/* auto-generated, do not modify */
#include "config.h"

#include "fu-ifd-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_ifd_region_to_string(FuIfdRegion val)
{
    if (val == FU_IFD_REGION_DESC)
        return "desc";
    if (val == FU_IFD_REGION_BIOS)
        return "bios";
    if (val == FU_IFD_REGION_ME)
        return "me";
    if (val == FU_IFD_REGION_GBE)
        return "gbe";
    if (val == FU_IFD_REGION_PLATFORM)
        return "platform";
    if (val == FU_IFD_REGION_DEVEXP)
        return "devexp";
    if (val == FU_IFD_REGION_BIOS2)
        return "bios2";
    if (val == FU_IFD_REGION_EC)
        return "ec";
    if (val == FU_IFD_REGION_IE)
        return "ie";
    if (val == FU_IFD_REGION_10GBE)
        return "10gbe";
    if (val == FU_IFD_REGION_MAX)
        return "max";
    return NULL;
}

gchar *
fu_ifd_access_to_string(FuIfdAccess val)
{
    const gchar *data[3] = {0};
    guint idx = 0;
    if (val == FU_IFD_ACCESS_NONE)
        return g_strdup("none");
    if (val & FU_IFD_ACCESS_READ)
        data[idx++] = "read";
    if (val & FU_IFD_ACCESS_WRITE)
        data[idx++] = "write";
    return g_strjoinv(",", (gchar **)data);
}
/* getters */
/**
 * fu_struct_ifd_fdbar_get_signature: (skip):
 **/
static guint32
fu_struct_ifd_fdbar_get_signature(const FuStructIfdFdbar *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_get_descriptor_map0: (skip):
 **/
guint32
fu_struct_ifd_fdbar_get_descriptor_map0(const FuStructIfdFdbar *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_get_descriptor_map1: (skip):
 **/
guint32
fu_struct_ifd_fdbar_get_descriptor_map1(const FuStructIfdFdbar *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_get_descriptor_map2: (skip):
 **/
guint32
fu_struct_ifd_fdbar_get_descriptor_map2(const FuStructIfdFdbar *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifd_fdbar_set_signature: (skip):
 **/
static void
fu_struct_ifd_fdbar_set_signature(FuStructIfdFdbar *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_set_descriptor_map0: (skip):
 **/
void
fu_struct_ifd_fdbar_set_descriptor_map0(FuStructIfdFdbar *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_set_descriptor_map1: (skip):
 **/
void
fu_struct_ifd_fdbar_set_descriptor_map1(FuStructIfdFdbar *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_set_descriptor_map2: (skip):
 **/
void
fu_struct_ifd_fdbar_set_descriptor_map2(FuStructIfdFdbar *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_new: (skip):
 **/
FuStructIfdFdbar *
fu_struct_ifd_fdbar_new(void)
{
    FuStructIfdFdbar *st = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st, 32, 0x0);
    memcpy(st->data + 0x0, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 16); /* nocheck:blocked */
    fu_struct_ifd_fdbar_set_signature(st, 0x0FF0A55A);
    return st;
}
/**
 * fu_struct_ifd_fdbar_to_string: (skip):
 **/
static gchar *
fu_struct_ifd_fdbar_to_string(const FuStructIfdFdbar *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfdFdbar:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  descriptor_map0: 0x%x\n",
                           (guint) fu_struct_ifd_fdbar_get_descriptor_map0(st));
    g_string_append_printf(str, "  descriptor_map1: 0x%x\n",
                           (guint) fu_struct_ifd_fdbar_get_descriptor_map1(st));
    g_string_append_printf(str, "  descriptor_map2: 0x%x\n",
                           (guint) fu_struct_ifd_fdbar_get_descriptor_map2(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifd_fdbar_validate_internal(FuStructIfdFdbar *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_ifd_fdbar_get_signature(st) != 0x0FF0A55A) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructIfdFdbar.signature was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0FF0A55A,
                    (guint) fu_struct_ifd_fdbar_get_signature(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ifd_fdbar_validate_stream: (skip):
 **/
gboolean
fu_struct_ifd_fdbar_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIfdFdbar failed read of 0x%x: ", (guint) 32);
        return FALSE;
    }
    if (st->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfdFdbar requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->len);
        return FALSE;
    }
    return fu_struct_ifd_fdbar_validate_internal(st, error);
}
static gboolean
fu_struct_ifd_fdbar_parse_internal(FuStructIfdFdbar *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifd_fdbar_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifd_fdbar_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifd_fdbar_parse_stream: (skip):
 **/
FuStructIfdFdbar *
fu_struct_ifd_fdbar_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIfdFdbar failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfdFdbar requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_ifd_fdbar_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_ifd_fcba_get_flcomp: (skip):
 **/
guint32
fu_struct_ifd_fcba_get_flcomp(const FuStructIfdFcba *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_get_flill: (skip):
 **/
guint32
fu_struct_ifd_fcba_get_flill(const FuStructIfdFcba *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_get_flill1: (skip):
 **/
guint32
fu_struct_ifd_fcba_get_flill1(const FuStructIfdFcba *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifd_fcba_set_flcomp: (skip):
 **/
void
fu_struct_ifd_fcba_set_flcomp(FuStructIfdFcba *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_set_flill: (skip):
 **/
void
fu_struct_ifd_fcba_set_flill(FuStructIfdFcba *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_set_flill1: (skip):
 **/
void
fu_struct_ifd_fcba_set_flill1(FuStructIfdFcba *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_new: (skip):
 **/
FuStructIfdFcba *
fu_struct_ifd_fcba_new(void)
{
    FuStructIfdFcba *st = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st, 12, 0x0);
    return st;
}
/**
 * fu_struct_ifd_fcba_to_string: (skip):
 **/
static gchar *
fu_struct_ifd_fcba_to_string(const FuStructIfdFcba *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfdFcba:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  flcomp: 0x%x\n",
                           (guint) fu_struct_ifd_fcba_get_flcomp(st));
    g_string_append_printf(str, "  flill: 0x%x\n",
                           (guint) fu_struct_ifd_fcba_get_flill(st));
    g_string_append_printf(str, "  flill1: 0x%x\n",
                           (guint) fu_struct_ifd_fcba_get_flill1(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifd_fcba_validate_internal(FuStructIfdFcba *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ifd_fcba_parse_internal(FuStructIfdFcba *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifd_fcba_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifd_fcba_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifd_fcba_parse_stream: (skip):
 **/
FuStructIfdFcba *
fu_struct_ifd_fcba_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 12, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIfdFcba failed read of 0x%x: ", (guint) 12);
        return NULL;
    }
    if (st->len != 12) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfdFcba requested 0x%x and got 0x%x",
                    (guint) 12,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_ifd_fcba_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
