/* WindowSwitcher.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowSwitcher.vala, do not modify */

/*
 * Copyright 2021 Aral Balkan <mail@ar.al>
 * Copyright 2020 Mark Story <mark@mark-story.com>
 * Copyright 2017 Popye <sailor3101@gmail.com>
 * Copyright 2014 Tom Beckmann
 * Copyright 2023-2025 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <cairo-gobject.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <mtk/mtk.h>
#include <stdlib.h>
#include <string.h>
#include <meta/window.h>
#include <meta/keybindings.h>
#include <meta/workspace.h>
#include <meta/meta-workspace-manager.h>
#include <atk/atk.h>
#include <meta/prefs.h>
#include <meta/meta-cursor-tracker.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#define GALA_WINDOW_SWITCHER_WRAPPER_PADDING 12
#define GALA_WINDOW_SWITCHER_MIN_OFFSET 64
#define GALA_WINDOW_SWITCHER_GESTURE_STEP 0.1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_SWITCHER (gala_window_switcher_get_type ())
#define GALA_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher))
#define GALA_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))
#define GALA_IS_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_IS_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_WINDOW_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))

typedef struct _GalaWindowSwitcher GalaWindowSwitcher;
typedef struct _GalaWindowSwitcherClass GalaWindowSwitcherClass;
typedef struct _GalaWindowSwitcherPrivate GalaWindowSwitcherPrivate;

#define GALA_TYPE_BACKGROUND_BLUR_EFFECT (gala_background_blur_effect_get_type ())
#define GALA_BACKGROUND_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_BLUR_EFFECT, GalaBackgroundBlurEffect))
#define GALA_BACKGROUND_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_BLUR_EFFECT, GalaBackgroundBlurEffectClass))
#define GALA_IS_BACKGROUND_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_BLUR_EFFECT))
#define GALA_IS_BACKGROUND_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_BLUR_EFFECT))
#define GALA_BACKGROUND_BLUR_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_BLUR_EFFECT, GalaBackgroundBlurEffectClass))

typedef struct _GalaBackgroundBlurEffect GalaBackgroundBlurEffect;
typedef struct _GalaBackgroundBlurEffectClass GalaBackgroundBlurEffectClass;

#define GALA_TYPE_WINDOW_SWITCHER_ICON (gala_window_switcher_icon_get_type ())
#define GALA_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon))
#define GALA_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))
#define GALA_IS_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_IS_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_WINDOW_SWITCHER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))

typedef struct _GalaWindowSwitcherIcon GalaWindowSwitcherIcon;
typedef struct _GalaWindowSwitcherIconClass GalaWindowSwitcherIconClass;
enum  {
	GALA_WINDOW_SWITCHER_0_PROPERTY,
	GALA_WINDOW_SWITCHER_ACTOR_PROPERTY,
	GALA_WINDOW_SWITCHER_WM_PROPERTY,
	GALA_WINDOW_SWITCHER_OPENED_PROPERTY,
	GALA_WINDOW_SWITCHER_MONITOR_SCALE_PROPERTY,
	GALA_WINDOW_SWITCHER_NUM_PROPERTIES
};
static GParamSpec* gala_window_switcher_properties[GALA_WINDOW_SWITCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))

#define GALA_TYPE_WINDOW_TRACKER (gala_window_tracker_get_type ())
#define GALA_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTracker))
#define GALA_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))
#define GALA_IS_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_TRACKER))
#define GALA_IS_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_TRACKER))
#define GALA_WINDOW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))

typedef struct _GalaWindowTracker GalaWindowTracker;
typedef struct _GalaWindowTrackerClass GalaWindowTrackerClass;

#define GALA_TYPE_WINDOW_MANAGER_GALA (gala_window_manager_gala_get_type ())
#define GALA_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala))
#define GALA_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))
#define GALA_IS_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_IS_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_WINDOW_MANAGER_GALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))

typedef struct _GalaWindowManagerGala GalaWindowManagerGala;
typedef struct _GalaWindowManagerGalaClass GalaWindowManagerGalaClass;

struct _GalaWindowSwitcher {
	GalaCanvasActor parent_instance;
	GalaWindowSwitcherPrivate * priv;
};

struct _GalaWindowSwitcherClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaWindowSwitcherPrivate {
	GalaWindowManager* _wm;
	gboolean _opened;
	gfloat _monitor_scale;
	GalaGestureController* gesture_controller;
	gint modifier_mask;
	GalaModalProxy* modal_proxy;
	GalaDrawingStyleManager* style_manager;
	ClutterActor* container;
	GalaText* caption;
	GalaShadowEffect* shadow_effect;
	GalaBackgroundBlurEffect* blur_effect;
	GalaWindowSwitcherIcon* _current_icon;
	gdouble previous_progress;
};

static gint GalaWindowSwitcher_private_offset;
static gpointer gala_window_switcher_parent_class = NULL;
static GalaGestureTargetIface * gala_window_switcher_gala_gesture_target_parent_iface = NULL;
static GalaRootTargetIface * gala_window_switcher_gala_root_target_parent_iface = NULL;

VALA_EXTERN GType gala_window_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcher, g_object_unref)
VALA_EXTERN GType gala_background_blur_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundBlurEffect, g_object_unref)
VALA_EXTERN GType gala_window_switcher_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcherIcon, g_object_unref)
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_new (GalaWindowManager* wm);
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_construct (GType object_type,
                                                    GalaWindowManager* wm);
static void gala_window_switcher_scale (GalaWindowSwitcher* self);
VALA_EXTERN gfloat gala_window_switcher_get_monitor_scale (GalaWindowSwitcher* self);
static void gala_window_switcher_real_get_preferred_width (ClutterActor* base,
                                                    gfloat for_height,
                                                    gfloat* min_width,
                                                    gfloat* natural_width);
VALA_EXTERN GalaWindowManager* gala_window_switcher_get_wm (GalaWindowSwitcher* self);
static void gala_window_switcher_real_draw (GalaCanvasActor* base,
                                     cairo_t* ctx,
                                     gint width,
                                     gint height);
static void _vala_ClutterColor_free (ClutterColor* self);
static void gala_window_switcher_real_propagate (GalaGestureTarget* base,
                                          GalaGestureTargetUpdateType update_type,
                                          GalaGestureAction action,
                                          gdouble progress);
static GalaWindowSwitcherIcon* gala_window_switcher_get_current_icon (GalaWindowSwitcher* self);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
static void gala_window_switcher_set_current_icon (GalaWindowSwitcher* self,
                                            GalaWindowSwitcherIcon* value);
static void gala_window_switcher_select_icon (GalaWindowSwitcher* self,
                                       GalaWindowSwitcherIcon* icon);
VALA_EXTERN void gala_window_switcher_handle_switch_windows (GalaWindowSwitcher* self,
                                                 MetaDisplay* display,
                                                 MetaWindow* window,
                                                 ClutterKeyEvent* event,
                                                 MetaKeyBinding* binding);
VALA_EXTERN gboolean gala_window_switcher_get_opened (GalaWindowSwitcher* self);
static gboolean gala_window_switcher_collect_current_windows (GalaWindowSwitcher* self,
                                                       MetaDisplay* display,
                                                       MetaWorkspace* workspace);
static gboolean gala_window_switcher_collect_all_windows (GalaWindowSwitcher* self,
                                                   MetaDisplay* display,
                                                   MetaWorkspace* workspace);
static void gala_window_switcher_open_switcher (GalaWindowSwitcher* self);
static void gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                       gboolean backward);
static void gala_window_switcher_recognizing_changed (GalaWindowSwitcher* self);
static void gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                          guint32 time,
                                          gboolean cancel);
static void gala_window_switcher_set_monitor_scale (GalaWindowSwitcher* self,
                                             gfloat value);
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_new (MetaWindow* window,
                                                       gfloat monitor_scale);
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_construct (GType object_type,
                                                             MetaWindow* window,
                                                             gfloat monitor_scale);
static void gala_window_switcher_add_icon (GalaWindowSwitcher* self,
                                    GalaWindowSwitcherIcon* icon);
VALA_EXTERN GType gala_window_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowTracker, g_object_unref)
VALA_EXTERN GType gala_window_manager_gala_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowManagerGala, g_object_unref)
VALA_EXTERN GalaWindowTracker* gala_window_manager_gala_get_window_tracker (GalaWindowManagerGala* self);
VALA_EXTERN GalaApp* gala_window_tracker_get_app_for_window (GalaWindowTracker* self,
                                                 MetaWindow* window);
static gboolean __lambda88_ (GalaWindowSwitcher* self,
                      ClutterActor* _icon,
                      ClutterEvent* event);
static gboolean ___lambda88__clutter_actor_motion_event (ClutterActor* _sender,
                                                  ClutterEvent* event,
                                                  gpointer self);
static void gala_window_switcher_toggle_display (GalaWindowSwitcher* self,
                                          gboolean show);
static void gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                      gboolean value);
static void gala_window_switcher_push_modal (GalaWindowSwitcher* self);
static gboolean __lambda89_ (GalaWindowSwitcher* self,
                      MetaKeyBinding* binding);
static gboolean ___lambda89__gala_keybinding_filter (MetaKeyBinding* binding,
                                              gpointer self);
VALA_EXTERN MetaWindow* gala_window_switcher_icon_get_window (GalaWindowSwitcherIcon* self);
static void gala_window_switcher_real_key_focus_out (ClutterActor* base);
static gboolean gala_window_switcher_container_mouse_release (GalaWindowSwitcher* self,
                                                       ClutterEvent* event);
static gboolean gala_window_switcher_real_key_release_event (ClutterActor* base,
                                                      ClutterEvent* event);
static inline ClutterModifierType gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self);
static gboolean gala_window_switcher_real_key_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static void gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                                  GalaWindowManager* value);
VALA_EXTERN void gala_window_switcher_icon_set_selected (GalaWindowSwitcherIcon* self,
                                             gboolean value);
static GObject * gala_window_switcher_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _gala_window_switcher_recognizing_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _gala_window_switcher_scale_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
VALA_EXTERN GalaBackgroundBlurEffect* gala_background_blur_effect_new (gfloat blur_radius,
                                                           gfloat clip_radius,
                                                           gfloat monitor_scale);
VALA_EXTERN GalaBackgroundBlurEffect* gala_background_blur_effect_construct (GType object_type,
                                                                 gfloat blur_radius,
                                                                 gfloat clip_radius,
                                                                 gfloat monitor_scale);
static gboolean _gala_window_switcher_container_mouse_release_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                           ClutterEvent* event,
                                                                                           gpointer self);
static void _clutter_content_invalidate_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void _gala_window_switcher___lambda90_ (GalaWindowSwitcher* self);
static void __gala_window_switcher___lambda90__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void gala_window_switcher_finalize (GObject * obj);
static GType gala_window_switcher_get_type_once (void);
static void _vala_gala_window_switcher_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_switcher_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gala_window_switcher_get_instance_private (GalaWindowSwitcher* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowSwitcher_private_offset);
}

GalaWindowSwitcher*
gala_window_switcher_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaWindowSwitcher * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowSwitcher*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaWindowSwitcher*
gala_window_switcher_new (GalaWindowManager* wm)
{
	return gala_window_switcher_construct (GALA_TYPE_WINDOW_SWITCHER, wm);
}

static void
gala_window_switcher_scale (GalaWindowSwitcher* self)
{
	gint margin = 0;
	gfloat _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	GalaText* _tmp5_;
	GalaText* _tmp6_;
	GalaText* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitor_scale;
	margin = gala_utils_scale_to_int (GALA_WINDOW_SWITCHER_WRAPPER_PADDING, _tmp0_);
	_tmp1_ = self->priv->container;
	clutter_actor_set_margin_left (_tmp1_, (gfloat) margin);
	_tmp2_ = self->priv->container;
	clutter_actor_set_margin_right (_tmp2_, (gfloat) margin);
	_tmp3_ = self->priv->container;
	clutter_actor_set_margin_bottom (_tmp3_, (gfloat) margin);
	_tmp4_ = self->priv->container;
	clutter_actor_set_margin_top (_tmp4_, (gfloat) margin);
	_tmp5_ = self->priv->caption;
	clutter_actor_set_margin_left ((ClutterActor*) _tmp5_, (gfloat) margin);
	_tmp6_ = self->priv->caption;
	clutter_actor_set_margin_right ((ClutterActor*) _tmp6_, (gfloat) margin);
	_tmp7_ = self->priv->caption;
	clutter_actor_set_margin_bottom ((ClutterActor*) _tmp7_, (gfloat) margin);
}

static void
gala_window_switcher_real_get_preferred_width (ClutterActor* base,
                                               gfloat for_height,
                                               gfloat* min_width,
                                               gfloat* natural_width)
{
	GalaWindowSwitcher * self;
	gfloat _vala_min_width = 0.0F;
	gfloat _vala_natural_width = 0.0F;
	gfloat preferred_nat_width = 0.0F;
	gfloat _tmp0_ = 0.0F;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	MtkRectangle geom = {0};
	MtkRectangle _tmp3_ = {0};
	gfloat container_nat_width = 0.0F;
	ClutterActor* _tmp4_;
	gfloat _tmp5_ = 0.0F;
	gfloat max_width = 0.0F;
	MtkRectangle _tmp6_;
	gfloat _tmp7_;
	self = (GalaWindowSwitcher*) base;
	_vala_min_width = (gfloat) 0;
	CLUTTER_ACTOR_CLASS (gala_window_switcher_parent_class)->get_preferred_width ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), for_height, NULL, &_tmp0_);
	preferred_nat_width = _tmp0_;
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	display = _tmp2_;
	meta_display_get_monitor_geometry (display, meta_display_get_current_monitor (display), &_tmp3_);
	geom = _tmp3_;
	_tmp4_ = self->priv->container;
	clutter_actor_get_preferred_size (_tmp4_, NULL, NULL, &_tmp5_, NULL);
	container_nat_width = _tmp5_;
	_tmp6_ = geom;
	_tmp7_ = self->priv->_monitor_scale;
	max_width = MIN ((gfloat) (_tmp6_.width - gala_utils_scale_to_int (GALA_WINDOW_SWITCHER_MIN_OFFSET * 2, _tmp7_)), container_nat_width);
	_vala_natural_width = MIN (max_width, preferred_nat_width);
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static void
gala_window_switcher_real_draw (GalaCanvasActor* base,
                                cairo_t* ctx,
                                gint width,
                                gint height)
{
	GalaWindowSwitcher * self;
	ClutterColor background_color = {0};
	ClutterColor border_color = {0};
	gchar* caption_color = NULL;
	gchar* _tmp0_;
	ClutterColor highlight_color = {0};
	GalaDrawingStyleManager* _tmp1_;
	GalaDrawingStyleManagerColorScheme _tmp2_;
	GalaDrawingStyleManagerColorScheme _tmp3_;
	GalaText* _tmp5_;
	const gchar* _tmp6_;
	ClutterColor* _tmp7_;
	ClutterColor* _tmp8_;
	ClutterColor _tmp9_;
	gint stroke_width = 0;
	gfloat _tmp10_;
	gfloat _tmp11_;
	ClutterColor _tmp12_;
	ClutterColor _tmp13_;
	ClutterColor _tmp14_;
	ClutterColor _tmp15_;
	ClutterColor _tmp16_;
	ClutterColor _tmp17_;
	ClutterColor _tmp18_;
	gfloat _tmp19_;
	ClutterColor _tmp20_;
	ClutterColor _tmp21_;
	ClutterColor _tmp22_;
	self = (GalaWindowSwitcher*) base;
	g_return_if_fail (ctx != NULL);
	background_color = GALA_DRAWING_COLOR_LIGHT_BACKGROUND;
	border_color = GALA_DRAWING_COLOR_LIGHT_BORDER;
	_tmp0_ = g_strdup ("#2e2e31");
	caption_color = _tmp0_;
	highlight_color = GALA_DRAWING_COLOR_LIGHT_HIGHLIGHT;
	_tmp1_ = self->priv->style_manager;
	_tmp2_ = gala_drawing_style_manager_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK) {
		gchar* _tmp4_;
		background_color = GALA_DRAWING_COLOR_DARK_BACKGROUND;
		border_color = GALA_DRAWING_COLOR_DARK_BORDER;
		_tmp4_ = g_strdup ("#fafafa");
		_g_free0 (caption_color);
		caption_color = _tmp4_;
		highlight_color = GALA_DRAWING_COLOR_DARK_HIGHLIGHT;
	}
	_tmp5_ = self->priv->caption;
	_tmp6_ = caption_color;
	_tmp7_ = _vala_clutter_color_from_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = *_tmp8_;
	clutter_text_set_color ((ClutterText*) _tmp5_, &_tmp9_);
	__vala_ClutterColor_free0 (_tmp8_);
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_clip (ctx);
	cairo_reset_clip (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	_tmp10_ = self->priv->_monitor_scale;
	stroke_width = gala_utils_scale_to_int (1, _tmp10_);
	_tmp11_ = self->priv->_monitor_scale;
	gala_drawing_utilities_cairo_rounded_rectangle (ctx, stroke_width / 2.0, stroke_width / 2.0, (gdouble) (width - stroke_width), (gdouble) (height - stroke_width), (gdouble) gala_utils_scale_to_int (9, _tmp11_));
	_tmp12_ = background_color;
	_tmp13_ = background_color;
	_tmp14_ = background_color;
	cairo_set_source_rgba (ctx, _tmp12_.red / 255.0, _tmp13_.green / 255.0, _tmp14_.blue / 255.0, 0.6);
	cairo_fill_preserve (ctx);
	cairo_set_line_width (ctx, (gdouble) stroke_width);
	_tmp15_ = border_color;
	_tmp16_ = border_color;
	_tmp17_ = border_color;
	_tmp18_ = border_color;
	cairo_set_source_rgba (ctx, _tmp15_.red / 255.0, _tmp16_.green / 255.0, _tmp17_.blue / 255.0, _tmp18_.alpha / 255.0);
	cairo_stroke (ctx);
	cairo_restore (ctx);
	_tmp19_ = self->priv->_monitor_scale;
	gala_drawing_utilities_cairo_rounded_rectangle (ctx, stroke_width * 1.5, stroke_width * 1.5, (gdouble) (width - (stroke_width * 3)), (gdouble) (height - (stroke_width * 3)), (gdouble) gala_utils_scale_to_int (8, _tmp19_));
	cairo_set_line_width (ctx, (gdouble) stroke_width);
	_tmp20_ = highlight_color;
	_tmp21_ = highlight_color;
	_tmp22_ = highlight_color;
	cairo_set_source_rgba (ctx, _tmp20_.red / 255.0, _tmp21_.green / 255.0, _tmp22_.blue / 255.0, 0.3);
	cairo_stroke (ctx);
	cairo_restore (ctx);
	_g_free0 (caption_color);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_window_switcher_real_propagate (GalaGestureTarget* base,
                                     GalaGestureTargetUpdateType update_type,
                                     GalaGestureAction action,
                                     gdouble progress)
{
	GalaWindowSwitcher * self;
	gboolean _tmp0_ = FALSE;
	gboolean is_step = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ClutterActor* _tmp4_;
	gint current_index = 0;
	ClutterActor* _tmp9_;
	GalaWindowSwitcherIcon* new_icon = NULL;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	GalaWindowSwitcherIcon* _tmp13_;
	GalaWindowSwitcherIcon* _tmp14_;
	GalaWindowSwitcherIcon* _tmp15_;
	GalaWindowSwitcherIcon* _tmp16_;
	self = (GalaWindowSwitcher*) base;
	if (update_type != GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE) {
		_tmp0_ = TRUE;
	} else {
		ClutterActor* _tmp1_;
		_tmp1_ = self->priv->container;
		_tmp0_ = clutter_actor_get_n_children (_tmp1_) == 0;
	}
	if (_tmp0_) {
		return;
	}
	is_step = abs (((gint) (self->priv->previous_progress / GALA_WINDOW_SWITCHER_GESTURE_STEP)) - ((gint) (progress / GALA_WINDOW_SWITCHER_GESTURE_STEP))) >= 1;
	self->priv->previous_progress = progress;
	_tmp4_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp4_) == 1) {
		GalaWindowSwitcherIcon* _tmp5_;
		GalaWindowSwitcherIcon* _tmp6_;
		_tmp5_ = gala_window_switcher_get_current_icon (self);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = is_step;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GalaWindowManager* _tmp7_;
		MetaDisplay* _tmp8_;
		_tmp7_ = self->priv->_wm;
		_tmp8_ = meta_plugin_get_display ((MetaPlugin*) _tmp7_);
		gala_internal_utils_bell_notify (_tmp8_);
		return;
	}
	_tmp9_ = self->priv->container;
	current_index = ((gint) (progress / GALA_WINDOW_SWITCHER_GESTURE_STEP)) % clutter_actor_get_n_children (_tmp9_);
	if (current_index < 0) {
		ClutterActor* _tmp10_;
		_tmp10_ = self->priv->container;
		current_index = clutter_actor_get_n_children (_tmp10_) + current_index;
	}
	_tmp11_ = self->priv->container;
	_tmp12_ = clutter_actor_get_child_at_index (_tmp11_, current_index);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon));
	new_icon = _tmp13_;
	_tmp14_ = new_icon;
	_tmp15_ = gala_window_switcher_get_current_icon (self);
	_tmp16_ = _tmp15_;
	if (_tmp14_ != _tmp16_) {
		GalaWindowSwitcherIcon* _tmp17_;
		_tmp17_ = new_icon;
		gala_window_switcher_set_current_icon (self, _tmp17_);
	}
	_g_object_unref0 (new_icon);
}

static void
gala_window_switcher_select_icon (GalaWindowSwitcher* self,
                                  GalaWindowSwitcherIcon* icon)
{
	gint index = 0;
	g_return_if_fail (self != NULL);
	if (icon == NULL) {
		GalaGestureController* _tmp0_;
		_tmp0_ = self->priv->gesture_controller;
		gala_gesture_controller_set_progress (_tmp0_, (gdouble) 0);
		gala_window_switcher_set_current_icon (self, NULL);
		return;
	}
	index = 0;
	{
		ClutterActor* child = NULL;
		ClutterActor* _tmp1_;
		ClutterActor* _tmp2_;
		ClutterActor* _tmp3_;
		_tmp1_ = self->priv->container;
		_tmp2_ = clutter_actor_get_first_child (_tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		child = _tmp3_;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ClutterActor* _tmp8_;
				ClutterActor* _tmp9_;
				gint _tmp11_;
				if (!_tmp4_) {
					ClutterActor* _tmp5_;
					ClutterActor* _tmp6_;
					ClutterActor* _tmp7_;
					_tmp5_ = child;
					_tmp6_ = clutter_actor_get_next_sibling (_tmp5_);
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_g_object_unref0 (child);
					child = _tmp7_;
				}
				_tmp4_ = FALSE;
				_tmp8_ = child;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = child;
				if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (icon, clutter_actor_get_type (), ClutterActor)) {
					GalaGestureController* _tmp10_;
					_tmp10_ = self->priv->gesture_controller;
					gala_gesture_controller_set_progress (_tmp10_, index * GALA_WINDOW_SWITCHER_GESTURE_STEP);
					break;
				}
				_tmp11_ = index;
				index = _tmp11_ + 1;
			}
		}
		_g_object_unref0 (child);
	}
}

void
gala_window_switcher_handle_switch_windows (GalaWindowSwitcher* self,
                                            MetaDisplay* display,
                                            MetaWindow* window,
                                            ClutterKeyEvent* event,
                                            MetaKeyBinding* binding)
{
	GalaGestureController* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	guint mask = 0U;
	gboolean _tmp6_;
	gchar* binding_name = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean backward = FALSE;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = self->priv->gesture_controller;
	_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = meta_display_get_workspace_manager (display);
	_tmp4_ = meta_workspace_manager_get_active_workspace (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	workspace = _tmp5_;
	mask = meta_key_binding_get_mask (binding);
	if (mask == ((guint) 0)) {
		self->priv->modifier_mask = 0;
	} else {
		self->priv->modifier_mask = 1;
		while (TRUE) {
			if (!(mask > ((guint) 1))) {
				break;
			}
			mask >>= (guint) 1;
			self->priv->modifier_mask = self->priv->modifier_mask << 1;
		}
	}
	_tmp6_ = self->priv->_opened;
	if (!_tmp6_) {
		gboolean windows_exist = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = meta_key_binding_get_name (binding);
		if (g_str_has_prefix (_tmp7_, "switch-group")) {
			MetaWorkspace* _tmp8_;
			_tmp8_ = workspace;
			windows_exist = gala_window_switcher_collect_current_windows (self, display, _tmp8_);
		} else {
			MetaWorkspace* _tmp9_;
			_tmp9_ = workspace;
			windows_exist = gala_window_switcher_collect_all_windows (self, display, _tmp9_);
		}
		if (!windows_exist) {
			_g_object_unref0 (workspace);
			return;
		}
		gala_window_switcher_open_switcher (self);
	}
	_tmp10_ = meta_key_binding_get_name (binding);
	_tmp11_ = g_strdup (_tmp10_);
	binding_name = _tmp11_;
	_tmp12_ = binding_name;
	backward = g_str_has_suffix (_tmp12_, "-backward");
	gala_window_switcher_next_window (self, backward);
	_g_free0 (binding_name);
	_g_object_unref0 (workspace);
}

static void
gala_window_switcher_recognizing_changed (GalaWindowSwitcher* self)
{
	GalaGestureController* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gesture_controller;
	_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		MetaDisplay* display = NULL;
		GalaWindowManager* _tmp3_;
		MetaDisplay* _tmp4_;
		MetaWorkspaceManager* workspace_manager = NULL;
		MetaDisplay* _tmp5_;
		MetaWorkspaceManager* _tmp6_;
		MetaWorkspace* active_workspace = NULL;
		MetaWorkspaceManager* _tmp7_;
		MetaWorkspace* _tmp8_;
		gboolean windows_exist = FALSE;
		MetaDisplay* _tmp9_;
		MetaWorkspace* _tmp10_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
		display = _tmp4_;
		_tmp5_ = display;
		_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
		workspace_manager = _tmp6_;
		_tmp7_ = workspace_manager;
		_tmp8_ = meta_workspace_manager_get_active_workspace (_tmp7_);
		active_workspace = _tmp8_;
		_tmp9_ = display;
		_tmp10_ = active_workspace;
		windows_exist = gala_window_switcher_collect_all_windows (self, _tmp9_, _tmp10_);
		if (!windows_exist) {
			return;
		}
		gala_window_switcher_open_switcher (self);
	} else {
		GalaWindowManager* _tmp11_;
		MetaDisplay* _tmp12_;
		_tmp11_ = self->priv->_wm;
		_tmp12_ = meta_plugin_get_display ((MetaPlugin*) _tmp11_);
		gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp12_), FALSE);
	}
}

static gboolean
gala_window_switcher_collect_all_windows (GalaWindowSwitcher* self,
                                          MetaDisplay* display,
                                          MetaWorkspace* workspace)
{
	ClutterActor* _tmp0_;
	GList* windows = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp3_;
	GList* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = self->priv->container;
	clutter_actor_remove_all_children (_tmp0_);
	gala_window_switcher_select_icon (self, NULL);
	gala_window_switcher_set_monitor_scale (self, meta_display_get_monitor_scale (display, meta_display_get_current_monitor (display)));
	_tmp1_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
	windows = _tmp1_;
	_tmp2_ = windows;
	if (_tmp2_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp3_ = meta_display_get_tab_current (display, META_TAB_LIST_NORMAL, workspace);
	current_window = _tmp3_;
	_tmp4_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp4_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GalaWindowSwitcherIcon* icon = NULL;
				MetaWindow* _tmp5_;
				gfloat _tmp6_;
				GalaWindowSwitcherIcon* _tmp7_;
				GalaWindowSwitcherIcon* _tmp8_;
				GalaWindowSwitcherIcon* _tmp9_;
				MetaWindow* _tmp10_;
				MetaWindow* _tmp11_;
				_tmp5_ = window;
				_tmp6_ = self->priv->_monitor_scale;
				_tmp7_ = gala_window_switcher_icon_new (_tmp5_, _tmp6_);
				g_object_ref_sink (_tmp7_);
				icon = _tmp7_;
				_tmp8_ = icon;
				g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp8_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				_tmp9_ = icon;
				gala_window_switcher_add_icon (self, _tmp9_);
				_tmp10_ = window;
				_tmp11_ = current_window;
				if (_tmp10_ == _tmp11_) {
					GalaWindowSwitcherIcon* _tmp12_;
					_tmp12_ = icon;
					gala_window_switcher_select_icon (self, _tmp12_);
				}
				_g_object_unref0 (icon);
			}
		}
	}
	result = TRUE;
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static gboolean
gala_window_switcher_collect_current_windows (GalaWindowSwitcher* self,
                                              MetaDisplay* display,
                                              MetaWorkspace* workspace)
{
	ClutterActor* _tmp0_;
	GList* windows = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	GalaWindowTracker* window_tracker = NULL;
	GalaWindowManager* _tmp5_;
	GalaWindowTracker* _tmp6_;
	GalaWindowTracker* _tmp7_;
	GalaApp* app = NULL;
	GalaWindowTracker* _tmp8_;
	MetaWindow* _tmp9_;
	GalaApp* _tmp10_;
	GList* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = self->priv->container;
	clutter_actor_remove_all_children (_tmp0_);
	gala_window_switcher_select_icon (self, NULL);
	gala_window_switcher_set_monitor_scale (self, meta_display_get_monitor_scale (display, meta_display_get_current_monitor (display)));
	_tmp1_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
	windows = _tmp1_;
	_tmp2_ = windows;
	if (_tmp2_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp3_ = meta_display_get_tab_current (display, META_TAB_LIST_NORMAL, workspace);
	current_window = _tmp3_;
	_tmp4_ = current_window;
	if (_tmp4_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp5_ = self->priv->_wm;
	_tmp6_ = gala_window_manager_gala_get_window_tracker (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala));
	_tmp7_ = _tmp6_;
	window_tracker = _tmp7_;
	_tmp8_ = window_tracker;
	_tmp9_ = current_window;
	_tmp10_ = gala_window_tracker_get_app_for_window (_tmp8_, _tmp9_);
	app = _tmp10_;
	_tmp11_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp11_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GalaWindowTracker* _tmp12_;
				MetaWindow* _tmp13_;
				GalaApp* _tmp14_;
				GalaApp* _tmp15_;
				GalaApp* _tmp16_;
				gboolean _tmp17_;
				_tmp12_ = window_tracker;
				_tmp13_ = window;
				_tmp14_ = gala_window_tracker_get_app_for_window (_tmp12_, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = app;
				_tmp17_ = _tmp15_ == _tmp16_;
				_g_object_unref0 (_tmp15_);
				if (_tmp17_) {
					GalaWindowSwitcherIcon* icon = NULL;
					MetaWindow* _tmp18_;
					gfloat _tmp19_;
					GalaWindowSwitcherIcon* _tmp20_;
					GalaWindowSwitcherIcon* _tmp21_;
					GalaWindowSwitcherIcon* _tmp22_;
					MetaWindow* _tmp23_;
					MetaWindow* _tmp24_;
					_tmp18_ = window;
					_tmp19_ = self->priv->_monitor_scale;
					_tmp20_ = gala_window_switcher_icon_new (_tmp18_, _tmp19_);
					g_object_ref_sink (_tmp20_);
					icon = _tmp20_;
					_tmp21_ = icon;
					g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp21_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
					_tmp22_ = icon;
					gala_window_switcher_add_icon (self, _tmp22_);
					_tmp23_ = window;
					_tmp24_ = current_window;
					if (_tmp23_ == _tmp24_) {
						GalaWindowSwitcherIcon* _tmp25_;
						_tmp25_ = icon;
						gala_window_switcher_select_icon (self, _tmp25_);
					}
					_g_object_unref0 (icon);
				}
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (app);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static gboolean
__lambda88_ (GalaWindowSwitcher* self,
             ClutterActor* _icon,
             ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	gboolean result;
	g_return_val_if_fail (_icon != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, clutter_actor_get_type (), ClutterActor) != _icon) {
		GalaGestureController* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->gesture_controller;
		_tmp4_ = gala_gesture_controller_get_recognizing (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_select_icon (self, G_TYPE_CHECK_INSTANCE_CAST (_icon, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon));
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda88__clutter_actor_motion_event (ClutterActor* _sender,
                                         ClutterEvent* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda88_ ((GalaWindowSwitcher*) self, _sender, event);
	return result;
}

static void
gala_window_switcher_add_icon (GalaWindowSwitcher* self,
                               GalaWindowSwitcherIcon* icon)
{
	ClutterActor* _tmp0_;
	AtkObject* _tmp1_;
	ClutterActor* _tmp2_;
	AtkObject* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	_tmp0_ = self->priv->container;
	clutter_actor_add_child (_tmp0_, (ClutterActor*) icon);
	_tmp1_ = clutter_actor_get_accessible ((ClutterActor*) icon);
	_tmp2_ = self->priv->container;
	_tmp3_ = clutter_actor_get_accessible (_tmp2_);
	g_object_set (_tmp1_, "accessible-parent", _tmp3_, NULL);
	g_signal_connect_object ((ClutterActor*) icon, "motion-event", (GCallback) ___lambda88__clutter_actor_motion_event, self, 0);
}

static void
gala_window_switcher_open_switcher (GalaWindowSwitcher* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	ClutterActor* _tmp2_;
	gboolean _tmp4_;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	MtkRectangle geom = {0};
	MetaDisplay* _tmp7_;
	MetaDisplay* _tmp8_;
	MtkRectangle _tmp9_ = {0};
	MtkRectangle _tmp10_;
	MtkRectangle _tmp11_;
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp2_) == 0) {
		MetaDisplay* _tmp3_;
		_tmp3_ = display;
		gala_internal_utils_bell_notify (_tmp3_);
		return;
	}
	_tmp4_ = self->priv->_opened;
	if (_tmp4_) {
		return;
	}
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	clutter_actor_get_preferred_size ((ClutterActor*) self, NULL, NULL, &_tmp5_, &_tmp6_);
	width = _tmp5_;
	height = _tmp6_;
	_tmp7_ = display;
	_tmp8_ = display;
	meta_display_get_monitor_geometry (_tmp7_, meta_display_get_current_monitor (_tmp8_), &_tmp9_);
	geom = _tmp9_;
	_tmp10_ = geom;
	_tmp11_ = geom;
	_tmp12_ = geom;
	_tmp13_ = geom;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) ((gint) (_tmp10_.x + ((_tmp11_.width - width) / 2))), (gfloat) ((gint) (_tmp12_.y + ((_tmp13_.height - height) / 2))));
	gala_window_switcher_toggle_display (self, TRUE);
}

static void
gala_window_switcher_toggle_display (GalaWindowSwitcher* self,
                                     gboolean show)
{
	gboolean _tmp0_;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opened;
	if (_tmp0_ == show) {
		return;
	}
	gala_window_switcher_set_opened (self, show);
	if (show) {
		gala_window_switcher_push_modal (self);
	} else {
		GalaWindowManager* _tmp1_;
		GalaModalProxy* _tmp2_;
		ClutterStage* _tmp3_;
		_tmp1_ = self->priv->_wm;
		_tmp2_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp1_, _tmp2_);
		_tmp3_ = (ClutterStage*) clutter_actor_get_stage ((ClutterActor*) self);
		clutter_stage_set_key_focus (_tmp3_, NULL);
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, gala_utils_get_animation_duration ((guint) GALA_ANIMATION_DURATION_HIDE));
	if (show) {
		_tmp4_ = 255;
	} else {
		_tmp4_ = 0;
	}
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) _tmp4_);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}

static gboolean
__lambda89_ (GalaWindowSwitcher* self,
             MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	switch (action) {
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda89__gala_keybinding_filter (MetaKeyBinding* binding,
                                     gpointer self)
{
	gboolean result;
	result = __lambda89_ ((GalaWindowSwitcher*) self, binding);
	return result;
}

static void
gala_window_switcher_push_modal (GalaWindowSwitcher* self)
{
	GalaWindowManager* _tmp0_;
	ClutterStage* _tmp1_;
	GalaModalProxy* _tmp2_;
	GalaModalProxy* _tmp3_;
	GalaGestureAction* _tmp4_;
	GalaGestureAction* _tmp5_;
	gint _tmp5__length1;
	GalaModalProxy* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = (ClutterStage*) clutter_actor_get_stage ((ClutterActor*) self);
	_tmp2_ = gala_window_manager_push_modal (_tmp0_, (ClutterActor*) _tmp1_, TRUE);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp2_;
	_tmp3_ = self->priv->modal_proxy;
	_tmp4_ = g_new0 (GalaGestureAction, 1);
	_tmp4_[0] = GALA_GESTURE_ACTION_SWITCH_WINDOWS;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gala_modal_proxy_allow_actions (_tmp3_, _tmp5_, (gint) 1);
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp6_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp6_, ___lambda89__gala_keybinding_filter, self);
}

static void
gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                     guint32 time,
                                     gboolean cancel)
{
	gboolean _tmp0_;
	MetaWindow* window = NULL;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opened;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_window_switcher_icon_get_window (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	if (!cancel) {
		MetaWorkspace* workspace = NULL;
		MetaWindow* _tmp7_;
		MetaWorkspace* _tmp8_;
		MetaWorkspace* _tmp9_;
		GalaWindowManager* _tmp10_;
		MetaDisplay* _tmp11_;
		MetaWorkspaceManager* _tmp12_;
		MetaWorkspace* _tmp13_;
		_tmp7_ = window;
		_tmp8_ = meta_window_get_workspace (_tmp7_);
		workspace = _tmp8_;
		_tmp9_ = workspace;
		_tmp10_ = self->priv->_wm;
		_tmp11_ = meta_plugin_get_display ((MetaPlugin*) _tmp10_);
		_tmp12_ = meta_display_get_workspace_manager (_tmp11_);
		_tmp13_ = meta_workspace_manager_get_active_workspace (_tmp12_);
		if (_tmp9_ != _tmp13_) {
			MetaWorkspace* _tmp14_;
			MetaWindow* _tmp15_;
			_tmp14_ = workspace;
			_tmp15_ = window;
			meta_workspace_activate_with_focus (_tmp14_, _tmp15_, time);
		} else {
			MetaWindow* _tmp16_;
			_tmp16_ = window;
			meta_window_activate (_tmp16_, time);
		}
	}
	gala_window_switcher_toggle_display (self, FALSE);
	_g_object_unref0 (window);
}

static void
gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                  gboolean backward)
{
	gdouble _tmp0_ = 0.0;
	GalaGestureController* _tmp1_;
	GalaGestureController* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	if (backward) {
		_tmp0_ = -GALA_WINDOW_SWITCHER_GESTURE_STEP;
	} else {
		_tmp0_ = GALA_WINDOW_SWITCHER_GESTURE_STEP;
	}
	_tmp1_ = self->priv->gesture_controller;
	_tmp2_ = self->priv->gesture_controller;
	_tmp3_ = gala_gesture_controller_get_progress (_tmp2_);
	_tmp4_ = _tmp3_;
	gala_gesture_controller_set_progress (_tmp2_, _tmp4_ + _tmp0_);
}

static void
gala_window_switcher_real_key_focus_out (ClutterActor* base)
{
	GalaWindowSwitcher * self;
	GalaGestureController* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (GalaWindowSwitcher*) base;
	_tmp0_ = self->priv->gesture_controller;
	_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GalaWindowManager* _tmp3_;
		MetaDisplay* _tmp4_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
		gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp4_), FALSE);
	}
}

static gboolean
gala_window_switcher_container_mouse_release (GalaWindowSwitcher* self,
                                              ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = self->priv->_opened;
	if (_tmp2_) {
		_tmp1_ = clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GalaGestureController* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->gesture_controller;
		_tmp4_ = gala_gesture_controller_get_recognizing (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
	}
	result = TRUE;
	return result;
}

static gboolean
gala_window_switcher_real_key_release_event (ClutterActor* base,
                                             ClutterEvent* event)
{
	GalaWindowSwitcher * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (GalaWindowSwitcher*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((gala_window_switcher_get_current_modifiers (self) & self->priv->modifier_mask) == 0) {
		GalaGestureController* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->gesture_controller;
		_tmp2_ = gala_gesture_controller_get_recognizing (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_window_switcher_real_key_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowSwitcher * self;
	gboolean result;
	self = (GalaWindowSwitcher*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (clutter_event_get_key_symbol (event)) {
		case CLUTTER_KEY_Right:
		{
			GalaGestureController* _tmp0_;
			gboolean _tmp1_;
			gboolean _tmp2_;
			_tmp0_ = self->priv->gesture_controller;
			_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gala_window_switcher_next_window (self, FALSE);
			}
			result = CLUTTER_EVENT_STOP;
			return result;
		}
		case CLUTTER_KEY_Left:
		{
			GalaGestureController* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = self->priv->gesture_controller;
			_tmp4_ = gala_gesture_controller_get_recognizing (_tmp3_);
			_tmp5_ = _tmp4_;
			if (!_tmp5_) {
				gala_window_switcher_next_window (self, TRUE);
			}
			result = CLUTTER_EVENT_STOP;
			return result;
		}
		case CLUTTER_KEY_Escape:
		{
			gala_window_switcher_close_switcher (self, clutter_event_get_time (event), TRUE);
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		case CLUTTER_KEY_Return:
		{
			gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		default:
		break;
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static inline ClutterModifierType
gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self)
{
	ClutterModifierType modifiers = 0U;
	MetaCursorTracker* tracker = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaCursorTracker* _tmp2_;
	ClutterModifierType _tmp3_ = 0U;
	ClutterModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_cursor_tracker_get_for_display (_tmp1_);
	tracker = _tmp2_;
	meta_cursor_tracker_get_pointer (tracker, NULL, &_tmp3_);
	modifiers = _tmp3_;
	result = modifiers & CLUTTER_MODIFIER_MASK;
	return result;
}

static ClutterActor*
gala_window_switcher_real_get_actor (GalaRootTarget* base)
{
	ClutterActor* result;
	GalaWindowSwitcher* self;
	self = (GalaWindowSwitcher*) base;
	result = (ClutterActor*) self;
	return result;
}

GalaWindowManager*
gala_window_switcher_get_wm (GalaWindowSwitcher* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY]);
	}
}

gboolean
gala_window_switcher_get_opened (GalaWindowSwitcher* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_opened;
	return result;
}

static void
gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_opened (self);
	if (old_value != value) {
		self->priv->_opened = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY]);
	}
}

gfloat
gala_window_switcher_get_monitor_scale (GalaWindowSwitcher* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

static void
gala_window_switcher_set_monitor_scale (GalaWindowSwitcher* self,
                                        gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_MONITOR_SCALE_PROPERTY]);
	}
}

static GalaWindowSwitcherIcon*
gala_window_switcher_get_current_icon (GalaWindowSwitcher* self)
{
	GalaWindowSwitcherIcon* result;
	GalaWindowSwitcherIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_icon;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_current_icon (GalaWindowSwitcher* self,
                                       GalaWindowSwitcherIcon* value)
{
	GalaWindowSwitcherIcon* _tmp0_;
	GalaWindowSwitcherIcon* _tmp2_;
	GalaWindowSwitcherIcon* _tmp3_;
	MetaWindow* _tmp6_ = NULL;
	GalaWindowSwitcherIcon* _tmp7_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp11_;
	const gchar* _tmp12_ = NULL;
	MetaWindow* _tmp13_;
	GalaText* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_icon;
	if (_tmp0_ != NULL) {
		GalaWindowSwitcherIcon* _tmp1_;
		_tmp1_ = self->priv->_current_icon;
		gala_window_switcher_icon_set_selected (_tmp1_, FALSE);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_icon);
	self->priv->_current_icon = _tmp2_;
	_tmp3_ = self->priv->_current_icon;
	if (_tmp3_ != NULL) {
		GalaWindowSwitcherIcon* _tmp4_;
		GalaWindowSwitcherIcon* _tmp5_;
		_tmp4_ = self->priv->_current_icon;
		gala_window_switcher_icon_set_selected (_tmp4_, TRUE);
		_tmp5_ = self->priv->_current_icon;
		clutter_actor_grab_key_focus ((ClutterActor*) _tmp5_);
	}
	_tmp7_ = self->priv->_current_icon;
	if (_tmp7_ != NULL) {
		GalaWindowSwitcherIcon* _tmp8_;
		MetaWindow* _tmp9_;
		MetaWindow* _tmp10_;
		_tmp8_ = self->priv->_current_icon;
		_tmp9_ = gala_window_switcher_icon_get_window (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_;
	} else {
		_tmp6_ = NULL;
	}
	_tmp11_ = _g_object_ref0 (_tmp6_);
	current_window = _tmp11_;
	_tmp13_ = current_window;
	if (_tmp13_ != NULL) {
		MetaWindow* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = current_window;
		_tmp15_ = meta_window_get_title (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = "n/a";
	}
	_tmp17_ = self->priv->caption;
	clutter_text_set_text ((ClutterText*) _tmp17_, _tmp12_);
	_g_object_unref0 (current_window);
}

static void
_gala_window_switcher_recognizing_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	gala_window_switcher_recognizing_changed ((GalaWindowSwitcher*) self);
}

static void
_gala_window_switcher_scale_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	gala_window_switcher_scale ((GalaWindowSwitcher*) self);
}

static gboolean
_gala_window_switcher_container_mouse_release_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                  ClutterEvent* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = gala_window_switcher_container_mouse_release ((GalaWindowSwitcher*) self, event);
	return result;
}

static void
_clutter_content_invalidate_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	clutter_content_invalidate ((ClutterContent*) self);
}

static void
_gala_window_switcher___lambda90_ (GalaWindowSwitcher* self)
{
	guint _tmp0_;
	guint _tmp1_;
	_tmp0_ = clutter_actor_get_opacity ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	g_object_set ((ClutterActor*) self, "visible", _tmp1_ != ((guint) 0), NULL);
}

static void
__gala_window_switcher___lambda90__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	_gala_window_switcher___lambda90_ ((GalaWindowSwitcher*) self);
}

static GObject *
gala_window_switcher_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowSwitcher * self;
	GalaDrawingStyleManager* _tmp0_;
	GalaDrawingStyleManager* _tmp1_;
	GalaWindowManager* _tmp2_;
	GalaGestureController* _tmp3_ = NULL;
	GalaGestureController* _tmp4_;
	GalaWindowManager* _tmp5_;
	ClutterStage* _tmp6_;
	ClutterStage* _tmp7_;
	GalaGestureController* _tmp8_;
	GalaGestureController* _tmp9_;
	ClutterFlowLayout* _tmp10_;
	ClutterActor* _tmp11_ = NULL;
	AtkObject* _tmp12_;
	ClutterActor* _tmp13_;
	AtkObject* _tmp14_;
	GalaText* _tmp15_ = NULL;
	ClutterActor* _tmp16_;
	GalaText* _tmp17_;
	ClutterBoxLayout* _tmp18_ = NULL;
	ClutterBoxLayout* _tmp19_;
	gfloat _tmp20_;
	GalaShadowEffect* _tmp21_ = NULL;
	GalaShadowEffect* _tmp22_;
	GalaShadowEffect* _tmp23_;
	gfloat _tmp24_;
	GalaBackgroundBlurEffect* _tmp25_;
	GalaBackgroundBlurEffect* _tmp26_;
	GalaBackgroundBlurEffect* _tmp27_;
	ClutterActor* _tmp28_;
	GalaDrawingStyleManager* _tmp29_;
	ClutterContent* _tmp30_;
	ClutterContent* _tmp31_;
	parent_class = G_OBJECT_CLASS (gala_window_switcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_tmp0_ = gala_drawing_style_manager_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->style_manager);
	self->priv->style_manager = _tmp1_;
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_SWITCH_WINDOWS, _tmp2_, GALA_GESTURE_CONTROLLER_GROUP_NONE);
	gala_gesture_controller_set_overshoot_upper_clamp (_tmp3_, (gdouble) G_MAXINT);
	gala_gesture_controller_set_overshoot_lower_clamp (_tmp3_, (gdouble) G_MININT);
	gala_gesture_controller_set_snap (_tmp3_, FALSE);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp3_;
	_tmp4_ = self->priv->gesture_controller;
	_tmp5_ = self->priv->_wm;
	_tmp6_ = gala_window_manager_get_stage (_tmp5_);
	_tmp7_ = _tmp6_;
	gala_gesture_controller_enable_touchpad (_tmp4_, (ClutterActor*) _tmp7_);
	_tmp8_ = self->priv->gesture_controller;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::recognizing", (GCallback) _gala_window_switcher_recognizing_changed_g_object_notify, self, 0);
	_tmp9_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp9_);
	_tmp10_ = (ClutterFlowLayout*) clutter_flow_layout_new (CLUTTER_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = clutter_actor_new ();
	clutter_actor_set_reactive (_tmp11_, TRUE);
	clutter_actor_set_layout_manager (_tmp11_, (ClutterLayoutManager*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp11_;
	_tmp12_ = clutter_actor_get_accessible ((ClutterActor*) self);
	g_object_set (_tmp12_, "accessible-name", _ ("Window switcher"), NULL);
	_tmp13_ = self->priv->container;
	_tmp14_ = clutter_actor_get_accessible (_tmp13_);
	g_object_set (_tmp14_, "accessible-role", ATK_ROLE_LIST, NULL);
	_tmp15_ = gala_text_new ();
	clutter_text_set_ellipsize ((ClutterText*) _tmp15_, PANGO_ELLIPSIZE_END);
	clutter_text_set_line_alignment ((ClutterText*) _tmp15_, PANGO_ALIGN_CENTER);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->caption);
	self->priv->caption = _tmp15_;
	_tmp16_ = self->priv->container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp16_);
	_tmp17_ = self->priv->caption;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp17_);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	_tmp18_ = (ClutterBoxLayout*) clutter_box_layout_new ();
	clutter_box_layout_set_orientation (_tmp18_, CLUTTER_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	clutter_actor_set_layout_manager ((ClutterActor*) self, (ClutterLayoutManager*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	g_signal_connect_object ((GObject*) self, "notify::monitor-scale", (GCallback) _gala_window_switcher_scale_g_object_notify, self, 0);
	gala_window_switcher_scale (self);
	_tmp20_ = self->priv->_monitor_scale;
	_tmp21_ = gala_shadow_effect_new ("window-switcher", _tmp20_);
	gala_shadow_effect_set_border_radius (_tmp21_, 10);
	gala_shadow_effect_set_shadow_opacity (_tmp21_, (guint8) 100);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->shadow_effect);
	self->priv->shadow_effect = _tmp21_;
	_tmp22_ = self->priv->shadow_effect;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp22_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp23_ = self->priv->shadow_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp23_);
	_tmp24_ = self->priv->_monitor_scale;
	_tmp25_ = gala_background_blur_effect_new ((gfloat) 40, (gfloat) 9, _tmp24_);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->blur_effect);
	self->priv->blur_effect = _tmp25_;
	_tmp26_ = self->priv->blur_effect;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp26_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp27_ = self->priv->blur_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp27_);
	_tmp28_ = self->priv->container;
	g_signal_connect_object (_tmp28_, "button-release-event", (GCallback) _gala_window_switcher_container_mouse_release_clutter_actor_button_release_event, self, 0);
	_tmp29_ = self->priv->style_manager;
	_tmp30_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp31_ = _tmp30_;
	g_signal_connect_object ((GObject*) _tmp29_, "notify::prefers-color-scheme", (GCallback) _clutter_content_invalidate_g_object_notify, _tmp31_, 0);
	g_signal_connect_object ((GObject*) self, "notify::opacity", (GCallback) __gala_window_switcher___lambda90__g_object_notify, self, 0);
	return obj;
}

static void
gala_window_switcher_class_init (GalaWindowSwitcherClass * klass,
                                 gpointer klass_data)
{
	gala_window_switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowSwitcher_private_offset);
	((ClutterActorClass *) klass)->get_preferred_width = (void (*) (ClutterActor*, gfloat, gfloat*, gfloat*)) gala_window_switcher_real_get_preferred_width;
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_window_switcher_real_draw;
	((ClutterActorClass *) klass)->key_focus_out = (void (*) (ClutterActor*)) gala_window_switcher_real_key_focus_out;
	((ClutterActorClass *) klass)->key_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_switcher_real_key_release_event;
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_switcher_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_switcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_switcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_switcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_switcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_ACTOR_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_WM_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_OPENED_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY] = g_param_spec_boolean ("opened", "opened", "opened", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_MONITOR_SCALE_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 1.0f, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_window_switcher_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                                         gpointer iface_data)
{
	gala_window_switcher_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_window_switcher_real_propagate;
}

static void
gala_window_switcher_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                      gpointer iface_data)
{
	gala_window_switcher_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_actor = gala_window_switcher_real_get_actor;
}

static void
gala_window_switcher_instance_init (GalaWindowSwitcher * self,
                                    gpointer klass)
{
	self->priv = gala_window_switcher_get_instance_private (self);
	self->priv->_opened = FALSE;
	self->priv->_monitor_scale = 1.0f;
	self->priv->modal_proxy = NULL;
	self->priv->_current_icon = NULL;
	self->priv->previous_progress = 0.;
}

static void
gala_window_switcher_finalize (GObject * obj)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->gesture_controller);
	_g_object_unref0 (self->priv->modal_proxy);
	_g_object_unref0 (self->priv->style_manager);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->caption);
	_g_object_unref0 (self->priv->shadow_effect);
	_g_object_unref0 (self->priv->blur_effect);
	_g_object_unref0 (self->priv->_current_icon);
	G_OBJECT_CLASS (gala_window_switcher_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_window_switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowSwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowSwitcher), 0, (GInstanceInitFunc) gala_window_switcher_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_window_switcher_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_window_switcher_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_switcher_type_id;
	gala_window_switcher_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaWindowSwitcher", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_switcher_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	g_type_add_interface_static (gala_window_switcher_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	GalaWindowSwitcher_private_offset = g_type_add_instance_private (gala_window_switcher_type_id, sizeof (GalaWindowSwitcherPrivate));
	return gala_window_switcher_type_id;
}

GType
gala_window_switcher_get_type (void)
{
	static gsize gala_window_switcher_type_id__once = 0;
	if (g_once_init_enter (&gala_window_switcher_type_id__once)) {
		GType gala_window_switcher_type_id;
		gala_window_switcher_type_id = gala_window_switcher_get_type_once ();
		g_once_init_leave (&gala_window_switcher_type_id__once, gala_window_switcher_type_id);
	}
	return gala_window_switcher_type_id__once;
}

static void
_vala_gala_window_switcher_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_ACTOR_PROPERTY:
		g_value_set_object (value, gala_root_target_get_actor ((GalaRootTarget*) self));
		break;
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		g_value_set_object (value, gala_window_switcher_get_wm (self));
		break;
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		g_value_set_boolean (value, gala_window_switcher_get_opened (self));
		break;
		case GALA_WINDOW_SWITCHER_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_window_switcher_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_switcher_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		gala_window_switcher_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		gala_window_switcher_set_opened (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_SWITCHER_MONITOR_SCALE_PROPERTY:
		gala_window_switcher_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

