/* application-folder-context.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-folder-context.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATION_FOLDER_CONTEXT_0_PROPERTY,
	APPLICATION_FOLDER_CONTEXT_FOLDER_PROPERTY,
	APPLICATION_FOLDER_CONTEXT_DISPLAY_NAME_PROPERTY,
	APPLICATION_FOLDER_CONTEXT_ICON_NAME_PROPERTY,
	APPLICATION_FOLDER_CONTEXT_DISPLAYED_COUNT_PROPERTY,
	APPLICATION_FOLDER_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ApplicationFolderContextPrivate {
	GearyFolder* _folder;
	gchar* _display_name;
	gchar* _icon_name;
	ApplicationFolderContextEmailCount _displayed_count;
};

static gint ApplicationFolderContext_private_offset;
static gpointer application_folder_context_parent_class = NULL;
static GeeComparableIface * application_folder_context_gee_comparable_parent_iface = NULL;

static void application_folder_context_set_folder (ApplicationFolderContext* self,
                                            GearyFolder* value);
static void __lambda5_ (ApplicationFolderContext* self);
static void application_folder_context_update (ApplicationFolderContext* self);
static void ___lambda5__geary_folder_use_changed (GearyFolder* _sender,
                                           GearyFolderSpecialUse old_use,
                                           GearyFolderSpecialUse new_use,
                                           gpointer self);
static gint application_folder_context_real_compare_to (GeeComparable* base,
                                                 ApplicationFolderContext* other);
static gchar* application_folder_context_get_default_icon_name (ApplicationFolderContext* self);
static void application_folder_context_finalize (GObject * obj);
static GType application_folder_context_get_type_once (void);
static void _vala_application_folder_context_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_application_folder_context_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
application_folder_context_get_instance_private (ApplicationFolderContext* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationFolderContext_private_offset);
}

/** Specifies different kinds of displayable email counts. */
static GType
application_folder_context_email_count_get_type_once (void)
{
	static const GEnumValue values[] = {{APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_NONE, "APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_NONE", "none"}, {APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_UNREAD, "APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_UNREAD", "unread"}, {APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_TOTAL, "APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_TOTAL", "total"}, {0, NULL, NULL}};
	GType application_folder_context_email_count_type_id;
	application_folder_context_email_count_type_id = g_enum_register_static ("ApplicationFolderContextEmailCount", values);
	return application_folder_context_email_count_type_id;
}

GType
application_folder_context_email_count_get_type (void)
{
	static volatile gsize application_folder_context_email_count_type_id__once = 0;
	if (g_once_init_enter (&application_folder_context_email_count_type_id__once)) {
		GType application_folder_context_email_count_type_id;
		application_folder_context_email_count_type_id = application_folder_context_email_count_get_type_once ();
		g_once_init_leave (&application_folder_context_email_count_type_id__once, application_folder_context_email_count_type_id);
	}
	return application_folder_context_email_count_type_id__once;
}

GearyFolder*
application_folder_context_get_folder (ApplicationFolderContext* self)
{
	GearyFolder* result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_folder;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_folder_context_set_folder (ApplicationFolderContext* self,
                                       GearyFolder* value)
{
	GearyFolder* old_value;
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self));
	old_value = application_folder_context_get_folder (self);
	if (old_value != value) {
		GearyFolder* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folder);
		self->priv->_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_FOLDER_PROPERTY]);
	}
}

const gchar*
application_folder_context_get_display_name (ApplicationFolderContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

void
application_folder_context_set_display_name (ApplicationFolderContext* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self));
	old_value = application_folder_context_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_DISPLAY_NAME_PROPERTY]);
	}
}

const gchar*
application_folder_context_get_icon_name (ApplicationFolderContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

void
application_folder_context_set_icon_name (ApplicationFolderContext* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self));
	old_value = application_folder_context_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_ICON_NAME_PROPERTY]);
	}
}

ApplicationFolderContextEmailCount
application_folder_context_get_displayed_count (ApplicationFolderContext* self)
{
	ApplicationFolderContextEmailCount result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self), 0);
	result = self->priv->_displayed_count;
	return result;
}

void
application_folder_context_set_displayed_count (ApplicationFolderContext* self,
                                                ApplicationFolderContextEmailCount value)
{
	ApplicationFolderContextEmailCount old_value;
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self));
	old_value = application_folder_context_get_displayed_count (self);
	if (old_value != value) {
		self->priv->_displayed_count = value;
		g_object_notify_by_pspec ((GObject *) self, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_DISPLAYED_COUNT_PROPERTY]);
	}
}

static void
__lambda5_ (ApplicationFolderContext* self)
{
	application_folder_context_update (self);
}

static void
___lambda5__geary_folder_use_changed (GearyFolder* _sender,
                                      GearyFolderSpecialUse old_use,
                                      GearyFolderSpecialUse new_use,
                                      gpointer self)
{
	__lambda5_ ((ApplicationFolderContext*) self);
}

ApplicationFolderContext*
application_folder_context_construct (GType object_type,
                                      GearyFolder* folder)
{
	ApplicationFolderContext * self = NULL;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER), NULL);
	self = (ApplicationFolderContext*) geary_base_object_construct (object_type);
	application_folder_context_set_folder (self, folder);
	_tmp0_ = self->priv->_folder;
	g_signal_connect_object (_tmp0_, "use-changed", (GCallback) ___lambda5__geary_folder_use_changed, self, 0);
	application_folder_context_update (self);
	return self;
}

ApplicationFolderContext*
application_folder_context_new (GearyFolder* folder)
{
	return application_folder_context_construct (APPLICATION_TYPE_FOLDER_CONTEXT, folder);
}

static gint
application_folder_context_real_compare_to (GeeComparable* base,
                                            ApplicationFolderContext* other)
{
	ApplicationFolderContext * self;
	GearyFolder* _tmp0_;
	GearyFolderPath* _tmp1_;
	GearyFolderPath* _tmp2_;
	GearyFolder* _tmp3_;
	GearyFolderPath* _tmp4_;
	GearyFolderPath* _tmp5_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_FOLDER_CONTEXT, ApplicationFolderContext);
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (other), 0);
	_tmp0_ = self->priv->_folder;
	_tmp1_ = geary_folder_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = other->priv->_folder;
	_tmp4_ = geary_folder_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	result = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp5_);
	return result;
}

static gchar*
application_folder_context_get_default_icon_name (ApplicationFolderContext* self)
{
	GearyServiceProvider service_provider = 0;
	GearyFolder* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	GearyAccountInformation* _tmp3_;
	GearyAccountInformation* _tmp4_;
	GearyServiceProvider _tmp5_;
	GearyServiceProvider _tmp6_;
	gchar* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_folder;
	_tmp1_ = geary_folder_get_account (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_account_get_information (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_account_information_get_service_provider (_tmp4_);
	_tmp6_ = _tmp5_;
	service_provider = _tmp6_;
	switch (service_provider) {
		case GEARY_SERVICE_PROVIDER_GMAIL:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("tag-symbolic");
			result = _tmp7_;
			return result;
		}
		default:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("folder-symbolic");
			result = _tmp8_;
			return result;
		}
	}
}

static void
application_folder_context_update (ApplicationFolderContext* self)
{
	GearyFolder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyFolder* _tmp3_;
	GearyFolderSpecialUse _tmp4_;
	GearyFolderSpecialUse _tmp5_;
	GearyFolder* _tmp8_;
	GearyFolderSpecialUse _tmp9_;
	GearyFolderSpecialUse _tmp10_;
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (self));
	_tmp0_ = self->priv->_folder;
	_tmp1_ = util_i18n_to_folder_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	application_folder_context_set_display_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_folder;
	_tmp4_ = geary_folder_get_used_as (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		case GEARY_FOLDER_SPECIAL_USE_INBOX:
		{
			application_folder_context_set_icon_name (self, "mail-inbox-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_DRAFTS:
		{
			application_folder_context_set_icon_name (self, "mail-drafts-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_SENT:
		{
			application_folder_context_set_icon_name (self, "mail-sent-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_FLAGGED:
		{
			application_folder_context_set_icon_name (self, "starred-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_IMPORTANT:
		{
			application_folder_context_set_icon_name (self, "task-due-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_ALL_MAIL:
		case GEARY_FOLDER_SPECIAL_USE_ARCHIVE:
		{
			application_folder_context_set_icon_name (self, "mail-archive-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_JUNK:
		{
			application_folder_context_set_icon_name (self, "dialog-warning-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_TRASH:
		{
			application_folder_context_set_icon_name (self, "user-trash-symbolic");
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_OUTBOX:
		{
			application_folder_context_set_icon_name (self, "mail-outbox-symbolic");
			break;
		}
		default:
		{
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = application_folder_context_get_default_icon_name (self);
			_tmp7_ = _tmp6_;
			application_folder_context_set_icon_name (self, _tmp7_);
			_g_free0 (_tmp7_);
			break;
		}
	}
	_tmp8_ = self->priv->_folder;
	_tmp9_ = geary_folder_get_used_as (_tmp8_);
	_tmp10_ = _tmp9_;
	switch (_tmp10_) {
		case GEARY_FOLDER_SPECIAL_USE_DRAFTS:
		case GEARY_FOLDER_SPECIAL_USE_OUTBOX:
		{
			application_folder_context_set_displayed_count (self, APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_TOTAL);
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_INBOX:
		case GEARY_FOLDER_SPECIAL_USE_JUNK:
		case GEARY_FOLDER_SPECIAL_USE_NONE:
		{
			application_folder_context_set_displayed_count (self, APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_UNREAD);
			break;
		}
		default:
		{
			application_folder_context_set_displayed_count (self, APPLICATION_FOLDER_CONTEXT_EMAIL_COUNT_NONE);
			break;
		}
	}
}

static void
application_folder_context_class_init (ApplicationFolderContextClass * klass,
                                       gpointer klass_data)
{
	application_folder_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationFolderContext_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_folder_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_folder_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_folder_context_finalize;
	/** The account for this context. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_CONTEXT_FOLDER_PROPERTY, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_FOLDER_PROPERTY] = g_param_spec_object ("folder", "folder", "folder", GEARY_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the human-readable name of the folder */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_CONTEXT_DISPLAY_NAME_PROPERTY, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The icon to use for the folder */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_CONTEXT_ICON_NAME_PROPERTY, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The count to be displayed for the folder. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_CONTEXT_DISPLAYED_COUNT_PROPERTY, application_folder_context_properties[APPLICATION_FOLDER_CONTEXT_DISPLAYED_COUNT_PROPERTY] = g_param_spec_enum ("displayed-count", "displayed-count", "displayed-count", APPLICATION_FOLDER_CONTEXT_TYPE_EMAIL_COUNT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
application_folder_context_gee_comparable_interface_init (GeeComparableIface * iface,
                                                          gpointer iface_data)
{
	application_folder_context_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) application_folder_context_real_compare_to;
}

static void
application_folder_context_instance_init (ApplicationFolderContext * self,
                                          gpointer klass)
{
	self->priv = application_folder_context_get_instance_private (self);
}

static void
application_folder_context_finalize (GObject * obj)
{
	ApplicationFolderContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_FOLDER_CONTEXT, ApplicationFolderContext);
	_g_object_unref0 (self->priv->_folder);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_icon_name);
	G_OBJECT_CLASS (application_folder_context_parent_class)->finalize (obj);
}

/**
 * Collects application state related to a single folder.
 */
static GType
application_folder_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationFolderContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_folder_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationFolderContext), 0, (GInstanceInitFunc) application_folder_context_instance_init, NULL };
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) application_folder_context_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType application_folder_context_type_id;
	application_folder_context_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationFolderContext", &g_define_type_info, 0);
	g_type_add_interface_static (application_folder_context_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	ApplicationFolderContext_private_offset = g_type_add_instance_private (application_folder_context_type_id, sizeof (ApplicationFolderContextPrivate));
	return application_folder_context_type_id;
}

GType
application_folder_context_get_type (void)
{
	static volatile gsize application_folder_context_type_id__once = 0;
	if (g_once_init_enter (&application_folder_context_type_id__once)) {
		GType application_folder_context_type_id;
		application_folder_context_type_id = application_folder_context_get_type_once ();
		g_once_init_leave (&application_folder_context_type_id__once, application_folder_context_type_id);
	}
	return application_folder_context_type_id__once;
}

static void
_vala_application_folder_context_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ApplicationFolderContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_FOLDER_CONTEXT, ApplicationFolderContext);
	switch (property_id) {
		case APPLICATION_FOLDER_CONTEXT_FOLDER_PROPERTY:
		g_value_set_object (value, application_folder_context_get_folder (self));
		break;
		case APPLICATION_FOLDER_CONTEXT_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, application_folder_context_get_display_name (self));
		break;
		case APPLICATION_FOLDER_CONTEXT_ICON_NAME_PROPERTY:
		g_value_set_string (value, application_folder_context_get_icon_name (self));
		break;
		case APPLICATION_FOLDER_CONTEXT_DISPLAYED_COUNT_PROPERTY:
		g_value_set_enum (value, application_folder_context_get_displayed_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_folder_context_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ApplicationFolderContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_FOLDER_CONTEXT, ApplicationFolderContext);
	switch (property_id) {
		case APPLICATION_FOLDER_CONTEXT_FOLDER_PROPERTY:
		application_folder_context_set_folder (self, g_value_get_object (value));
		break;
		case APPLICATION_FOLDER_CONTEXT_DISPLAY_NAME_PROPERTY:
		application_folder_context_set_display_name (self, g_value_get_string (value));
		break;
		case APPLICATION_FOLDER_CONTEXT_ICON_NAME_PROPERTY:
		application_folder_context_set_icon_name (self, g_value_get_string (value));
		break;
		case APPLICATION_FOLDER_CONTEXT_DISPLAYED_COUNT_PROPERTY:
		application_folder_context_set_displayed_count (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

