/* components-attachment-pane.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from components-attachment-pane.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>

#define COMPONENTS_ATTACHMENT_PANE_GROUP_NAME "cap"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_OPEN "open"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_OPEN_SELECTED "open-selected"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_REMOVE "remove"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_REMOVE_SELECTED "remove-selected"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE "save"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE_ALL "save-all"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE_SELECTED "save-selected"
#define COMPONENTS_ATTACHMENT_PANE_ACTION_SELECT_ALL "select-all"
#define COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_ICON_SIZE 32
#define COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PREVIEW_SIZE 64
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX (components_attachment_pane_flow_box_get_type ())
#define COMPONENTS_ATTACHMENT_PANE_FLOW_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX, ComponentsAttachmentPaneFlowBox))
#define COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX, ComponentsAttachmentPaneFlowBoxClass))
#define COMPONENTS_ATTACHMENT_PANE_IS_FLOW_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX))
#define COMPONENTS_ATTACHMENT_PANE_IS_FLOW_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX))
#define COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX, ComponentsAttachmentPaneFlowBoxClass))

typedef struct _ComponentsAttachmentPaneFlowBox ComponentsAttachmentPaneFlowBox;
typedef struct _ComponentsAttachmentPaneFlowBoxClass ComponentsAttachmentPaneFlowBoxClass;
enum  {
	COMPONENTS_ATTACHMENT_PANE_0_PROPERTY,
	COMPONENTS_ATTACHMENT_PANE_EDIT_MODE_PROPERTY,
	COMPONENTS_ATTACHMENT_PANE_NUM_PROPERTIES
};
static GParamSpec* components_attachment_pane_properties[COMPONENTS_ATTACHMENT_PANE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW (components_attachment_pane_view_get_type ())
#define COMPONENTS_ATTACHMENT_PANE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView))
#define COMPONENTS_ATTACHMENT_PANE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneViewClass))
#define COMPONENTS_ATTACHMENT_PANE_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW))
#define COMPONENTS_ATTACHMENT_PANE_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW))
#define COMPONENTS_ATTACHMENT_PANE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneViewClass))

typedef struct _ComponentsAttachmentPaneView ComponentsAttachmentPaneView;
typedef struct _ComponentsAttachmentPaneViewClass ComponentsAttachmentPaneViewClass;
typedef struct _Block51Data Block51Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block52Data Block52Data;

#define TYPE_ALERT_DIALOG (alert_dialog_get_type ())
#define ALERT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALERT_DIALOG, AlertDialog))
#define ALERT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALERT_DIALOG, AlertDialogClass))
#define IS_ALERT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALERT_DIALOG))
#define IS_ALERT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALERT_DIALOG))
#define ALERT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALERT_DIALOG, AlertDialogClass))

typedef struct _AlertDialog AlertDialog;
typedef struct _AlertDialogClass AlertDialogClass;

#define TYPE_QUESTION_DIALOG (question_dialog_get_type ())
#define QUESTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUESTION_DIALOG, QuestionDialog))
#define QUESTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUESTION_DIALOG, QuestionDialogClass))
#define IS_QUESTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUESTION_DIALOG))
#define IS_QUESTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUESTION_DIALOG))
#define QUESTION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUESTION_DIALOG, QuestionDialogClass))

typedef struct _QuestionDialog QuestionDialog;
typedef struct _QuestionDialogClass QuestionDialogClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ComponentsAttachmentPaneFlowBoxPrivate ComponentsAttachmentPaneFlowBoxPrivate;
enum  {
	COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_0_PROPERTY,
	COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_NUM_PROPERTIES
};
static GParamSpec* components_attachment_pane_flow_box_properties[COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_NUM_PROPERTIES];
enum  {
	COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_OPEN_ATTACHMENTS_SIGNAL,
	COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_SAVE_ATTACHMENTS_SIGNAL,
	COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_REMOVE_ATTACHMENTS_SIGNAL,
	COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_NUM_SIGNALS
};
static guint components_attachment_pane_flow_box_signals[COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_NUM_SIGNALS] = {0};
typedef struct _ComponentsAttachmentPaneViewPrivate ComponentsAttachmentPaneViewPrivate;
enum  {
	COMPONENTS_ATTACHMENT_PANE_VIEW_0_PROPERTY,
	COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PROPERTY,
	COMPONENTS_ATTACHMENT_PANE_VIEW_NUM_PROPERTIES
};
static GParamSpec* components_attachment_pane_view_properties[COMPONENTS_ATTACHMENT_PANE_VIEW_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _ComponentsAttachmentPaneViewLoadIconData ComponentsAttachmentPaneViewLoadIconData;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

struct _ComponentsAttachmentPanePrivate {
	gboolean _edit_mode;
	GeeList* attachments;
	ApplicationAttachmentManager* manager;
	GSimpleActionGroup* actions;
	GtkGrid* attachments_container;
	GtkButton* save_button;
	GtkButton* remove_button;
	ComponentsAttachmentPaneFlowBox* attachments_view;
};

struct _Block51Data {
	int _ref_count_;
	ComponentsAttachmentPane* self;
	GearyAttachment* attachment;
};

struct _Block52Data {
	int _ref_count_;
	ComponentsAttachmentPane* self;
	GeeLinkedList* selected;
};

struct _ComponentsAttachmentPaneFlowBox {
	GtkFlowBox parent_instance;
	ComponentsAttachmentPaneFlowBoxPrivate * priv;
};

struct _ComponentsAttachmentPaneFlowBoxClass {
	GtkFlowBoxClass parent_class;
};

struct _ComponentsAttachmentPaneView {
	GtkGrid parent_instance;
	ComponentsAttachmentPaneViewPrivate * priv;
};

struct _ComponentsAttachmentPaneViewClass {
	GtkGridClass parent_class;
};

struct _ComponentsAttachmentPaneViewPrivate {
	GearyAttachment* _attachment;
	GtkImage* icon;
	GtkLabel* filename;
	GtkLabel* description;
	gchar* gio_content_type;
};

struct _ComponentsAttachmentPaneViewLoadIconData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsAttachmentPaneView* self;
	GCancellable* load_cancelled;
	GdkPixbuf* pixbuf;
	gint window_scale;
	GearyAttachment* _tmp0_;
	GearyMimeContentType* _tmp1_;
	GearyMimeContentType* _tmp2_;
	gint preview_size;
	GInputStream* stream;
	GearyAttachment* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFileInputStream* _tmp6_;
	GdkPixbuf* _tmp7_;
	GInputStream* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GIcon* icon;
	const gchar* _tmp13_;
	GIcon* _tmp14_;
	GtkIconTheme* theme;
	GtkIconTheme* _tmp15_;
	GtkIconTheme* _tmp16_;
	GtkIconLookupFlags flags;
	GtkIconInfo* icon_info;
	GtkIconTheme* _tmp17_;
	GIcon* _tmp18_;
	GtkIconInfo* _tmp19_;
	GtkIconInfo* _tmp20_;
	GdkPixbuf* _tmp21_;
	GtkIconInfo* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GError* _error_;
	GearyAttachment* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GError* _tmp30_;
	const gchar* _tmp31_;
	GdkPixbuf* _tmp32_;
	cairo_surface_t* surface;
	GdkPixbuf* _tmp33_;
	GdkWindow* _tmp34_;
	cairo_surface_t* _tmp35_;
	GtkImage* _tmp36_;
	cairo_surface_t* _tmp37_;
	GError* _inner_error0_;
};

static gint ComponentsAttachmentPane_private_offset;
static gpointer components_attachment_pane_parent_class = NULL;
static gpointer components_attachment_pane_flow_box_parent_class = NULL;
static gint ComponentsAttachmentPaneView_private_offset;
static gpointer components_attachment_pane_view_parent_class = NULL;

static GType components_attachment_pane_flow_box_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void components_attachment_pane_on_open (ComponentsAttachmentPane* self,
                                         GSimpleAction* action,
                                         GVariant* param);
static void _components_attachment_pane_on_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void components_attachment_pane_on_open_selected (ComponentsAttachmentPane* self);
static void _components_attachment_pane_on_open_selected_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void components_attachment_pane_on_remove (ComponentsAttachmentPane* self,
                                           GSimpleAction* action,
                                           GVariant* param);
static void _components_attachment_pane_on_remove_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void components_attachment_pane_on_remove_selected (ComponentsAttachmentPane* self);
static void _components_attachment_pane_on_remove_selected_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
static void components_attachment_pane_on_save (ComponentsAttachmentPane* self,
                                         GSimpleAction* action,
                                         GVariant* param);
static void _components_attachment_pane_on_save_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void components_attachment_pane_on_save_all (ComponentsAttachmentPane* self);
static void _components_attachment_pane_on_save_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void components_attachment_pane_on_save_selected (ComponentsAttachmentPane* self);
static void _components_attachment_pane_on_save_selected_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void components_attachment_pane_on_select_all (ComponentsAttachmentPane* self);
static void _components_attachment_pane_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void components_attachment_pane_set_edit_mode (ComponentsAttachmentPane* self,
                                               gboolean value);
static ComponentsAttachmentPaneFlowBox* components_attachment_pane_flow_box_new (void);
static ComponentsAttachmentPaneFlowBox* components_attachment_pane_flow_box_construct (GType object_type);
static void _components_attachment_pane_on_open_selected_components_attachment_pane_flow_box_open_attachments (ComponentsAttachmentPaneFlowBox* _sender,
                                                                                                        gpointer self);
static void _components_attachment_pane_on_remove_selected_components_attachment_pane_flow_box_remove_attachments (ComponentsAttachmentPaneFlowBox* _sender,
                                                                                                            gpointer self);
static void _components_attachment_pane_on_save_selected_components_attachment_pane_flow_box_save_attachments (ComponentsAttachmentPaneFlowBox* _sender,
                                                                                                        gpointer self);
static void components_attachment_pane_on_child_activated (ComponentsAttachmentPane* self);
static void _components_attachment_pane_on_child_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                                  GtkFlowBoxChild* child,
                                                                                  gpointer self);
static void components_attachment_pane_on_selected_changed (ComponentsAttachmentPane* self);
static void _components_attachment_pane_on_selected_changed_gtk_flow_box_selected_children_changed (GtkFlowBox* _sender,
                                                                                             gpointer self);
static gboolean components_attachment_pane_on_attachment_button_press (ComponentsAttachmentPane* self,
                                                                GtkWidget* widget,
                                                                GdkEventButton* event);
static gboolean _components_attachment_pane_on_attachment_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                               GdkEventButton* event,
                                                                                               gpointer self);
static gboolean components_attachment_pane_on_attachment_popup_menu (ComponentsAttachmentPane* self,
                                                              GtkWidget* widget);
static gboolean _components_attachment_pane_on_attachment_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                                     gpointer self);
static GType components_attachment_pane_view_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ComponentsAttachmentPaneView* components_attachment_pane_view_new (GearyAttachment* attachment);
static ComponentsAttachmentPaneView* components_attachment_pane_view_construct (GType object_type,
                                                                         GearyAttachment* attachment);
static void components_attachment_pane_view_load_icon (ComponentsAttachmentPaneView* self,
                                                GCancellable* load_cancelled,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void components_attachment_pane_view_load_icon_finish (ComponentsAttachmentPaneView* self,
                                                       GAsyncResult* _res_);
static void components_attachment_pane_update_actions (ComponentsAttachmentPane* self);
static void components_attachment_pane_open_attachments (ComponentsAttachmentPane* self,
                                                  GeeCollection* attachments);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static void __lambda99_ (Block51Data* _data51_,
                  GtkWidget* child);
static GearyAttachment* components_attachment_pane_view_get_attachment (ComponentsAttachmentPaneView* self);
static void ___lambda99__gtk_callback (GtkWidget* widget,
                                gpointer self);
static GearyAttachment* components_attachment_pane_get_attachment (ComponentsAttachmentPane* self,
                                                            GVariant* param);
static gchar* _variant_get5 (GVariant* value);
static GeeCollection* components_attachment_pane_get_selected_attachments (ComponentsAttachmentPane* self);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void __lambda98_ (Block52Data* _data52_,
                  GtkFlowBox* box,
                  GtkFlowBoxChild* child);
static void ___lambda98__gtk_flow_box_foreach_func (GtkFlowBox* box,
                                             GtkFlowBoxChild* child,
                                             gpointer self);
static gboolean components_attachment_pane_open_selected (ComponentsAttachmentPane* self);
static gboolean components_attachment_pane_save_selected (ComponentsAttachmentPane* self);
static gboolean components_attachment_pane_remove_selected (ComponentsAttachmentPane* self);
static void ___lambda100_ (ComponentsAttachmentPane* self,
                    GtkFlowBoxChild* child);
static void ____lambda100__gfunc (gconstpointer data,
                           gpointer self);
static void components_attachment_pane_set_action_enabled (ComponentsAttachmentPane* self,
                                                    const gchar* name,
                                                    gboolean enabled);
VALA_EXTERN GType alert_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType question_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN QuestionDialog* question_dialog_new_with_checkbox (GtkWindow* parent,
                                                   const gchar* title,
                                                   const gchar* description,
                                                   const gchar* yes_button,
                                                   const gchar* no_button,
                                                   const gchar* checkbox_label,
                                                   gboolean checkbox_default);
VALA_EXTERN QuestionDialog* question_dialog_construct_with_checkbox (GType object_type,
                                                         GtkWindow* parent,
                                                         const gchar* title,
                                                         const gchar* description,
                                                         const gchar* yes_button,
                                                         const gchar* no_button,
                                                         const gchar* checkbox_label,
                                                         gboolean checkbox_default);
VALA_EXTERN GtkResponseType alert_dialog_run (AlertDialog* self);
VALA_EXTERN gboolean question_dialog_get_is_checked (QuestionDialog* self);
static void components_attachment_pane_show_popup (ComponentsAttachmentPane* self,
                                            ComponentsAttachmentPaneView* view,
                                            GdkEventButton* event);
static GVariant* _variant_new4 (gchar* value);
static void components_attachment_pane_beep (ComponentsAttachmentPane* self);
static GType components_attachment_pane_flow_box_get_type_once (void);
static void components_attachment_pane_view_set_attachment (ComponentsAttachmentPaneView* self,
                                                     GearyAttachment* value);
static void components_attachment_pane_view_load_icon_data_free (gpointer _data);
static gboolean components_attachment_pane_view_load_icon_co (ComponentsAttachmentPaneViewLoadIconData* _data_);
static void components_attachment_pane_view_load_icon_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void components_attachment_pane_view_finalize (GObject * obj);
static GType components_attachment_pane_view_get_type_once (void);
static void _vala_components_attachment_pane_view_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_components_attachment_pane_view_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void components_attachment_pane_finalize (GObject * obj);
static GType components_attachment_pane_get_type_once (void);
static void _vala_components_attachment_pane_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_components_attachment_pane_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static const GActionEntry COMPONENTS_ATTACHMENT_PANE_action_entries[8] = {{COMPONENTS_ATTACHMENT_PANE_ACTION_OPEN, _components_attachment_pane_on_open_gsimple_action_activate_callback, "s"}, {COMPONENTS_ATTACHMENT_PANE_ACTION_OPEN_SELECTED, _components_attachment_pane_on_open_selected_gsimple_action_activate_callback}, {COMPONENTS_ATTACHMENT_PANE_ACTION_REMOVE, _components_attachment_pane_on_remove_gsimple_action_activate_callback, "s"}, {COMPONENTS_ATTACHMENT_PANE_ACTION_REMOVE_SELECTED, _components_attachment_pane_on_remove_selected_gsimple_action_activate_callback}, {COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE, _components_attachment_pane_on_save_gsimple_action_activate_callback, "s"}, {COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE_ALL, _components_attachment_pane_on_save_all_gsimple_action_activate_callback}, {COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE_SELECTED, _components_attachment_pane_on_save_selected_gsimple_action_activate_callback}, {COMPONENTS_ATTACHMENT_PANE_ACTION_SELECT_ALL, _components_attachment_pane_on_select_all_gsimple_action_activate_callback}};

static inline gpointer
components_attachment_pane_get_instance_private (ComponentsAttachmentPane* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsAttachmentPane_private_offset);
}

static void
_components_attachment_pane_on_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	components_attachment_pane_on_open ((ComponentsAttachmentPane*) self, action, parameter);
}

static void
_components_attachment_pane_on_open_selected_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	components_attachment_pane_on_open_selected ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_remove_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	components_attachment_pane_on_remove ((ComponentsAttachmentPane*) self, action, parameter);
}

static void
_components_attachment_pane_on_remove_selected_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	components_attachment_pane_on_remove_selected ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_save_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	components_attachment_pane_on_save ((ComponentsAttachmentPane*) self, action, parameter);
}

static void
_components_attachment_pane_on_save_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	components_attachment_pane_on_save_all ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_save_selected_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	components_attachment_pane_on_save_selected ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	components_attachment_pane_on_select_all ((ComponentsAttachmentPane*) self);
}

gboolean
components_attachment_pane_get_edit_mode (ComponentsAttachmentPane* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), FALSE);
	result = self->priv->_edit_mode;
	return result;
}

static void
components_attachment_pane_set_edit_mode (ComponentsAttachmentPane* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	old_value = components_attachment_pane_get_edit_mode (self);
	if (old_value != value) {
		self->priv->_edit_mode = value;
		g_object_notify_by_pspec ((GObject *) self, components_attachment_pane_properties[COMPONENTS_ATTACHMENT_PANE_EDIT_MODE_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_components_attachment_pane_on_open_selected_components_attachment_pane_flow_box_open_attachments (ComponentsAttachmentPaneFlowBox* _sender,
                                                                                                   gpointer self)
{
	components_attachment_pane_on_open_selected ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_remove_selected_components_attachment_pane_flow_box_remove_attachments (ComponentsAttachmentPaneFlowBox* _sender,
                                                                                                       gpointer self)
{
	components_attachment_pane_on_remove_selected ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_save_selected_components_attachment_pane_flow_box_save_attachments (ComponentsAttachmentPaneFlowBox* _sender,
                                                                                                   gpointer self)
{
	components_attachment_pane_on_save_selected ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_child_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                             GtkFlowBoxChild* child,
                                                                             gpointer self)
{
	components_attachment_pane_on_child_activated ((ComponentsAttachmentPane*) self);
}

static void
_components_attachment_pane_on_selected_changed_gtk_flow_box_selected_children_changed (GtkFlowBox* _sender,
                                                                                        gpointer self)
{
	components_attachment_pane_on_selected_changed ((ComponentsAttachmentPane*) self);
}

static gboolean
_components_attachment_pane_on_attachment_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                      GdkEventButton* event,
                                                                                      gpointer self)
{
	gboolean result;
	result = components_attachment_pane_on_attachment_button_press ((ComponentsAttachmentPane*) self, _sender, event);
	return result;
}

static gboolean
_components_attachment_pane_on_attachment_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                            gpointer self)
{
	gboolean result;
	result = components_attachment_pane_on_attachment_popup_menu ((ComponentsAttachmentPane*) self, _sender);
	return result;
}

ComponentsAttachmentPane*
components_attachment_pane_construct (GType object_type,
                                      gboolean edit_mode,
                                      ApplicationAttachmentManager* manager)
{
	ComponentsAttachmentPane * self = NULL;
	ApplicationAttachmentManager* _tmp2_;
	ComponentsAttachmentPaneFlowBox* _tmp3_;
	ComponentsAttachmentPaneFlowBox* _tmp4_;
	ComponentsAttachmentPaneFlowBox* _tmp5_;
	ComponentsAttachmentPaneFlowBox* _tmp6_;
	ComponentsAttachmentPaneFlowBox* _tmp7_;
	ComponentsAttachmentPaneFlowBox* _tmp8_;
	ComponentsAttachmentPaneFlowBox* _tmp9_;
	ComponentsAttachmentPaneFlowBox* _tmp10_;
	ComponentsAttachmentPaneFlowBox* _tmp11_;
	ComponentsAttachmentPaneFlowBox* _tmp12_;
	ComponentsAttachmentPaneFlowBox* _tmp13_;
	ComponentsAttachmentPaneFlowBox* _tmp14_;
	ComponentsAttachmentPaneFlowBox* _tmp15_;
	ComponentsAttachmentPaneFlowBox* _tmp16_;
	ComponentsAttachmentPaneFlowBox* _tmp17_;
	GtkGrid* _tmp18_;
	ComponentsAttachmentPaneFlowBox* _tmp19_;
	GSimpleActionGroup* _tmp20_;
	GSimpleActionGroup* _tmp21_;
	g_return_val_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (manager), NULL);
	self = (ComponentsAttachmentPane*) g_object_new (object_type, NULL);
	components_attachment_pane_set_edit_mode (self, edit_mode);
	if (edit_mode) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->save_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->remove_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp2_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp2_;
	_tmp3_ = components_attachment_pane_flow_box_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->attachments_view);
	self->priv->attachments_view = _tmp3_;
	_tmp4_ = self->priv->attachments_view;
	g_signal_connect_object (_tmp4_, "open-attachments", (GCallback) _components_attachment_pane_on_open_selected_components_attachment_pane_flow_box_open_attachments, self, 0);
	_tmp5_ = self->priv->attachments_view;
	g_signal_connect_object (_tmp5_, "remove-attachments", (GCallback) _components_attachment_pane_on_remove_selected_components_attachment_pane_flow_box_remove_attachments, self, 0);
	_tmp6_ = self->priv->attachments_view;
	g_signal_connect_object (_tmp6_, "save-attachments", (GCallback) _components_attachment_pane_on_save_selected_components_attachment_pane_flow_box_save_attachments, self, 0);
	_tmp7_ = self->priv->attachments_view;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_flow_box_get_type (), GtkFlowBox), "child-activated", (GCallback) _components_attachment_pane_on_child_activated_gtk_flow_box_child_activated, self, 0);
	_tmp8_ = self->priv->attachments_view;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_flow_box_get_type (), GtkFlowBox), "selected-children-changed", (GCallback) _components_attachment_pane_on_selected_changed_gtk_flow_box_selected_children_changed, self, 0);
	_tmp9_ = self->priv->attachments_view;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _components_attachment_pane_on_attachment_button_press_gtk_widget_button_press_event, self, 0);
	_tmp10_ = self->priv->attachments_view;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), "popup-menu", (GCallback) _components_attachment_pane_on_attachment_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp11_ = self->priv->attachments_view;
	gtk_flow_box_set_activate_on_single_click (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_flow_box_get_type (), GtkFlowBox), FALSE);
	_tmp12_ = self->priv->attachments_view;
	gtk_flow_box_set_max_children_per_line (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_flow_box_get_type (), GtkFlowBox), (guint) 3);
	_tmp13_ = self->priv->attachments_view;
	gtk_flow_box_set_column_spacing (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_flow_box_get_type (), GtkFlowBox), (guint) 6);
	_tmp14_ = self->priv->attachments_view;
	gtk_flow_box_set_row_spacing (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_flow_box_get_type (), GtkFlowBox), (guint) 6);
	_tmp15_ = self->priv->attachments_view;
	gtk_flow_box_set_selection_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_flow_box_get_type (), GtkFlowBox), GTK_SELECTION_MULTIPLE);
	_tmp16_ = self->priv->attachments_view;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp17_ = self->priv->attachments_view;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->attachments_container;
	_tmp19_ = self->priv->attachments_view;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_action_map_get_type (), GActionMap), COMPONENTS_ATTACHMENT_PANE_action_entries, (gint) G_N_ELEMENTS (COMPONENTS_ATTACHMENT_PANE_action_entries), self);
	_tmp21_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), COMPONENTS_ATTACHMENT_PANE_GROUP_NAME, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_action_group_get_type (), GActionGroup));
	return self;
}

ComponentsAttachmentPane*
components_attachment_pane_new (gboolean edit_mode,
                                ApplicationAttachmentManager* manager)
{
	return components_attachment_pane_construct (COMPONENTS_TYPE_ATTACHMENT_PANE, edit_mode, manager);
}

void
components_attachment_pane_add_attachment (ComponentsAttachmentPane* self,
                                           GearyAttachment* attachment,
                                           GCancellable* cancellable)
{
	ComponentsAttachmentPaneView* view = NULL;
	ComponentsAttachmentPaneView* _tmp0_;
	ComponentsAttachmentPaneFlowBox* _tmp1_;
	GeeList* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachment, GEARY_TYPE_ATTACHMENT));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = components_attachment_pane_view_new (attachment);
	g_object_ref_sink (_tmp0_);
	view = _tmp0_;
	_tmp1_ = self->priv->attachments_view;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (view, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->attachments;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), attachment);
	components_attachment_pane_view_load_icon (view, cancellable, NULL, NULL);
	components_attachment_pane_update_actions (self);
	_g_object_unref0 (view);
}

void
components_attachment_pane_open_attachment (ComponentsAttachmentPane* self,
                                            GearyAttachment* attachment)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachment, GEARY_TYPE_ATTACHMENT));
	_tmp0_ = geary_collection_single (GEARY_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, attachment);
	_tmp1_ = _tmp0_;
	components_attachment_pane_open_attachments (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

void
components_attachment_pane_save_attachment (ComponentsAttachmentPane* self,
                                            GearyAttachment* attachment)
{
	ApplicationAttachmentManager* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachment, GEARY_TYPE_ATTACHMENT));
	_tmp0_ = self->priv->manager;
	application_attachment_manager_save_attachment (_tmp0_, attachment, NULL, NULL, NULL, NULL);
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		ComponentsAttachmentPane* self;
		self = _data51_->self;
		_g_object_unref0 (_data51_->attachment);
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static void
__lambda99_ (Block51Data* _data51_,
             GtkWidget* child)
{
	ComponentsAttachmentPane* self;
	GtkFlowBoxChild* flow_child = NULL;
	GtkFlowBoxChild* _tmp0_;
	GtkFlowBoxChild* _tmp1_;
	GtkWidget* _tmp2_;
	GearyAttachment* _tmp3_;
	GearyAttachment* _tmp4_;
	self = _data51_->self;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, gtk_flow_box_child_get_type (), GtkFlowBoxChild));
	flow_child = _tmp0_;
	_tmp1_ = flow_child;
	_tmp2_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_bin_get_type (), GtkBin));
	_tmp3_ = components_attachment_pane_view_get_attachment (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView));
	_tmp4_ = _tmp3_;
	if (_tmp4_ == _data51_->attachment) {
		ComponentsAttachmentPaneFlowBox* _tmp5_;
		_tmp5_ = self->priv->attachments_view;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), child);
	}
	_g_object_unref0 (flow_child);
}

static void
___lambda99__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda99_ (self, widget);
}

void
components_attachment_pane_remove_attachment (ComponentsAttachmentPane* self,
                                              GearyAttachment* attachment)
{
	Block51Data* _data51_;
	GearyAttachment* _tmp0_;
	GeeList* _tmp1_;
	ComponentsAttachmentPaneFlowBox* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachment, GEARY_TYPE_ATTACHMENT));
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (attachment);
	_g_object_unref0 (_data51_->attachment);
	_data51_->attachment = _tmp0_;
	_tmp1_ = self->priv->attachments;
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), _data51_->attachment);
	_tmp2_ = self->priv->attachments_view;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer), ___lambda99__gtk_callback, _data51_);
	block51_data_unref (_data51_);
	_data51_ = NULL;
}

gboolean
components_attachment_pane_save_all (ComponentsAttachmentPane* self)
{
	gboolean ret = FALSE;
	GeeList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), FALSE);
	ret = FALSE;
	_tmp0_ = self->priv->attachments;
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GeeArrayList* all = NULL;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeList* _tmp5_;
		ApplicationAttachmentManager* _tmp6_;
		GeeArrayList* _tmp7_;
		_tmp3_ = gee_array_list_new (GEARY_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		all = _tmp3_;
		_tmp4_ = all;
		_tmp5_ = self->priv->attachments;
		gee_array_list_add_all (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = self->priv->manager;
		_tmp7_ = all;
		application_attachment_manager_save_attachments (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL, NULL);
		_g_object_unref0 (all);
	}
	result = ret;
	return result;
}

static gchar*
_variant_get5 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static GearyAttachment*
components_attachment_pane_get_attachment (ComponentsAttachmentPane* self,
                                           GVariant* param)
{
	GearyAttachment* ret = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	GearyAttachment* result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), NULL);
	g_return_val_if_fail (param != NULL, NULL);
	ret = NULL;
	_tmp0_ = _variant_get5 (param);
	path = _tmp0_;
	{
		GeeList* _attachment_list = NULL;
		GeeList* _tmp1_;
		gint _attachment_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _attachment_index = 0;
		_tmp1_ = self->priv->attachments;
		_attachment_list = _tmp1_;
		_tmp2_ = _attachment_list;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_attachment_size = _tmp4_;
		_attachment_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GearyAttachment* attachment = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GearyAttachment* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gboolean _tmp15_;
			_attachment_index = _attachment_index + 1;
			_tmp5_ = _attachment_index;
			_tmp6_ = _attachment_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _attachment_list;
			_tmp8_ = gee_list_get (_tmp7_, _attachment_index);
			attachment = (GearyAttachment*) _tmp8_;
			_tmp9_ = attachment;
			_tmp10_ = geary_attachment_get_file (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_file_get_path (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = path;
			_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
			_g_free0 (_tmp13_);
			if (_tmp15_) {
				GearyAttachment* _tmp16_;
				GearyAttachment* _tmp17_;
				_tmp16_ = attachment;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_g_object_unref0 (ret);
				ret = _tmp17_;
				_g_object_unref0 (attachment);
				break;
			}
			_g_object_unref0 (attachment);
		}
	}
	result = ret;
	_g_free0 (path);
	return result;
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		ComponentsAttachmentPane* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->selected);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static void
__lambda98_ (Block52Data* _data52_,
             GtkFlowBox* box,
             GtkFlowBoxChild* child)
{
	ComponentsAttachmentPane* self;
	GtkWidget* _tmp0_;
	GearyAttachment* _tmp1_;
	GearyAttachment* _tmp2_;
	self = _data52_->self;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (box, gtk_flow_box_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_flow_box_child_get_type ()));
	_tmp0_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (child, gtk_bin_get_type (), GtkBin));
	_tmp1_ = components_attachment_pane_view_get_attachment (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView));
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data52_->selected, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
}

static void
___lambda98__gtk_flow_box_foreach_func (GtkFlowBox* box,
                                        GtkFlowBoxChild* child,
                                        gpointer self)
{
	__lambda98_ (self, box, child);
}

static GeeCollection*
components_attachment_pane_get_selected_attachments (ComponentsAttachmentPane* self)
{
	Block52Data* _data52_;
	GeeLinkedList* _tmp0_;
	ComponentsAttachmentPaneFlowBox* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), NULL);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_tmp0_ = gee_linked_list_new (GEARY_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data52_->selected = _tmp0_;
	_tmp1_ = self->priv->attachments_view;
	gtk_flow_box_selected_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_flow_box_get_type (), GtkFlowBox), ___lambda98__gtk_flow_box_foreach_func, _data52_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data52_->selected, GEE_TYPE_COLLECTION, GeeCollection));
	result = _tmp2_;
	block52_data_unref (_data52_);
	_data52_ = NULL;
	return result;
}

static gboolean
components_attachment_pane_open_selected (ComponentsAttachmentPane* self)
{
	gboolean ret = FALSE;
	GeeCollection* selected = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), FALSE);
	ret = FALSE;
	_tmp0_ = components_attachment_pane_get_selected_attachments (self);
	selected = _tmp0_;
	_tmp1_ = selected;
	_tmp2_ = gee_collection_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GeeCollection* _tmp4_;
		_tmp4_ = selected;
		components_attachment_pane_open_attachments (self, _tmp4_);
		ret = TRUE;
	}
	result = ret;
	_g_object_unref0 (selected);
	return result;
}

static gboolean
components_attachment_pane_save_selected (ComponentsAttachmentPane* self)
{
	gboolean ret = FALSE;
	GeeCollection* selected = NULL;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), FALSE);
	ret = FALSE;
	_tmp0_ = components_attachment_pane_get_selected_attachments (self);
	selected = _tmp0_;
	_tmp2_ = self->priv->_edit_mode;
	if (!_tmp2_) {
		GeeCollection* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = selected;
		_tmp4_ = gee_collection_get_is_empty (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ApplicationAttachmentManager* _tmp6_;
		GeeCollection* _tmp7_;
		_tmp6_ = self->priv->manager;
		_tmp7_ = selected;
		application_attachment_manager_save_attachments (_tmp6_, _tmp7_, NULL, NULL, NULL);
		ret = TRUE;
	}
	result = ret;
	_g_object_unref0 (selected);
	return result;
}

static void
___lambda100_ (ComponentsAttachmentPane* self,
               GtkFlowBoxChild* child)
{
	ComponentsAttachmentPaneFlowBox* _tmp0_;
	GeeList* _tmp1_;
	GtkWidget* _tmp2_;
	GearyAttachment* _tmp3_;
	GearyAttachment* _tmp4_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_flow_box_child_get_type ()));
	_tmp0_ = self->priv->attachments_view;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (child, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->attachments;
	_tmp2_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (child, gtk_bin_get_type (), GtkBin));
	_tmp3_ = components_attachment_pane_view_get_attachment (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView));
	_tmp4_ = _tmp3_;
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), _tmp4_);
}

static void
____lambda100__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda100_ ((ComponentsAttachmentPane*) self, (GtkFlowBoxChild*) data);
}

static gboolean
components_attachment_pane_remove_selected (ComponentsAttachmentPane* self)
{
	gboolean ret = FALSE;
	GList* children = NULL;
	ComponentsAttachmentPaneFlowBox* _tmp0_;
	GList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), FALSE);
	ret = FALSE;
	_tmp0_ = self->priv->attachments_view;
	_tmp1_ = gtk_flow_box_get_selected_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_flow_box_get_type (), GtkFlowBox));
	children = _tmp1_;
	_tmp3_ = self->priv->_edit_mode;
	if (_tmp3_) {
		GList* _tmp4_;
		_tmp4_ = children;
		_tmp2_ = g_list_length (_tmp4_) > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GList* _tmp5_;
		_tmp5_ = children;
		g_list_foreach (_tmp5_, ____lambda100__gfunc, self);
		ret = TRUE;
	}
	result = ret;
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

static void
components_attachment_pane_update_actions (ComponentsAttachmentPane* self)
{
	guint len = 0U;
	ComponentsAttachmentPaneFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	gboolean not_empty = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	_tmp0_ = self->priv->attachments_view;
	_tmp1_ = gtk_flow_box_get_selected_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_flow_box_get_type (), GtkFlowBox));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	len = _tmp3_;
	not_empty = len > ((guint) 0);
	components_attachment_pane_set_action_enabled (self, COMPONENTS_ATTACHMENT_PANE_ACTION_OPEN_SELECTED, not_empty);
	if (not_empty) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_edit_mode;
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	components_attachment_pane_set_action_enabled (self, COMPONENTS_ATTACHMENT_PANE_ACTION_REMOVE_SELECTED, _tmp4_);
	if (not_empty) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_edit_mode;
		_tmp6_ = !_tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	components_attachment_pane_set_action_enabled (self, COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE_SELECTED, _tmp6_);
	_tmp8_ = self->priv->attachments;
	_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp10_ = _tmp9_;
	components_attachment_pane_set_action_enabled (self, COMPONENTS_ATTACHMENT_PANE_ACTION_SELECT_ALL, len < ((guint) _tmp10_));
}

static void
components_attachment_pane_open_attachments (ComponentsAttachmentPane* self,
                                             GeeCollection* attachments)
{
	ApplicationMainWindow* main = NULL;
	GtkWidget* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments, GEE_TYPE_COLLECTION));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp0_) ? ((ApplicationMainWindow*) _tmp0_) : NULL);
	main = _tmp1_;
	_tmp2_ = main;
	if (_tmp2_ != NULL) {
		ApplicationClient* app = NULL;
		ApplicationMainWindow* _tmp3_;
		ApplicationClient* _tmp4_;
		ApplicationClient* _tmp5_;
		ApplicationClient* _tmp6_;
		gboolean confirmed = FALSE;
		ApplicationClient* _tmp7_;
		ApplicationConfiguration* _tmp8_;
		ApplicationConfiguration* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp3_ = main;
		_tmp4_ = application_main_window_get_application (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		app = _tmp6_;
		confirmed = TRUE;
		_tmp7_ = app;
		_tmp8_ = application_client_get_config (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = application_configuration_get_ask_open_attachment (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			QuestionDialog* ask_to_open = NULL;
			ApplicationMainWindow* _tmp12_;
			QuestionDialog* _tmp13_;
			QuestionDialog* _tmp14_;
			_tmp12_ = main;
			_tmp13_ = question_dialog_new_with_checkbox (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_window_get_type (), GtkWindow), _ ("Are you sure you want to open these attachments?"), _ ("Attachments may cause damage to your system if opened.  Only open file" \
"s from trusted sources."), STOCK__OPEN_BUTTON, STOCK__CANCEL, _ ("Don’t _ask me again"), FALSE);
			ask_to_open = _tmp13_;
			_tmp14_ = ask_to_open;
			if (alert_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_ALERT_DIALOG, AlertDialog)) == GTK_RESPONSE_OK) {
				ApplicationClient* _tmp15_;
				ApplicationConfiguration* _tmp16_;
				ApplicationConfiguration* _tmp17_;
				QuestionDialog* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp15_ = app;
				_tmp16_ = application_client_get_config (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = ask_to_open;
				_tmp19_ = question_dialog_get_is_checked (_tmp18_);
				_tmp20_ = _tmp19_;
				application_configuration_set_ask_open_attachment (_tmp17_, !_tmp20_);
			} else {
				confirmed = FALSE;
			}
			_g_object_unref0 (ask_to_open);
		}
		if (confirmed) {
			{
				GeeIterator* _attachment_it = NULL;
				GeeIterator* _tmp21_;
				_tmp21_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (attachments, GEE_TYPE_ITERABLE, GeeIterable));
				_attachment_it = _tmp21_;
				while (TRUE) {
					GeeIterator* _tmp22_;
					GearyAttachment* attachment = NULL;
					GeeIterator* _tmp23_;
					gpointer _tmp24_;
					ApplicationClient* _tmp25_;
					GearyAttachment* _tmp26_;
					GFile* _tmp27_;
					GFile* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp22_ = _attachment_it;
					if (!gee_iterator_next (_tmp22_)) {
						break;
					}
					_tmp23_ = _attachment_it;
					_tmp24_ = gee_iterator_get (_tmp23_);
					attachment = (GearyAttachment*) _tmp24_;
					_tmp25_ = app;
					_tmp26_ = attachment;
					_tmp27_ = geary_attachment_get_file (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_file_get_uri (_tmp28_);
					_tmp30_ = _tmp29_;
					application_client_show_uri (_tmp25_, _tmp30_, NULL, NULL);
					_g_free0 (_tmp30_);
					_g_object_unref0 (attachment);
				}
				_g_object_unref0 (_attachment_it);
			}
		}
		_g_object_unref0 (app);
	}
	_g_object_unref0 (main);
}

static void
components_attachment_pane_set_action_enabled (ComponentsAttachmentPane* self,
                                               const gchar* name,
                                               gboolean enabled)
{
	GSimpleAction* action = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), name);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp1_) : NULL);
	action = _tmp2_;
	_tmp3_ = action;
	if (_tmp3_ != NULL) {
		GSimpleAction* _tmp4_;
		_tmp4_ = action;
		g_simple_action_set_enabled (_tmp4_, enabled);
	}
	_g_object_unref0 (action);
}

static GVariant*
_variant_new4 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
components_attachment_pane_show_popup (ComponentsAttachmentPane* self,
                                       ComponentsAttachmentPaneView* view,
                                       GdkEventButton* event)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GeeHashMap* targets = NULL;
	GeeHashMap* _tmp1_;
	GVariant* target = NULL;
	GearyAttachment* _tmp2_;
	GearyAttachment* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GeeHashMap* _tmp10_;
	GVariant* _tmp11_;
	GeeHashMap* _tmp12_;
	GVariant* _tmp13_;
	GeeHashMap* _tmp14_;
	GVariant* _tmp15_;
	GMenu* model = NULL;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_;
	GeeHashMap* _tmp18_;
	GMenu* _tmp19_;
	GtkMenu* menu = NULL;
	GMenu* _tmp20_;
	GtkMenu* _tmp21_;
	GtkMenu* _tmp22_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (COMPONENTS_ATTACHMENT_PANE_IS_VIEW (view));
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Geary/components-attachment-pane-menus.ui");
	builder = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_VARIANT, (GBoxedCopyFunc) g_variant_ref, (GDestroyNotify) g_variant_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	targets = _tmp1_;
	_tmp2_ = components_attachment_pane_view_get_attachment (view);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_attachment_get_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _variant_new4 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	target = _tmp9_;
	_tmp10_ = targets;
	_tmp11_ = target;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), COMPONENTS_ATTACHMENT_PANE_ACTION_OPEN, _tmp11_);
	_tmp12_ = targets;
	_tmp13_ = target;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), COMPONENTS_ATTACHMENT_PANE_ACTION_REMOVE, _tmp13_);
	_tmp14_ = targets;
	_tmp15_ = target;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), COMPONENTS_ATTACHMENT_PANE_ACTION_SAVE, _tmp15_);
	_tmp16_ = builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "attachments_menu");
	_tmp18_ = targets;
	_tmp19_ = util_gtk_copy_menu_with_targets (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_menu_get_type (), GMenu), COMPONENTS_ATTACHMENT_PANE_GROUP_NAME, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_MAP, GeeMap));
	model = _tmp19_;
	_tmp20_ = model;
	_tmp21_ = (GtkMenu*) gtk_menu_new_from_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_menu_model_get_type (), GMenuModel));
	g_object_ref_sink (_tmp21_);
	menu = _tmp21_;
	_tmp22_ = menu;
	gtk_menu_attach_to_widget (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (view, gtk_widget_get_type (), GtkWidget), NULL);
	if (event != NULL) {
		GtkMenu* _tmp23_;
		_tmp23_ = menu;
		gtk_menu_popup_at_pointer (_tmp23_, (GdkEvent*) event);
	} else {
		GtkMenu* _tmp24_;
		_tmp24_ = menu;
		gtk_menu_popup_at_widget (_tmp24_, G_TYPE_CHECK_INSTANCE_CAST (view, gtk_widget_get_type (), GtkWidget), GDK_GRAVITY_CENTER, GDK_GRAVITY_SOUTH, NULL);
	}
	_g_object_unref0 (menu);
	_g_object_unref0 (model);
	_g_variant_unref0 (target);
	_g_object_unref0 (targets);
	_g_object_unref0 (builder);
}

static void
components_attachment_pane_beep (ComponentsAttachmentPane* self)
{
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	toplevel = _tmp1_;
	_tmp2_ = toplevel;
	if (_tmp2_ == NULL) {
		GdkWindow* window = NULL;
		GtkWidget* _tmp3_;
		GdkWindow* _tmp4_;
		GdkWindow* _tmp5_;
		GdkWindow* _tmp6_;
		_tmp3_ = toplevel;
		_tmp4_ = gtk_widget_get_window (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		window = _tmp5_;
		_tmp6_ = window;
		if (_tmp6_ != NULL) {
			GdkWindow* _tmp7_;
			_tmp7_ = window;
			gdk_window_beep (_tmp7_);
		}
		_g_object_unref0 (window);
	}
	_g_object_unref0 (toplevel);
}

static void
components_attachment_pane_on_open (ComponentsAttachmentPane* self,
                                    GSimpleAction* action,
                                    GVariant* param)
{
	GearyAttachment* target = NULL;
	GearyAttachment* _tmp0_;
	GearyAttachment* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = components_attachment_pane_get_attachment (self, param);
	target = _tmp0_;
	_tmp1_ = target;
	if (_tmp1_ != NULL) {
		GearyAttachment* _tmp2_;
		_tmp2_ = target;
		components_attachment_pane_open_attachment (self, _tmp2_);
	}
	_g_object_unref0 (target);
}

static void
components_attachment_pane_on_open_selected (ComponentsAttachmentPane* self)
{
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	if (!components_attachment_pane_open_selected (self)) {
		components_attachment_pane_beep (self);
	}
}

static void
components_attachment_pane_on_save (ComponentsAttachmentPane* self,
                                    GSimpleAction* action,
                                    GVariant* param)
{
	GearyAttachment* target = NULL;
	GearyAttachment* _tmp0_;
	GearyAttachment* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = components_attachment_pane_get_attachment (self, param);
	target = _tmp0_;
	_tmp1_ = target;
	if (_tmp1_ != NULL) {
		GearyAttachment* _tmp2_;
		_tmp2_ = target;
		components_attachment_pane_save_attachment (self, _tmp2_);
	}
	_g_object_unref0 (target);
}

static void
components_attachment_pane_on_save_all (ComponentsAttachmentPane* self)
{
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	if (!components_attachment_pane_save_all (self)) {
		components_attachment_pane_beep (self);
	}
}

static void
components_attachment_pane_on_save_selected (ComponentsAttachmentPane* self)
{
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	if (!components_attachment_pane_save_selected (self)) {
		components_attachment_pane_beep (self);
	}
}

static void
components_attachment_pane_on_remove (ComponentsAttachmentPane* self,
                                      GSimpleAction* action,
                                      GVariant* param)
{
	GearyAttachment* target = NULL;
	GearyAttachment* _tmp0_;
	GearyAttachment* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = components_attachment_pane_get_attachment (self, param);
	target = _tmp0_;
	_tmp1_ = target;
	if (_tmp1_ != NULL) {
		GearyAttachment* _tmp2_;
		_tmp2_ = target;
		components_attachment_pane_remove_attachment (self, _tmp2_);
	}
	_g_object_unref0 (target);
}

static void
components_attachment_pane_on_remove_selected (ComponentsAttachmentPane* self)
{
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	if (!components_attachment_pane_remove_selected (self)) {
		components_attachment_pane_beep (self);
	}
}

static void
components_attachment_pane_on_select_all (ComponentsAttachmentPane* self)
{
	ComponentsAttachmentPaneFlowBox* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	_tmp0_ = self->priv->attachments_view;
	gtk_flow_box_select_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_flow_box_get_type (), GtkFlowBox));
}

static void
components_attachment_pane_on_child_activated (ComponentsAttachmentPane* self)
{
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	components_attachment_pane_open_selected (self);
}

static void
components_attachment_pane_on_selected_changed (ComponentsAttachmentPane* self)
{
	g_return_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self));
	components_attachment_pane_update_actions (self);
}

static gboolean
components_attachment_pane_on_attachment_popup_menu (ComponentsAttachmentPane* self,
                                                     GtkWidget* widget)
{
	gboolean ret = FALSE;
	GtkWindow* parent = NULL;
	GtkWidget* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), FALSE);
	ret = GDK_EVENT_PROPAGATE;
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL);
	parent = _tmp1_;
	_tmp2_ = parent;
	if (_tmp2_ != NULL) {
		GtkFlowBoxChild* focus = NULL;
		GtkWindow* _tmp3_;
		GtkWidget* _tmp4_;
		GtkFlowBoxChild* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GtkFlowBoxChild* _tmp7_;
		_tmp3_ = parent;
		_tmp4_ = gtk_window_get_focus (_tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) _tmp4_) : NULL);
		focus = _tmp5_;
		_tmp7_ = focus;
		if (_tmp7_ != NULL) {
			GtkFlowBoxChild* _tmp8_;
			GtkContainer* _tmp9_;
			GtkContainer* _tmp10_;
			ComponentsAttachmentPaneFlowBox* _tmp11_;
			_tmp8_ = focus;
			_tmp9_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->attachments_view;
			_tmp6_ = _tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_container_get_type (), GtkContainer);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkFlowBoxChild* _tmp12_;
			GtkWidget* _tmp13_;
			_tmp12_ = focus;
			_tmp13_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_bin_get_type (), GtkBin));
			components_attachment_pane_show_popup (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView), NULL);
			ret = GDK_EVENT_STOP;
		}
		_g_object_unref0 (focus);
	}
	result = ret;
	_g_object_unref0 (parent);
	return result;
}

static gboolean
components_attachment_pane_on_attachment_button_press (ComponentsAttachmentPane* self,
                                                       GtkWidget* widget,
                                                       GdkEventButton* event)
{
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_ATTACHMENT_PANE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	ret = GDK_EVENT_PROPAGATE;
	if (gdk_event_triggers_context_menu ((GdkEvent*) event)) {
		GtkFlowBoxChild* child = NULL;
		ComponentsAttachmentPaneFlowBox* _tmp0_;
		GtkFlowBoxChild* _tmp1_;
		GtkFlowBoxChild* _tmp2_;
		GtkFlowBoxChild* _tmp3_;
		_tmp0_ = self->priv->attachments_view;
		_tmp1_ = gtk_flow_box_get_child_at_pos (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_flow_box_get_type (), GtkFlowBox), (gint) event->x, (gint) event->y);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		child = _tmp2_;
		_tmp3_ = child;
		if (_tmp3_ != NULL) {
			GtkFlowBoxChild* _tmp4_;
			GtkWidget* _tmp5_;
			_tmp4_ = child;
			_tmp5_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_bin_get_type (), GtkBin));
			components_attachment_pane_show_popup (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView), event);
			ret = GDK_EVENT_STOP;
		}
		_g_object_unref0 (child);
	}
	result = ret;
	return result;
}

static ComponentsAttachmentPaneFlowBox*
components_attachment_pane_flow_box_construct (GType object_type)
{
	ComponentsAttachmentPaneFlowBox * self = NULL;
	self = (ComponentsAttachmentPaneFlowBox*) g_object_new (object_type, NULL);
	return self;
}

static ComponentsAttachmentPaneFlowBox*
components_attachment_pane_flow_box_new (void)
{
	return components_attachment_pane_flow_box_construct (COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX);
}

static void
components_attachment_pane_flow_box_class_init (ComponentsAttachmentPaneFlowBoxClass * klass,
                                                gpointer klass_data)
{
	components_attachment_pane_flow_box_parent_class = g_type_class_peek_parent (klass);
	/** Keyboard action to open the currently selected attachments. */
	components_attachment_pane_flow_box_signals[COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_OPEN_ATTACHMENTS_SIGNAL] = g_signal_new ("open-attachments", COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keyboard action to save the currently selected attachments. */
	components_attachment_pane_flow_box_signals[COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_SAVE_ATTACHMENTS_SIGNAL] = g_signal_new ("save-attachments", COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keyboard action to remove the currently selected attachments. */
	components_attachment_pane_flow_box_signals[COMPONENTS_ATTACHMENT_PANE_FLOW_BOX_REMOVE_ATTACHMENTS_SIGNAL] = g_signal_new ("remove-attachments", COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
components_attachment_pane_flow_box_instance_init (ComponentsAttachmentPaneFlowBox * self,
                                                   gpointer klass)
{
}

static GType
components_attachment_pane_flow_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsAttachmentPaneFlowBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_attachment_pane_flow_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsAttachmentPaneFlowBox), 0, (GInstanceInitFunc) components_attachment_pane_flow_box_instance_init, NULL };
	GType components_attachment_pane_flow_box_type_id;
	components_attachment_pane_flow_box_type_id = g_type_register_static (gtk_flow_box_get_type (), "ComponentsAttachmentPaneFlowBox", &g_define_type_info, 0);
	return components_attachment_pane_flow_box_type_id;
}

static GType
components_attachment_pane_flow_box_get_type (void)
{
	static volatile gsize components_attachment_pane_flow_box_type_id__once = 0;
	if (g_once_init_enter (&components_attachment_pane_flow_box_type_id__once)) {
		GType components_attachment_pane_flow_box_type_id;
		components_attachment_pane_flow_box_type_id = components_attachment_pane_flow_box_get_type_once ();
		g_once_init_leave (&components_attachment_pane_flow_box_type_id__once, components_attachment_pane_flow_box_type_id);
	}
	return components_attachment_pane_flow_box_type_id__once;
}

static inline gpointer
components_attachment_pane_view_get_instance_private (ComponentsAttachmentPaneView* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsAttachmentPaneView_private_offset);
}

static GearyAttachment*
components_attachment_pane_view_get_attachment (ComponentsAttachmentPaneView* self)
{
	GearyAttachment* result;
	GearyAttachment* _tmp0_;
	g_return_val_if_fail (COMPONENTS_ATTACHMENT_PANE_IS_VIEW (self), NULL);
	_tmp0_ = self->priv->_attachment;
	result = _tmp0_;
	return result;
}

static void
components_attachment_pane_view_set_attachment (ComponentsAttachmentPaneView* self,
                                                GearyAttachment* value)
{
	GearyAttachment* old_value;
	g_return_if_fail (COMPONENTS_ATTACHMENT_PANE_IS_VIEW (self));
	old_value = components_attachment_pane_view_get_attachment (self);
	if (old_value != value) {
		GearyAttachment* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_attachment);
		self->priv->_attachment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, components_attachment_pane_view_properties[COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PROPERTY]);
	}
}

static ComponentsAttachmentPaneView*
components_attachment_pane_view_construct (GType object_type,
                                           GearyAttachment* attachment)
{
	ComponentsAttachmentPaneView * self = NULL;
	gchar* mime_content_type = NULL;
	GearyMimeContentType* _tmp0_;
	GearyMimeContentType* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* file_name = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* file_desc = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* file_size = NULL;
	gint64 _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	GtkLabel* _tmp25_;
	const gchar* _tmp26_;
	GtkLabel* _tmp27_;
	const gchar* _tmp28_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachment, GEARY_TYPE_ATTACHMENT), NULL);
	self = (ComponentsAttachmentPaneView*) g_object_new (object_type, NULL);
	components_attachment_pane_view_set_attachment (self, attachment);
	_tmp0_ = geary_attachment_get_content_type (attachment);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_mime_content_type_get_mime_type (_tmp1_);
	mime_content_type = _tmp2_;
	_tmp3_ = mime_content_type;
	_tmp4_ = g_content_type_from_mime_type (_tmp3_);
	_g_free0 (self->priv->gio_content_type);
	self->priv->gio_content_type = _tmp4_;
	_tmp5_ = geary_attachment_get_content_filename (attachment);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	file_name = _tmp7_;
	_tmp8_ = self->priv->gio_content_type;
	_tmp9_ = g_content_type_get_description (_tmp8_);
	file_desc = _tmp9_;
	_tmp10_ = self->priv->gio_content_type;
	if (g_content_type_is_unknown (_tmp10_)) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup (_ ("Unknown"));
		_g_free0 (file_desc);
		file_desc = _tmp11_;
	}
	_tmp12_ = geary_attachment_get_filesize (attachment);
	_tmp13_ = _tmp12_;
	_tmp14_ = files_get_filesize_as_string (_tmp13_);
	file_size = _tmp14_;
	_tmp15_ = file_name;
	if (geary_string_is_empty (_tmp15_)) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = file_desc;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (file_name);
		file_name = _tmp17_;
		_tmp18_ = file_size;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (file_desc);
		file_desc = _tmp19_;
	} else {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp20_ = file_desc;
		_tmp21_ = file_size;
		_tmp22_ = g_strdup_printf ("%s (%s)", _tmp20_, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup (_ (_tmp23_));
		_g_free0 (file_desc);
		file_desc = _tmp24_;
		_g_free0 (_tmp23_);
	}
	_tmp25_ = self->priv->filename;
	_tmp26_ = file_name;
	gtk_label_set_text (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->description;
	_tmp28_ = file_desc;
	gtk_label_set_text (_tmp27_, _tmp28_);
	_g_free0 (file_size);
	_g_free0 (file_desc);
	_g_free0 (file_name);
	_g_free0 (mime_content_type);
	return self;
}

static ComponentsAttachmentPaneView*
components_attachment_pane_view_new (GearyAttachment* attachment)
{
	return components_attachment_pane_view_construct (COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, attachment);
}

static void
components_attachment_pane_view_load_icon_data_free (gpointer _data)
{
	ComponentsAttachmentPaneViewLoadIconData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->load_cancelled);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsAttachmentPaneViewLoadIconData, _data_);
}

static void
components_attachment_pane_view_load_icon (ComponentsAttachmentPaneView* self,
                                           GCancellable* load_cancelled,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	ComponentsAttachmentPaneViewLoadIconData* _data_;
	ComponentsAttachmentPaneView* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (COMPONENTS_ATTACHMENT_PANE_IS_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (load_cancelled, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ComponentsAttachmentPaneViewLoadIconData);
	_data_->_async_result = g_task_new (G_OBJECT (self), load_cancelled, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_attachment_pane_view_load_icon_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (load_cancelled);
	_g_object_unref0 (_data_->load_cancelled);
	_data_->load_cancelled = _tmp1_;
	components_attachment_pane_view_load_icon_co (_data_);
}

static void
components_attachment_pane_view_load_icon_finish (ComponentsAttachmentPaneView* self,
                                                  GAsyncResult* _res_)
{
	ComponentsAttachmentPaneViewLoadIconData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
components_attachment_pane_view_load_icon_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	ComponentsAttachmentPaneViewLoadIconData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_attachment_pane_view_load_icon_co (_data_);
}

static gboolean
components_attachment_pane_view_load_icon_co (ComponentsAttachmentPaneViewLoadIconData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_cancellable_is_cancelled (_data_->load_cancelled)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->pixbuf = NULL;
	_data_->window_scale = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	{
		_data_->_tmp0_ = _data_->self->priv->_attachment;
		_data_->_tmp1_ = geary_attachment_get_content_type (_data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		if (geary_mime_content_type_has_media_type (_data_->_tmp2_, "image")) {
			_data_->preview_size = COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PREVIEW_SIZE * _data_->window_scale;
			_data_->_tmp3_ = _data_->self->priv->_attachment;
			_data_->_tmp4_ = geary_attachment_get_file (_data_->_tmp3_);
			_data_->_tmp5_ = _data_->_tmp4_;
			_data_->_state_ = 1;
			g_file_read_async (_data_->_tmp5_, G_PRIORITY_DEFAULT, _data_->load_cancelled, components_attachment_pane_view_load_icon_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = g_file_read_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
			_data_->stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_input_stream_get_type (), GInputStream);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->stream;
			_data_->_state_ = 2;
			gdk_pixbuf_new_from_stream_at_scale_async (_data_->_tmp8_, _data_->preview_size, _data_->preview_size, TRUE, _data_->load_cancelled, components_attachment_pane_view_load_icon_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp9_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp7_ = _data_->_tmp9_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->stream);
				goto __catch0_g_error;
			}
			_data_->_tmp10_ = _data_->_tmp7_;
			_data_->_tmp7_ = NULL;
			_g_object_unref0 (_data_->pixbuf);
			_data_->pixbuf = _data_->_tmp10_;
			_data_->_tmp11_ = _data_->pixbuf;
			_data_->_tmp12_ = gdk_pixbuf_apply_embedded_orientation (_data_->_tmp11_);
			_g_object_unref0 (_data_->pixbuf);
			_data_->pixbuf = _data_->_tmp12_;
			_g_object_unref0 (_data_->_tmp7_);
			_g_object_unref0 (_data_->stream);
		} else {
			_data_->_tmp13_ = _data_->self->priv->gio_content_type;
			_data_->_tmp14_ = g_content_type_get_icon (_data_->_tmp13_);
			_data_->icon = _data_->_tmp14_;
			_data_->_tmp15_ = gtk_icon_theme_get_default ();
			_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
			_data_->theme = _data_->_tmp16_;
			_data_->flags = GTK_ICON_LOOKUP_DIR_LTR;
			if (gtk_widget_get_direction (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget)) == GTK_TEXT_DIR_RTL) {
				_data_->flags = GTK_ICON_LOOKUP_DIR_RTL;
			}
			_data_->_tmp17_ = _data_->theme;
			_data_->_tmp18_ = _data_->icon;
			_data_->_tmp19_ = gtk_icon_theme_lookup_by_gicon_for_scale (_data_->_tmp17_, _data_->_tmp18_, COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_ICON_SIZE, _data_->window_scale, _data_->flags);
			_data_->icon_info = _data_->_tmp19_;
			_data_->_tmp20_ = _data_->icon_info;
			if (_data_->_tmp20_ != NULL) {
				_data_->_tmp22_ = _data_->icon_info;
				_data_->_state_ = 3;
				gtk_icon_info_load_icon_async (_data_->_tmp22_, _data_->load_cancelled, components_attachment_pane_view_load_icon_ready, _data_);
				return FALSE;
				_state_3:
				_data_->_tmp23_ = gtk_icon_info_load_icon_finish (_data_->_tmp22_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp21_ = _data_->_tmp23_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->icon_info);
					_g_object_unref0 (_data_->theme);
					_g_object_unref0 (_data_->icon);
					goto __catch0_g_error;
				}
				_data_->_tmp24_ = _data_->_tmp21_;
				_data_->_tmp21_ = NULL;
				_g_object_unref0 (_data_->pixbuf);
				_data_->pixbuf = _data_->_tmp24_;
				_g_object_unref0 (_data_->_tmp21_);
			}
			_g_object_unref0 (_data_->icon_info);
			_g_object_unref0 (_data_->theme);
			_g_object_unref0 (_data_->icon);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp25_ = _data_->self->priv->_attachment;
		_data_->_tmp26_ = geary_attachment_get_file (_data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = g_file_get_path (_data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = _data_->_error_;
		_data_->_tmp31_ = _data_->_tmp30_->message;
		g_debug ("components-attachment-pane.vala:156: Failed to load icon for attachmen" \
"t '%s': %s", _data_->_tmp29_, _data_->_tmp31_);
		_g_free0 (_data_->_tmp29_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->pixbuf;
	if (_data_->_tmp32_ != NULL) {
		_data_->_tmp33_ = _data_->pixbuf;
		_data_->_tmp34_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
		_data_->_tmp35_ = gdk_cairo_surface_create_from_pixbuf (_data_->_tmp33_, _data_->window_scale, _data_->_tmp34_);
		_data_->surface = _data_->_tmp35_;
		_data_->_tmp36_ = _data_->self->priv->icon;
		_data_->_tmp37_ = _data_->surface;
		gtk_image_set_from_surface (_data_->_tmp36_, _data_->_tmp37_);
		_cairo_surface_destroy0 (_data_->surface);
	}
	_g_object_unref0 (_data_->pixbuf);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
components_attachment_pane_view_class_init (ComponentsAttachmentPaneViewClass * klass,
                                            gpointer klass_data)
{
	components_attachment_pane_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsAttachmentPaneView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_components_attachment_pane_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_attachment_pane_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_attachment_pane_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PROPERTY, components_attachment_pane_view_properties[COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PROPERTY] = g_param_spec_object ("attachment", "attachment", "attachment", GEARY_TYPE_ATTACHMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-attachment-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "icon", FALSE, ComponentsAttachmentPaneView_private_offset + G_STRUCT_OFFSET (ComponentsAttachmentPaneViewPrivate, icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filename", FALSE, ComponentsAttachmentPaneView_private_offset + G_STRUCT_OFFSET (ComponentsAttachmentPaneViewPrivate, filename));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description", FALSE, ComponentsAttachmentPaneView_private_offset + G_STRUCT_OFFSET (ComponentsAttachmentPaneViewPrivate, description));
}

static void
components_attachment_pane_view_instance_init (ComponentsAttachmentPaneView * self,
                                               gpointer klass)
{
	self->priv = components_attachment_pane_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_attachment_pane_view_finalize (GObject * obj)
{
	ComponentsAttachmentPaneView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView);
	_g_object_unref0 (self->priv->_attachment);
	_g_free0 (self->priv->gio_content_type);
	G_OBJECT_CLASS (components_attachment_pane_view_parent_class)->finalize (obj);
}

static GType
components_attachment_pane_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsAttachmentPaneViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_attachment_pane_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsAttachmentPaneView), 0, (GInstanceInitFunc) components_attachment_pane_view_instance_init, NULL };
	GType components_attachment_pane_view_type_id;
	components_attachment_pane_view_type_id = g_type_register_static (gtk_grid_get_type (), "ComponentsAttachmentPaneView", &g_define_type_info, 0);
	ComponentsAttachmentPaneView_private_offset = g_type_add_instance_private (components_attachment_pane_view_type_id, sizeof (ComponentsAttachmentPaneViewPrivate));
	return components_attachment_pane_view_type_id;
}

static GType
components_attachment_pane_view_get_type (void)
{
	static volatile gsize components_attachment_pane_view_type_id__once = 0;
	if (g_once_init_enter (&components_attachment_pane_view_type_id__once)) {
		GType components_attachment_pane_view_type_id;
		components_attachment_pane_view_type_id = components_attachment_pane_view_get_type_once ();
		g_once_init_leave (&components_attachment_pane_view_type_id__once, components_attachment_pane_view_type_id);
	}
	return components_attachment_pane_view_type_id__once;
}

static void
_vala_components_attachment_pane_view_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	ComponentsAttachmentPaneView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView);
	switch (property_id) {
		case COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PROPERTY:
		g_value_set_object (value, components_attachment_pane_view_get_attachment (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_attachment_pane_view_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	ComponentsAttachmentPaneView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_ATTACHMENT_PANE_TYPE_VIEW, ComponentsAttachmentPaneView);
	switch (property_id) {
		case COMPONENTS_ATTACHMENT_PANE_VIEW_ATTACHMENT_PROPERTY:
		components_attachment_pane_view_set_attachment (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
components_attachment_pane_class_init (ComponentsAttachmentPaneClass * klass,
                                       gpointer klass_data)
{
	GtkBindingSet* bindings = NULL;
	GTypeClass* _tmp0_;
	GObjectClass* _tmp1_;
	GtkBindingSet* _tmp2_;
	GtkBindingSet* _tmp3_;
	GtkBindingSet* _tmp4_;
	GtkBindingSet* _tmp5_;
	GtkBindingSet* _tmp6_;
	GtkBindingSet* _tmp7_;
	GtkBindingSet* _tmp8_;
	components_attachment_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsAttachmentPane_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_components_attachment_pane_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_attachment_pane_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_attachment_pane_finalize;
	/** Determines if this pane's contents can be modified. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_ATTACHMENT_PANE_EDIT_MODE_PROPERTY, components_attachment_pane_properties[COMPONENTS_ATTACHMENT_PANE_EDIT_MODE_PROPERTY] = g_param_spec_boolean ("edit-mode", "edit-mode", "edit-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-attachment-pane.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "attachments_container", FALSE, ComponentsAttachmentPane_private_offset + G_STRUCT_OFFSET (ComponentsAttachmentPanePrivate, attachments_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, ComponentsAttachmentPane_private_offset + G_STRUCT_OFFSET (ComponentsAttachmentPanePrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_button", FALSE, ComponentsAttachmentPane_private_offset + G_STRUCT_OFFSET (ComponentsAttachmentPanePrivate, remove_button));
	_tmp0_ = g_type_class_ref (COMPONENTS_ATTACHMENT_PANE_TYPE_FLOW_BOX);
	_tmp1_ = (GObjectClass*) _tmp0_;
	_tmp2_ = gtk_binding_set_by_class ((gpointer) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_type_class_unref0 (_tmp1_);
	bindings = _tmp3_;
	_tmp4_ = bindings;
	gtk_binding_entry_add_signal (_tmp4_, GDK_KEY_O, GDK_CONTROL_MASK, "open-attachments", (guint) 0, NULL);
	_tmp5_ = bindings;
	gtk_binding_entry_add_signal (_tmp5_, GDK_KEY_S, GDK_CONTROL_MASK, "save-attachments", (guint) 0, NULL);
	_tmp6_ = bindings;
	gtk_binding_entry_add_signal (_tmp6_, GDK_KEY_BackSpace, 0, "remove-attachments", (guint) 0, NULL);
	_tmp7_ = bindings;
	gtk_binding_entry_add_signal (_tmp7_, GDK_KEY_Delete, 0, "remove-attachments", (guint) 0, NULL);
	_tmp8_ = bindings;
	gtk_binding_entry_add_signal (_tmp8_, GDK_KEY_KP_Delete, 0, "remove-attachments", (guint) 0, NULL);
}

static void
components_attachment_pane_instance_init (ComponentsAttachmentPane * self,
                                          gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	self->priv = components_attachment_pane_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (GEARY_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->attachments = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = g_simple_action_group_new ();
	self->priv->actions = _tmp1_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_attachment_pane_finalize (GObject * obj)
{
	ComponentsAttachmentPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_ATTACHMENT_PANE, ComponentsAttachmentPane);
	_g_object_unref0 (self->priv->attachments);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->attachments_view);
	G_OBJECT_CLASS (components_attachment_pane_parent_class)->finalize (obj);
}

/**
 * Displays the attachment parts for an email.
 *
 * This can be used in an editable or non-editable context, the UI
 * shown will differ slightly based on which is selected.
 */
static GType
components_attachment_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsAttachmentPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_attachment_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsAttachmentPane), 0, (GInstanceInitFunc) components_attachment_pane_instance_init, NULL };
	GType components_attachment_pane_type_id;
	components_attachment_pane_type_id = g_type_register_static (gtk_grid_get_type (), "ComponentsAttachmentPane", &g_define_type_info, 0);
	ComponentsAttachmentPane_private_offset = g_type_add_instance_private (components_attachment_pane_type_id, sizeof (ComponentsAttachmentPanePrivate));
	return components_attachment_pane_type_id;
}

GType
components_attachment_pane_get_type (void)
{
	static volatile gsize components_attachment_pane_type_id__once = 0;
	if (g_once_init_enter (&components_attachment_pane_type_id__once)) {
		GType components_attachment_pane_type_id;
		components_attachment_pane_type_id = components_attachment_pane_get_type_once ();
		g_once_init_leave (&components_attachment_pane_type_id__once, components_attachment_pane_type_id);
	}
	return components_attachment_pane_type_id__once;
}

static void
_vala_components_attachment_pane_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ComponentsAttachmentPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_ATTACHMENT_PANE, ComponentsAttachmentPane);
	switch (property_id) {
		case COMPONENTS_ATTACHMENT_PANE_EDIT_MODE_PROPERTY:
		g_value_set_boolean (value, components_attachment_pane_get_edit_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_attachment_pane_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ComponentsAttachmentPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_ATTACHMENT_PANE, ComponentsAttachmentPane);
	switch (property_id) {
		case COMPONENTS_ATTACHMENT_PANE_EDIT_MODE_PROPERTY:
		components_attachment_pane_set_edit_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

