/* conversation-list-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from conversation-list-view.vala, do not modify */

/*
 * Copyright © 2022 John Renner <john@jrenner.net>
 * Copyright © 2022 Cédric Bellegarde <cedric.bellegarde@adishatz.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define CONVERSATION_LIST_TYPE_ROW (conversation_list_row_get_type ())
#define CONVERSATION_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONVERSATION_LIST_TYPE_ROW, ConversationListRow))
#define CONVERSATION_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONVERSATION_LIST_TYPE_ROW, ConversationListRowClass))
#define CONVERSATION_LIST_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONVERSATION_LIST_TYPE_ROW))
#define CONVERSATION_LIST_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONVERSATION_LIST_TYPE_ROW))
#define CONVERSATION_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONVERSATION_LIST_TYPE_ROW, ConversationListRowClass))

typedef struct _ConversationListRow ConversationListRow;
typedef struct _ConversationListRowClass ConversationListRowClass;
enum  {
	CONVERSATION_LIST_VIEW_0_PROPERTY,
	CONVERSATION_LIST_VIEW_SELECTION_MODE_ENABLED_PROPERTY,
	CONVERSATION_LIST_VIEW_SELECTED_PROPERTY,
	CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_PROPERTY,
	CONVERSATION_LIST_VIEW_NUM_PROPERTIES
};
static GParamSpec* conversation_list_view_properties[CONVERSATION_LIST_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ConversationListRowPrivate ConversationListRowPrivate;
typedef struct _Block82Data Block82Data;
typedef struct _Block83Data Block83Data;
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define __vala_GdkEventSequence_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventSequence_free (var), NULL)))
enum  {
	CONVERSATION_LIST_VIEW_CONVERSATIONS_SELECTED_SIGNAL,
	CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL,
	CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL,
	CONVERSATION_LIST_VIEW_NUM_SIGNALS
};
static guint conversation_list_view_signals[CONVERSATION_LIST_VIEW_NUM_SIGNALS] = {0};

struct _ConversationListViewPrivate {
	GeeSet* _selected;
	ApplicationConfiguration* config;
	GtkGestureMultiPress* press_gesture;
	GtkGestureLongPress* long_press_gesture;
	GtkEventControllerKey* key_event_controller;
	GdkModifierType last_modifier_type;
	GtkListBox* list;
	GtkListBoxRow* to_restore_row;
	ConversationListModel* model;
	gdouble LOAD_MORE_THRESHOLD;
	gint LOAD_MORE_COUNT;
	gint VISIBILITY_UPDATE_DELAY_MS;
	GeeSet* _visible_conversations;
	GearySchedulerScheduled* scheduled_visible_update;
	gboolean should_inhibit_autoactivate;
	ConversationListRow* drag_widget;
};

struct _ConversationListRow {
	GtkListBoxRow parent_instance;
	GearyAppConversation* conversation;
	ConversationListRowPrivate * priv;
};

struct _ConversationListRowClass {
	GtkListBoxRowClass parent_class;
};

struct _Block82Data {
	int _ref_count_;
	ConversationListView* self;
	GeeCollection* selection;
};

struct _Block83Data {
	int _ref_count_;
	ConversationListView* self;
	GearyAppConversation* convo;
};

static gint ConversationListView_private_offset;
static gpointer conversation_list_view_parent_class = NULL;
static GearyBaseInterfaceIface * conversation_list_view_geary_base_interface_parent_iface = NULL;

VALA_EXTERN GType conversation_list_row_get_type (void) G_GNUC_CONST ;
static void conversation_list_view_on_selection_mode_changed (ConversationListView* self);
static void _conversation_list_view_on_selection_mode_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void conversation_list_view_on_selected_rows_changed (ConversationListView* self);
static void _conversation_list_view_on_selected_rows_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                                          gpointer self);
static void conversation_list_view_on_row_activated (ConversationListView* self);
static void _conversation_list_view_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                          GtkListBoxRow* row,
                                                                          gpointer self);
static void conversation_list_view_header_func (ConversationListView* self,
                                         GtkListBoxRow* row,
                                         GtkListBoxRow* before);
static void _conversation_list_view_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                          GtkListBoxRow* before,
                                                                          gpointer self);
static void conversation_list_view_maybe_load_more (ConversationListView* self,
                                             GtkAdjustment* adjustment);
static void _conversation_list_view_maybe_load_more_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                           gpointer self);
static void conversation_list_view_update_visible_conversations (ConversationListView* self);
static void _conversation_list_view_update_visible_conversations_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                        gpointer self);
static void conversation_list_view_on_press_gesture_released (ConversationListView* self,
                                                       gint n_press,
                                                       gdouble x,
                                                       gdouble y);
static void _conversation_list_view_on_press_gesture_released_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                         gint n_press,
                                                                                         gdouble x,
                                                                                         gdouble y,
                                                                                         gpointer self);
static void __lambda28_ (ConversationListView* self,
                  GtkGestureLongPress* n_press,
                  gdouble x,
                  gdouble y);
static void ___lambda28__gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                  gdouble x,
                                                  gdouble y,
                                                  gpointer self);
static gboolean conversation_list_view_on_key_event_controller_key_pressed (ConversationListView* self,
                                                                     guint keyval,
                                                                     guint keycode,
                                                                     GdkModifierType modifier_type);
static gboolean _conversation_list_view_on_key_event_controller_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                                           guint keyval,
                                                                                                           guint keycode,
                                                                                                           GdkModifierType state,
                                                                                                           gpointer self);
static void conversation_list_view_on_drag_begin (ConversationListView* self,
                                           GdkDragContext* ctx);
static void _conversation_list_view_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                                  GdkDragContext* context,
                                                                  gpointer self);
static void conversation_list_view_on_drag_end (ConversationListView* self,
                                         GdkDragContext* ctx);
static void _conversation_list_view_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                              GdkDragContext* context,
                                                              gpointer self);
static void __lambda29_ (ConversationListView* self,
                  GtkWidget* child);
VALA_EXTERN void conversation_list_row_refresh_time (ConversationListRow* self);
static void ___lambda29__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void conversation_list_view_on_conversations_loaded (ConversationListView* self);
static void _conversation_list_view_on_conversations_loaded_conversation_list_model_conversations_loaded (ConversationListModel* _sender,
                                                                                                   gpointer self);
static void conversation_list_view_on_conversations_removed (ConversationListView* self,
                                                      gboolean start);
static void _conversation_list_view_on_conversations_removed_conversation_list_model_conversations_removed (ConversationListModel* _sender,
                                                                                                     gboolean start,
                                                                                                     gpointer self);
static void conversation_list_view_on_conversation_updated (ConversationListView* self,
                                                     GearyAppConversation* convo);
static void _conversation_list_view_on_conversation_updated_conversation_list_model_conversation_updated (ConversationListModel* _sender,
                                                                                                   GearyAppConversation* convo,
                                                                                                   gpointer self);
static GtkWidget* conversation_list_view_row_factory (ConversationListView* self,
                                               GObject* convo_obj);
static GtkWidget* _conversation_list_view_row_factory_gtk_list_box_create_widget_func (GObject* item,
                                                                                gpointer self);
VALA_EXTERN ConversationListModel* conversation_list_model_new (GearyAppConversationMonitor* monitor);
VALA_EXTERN ConversationListModel* conversation_list_model_construct (GType object_type,
                                                          GearyAppConversationMonitor* monitor);
VALA_EXTERN ConversationListRow* conversation_list_row_new (ApplicationConfiguration* config,
                                                GearyAppConversation* conversation,
                                                gboolean selection_mode_enabled);
VALA_EXTERN ConversationListRow* conversation_list_row_construct (GType object_type,
                                                      ApplicationConfiguration* config,
                                                      GearyAppConversation* conversation,
                                                      gboolean selection_mode_enabled);
static void conversation_list_view_on_toggle_flags (ConversationListView* self,
                                             ConversationListRow* row,
                                             GearyNamedFlag* flag);
static void _conversation_list_view_on_toggle_flags_conversation_list_row_toggle_flag (ConversationListRow* _sender,
                                                                                ConversationListRow* row,
                                                                                GearyNamedFlag* flag,
                                                                                gpointer self);
static void conversation_list_view_on_toggle_selection (ConversationListView* self,
                                                 ConversationListRow* row,
                                                 gboolean active);
static void _conversation_list_view_on_toggle_selection_conversation_list_row_toggle_selection (ConversationListRow* _sender,
                                                                                         ConversationListRow* row,
                                                                                         gboolean active,
                                                                                         gpointer self);
static void conversation_list_view_context_menu (ConversationListView* self,
                                          ConversationListRow* row,
                                          GdkRectangle* rect);
static GtkPopover* conversation_list_view_construct_popover (ConversationListView* self,
                                                      ConversationListRow* row,
                                                      guint selection_size);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static Block82Data* block82_data_ref (Block82Data* _data82_);
static void block82_data_unref (void * _userdata_);
static void __lambda31_ (Block82Data* _data82_,
                  GtkWidget* child);
static void ___lambda31__gtk_callback (GtkWidget* widget,
                                gpointer self);
static gboolean conversation_list_view_selection_changed (ConversationListView* self,
                                                   GeeSet* selection);
static void conversation_list_view_restore_row (ConversationListView* self);
static gboolean ___lambda26_ (ConversationListView* self);
static gboolean ____lambda26__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void conversation_list_view_set_visible_conversations (ConversationListView* self,
                                                       GeeSet* value);
static gboolean __lambda27_ (ConversationListView* self);
static gboolean ___lambda27__gsource_func (gpointer self);
static GtkListBoxRow* conversation_list_view_get_next_conversation (ConversationListView* self,
                                                             gboolean asc);
static Block83Data* block83_data_ref (Block83Data* _data83_);
static void block83_data_unref (void * _userdata_);
static void __lambda30_ (Block83Data* _data83_,
                  GtkWidget* child);
VALA_EXTERN void conversation_list_row_update (ConversationListRow* self);
static void ___lambda30__gtk_callback (GtkWidget* widget,
                                gpointer self);
static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self);
static void _vala_GdkEvent_free (GdkEvent* self);
static void _vala_GdkEventSequence_free (GdkEventSequence* self);
static void __lambda25_ (ConversationListView* self,
                  GtkWidget* child);
VALA_EXTERN void conversation_list_row_set_selection_enabled (ConversationListRow* self,
                                                  gboolean enabled);
static void ___lambda25__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void conversation_list_view_finalize (GObject * obj);
static GType conversation_list_view_get_type_once (void);
static void _vala_conversation_list_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_conversation_list_view_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

VALA_EXTERN const GtkTargetEntry FOLDER_LIST_TREE_TARGET_ENTRY_LIST[1];

static inline gpointer
conversation_list_view_get_instance_private (ConversationListView* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationListView_private_offset);
}

gboolean
conversation_list_view_get_selection_mode_enabled (ConversationListView* self)
{
	gboolean result;
	GtkListBox* _tmp0_;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), FALSE);
	_tmp0_ = self->priv->list;
	result = gtk_list_box_get_selection_mode (_tmp0_) == GTK_SELECTION_MULTIPLE;
	return result;
}

void
conversation_list_view_set_selection_mode_enabled (ConversationListView* self,
                                                   gboolean value)
{
	GtkSelectionMode _tmp0_ = 0;
	GtkSelectionMode mode = 0;
	GtkListBox* _tmp1_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	if (value) {
		_tmp0_ = GTK_SELECTION_MULTIPLE;
	} else {
		_tmp0_ = GTK_SELECTION_SINGLE;
	}
	mode = _tmp0_;
	_tmp1_ = self->priv->list;
	if (gtk_list_box_get_selection_mode (_tmp1_) != mode) {
		GtkListBox* _tmp2_;
		_tmp2_ = self->priv->list;
		gtk_list_box_set_selection_mode (_tmp2_, mode);
		g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "selection-mode-enabled");
	}
}

GeeSet*
conversation_list_view_get_selected (ConversationListView* self)
{
	GeeSet* result;
	GeeSet* _tmp0_;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), NULL);
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
conversation_list_view_set_selected (ConversationListView* self,
                                     GeeSet* value)
{
	GeeSet* old_value;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	old_value = conversation_list_view_get_selected (self);
	if (old_value != value) {
		GeeSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected);
		self->priv->_selected = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_list_view_properties[CONVERSATION_LIST_VIEW_SELECTED_PROPERTY]);
	}
}

static void
_conversation_list_view_on_selection_mode_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	conversation_list_view_on_selection_mode_changed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_selected_rows_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                                     gpointer self)
{
	conversation_list_view_on_selected_rows_changed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                     GtkListBoxRow* row,
                                                                     gpointer self)
{
	conversation_list_view_on_row_activated ((ConversationListView*) self);
}

static void
_conversation_list_view_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                     GtkListBoxRow* before,
                                                                     gpointer self)
{
	conversation_list_view_header_func ((ConversationListView*) self, row, before);
}

static void
_conversation_list_view_maybe_load_more_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                      gpointer self)
{
	conversation_list_view_maybe_load_more ((ConversationListView*) self, _sender);
}

static void
_conversation_list_view_update_visible_conversations_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                   gpointer self)
{
	conversation_list_view_update_visible_conversations ((ConversationListView*) self);
}

static void
_conversation_list_view_on_press_gesture_released_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                    gint n_press,
                                                                                    gdouble x,
                                                                                    gdouble y,
                                                                                    gpointer self)
{
	conversation_list_view_on_press_gesture_released ((ConversationListView*) self, n_press, x, y);
}

static void
__lambda28_ (ConversationListView* self,
             GtkGestureLongPress* n_press,
             gdouble x,
             gdouble y)
{
	ConversationListRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	ConversationListRow* _tmp2_;
	ConversationListRow* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (n_press, gtk_gesture_long_press_get_type ()));
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, (gint) y);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONVERSATION_LIST_TYPE_ROW, ConversationListRow));
	row = _tmp2_;
	_tmp3_ = row;
	if (_tmp3_ != NULL) {
		GtkListBox* _tmp4_;
		_tmp4_ = self->priv->list;
		gtk_list_box_unselect_all (_tmp4_);
		conversation_list_view_set_selection_mode_enabled (self, TRUE);
	}
	_g_object_unref0 (row);
}

static void
___lambda28__gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                             gdouble x,
                                             gdouble y,
                                             gpointer self)
{
	__lambda28_ ((ConversationListView*) self, _sender, x, y);
}

static gboolean
_conversation_list_view_on_key_event_controller_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                                  guint keyval,
                                                                                                  guint keycode,
                                                                                                  GdkModifierType state,
                                                                                                  gpointer self)
{
	gboolean result;
	result = conversation_list_view_on_key_event_controller_key_pressed ((ConversationListView*) self, keyval, keycode, state);
	return result;
}

static void
_conversation_list_view_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gpointer self)
{
	conversation_list_view_on_drag_begin ((ConversationListView*) self, context);
}

static void
_conversation_list_view_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                         GdkDragContext* context,
                                                         gpointer self)
{
	conversation_list_view_on_drag_end ((ConversationListView*) self, context);
}

ConversationListView*
conversation_list_view_construct (GType object_type,
                                  ApplicationConfiguration* config)
{
	ConversationListView * self = NULL;
	ApplicationConfiguration* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkListBox* _tmp8_;
	GtkGestureMultiPress* _tmp9_;
	GtkGestureMultiPress* _tmp10_;
	GtkGestureMultiPress* _tmp11_;
	GtkListBox* _tmp12_;
	GtkGestureLongPress* _tmp13_;
	GtkGestureLongPress* _tmp14_;
	GtkGestureLongPress* _tmp15_;
	GtkListBox* _tmp16_;
	GtkEventControllerKey* _tmp17_;
	GtkEventControllerKey* _tmp18_;
	GtkListBox* _tmp19_;
	GtkListBox* _tmp20_;
	GtkListBox* _tmp21_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (ConversationListView*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::selection-mode-enabled", (GCallback) _conversation_list_view_on_selection_mode_changed_g_object_notify, self, 0);
	_tmp1_ = self->priv->list;
	g_signal_connect_object (_tmp1_, "selected-rows-changed", (GCallback) _conversation_list_view_on_selected_rows_changed_gtk_list_box_selected_rows_changed, self, 0);
	_tmp2_ = self->priv->list;
	g_signal_connect_object (_tmp2_, "row-activated", (GCallback) _conversation_list_view_on_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp3_ = self->priv->list;
	gtk_list_box_set_header_func (_tmp3_, _conversation_list_view_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "value-changed", (GCallback) _conversation_list_view_maybe_load_more_gtk_adjustment_value_changed, self, 0);
	_tmp6_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "value-changed", (GCallback) _conversation_list_view_update_visible_conversations_gtk_adjustment_value_changed, self, 0);
	_tmp8_ = self->priv->list;
	_tmp9_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->press_gesture);
	self->priv->press_gesture = _tmp9_;
	_tmp10_ = self->priv->press_gesture;
	gtk_gesture_single_set_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_gesture_single_get_type (), GtkGestureSingle), (guint) 0);
	_tmp11_ = self->priv->press_gesture;
	g_signal_connect_object (_tmp11_, "released", (GCallback) _conversation_list_view_on_press_gesture_released_gtk_gesture_multi_press_released, self, 0);
	_tmp12_ = self->priv->list;
	_tmp13_ = (GtkGestureLongPress*) gtk_gesture_long_press_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->long_press_gesture);
	self->priv->long_press_gesture = _tmp13_;
	_tmp14_ = self->priv->long_press_gesture;
	gtk_event_controller_set_propagation_phase (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_event_controller_get_type (), GtkEventController), GTK_PHASE_CAPTURE);
	_tmp15_ = self->priv->long_press_gesture;
	g_signal_connect_object (_tmp15_, "pressed", (GCallback) ___lambda28__gtk_gesture_long_press_pressed, self, 0);
	_tmp16_ = self->priv->list;
	_tmp17_ = (GtkEventControllerKey*) gtk_event_controller_key_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->key_event_controller);
	self->priv->key_event_controller = _tmp17_;
	_tmp18_ = self->priv->key_event_controller;
	g_signal_connect_object (_tmp18_, "key-pressed", (GCallback) _conversation_list_view_on_key_event_controller_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp19_ = self->priv->list;
	gtk_drag_source_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), GDK_BUTTON1_MASK, FOLDER_LIST_TREE_TARGET_ENTRY_LIST, (gint) G_N_ELEMENTS (FOLDER_LIST_TREE_TARGET_ENTRY_LIST), GDK_ACTION_COPY | GDK_ACTION_MOVE);
	_tmp20_ = self->priv->list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), "drag-begin", (GCallback) _conversation_list_view_on_drag_begin_gtk_widget_drag_begin, self, 0);
	_tmp21_ = self->priv->list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), "drag-end", (GCallback) _conversation_list_view_on_drag_end_gtk_widget_drag_end, self, 0);
	return self;
}

ConversationListView*
conversation_list_view_new (ApplicationConfiguration* config)
{
	return conversation_list_view_construct (CONVERSATION_LIST_TYPE_VIEW, config);
}

static void
conversation_list_view_header_func (ConversationListView* self,
                                    GtkListBoxRow* row,
                                    GtkListBoxRow* before)
{
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (row, gtk_list_box_row_get_type ()));
	g_return_if_fail ((before == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (before, gtk_list_box_row_get_type ()));
	if (before != NULL) {
		GtkSeparator* sep = NULL;
		GtkSeparator* _tmp0_;
		GtkSeparator* _tmp1_;
		GtkSeparator* _tmp2_;
		_tmp0_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp0_);
		sep = _tmp0_;
		_tmp1_ = sep;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp2_ = sep;
		gtk_list_box_row_set_header (row, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (sep);
	}
}

/**
     * Updates the display of the received time on each list row.
     *
     * Because the received time is displayed as relative to the current time,
     * it must be periodically updated. ConversationList.View does not do this
     * automatically but instead it must be externally scheduled
     */
static void
__lambda29_ (ConversationListView* self,
             GtkWidget* child)
{
	ConversationListRow* row = NULL;
	ConversationListRow* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, CONVERSATION_LIST_TYPE_ROW, ConversationListRow));
	row = _tmp0_;
	conversation_list_row_refresh_time (row);
	_g_object_unref0 (row);
}

static void
___lambda29__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda29_ ((ConversationListView*) self, widget);
}

void
conversation_list_view_refresh_times (ConversationListView* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), ___lambda29__gtk_callback, self);
}

/**
     * Set the conversation monitor which the listview is displaying
     */
static void
_conversation_list_view_on_conversations_loaded_conversation_list_model_conversations_loaded (ConversationListModel* _sender,
                                                                                              gpointer self)
{
	conversation_list_view_on_conversations_loaded ((ConversationListView*) self);
}

static void
_conversation_list_view_on_conversations_removed_conversation_list_model_conversations_removed (ConversationListModel* _sender,
                                                                                                gboolean start,
                                                                                                gpointer self)
{
	conversation_list_view_on_conversations_removed ((ConversationListView*) self, start);
}

static void
_conversation_list_view_on_conversation_updated_conversation_list_model_conversation_updated (ConversationListModel* _sender,
                                                                                              GearyAppConversation* convo,
                                                                                              gpointer self)
{
	conversation_list_view_on_conversation_updated ((ConversationListView*) self, convo);
}

static GtkWidget*
_conversation_list_view_row_factory_gtk_list_box_create_widget_func (GObject* item,
                                                                     gpointer self)
{
	GtkWidget* result;
	result = conversation_list_view_row_factory ((ConversationListView*) self, item);
	return result;
}

void
conversation_list_view_set_monitor (ConversationListView* self,
                                    GearyAppConversationMonitor* monitor)
{
	ConversationListModel* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail ((monitor == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (monitor, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	_tmp0_ = self->priv->model;
	if (_tmp0_ != NULL) {
		ConversationListModel* _tmp1_;
		guint _tmp2_;
		ConversationListModel* _tmp3_;
		guint _tmp4_;
		ConversationListModel* _tmp5_;
		guint _tmp6_;
		_tmp1_ = self->priv->model;
		g_signal_parse_name ("conversations-loaded", CONVERSATION_LIST_TYPE_MODEL, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _conversation_list_view_on_conversations_loaded_conversation_list_model_conversations_loaded, self);
		_tmp3_ = self->priv->model;
		g_signal_parse_name ("conversations-removed", CONVERSATION_LIST_TYPE_MODEL, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _conversation_list_view_on_conversations_removed_conversation_list_model_conversations_removed, self);
		_tmp5_ = self->priv->model;
		g_signal_parse_name ("conversation-updated", CONVERSATION_LIST_TYPE_MODEL, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _conversation_list_view_on_conversation_updated_conversation_list_model_conversation_updated, self);
	}
	if (monitor == NULL) {
		GtkListBox* _tmp7_;
		_g_object_unref0 (self->priv->model);
		self->priv->model = NULL;
		_tmp7_ = self->priv->list;
		gtk_list_box_bind_model (_tmp7_, NULL, _conversation_list_view_row_factory_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	} else {
		ConversationListModel* _tmp8_;
		GtkListBox* _tmp9_;
		ConversationListModel* _tmp10_;
		ConversationListModel* _tmp11_;
		ConversationListModel* _tmp12_;
		ConversationListModel* _tmp13_;
		_tmp8_ = conversation_list_model_new (monitor);
		_g_object_unref0 (self->priv->model);
		self->priv->model = _tmp8_;
		_tmp9_ = self->priv->list;
		_tmp10_ = self->priv->model;
		gtk_list_box_bind_model (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_list_model_get_type (), GListModel), _conversation_list_view_row_factory_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
		_tmp11_ = self->priv->model;
		g_signal_connect_object (_tmp11_, "conversations-loaded", (GCallback) _conversation_list_view_on_conversations_loaded_conversation_list_model_conversations_loaded, self, 0);
		_tmp12_ = self->priv->model;
		g_signal_connect_object (_tmp12_, "conversations-removed", (GCallback) _conversation_list_view_on_conversations_removed_conversation_list_model_conversations_removed, self, 0);
		_tmp13_ = self->priv->model;
		g_signal_connect_object (_tmp13_, "conversation-updated", (GCallback) _conversation_list_view_on_conversation_updated_conversation_list_model_conversation_updated, self, 0);
	}
}

/**
     * Attempt to load more conversations from the current monitor
     */
void
conversation_list_view_load_more (ConversationListView* self,
                                  gint request)
{
	ConversationListModel* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->model;
	if (_tmp0_ != NULL) {
		ConversationListModel* _tmp1_;
		_tmp1_ = self->priv->model;
		conversation_list_model_load_more (_tmp1_, request);
	}
}

void
conversation_list_view_scroll (ConversationListView* self,
                               GtkScrollType scroll_type)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	gint index = 0;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp11_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (row);
		return;
	}
	_tmp4_ = row;
	index = gtk_list_box_row_get_index (_tmp4_);
	if (scroll_type == GTK_SCROLL_STEP_UP) {
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		GtkListBoxRow* _tmp7_;
		_tmp5_ = self->priv->list;
		_tmp6_ = gtk_list_box_get_row_at_index (_tmp5_, index - 1);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (row);
		row = _tmp7_;
	} else {
		GtkListBox* _tmp8_;
		GtkListBoxRow* _tmp9_;
		GtkListBoxRow* _tmp10_;
		_tmp8_ = self->priv->list;
		_tmp9_ = gtk_list_box_get_row_at_index (_tmp8_, index + 1);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (row);
		row = _tmp10_;
	}
	_tmp11_ = row;
	if (_tmp11_ != NULL) {
		GtkListBox* _tmp12_;
		GtkListBoxRow* _tmp13_;
		_tmp12_ = self->priv->list;
		_tmp13_ = row;
		gtk_list_box_select_row (_tmp12_, _tmp13_);
	}
	_g_object_unref0 (row);
}

static void
_conversation_list_view_on_toggle_flags_conversation_list_row_toggle_flag (ConversationListRow* _sender,
                                                                           ConversationListRow* row,
                                                                           GearyNamedFlag* flag,
                                                                           gpointer self)
{
	conversation_list_view_on_toggle_flags ((ConversationListView*) self, row, flag);
}

static void
_conversation_list_view_on_toggle_selection_conversation_list_row_toggle_selection (ConversationListRow* _sender,
                                                                                    ConversationListRow* row,
                                                                                    gboolean active,
                                                                                    gpointer self)
{
	conversation_list_view_on_toggle_selection ((ConversationListView*) self, row, active);
}

static GtkWidget*
conversation_list_view_row_factory (ConversationListView* self,
                                    GObject* convo_obj)
{
	GearyAppConversation* convo = NULL;
	GearyAppConversation* _tmp0_;
	ConversationListRow* row = NULL;
	ApplicationConfiguration* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ConversationListRow* _tmp4_;
	GtkWidget* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (convo_obj, G_TYPE_OBJECT), NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (convo_obj, GEARY_APP_TYPE_CONVERSATION, GearyAppConversation));
	convo = _tmp0_;
	_tmp1_ = self->priv->config;
	_tmp2_ = conversation_list_view_get_selection_mode_enabled (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = conversation_list_row_new (_tmp1_, convo, _tmp3_);
	g_object_ref_sink (_tmp4_);
	row = _tmp4_;
	g_signal_connect_object (row, "toggle-flag", (GCallback) _conversation_list_view_on_toggle_flags_conversation_list_row_toggle_flag, self, 0);
	g_signal_connect_object (row, "toggle-selection", (GCallback) _conversation_list_view_on_toggle_selection_conversation_list_row_toggle_selection, self, 0);
	result = G_TYPE_CHECK_INSTANCE_CAST (row, gtk_widget_get_type (), GtkWidget);
	_g_object_unref0 (convo);
	return result;
}

static void
conversation_list_view_context_menu (ConversationListView* self,
                                     ConversationListRow* row,
                                     GdkRectangle* rect)
{
	GtkPopover* popup_menu = NULL;
	GtkListBox* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GtkPopover* _tmp5_;
	GtkPopover* _tmp6_;
	GtkPopover* _tmp9_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (row));
	if (!gtk_list_box_row_is_selected (G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow))) {
		GtkListBox* _tmp0_;
		GtkListBox* _tmp1_;
		_tmp0_ = self->priv->list;
		gtk_list_box_unselect_all (_tmp0_);
		_tmp1_ = self->priv->list;
		gtk_list_box_select_row (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow));
	}
	_tmp2_ = self->priv->list;
	_tmp3_ = gtk_list_box_get_selected_rows (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = conversation_list_view_construct_popover (self, row, g_list_length (_tmp4_));
	_tmp6_ = _tmp5_;
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	popup_menu = _tmp6_;
	if (rect != NULL) {
		GtkPopover* _tmp7_;
		GdkRectangle _tmp8_;
		_tmp7_ = popup_menu;
		_tmp8_ = *rect;
		gtk_popover_set_pointing_to (_tmp7_, &_tmp8_);
	}
	_tmp9_ = popup_menu;
	gtk_popover_popup (_tmp9_);
	_g_object_unref0 (popup_menu);
}

static GtkPopover*
conversation_list_view_construct_popover (ConversationListView* self,
                                          ConversationListRow* row,
                                          guint selection_size)
{
	GMenu* context_menu_model = NULL;
	GMenu* _tmp0_;
	ApplicationMainWindow* main = NULL;
	GtkWidget* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	ApplicationMainWindow* _tmp3_;
	GearyAppConversation* _tmp13_;
	GearyAppConversation* _tmp17_;
	GearyAppConversation* _tmp21_;
	gboolean _tmp28_ = FALSE;
	GearyAppConversation* _tmp29_;
	GearyFolder* _tmp30_;
	GearyFolder* _tmp31_;
	GearyFolderSpecialUse _tmp32_;
	GearyFolderSpecialUse _tmp33_;
	GMenu* actions_section = NULL;
	GMenu* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GMenu* _tmp49_;
	GtkPopover* context_menu = NULL;
	GMenu* _tmp50_;
	GtkPopover* _tmp51_;
	GtkPopover* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), NULL);
	g_return_val_if_fail (CONVERSATION_LIST_IS_ROW (row), NULL);
	_tmp0_ = g_menu_new ();
	context_menu_model = _tmp0_;
	_tmp1_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp1_) ? ((ApplicationMainWindow*) _tmp1_) : NULL);
	main = _tmp2_;
	_tmp3_ = main;
	if (_tmp3_ != NULL) {
		ApplicationMainWindow* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = main;
		_tmp5_ = application_main_window_get_is_shift_down (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!_tmp6_) {
			GMenu* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = context_menu_model;
			_tmp8_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_TRASH_CONVERSATION);
			_tmp9_ = _tmp8_;
			g_menu_append (_tmp7_, ngettext ("Move conversation to _Trash", "Move conversations to _Trash", (gulong) selection_size), _tmp9_);
			_g_free0 (_tmp9_);
		} else {
			GMenu* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = context_menu_model;
			_tmp11_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_DELETE_CONVERSATION);
			_tmp12_ = _tmp11_;
			g_menu_append (_tmp10_, ngettext ("_Delete conversation", "_Delete conversations", (gulong) selection_size), _tmp12_);
			_g_free0 (_tmp12_);
		}
	}
	_tmp13_ = row->conversation;
	if (geary_app_conversation_is_unread (_tmp13_)) {
		GMenu* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = context_menu_model;
		_tmp15_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_READ);
		_tmp16_ = _tmp15_;
		g_menu_append (_tmp14_, _ ("Mark as _Read"), _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = row->conversation;
	if (geary_app_conversation_has_any_read_message (_tmp17_)) {
		GMenu* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = context_menu_model;
		_tmp19_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNREAD);
		_tmp20_ = _tmp19_;
		g_menu_append (_tmp18_, _ ("Mark as _Unread"), _tmp20_);
		_g_free0 (_tmp20_);
	}
	_tmp21_ = row->conversation;
	if (geary_app_conversation_is_flagged (_tmp21_)) {
		GMenu* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = context_menu_model;
		_tmp23_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNSTARRED);
		_tmp24_ = _tmp23_;
		g_menu_append (_tmp22_, _ ("U_nstar"), _tmp24_);
		_g_free0 (_tmp24_);
	} else {
		GMenu* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = context_menu_model;
		_tmp26_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_STARRED);
		_tmp27_ = _tmp26_;
		g_menu_append (_tmp25_, _ ("_Star"), _tmp27_);
		_g_free0 (_tmp27_);
	}
	_tmp29_ = row->conversation;
	_tmp30_ = geary_app_conversation_get_base_folder (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = geary_folder_get_used_as (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != GEARY_FOLDER_SPECIAL_USE_ARCHIVE) {
		GearyAppConversation* _tmp34_;
		GearyFolder* _tmp35_;
		GearyFolder* _tmp36_;
		GearyFolderSpecialUse _tmp37_;
		GearyFolderSpecialUse _tmp38_;
		_tmp34_ = row->conversation;
		_tmp35_ = geary_app_conversation_get_base_folder (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = geary_folder_get_used_as (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp28_ = _tmp38_ != GEARY_FOLDER_SPECIAL_USE_ALL_MAIL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		GMenu* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp39_ = context_menu_model;
		_tmp40_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_ARCHIVE_CONVERSATION);
		_tmp41_ = _tmp40_;
		g_menu_append (_tmp39_, ngettext ("_Archive conversation", "_Archive conversations", (gulong) selection_size), _tmp41_);
		_g_free0 (_tmp41_);
	}
	_tmp42_ = g_menu_new ();
	actions_section = _tmp42_;
	_tmp43_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_REPLY_CONVERSATION);
	_tmp44_ = _tmp43_;
	g_menu_append (actions_section, _ ("_Reply"), _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_REPLY_ALL_CONVERSATION);
	_tmp46_ = _tmp45_;
	g_menu_append (actions_section, _ ("R_eply All"), _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_FORWARD_CONVERSATION);
	_tmp48_ = _tmp47_;
	g_menu_append (actions_section, _ ("_Forward"), _tmp48_);
	_g_free0 (_tmp48_);
	_tmp49_ = context_menu_model;
	g_menu_append_section (_tmp49_, NULL, G_TYPE_CHECK_INSTANCE_CAST (actions_section, g_menu_model_get_type (), GMenuModel));
	_tmp50_ = context_menu_model;
	_tmp51_ = (GtkPopover*) gtk_popover_new_from_model (G_TYPE_CHECK_INSTANCE_CAST (row, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, g_menu_model_get_type (), GMenuModel));
	g_object_ref_sink (_tmp51_);
	context_menu = _tmp51_;
	result = context_menu;
	_g_object_unref0 (actions_section);
	_g_object_unref0 (main);
	_g_object_unref0 (context_menu_model);
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

/**
     * Gets the conversations represented by the current selection in the ListBox
     */
GeeSet*
conversation_list_view_get_selected_conversations (ConversationListView* self)
{
	GeeHashSet* selected = NULL;
	GeeHashSet* _tmp0_;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	GeeSet* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), NULL);
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	selected = _tmp0_;
	_tmp1_ = self->priv->list;
	_tmp2_ = gtk_list_box_get_selected_rows (_tmp1_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp2_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* row = NULL;
			row = (GtkListBoxRow*) row_it->data;
			{
				GeeHashSet* _tmp3_;
				GtkListBoxRow* _tmp4_;
				GearyAppConversation* _tmp5_;
				_tmp3_ = selected;
				_tmp4_ = row;
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CONVERSATION_LIST_TYPE_ROW, ConversationListRow)->conversation;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp5_);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (selected, GEE_TYPE_SET, GeeSet);
	return result;
}

/**
     * Selects the rows for a given collection of conversations
     *
     * If a conversation is not present in the ListBox, it is ignored.
     */
static Block82Data*
block82_data_ref (Block82Data* _data82_)
{
	g_atomic_int_inc (&_data82_->_ref_count_);
	return _data82_;
}

static void
block82_data_unref (void * _userdata_)
{
	Block82Data* _data82_;
	_data82_ = (Block82Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data82_->_ref_count_)) {
		ConversationListView* self;
		self = _data82_->self;
		_g_object_unref0 (_data82_->selection);
		_g_object_unref0 (self);
		g_slice_free (Block82Data, _data82_);
	}
}

static void
__lambda31_ (Block82Data* _data82_,
             GtkWidget* child)
{
	ConversationListView* self;
	ConversationListRow* row = NULL;
	ConversationListRow* _tmp0_;
	GearyAppConversation* conversation = NULL;
	ConversationListRow* _tmp1_;
	GearyAppConversation* _tmp2_;
	GearyAppConversation* _tmp3_;
	GearyAppConversation* _tmp4_;
	self = _data82_->self;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, CONVERSATION_LIST_TYPE_ROW, ConversationListRow));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = _tmp1_->conversation;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	conversation = _tmp3_;
	_tmp4_ = conversation;
	if (gee_collection_contains (_data82_->selection, _tmp4_)) {
		GtkListBox* _tmp5_;
		ConversationListRow* _tmp6_;
		_tmp5_ = self->priv->list;
		_tmp6_ = row;
		gtk_list_box_select_row (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_row_get_type (), GtkListBoxRow));
	}
	_g_object_unref0 (conversation);
	_g_object_unref0 (row);
}

static void
___lambda31__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda31_ (self, widget);
}

void
conversation_list_view_select_conversations (ConversationListView* self,
                                             GeeCollection* selection)
{
	Block82Data* _data82_;
	GeeCollection* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (selection, GEE_TYPE_COLLECTION));
	_data82_ = g_slice_new0 (Block82Data);
	_data82_->_ref_count_ = 1;
	_data82_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (selection);
	_g_object_unref0 (_data82_->selection);
	_data82_->selection = _tmp0_;
	_tmp1_ = self->priv->list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer), ___lambda31__gtk_callback, _data82_);
	block82_data_unref (_data82_);
	_data82_ = NULL;
}

/**
     * Activate currently selected row
     *
     * If more than one selected, activate the first one
     */
void
conversation_list_view_activate_selected (ConversationListView* self)
{
	GeeSet* conversations = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = conversation_list_view_get_selected_conversations (self);
	conversations = _tmp0_;
	_tmp1_ = conversations;
	_tmp2_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GeeSet* _tmp4_;
		gint _tmp5_ = 0;
		gpointer* _tmp6_;
		GearyAppConversation** _tmp7_;
		gint _tmp7__length1;
		GearyAppConversation* _tmp8_;
		_tmp4_ = conversations;
		_tmp6_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp5_;
		_tmp8_ = _tmp7_[0];
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL], 0, _tmp8_, (guint) 1);
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_g_object_unref0 (conversations);
}

/**
     * Selects all conversations
     */
void
conversation_list_view_select_all (ConversationListView* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	conversation_list_view_set_selection_mode_enabled (self, TRUE);
	_tmp0_ = self->priv->list;
	gtk_list_box_select_all (_tmp0_);
}

/**
     * Unselects all conversations
     */
void
conversation_list_view_unselect_all (ConversationListView* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->list;
	gtk_list_box_unselect_all (_tmp0_);
}

static gboolean
conversation_list_view_selection_changed (ConversationListView* self,
                                          GeeSet* selection)
{
	gboolean changed = FALSE;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (selection, GEE_TYPE_SET), FALSE);
	_tmp0_ = self->priv->_selected;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (selection, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = _tmp3_;
	changed = _tmp2_ != _tmp4_;
	if (changed) {
		result = TRUE;
		return result;
	}
	{
		GeeIterator* _conversation_it = NULL;
		GeeIterator* _tmp5_;
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (selection, GEE_TYPE_ITERABLE, GeeIterable));
		_conversation_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GearyAppConversation* conversation = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeSet* _tmp9_;
			GearyAppConversation* _tmp10_;
			_tmp6_ = _conversation_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _conversation_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			conversation = (GearyAppConversation*) _tmp8_;
			_tmp9_ = self->priv->_selected;
			_tmp10_ = conversation;
			if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_)) {
				changed = TRUE;
			}
			_g_object_unref0 (conversation);
		}
		_g_object_unref0 (_conversation_it);
	}
	result = changed;
	return result;
}

static gboolean
___lambda26_ (ConversationListView* self)
{
	GtkListBoxRow* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->to_restore_row;
	g_signal_emit_by_name (_tmp0_, "activate");
	_g_object_unref0 (self->priv->to_restore_row);
	self->priv->to_restore_row = NULL;
	result = FALSE;
	return result;
}

static gboolean
____lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda26_ ((ConversationListView*) self);
	return result;
}

static void
conversation_list_view_restore_row (ConversationListView* self)
{
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->to_restore_row;
	if (_tmp0_ != NULL) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda26__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
conversation_list_view_on_toggle_flags (ConversationListView* self,
                                        ConversationListRow* row,
                                        GearyNamedFlag* flag)
{
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (row));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (flag, GEARY_TYPE_NAMED_FLAG));
	if (gtk_list_box_row_is_selected (G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow))) {
		GeeSet* _tmp0_;
		_tmp0_ = self->priv->_selected;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), flag);
	} else {
		GearyAppConversation* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		_tmp1_ = row->conversation;
		_tmp2_ = geary_collection_single (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_);
		_tmp3_ = _tmp2_;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL], 0, _tmp3_, flag);
		_g_object_unref0 (_tmp3_);
	}
}

static void
conversation_list_view_on_toggle_selection (ConversationListView* self,
                                            ConversationListRow* row,
                                            gboolean active)
{
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (row));
	if (active) {
		GtkListBox* _tmp0_;
		_tmp0_ = self->priv->list;
		gtk_list_box_select_row (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow));
	} else {
		GtkListBox* _tmp1_;
		_tmp1_ = self->priv->list;
		gtk_list_box_unselect_row (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow));
	}
}

/**
     * Called on scroll to possibly load more conversations from the model
     */
static void
conversation_list_view_maybe_load_more (ConversationListView* self,
                                        GtkAdjustment* adjustment)
{
	gdouble upper = 0.0;
	gdouble threshold = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (adjustment, gtk_adjustment_get_type ()));
	upper = gtk_adjustment_get_upper (adjustment);
	_tmp0_ = gtk_adjustment_get_page_size (adjustment);
	_tmp1_ = _tmp0_;
	threshold = (upper - _tmp1_) - self->priv->LOAD_MORE_THRESHOLD;
	if (gtk_widget_is_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget))) {
		_tmp2_ = gtk_adjustment_get_value (adjustment) >= threshold;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		conversation_list_view_load_more (self, self->priv->LOAD_MORE_COUNT);
	}
}

GeeSet*
conversation_list_view_get_visible_conversations (ConversationListView* self)
{
	GeeSet* result;
	GeeSet* _tmp0_;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), NULL);
	_tmp0_ = self->priv->_visible_conversations;
	result = _tmp0_;
	return result;
}

static void
conversation_list_view_set_visible_conversations (ConversationListView* self,
                                                  GeeSet* value)
{
	GeeSet* old_value;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	old_value = conversation_list_view_get_visible_conversations (self);
	if (old_value != value) {
		GeeSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_visible_conversations);
		self->priv->_visible_conversations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_list_view_properties[CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_PROPERTY]);
	}
}

/**
     * Called on scroll to update the set of visible conversations
     */
static gboolean
__lambda27_ (ConversationListView* self)
{
	GeeHashSet* visible = NULL;
	GeeHashSet* _tmp0_;
	GtkListBoxRow* first = NULL;
	GtkListBox* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	GtkListBoxRow* _tmp6_;
	GtkListBoxRow* _tmp7_;
	GtkListBoxRow* _tmp8_;
	guint start_index = 0U;
	GtkListBoxRow* _tmp10_;
	guint end_index = 0U;
	GtkAdjustment* _tmp11_;
	GtkAdjustment* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	GtkListBoxRow* _tmp15_;
	ConversationListModel* _tmp16_;
	GeeHashSet* _tmp24_;
	gboolean result;
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	visible = _tmp0_;
	_tmp1_ = self->priv->list;
	_tmp2_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_adjustment_get_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_list_box_get_row_at_y (_tmp1_, (gint) _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	first = _tmp7_;
	_tmp8_ = first;
	if (_tmp8_ == NULL) {
		GeeHashSet* _tmp9_;
		_tmp9_ = visible;
		conversation_list_view_set_visible_conversations (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_SET, GeeSet));
		result = G_SOURCE_REMOVE;
		_g_object_unref0 (first);
		_g_object_unref0 (visible);
		return result;
	}
	_tmp10_ = first;
	start_index = (guint) gtk_list_box_row_get_index (_tmp10_);
	_tmp11_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp12_ = _tmp11_;
	_tmp13_ = gtk_adjustment_get_page_size (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = first;
	_tmp16_ = self->priv->model;
	end_index = MIN (start_index + ((guint) (_tmp14_ / gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget)))), g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_list_model_get_type (), GListModel)));
	{
		guint i = 0U;
		i = start_index;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				GeeSet* _tmp19_;
				ConversationListModel* _tmp20_;
				GObject* _tmp21_;
				GearyAppConversation* _tmp22_;
				GearyAppConversation* _tmp23_;
				if (!_tmp17_) {
					guint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < end_index)) {
					break;
				}
				_tmp19_ = self->priv->_visible_conversations;
				_tmp20_ = self->priv->model;
				_tmp21_ = g_list_model_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_list_model_get_type (), GListModel), i);
				_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GEARY_APP_TYPE_CONVERSATION) ? ((GearyAppConversation*) _tmp21_) : NULL;
				if (_tmp22_ == NULL) {
					_g_object_unref0 (_tmp21_);
				}
				_tmp23_ = _tmp22_;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection), _tmp23_);
				_g_object_unref0 (_tmp23_);
			}
		}
	}
	_tmp24_ = visible;
	conversation_list_view_set_visible_conversations (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_SET, GeeSet));
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (first);
	_g_object_unref0 (visible);
	return result;
}

static gboolean
___lambda27__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda27_ ((ConversationListView*) self);
	return result;
}

static void
conversation_list_view_update_visible_conversations (ConversationListView* self)
{
	GearySchedulerScheduled* _tmp0_;
	gint _tmp2_;
	GearySchedulerScheduled* _tmp3_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->scheduled_visible_update;
	if (_tmp0_ != NULL) {
		GearySchedulerScheduled* _tmp1_;
		_tmp1_ = self->priv->scheduled_visible_update;
		geary_scheduler_scheduled_cancel (_tmp1_);
	}
	_tmp2_ = self->priv->VISIBILITY_UPDATE_DELAY_MS;
	_tmp3_ = geary_scheduler_after_msec ((guint) _tmp2_, ___lambda27__gsource_func, self, G_PRIORITY_DEFAULT_IDLE);
	_g_object_unref0 (self->priv->scheduled_visible_update);
	self->priv->scheduled_visible_update = _tmp3_;
}

/**
     * Informs the listbox to suppress autoactivate behavior on the next update
     */
void
conversation_list_view_inhibit_next_autoselect (ConversationListView* self)
{
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	self->priv->should_inhibit_autoactivate = TRUE;
}

/**
     * Find a selectable conversation near current selection
     */
static GtkListBoxRow*
conversation_list_view_get_next_conversation (ConversationListView* self,
                                              gboolean asc)
{
	gint _tmp0_ = 0;
	gint index = 0;
	GList* selected_rows = NULL;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp11_;
	GtkListBoxRow* _tmp12_;
	GtkListBoxRow* _tmp13_;
	GtkListBoxRow* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GtkListBoxRow* _tmp16_;
	GtkListBoxRow* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), NULL);
	if (asc) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = G_MAXINT;
	}
	index = _tmp0_;
	_tmp1_ = self->priv->list;
	_tmp2_ = gtk_list_box_get_selected_rows (_tmp1_);
	(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
	selected_rows = _tmp2_;
	_tmp3_ = selected_rows;
	if (g_list_length (_tmp3_) == ((guint) 0)) {
		result = NULL;
		(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
		return result;
	}
	_tmp4_ = selected_rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp4_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* row = NULL;
			row = (GtkListBoxRow*) row_it->data;
			{
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				if (asc) {
					GtkListBoxRow* _tmp7_;
					_tmp7_ = row;
					_tmp6_ = gtk_list_box_row_get_index (_tmp7_) > index;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (!asc) {
						GtkListBoxRow* _tmp9_;
						_tmp9_ = row;
						_tmp8_ = gtk_list_box_row_get_index (_tmp9_) < index;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp5_ = _tmp8_;
				}
				if (_tmp5_) {
					GtkListBoxRow* _tmp10_;
					_tmp10_ = row;
					index = gtk_list_box_row_get_index (_tmp10_);
				}
			}
		}
	}
	if (asc) {
		index += 1;
	} else {
		index -= 1;
	}
	_tmp11_ = self->priv->list;
	_tmp12_ = gtk_list_box_get_row_at_index (_tmp11_, index);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	row = _tmp13_;
	_tmp16_ = row;
	if (_tmp16_ != NULL) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = !asc;
	}
	if (_tmp15_) {
		GtkListBoxRow* _tmp17_;
		GtkListBoxRow* _tmp18_;
		_tmp17_ = row;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (_tmp14_);
		_tmp14_ = _tmp18_;
	} else {
		GtkListBoxRow* _tmp19_;
		_tmp19_ = conversation_list_view_get_next_conversation (self, FALSE);
		_g_object_unref0 (_tmp14_);
		_tmp14_ = _tmp19_;
	}
	result = _tmp14_;
	_g_object_unref0 (row);
	(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
	return result;
}

static void
conversation_list_view_on_conversations_loaded (ConversationListView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ApplicationConfiguration* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp2_ = self->priv->config;
	_tmp3_ = application_configuration_get_autoselect (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = !self->priv->should_inhibit_autoactivate;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkListBox* _tmp5_;
		GList* _tmp6_;
		GList* _tmp7_;
		_tmp5_ = self->priv->list;
		_tmp6_ = gtk_list_box_get_selected_rows (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_list_length (_tmp7_) == ((guint) 0);
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_list_free (_tmp7_), NULL));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBoxRow* first_row = NULL;
		GtkListBox* _tmp8_;
		GtkListBoxRow* _tmp9_;
		GtkListBoxRow* _tmp10_;
		GtkListBoxRow* _tmp11_;
		_tmp8_ = self->priv->list;
		_tmp9_ = gtk_list_box_get_row_at_index (_tmp8_, 0);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		first_row = _tmp10_;
		_tmp11_ = first_row;
		if (_tmp11_ != NULL) {
			GtkListBox* _tmp12_;
			GtkListBoxRow* _tmp13_;
			_tmp12_ = self->priv->list;
			_tmp13_ = first_row;
			gtk_list_box_select_row (_tmp12_, _tmp13_);
		}
		_g_object_unref0 (first_row);
	}
	self->priv->should_inhibit_autoactivate = FALSE;
}

static void
conversation_list_view_on_conversations_removed (ConversationListView* self,
                                                 gboolean start)
{
	gboolean _tmp0_ = FALSE;
	ApplicationConfiguration* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp1_ = self->priv->config;
	_tmp2_ = application_configuration_get_autoselect (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = start;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBoxRow* _tmp4_;
		_tmp4_ = conversation_list_view_get_next_conversation (self, TRUE);
		_g_object_unref0 (self->priv->to_restore_row);
		self->priv->to_restore_row = _tmp4_;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = conversation_list_view_get_selection_mode_enabled (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			conversation_list_view_set_selection_mode_enabled (self, FALSE);
		} else {
			gboolean _tmp7_ = FALSE;
			ApplicationConfiguration* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->config;
			_tmp9_ = application_configuration_get_autoselect (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				GtkListBox* _tmp11_;
				GList* _tmp12_;
				GList* _tmp13_;
				_tmp11_ = self->priv->list;
				_tmp12_ = gtk_list_box_get_selected_rows (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = g_list_length (_tmp13_) == ((guint) 0);
				(_tmp13_ == NULL) ? NULL : (_tmp13_ = (g_list_free (_tmp13_), NULL));
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				conversation_list_view_restore_row (self);
			}
		}
	}
}

static Block83Data*
block83_data_ref (Block83Data* _data83_)
{
	g_atomic_int_inc (&_data83_->_ref_count_);
	return _data83_;
}

static void
block83_data_unref (void * _userdata_)
{
	Block83Data* _data83_;
	_data83_ = (Block83Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data83_->_ref_count_)) {
		ConversationListView* self;
		self = _data83_->self;
		_g_object_unref0 (_data83_->convo);
		_g_object_unref0 (self);
		g_slice_free (Block83Data, _data83_);
	}
}

static void
__lambda30_ (Block83Data* _data83_,
             GtkWidget* child)
{
	ConversationListView* self;
	ConversationListRow* row = NULL;
	ConversationListRow* _tmp0_;
	ConversationListRow* _tmp1_;
	GearyAppConversation* _tmp2_;
	self = _data83_->self;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, CONVERSATION_LIST_TYPE_ROW, ConversationListRow));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = _tmp1_->conversation;
	if (_data83_->convo == _tmp2_) {
		ConversationListRow* _tmp3_;
		_tmp3_ = row;
		conversation_list_row_update (_tmp3_);
	}
	_g_object_unref0 (row);
}

static void
___lambda30__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda30_ (self, widget);
}

static void
conversation_list_view_on_conversation_updated (ConversationListView* self,
                                                GearyAppConversation* convo)
{
	Block83Data* _data83_;
	GearyAppConversation* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (convo, GEARY_APP_TYPE_CONVERSATION));
	_data83_ = g_slice_new0 (Block83Data);
	_data83_->_ref_count_ = 1;
	_data83_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (convo);
	_g_object_unref0 (_data83_->convo);
	_data83_->convo = _tmp0_;
	_tmp1_ = self->priv->list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer), ___lambda30__gtk_callback, _data83_);
	block83_data_unref (_data83_);
	_data83_ = NULL;
}

static GdkEvent*
_vala_GdkEvent_copy (GdkEvent* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEvent_copy0 (gpointer self)
{
	return self ? _vala_GdkEvent_copy (self) : NULL;
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static void
_vala_GdkEventSequence_free (GdkEventSequence* self)
{
	g_boxed_free (gdk_event_sequence_get_type (), self);
}

static void
conversation_list_view_on_press_gesture_released (ConversationListView* self,
                                                  gint n_press,
                                                  gdouble x,
                                                  gdouble y)
{
	ConversationListRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	ConversationListRow* _tmp2_;
	ConversationListRow* _tmp3_;
	guint button = 0U;
	GtkGestureMultiPress* _tmp4_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, (gint) y);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONVERSATION_LIST_TYPE_ROW, ConversationListRow));
	row = _tmp2_;
	_tmp3_ = row;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (row);
		return;
	}
	_tmp4_ = self->priv->press_gesture;
	button = gtk_gesture_single_get_current_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_gesture_single_get_type (), GtkGestureSingle));
	if (button == ((guint) 1)) {
		GdkEventSequence* sequence = NULL;
		GtkGestureMultiPress* _tmp5_;
		GdkEventSequence* _tmp6_;
		GdkEvent* event = NULL;
		GtkGestureMultiPress* _tmp7_;
		GdkEventSequence* _tmp8_;
		GdkEvent* _tmp9_;
		GdkEvent* _tmp10_;
		GdkEvent* _tmp11_;
		GdkModifierType _tmp12_ = 0U;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp5_ = self->priv->press_gesture;
		_tmp6_ = gtk_gesture_single_get_current_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_gesture_single_get_type (), GtkGestureSingle));
		sequence = _tmp6_;
		_tmp7_ = self->priv->press_gesture;
		_tmp8_ = sequence;
		_tmp9_ = gtk_gesture_get_last_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_gesture_get_type (), GtkGesture), _tmp8_);
		_tmp10_ = __vala_GdkEvent_copy0 (_tmp9_);
		event = _tmp10_;
		_tmp11_ = event;
		gdk_event_get_state (_tmp11_, &_tmp12_);
		self->priv->last_modifier_type = _tmp12_;
		_tmp13_ = conversation_list_view_get_selection_mode_enabled (self);
		_tmp14_ = _tmp13_;
		if (!_tmp14_) {
			gboolean _tmp15_ = FALSE;
			if ((self->priv->last_modifier_type & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
				_tmp15_ = TRUE;
			} else {
				_tmp15_ = (self->priv->last_modifier_type & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
			}
			if (_tmp15_) {
				conversation_list_view_set_selection_mode_enabled (self, TRUE);
			} else {
				ConversationListRow* _tmp16_;
				GearyAppConversation* _tmp17_;
				_tmp16_ = row;
				_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CONVERSATION_LIST_TYPE_ROW, ConversationListRow)->conversation;
				g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL], 0, _tmp17_, (guint) 1);
			}
		}
		__vala_GdkEvent_free0 (event);
		__vala_GdkEventSequence_free0 (sequence);
	} else {
		if (button == ((guint) 2)) {
			ConversationListRow* _tmp18_;
			GearyAppConversation* _tmp19_;
			_tmp18_ = row;
			_tmp19_ = _tmp18_->conversation;
			g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL], 0, _tmp19_, (guint) 2);
		} else {
			if (button == ((guint) 3)) {
				GdkRectangle rect = {0};
				ConversationListRow* _tmp20_;
				GtkListBox* _tmp21_;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				GdkRectangle _tmp24_;
				ConversationListRow* _tmp25_;
				GdkRectangle _tmp26_;
				memset (&rect, 0, sizeof (GdkRectangle));
				_tmp20_ = row;
				_tmp21_ = self->priv->list;
				gtk_widget_translate_coordinates (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), 0, 0, &_tmp22_, &_tmp23_);
				rect.x = _tmp22_;
				rect.y = _tmp23_;
				rect.x = (gint) x;
				_tmp24_ = rect;
				rect.y = ((gint) y) - _tmp24_.y;
				rect.height = 0;
				rect.width = rect.height;
				_tmp25_ = row;
				_tmp26_ = rect;
				conversation_list_view_context_menu (self, _tmp25_, &_tmp26_);
			}
		}
	}
	_g_object_unref0 (row);
}

static gboolean
conversation_list_view_on_key_event_controller_key_pressed (ConversationListView* self,
                                                            guint keyval,
                                                            guint keycode,
                                                            GdkModifierType modifier_type)
{
	gboolean result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_VIEW (self), FALSE);
	switch (keyval) {
		case GDK_KEY_Up:
		case GDK_KEY_Down:
		{
			if ((modifier_type & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
				conversation_list_view_set_selection_mode_enabled (self, TRUE);
			}
			break;
		}
		case GDK_KEY_Escape:
		{
			gboolean _tmp0_;
			gboolean _tmp1_;
			_tmp0_ = conversation_list_view_get_selection_mode_enabled (self);
			_tmp1_ = _tmp0_;
			if (_tmp1_) {
				conversation_list_view_set_selection_mode_enabled (self, FALSE);
				result = TRUE;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static void
conversation_list_view_on_drag_begin (ConversationListView* self,
                                      GdkDragContext* ctx)
{
	gint screen_x = 0;
	gint screen_y = 0;
	GdkModifierType _modifier = 0U;
	GdkWindow* _tmp0_;
	GdkDevice* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkModifierType _tmp4_ = 0U;
	ConversationListRow* row = NULL;
	GtkListBox* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	GtkListBoxRow* _tmp10_;
	ConversationListRow* _tmp11_;
	gboolean _tmp12_ = FALSE;
	ConversationListRow* _tmp13_;
	ApplicationConfiguration* _tmp18_;
	ConversationListRow* _tmp19_;
	GearyAppConversation* _tmp20_;
	ConversationListRow* _tmp21_;
	ConversationListRow* _tmp22_;
	ConversationListRow* _tmp23_;
	ConversationListRow* _tmp24_;
	GtkStyleContext* _tmp25_;
	ConversationListRow* _tmp26_;
	gint hot_x = 0;
	gint hot_y = 0;
	ConversationListRow* _tmp27_;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	ConversationListRow* _tmp30_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ctx, gdk_drag_context_get_type ()));
	_tmp0_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = gdk_drag_context_get_device (ctx);
	gdk_window_get_device_position (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	screen_x = _tmp2_;
	screen_y = _tmp3_;
	_modifier = _tmp4_;
	_tmp5_ = self->priv->list;
	_tmp6_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_adjustment_get_value (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_list_box_get_row_at_y (_tmp5_, screen_y + ((gint) _tmp9_));
	_tmp11_ = _g_object_ref0 (CONVERSATION_LIST_IS_ROW (_tmp10_) ? ((ConversationListRow*) _tmp10_) : NULL);
	row = _tmp11_;
	_tmp13_ = row;
	if (_tmp13_ != NULL) {
		ConversationListRow* _tmp14_;
		_tmp14_ = row;
		_tmp12_ = !gtk_list_box_row_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_list_box_row_get_type (), GtkListBoxRow));
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkListBox* _tmp15_;
		GtkListBox* _tmp16_;
		ConversationListRow* _tmp17_;
		_tmp15_ = self->priv->list;
		gtk_list_box_unselect_all (_tmp15_);
		_tmp16_ = self->priv->list;
		_tmp17_ = row;
		gtk_list_box_select_row (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_list_box_row_get_type (), GtkListBoxRow));
	}
	_tmp18_ = self->priv->config;
	_tmp19_ = row;
	_tmp20_ = _tmp19_->conversation;
	_tmp21_ = conversation_list_row_new (_tmp18_, _tmp20_, FALSE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->drag_widget);
	self->priv->drag_widget = _tmp21_;
	_tmp22_ = self->priv->drag_widget;
	_tmp23_ = row;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), "width-request", gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget)), NULL);
	_tmp24_ = self->priv->drag_widget;
	_tmp25_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp25_, "drag-n-drop");
	_tmp26_ = self->priv->drag_widget;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp27_ = row;
	gtk_widget_translate_coordinates (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), screen_x, screen_y, &_tmp28_, &_tmp29_);
	hot_x = _tmp28_;
	hot_y = _tmp29_;
	_tmp30_ = self->priv->drag_widget;
	gtk_drag_set_icon_widget (ctx, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget), hot_x, hot_y);
	_g_object_unref0 (row);
}

static void
conversation_list_view_on_drag_end (ConversationListView* self,
                                    GdkDragContext* ctx)
{
	ConversationListRow* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ctx, gdk_drag_context_get_type ()));
	_tmp0_ = self->priv->drag_widget;
	if (_tmp0_ != NULL) {
		ConversationListRow* _tmp1_;
		_tmp1_ = self->priv->drag_widget;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (self->priv->drag_widget);
		self->priv->drag_widget = NULL;
	}
}

static void
conversation_list_view_on_selected_rows_changed (ConversationListView* self)
{
	GeeSet* selected = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = conversation_list_view_get_selected_conversations (self);
	selected = _tmp0_;
	_tmp1_ = selected;
	if (!conversation_list_view_selection_changed (self, _tmp1_)) {
		_g_object_unref0 (selected);
		return;
	}
	_tmp2_ = selected;
	conversation_list_view_set_selected (self, _tmp2_);
	_tmp4_ = self->priv->_selected;
	_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		_tmp3_ = TRUE;
	} else {
		GtkListBoxRow* _tmp7_;
		_tmp7_ = self->priv->to_restore_row;
		_tmp3_ = _tmp7_ == NULL;
	}
	if (_tmp3_) {
		GeeSet* _tmp8_;
		_tmp8_ = self->priv->_selected;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATIONS_SELECTED_SIGNAL], 0, _tmp8_);
	}
	_g_object_unref0 (selected);
}

static void
conversation_list_view_on_row_activated (ConversationListView* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	if (_tmp3_ != NULL) {
		GtkListBoxRow* _tmp4_;
		GearyAppConversation* _tmp5_;
		_tmp4_ = row;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CONVERSATION_LIST_TYPE_ROW, ConversationListRow)->conversation;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL], 0, _tmp5_, (guint) 1);
	}
	_g_object_unref0 (row);
}

static void
__lambda25_ (ConversationListView* self,
             GtkWidget* child)
{
	ConversationListRow* row = NULL;
	ConversationListRow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, CONVERSATION_LIST_TYPE_ROW, ConversationListRow));
	row = _tmp0_;
	_tmp1_ = conversation_list_view_get_selection_mode_enabled (self);
	_tmp2_ = _tmp1_;
	conversation_list_row_set_selection_enabled (row, _tmp2_);
	_g_object_unref0 (row);
}

static void
___lambda25__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda25_ ((ConversationListView*) self, widget);
}

static void
conversation_list_view_on_selection_mode_changed (ConversationListView* self)
{
	GtkListBox* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (CONVERSATION_LIST_IS_VIEW (self));
	_tmp0_ = self->priv->list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), ___lambda25__gtk_callback, self);
	_tmp1_ = conversation_list_view_get_selection_mode_enabled (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkListBox* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GtkListBoxRow* _tmp5_;
		_tmp3_ = self->priv->list;
		_tmp4_ = gtk_list_box_get_selected_row (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (self->priv->to_restore_row);
		self->priv->to_restore_row = _tmp5_;
	} else {
		conversation_list_view_restore_row (self);
	}
}

static void
conversation_list_view_class_init (ConversationListViewClass * klass,
                                   gpointer klass_data)
{
	conversation_list_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationListView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_list_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_conversation_list_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_list_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_LIST_VIEW_SELECTION_MODE_ENABLED_PROPERTY, conversation_list_view_properties[CONVERSATION_LIST_VIEW_SELECTION_MODE_ENABLED_PROPERTY] = g_param_spec_boolean ("selection-mode-enabled", "selection-mode-enabled", "selection-mode-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_LIST_VIEW_SELECTED_PROPERTY, conversation_list_view_properties[CONVERSATION_LIST_VIEW_SELECTED_PROPERTY] = g_param_spec_object ("selected", "selected", "selected", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The set of all conversations currently displayed in the viewport
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_PROPERTY, conversation_list_view_properties[CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_PROPERTY] = g_param_spec_object ("visible-conversations", "visible-conversations", "visible-conversations", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/conversation-list-view.ui");
	/**
	     * Emitted when one or more conversations are selected
	     */
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATIONS_SELECTED_SIGNAL] = g_signal_new ("conversations-selected", CONVERSATION_LIST_TYPE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_SET);
	/**
	     * Emitted when one conversation is activated
	     */
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL] = g_signal_new ("conversation-activated", CONVERSATION_LIST_TYPE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, GEARY_APP_TYPE_CONVERSATION, G_TYPE_UINT);
	/**
	     * Emitted when the user expresses intent to update the flags on a set of conversations
	     */
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL] = g_signal_new ("mark-conversations", CONVERSATION_LIST_TYPE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEARY_TYPE_NAMED_FLAG);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list", FALSE, ConversationListView_private_offset + G_STRUCT_OFFSET (ConversationListViewPrivate, list));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "conversation-list");
}

static void
conversation_list_view_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                            gpointer iface_data)
{
	conversation_list_view_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
conversation_list_view_instance_init (ConversationListView * self,
                                      gpointer klass)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = conversation_list_view_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_selected = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	self->priv->to_restore_row = NULL;
	self->priv->LOAD_MORE_THRESHOLD = (gdouble) 100;
	self->priv->LOAD_MORE_COUNT = 50;
	self->priv->VISIBILITY_UPDATE_DELAY_MS = 1000;
	_tmp1_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_visible_conversations = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
	self->priv->should_inhibit_autoactivate = FALSE;
	self->priv->drag_widget = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
conversation_list_view_finalize (GObject * obj)
{
	ConversationListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONVERSATION_LIST_TYPE_VIEW, ConversationListView);
	_g_object_unref0 (self->priv->_selected);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->press_gesture);
	_g_object_unref0 (self->priv->long_press_gesture);
	_g_object_unref0 (self->priv->key_event_controller);
	_g_object_unref0 (self->priv->to_restore_row);
	_g_object_unref0 (self->priv->model);
	_g_object_unref0 (self->priv->_visible_conversations);
	_g_object_unref0 (self->priv->scheduled_visible_update);
	_g_object_unref0 (self->priv->drag_widget);
	G_OBJECT_CLASS (conversation_list_view_parent_class)->finalize (obj);
}

/**
 * Represents in folder conversations list.
 *
 */
static GType
conversation_list_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationListViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_list_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationListView), 0, (GInstanceInitFunc) conversation_list_view_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) conversation_list_view_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType conversation_list_view_type_id;
	conversation_list_view_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "ConversationListView", &g_define_type_info, 0);
	g_type_add_interface_static (conversation_list_view_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ConversationListView_private_offset = g_type_add_instance_private (conversation_list_view_type_id, sizeof (ConversationListViewPrivate));
	return conversation_list_view_type_id;
}

GType
conversation_list_view_get_type (void)
{
	static volatile gsize conversation_list_view_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_view_type_id__once)) {
		GType conversation_list_view_type_id;
		conversation_list_view_type_id = conversation_list_view_get_type_once ();
		g_once_init_leave (&conversation_list_view_type_id__once, conversation_list_view_type_id);
	}
	return conversation_list_view_type_id__once;
}

static void
_vala_conversation_list_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	ConversationListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_LIST_TYPE_VIEW, ConversationListView);
	switch (property_id) {
		case CONVERSATION_LIST_VIEW_SELECTION_MODE_ENABLED_PROPERTY:
		g_value_set_boolean (value, conversation_list_view_get_selection_mode_enabled (self));
		break;
		case CONVERSATION_LIST_VIEW_SELECTED_PROPERTY:
		g_value_set_object (value, conversation_list_view_get_selected (self));
		break;
		case CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_PROPERTY:
		g_value_set_object (value, conversation_list_view_get_visible_conversations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_conversation_list_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	ConversationListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_LIST_TYPE_VIEW, ConversationListView);
	switch (property_id) {
		case CONVERSATION_LIST_VIEW_SELECTION_MODE_ENABLED_PROPERTY:
		conversation_list_view_set_selection_mode_enabled (self, g_value_get_boolean (value));
		break;
		case CONVERSATION_LIST_VIEW_SELECTED_PROPERTY:
		conversation_list_view_set_selected (self, g_value_get_object (value));
		break;
		case CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_PROPERTY:
		conversation_list_view_set_visible_conversations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

