/* plugin-folder-extension.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin-folder-extension.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static GType plugin_folder_extension_get_type_once (void);
static GType plugin_folder_context_get_type_once (void);

PluginFolderContext*
plugin_folder_extension_get_folders (PluginFolderExtension* self)
{
	PluginFolderExtensionIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER_EXTENSION (self), NULL);
	_iface_ = PLUGIN_FOLDER_EXTENSION_GET_INTERFACE (self);
	if (_iface_->get_folders) {
		return _iface_->get_folders (self);
	}
	return NULL;
}

void
plugin_folder_extension_set_folders (PluginFolderExtension* self,
                                     PluginFolderContext* value)
{
	PluginFolderExtensionIface* _iface_;
	g_return_if_fail (PLUGIN_IS_FOLDER_EXTENSION (self));
	_iface_ = PLUGIN_FOLDER_EXTENSION_GET_INTERFACE (self);
	if (_iface_->set_folders) {
		_iface_->set_folders (self, value);
	}
}

static void
plugin_folder_extension_default_init (PluginFolderExtensionIface * iface,
                                      gpointer iface_data)
{
	/**
	     * Context object for accessing folders.
	     *
	     * This will be set during (or just after) plugin construction,
	     * before {@link PluginBase.activate} is called.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("folders", "folders", "folders", PLUGIN_TYPE_FOLDER_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

/**
 * A plugin extension point for working with folders.
 */
static GType
plugin_folder_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginFolderExtensionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_folder_extension_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_folder_extension_type_id;
	plugin_folder_extension_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginFolderExtension", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_folder_extension_type_id, PLUGIN_TYPE_PLUGIN_BASE);
	return plugin_folder_extension_type_id;
}

GType
plugin_folder_extension_get_type (void)
{
	static volatile gsize plugin_folder_extension_type_id__once = 0;
	if (g_once_init_enter (&plugin_folder_extension_type_id__once)) {
		GType plugin_folder_extension_type_id;
		plugin_folder_extension_type_id = plugin_folder_extension_get_type_once ();
		g_once_init_leave (&plugin_folder_extension_type_id__once, plugin_folder_extension_type_id);
	}
	return plugin_folder_extension_type_id__once;
}

void
plugin_folder_context_get_folder_store (PluginFolderContext* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	PluginFolderContextIface* _iface_;
	_iface_ = PLUGIN_FOLDER_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_folder_store) {
		_iface_->get_folder_store (self, _callback_, _user_data_);
	}
}

PluginFolderStore*
plugin_folder_context_get_folder_store_finish (PluginFolderContext* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	PluginFolderContextIface* _iface_;
	_iface_ = PLUGIN_FOLDER_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_folder_store_finish) {
		return _iface_->get_folder_store_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Adds an info bar to a folder, if selected.
     *
     * The info bar will be shown for the given folder if it is
     * currently selected in any main window, which can be determined
     * by connecting to the {@link FolderStore.folder_selected}
     * signal. Further, if multiple info bars are added for the same
     * folder, only the one with a higher priority will be shown. If
     * that is closed or removed, the second highest will be shown,
     * and so on. Once the selected folder changes, the info bars will
     * be automatically removed.
     */
void
plugin_folder_context_add_folder_info_bar (PluginFolderContext* self,
                                           PluginFolder* selected,
                                           PluginInfoBar* infobar,
                                           guint priority)
{
	PluginFolderContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_FOLDER_CONTEXT (self));
	_iface_ = PLUGIN_FOLDER_CONTEXT_GET_INTERFACE (self);
	if (_iface_->add_folder_info_bar) {
		_iface_->add_folder_info_bar (self, selected, infobar, priority);
	}
}

/**
     * Removes an info bar from a folder, if selected.
     *
     * Removes the info bar from the given folder if it is currently
     * selected in any main window.
     */
void
plugin_folder_context_remove_folder_info_bar (PluginFolderContext* self,
                                              PluginFolder* selected,
                                              PluginInfoBar* infobar)
{
	PluginFolderContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_FOLDER_CONTEXT (self));
	_iface_ = PLUGIN_FOLDER_CONTEXT_GET_INTERFACE (self);
	if (_iface_->remove_folder_info_bar) {
		_iface_->remove_folder_info_bar (self, selected, infobar);
	}
}

/**
     * Registers a folder for a well-known use.
     *
     * This promotes a folder from a label to a special-use folder,
     * causing it to appear with other special-use folders with the
     * given name and icon.
     */
void
plugin_folder_context_register_folder_used_as (PluginFolderContext* self,
                                               PluginFolder* target,
                                               const gchar* name,
                                               const gchar* icon_name,
                                               GError** error)
{
	PluginFolderContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_FOLDER_CONTEXT (self));
	_iface_ = PLUGIN_FOLDER_CONTEXT_GET_INTERFACE (self);
	if (_iface_->register_folder_used_as) {
		_iface_->register_folder_used_as (self, target, name, icon_name, error);
	}
}

/**
     * Unregisters a folder for a well-known use.
     *
     * This demotes the folder from a special-use to an ordinary
     * label.
     */
void
plugin_folder_context_unregister_folder_used_as (PluginFolderContext* self,
                                                 PluginFolder* target,
                                                 GError** error)
{
	PluginFolderContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_FOLDER_CONTEXT (self));
	_iface_ = PLUGIN_FOLDER_CONTEXT_GET_INTERFACE (self);
	if (_iface_->unregister_folder_used_as) {
		_iface_->unregister_folder_used_as (self, target, error);
	}
}

static void
plugin_folder_context_default_init (PluginFolderContextIface * iface,
                                    gpointer iface_data)
{
}

/**
 * Provides a context for folder plugins.
 *
 * The context provides an interface for folder plugins to interface
 * with the Geary client application. Plugins that implement the
 * {@link FolderExtension} interface will be given an instance of this
 * class.
 *
 * @see Plugin.FolderExtension.folders
 */
static GType
plugin_folder_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginFolderContextIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_folder_context_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_folder_context_type_id;
	plugin_folder_context_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginFolderContext", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_folder_context_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_folder_context_type_id;
}

GType
plugin_folder_context_get_type (void)
{
	static volatile gsize plugin_folder_context_type_id__once = 0;
	if (g_once_init_enter (&plugin_folder_context_type_id__once)) {
		GType plugin_folder_context_type_id;
		plugin_folder_context_type_id = plugin_folder_context_get_type_once ();
		g_once_init_leave (&plugin_folder_context_type_id__once, plugin_folder_context_type_id);
	}
	return plugin_folder_context_type_id__once;
}

