/* imap-folder-root.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-folder-root.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_FOLDER_ROOT_0_PROPERTY,
	GEARY_IMAP_FOLDER_ROOT_INBOX_PROPERTY,
	GEARY_IMAP_FOLDER_ROOT_NUM_PROPERTIES
};
static GParamSpec* geary_imap_folder_root_properties[GEARY_IMAP_FOLDER_ROOT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyImapFolderRootPrivate {
	GearyFolderPath* _inbox;
};

static gint GearyImapFolderRoot_private_offset;
static gpointer geary_imap_folder_root_parent_class = NULL;

static void geary_imap_folder_root_set_inbox (GearyImapFolderRoot* self,
                                       GearyFolderPath* value);
static GearyFolderPath* geary_imap_folder_root_real_get_child (GearyFolderPath* base,
                                                        const gchar* basename,
                                                        GearyTrillian is_case_sensitive);
static void geary_imap_folder_root_finalize (GObject * obj);
static GType geary_imap_folder_root_get_type_once (void);
static void _vala_geary_imap_folder_root_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_geary_imap_folder_root_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
geary_imap_folder_root_get_instance_private (GearyImapFolderRoot* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapFolderRoot_private_offset);
}

GearyFolderPath*
geary_imap_folder_root_get_inbox (GearyImapFolderRoot* self)
{
	GearyFolderPath* result;
	GearyFolderPath* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_ROOT (self), NULL);
	_tmp0_ = self->priv->_inbox;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_folder_root_set_inbox (GearyImapFolderRoot* self,
                                  GearyFolderPath* value)
{
	GearyFolderPath* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_ROOT (self));
	old_value = geary_imap_folder_root_get_inbox (self);
	if (old_value != value) {
		GearyFolderPath* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_inbox);
		self->priv->_inbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_root_properties[GEARY_IMAP_FOLDER_ROOT_INBOX_PROPERTY]);
	}
}

GearyImapFolderRoot*
geary_imap_folder_root_construct (GType object_type,
                                  const gchar* label)
{
	GearyImapFolderRoot * self = NULL;
	GearyFolderPath* _tmp0_;
	GearyFolderPath* _tmp1_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (GearyImapFolderRoot*) geary_folder_root_construct (object_type, label, FALSE);
	_tmp0_ = GEARY_FOLDER_PATH_CLASS (geary_imap_folder_root_parent_class)->get_child (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot), GEARY_TYPE_FOLDER_PATH, GearyFolderPath), GEARY_IMAP_MAILBOX_SPECIFIER_CANONICAL_INBOX_NAME, GEARY_TRILLIAN_FALSE);
	_tmp1_ = _tmp0_;
	geary_imap_folder_root_set_inbox (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

GearyImapFolderRoot*
geary_imap_folder_root_new (const gchar* label)
{
	return geary_imap_folder_root_construct (GEARY_IMAP_TYPE_FOLDER_ROOT, label);
}

/**
     * Creates a path that is a child of this folder.
     *
     * If the given basename is that of the IMAP inbox, then {@link
     * inbox} will be returned.
     */
static GearyFolderPath*
geary_imap_folder_root_real_get_child (GearyFolderPath* base,
                                       const gchar* basename,
                                       GearyTrillian is_case_sensitive)
{
	GearyImapFolderRoot * self;
	GearyFolderPath* _tmp0_ = NULL;
	GearyFolderPath* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_FOLDER_ROOT, GearyImapFolderRoot);
	g_return_val_if_fail (basename != NULL, NULL);
	if (geary_imap_mailbox_specifier_is_inbox_name (basename)) {
		GearyFolderPath* _tmp1_;
		GearyFolderPath* _tmp2_;
		_tmp1_ = self->priv->_inbox;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GearyFolderPath* _tmp3_;
		_tmp3_ = GEARY_FOLDER_PATH_CLASS (geary_imap_folder_root_parent_class)->get_child (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot), GEARY_TYPE_FOLDER_PATH, GearyFolderPath), basename, is_case_sensitive);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static void
geary_imap_folder_root_class_init (GearyImapFolderRootClass * klass,
                                   gpointer klass_data)
{
	geary_imap_folder_root_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapFolderRoot_private_offset);
	((GearyFolderPathClass *) klass)->get_child = (GearyFolderPath* (*) (GearyFolderPath*, const gchar*, GearyTrillian)) geary_imap_folder_root_real_get_child;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_folder_root_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_folder_root_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_folder_root_finalize;
	/**
	     * The canonical path for the IMAP inbox.
	     *
	     * This specific path object will always be returned when a child
	     * with some case-insensitive version of the IMAP inbox mailbox is
	     * obtained via {@link get_child} from this root folder. However
	     * since multiple folder roots may be constructed, in general
	     * {@link FolderPath.equal_to} or {@link FolderPath.compare_to}
	     * should still be used for testing equality with this path.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_ROOT_INBOX_PROPERTY, geary_imap_folder_root_properties[GEARY_IMAP_FOLDER_ROOT_INBOX_PROPERTY] = g_param_spec_object ("inbox", "inbox", "inbox", GEARY_TYPE_FOLDER_PATH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_folder_root_instance_init (GearyImapFolderRoot * self,
                                      gpointer klass)
{
	self->priv = geary_imap_folder_root_get_instance_private (self);
}

static void
geary_imap_folder_root_finalize (GObject * obj)
{
	GearyImapFolderRoot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_FOLDER_ROOT, GearyImapFolderRoot);
	_g_object_unref0 (self->priv->_inbox);
	G_OBJECT_CLASS (geary_imap_folder_root_parent_class)->finalize (obj);
}

/**
 * The root of all IMAP mailbox paths.
 *
 * Because IMAP has peculiar requirements about its mailbox paths (in
 * particular, Inbox is guaranteed at the root and is named
 * case-insensitive, and that delimiters are particular to each path),
 * this class ensure certain requirements are held throughout the
 * library.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_folder_root_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapFolderRootClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_folder_root_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapFolderRoot), 0, (GInstanceInitFunc) geary_imap_folder_root_instance_init, NULL };
	GType geary_imap_folder_root_type_id;
	geary_imap_folder_root_type_id = g_type_register_static (GEARY_TYPE_FOLDER_ROOT, "GearyImapFolderRoot", &g_define_type_info, 0);
	GearyImapFolderRoot_private_offset = g_type_add_instance_private (geary_imap_folder_root_type_id, sizeof (GearyImapFolderRootPrivate));
	return geary_imap_folder_root_type_id;
}

GType
geary_imap_folder_root_get_type (void)
{
	static gsize geary_imap_folder_root_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_folder_root_type_id__once)) {
		GType geary_imap_folder_root_type_id;
		geary_imap_folder_root_type_id = geary_imap_folder_root_get_type_once ();
		g_once_init_leave (&geary_imap_folder_root_type_id__once, geary_imap_folder_root_type_id);
	}
	return geary_imap_folder_root_type_id__once;
}

static void
_vala_geary_imap_folder_root_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapFolderRoot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FOLDER_ROOT, GearyImapFolderRoot);
	switch (property_id) {
		case GEARY_IMAP_FOLDER_ROOT_INBOX_PROPERTY:
		g_value_set_object (value, geary_imap_folder_root_get_inbox (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_folder_root_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapFolderRoot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FOLDER_ROOT, GearyImapFolderRoot);
	switch (property_id) {
		case GEARY_IMAP_FOLDER_ROOT_INBOX_PROPERTY:
		geary_imap_folder_root_set_inbox (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

