/* nonblocking-variants.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nonblocking-variants.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_NONBLOCKING_SEMAPHORE_0_PROPERTY,
	GEARY_NONBLOCKING_SEMAPHORE_NUM_PROPERTIES
};
static GParamSpec* geary_nonblocking_semaphore_properties[GEARY_NONBLOCKING_SEMAPHORE_NUM_PROPERTIES];
enum  {
	GEARY_NONBLOCKING_EVENT_0_PROPERTY,
	GEARY_NONBLOCKING_EVENT_NUM_PROPERTIES
};
static GParamSpec* geary_nonblocking_event_properties[GEARY_NONBLOCKING_EVENT_NUM_PROPERTIES];
enum  {
	GEARY_NONBLOCKING_SPINLOCK_0_PROPERTY,
	GEARY_NONBLOCKING_SPINLOCK_NUM_PROPERTIES
};
static GParamSpec* geary_nonblocking_spinlock_properties[GEARY_NONBLOCKING_SPINLOCK_NUM_PROPERTIES];

static gpointer geary_nonblocking_semaphore_parent_class = NULL;
static gpointer geary_nonblocking_event_parent_class = NULL;
static gpointer geary_nonblocking_spinlock_parent_class = NULL;

static GType geary_nonblocking_semaphore_get_type_once (void);
static GType geary_nonblocking_event_get_type_once (void);
static GType geary_nonblocking_spinlock_get_type_once (void);

/**
     * Constructs a new semaphore lock.
     *
     * The new lock is initially not able to be passed.
     */
GearyNonblockingSemaphore*
geary_nonblocking_semaphore_construct (GType object_type,
                                       GCancellable* cancellable)
{
	GearyNonblockingSemaphore * self = NULL;
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyNonblockingSemaphore*) geary_nonblocking_lock_construct (object_type, TRUE, FALSE, cancellable);
	return self;
}

GearyNonblockingSemaphore*
geary_nonblocking_semaphore_new (GCancellable* cancellable)
{
	return geary_nonblocking_semaphore_construct (GEARY_NONBLOCKING_TYPE_SEMAPHORE, cancellable);
}

static void
geary_nonblocking_semaphore_class_init (GearyNonblockingSemaphoreClass * klass,
                                        gpointer klass_data)
{
	geary_nonblocking_semaphore_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_nonblocking_semaphore_instance_init (GearyNonblockingSemaphore * self,
                                           gpointer klass)
{
}

/**
 * A broadcasting, manually-resetting asynchronous lock.
 *
 * This lock type will notify all waiting asynchronous tasks when
 * marked as being safe to pass, and requires a call to {@link
 * Lock.reset} to be marked as unsafe again.
 *
 * This class is ''not'' thread safe and should only be used by
 * asynchronous tasks.
 *
 * @see Lock
 */
 G_GNUC_NO_INLINE static GType
geary_nonblocking_semaphore_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyNonblockingSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_nonblocking_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyNonblockingSemaphore), 0, (GInstanceInitFunc) geary_nonblocking_semaphore_instance_init, NULL };
	GType geary_nonblocking_semaphore_type_id;
	geary_nonblocking_semaphore_type_id = g_type_register_static (GEARY_NONBLOCKING_TYPE_LOCK, "GearyNonblockingSemaphore", &g_define_type_info, 0);
	return geary_nonblocking_semaphore_type_id;
}

GType
geary_nonblocking_semaphore_get_type (void)
{
	static gsize geary_nonblocking_semaphore_type_id__once = 0;
	if (g_once_init_enter (&geary_nonblocking_semaphore_type_id__once)) {
		GType geary_nonblocking_semaphore_type_id;
		geary_nonblocking_semaphore_type_id = geary_nonblocking_semaphore_get_type_once ();
		g_once_init_leave (&geary_nonblocking_semaphore_type_id__once, geary_nonblocking_semaphore_type_id);
	}
	return geary_nonblocking_semaphore_type_id__once;
}

/**
     * Constructs a new event lock.
     *
     * The new lock is initially not able to be passed.
     */
GearyNonblockingEvent*
geary_nonblocking_event_construct (GType object_type,
                                   GCancellable* cancellable)
{
	GearyNonblockingEvent * self = NULL;
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyNonblockingEvent*) geary_nonblocking_lock_construct (object_type, TRUE, TRUE, cancellable);
	return self;
}

GearyNonblockingEvent*
geary_nonblocking_event_new (GCancellable* cancellable)
{
	return geary_nonblocking_event_construct (GEARY_NONBLOCKING_TYPE_EVENT, cancellable);
}

static void
geary_nonblocking_event_class_init (GearyNonblockingEventClass * klass,
                                    gpointer klass_data)
{
	geary_nonblocking_event_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_nonblocking_event_instance_init (GearyNonblockingEvent * self,
                                       gpointer klass)
{
}

/**
 * A broadcasting, automatically-resetting asynchronous lock.
 *
 * This lock type will notify all waiting asynchronous tasks when
 * marked as being safe to pass, and will automatically reset as being
 * unsafe to pass after doing so.
 *
 * This class is ''not'' thread safe and should only be used by
 * asynchronous tasks.
 *
 * @see Lock
 */
 G_GNUC_NO_INLINE static GType
geary_nonblocking_event_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyNonblockingEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_nonblocking_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyNonblockingEvent), 0, (GInstanceInitFunc) geary_nonblocking_event_instance_init, NULL };
	GType geary_nonblocking_event_type_id;
	geary_nonblocking_event_type_id = g_type_register_static (GEARY_NONBLOCKING_TYPE_LOCK, "GearyNonblockingEvent", &g_define_type_info, 0);
	return geary_nonblocking_event_type_id;
}

GType
geary_nonblocking_event_get_type (void)
{
	static gsize geary_nonblocking_event_type_id__once = 0;
	if (g_once_init_enter (&geary_nonblocking_event_type_id__once)) {
		GType geary_nonblocking_event_type_id;
		geary_nonblocking_event_type_id = geary_nonblocking_event_get_type_once ();
		g_once_init_leave (&geary_nonblocking_event_type_id__once, geary_nonblocking_event_type_id);
	}
	return geary_nonblocking_event_type_id__once;
}

/**
     * Constructs a new spin lock.
     *
     * The new lock is initially not able to be passed.
     */
GearyNonblockingSpinlock*
geary_nonblocking_spinlock_construct (GType object_type,
                                      GCancellable* cancellable)
{
	GearyNonblockingSpinlock * self = NULL;
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyNonblockingSpinlock*) geary_nonblocking_lock_construct (object_type, FALSE, TRUE, cancellable);
	return self;
}

GearyNonblockingSpinlock*
geary_nonblocking_spinlock_new (GCancellable* cancellable)
{
	return geary_nonblocking_spinlock_construct (GEARY_NONBLOCKING_TYPE_SPINLOCK, cancellable);
}

static void
geary_nonblocking_spinlock_class_init (GearyNonblockingSpinlockClass * klass,
                                       gpointer klass_data)
{
	geary_nonblocking_spinlock_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_nonblocking_spinlock_instance_init (GearyNonblockingSpinlock * self,
                                          gpointer klass)
{
}

/**
 * A single-task-notifying, automatically-resetting asynchronous lock.
 *
 * This lock type will the first asynchronous task waiting when marked
 * as being safe to pass, and will automatically reset as being unsafe
 * to pass after doing so.
 *
 * This class is ''not'' thread safe and should only be used by
 * asynchronous tasks.
 *
 * @see Lock
 */
 G_GNUC_NO_INLINE static GType
geary_nonblocking_spinlock_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyNonblockingSpinlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_nonblocking_spinlock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyNonblockingSpinlock), 0, (GInstanceInitFunc) geary_nonblocking_spinlock_instance_init, NULL };
	GType geary_nonblocking_spinlock_type_id;
	geary_nonblocking_spinlock_type_id = g_type_register_static (GEARY_NONBLOCKING_TYPE_LOCK, "GearyNonblockingSpinlock", &g_define_type_info, 0);
	return geary_nonblocking_spinlock_type_id;
}

GType
geary_nonblocking_spinlock_get_type (void)
{
	static gsize geary_nonblocking_spinlock_type_id__once = 0;
	if (g_once_init_enter (&geary_nonblocking_spinlock_type_id__once)) {
		GType geary_nonblocking_spinlock_type_id;
		geary_nonblocking_spinlock_type_id = geary_nonblocking_spinlock_get_type_once ();
		g_once_init_leave (&geary_nonblocking_spinlock_type_id__once, geary_nonblocking_spinlock_type_id);
	}
	return geary_nonblocking_spinlock_type_id__once;
}

