/* util-config-file.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-config-file.vala, do not modify */

/*
 * Copyright 2018 Michael James Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _geary_config_file_unref0(var) ((var == NULL) ? NULL : (var = (geary_config_file_unref (var), NULL)))
typedef struct _Block116Data Block116Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyConfigFileLoadData GearyConfigFileLoadData;
typedef struct _Block117Data Block117Data;
typedef struct _GearyConfigFileSaveData GearyConfigFileSaveData;

#define GEARY_CONFIG_FILE_GROUP_TYPE_GROUP_LOOKUP (geary_config_file_group_group_lookup_get_type ())
typedef struct _GearyConfigFileGroupGroupLookup GearyConfigFileGroupGroupLookup;
typedef struct _GearyConfigFileParamSpecGroup GearyConfigFileParamSpecGroup;
typedef struct _GearyParamSpecConfigFile GearyParamSpecConfigFile;

struct _GearyConfigFilePrivate {
	GFile* config_file;
	GKeyFile* backing;
};

struct _Block116Data {
	int _ref_count_;
	GearyConfigFile* self;
	GError* thrown;
	gpointer _async_data_;
};

struct _GearyConfigFileLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyConfigFile* self;
	GCancellable* cancellable;
	Block116Data* _data116_;
	GearyNonblockingConcurrent* _tmp0_;
	GearyNonblockingConcurrent* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_;
};

struct _Block117Data {
	int _ref_count_;
	GearyConfigFile* self;
	GError* thrown;
	gpointer _async_data_;
};

struct _GearyConfigFileSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyConfigFile* self;
	GCancellable* cancellable;
	Block117Data* _data117_;
	GearyNonblockingConcurrent* _tmp0_;
	GearyNonblockingConcurrent* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_;
};

struct _GearyConfigFileGroupGroupLookup {
	gchar* group;
	gchar* prefix;
};

struct _GearyConfigFileGroupPrivate {
	GearyConfigFile* _file;
	gchar* _name;
	GKeyFile* backing;
	GearyConfigFileGroupGroupLookup* lookups;
	gint lookups_length1;
	gint _lookups_size_;
};

struct _GearyConfigFileParamSpecGroup {
	GParamSpec parent_instance;
};

struct _GearyParamSpecConfigFile {
	GParamSpec parent_instance;
};

static gint GearyConfigFile_private_offset;
static gpointer geary_config_file_parent_class = NULL;
static gint GearyConfigFileGroup_private_offset;
static gpointer geary_config_file_group_parent_class = NULL;

VALA_EXTERN GearyConfigFileGroup* geary_config_file_group_new (GearyConfigFile* file,
                                                   const gchar* name,
                                                   GKeyFile* backing);
VALA_EXTERN GearyConfigFileGroup* geary_config_file_group_construct (GType object_type,
                                                         GearyConfigFile* file,
                                                         const gchar* name,
                                                         GKeyFile* backing);
static void geary_config_file_load_data_free (gpointer _data);
static gboolean geary_config_file_load_co (GearyConfigFileLoadData* _data_);
static Block116Data* block116_data_ref (Block116Data* _data116_);
static void block116_data_unref (void * _userdata_);
static void __lambda179_ (Block116Data* _data116_,
                   GError** error);
static void ___lambda179__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                     gpointer self,
                                                                     GError** error);
static void geary_config_file_load_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void geary_config_file_save_data_free (gpointer _data);
static gboolean geary_config_file_save_co (GearyConfigFileSaveData* _data_);
static Block117Data* block117_data_ref (Block117Data* _data117_);
static void block117_data_unref (void * _userdata_);
static void __lambda180_ (Block117Data* _data117_,
                   GError** error);
static void ___lambda180__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                     gpointer self,
                                                                     GError** error);
static void geary_config_file_save_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static GType geary_config_file_group_group_lookup_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GearyConfigFileGroupGroupLookup* geary_config_file_group_group_lookup_dup (const GearyConfigFileGroupGroupLookup* self);
static void geary_config_file_group_group_lookup_free (GearyConfigFileGroupGroupLookup* self);
static void geary_config_file_group_group_lookup_copy (const GearyConfigFileGroupGroupLookup* self,
                                                GearyConfigFileGroupGroupLookup* dest);
static void geary_config_file_group_group_lookup_destroy (GearyConfigFileGroupGroupLookup* self);
static void geary_config_file_group_set_file (GearyConfigFileGroup* self,
                                       GearyConfigFile* value);
static void geary_config_file_group_set_name (GearyConfigFileGroup* self,
                                       const gchar* value);
static void _vala_GearyConfigFileGroupGroupLookup_array_free (GearyConfigFileGroupGroupLookup * array,
                                                       gssize array_length);
static void geary_config_file_group_group_lookup_init (GearyConfigFileGroupGroupLookup *self,
                                                const gchar* group,
                                                const gchar* prefix);
static void geary_config_file_group_finalize (GearyConfigFileGroup * obj);
static GType geary_config_file_group_get_type_once (void);
static void geary_config_file_finalize (GearyConfigFile * obj);
static GType geary_config_file_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_config_file_get_instance_private (GearyConfigFile* self)
{
	return G_STRUCT_MEMBER_P (self, GearyConfigFile_private_offset);
}

GFile*
geary_config_file_get_file (GearyConfigFile* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CONFIG_FILE (self), NULL);
	_tmp0_ = self->priv->config_file;
	result = _tmp0_;
	return result;
}

/**
     * Constructs a config file using the specified on-disk file.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyConfigFile*
geary_config_file_construct (GType object_type,
                             GFile* config_file)
{
	GearyConfigFile* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config_file, g_file_get_type ()), NULL);
	self = (GearyConfigFile*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (config_file);
	_g_object_unref0 (self->priv->config_file);
	self->priv->config_file = _tmp0_;
	return self;
}

GearyConfigFile*
geary_config_file_new (GFile* config_file)
{
	return geary_config_file_construct (GEARY_TYPE_CONFIG_FILE, config_file);
}

/**
     * Returns the config key group under the given heading name.
     *
     * If the group does not already exist, it will be created when a
     * key is first set, but an error will be thrown if a value is
     * accessed from it before doing so. Use {@link Group.exists} to
     * determine if the group has previously been created.
     */
GearyConfigFileGroup*
geary_config_file_get_group (GearyConfigFile* self,
                             const gchar* name)
{
	GKeyFile* _tmp0_;
	GearyConfigFileGroup* _tmp1_;
	GearyConfigFileGroup* result;
	g_return_val_if_fail (GEARY_IS_CONFIG_FILE (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->backing;
	_tmp1_ = geary_config_file_group_new (self, name, _tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_config_file_load_data_free (gpointer _data)
{
	GearyConfigFileLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_config_file_unref0 (_data_->self);
	g_slice_free (GearyConfigFileLoadData, _data_);
}

static gpointer
_geary_config_file_ref0 (gpointer self)
{
	return self ? geary_config_file_ref (self) : NULL;
}

void
geary_config_file_load (GearyConfigFile* self,
                        GCancellable* cancellable,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GearyConfigFileLoadData* _data_;
	GearyConfigFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IS_CONFIG_FILE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyConfigFileLoadData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_config_file_load_data_free);
	_tmp0_ = _geary_config_file_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_config_file_load_co (_data_);
}

void
geary_config_file_load_finish (GearyConfigFile* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GearyConfigFileLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Loads config data from the underlying config file.
     */
static Block116Data*
block116_data_ref (Block116Data* _data116_)
{
	g_atomic_int_inc (&_data116_->_ref_count_);
	return _data116_;
}

static void
block116_data_unref (void * _userdata_)
{
	Block116Data* _data116_;
	_data116_ = (Block116Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data116_->_ref_count_)) {
		GearyConfigFile* self;
		self = _data116_->self;
		_g_error_free0 (_data116_->thrown);
		_geary_config_file_unref0 (self);
		g_slice_free (Block116Data, _data116_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda179_ (Block116Data* _data116_,
              GError** error)
{
	GearyConfigFile* self;
	GError* _inner_error0_ = NULL;
	self = _data116_->self;
	{
		GKeyFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = self->priv->backing;
		_tmp1_ = self->priv->config_file;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_file (_tmp0_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (_data116_->thrown);
		_data116_->thrown = _tmp5_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda179__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                gpointer self,
                                                                GError** error)
{
	__lambda179_ (self, error);
}

static void
geary_config_file_load_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GearyConfigFileLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_config_file_load_co (_data_);
}

static gboolean
geary_config_file_load_co (GearyConfigFileLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data116_ = g_slice_new0 (Block116Data);
	_data_->_data116_->_ref_count_ = 1;
	_data_->_data116_->self = geary_config_file_ref (_data_->self);
	_data_->_data116_->_async_data_ = _data_;
	_data_->_data116_->thrown = NULL;
	_data_->_tmp0_ = geary_nonblocking_concurrent_get_global ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_nonblocking_concurrent_schedule_async (_data_->_tmp1_, ___lambda179__geary_nonblocking_concurrent_concurrent_callback, _data_->_data116_, _data_->cancellable, geary_config_file_load_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_concurrent_schedule_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block116_data_unref (_data_->_data116_);
		_data_->_data116_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_data116_->thrown;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->_data116_->thrown;
		_data_->_tmp4_ = _g_error_copy0 (_data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block116_data_unref (_data_->_data116_);
		_data_->_data116_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block116_data_unref (_data_->_data116_);
	_data_->_data116_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_config_file_save_data_free (gpointer _data)
{
	GearyConfigFileSaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_config_file_unref0 (_data_->self);
	g_slice_free (GearyConfigFileSaveData, _data_);
}

void
geary_config_file_save (GearyConfigFile* self,
                        GCancellable* cancellable,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GearyConfigFileSaveData* _data_;
	GearyConfigFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IS_CONFIG_FILE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyConfigFileSaveData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_config_file_save_data_free);
	_tmp0_ = _geary_config_file_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_config_file_save_co (_data_);
}

void
geary_config_file_save_finish (GearyConfigFile* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GearyConfigFileSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Saves config data to the underlying config file.
     */
static Block117Data*
block117_data_ref (Block117Data* _data117_)
{
	g_atomic_int_inc (&_data117_->_ref_count_);
	return _data117_;
}

static void
block117_data_unref (void * _userdata_)
{
	Block117Data* _data117_;
	_data117_ = (Block117Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data117_->_ref_count_)) {
		GearyConfigFile* self;
		self = _data117_->self;
		_g_error_free0 (_data117_->thrown);
		_geary_config_file_unref0 (self);
		g_slice_free (Block117Data, _data117_);
	}
}

static void
__lambda180_ (Block117Data* _data117_,
              GError** error)
{
	GearyConfigFile* self;
	GError* _inner_error0_ = NULL;
	self = _data117_->self;
	{
		GKeyFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = self->priv->backing;
		_tmp1_ = self->priv->config_file;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		g_key_file_save_to_file (_tmp0_, _tmp3_, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (_data117_->thrown);
		_data117_->thrown = _tmp5_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda180__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                gpointer self,
                                                                GError** error)
{
	__lambda180_ (self, error);
}

static void
geary_config_file_save_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GearyConfigFileSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_config_file_save_co (_data_);
}

static gboolean
geary_config_file_save_co (GearyConfigFileSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data117_ = g_slice_new0 (Block117Data);
	_data_->_data117_->_ref_count_ = 1;
	_data_->_data117_->self = geary_config_file_ref (_data_->self);
	_data_->_data117_->_async_data_ = _data_;
	_data_->_data117_->thrown = NULL;
	_data_->_tmp0_ = geary_nonblocking_concurrent_get_global ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_nonblocking_concurrent_schedule_async (_data_->_tmp1_, ___lambda180__geary_nonblocking_concurrent_concurrent_callback, _data_->_data117_, _data_->cancellable, geary_config_file_save_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_concurrent_schedule_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block117_data_unref (_data_->_data117_);
		_data_->_data117_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_data117_->thrown;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->_data117_->thrown;
		_data_->_tmp4_ = _g_error_copy0 (_data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block117_data_unref (_data_->_data117_);
		_data_->_data117_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block117_data_unref (_data_->_data117_);
	_data_->_data117_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline gpointer
geary_config_file_group_get_instance_private (GearyConfigFileGroup* self)
{
	return G_STRUCT_MEMBER_P (self, GearyConfigFileGroup_private_offset);
}

GearyConfigFile*
geary_config_file_group_get_file (GearyConfigFileGroup* self)
{
	GearyConfigFile* result;
	GearyConfigFile* _tmp0_;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
geary_config_file_group_set_file (GearyConfigFileGroup* self,
                                  GearyConfigFile* value)
{
	GearyConfigFile* _tmp0_;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	_tmp0_ = _geary_config_file_ref0 (value);
	_geary_config_file_unref0 (self->priv->_file);
	self->priv->_file = _tmp0_;
}

const gchar*
geary_config_file_group_get_name (GearyConfigFileGroup* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
geary_config_file_group_set_name (GearyConfigFileGroup* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

gboolean
geary_config_file_group_get_exists (GearyConfigFileGroup* self)
{
	gboolean result;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), FALSE);
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	result = g_key_file_has_group (_tmp0_, _tmp1_);
	return result;
}

static void
_vala_GearyConfigFileGroupGroupLookup_array_free (GearyConfigFileGroupGroupLookup * array,
                                                  gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			geary_config_file_group_group_lookup_destroy (&array[i]);
		}
	}
	g_free (array);
}

static gpointer
_g_key_file_ref0 (gpointer self)
{
	return self ? g_key_file_ref (self) : NULL;
}

GearyConfigFileGroup*
geary_config_file_group_construct (GType object_type,
                                   GearyConfigFile* file,
                                   const gchar* name,
                                   GKeyFile* backing)
{
	GearyConfigFileGroup* self = NULL;
	GKeyFile* _tmp0_;
	GearyConfigFileGroupGroupLookup _tmp1_ = {0};
	GearyConfigFileGroupGroupLookup* _tmp2_;
	g_return_val_if_fail (GEARY_IS_CONFIG_FILE (file), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (backing != NULL, NULL);
	self = (GearyConfigFileGroup*) g_type_create_instance (object_type);
	geary_config_file_group_set_file (self, file);
	geary_config_file_group_set_name (self, name);
	_tmp0_ = _g_key_file_ref0 (backing);
	_g_key_file_unref0 (self->priv->backing);
	self->priv->backing = _tmp0_;
	geary_config_file_group_group_lookup_init (&_tmp1_, name, "");
	_tmp2_ = g_new0 (GearyConfigFileGroupGroupLookup, 1);
	_tmp2_[0] = _tmp1_;
	self->priv->lookups = (_vala_GearyConfigFileGroupGroupLookup_array_free (self->priv->lookups, self->priv->lookups_length1), NULL);
	self->priv->lookups = _tmp2_;
	self->priv->lookups_length1 = 1;
	self->priv->_lookups_size_ = self->priv->lookups_length1;
	return self;
}

GearyConfigFileGroup*
geary_config_file_group_new (GearyConfigFile* file,
                             const gchar* name,
                             GKeyFile* backing)
{
	return geary_config_file_group_construct (GEARY_CONFIG_FILE_TYPE_GROUP, file, name, backing);
}

/**
         * Sets a fallback lookup for missing keys in the group.
         *
         * This provides a fallback for looking up a legacy key. If
         * set, when performing a lookup for `key` and no such key in
         * the group is found, a lookup in the alternative specified
         * group for `prefix` + `key` will be performed and returned
         * if found.
         */
void
geary_config_file_group_set_fallback (GearyConfigFileGroup* self,
                                      const gchar* group,
                                      const gchar* prefix)
{
	GearyConfigFileGroupGroupLookup* _tmp0_;
	gint _tmp0__length1;
	GearyConfigFileGroupGroupLookup _tmp1_;
	GearyConfigFileGroupGroupLookup _tmp2_;
	GearyConfigFileGroupGroupLookup _tmp3_ = {0};
	GearyConfigFileGroupGroupLookup _tmp4_ = {0};
	GearyConfigFileGroupGroupLookup* _tmp5_;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	g_return_if_fail (group != NULL);
	g_return_if_fail (prefix != NULL);
	_tmp0_ = self->priv->lookups;
	_tmp0__length1 = self->priv->lookups_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = _tmp1_;
	geary_config_file_group_group_lookup_copy (&_tmp2_, &_tmp3_);
	geary_config_file_group_group_lookup_init (&_tmp4_, group, prefix);
	_tmp5_ = g_new0 (GearyConfigFileGroupGroupLookup, 2);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	self->priv->lookups = (_vala_GearyConfigFileGroupGroupLookup_array_free (self->priv->lookups, self->priv->lookups_length1), NULL);
	self->priv->lookups = _tmp5_;
	self->priv->lookups_length1 = 2;
	self->priv->_lookups_size_ = self->priv->lookups_length1;
}

/** Determines if this group as a specific config key set. */
gboolean
geary_config_file_group_has_key (GearyConfigFileGroup* self,
                                 const gchar* name)
{
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->backing;
		_tmp2_ = self->priv->_name;
		_tmp0_ = g_key_file_has_key (_tmp1_, _tmp2_, name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp3_;
}

gchar*
geary_config_file_group_get_string (GearyConfigFileGroup* self,
                                    const gchar* key,
                                    const gchar* def)
{
	gchar* ret = NULL;
	gchar* _tmp0_;
	GearyConfigFileGroupGroupLookup* _tmp1_;
	gint _tmp1__length1;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_strdup (def);
	ret = _tmp0_;
	_tmp1_ = self->priv->lookups;
	_tmp1__length1 = self->priv->lookups_length1;
	{
		GearyConfigFileGroupGroupLookup* lookup_collection = NULL;
		gint lookup_collection_length1 = 0;
		gint _lookup_collection_size_ = 0;
		gint lookup_it = 0;
		lookup_collection = _tmp1_;
		lookup_collection_length1 = _tmp1__length1;
		for (lookup_it = 0; lookup_it < lookup_collection_length1; lookup_it = lookup_it + 1) {
			GearyConfigFileGroupGroupLookup _tmp2_;
			GearyConfigFileGroupGroupLookup _tmp3_ = {0};
			GearyConfigFileGroupGroupLookup lookup = {0};
			_tmp2_ = lookup_collection[lookup_it];
			geary_config_file_group_group_lookup_copy (&_tmp2_, &_tmp3_);
			lookup = _tmp3_;
			{
				{
					gchar* _tmp4_ = NULL;
					GKeyFile* _tmp5_;
					GearyConfigFileGroupGroupLookup _tmp6_;
					const gchar* _tmp7_;
					GearyConfigFileGroupGroupLookup _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp5_ = self->priv->backing;
					_tmp6_ = lookup;
					_tmp7_ = _tmp6_.group;
					_tmp8_ = lookup;
					_tmp9_ = _tmp8_.prefix;
					_tmp10_ = g_strconcat (_tmp9_, key, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_key_file_get_string (_tmp5_, _tmp7_, _tmp11_, &_inner_error0_);
					_tmp13_ = _tmp12_;
					_g_free0 (_tmp11_);
					_tmp4_ = _tmp13_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						geary_config_file_group_group_lookup_destroy (&lookup);
						_g_free0 (ret);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp14_ = _tmp4_;
					_tmp4_ = NULL;
					_g_free0 (ret);
					ret = _tmp14_;
					_g_free0 (_tmp4_);
					geary_config_file_group_group_lookup_destroy (&lookup);
					break;
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					geary_config_file_group_group_lookup_destroy (&lookup);
					_g_free0 (ret);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				geary_config_file_group_group_lookup_destroy (&lookup);
			}
		}
	}
	result = ret;
	return result;
}

gchar*
geary_config_file_group_get_required_string (GearyConfigFileGroup* self,
                                             const gchar* key,
                                             GError** error)
{
	gchar* ret = NULL;
	GError* key_err = NULL;
	GearyConfigFileGroupGroupLookup* _tmp0_;
	gint _tmp0__length1;
	GError* _tmp17_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	ret = NULL;
	key_err = NULL;
	_tmp0_ = self->priv->lookups;
	_tmp0__length1 = self->priv->lookups_length1;
	{
		GearyConfigFileGroupGroupLookup* lookup_collection = NULL;
		gint lookup_collection_length1 = 0;
		gint _lookup_collection_size_ = 0;
		gint lookup_it = 0;
		lookup_collection = _tmp0_;
		lookup_collection_length1 = _tmp0__length1;
		for (lookup_it = 0; lookup_it < lookup_collection_length1; lookup_it = lookup_it + 1) {
			GearyConfigFileGroupGroupLookup _tmp1_;
			GearyConfigFileGroupGroupLookup _tmp2_ = {0};
			GearyConfigFileGroupGroupLookup lookup = {0};
			_tmp1_ = lookup_collection[lookup_it];
			geary_config_file_group_group_lookup_copy (&_tmp1_, &_tmp2_);
			lookup = _tmp2_;
			{
				{
					gchar* _tmp3_ = NULL;
					GKeyFile* _tmp4_;
					GearyConfigFileGroupGroupLookup _tmp5_;
					const gchar* _tmp6_;
					GearyConfigFileGroupGroupLookup _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp4_ = self->priv->backing;
					_tmp5_ = lookup;
					_tmp6_ = _tmp5_.group;
					_tmp7_ = lookup;
					_tmp8_ = _tmp7_.prefix;
					_tmp9_ = g_strconcat (_tmp8_, key, NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_key_file_get_string (_tmp4_, _tmp6_, _tmp10_, &_inner_error0_);
					_tmp12_ = _tmp11_;
					_g_free0 (_tmp10_);
					_tmp3_ = _tmp12_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						geary_config_file_group_group_lookup_destroy (&lookup);
						_g_error_free0 (key_err);
						_g_free0 (ret);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp13_ = _tmp3_;
					_tmp3_ = NULL;
					_g_free0 (ret);
					ret = _tmp13_;
					_g_free0 (_tmp3_);
					geary_config_file_group_group_lookup_destroy (&lookup);
					break;
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					GError* err = NULL;
					GError* _tmp14_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp14_ = key_err;
					if (_tmp14_ == NULL) {
						GError* _tmp15_;
						GError* _tmp16_;
						_tmp15_ = err;
						_tmp16_ = _g_error_copy0 (_tmp15_);
						_g_error_free0 (key_err);
						key_err = _tmp16_;
					}
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						geary_config_file_group_group_lookup_destroy (&lookup);
						_g_error_free0 (key_err);
						_g_free0 (ret);
						return NULL;
					} else {
						geary_config_file_group_group_lookup_destroy (&lookup);
						_g_error_free0 (key_err);
						_g_free0 (ret);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				geary_config_file_group_group_lookup_destroy (&lookup);
			}
		}
	}
	_tmp17_ = key_err;
	if (_tmp17_ != NULL) {
		GError* _tmp18_;
		GError* _tmp19_;
		_tmp18_ = key_err;
		_tmp19_ = _g_error_copy0 (_tmp18_);
		_inner_error0_ = _tmp19_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_error_free0 (key_err);
			_g_free0 (ret);
			return NULL;
		} else {
			_g_error_free0 (key_err);
			_g_free0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = ret;
	_g_error_free0 (key_err);
	return result;
}

void
geary_config_file_group_set_string (GearyConfigFileGroup* self,
                                    const gchar* key,
                                    const gchar* value)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	g_key_file_set_string (_tmp0_, _tmp1_, key, value);
}

GeeList*
geary_config_file_group_get_string_list (GearyConfigFileGroup* self,
                                         const gchar* key)
{
	GeeArrayList* strs = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	strs = _tmp0_;
	{
		gchar** _tmp1_ = NULL;
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		gsize _tmp4_ = 0;
		gchar** _tmp5_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		_tmp2_ = self->priv->backing;
		_tmp3_ = self->priv->_name;
		_tmp5_ = g_key_file_get_string_list (_tmp2_, _tmp3_, key, &_tmp4_, &_inner_error0_);
		_tmp1_ = _tmp5_;
		_tmp1__length1 = _tmp4_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_object_unref0 (strs);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (strs, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_, (gint) _tmp1__length1);
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (strs);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (strs, GEE_TYPE_LIST, GeeList);
	return result;
}

GeeList*
geary_config_file_group_get_required_string_list (GearyConfigFileGroup* self,
                                                  const gchar* key,
                                                  GError** error)
{
	GeeArrayList* strs = NULL;
	GeeArrayList* _tmp0_;
	gchar** _tmp1_ = NULL;
	GKeyFile* _tmp2_;
	const gchar* _tmp3_;
	gsize _tmp4_ = 0;
	gchar** _tmp5_;
	gint _tmp1__length1;
	gint __tmp1__size_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	strs = _tmp0_;
	_tmp2_ = self->priv->backing;
	_tmp3_ = self->priv->_name;
	_tmp5_ = g_key_file_get_string_list (_tmp2_, _tmp3_, key, &_tmp4_, &_inner_error0_);
	_tmp1_ = _tmp5_;
	_tmp1__length1 = _tmp4_;
	__tmp1__size_ = _tmp1__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (strs);
			return NULL;
		} else {
			_g_object_unref0 (strs);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (strs, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_, (gint) _tmp1__length1);
	result = G_TYPE_CHECK_INSTANCE_CAST (strs, GEE_TYPE_LIST, GeeList);
	_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
geary_config_file_group_set_string_list (GearyConfigFileGroup* self,
                                         const gchar* key,
                                         GeeList* value)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	g_return_if_fail (key != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, GEE_TYPE_LIST));
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	_tmp3_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (value, GEE_TYPE_COLLECTION, GeeCollection), &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	g_key_file_set_string_list (_tmp0_, _tmp1_, key, (const gchar* const*) _tmp4_, (gint) _tmp2_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}

gboolean
geary_config_file_group_get_bool (GearyConfigFileGroup* self,
                                  const gchar* key,
                                  gboolean def)
{
	gboolean ret = FALSE;
	GearyConfigFileGroupGroupLookup* _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	ret = def;
	_tmp0_ = self->priv->lookups;
	_tmp0__length1 = self->priv->lookups_length1;
	{
		GearyConfigFileGroupGroupLookup* lookup_collection = NULL;
		gint lookup_collection_length1 = 0;
		gint _lookup_collection_size_ = 0;
		gint lookup_it = 0;
		lookup_collection = _tmp0_;
		lookup_collection_length1 = _tmp0__length1;
		for (lookup_it = 0; lookup_it < lookup_collection_length1; lookup_it = lookup_it + 1) {
			GearyConfigFileGroupGroupLookup _tmp1_;
			GearyConfigFileGroupGroupLookup _tmp2_ = {0};
			GearyConfigFileGroupGroupLookup lookup = {0};
			_tmp1_ = lookup_collection[lookup_it];
			geary_config_file_group_group_lookup_copy (&_tmp1_, &_tmp2_);
			lookup = _tmp2_;
			{
				{
					gboolean _tmp3_ = FALSE;
					GKeyFile* _tmp4_;
					GearyConfigFileGroupGroupLookup _tmp5_;
					const gchar* _tmp6_;
					GearyConfigFileGroupGroupLookup _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp4_ = self->priv->backing;
					_tmp5_ = lookup;
					_tmp6_ = _tmp5_.group;
					_tmp7_ = lookup;
					_tmp8_ = _tmp7_.prefix;
					_tmp9_ = g_strconcat (_tmp8_, key, NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_key_file_get_boolean (_tmp4_, _tmp6_, _tmp10_, &_inner_error0_);
					_g_free0 (_tmp10_);
					_tmp3_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp12_ = FALSE;
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						geary_config_file_group_group_lookup_destroy (&lookup);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp12_;
					}
					ret = _tmp3_;
					geary_config_file_group_group_lookup_destroy (&lookup);
					break;
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp13_ = FALSE;
					geary_config_file_group_group_lookup_destroy (&lookup);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp13_;
				}
				geary_config_file_group_group_lookup_destroy (&lookup);
			}
		}
	}
	result = ret;
	return result;
}

void
geary_config_file_group_set_bool (GearyConfigFileGroup* self,
                                  const gchar* key,
                                  gboolean value)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	g_key_file_set_boolean (_tmp0_, _tmp1_, key, value);
}

gint
geary_config_file_group_get_int (GearyConfigFileGroup* self,
                                 const gchar* key,
                                 gint def)
{
	gint ret = 0;
	GearyConfigFileGroupGroupLookup* _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), 0);
	g_return_val_if_fail (key != NULL, 0);
	ret = def;
	_tmp0_ = self->priv->lookups;
	_tmp0__length1 = self->priv->lookups_length1;
	{
		GearyConfigFileGroupGroupLookup* lookup_collection = NULL;
		gint lookup_collection_length1 = 0;
		gint _lookup_collection_size_ = 0;
		gint lookup_it = 0;
		lookup_collection = _tmp0_;
		lookup_collection_length1 = _tmp0__length1;
		for (lookup_it = 0; lookup_it < lookup_collection_length1; lookup_it = lookup_it + 1) {
			GearyConfigFileGroupGroupLookup _tmp1_;
			GearyConfigFileGroupGroupLookup _tmp2_ = {0};
			GearyConfigFileGroupGroupLookup lookup = {0};
			_tmp1_ = lookup_collection[lookup_it];
			geary_config_file_group_group_lookup_copy (&_tmp1_, &_tmp2_);
			lookup = _tmp2_;
			{
				{
					gint _tmp3_ = 0;
					GKeyFile* _tmp4_;
					GearyConfigFileGroupGroupLookup _tmp5_;
					const gchar* _tmp6_;
					GearyConfigFileGroupGroupLookup _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gint _tmp11_;
					_tmp4_ = self->priv->backing;
					_tmp5_ = lookup;
					_tmp6_ = _tmp5_.group;
					_tmp7_ = lookup;
					_tmp8_ = _tmp7_.prefix;
					_tmp9_ = g_strconcat (_tmp8_, key, NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_key_file_get_integer (_tmp4_, _tmp6_, _tmp10_, &_inner_error0_);
					_g_free0 (_tmp10_);
					_tmp3_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gint _tmp12_ = -1;
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						geary_config_file_group_group_lookup_destroy (&lookup);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp12_;
					}
					ret = _tmp3_;
					geary_config_file_group_group_lookup_destroy (&lookup);
					break;
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gint _tmp13_ = -1;
					geary_config_file_group_group_lookup_destroy (&lookup);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp13_;
				}
				geary_config_file_group_group_lookup_destroy (&lookup);
			}
		}
	}
	result = ret;
	return result;
}

void
geary_config_file_group_set_int (GearyConfigFileGroup* self,
                                 const gchar* key,
                                 gint value)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	g_key_file_set_integer (_tmp0_, _tmp1_, key, value);
}

guint16
geary_config_file_group_get_uint16 (GearyConfigFileGroup* self,
                                    const gchar* key,
                                    guint16 def)
{
	guint16 result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), 0U);
	g_return_val_if_fail (key != NULL, 0U);
	result = (guint16) geary_config_file_group_get_int (self, key, (gint) def);
	return result;
}

void
geary_config_file_group_set_uint16 (GearyConfigFileGroup* self,
                                    const gchar* key,
                                    guint16 value)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	g_key_file_set_integer (_tmp0_, _tmp1_, key, (gint) value);
}

gpointer
geary_config_file_group_parse_value (GearyConfigFileGroup* self,
                                     GType t_type,
                                     GBoxedCopyFunc t_dup_func,
                                     GDestroyNotify t_destroy_func,
                                     const gchar* key,
                                     GearyConfigFileParser parser,
                                     gpointer parser_target,
                                     gconstpointer def)
{
	gpointer value = NULL;
	gpointer _tmp0_;
	gchar* str = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gpointer result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = ((def != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) def) : ((gpointer) def);
	value = _tmp0_;
	_tmp1_ = geary_config_file_group_get_string (self, key, NULL);
	str = _tmp1_;
	_tmp2_ = str;
	if (_tmp2_ != NULL) {
		{
			gpointer _tmp3_ = NULL;
			const gchar* _tmp4_;
			gpointer _tmp5_;
			gpointer _tmp6_;
			_tmp4_ = str;
			_tmp5_ = parser (_tmp4_, parser_target, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				_g_free0 (str);
				((value == NULL) || (t_destroy_func == NULL)) ? NULL : (value = (t_destroy_func (value), NULL));
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp6_ = _tmp3_;
			_tmp3_ = NULL;
			((value == NULL) || (t_destroy_func == NULL)) ? NULL : (value = (t_destroy_func (value), NULL));
			value = _tmp6_;
			((_tmp3_ == NULL) || (t_destroy_func == NULL)) ? NULL : (_tmp3_ = (t_destroy_func (_tmp3_), NULL));
		}
		goto __finally0;
		__catch0_g_key_file_error:
		{
			GError* err = NULL;
			const gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = self->priv->_name;
			_tmp8_ = err;
			_tmp9_ = _tmp8_->message;
			g_debug ("util-config-file.vala:202: %s:%s value is invalid: %s", _tmp7_, key, _tmp9_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (str);
			((value == NULL) || (t_destroy_func == NULL)) ? NULL : (value = (t_destroy_func (value), NULL));
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = value;
	_g_free0 (str);
	return result;
}

gpointer
geary_config_file_group_parse_required_value (GearyConfigFileGroup* self,
                                              GType t_type,
                                              GBoxedCopyFunc t_dup_func,
                                              GDestroyNotify t_destroy_func,
                                              const gchar* key,
                                              GearyConfigFileParser parser,
                                              gpointer parser_target,
                                              GError** error)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gpointer result;
	g_return_val_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = geary_config_file_group_get_required_string (self, key, &_inner_error0_);
	str = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		gpointer _tmp1_ = NULL;
		const gchar* _tmp2_;
		gpointer _tmp3_;
		gpointer _tmp4_;
		_tmp2_ = str;
		_tmp3_ = parser (_tmp2_, parser_target, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_free0 (str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp4_;
		((_tmp1_ == NULL) || (t_destroy_func == NULL)) ? NULL : (_tmp1_ = (t_destroy_func (_tmp1_), NULL));
		_g_free0 (str);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* err = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = self->priv->_name;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, "%s:%s value is invalid: %s", _tmp5_, key, _tmp7_);
		_inner_error0_ = _tmp8_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (str);
		return NULL;
	} else {
		_g_free0 (str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

/** Removes a key from this group. */
void
geary_config_file_group_remove_key (GearyConfigFileGroup* self,
                                    const gchar* name,
                                    GError** error)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	g_key_file_remove_key (_tmp0_, _tmp1_, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/** Removes this group from the config file. */
void
geary_config_file_group_remove (GearyConfigFileGroup* self,
                                GError** error)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_CONFIG_FILE_IS_GROUP (self));
	_tmp0_ = self->priv->backing;
	_tmp1_ = self->priv->_name;
	g_key_file_remove_group (_tmp0_, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
geary_config_file_group_group_lookup_init (GearyConfigFileGroupGroupLookup *self,
                                           const gchar* group,
                                           const gchar* prefix)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (group != NULL);
	g_return_if_fail (prefix != NULL);
	memset (self, 0, sizeof (GearyConfigFileGroupGroupLookup));
	_tmp0_ = g_strdup (group);
	_g_free0 ((*self).group);
	(*self).group = _tmp0_;
	_tmp1_ = g_strdup (prefix);
	_g_free0 ((*self).prefix);
	(*self).prefix = _tmp1_;
}

static void
geary_config_file_group_group_lookup_copy (const GearyConfigFileGroupGroupLookup* self,
                                           GearyConfigFileGroupGroupLookup* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).group;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).group);
	(*dest).group = _tmp1_;
	_tmp2_ = (*self).prefix;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).prefix);
	(*dest).prefix = _tmp3_;
}

static void
geary_config_file_group_group_lookup_destroy (GearyConfigFileGroupGroupLookup* self)
{
	_g_free0 ((*self).group);
	_g_free0 ((*self).prefix);
}

static GearyConfigFileGroupGroupLookup*
geary_config_file_group_group_lookup_dup (const GearyConfigFileGroupGroupLookup* self)
{
	GearyConfigFileGroupGroupLookup* dup;
	dup = g_new0 (GearyConfigFileGroupGroupLookup, 1);
	geary_config_file_group_group_lookup_copy (self, dup);
	return dup;
}

static void
geary_config_file_group_group_lookup_free (GearyConfigFileGroupGroupLookup* self)
{
	geary_config_file_group_group_lookup_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
geary_config_file_group_group_lookup_get_type_once (void)
{
	GType geary_config_file_group_group_lookup_type_id;
	geary_config_file_group_group_lookup_type_id = g_boxed_type_register_static ("GearyConfigFileGroupGroupLookup", (GBoxedCopyFunc) geary_config_file_group_group_lookup_dup, (GBoxedFreeFunc) geary_config_file_group_group_lookup_free);
	return geary_config_file_group_group_lookup_type_id;
}

static GType
geary_config_file_group_group_lookup_get_type (void)
{
	static gsize geary_config_file_group_group_lookup_type_id__once = 0;
	if (g_once_init_enter (&geary_config_file_group_group_lookup_type_id__once)) {
		GType geary_config_file_group_group_lookup_type_id;
		geary_config_file_group_group_lookup_type_id = geary_config_file_group_group_lookup_get_type_once ();
		g_once_init_leave (&geary_config_file_group_group_lookup_type_id__once, geary_config_file_group_group_lookup_type_id);
	}
	return geary_config_file_group_group_lookup_type_id__once;
}

static void
geary_config_file_value_group_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_config_file_value_group_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_config_file_group_unref (value->data[0].v_pointer);
	}
}

static void
geary_config_file_value_group_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_config_file_group_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_config_file_value_group_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_config_file_value_group_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyConfigFileGroup * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_config_file_group_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_config_file_value_group_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	GearyConfigFileGroup ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_config_file_group_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_config_file_param_spec_group (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	GearyConfigFileParamSpecGroup* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_CONFIG_FILE_TYPE_GROUP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_config_file_value_get_group (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_CONFIG_FILE_TYPE_GROUP), NULL);
	return value->data[0].v_pointer;
}

void
geary_config_file_value_set_group (GValue* value,
                                   gpointer v_object)
{
	GearyConfigFileGroup * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_CONFIG_FILE_TYPE_GROUP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_CONFIG_FILE_TYPE_GROUP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_config_file_group_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_config_file_group_unref (old);
	}
}

void
geary_config_file_value_take_group (GValue* value,
                                    gpointer v_object)
{
	GearyConfigFileGroup * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_CONFIG_FILE_TYPE_GROUP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_CONFIG_FILE_TYPE_GROUP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_config_file_group_unref (old);
	}
}

static void
geary_config_file_group_class_init (GearyConfigFileGroupClass * klass,
                                    gpointer klass_data)
{
	geary_config_file_group_parent_class = g_type_class_peek_parent (klass);
	((GearyConfigFileGroupClass *) klass)->finalize = geary_config_file_group_finalize;
	g_type_class_adjust_private_offset (klass, &GearyConfigFileGroup_private_offset);
}

static void
geary_config_file_group_instance_init (GearyConfigFileGroup * self,
                                       gpointer klass)
{
	self->priv = geary_config_file_group_get_instance_private (self);
	self->ref_count = 1;
}

static void
geary_config_file_group_finalize (GearyConfigFileGroup * obj)
{
	GearyConfigFileGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_CONFIG_FILE_TYPE_GROUP, GearyConfigFileGroup);
	g_signal_handlers_destroy (self);
	_geary_config_file_unref0 (self->priv->_file);
	_g_free0 (self->priv->_name);
	_g_key_file_unref0 (self->priv->backing);
	self->priv->lookups = (_vala_GearyConfigFileGroupGroupLookup_array_free (self->priv->lookups, self->priv->lookups_length1), NULL);
}

/**
     * A set of configuration keys grouped under a "[Name]" heading.
     */
 G_GNUC_NO_INLINE static GType
geary_config_file_group_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_config_file_value_group_init, geary_config_file_value_group_free_value, geary_config_file_value_group_copy_value, geary_config_file_value_group_peek_pointer, "p", geary_config_file_value_group_collect_value, "p", geary_config_file_value_group_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyConfigFileGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_config_file_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyConfigFileGroup), 0, (GInstanceInitFunc) geary_config_file_group_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_config_file_group_type_id;
	geary_config_file_group_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyConfigFileGroup", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyConfigFileGroup_private_offset = g_type_add_instance_private (geary_config_file_group_type_id, sizeof (GearyConfigFileGroupPrivate));
	return geary_config_file_group_type_id;
}

GType
geary_config_file_group_get_type (void)
{
	static gsize geary_config_file_group_type_id__once = 0;
	if (g_once_init_enter (&geary_config_file_group_type_id__once)) {
		GType geary_config_file_group_type_id;
		geary_config_file_group_type_id = geary_config_file_group_get_type_once ();
		g_once_init_leave (&geary_config_file_group_type_id__once, geary_config_file_group_type_id);
	}
	return geary_config_file_group_type_id__once;
}

gpointer
geary_config_file_group_ref (gpointer instance)
{
	GearyConfigFileGroup * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_config_file_group_unref (gpointer instance)
{
	GearyConfigFileGroup * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_CONFIG_FILE_GROUP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
geary_value_config_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_value_config_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_config_file_unref (value->data[0].v_pointer);
	}
}

static void
geary_value_config_file_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_config_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_value_config_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_value_config_file_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyConfigFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_config_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_value_config_file_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	GearyConfigFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_config_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_param_spec_config_file (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	GearyParamSpecConfigFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_TYPE_CONFIG_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_value_get_config_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_TYPE_CONFIG_FILE), NULL);
	return value->data[0].v_pointer;
}

void
geary_value_set_config_file (GValue* value,
                             gpointer v_object)
{
	GearyConfigFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_TYPE_CONFIG_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_TYPE_CONFIG_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_config_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_config_file_unref (old);
	}
}

void
geary_value_take_config_file (GValue* value,
                              gpointer v_object)
{
	GearyConfigFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_TYPE_CONFIG_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_TYPE_CONFIG_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_config_file_unref (old);
	}
}

static void
geary_config_file_class_init (GearyConfigFileClass * klass,
                              gpointer klass_data)
{
	geary_config_file_parent_class = g_type_class_peek_parent (klass);
	((GearyConfigFileClass *) klass)->finalize = geary_config_file_finalize;
	g_type_class_adjust_private_offset (klass, &GearyConfigFile_private_offset);
}

static void
geary_config_file_instance_init (GearyConfigFile * self,
                                 gpointer klass)
{
	GKeyFile* _tmp0_;
	self->priv = geary_config_file_get_instance_private (self);
	_tmp0_ = g_key_file_new ();
	self->priv->backing = _tmp0_;
	self->ref_count = 1;
}

static void
geary_config_file_finalize (GearyConfigFile * obj)
{
	GearyConfigFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_CONFIG_FILE, GearyConfigFile);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->config_file);
	_g_key_file_unref0 (self->priv->backing);
}

/**
 * A simple ini-file-like configuration file.
 *
 * This class provides a convenient, high-level API for the {@link
 * GLib.KeyFile} class.
 */
 G_GNUC_NO_INLINE static GType
geary_config_file_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_value_config_file_init, geary_value_config_file_free_value, geary_value_config_file_copy_value, geary_value_config_file_peek_pointer, "p", geary_value_config_file_collect_value, "p", geary_value_config_file_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyConfigFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_config_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyConfigFile), 0, (GInstanceInitFunc) geary_config_file_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_config_file_type_id;
	geary_config_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyConfigFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyConfigFile_private_offset = g_type_add_instance_private (geary_config_file_type_id, sizeof (GearyConfigFilePrivate));
	return geary_config_file_type_id;
}

GType
geary_config_file_get_type (void)
{
	static gsize geary_config_file_type_id__once = 0;
	if (g_once_init_enter (&geary_config_file_type_id__once)) {
		GType geary_config_file_type_id;
		geary_config_file_type_id = geary_config_file_get_type_once ();
		g_once_init_leave (&geary_config_file_type_id__once, geary_config_file_type_id);
	}
	return geary_config_file_type_id__once;
}

gpointer
geary_config_file_ref (gpointer instance)
{
	GearyConfigFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_config_file_unref (gpointer instance)
{
	GearyConfigFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_CONFIG_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

