/* gitg-checkout-remote-branch-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-checkout-remote-branch-dialog.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2020 - Armandas Jarušauskas
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libgitg.h"
#include <glib.h>
#include <libgit2-glib/ggit.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG (gitg_checkout_remote_branch_dialog_get_type ())
#define GITG_CHECKOUT_REMOTE_BRANCH_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialog))
#define GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialogClass))
#define GITG_IS_CHECKOUT_REMOTE_BRANCH_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG))
#define GITG_IS_CHECKOUT_REMOTE_BRANCH_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG))
#define GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialogClass))

typedef struct _GitgCheckoutRemoteBranchDialog GitgCheckoutRemoteBranchDialog;
typedef struct _GitgCheckoutRemoteBranchDialogClass GitgCheckoutRemoteBranchDialogClass;
typedef struct _GitgCheckoutRemoteBranchDialogPrivate GitgCheckoutRemoteBranchDialogPrivate;
enum  {
	GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_0_PROPERTY,
	GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_NEW_BRANCH_NAME_PROPERTY,
	GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_REMOTE_BRANCH_NAME_PROPERTY,
	GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_TRACK_REMOTE_PROPERTY,
	GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_NUM_PROPERTIES
};
static GParamSpec* gitg_checkout_remote_branch_dialog_properties[GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgCheckoutRemoteBranchDialog {
	GtkDialog parent_instance;
	GitgCheckoutRemoteBranchDialogPrivate * priv;
};

struct _GitgCheckoutRemoteBranchDialogClass {
	GtkDialogClass parent_class;
};

struct _GitgCheckoutRemoteBranchDialogPrivate {
	GtkButton* d_button_create;
	GtkEntry* d_branch_name;
	GtkComboBoxText* d_remote_branch_name;
	GtkCheckButton* d_track_remote;
	GitgRepository* d_repository;
	GitgRef* d_remote_reference;
};

static gint GitgCheckoutRemoteBranchDialog_private_offset;
static gpointer gitg_checkout_remote_branch_dialog_parent_class = NULL;

VALA_EXTERN GType gitg_checkout_remote_branch_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgCheckoutRemoteBranchDialog, g_object_unref)
VALA_EXTERN GitgCheckoutRemoteBranchDialog* gitg_checkout_remote_branch_dialog_new (GtkWindow* parent,
                                                                        GitgRepository* repository,
                                                                        GitgRef* reference);
VALA_EXTERN GitgCheckoutRemoteBranchDialog* gitg_checkout_remote_branch_dialog_construct (GType object_type,
                                                                              GtkWindow* parent,
                                                                              GitgRepository* repository,
                                                                              GitgRef* reference);
static void gitg_checkout_remote_branch_dialog_real_show (GtkWidget* base);
static void gitg_checkout_remote_branch_dialog_update_entries (GitgCheckoutRemoteBranchDialog* self);
static gboolean gitg_checkout_remote_branch_dialog_entries_valid (GitgCheckoutRemoteBranchDialog* self);
VALA_EXTERN gchar* gitg_checkout_remote_branch_dialog_get_new_branch_name (GitgCheckoutRemoteBranchDialog* self);
static gint ___lambda13_ (GitgCheckoutRemoteBranchDialog* self,
                   const gchar* name);
static gint ____lambda13__ggit_references_name_callback (const gchar* name,
                                                  gpointer self);
VALA_EXTERN gchar* gitg_checkout_remote_branch_dialog_get_remote_branch_name (GitgCheckoutRemoteBranchDialog* self);
VALA_EXTERN gboolean gitg_checkout_remote_branch_dialog_get_track_remote (GitgCheckoutRemoteBranchDialog* self);
static GObject * gitg_checkout_remote_branch_dialog_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void _gitg_checkout_remote_branch_dialog___lambda14_ (GitgCheckoutRemoteBranchDialog* self);
static void __gitg_checkout_remote_branch_dialog___lambda14__gtk_editable_changed (GtkEditable* _sender,
                                                                            gpointer self);
static void _gitg_checkout_remote_branch_dialog___lambda15_ (GitgCheckoutRemoteBranchDialog* self);
static void __gitg_checkout_remote_branch_dialog___lambda15__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self);
static void gitg_checkout_remote_branch_dialog_finalize (GObject * obj);
static GType gitg_checkout_remote_branch_dialog_get_type_once (void);
static void _vala_gitg_checkout_remote_branch_dialog_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
gitg_checkout_remote_branch_dialog_get_instance_private (GitgCheckoutRemoteBranchDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCheckoutRemoteBranchDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgCheckoutRemoteBranchDialog*
gitg_checkout_remote_branch_dialog_construct (GType object_type,
                                              GtkWindow* parent,
                                              GitgRepository* repository,
                                              GitgRef* reference)
{
	GitgCheckoutRemoteBranchDialog * self = NULL;
	g_return_val_if_fail (reference != NULL, NULL);
	self = (GitgCheckoutRemoteBranchDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	if (parent != NULL) {
		gtk_window_set_transient_for ((GtkWindow*) self, parent);
	}
	if (repository != NULL) {
		GitgRepository* _tmp0_;
		_tmp0_ = _g_object_ref0 (repository);
		_g_object_unref0 (self->priv->d_repository);
		self->priv->d_repository = _tmp0_;
	}
	if (ggit_ref_is_remote ((GgitRef*) reference)) {
		GitgRef* _tmp1_;
		_tmp1_ = _g_object_ref0 (reference);
		_g_object_unref0 (self->priv->d_remote_reference);
		self->priv->d_remote_reference = _tmp1_;
	}
	return self;
}

GitgCheckoutRemoteBranchDialog*
gitg_checkout_remote_branch_dialog_new (GtkWindow* parent,
                                        GitgRepository* repository,
                                        GitgRef* reference)
{
	return gitg_checkout_remote_branch_dialog_construct (GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, parent, repository, reference);
}

static void
gitg_checkout_remote_branch_dialog_real_show (GtkWidget* base)
{
	GitgCheckoutRemoteBranchDialog * self;
	self = (GitgCheckoutRemoteBranchDialog*) base;
	GTK_WIDGET_CLASS (gitg_checkout_remote_branch_dialog_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	gitg_checkout_remote_branch_dialog_update_entries (self);
}

static gboolean
gitg_checkout_remote_branch_dialog_entries_valid (GitgCheckoutRemoteBranchDialog* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gitg_checkout_remote_branch_dialog_get_new_branch_name (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != 0;
	_g_free0 (_tmp3_);
	if (_tmp6_) {
		GtkComboBoxText* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->d_remote_branch_name;
		_tmp8_ = gtk_combo_box_text_get_active_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_ != NULL;
		_g_free0 (_tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gint
___lambda13_ (GitgCheckoutRemoteBranchDialog* self,
              const gchar* name)
{
	GitgRef* reference = NULL;
	gboolean _tmp5_ = FALSE;
	GitgRef* _tmp6_;
	GtkComboBoxText* _tmp8_;
	GitgRef* _tmp9_;
	GitgParsedRefName* _tmp10_;
	GitgParsedRefName* _tmp11_;
	GitgParsedRefName* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GitgRef* _tmp16_;
	GitgParsedRefName* _tmp17_;
	GitgParsedRefName* _tmp18_;
	GitgParsedRefName* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (name != NULL, 0);
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_;
		GitgRef* _tmp2_;
		GitgRef* _tmp3_;
		_tmp1_ = self->priv->d_repository;
		_tmp2_ = gitg_repository_lookup_reference (_tmp1_, name, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (reference);
		reference = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = 0;
		_g_object_unref0 (reference);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp4_ = -1;
		_g_object_unref0 (reference);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	_tmp6_ = reference;
	if (!ggit_ref_is_remote ((GgitRef*) _tmp6_)) {
		_tmp5_ = TRUE;
	} else {
		GitgRef* _tmp7_;
		_tmp7_ = reference;
		_tmp5_ = ggit_ref_get_reference_type ((GgitRef*) _tmp7_) == GGIT_REF_SYMBOLIC;
	}
	if (_tmp5_) {
		result = 0;
		_g_object_unref0 (reference);
		return result;
	}
	_tmp8_ = self->priv->d_remote_branch_name;
	_tmp9_ = reference;
	_tmp10_ = gitg_ref_get_parsed_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = gitg_parsed_ref_name_get_shortname (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = reference;
	_tmp17_ = gitg_ref_get_parsed_name (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = gitg_parsed_ref_name_get_shortname (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	gtk_combo_box_text_append (_tmp8_, _tmp15_, _tmp22_);
	_g_free0 (_tmp22_);
	_g_object_unref0 (_tmp19_);
	_g_free0 (_tmp15_);
	_g_object_unref0 (_tmp12_);
	result = 0;
	_g_object_unref0 (reference);
	return result;
}

static gint
____lambda13__ggit_references_name_callback (const gchar* name,
                                             gpointer self)
{
	gint result;
	result = ___lambda13_ ((GitgCheckoutRemoteBranchDialog*) self, name);
	return result;
}

static void
gitg_checkout_remote_branch_dialog_update_entries (GitgCheckoutRemoteBranchDialog* self)
{
	GtkEntry* _tmp0_;
	GitgRef* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgParsedRefName* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkComboBoxText* _tmp9_;
	GitgRef* _tmp10_;
	GitgParsedRefName* _tmp11_;
	GitgParsedRefName* _tmp12_;
	GitgParsedRefName* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_branch_name;
	_tmp1_ = self->priv->d_remote_reference;
	_tmp2_ = gitg_ref_get_parsed_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = gitg_parsed_ref_name_get_remote_branch (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	gtk_entry_set_text (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	{
		GitgRepository* _tmp8_;
		_tmp8_ = self->priv->d_repository;
		ggit_repository_references_foreach_name ((GgitRepository*) _tmp8_, ____lambda13__ggit_references_name_callback, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = self->priv->d_remote_branch_name;
	_tmp10_ = self->priv->d_remote_reference;
	_tmp11_ = gitg_ref_get_parsed_name (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = gitg_parsed_ref_name_get_shortname (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp9_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_object_unref0 (_tmp13_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
gitg_checkout_remote_branch_dialog_get_new_branch_name (GitgCheckoutRemoteBranchDialog* self)
{
	gchar* result;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_branch_name;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
gitg_checkout_remote_branch_dialog_get_remote_branch_name (GitgCheckoutRemoteBranchDialog* self)
{
	gchar* result;
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_remote_branch_name;
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
gitg_checkout_remote_branch_dialog_get_track_remote (GitgCheckoutRemoteBranchDialog* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_track_remote;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
_gitg_checkout_remote_branch_dialog___lambda14_ (GitgCheckoutRemoteBranchDialog* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->d_button_create;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, gitg_checkout_remote_branch_dialog_entries_valid (self));
}

static void
__gitg_checkout_remote_branch_dialog___lambda14__gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self)
{
	_gitg_checkout_remote_branch_dialog___lambda14_ ((GitgCheckoutRemoteBranchDialog*) self);
}

static void
_gitg_checkout_remote_branch_dialog___lambda15_ (GitgCheckoutRemoteBranchDialog* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->d_button_create;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, gitg_checkout_remote_branch_dialog_entries_valid (self));
}

static void
__gitg_checkout_remote_branch_dialog___lambda15__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self)
{
	_gitg_checkout_remote_branch_dialog___lambda15_ ((GitgCheckoutRemoteBranchDialog*) self);
}

static GObject *
gitg_checkout_remote_branch_dialog_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgCheckoutRemoteBranchDialog * self;
	GtkEntry* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkButton* _tmp2_;
	parent_class = G_OBJECT_CLASS (gitg_checkout_remote_branch_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialog);
	_tmp0_ = self->priv->d_branch_name;
	g_signal_connect_object ((GtkEditable*) _tmp0_, "changed", (GCallback) __gitg_checkout_remote_branch_dialog___lambda14__gtk_editable_changed, self, 0);
	_tmp1_ = self->priv->d_remote_branch_name;
	g_signal_connect_object ((GtkComboBox*) _tmp1_, "changed", (GCallback) __gitg_checkout_remote_branch_dialog___lambda15__gtk_combo_box_changed, self, 0);
	_tmp2_ = self->priv->d_button_create;
	gtk_window_set_default ((GtkWindow*) self, (GtkWidget*) _tmp2_);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	return obj;
}

static void
gitg_checkout_remote_branch_dialog_class_init (GitgCheckoutRemoteBranchDialogClass * klass,
                                               gpointer klass_data)
{
	gitg_checkout_remote_branch_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCheckoutRemoteBranchDialog_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) gitg_checkout_remote_branch_dialog_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_checkout_remote_branch_dialog_get_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_checkout_remote_branch_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_checkout_remote_branch_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_NEW_BRANCH_NAME_PROPERTY, gitg_checkout_remote_branch_dialog_properties[GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_NEW_BRANCH_NAME_PROPERTY] = g_param_spec_string ("new-branch-name", "new-branch-name", "new-branch-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_REMOTE_BRANCH_NAME_PROPERTY, gitg_checkout_remote_branch_dialog_properties[GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_REMOTE_BRANCH_NAME_PROPERTY] = g_param_spec_string ("remote-branch-name", "remote-branch-name", "remote-branch-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_TRACK_REMOTE_PROPERTY, gitg_checkout_remote_branch_dialog_properties[GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_TRACK_REMOTE_PROPERTY] = g_param_spec_boolean ("track-remote", "track-remote", "track-remote", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-checkout-remote-branch-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_button_create", FALSE, GitgCheckoutRemoteBranchDialog_private_offset + G_STRUCT_OFFSET (GitgCheckoutRemoteBranchDialogPrivate, d_button_create));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_name", FALSE, GitgCheckoutRemoteBranchDialog_private_offset + G_STRUCT_OFFSET (GitgCheckoutRemoteBranchDialogPrivate, d_branch_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remote_branch_name", FALSE, GitgCheckoutRemoteBranchDialog_private_offset + G_STRUCT_OFFSET (GitgCheckoutRemoteBranchDialogPrivate, d_remote_branch_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_track_remote", FALSE, GitgCheckoutRemoteBranchDialog_private_offset + G_STRUCT_OFFSET (GitgCheckoutRemoteBranchDialogPrivate, d_track_remote));
}

static void
gitg_checkout_remote_branch_dialog_instance_init (GitgCheckoutRemoteBranchDialog * self,
                                                  gpointer klass)
{
	self->priv = gitg_checkout_remote_branch_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_checkout_remote_branch_dialog_finalize (GObject * obj)
{
	GitgCheckoutRemoteBranchDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialog);
	_g_object_unref0 (self->priv->d_repository);
	_g_object_unref0 (self->priv->d_remote_reference);
	G_OBJECT_CLASS (gitg_checkout_remote_branch_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_checkout_remote_branch_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCheckoutRemoteBranchDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_checkout_remote_branch_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCheckoutRemoteBranchDialog), 0, (GInstanceInitFunc) gitg_checkout_remote_branch_dialog_instance_init, NULL };
	GType gitg_checkout_remote_branch_dialog_type_id;
	gitg_checkout_remote_branch_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "GitgCheckoutRemoteBranchDialog", &g_define_type_info, 0);
	GitgCheckoutRemoteBranchDialog_private_offset = g_type_add_instance_private (gitg_checkout_remote_branch_dialog_type_id, sizeof (GitgCheckoutRemoteBranchDialogPrivate));
	return gitg_checkout_remote_branch_dialog_type_id;
}

GType
gitg_checkout_remote_branch_dialog_get_type (void)
{
	static gsize gitg_checkout_remote_branch_dialog_type_id__once = 0;
	if (g_once_init_enter (&gitg_checkout_remote_branch_dialog_type_id__once)) {
		GType gitg_checkout_remote_branch_dialog_type_id;
		gitg_checkout_remote_branch_dialog_type_id = gitg_checkout_remote_branch_dialog_get_type_once ();
		g_once_init_leave (&gitg_checkout_remote_branch_dialog_type_id__once, gitg_checkout_remote_branch_dialog_type_id);
	}
	return gitg_checkout_remote_branch_dialog_type_id__once;
}

static void
_vala_gitg_checkout_remote_branch_dialog_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GitgCheckoutRemoteBranchDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialog);
	switch (property_id) {
		case GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_NEW_BRANCH_NAME_PROPERTY:
		g_value_take_string (value, gitg_checkout_remote_branch_dialog_get_new_branch_name (self));
		break;
		case GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_REMOTE_BRANCH_NAME_PROPERTY:
		g_value_take_string (value, gitg_checkout_remote_branch_dialog_get_remote_branch_name (self));
		break;
		case GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_TRACK_REMOTE_PROPERTY:
		g_value_set_boolean (value, gitg_checkout_remote_branch_dialog_get_track_remote (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

