/* ActivityMonitorBackend.c generated by valac 0.56.17, the Vala compiler
 * generated from ActivityMonitorBackend.vala, do not modify */

/* ActivityMonitorBackend.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include "common.h"
#include <stdlib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_BACKEND_0_PROPERTY,
	BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_BACKEND_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_activity_activity_monitor_backend_properties[BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_BACKEND_NUM_PROPERTIES];

struct _BreakTimerDaemonActivityActivityMonitorBackendPrivate {
	gint64 last_real_time;
	gint64 last_monotonic_time;
};

static gint BreakTimerDaemonActivityActivityMonitorBackend_private_offset;
static gpointer break_timer_daemon_activity_activity_monitor_backend_parent_class = NULL;
static GInitableIface * break_timer_daemon_activity_activity_monitor_backend_g_initable_parent_iface = NULL;

static gboolean break_timer_daemon_activity_activity_monitor_backend_real_init (BreakTimerDaemonActivityActivityMonitorBackend* self,
                                                                         GCancellable* cancellable,
                                                                         GError** error);
static JsonObject* break_timer_daemon_activity_activity_monitor_backend_real_serialize (BreakTimerDaemonActivityActivityMonitorBackend* self);
static void break_timer_daemon_activity_activity_monitor_backend_real_deserialize (BreakTimerDaemonActivityActivityMonitorBackend* self,
                                                                            JsonObject** json_root);
static guint64 break_timer_daemon_activity_activity_monitor_backend_real_time_since_last_event_ms (BreakTimerDaemonActivityActivityMonitorBackend* self);
static void break_timer_daemon_activity_activity_monitor_backend_finalize (GObject * obj);
static GType break_timer_daemon_activity_activity_monitor_backend_get_type_once (void);

static inline gpointer
break_timer_daemon_activity_activity_monitor_backend_get_instance_private (BreakTimerDaemonActivityActivityMonitorBackend* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonActivityActivityMonitorBackend_private_offset);
}

static gboolean
break_timer_daemon_activity_activity_monitor_backend_real_init (BreakTimerDaemonActivityActivityMonitorBackend* self,
                                                                GCancellable* cancellable,
                                                                GError** error)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
break_timer_daemon_activity_activity_monitor_backend_init (BreakTimerDaemonActivityActivityMonitorBackend* self,
                                                           GCancellable* cancellable,
                                                           GError** error)
{
	BreakTimerDaemonActivityActivityMonitorBackendClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_BACKEND_GET_CLASS (self);
	if (_klass_->init) {
		return _klass_->init (self, cancellable, error);
	}
	return FALSE;
}

static JsonObject*
break_timer_daemon_activity_activity_monitor_backend_real_serialize (BreakTimerDaemonActivityActivityMonitorBackend* self)
{
	JsonObject* json_root = NULL;
	JsonObject* _tmp0_;
	JsonObject* result;
	_tmp0_ = json_object_new ();
	json_root = _tmp0_;
	json_object_set_int_member (json_root, "last_real_time", self->priv->last_real_time);
	json_object_set_int_member (json_root, "last_monotonic_time", self->priv->last_monotonic_time);
	result = json_root;
	return result;
}

JsonObject*
break_timer_daemon_activity_activity_monitor_backend_serialize (BreakTimerDaemonActivityActivityMonitorBackend* self)
{
	BreakTimerDaemonActivityActivityMonitorBackendClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_BACKEND_GET_CLASS (self);
	if (_klass_->serialize) {
		return _klass_->serialize (self);
	}
	return NULL;
}

static void
break_timer_daemon_activity_activity_monitor_backend_real_deserialize (BreakTimerDaemonActivityActivityMonitorBackend* self,
                                                                       JsonObject** json_root)
{
	g_return_if_fail (*json_root != NULL);
	self->priv->last_real_time = json_object_get_int_member (*json_root, "last_real_time");
	self->priv->last_monotonic_time = json_object_get_int_member (*json_root, "last_monotonic_time");
}

void
break_timer_daemon_activity_activity_monitor_backend_deserialize (BreakTimerDaemonActivityActivityMonitorBackend* self,
                                                                  JsonObject** json_root)
{
	BreakTimerDaemonActivityActivityMonitorBackendClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_BACKEND_GET_CLASS (self);
	if (_klass_->deserialize) {
		_klass_->deserialize (self, json_root);
	}
}

static guint64
break_timer_daemon_activity_activity_monitor_backend_real_time_since_last_event_ms (BreakTimerDaemonActivityActivityMonitorBackend* self)
{
	guint64 _tmp0_ = 0ULL;
	g_critical ("Type `%s' does not implement abstract method `break_timer_daemon_activity_activity_monitor_backend_time_since_last_event_ms'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint64
break_timer_daemon_activity_activity_monitor_backend_time_since_last_event_ms (BreakTimerDaemonActivityActivityMonitorBackend* self)
{
	BreakTimerDaemonActivityActivityMonitorBackendClass* _klass_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_klass_ = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_BACKEND_GET_CLASS (self);
	if (_klass_->time_since_last_event_ms) {
		return _klass_->time_since_last_event_ms (self);
	}
	return 0ULL;
}

gint64
break_timer_daemon_activity_activity_monitor_backend_get_idle_seconds (BreakTimerDaemonActivityActivityMonitorBackend* self)
{
	guint64 idle_ms = 0ULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	idle_ms = break_timer_daemon_activity_activity_monitor_backend_time_since_last_event_ms (self);
	result = ((gint64) idle_ms) / BREAK_TIMER_COMMON_TIME_UNIT_MILLISECONDS_IN_SECONDS;
	return result;
}

/** Detect if the device has been asleep using the difference between monotonic time and real time */
gint64
break_timer_daemon_activity_activity_monitor_backend_pop_sleep_time (BreakTimerDaemonActivityActivityMonitorBackend* self)
{
	gint64 sleep_time = 0LL;
	gint64 now_real = 0LL;
	gint64 now_monotonic = 0LL;
	gint64 real_time_delta = 0LL;
	gint64 monotonic_time_delta = 0LL;
	gboolean _tmp0_ = FALSE;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	now_real = break_timer_common_time_unit_get_real_time_seconds ();
	now_monotonic = break_timer_common_time_unit_get_monotonic_time_seconds ();
	real_time_delta = (gint64) (now_real - self->priv->last_real_time);
	monotonic_time_delta = (gint64) llabs (now_monotonic - self->priv->last_monotonic_time);
	if (self->priv->last_real_time > ((gint64) 0)) {
		_tmp0_ = self->priv->last_monotonic_time > ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (real_time_delta > monotonic_time_delta) {
			sleep_time = (gint64) (real_time_delta - monotonic_time_delta);
		} else {
			sleep_time = real_time_delta;
		}
	} else {
		sleep_time = (gint64) 0;
	}
	self->priv->last_real_time = now_real;
	self->priv->last_monotonic_time = now_monotonic;
	result = sleep_time;
	return result;
}

BreakTimerDaemonActivityActivityMonitorBackend*
break_timer_daemon_activity_activity_monitor_backend_construct (GType object_type)
{
	BreakTimerDaemonActivityActivityMonitorBackend * self = NULL;
	self = (BreakTimerDaemonActivityActivityMonitorBackend*) g_object_new (object_type, NULL);
	return self;
}

static void
break_timer_daemon_activity_activity_monitor_backend_class_init (BreakTimerDaemonActivityActivityMonitorBackendClass * klass,
                                                                 gpointer klass_data)
{
	break_timer_daemon_activity_activity_monitor_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonActivityActivityMonitorBackend_private_offset);
	((BreakTimerDaemonActivityActivityMonitorBackendClass *) klass)->init = (gboolean (*) (BreakTimerDaemonActivityActivityMonitorBackend*, GCancellable*, GError**)) break_timer_daemon_activity_activity_monitor_backend_real_init;
	((BreakTimerDaemonActivityActivityMonitorBackendClass *) klass)->serialize = (JsonObject* (*) (BreakTimerDaemonActivityActivityMonitorBackend*)) break_timer_daemon_activity_activity_monitor_backend_real_serialize;
	((BreakTimerDaemonActivityActivityMonitorBackendClass *) klass)->deserialize = (void (*) (BreakTimerDaemonActivityActivityMonitorBackend*, JsonObject**)) break_timer_daemon_activity_activity_monitor_backend_real_deserialize;
	((BreakTimerDaemonActivityActivityMonitorBackendClass *) klass)->time_since_last_event_ms = (guint64 (*) (BreakTimerDaemonActivityActivityMonitorBackend*)) break_timer_daemon_activity_activity_monitor_backend_real_time_since_last_event_ms;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_activity_activity_monitor_backend_finalize;
}

static void
break_timer_daemon_activity_activity_monitor_backend_g_initable_interface_init (GInitableIface * iface,
                                                                                gpointer iface_data)
{
	break_timer_daemon_activity_activity_monitor_backend_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) break_timer_daemon_activity_activity_monitor_backend_init;
}

static void
break_timer_daemon_activity_activity_monitor_backend_instance_init (BreakTimerDaemonActivityActivityMonitorBackend * self,
                                                                    gpointer klass)
{
	self->priv = break_timer_daemon_activity_activity_monitor_backend_get_instance_private (self);
	self->priv->last_real_time = (gint64) 0;
	self->priv->last_monotonic_time = (gint64) 0;
}

static void
break_timer_daemon_activity_activity_monitor_backend_finalize (GObject * obj)
{
	BreakTimerDaemonActivityActivityMonitorBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_ACTIVITY_TYPE_ACTIVITY_MONITOR_BACKEND, BreakTimerDaemonActivityActivityMonitorBackend);
	G_OBJECT_CLASS (break_timer_daemon_activity_activity_monitor_backend_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_activity_activity_monitor_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonActivityActivityMonitorBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_activity_activity_monitor_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonActivityActivityMonitorBackend), 0, (GInstanceInitFunc) break_timer_daemon_activity_activity_monitor_backend_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) break_timer_daemon_activity_activity_monitor_backend_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType break_timer_daemon_activity_activity_monitor_backend_type_id;
	break_timer_daemon_activity_activity_monitor_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonActivityActivityMonitorBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (break_timer_daemon_activity_activity_monitor_backend_type_id, g_initable_get_type (), &g_initable_info);
	BreakTimerDaemonActivityActivityMonitorBackend_private_offset = g_type_add_instance_private (break_timer_daemon_activity_activity_monitor_backend_type_id, sizeof (BreakTimerDaemonActivityActivityMonitorBackendPrivate));
	return break_timer_daemon_activity_activity_monitor_backend_type_id;
}

GType
break_timer_daemon_activity_activity_monitor_backend_get_type (void)
{
	static volatile gsize break_timer_daemon_activity_activity_monitor_backend_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_activity_activity_monitor_backend_type_id__once)) {
		GType break_timer_daemon_activity_activity_monitor_backend_type_id;
		break_timer_daemon_activity_activity_monitor_backend_type_id = break_timer_daemon_activity_activity_monitor_backend_get_type_once ();
		g_once_init_leave (&break_timer_daemon_activity_activity_monitor_backend_type_id__once, break_timer_daemon_activity_activity_monitor_backend_type_id);
	}
	return break_timer_daemon_activity_activity_monitor_backend_type_id__once;
}

