/* PausableTimeout.c generated by valac 0.56.17, the Vala compiler
 * generated from PausableTimeout.vala, do not modify */

/* PausableTimeout.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_UTIL_PAUSABLE_TIMEOUT_0_PROPERTY,
	BREAK_TIMER_DAEMON_UTIL_PAUSABLE_TIMEOUT_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_util_pausable_timeout_properties[BREAK_TIMER_DAEMON_UTIL_PAUSABLE_TIMEOUT_NUM_PROPERTIES];

struct _BreakTimerDaemonUtilPausableTimeoutPrivate {
	BreakTimerDaemonUtilPausableTimeoutTimeoutCB timeout_cb;
	gpointer timeout_cb_target;
	guint source_id;
	gint frequency;
	gint64 last_time;
};

static gint BreakTimerDaemonUtilPausableTimeout_private_offset;
static gpointer break_timer_daemon_util_pausable_timeout_parent_class = NULL;

static gboolean break_timer_daemon_util_pausable_timeout_timeout_wrapper (BreakTimerDaemonUtilPausableTimeout* self);
static gboolean _break_timer_daemon_util_pausable_timeout_timeout_wrapper_gsource_func (gpointer self);
static void break_timer_daemon_util_pausable_timeout_finalize (GObject * obj);
static GType break_timer_daemon_util_pausable_timeout_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
break_timer_daemon_util_pausable_timeout_get_instance_private (BreakTimerDaemonUtilPausableTimeout* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonUtilPausableTimeout_private_offset);
}

BreakTimerDaemonUtilPausableTimeout*
break_timer_daemon_util_pausable_timeout_construct (GType object_type,
                                                    BreakTimerDaemonUtilPausableTimeoutTimeoutCB callback,
                                                    gpointer callback_target,
                                                    gint frequency)
{
	BreakTimerDaemonUtilPausableTimeout * self = NULL;
	self = (BreakTimerDaemonUtilPausableTimeout*) g_object_new (object_type, NULL);
	self->priv->timeout_cb = callback;
	self->priv->timeout_cb_target = callback_target;
	self->priv->frequency = frequency;
	return self;
}

BreakTimerDaemonUtilPausableTimeout*
break_timer_daemon_util_pausable_timeout_new (BreakTimerDaemonUtilPausableTimeoutTimeoutCB callback,
                                              gpointer callback_target,
                                              gint frequency)
{
	return break_timer_daemon_util_pausable_timeout_construct (BREAK_TIMER_DAEMON_UTIL_TYPE_PAUSABLE_TIMEOUT, callback, callback_target, frequency);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
break_timer_daemon_util_pausable_timeout_serialize (BreakTimerDaemonUtilPausableTimeout* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", self->priv->frequency);
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, self->priv->last_time);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	_tmp4_ = _vala_g_strjoinv (",", _tmp3_, (gint) 2);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp5_;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

void
break_timer_daemon_util_pausable_timeout_deserialize (BreakTimerDaemonUtilPausableTimeout* self,
                                                      const gchar* data)
{
	gchar** data_parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint data_parts_length1;
	gint _data_parts_size_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (data, ",", 0);
	data_parts = _tmp1_;
	data_parts_length1 = _vala_array_length (_tmp0_);
	_data_parts_size_ = data_parts_length1;
	_tmp2_ = data_parts[0];
	self->priv->frequency = atoi (_tmp2_);
	_tmp3_ = data_parts[1];
	self->priv->last_time = int64_parse (_tmp3_, (guint) 0);
	data_parts = (_vala_array_free (data_parts, data_parts_length1, (GDestroyNotify) g_free), NULL);
}

static gboolean
break_timer_daemon_util_pausable_timeout_timeout_wrapper (BreakTimerDaemonUtilPausableTimeout* self)
{
	gint64 now = 0LL;
	gint64 time_delta = 0LL;
	gint delta_millisecs = 0;
	BreakTimerDaemonUtilPausableTimeoutTimeoutCB _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	now = break_timer_common_time_unit_get_monotonic_time ();
	time_delta = now - self->priv->last_time;
	self->priv->last_time = now;
	delta_millisecs = (gint) (time_delta / BREAK_TIMER_COMMON_TIME_UNIT_MILLISECONDS_IN_SECONDS);
	_tmp0_ = self->priv->timeout_cb;
	_tmp0__target = self->priv->timeout_cb_target;
	_tmp0_ (self, delta_millisecs, _tmp0__target);
	result = G_SOURCE_CONTINUE;
	return result;
}

void
break_timer_daemon_util_pausable_timeout_run_once (BreakTimerDaemonUtilPausableTimeout* self)
{
	g_return_if_fail (self != NULL);
	break_timer_daemon_util_pausable_timeout_timeout_wrapper (self);
}

static gboolean
_break_timer_daemon_util_pausable_timeout_timeout_wrapper_gsource_func (gpointer self)
{
	gboolean result;
	result = break_timer_daemon_util_pausable_timeout_timeout_wrapper ((BreakTimerDaemonUtilPausableTimeout*) self);
	return result;
}

void
break_timer_daemon_util_pausable_timeout_start (BreakTimerDaemonUtilPausableTimeout* self)
{
	g_return_if_fail (self != NULL);
	if (break_timer_daemon_util_pausable_timeout_is_running (self)) {
		g_source_remove (self->priv->source_id);
	}
	self->priv->last_time = break_timer_common_time_unit_get_monotonic_time ();
	self->priv->source_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->priv->frequency, _break_timer_daemon_util_pausable_timeout_timeout_wrapper_gsource_func, g_object_ref (self), g_object_unref);
}

void
break_timer_daemon_util_pausable_timeout_set_frequency (BreakTimerDaemonUtilPausableTimeout* self,
                                                        gint frequency)
{
	g_return_if_fail (self != NULL);
	self->priv->frequency = frequency;
	if (break_timer_daemon_util_pausable_timeout_is_running (self)) {
		break_timer_daemon_util_pausable_timeout_start (self);
	}
}

void
break_timer_daemon_util_pausable_timeout_stop (BreakTimerDaemonUtilPausableTimeout* self)
{
	g_return_if_fail (self != NULL);
	if (break_timer_daemon_util_pausable_timeout_is_running (self)) {
		g_source_remove (self->priv->source_id);
		self->priv->source_id = (guint) 0;
	}
}

gboolean
break_timer_daemon_util_pausable_timeout_is_running (BreakTimerDaemonUtilPausableTimeout* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->source_id > ((guint) 0);
	return result;
}

static void
break_timer_daemon_util_pausable_timeout_class_init (BreakTimerDaemonUtilPausableTimeoutClass * klass,
                                                     gpointer klass_data)
{
	break_timer_daemon_util_pausable_timeout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonUtilPausableTimeout_private_offset);
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_util_pausable_timeout_finalize;
}

static void
break_timer_daemon_util_pausable_timeout_instance_init (BreakTimerDaemonUtilPausableTimeout * self,
                                                        gpointer klass)
{
	self->priv = break_timer_daemon_util_pausable_timeout_get_instance_private (self);
}

static void
break_timer_daemon_util_pausable_timeout_finalize (GObject * obj)
{
	BreakTimerDaemonUtilPausableTimeout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_UTIL_TYPE_PAUSABLE_TIMEOUT, BreakTimerDaemonUtilPausableTimeout);
	G_OBJECT_CLASS (break_timer_daemon_util_pausable_timeout_parent_class)->finalize (obj);
}

/**
 * Calls a function continuously with a particular interval, in seconds. An
 * instance of PausableTimout is attached to a particular TimeoutCB function,
 * so it is trivial to stop and start the timeout by calling the stop and
 * start methods, respectively.
 */
static GType
break_timer_daemon_util_pausable_timeout_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonUtilPausableTimeoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_util_pausable_timeout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonUtilPausableTimeout), 0, (GInstanceInitFunc) break_timer_daemon_util_pausable_timeout_instance_init, NULL };
	GType break_timer_daemon_util_pausable_timeout_type_id;
	break_timer_daemon_util_pausable_timeout_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonUtilPausableTimeout", &g_define_type_info, 0);
	BreakTimerDaemonUtilPausableTimeout_private_offset = g_type_add_instance_private (break_timer_daemon_util_pausable_timeout_type_id, sizeof (BreakTimerDaemonUtilPausableTimeoutPrivate));
	return break_timer_daemon_util_pausable_timeout_type_id;
}

GType
break_timer_daemon_util_pausable_timeout_get_type (void)
{
	static volatile gsize break_timer_daemon_util_pausable_timeout_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_util_pausable_timeout_type_id__once)) {
		GType break_timer_daemon_util_pausable_timeout_type_id;
		break_timer_daemon_util_pausable_timeout_type_id = break_timer_daemon_util_pausable_timeout_get_type_once ();
		g_once_init_leave (&break_timer_daemon_util_pausable_timeout_type_id__once, break_timer_daemon_util_pausable_timeout_type_id);
	}
	return break_timer_daemon_util_pausable_timeout_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

