/* nibbles-game.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nibbles-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2022-25 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 * grep -ne ' $' *.vala
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_GAME_MAX_SPEED 4
#define NIBBLES_GAME_EMPTYCHAR 'a'
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_MAX_LEVEL 26
#define WORM_GROW_FACTOR 4
#define NIBBLES_GAME_BONUSES_MAX_BONUSES ((guint8) 100)
#define NIBBLES_GAME_BONUSES_MAX_MISSED ((guint8) 2)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef gboolean (*KeypressHandlerFunction) (guint a, guint b, gboolean* remove_handler, gpointer user_data);
typedef gboolean (*_LocalFunc0_) (GValue* value, GVariant* variant, void* data);
typedef GVariant* (*_LocalFunc1_) (GValue* value, const GVariantType* type, void* data);

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;

#define NIBBLES_GAME_TYPE_BONUSES (nibbles_game_bonuses_get_type ())
#define NIBBLES_GAME_BONUSES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_GAME_TYPE_BONUSES, NibblesGameBonuses))
#define NIBBLES_GAME_BONUSES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_GAME_TYPE_BONUSES, NibblesGameBonusesClass))
#define NIBBLES_GAME_IS_BONUSES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_GAME_TYPE_BONUSES))
#define NIBBLES_GAME_IS_BONUSES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_GAME_TYPE_BONUSES))
#define NIBBLES_GAME_BONUSES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_GAME_TYPE_BONUSES, NibblesGameBonusesClass))

typedef struct _NibblesGameBonuses NibblesGameBonuses;
typedef struct _NibblesGameBonusesClass NibblesGameBonusesClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;

#define NIBBLES_GAME_TYPE_SCORE_DELTA (nibbles_game_score_delta_get_type ())
#define NIBBLES_GAME_SCORE_DELTA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_GAME_TYPE_SCORE_DELTA, NibblesGameScoreDelta))
#define NIBBLES_GAME_SCORE_DELTA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_GAME_TYPE_SCORE_DELTA, NibblesGameScoreDeltaClass))
#define NIBBLES_GAME_IS_SCORE_DELTA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_GAME_TYPE_SCORE_DELTA))
#define NIBBLES_GAME_IS_SCORE_DELTA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_GAME_TYPE_SCORE_DELTA))
#define NIBBLES_GAME_SCORE_DELTA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_GAME_TYPE_SCORE_DELTA, NibblesGameScoreDeltaClass))

typedef struct _NibblesGameScoreDelta NibblesGameScoreDelta;
typedef struct _NibblesGameScoreDeltaClass NibblesGameScoreDeltaClass;
enum  {
	NIBBLES_GAME_0_PROPERTY,
	NIBBLES_GAME_SKIP_SCORE_PROPERTY,
	NIBBLES_GAME_CURRENT_LEVEL_PROPERTY,
	NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY,
	NIBBLES_GAME_SPEED_PROPERTY,
	NIBBLES_GAME_GAMEDELAY_PROPERTY,
	NIBBLES_GAME_PROGRESS_PROPERTY,
	NIBBLES_GAME_START_LEVEL_PROPERTY,
	NIBBLES_GAME_WIDTH_PROPERTY,
	NIBBLES_GAME_HEIGHT_PROPERTY,
	NIBBLES_GAME_NUMHUMANS_PROPERTY,
	NIBBLES_GAME_NUMAI_PROPERTY,
	NIBBLES_GAME_NUMWORMS_PROPERTY,
	NIBBLES_GAME_WORMS_PROPERTY,
	NIBBLES_GAME_WORM_PROPS_PROPERTY,
	NIBBLES_GAME_IS_RUNNING_PROPERTY,
	NIBBLES_GAME_PAUSED_PROPERTY,
	NIBBLES_GAME_FAKES_PROPERTY,
	NIBBLES_GAME_NUM_PROPERTIES
};
static GParamSpec* nibbles_game_properties[NIBBLES_GAME_NUM_PROPERTIES];
typedef enum  {
	NIBBLES_GAME_ESTATUS_GAMEOVER,
	NIBBLES_GAME_ESTATUS_VICTORY,
	NIBBLES_GAME_ESTATUS_NEWROUND
} NibblesGameeStatus;

#define NIBBLES_GAME_TYPE_ESTATUS (nibbles_game_estatus_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_EAST = WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_SOUTH = WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_WEST = WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP,
	WORM_DIRECTION_NORTH = WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
typedef GeeList* (*WormGetOtherWormsType) (Worm* _self_, gpointer user_data);
typedef GeeList* (*WormGetBonusesType) (gpointer user_data);
typedef struct _WormPrivate WormPrivate;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_POSITIONS (worm_positions_get_type ())
#define WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_POSITIONS, WormPositions))
#define WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_POSITIONS, WormPositionsClass))
#define IS_WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_POSITIONS))
#define IS_WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_POSITIONS))
#define WORM_POSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_POSITIONS, WormPositionsClass))

typedef struct _WormPositions WormPositions;
typedef struct _WormPositionsClass WormPositionsClass;
typedef enum  {
	BONUS_ETYPE_REGULAR,
	BONUS_ETYPE_HALF,
	BONUS_ETYPE_DOUBLE,
	BONUS_ETYPE_LIFE,
	BONUS_ETYPE_REVERSE,
	BONUS_ETYPE_WARP
} BonuseType;

#define BONUS_TYPE_ETYPE (bonus_etype_get_type ())
typedef struct _NibblesGameBonusesPrivate NibblesGameBonusesPrivate;
enum  {
	NIBBLES_GAME_BONUSES_0_PROPERTY,
	NIBBLES_GAME_BONUSES_NUM_PROPERTIES
};
static GParamSpec* nibbles_game_bonuses_properties[NIBBLES_GAME_BONUSES_NUM_PROPERTIES];
enum  {
	NIBBLES_GAME_BONUSES_BONUS_REMOVED_SIGNAL,
	NIBBLES_GAME_BONUSES_NUM_SIGNALS
};
static guint nibbles_game_bonuses_signals[NIBBLES_GAME_BONUSES_NUM_SIGNALS] = {0};
typedef struct _NibblesGameScoreDeltaPrivate NibblesGameScoreDeltaPrivate;
enum  {
	NIBBLES_GAME_SCORE_DELTA_0_PROPERTY,
	NIBBLES_GAME_SCORE_DELTA_WORM_PROPERTY,
	NIBBLES_GAME_SCORE_DELTA_SCORE_DELTA_PROPERTY,
	NIBBLES_GAME_SCORE_DELTA_NUM_PROPERTIES
};
static GParamSpec* nibbles_game_score_delta_properties[NIBBLES_GAME_SCORE_DELTA_NUM_PROPERTIES];
enum  {
	NIBBLES_GAME_BONUS_APPLIED_SIGNAL,
	NIBBLES_GAME_LOG_SCORE_SIGNAL,
	NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL,
	NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL,
	NIBBLES_GAME_WARP_ADDED_SIGNAL,
	NIBBLES_GAME_BONUS_ADDED_SIGNAL,
	NIBBLES_GAME_BONUS_REMOVED_SIGNAL,
	NIBBLES_GAME_GET_PKGDATADIR_SIGNAL,
	NIBBLES_GAME_ADD_KEYPRESS_HANDLER_SIGNAL,
	NIBBLES_GAME_REDRAW_SIGNAL,
	NIBBLES_GAME_PLAY_SOUND_SIGNAL,
	NIBBLES_GAME_NUM_SIGNALS
};
static guint nibbles_game_signals[NIBBLES_GAME_NUM_SIGNALS] = {0};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint _progress;
	gint* levels_uncompleated;
	gint levels_uncompleated_length1;
	gint _levels_uncompleated_size_;
	gint* board;
	gint board_length1;
	gint board_length2;
	gboolean added_keypress_handler;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _NibblesGamePrivate {
	gboolean _skip_score;
	gint _current_level;
	gboolean _three_dimensional_view;
	gint _speed;
	gint _gamedelay;
	gint _start_level;
	guint8 _width;
	guint8 _height;
	gint _numhumans;
	gint _numai;
	gint _numworms;
	GeeLinkedList* _worms;
	GeeHashMap* _worm_props;
	NibblesGameBonuses* bonuses;
	WarpManager* warp_manager;
	GeeHashMap* _score_deltas;
	GeeSet* bouns_eaten;
	gboolean _is_running;
	gboolean _is_paused;
	guint main_id;
	gboolean _fakes;
	guint8 bonus_cycle;
};

struct _Position {
	guint8 x;
	guint8 y;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gint rounds_to_stay_still;
	gboolean is_stopped;
	Position warp_position;
	gboolean warp_bonus;
	WormPositions* list;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _NibblesGameBonuses {
	GObject parent_instance;
	NibblesGameBonusesPrivate * priv;
	gint progress;
};

struct _NibblesGameBonusesClass {
	GObjectClass parent_class;
};

struct _NibblesGameBonusesPrivate {
	GeeLinkedList* bonuses;
	guint8 regular_bonus_left;
	guint8 regular_bonus_maxi;
	guint8 total_bonus_number;
	guint8 missed;
};

struct _NibblesGameScoreDelta {
	GObject parent_instance;
	NibblesGameScoreDeltaPrivate * priv;
};

struct _NibblesGameScoreDeltaClass {
	GObjectClass parent_class;
};

struct _NibblesGameScoreDeltaPrivate {
	Worm* _worm;
	gint _score_delta;
};

static gint NibblesGame_private_offset;
static gpointer nibbles_game_parent_class = NULL;
static gint NibblesGameBonuses_private_offset;
static gpointer nibbles_game_bonuses_parent_class = NULL;
static gint NibblesGameScoreDelta_private_offset;
static gpointer nibbles_game_score_delta_parent_class = NULL;

VALA_EXTERN GType nibbles_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGame, g_object_unref)
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
static GType nibbles_game_bonuses_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGameBonuses, g_object_unref)
VALA_EXTERN GType warp_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WarpManager, g_object_unref)
VALA_EXTERN GType bonus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bonus, g_object_unref)
static GType nibbles_game_score_delta_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGameScoreDelta, g_object_unref)
VALA_EXTERN GType nibbles_game_estatus_get_type (void) G_GNUC_CONST ;
static NibblesGameBonuses* nibbles_game_bonuses_new (void);
static NibblesGameBonuses* nibbles_game_bonuses_construct (GType object_type);
VALA_EXTERN WarpManager* warp_manager_new (void);
VALA_EXTERN WarpManager* warp_manager_construct (GType object_type);
VALA_EXTERN NibblesGame* nibbles_game_new (gint start_level,
                               gint speed,
                               gint gamedelay,
                               gboolean fakes,
                               gboolean three_dimensional_view,
                               guint8 width,
                               guint8 height,
                               gboolean no_random);
VALA_EXTERN NibblesGame* nibbles_game_construct (GType object_type,
                                     gint start_level,
                                     gint speed,
                                     gint gamedelay,
                                     gboolean fakes,
                                     gboolean three_dimensional_view,
                                     guint8 width,
                                     guint8 height,
                                     gboolean no_random);
VALA_EXTERN void nibbles_game_new_level (NibblesGame* self,
                             gint level_id);
VALA_EXTERN gboolean nibbles_game_keypress (NibblesGame* self,
                                guint keyval,
                                guint keycode,
                                gboolean* remove_handler);
static gboolean _nibbles_game_keypress_keypress_handler_function (guint a,
                                                           guint b,
                                                           gboolean* remove_handler,
                                                           gpointer self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gboolean nibbles_game_load_board (NibblesGame* self,
                                  gchar** future_board,
                                  gint future_board_length1,
                                  guint8 regular_bonus);
VALA_EXTERN gint nibbles_game_get_numworms (NibblesGame* self);
VALA_EXTERN guint8 nibbles_game_get_height (NibblesGame* self);
static void nibbles_game_bonuses_reset (NibblesGameBonuses* self,
                                 guint8 regular_bonus);
VALA_EXTERN void warp_manager_clear_warps (WarpManager* self);
VALA_EXTERN guint8 nibbles_game_get_width (NibblesGame* self);
VALA_EXTERN GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
VALA_EXTERN GType worm_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void worm_set_start (Worm* self,
                     guint8 x,
                     guint8 y,
                     WormDirection direction);
VALA_EXTERN void warp_manager_add_warp_source (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y,
                                   gboolean random);
VALA_EXTERN void warp_manager_add_warp_target (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y);
VALA_EXTERN void warp_manager_initilise (WarpManager* self,
                             gint* board,
                             gint board_length1,
                             gint board_length2);
VALA_EXTERN void nibbles_game_start (NibblesGame* self,
                         gboolean add_initial_bonus);
static void nibbles_game_add_bonus (NibblesGame* self,
                             gboolean regular);
static void nibbles_game_set_is_running (NibblesGame* self,
                                  gboolean value);
VALA_EXTERN gint nibbles_game_get_speed (NibblesGame* self);
VALA_EXTERN gint nibbles_game_get_gamedelay (NibblesGame* self);
static gboolean __lambda6_ (NibblesGame* self);
static gboolean nibbles_game_main_loop_cb (NibblesGame* self);
static gboolean ___lambda6__gsource_func (gpointer self);
VALA_EXTERN void nibbles_game_stop (NibblesGame* self);
VALA_EXTERN void nibbles_game_reset (NibblesGame* self,
                         gint start_level);
VALA_EXTERN void nibbles_game_set_skip_score (NibblesGame* self,
                                  gboolean value);
VALA_EXTERN gint nibbles_game_get_progress (NibblesGame* self);
VALA_EXTERN void nibbles_game_set_current_level (NibblesGame* self,
                                     gint value);
static void _vala_array_add4 (gint* * array,
                       gint* length,
                       gint* size,
                       gint value);
static gint nibbles_game_remove_one_uncompleated_level (NibblesGame* self);
static void nibbles_game_set_is_paused (NibblesGame* self,
                                 gboolean value);
static void nibbles_game_end (NibblesGame* self);
VALA_EXTERN NibblesGameeStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _nibbles_game_estatus_equal (const NibblesGameeStatus * s1,
                                      const NibblesGameeStatus * s2);
VALA_EXTERN gint worm_get_score (Worm* self);
VALA_EXTERN gint nibbles_game_get_current_level (NibblesGame* self);
static void nibbles_game_move_worms (NibblesGame* self);
VALA_EXTERN void nibbles_game_create_worms (NibblesGame* self,
                                GeeArrayList* worm_settings);
VALA_EXTERN gint nibbles_game_get_numai (NibblesGame* self);
VALA_EXTERN gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_game_set_numworms (NibblesGame* self,
                                gint value);
static GeeList* nibbles_game_get_other_worms (NibblesGame* self,
                                       Worm* _self_);
static GeeList* _nibbles_game_get_other_worms_worm_get_other_worms_type (Worm* _self_,
                                                                  gpointer self);
VALA_EXTERN GeeList* nibbles_game_get_bonuses (NibblesGame* self);
static GeeList* _nibbles_game_get_bonuses_worm_get_bonuses_type (gpointer self);
VALA_EXTERN Worm* worm_new (gint id,
                guint8 width,
                guint8 height,
                WormGetOtherWormsType cb0,
                gpointer cb0_target,
                WormGetBonusesType cb1,
                gpointer cb1_target);
VALA_EXTERN Worm* worm_construct (GType object_type,
                      gint id,
                      guint8 width,
                      guint8 height,
                      WormGetOtherWormsType cb0,
                      gpointer cb0_target,
                      WormGetBonusesType cb1,
                      gpointer cb1_target);
static void nibbles_game_bonus_found_cb (NibblesGame* self,
                                  Worm* worm);
static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                                    gpointer self);
VALA_EXTERN GType position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Position* position_dup (const Position* self);
VALA_EXTERN void position_free (Position* self);
VALA_EXTERN GType worm_positions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormPositions, g_object_unref)
VALA_EXTERN void nibbles_game_load_worm_properties (NibblesGame* self,
                                        GeeArrayList* worm_settings);
VALA_EXTERN void nibbles_game_add_worms (NibblesGame* self);
VALA_EXTERN void worm_spawn (Worm* self,
                 gint* board,
                 gint board_length1,
                 gint board_length2);
static inline gboolean nibbles_game_bonuses_too_many_missed (NibblesGameBonuses* self);
VALA_EXTERN void worm_set_score (Worm* self,
                     gint value);
static void nibbles_game_bonuses_on_worms_move (NibblesGameBonuses* self,
                                         guint8* missed_bonuses_to_replace);
VALA_EXTERN void worm_human_move (Worm* self,
                      gint* board,
                      gint board_length1,
                      gint board_length2,
                      GeeLinkedList* worms);
VALA_EXTERN void worm_ai_move (Worm* self,
                   gint* board,
                   gint board_length1,
                   gint board_length2,
                   GeeLinkedList* worms);
VALA_EXTERN void worm_position_move (Worm* self,
                         Position* result);
VALA_EXTERN gboolean warp_manager_get_warp_target (WarpManager* self,
                                       guint8 x,
                                       guint8 y,
                                       WormDirection worm_direction,
                                       gint worm_length,
                                       gboolean ai_worm,
                                       GeeLinkedList* worms,
                                       guint8* target_x,
                                       guint8* target_y,
                                       gboolean* bonus);
VALA_EXTERN WormDirection worm_get_direction (Worm* self);
VALA_EXTERN gint worm_get_length (Worm* self);
VALA_EXTERN gboolean worm_can_move_to (Worm* self,
                           gint* board,
                           gint board_length1,
                           gint board_length2,
                           GeeList* worms,
                           Position* position);
VALA_EXTERN void worm_move_part_1 (Worm* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2);
VALA_EXTERN void worm_get_head (Worm* self,
                    Position * result);
VALA_EXTERN void worm_move_part_2 (Worm* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2,
                       Position* head_position);
static void nibbles_game_bonuses_decrement_regular_bonus (NibblesGameBonuses* self,
                                                   gint d);
static GeeHashMap* nibbles_game_get_score_deltas (NibblesGame* self);
static gint nibbles_game_score_delta_get_score_delta (NibblesGameScoreDelta* self);
static Worm* nibbles_game_score_delta_get_worm (NibblesGameScoreDelta* self);
VALA_EXTERN GType bonus_etype_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BonuseType bonus_get_etype (Bonus* self);
VALA_EXTERN gboolean bonus_get_fake (Bonus* self);
static void nibbles_game_bonuses_remove_bonus (NibblesGameBonuses* self,
                                        Bonus* bonus);
static inline gboolean nibbles_game_bonuses_last_regular_bonus (NibblesGameBonuses* self);
VALA_EXTERN guint8 worm_get_lives (Worm* self);
VALA_EXTERN void worm_reset (Worm* self,
                 gint* board,
                 gint board_length1,
                 gint board_length2);
static void nibbles_game_reverse_worms (NibblesGame* self,
                                 Worm* worm);
VALA_EXTERN void worm_reverse (Worm* self);
static gboolean nibbles_game_is_space_empty (NibblesGame* self,
                                      guint8 x,
                                      guint8 y,
                                      gboolean* worms_at,
                                      gint worms_at_length1,
                                      gint worms_at_length2);
static Bonus* nibbles_game_bonuses_get_bonus (NibblesGameBonuses* self,
                                       guint8 x,
                                       guint8 y);
VALA_EXTERN gboolean nibbles_game_get_fakes (NibblesGame* self);
static inline void _nibbles_game_add_bonus (NibblesGame* self,
                              guint8 x,
                              guint8 y,
                              BonuseType bonus_type,
                              gboolean fake,
                              guint16 countdown);
VALA_EXTERN Bonus* bonus_new (guint8 x,
                  guint8 y,
                  GType type,
                  gboolean fake,
                  guint16 countdown);
VALA_EXTERN Bonus* bonus_construct (GType object_type,
                        guint8 x,
                        guint8 y,
                        GType type,
                        gboolean fake,
                        guint16 countdown);
static gboolean nibbles_game_bonuses_add_bonus (NibblesGameBonuses* self,
                                         Bonus* bonus);
static gint nibbles_game_calculate_bonus (NibblesGame* self,
                                   Bonus* bonus,
                                   Worm* worm);
static guint8 nibbles_game_bonuses_new_regular_bonus_eaten (NibblesGameBonuses* self);
VALA_EXTERN gint worm_get_change (Worm* self);
VALA_EXTERN void worm_set_change (Worm* self,
                      gint value);
VALA_EXTERN void worm_reduce_tail (Worm* self,
                       gint erase_size);
VALA_EXTERN void worm_add_life (Worm* self);
VALA_EXTERN void worm_add_bonus_eaten_position (Worm* self,
                                    guint8 x,
                                    guint8 y);
static NibblesGameScoreDelta* nibbles_game_score_delta_new (Worm* worm,
                                                     gint score_delta);
static NibblesGameScoreDelta* nibbles_game_score_delta_construct (GType object_type,
                                                           Worm* worm,
                                                           gint score_delta);
static NibblesGameeStatus* _nibbles_game_estatus_dup (NibblesGameeStatus* self);
VALA_EXTERN guint nibbles_game_humans_left (NibblesGame* self);
static gboolean __lambda7_ (GValue* value,
                     GVariant* variant,
                     void* data);
static inline gint nibbles_game_get_color_num (const gchar* color);
static gboolean ___lambda7___localfunc0_ (GValue* value,
                                   GVariant* variant,
                                   void* data);
static GVariant* __lambda8_ (GValue* value,
                      const GVariantType* type,
                      void* data);
static inline gchar* nibbles_game_get_color_string (gint color);
static GVariant* ___lambda8___localfunc1_ (GValue* value,
                                    const GVariantType* type,
                                    void* data);
VALA_EXTERN GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
VALA_EXTERN WormProperties* worm_properties_new (void);
VALA_EXTERN WormProperties* worm_properties_construct (GType object_type);
VALA_EXTERN gint worm_get_id (Worm* self);
VALA_EXTERN gboolean nibbles_game_handle_keypress (NibblesGame* self,
                                       guint keyval,
                                       guint keycode);
VALA_EXTERN gboolean nibbles_game_get_is_running (NibblesGame* self);
VALA_EXTERN gboolean worm_handle_keypress (Worm* self,
                               guint keycode,
                               GeeHashMap* worm_props);
static GeeList* nibbles_game_bonuses_get_bonuses (NibblesGameBonuses* self);
VALA_EXTERN gboolean nibbles_game_get_skip_score (NibblesGame* self);
VALA_EXTERN gboolean nibbles_game_get_three_dimensional_view (NibblesGame* self);
VALA_EXTERN void nibbles_game_set_three_dimensional_view (NibblesGame* self,
                                              gboolean value);
VALA_EXTERN void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
static void nibbles_game_set_gamedelay (NibblesGame* self,
                                 gint value);
VALA_EXTERN void nibbles_game_set_progress (NibblesGame* self,
                                gint value);
VALA_EXTERN gint nibbles_game_get_start_level (NibblesGame* self);
VALA_EXTERN void nibbles_game_set_start_level (NibblesGame* self,
                                   gint value);
static void nibbles_game_set_width (NibblesGame* self,
                             guint8 value);
static void nibbles_game_set_height (NibblesGame* self,
                              guint8 value);
VALA_EXTERN void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
VALA_EXTERN void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
static gboolean nibbles_game_get_is_paused (NibblesGame* self);
VALA_EXTERN gboolean nibbles_game_get_paused (NibblesGame* self);
VALA_EXTERN void nibbles_game_set_paused (NibblesGame* self,
                              gboolean value);
VALA_EXTERN void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UCHAR_UCHAR (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_STRING__VOID (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static inline void nibbles_game_bonuses_reset_missed (NibblesGameBonuses* self);
VALA_EXTERN guint8 bonus_get_x (Bonus* self);
VALA_EXTERN guint8 bonus_get_y (Bonus* self);
VALA_EXTERN guint16 bonus_get_countdown (Bonus* self);
VALA_EXTERN void bonus_set_countdown (Bonus* self,
                          guint16 value);
static inline void nibbles_game_bonuses_increase_missed (NibblesGameBonuses* self);
static void nibbles_game_bonuses_finalize (GObject * obj);
static GType nibbles_game_bonuses_get_type_once (void);
static void nibbles_game_score_delta_set_worm (NibblesGameScoreDelta* self,
                                        Worm* value);
static void nibbles_game_score_delta_set_score_delta (NibblesGameScoreDelta* self,
                                               gint value);
static void nibbles_game_score_delta_finalize (GObject * obj);
static GType nibbles_game_score_delta_get_type_once (void);
static void _vala_nibbles_game_score_delta_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_nibbles_game_score_delta_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static GObject * nibbles_game_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _nibbles_game___lambda9_ (NibblesGame* self,
                               Bonus* bonus);
static void __nibbles_game___lambda9__nibbles_game_bonuses_bonus_removed (NibblesGameBonuses* _sender,
                                                                   Bonus* bonus,
                                                                   gpointer self);
static void nibbles_game_finalize (GObject * obj);
static GType nibbles_game_get_type_once (void);
static void _vala_nibbles_game_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_nibbles_game_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array,
                       gsize element_size,
                       gssize src,
                       gssize dest,
                       gssize length);

static inline gpointer
nibbles_game_get_instance_private (NibblesGame* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesGame_private_offset);
}

 G_GNUC_NO_INLINE static GType
nibbles_game_estatus_get_type_once (void)
{
	static const GEnumValue values[] = {{NIBBLES_GAME_ESTATUS_GAMEOVER, "NIBBLES_GAME_ESTATUS_GAMEOVER", "gameover"}, {NIBBLES_GAME_ESTATUS_VICTORY, "NIBBLES_GAME_ESTATUS_VICTORY", "victory"}, {NIBBLES_GAME_ESTATUS_NEWROUND, "NIBBLES_GAME_ESTATUS_NEWROUND", "newround"}, {0, NULL, NULL}};
	GType nibbles_game_estatus_type_id;
	nibbles_game_estatus_type_id = g_enum_register_static ("NibblesGameeStatus", values);
	return nibbles_game_estatus_type_id;
}

GType
nibbles_game_estatus_get_type (void)
{
	static gsize nibbles_game_estatus_type_id__once = 0;
	if (g_once_init_enter (&nibbles_game_estatus_type_id__once)) {
		GType nibbles_game_estatus_type_id;
		nibbles_game_estatus_type_id = nibbles_game_estatus_get_type_once ();
		g_once_init_leave (&nibbles_game_estatus_type_id__once, nibbles_game_estatus_type_id);
	}
	return nibbles_game_estatus_type_id__once;
}

NibblesGame*
nibbles_game_construct (GType object_type,
                        gint start_level,
                        gint speed,
                        gint gamedelay,
                        gboolean fakes,
                        gboolean three_dimensional_view,
                        guint8 width,
                        guint8 height,
                        gboolean no_random)
{
	NibblesGame * self = NULL;
	guint32 _tmp0_ = 0U;
	self = (NibblesGame*) g_object_new (object_type, "skip-score", start_level != 1, "current-level", start_level, "speed", speed, "gamedelay", gamedelay, "fakes", fakes, "three-dimensional-view", three_dimensional_view, "width", width, "height", height, NULL);
	if (no_random) {
		_tmp0_ = (guint32) 42;
	} else {
		time_t _tmp1_;
		_tmp1_ = time (NULL);
		_tmp0_ = (guint32) _tmp1_;
	}
	g_random_set_seed (_tmp0_);
	return self;
}

NibblesGame*
nibbles_game_new (gint start_level,
                  gint speed,
                  gint gamedelay,
                  gboolean fakes,
                  gboolean three_dimensional_view,
                  guint8 width,
                  guint8 height,
                  gboolean no_random)
{
	return nibbles_game_construct (TYPE_NIBBLES_GAME, start_level, speed, gamedelay, fakes, three_dimensional_view, width, height, no_random);
}

static gboolean
_nibbles_game_keypress_keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self)
{
	gboolean result;
	result = nibbles_game_keypress ((NibblesGame*) self, a, b, remove_handler);
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		((GString*) _tmp4_)->str = NULL;
		result = _tmp5_;
		_g_string_free0 (ret);
		return result;
	}
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
nibbles_game_new_level (NibblesGame* self,
                        gint level_id)
{
	gchar* level_name = NULL;
	gchar* _tmp1_;
	gchar* filename = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FILE* file = NULL;
	FILE* _tmp6_;
	gchar* line = NULL;
	gchar** board = NULL;
	gchar** _tmp7_;
	gint board_length1;
	gint _board_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	if (!self->added_keypress_handler) {
		gboolean _tmp0_ = FALSE;
		g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ADD_KEYPRESS_HANDLER_SIGNAL], 0, _nibbles_game_keypress_keypress_handler_function, self, &_tmp0_);
		self->added_keypress_handler = _tmp0_;
	}
	_tmp1_ = g_strdup_printf ("level%03d.gnl", level_id);
	level_name = _tmp1_;
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_GET_PKGDATADIR_SIGNAL], 0, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp3_, "levels", level_name, NULL, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	filename = _tmp5_;
	_tmp6_ = g_fopen (filename, "r");
	_fclose0 (file);
	file = _tmp6_;
	if (file == NULL) {
		g_error ("nibbles-game.vala:275: Nibbles couldn't find pixmap file: %s", filename);
	}
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	board = _tmp7_;
	board_length1 = 0;
	_board_size_ = board_length1;
	while (TRUE) {
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = g_file_stream_read_line (file);
		_g_free0 (line);
		line = _tmp8_;
		_tmp9_ = line;
		if (!(_tmp9_ != NULL)) {
			break;
		}
		_tmp10_ = line;
		_tmp11_ = g_strdup ((const gchar*) _tmp10_);
		_vala_array_add3 (&board, &board_length1, &_board_size_, _tmp11_);
	}
	_tmp12_ = board;
	_tmp12__length1 = board_length1;
	_tmp13_ = self->priv->_numworms;
	if (!nibbles_game_load_board (self, _tmp12_, (gint) _tmp12__length1, (guint8) (8 + _tmp13_))) {
		g_error ("nibbles-game.vala:282: Level file appears to be damaged: %s", filename);
	}
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (line);
	_fclose0 (file);
	_g_free0 (filename);
	_g_free0 (level_name);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gboolean
nibbles_game_load_board (NibblesGame* self,
                         gchar** future_board,
                         gint future_board_length1,
                         guint8 regular_bonus)
{
	guint8 _tmp0_;
	NibblesGameBonuses* _tmp1_;
	WarpManager* _tmp2_;
	gchar* tmpboard = NULL;
	gint count = 0;
	WarpManager* _tmp63_;
	gint* _tmp64_;
	gint _tmp64__length1;
	gint _tmp64__length2;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_height;
	if (future_board_length1 != ((gint) _tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->bonuses;
	nibbles_game_bonuses_reset (_tmp1_, regular_bonus);
	_tmp2_ = self->priv->warp_manager;
	warp_manager_clear_warps (_tmp2_);
	count = 0;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				guint8 _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				guint8 _tmp9_;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_height;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = future_board[i];
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (tmpboard);
				tmpboard = _tmp7_;
				_tmp8_ = tmpboard;
				_tmp9_ = self->priv->_width;
				if (g_utf8_strlen (_tmp8_, (gssize) -1) != ((gint) _tmp9_)) {
					result = FALSE;
					_g_free0 (tmpboard);
					return result;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							guint8 _tmp12_;
							gunichar char_value = 0U;
							const gchar* _tmp13_;
							const gchar* _tmp14_;
							if (!_tmp10_) {
								guint8 _tmp11_;
								_tmp11_ = j;
								j = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = self->priv->_width;
							if (!(j < _tmp12_)) {
								break;
							}
							_tmp13_ = tmpboard;
							_tmp14_ = tmpboard;
							char_value = string_get_char (_tmp13_, (glong) string_index_of_nth_char (_tmp14_, (glong) j));
							switch (char_value) {
								case '.':
								case '+':
								{
									gint* _tmp15_;
									gint _tmp15__length1;
									gint _tmp15__length2;
									_tmp15_ = self->board;
									_tmp15__length1 = self->board_length1;
									_tmp15__length2 = self->board_length2;
									_tmp15_[(j * _tmp15__length2) + i] = (gint) 'a';
									break;
								}
								case 9475U:
								{
									gint* _tmp16_;
									gint _tmp16__length1;
									gint _tmp16__length2;
									_tmp16_ = self->board;
									_tmp16__length1 = self->board_length1;
									_tmp16__length2 = self->board_length2;
									_tmp16_[(j * _tmp16__length2) + i] = (gint) 'b';
									break;
								}
								case 9473U:
								{
									gint* _tmp17_;
									gint _tmp17__length1;
									gint _tmp17__length2;
									_tmp17_ = self->board;
									_tmp17__length1 = self->board_length1;
									_tmp17__length2 = self->board_length2;
									_tmp17_[(j * _tmp17__length2) + i] = (gint) 'c';
									break;
								}
								case 9495U:
								{
									gint* _tmp18_;
									gint _tmp18__length1;
									gint _tmp18__length2;
									_tmp18_ = self->board;
									_tmp18__length1 = self->board_length1;
									_tmp18__length2 = self->board_length2;
									_tmp18_[(j * _tmp18__length2) + i] = (gint) 'd';
									break;
								}
								case 9499U:
								{
									gint* _tmp19_;
									gint _tmp19__length1;
									gint _tmp19__length2;
									_tmp19_ = self->board;
									_tmp19__length1 = self->board_length1;
									_tmp19__length2 = self->board_length2;
									_tmp19_[(j * _tmp19__length2) + i] = (gint) 'e';
									break;
								}
								case 9487U:
								{
									gint* _tmp20_;
									gint _tmp20__length1;
									gint _tmp20__length2;
									_tmp20_ = self->board;
									_tmp20__length1 = self->board_length1;
									_tmp20__length2 = self->board_length2;
									_tmp20_[(j * _tmp20__length2) + i] = (gint) 'f';
									break;
								}
								case 9491U:
								{
									gint* _tmp21_;
									gint _tmp21__length1;
									gint _tmp21__length2;
									_tmp21_ = self->board;
									_tmp21__length1 = self->board_length1;
									_tmp21__length2 = self->board_length2;
									_tmp21_[(j * _tmp21__length2) + i] = (gint) 'g';
									break;
								}
								case 9531U:
								{
									gint* _tmp22_;
									gint _tmp22__length1;
									gint _tmp22__length2;
									_tmp22_ = self->board;
									_tmp22__length1 = self->board_length1;
									_tmp22__length2 = self->board_length2;
									_tmp22_[(j * _tmp22__length2) + i] = (gint) 'h';
									break;
								}
								case 9507U:
								{
									gint* _tmp23_;
									gint _tmp23__length1;
									gint _tmp23__length2;
									_tmp23_ = self->board;
									_tmp23__length1 = self->board_length1;
									_tmp23__length2 = self->board_length2;
									_tmp23_[(j * _tmp23__length2) + i] = (gint) 'i';
									break;
								}
								case 9515U:
								{
									gint* _tmp24_;
									gint _tmp24__length1;
									gint _tmp24__length2;
									_tmp24_ = self->board;
									_tmp24__length1 = self->board_length1;
									_tmp24__length2 = self->board_length2;
									_tmp24_[(j * _tmp24__length2) + i] = (gint) 'j';
									break;
								}
								case 9523U:
								{
									gint* _tmp25_;
									gint _tmp25__length1;
									gint _tmp25__length2;
									_tmp25_ = self->board;
									_tmp25__length1 = self->board_length1;
									_tmp25__length2 = self->board_length2;
									_tmp25_[(j * _tmp25__length2) + i] = (gint) 'k';
									break;
								}
								case 9547U:
								{
									gint* _tmp26_;
									gint _tmp26__length1;
									gint _tmp26__length2;
									_tmp26_ = self->board;
									_tmp26__length1 = self->board_length1;
									_tmp26__length2 = self->board_length2;
									_tmp26_[(j * _tmp26__length2) + i] = (gint) 'l';
									break;
								}
								case 9650U:
								case 'm':
								{
									gint* _tmp27_;
									gint _tmp27__length1;
									gint _tmp27__length2;
									gint _tmp28_;
									_tmp27_ = self->board;
									_tmp27__length1 = self->board_length1;
									_tmp27__length2 = self->board_length2;
									_tmp27_[(j * _tmp27__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp28_ = self->priv->_numworms;
									if (count < _tmp28_) {
										GeeLinkedList* _tmp29_;
										gpointer _tmp30_;
										Worm* _tmp31_;
										gint _tmp32_;
										_tmp29_ = self->priv->_worms;
										_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, count);
										_tmp31_ = (Worm*) _tmp30_;
										worm_set_start (_tmp31_, j, i, WORM_DIRECTION_UP);
										_g_object_unref0 (_tmp31_);
										_tmp32_ = count;
										count = _tmp32_ + 1;
									}
									break;
								}
								case 9664U:
								case 'n':
								{
									gint* _tmp33_;
									gint _tmp33__length1;
									gint _tmp33__length2;
									gint _tmp34_;
									_tmp33_ = self->board;
									_tmp33__length1 = self->board_length1;
									_tmp33__length2 = self->board_length2;
									_tmp33_[(j * _tmp33__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp34_ = self->priv->_numworms;
									if (count < _tmp34_) {
										GeeLinkedList* _tmp35_;
										gpointer _tmp36_;
										Worm* _tmp37_;
										gint _tmp38_;
										_tmp35_ = self->priv->_worms;
										_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, count);
										_tmp37_ = (Worm*) _tmp36_;
										worm_set_start (_tmp37_, j, i, WORM_DIRECTION_LEFT);
										_g_object_unref0 (_tmp37_);
										_tmp38_ = count;
										count = _tmp38_ + 1;
									}
									break;
								}
								case 9660U:
								case 'o':
								{
									gint* _tmp39_;
									gint _tmp39__length1;
									gint _tmp39__length2;
									gint _tmp40_;
									_tmp39_ = self->board;
									_tmp39__length1 = self->board_length1;
									_tmp39__length2 = self->board_length2;
									_tmp39_[(j * _tmp39__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp40_ = self->priv->_numworms;
									if (count < _tmp40_) {
										GeeLinkedList* _tmp41_;
										gpointer _tmp42_;
										Worm* _tmp43_;
										gint _tmp44_;
										_tmp41_ = self->priv->_worms;
										_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, count);
										_tmp43_ = (Worm*) _tmp42_;
										worm_set_start (_tmp43_, j, i, WORM_DIRECTION_DOWN);
										_g_object_unref0 (_tmp43_);
										_tmp44_ = count;
										count = _tmp44_ + 1;
									}
									break;
								}
								case 9654U:
								case 'p':
								{
									gint* _tmp45_;
									gint _tmp45__length1;
									gint _tmp45__length2;
									gint _tmp46_;
									_tmp45_ = self->board;
									_tmp45__length1 = self->board_length1;
									_tmp45__length2 = self->board_length2;
									_tmp45_[(j * _tmp45__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp46_ = self->priv->_numworms;
									if (count < _tmp46_) {
										GeeLinkedList* _tmp47_;
										gpointer _tmp48_;
										Worm* _tmp49_;
										gint _tmp50_;
										_tmp47_ = self->priv->_worms;
										_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, count);
										_tmp49_ = (Worm*) _tmp48_;
										worm_set_start (_tmp49_, j, i, WORM_DIRECTION_RIGHT);
										_g_object_unref0 (_tmp49_);
										_tmp50_ = count;
										count = _tmp50_ + 1;
									}
									break;
								}
								case 'Q':
								case 'R':
								case 'S':
								case 'T':
								case 'U':
								case 'V':
								case 'W':
								case 'X':
								case 'Y':
								case 'Z':
								{
									gboolean _tmp51_ = FALSE;
									gint* _tmp52_;
									gint _tmp52__length1;
									gint _tmp52__length2;
									WarpManager* _tmp53_;
									gint* _tmp54_;
									gint _tmp54__length1;
									gint _tmp54__length2;
									gint _tmp55_;
									gint* _tmp56_;
									gint _tmp56__length1;
									gint _tmp56__length2;
									gint* _tmp57_;
									gint _tmp57__length1;
									gint _tmp57__length2;
									gint* _tmp58_;
									gint _tmp58__length1;
									gint _tmp58__length2;
									gint* _tmp59_;
									gint _tmp59__length1;
									gint _tmp59__length2;
									if (((gint) j) == 0) {
										_tmp51_ = TRUE;
									} else {
										_tmp51_ = ((gint) i) == 0;
									}
									if (_tmp51_) {
										result = FALSE;
										_g_free0 (tmpboard);
										return result;
									}
									_tmp52_ = self->board;
									_tmp52__length1 = self->board_length1;
									_tmp52__length2 = self->board_length2;
									_tmp52_[(j * _tmp52__length2) + i] = (gint) char_value;
									_tmp53_ = self->priv->warp_manager;
									_tmp54_ = self->board;
									_tmp54__length1 = self->board_length1;
									_tmp54__length2 = self->board_length2;
									_tmp55_ = _tmp54_[(j * _tmp54__length2) + i];
									warp_manager_add_warp_source (_tmp53_, _tmp55_, (guint8) (j - 1), (guint8) (i - 1), char_value == ((gunichar) 'Q'));
									_tmp56_ = self->board;
									_tmp56__length1 = self->board_length1;
									_tmp56__length2 = self->board_length2;
									_tmp56_[((j - 1) * _tmp56__length2) + (i - 1)] = (gint) NIBBLES_GAME_WARPCHAR;
									_tmp57_ = self->board;
									_tmp57__length1 = self->board_length1;
									_tmp57__length2 = self->board_length2;
									_tmp57_[(j * _tmp57__length2) + (i - 1)] = (gint) NIBBLES_GAME_WARPCHAR;
									_tmp58_ = self->board;
									_tmp58__length1 = self->board_length1;
									_tmp58__length2 = self->board_length2;
									_tmp58_[((j - 1) * _tmp58__length2) + i] = (gint) NIBBLES_GAME_WARPCHAR;
									_tmp59_ = self->board;
									_tmp59__length1 = self->board_length1;
									_tmp59__length2 = self->board_length2;
									_tmp59_[(j * _tmp59__length2) + i] = (gint) NIBBLES_GAME_WARPCHAR;
									g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_WARP_ADDED_SIGNAL], 0, (guint8) (j - 1), (guint8) (i - 1));
									break;
								}
								case 'r':
								case 's':
								case 't':
								case 'u':
								case 'v':
								case 'w':
								case 'x':
								case 'y':
								case 'z':
								{
									WarpManager* _tmp60_;
									gint* _tmp61_;
									gint _tmp61__length1;
									gint _tmp61__length2;
									_tmp60_ = self->priv->warp_manager;
									warp_manager_add_warp_target (_tmp60_, (((gint) char_value) - ((gint) 'a')) + ((gint) 'A'), j, i);
									_tmp61_ = self->board;
									_tmp61__length1 = self->board_length1;
									_tmp61__length2 = self->board_length2;
									_tmp61_[(j * _tmp61__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									break;
								}
								case 'a':
								case 'b':
								case 'c':
								case 'd':
								case 'e':
								case 'f':
								case 'g':
								case 'h':
								case 'i':
								case 'j':
								case 'k':
								case 'l':
								{
									gint* _tmp62_;
									gint _tmp62__length1;
									gint _tmp62__length2;
									_tmp62_ = self->board;
									_tmp62__length1 = self->board_length1;
									_tmp62__length2 = self->board_length2;
									_tmp62_[(j * _tmp62__length2) + i] = (gint) char_value;
									break;
								}
								default:
								{
									result = FALSE;
									_g_free0 (tmpboard);
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp63_ = self->priv->warp_manager;
	_tmp64_ = self->board;
	_tmp64__length1 = self->board_length1;
	_tmp64__length2 = self->board_length2;
	warp_manager_initilise (_tmp63_, _tmp64_, (gint) _tmp64__length1, (gint) _tmp64__length2);
	result = TRUE;
	_g_free0 (tmpboard);
	return result;
}

static gboolean
__lambda6_ (NibblesGame* self)
{
	gboolean result;
	self->priv->bonus_cycle = (guint8) ((self->priv->bonus_cycle + 1) % 3);
	if (((gint) self->priv->bonus_cycle) == 0) {
		nibbles_game_add_bonus (self, FALSE);
	}
	result = nibbles_game_main_loop_cb (self);
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((NibblesGame*) self);
	return result;
}

void
nibbles_game_start (NibblesGame* self,
                    gboolean add_initial_bonus)
{
	gint _tmp0_ = 0;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	if (add_initial_bonus) {
		nibbles_game_add_bonus (self, TRUE);
	}
	nibbles_game_set_is_running (self, TRUE);
	_tmp1_ = self->priv->_speed;
	if (_tmp1_ == 1) {
		gint _tmp2_;
		_tmp2_ = self->priv->_gamedelay;
		_tmp0_ = (_tmp2_ * 3) / 2;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->_gamedelay;
		_tmp4_ = self->priv->_speed;
		_tmp0_ = _tmp3_ * _tmp4_;
	}
	self->priv->main_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp0_, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	g_source_set_name_by_id (self->priv->main_id, "[Nibbles] main_loop_cb");
}

void
nibbles_game_stop (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_running (self, FALSE);
	if (self->priv->main_id == ((guint) 0)) {
		return;
	}
	g_source_remove (self->priv->main_id);
	self->priv->main_id = (guint) 0;
}

static void
_vala_array_add4 (gint* * array,
                  gint* length,
                  gint* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

inline void
nibbles_game_reset (NibblesGame* self,
                    gint start_level)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	nibbles_game_set_skip_score (self, start_level != 1);
	_tmp0_ = nibbles_game_get_progress (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 1) {
		nibbles_game_set_current_level (self, start_level);
	} else {
		{
			gint i = 0;
			i = NIBBLES_GAME_MAX_LEVEL;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ - 1;
						_vala_array_add4 (&self->levels_uncompleated, &self->levels_uncompleated_length1, &self->_levels_uncompleated_size_, _tmp3_);
					}
					_tmp2_ = FALSE;
					if (!(i > 0)) {
						break;
					}
				}
			}
		}
		nibbles_game_set_current_level (self, nibbles_game_remove_one_uncompleated_level (self));
	}
	nibbles_game_set_is_paused (self, FALSE);
}

static gint
nibbles_game_remove_one_uncompleated_level (NibblesGame* self)
{
	gint32 index = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint level = 0;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->levels_uncompleated;
	_tmp0__length1 = self->levels_uncompleated_length1;
	index = g_random_int_range ((gint32) 0, (gint32) _tmp0__length1);
	_tmp1_ = self->levels_uncompleated;
	_tmp1__length1 = self->levels_uncompleated_length1;
	_tmp2_ = _tmp1_[index];
	level = _tmp2_;
	_tmp3_ = self->levels_uncompleated;
	_tmp3__length1 = self->levels_uncompleated_length1;
	if (index < ((gint32) (_tmp3__length1 - 1))) {
		gint* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->levels_uncompleated;
		_tmp4__length1 = self->levels_uncompleated_length1;
		_vala_array_move (self->levels_uncompleated, sizeof (gint), (gint) (index + 1), (gint) index, _tmp4__length1 - (index + 1));
	}
	_tmp5_ = self->levels_uncompleated;
	_tmp5__length1 = self->levels_uncompleated_length1;
	_tmp6_ = _tmp5__length1 - 1;
	self->levels_uncompleated = g_renew (gint, self->levels_uncompleated, _tmp5__length1 - 1);
	(_tmp6_ > self->levels_uncompleated_length1) ? memset (self->levels_uncompleated + self->levels_uncompleated_length1, 0, sizeof (gint) * (_tmp6_ - self->levels_uncompleated_length1)) : NULL;
	self->levels_uncompleated_length1 = _tmp6_;
	self->_levels_uncompleated_size_ = _tmp6_;
	result = level;
	return result;
}

static void
nibbles_game_end (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	nibbles_game_stop (self);
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
}

static gboolean
_nibbles_game_estatus_equal (const NibblesGameeStatus * s1,
                             const NibblesGameeStatus * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gboolean
nibbles_game_main_loop_cb (NibblesGame* self)
{
	NibblesGameeStatus* status = NULL;
	NibblesGameeStatus* _tmp0_;
	gboolean _tmp1_ = FALSE;
	NibblesGameeStatus* _tmp2_;
	NibblesGameeStatus _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = nibbles_game_get_game_status (self);
	status = _tmp0_;
	_tmp2_ = status;
	_tmp3_ = NIBBLES_GAME_ESTATUS_GAMEOVER;
	if (_nibbles_game_estatus_equal (_tmp2_, &_tmp3_) == TRUE) {
		_tmp1_ = TRUE;
	} else {
		NibblesGameeStatus* _tmp4_;
		NibblesGameeStatus _tmp5_;
		_tmp4_ = status;
		_tmp5_ = NIBBLES_GAME_ESTATUS_VICTORY;
		_tmp1_ = _nibbles_game_estatus_equal (_tmp4_, &_tmp5_) == TRUE;
	}
	if (_tmp1_) {
		GeeLinkedList* _tmp6_;
		gpointer _tmp7_;
		Worm* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		nibbles_game_end (self);
		_tmp6_ = self->priv->_worms;
		_tmp7_ = gee_linked_list_first (_tmp6_);
		_tmp8_ = (Worm*) _tmp7_;
		_tmp9_ = worm_get_score (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_current_level;
		g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp10_, _tmp11_);
		_g_object_unref0 (_tmp8_);
		result = G_SOURCE_REMOVE;
		_g_free0 (status);
		return result;
	} else {
		NibblesGameeStatus* _tmp12_;
		NibblesGameeStatus _tmp13_;
		_tmp12_ = status;
		_tmp13_ = NIBBLES_GAME_ESTATUS_NEWROUND;
		if (_nibbles_game_estatus_equal (_tmp12_, &_tmp13_) == TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			nibbles_game_stop (self);
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL], 0);
			_tmp14_ = nibbles_game_get_progress (self);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == 0) {
				gint _tmp16_;
				gint _tmp17_;
				_tmp16_ = self->priv->_current_level;
				nibbles_game_set_current_level (self, _tmp16_ + 1);
				_tmp17_ = self->priv->_current_level;
				if (_tmp17_ == (NIBBLES_GAME_MAX_LEVEL + 1)) {
					GeeLinkedList* _tmp18_;
					gpointer _tmp19_;
					Worm* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					_tmp18_ = self->priv->_worms;
					_tmp19_ = gee_linked_list_first (_tmp18_);
					_tmp20_ = (Worm*) _tmp19_;
					_tmp21_ = worm_get_score (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = self->priv->_current_level;
					g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp22_, _tmp23_);
					_g_object_unref0 (_tmp20_);
				}
			} else {
				gint _tmp24_;
				gint _tmp25_;
				_tmp24_ = nibbles_game_get_progress (self);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == 1) {
					gint* _tmp26_;
					gint _tmp26__length1;
					_tmp26_ = self->levels_uncompleated;
					_tmp26__length1 = self->levels_uncompleated_length1;
					if (_tmp26__length1 > 0) {
						nibbles_game_set_current_level (self, nibbles_game_remove_one_uncompleated_level (self));
					} else {
						GeeLinkedList* _tmp27_;
						gpointer _tmp28_;
						Worm* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						_tmp27_ = self->priv->_worms;
						_tmp28_ = gee_linked_list_first (_tmp27_);
						_tmp29_ = (Worm*) _tmp28_;
						_tmp30_ = worm_get_score (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = self->priv->_current_level;
						g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp31_, _tmp32_);
						_g_object_unref0 (_tmp29_);
					}
				}
			}
			result = G_SOURCE_REMOVE;
			_g_free0 (status);
			return result;
		} else {
			nibbles_game_move_worms (self);
			result = G_SOURCE_CONTINUE;
			_g_free0 (status);
			return result;
		}
	}
}

static GeeList*
_nibbles_game_get_other_worms_worm_get_other_worms_type (Worm* _self_,
                                                         gpointer self)
{
	GeeList* result;
	result = nibbles_game_get_other_worms ((NibblesGame*) self, _self_);
	return result;
}

static GeeList*
_nibbles_game_get_bonuses_worm_get_bonuses_type (gpointer self)
{
	GeeList* result;
	result = nibbles_game_get_bonuses ((NibblesGame*) self);
	return result;
}

static void
_nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                               gpointer self)
{
	nibbles_game_bonus_found_cb ((NibblesGame*) self, _sender);
}

void
nibbles_game_create_worms (NibblesGame* self,
                           GeeArrayList* worm_settings)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_worms;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_numai;
	_tmp2_ = self->priv->_numhumans;
	nibbles_game_set_numworms (self, _tmp1_ + _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				Worm* worm = NULL;
				guint8 _tmp6_;
				guint8 _tmp7_;
				Worm* _tmp8_;
				Worm* _tmp9_;
				Worm* _tmp10_;
				gint _tmp11_;
				GeeLinkedList* _tmp12_;
				Worm* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_numworms;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->_width;
				_tmp7_ = self->priv->_height;
				_tmp8_ = worm_new (i, _tmp6_, _tmp7_, _nibbles_game_get_other_worms_worm_get_other_worms_type, self, _nibbles_game_get_bonuses_worm_get_bonuses_type, self);
				worm = _tmp8_;
				_tmp9_ = worm;
				g_signal_connect_object (_tmp9_, "bonus-found", (GCallback) _nibbles_game_bonus_found_cb_worm_bonus_found, self, 0);
				_tmp10_ = worm;
				_tmp11_ = self->priv->_numhumans;
				_tmp10_->is_human = i < _tmp11_;
				_tmp12_ = self->priv->_worms;
				_tmp13_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				_g_object_unref0 (worm);
			}
		}
	}
	if (worm_settings != NULL) {
		nibbles_game_load_worm_properties (self, worm_settings);
	}
}

void
nibbles_game_add_worms (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			gint* _tmp9_;
			gint _tmp9__length1;
			gint _tmp9__length2;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp8_ = worm;
			_tmp9_ = self->board;
			_tmp9__length1 = self->board_length1;
			_tmp9__length2 = self->board_length2;
			worm_spawn (_tmp8_, _tmp9_, (gint) _tmp9__length1, (gint) _tmp9__length2);
			_g_object_unref0 (worm);
		}
	}
}

static void
nibbles_game_move_worms (NibblesGame* self)
{
	NibblesGameBonuses* _tmp13_;
	guint8 missed_bonuses_to_replace = 0U;
	NibblesGameBonuses* _tmp28_;
	guint8 _tmp29_ = 0U;
	GeeLinkedList* dead_worms = NULL;
	GeeLinkedList* _tmp53_;
	NibblesGameBonuses* _tmp176_;
	GeeSet* _tmp177_;
	gint _tmp178_;
	gint _tmp179_;
	GeeSet* _tmp180_;
	GeeHashMap* _tmp235_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			Worm* _tmp10_;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp8_ = worm;
			if (_tmp8_->rounds_to_stay_still == 1) {
				Worm* _tmp9_;
				_tmp9_ = worm;
				_tmp9_->is_stopped = FALSE;
			}
			_tmp10_ = worm;
			if (_tmp10_->rounds_to_stay_still > 0) {
				Worm* _tmp11_;
				gint _tmp12_;
				_tmp11_ = worm;
				_tmp11_->rounds_to_stay_still = _tmp11_->rounds_to_stay_still - 1;
				_tmp12_ = _tmp11_->rounds_to_stay_still;
			}
			_g_object_unref0 (worm);
		}
	}
	_tmp13_ = self->priv->bonuses;
	if (nibbles_game_bonuses_too_many_missed (_tmp13_)) {
		{
			GeeLinkedList* _worm_list = NULL;
			GeeLinkedList* _tmp14_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _worm_index = 0;
			_tmp14_ = self->priv->_worms;
			_worm_list = _tmp14_;
			_tmp15_ = _worm_list;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_worm_size = _tmp17_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				Worm* worm = NULL;
				GeeLinkedList* _tmp20_;
				gpointer _tmp21_;
				Worm* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_worm_index = _worm_index + 1;
				_tmp18_ = _worm_index;
				_tmp19_ = _worm_size;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = _worm_list;
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _worm_index);
				worm = (Worm*) _tmp21_;
				_tmp22_ = worm;
				_tmp23_ = worm_get_score (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ > 0) {
					Worm* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					_tmp25_ = worm;
					_tmp26_ = worm_get_score (_tmp25_);
					_tmp27_ = _tmp26_;
					worm_set_score (_tmp25_, _tmp27_ - 1);
				}
				_g_object_unref0 (worm);
			}
		}
	}
	_tmp28_ = self->priv->bonuses;
	nibbles_game_bonuses_on_worms_move (_tmp28_, &_tmp29_);
	missed_bonuses_to_replace = _tmp29_;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				if (!_tmp30_) {
					guint8 _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				if (!(i < missed_bonuses_to_replace)) {
					break;
				}
				nibbles_game_add_bonus (self, TRUE);
			}
		}
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp32_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _worm_index = 0;
		_tmp32_ = self->priv->_worms;
		_worm_list = _tmp32_;
		_tmp33_ = _worm_list;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_worm_size = _tmp35_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp38_;
			gpointer _tmp39_;
			gboolean _tmp40_ = FALSE;
			Worm* _tmp41_;
			_worm_index = _worm_index + 1;
			_tmp36_ = _worm_index;
			_tmp37_ = _worm_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _worm_list;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _worm_index);
			worm = (Worm*) _tmp39_;
			_tmp41_ = worm;
			if (!_tmp41_->is_stopped) {
				Worm* _tmp42_;
				WormPositions* _tmp43_;
				gboolean _tmp44_;
				gboolean _tmp45_;
				_tmp42_ = worm;
				_tmp43_ = _tmp42_->list;
				_tmp44_ = gee_collection_get_is_empty ((GeeCollection*) _tmp43_);
				_tmp45_ = _tmp44_;
				_tmp40_ = !_tmp45_;
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				Worm* _tmp46_;
				_tmp46_ = worm;
				if (_tmp46_->is_human) {
					Worm* _tmp47_;
					gint* _tmp48_;
					gint _tmp48__length1;
					gint _tmp48__length2;
					GeeLinkedList* _tmp49_;
					_tmp47_ = worm;
					_tmp48_ = self->board;
					_tmp48__length1 = self->board_length1;
					_tmp48__length2 = self->board_length2;
					_tmp49_ = self->priv->_worms;
					worm_human_move (_tmp47_, _tmp48_, (gint) _tmp48__length1, (gint) _tmp48__length2, _tmp49_);
				} else {
					Worm* _tmp50_;
					gint* _tmp51_;
					gint _tmp51__length1;
					gint _tmp51__length2;
					GeeLinkedList* _tmp52_;
					_tmp50_ = worm;
					_tmp51_ = self->board;
					_tmp51__length1 = self->board_length1;
					_tmp51__length2 = self->board_length2;
					_tmp52_ = self->priv->_worms;
					worm_ai_move (_tmp50_, _tmp51_, (gint) _tmp51__length1, (gint) _tmp51__length2, _tmp52_);
				}
			}
			_g_object_unref0 (worm);
		}
	}
	_tmp53_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dead_worms = _tmp53_;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp54_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gint _worm_index = 0;
		_tmp54_ = self->priv->_worms;
		_worm_list = _tmp54_;
		_tmp55_ = _worm_list;
		_tmp56_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp55_);
		_tmp57_ = _tmp56_;
		_worm_size = _tmp57_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp58_;
			gint _tmp59_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp60_;
			gpointer _tmp61_;
			gboolean _tmp62_ = FALSE;
			Worm* _tmp63_;
			_worm_index = _worm_index + 1;
			_tmp58_ = _worm_index;
			_tmp59_ = _worm_size;
			if (!(_tmp58_ < _tmp59_)) {
				break;
			}
			_tmp60_ = _worm_list;
			_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp60_, _worm_index);
			worm = (Worm*) _tmp61_;
			_tmp63_ = worm;
			if (!_tmp63_->is_stopped) {
				Worm* _tmp64_;
				WormPositions* _tmp65_;
				gboolean _tmp66_;
				gboolean _tmp67_;
				_tmp64_ = worm;
				_tmp65_ = _tmp64_->list;
				_tmp66_ = gee_collection_get_is_empty ((GeeCollection*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp62_ = !_tmp67_;
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				Position position = {0};
				Worm* _tmp68_;
				Position _tmp69_ = {0};
				guint8 target_x = 0U;
				guint8 target_y = 0U;
				WarpManager* _tmp70_;
				Position _tmp71_;
				Position _tmp72_;
				Worm* _tmp73_;
				WormDirection _tmp74_;
				WormDirection _tmp75_;
				Worm* _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				Worm* _tmp79_;
				GeeLinkedList* _tmp80_;
				Worm* _tmp81_;
				guint8 _tmp82_ = 0U;
				guint8 _tmp83_ = 0U;
				gboolean _tmp84_ = FALSE;
				gboolean _tmp85_;
				Worm* _tmp87_;
				gint* _tmp88_;
				gint _tmp88__length1;
				gint _tmp88__length2;
				GeeLinkedList* _tmp89_;
				Position _tmp90_;
				_tmp68_ = worm;
				worm_position_move (_tmp68_, &_tmp69_);
				position = _tmp69_;
				_tmp70_ = self->priv->warp_manager;
				_tmp71_ = position;
				_tmp72_ = position;
				_tmp73_ = worm;
				_tmp74_ = worm_get_direction (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = worm;
				_tmp77_ = worm_get_length (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = worm;
				_tmp80_ = self->priv->_worms;
				_tmp81_ = worm;
				_tmp85_ = warp_manager_get_warp_target (_tmp70_, _tmp71_.x, _tmp72_.y, _tmp75_, _tmp78_, !_tmp79_->is_human, _tmp80_, &_tmp82_, &_tmp83_, &_tmp84_);
				target_x = _tmp82_;
				target_y = _tmp83_;
				_tmp81_->warp_bonus = _tmp84_;
				if (_tmp85_) {
					Position _tmp86_ = {0};
					memset (&_tmp86_, 0, sizeof (Position));
					_tmp86_.x = target_x;
					_tmp86_.y = target_y;
					position = _tmp86_;
				}
				_tmp87_ = worm;
				_tmp88_ = self->board;
				_tmp88__length1 = self->board_length1;
				_tmp88__length2 = self->board_length2;
				_tmp89_ = self->priv->_worms;
				_tmp90_ = position;
				if (!worm_can_move_to (_tmp87_, _tmp88_, (gint) _tmp88__length1, (gint) _tmp88__length2, (GeeList*) _tmp89_, &_tmp90_)) {
					GeeLinkedList* _tmp91_;
					Worm* _tmp92_;
					_tmp91_ = dead_worms;
					_tmp92_ = worm;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp91_, _tmp92_);
					g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "crash");
				} else {
					Worm* _tmp93_;
					Position _tmp94_;
					_tmp93_ = worm;
					_tmp94_ = position;
					_tmp93_->warp_position = _tmp94_;
				}
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp95_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _worm_index = 0;
		_tmp95_ = self->priv->_worms;
		_worm_list = _tmp95_;
		_tmp96_ = _worm_list;
		_tmp97_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_worm_size = _tmp98_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp99_;
			gint _tmp100_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp101_;
			gpointer _tmp102_;
			gboolean _tmp103_ = FALSE;
			gboolean _tmp104_ = FALSE;
			Worm* _tmp105_;
			Worm* _tmp112_;
			gint* _tmp113_;
			gint _tmp113__length1;
			gint _tmp113__length2;
			gint* _tmp114_;
			gint _tmp114__length1;
			gint _tmp114__length2;
			Worm* _tmp115_;
			Position _tmp116_ = {0};
			Position _tmp117_;
			Worm* _tmp118_;
			Position _tmp119_ = {0};
			Position _tmp120_;
			gint _tmp121_;
			_worm_index = _worm_index + 1;
			_tmp99_ = _worm_index;
			_tmp100_ = _worm_size;
			if (!(_tmp99_ < _tmp100_)) {
				break;
			}
			_tmp101_ = _worm_list;
			_tmp102_ = gee_abstract_list_get ((GeeAbstractList*) _tmp101_, _worm_index);
			worm = (Worm*) _tmp102_;
			_tmp105_ = worm;
			if (_tmp105_->is_stopped) {
				_tmp104_ = TRUE;
			} else {
				Worm* _tmp106_;
				WormPositions* _tmp107_;
				gboolean _tmp108_;
				gboolean _tmp109_;
				_tmp106_ = worm;
				_tmp107_ = _tmp106_->list;
				_tmp108_ = gee_collection_get_is_empty ((GeeCollection*) _tmp107_);
				_tmp109_ = _tmp108_;
				_tmp104_ = _tmp109_;
			}
			if (_tmp104_) {
				_tmp103_ = TRUE;
			} else {
				GeeLinkedList* _tmp110_;
				Worm* _tmp111_;
				_tmp110_ = dead_worms;
				_tmp111_ = worm;
				_tmp103_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp110_, _tmp111_);
			}
			if (_tmp103_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp112_ = worm;
			_tmp113_ = self->board;
			_tmp113__length1 = self->board_length1;
			_tmp113__length2 = self->board_length2;
			worm_move_part_1 (_tmp112_, _tmp113_, (gint) _tmp113__length1, (gint) _tmp113__length2);
			_tmp114_ = self->board;
			_tmp114__length1 = self->board_length1;
			_tmp114__length2 = self->board_length2;
			_tmp115_ = worm;
			worm_get_head (_tmp115_, &_tmp116_);
			_tmp117_ = _tmp116_;
			_tmp118_ = worm;
			worm_get_head (_tmp118_, &_tmp119_);
			_tmp120_ = _tmp119_;
			_tmp121_ = _tmp114_[(_tmp117_.x * _tmp114__length2) + _tmp120_.y];
			if (_tmp121_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
				Worm* _tmp122_;
				gint* _tmp123_;
				gint _tmp123__length1;
				gint _tmp123__length2;
				Worm* _tmp124_;
				Position _tmp125_;
				Worm* _tmp126_;
				_tmp122_ = worm;
				_tmp123_ = self->board;
				_tmp123__length1 = self->board_length1;
				_tmp123__length2 = self->board_length2;
				_tmp124_ = worm;
				_tmp125_ = _tmp124_->warp_position;
				worm_move_part_2 (_tmp122_, _tmp123_, (gint) _tmp123__length1, (gint) _tmp123__length2, &_tmp125_);
				_tmp126_ = worm;
				if (_tmp126_->warp_bonus) {
					Worm* _tmp127_;
					Worm* _tmp128_;
					gint _tmp129_;
					gint _tmp130_;
					Worm* _tmp131_;
					gint _tmp132_;
					gint _tmp133_;
					gint _tmp134_;
					_tmp127_ = worm;
					_tmp128_ = worm;
					_tmp129_ = worm_get_score (_tmp128_);
					_tmp130_ = _tmp129_;
					_tmp131_ = worm;
					_tmp132_ = worm_get_length (_tmp131_);
					_tmp133_ = _tmp132_;
					_tmp134_ = self->priv->_current_level;
					worm_set_score (_tmp128_, _tmp130_ + ((_tmp133_ * _tmp134_) / 2));
					g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "bonus");
				}
			} else {
				Worm* _tmp135_;
				gint* _tmp136_;
				gint _tmp136__length1;
				gint _tmp136__length2;
				_tmp135_ = worm;
				_tmp136_ = self->board;
				_tmp136__length1 = self->board_length1;
				_tmp136__length2 = self->board_length2;
				worm_move_part_2 (_tmp135_, _tmp136_, (gint) _tmp136__length1, (gint) _tmp136__length2, NULL);
			}
			{
				GeeLinkedList* _other_worm_list = NULL;
				GeeLinkedList* _tmp137_;
				gint _other_worm_size = 0;
				GeeLinkedList* _tmp138_;
				gint _tmp139_;
				gint _tmp140_;
				gint _other_worm_index = 0;
				_tmp137_ = self->priv->_worms;
				_other_worm_list = _tmp137_;
				_tmp138_ = _other_worm_list;
				_tmp139_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp138_);
				_tmp140_ = _tmp139_;
				_other_worm_size = _tmp140_;
				_other_worm_index = -1;
				while (TRUE) {
					gint _tmp141_;
					gint _tmp142_;
					Worm* other_worm = NULL;
					GeeLinkedList* _tmp143_;
					gpointer _tmp144_;
					gboolean _tmp145_ = FALSE;
					gboolean _tmp146_ = FALSE;
					gboolean _tmp147_ = FALSE;
					gboolean _tmp148_ = FALSE;
					Worm* _tmp149_;
					Worm* _tmp150_;
					_other_worm_index = _other_worm_index + 1;
					_tmp141_ = _other_worm_index;
					_tmp142_ = _other_worm_size;
					if (!(_tmp141_ < _tmp142_)) {
						break;
					}
					_tmp143_ = _other_worm_list;
					_tmp144_ = gee_abstract_list_get ((GeeAbstractList*) _tmp143_, _other_worm_index);
					other_worm = (Worm*) _tmp144_;
					_tmp149_ = worm;
					_tmp150_ = other_worm;
					if (_tmp149_ != _tmp150_) {
						Worm* _tmp151_;
						_tmp151_ = other_worm;
						_tmp148_ = !_tmp151_->is_stopped;
					} else {
						_tmp148_ = FALSE;
					}
					if (_tmp148_) {
						Worm* _tmp152_;
						WormPositions* _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp155_;
						_tmp152_ = other_worm;
						_tmp153_ = _tmp152_->list;
						_tmp154_ = gee_collection_get_is_empty ((GeeCollection*) _tmp153_);
						_tmp155_ = _tmp154_;
						_tmp147_ = !_tmp155_;
					} else {
						_tmp147_ = FALSE;
					}
					if (_tmp147_) {
						Worm* _tmp156_;
						Position _tmp157_ = {0};
						Position _tmp158_;
						Worm* _tmp159_;
						Position _tmp160_ = {0};
						Position _tmp161_;
						_tmp156_ = worm;
						worm_get_head (_tmp156_, &_tmp157_);
						_tmp158_ = _tmp157_;
						_tmp159_ = other_worm;
						worm_get_head (_tmp159_, &_tmp160_);
						_tmp161_ = _tmp160_;
						_tmp146_ = _tmp158_.x == _tmp161_.x;
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						Worm* _tmp162_;
						Position _tmp163_ = {0};
						Position _tmp164_;
						Worm* _tmp165_;
						Position _tmp166_ = {0};
						Position _tmp167_;
						_tmp162_ = worm;
						worm_get_head (_tmp162_, &_tmp163_);
						_tmp164_ = _tmp163_;
						_tmp165_ = other_worm;
						worm_get_head (_tmp165_, &_tmp166_);
						_tmp167_ = _tmp166_;
						_tmp145_ = _tmp164_.y == _tmp167_.y;
					} else {
						_tmp145_ = FALSE;
					}
					if (_tmp145_) {
						GeeLinkedList* _tmp168_;
						Worm* _tmp169_;
						GeeLinkedList* _tmp172_;
						Worm* _tmp173_;
						_tmp168_ = dead_worms;
						_tmp169_ = worm;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp168_, _tmp169_)) {
							GeeLinkedList* _tmp170_;
							Worm* _tmp171_;
							_tmp170_ = dead_worms;
							_tmp171_ = worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp170_, _tmp171_);
						}
						_tmp172_ = dead_worms;
						_tmp173_ = other_worm;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp172_, _tmp173_)) {
							GeeLinkedList* _tmp174_;
							Worm* _tmp175_;
							_tmp174_ = dead_worms;
							_tmp175_ = other_worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp174_, _tmp175_);
						}
					}
					_g_object_unref0 (other_worm);
				}
			}
			_g_object_unref0 (worm);
		}
	}
	_tmp176_ = self->priv->bonuses;
	_tmp177_ = self->priv->bouns_eaten;
	_tmp178_ = gee_collection_get_size ((GeeCollection*) _tmp177_);
	_tmp179_ = _tmp178_;
	nibbles_game_bonuses_decrement_regular_bonus (_tmp176_, _tmp179_);
	_tmp180_ = self->priv->bouns_eaten;
	gee_collection_clear ((GeeCollection*) _tmp180_);
	{
		GeeIterator* _bonus_it = NULL;
		GeeHashMap* _tmp181_;
		GeeIterator* _tmp182_;
		_tmp181_ = self->priv->_score_deltas;
		_tmp182_ = gee_iterable_iterator ((GeeIterable*) _tmp181_);
		_bonus_it = _tmp182_;
		while (TRUE) {
			GeeIterator* _tmp183_;
			GeeMapEntry* bonus = NULL;
			GeeIterator* _tmp184_;
			gpointer _tmp185_;
			gint how_many_worms_ate_the_bonus = 0;
			GeeMapEntry* _tmp186_;
			gconstpointer _tmp187_;
			gconstpointer _tmp188_;
			gint _tmp189_;
			gint _tmp190_;
			gboolean _tmp218_ = FALSE;
			GeeMapEntry* _tmp219_;
			gconstpointer _tmp220_;
			gconstpointer _tmp221_;
			BonuseType _tmp222_;
			BonuseType _tmp223_;
			gboolean real_bonus = FALSE;
			NibblesGameBonuses* _tmp229_;
			GeeMapEntry* _tmp230_;
			gconstpointer _tmp231_;
			gconstpointer _tmp232_;
			gboolean _tmp233_ = FALSE;
			_tmp183_ = _bonus_it;
			if (!gee_iterator_next (_tmp183_)) {
				break;
			}
			_tmp184_ = _bonus_it;
			_tmp185_ = gee_iterator_get (_tmp184_);
			bonus = (GeeMapEntry*) _tmp185_;
			_tmp186_ = bonus;
			_tmp187_ = gee_map_entry_get_value (_tmp186_);
			_tmp188_ = _tmp187_;
			_tmp189_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) ((GeeLinkedList*) _tmp188_));
			_tmp190_ = _tmp189_;
			how_many_worms_ate_the_bonus = _tmp190_;
			{
				GeeLinkedList* _score_delta_list = NULL;
				GeeMapEntry* _tmp191_;
				gconstpointer _tmp192_;
				gconstpointer _tmp193_;
				gint _score_delta_size = 0;
				GeeLinkedList* _tmp194_;
				gint _tmp195_;
				gint _tmp196_;
				gint _score_delta_index = 0;
				_tmp191_ = bonus;
				_tmp192_ = gee_map_entry_get_value (_tmp191_);
				_tmp193_ = _tmp192_;
				_score_delta_list = (GeeLinkedList*) _tmp193_;
				_tmp194_ = _score_delta_list;
				_tmp195_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp194_);
				_tmp196_ = _tmp195_;
				_score_delta_size = _tmp196_;
				_score_delta_index = -1;
				while (TRUE) {
					gint _tmp197_;
					gint _tmp198_;
					NibblesGameScoreDelta* score_delta = NULL;
					GeeLinkedList* _tmp199_;
					gpointer _tmp200_;
					gint delta = 0;
					NibblesGameScoreDelta* _tmp201_;
					gint _tmp202_;
					gint _tmp203_;
					NibblesGameScoreDelta* _tmp204_;
					Worm* _tmp205_;
					Worm* _tmp206_;
					NibblesGameScoreDelta* _tmp207_;
					Worm* _tmp208_;
					Worm* _tmp209_;
					gint _tmp210_;
					gint _tmp211_;
					GeeMapEntry* _tmp212_;
					gconstpointer _tmp213_;
					gconstpointer _tmp214_;
					NibblesGameScoreDelta* _tmp215_;
					Worm* _tmp216_;
					Worm* _tmp217_;
					_score_delta_index = _score_delta_index + 1;
					_tmp197_ = _score_delta_index;
					_tmp198_ = _score_delta_size;
					if (!(_tmp197_ < _tmp198_)) {
						break;
					}
					_tmp199_ = _score_delta_list;
					_tmp200_ = gee_abstract_list_get ((GeeAbstractList*) _tmp199_, _score_delta_index);
					score_delta = (NibblesGameScoreDelta*) _tmp200_;
					_tmp201_ = score_delta;
					_tmp202_ = nibbles_game_score_delta_get_score_delta (_tmp201_);
					_tmp203_ = _tmp202_;
					delta = _tmp203_ / how_many_worms_ate_the_bonus;
					_tmp204_ = score_delta;
					_tmp205_ = nibbles_game_score_delta_get_worm (_tmp204_);
					_tmp206_ = _tmp205_;
					_tmp207_ = score_delta;
					_tmp208_ = nibbles_game_score_delta_get_worm (_tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = worm_get_score (_tmp209_);
					_tmp211_ = _tmp210_;
					worm_set_score (_tmp209_, _tmp211_ + delta);
					_tmp212_ = bonus;
					_tmp213_ = gee_map_entry_get_key (_tmp212_);
					_tmp214_ = _tmp213_;
					_tmp215_ = score_delta;
					_tmp216_ = nibbles_game_score_delta_get_worm (_tmp215_);
					_tmp217_ = _tmp216_;
					g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL], 0, (Bonus*) _tmp214_, _tmp217_, delta);
					_g_object_unref0 (score_delta);
				}
			}
			_tmp219_ = bonus;
			_tmp220_ = gee_map_entry_get_key (_tmp219_);
			_tmp221_ = _tmp220_;
			_tmp222_ = bonus_get_etype ((Bonus*) _tmp221_);
			_tmp223_ = _tmp222_;
			if (_tmp223_ == BONUS_ETYPE_REGULAR) {
				GeeMapEntry* _tmp224_;
				gconstpointer _tmp225_;
				gconstpointer _tmp226_;
				gboolean _tmp227_;
				gboolean _tmp228_;
				_tmp224_ = bonus;
				_tmp225_ = gee_map_entry_get_key (_tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = bonus_get_fake ((Bonus*) _tmp226_);
				_tmp228_ = _tmp227_;
				_tmp218_ = !_tmp228_;
			} else {
				_tmp218_ = FALSE;
			}
			real_bonus = _tmp218_;
			_tmp229_ = self->priv->bonuses;
			_tmp230_ = bonus;
			_tmp231_ = gee_map_entry_get_key (_tmp230_);
			_tmp232_ = _tmp231_;
			nibbles_game_bonuses_remove_bonus (_tmp229_, (Bonus*) _tmp232_);
			if (real_bonus) {
				NibblesGameBonuses* _tmp234_;
				_tmp234_ = self->priv->bonuses;
				_tmp233_ = !nibbles_game_bonuses_last_regular_bonus (_tmp234_);
			} else {
				_tmp233_ = FALSE;
			}
			if (_tmp233_) {
				nibbles_game_add_bonus (self, TRUE);
			}
			_g_object_unref0 (bonus);
		}
		_g_object_unref0 (_bonus_it);
	}
	_tmp235_ = self->priv->_score_deltas;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp235_);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp236_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _worm_index = 0;
		_tmp236_ = dead_worms;
		_worm_list = _tmp236_;
		_tmp237_ = _worm_list;
		_tmp238_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_worm_size = _tmp239_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp240_;
			gint _tmp241_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp242_;
			gpointer _tmp243_;
			gint _tmp244_;
			Worm* _tmp249_;
			guint8 _tmp250_;
			guint8 _tmp251_;
			_worm_index = _worm_index + 1;
			_tmp240_ = _worm_index;
			_tmp241_ = _worm_size;
			if (!(_tmp240_ < _tmp241_)) {
				break;
			}
			_tmp242_ = _worm_list;
			_tmp243_ = gee_abstract_list_get ((GeeAbstractList*) _tmp242_, _worm_index);
			worm = (Worm*) _tmp243_;
			_tmp244_ = self->priv->_numworms;
			if (_tmp244_ > 1) {
				Worm* _tmp245_;
				Worm* _tmp246_;
				gint _tmp247_;
				gint _tmp248_;
				_tmp245_ = worm;
				_tmp246_ = worm;
				_tmp247_ = worm_get_score (_tmp246_);
				_tmp248_ = _tmp247_;
				worm_set_score (_tmp245_, (_tmp248_ * 7) / 10);
			}
			_tmp249_ = worm;
			_tmp250_ = worm_get_lives (_tmp249_);
			_tmp251_ = _tmp250_;
			if (((gint) _tmp251_) > 0) {
				Worm* _tmp252_;
				gint* _tmp253_;
				gint _tmp253__length1;
				gint _tmp253__length2;
				_tmp252_ = worm;
				_tmp253_ = self->board;
				_tmp253__length1 = self->board_length1;
				_tmp253__length2 = self->board_length2;
				worm_reset (_tmp252_, _tmp253_, (gint) _tmp253__length1, (gint) _tmp253__length2);
			}
			_g_object_unref0 (worm);
		}
	}
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_REDRAW_SIGNAL], 0, TRUE);
	_g_object_unref0 (dead_worms);
}

static void
nibbles_game_reverse_worms (NibblesGame* self,
                            Worm* worm)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	{
		GeeLinkedList* _other_worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _other_worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _other_worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_other_worm_list = _tmp0_;
		_tmp1_ = _other_worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_other_worm_size = _tmp3_;
		_other_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* other_worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			_other_worm_index = _other_worm_index + 1;
			_tmp4_ = _other_worm_index;
			_tmp5_ = _other_worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _other_worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _other_worm_index);
			other_worm = (Worm*) _tmp7_;
			_tmp8_ = other_worm;
			if (worm != _tmp8_) {
				Worm* _tmp9_;
				_tmp9_ = other_worm;
				worm_reverse (_tmp9_);
			}
			_g_object_unref0 (other_worm);
		}
	}
}

static gboolean
nibbles_game_is_space_empty (NibblesGame* self,
                             guint8 x,
                             guint8 y,
                             gboolean* worms_at,
                             gint worms_at_length1,
                             gint worms_at_length2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp11_ = self->board;
	_tmp11__length1 = self->board_length1;
	_tmp11__length2 = self->board_length2;
	_tmp12_ = _tmp11_[(x * _tmp11__length2) + y];
	if (((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp12_) {
		gint* _tmp13_;
		gint _tmp13__length1;
		gint _tmp13__length2;
		gint _tmp14_;
		_tmp13_ = self->board;
		_tmp13__length1 = self->board_length1;
		_tmp13__length2 = self->board_length2;
		_tmp14_ = _tmp13_[((x + 1) * _tmp13__length2) + (y + 1)];
		_tmp10_ = ((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp14_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gint* _tmp15_;
		gint _tmp15__length1;
		gint _tmp15__length2;
		gint _tmp16_;
		_tmp15_ = self->board;
		_tmp15__length1 = self->board_length1;
		_tmp15__length2 = self->board_length2;
		_tmp16_ = _tmp15_[((x + 1) * _tmp15__length2) + y];
		_tmp9_ = ((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp16_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gint* _tmp17_;
		gint _tmp17__length1;
		gint _tmp17__length2;
		gint _tmp18_;
		_tmp17_ = self->board;
		_tmp17__length1 = self->board_length1;
		_tmp17__length2 = self->board_length2;
		_tmp18_ = _tmp17_[(x * _tmp17__length2) + (y + 1)];
		_tmp8_ = ((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp18_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		NibblesGameBonuses* _tmp19_;
		Bonus* _tmp20_;
		Bonus* _tmp21_;
		_tmp19_ = self->priv->bonuses;
		_tmp20_ = nibbles_game_bonuses_get_bonus (_tmp19_, x, y);
		_tmp21_ = _tmp20_;
		_tmp7_ = _tmp21_ == NULL;
		_g_object_unref0 (_tmp21_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		NibblesGameBonuses* _tmp22_;
		Bonus* _tmp23_;
		Bonus* _tmp24_;
		_tmp22_ = self->priv->bonuses;
		_tmp23_ = nibbles_game_bonuses_get_bonus (_tmp22_, (guint8) (x + 1), (guint8) (y + 1));
		_tmp24_ = _tmp23_;
		_tmp6_ = _tmp24_ == NULL;
		_g_object_unref0 (_tmp24_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		NibblesGameBonuses* _tmp25_;
		Bonus* _tmp26_;
		Bonus* _tmp27_;
		_tmp25_ = self->priv->bonuses;
		_tmp26_ = nibbles_game_bonuses_get_bonus (_tmp25_, (guint8) (x + 1), y);
		_tmp27_ = _tmp26_;
		_tmp5_ = _tmp27_ == NULL;
		_g_object_unref0 (_tmp27_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		NibblesGameBonuses* _tmp28_;
		Bonus* _tmp29_;
		Bonus* _tmp30_;
		_tmp28_ = self->priv->bonuses;
		_tmp29_ = nibbles_game_bonuses_get_bonus (_tmp28_, x, (guint8) (y + 1));
		_tmp30_ = _tmp29_;
		_tmp4_ = _tmp30_ == NULL;
		_g_object_unref0 (_tmp30_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp31_;
		_tmp31_ = worms_at[(x * worms_at_length2) + y];
		_tmp3_ = !_tmp31_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp32_;
		_tmp32_ = worms_at[((x + 1) * worms_at_length2) + (y + 1)];
		_tmp2_ = !_tmp32_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp33_;
		_tmp33_ = worms_at[((x + 1) * worms_at_length2) + y];
		_tmp1_ = !_tmp33_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp34_;
		_tmp34_ = worms_at[(x * worms_at_length2) + (y + 1)];
		_tmp0_ = !_tmp34_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
nibbles_game_add_bonus (NibblesGame* self,
                        gboolean regular)
{
	gboolean good = FALSE;
	guint8 x = 0U;
	guint8 y = 0U;
	gboolean* worms_at = NULL;
	guint8 _tmp0_;
	guint8 _tmp1_;
	gboolean* _tmp2_;
	gint worms_at_length1;
	gint worms_at_length2;
	g_return_if_fail (self != NULL);
	good = FALSE;
	x = (guint8) 0;
	y = (guint8) 0;
	_tmp0_ = self->priv->_width;
	_tmp1_ = self->priv->_height;
	_tmp2_ = g_new0 (gboolean, _tmp0_ * _tmp1_);
	worms_at = _tmp2_;
	worms_at_length1 = _tmp0_;
	worms_at_length2 = _tmp1_;
	if (!regular) {
		if (g_random_int_range ((gint32) 0, (gint32) 50) != ((gint32) 0)) {
			worms_at = (g_free (worms_at), NULL);
			return;
		}
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp3_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _worm_index = 0;
		_tmp3_ = self->priv->_worms;
		_worm_list = _tmp3_;
		_tmp4_ = _worm_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_worm_size = _tmp6_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_;
			gpointer _tmp10_;
			Worm* _tmp11_;
			_worm_index = _worm_index + 1;
			_tmp7_ = _worm_index;
			_tmp8_ = _worm_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _worm_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _worm_index);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			if (!_tmp11_->is_stopped) {
				{
					WormPositions* _p_list = NULL;
					Worm* _tmp12_;
					WormPositions* _tmp13_;
					gint _p_size = 0;
					WormPositions* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _p_index = 0;
					_tmp12_ = worm;
					_tmp13_ = _tmp12_->list;
					_p_list = _tmp13_;
					_tmp14_ = _p_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_p_size = _tmp16_;
					_p_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						guint16 p = 0U;
						WormPositions* _tmp19_;
						gpointer _tmp20_;
						gboolean* _tmp21_;
						gint _tmp21__length1;
						gint _tmp21__length2;
						_p_index = _p_index + 1;
						_tmp17_ = _p_index;
						_tmp18_ = _p_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _p_list;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _p_index);
						p = (guint16) ((guintptr) _tmp20_);
						_tmp21_ = worms_at;
						_tmp21__length1 = worms_at_length1;
						_tmp21__length2 = worms_at_length2;
						_tmp21_[((p >> 8) * _tmp21__length2) + ((guint8) p)] = TRUE;
					}
				}
			}
			_g_object_unref0 (worm);
		}
	}
	{
		gboolean _tmp22_ = FALSE;
		_tmp22_ = TRUE;
		while (TRUE) {
			guint8 _tmp24_;
			guint8 _tmp25_;
			if (!_tmp22_) {
				gboolean* _tmp23_;
				gint _tmp23__length1;
				gint _tmp23__length2;
				_tmp23_ = worms_at;
				_tmp23__length1 = worms_at_length1;
				_tmp23__length2 = worms_at_length2;
				if (!(!nibbles_game_is_space_empty (self, x, y, _tmp23_, (gint) _tmp23__length1, (gint) _tmp23__length2))) {
					break;
				}
			}
			_tmp22_ = FALSE;
			_tmp24_ = self->priv->_width;
			x = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp24_ - 1));
			_tmp25_ = self->priv->_height;
			y = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp25_ - 1));
		}
	}
	if (regular) {
		gboolean _tmp26_ = FALSE;
		if (g_random_int_range ((gint32) 0, (gint32) 7) == ((gint32) 0)) {
			gboolean _tmp27_;
			_tmp27_ = self->priv->_fakes;
			_tmp26_ = _tmp27_;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			_nibbles_game_add_bonus (self, x, y, BONUS_ETYPE_REGULAR, TRUE, (guint16) 300);
		}
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				guint8 _tmp30_;
				guint8 _tmp31_;
				if (!_tmp28_) {
					gboolean* _tmp29_;
					gint _tmp29__length1;
					gint _tmp29__length2;
					_tmp29_ = worms_at;
					_tmp29__length1 = worms_at_length1;
					_tmp29__length2 = worms_at_length2;
					if (!(!nibbles_game_is_space_empty (self, x, y, _tmp29_, (gint) _tmp29__length1, (gint) _tmp29__length2))) {
						break;
					}
				}
				_tmp28_ = FALSE;
				_tmp30_ = self->priv->_width;
				x = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp30_ - 1));
				_tmp31_ = self->priv->_height;
				y = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp31_ - 1));
			}
		}
		_nibbles_game_add_bonus (self, x, y, BONUS_ETYPE_REGULAR, FALSE, (guint16) 300);
	} else {
		NibblesGameBonuses* _tmp32_;
		_tmp32_ = self->priv->bonuses;
		if (!nibbles_game_bonuses_too_many_missed (_tmp32_)) {
			gboolean _tmp33_ = FALSE;
			if (g_random_int_range ((gint32) 0, (gint32) 7) != ((gint32) 0)) {
				good = FALSE;
			} else {
				good = TRUE;
			}
			if (good) {
				gboolean _tmp34_;
				_tmp34_ = self->priv->_fakes;
				_tmp33_ = !_tmp34_;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				worms_at = (g_free (worms_at), NULL);
				return;
			}
			switch (g_random_int_range ((gint32) 0, (gint32) 21)) {
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
				{
					_nibbles_game_add_bonus (self, x, y, BONUS_ETYPE_HALF, good, (guint16) 200);
					break;
				}
				case 10:
				case 11:
				case 12:
				case 13:
				case 14:
				{
					_nibbles_game_add_bonus (self, x, y, BONUS_ETYPE_DOUBLE, good, (guint16) 150);
					break;
				}
				case 15:
				{
					_nibbles_game_add_bonus (self, x, y, BONUS_ETYPE_LIFE, good, (guint16) 100);
					break;
				}
				case 16:
				case 17:
				case 18:
				case 19:
				case 20:
				{
					gint _tmp35_;
					_tmp35_ = self->priv->_numworms;
					if (_tmp35_ > 1) {
						_nibbles_game_add_bonus (self, x, y, BONUS_ETYPE_REVERSE, good, (guint16) 150);
					}
					break;
				}
				default:
				break;
			}
		}
	}
	worms_at = (g_free (worms_at), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static inline void
_nibbles_game_add_bonus (NibblesGame* self,
                         guint8 x,
                         guint8 y,
                         BonuseType bonus_type,
                         gboolean fake,
                         guint16 countdown)
{
	Bonus* bonus = NULL;
	Bonus* _tmp0_;
	NibblesGameBonuses* _tmp1_;
	Bonus* _tmp2_;
	Bonus* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bonus_new (x, y, (GType) bonus_type, fake, countdown);
	bonus = _tmp0_;
	_tmp1_ = self->priv->bonuses;
	_tmp2_ = bonus;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	if (nibbles_game_bonuses_add_bonus (_tmp1_, _tmp3_)) {
		Bonus* _tmp4_;
		BonuseType _tmp5_;
		BonuseType _tmp6_;
		_tmp4_ = bonus;
		_tmp5_ = bonus_get_etype (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != BONUS_ETYPE_REGULAR) {
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "appear");
		}
	}
	_g_object_unref0 (bonus);
}

static gint
nibbles_game_calculate_bonus (NibblesGame* self,
                              Bonus* bonus,
                              Worm* worm)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (bonus != NULL, 0);
	g_return_val_if_fail (worm != NULL, 0);
	_tmp0_ = bonus_get_fake (bonus);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		worm_reverse (worm);
		result = 0;
		return result;
	} else {
		gint score_delta = 0;
		BonuseType _tmp2_;
		BonuseType _tmp3_;
		score_delta = 0;
		_tmp2_ = bonus_get_etype (bonus);
		_tmp3_ = _tmp2_;
		switch (_tmp3_) {
			case BONUS_ETYPE_REGULAR:
			{
				guint8 nth_bonus = 0U;
				NibblesGameBonuses* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GeeSet* _tmp8_;
				_tmp4_ = self->priv->bonuses;
				nth_bonus = nibbles_game_bonuses_new_regular_bonus_eaten (_tmp4_);
				_tmp5_ = worm_get_change (worm);
				_tmp6_ = _tmp5_;
				worm_set_change (worm, _tmp6_ + (((gint) nth_bonus) * WORM_GROW_FACTOR));
				_tmp7_ = self->priv->_current_level;
				score_delta = ((gint) nth_bonus) * _tmp7_;
				_tmp8_ = self->priv->bouns_eaten;
				gee_collection_add ((GeeCollection*) _tmp8_, bonus);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "gobble");
				break;
			}
			case BONUS_ETYPE_DOUBLE:
			{
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				_tmp9_ = worm_get_length (worm);
				_tmp10_ = _tmp9_;
				_tmp11_ = worm_get_change (worm);
				_tmp12_ = _tmp11_;
				_tmp13_ = self->priv->_current_level;
				score_delta = (_tmp10_ + _tmp12_) * _tmp13_;
				_tmp14_ = worm_get_change (worm);
				_tmp15_ = _tmp14_;
				_tmp16_ = worm_get_length (worm);
				_tmp17_ = _tmp16_;
				_tmp18_ = worm_get_change (worm);
				_tmp19_ = _tmp18_;
				worm_set_change (worm, _tmp15_ + (_tmp17_ + _tmp19_));
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "bonus");
				break;
			}
			case BONUS_ETYPE_HALF:
			{
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				_tmp20_ = worm_get_length (worm);
				_tmp21_ = _tmp20_;
				_tmp22_ = worm_get_change (worm);
				_tmp23_ = _tmp22_;
				if ((_tmp21_ + _tmp23_) > 2) {
					gint _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					_tmp24_ = worm_get_length (worm);
					_tmp25_ = _tmp24_;
					_tmp26_ = worm_get_change (worm);
					_tmp27_ = _tmp26_;
					_tmp28_ = self->priv->_current_level;
					score_delta = (_tmp25_ + (_tmp27_ / 2)) * _tmp28_;
					_tmp29_ = worm_get_length (worm);
					_tmp30_ = _tmp29_;
					worm_reduce_tail (worm, _tmp30_ / 2);
					_tmp31_ = worm_get_change (worm);
					_tmp32_ = _tmp31_;
					_tmp33_ = worm_get_length (worm);
					_tmp34_ = _tmp33_;
					_tmp35_ = worm_get_change (worm);
					_tmp36_ = _tmp35_;
					worm_set_change (worm, _tmp32_ - ((_tmp34_ + _tmp36_) / 2));
				}
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "bonus");
				break;
			}
			case BONUS_ETYPE_LIFE:
			{
				worm_add_life (worm);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "life");
				break;
			}
			case BONUS_ETYPE_REVERSE:
			{
				nibbles_game_reverse_worms (self, worm);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "reverse");
				break;
			}
			case BONUS_ETYPE_WARP:
			{
				break;
			}
			default:
			break;
		}
		result = score_delta;
		return result;
	}
}

static void
nibbles_game_bonus_found_cb (NibblesGame* self,
                             Worm* worm)
{
	Bonus* bonus = NULL;
	NibblesGameBonuses* _tmp0_;
	Position _tmp1_ = {0};
	Position _tmp2_;
	Position _tmp3_ = {0};
	Position _tmp4_;
	Bonus* _tmp5_;
	Bonus* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->bonuses;
	worm_get_head (worm, &_tmp1_);
	_tmp2_ = _tmp1_;
	worm_get_head (worm, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = nibbles_game_bonuses_get_bonus (_tmp0_, _tmp2_.x, _tmp4_.y);
	bonus = _tmp5_;
	_tmp6_ = bonus;
	if (_tmp6_ != NULL) {
		Position _tmp7_ = {0};
		Position _tmp8_;
		Position _tmp9_ = {0};
		Position _tmp10_;
		NibblesGameScoreDelta* score_delta = NULL;
		Bonus* _tmp11_;
		NibblesGameScoreDelta* _tmp12_;
		GeeLinkedList* delta = NULL;
		GeeHashMap* _tmp13_;
		Bonus* _tmp14_;
		gpointer _tmp15_;
		GeeLinkedList* _tmp16_;
		GeeLinkedList* _tmp21_;
		NibblesGameScoreDelta* _tmp22_;
		worm_get_head (worm, &_tmp7_);
		_tmp8_ = _tmp7_;
		worm_get_head (worm, &_tmp9_);
		_tmp10_ = _tmp9_;
		worm_add_bonus_eaten_position (worm, _tmp8_.x, _tmp10_.y);
		_tmp11_ = bonus;
		_tmp12_ = nibbles_game_score_delta_new (worm, nibbles_game_calculate_bonus (self, _tmp11_, worm));
		score_delta = _tmp12_;
		_tmp13_ = self->priv->_score_deltas;
		_tmp14_ = bonus;
		_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
		delta = (GeeLinkedList*) _tmp15_;
		_tmp16_ = delta;
		if (_tmp16_ == NULL) {
			GeeLinkedList* _tmp17_;
			GeeHashMap* _tmp18_;
			Bonus* _tmp19_;
			GeeLinkedList* _tmp20_;
			_tmp17_ = gee_linked_list_new (NIBBLES_GAME_TYPE_SCORE_DELTA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			_g_object_unref0 (delta);
			delta = _tmp17_;
			_tmp18_ = self->priv->_score_deltas;
			_tmp19_ = bonus;
			_tmp20_ = delta;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp19_, _tmp20_);
		}
		_tmp21_ = delta;
		_tmp22_ = score_delta;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
		_g_object_unref0 (delta);
		_g_object_unref0 (score_delta);
	}
	_g_object_unref0 (bonus);
}

static NibblesGameeStatus*
_nibbles_game_estatus_dup (NibblesGameeStatus* self)
{
	NibblesGameeStatus* dup;
	dup = g_new0 (NibblesGameeStatus, 1);
	memcpy (dup, self, sizeof (NibblesGameeStatus));
	return dup;
}

static gpointer
__nibbles_game_estatus_dup0 (gpointer self)
{
	return self ? _nibbles_game_estatus_dup (self) : NULL;
}

NibblesGameeStatus*
nibbles_game_get_game_status (NibblesGame* self)
{
	gint worms_left = 0;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	NibblesGameeStatus* result;
	g_return_val_if_fail (self != NULL, NULL);
	worms_left = 0;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			guint8 _tmp9_;
			guint8 _tmp10_;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp8_ = worm;
			_tmp9_ = worm_get_lives (_tmp8_);
			_tmp10_ = _tmp9_;
			if (((gint) _tmp10_) > 0) {
				worms_left += 1;
			} else {
				gboolean _tmp11_ = FALSE;
				gint _tmp12_;
				_tmp12_ = self->priv->_numhumans;
				if (_tmp12_ == 0) {
					Worm* _tmp13_;
					guint8 _tmp14_;
					guint8 _tmp15_;
					_tmp13_ = worm;
					_tmp14_ = worm_get_lives (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp11_ = ((gint) _tmp15_) == 0;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					NibblesGameeStatus _tmp16_;
					NibblesGameeStatus* _tmp17_;
					_tmp16_ = NIBBLES_GAME_ESTATUS_GAMEOVER;
					_tmp17_ = __nibbles_game_estatus_dup0 (&_tmp16_);
					result = _tmp17_;
					_g_object_unref0 (worm);
					return result;
				}
			}
			_g_object_unref0 (worm);
		}
	}
	if (worms_left == 1) {
		gint _tmp20_;
		_tmp20_ = self->priv->_numworms;
		_tmp19_ = _tmp20_ > 1;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		if (nibbles_game_humans_left (self) == ((guint) 1)) {
			gint _tmp22_;
			_tmp22_ = self->priv->_numhumans;
			_tmp21_ = _tmp22_ > 1;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp18_ = _tmp21_;
	}
	if (_tmp18_) {
		NibblesGameeStatus _tmp23_;
		NibblesGameeStatus* _tmp24_;
		_tmp23_ = NIBBLES_GAME_ESTATUS_VICTORY;
		_tmp24_ = __nibbles_game_estatus_dup0 (&_tmp23_);
		result = _tmp24_;
		return result;
	} else {
		gboolean _tmp25_ = FALSE;
		if (worms_left == 0) {
			_tmp25_ = TRUE;
		} else {
			gboolean _tmp26_ = FALSE;
			if (nibbles_game_humans_left (self) == ((guint) 0)) {
				gint _tmp27_;
				_tmp27_ = self->priv->_numhumans;
				_tmp26_ = _tmp27_ >= 1;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp25_ = _tmp26_;
		}
		if (_tmp25_) {
			NibblesGameeStatus _tmp28_;
			NibblesGameeStatus* _tmp29_;
			_tmp28_ = NIBBLES_GAME_ESTATUS_GAMEOVER;
			_tmp29_ = __nibbles_game_estatus_dup0 (&_tmp28_);
			result = _tmp29_;
			return result;
		} else {
			NibblesGameBonuses* _tmp30_;
			_tmp30_ = self->priv->bonuses;
			if (nibbles_game_bonuses_last_regular_bonus (_tmp30_)) {
				NibblesGameeStatus _tmp31_;
				NibblesGameeStatus* _tmp32_;
				_tmp31_ = NIBBLES_GAME_ESTATUS_NEWROUND;
				_tmp32_ = __nibbles_game_estatus_dup0 (&_tmp31_);
				result = _tmp32_;
				return result;
			} else {
				result = NULL;
				return result;
			}
		}
	}
}

guint
nibbles_game_humans_left (NibblesGame* self)
{
	guint count = 0U;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	count = (guint) 0;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			Worm* _tmp9_;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp9_ = worm;
			if (_tmp9_->is_human) {
				Worm* _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				_tmp10_ = worm;
				_tmp11_ = worm_get_lives (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp8_ = ((gint) _tmp12_) > 0;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				guint _tmp13_;
				count = count + 1;
				_tmp13_ = count;
			}
			_g_object_unref0 (worm);
		}
	}
	result = count;
	return result;
}

static gboolean
__lambda7_ (GValue* value,
            GVariant* variant,
            void* data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_int (value, nibbles_game_get_color_num (_tmp0_));
	result = TRUE;
	return result;
}

static gboolean
___lambda7___localfunc0_ (GValue* value,
                          GVariant* variant,
                          void* data)
{
	gboolean result;
	result = __lambda7_ (value, variant, data);
	return result;
}

static GVariant*
__lambda8_ (GValue* value,
            const GVariantType* type,
            void* data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = nibbles_game_get_color_string (g_value_get_int (value));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GVariant*
___lambda8___localfunc1_ (GValue* value,
                          const GVariantType* type,
                          void* data)
{
	GVariant* result;
	result = __lambda8_ (value, type, data);
	return result;
}

void
nibbles_game_load_worm_properties (NibblesGame* self,
                                   GeeArrayList* worm_settings)
{
	_LocalFunc0_ GetMappingFunction = NULL;
	_LocalFunc1_ SetMappingFunction = NULL;
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm_settings != NULL);
	GetMappingFunction = ___lambda7___localfunc0_;
	SetMappingFunction = ___lambda8___localfunc1_;
	_tmp0_ = self->priv->_worm_props;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			WormProperties* properties = NULL;
			WormProperties* _tmp9_;
			Worm* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			GSettings* _tmp14_;
			WormProperties* _tmp15_;
			_LocalFunc0_ _tmp16_;
			_LocalFunc1_ _tmp17_;
			Worm* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			GSettings* _tmp22_;
			WormProperties* _tmp23_;
			Worm* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			GSettings* _tmp28_;
			WormProperties* _tmp29_;
			Worm* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			GSettings* _tmp34_;
			WormProperties* _tmp35_;
			Worm* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			GSettings* _tmp40_;
			WormProperties* _tmp41_;
			Worm* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_;
			GSettings* _tmp46_;
			WormProperties* _tmp47_;
			Worm* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gpointer _tmp51_;
			GSettings* _tmp52_;
			WormProperties* _tmp53_;
			Worm* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gpointer _tmp57_;
			GSettings* _tmp58_;
			WormProperties* _tmp59_;
			Worm* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gpointer _tmp63_;
			GSettings* _tmp64_;
			WormProperties* _tmp65_;
			GeeHashMap* _tmp66_;
			Worm* _tmp67_;
			WormProperties* _tmp68_;
			_worm_index = _worm_index + 1;
			_tmp5_ = _worm_index;
			_tmp6_ = _worm_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _worm_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _worm_index);
			worm = (Worm*) _tmp8_;
			_tmp9_ = worm_properties_new ();
			properties = _tmp9_;
			_tmp10_ = worm;
			_tmp11_ = worm_get_id (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp12_);
			_tmp14_ = (GSettings*) _tmp13_;
			_tmp15_ = properties;
			_tmp16_ = GetMappingFunction;
			_tmp17_ = SetMappingFunction;
			g_settings_bind_with_mapping (_tmp14_, "color", (GObject*) _tmp15_, "color", G_SETTINGS_BIND_DEFAULT, _tmp16_, _tmp17_, NULL, NULL);
			_g_object_unref0 (_tmp14_);
			_tmp18_ = worm;
			_tmp19_ = worm_get_id (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp20_);
			_tmp22_ = (GSettings*) _tmp21_;
			_tmp23_ = properties;
			g_settings_bind (_tmp22_, "key-up", (GObject*) _tmp23_, "up", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp22_);
			_tmp24_ = worm;
			_tmp25_ = worm_get_id (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp26_);
			_tmp28_ = (GSettings*) _tmp27_;
			_tmp29_ = properties;
			g_settings_bind (_tmp28_, "key-down", (GObject*) _tmp29_, "down", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp28_);
			_tmp30_ = worm;
			_tmp31_ = worm_get_id (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp32_);
			_tmp34_ = (GSettings*) _tmp33_;
			_tmp35_ = properties;
			g_settings_bind (_tmp34_, "key-left", (GObject*) _tmp35_, "left", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp34_);
			_tmp36_ = worm;
			_tmp37_ = worm_get_id (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp38_);
			_tmp40_ = (GSettings*) _tmp39_;
			_tmp41_ = properties;
			g_settings_bind (_tmp40_, "key-right", (GObject*) _tmp41_, "right", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp40_);
			_tmp42_ = worm;
			_tmp43_ = worm_get_id (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp44_);
			_tmp46_ = (GSettings*) _tmp45_;
			_tmp47_ = properties;
			g_settings_bind (_tmp46_, "key-up-raw", (GObject*) _tmp47_, "raw-up", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp46_);
			_tmp48_ = worm;
			_tmp49_ = worm_get_id (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp50_);
			_tmp52_ = (GSettings*) _tmp51_;
			_tmp53_ = properties;
			g_settings_bind (_tmp52_, "key-down-raw", (GObject*) _tmp53_, "raw-down", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp52_);
			_tmp54_ = worm;
			_tmp55_ = worm_get_id (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp56_);
			_tmp58_ = (GSettings*) _tmp57_;
			_tmp59_ = properties;
			g_settings_bind (_tmp58_, "key-left-raw", (GObject*) _tmp59_, "raw-left", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp58_);
			_tmp60_ = worm;
			_tmp61_ = worm_get_id (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp62_);
			_tmp64_ = (GSettings*) _tmp63_;
			_tmp65_ = properties;
			g_settings_bind (_tmp64_, "key-right-raw", (GObject*) _tmp65_, "raw-right", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp64_);
			_tmp66_ = self->priv->_worm_props;
			_tmp67_ = worm;
			_tmp68_ = properties;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp66_, _tmp67_, _tmp68_);
			_g_object_unref0 (properties);
			_g_object_unref0 (worm);
		}
	}
}

static inline gchar*
nibbles_game_get_color_string (gint color)
{
	gchar* result;
	switch (color) {
		case 0:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("red");
			result = _tmp0_;
			return result;
		}
		case 1:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("green");
			result = _tmp1_;
			return result;
		}
		case 2:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("blue");
			result = _tmp2_;
			return result;
		}
		case 3:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("yellow");
			result = _tmp3_;
			return result;
		}
		case 4:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("cyan");
			result = _tmp4_;
			return result;
		}
		case 5:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("purple");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static inline gint
nibbles_game_get_color_num (const gchar* color)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	gint result;
	g_return_val_if_fail (color != NULL, 0);
	_tmp0_ = color;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("red")))) {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("green")))) {
		switch (0) {
			default:
			{
				result = 1;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("blue")))) {
		switch (0) {
			default:
			{
				result = 2;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("yellow")))) {
		switch (0) {
			default:
			{
				result = 3;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("cyan")))) {
		switch (0) {
			default:
			{
				result = 4;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("purple")))) {
		switch (0) {
			default:
			{
				result = 5;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

gboolean
nibbles_game_keypress (NibblesGame* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_remove_handler = FALSE;
	result = nibbles_game_handle_keypress (self, keyval, keycode);
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

gboolean
nibbles_game_handle_keypress (NibblesGame* self,
                              guint keyval,
                              guint keycode)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_running;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			Worm* _tmp9_;
			_worm_index = _worm_index + 1;
			_tmp5_ = _worm_index;
			_tmp6_ = _worm_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _worm_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _worm_index);
			worm = (Worm*) _tmp8_;
			_tmp9_ = worm;
			if (_tmp9_->is_human) {
				Worm* _tmp10_;
				GeeHashMap* _tmp11_;
				_tmp10_ = worm;
				_tmp11_ = self->priv->_worm_props;
				if (worm_handle_keypress (_tmp10_, keycode, _tmp11_)) {
					result = TRUE;
					_g_object_unref0 (worm);
					return result;
				}
			}
			_g_object_unref0 (worm);
		}
	}
	result = FALSE;
	return result;
}

static GeeList*
nibbles_game_get_other_worms (NibblesGame* self,
                              Worm* _self_)
{
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_self_ != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			Worm* _tmp9_;
			_worm_index = _worm_index + 1;
			_tmp5_ = _worm_index;
			_tmp6_ = _worm_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _worm_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _worm_index);
			worm = (Worm*) _tmp8_;
			_tmp9_ = worm;
			if (_tmp9_ != _self_) {
				GeeArrayList* _tmp10_;
				Worm* _tmp11_;
				_tmp10_ = _result_;
				_tmp11_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
			_g_object_unref0 (worm);
		}
	}
	result = (GeeList*) _result_;
	return result;
}

GeeList*
nibbles_game_get_bonuses (NibblesGame* self)
{
	NibblesGameBonuses* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bonuses;
	_tmp1_ = nibbles_game_bonuses_get_bonuses (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
nibbles_game_get_skip_score (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_skip_score;
	return result;
}

void
nibbles_game_set_skip_score (NibblesGame* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_skip_score (self);
	if (old_value != value) {
		self->priv->_skip_score = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_SKIP_SCORE_PROPERTY]);
	}
}

gint
nibbles_game_get_current_level (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_level;
	return result;
}

void
nibbles_game_set_current_level (NibblesGame* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_current_level (self);
	if (old_value != value) {
		self->priv->_current_level = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY]);
	}
}

gboolean
nibbles_game_get_three_dimensional_view (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_three_dimensional_view;
	return result;
}

void
nibbles_game_set_three_dimensional_view (NibblesGame* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_three_dimensional_view (self);
	if (old_value != value) {
		self->priv->_three_dimensional_view = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY]);
	}
}

gint
nibbles_game_get_speed (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_speed;
	return result;
}

void
nibbles_game_set_speed (NibblesGame* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_speed (self);
	if (old_value != value) {
		self->priv->_speed = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY]);
	}
}

gint
nibbles_game_get_gamedelay (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_gamedelay;
	return result;
}

static void
nibbles_game_set_gamedelay (NibblesGame* self,
                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_gamedelay (self);
	if (old_value != value) {
		self->priv->_gamedelay = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_GAMEDELAY_PROPERTY]);
	}
}

gint
nibbles_game_get_progress (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->_progress;
	return result;
}

void
nibbles_game_set_progress (NibblesGame* self,
                           gint value)
{
	NibblesGameBonuses* _tmp0_;
	g_return_if_fail (self != NULL);
	self->_progress = value;
	_tmp0_ = self->priv->bonuses;
	if (_tmp0_ != NULL) {
		NibblesGameBonuses* _tmp1_;
		_tmp1_ = self->priv->bonuses;
		_tmp1_->progress = self->_progress;
	}
	g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_PROGRESS_PROPERTY]);
}

gint
nibbles_game_get_start_level (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start_level;
	return result;
}

void
nibbles_game_set_start_level (NibblesGame* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_start_level (self);
	if (old_value != value) {
		self->priv->_start_level = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_START_LEVEL_PROPERTY]);
	}
}

guint8
nibbles_game_get_width (NibblesGame* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_width;
	return result;
}

static void
nibbles_game_set_width (NibblesGame* self,
                        guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WIDTH_PROPERTY]);
	}
}

guint8
nibbles_game_get_height (NibblesGame* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_height;
	return result;
}

static void
nibbles_game_set_height (NibblesGame* self,
                         guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_height (self);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_HEIGHT_PROPERTY]);
	}
}

gint
nibbles_game_get_numhumans (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_numhumans;
	return result;
}

void
nibbles_game_set_numhumans (NibblesGame* self,
                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_numhumans (self);
	if (old_value != value) {
		self->priv->_numhumans = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY]);
	}
}

gint
nibbles_game_get_numai (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_numai;
	return result;
}

void
nibbles_game_set_numai (NibblesGame* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_numai (self);
	if (old_value != value) {
		self->priv->_numai = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY]);
	}
}

gint
nibbles_game_get_numworms (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_numworms;
	return result;
}

static void
nibbles_game_set_numworms (NibblesGame* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_numworms (self);
	if (old_value != value) {
		self->priv->_numworms = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY]);
	}
}

GeeLinkedList*
nibbles_game_get_worms (NibblesGame* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worms;
	result = _tmp0_;
	return result;
}

GeeHashMap*
nibbles_game_get_worm_props (NibblesGame* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worm_props;
	result = _tmp0_;
	return result;
}

static GeeHashMap*
nibbles_game_get_score_deltas (NibblesGame* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_score_deltas;
	result = _tmp0_;
	return result;
}

gboolean
nibbles_game_get_is_running (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_running;
	return result;
}

static void
nibbles_game_set_is_running (NibblesGame* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_is_running (self);
	if (old_value != value) {
		self->priv->_is_running = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY]);
	}
}

static gboolean
nibbles_game_get_is_paused (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_paused;
	return result;
}

static void
nibbles_game_set_is_paused (NibblesGame* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_paused = value;
}

gboolean
nibbles_game_get_paused (NibblesGame* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_paused;
	result = _tmp0_;
	return result;
}

void
nibbles_game_set_paused (NibblesGame* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_paused (self, value);
	if (value) {
		nibbles_game_stop (self);
	} else {
		nibbles_game_start (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_PAUSED_PROPERTY]);
}

gboolean
nibbles_game_get_fakes (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fakes;
	return result;
}

void
nibbles_game_set_fakes (NibblesGame* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_fakes (self);
	if (old_value != value) {
		self->priv->_fakes = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__UCHAR_UCHAR (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UCHAR_UCHAR) (gpointer data1, guint8 arg_1, guint8 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UCHAR_UCHAR callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UCHAR_UCHAR) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uchar (param_values + 1), g_value_get_uchar (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_STRING__VOID (GClosure * closure,
                                      GValue * return_value,
                                      guint n_param_values,
                                      const GValue * param_values,
                                      gpointer invocation_hint,
                                      gpointer marshal_data)
{
	typedef const char* (*GMarshalFunc_STRING__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_STRING__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	const char* v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_STRING__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_take_string (return_value, v_return);
}

static void
g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}

static inline gpointer
nibbles_game_bonuses_get_instance_private (NibblesGameBonuses* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesGameBonuses_private_offset);
}

static gboolean
nibbles_game_bonuses_add_bonus (NibblesGameBonuses* self,
                                Bonus* bonus)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bonus != NULL, FALSE);
	if (self->progress != 2) {
		_tmp0_ = self->priv->total_bonus_number >= NIBBLES_GAME_BONUSES_MAX_BONUSES;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		_g_object_unref0 (bonus);
		return result;
	} else {
		GeeLinkedList* _tmp1_;
		guint8 _tmp2_;
		_tmp1_ = self->priv->bonuses;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, bonus);
		_tmp2_ = self->priv->total_bonus_number;
		self->priv->total_bonus_number = _tmp2_ + 1;
		result = TRUE;
		_g_object_unref0 (bonus);
		return result;
	}
}

static void
nibbles_game_bonuses_remove_bonus (NibblesGameBonuses* self,
                                   Bonus* bonus)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	g_signal_emit (self, nibbles_game_bonuses_signals[NIBBLES_GAME_BONUSES_BONUS_REMOVED_SIGNAL], 0, bonus);
	_tmp0_ = self->priv->bonuses;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, bonus);
}

static void
nibbles_game_bonuses_reset (NibblesGameBonuses* self,
                            guint8 regular_bonus)
{
	GeeLinkedList* _tmp0_;
	guint8 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bonuses;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	nibbles_game_bonuses_reset_missed (self);
	if (regular_bonus < NIBBLES_GAME_BONUSES_MAX_BONUSES) {
		_tmp1_ = regular_bonus;
	} else {
		_tmp1_ = NIBBLES_GAME_BONUSES_MAX_BONUSES;
	}
	self->priv->regular_bonus_maxi = _tmp1_;
	self->priv->regular_bonus_left = self->priv->regular_bonus_maxi;
	self->priv->total_bonus_number = (guint8) 0;
}

static Bonus*
nibbles_game_bonuses_get_bonus (NibblesGameBonuses* self,
                                guint8 x,
                                guint8 y)
{
	Bonus* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _bonus_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _bonus_index = 0;
		_tmp0_ = self->priv->bonuses;
		_bonus_list = _tmp0_;
		_tmp1_ = _bonus_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_bonus_size = _tmp3_;
		_bonus_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			Bonus* _tmp12_;
			guint8 _tmp13_;
			guint8 _tmp14_;
			_bonus_index = _bonus_index + 1;
			_tmp4_ = _bonus_index;
			_tmp5_ = _bonus_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _bonus_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _bonus_index);
			bonus = (Bonus*) _tmp7_;
			_tmp12_ = bonus;
			_tmp13_ = bonus_get_x (_tmp12_);
			_tmp14_ = _tmp13_;
			if (((gint) x) == (_tmp14_ + 0)) {
				Bonus* _tmp15_;
				guint8 _tmp16_;
				guint8 _tmp17_;
				_tmp15_ = bonus;
				_tmp16_ = bonus_get_y (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = ((gint) y) == (_tmp17_ + 0);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				gboolean _tmp18_ = FALSE;
				Bonus* _tmp19_;
				guint8 _tmp20_;
				guint8 _tmp21_;
				_tmp19_ = bonus;
				_tmp20_ = bonus_get_x (_tmp19_);
				_tmp21_ = _tmp20_;
				if (((gint) x) == (_tmp21_ + 1)) {
					Bonus* _tmp22_;
					guint8 _tmp23_;
					guint8 _tmp24_;
					_tmp22_ = bonus;
					_tmp23_ = bonus_get_y (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp18_ = ((gint) y) == (_tmp24_ + 0);
				} else {
					_tmp18_ = FALSE;
				}
				_tmp10_ = _tmp18_;
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				gboolean _tmp25_ = FALSE;
				Bonus* _tmp26_;
				guint8 _tmp27_;
				guint8 _tmp28_;
				_tmp26_ = bonus;
				_tmp27_ = bonus_get_x (_tmp26_);
				_tmp28_ = _tmp27_;
				if (((gint) x) == (_tmp28_ + 0)) {
					Bonus* _tmp29_;
					guint8 _tmp30_;
					guint8 _tmp31_;
					_tmp29_ = bonus;
					_tmp30_ = bonus_get_y (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp25_ = ((gint) y) == (_tmp31_ + 1);
				} else {
					_tmp25_ = FALSE;
				}
				_tmp9_ = _tmp25_;
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				gboolean _tmp32_ = FALSE;
				Bonus* _tmp33_;
				guint8 _tmp34_;
				guint8 _tmp35_;
				_tmp33_ = bonus;
				_tmp34_ = bonus_get_x (_tmp33_);
				_tmp35_ = _tmp34_;
				if (((gint) x) == (_tmp35_ + 1)) {
					Bonus* _tmp36_;
					guint8 _tmp37_;
					guint8 _tmp38_;
					_tmp36_ = bonus;
					_tmp37_ = bonus_get_y (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp32_ = ((gint) y) == (_tmp38_ + 1);
				} else {
					_tmp32_ = FALSE;
				}
				_tmp8_ = _tmp32_;
			}
			if (_tmp8_) {
				result = bonus;
				return result;
			}
			_g_object_unref0 (bonus);
		}
	}
	result = NULL;
	return result;
}

static GeeList*
nibbles_game_bonuses_get_bonuses (NibblesGameBonuses* self)
{
	GeeLinkedList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bonuses;
	_tmp1_ = _g_object_ref0 ((GeeList*) _tmp0_);
	result = _tmp1_;
	return result;
}

static void
nibbles_game_bonuses_on_worms_move (NibblesGameBonuses* self,
                                    guint8* missed_bonuses_to_replace)
{
	guint8 _vala_missed_bonuses_to_replace = 0U;
	g_return_if_fail (self != NULL);
	_vala_missed_bonuses_to_replace = (guint8) 0;
	{
		gint i = 0;
		GeeLinkedList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->bonuses;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				Bonus* bonus = NULL;
				GeeLinkedList* _tmp5_;
				gpointer _tmp6_;
				Bonus* _tmp7_;
				guint16 _tmp8_;
				guint16 _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (!(i > 0)) {
					break;
				}
				_tmp5_ = self->priv->bonuses;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i - 1);
				bonus = (Bonus*) _tmp6_;
				_tmp7_ = bonus;
				_tmp8_ = bonus_get_countdown (_tmp7_);
				_tmp9_ = _tmp8_;
				if (((gint) _tmp9_) > 0) {
					Bonus* _tmp10_;
					guint16 _tmp11_;
					guint16 _tmp12_;
					_tmp10_ = bonus;
					_tmp11_ = bonus_get_countdown (_tmp10_);
					_tmp12_ = _tmp11_;
					bonus_set_countdown (_tmp10_, _tmp12_ - 1);
				} else {
					Bonus* _tmp13_;
					gboolean _tmp14_ = FALSE;
					Bonus* _tmp15_;
					BonuseType _tmp16_;
					BonuseType _tmp17_;
					_tmp13_ = bonus;
					nibbles_game_bonuses_remove_bonus (self, _tmp13_);
					_tmp15_ = bonus;
					_tmp16_ = bonus_get_etype (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_ == BONUS_ETYPE_REGULAR) {
						Bonus* _tmp18_;
						gboolean _tmp19_;
						gboolean _tmp20_;
						_tmp18_ = bonus;
						_tmp19_ = bonus_get_fake (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp14_ = !_tmp20_;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						guint8 _tmp21_;
						nibbles_game_bonuses_increase_missed (self);
						_tmp21_ = _vala_missed_bonuses_to_replace;
						_vala_missed_bonuses_to_replace = _tmp21_ + 1;
					}
				}
				_g_object_unref0 (bonus);
			}
		}
	}
	if (missed_bonuses_to_replace) {
		*missed_bonuses_to_replace = _vala_missed_bonuses_to_replace;
	}
}

static guint8
nibbles_game_bonuses_new_regular_bonus_eaten (NibblesGameBonuses* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	nibbles_game_bonuses_reset_missed (self);
	if (((gint) self->priv->regular_bonus_left) > 0) {
		result = (guint8) (self->priv->regular_bonus_maxi - (self->priv->regular_bonus_left - 1));
		return result;
	} else {
		result = self->priv->regular_bonus_maxi - self->priv->regular_bonus_left;
		return result;
	}
}

static void
nibbles_game_bonuses_decrement_regular_bonus (NibblesGameBonuses* self,
                                              gint d)
{
	g_return_if_fail (self != NULL);
	if (((gint) self->priv->regular_bonus_left) > d) {
		self->priv->regular_bonus_left = self->priv->regular_bonus_left - ((guint8) d);
	} else {
		self->priv->regular_bonus_left = (guint8) 0;
	}
}

static inline gboolean
nibbles_game_bonuses_last_regular_bonus (NibblesGameBonuses* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->progress != 2) {
		_tmp0_ = ((gint) self->priv->regular_bonus_left) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static inline gboolean
nibbles_game_bonuses_too_many_missed (NibblesGameBonuses* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->missed > NIBBLES_GAME_BONUSES_MAX_MISSED;
	return result;
}

static inline void
nibbles_game_bonuses_increase_missed (NibblesGameBonuses* self)
{
	guint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->missed;
	self->priv->missed = _tmp0_ + 1;
}

static inline void
nibbles_game_bonuses_reset_missed (NibblesGameBonuses* self)
{
	g_return_if_fail (self != NULL);
	self->priv->missed = (guint8) 0;
}

static NibblesGameBonuses*
nibbles_game_bonuses_construct (GType object_type)
{
	NibblesGameBonuses * self = NULL;
	self = (NibblesGameBonuses*) g_object_new (object_type, NULL);
	return self;
}

static NibblesGameBonuses*
nibbles_game_bonuses_new (void)
{
	return nibbles_game_bonuses_construct (NIBBLES_GAME_TYPE_BONUSES);
}

static void
nibbles_game_bonuses_class_init (NibblesGameBonusesClass * klass,
                                 gpointer klass_data)
{
	nibbles_game_bonuses_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesGameBonuses_private_offset);
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_bonuses_finalize;
	nibbles_game_bonuses_signals[NIBBLES_GAME_BONUSES_BONUS_REMOVED_SIGNAL] = g_signal_new ("bonus-removed", NIBBLES_GAME_TYPE_BONUSES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
}

static void
nibbles_game_bonuses_instance_init (NibblesGameBonuses * self,
                                    gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = nibbles_game_bonuses_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->bonuses = _tmp0_;
	self->priv->regular_bonus_left = (guint8) 0;
	self->priv->regular_bonus_maxi = (guint8) 0;
	self->priv->total_bonus_number = (guint8) 0;
	self->priv->missed = (guint8) 0;
}

static void
nibbles_game_bonuses_finalize (GObject * obj)
{
	NibblesGameBonuses * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_GAME_TYPE_BONUSES, NibblesGameBonuses);
	_g_object_unref0 (self->priv->bonuses);
	G_OBJECT_CLASS (nibbles_game_bonuses_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_game_bonuses_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesGameBonusesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_bonuses_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGameBonuses), 0, (GInstanceInitFunc) nibbles_game_bonuses_instance_init, NULL };
	GType nibbles_game_bonuses_type_id;
	nibbles_game_bonuses_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGameBonuses", &g_define_type_info, 0);
	NibblesGameBonuses_private_offset = g_type_add_instance_private (nibbles_game_bonuses_type_id, sizeof (NibblesGameBonusesPrivate));
	return nibbles_game_bonuses_type_id;
}

static GType
nibbles_game_bonuses_get_type (void)
{
	static gsize nibbles_game_bonuses_type_id__once = 0;
	if (g_once_init_enter (&nibbles_game_bonuses_type_id__once)) {
		GType nibbles_game_bonuses_type_id;
		nibbles_game_bonuses_type_id = nibbles_game_bonuses_get_type_once ();
		g_once_init_leave (&nibbles_game_bonuses_type_id__once, nibbles_game_bonuses_type_id);
	}
	return nibbles_game_bonuses_type_id__once;
}

static inline gpointer
nibbles_game_score_delta_get_instance_private (NibblesGameScoreDelta* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesGameScoreDelta_private_offset);
}

static NibblesGameScoreDelta*
nibbles_game_score_delta_construct (GType object_type,
                                    Worm* worm,
                                    gint score_delta)
{
	NibblesGameScoreDelta * self = NULL;
	g_return_val_if_fail (worm != NULL, NULL);
	self = (NibblesGameScoreDelta*) g_object_new (object_type, "worm", worm, "score-delta", score_delta, NULL);
	return self;
}

static NibblesGameScoreDelta*
nibbles_game_score_delta_new (Worm* worm,
                              gint score_delta)
{
	return nibbles_game_score_delta_construct (NIBBLES_GAME_TYPE_SCORE_DELTA, worm, score_delta);
}

static Worm*
nibbles_game_score_delta_get_worm (NibblesGameScoreDelta* self)
{
	Worm* result;
	Worm* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worm;
	result = _tmp0_;
	return result;
}

static void
nibbles_game_score_delta_set_worm (NibblesGameScoreDelta* self,
                                   Worm* value)
{
	Worm* old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_score_delta_get_worm (self);
	if (old_value != value) {
		Worm* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_worm);
		self->priv->_worm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_score_delta_properties[NIBBLES_GAME_SCORE_DELTA_WORM_PROPERTY]);
	}
}

static gint
nibbles_game_score_delta_get_score_delta (NibblesGameScoreDelta* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_score_delta;
	return result;
}

static void
nibbles_game_score_delta_set_score_delta (NibblesGameScoreDelta* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_score_delta_get_score_delta (self);
	if (old_value != value) {
		self->priv->_score_delta = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_score_delta_properties[NIBBLES_GAME_SCORE_DELTA_SCORE_DELTA_PROPERTY]);
	}
}

static void
nibbles_game_score_delta_class_init (NibblesGameScoreDeltaClass * klass,
                                     gpointer klass_data)
{
	nibbles_game_score_delta_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesGameScoreDelta_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_game_score_delta_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_game_score_delta_set_property;
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_score_delta_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SCORE_DELTA_WORM_PROPERTY, nibbles_game_score_delta_properties[NIBBLES_GAME_SCORE_DELTA_WORM_PROPERTY] = g_param_spec_object ("worm", "worm", "worm", TYPE_WORM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SCORE_DELTA_SCORE_DELTA_PROPERTY, nibbles_game_score_delta_properties[NIBBLES_GAME_SCORE_DELTA_SCORE_DELTA_PROPERTY] = g_param_spec_int ("score-delta", "score-delta", "score-delta", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
nibbles_game_score_delta_instance_init (NibblesGameScoreDelta * self,
                                        gpointer klass)
{
	self->priv = nibbles_game_score_delta_get_instance_private (self);
}

static void
nibbles_game_score_delta_finalize (GObject * obj)
{
	NibblesGameScoreDelta * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_GAME_TYPE_SCORE_DELTA, NibblesGameScoreDelta);
	_g_object_unref0 (self->priv->_worm);
	G_OBJECT_CLASS (nibbles_game_score_delta_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_game_score_delta_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesGameScoreDeltaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_score_delta_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGameScoreDelta), 0, (GInstanceInitFunc) nibbles_game_score_delta_instance_init, NULL };
	GType nibbles_game_score_delta_type_id;
	nibbles_game_score_delta_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGameScoreDelta", &g_define_type_info, 0);
	NibblesGameScoreDelta_private_offset = g_type_add_instance_private (nibbles_game_score_delta_type_id, sizeof (NibblesGameScoreDeltaPrivate));
	return nibbles_game_score_delta_type_id;
}

static GType
nibbles_game_score_delta_get_type (void)
{
	static gsize nibbles_game_score_delta_type_id__once = 0;
	if (g_once_init_enter (&nibbles_game_score_delta_type_id__once)) {
		GType nibbles_game_score_delta_type_id;
		nibbles_game_score_delta_type_id = nibbles_game_score_delta_get_type_once ();
		g_once_init_leave (&nibbles_game_score_delta_type_id__once, nibbles_game_score_delta_type_id);
	}
	return nibbles_game_score_delta_type_id__once;
}

static void
_vala_nibbles_game_score_delta_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	NibblesGameScoreDelta * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NIBBLES_GAME_TYPE_SCORE_DELTA, NibblesGameScoreDelta);
	switch (property_id) {
		case NIBBLES_GAME_SCORE_DELTA_WORM_PROPERTY:
		g_value_set_object (value, nibbles_game_score_delta_get_worm (self));
		break;
		case NIBBLES_GAME_SCORE_DELTA_SCORE_DELTA_PROPERTY:
		g_value_set_int (value, nibbles_game_score_delta_get_score_delta (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_nibbles_game_score_delta_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	NibblesGameScoreDelta * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NIBBLES_GAME_TYPE_SCORE_DELTA, NibblesGameScoreDelta);
	switch (property_id) {
		case NIBBLES_GAME_SCORE_DELTA_WORM_PROPERTY:
		nibbles_game_score_delta_set_worm (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_SCORE_DELTA_SCORE_DELTA_PROPERTY:
		nibbles_game_score_delta_set_score_delta (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_nibbles_game___lambda9_ (NibblesGame* self,
                          Bonus* bonus)
{
	g_return_if_fail (bonus != NULL);
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_BONUS_REMOVED_SIGNAL], 0, bonus);
}

static void
__nibbles_game___lambda9__nibbles_game_bonuses_bonus_removed (NibblesGameBonuses* _sender,
                                                              Bonus* bonus,
                                                              gpointer self)
{
	_nibbles_game___lambda9_ ((NibblesGame*) self, bonus);
}

static GObject *
nibbles_game_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NibblesGame * self;
	guint8 _tmp0_;
	guint8 _tmp1_;
	gint* _tmp2_;
	NibblesGameBonuses* _tmp3_;
	parent_class = G_OBJECT_CLASS (nibbles_game_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
	_tmp0_ = self->priv->_width;
	_tmp1_ = self->priv->_height;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	self->board = (g_free (self->board), NULL);
	self->board = _tmp2_;
	self->board_length1 = _tmp0_;
	self->board_length2 = _tmp1_;
	_tmp3_ = self->priv->bonuses;
	g_signal_connect_object (_tmp3_, "bonus-removed", (GCallback) __nibbles_game___lambda9__nibbles_game_bonuses_bonus_removed, self, 0);
	return obj;
}

static void
nibbles_game_class_init (NibblesGameClass * klass,
                         gpointer klass_data)
{
	nibbles_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesGame_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_game_set_property;
	G_OBJECT_CLASS (klass)->constructor = nibbles_game_constructor;
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SKIP_SCORE_PROPERTY, nibbles_game_properties[NIBBLES_GAME_SKIP_SCORE_PROPERTY] = g_param_spec_boolean ("skip-score", "skip-score", "skip-score", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_CURRENT_LEVEL_PROPERTY, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY] = g_param_spec_int ("current-level", "current-level", "current-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY, nibbles_game_properties[NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY] = g_param_spec_boolean ("three-dimensional-view", "three-dimensional-view", "three-dimensional-view", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SPEED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY] = g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_GAMEDELAY_PROPERTY, nibbles_game_properties[NIBBLES_GAME_GAMEDELAY_PROPERTY] = g_param_spec_int ("gamedelay", "gamedelay", "gamedelay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_PROGRESS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_PROGRESS_PROPERTY] = g_param_spec_int ("progress", "progress", "progress", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_START_LEVEL_PROPERTY, nibbles_game_properties[NIBBLES_GAME_START_LEVEL_PROPERTY] = g_param_spec_int ("start-level", "start-level", "start-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WIDTH_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WIDTH_PROPERTY] = g_param_spec_uchar ("width", "width", "width", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_HEIGHT_PROPERTY, nibbles_game_properties[NIBBLES_GAME_HEIGHT_PROPERTY] = g_param_spec_uchar ("height", "height", "height", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMHUMANS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY] = g_param_spec_int ("numhumans", "numhumans", "numhumans", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMAI_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY] = g_param_spec_int ("numai", "numai", "numai", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMWORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY] = g_param_spec_int ("numworms", "numworms", "numworms", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORMS_PROPERTY] = g_param_spec_object ("worms", "worms", "worms", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORM_PROPS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORM_PROPS_PROPERTY] = g_param_spec_object ("worm-props", "worm-props", "worm-props", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_RUNNING_PROPERTY, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_PAUSED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_PAUSED_PROPERTY] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_FAKES_PROPERTY, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY] = g_param_spec_boolean ("fakes", "fakes", "fakes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL] = g_signal_new ("bonus-applied", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT, G_TYPE_NONE, 3, TYPE_BONUS, TYPE_WORM, G_TYPE_INT);
	nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL] = g_signal_new ("log-score", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL] = g_signal_new ("animate-end-game", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL] = g_signal_new ("level-completed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	nibbles_game_signals[NIBBLES_GAME_WARP_ADDED_SIGNAL] = g_signal_new ("warp-added", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UCHAR_UCHAR, G_TYPE_NONE, 2, G_TYPE_UCHAR, G_TYPE_UCHAR);
	nibbles_game_signals[NIBBLES_GAME_BONUS_ADDED_SIGNAL] = g_signal_new ("bonus-added", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
	nibbles_game_signals[NIBBLES_GAME_BONUS_REMOVED_SIGNAL] = g_signal_new ("bonus-removed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
	nibbles_game_signals[NIBBLES_GAME_GET_PKGDATADIR_SIGNAL] = g_signal_new ("get-pkgdatadir", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_STRING__VOID, G_TYPE_STRING, 0);
	nibbles_game_signals[NIBBLES_GAME_ADD_KEYPRESS_HANDLER_SIGNAL] = g_signal_new ("add-keypress-handler", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, G_TYPE_BOOLEAN, 2, G_TYPE_POINTER, G_TYPE_POINTER);
	nibbles_game_signals[NIBBLES_GAME_REDRAW_SIGNAL] = g_signal_new ("redraw", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL] = g_signal_new ("play-sound", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
nibbles_game_instance_init (NibblesGame * self,
                            gpointer klass)
{
	gint* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeHashMap* _tmp2_;
	NibblesGameBonuses* _tmp3_;
	WarpManager* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeConcurrentSet* _tmp6_;
	self->priv = nibbles_game_get_instance_private (self);
	_tmp0_ = g_new0 (gint, 0);
	self->levels_uncompleated = _tmp0_;
	self->levels_uncompleated_length1 = 0;
	self->_levels_uncompleated_size_ = self->levels_uncompleated_length1;
	_tmp1_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_worms = _tmp1_;
	_tmp2_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM_PROPERTIES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_worm_props = _tmp2_;
	_tmp3_ = nibbles_game_bonuses_new ();
	self->priv->bonuses = _tmp3_;
	_tmp4_ = warp_manager_new ();
	self->priv->warp_manager = _tmp4_;
	_tmp5_ = gee_hash_map_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_score_deltas = _tmp5_;
	_tmp6_ = gee_concurrent_set_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->bouns_eaten = (GeeSet*) _tmp6_;
	self->priv->_is_running = FALSE;
	self->priv->_is_paused = FALSE;
	self->priv->main_id = (guint) 0;
	self->added_keypress_handler = FALSE;
	self->priv->bonus_cycle = (guint8) 0;
}

static void
nibbles_game_finalize (GObject * obj)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
	self->levels_uncompleated = (g_free (self->levels_uncompleated), NULL);
	self->board = (g_free (self->board), NULL);
	_g_object_unref0 (self->priv->_worms);
	_g_object_unref0 (self->priv->_worm_props);
	_g_object_unref0 (self->priv->bonuses);
	_g_object_unref0 (self->priv->warp_manager);
	_g_object_unref0 (self->priv->_score_deltas);
	_g_object_unref0 (self->priv->bouns_eaten);
	G_OBJECT_CLASS (nibbles_game_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGame), 0, (GInstanceInitFunc) nibbles_game_instance_init, NULL };
	GType nibbles_game_type_id;
	nibbles_game_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGame", &g_define_type_info, 0);
	NibblesGame_private_offset = g_type_add_instance_private (nibbles_game_type_id, sizeof (NibblesGamePrivate));
	return nibbles_game_type_id;
}

GType
nibbles_game_get_type (void)
{
	static gsize nibbles_game_type_id__once = 0;
	if (g_once_init_enter (&nibbles_game_type_id__once)) {
		GType nibbles_game_type_id;
		nibbles_game_type_id = nibbles_game_get_type_once ();
		g_once_init_leave (&nibbles_game_type_id__once, nibbles_game_type_id);
	}
	return nibbles_game_type_id__once;
}

static void
_vala_nibbles_game_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_SKIP_SCORE_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_skip_score (self));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
		g_value_set_int (value, nibbles_game_get_current_level (self));
		break;
		case NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_three_dimensional_view (self));
		break;
		case NIBBLES_GAME_SPEED_PROPERTY:
		g_value_set_int (value, nibbles_game_get_speed (self));
		break;
		case NIBBLES_GAME_GAMEDELAY_PROPERTY:
		g_value_set_int (value, nibbles_game_get_gamedelay (self));
		break;
		case NIBBLES_GAME_PROGRESS_PROPERTY:
		g_value_set_int (value, nibbles_game_get_progress (self));
		break;
		case NIBBLES_GAME_START_LEVEL_PROPERTY:
		g_value_set_int (value, nibbles_game_get_start_level (self));
		break;
		case NIBBLES_GAME_WIDTH_PROPERTY:
		g_value_set_uchar (value, nibbles_game_get_width (self));
		break;
		case NIBBLES_GAME_HEIGHT_PROPERTY:
		g_value_set_uchar (value, nibbles_game_get_height (self));
		break;
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numhumans (self));
		break;
		case NIBBLES_GAME_NUMAI_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numai (self));
		break;
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numworms (self));
		break;
		case NIBBLES_GAME_WORMS_PROPERTY:
		g_value_set_object (value, nibbles_game_get_worms (self));
		break;
		case NIBBLES_GAME_WORM_PROPS_PROPERTY:
		g_value_set_object (value, nibbles_game_get_worm_props (self));
		break;
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_is_running (self));
		break;
		case NIBBLES_GAME_PAUSED_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_paused (self));
		break;
		case NIBBLES_GAME_FAKES_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_fakes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_nibbles_game_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_SKIP_SCORE_PROPERTY:
		nibbles_game_set_skip_score (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
		nibbles_game_set_current_level (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY:
		nibbles_game_set_three_dimensional_view (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_SPEED_PROPERTY:
		nibbles_game_set_speed (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_GAMEDELAY_PROPERTY:
		nibbles_game_set_gamedelay (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_PROGRESS_PROPERTY:
		nibbles_game_set_progress (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_START_LEVEL_PROPERTY:
		nibbles_game_set_start_level (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_WIDTH_PROPERTY:
		nibbles_game_set_width (self, g_value_get_uchar (value));
		break;
		case NIBBLES_GAME_HEIGHT_PROPERTY:
		nibbles_game_set_height (self, g_value_get_uchar (value));
		break;
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
		nibbles_game_set_numhumans (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMAI_PROPERTY:
		nibbles_game_set_numai (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
		nibbles_game_set_numworms (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
		nibbles_game_set_is_running (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_PAUSED_PROPERTY:
		nibbles_game_set_paused (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_FAKES_PROPERTY:
		nibbles_game_set_fakes (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_array_move (gpointer array,
                  gsize element_size,
                  gssize src,
                  gssize dest,
                  gssize length)
{
	memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}

