/* taquin-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from taquin-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Taquin.

   Copyright (C) 2014-2016 – Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME Taquin is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Taquin is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Taquin.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define TAQUIN_VIEW_GRID_SPACING 1
#define TAQUIN_VIEW_half_pi (G_PI / 2.0)
#define TAQUIN_VIEW_three_half_pi (TAQUIN_VIEW_half_pi * 3.0)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	DIRECTION_TOP,
	DIRECTION_LEFT,
	DIRECTION_RIGHT,
	DIRECTION_BOTTOM,
	DIRECTION_NONE
} Direction;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;
typedef struct _TaquinViewPrivate TaquinViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	TAQUIN_VIEW_0_PROPERTY,
	TAQUIN_VIEW_GAME_PROPERTY,
	TAQUIN_VIEW_THEME_PROPERTY,
	TAQUIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* taquin_view_properties[TAQUIN_VIEW_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

#define TYPE_GAME_TYPE (game_type_get_type ())

struct _TaquinView {
	GtkDrawingArea parent_instance;
	TaquinViewPrivate * priv;
};

struct _TaquinViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _TaquinViewPrivate {
	gint grid_border_main;
	gint grid_border_thin;
	gint arrows;
	gint tile_size;
	gint board_size;
	gint8 x_arrow;
	gint8 y_arrow;
	gboolean draw_lights;
	gint render_size;
	cairo_pattern_t* tiles_pattern;
	gboolean animate;
	gint animation_offset;
	gboolean x_axis;
	gint number;
	gint8 x_gap;
	gint8 y_gap;
	gboolean animate_end;
	gboolean finished;
	gdouble animation_end_offset;
	Game* _game;
	GdkPixbuf* unscaled_pixbuf;
	gchar* _theme;
	GtkGestureMultiPress* click_controller;
	GtkEventControllerKey* key_controller;
};

static gint TaquinView_private_offset;
static gpointer taquin_view_parent_class = NULL;

VALA_EXTERN GType direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType taquin_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TaquinView, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN TaquinView* taquin_view_new (void);
VALA_EXTERN TaquinView* taquin_view_construct (GType object_type);
static gboolean taquin_view_real_configure_event (GtkWidget* base,
                                           GdkEventConfigure* e);
static void taquin_view_configure (TaquinView* self);
static Game* taquin_view_get_game (TaquinView* self);
VALA_EXTERN gint8 game_get_size (Game* self);
static gboolean taquin_view_real_draw (GtkWidget* base,
                                cairo_t* cr);
static inline void _taquin_view_refresh_pixmaps (cairo_t* context,
                                   GdkPixbuf* unscaled_pixbuf,
                                   gint* board_size);
static gint taquin_view_get_x_offset (TaquinView* self);
static gint taquin_view_get_y_offset (TaquinView* self);
static inline void _taquin_view_draw_board (cairo_t* cr,
                              gint* grid_border_main,
                              gint* board_size,
                              gint* grid_border_thin);
VALA_EXTERN GType game_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameType game_get_game_type (Game* self);
static inline void taquin_view_draw_movable_lights (TaquinView* self,
                                      cairo_t* cr);
static inline void taquin_view_draw_fixed_arrows (TaquinView* self,
                                    cairo_t* cr);
static inline void taquin_view_draw_movable_arrows (TaquinView* self,
                                      cairo_t* cr);
VALA_EXTERN gint8 game_get_tile_value (Game* self,
                           gint8 x,
                           gint8 y);
static inline void _taquin_view_draw_movable_lights (cairo_t* cr,
                                       gdouble* animation_end_offset,
                                       gint* grid_border_main,
                                       gint* tile_size,
                                       gint8* x_arrow,
                                       gint* grid_border_thin,
                                       gint* board_size,
                                       gint8* y_arrow);
static void taquin_view_draw_light (cairo_t* cr,
                             gboolean horizontal,
                             gint* tile_size,
                             gint* grid_border_main);
static inline void _taquin_view_draw_fixed_arrows (cairo_t* cr,
                                     gint game_size,
                                     gint* grid_border_main,
                                     gint* tile_size,
                                     gint* grid_border_thin,
                                     gint* board_size);
static void taquin_view_draw_vertical_arrow (cairo_t* cr,
                                      gboolean inside,
                                      gint number,
                                      gint* grid_border_main,
                                      gint* tile_size,
                                      gint* grid_border_thin,
                                      gint* board_size);
static void taquin_view_draw_horizontal_arrow (cairo_t* cr,
                                        gboolean inside,
                                        gint number,
                                        gint* grid_border_main,
                                        gint* tile_size,
                                        gint* grid_border_thin,
                                        gint* board_size);
static inline void _taquin_view_draw_movable_arrows (cairo_t* cr,
                                       gint8* x_arrow,
                                       gint8* y_arrow,
                                       gint* grid_border_main,
                                       gint* tile_size,
                                       gint* grid_border_thin,
                                       gint* board_size);
static void taquin_view_move_cb (TaquinView* self,
                          gboolean x_axis,
                          gint8 number,
                          gint8 x_gap,
                          gint8 y_gap,
                          guint moves_count,
                          gboolean disable_animation);
static void taquin_view_complete_cb (TaquinView* self);
static gboolean __lambda13_ (TaquinView* self);
static gboolean ___lambda13__gsource_func (gpointer self);
static void taquin_view_init_mouse (TaquinView* self);
static inline void taquin_view_on_click (TaquinView* self,
                           GtkGestureMultiPress* _click_controller,
                           gint n_press,
                           gdouble event_x,
                           gdouble event_y);
static void _taquin_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                            gint n_press,
                                                            gdouble x,
                                                            gdouble y,
                                                            gpointer self);
VALA_EXTERN void game_request_move (Game* self,
                        gint8 x,
                        gint8 y,
                        gboolean keyboard_call);
static void taquin_view_init_keyboard (TaquinView* self);
static inline gboolean taquin_view_on_key_pressed (TaquinView* self,
                                     GtkEventControllerKey* _key_controller,
                                     guint keyval,
                                     guint keycode,
                                     GdkModifierType state);
static gboolean _taquin_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self);
VALA_EXTERN void taquin_view_set_game (TaquinView* self,
                           Game* value);
static void _taquin_view_move_cb_game_move (Game* _sender,
                                     gboolean x_axis,
                                     gint8 number,
                                     gint8 x_gap,
                                     gint8 y_gap,
                                     guint moves_count,
                                     gboolean disable_animation,
                                     gpointer self);
static void _taquin_view_complete_cb_game_complete (Game* _sender,
                                             gpointer self);
static const gchar* taquin_view_get_theme (TaquinView* self);
VALA_EXTERN void taquin_view_set_theme (TaquinView* self,
                            const gchar* value);
static GObject * taquin_view_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void taquin_view_finalize (GObject * obj);
static GType taquin_view_get_type_once (void);
static void _vala_taquin_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_taquin_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
direction_get_type_once (void)
{
	static const GEnumValue values[] = {{DIRECTION_TOP, "DIRECTION_TOP", "top"}, {DIRECTION_LEFT, "DIRECTION_LEFT", "left"}, {DIRECTION_RIGHT, "DIRECTION_RIGHT", "right"}, {DIRECTION_BOTTOM, "DIRECTION_BOTTOM", "bottom"}, {DIRECTION_NONE, "DIRECTION_NONE", "none"}, {0, NULL, NULL}};
	GType direction_type_id;
	direction_type_id = g_enum_register_static ("Direction", values);
	return direction_type_id;
}

GType
direction_get_type (void)
{
	static volatile gsize direction_type_id__once = 0;
	if (g_once_init_enter (&direction_type_id__once)) {
		GType direction_type_id;
		direction_type_id = direction_get_type_once ();
		g_once_init_leave (&direction_type_id__once, direction_type_id);
	}
	return direction_type_id__once;
}

static inline gpointer
taquin_view_get_instance_private (TaquinView* self)
{
	return G_STRUCT_MEMBER_P (self, TaquinView_private_offset);
}

TaquinView*
taquin_view_construct (GType object_type)
{
	TaquinView * self = NULL;
	self = (TaquinView*) g_object_new (object_type, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK));
	return self;
}

TaquinView*
taquin_view_new (void)
{
	return taquin_view_construct (TYPE_TAQUIN_VIEW);
}

static gboolean
taquin_view_real_configure_event (GtkWidget* base,
                                  GdkEventConfigure* e)
{
	TaquinView * self;
	gboolean result;
	self = (TaquinView*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	taquin_view_configure (self);
	result = TRUE;
	return result;
}

static void
taquin_view_configure (TaquinView* self)
{
	gint size = 0;
	Game* _tmp0_;
	Game* _tmp1_;
	gint8 _tmp2_;
	gint8 _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	gint8 _tmp6_;
	gint8 _tmp7_;
	g_return_if_fail (self != NULL);
	size = MIN (gtk_widget_get_allocated_width ((GtkWidget*) self), gtk_widget_get_allocated_height ((GtkWidget*) self));
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->tile_size = ((size * 10) / 12) / _tmp3_;
	_tmp4_ = taquin_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	self->priv->board_size = (self->priv->tile_size * _tmp7_) - TAQUIN_VIEW_GRID_SPACING;
	self->priv->grid_border_main = (size - self->priv->board_size) / 2;
	self->priv->arrows = size / 100;
}

static gboolean
taquin_view_real_draw (GtkWidget* base,
                       cairo_t* cr)
{
	TaquinView * self;
	gboolean _tmp0_ = FALSE;
	cairo_pattern_t* _tmp1_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	Game* _tmp14_;
	Game* _tmp15_;
	GameType _tmp16_;
	GameType _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean result;
	self = (TaquinView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp1_ = self->priv->tiles_pattern;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->render_size != self->priv->tile_size;
	}
	if (_tmp0_) {
		cairo_surface_t* surface = NULL;
		cairo_surface_t* _tmp2_;
		cairo_surface_t* _tmp3_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp4_;
		cairo_t* _tmp5_;
		cairo_t* _tmp6_;
		GdkPixbuf* _tmp7_;
		cairo_surface_t* _tmp8_;
		cairo_pattern_t* _tmp9_;
		self->priv->render_size = self->priv->tile_size;
		_tmp2_ = cairo_get_target (cr);
		_tmp3_ = cairo_surface_create_similar (_tmp2_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->board_size, self->priv->board_size);
		surface = _tmp3_;
		_tmp4_ = surface;
		_tmp5_ = cairo_create (_tmp4_);
		c = _tmp5_;
		_tmp6_ = c;
		_tmp7_ = self->priv->unscaled_pixbuf;
		_taquin_view_refresh_pixmaps (_tmp6_, _tmp7_, &self->priv->board_size);
		_tmp8_ = surface;
		_tmp9_ = cairo_pattern_create_for_surface (_tmp8_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp9_;
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp10_ = taquin_view_get_x_offset (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = taquin_view_get_y_offset (self);
	_tmp13_ = _tmp12_;
	cairo_translate (cr, (gdouble) _tmp11_, (gdouble) _tmp13_);
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);
	_taquin_view_draw_board (cr, &self->priv->grid_border_main, &self->priv->board_size, &self->priv->grid_border_thin);
	cairo_set_source_rgba (cr, 0.5, 0.5, 0.5, 1.0 - self->priv->animation_end_offset);
	cairo_set_line_width (cr, (gdouble) self->priv->arrows);
	_tmp14_ = taquin_view_get_game (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = game_get_game_type (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == GAME_TYPE_SIXTEEN) {
		if (self->priv->draw_lights) {
			taquin_view_draw_movable_lights (self, cr);
		}
		taquin_view_draw_fixed_arrows (self, cr);
	} else {
		taquin_view_draw_movable_arrows (self, cr);
	}
	cairo_stroke (cr);
	cairo_save (cr);
	cairo_translate (cr, (gdouble) self->priv->grid_border_main, (gdouble) self->priv->grid_border_main);
	if (self->priv->animate) {
		Game* _tmp19_;
		Game* _tmp20_;
		GameType _tmp21_;
		GameType _tmp22_;
		_tmp19_ = taquin_view_get_game (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = game_get_game_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_ == GAME_TYPE_SIXTEEN;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gint texture_x = 0;
		Game* _tmp23_;
		Game* _tmp24_;
		Game* _tmp25_;
		Game* _tmp26_;
		gint8 _tmp27_;
		gint8 _tmp28_;
		gint texture_y = 0;
		Game* _tmp29_;
		Game* _tmp30_;
		Game* _tmp31_;
		Game* _tmp32_;
		gint8 _tmp33_;
		gint8 _tmp34_;
		gint tile_x = 0;
		gint tile_y = 0;
		cairo_matrix_t matrix = {0};
		cairo_pattern_t* _tmp35_;
		cairo_matrix_t _tmp36_;
		cairo_pattern_t* _tmp37_;
		gint _tmp38_ = 0;
		gint8 _tmp44_ = 0;
		cairo_pattern_t* _tmp50_;
		cairo_matrix_t _tmp51_;
		cairo_pattern_t* _tmp52_;
		_tmp23_ = taquin_view_get_game (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = taquin_view_get_game (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = game_get_size (_tmp26_);
		_tmp28_ = _tmp27_;
		texture_x = (game_get_tile_value (_tmp24_, self->priv->x_gap, self->priv->y_gap) % _tmp28_) * self->priv->tile_size;
		_tmp29_ = taquin_view_get_game (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = taquin_view_get_game (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = game_get_size (_tmp32_);
		_tmp34_ = _tmp33_;
		texture_y = (game_get_tile_value (_tmp30_, self->priv->x_gap, self->priv->y_gap) / _tmp34_) * self->priv->tile_size;
		tile_x = self->priv->x_gap * self->priv->tile_size;
		tile_y = self->priv->y_gap * self->priv->tile_size;
		cairo_matrix_init_identity (&matrix);
		cairo_matrix_translate (&matrix, (gdouble) (texture_x - tile_x), (gdouble) (texture_y - tile_y));
		_tmp35_ = self->priv->tiles_pattern;
		_tmp36_ = matrix;
		cairo_pattern_set_matrix ((cairo_pattern_t*) _tmp35_, &_tmp36_);
		_tmp37_ = self->priv->tiles_pattern;
		cairo_set_source (cr, (cairo_pattern_t*) _tmp37_);
		cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING), (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING));
		cairo_fill (cr);
		if (self->priv->x_axis) {
			gint _tmp39_ = 0;
			if (((gint) self->priv->x_gap) == 0) {
				Game* _tmp40_;
				Game* _tmp41_;
				gint8 _tmp42_;
				gint8 _tmp43_;
				_tmp40_ = taquin_view_get_game (self);
				_tmp41_ = _tmp40_;
				_tmp42_ = game_get_size (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp39_ = _tmp43_ - 1;
			} else {
				_tmp39_ = 0;
			}
			_tmp38_ = _tmp39_;
		} else {
			_tmp38_ = (gint) self->priv->x_gap;
		}
		tile_x = self->priv->tile_size * _tmp38_;
		if (self->priv->x_axis) {
			_tmp44_ = self->priv->y_gap;
		} else {
			gint _tmp45_ = 0;
			if (((gint) self->priv->y_gap) == 0) {
				Game* _tmp46_;
				Game* _tmp47_;
				gint8 _tmp48_;
				gint8 _tmp49_;
				_tmp46_ = taquin_view_get_game (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = game_get_size (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp45_ = _tmp49_ - 1;
			} else {
				_tmp45_ = 0;
			}
			_tmp44_ = (gint8) _tmp45_;
		}
		tile_y = self->priv->tile_size * _tmp44_;
		cairo_matrix_init_identity (&matrix);
		cairo_matrix_translate (&matrix, (gdouble) (texture_x - tile_x), (gdouble) (texture_y - tile_y));
		_tmp50_ = self->priv->tiles_pattern;
		_tmp51_ = matrix;
		cairo_pattern_set_matrix ((cairo_pattern_t*) _tmp50_, &_tmp51_);
		_tmp52_ = self->priv->tiles_pattern;
		cairo_set_source (cr, (cairo_pattern_t*) _tmp52_);
		cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING), (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING));
		cairo_fill (cr);
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = TRUE;
			while (TRUE) {
				Game* _tmp55_;
				Game* _tmp56_;
				gint8 _tmp57_;
				gint8 _tmp58_;
				if (!_tmp53_) {
					gint _tmp54_;
					_tmp54_ = y;
					y = _tmp54_ + 1;
				}
				_tmp53_ = FALSE;
				_tmp55_ = taquin_view_get_game (self);
				_tmp56_ = _tmp55_;
				_tmp57_ = game_get_size (_tmp56_);
				_tmp58_ = _tmp57_;
				if (!(y < ((gint) _tmp58_))) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp59_ = FALSE;
						_tmp59_ = TRUE;
						while (TRUE) {
							Game* _tmp61_;
							Game* _tmp62_;
							gint8 _tmp63_;
							gint8 _tmp64_;
							gboolean _tmp65_ = FALSE;
							gboolean _tmp66_ = FALSE;
							gint tile_x = 0;
							gint tile_y = 0;
							gboolean _tmp67_ = FALSE;
							gint texture_x = 0;
							Game* _tmp79_;
							Game* _tmp80_;
							Game* _tmp81_;
							Game* _tmp82_;
							gint8 _tmp83_;
							gint8 _tmp84_;
							gint texture_y = 0;
							Game* _tmp85_;
							Game* _tmp86_;
							Game* _tmp87_;
							Game* _tmp88_;
							gint8 _tmp89_;
							gint8 _tmp90_;
							cairo_matrix_t matrix = {0};
							cairo_pattern_t* _tmp91_;
							cairo_matrix_t _tmp92_;
							cairo_pattern_t* _tmp93_;
							if (!_tmp59_) {
								gint _tmp60_;
								_tmp60_ = x;
								x = _tmp60_ + 1;
							}
							_tmp59_ = FALSE;
							_tmp61_ = taquin_view_get_game (self);
							_tmp62_ = _tmp61_;
							_tmp63_ = game_get_size (_tmp62_);
							_tmp64_ = _tmp63_;
							if (!(x < ((gint) _tmp64_))) {
								break;
							}
							if (self->priv->animate) {
								_tmp66_ = x == ((gint) self->priv->x_gap);
							} else {
								_tmp66_ = FALSE;
							}
							if (_tmp66_) {
								_tmp65_ = y == ((gint) self->priv->y_gap);
							} else {
								_tmp65_ = FALSE;
							}
							if (_tmp65_) {
								continue;
							}
							tile_x = x * self->priv->tile_size;
							tile_y = y * self->priv->tile_size;
							if (self->priv->animate) {
								gboolean _tmp68_ = FALSE;
								if (x != ((gint) self->priv->x_gap)) {
									_tmp68_ = TRUE;
								} else {
									_tmp68_ = y != ((gint) self->priv->y_gap);
								}
								_tmp67_ = _tmp68_;
							} else {
								_tmp67_ = FALSE;
							}
							if (_tmp67_) {
								gboolean _tmp69_ = FALSE;
								if (self->priv->x_axis) {
									_tmp69_ = y == ((gint) self->priv->y_gap);
								} else {
									_tmp69_ = FALSE;
								}
								if (_tmp69_) {
									gboolean _tmp70_ = FALSE;
									gboolean _tmp71_ = FALSE;
									if (self->priv->number > 0) {
										_tmp71_ = x <= (self->priv->x_gap + self->priv->number);
									} else {
										_tmp71_ = FALSE;
									}
									if (_tmp71_) {
										_tmp70_ = x >= ((gint) self->priv->x_gap);
									} else {
										_tmp70_ = FALSE;
									}
									if (_tmp70_) {
										tile_x -= self->priv->tile_size - self->priv->animation_offset;
									} else {
										gboolean _tmp72_ = FALSE;
										gboolean _tmp73_ = FALSE;
										if (self->priv->number < 0) {
											_tmp73_ = x >= (self->priv->x_gap + self->priv->number);
										} else {
											_tmp73_ = FALSE;
										}
										if (_tmp73_) {
											_tmp72_ = x <= ((gint) self->priv->x_gap);
										} else {
											_tmp72_ = FALSE;
										}
										if (_tmp72_) {
											tile_x += self->priv->tile_size - self->priv->animation_offset;
										}
									}
								} else {
									gboolean _tmp74_ = FALSE;
									if (!self->priv->x_axis) {
										_tmp74_ = x == ((gint) self->priv->x_gap);
									} else {
										_tmp74_ = FALSE;
									}
									if (_tmp74_) {
										gboolean _tmp75_ = FALSE;
										gboolean _tmp76_ = FALSE;
										if (self->priv->number > 0) {
											_tmp76_ = y <= (self->priv->y_gap + self->priv->number);
										} else {
											_tmp76_ = FALSE;
										}
										if (_tmp76_) {
											_tmp75_ = y >= ((gint) self->priv->y_gap);
										} else {
											_tmp75_ = FALSE;
										}
										if (_tmp75_) {
											tile_y -= self->priv->tile_size - self->priv->animation_offset;
										} else {
											gboolean _tmp77_ = FALSE;
											gboolean _tmp78_ = FALSE;
											if (self->priv->number < 0) {
												_tmp78_ = y >= (self->priv->y_gap + self->priv->number);
											} else {
												_tmp78_ = FALSE;
											}
											if (_tmp78_) {
												_tmp77_ = y <= ((gint) self->priv->y_gap);
											} else {
												_tmp77_ = FALSE;
											}
											if (_tmp77_) {
												tile_y += self->priv->tile_size - self->priv->animation_offset;
											}
										}
									}
								}
							}
							_tmp79_ = taquin_view_get_game (self);
							_tmp80_ = _tmp79_;
							_tmp81_ = taquin_view_get_game (self);
							_tmp82_ = _tmp81_;
							_tmp83_ = game_get_size (_tmp82_);
							_tmp84_ = _tmp83_;
							texture_x = (game_get_tile_value (_tmp80_, (gint8) x, (gint8) y) % _tmp84_) * self->priv->tile_size;
							_tmp85_ = taquin_view_get_game (self);
							_tmp86_ = _tmp85_;
							_tmp87_ = taquin_view_get_game (self);
							_tmp88_ = _tmp87_;
							_tmp89_ = game_get_size (_tmp88_);
							_tmp90_ = _tmp89_;
							texture_y = (game_get_tile_value (_tmp86_, (gint8) x, (gint8) y) / _tmp90_) * self->priv->tile_size;
							cairo_matrix_init_identity (&matrix);
							cairo_matrix_translate (&matrix, (gdouble) (texture_x - tile_x), (gdouble) (texture_y - tile_y));
							_tmp91_ = self->priv->tiles_pattern;
							_tmp92_ = matrix;
							cairo_pattern_set_matrix ((cairo_pattern_t*) _tmp91_, &_tmp92_);
							_tmp93_ = self->priv->tiles_pattern;
							cairo_set_source (cr, (cairo_pattern_t*) _tmp93_);
							cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING), (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING));
							cairo_fill (cr);
						}
					}
				}
			}
		}
	}
	if (self->priv->animate_end) {
		cairo_matrix_t matrix = {0};
		cairo_pattern_t* _tmp94_;
		cairo_matrix_t _tmp95_;
		self->priv->animation_end_offset = self->priv->animation_end_offset + 0.01;
		if (self->priv->animation_end_offset >= ((gdouble) 1)) {
			self->priv->animation_end_offset = (gdouble) 1;
		}
		cairo_matrix_init_identity (&matrix);
		_tmp94_ = self->priv->tiles_pattern;
		_tmp95_ = matrix;
		cairo_pattern_set_matrix ((cairo_pattern_t*) _tmp94_, &_tmp95_);
		cairo_paint_with_alpha (cr, self->priv->animation_end_offset);
		if (self->priv->animation_end_offset != ((gdouble) 1)) {
			gtk_widget_queue_draw ((GtkWidget*) self);
		}
	}
	cairo_restore (cr);
	if (self->priv->animate) {
		self->priv->animation_offset = self->priv->animation_offset + 8;
		if (self->priv->x_axis) {
			gint _tmp96_;
			gint _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			_tmp96_ = taquin_view_get_x_offset (self);
			_tmp97_ = _tmp96_;
			_tmp98_ = taquin_view_get_y_offset (self);
			_tmp99_ = _tmp98_;
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp97_ + self->priv->grid_border_main) + (self->priv->tile_size * MIN ((gint) self->priv->x_gap, self->priv->x_gap + self->priv->number)), (_tmp99_ + self->priv->grid_border_main) + (self->priv->tile_size * self->priv->y_gap), self->priv->tile_size * (abs (self->priv->number) + 1), self->priv->tile_size);
		} else {
			gint _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			gint _tmp103_;
			_tmp100_ = taquin_view_get_x_offset (self);
			_tmp101_ = _tmp100_;
			_tmp102_ = taquin_view_get_y_offset (self);
			_tmp103_ = _tmp102_;
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp101_ + self->priv->grid_border_main) + (self->priv->tile_size * self->priv->x_gap), (_tmp103_ + self->priv->grid_border_main) + (self->priv->tile_size * MIN ((gint) self->priv->y_gap, self->priv->y_gap + self->priv->number)), self->priv->tile_size, self->priv->tile_size * (abs (self->priv->number) + 1));
		}
		if (self->priv->animation_offset > self->priv->tile_size) {
			self->priv->animate = FALSE;
		}
	}
	result = FALSE;
	return result;
}

static inline void
_taquin_view_refresh_pixmaps (cairo_t* context,
                              GdkPixbuf* unscaled_pixbuf,
                              gint* board_size)
{
	GdkPixbuf* tmp_pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	g_return_if_fail (context != NULL);
	if (unscaled_pixbuf == NULL) {
		return;
	}
	_tmp0_ = gdk_pixbuf_scale_simple (G_TYPE_CHECK_INSTANCE_CAST (unscaled_pixbuf, gdk_pixbuf_get_type (), GdkPixbuf), *board_size, *board_size, GDK_INTERP_BILINEAR);
	_g_object_unref0 (tmp_pixbuf);
	tmp_pixbuf = _tmp0_;
	_tmp1_ = tmp_pixbuf;
	if (_tmp1_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp2_ = tmp_pixbuf;
	gdk_cairo_set_source_pixbuf (context, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gdk_pixbuf_get_type (), GdkPixbuf), (gdouble) 0, (gdouble) 0);
	cairo_paint (context);
	_g_object_unref0 (tmp_pixbuf);
}

static inline void
_taquin_view_draw_board (cairo_t* cr,
                         gint* grid_border_main,
                         gint* board_size,
                         gint* grid_border_thin)
{
	gdouble half_grid_border_main_first_side = 0.0;
	gdouble board_size_plus_two_half_borders = 0.0;
	gdouble half_grid_border_main_other_side = 0.0;
	gdouble half_grid_borders_diff = 0.0;
	g_return_if_fail (cr != NULL);
	half_grid_border_main_first_side = (*grid_border_main) / 2.0;
	board_size_plus_two_half_borders = (gdouble) ((*board_size) + (*grid_border_main));
	half_grid_border_main_other_side = board_size_plus_two_half_borders + half_grid_border_main_first_side;
	half_grid_borders_diff = ((*grid_border_main) - (*grid_border_thin)) / 2.0;
	cairo_set_source_rgb (cr, 0.8, 0.8, 0.8);
	cairo_rectangle (cr, half_grid_border_main_first_side, half_grid_border_main_first_side, board_size_plus_two_half_borders, board_size_plus_two_half_borders);
	cairo_fill_preserve (cr);
	cairo_set_source_rgb (cr, 0.3, 0.3, 0.3);
	cairo_set_line_width (cr, (gdouble) (*grid_border_main));
	cairo_stroke (cr);
	cairo_set_source_rgb (cr, 0.1, 0.1, 0.1);
	cairo_set_line_width (cr, (gdouble) (*grid_border_thin));
	cairo_arc (cr, half_grid_border_main_first_side, half_grid_border_main_first_side, half_grid_borders_diff, G_PI, TAQUIN_VIEW_three_half_pi);
	cairo_arc (cr, half_grid_border_main_other_side, half_grid_border_main_first_side, half_grid_borders_diff, TAQUIN_VIEW_three_half_pi, 0.0);
	cairo_arc (cr, half_grid_border_main_other_side, half_grid_border_main_other_side, half_grid_borders_diff, 0.0, TAQUIN_VIEW_half_pi);
	cairo_arc (cr, half_grid_border_main_first_side, half_grid_border_main_other_side, half_grid_borders_diff, TAQUIN_VIEW_half_pi, G_PI);
	cairo_arc (cr, half_grid_border_main_first_side, half_grid_border_main_first_side, half_grid_borders_diff, G_PI, TAQUIN_VIEW_three_half_pi);
	cairo_stroke (cr);
}

static inline void
taquin_view_draw_movable_lights (TaquinView* self,
                                 cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_taquin_view_draw_movable_lights (cr, &self->priv->animation_end_offset, &self->priv->grid_border_main, &self->priv->tile_size, &self->priv->x_arrow, &self->priv->grid_border_thin, &self->priv->board_size, &self->priv->y_arrow);
}

static inline void
_taquin_view_draw_movable_lights (cairo_t* cr,
                                  gdouble* animation_end_offset,
                                  gint* grid_border_main,
                                  gint* tile_size,
                                  gint8* x_arrow,
                                  gint* grid_border_thin,
                                  gint* board_size,
                                  gint8* y_arrow)
{
	gdouble half_grid_borders_sum = 0.0;
	gint board_size_plus_borders_diff = 0;
	g_return_if_fail (cr != NULL);
	half_grid_borders_sum = ((*grid_border_main) + (*grid_border_thin)) / 2.0;
	board_size_plus_borders_diff = ((*board_size) + (*grid_border_main)) - (*grid_border_thin);
	cairo_save (cr);
	cairo_set_source_rgba (cr, 0.7, 0.7, 0.7, 0.3 - (0.3 * (*animation_end_offset)));
	cairo_save (cr);
	cairo_translate (cr, (*grid_border_main) + ((*tile_size) * ((*x_arrow) + 0.5)), half_grid_borders_sum);
	taquin_view_draw_light (cr, TRUE, tile_size, grid_border_main);
	cairo_translate (cr, (gdouble) 0, (gdouble) board_size_plus_borders_diff);
	taquin_view_draw_light (cr, TRUE, tile_size, grid_border_main);
	cairo_restore (cr);
	cairo_fill (cr);
	cairo_save (cr);
	cairo_translate (cr, half_grid_borders_sum, (*grid_border_main) + ((*tile_size) * ((*y_arrow) + 0.5)));
	taquin_view_draw_light (cr, FALSE, tile_size, grid_border_main);
	cairo_translate (cr, (gdouble) board_size_plus_borders_diff, (gdouble) 0);
	taquin_view_draw_light (cr, FALSE, tile_size, grid_border_main);
	cairo_restore (cr);
	cairo_fill (cr);
	cairo_restore (cr);
}

static void
taquin_view_draw_light (cairo_t* cr,
                        gboolean horizontal,
                        gint* tile_size,
                        gint* grid_border_main)
{
	gdouble size = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	size = (0.3 * (*tile_size)) / (*grid_border_main);
	if (horizontal) {
		_tmp0_ = size;
	} else {
		_tmp0_ = 0.3;
	}
	if (horizontal) {
		_tmp1_ = 0.3;
	} else {
		_tmp1_ = size;
	}
	cairo_scale (cr, _tmp0_, _tmp1_);
	cairo_arc (cr, 0.0, 0.0, (gdouble) (*grid_border_main), 0.0, 2.0 * G_PI);
	cairo_restore (cr);
}

static inline void
taquin_view_draw_fixed_arrows (TaquinView* self,
                               cairo_t* cr)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gint8 _tmp2_;
	gint8 _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_taquin_view_draw_fixed_arrows (cr, (gint) _tmp3_, &self->priv->grid_border_main, &self->priv->tile_size, &self->priv->grid_border_thin, &self->priv->board_size);
}

static inline void
_taquin_view_draw_fixed_arrows (cairo_t* cr,
                                gint game_size,
                                gint* grid_border_main,
                                gint* tile_size,
                                gint* grid_border_thin,
                                gint* board_size)
{
	g_return_if_fail (cr != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < game_size)) {
					break;
				}
				taquin_view_draw_vertical_arrow (cr, FALSE, i, grid_border_main, tile_size, grid_border_thin, board_size);
				taquin_view_draw_horizontal_arrow (cr, FALSE, i, grid_border_main, tile_size, grid_border_thin, board_size);
			}
		}
	}
}

static inline void
taquin_view_draw_movable_arrows (TaquinView* self,
                                 cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_taquin_view_draw_movable_arrows (cr, &self->priv->x_arrow, &self->priv->y_arrow, &self->priv->grid_border_main, &self->priv->tile_size, &self->priv->grid_border_thin, &self->priv->board_size);
}

static inline void
_taquin_view_draw_movable_arrows (cairo_t* cr,
                                  gint8* x_arrow,
                                  gint8* y_arrow,
                                  gint* grid_border_main,
                                  gint* tile_size,
                                  gint* grid_border_thin,
                                  gint* board_size)
{
	g_return_if_fail (cr != NULL);
	taquin_view_draw_vertical_arrow (cr, TRUE, (gint) (*x_arrow), grid_border_main, tile_size, grid_border_thin, board_size);
	taquin_view_draw_horizontal_arrow (cr, TRUE, (gint) (*y_arrow), grid_border_main, tile_size, grid_border_thin, board_size);
}

static void
taquin_view_draw_horizontal_arrow (cairo_t* cr,
                                   gboolean inside,
                                   gint number,
                                   gint* grid_border_main,
                                   gint* tile_size,
                                   gint* grid_border_thin,
                                   gint* board_size)
{
	gdouble x1 = 0.0;
	gdouble x2 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (cr != NULL);
	x1 = (((*grid_border_main) * 1.0) / 3) + (((*grid_border_thin) * 2.0) / 3);
	x2 = (((*grid_border_main) * 2.0) / 3) + (((*grid_border_thin) * 1.0) / 3);
	if (inside) {
		_tmp0_ = x1;
	} else {
		_tmp0_ = x2;
	}
	cairo_move_to (cr, _tmp0_, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 3))));
	if (inside) {
		_tmp1_ = x2;
	} else {
		_tmp1_ = x1;
	}
	cairo_line_to (cr, _tmp1_, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 2))));
	if (inside) {
		_tmp2_ = x1;
	} else {
		_tmp2_ = x2;
	}
	cairo_line_to (cr, _tmp2_, (*grid_border_main) + ((*tile_size) * (number + (2.0 / 3))));
	x1 = ((*board_size) + (((*grid_border_main) * 5.0) / 3)) - (((*grid_border_thin) * 2.0) / 3);
	x2 = ((*board_size) + (((*grid_border_main) * 4.0) / 3)) - (((*grid_border_thin) * 1.0) / 3);
	if (inside) {
		_tmp3_ = x1;
	} else {
		_tmp3_ = x2;
	}
	cairo_move_to (cr, _tmp3_, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 3))));
	if (inside) {
		_tmp4_ = x2;
	} else {
		_tmp4_ = x1;
	}
	cairo_line_to (cr, _tmp4_, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 2))));
	if (inside) {
		_tmp5_ = x1;
	} else {
		_tmp5_ = x2;
	}
	cairo_line_to (cr, _tmp5_, (*grid_border_main) + ((*tile_size) * (number + (2.0 / 3))));
}

static void
taquin_view_draw_vertical_arrow (cairo_t* cr,
                                 gboolean inside,
                                 gint number,
                                 gint* grid_border_main,
                                 gint* tile_size,
                                 gint* grid_border_thin,
                                 gint* board_size)
{
	gdouble y1 = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (cr != NULL);
	y1 = (((*grid_border_main) * 1.0) / 3) + (((*grid_border_thin) * 2.0) / 3);
	y2 = (((*grid_border_main) * 2.0) / 3) + (((*grid_border_thin) * 1.0) / 3);
	if (inside) {
		_tmp0_ = y1;
	} else {
		_tmp0_ = y2;
	}
	cairo_move_to (cr, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 3))), _tmp0_);
	if (inside) {
		_tmp1_ = y2;
	} else {
		_tmp1_ = y1;
	}
	cairo_line_to (cr, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 2))), _tmp1_);
	if (inside) {
		_tmp2_ = y1;
	} else {
		_tmp2_ = y2;
	}
	cairo_line_to (cr, (*grid_border_main) + ((*tile_size) * (number + (2.0 / 3))), _tmp2_);
	y1 = ((*board_size) + (((*grid_border_main) * 5.0) / 3)) - (((*grid_border_thin) * 2.0) / 3);
	y2 = ((*board_size) + (((*grid_border_main) * 4.0) / 3)) - (((*grid_border_thin) * 1.0) / 3);
	if (inside) {
		_tmp3_ = y1;
	} else {
		_tmp3_ = y2;
	}
	cairo_move_to (cr, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 3))), _tmp3_);
	if (inside) {
		_tmp4_ = y2;
	} else {
		_tmp4_ = y1;
	}
	cairo_line_to (cr, (*grid_border_main) + ((*tile_size) * (number + (1.0 / 2))), _tmp4_);
	if (inside) {
		_tmp5_ = y1;
	} else {
		_tmp5_ = y2;
	}
	cairo_line_to (cr, (*grid_border_main) + ((*tile_size) * (number + (2.0 / 3))), _tmp5_);
}

static void
taquin_view_move_cb (TaquinView* self,
                     gboolean x_axis,
                     gint8 number,
                     gint8 x_gap,
                     gint8 y_gap,
                     guint moves_count,
                     gboolean disable_animation)
{
	Game* _tmp0_;
	Game* _tmp1_;
	GameType _tmp2_;
	GameType _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->x_axis = x_axis;
	self->priv->number = (gint) number;
	self->priv->x_gap = x_gap;
	self->priv->y_gap = y_gap;
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_game_type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GAME_TYPE_FIFTEEN) {
		self->priv->x_arrow = x_gap;
		self->priv->y_arrow = y_gap;
	}
	if (disable_animation) {
		self->priv->finished = FALSE;
		self->priv->animation_end_offset = (gdouble) 0;
		self->priv->animate_end = FALSE;
	} else {
		self->priv->animation_offset = 0;
		self->priv->animate = TRUE;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
__lambda13_ (TaquinView* self)
{
	gboolean result;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->animate_end = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ ((TaquinView*) self);
	return result;
}

static void
taquin_view_complete_cb (TaquinView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->finished = TRUE;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda13__gsource_func, g_object_ref (self), g_object_unref);
}

static void
_taquin_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                       gint n_press,
                                                       gdouble x,
                                                       gdouble y,
                                                       gpointer self)
{
	taquin_view_on_click ((TaquinView*) self, _sender, n_press, x, y);
}

static void
taquin_view_init_mouse (TaquinView* self)
{
	GtkGestureMultiPress* _tmp0_;
	GtkGestureMultiPress* _tmp1_;
	GtkGestureMultiPress* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->click_controller);
	self->priv->click_controller = _tmp0_;
	_tmp1_ = self->priv->click_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp1_, (guint) 0);
	_tmp2_ = self->priv->click_controller;
	g_signal_connect_object (_tmp2_, "pressed", (GCallback) _taquin_view_on_click_gtk_gesture_multi_press_pressed, self, 0);
}

static inline void
taquin_view_on_click (TaquinView* self,
                      GtkGestureMultiPress* _click_controller,
                      gint n_press,
                      gdouble event_x,
                      gdouble event_y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint button = 0U;
	gboolean _tmp2_ = FALSE;
	Game* _tmp3_;
	Game* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_click_controller != NULL);
	if (self->priv->finished) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->animate;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->animate_end;
	}
	if (_tmp0_) {
		return;
	}
	button = gtk_gesture_single_get_current_button ((GtkGestureSingle*) _click_controller);
	if (button != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp2_ = button != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	self->priv->draw_lights = FALSE;
	_tmp3_ = taquin_view_get_game (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = taquin_view_get_x_offset (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = taquin_view_get_y_offset (self);
	_tmp8_ = _tmp7_;
	game_request_move (_tmp4_, (gint8) ((((gint) (((event_x - _tmp6_) - self->priv->grid_border_main) + self->priv->tile_size)) / self->priv->tile_size) - 1), (gint8) ((((gint) (((event_y - _tmp8_) - self->priv->grid_border_main) + self->priv->tile_size)) / self->priv->tile_size) - 1), FALSE);
}

static gboolean
_taquin_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                  guint keyval,
                                                                  guint keycode,
                                                                  GdkModifierType state,
                                                                  gpointer self)
{
	gboolean result;
	result = taquin_view_on_key_pressed ((TaquinView*) self, _sender, keyval, keycode, state);
	return result;
}

static void
taquin_view_init_keyboard (TaquinView* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect_object (_tmp1_, "key-pressed", (GCallback) _taquin_view_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
}

static inline gboolean
taquin_view_on_key_pressed (TaquinView* self,
                            GtkEventControllerKey* _key_controller,
                            guint keyval,
                            guint keycode,
                            GdkModifierType state)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* k_name = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_;
	Game* _tmp5_;
	GameType _tmp6_;
	GameType _tmp7_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	const gchar* _tmp31_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GQuark _tmp39_ = 0U;
	static GQuark _tmp38_label0 = 0;
	static GQuark _tmp38_label1 = 0;
	static GQuark _tmp38_label2 = 0;
	static GQuark _tmp38_label3 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	if (self->priv->finished) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	k_name = _tmp2_;
	_tmp4_ = taquin_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_game_type (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == GAME_TYPE_SIXTEEN) {
		gboolean _tmp8_ = FALSE;
		if ((state & GDK_SHIFT_MASK) > 0) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = (state & GDK_CONTROL_MASK) > 0;
		}
		_tmp3_ = _tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GQuark _tmp12_ = 0U;
		static GQuark _tmp11_label0 = 0;
		static GQuark _tmp11_label1 = 0;
		static GQuark _tmp11_label2 = 0;
		static GQuark _tmp11_label3 = 0;
		_tmp9_ = k_name;
		_tmp10_ = _tmp9_;
		_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
		if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("Left")))) {
			switch (0) {
				default:
				{
					Game* _tmp13_;
					Game* _tmp14_;
					_tmp13_ = taquin_view_get_game (self);
					_tmp14_ = _tmp13_;
					game_request_move (_tmp14_, (gint8) -1, self->priv->y_arrow, TRUE);
					break;
				}
			}
		} else if (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("Right")))) {
			switch (0) {
				default:
				{
					Game* _tmp15_;
					Game* _tmp16_;
					Game* _tmp17_;
					Game* _tmp18_;
					gint8 _tmp19_;
					gint8 _tmp20_;
					_tmp15_ = taquin_view_get_game (self);
					_tmp16_ = _tmp15_;
					_tmp17_ = taquin_view_get_game (self);
					_tmp18_ = _tmp17_;
					_tmp19_ = game_get_size (_tmp18_);
					_tmp20_ = _tmp19_;
					game_request_move (_tmp16_, _tmp20_, self->priv->y_arrow, TRUE);
					break;
				}
			}
		} else if (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("Up")))) {
			switch (0) {
				default:
				{
					Game* _tmp21_;
					Game* _tmp22_;
					_tmp21_ = taquin_view_get_game (self);
					_tmp22_ = _tmp21_;
					game_request_move (_tmp22_, self->priv->x_arrow, (gint8) -1, TRUE);
					break;
				}
			}
		} else if (_tmp12_ == ((0 != _tmp11_label3) ? _tmp11_label3 : (_tmp11_label3 = g_quark_from_static_string ("Down")))) {
			switch (0) {
				default:
				{
					Game* _tmp23_;
					Game* _tmp24_;
					Game* _tmp25_;
					Game* _tmp26_;
					gint8 _tmp27_;
					gint8 _tmp28_;
					_tmp23_ = taquin_view_get_game (self);
					_tmp24_ = _tmp23_;
					_tmp25_ = taquin_view_get_game (self);
					_tmp26_ = _tmp25_;
					_tmp27_ = game_get_size (_tmp26_);
					_tmp28_ = _tmp27_;
					game_request_move (_tmp24_, self->priv->x_arrow, _tmp28_, TRUE);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = FALSE;
					_g_free0 (k_name);
					return result;
				}
			}
		}
	}
	_tmp31_ = k_name;
	if (g_strcmp0 (_tmp31_, "space") == 0) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp32_;
		_tmp32_ = k_name;
		_tmp30_ = g_strcmp0 (_tmp32_, "KP_Enter") == 0;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		const gchar* _tmp33_;
		_tmp33_ = k_name;
		_tmp29_ = g_strcmp0 (_tmp33_, "Return") == 0;
	}
	if (_tmp29_) {
		Game* _tmp34_;
		Game* _tmp35_;
		_tmp34_ = taquin_view_get_game (self);
		_tmp35_ = _tmp34_;
		game_request_move (_tmp35_, self->priv->x_arrow, self->priv->y_arrow, TRUE);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp36_ = k_name;
	_tmp37_ = _tmp36_;
	_tmp39_ = (NULL == _tmp37_) ? 0 : g_quark_from_string (_tmp37_);
	if (_tmp39_ == ((0 != _tmp38_label0) ? _tmp38_label0 : (_tmp38_label0 = g_quark_from_static_string ("Left")))) {
		switch (0) {
			default:
			{
				if (((gint) self->priv->x_arrow) > 0) {
					gint8 _tmp40_;
					_tmp40_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp40_ - 1;
				}
				break;
			}
		}
	} else if (_tmp39_ == ((0 != _tmp38_label1) ? _tmp38_label1 : (_tmp38_label1 = g_quark_from_static_string ("Right")))) {
		switch (0) {
			default:
			{
				Game* _tmp41_;
				Game* _tmp42_;
				gint8 _tmp43_;
				gint8 _tmp44_;
				_tmp41_ = taquin_view_get_game (self);
				_tmp42_ = _tmp41_;
				_tmp43_ = game_get_size (_tmp42_);
				_tmp44_ = _tmp43_;
				if (((gint) self->priv->x_arrow) < (_tmp44_ - 1)) {
					gint8 _tmp45_;
					_tmp45_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp45_ + 1;
				}
				break;
			}
		}
	} else if (_tmp39_ == ((0 != _tmp38_label2) ? _tmp38_label2 : (_tmp38_label2 = g_quark_from_static_string ("Up")))) {
		switch (0) {
			default:
			{
				if (((gint) self->priv->y_arrow) > 0) {
					gint8 _tmp46_;
					_tmp46_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp46_ - 1;
				}
				break;
			}
		}
	} else if (_tmp39_ == ((0 != _tmp38_label3) ? _tmp38_label3 : (_tmp38_label3 = g_quark_from_static_string ("Down")))) {
		switch (0) {
			default:
			{
				Game* _tmp47_;
				Game* _tmp48_;
				gint8 _tmp49_;
				gint8 _tmp50_;
				_tmp47_ = taquin_view_get_game (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = game_get_size (_tmp48_);
				_tmp50_ = _tmp49_;
				if (((gint) self->priv->y_arrow) < (_tmp50_ - 1)) {
					gint8 _tmp51_;
					_tmp51_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp51_ + 1;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (k_name);
				return result;
			}
		}
	}
	self->priv->draw_lights = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_free0 (k_name);
	return result;
}

static gint
taquin_view_get_x_offset (TaquinView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gtk_widget_get_allocated_width ((GtkWidget*) self) - self->priv->board_size) / 2) - self->priv->grid_border_main;
	return result;
}

static gint
taquin_view_get_y_offset (TaquinView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gtk_widget_get_allocated_height ((GtkWidget*) self) - self->priv->board_size) / 2) - self->priv->grid_border_main;
	return result;
}

static Game*
taquin_view_get_game (TaquinView* self)
{
	Game* result;
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = self->priv->_game;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_GAME, Game);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_taquin_view_move_cb_game_move (Game* _sender,
                                gboolean x_axis,
                                gint8 number,
                                gint8 x_gap,
                                gint8 y_gap,
                                guint moves_count,
                                gboolean disable_animation,
                                gpointer self)
{
	taquin_view_move_cb ((TaquinView*) self, x_axis, number, x_gap, y_gap, moves_count, disable_animation);
}

static void
_taquin_view_complete_cb_game_complete (Game* _sender,
                                        gpointer self)
{
	taquin_view_complete_cb ((TaquinView*) self);
}

void
taquin_view_set_game (TaquinView* self,
                      Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	if (_tmp3_ == NULL) {
		g_assert_not_reached ();
	}
	self->priv->animate = FALSE;
	self->priv->finished = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->draw_lights = FALSE;
	self->priv->x_arrow = (gint8) 0;
	self->priv->y_arrow = (gint8) 0;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	taquin_view_configure (self);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_GAME, Game), "move", (GCallback) _taquin_view_move_cb_game_move, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_GAME, Game), "complete", (GCallback) _taquin_view_complete_cb_game_complete, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static const gchar*
taquin_view_get_theme (TaquinView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	if (_tmp0_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = self->priv->_theme;
	result = (const gchar*) _tmp1_;
	return result;
}

void
taquin_view_set_theme (TaquinView* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp0_;
	_tmp1_ = self->priv->_theme;
	if (_tmp1_ == NULL) {
		g_assert_not_reached ();
	}
	{
		GdkPixbuf* _tmp2_ = NULL;
		const gchar* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp3_ = self->priv->_theme;
		_tmp4_ = gdk_pixbuf_new_from_file ((const gchar*) _tmp3_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->unscaled_pixbuf);
		self->priv->unscaled_pixbuf = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp6_ = self->priv->_theme;
		g_critical ("taquin-view.vala:117: failed to load theme: %s", (const gchar*) _tmp6_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static GObject *
taquin_view_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TaquinView * self;
	parent_class = G_OBJECT_CLASS (taquin_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN_VIEW, TaquinView);
	taquin_view_init_keyboard (self);
	taquin_view_init_mouse (self);
	return obj;
}

static void
taquin_view_class_init (TaquinViewClass * klass,
                        gpointer klass_data)
{
	taquin_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TaquinView_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) taquin_view_real_configure_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) taquin_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_taquin_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_taquin_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = taquin_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = taquin_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_GAME_PROPERTY, taquin_view_properties[TAQUIN_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_THEME_PROPERTY, taquin_view_properties[TAQUIN_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
taquin_view_instance_init (TaquinView * self,
                           gpointer klass)
{
	self->priv = taquin_view_get_instance_private (self);
	self->priv->grid_border_thin = 6;
	self->priv->x_arrow = (gint8) 0;
	self->priv->y_arrow = (gint8) 0;
	self->priv->draw_lights = FALSE;
	self->priv->render_size = 0;
	self->priv->tiles_pattern = NULL;
	self->priv->animate = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->finished = FALSE;
	self->priv->_game = NULL;
	self->priv->unscaled_pixbuf = NULL;
	self->priv->_theme = NULL;
}

static void
taquin_view_finalize (GObject * obj)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN_VIEW, TaquinView);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	_g_object_unref0 (self->priv->_game);
	_g_object_unref0 (self->priv->unscaled_pixbuf);
	_g_free0 (self->priv->_theme);
	_g_object_unref0 (self->priv->click_controller);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (taquin_view_parent_class)->finalize (obj);
}

static GType
taquin_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TaquinViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaquinView), 0, (GInstanceInitFunc) taquin_view_instance_init, NULL };
	GType taquin_view_type_id;
	taquin_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "TaquinView", &g_define_type_info, 0);
	TaquinView_private_offset = g_type_add_instance_private (taquin_view_type_id, sizeof (TaquinViewPrivate));
	return taquin_view_type_id;
}

GType
taquin_view_get_type (void)
{
	static volatile gsize taquin_view_type_id__once = 0;
	if (g_once_init_enter (&taquin_view_type_id__once)) {
		GType taquin_view_type_id;
		taquin_view_type_id = taquin_view_get_type_once ();
		g_once_init_leave (&taquin_view_type_id__once, taquin_view_type_id);
	}
	return taquin_view_type_id__once;
}

static void
_vala_taquin_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME_PROPERTY:
		g_value_set_object (value, taquin_view_get_game (self));
		break;
		case TAQUIN_VIEW_THEME_PROPERTY:
		g_value_set_string (value, taquin_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_taquin_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME_PROPERTY:
		taquin_view_set_game (self, g_value_get_object (value));
		break;
		case TAQUIN_VIEW_THEME_PROPERTY:
		taquin_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

