/* cpu-graph.c generated by valac 0.56.18, the Vala compiler
 * generated from cpu-graph.vala, do not modify */

/* cpu-graph.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_GRAPH_VIEW (usage_graph_view_get_type ())
#define USAGE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphView))
#define USAGE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))
#define USAGE_IS_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_IS_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))

typedef struct _UsageGraphView UsageGraphView;
typedef struct _UsageGraphViewClass UsageGraphViewClass;
typedef struct _UsageGraphViewPrivate UsageGraphViewPrivate;

#define USAGE_TYPE_PERFORMANCE_GRAPH_VIEW (usage_performance_graph_view_get_type ())
#define USAGE_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphView))
#define USAGE_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_PERFORMANCE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))

typedef struct _UsagePerformanceGraphView UsagePerformanceGraphView;
typedef struct _UsagePerformanceGraphViewClass UsagePerformanceGraphViewClass;
typedef struct _UsagePerformanceGraphViewPrivate UsagePerformanceGraphViewPrivate;

#define USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE (usage_cpu_graph_most_used_core_get_type ())
#define USAGE_CPU_GRAPH_MOST_USED_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE, UsageCpuGraphMostUsedCore))
#define USAGE_CPU_GRAPH_MOST_USED_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE, UsageCpuGraphMostUsedCoreClass))
#define USAGE_IS_CPU_GRAPH_MOST_USED_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE))
#define USAGE_IS_CPU_GRAPH_MOST_USED_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE))
#define USAGE_CPU_GRAPH_MOST_USED_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE, UsageCpuGraphMostUsedCoreClass))

typedef struct _UsageCpuGraphMostUsedCore UsageCpuGraphMostUsedCore;
typedef struct _UsageCpuGraphMostUsedCoreClass UsageCpuGraphMostUsedCoreClass;
typedef struct _UsageCpuGraphMostUsedCorePrivate UsageCpuGraphMostUsedCorePrivate;

#define USAGE_TYPE_GRAPH (usage_graph_get_type ())
#define USAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH, UsageGraph))
#define USAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH, UsageGraphClass))
#define USAGE_IS_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH))
#define USAGE_IS_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH))
#define USAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH, UsageGraphClass))

typedef struct _UsageGraph UsageGraph;
typedef struct _UsageGraphClass UsageGraphClass;
enum  {
	USAGE_CPU_GRAPH_MOST_USED_CORE_0_PROPERTY,
	USAGE_CPU_GRAPH_MOST_USED_CORE_NUM_PROPERTIES
};
static GParamSpec* usage_cpu_graph_most_used_core_properties[USAGE_CPU_GRAPH_MOST_USED_CORE_NUM_PROPERTIES];
#define _usage_graph_unref0(var) ((var == NULL) ? NULL : (var = (usage_graph_unref (var), NULL)))

#define USAGE_TYPE_SYSTEM_MONITOR (usage_system_monitor_get_type ())
#define USAGE_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor))
#define USAGE_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))
#define USAGE_IS_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_IS_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_SYSTEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))

typedef struct _UsageSystemMonitor UsageSystemMonitor;
typedef struct _UsageSystemMonitorClass UsageSystemMonitorClass;

#define USAGE_TYPE_GRAPH_POINT (usage_graph_point_get_type ())
typedef struct _UsageGraphPoint UsageGraphPoint;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define USAGE_TYPE_CPU_GRAPH (usage_cpu_graph_get_type ())
#define USAGE_CPU_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_CPU_GRAPH, UsageCpuGraph))
#define USAGE_CPU_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_CPU_GRAPH, UsageCpuGraphClass))
#define USAGE_IS_CPU_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_CPU_GRAPH))
#define USAGE_IS_CPU_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_CPU_GRAPH))
#define USAGE_CPU_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_CPU_GRAPH, UsageCpuGraphClass))

typedef struct _UsageCpuGraph UsageCpuGraph;
typedef struct _UsageCpuGraphClass UsageCpuGraphClass;
typedef struct _UsageCpuGraphPrivate UsageCpuGraphPrivate;
enum  {
	USAGE_CPU_GRAPH_0_PROPERTY,
	USAGE_CPU_GRAPH_NUM_PROPERTIES
};
static GParamSpec* usage_cpu_graph_properties[USAGE_CPU_GRAPH_NUM_PROPERTIES];

struct _UsageGraphView {
	GtkWidget parent_instance;
	UsageGraphViewPrivate * priv;
	gint64 _offset_x;
	gint64 _range_x;
	gint64 _offset_y;
	gint64 _range_y;
};

struct _UsageGraphViewClass {
	GtkWidgetClass parent_class;
	gint64 (*get_offset_x) (UsageGraphView* self);
	void (*set_offset_x) (UsageGraphView* self, gint64 value);
};

struct _UsagePerformanceGraphView {
	UsageGraphView parent_instance;
	UsagePerformanceGraphViewPrivate * priv;
};

struct _UsagePerformanceGraphViewClass {
	UsageGraphViewClass parent_class;
	void (*update_graphs) (UsagePerformanceGraphView* self);
};

struct _UsageCpuGraphMostUsedCore {
	UsagePerformanceGraphView parent_instance;
	UsageCpuGraphMostUsedCorePrivate * priv;
};

struct _UsageCpuGraphMostUsedCoreClass {
	UsagePerformanceGraphViewClass parent_class;
};

struct _UsageCpuGraphMostUsedCorePrivate {
	UsageGraph* max_load_graph;
};

struct _UsageGraphPoint {
	gint64 timestamp;
	gdouble level;
};

struct _UsageCpuGraph {
	UsagePerformanceGraphView parent_instance;
	UsageCpuGraphPrivate * priv;
};

struct _UsageCpuGraphClass {
	UsagePerformanceGraphViewClass parent_class;
};

static gint UsageCpuGraphMostUsedCore_private_offset;
static gpointer usage_cpu_graph_most_used_core_parent_class = NULL;
static gpointer usage_cpu_graph_parent_class = NULL;

VALA_EXTERN GType usage_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphView, g_object_unref)
VALA_EXTERN GType usage_performance_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsagePerformanceGraphView, g_object_unref)
VALA_EXTERN GType usage_cpu_graph_most_used_core_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageCpuGraphMostUsedCore, g_object_unref)
VALA_EXTERN gpointer usage_graph_ref (gpointer instance);
VALA_EXTERN void usage_graph_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_graph (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_graph (GValue* value,
                            gpointer v_object);
VALA_EXTERN void usage_value_take_graph (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_graph (const GValue* value);
VALA_EXTERN GType usage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraph, usage_graph_unref)
VALA_EXTERN void usage_performance_graph_view_update_graphs (UsagePerformanceGraphView* self);
VALA_EXTERN UsageGraph* usage_graph_new (void);
VALA_EXTERN UsageGraph* usage_graph_construct (GType object_type);
VALA_EXTERN UsageCpuGraphMostUsedCore* usage_cpu_graph_most_used_core_new (void);
VALA_EXTERN UsageCpuGraphMostUsedCore* usage_cpu_graph_most_used_core_construct (GType object_type);
VALA_EXTERN UsagePerformanceGraphView* usage_performance_graph_view_construct (GType object_type);
VALA_EXTERN void usage_performance_graph_view_add_graph (UsagePerformanceGraphView* self,
                                             UsageGraph* graph);
static void usage_cpu_graph_most_used_core_real_update_graphs (UsagePerformanceGraphView* base);
VALA_EXTERN GType usage_system_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSystemMonitor, g_object_unref)
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_get_default (void);
VALA_EXTERN gdouble* usage_system_monitor_get_x_cpu_load (UsageSystemMonitor* self,
                                              gint* result_length1);
VALA_EXTERN GType usage_graph_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageGraphPoint* usage_graph_point_dup (const UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_free (UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_init (UsageGraphPoint *self,
                             gint64 timestamp,
                             gdouble level);
VALA_EXTERN void usage_graph_push_point (UsageGraph* self,
                             UsageGraphPoint* point);
static void usage_cpu_graph_most_used_core_finalize (GObject * obj);
static GType usage_cpu_graph_most_used_core_get_type_once (void);
VALA_EXTERN GType usage_cpu_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageCpuGraph, g_object_unref)
VALA_EXTERN UsageCpuGraph* usage_cpu_graph_new (void);
VALA_EXTERN UsageCpuGraph* usage_cpu_graph_construct (GType object_type);
static void usage_cpu_graph_real_update_graphs (UsagePerformanceGraphView* base);
VALA_EXTERN UsageGraph* usage_graph_view_get_graph (UsageGraphView* self,
                                        gint i);
static GType usage_cpu_graph_get_type_once (void);

static inline gpointer
usage_cpu_graph_most_used_core_get_instance_private (UsageCpuGraphMostUsedCore* self)
{
	return G_STRUCT_MEMBER_P (self, UsageCpuGraphMostUsedCore_private_offset);
}

UsageCpuGraphMostUsedCore*
usage_cpu_graph_most_used_core_construct (GType object_type)
{
	UsageCpuGraphMostUsedCore * self = NULL;
	UsageGraph* _tmp0_;
	self = (UsageCpuGraphMostUsedCore*) usage_performance_graph_view_construct (object_type);
	_tmp0_ = self->priv->max_load_graph;
	usage_performance_graph_view_add_graph ((UsagePerformanceGraphView*) self, _tmp0_);
	return self;
}

UsageCpuGraphMostUsedCore*
usage_cpu_graph_most_used_core_new (void)
{
	return usage_cpu_graph_most_used_core_construct (USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE);
}

static void
usage_cpu_graph_most_used_core_real_update_graphs (UsagePerformanceGraphView* base)
{
	UsageCpuGraphMostUsedCore * self;
	UsageSystemMonitor* monitor = NULL;
	UsageSystemMonitor* _tmp0_;
	gint64 timestamp = 0LL;
	gdouble most_used_core = 0.0;
	UsageSystemMonitor* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gint _tmp4__length1;
	gdouble _tmp5_;
	UsageGraphPoint point = {0};
	UsageGraph* _tmp18_;
	UsageGraphPoint _tmp19_;
	self = (UsageCpuGraphMostUsedCore*) base;
	_tmp0_ = usage_system_monitor_get_default ();
	monitor = _tmp0_;
	timestamp = g_get_monotonic_time ();
	_tmp1_ = monitor;
	_tmp2_ = usage_system_monitor_get_x_cpu_load (_tmp1_, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = _tmp4_[0];
	most_used_core = _tmp5_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				UsageSystemMonitor* _tmp8_;
				gdouble* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_ = 0;
				gdouble* _tmp11_;
				gint _tmp11__length1;
				gdouble _tmp12_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(((guint) i) < g_get_num_processors ())) {
					break;
				}
				_tmp8_ = monitor;
				_tmp9_ = usage_system_monitor_get_x_cpu_load (_tmp8_, &_tmp10_);
				_tmp9__length1 = _tmp10_;
				_tmp11_ = _tmp9_;
				_tmp11__length1 = _tmp9__length1;
				_tmp12_ = _tmp11_[i];
				if (_tmp12_ > most_used_core) {
					UsageSystemMonitor* _tmp13_;
					gdouble* _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_ = 0;
					gdouble* _tmp16_;
					gint _tmp16__length1;
					gdouble _tmp17_;
					_tmp13_ = monitor;
					_tmp14_ = usage_system_monitor_get_x_cpu_load (_tmp13_, &_tmp15_);
					_tmp14__length1 = _tmp15_;
					_tmp16_ = _tmp14_;
					_tmp16__length1 = _tmp14__length1;
					_tmp17_ = _tmp16_[i];
					most_used_core = _tmp17_;
				}
			}
		}
	}
	usage_graph_point_init (&point, timestamp, most_used_core);
	_tmp18_ = self->priv->max_load_graph;
	_tmp19_ = point;
	usage_graph_push_point (_tmp18_, &_tmp19_);
	_g_object_unref0 (monitor);
}

static void
usage_cpu_graph_most_used_core_class_init (UsageCpuGraphMostUsedCoreClass * klass,
                                           gpointer klass_data)
{
	usage_cpu_graph_most_used_core_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageCpuGraphMostUsedCore_private_offset);
	((UsagePerformanceGraphViewClass *) klass)->update_graphs = (void (*) (UsagePerformanceGraphView*)) usage_cpu_graph_most_used_core_real_update_graphs;
	G_OBJECT_CLASS (klass)->finalize = usage_cpu_graph_most_used_core_finalize;
}

static void
usage_cpu_graph_most_used_core_instance_init (UsageCpuGraphMostUsedCore * self,
                                              gpointer klass)
{
	UsageGraph* _tmp0_;
	self->priv = usage_cpu_graph_most_used_core_get_instance_private (self);
	_tmp0_ = usage_graph_new ();
	self->priv->max_load_graph = _tmp0_;
}

static void
usage_cpu_graph_most_used_core_finalize (GObject * obj)
{
	UsageCpuGraphMostUsedCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_CPU_GRAPH_MOST_USED_CORE, UsageCpuGraphMostUsedCore);
	_usage_graph_unref0 (self->priv->max_load_graph);
	G_OBJECT_CLASS (usage_cpu_graph_most_used_core_parent_class)->finalize (obj);
}

/**
 *  Graph showing most used core
**/
static GType
usage_cpu_graph_most_used_core_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageCpuGraphMostUsedCoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_cpu_graph_most_used_core_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageCpuGraphMostUsedCore), 0, (GInstanceInitFunc) usage_cpu_graph_most_used_core_instance_init, NULL };
	GType usage_cpu_graph_most_used_core_type_id;
	usage_cpu_graph_most_used_core_type_id = g_type_register_static (USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, "UsageCpuGraphMostUsedCore", &g_define_type_info, 0);
	UsageCpuGraphMostUsedCore_private_offset = g_type_add_instance_private (usage_cpu_graph_most_used_core_type_id, sizeof (UsageCpuGraphMostUsedCorePrivate));
	return usage_cpu_graph_most_used_core_type_id;
}

GType
usage_cpu_graph_most_used_core_get_type (void)
{
	static volatile gsize usage_cpu_graph_most_used_core_type_id__once = 0;
	if (g_once_init_enter (&usage_cpu_graph_most_used_core_type_id__once)) {
		GType usage_cpu_graph_most_used_core_type_id;
		usage_cpu_graph_most_used_core_type_id = usage_cpu_graph_most_used_core_get_type_once ();
		g_once_init_leave (&usage_cpu_graph_most_used_core_type_id__once, usage_cpu_graph_most_used_core_type_id);
	}
	return usage_cpu_graph_most_used_core_type_id__once;
}

UsageCpuGraph*
usage_cpu_graph_construct (GType object_type)
{
	UsageCpuGraph * self = NULL;
	self = (UsageCpuGraph*) usage_performance_graph_view_construct (object_type);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				UsageGraph* graph = NULL;
				UsageGraph* _tmp2_;
				UsageGraph* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < g_get_num_processors ())) {
					break;
				}
				_tmp2_ = usage_graph_new ();
				graph = _tmp2_;
				_tmp3_ = graph;
				usage_performance_graph_view_add_graph ((UsagePerformanceGraphView*) self, _tmp3_);
				_usage_graph_unref0 (graph);
			}
		}
	}
	gtk_widget_add_css_class ((GtkWidget*) self, "big");
	return self;
}

UsageCpuGraph*
usage_cpu_graph_new (void)
{
	return usage_cpu_graph_construct (USAGE_TYPE_CPU_GRAPH);
}

static void
usage_cpu_graph_real_update_graphs (UsagePerformanceGraphView* base)
{
	UsageCpuGraph * self;
	UsageSystemMonitor* monitor = NULL;
	UsageSystemMonitor* _tmp0_;
	gint64 timestamp = 0LL;
	self = (UsageCpuGraph*) base;
	_tmp0_ = usage_system_monitor_get_default ();
	monitor = _tmp0_;
	timestamp = g_get_monotonic_time ();
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				UsageGraphPoint point = {0};
				UsageSystemMonitor* _tmp3_;
				gdouble* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_ = 0;
				gdouble* _tmp6_;
				gint _tmp6__length1;
				gdouble _tmp7_;
				UsageGraph* _tmp8_;
				UsageGraph* _tmp9_;
				UsageGraphPoint _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < g_get_num_processors ())) {
					break;
				}
				_tmp3_ = monitor;
				_tmp4_ = usage_system_monitor_get_x_cpu_load (_tmp3_, &_tmp5_);
				_tmp4__length1 = _tmp5_;
				_tmp6_ = _tmp4_;
				_tmp6__length1 = _tmp4__length1;
				_tmp7_ = _tmp6_[i];
				usage_graph_point_init (&point, timestamp, _tmp7_);
				_tmp8_ = usage_graph_view_get_graph ((UsageGraphView*) self, i);
				_tmp9_ = _tmp8_;
				_tmp10_ = point;
				usage_graph_push_point (_tmp9_, &_tmp10_);
				_usage_graph_unref0 (_tmp9_);
			}
		}
	}
	_g_object_unref0 (monitor);
}

static void
usage_cpu_graph_class_init (UsageCpuGraphClass * klass,
                            gpointer klass_data)
{
	usage_cpu_graph_parent_class = g_type_class_peek_parent (klass);
	((UsagePerformanceGraphViewClass *) klass)->update_graphs = (void (*) (UsagePerformanceGraphView*)) usage_cpu_graph_real_update_graphs;
}

static void
usage_cpu_graph_instance_init (UsageCpuGraph * self,
                               gpointer klass)
{
}

/**
 *  Graph showing all processor cores.
**/
static GType
usage_cpu_graph_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageCpuGraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_cpu_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageCpuGraph), 0, (GInstanceInitFunc) usage_cpu_graph_instance_init, NULL };
	GType usage_cpu_graph_type_id;
	usage_cpu_graph_type_id = g_type_register_static (USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, "UsageCpuGraph", &g_define_type_info, 0);
	return usage_cpu_graph_type_id;
}

GType
usage_cpu_graph_get_type (void)
{
	static volatile gsize usage_cpu_graph_type_id__once = 0;
	if (g_once_init_enter (&usage_cpu_graph_type_id__once)) {
		GType usage_cpu_graph_type_id;
		usage_cpu_graph_type_id = usage_cpu_graph_get_type_once ();
		g_once_init_leave (&usage_cpu_graph_type_id__once, usage_cpu_graph_type_id);
	}
	return usage_cpu_graph_type_id__once;
}

