/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, network, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_network_udp_sink = R"doc(This block provides a UDP Sink block that can send data over UDP streams to a specified host.

This block provides a UDP sink that supports sending data over a UDP stream to external applications. A number of header formats are supported including None (raw stream), and other header formats that allow for sequence numbers to be tracked. This feature allows the recipient to be aware of any frames dropped in transit or by its receiving stack. The UDP packet size can also be adjusted to support jumbo frames. For most networks, 1472 is the correct UDP data packet size that optimizes network transmission. Adjusting this value without a full understanding of the network implications can create additional network fragmentation and inefficient packet usage so should be avoided. For networks and endpoints supporting jumbo frames of 9000, 8972 would be the appropriate size (9000 - 28 header bytes). If send NULL packet as EOF is set, when the flowgraph terminates, an empty UDP packet is sent. This can be used on the receiving side to be aware that no more data may be received from the sending application. When pairing with the GNU Radio UDP source block, this isn't necessary and the source block can simply be set to source zero's when an incoming network data stream is not present in order to continue returning data from the work function. This block also supports IPv4 and IPv6 addresses and is automatically determined from the address provided.

Constructor Specific Documentation:

Build a udp_sink block.

Args:
    itemsize : 
    veclen : 
    host : 
    port : 
    header_type : 
    payloadsize : 
    send_eof : )doc";


static const char* __doc_gr_network_udp_sink_udp_sink = R"doc()doc";


static const char* __doc_gr_network_udp_sink_make = R"doc(This block provides a UDP Sink block that can send data over UDP streams to a specified host.

This block provides a UDP sink that supports sending data over a UDP stream to external applications. A number of header formats are supported including None (raw stream), and other header formats that allow for sequence numbers to be tracked. This feature allows the recipient to be aware of any frames dropped in transit or by its receiving stack. The UDP packet size can also be adjusted to support jumbo frames. For most networks, 1472 is the correct UDP data packet size that optimizes network transmission. Adjusting this value without a full understanding of the network implications can create additional network fragmentation and inefficient packet usage so should be avoided. For networks and endpoints supporting jumbo frames of 9000, 8972 would be the appropriate size (9000 - 28 header bytes). If send NULL packet as EOF is set, when the flowgraph terminates, an empty UDP packet is sent. This can be used on the receiving side to be aware that no more data may be received from the sending application. When pairing with the GNU Radio UDP source block, this isn't necessary and the source block can simply be set to source zero's when an incoming network data stream is not present in order to continue returning data from the work function. This block also supports IPv4 and IPv6 addresses and is automatically determined from the address provided.

Constructor Specific Documentation:

Build a udp_sink block.

Args:
    itemsize : 
    veclen : 
    host : 
    port : 
    header_type : 
    payloadsize : 
    send_eof : )doc";
