/* gpx-point.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-point.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define _XOPEN_SOURCE

#include "gpx.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GpxParamSpecPoint GpxParamSpecPoint;

struct _GpxPointPrivate {
	gchar* _name;
	gchar* _description;
	time_t utime;
	GDateTime* datetime;
};

struct _GpxParamSpecPoint {
	GParamSpec parent_instance;
};

static gint GpxPoint_private_offset;
static gpointer gpx_point_parent_class = NULL;

static void gpx_point_finalize (GpxPoint * obj);
static GType gpx_point_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GpxHeartRateMonitorPoint*
gpx_heart_rate_monitor_point_dup (const GpxHeartRateMonitorPoint* self)
{
	GpxHeartRateMonitorPoint* dup;
#line 22 "../gpx-viewer/libgpx/gpx-point.vala"
	dup = g_new0 (GpxHeartRateMonitorPoint, 1);
#line 22 "../gpx-viewer/libgpx/gpx-point.vala"
	memcpy (dup, self, sizeof (GpxHeartRateMonitorPoint));
#line 22 "../gpx-viewer/libgpx/gpx-point.vala"
	return dup;
#line 78 "gpx-point.c"
}

void
gpx_heart_rate_monitor_point_free (GpxHeartRateMonitorPoint* self)
{
#line 22 "../gpx-viewer/libgpx/gpx-point.vala"
	g_free (self);
#line 86 "gpx-point.c"
}

static GType
gpx_heart_rate_monitor_point_get_type_once (void)
{
	GType gpx_heart_rate_monitor_point_type_id;
	gpx_heart_rate_monitor_point_type_id = g_boxed_type_register_static ("GpxHeartRateMonitorPoint", (GBoxedCopyFunc) gpx_heart_rate_monitor_point_dup, (GBoxedFreeFunc) gpx_heart_rate_monitor_point_free);
	return gpx_heart_rate_monitor_point_type_id;
}

GType
gpx_heart_rate_monitor_point_get_type (void)
{
	static volatile gsize gpx_heart_rate_monitor_point_type_id__once = 0;
	if (g_once_init_enter (&gpx_heart_rate_monitor_point_type_id__once)) {
		GType gpx_heart_rate_monitor_point_type_id;
		gpx_heart_rate_monitor_point_type_id = gpx_heart_rate_monitor_point_get_type_once ();
		g_once_init_leave (&gpx_heart_rate_monitor_point_type_id__once, gpx_heart_rate_monitor_point_type_id);
	}
	return gpx_heart_rate_monitor_point_type_id__once;
}

static inline gpointer
gpx_point_get_instance_private (GpxPoint* self)
{
	return G_STRUCT_MEMBER_P (self, GpxPoint_private_offset);
}

gboolean
gpx_point_has_position (GpxPoint* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 65 "../gpx-viewer/libgpx/gpx-point.vala"
	if (self->lat == ((gdouble) 1000)) {
#line 65 "../gpx-viewer/libgpx/gpx-point.vala"
		_tmp0_ = TRUE;
#line 124 "gpx-point.c"
	} else {
#line 65 "../gpx-viewer/libgpx/gpx-point.vala"
		_tmp0_ = self->lon == ((gdouble) 1000);
#line 128 "gpx-point.c"
	}
#line 65 "../gpx-viewer/libgpx/gpx-point.vala"
	result = !_tmp0_;
#line 65 "../gpx-viewer/libgpx/gpx-point.vala"
	return result;
#line 134 "gpx-point.c"
}

/**
         * Make a clean copy off the point.
         * Only position and time is copied.
         */
GpxPoint*
gpx_point_copy (GpxPoint* self)
{
	GpxPoint* p = NULL;
	GpxPoint* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GpxHeartRateMonitorPoint _tmp5_;
	GpxPoint* result;
#line 74 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_ = gpx_point_new ();
#line 74 "../gpx-viewer/libgpx/gpx-point.vala"
	p = _tmp0_;
#line 75 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp1_ = self->priv->_name;
#line 75 "../gpx-viewer/libgpx/gpx-point.vala"
	gpx_point_set_name (p, _tmp1_);
#line 76 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp2_ = self->priv->_description;
#line 76 "../gpx-viewer/libgpx/gpx-point.vala"
	gpx_point_set_description (p, _tmp2_);
#line 77 "../gpx-viewer/libgpx/gpx-point.vala"
	p->lat = self->lat;
#line 78 "../gpx-viewer/libgpx/gpx-point.vala"
	p->lon = self->lon;
#line 79 "../gpx-viewer/libgpx/gpx-point.vala"
	p->lat_dec = self->lat_dec;
#line 80 "../gpx-viewer/libgpx/gpx-point.vala"
	p->lon_dec = self->lon_dec;
#line 81 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp3_ = self->time;
#line 81 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 81 "../gpx-viewer/libgpx/gpx-point.vala"
	_g_free0 (p->time);
#line 81 "../gpx-viewer/libgpx/gpx-point.vala"
	p->time = _tmp4_;
#line 82 "../gpx-viewer/libgpx/gpx-point.vala"
	p->elevation = self->elevation;
#line 83 "../gpx-viewer/libgpx/gpx-point.vala"
	p->smooth_elevation = self->smooth_elevation;
#line 84 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp5_ = self->tpe;
#line 84 "../gpx-viewer/libgpx/gpx-point.vala"
	p->tpe = _tmp5_;
#line 85 "../gpx-viewer/libgpx/gpx-point.vala"
	result = p;
#line 85 "../gpx-viewer/libgpx/gpx-point.vala"
	return result;
#line 192 "gpx-point.c"
}

void
gpx_point_set_position_lat (GpxPoint* self,
                            gdouble lat_d)
{
#line 89 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lat_dec = lat_d;
#line 90 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lat = ((2 * G_PI) * lat_d) / 360.0;
#line 203 "gpx-point.c"
}

void
gpx_point_set_position_lon (GpxPoint* self,
                            gdouble lon_d)
{
#line 94 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lon_dec = lon_d;
#line 95 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lon = ((2 * G_PI) * lon_d) / 360.0;
#line 214 "gpx-point.c"
}

void
gpx_point_set_position (GpxPoint* self,
                        gdouble lat,
                        gdouble lon)
{
#line 100 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lat_dec = lat;
#line 101 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lon_dec = lon;
#line 102 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lat = ((2 * G_PI) * lat) / 360.0;
#line 103 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lon = ((2 * G_PI) * lon) / 360.0;
#line 230 "gpx-point.c"
}

void
gpx_point_set_utime (GpxPoint* self,
                     time_t ut)
{
#line 108 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv->utime = ut;
#line 239 "gpx-point.c"
}

time_t
gpx_point_get_time (GpxPoint* self)
{
	const gchar* _tmp0_;
	struct tm ta = {0};
	const gchar* _tmp1_;
	time_t result;
#line 112 "../gpx-viewer/libgpx/gpx-point.vala"
	if (self->priv->utime > ((time_t) 0)) {
#line 113 "../gpx-viewer/libgpx/gpx-point.vala"
		result = self->priv->utime;
#line 113 "../gpx-viewer/libgpx/gpx-point.vala"
		return result;
#line 255 "gpx-point.c"
	}
#line 114 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_ = self->time;
#line 114 "../gpx-viewer/libgpx/gpx-point.vala"
	if (_tmp0_ == NULL) {
#line 114 "../gpx-viewer/libgpx/gpx-point.vala"
		result = (time_t) 0;
#line 114 "../gpx-viewer/libgpx/gpx-point.vala"
		return result;
#line 265 "gpx-point.c"
	}
#line 115 "../gpx-viewer/libgpx/gpx-point.vala"
	memset (&ta, 0, sizeof (struct tm));
#line 116 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp1_ = self->time;
#line 116 "../gpx-viewer/libgpx/gpx-point.vala"
	strptime (_tmp1_, "%FT%T%z", &ta);
#line 117 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv->utime = mktime (&ta);
#line 118 "../gpx-viewer/libgpx/gpx-point.vala"
	result = self->priv->utime;
#line 118 "../gpx-viewer/libgpx/gpx-point.vala"
	return result;
#line 279 "gpx-point.c"
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
#line 124 "../gpx-viewer/libgpx/gpx-point.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 287 "gpx-point.c"
}

GDateTime*
gpx_point_get_datetime (GpxPoint* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* result;
#line 122 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_ = self->priv->datetime;
#line 122 "../gpx-viewer/libgpx/gpx-point.vala"
	if (_tmp0_ == NULL) {
#line 301 "gpx-point.c"
		GDateTime* _tmp1_;
#line 123 "../gpx-viewer/libgpx/gpx-point.vala"
		_tmp1_ = g_date_time_new_from_unix_utc ((gint64) gpx_point_get_time (self));
#line 123 "../gpx-viewer/libgpx/gpx-point.vala"
		_g_date_time_unref0 (self->priv->datetime);
#line 123 "../gpx-viewer/libgpx/gpx-point.vala"
		self->priv->datetime = _tmp1_;
#line 309 "gpx-point.c"
	}
#line 124 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp2_ = self->priv->datetime;
#line 124 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
#line 124 "../gpx-viewer/libgpx/gpx-point.vala"
	result = _tmp3_;
#line 124 "../gpx-viewer/libgpx/gpx-point.vala"
	return result;
#line 319 "gpx-point.c"
}

GpxPoint*
gpx_point_construct (GType object_type)
{
	GpxPoint* self = NULL;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	self = (GpxPoint*) g_type_create_instance (object_type);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return self;
#line 330 "gpx-point.c"
}

GpxPoint*
gpx_point_new (void)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return gpx_point_construct (GPX_TYPE_POINT);
#line 338 "gpx-point.c"
}

const gchar*
gpx_point_get_name (GpxPoint* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_ = self->priv->_name;
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	result = _tmp0_;
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	return result;
#line 352 "gpx-point.c"
}

void
gpx_point_set_name (GpxPoint* self,
                    const gchar* value)
{
	gchar* _tmp0_;
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_ = g_strdup (value);
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	_g_free0 (self->priv->_name);
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv->_name = _tmp0_;
#line 366 "gpx-point.c"
}

const gchar*
gpx_point_get_description (GpxPoint* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_ = self->priv->_description;
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	result = _tmp0_;
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	return result;
#line 380 "gpx-point.c"
}

void
gpx_point_set_description (GpxPoint* self,
                           const gchar* value)
{
	gchar* _tmp0_;
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_ = g_strdup (value);
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	_g_free0 (self->priv->_description);
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv->_description = _tmp0_;
#line 394 "gpx-point.c"
}

static void
gpx_value_point_init (GValue* value)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	value->data[0].v_pointer = NULL;
#line 402 "gpx-point.c"
}

static void
gpx_value_point_free_value (GValue* value)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (value->data[0].v_pointer) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		gpx_point_unref (value->data[0].v_pointer);
#line 412 "gpx-point.c"
	}
}

static void
gpx_value_point_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (src_value->data[0].v_pointer) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		dest_value->data[0].v_pointer = gpx_point_ref (src_value->data[0].v_pointer);
#line 424 "gpx-point.c"
	} else {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		dest_value->data[0].v_pointer = NULL;
#line 428 "gpx-point.c"
	}
}

static gpointer
gpx_value_point_peek_pointer (const GValue* value)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return value->data[0].v_pointer;
#line 437 "gpx-point.c"
}

static gchar*
gpx_value_point_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (collect_values[0].v_pointer) {
#line 448 "gpx-point.c"
		GpxPoint * object;
		object = collect_values[0].v_pointer;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		if (object->parent_instance.g_class == NULL) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 455 "gpx-point.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 459 "gpx-point.c"
		}
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		value->data[0].v_pointer = gpx_point_ref (object);
#line 463 "gpx-point.c"
	} else {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		value->data[0].v_pointer = NULL;
#line 467 "gpx-point.c"
	}
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return NULL;
#line 471 "gpx-point.c"
}

static gchar*
gpx_value_point_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	GpxPoint ** object_p;
	object_p = collect_values[0].v_pointer;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (!object_p) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 486 "gpx-point.c"
	}
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (!value->data[0].v_pointer) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		*object_p = NULL;
#line 492 "gpx-point.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		*object_p = value->data[0].v_pointer;
#line 496 "gpx-point.c"
	} else {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		*object_p = gpx_point_ref (value->data[0].v_pointer);
#line 500 "gpx-point.c"
	}
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return NULL;
#line 504 "gpx-point.c"
}

GParamSpec*
gpx_param_spec_point (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	GpxParamSpecPoint* spec;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GPX_TYPE_POINT), NULL);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return G_PARAM_SPEC (spec);
#line 523 "gpx-point.c"
}

gpointer
gpx_value_get_point (const GValue* value)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPX_TYPE_POINT), NULL);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return value->data[0].v_pointer;
#line 533 "gpx-point.c"
}

void
gpx_value_set_point (GValue* value,
                     gpointer v_object)
{
	GpxPoint * old;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPX_TYPE_POINT));
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	old = value->data[0].v_pointer;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (v_object) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GPX_TYPE_POINT));
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		value->data[0].v_pointer = v_object;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		gpx_point_ref (value->data[0].v_pointer);
#line 555 "gpx-point.c"
	} else {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		value->data[0].v_pointer = NULL;
#line 559 "gpx-point.c"
	}
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (old) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		gpx_point_unref (old);
#line 565 "gpx-point.c"
	}
}

void
gpx_value_take_point (GValue* value,
                      gpointer v_object)
{
	GpxPoint * old;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPX_TYPE_POINT));
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	old = value->data[0].v_pointer;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (v_object) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GPX_TYPE_POINT));
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		value->data[0].v_pointer = v_object;
#line 586 "gpx-point.c"
	} else {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		value->data[0].v_pointer = NULL;
#line 590 "gpx-point.c"
	}
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (old) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		gpx_point_unref (old);
#line 596 "gpx-point.c"
	}
}

static void
gpx_point_class_init (GpxPointClass * klass,
                      gpointer klass_data)
{
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	gpx_point_parent_class = g_type_class_peek_parent (klass);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	((GpxPointClass *) klass)->finalize = gpx_point_finalize;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	g_type_class_adjust_private_offset (klass, &GpxPoint_private_offset);
#line 610 "gpx-point.c"
}

static void
gpx_point_instance_init (GpxPoint * self,
                         gpointer klass)
{
	GpxHeartRateMonitorPoint _tmp0_ = {0};
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv = gpx_point_get_instance_private (self);
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv->_name = NULL;
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv->_description = NULL;
#line 36 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lat = (gdouble) 1000;
#line 37 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lon = (gdouble) 1000;
#line 38 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lat_dec = (gdouble) 1000;
#line 39 "../gpx-viewer/libgpx/gpx-point.vala"
	self->lon_dec = (gdouble) 1000;
#line 41 "../gpx-viewer/libgpx/gpx-point.vala"
	self->distance = (gdouble) 0;
#line 48 "../gpx-viewer/libgpx/gpx-point.vala"
	self->speed = (gdouble) 0;
#line 50 "../gpx-viewer/libgpx/gpx-point.vala"
	self->stopped = FALSE;
#line 52 "../gpx-viewer/libgpx/gpx-point.vala"
	self->priv->utime = (time_t) 0;
#line 55 "../gpx-viewer/libgpx/gpx-point.vala"
	self->cadence = (guint32) 0;
#line 58 "../gpx-viewer/libgpx/gpx-point.vala"
	memset (&_tmp0_, 0, sizeof (GpxHeartRateMonitorPoint));
#line 58 "../gpx-viewer/libgpx/gpx-point.vala"
	_tmp0_.heartrate = 0;
#line 58 "../gpx-viewer/libgpx/gpx-point.vala"
	self->tpe = _tmp0_;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	self->ref_count = 1;
#line 650 "gpx-point.c"
}

static void
gpx_point_finalize (GpxPoint * obj)
{
	GpxPoint * self;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_POINT, GpxPoint);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	g_signal_handlers_destroy (self);
#line 33 "../gpx-viewer/libgpx/gpx-point.vala"
	_g_free0 (self->priv->_name);
#line 34 "../gpx-viewer/libgpx/gpx-point.vala"
	_g_free0 (self->priv->_description);
#line 46 "../gpx-viewer/libgpx/gpx-point.vala"
	_g_free0 (self->time);
#line 53 "../gpx-viewer/libgpx/gpx-point.vala"
	_g_date_time_unref0 (self->priv->datetime);
#line 669 "gpx-point.c"
}

/**
     * Represents a point in the track or a waypoint.
     */
static GType
gpx_point_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gpx_value_point_init, gpx_value_point_free_value, gpx_value_point_copy_value, gpx_value_point_peek_pointer, "p", gpx_value_point_collect_value, "p", gpx_value_point_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GpxPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxPoint), 0, (GInstanceInitFunc) gpx_point_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gpx_point_type_id;
	gpx_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GpxPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GpxPoint_private_offset = g_type_add_instance_private (gpx_point_type_id, sizeof (GpxPointPrivate));
	return gpx_point_type_id;
}

GType
gpx_point_get_type (void)
{
	static volatile gsize gpx_point_type_id__once = 0;
	if (g_once_init_enter (&gpx_point_type_id__once)) {
		GType gpx_point_type_id;
		gpx_point_type_id = gpx_point_get_type_once ();
		g_once_init_leave (&gpx_point_type_id__once, gpx_point_type_id);
	}
	return gpx_point_type_id__once;
}

gpointer
gpx_point_ref (gpointer instance)
{
	GpxPoint * self;
	self = instance;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	g_atomic_int_inc (&self->ref_count);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	return instance;
#line 708 "gpx-point.c"
}

void
gpx_point_unref (gpointer instance)
{
	GpxPoint * self;
	self = instance;
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		GPX_POINT_GET_CLASS (self)->finalize (self);
#line 30 "../gpx-viewer/libgpx/gpx-point.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 722 "gpx-point.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

