// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportPartialSuccess represents the details of a partially successful export request.
type ExportProfilesPartialSuccess struct {
	RejectedProfiles int64
	ErrorMessage     string
}

var (
	protoPoolExportProfilesPartialSuccess = sync.Pool{
		New: func() any {
			return &ExportProfilesPartialSuccess{}
		},
	}
)

func NewExportProfilesPartialSuccess() *ExportProfilesPartialSuccess {
	if !UseProtoPooling.IsEnabled() {
		return &ExportProfilesPartialSuccess{}
	}
	return protoPoolExportProfilesPartialSuccess.Get().(*ExportProfilesPartialSuccess)
}

func DeleteExportProfilesPartialSuccess(orig *ExportProfilesPartialSuccess, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolExportProfilesPartialSuccess.Put(orig)
	}
}

func CopyExportProfilesPartialSuccess(dest, src *ExportProfilesPartialSuccess) *ExportProfilesPartialSuccess {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportProfilesPartialSuccess()
	}
	dest.RejectedProfiles = src.RejectedProfiles

	dest.ErrorMessage = src.ErrorMessage

	return dest
}

func CopyExportProfilesPartialSuccessSlice(dest, src []ExportProfilesPartialSuccess) []ExportProfilesPartialSuccess {
	var newDest []ExportProfilesPartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]ExportProfilesPartialSuccess, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportProfilesPartialSuccess(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportProfilesPartialSuccess(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportProfilesPartialSuccessPtrSlice(dest, src []*ExportProfilesPartialSuccess) []*ExportProfilesPartialSuccess {
	var newDest []*ExportProfilesPartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]*ExportProfilesPartialSuccess, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportProfilesPartialSuccess()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportProfilesPartialSuccess(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportProfilesPartialSuccess()
		}
	}
	for i := range src {
		CopyExportProfilesPartialSuccess(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportProfilesPartialSuccess) Reset() {
	*orig = ExportProfilesPartialSuccess{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportProfilesPartialSuccess) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RejectedProfiles != int64(0) {
		dest.WriteObjectField("rejectedProfiles")
		dest.WriteInt64(orig.RejectedProfiles)
	}
	if orig.ErrorMessage != "" {
		dest.WriteObjectField("errorMessage")
		dest.WriteString(orig.ErrorMessage)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportProfilesPartialSuccess) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "rejectedProfiles", "rejected_profiles":
			orig.RejectedProfiles = iter.ReadInt64()
		case "errorMessage", "error_message":
			orig.ErrorMessage = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportProfilesPartialSuccess) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.RejectedProfiles != 0 {
		n += 1 + proto.Sov(uint64(orig.RejectedProfiles))
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ExportProfilesPartialSuccess) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RejectedProfiles != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.RejectedProfiles))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.ErrorMessage)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func (orig *ExportProfilesPartialSuccess) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedProfiles", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.RejectedProfiles = int64(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ErrorMessage = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportProfilesPartialSuccess() *ExportProfilesPartialSuccess {
	orig := NewExportProfilesPartialSuccess()
	orig.RejectedProfiles = int64(13)
	orig.ErrorMessage = "test_errormessage"
	return orig
}

func GenTestExportProfilesPartialSuccessPtrSlice() []*ExportProfilesPartialSuccess {
	orig := make([]*ExportProfilesPartialSuccess, 5)
	orig[0] = NewExportProfilesPartialSuccess()
	orig[1] = GenTestExportProfilesPartialSuccess()
	orig[2] = NewExportProfilesPartialSuccess()
	orig[3] = GenTestExportProfilesPartialSuccess()
	orig[4] = NewExportProfilesPartialSuccess()
	return orig
}

func GenTestExportProfilesPartialSuccessSlice() []ExportProfilesPartialSuccess {
	orig := make([]ExportProfilesPartialSuccess, 5)
	orig[1] = *GenTestExportProfilesPartialSuccess()
	orig[3] = *GenTestExportProfilesPartialSuccess()
	return orig
}
