// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Histogram represents the type of a metric that is calculated by aggregating as a Histogram of all reported measurements over a time interval.
type Histogram struct {
	DataPoints             []*HistogramDataPoint
	AggregationTemporality AggregationTemporality
}

var (
	protoPoolHistogram = sync.Pool{
		New: func() any {
			return &Histogram{}
		},
	}
)

func NewHistogram() *Histogram {
	if !UseProtoPooling.IsEnabled() {
		return &Histogram{}
	}
	return protoPoolHistogram.Get().(*Histogram)
}

func DeleteHistogram(orig *Histogram, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.DataPoints {
		DeleteHistogramDataPoint(orig.DataPoints[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolHistogram.Put(orig)
	}
}

func CopyHistogram(dest, src *Histogram) *Histogram {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewHistogram()
	}
	dest.DataPoints = CopyHistogramDataPointPtrSlice(dest.DataPoints, src.DataPoints)

	dest.AggregationTemporality = src.AggregationTemporality

	return dest
}

func CopyHistogramSlice(dest, src []Histogram) []Histogram {
	var newDest []Histogram
	if cap(dest) < len(src) {
		newDest = make([]Histogram, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteHistogram(&dest[i], false)
		}
	}
	for i := range src {
		CopyHistogram(&newDest[i], &src[i])
	}
	return newDest
}

func CopyHistogramPtrSlice(dest, src []*Histogram) []*Histogram {
	var newDest []*Histogram
	if cap(dest) < len(src) {
		newDest = make([]*Histogram, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewHistogram()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteHistogram(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewHistogram()
		}
	}
	for i := range src {
		CopyHistogram(newDest[i], src[i])
	}
	return newDest
}

func (orig *Histogram) Reset() {
	*orig = Histogram{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Histogram) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		orig.DataPoints[0].MarshalJSON(dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			orig.DataPoints[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}

	if int32(orig.AggregationTemporality) != 0 {
		dest.WriteObjectField("aggregationTemporality")
		dest.WriteInt32(int32(orig.AggregationTemporality))
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Histogram) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "dataPoints", "data_points":
			for iter.ReadArray() {
				orig.DataPoints = append(orig.DataPoints, NewHistogramDataPoint())
				orig.DataPoints[len(orig.DataPoints)-1].UnmarshalJSON(iter)
			}

		case "aggregationTemporality", "aggregation_temporality":
			orig.AggregationTemporality = AggregationTemporality(iter.ReadEnumValue(AggregationTemporality_value))
		default:
			iter.Skip()
		}
	}
}

func (orig *Histogram) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = orig.DataPoints[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.AggregationTemporality != AggregationTemporality(0) {
		n += 1 + proto.Sov(uint64(orig.AggregationTemporality))
	}
	return n
}

func (orig *Histogram) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.DataPoints) - 1; i >= 0; i-- {
		l = orig.DataPoints[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.AggregationTemporality != AggregationTemporality(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AggregationTemporality))
		pos--
		buf[pos] = 0x10
	}
	return len(buf) - pos
}

func (orig *Histogram) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DataPoints = append(orig.DataPoints, NewHistogramDataPoint())
			err = orig.DataPoints[len(orig.DataPoints)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.AggregationTemporality = AggregationTemporality(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestHistogram() *Histogram {
	orig := NewHistogram()
	orig.DataPoints = []*HistogramDataPoint{{}, GenTestHistogramDataPoint()}
	orig.AggregationTemporality = AggregationTemporality(13)
	return orig
}

func GenTestHistogramPtrSlice() []*Histogram {
	orig := make([]*Histogram, 5)
	orig[0] = NewHistogram()
	orig[1] = GenTestHistogram()
	orig[2] = NewHistogram()
	orig[3] = GenTestHistogram()
	orig[4] = NewHistogram()
	return orig
}

func GenTestHistogramSlice() []Histogram {
	orig := make([]Histogram, 5)
	orig[1] = *GenTestHistogram()
	orig[3] = *GenTestHistogram()
	return orig
}
