/* Logger.c generated by valac 0.56.17, the Vala compiler
 * generated from Logger.vala, do not modify */

/*
 * Copyright 2015–2019 elementary, Inc. (https://elementary.io)
 * Copyright 2015–2017 Rico Tzschichholz
 * Copyright 2011–2013 Robert Dyer
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	GRANITE_SERVICES_CONSOLE_COLOR_BLACK,
	GRANITE_SERVICES_CONSOLE_COLOR_RED,
	GRANITE_SERVICES_CONSOLE_COLOR_GREEN,
	GRANITE_SERVICES_CONSOLE_COLOR_YELLOW,
	GRANITE_SERVICES_CONSOLE_COLOR_BLUE,
	GRANITE_SERVICES_CONSOLE_COLOR_MAGENTA,
	GRANITE_SERVICES_CONSOLE_COLOR_CYAN,
	GRANITE_SERVICES_CONSOLE_COLOR_WHITE
} GraniteServicesConsoleColor;

#define GRANITE_SERVICES_TYPE_CONSOLE_COLOR (granite_services_console_color_get_type ())
enum  {
	GRANITE_SERVICES_LOGGER_0_PROPERTY,
	GRANITE_SERVICES_LOGGER_NUM_PROPERTIES
};
static GParamSpec* granite_services_logger_properties[GRANITE_SERVICES_LOGGER_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

static gpointer granite_services_logger_parent_class = NULL;
static GraniteServicesLogLevel granite_services_logger__DisplayLevel;
static GraniteServicesLogLevel granite_services_logger__DisplayLevel = GRANITE_SERVICES_LOG_LEVEL_WARN;
static GMutex granite_services_logger_write_mutex;
static GMutex granite_services_logger_write_mutex = {0};

 G_GNUC_INTERNAL GType granite_services_console_color_get_type (void) G_GNUC_CONST ;
static void granite_services_logger_glib_log_func (const gchar* d,
                                            GLogLevelFlags flags,
                                            const gchar* msg);
static void granite_services_logger_write (GraniteServicesLogLevel level,
                                    gchar* msg);
static gchar* granite_services_logger_get_time (void);
static void granite_services_logger_set_color_for_level (GraniteServicesLogLevel level);
static void granite_services_logger_reset_color (void);
static void granite_services_logger_set_foreground (GraniteServicesConsoleColor color);
static void granite_services_logger_set_background (GraniteServicesConsoleColor color);
static void granite_services_logger_set_color (GraniteServicesConsoleColor color,
                                        gboolean is_foreground);
static void granite_services_logger_finalize (GObject * obj);
static GType granite_services_logger_get_type_once (void);
static void _vala_granite_services_logger_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_granite_services_logger_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static const gchar* GRANITE_SERVICES_LOGGER_LOG_LEVEL_TO_STRING[6] = {"DEBUG", "INFO", "NOTIFY", "WARNING", "ERROR", "FATAL"};

/**
     * LogLevel:
     */
static GType
granite_services_log_level_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_SERVICES_LOG_LEVEL_DEBUG, "GRANITE_SERVICES_LOG_LEVEL_DEBUG", "debug"}, {GRANITE_SERVICES_LOG_LEVEL_INFO, "GRANITE_SERVICES_LOG_LEVEL_INFO", "info"}, {GRANITE_SERVICES_LOG_LEVEL_NOTIFY, "GRANITE_SERVICES_LOG_LEVEL_NOTIFY", "notify"}, {GRANITE_SERVICES_LOG_LEVEL_WARN, "GRANITE_SERVICES_LOG_LEVEL_WARN", "warn"}, {GRANITE_SERVICES_LOG_LEVEL_ERROR, "GRANITE_SERVICES_LOG_LEVEL_ERROR", "error"}, {GRANITE_SERVICES_LOG_LEVEL_FATAL, "GRANITE_SERVICES_LOG_LEVEL_FATAL", "fatal"}, {0, NULL, NULL}};
	GType granite_services_log_level_type_id;
	granite_services_log_level_type_id = g_enum_register_static ("GraniteServicesLogLevel", values);
	return granite_services_log_level_type_id;
}

GType
granite_services_log_level_get_type (void)
{
	static volatile gsize granite_services_log_level_type_id__once = 0;
	if (g_once_init_enter (&granite_services_log_level_type_id__once)) {
		GType granite_services_log_level_type_id;
		granite_services_log_level_type_id = granite_services_log_level_get_type_once ();
		g_once_init_leave (&granite_services_log_level_type_id__once, granite_services_log_level_type_id);
	}
	return granite_services_log_level_type_id__once;
}

static GType
granite_services_console_color_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_SERVICES_CONSOLE_COLOR_BLACK, "GRANITE_SERVICES_CONSOLE_COLOR_BLACK", "black"}, {GRANITE_SERVICES_CONSOLE_COLOR_RED, "GRANITE_SERVICES_CONSOLE_COLOR_RED", "red"}, {GRANITE_SERVICES_CONSOLE_COLOR_GREEN, "GRANITE_SERVICES_CONSOLE_COLOR_GREEN", "green"}, {GRANITE_SERVICES_CONSOLE_COLOR_YELLOW, "GRANITE_SERVICES_CONSOLE_COLOR_YELLOW", "yellow"}, {GRANITE_SERVICES_CONSOLE_COLOR_BLUE, "GRANITE_SERVICES_CONSOLE_COLOR_BLUE", "blue"}, {GRANITE_SERVICES_CONSOLE_COLOR_MAGENTA, "GRANITE_SERVICES_CONSOLE_COLOR_MAGENTA", "magenta"}, {GRANITE_SERVICES_CONSOLE_COLOR_CYAN, "GRANITE_SERVICES_CONSOLE_COLOR_CYAN", "cyan"}, {GRANITE_SERVICES_CONSOLE_COLOR_WHITE, "GRANITE_SERVICES_CONSOLE_COLOR_WHITE", "white"}, {0, NULL, NULL}};
	GType granite_services_console_color_type_id;
	granite_services_console_color_type_id = g_enum_register_static ("GraniteServicesConsoleColor", values);
	return granite_services_console_color_type_id;
}

 G_GNUC_INTERNAL GType
granite_services_console_color_get_type (void)
{
	static volatile gsize granite_services_console_color_type_id__once = 0;
	if (g_once_init_enter (&granite_services_console_color_type_id__once)) {
		GType granite_services_console_color_type_id;
		granite_services_console_color_type_id = granite_services_console_color_get_type_once ();
		g_once_init_leave (&granite_services_console_color_type_id__once, granite_services_console_color_type_id);
	}
	return granite_services_console_color_type_id__once;
}

GraniteServicesLogLevel
granite_services_logger_get_DisplayLevel (void)
{
	GraniteServicesLogLevel result;
	result = granite_services_logger__DisplayLevel;
	return result;
}

void
granite_services_logger_set_DisplayLevel (GraniteServicesLogLevel value)
{
	granite_services_logger__DisplayLevel = value;
}

/**
         * This method initializes the Logger
         *
         * @param app_name name of app that is logging
         */
void
granite_services_logger_initialize (const gchar* app_name)
{
	g_return_if_fail (app_name != NULL);
	g_log_set_default_handler ((GLogFunc) granite_services_logger_glib_log_func, NULL);
}

/**
         * Logs message using Notify level formatting
         *
         * @param msg message to be logged
         */
void
granite_services_logger_notification (const gchar* msg)
{
	gchar* _tmp0_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = g_strdup (msg);
	granite_services_logger_write (GRANITE_SERVICES_LOG_LEVEL_NOTIFY, _tmp0_);
}

static gchar*
granite_services_logger_get_time (void)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = g_strdup_printf ("%.2d:%.2d:%.2d.%.6d", g_date_time_get_hour (now), g_date_time_get_minute (now), g_date_time_get_second (now), g_date_time_get_microsecond (now));
	result = _tmp1_;
	_g_date_time_unref0 (now);
	return result;
}

static void
granite_services_logger_write (GraniteServicesLogLevel level,
                               gchar* msg)
{
	GraniteServicesLogLevel _tmp0_;
	GraniteServicesLogLevel _tmp1_;
	FILE* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FILE* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = granite_services_logger_get_DisplayLevel ();
	_tmp1_ = _tmp0_;
	if (level < _tmp1_) {
		_g_free0 (msg);
		return;
	}
	g_mutex_lock (&granite_services_logger_write_mutex);
	granite_services_logger_set_color_for_level (level);
	_tmp2_ = stdout;
	_tmp3_ = GRANITE_SERVICES_LOGGER_LOG_LEVEL_TO_STRING[level];
	_tmp4_ = granite_services_logger_get_time ();
	_tmp5_ = _tmp4_;
	fprintf (_tmp2_, "[%s %s]", _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	granite_services_logger_reset_color ();
	_tmp6_ = stdout;
	fprintf (_tmp6_, " %s\n", msg);
	g_mutex_unlock (&granite_services_logger_write_mutex);
	_g_free0 (msg);
}

static void
granite_services_logger_set_color_for_level (GraniteServicesLogLevel level)
{
	switch (level) {
		case GRANITE_SERVICES_LOG_LEVEL_DEBUG:
		{
			granite_services_logger_set_foreground (GRANITE_SERVICES_CONSOLE_COLOR_GREEN);
			break;
		}
		case GRANITE_SERVICES_LOG_LEVEL_INFO:
		{
			granite_services_logger_set_foreground (GRANITE_SERVICES_CONSOLE_COLOR_BLUE);
			break;
		}
		case GRANITE_SERVICES_LOG_LEVEL_NOTIFY:
		{
			granite_services_logger_set_foreground (GRANITE_SERVICES_CONSOLE_COLOR_MAGENTA);
			break;
		}
		case GRANITE_SERVICES_LOG_LEVEL_WARN:
		{
			granite_services_logger_set_foreground (GRANITE_SERVICES_CONSOLE_COLOR_YELLOW);
			break;
		}
		case GRANITE_SERVICES_LOG_LEVEL_ERROR:
		{
			granite_services_logger_set_foreground (GRANITE_SERVICES_CONSOLE_COLOR_RED);
			break;
		}
		case GRANITE_SERVICES_LOG_LEVEL_FATAL:
		{
			granite_services_logger_set_background (GRANITE_SERVICES_CONSOLE_COLOR_RED);
			granite_services_logger_set_foreground (GRANITE_SERVICES_CONSOLE_COLOR_WHITE);
			break;
		}
		default:
		break;
	}
}

static void
granite_services_logger_reset_color (void)
{
	FILE* _tmp0_;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\x001b[0m");
}

static void
granite_services_logger_set_foreground (GraniteServicesConsoleColor color)
{
	granite_services_logger_set_color (color, TRUE);
}

static void
granite_services_logger_set_background (GraniteServicesConsoleColor color)
{
	granite_services_logger_set_color (color, FALSE);
}

static void
granite_services_logger_set_color (GraniteServicesConsoleColor color,
                                   gboolean is_foreground)
{
	GraniteServicesConsoleColor color_code = 0;
	FILE* _tmp0_;
	color_code = (color + 30) + 60;
	if (!is_foreground) {
		color_code += 10;
	}
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\x001b[%dm", (gint) color_code);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
granite_services_logger_glib_log_func (const gchar* d,
                                       GLogLevelFlags flags,
                                       const gchar* msg)
{
	gchar* domain = NULL;
	gchar* message = NULL;
	gboolean _tmp2_ = FALSE;
	GraniteServicesLogLevel level = 0;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (msg != NULL);
	if (d != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("[%s] ", d);
		_g_free0 (domain);
		domain = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (domain);
		domain = _tmp1_;
	}
	if (string_contains (msg, "\n")) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = string_contains (msg, "\r");
	}
	if (_tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = domain;
		_tmp4_ = string_replace (msg, "\n", "");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_replace (_tmp5_, "\r", "");
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s%s", _tmp3_, _tmp7_);
		_g_free0 (message);
		message = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = domain;
		_tmp10_ = g_strdup_printf ("%s%s", _tmp9_, msg);
		_g_free0 (message);
		message = _tmp10_;
	}
	flags = flags & G_LOG_LEVEL_MASK;
	switch (flags) {
		case G_LOG_LEVEL_CRITICAL:
		{
			level = GRANITE_SERVICES_LOG_LEVEL_FATAL;
			break;
		}
		case G_LOG_LEVEL_ERROR:
		{
			level = GRANITE_SERVICES_LOG_LEVEL_ERROR;
			break;
		}
		case G_LOG_LEVEL_INFO:
		case G_LOG_LEVEL_MESSAGE:
		{
			level = GRANITE_SERVICES_LOG_LEVEL_INFO;
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			level = GRANITE_SERVICES_LOG_LEVEL_DEBUG;
			break;
		}
		default:
		case G_LOG_LEVEL_WARNING:
		{
			level = GRANITE_SERVICES_LOG_LEVEL_WARN;
			break;
		}
	}
	_tmp11_ = message;
	_tmp12_ = g_strdup (_tmp11_);
	granite_services_logger_write (level, _tmp12_);
	_g_free0 (message);
	_g_free0 (domain);
}

GraniteServicesLogger*
granite_services_logger_construct (GType object_type)
{
	GraniteServicesLogger * self = NULL;
	self = (GraniteServicesLogger*) g_object_new (object_type, NULL);
	return self;
}

GraniteServicesLogger*
granite_services_logger_new (void)
{
	return granite_services_logger_construct (GRANITE_SERVICES_TYPE_LOGGER);
}

static void
granite_services_logger_class_init (GraniteServicesLoggerClass * klass,
                                    gpointer klass_data)
{
	granite_services_logger_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_services_logger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_services_logger_set_property;
	G_OBJECT_CLASS (klass)->finalize = granite_services_logger_finalize;
}

static void
granite_services_logger_instance_init (GraniteServicesLogger * self,
                                       gpointer klass)
{
}

static void
granite_services_logger_finalize (GObject * obj)
{
	GraniteServicesLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_LOGGER, GraniteServicesLogger);
	G_OBJECT_CLASS (granite_services_logger_parent_class)->finalize (obj);
}

/**
     * This class helps in the use of logs in a Granite application.
     *
     */
static GType
granite_services_logger_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesLogger), 0, (GInstanceInitFunc) granite_services_logger_instance_init, NULL };
	GType granite_services_logger_type_id;
	granite_services_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesLogger", &g_define_type_info, 0);
	return granite_services_logger_type_id;
}

GType
granite_services_logger_get_type (void)
{
	static volatile gsize granite_services_logger_type_id__once = 0;
	if (g_once_init_enter (&granite_services_logger_type_id__once)) {
		GType granite_services_logger_type_id;
		granite_services_logger_type_id = granite_services_logger_get_type_once ();
		g_once_init_leave (&granite_services_logger_type_id__once, granite_services_logger_type_id);
	}
	return granite_services_logger_type_id__once;
}

static void
_vala_granite_services_logger_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GraniteServicesLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_TYPE_LOGGER, GraniteServicesLogger);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_services_logger_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GraniteServicesLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_TYPE_LOGGER, GraniteServicesLogger);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

