/* Paths.c generated by valac 0.56.17, the Vala compiler
 * generated from Paths.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011-2013 Robert Dyer
 * Copyright 2011-2013 Rico Tzschichholz <ricotz@ubuntu.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_SERVICES_PATHS_0_PROPERTY,
	GRANITE_SERVICES_PATHS_NUM_PROPERTIES
};
static GParamSpec* granite_services_paths_properties[GRANITE_SERVICES_PATHS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer granite_services_paths_parent_class = NULL;
static GFile* granite_services_paths__home_folder;
static GFile* granite_services_paths__home_folder = NULL;
static GFile* granite_services_paths__data_folder;
static GFile* granite_services_paths__data_folder = NULL;
static GFile* granite_services_paths__xdg_config_home_folder;
static GFile* granite_services_paths__xdg_config_home_folder = NULL;
static GFile* granite_services_paths__xdg_data_home_folder;
static GFile* granite_services_paths__xdg_data_home_folder = NULL;
static GFile* granite_services_paths__xdg_cache_home_folder;
static GFile* granite_services_paths__xdg_cache_home_folder = NULL;
static GList* granite_services_paths__xdg_data_dir_folders;
static GList* granite_services_paths__xdg_data_dir_folders = NULL;
static GFile* granite_services_paths__user_config_folder;
static GFile* granite_services_paths__user_config_folder = NULL;
static GFile* granite_services_paths__user_data_folder;
static GFile* granite_services_paths__user_data_folder = NULL;
static GFile* granite_services_paths__user_cache_folder;
static GFile* granite_services_paths__user_cache_folder = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void granite_services_paths_finalize (GObject * obj);
static GType granite_services_paths_get_type_once (void);
static void _vala_granite_services_paths_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_granite_services_paths_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GFile*
granite_services_paths_get_home_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__home_folder;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
granite_services_paths_set_home_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__home_folder);
	granite_services_paths__home_folder = _tmp0_;
}

GFile*
granite_services_paths_get_data_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__data_folder;
	result = _tmp0_;
	return result;
}

void
granite_services_paths_set_data_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__data_folder);
	granite_services_paths__data_folder = _tmp0_;
}

GFile*
granite_services_paths_get_xdg_config_home_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__xdg_config_home_folder;
	result = _tmp0_;
	return result;
}

void
granite_services_paths_set_xdg_config_home_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__xdg_config_home_folder);
	granite_services_paths__xdg_config_home_folder = _tmp0_;
}

GFile*
granite_services_paths_get_xdg_data_home_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__xdg_data_home_folder;
	result = _tmp0_;
	return result;
}

void
granite_services_paths_set_xdg_data_home_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__xdg_data_home_folder);
	granite_services_paths__xdg_data_home_folder = _tmp0_;
}

GFile*
granite_services_paths_get_xdg_cache_home_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__xdg_cache_home_folder;
	result = _tmp0_;
	return result;
}

void
granite_services_paths_set_xdg_cache_home_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__xdg_cache_home_folder);
	granite_services_paths__xdg_cache_home_folder = _tmp0_;
}

GList*
granite_services_paths_get_xdg_data_dir_folders (void)
{
	GList* result;
	GList* _tmp0_;
	_tmp0_ = granite_services_paths__xdg_data_dir_folders;
	result = _tmp0_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
granite_services_paths_set_xdg_data_dir_folders (GList* value)
{
	GList* _tmp0_;
	_tmp0_ = value;
	value = NULL;
	(granite_services_paths__xdg_data_dir_folders == NULL) ? NULL : (granite_services_paths__xdg_data_dir_folders = (_g_list_free__g_object_unref0_ (granite_services_paths__xdg_data_dir_folders), NULL));
	granite_services_paths__xdg_data_dir_folders = _tmp0_;
	(value == NULL) ? NULL : (value = (_g_list_free__g_object_unref0_ (value), NULL));
}

GFile*
granite_services_paths_get_user_config_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__user_config_folder;
	result = _tmp0_;
	return result;
}

void
granite_services_paths_set_user_config_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__user_config_folder);
	granite_services_paths__user_config_folder = _tmp0_;
}

GFile*
granite_services_paths_get_user_data_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__user_data_folder;
	result = _tmp0_;
	return result;
}

void
granite_services_paths_set_user_data_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__user_data_folder);
	granite_services_paths__user_data_folder = _tmp0_;
}

GFile*
granite_services_paths_get_user_cache_folder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = granite_services_paths__user_cache_folder;
	result = _tmp0_;
	return result;
}

void
granite_services_paths_set_user_cache_folder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (granite_services_paths__user_cache_folder);
	granite_services_paths__user_cache_folder = _tmp0_;
}

/**
         * Initialize all the paths using the supplied app name and path to the app's data folder.
         *
         * @param app_name the name of the application
         * @param data_folder_path the path to the application's data folder
         */
void
granite_services_paths_initialize (const gchar* app_name,
                                   const gchar* data_folder_path)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* xdg_config_home = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* xdg_data_home = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* xdg_cache_home = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* xdg_data_dirs = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gboolean _tmp39_ = FALSE;
	const gchar* _tmp40_;
	GList* dirs = NULL;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	GList* _tmp64_;
	GFile* _tmp65_;
	GFile* _tmp66_;
	GFile* _tmp67_;
	GFile* _tmp68_;
	GFile* _tmp69_;
	GFile* _tmp70_;
	GFile* _tmp71_;
	GFile* _tmp72_;
	GFile* _tmp73_;
	GFile* _tmp74_;
	GFile* _tmp75_;
	GFile* _tmp76_;
	GFile* _tmp77_;
	GFile* _tmp78_;
	GFile* _tmp79_;
	GFile* _tmp80_;
	GFile* _tmp81_;
	GFile* _tmp82_;
	g_return_if_fail (app_name != NULL);
	g_return_if_fail (data_folder_path != NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	granite_services_paths_set_home_folder (_tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = g_file_new_for_path (data_folder_path);
	_tmp4_ = _tmp3_;
	granite_services_paths_set_data_folder (_tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = g_getenv ("XDG_CONFIG_HOME");
	_tmp6_ = g_strdup (_tmp5_);
	xdg_config_home = _tmp6_;
	_tmp7_ = g_getenv ("XDG_DATA_HOME");
	_tmp8_ = g_strdup (_tmp7_);
	xdg_data_home = _tmp8_;
	_tmp9_ = g_getenv ("XDG_CACHE_HOME");
	_tmp10_ = g_strdup (_tmp9_);
	xdg_cache_home = _tmp10_;
	_tmp11_ = g_getenv ("XDG_DATA_DIRS");
	_tmp12_ = g_strdup (_tmp11_);
	xdg_data_dirs = _tmp12_;
	_tmp14_ = xdg_config_home;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp15_ = xdg_config_home;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ == 0;
	}
	if (_tmp13_) {
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp18_ = granite_services_paths_get_home_folder ();
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_get_child (_tmp19_, ".config");
		_tmp21_ = _tmp20_;
		granite_services_paths_set_xdg_config_home_folder (_tmp21_);
		_g_object_unref0 (_tmp21_);
	} else {
		const gchar* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		_tmp22_ = xdg_config_home;
		_tmp23_ = g_file_new_for_path (_tmp22_);
		_tmp24_ = _tmp23_;
		granite_services_paths_set_xdg_config_home_folder (_tmp24_);
		_g_object_unref0 (_tmp24_);
	}
	_tmp26_ = xdg_data_home;
	if (_tmp26_ == NULL) {
		_tmp25_ = TRUE;
	} else {
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp27_ = xdg_data_home;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_ == 0;
	}
	if (_tmp25_) {
		GFile* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
		GFile* _tmp35_;
		_tmp30_ = granite_services_paths_get_home_folder ();
		_tmp31_ = _tmp30_;
		_tmp32_ = g_file_get_child (_tmp31_, ".local");
		_tmp33_ = _tmp32_;
		_tmp34_ = g_file_get_child (_tmp33_, "share");
		_tmp35_ = _tmp34_;
		granite_services_paths_set_xdg_data_home_folder (_tmp35_);
		_g_object_unref0 (_tmp35_);
		_g_object_unref0 (_tmp33_);
	} else {
		const gchar* _tmp36_;
		GFile* _tmp37_;
		GFile* _tmp38_;
		_tmp36_ = xdg_data_home;
		_tmp37_ = g_file_new_for_path (_tmp36_);
		_tmp38_ = _tmp37_;
		granite_services_paths_set_xdg_data_home_folder (_tmp38_);
		_g_object_unref0 (_tmp38_);
	}
	_tmp40_ = xdg_cache_home;
	if (_tmp40_ == NULL) {
		_tmp39_ = TRUE;
	} else {
		const gchar* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		_tmp41_ = xdg_cache_home;
		_tmp42_ = strlen (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp39_ = _tmp43_ == 0;
	}
	if (_tmp39_) {
		GFile* _tmp44_;
		GFile* _tmp45_;
		GFile* _tmp46_;
		GFile* _tmp47_;
		_tmp44_ = granite_services_paths_get_home_folder ();
		_tmp45_ = _tmp44_;
		_tmp46_ = g_file_get_child (_tmp45_, ".cache");
		_tmp47_ = _tmp46_;
		granite_services_paths_set_xdg_cache_home_folder (_tmp47_);
		_g_object_unref0 (_tmp47_);
	} else {
		const gchar* _tmp48_;
		GFile* _tmp49_;
		GFile* _tmp50_;
		_tmp48_ = xdg_cache_home;
		_tmp49_ = g_file_new_for_path (_tmp48_);
		_tmp50_ = _tmp49_;
		granite_services_paths_set_xdg_cache_home_folder (_tmp50_);
		_g_object_unref0 (_tmp50_);
	}
	dirs = NULL;
	_tmp52_ = xdg_data_dirs;
	if (_tmp52_ == NULL) {
		_tmp51_ = TRUE;
	} else {
		const gchar* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		_tmp53_ = xdg_data_dirs;
		_tmp54_ = strlen (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp51_ = _tmp55_ == 0;
	}
	if (_tmp51_) {
		GFile* _tmp56_;
		GFile* _tmp57_;
		_tmp56_ = g_file_new_for_path ("/usr/local/share");
		dirs = g_list_append (dirs, _tmp56_);
		_tmp57_ = g_file_new_for_path ("/usr/share");
		dirs = g_list_append (dirs, _tmp57_);
	} else {
		const gchar* _tmp58_;
		gchar** _tmp59_;
		gchar** _tmp60_;
		_tmp58_ = xdg_data_dirs;
		_tmp60_ = _tmp59_ = g_strsplit (_tmp58_, ":", 0);
		{
			gchar** path_collection = NULL;
			gint path_collection_length1 = 0;
			gint _path_collection_size_ = 0;
			gint path_it = 0;
			path_collection = _tmp60_;
			path_collection_length1 = _vala_array_length (_tmp59_);
			for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
				gchar* _tmp61_;
				gchar* path = NULL;
				_tmp61_ = g_strdup (path_collection[path_it]);
				path = _tmp61_;
				{
					const gchar* _tmp62_;
					GFile* _tmp63_;
					_tmp62_ = path;
					_tmp63_ = g_file_new_for_path (_tmp62_);
					dirs = g_list_append (dirs, _tmp63_);
					_g_free0 (path);
				}
			}
			path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_tmp64_ = dirs;
	dirs = NULL;
	granite_services_paths_set_xdg_data_dir_folders (_tmp64_);
	_tmp65_ = granite_services_paths_get_xdg_config_home_folder ();
	_tmp66_ = _tmp65_;
	_tmp67_ = g_file_get_child (_tmp66_, app_name);
	_tmp68_ = _tmp67_;
	granite_services_paths_set_user_config_folder (_tmp68_);
	_g_object_unref0 (_tmp68_);
	_tmp69_ = granite_services_paths_get_xdg_data_home_folder ();
	_tmp70_ = _tmp69_;
	_tmp71_ = g_file_get_child (_tmp70_, app_name);
	_tmp72_ = _tmp71_;
	granite_services_paths_set_user_data_folder (_tmp72_);
	_g_object_unref0 (_tmp72_);
	_tmp73_ = granite_services_paths_get_xdg_cache_home_folder ();
	_tmp74_ = _tmp73_;
	_tmp75_ = g_file_get_child (_tmp74_, app_name);
	_tmp76_ = _tmp75_;
	granite_services_paths_set_user_cache_folder (_tmp76_);
	_g_object_unref0 (_tmp76_);
	_tmp77_ = granite_services_paths_get_user_config_folder ();
	_tmp78_ = _tmp77_;
	granite_services_paths_ensure_directory_exists (_tmp78_);
	_tmp79_ = granite_services_paths_get_user_data_folder ();
	_tmp80_ = _tmp79_;
	granite_services_paths_ensure_directory_exists (_tmp80_);
	_tmp81_ = granite_services_paths_get_user_cache_folder ();
	_tmp82_ = _tmp81_;
	granite_services_paths_ensure_directory_exists (_tmp82_);
	(dirs == NULL) ? NULL : (dirs = (_g_list_free__g_object_unref0_ (dirs), NULL));
	_g_free0 (xdg_data_dirs);
	_g_free0 (xdg_cache_home);
	_g_free0 (xdg_data_home);
	_g_free0 (xdg_config_home);
}

/**
         * Ensure the directory exists, by creating it if it does not.
         *
         * @param dir the directory in question
         *
         * @return `true` is the directory exists, `false` if it does not
         */
gboolean
granite_services_paths_ensure_directory_exists (GFile* dir)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dir != NULL, FALSE);
	if (!g_file_query_exists (dir, NULL)) {
		gboolean _tmp2_ = FALSE;
		{
			g_file_make_directory_with_parents (dir, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = TRUE;
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			g_clear_error (&_inner_error0_);
			_tmp0_ = g_file_get_path (dir);
			_tmp1_ = _tmp0_;
			g_error ("Paths.vala:133: Could not access or create the directory '%s'.", _tmp1_);
			_g_free0 (_tmp1_);
		}
		__finally0:
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = FALSE;
	return result;
}

GraniteServicesPaths*
granite_services_paths_construct (GType object_type)
{
	GraniteServicesPaths * self = NULL;
	self = (GraniteServicesPaths*) g_object_new (object_type, NULL);
	return self;
}

GraniteServicesPaths*
granite_services_paths_new (void)
{
	return granite_services_paths_construct (GRANITE_SERVICES_TYPE_PATHS);
}

static void
granite_services_paths_class_init (GraniteServicesPathsClass * klass,
                                   gpointer klass_data)
{
	granite_services_paths_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_services_paths_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_services_paths_set_property;
	G_OBJECT_CLASS (klass)->finalize = granite_services_paths_finalize;
}

static void
granite_services_paths_instance_init (GraniteServicesPaths * self,
                                      gpointer klass)
{
}

static void
granite_services_paths_finalize (GObject * obj)
{
	GraniteServicesPaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_PATHS, GraniteServicesPaths);
	G_OBJECT_CLASS (granite_services_paths_parent_class)->finalize (obj);
}

/**
     * A class for interacting with frequently-used directories, following the
     * XDG Base Directory specification: [[http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html]]
     */
static GType
granite_services_paths_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesPathsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_paths_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesPaths), 0, (GInstanceInitFunc) granite_services_paths_instance_init, NULL };
	GType granite_services_paths_type_id;
	granite_services_paths_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesPaths", &g_define_type_info, 0);
	return granite_services_paths_type_id;
}

GType
granite_services_paths_get_type (void)
{
	static volatile gsize granite_services_paths_type_id__once = 0;
	if (g_once_init_enter (&granite_services_paths_type_id__once)) {
		GType granite_services_paths_type_id;
		granite_services_paths_type_id = granite_services_paths_get_type_once ();
		g_once_init_leave (&granite_services_paths_type_id__once, granite_services_paths_type_id);
	}
	return granite_services_paths_type_id__once;
}

static void
_vala_granite_services_paths_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GraniteServicesPaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_TYPE_PATHS, GraniteServicesPaths);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_services_paths_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GraniteServicesPaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_TYPE_PATHS, GraniteServicesPaths);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

