/* AccelLabel.c generated by valac 0.56.17, the Vala compiler
 * generated from AccelLabel.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "granite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_ACCEL_LABEL_0_PROPERTY,
	GRANITE_ACCEL_LABEL_ACTION_NAME_PROPERTY,
	GRANITE_ACCEL_LABEL_ACCEL_STRING_PROPERTY,
	GRANITE_ACCEL_LABEL_LABEL_PROPERTY,
	GRANITE_ACCEL_LABEL_NUM_PROPERTIES
};
static GParamSpec* granite_accel_label_properties[GRANITE_ACCEL_LABEL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GraniteAccelLabelPrivate {
	gchar* _action_name;
	gchar* _accel_string;
	gchar* _label;
};

static gint GraniteAccelLabel_private_offset;
static gpointer granite_accel_label_parent_class = NULL;

static void granite_accel_label_update_accels (GraniteAccelLabel* self);
static GObject * granite_accel_label_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _granite_accel_label_update_accels_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
 G_GNUC_INTERNAL void granite_init (void);
static void granite_accel_label_finalize (GObject * obj);
static GType granite_accel_label_get_type_once (void);
static void _vala_granite_accel_label_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_granite_accel_label_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
granite_accel_label_get_instance_private (GraniteAccelLabel* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteAccelLabel_private_offset);
}

const gchar*
granite_accel_label_get_action_name (GraniteAccelLabel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_name;
	result = _tmp0_;
	return result;
}

void
granite_accel_label_set_action_name (GraniteAccelLabel* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_accel_label_get_action_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_action_name);
		self->priv->_action_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_accel_label_properties[GRANITE_ACCEL_LABEL_ACTION_NAME_PROPERTY]);
	}
}

const gchar*
granite_accel_label_get_accel_string (GraniteAccelLabel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accel_string;
	result = _tmp0_;
	return result;
}

void
granite_accel_label_set_accel_string (GraniteAccelLabel* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_accel_label_get_accel_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_accel_string);
		self->priv->_accel_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_accel_label_properties[GRANITE_ACCEL_LABEL_ACCEL_STRING_PROPERTY]);
	}
}

const gchar*
granite_accel_label_get_label (GraniteAccelLabel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
granite_accel_label_set_label (GraniteAccelLabel* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_accel_label_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_accel_label_properties[GRANITE_ACCEL_LABEL_LABEL_PROPERTY]);
	}
}

/**
     * Creates a new AccelLabel from a label and an accelerator string
     *
     * @param label displayed to the user as the menu item name
     * @param accel an accelerator label like “<Control>a” or “<Super>Right”
     */
GraniteAccelLabel*
granite_accel_label_construct (GType object_type,
                               const gchar* label,
                               const gchar* accel_string)
{
	GraniteAccelLabel * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (GraniteAccelLabel*) g_object_new (object_type, "label", label, "accel-string", accel_string, NULL);
	return self;
}

GraniteAccelLabel*
granite_accel_label_new (const gchar* label,
                         const gchar* accel_string)
{
	return granite_accel_label_construct (GRANITE_TYPE_ACCEL_LABEL, label, accel_string);
}

/**
     * Creates a new AccelLabel from a label and an action name
     *
     * @param label displayed to the user as the menu item name
     * @param action_name name of the {@link GLib.Action} used to retrieve action accelerators
     */
GraniteAccelLabel*
granite_accel_label_construct_from_action_name (GType object_type,
                                                const gchar* label,
                                                const gchar* action_name)
{
	GraniteAccelLabel * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	self = (GraniteAccelLabel*) g_object_new (object_type, "label", label, "action-name", action_name, NULL);
	return self;
}

GraniteAccelLabel*
granite_accel_label_new_from_action_name (const gchar* label,
                                          const gchar* action_name)
{
	return granite_accel_label_construct_from_action_name (GRANITE_TYPE_ACCEL_LABEL, label, action_name);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
granite_accel_label_update_accels (GraniteAccelLabel* self)
{
	GList* list = NULL;
	GList* _tmp0_;
	gchar** accels = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint accels_length1;
	gint _accels_size_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	const gchar* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	list = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GList* _tmp3_;
				GList* _tmp4_;
				gconstpointer _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = list;
				if (!(((guint) i) < (g_list_length (_tmp3_) - 1))) {
					break;
				}
				_tmp4_ = list;
				_tmp5_ = g_list_nth_data (_tmp4_, (guint) i);
				gtk_widget_destroy ((GtkWidget*) _tmp5_);
			}
		}
	}
	_tmp6_ = g_strdup ("");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	accels = _tmp7_;
	accels_length1 = 1;
	_accels_size_ = accels_length1;
	_tmp9_ = self->priv->_accel_string;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->_accel_string;
		_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		_tmp11_ = self->priv->_accel_string;
		_tmp12_ = granite_accel_to_string (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " + ", 0);
		accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
		accels = _tmp15_;
		accels_length1 = _vala_array_length (_tmp14_);
		_accels_size_ = accels_length1;
		_g_free0 (_tmp13_);
	} else {
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_;
		_tmp17_ = self->priv->_action_name;
		if (_tmp17_ != NULL) {
			const gchar* _tmp18_;
			_tmp18_ = self->priv->_action_name;
			_tmp16_ = g_strcmp0 (_tmp18_, "") != 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			GApplication* _tmp19_;
			const gchar* _tmp20_;
			gchar** _tmp21_;
			gchar** _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			_tmp19_ = g_application_get_default ();
			_tmp20_ = self->priv->_action_name;
			_tmp22_ = _tmp21_ = gtk_application_get_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_application_get_type (), GtkApplication), _tmp20_);
			_tmp23_ = _tmp22_;
			_tmp23__length1 = _vala_array_length (_tmp21_);
			_tmp24_ = _tmp23_[0];
			granite_accel_label_set_accel_string (self, _tmp24_);
			_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_tmp25_ = accels;
	_tmp25__length1 = accels_length1;
	_tmp26_ = _tmp25_[0];
	if (g_strcmp0 (_tmp26_, "") != 0) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = accels;
		_tmp27__length1 = accels_length1;
		{
			gchar** accel_collection = NULL;
			gint accel_collection_length1 = 0;
			gint _accel_collection_size_ = 0;
			gint accel_it = 0;
			accel_collection = _tmp27_;
			accel_collection_length1 = _tmp27__length1;
			for (accel_it = 0; accel_it < accel_collection_length1; accel_it = accel_it + 1) {
				const gchar* accel = NULL;
				accel = accel_collection[accel_it];
				{
					const gchar* _tmp28_;
					GtkLabel* accel_label = NULL;
					const gchar* _tmp29_;
					GtkLabel* _tmp30_;
					GtkStyleContext* accel_label_context = NULL;
					GtkLabel* _tmp31_;
					GtkStyleContext* _tmp32_;
					GtkStyleContext* _tmp33_;
					GtkStyleContext* _tmp34_;
					GtkLabel* _tmp35_;
					_tmp28_ = accel;
					if (g_strcmp0 (_tmp28_, "") == 0) {
						continue;
					}
					_tmp29_ = accel;
					_tmp30_ = (GtkLabel*) gtk_label_new (_tmp29_);
					g_object_ref_sink (_tmp30_);
					accel_label = _tmp30_;
					_tmp31_ = accel_label;
					_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
					_tmp33_ = _g_object_ref0 (_tmp32_);
					accel_label_context = _tmp33_;
					_tmp34_ = accel_label_context;
					gtk_style_context_add_class (_tmp34_, GRANITE_STYLE_CLASS_KEYCAP);
					_tmp35_ = accel_label;
					gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp35_);
					_g_object_unref0 (accel_label_context);
					_g_object_unref0 (accel_label);
				}
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
	accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
	(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
}

static void
_granite_accel_label_update_accels_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	granite_accel_label_update_accels ((GraniteAccelLabel*) self);
}

static GObject *
granite_accel_label_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteAccelLabel * self;
	GtkLabel* label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	parent_class = G_OBJECT_CLASS (granite_accel_label_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_ACCEL_LABEL, GraniteAccelLabel);
	_tmp0_ = self->priv->_label;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 6);
	_tmp4_ = label;
	gtk_label_set_xalign (_tmp4_, (gfloat) 0);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 3);
	_tmp5_ = label;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	granite_accel_label_update_accels (self);
	g_signal_connect_object ((GObject*) self, "notify::accel-string", (GCallback) _granite_accel_label_update_accels_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::action-name", (GCallback) _granite_accel_label_update_accels_g_object_notify, self, 0);
	_tmp6_ = label;
	g_object_bind_property_with_closures ((GObject*) self, "label", (GObject*) _tmp6_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (label);
	return obj;
}

static void
granite_accel_label_class_init (GraniteAccelLabelClass * klass,
                                gpointer klass_data)
{
	granite_accel_label_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteAccelLabel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_accel_label_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_accel_label_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_accel_label_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_accel_label_finalize;
	/**
	     * The name of the {@link GLib.Action} used to retrieve action accelerators
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_ACCEL_LABEL_ACTION_NAME_PROPERTY, granite_accel_label_properties[GRANITE_ACCEL_LABEL_ACTION_NAME_PROPERTY] = g_param_spec_string ("action-name", "action-name", "action-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * A {@link Gtk.accelerator_parse} style accel string like “<Control>a” or “<Super>Right”
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_ACCEL_LABEL_ACCEL_STRING_PROPERTY, granite_accel_label_properties[GRANITE_ACCEL_LABEL_ACCEL_STRING_PROPERTY] = g_param_spec_string ("accel-string", "accel-string", "accel-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The user-facing menu item label
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_ACCEL_LABEL_LABEL_PROPERTY, granite_accel_label_properties[GRANITE_ACCEL_LABEL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	granite_init ();
}

static void
granite_accel_label_instance_init (GraniteAccelLabel * self,
                                   gpointer klass)
{
	self->priv = granite_accel_label_get_instance_private (self);
}

static void
granite_accel_label_finalize (GObject * obj)
{
	GraniteAccelLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_ACCEL_LABEL, GraniteAccelLabel);
	_g_free0 (self->priv->_action_name);
	_g_free0 (self->priv->_accel_string);
	_g_free0 (self->priv->_label);
	G_OBJECT_CLASS (granite_accel_label_parent_class)->finalize (obj);
}

/**
 * AccelLabel is meant to be used as a {@link Gtk.MenuItem} child for displaying
 * a {@link GLib.Action}'s accelerator alongside the Menu Item label.
 *
 * The class itself is similar to it's Gtk equivalent {@link Gtk.AccelLabel}
 * but follows elementary OS design conventions. Specifically, this class uses
 * {@link Granite.accel_to_string} for accelerator string parsing.
 *
 * ''Example''<<BR>>
 * {{{
 *   var copy_menuitem = new Gtk.MenuItem ();
 *   copy_menuitem.set_action_name (ACTION_PREFIX + ACTION_COPY);
 *   copy_menuitem.add (new Granite.AccelLabel.from_action_name (_("Copy"), copy_menuitem.action_name));
 * }}}
 *
 */
static GType
granite_accel_label_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteAccelLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_accel_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteAccelLabel), 0, (GInstanceInitFunc) granite_accel_label_instance_init, NULL };
	GType granite_accel_label_type_id;
	granite_accel_label_type_id = g_type_register_static (gtk_grid_get_type (), "GraniteAccelLabel", &g_define_type_info, 0);
	GraniteAccelLabel_private_offset = g_type_add_instance_private (granite_accel_label_type_id, sizeof (GraniteAccelLabelPrivate));
	return granite_accel_label_type_id;
}

GType
granite_accel_label_get_type (void)
{
	static volatile gsize granite_accel_label_type_id__once = 0;
	if (g_once_init_enter (&granite_accel_label_type_id__once)) {
		GType granite_accel_label_type_id;
		granite_accel_label_type_id = granite_accel_label_get_type_once ();
		g_once_init_leave (&granite_accel_label_type_id__once, granite_accel_label_type_id);
	}
	return granite_accel_label_type_id__once;
}

static void
_vala_granite_accel_label_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GraniteAccelLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_ACCEL_LABEL, GraniteAccelLabel);
	switch (property_id) {
		case GRANITE_ACCEL_LABEL_ACTION_NAME_PROPERTY:
		g_value_set_string (value, granite_accel_label_get_action_name (self));
		break;
		case GRANITE_ACCEL_LABEL_ACCEL_STRING_PROPERTY:
		g_value_set_string (value, granite_accel_label_get_accel_string (self));
		break;
		case GRANITE_ACCEL_LABEL_LABEL_PROPERTY:
		g_value_set_string (value, granite_accel_label_get_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_accel_label_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GraniteAccelLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_ACCEL_LABEL, GraniteAccelLabel);
	switch (property_id) {
		case GRANITE_ACCEL_LABEL_ACTION_NAME_PROPERTY:
		granite_accel_label_set_action_name (self, g_value_get_string (value));
		break;
		case GRANITE_ACCEL_LABEL_ACCEL_STRING_PROPERTY:
		granite_accel_label_set_accel_string (self, g_value_get_string (value));
		break;
		case GRANITE_ACCEL_LABEL_LABEL_PROPERTY:
		granite_accel_label_set_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

