/* ModeButton.c generated by valac 0.56.17, the Vala compiler
 * generated from ModeButton.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2008–2013 Christian Hergert <chris@dronelabs.com>,
 * Copyright 2008–2013 Giulio Collura <random.cpp@gmail.com>,
 * Copyright 2008–2013 Victor Eduardo <victoreduardm@gmail.com>,
 * Copyright 2008–2013 ammonkey <am.monkeyd@gmail.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM (granite_widgets_mode_button_item_get_type ())
#define GRANITE_WIDGETS_MODE_BUTTON_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, GraniteWidgetsModeButtonItem))
#define GRANITE_WIDGETS_MODE_BUTTON_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, GraniteWidgetsModeButtonItemClass))
#define GRANITE_WIDGETS_MODE_BUTTON_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM))
#define GRANITE_WIDGETS_MODE_BUTTON_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM))
#define GRANITE_WIDGETS_MODE_BUTTON_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, GraniteWidgetsModeButtonItemClass))

typedef struct _GraniteWidgetsModeButtonItem GraniteWidgetsModeButtonItem;
typedef struct _GraniteWidgetsModeButtonItemClass GraniteWidgetsModeButtonItemClass;
enum  {
	GRANITE_WIDGETS_MODE_BUTTON_0_PROPERTY,
	GRANITE_WIDGETS_MODE_BUTTON_SELECTED_PROPERTY,
	GRANITE_WIDGETS_MODE_BUTTON_N_ITEMS_PROPERTY,
	GRANITE_WIDGETS_MODE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_mode_button_properties[GRANITE_WIDGETS_MODE_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
typedef struct _GraniteWidgetsModeButtonItemPrivate GraniteWidgetsModeButtonItemPrivate;
enum  {
	GRANITE_WIDGETS_MODE_BUTTON_ITEM_0_PROPERTY,
	GRANITE_WIDGETS_MODE_BUTTON_ITEM_INDEX_PROPERTY,
	GRANITE_WIDGETS_MODE_BUTTON_ITEM_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_mode_button_item_properties[GRANITE_WIDGETS_MODE_BUTTON_ITEM_NUM_PROPERTIES];
enum  {
	GRANITE_WIDGETS_MODE_BUTTON_MODE_ADDED_SIGNAL,
	GRANITE_WIDGETS_MODE_BUTTON_MODE_REMOVED_SIGNAL,
	GRANITE_WIDGETS_MODE_BUTTON_MODE_CHANGED_SIGNAL,
	GRANITE_WIDGETS_MODE_BUTTON_NUM_SIGNALS
};
static guint granite_widgets_mode_button_signals[GRANITE_WIDGETS_MODE_BUTTON_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GraniteWidgetsModeButtonPrivate {
	gint _selected;
	GeeHashMap* item_map;
};

struct _Block10Data {
	int _ref_count_;
	GraniteWidgetsModeButton* self;
	GraniteWidgetsModeButtonItem* item;
};

struct _GraniteWidgetsModeButtonItem {
	GtkToggleButton parent_instance;
	GraniteWidgetsModeButtonItemPrivate * priv;
};

struct _GraniteWidgetsModeButtonItemClass {
	GtkToggleButtonClass parent_class;
};

struct _GraniteWidgetsModeButtonItemPrivate {
	gint _index;
};

static gint GraniteWidgetsModeButton_private_offset;
static gpointer granite_widgets_mode_button_parent_class = NULL;
static gint GraniteWidgetsModeButtonItem_private_offset;
static gpointer granite_widgets_mode_button_item_parent_class = NULL;

static GType granite_widgets_mode_button_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void g_cclosure_user_marshal_VOID__INT_OBJECT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static GraniteWidgetsModeButtonItem* granite_widgets_mode_button_item_new (gint index);
static GraniteWidgetsModeButtonItem* granite_widgets_mode_button_item_construct (GType object_type,
                                                                          gint index);
static gboolean granite_widgets_mode_button_on_scroll_event (GraniteWidgetsModeButton* self,
                                                      GtkWidget* widget,
                                                      GdkEventScroll* ev);
static gboolean _granite_widgets_mode_button_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                               GdkEventScroll* event,
                                                                               gpointer self);
static void __lambda62_ (Block10Data* _data10_);
static gint granite_widgets_mode_button_item_get_index (GraniteWidgetsModeButtonItem* self);
static void ___lambda62__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void granite_widgets_mode_button_clear_selected (GraniteWidgetsModeButton* self);
static void granite_widgets_mode_button_item_set_index (GraniteWidgetsModeButtonItem* self,
                                                 gint value);
static void granite_widgets_mode_button_item_finalize (GObject * obj);
static GType granite_widgets_mode_button_item_get_type_once (void);
static void _vala_granite_widgets_mode_button_item_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_granite_widgets_mode_button_item_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static GObject * granite_widgets_mode_button_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void granite_widgets_mode_button_finalize (GObject * obj);
static GType granite_widgets_mode_button_get_type_once (void);
static void _vala_granite_widgets_mode_button_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_granite_widgets_mode_button_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
granite_widgets_mode_button_get_instance_private (GraniteWidgetsModeButton* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsModeButton_private_offset);
}

static void
g_cclosure_user_marshal_VOID__INT_OBJECT (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_OBJECT) (gpointer data1, gint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_object (param_values + 2), data2);
}

gint
granite_widgets_mode_button_get_selected (GraniteWidgetsModeButton* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_selected;
	return result;
}

void
granite_widgets_mode_button_set_selected (GraniteWidgetsModeButton* self,
                                          gint value)
{
	g_return_if_fail (self != NULL);
	granite_widgets_mode_button_set_active (self, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_mode_button_properties[GRANITE_WIDGETS_MODE_BUTTON_SELECTED_PROPERTY]);
}

guint
granite_widgets_mode_button_get_n_items (GraniteWidgetsModeButton* self)
{
	guint result;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->item_map;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

/**
         * Makes new ModeButton
         */
GraniteWidgetsModeButton*
granite_widgets_mode_button_construct (GType object_type)
{
	GraniteWidgetsModeButton * self = NULL;
	self = (GraniteWidgetsModeButton*) g_object_new (object_type, NULL);
	return self;
}

GraniteWidgetsModeButton*
granite_widgets_mode_button_new (void)
{
	return granite_widgets_mode_button_construct (GRANITE_WIDGETS_TYPE_MODE_BUTTON);
}

/**
         * Appends Pixbuf to ModeButton
         *
         * @param pixbuf Gdk.Pixbuf to append to ModeButton
         */
gint
granite_widgets_mode_button_append_pixbuf (GraniteWidgetsModeButton* self,
                                           GdkPixbuf* pixbuf)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (pixbuf != NULL, 0);
	_tmp0_ = (GtkImage*) gtk_image_new_from_pixbuf (pixbuf);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = granite_widgets_mode_button_append (self, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
         * Appends text to ModeButton
         *
         * @param text text to append to ModeButton
         * @return index of new item
         */
gint
granite_widgets_mode_button_append_text (GraniteWidgetsModeButton* self,
                                         const gchar* text)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	_tmp0_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = granite_widgets_mode_button_append (self, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
         * Appends icon to ModeButton
         *
         * @param icon_name name of icon to append
         * @param size desired size of icon
         * @return index of appended item
         */
gint
granite_widgets_mode_button_append_icon (GraniteWidgetsModeButton* self,
                                         const gchar* icon_name,
                                         GtkIconSize size)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (icon_name != NULL, 0);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name, (GtkIconSize) size);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = granite_widgets_mode_button_append (self, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
         * Appends given widget to ModeButton
         *
         * @param w widget to add to ModeButton
         * @return index of new item
         */
static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GraniteWidgetsModeButton* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->item);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
_granite_widgets_mode_button_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                      GdkEventScroll* event,
                                                                      gpointer self)
{
	gboolean result;
	result = granite_widgets_mode_button_on_scroll_event ((GraniteWidgetsModeButton*) self, _sender, event);
	return result;
}

static void
__lambda62_ (Block10Data* _data10_)
{
	GraniteWidgetsModeButton* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data10_->self;
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) _data10_->item);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = granite_widgets_mode_button_item_get_index (_data10_->item);
		_tmp3_ = _tmp2_;
		granite_widgets_mode_button_set_selected (self, _tmp3_);
	} else {
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = granite_widgets_mode_button_get_selected (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = granite_widgets_mode_button_item_get_index (_data10_->item);
		_tmp7_ = _tmp6_;
		if (_tmp5_ == _tmp7_) {
			gtk_toggle_button_set_active ((GtkToggleButton*) _data10_->item, TRUE);
		}
	}
}

static void
___lambda62__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda62_ (self);
}

gint
granite_widgets_mode_button_append (GraniteWidgetsModeButton* self,
                                    GtkWidget* w)
{
	Block10Data* _data10_;
	gint index = 0;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	GraniteWidgetsModeButtonItem* _tmp8_;
	GraniteWidgetsModeButtonItem* _tmp9_;
	GeeHashMap* _tmp10_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (w != NULL, 0);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	{
		GeeHashMap* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = self->priv->item_map;
		_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		index = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			GeeHashMap* _tmp5_;
			if (!_tmp3_) {
				gint _tmp4_;
				_tmp4_ = index;
				index = _tmp4_ + 1;
			}
			_tmp3_ = FALSE;
			_tmp5_ = self->priv->item_map;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, (gpointer) ((gintptr) index))) {
				break;
			}
		}
	}
	_tmp6_ = self->priv->item_map;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, (gpointer) ((gintptr) index));
	_tmp8_ = (GraniteWidgetsModeButtonItem*) _tmp7_;
	_vala_assert (_tmp8_ == NULL, "item_map[index] == null");
	_g_object_unref0 (_tmp8_);
	_tmp9_ = granite_widgets_mode_button_item_new (index);
	g_object_ref_sink (_tmp9_);
	_data10_->item = _tmp9_;
	g_signal_connect_object ((GtkWidget*) _data10_->item, "scroll-event", (GCallback) _granite_widgets_mode_button_on_scroll_event_gtk_widget_scroll_event, self, 0);
	gtk_container_add ((GtkContainer*) _data10_->item, w);
	g_signal_connect_data ((GtkToggleButton*) _data10_->item, "toggled", (GCallback) ___lambda62__gtk_toggle_button_toggled, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp10_ = self->priv->item_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) index), _data10_->item);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _data10_->item);
	gtk_widget_show_all ((GtkWidget*) _data10_->item);
	g_signal_emit (self, granite_widgets_mode_button_signals[GRANITE_WIDGETS_MODE_BUTTON_MODE_ADDED_SIGNAL], 0, index, w);
	result = index;
	block10_data_unref (_data10_);
	_data10_ = NULL;
	return result;
}

/**
         * Clear selected items
         */
static void
granite_widgets_mode_button_clear_selected (GraniteWidgetsModeButton* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_selected = -1;
	{
		GeeIterator* _item_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->item_map;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_item_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GraniteWidgetsModeButtonItem* item = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			GraniteWidgetsModeButtonItem* _tmp10_;
			_tmp6_ = _item_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _item_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			item = (GraniteWidgetsModeButtonItem*) _tmp8_;
			_tmp10_ = item;
			if (_tmp10_ != NULL) {
				GraniteWidgetsModeButtonItem* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = item;
				_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp9_ = _tmp13_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GraniteWidgetsModeButtonItem* _tmp14_;
				_tmp14_ = item;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, FALSE);
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
}

/**
         * Sets item of given index's activity
         *
         * @param new_active_index index of changed item
         */
void
granite_widgets_mode_button_set_active (GraniteWidgetsModeButton* self,
                                        gint new_active_index)
{
	GeeHashMap* _tmp0_;
	GraniteWidgetsModeButtonItem* new_item = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GraniteWidgetsModeButtonItem* _tmp3_;
	GraniteWidgetsModeButtonItem* _tmp4_;
	GraniteWidgetsModeButtonItem* _tmp5_;
	g_return_if_fail (self != NULL);
	if (new_active_index <= -1) {
		granite_widgets_mode_button_clear_selected (self);
		return;
	}
	_tmp0_ = self->priv->item_map;
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) new_active_index)));
	_tmp1_ = self->priv->item_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) new_active_index));
	_tmp3_ = (GraniteWidgetsModeButtonItem*) _tmp2_;
	_tmp4_ = GRANITE_WIDGETS_MODE_BUTTON_IS_ITEM (_tmp3_) ? ((GraniteWidgetsModeButtonItem*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	new_item = _tmp4_;
	_tmp5_ = new_item;
	if (_tmp5_ != NULL) {
		GraniteWidgetsModeButtonItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GraniteWidgetsModeButtonItem* _tmp9_;
		GraniteWidgetsModeButtonItem* old_item = NULL;
		GeeHashMap* _tmp10_;
		gpointer _tmp11_;
		GraniteWidgetsModeButtonItem* _tmp12_;
		GraniteWidgetsModeButtonItem* _tmp13_;
		GraniteWidgetsModeButtonItem* _tmp14_;
		GraniteWidgetsModeButtonItem* _tmp16_;
		GtkWidget* _tmp17_;
		_tmp6_ = new_item;
		_tmp7_ = granite_widgets_mode_button_item_get_index (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ == new_active_index, "new_item.index == new_active_index");
		_tmp9_ = new_item;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp9_, TRUE);
		if (self->priv->_selected == new_active_index) {
			_g_object_unref0 (new_item);
			return;
		}
		_tmp10_ = self->priv->item_map;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) self->priv->_selected));
		_tmp12_ = (GraniteWidgetsModeButtonItem*) _tmp11_;
		_tmp13_ = GRANITE_WIDGETS_MODE_BUTTON_IS_ITEM (_tmp12_) ? ((GraniteWidgetsModeButtonItem*) _tmp12_) : NULL;
		if (_tmp13_ == NULL) {
			_g_object_unref0 (_tmp12_);
		}
		old_item = _tmp13_;
		self->priv->_selected = new_active_index;
		_tmp14_ = old_item;
		if (_tmp14_ != NULL) {
			GraniteWidgetsModeButtonItem* _tmp15_;
			_tmp15_ = old_item;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp15_, FALSE);
		}
		_tmp16_ = new_item;
		_tmp17_ = gtk_bin_get_child ((GtkBin*) _tmp16_);
		g_signal_emit (self, granite_widgets_mode_button_signals[GRANITE_WIDGETS_MODE_BUTTON_MODE_CHANGED_SIGNAL], 0, _tmp17_);
		_g_object_unref0 (old_item);
	}
	_g_object_unref0 (new_item);
}

/**
         * Changes visibility of item of given index
         *
         * @param index index of item to be modified
         * @param val value to change the visiblity to
         */
void
granite_widgets_mode_button_set_item_visible (GraniteWidgetsModeButton* self,
                                              gint index,
                                              gboolean val)
{
	GeeHashMap* _tmp0_;
	GraniteWidgetsModeButtonItem* item = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GraniteWidgetsModeButtonItem* _tmp3_;
	GraniteWidgetsModeButtonItem* _tmp4_;
	GraniteWidgetsModeButtonItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->item_map;
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) index)));
	_tmp1_ = self->priv->item_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) index));
	_tmp3_ = (GraniteWidgetsModeButtonItem*) _tmp2_;
	_tmp4_ = GRANITE_WIDGETS_MODE_BUTTON_IS_ITEM (_tmp3_) ? ((GraniteWidgetsModeButtonItem*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		GraniteWidgetsModeButtonItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GraniteWidgetsModeButtonItem* _tmp9_;
		GraniteWidgetsModeButtonItem* _tmp10_;
		_tmp6_ = item;
		_tmp7_ = granite_widgets_mode_button_item_get_index (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ == index, "item.index == index");
		_tmp9_ = item;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp9_, !val);
		_tmp10_ = item;
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, val);
	}
	_g_object_unref0 (item);
}

/**
         * Removes item at given index
         *
         * @param index index of item to remove
         */
void
granite_widgets_mode_button_remove (GraniteWidgetsModeButton* self,
                                    gint index)
{
	GeeHashMap* _tmp0_;
	GraniteWidgetsModeButtonItem* item = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GraniteWidgetsModeButtonItem* _tmp3_;
	GraniteWidgetsModeButtonItem* _tmp4_;
	GraniteWidgetsModeButtonItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->item_map;
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) index)));
	_tmp1_ = self->priv->item_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) index));
	_tmp3_ = (GraniteWidgetsModeButtonItem*) _tmp2_;
	_tmp4_ = GRANITE_WIDGETS_MODE_BUTTON_IS_ITEM (_tmp3_) ? ((GraniteWidgetsModeButtonItem*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		GraniteWidgetsModeButtonItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GeeHashMap* _tmp9_;
		GraniteWidgetsModeButtonItem* _tmp10_;
		GtkWidget* _tmp11_;
		GraniteWidgetsModeButtonItem* _tmp12_;
		_tmp6_ = item;
		_tmp7_ = granite_widgets_mode_button_item_get_index (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ == index, "item.index == index");
		_tmp9_ = self->priv->item_map;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, (gpointer) ((gintptr) index), NULL);
		_tmp10_ = item;
		_tmp11_ = gtk_bin_get_child ((GtkBin*) _tmp10_);
		g_signal_emit (self, granite_widgets_mode_button_signals[GRANITE_WIDGETS_MODE_BUTTON_MODE_REMOVED_SIGNAL], 0, index, _tmp11_);
		_tmp12_ = item;
		gtk_widget_destroy ((GtkWidget*) _tmp12_);
	}
	_g_object_unref0 (item);
}

/**
         * Clears all children
         */
void
granite_widgets_mode_button_clear_children (GraniteWidgetsModeButton* self)
{
	GList* _tmp0_;
	GeeHashMap* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp0_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkWidget* button = NULL;
			button = (GtkWidget*) button_it->data;
			{
				GtkWidget* _tmp1_;
				GtkWidget* _tmp2_;
				GtkContainer* _tmp3_;
				_tmp1_ = button;
				gtk_widget_hide (_tmp1_);
				_tmp2_ = button;
				_tmp3_ = gtk_widget_get_parent (_tmp2_);
				if (_tmp3_ != NULL) {
					GtkWidget* _tmp4_;
					_tmp4_ = button;
					GTK_CONTAINER_CLASS (granite_widgets_mode_button_parent_class)->remove ((GtkContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), _tmp4_);
				}
			}
		}
		(button_collection == NULL) ? NULL : (button_collection = (g_list_free (button_collection), NULL));
	}
	_tmp5_ = self->priv->item_map;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp5_);
	self->priv->_selected = -1;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
granite_widgets_mode_button_on_scroll_event (GraniteWidgetsModeButton* self,
                                             GtkWidget* widget,
                                             GdkEventScroll* ev)
{
	gint offset = 0;
	GList* children = NULL;
	GList* _tmp0_;
	guint n_children = 0U;
	GList* _tmp1_;
	GraniteWidgetsModeButtonItem* selected_item = NULL;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	GraniteWidgetsModeButtonItem* _tmp6_;
	gint new_item = 0;
	GList* _tmp7_;
	GraniteWidgetsModeButtonItem* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	switch (ev->direction) {
		case GDK_SCROLL_DOWN:
		case GDK_SCROLL_RIGHT:
		{
			offset = 1;
			break;
		}
		case GDK_SCROLL_UP:
		case GDK_SCROLL_LEFT:
		{
			offset = -1;
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	n_children = g_list_length (_tmp1_);
	_tmp2_ = self->priv->item_map;
	_tmp3_ = granite_widgets_mode_button_get_selected (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) _tmp4_));
	selected_item = (GraniteWidgetsModeButtonItem*) _tmp5_;
	_tmp6_ = selected_item;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (selected_item);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	_tmp7_ = children;
	_tmp8_ = selected_item;
	new_item = g_list_index (_tmp7_, (GtkWidget*) _tmp8_);
	if (new_item < 0) {
		result = FALSE;
		_g_object_unref0 (selected_item);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			GraniteWidgetsModeButtonItem* item = NULL;
			GList* _tmp11_;
			gconstpointer _tmp12_;
			GtkWidget* _tmp13_;
			GraniteWidgetsModeButtonItem* _tmp14_;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			GraniteWidgetsModeButtonItem* _tmp17_;
			if (!_tmp9_) {
				gboolean _tmp10_ = FALSE;
				if (new_item >= 0) {
					_tmp10_ = ((guint) new_item) < n_children;
				} else {
					_tmp10_ = FALSE;
				}
				if (!_tmp10_) {
					break;
				}
			}
			_tmp9_ = FALSE;
			new_item += offset;
			_tmp11_ = children;
			_tmp12_ = g_list_nth_data (_tmp11_, (guint) new_item);
			_tmp13_ = (GtkWidget*) _tmp12_;
			_tmp14_ = _g_object_ref0 (GRANITE_WIDGETS_MODE_BUTTON_IS_ITEM (_tmp13_) ? ((GraniteWidgetsModeButtonItem*) _tmp13_) : NULL);
			item = _tmp14_;
			_tmp17_ = item;
			if (_tmp17_ != NULL) {
				GraniteWidgetsModeButtonItem* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp18_ = item;
				_tmp19_ = gtk_widget_get_visible ((GtkWidget*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp16_ = _tmp20_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				GraniteWidgetsModeButtonItem* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = item;
				_tmp22_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp15_ = _tmp23_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				GraniteWidgetsModeButtonItem* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				_tmp24_ = item;
				_tmp25_ = granite_widgets_mode_button_item_get_index (_tmp24_);
				_tmp26_ = _tmp25_;
				granite_widgets_mode_button_set_selected (self, _tmp26_);
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (item);
		}
	}
	result = FALSE;
	_g_object_unref0 (selected_item);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

static inline gpointer
granite_widgets_mode_button_item_get_instance_private (GraniteWidgetsModeButtonItem* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsModeButtonItem_private_offset);
}

static gint
granite_widgets_mode_button_item_get_index (GraniteWidgetsModeButtonItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_index;
	return result;
}

static void
granite_widgets_mode_button_item_set_index (GraniteWidgetsModeButtonItem* self,
                                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_mode_button_item_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_mode_button_item_properties[GRANITE_WIDGETS_MODE_BUTTON_ITEM_INDEX_PROPERTY]);
	}
}

static GraniteWidgetsModeButtonItem*
granite_widgets_mode_button_item_construct (GType object_type,
                                            gint index)
{
	GraniteWidgetsModeButtonItem * self = NULL;
	self = (GraniteWidgetsModeButtonItem*) g_object_new (object_type, "index", index, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	return self;
}

static GraniteWidgetsModeButtonItem*
granite_widgets_mode_button_item_new (gint index)
{
	return granite_widgets_mode_button_item_construct (GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, index);
}

static void
granite_widgets_mode_button_item_class_init (GraniteWidgetsModeButtonItemClass * klass,
                                             gpointer klass_data)
{
	granite_widgets_mode_button_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsModeButtonItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_mode_button_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_mode_button_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_mode_button_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_MODE_BUTTON_ITEM_INDEX_PROPERTY, granite_widgets_mode_button_item_properties[GRANITE_WIDGETS_MODE_BUTTON_ITEM_INDEX_PROPERTY] = g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
granite_widgets_mode_button_item_instance_init (GraniteWidgetsModeButtonItem * self,
                                                gpointer klass)
{
	self->priv = granite_widgets_mode_button_item_get_instance_private (self);
}

static void
granite_widgets_mode_button_item_finalize (GObject * obj)
{
	GraniteWidgetsModeButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, GraniteWidgetsModeButtonItem);
	G_OBJECT_CLASS (granite_widgets_mode_button_item_parent_class)->finalize (obj);
}

static GType
granite_widgets_mode_button_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsModeButtonItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_mode_button_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsModeButtonItem), 0, (GInstanceInitFunc) granite_widgets_mode_button_item_instance_init, NULL };
	GType granite_widgets_mode_button_item_type_id;
	granite_widgets_mode_button_item_type_id = g_type_register_static (gtk_toggle_button_get_type (), "GraniteWidgetsModeButtonItem", &g_define_type_info, 0);
	GraniteWidgetsModeButtonItem_private_offset = g_type_add_instance_private (granite_widgets_mode_button_item_type_id, sizeof (GraniteWidgetsModeButtonItemPrivate));
	return granite_widgets_mode_button_item_type_id;
}

static GType
granite_widgets_mode_button_item_get_type (void)
{
	static volatile gsize granite_widgets_mode_button_item_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_mode_button_item_type_id__once)) {
		GType granite_widgets_mode_button_item_type_id;
		granite_widgets_mode_button_item_type_id = granite_widgets_mode_button_item_get_type_once ();
		g_once_init_leave (&granite_widgets_mode_button_item_type_id__once, granite_widgets_mode_button_item_type_id);
	}
	return granite_widgets_mode_button_item_type_id__once;
}

static void
_vala_granite_widgets_mode_button_item_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	GraniteWidgetsModeButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, GraniteWidgetsModeButtonItem);
	switch (property_id) {
		case GRANITE_WIDGETS_MODE_BUTTON_ITEM_INDEX_PROPERTY:
		g_value_set_int (value, granite_widgets_mode_button_item_get_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_mode_button_item_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	GraniteWidgetsModeButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, GraniteWidgetsModeButtonItem);
	switch (property_id) {
		case GRANITE_WIDGETS_MODE_BUTTON_ITEM_INDEX_PROPERTY:
		granite_widgets_mode_button_item_set_index (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
granite_widgets_mode_button_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsModeButton * self;
	GeeHashMap* _tmp0_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	parent_class = G_OBJECT_CLASS (granite_widgets_mode_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_MODE_BUTTON, GraniteWidgetsModeButton);
	gtk_box_set_homogeneous ((GtkBox*) self, TRUE);
	gtk_box_set_spacing ((GtkBox*) self, 0);
	_tmp0_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GRANITE_WIDGETS_MODE_BUTTON_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->item_map);
	self->priv->item_map = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	style = _tmp2_;
	_tmp3_ = style;
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_LINKED);
	_tmp4_ = style;
	gtk_style_context_add_class (_tmp4_, "raised");
	_g_object_unref0 (style);
	return obj;
}

static void
granite_widgets_mode_button_class_init (GraniteWidgetsModeButtonClass * klass,
                                        gpointer klass_data)
{
	granite_widgets_mode_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsModeButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_mode_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_mode_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_mode_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_mode_button_finalize;
	/**
	         * Index of currently selected item.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_MODE_BUTTON_SELECTED_PROPERTY, granite_widgets_mode_button_properties[GRANITE_WIDGETS_MODE_BUTTON_SELECTED_PROPERTY] = g_param_spec_int ("selected", "selected", "selected", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Read-only length of current ModeButton
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_MODE_BUTTON_N_ITEMS_PROPERTY, granite_widgets_mode_button_properties[GRANITE_WIDGETS_MODE_BUTTON_N_ITEMS_PROPERTY] = g_param_spec_uint ("n-items", "n-items", "n-items", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	granite_widgets_mode_button_signals[GRANITE_WIDGETS_MODE_BUTTON_MODE_ADDED_SIGNAL] = g_signal_new ("mode-added", GRANITE_WIDGETS_TYPE_MODE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_OBJECT, G_TYPE_NONE, 2, G_TYPE_INT, gtk_widget_get_type ());
	granite_widgets_mode_button_signals[GRANITE_WIDGETS_MODE_BUTTON_MODE_REMOVED_SIGNAL] = g_signal_new ("mode-removed", GRANITE_WIDGETS_TYPE_MODE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_OBJECT, G_TYPE_NONE, 2, G_TYPE_INT, gtk_widget_get_type ());
	granite_widgets_mode_button_signals[GRANITE_WIDGETS_MODE_BUTTON_MODE_CHANGED_SIGNAL] = g_signal_new ("mode-changed", GRANITE_WIDGETS_TYPE_MODE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gtk_widget_get_type ());
}

static void
granite_widgets_mode_button_instance_init (GraniteWidgetsModeButton * self,
                                           gpointer klass)
{
	self->priv = granite_widgets_mode_button_get_instance_private (self);
	self->priv->_selected = -1;
}

static void
granite_widgets_mode_button_finalize (GObject * obj)
{
	GraniteWidgetsModeButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_MODE_BUTTON, GraniteWidgetsModeButton);
	_g_object_unref0 (self->priv->item_map);
	G_OBJECT_CLASS (granite_widgets_mode_button_parent_class)->finalize (obj);
}

/**
     * This widget is a multiple option modal switch
     *
     * {{../doc/images/ModeButton.png}}
     */
static GType
granite_widgets_mode_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsModeButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_mode_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsModeButton), 0, (GInstanceInitFunc) granite_widgets_mode_button_instance_init, NULL };
	GType granite_widgets_mode_button_type_id;
	granite_widgets_mode_button_type_id = g_type_register_static (gtk_box_get_type (), "GraniteWidgetsModeButton", &g_define_type_info, 0);
	GraniteWidgetsModeButton_private_offset = g_type_add_instance_private (granite_widgets_mode_button_type_id, sizeof (GraniteWidgetsModeButtonPrivate));
	return granite_widgets_mode_button_type_id;
}

GType
granite_widgets_mode_button_get_type (void)
{
	static volatile gsize granite_widgets_mode_button_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_mode_button_type_id__once)) {
		GType granite_widgets_mode_button_type_id;
		granite_widgets_mode_button_type_id = granite_widgets_mode_button_get_type_once ();
		g_once_init_leave (&granite_widgets_mode_button_type_id__once, granite_widgets_mode_button_type_id);
	}
	return granite_widgets_mode_button_type_id__once;
}

static void
_vala_granite_widgets_mode_button_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsModeButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_MODE_BUTTON, GraniteWidgetsModeButton);
	switch (property_id) {
		case GRANITE_WIDGETS_MODE_BUTTON_SELECTED_PROPERTY:
		g_value_set_int (value, granite_widgets_mode_button_get_selected (self));
		break;
		case GRANITE_WIDGETS_MODE_BUTTON_N_ITEMS_PROPERTY:
		g_value_set_uint (value, granite_widgets_mode_button_get_n_items (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_mode_button_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsModeButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_MODE_BUTTON, GraniteWidgetsModeButton);
	switch (property_id) {
		case GRANITE_WIDGETS_MODE_BUTTON_SELECTED_PROPERTY:
		granite_widgets_mode_button_set_selected (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

