/* OverlayBar.c generated by valac 0.56.17, the Vala compiler
 * generated from OverlayBar.vala, do not modify */

/*
 * Copyright 2012 ammonkey <am.monkeyd@gmail.com>
 * Copyright 2013 Julián Unrrein <junrrein@gmail.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <pango/pango.h>

#define GRANITE_WIDGETS_OVERLAY_BAR_FALLBACK_THEME "\n" \
"        .overlay-bar {\n" \
"            background-color: alpha (#333, 0.8);\n" \
"            border-radius: 3px;\n" \
"            border-width: 0;\n" \
"            box-shadow:\n" \
"                0 1px 3px alpha (#000, 0.12),\n" \
"                0 1px 2px alpha (#000, 0.24);\n" \
"            color: #fff;\n" \
"            padding: 3px 6px;\n" \
"            margin: 6px;\n" \
"            text-shadow: 0 1px 2px alpha (#000, 0.6);\n" \
"        }\n" \
"    "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_OVERLAY_BAR_0_PROPERTY,
	GRANITE_WIDGETS_OVERLAY_BAR_OVERLAY_PROPERTY,
	GRANITE_WIDGETS_OVERLAY_BAR_STATUS_PROPERTY,
	GRANITE_WIDGETS_OVERLAY_BAR_LABEL_PROPERTY,
	GRANITE_WIDGETS_OVERLAY_BAR_ACTIVE_PROPERTY,
	GRANITE_WIDGETS_OVERLAY_BAR_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GraniteWidgetsOverlayBarPrivate {
	GtkLabel* status_label;
	GtkRevealer* revealer;
	GtkSpinner* spinner;
	GtkOverlay* _overlay;
};

static gint GraniteWidgetsOverlayBar_private_offset;
static gpointer granite_widgets_overlay_bar_parent_class = NULL;

static void granite_widgets_overlay_bar_real_parent_set (GtkWidget* base,
                                                  GtkWidget* old_parent);
static gboolean granite_widgets_overlay_bar_enter_notify_callback (GraniteWidgetsOverlayBar* self,
                                                            GdkEventCrossing* event);
static gboolean _granite_widgets_overlay_bar_enter_notify_callback_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                           GdkEventCrossing* event,
                                                                                           gpointer self);
static GObject * granite_widgets_overlay_bar_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void granite_widgets_overlay_bar_finalize (GObject * obj);
static GType granite_widgets_overlay_bar_get_type_once (void);
static void _vala_granite_widgets_overlay_bar_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_granite_widgets_overlay_bar_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
granite_widgets_overlay_bar_get_instance_private (GraniteWidgetsOverlayBar* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsOverlayBar_private_offset);
}

GtkOverlay*
granite_widgets_overlay_bar_get_overlay (GraniteWidgetsOverlayBar* self)
{
	GtkOverlay* result;
	GtkOverlay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_overlay;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
granite_widgets_overlay_bar_set_overlay (GraniteWidgetsOverlayBar* self,
                                         GtkOverlay* value)
{
	GtkOverlay* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_overlay_bar_get_overlay (self);
	if (old_value != value) {
		GtkOverlay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_overlay);
		self->priv->_overlay = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_OVERLAY_PROPERTY]);
	}
}

const gchar*
granite_widgets_overlay_bar_get_status (GraniteWidgetsOverlayBar* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->status_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_overlay_bar_set_status (GraniteWidgetsOverlayBar* self,
                                        const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_STATUS_PROPERTY]);
}

const gchar*
granite_widgets_overlay_bar_get_label (GraniteWidgetsOverlayBar* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->status_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_overlay_bar_set_label (GraniteWidgetsOverlayBar* self,
                                       const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_LABEL_PROPERTY]);
}

gboolean
granite_widgets_overlay_bar_get_active (GraniteWidgetsOverlayBar* self)
{
	gboolean result;
	GtkSpinner* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->spinner;
	g_object_get (_tmp0_, "active", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_overlay_bar_set_active (GraniteWidgetsOverlayBar* self,
                                        gboolean value)
{
	GtkSpinner* _tmp0_;
	GtkRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->spinner;
	g_object_set (_tmp0_, "active", value, NULL);
	_tmp1_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_ACTIVE_PROPERTY]);
}

/**
     * Create a new Overlay Bar, and add it to the {@link Gtk.Overlay}.
     */
GraniteWidgetsOverlayBar*
granite_widgets_overlay_bar_construct (GType object_type,
                                       GtkOverlay* overlay)
{
	GraniteWidgetsOverlayBar * self = NULL;
	self = (GraniteWidgetsOverlayBar*) g_object_new (object_type, NULL);
	if (overlay != NULL) {
		gtk_widget_add_events ((GtkWidget*) overlay, (gint) GDK_ENTER_NOTIFY_MASK);
		gtk_overlay_add_overlay (overlay, (GtkWidget*) self);
	}
	return self;
}

GraniteWidgetsOverlayBar*
granite_widgets_overlay_bar_new (GtkOverlay* overlay)
{
	return granite_widgets_overlay_bar_construct (GRANITE_WIDGETS_TYPE_OVERLAY_BAR, overlay);
}

static gboolean
_granite_widgets_overlay_bar_enter_notify_callback_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                  GdkEventCrossing* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = granite_widgets_overlay_bar_enter_notify_callback ((GraniteWidgetsOverlayBar*) self, event);
	return result;
}

static void
granite_widgets_overlay_bar_real_parent_set (GtkWidget* base,
                                             GtkWidget* old_parent)
{
	GraniteWidgetsOverlayBar * self;
	GtkWidget* parent = NULL;
	GtkContainer* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp3_;
	self = (GraniteWidgetsOverlayBar*) base;
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	parent = _tmp1_;
	if (old_parent != NULL) {
		guint _tmp2_;
		g_signal_parse_name ("enter-notify-event", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (old_parent, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _granite_widgets_overlay_bar_enter_notify_callback_gtk_widget_enter_notify_event, self);
	}
	_tmp3_ = parent;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_;
		_tmp4_ = parent;
		g_signal_connect_object (_tmp4_, "enter-notify-event", (GCallback) _granite_widgets_overlay_bar_enter_notify_callback_gtk_widget_enter_notify_event, self, 0);
	}
	_g_object_unref0 (parent);
}

static gboolean
granite_widgets_overlay_bar_enter_notify_callback (GraniteWidgetsOverlayBar* self,
                                                   GdkEventCrossing* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (gtk_widget_get_halign ((GtkWidget*) self) == GTK_ALIGN_START) {
		gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_END);
	} else {
		gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static GObject *
granite_widgets_overlay_bar_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsOverlayBar * self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkSpinner* _tmp2_;
	GtkRevealer* _tmp3_;
	GtkRevealer* _tmp4_;
	GtkRevealer* _tmp5_;
	GtkRevealer* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkLabel* _tmp10_;
	GtkGrid* _tmp11_;
	GtkRevealer* _tmp12_;
	GtkGrid* _tmp13_;
	gint priority = 0;
	GtkGrid* _tmp14_;
	GtkCssProvider* _tmp15_;
	GtkCssProvider* _tmp16_;
	GtkStyleContext* ctx = NULL;
	GtkGrid* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkStateFlags state = 0U;
	GtkStyleContext* _tmp20_;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp21_;
	GtkBorder _tmp22_ = {0};
	GtkLabel* _tmp23_;
	GtkBorder _tmp24_;
	GtkLabel* _tmp25_;
	GtkBorder _tmp26_;
	GtkLabel* _tmp27_;
	GtkBorder _tmp28_;
	GtkLabel* _tmp29_;
	GtkBorder _tmp30_;
	GtkSpinner* _tmp31_;
	GtkBorder _tmp32_;
	GtkBorder margin = {0};
	GtkStyleContext* _tmp33_;
	GtkBorder _tmp34_ = {0};
	GtkGrid* _tmp35_;
	GtkBorder _tmp36_;
	GtkGrid* _tmp37_;
	GtkBorder _tmp38_;
	GtkGrid* _tmp39_;
	GtkBorder _tmp40_;
	GtkGrid* _tmp41_;
	GtkBorder _tmp42_;
	parent_class = G_OBJECT_CLASS (granite_widgets_overlay_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_OVERLAY_BAR, GraniteWidgetsOverlayBar);
	granite_widgets_overlay_bar_set_overlay (self, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->status_label);
	self->priv->status_label = _tmp0_;
	_tmp1_ = self->priv->status_label;
	gtk_label_set_ellipsize (_tmp1_, PANGO_ELLIPSIZE_END);
	_tmp2_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp2_;
	_tmp3_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp3_;
	_tmp4_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp4_, FALSE);
	_tmp5_ = self->priv->revealer;
	gtk_revealer_set_transition_type (_tmp5_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	_tmp6_ = self->priv->revealer;
	_tmp7_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp8_);
	grid = _tmp8_;
	_tmp9_ = grid;
	_tmp10_ = self->priv->status_label;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = grid;
	_tmp12_ = self->priv->revealer;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_END);
	priority = GTK_STYLE_PROVIDER_PRIORITY_FALLBACK;
	_tmp14_ = grid;
	_tmp15_ = granite_widgets_utils_set_theming ((GtkWidget*) _tmp14_, GRANITE_WIDGETS_OVERLAY_BAR_FALLBACK_THEME, GRANITE_STYLE_CLASS_OVERLAY_BAR, priority);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	_tmp17_ = grid;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	ctx = _tmp19_;
	_tmp20_ = ctx;
	state = gtk_style_context_get_state (_tmp20_);
	_tmp21_ = ctx;
	gtk_style_context_get_padding (_tmp21_, state, &_tmp22_);
	padding = _tmp22_;
	_tmp23_ = self->priv->status_label;
	_tmp24_ = padding;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp23_, (gint) _tmp24_.top);
	_tmp25_ = self->priv->status_label;
	_tmp26_ = padding;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp25_, (gint) _tmp26_.bottom);
	_tmp27_ = self->priv->status_label;
	_tmp28_ = padding;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp27_, (gint) _tmp28_.left);
	_tmp29_ = self->priv->status_label;
	_tmp30_ = padding;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp29_, (gint) _tmp30_.right);
	_tmp31_ = self->priv->spinner;
	_tmp32_ = padding;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp31_, (gint) _tmp32_.right);
	_tmp33_ = ctx;
	gtk_style_context_get_margin (_tmp33_, state, &_tmp34_);
	margin = _tmp34_;
	_tmp35_ = grid;
	_tmp36_ = margin;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp35_, (gint) _tmp36_.top);
	_tmp37_ = grid;
	_tmp38_ = margin;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp37_, (gint) _tmp38_.bottom);
	_tmp39_ = grid;
	_tmp40_ = margin;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp39_, (gint) _tmp40_.left);
	_tmp41_ = grid;
	_tmp42_ = margin;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp41_, (gint) _tmp42_.right);
	_g_object_unref0 (ctx);
	_g_object_unref0 (grid);
	return obj;
}

static void
granite_widgets_overlay_bar_class_init (GraniteWidgetsOverlayBarClass * klass,
                                        gpointer klass_data)
{
	granite_widgets_overlay_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsOverlayBar_private_offset);
	((GtkWidgetClass *) klass)->parent_set = (void (*) (GtkWidget*, GtkWidget*)) granite_widgets_overlay_bar_real_parent_set;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_overlay_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_overlay_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_overlay_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_overlay_bar_finalize;
	/**
	     * overlay: Deprecated property, always returns null.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_OVERLAY_BAR_OVERLAY_PROPERTY, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_OVERLAY_PROPERTY] = g_param_spec_object ("overlay", "overlay", "overlay", gtk_overlay_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_DEPRECATED));
	/**
	     * Status text displayed inside the Overlay Bar.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_OVERLAY_BAR_STATUS_PROPERTY, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_STATUS_PROPERTY] = g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_DEPRECATED));
	/**
	     * Text displayed inside the Overlay Bar.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_OVERLAY_BAR_LABEL_PROPERTY, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether to display a {@link Gtk.Spinner} inside the Overlay Bar.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_OVERLAY_BAR_ACTIVE_PROPERTY, granite_widgets_overlay_bar_properties[GRANITE_WIDGETS_OVERLAY_BAR_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
granite_widgets_overlay_bar_instance_init (GraniteWidgetsOverlayBar * self,
                                           gpointer klass)
{
	self->priv = granite_widgets_overlay_bar_get_instance_private (self);
}

static void
granite_widgets_overlay_bar_finalize (GObject * obj)
{
	GraniteWidgetsOverlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_OVERLAY_BAR, GraniteWidgetsOverlayBar);
	_g_object_unref0 (self->priv->status_label);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->_overlay);
	G_OBJECT_CLASS (granite_widgets_overlay_bar_parent_class)->finalize (obj);
}

/**
 * A floating status bar that displays a single line of text.
 *
 * This widget is intended to be used as an overlay for a {@link Gtk.Overlay} and is placed in the
 * bottom-right corner by default. You can change its position like you would do for any overlay
 * widget used in a {@link Gtk.Overlay}.
 *
 * The Overlay Bar displays a single line of text that can be changed using the "status" property.
 *
 * {{../doc/images/OverlayBar.png}}
 *
 * This widget tries to avoid getting in front of the content being displayed inside the {@link Gtk.Overlay}
 * by moving itself horizontally to the opposite side from the current one when the mouse pointer enters
 * the widget.
 *
 * For this widget to function correctly, the event {@link Gdk.EventMask.ENTER_NOTIFY_MASK} must be set
 * for the parent {@link Gtk.Overlay}. Overlay Bar's constructor takes care of this automatically, if
 * the parent is supplied as a parameter, but you have to be careful not to unset the event for
 * the {@link Gtk.Overlay} at a later stage.
 *
 * ''Example''<<BR>>
 * {{{
 * public class OverlayBarView : Gtk.Overlay {
 *     construct {
 *         var button = new Gtk.ToggleButton.with_label ("Show Spinner");
 * 
 *         var grid = new Gtk.Grid ();
 *         grid.halign = Gtk.Align.CENTER;
 *         grid.valign = Gtk.Align.CENTER;
 *         grid.add (button);
 * 
 *         var overlaybar = new Granite.Widgets.OverlayBar (this);
 *         overlaybar.label = "Hover the OverlayBar to change its position";
 *         
 *         add (grid);
 * 
 *         button.toggled.connect (() => {
 *             overlaybar.active = button.active;
 *         });
 *     }
 * }
 * }}}
 *
 * @see Gtk.Overlay
 *
 */
static GType
granite_widgets_overlay_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsOverlayBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_overlay_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsOverlayBar), 0, (GInstanceInitFunc) granite_widgets_overlay_bar_instance_init, NULL };
	GType granite_widgets_overlay_bar_type_id;
	granite_widgets_overlay_bar_type_id = g_type_register_static (gtk_event_box_get_type (), "GraniteWidgetsOverlayBar", &g_define_type_info, 0);
	GraniteWidgetsOverlayBar_private_offset = g_type_add_instance_private (granite_widgets_overlay_bar_type_id, sizeof (GraniteWidgetsOverlayBarPrivate));
	return granite_widgets_overlay_bar_type_id;
}

GType
granite_widgets_overlay_bar_get_type (void)
{
	static volatile gsize granite_widgets_overlay_bar_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_overlay_bar_type_id__once)) {
		GType granite_widgets_overlay_bar_type_id;
		granite_widgets_overlay_bar_type_id = granite_widgets_overlay_bar_get_type_once ();
		g_once_init_leave (&granite_widgets_overlay_bar_type_id__once, granite_widgets_overlay_bar_type_id);
	}
	return granite_widgets_overlay_bar_type_id__once;
}

static void
_vala_granite_widgets_overlay_bar_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsOverlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_OVERLAY_BAR, GraniteWidgetsOverlayBar);
	switch (property_id) {
		case GRANITE_WIDGETS_OVERLAY_BAR_OVERLAY_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_object (value, granite_widgets_overlay_bar_get_overlay (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case GRANITE_WIDGETS_OVERLAY_BAR_STATUS_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_string (value, granite_widgets_overlay_bar_get_status (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case GRANITE_WIDGETS_OVERLAY_BAR_LABEL_PROPERTY:
		g_value_set_string (value, granite_widgets_overlay_bar_get_label (self));
		break;
		case GRANITE_WIDGETS_OVERLAY_BAR_ACTIVE_PROPERTY:
		g_value_set_boolean (value, granite_widgets_overlay_bar_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_overlay_bar_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsOverlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_OVERLAY_BAR, GraniteWidgetsOverlayBar);
	switch (property_id) {
		case GRANITE_WIDGETS_OVERLAY_BAR_OVERLAY_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		granite_widgets_overlay_bar_set_overlay (self, g_value_get_object (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case GRANITE_WIDGETS_OVERLAY_BAR_STATUS_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		granite_widgets_overlay_bar_set_status (self, g_value_get_string (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case GRANITE_WIDGETS_OVERLAY_BAR_LABEL_PROPERTY:
		granite_widgets_overlay_bar_set_label (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_OVERLAY_BAR_ACTIVE_PROPERTY:
		granite_widgets_overlay_bar_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

