/* SeekBar.c generated by valac 0.56.17, the Vala compiler
 * generated from SeekBar.vala, do not modify */

/*-
 * Copyright 2017 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_SEEK_BAR_0_PROPERTY,
	GRANITE_SEEK_BAR_PLAYBACK_DURATION_PROPERTY,
	GRANITE_SEEK_BAR_PLAYBACK_PROGRESS_PROPERTY,
	GRANITE_SEEK_BAR_IS_GRABBING_PROPERTY,
	GRANITE_SEEK_BAR_IS_HOVERING_PROPERTY,
	GRANITE_SEEK_BAR_PROGRESSION_LABEL_PROPERTY,
	GRANITE_SEEK_BAR_DURATION_LABEL_PROPERTY,
	GRANITE_SEEK_BAR_SCALE_PROPERTY,
	GRANITE_SEEK_BAR_NUM_PROPERTIES
};
static GParamSpec* granite_seek_bar_properties[GRANITE_SEEK_BAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GraniteSeekBarPrivate {
	gdouble _playback_duration;
	gdouble _playback_progress;
	gboolean _is_grabbing;
	gboolean _is_hovering;
	GtkLabel* _progression_label;
	GtkLabel* _duration_label;
	GtkScale* _scale;
};

static gint GraniteSeekBar_private_offset;
static gpointer granite_seek_bar_parent_class = NULL;

static void granite_seek_bar_set_is_grabbing (GraniteSeekBar* self,
                                       gboolean value);
static void granite_seek_bar_set_is_hovering (GraniteSeekBar* self,
                                       gboolean value);
static void granite_seek_bar_real_get_preferred_width (GtkWidget* base,
                                                gint* minimum_width,
                                                gint* natural_width);
static GObject * granite_seek_bar_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static gboolean _granite_seek_bar___lambda67_ (GraniteSeekBar* self);
static gboolean __granite_seek_bar___lambda67__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self);
static gboolean _granite_seek_bar___lambda68_ (GraniteSeekBar* self);
static gboolean __granite_seek_bar___lambda68__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
static gboolean _granite_seek_bar___lambda69_ (GraniteSeekBar* self);
static gboolean __granite_seek_bar___lambda69__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                       GdkEventCrossing* event,
                                                                       gpointer self);
static gboolean _granite_seek_bar___lambda70_ (GraniteSeekBar* self);
static gboolean __granite_seek_bar___lambda70__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                       GdkEventCrossing* event,
                                                                       gpointer self);
static gboolean _granite_seek_bar___lambda71_ (GraniteSeekBar* self);
static gboolean __granite_seek_bar___lambda71__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                        GdkEventMotion* event,
                                                                        gpointer self);
static void granite_seek_bar_finalize (GObject * obj);
static GType granite_seek_bar_get_type_once (void);
static void _vala_granite_seek_bar_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_granite_seek_bar_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
granite_seek_bar_get_instance_private (GraniteSeekBar* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteSeekBar_private_offset);
}

gdouble
granite_seek_bar_get_playback_duration (GraniteSeekBar* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_playback_duration;
	return result;
}

void
granite_seek_bar_set_playback_duration (GraniteSeekBar* self,
                                        gdouble value)
{
	gdouble duration = 0.0;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	duration = value;
	if (duration < 0.0) {
		g_debug ("SeekBar.vala:131: Duration value less than zero, duration set to 0.0");
		duration = 0.0;
	}
	self->priv->_playback_duration = duration;
	_tmp0_ = self->priv->_duration_label;
	_tmp1_ = granite_date_time_seconds_to_time ((gint) duration);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_notify_by_pspec ((GObject *) self, granite_seek_bar_properties[GRANITE_SEEK_BAR_PLAYBACK_DURATION_PROPERTY]);
}

gdouble
granite_seek_bar_get_playback_progress (GraniteSeekBar* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_playback_progress;
	return result;
}

void
granite_seek_bar_set_playback_progress (GraniteSeekBar* self,
                                        gdouble value)
{
	gdouble progress = 0.0;
	GtkScale* _tmp0_;
	GtkLabel* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	progress = value;
	if (progress < 0.0) {
		g_debug ("SeekBar.vala:150: Progress value less than 0.0, progress set to 0.0");
		progress = 0.0;
	} else {
		if (progress > 1.0) {
			g_debug ("SeekBar.vala:153: Progress value greater than 1.0, progress set to 1.0");
			progress = 1.0;
		}
	}
	self->priv->_playback_progress = progress;
	_tmp0_ = self->priv->_scale;
	gtk_range_set_value ((GtkRange*) _tmp0_, progress);
	_tmp1_ = self->priv->_progression_label;
	_tmp2_ = granite_seek_bar_get_playback_duration (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = granite_date_time_seconds_to_time ((gint) (progress * _tmp3_));
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_notify_by_pspec ((GObject *) self, granite_seek_bar_properties[GRANITE_SEEK_BAR_PLAYBACK_PROGRESS_PROPERTY]);
}

gboolean
granite_seek_bar_get_is_grabbing (GraniteSeekBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_grabbing;
	return result;
}

static void
granite_seek_bar_set_is_grabbing (GraniteSeekBar* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_seek_bar_get_is_grabbing (self);
	if (old_value != value) {
		self->priv->_is_grabbing = value;
		g_object_notify_by_pspec ((GObject *) self, granite_seek_bar_properties[GRANITE_SEEK_BAR_IS_GRABBING_PROPERTY]);
	}
}

gboolean
granite_seek_bar_get_is_hovering (GraniteSeekBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_hovering;
	return result;
}

static void
granite_seek_bar_set_is_hovering (GraniteSeekBar* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_seek_bar_get_is_hovering (self);
	if (old_value != value) {
		self->priv->_is_hovering = value;
		g_object_notify_by_pspec ((GObject *) self, granite_seek_bar_properties[GRANITE_SEEK_BAR_IS_HOVERING_PROPERTY]);
	}
}

GtkLabel*
granite_seek_bar_get_progression_label (GraniteSeekBar* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_progression_label;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
granite_seek_bar_set_progression_label (GraniteSeekBar* self,
                                        GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_seek_bar_get_progression_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_progression_label);
		self->priv->_progression_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_seek_bar_properties[GRANITE_SEEK_BAR_PROGRESSION_LABEL_PROPERTY]);
	}
}

GtkLabel*
granite_seek_bar_get_duration_label (GraniteSeekBar* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_duration_label;
	result = _tmp0_;
	return result;
}

void
granite_seek_bar_set_duration_label (GraniteSeekBar* self,
                                     GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_seek_bar_get_duration_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_duration_label);
		self->priv->_duration_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_seek_bar_properties[GRANITE_SEEK_BAR_DURATION_LABEL_PROPERTY]);
	}
}

GtkScale*
granite_seek_bar_get_scale (GraniteSeekBar* self)
{
	GtkScale* result;
	GtkScale* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scale;
	result = _tmp0_;
	return result;
}

void
granite_seek_bar_set_scale (GraniteSeekBar* self,
                            GtkScale* value)
{
	GtkScale* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_seek_bar_get_scale (self);
	if (old_value != value) {
		GtkScale* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_scale);
		self->priv->_scale = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_seek_bar_properties[GRANITE_SEEK_BAR_SCALE_PROPERTY]);
	}
}

GraniteSeekBar*
granite_seek_bar_construct (GType object_type,
                            gdouble playback_duration)
{
	GraniteSeekBar * self = NULL;
	self = (GraniteSeekBar*) g_object_new (object_type, "playback-duration", playback_duration, NULL);
	return self;
}

GraniteSeekBar*
granite_seek_bar_new (gdouble playback_duration)
{
	return granite_seek_bar_construct (GRANITE_TYPE_SEEK_BAR, playback_duration);
}

static void
granite_seek_bar_real_get_preferred_width (GtkWidget* base,
                                           gint* minimum_width,
                                           gint* natural_width)
{
	GraniteSeekBar * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	GdkWindow* window = NULL;
	GtkContainer* _tmp4_;
	GtkContainer* _tmp5_;
	GdkWindow* _tmp6_;
	GdkWindow* _tmp7_;
	GdkWindow* _tmp8_;
	gint width = 0;
	GtkContainer* _tmp9_;
	GtkContainer* _tmp10_;
	GdkWindow* _tmp11_;
	gboolean _tmp12_ = FALSE;
	self = (GraniteSeekBar*) base;
	GTK_WIDGET_CLASS (granite_seek_bar_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		if (minimum_width) {
			*minimum_width = _vala_minimum_width;
		}
		if (natural_width) {
			*natural_width = _vala_natural_width;
		}
		return;
	}
	_tmp4_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	window = _tmp7_;
	_tmp8_ = window;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (window);
		if (minimum_width) {
			*minimum_width = _vala_minimum_width;
		}
		if (natural_width) {
			*natural_width = _vala_natural_width;
		}
		return;
	}
	_tmp9_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_widget_get_window ((GtkWidget*) _tmp10_);
	width = gdk_window_get_width (_tmp11_);
	if (width > 0) {
		_tmp12_ = width >= _vala_minimum_width;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_vala_natural_width = width;
	}
	_g_object_unref0 (window);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static gboolean
_granite_seek_bar___lambda67_ (GraniteSeekBar* self)
{
	gboolean result;
	granite_seek_bar_set_is_grabbing (self, TRUE);
	result = FALSE;
	return result;
}

static gboolean
__granite_seek_bar___lambda67__gtk_widget_button_press_event (GtkWidget* _sender,
                                                              GdkEventButton* event,
                                                              gpointer self)
{
	gboolean result;
	result = _granite_seek_bar___lambda67_ ((GraniteSeekBar*) self);
	return result;
}

static gboolean
_granite_seek_bar___lambda68_ (GraniteSeekBar* self)
{
	GtkScale* _tmp0_;
	gboolean result;
	granite_seek_bar_set_is_grabbing (self, FALSE);
	_tmp0_ = self->priv->_scale;
	granite_seek_bar_set_playback_progress (self, gtk_range_get_value ((GtkRange*) _tmp0_));
	result = FALSE;
	return result;
}

static gboolean
__granite_seek_bar___lambda68__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = _granite_seek_bar___lambda68_ ((GraniteSeekBar*) self);
	return result;
}

static gboolean
_granite_seek_bar___lambda69_ (GraniteSeekBar* self)
{
	gboolean result;
	granite_seek_bar_set_is_hovering (self, TRUE);
	result = FALSE;
	return result;
}

static gboolean
__granite_seek_bar___lambda69__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                              GdkEventCrossing* event,
                                                              gpointer self)
{
	gboolean result;
	result = _granite_seek_bar___lambda69_ ((GraniteSeekBar*) self);
	return result;
}

static gboolean
_granite_seek_bar___lambda70_ (GraniteSeekBar* self)
{
	gboolean result;
	granite_seek_bar_set_is_hovering (self, FALSE);
	result = FALSE;
	return result;
}

static gboolean
__granite_seek_bar___lambda70__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                              GdkEventCrossing* event,
                                                              gpointer self)
{
	gboolean result;
	result = _granite_seek_bar___lambda70_ ((GraniteSeekBar*) self);
	return result;
}

static gboolean
_granite_seek_bar___lambda71_ (GraniteSeekBar* self)
{
	GtkScale* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_scale;
	granite_seek_bar_set_playback_progress (self, gtk_range_get_value ((GtkRange*) _tmp0_));
	result = FALSE;
	return result;
}

static gboolean
__granite_seek_bar___lambda71__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                               GdkEventMotion* event,
                                                               gpointer self)
{
	gboolean result;
	result = _granite_seek_bar___lambda71_ ((GraniteSeekBar*) self);
	return result;
}

static GObject *
granite_seek_bar_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteSeekBar * self;
	GtkStyleContext* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkScale* _tmp7_;
	GtkScale* _tmp8_;
	GtkScale* _tmp9_;
	GtkScale* _tmp10_;
	GtkScale* _tmp11_;
	GtkScale* _tmp12_;
	GtkScale* _tmp13_;
	GdkEventMask _tmp14_;
	GdkEventMask _tmp15_;
	GtkScale* _tmp16_;
	GtkScale* _tmp17_;
	GdkEventMask _tmp18_;
	GdkEventMask _tmp19_;
	GtkScale* _tmp20_;
	GtkScale* _tmp21_;
	GdkEventMask _tmp22_;
	GdkEventMask _tmp23_;
	GtkScale* _tmp24_;
	GtkScale* _tmp25_;
	GtkScale* _tmp26_;
	GtkScale* _tmp27_;
	GtkScale* _tmp28_;
	GtkLabel* _tmp29_;
	GtkScale* _tmp30_;
	GtkLabel* _tmp31_;
	parent_class = G_OBJECT_CLASS (granite_seek_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_SEEK_BAR, GraniteSeekBar);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GRANITE_STYLE_CLASS_SEEKBAR);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	granite_seek_bar_set_progression_label (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	granite_seek_bar_set_duration_label (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_progression_label;
	_tmp6_ = self->priv->_duration_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp5_, 3);
	_tmp7_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 1, 0.1);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	granite_seek_bar_set_scale (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->_scale;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = self->priv->_scale;
	gtk_scale_set_draw_value (_tmp10_, FALSE);
	_tmp11_ = self->priv->_scale;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp11_, FALSE);
	_tmp12_ = self->priv->_scale;
	_tmp13_ = self->priv->_scale;
	_tmp14_ = gtk_widget_get_events ((GtkWidget*) _tmp13_);
	_tmp15_ = _tmp14_;
	gtk_widget_set_events ((GtkWidget*) _tmp13_, _tmp15_ | GDK_POINTER_MOTION_MASK);
	_tmp16_ = self->priv->_scale;
	_tmp17_ = self->priv->_scale;
	_tmp18_ = gtk_widget_get_events ((GtkWidget*) _tmp17_);
	_tmp19_ = _tmp18_;
	gtk_widget_set_events ((GtkWidget*) _tmp17_, _tmp19_ | GDK_LEAVE_NOTIFY_MASK);
	_tmp20_ = self->priv->_scale;
	_tmp21_ = self->priv->_scale;
	_tmp22_ = gtk_widget_get_events ((GtkWidget*) _tmp21_);
	_tmp23_ = _tmp22_;
	gtk_widget_set_events ((GtkWidget*) _tmp21_, _tmp23_ | GDK_ENTER_NOTIFY_MASK);
	_tmp24_ = self->priv->_scale;
	g_signal_connect_object ((GtkWidget*) _tmp24_, "button-press-event", (GCallback) __granite_seek_bar___lambda67__gtk_widget_button_press_event, self, 0);
	_tmp25_ = self->priv->_scale;
	g_signal_connect_object ((GtkWidget*) _tmp25_, "button-release-event", (GCallback) __granite_seek_bar___lambda68__gtk_widget_button_release_event, self, 0);
	_tmp26_ = self->priv->_scale;
	g_signal_connect_object ((GtkWidget*) _tmp26_, "enter-notify-event", (GCallback) __granite_seek_bar___lambda69__gtk_widget_enter_notify_event, self, 0);
	_tmp27_ = self->priv->_scale;
	g_signal_connect_object ((GtkWidget*) _tmp27_, "leave-notify-event", (GCallback) __granite_seek_bar___lambda70__gtk_widget_leave_notify_event, self, 0);
	_tmp28_ = self->priv->_scale;
	g_signal_connect_object ((GtkWidget*) _tmp28_, "motion-notify-event", (GCallback) __granite_seek_bar___lambda71__gtk_widget_motion_notify_event, self, 0);
	_tmp29_ = self->priv->_progression_label;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->_scale;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->_duration_label;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp31_);
	granite_seek_bar_set_playback_progress (self, 0.0);
	return obj;
}

static void
granite_seek_bar_class_init (GraniteSeekBarClass * klass,
                             gpointer klass_data)
{
	granite_seek_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteSeekBar_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) granite_seek_bar_real_get_preferred_width;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_seek_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_seek_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_seek_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_seek_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SEEK_BAR_PLAYBACK_DURATION_PROPERTY, granite_seek_bar_properties[GRANITE_SEEK_BAR_PLAYBACK_DURATION_PROPERTY] = g_param_spec_double ("playback-duration", "playback-duration", "playback-duration", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SEEK_BAR_PLAYBACK_PROGRESS_PROPERTY, granite_seek_bar_properties[GRANITE_SEEK_BAR_PLAYBACK_PROGRESS_PROPERTY] = g_param_spec_double ("playback-progress", "playback-progress", "playback-progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SEEK_BAR_IS_GRABBING_PROPERTY, granite_seek_bar_properties[GRANITE_SEEK_BAR_IS_GRABBING_PROPERTY] = g_param_spec_boolean ("is-grabbing", "is-grabbing", "is-grabbing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SEEK_BAR_IS_HOVERING_PROPERTY, granite_seek_bar_properties[GRANITE_SEEK_BAR_IS_HOVERING_PROPERTY] = g_param_spec_boolean ("is-hovering", "is-hovering", "is-hovering", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SEEK_BAR_PROGRESSION_LABEL_PROPERTY, granite_seek_bar_properties[GRANITE_SEEK_BAR_PROGRESSION_LABEL_PROPERTY] = g_param_spec_object ("progression-label", "progression-label", "progression-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SEEK_BAR_DURATION_LABEL_PROPERTY, granite_seek_bar_properties[GRANITE_SEEK_BAR_DURATION_LABEL_PROPERTY] = g_param_spec_object ("duration-label", "duration-label", "duration-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SEEK_BAR_SCALE_PROPERTY, granite_seek_bar_properties[GRANITE_SEEK_BAR_SCALE_PROPERTY] = g_param_spec_object ("scale", "scale", "scale", gtk_scale_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
granite_seek_bar_instance_init (GraniteSeekBar * self,
                                gpointer klass)
{
	self->priv = granite_seek_bar_get_instance_private (self);
	self->priv->_is_grabbing = FALSE;
	self->priv->_is_hovering = FALSE;
}

static void
granite_seek_bar_finalize (GObject * obj)
{
	GraniteSeekBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_SEEK_BAR, GraniteSeekBar);
	_g_object_unref0 (self->priv->_progression_label);
	_g_object_unref0 (self->priv->_duration_label);
	_g_object_unref0 (self->priv->_scale);
	G_OBJECT_CLASS (granite_seek_bar_parent_class)->finalize (obj);
}

/**
 * This widget is a playback statusbar that contains a Gtk.Scale widget and
 * two labels displaying the current progression and the total duration.
 *
 * Granite.SeekBar will get the style class .seek-bar
 *
 * {{../doc/images/SeekBar.png}}
 *
 * ''Example''<<BR>>
 * {{{
 * public class SeekBarView : Gtk.Grid {
 *     private Gtk.Popover preview_popover;
 *     private Gtk.Label preview_label;
 *
 *     public SeekBarView () {
 *         Object (valign: Gtk.Align.CENTER,
 *                 margin: 24);
 *     }
 *
 *     construct {
 *         preview_popover = new Gtk.Popover (this);
 *         preview_popover.can_focus = false;
 *         preview_popover.sensitive = false;
 *         preview_popover.modal = false;
 *         preview_popover.valign = Gtk.Align.CENTER;
 *
 *         preview_label = new Gtk.Label ("");
 *         preview_label.margin = 5;
 *         preview_popover.add (preview_label);
 *         preview_popover.show_all ();
 *         preview_popover.set_visible (false);
 *
 *         var seek_bar = new Granite.SeekBar (100);
 *
 *         preview_popover.relative_to = seek_bar.scale;
 *
 *         seek_bar.scale.motion_notify_event.connect ((event) => {
 *             update_pointing ((int) event.x);
 *             if (!seek_bar.is_grabbing) {
 *                 var duration_decimal = (event.x / ((double) event.window.get_width ()));
 *                 var duration_mins = Granite.DateTime.seconds_to_time ((int) (duration_decimal * seek_bar.playback_duration));
 *                 preview_label.label = duration_mins.to_string ();
 *             }
 *             return false;
 *         });
 *
 *         seek_bar.scale.enter_notify_event.connect (() => {
 *             preview_popover.set_visible (true);
 *             return false;
 *         });
 *
 *         seek_bar.scale.leave_notify_event.connect (() => {
 *             preview_popover.set_visible (false);
 *             return false;
 *         });
 *
 *         seek_bar.scale.button_press_event.connect (() => {
 *             preview_label.margin = 10;
 *             return false;
 *         });
 *
 *         seek_bar.scale.button_release_event.connect (() => {
 *             preview_label.margin = 5;
 *             return false;
 *         });
 *
 *         seek_bar.scale.change_value.connect ((scroll, new_value) => {
 *             if (new_value >= 0.0 && new_value <= 1.0) {
 *                 var duration_mins = Granite.DateTime.seconds_to_time ((int) (new_value * seek_bar.playback_duration));
 *                 preview_label.label = duration_mins.to_string ();
 *             }
 *             return false;
 *         });
 *
 *         add (seek_bar);
 *
 *         int progress = 0;
 *         Timeout.add (500, () => {
 *             if (seek_bar.is_grabbing) {
 *                 return true;
 *             }
 *
 *             if (progress >= 10) {
 *                 progress = 0;
 *                 seek_bar.playback_progress = 0.0;
 *             } else {
 *                 progress += 1;
 *                 seek_bar.playback_progress = progress / 10.0;
 *             }
 *             return true;
 *         });
 *     }
 *
 *     private void update_pointing (int x) {
 *         var pointing = preview_popover.pointing_to;
 *         pointing.x = x;
 *
 *         // changing the width properly updates arrow position when popover hits the edge
 *         if (pointing.width == 0) {
 *             pointing.width = 2;
 *             pointing.x -= 1;
 *         } else {
 *             pointing.width = 0;
 *         }
 *
 *         preview_popover.set_pointing_to (pointing);
 *     }
 * }
 * }}}
 */
static GType
granite_seek_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteSeekBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_seek_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteSeekBar), 0, (GInstanceInitFunc) granite_seek_bar_instance_init, NULL };
	GType granite_seek_bar_type_id;
	granite_seek_bar_type_id = g_type_register_static (gtk_grid_get_type (), "GraniteSeekBar", &g_define_type_info, 0);
	GraniteSeekBar_private_offset = g_type_add_instance_private (granite_seek_bar_type_id, sizeof (GraniteSeekBarPrivate));
	return granite_seek_bar_type_id;
}

GType
granite_seek_bar_get_type (void)
{
	static volatile gsize granite_seek_bar_type_id__once = 0;
	if (g_once_init_enter (&granite_seek_bar_type_id__once)) {
		GType granite_seek_bar_type_id;
		granite_seek_bar_type_id = granite_seek_bar_get_type_once ();
		g_once_init_leave (&granite_seek_bar_type_id__once, granite_seek_bar_type_id);
	}
	return granite_seek_bar_type_id__once;
}

static void
_vala_granite_seek_bar_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GraniteSeekBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_SEEK_BAR, GraniteSeekBar);
	switch (property_id) {
		case GRANITE_SEEK_BAR_PLAYBACK_DURATION_PROPERTY:
		g_value_set_double (value, granite_seek_bar_get_playback_duration (self));
		break;
		case GRANITE_SEEK_BAR_PLAYBACK_PROGRESS_PROPERTY:
		g_value_set_double (value, granite_seek_bar_get_playback_progress (self));
		break;
		case GRANITE_SEEK_BAR_IS_GRABBING_PROPERTY:
		g_value_set_boolean (value, granite_seek_bar_get_is_grabbing (self));
		break;
		case GRANITE_SEEK_BAR_IS_HOVERING_PROPERTY:
		g_value_set_boolean (value, granite_seek_bar_get_is_hovering (self));
		break;
		case GRANITE_SEEK_BAR_PROGRESSION_LABEL_PROPERTY:
		g_value_set_object (value, granite_seek_bar_get_progression_label (self));
		break;
		case GRANITE_SEEK_BAR_DURATION_LABEL_PROPERTY:
		g_value_set_object (value, granite_seek_bar_get_duration_label (self));
		break;
		case GRANITE_SEEK_BAR_SCALE_PROPERTY:
		g_value_set_object (value, granite_seek_bar_get_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_seek_bar_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GraniteSeekBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_SEEK_BAR, GraniteSeekBar);
	switch (property_id) {
		case GRANITE_SEEK_BAR_PLAYBACK_DURATION_PROPERTY:
		granite_seek_bar_set_playback_duration (self, g_value_get_double (value));
		break;
		case GRANITE_SEEK_BAR_PLAYBACK_PROGRESS_PROPERTY:
		granite_seek_bar_set_playback_progress (self, g_value_get_double (value));
		break;
		case GRANITE_SEEK_BAR_IS_GRABBING_PROPERTY:
		granite_seek_bar_set_is_grabbing (self, g_value_get_boolean (value));
		break;
		case GRANITE_SEEK_BAR_IS_HOVERING_PROPERTY:
		granite_seek_bar_set_is_hovering (self, g_value_get_boolean (value));
		break;
		case GRANITE_SEEK_BAR_PROGRESSION_LABEL_PROPERTY:
		granite_seek_bar_set_progression_label (self, g_value_get_object (value));
		break;
		case GRANITE_SEEK_BAR_DURATION_LABEL_PROPERTY:
		granite_seek_bar_set_duration_label (self, g_value_get_object (value));
		break;
		case GRANITE_SEEK_BAR_SCALE_PROPERTY:
		granite_seek_bar_set_scale (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

