/* OverlayBar.c generated by valac 0.56.17, the Vala compiler
 * generated from OverlayBar.vala, do not modify */

/*
 * Copyright 2021-2022 elementary, Inc. (https://elementary.io)
 * Copyright 2012 ammonkey <am.monkeyd@gmail.com>
 * Copyright 2013 Julián Unrrein <junrrein@gmail.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite-7.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_OVERLAY_BAR_0_PROPERTY,
	GRANITE_OVERLAY_BAR_OVERLAY_PROPERTY,
	GRANITE_OVERLAY_BAR_LABEL_PROPERTY,
	GRANITE_OVERLAY_BAR_ACTIVE_PROPERTY,
	GRANITE_OVERLAY_BAR_NUM_PROPERTIES
};
static GParamSpec* granite_overlay_bar_properties[GRANITE_OVERLAY_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GraniteOverlayBarPrivate {
	GtkOverlay* _overlay;
	gchar* _label;
	gboolean _active;
};

static gint GraniteOverlayBar_private_offset;
static gpointer granite_overlay_bar_parent_class = NULL;

static void granite_overlay_bar_enter_notify_callback (GraniteOverlayBar* self);
static GObject * granite_overlay_bar_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _granite_overlay_bar_enter_notify_callback_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                                   gdouble x,
                                                                                   gdouble y,
                                                                                   gpointer self);
static void granite_overlay_bar_finalize (GObject * obj);
static GType granite_overlay_bar_get_type_once (void);
static void _vala_granite_overlay_bar_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_granite_overlay_bar_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
granite_overlay_bar_get_instance_private (GraniteOverlayBar* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteOverlayBar_private_offset);
}

GtkOverlay*
granite_overlay_bar_get_overlay (GraniteOverlayBar* self)
{
	GtkOverlay* result;
	GtkOverlay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_overlay;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
granite_overlay_bar_set_overlay (GraniteOverlayBar* self,
                                 GtkOverlay* value)
{
	GtkOverlay* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_overlay_bar_get_overlay (self);
	if (old_value != value) {
		GtkOverlay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_overlay);
		self->priv->_overlay = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_overlay_bar_properties[GRANITE_OVERLAY_BAR_OVERLAY_PROPERTY]);
	}
}

const gchar*
granite_overlay_bar_get_label (GraniteOverlayBar* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
granite_overlay_bar_set_label (GraniteOverlayBar* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_overlay_bar_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_overlay_bar_properties[GRANITE_OVERLAY_BAR_LABEL_PROPERTY]);
	}
}

gboolean
granite_overlay_bar_get_active (GraniteOverlayBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
granite_overlay_bar_set_active (GraniteOverlayBar* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_overlay_bar_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, granite_overlay_bar_properties[GRANITE_OVERLAY_BAR_ACTIVE_PROPERTY]);
	}
}

/**
     * Create a new Overlay Bar, and add it to the {@link Gtk.Overlay}.
     */
GraniteOverlayBar*
granite_overlay_bar_construct (GType object_type,
                               GtkOverlay* overlay)
{
	GraniteOverlayBar * self = NULL;
	self = (GraniteOverlayBar*) g_object_new (object_type, NULL);
	if (overlay != NULL) {
		gtk_overlay_add_overlay (overlay, (GtkWidget*) self);
	}
	return self;
}

GraniteOverlayBar*
granite_overlay_bar_new (GtkOverlay* overlay)
{
	return granite_overlay_bar_construct (GRANITE_TYPE_OVERLAY_BAR, overlay);
}

static void
granite_overlay_bar_enter_notify_callback (GraniteOverlayBar* self)
{
	GtkAlign _tmp0_;
	GtkAlign _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_halign ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GTK_ALIGN_START) {
		gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_END);
	} else {
		gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
}

static void
_granite_overlay_bar_enter_notify_callback_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                              gdouble x,
                                                                              gdouble y,
                                                                              gpointer self)
{
	granite_overlay_bar_enter_notify_callback ((GraniteOverlayBar*) self);
}

static GObject *
granite_overlay_bar_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteOverlayBar * self;
	GtkLabel* status_label = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp1_ = NULL;
	GtkRevealer* revealer = NULL;
	GtkSpinner* _tmp2_;
	GtkWidget* _tmp3_;
	GtkRevealer* _tmp4_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkRevealer* _tmp10_;
	GtkBox* _tmp11_;
	GtkEventControllerMotion* focus_controller = NULL;
	GtkEventControllerMotion* _tmp12_;
	GtkEventControllerMotion* _tmp13_;
	GtkEventControllerMotion* _tmp14_;
	GtkEventController* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkLabel* _tmp17_;
	parent_class = G_OBJECT_CLASS (granite_overlay_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_OVERLAY_BAR, GraniteOverlayBar);
	granite_overlay_bar_set_overlay (self, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_ellipsize (_tmp0_, PANGO_ELLIPSIZE_END);
	g_object_ref_sink (_tmp0_);
	status_label = _tmp0_;
	_tmp1_ = (GtkSpinner*) gtk_spinner_new ();
	gtk_spinner_set_spinning (_tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	spinner = _tmp1_;
	_tmp2_ = spinner;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp4_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	gtk_revealer_set_child (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	revealer = _tmp4_;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp5_);
	box = _tmp5_;
	_tmp6_ = box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, GRANITE_STYLE_CLASS_OSD);
	_tmp7_ = box;
	_tmp8_ = status_label;
	gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = box;
	_tmp10_ = revealer;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = box;
	gtk_widget_set_parent ((GtkWidget*) _tmp11_, (GtkWidget*) self);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_END);
	_tmp12_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	focus_controller = _tmp12_;
	_tmp13_ = focus_controller;
	g_signal_connect_object (_tmp13_, "enter", (GCallback) _granite_overlay_bar_enter_notify_callback_gtk_event_controller_motion_enter, self, 0);
	_tmp14_ = focus_controller;
	_tmp15_ = _g_object_ref0 ((GtkEventController*) _tmp14_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp15_);
	_tmp16_ = revealer;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp16_, "reveal-child", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp17_ = status_label;
	g_object_bind_property_with_closures ((GObject*) self, "label", (GObject*) _tmp17_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (focus_controller);
	_g_object_unref0 (box);
	_g_object_unref0 (revealer);
	_g_object_unref0 (spinner);
	_g_object_unref0 (status_label);
	return obj;
}

static void
granite_overlay_bar_base_init (GraniteOverlayBarClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "overlaybar");
}

static void
granite_overlay_bar_class_init (GraniteOverlayBarClass * klass,
                                gpointer klass_data)
{
	granite_overlay_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteOverlayBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_overlay_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_overlay_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_overlay_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_overlay_bar_finalize;
	/**
	     * {@link Gtk.Overlay} to add #this to
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_OVERLAY_BAR_OVERLAY_PROPERTY, granite_overlay_bar_properties[GRANITE_OVERLAY_BAR_OVERLAY_PROPERTY] = g_param_spec_object ("overlay", "overlay", "overlay", gtk_overlay_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Text displayed inside the Overlay Bar.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_OVERLAY_BAR_LABEL_PROPERTY, granite_overlay_bar_properties[GRANITE_OVERLAY_BAR_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether to display a {@link Gtk.Spinner} inside the Overlay Bar.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_OVERLAY_BAR_ACTIVE_PROPERTY, granite_overlay_bar_properties[GRANITE_OVERLAY_BAR_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_layout_manager_type (GTK_WIDGET_CLASS (klass), gtk_bin_layout_get_type ());
}

static void
granite_overlay_bar_instance_init (GraniteOverlayBar * self,
                                   gpointer klass)
{
	self->priv = granite_overlay_bar_get_instance_private (self);
}

static void
granite_overlay_bar_finalize (GObject * obj)
{
	GraniteOverlayBar * self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_OVERLAY_BAR, GraniteOverlayBar);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	gtk_widget_unparent (_tmp0_);
	_g_object_unref0 (self->priv->_overlay);
	_g_free0 (self->priv->_label);
	G_OBJECT_CLASS (granite_overlay_bar_parent_class)->finalize (obj);
}

/**
 * A floating status bar that displays a single line of text.
 *
 * This widget is intended to be used as an overlay for a {@link Gtk.Overlay} and is placed in the
 * bottom-right corner by default. You can change its position like you would do for any overlay
 * widget used in a {@link Gtk.Overlay}.
 *
 * The Overlay Bar displays a single line of text that can be changed using the "status" property.
 *
 * {{../doc/images/OverlayBar.png}}
 *
 * This widget tries to avoid getting in front of the content being displayed inside the {@link Gtk.Overlay}
 * by moving itself horizontally to the opposite side from the current one when the mouse pointer enters
 * the widget.
 *
 * For this widget to function correctly, the event {@link Gdk.EventMask.ENTER_NOTIFY_MASK} must be set
 * for the parent {@link Gtk.Overlay}. Overlay Bar's constructor takes care of this automatically, if
 * the parent is supplied as a parameter, but you have to be careful not to unset the event for
 * the {@link Gtk.Overlay} at a later stage.
 *
 * ''Example''<<BR>>
 * {{{
 * public class OverlayBarView : Gtk.Overlay {
 *     construct {
 *         var button = new Gtk.ToggleButton.with_label ("Show Spinner");
 *
 *         var box = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6) {
 *             halign = Gtk.Align.CENTER,
 *             valign = Gtk.Align.CENTER
 *         };
 *         grid.append (button);
 *
 *         var overlaybar = new Granite.OverlayBar (this) {
 *             label = "Hover the OverlayBar to change its position"
 *         };
 *
 *         child = box;
 *
 *         button.toggled.connect (() => {
 *             overlaybar.active = button.active;
 *         });
 *     }
 * }
 * }}}
 *
 * @see Gtk.Overlay
 *
 */
static GType
granite_overlay_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteOverlayBarClass), (GBaseInitFunc) granite_overlay_bar_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_overlay_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteOverlayBar), 0, (GInstanceInitFunc) granite_overlay_bar_instance_init, NULL };
	GType granite_overlay_bar_type_id;
	granite_overlay_bar_type_id = g_type_register_static (gtk_widget_get_type (), "GraniteOverlayBar", &g_define_type_info, 0);
	GraniteOverlayBar_private_offset = g_type_add_instance_private (granite_overlay_bar_type_id, sizeof (GraniteOverlayBarPrivate));
	return granite_overlay_bar_type_id;
}

GType
granite_overlay_bar_get_type (void)
{
	static volatile gsize granite_overlay_bar_type_id__once = 0;
	if (g_once_init_enter (&granite_overlay_bar_type_id__once)) {
		GType granite_overlay_bar_type_id;
		granite_overlay_bar_type_id = granite_overlay_bar_get_type_once ();
		g_once_init_leave (&granite_overlay_bar_type_id__once, granite_overlay_bar_type_id);
	}
	return granite_overlay_bar_type_id__once;
}

static void
_vala_granite_overlay_bar_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GraniteOverlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_OVERLAY_BAR, GraniteOverlayBar);
	switch (property_id) {
		case GRANITE_OVERLAY_BAR_OVERLAY_PROPERTY:
		g_value_set_object (value, granite_overlay_bar_get_overlay (self));
		break;
		case GRANITE_OVERLAY_BAR_LABEL_PROPERTY:
		g_value_set_string (value, granite_overlay_bar_get_label (self));
		break;
		case GRANITE_OVERLAY_BAR_ACTIVE_PROPERTY:
		g_value_set_boolean (value, granite_overlay_bar_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_overlay_bar_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GraniteOverlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_OVERLAY_BAR, GraniteOverlayBar);
	switch (property_id) {
		case GRANITE_OVERLAY_BAR_OVERLAY_PROPERTY:
		granite_overlay_bar_set_overlay (self, g_value_get_object (value));
		break;
		case GRANITE_OVERLAY_BAR_LABEL_PROPERTY:
		granite_overlay_bar_set_label (self, g_value_get_string (value));
		break;
		case GRANITE_OVERLAY_BAR_ACTIVE_PROPERTY:
		granite_overlay_bar_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

