{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The GTree struct is an opaque data structure representing a
-- <http://developer.gnome.org/glib/stable/data-structures.html#binary-trees balanced binary tree>. It should be
-- accessed only by using the following functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Tree
    ( 

-- * Exported types
    Tree(..)                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [destroy]("GI.GLib.Structs.Tree#g:method:destroy"), [foreach]("GI.GLib.Structs.Tree#g:method:foreach"), [foreachNode]("GI.GLib.Structs.Tree#g:method:foreachNode"), [height]("GI.GLib.Structs.Tree#g:method:height"), [insert]("GI.GLib.Structs.Tree#g:method:insert"), [insertNode]("GI.GLib.Structs.Tree#g:method:insertNode"), [lookup]("GI.GLib.Structs.Tree#g:method:lookup"), [lookupExtended]("GI.GLib.Structs.Tree#g:method:lookupExtended"), [lookupNode]("GI.GLib.Structs.Tree#g:method:lookupNode"), [lowerBound]("GI.GLib.Structs.Tree#g:method:lowerBound"), [nnodes]("GI.GLib.Structs.Tree#g:method:nnodes"), [nodeFirst]("GI.GLib.Structs.Tree#g:method:nodeFirst"), [nodeLast]("GI.GLib.Structs.Tree#g:method:nodeLast"), [ref]("GI.GLib.Structs.Tree#g:method:ref"), [remove]("GI.GLib.Structs.Tree#g:method:remove"), [removeAll]("GI.GLib.Structs.Tree#g:method:removeAll"), [replace]("GI.GLib.Structs.Tree#g:method:replace"), [replaceNode]("GI.GLib.Structs.Tree#g:method:replaceNode"), [search]("GI.GLib.Structs.Tree#g:method:search"), [searchNode]("GI.GLib.Structs.Tree#g:method:searchNode"), [steal]("GI.GLib.Structs.Tree#g:method:steal"), [traverse]("GI.GLib.Structs.Tree#g:method:traverse"), [unref]("GI.GLib.Structs.Tree#g:method:unref"), [upperBound]("GI.GLib.Structs.Tree#g:method:upperBound").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTreeMethod                       ,
#endif

-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    TreeDestroyMethodInfo                   ,
#endif
    treeDestroy                             ,


-- ** foreach #method:foreach#

#if defined(ENABLE_OVERLOADING)
    TreeForeachMethodInfo                   ,
#endif
    treeForeach                             ,


-- ** foreachNode #method:foreachNode#

#if defined(ENABLE_OVERLOADING)
    TreeForeachNodeMethodInfo               ,
#endif
    treeForeachNode                         ,


-- ** height #method:height#

#if defined(ENABLE_OVERLOADING)
    TreeHeightMethodInfo                    ,
#endif
    treeHeight                              ,


-- ** insert #method:insert#

#if defined(ENABLE_OVERLOADING)
    TreeInsertMethodInfo                    ,
#endif
    treeInsert                              ,


-- ** insertNode #method:insertNode#

#if defined(ENABLE_OVERLOADING)
    TreeInsertNodeMethodInfo                ,
#endif
    treeInsertNode                          ,


-- ** lookup #method:lookup#

#if defined(ENABLE_OVERLOADING)
    TreeLookupMethodInfo                    ,
#endif
    treeLookup                              ,


-- ** lookupExtended #method:lookupExtended#

#if defined(ENABLE_OVERLOADING)
    TreeLookupExtendedMethodInfo            ,
#endif
    treeLookupExtended                      ,


-- ** lookupNode #method:lookupNode#

#if defined(ENABLE_OVERLOADING)
    TreeLookupNodeMethodInfo                ,
#endif
    treeLookupNode                          ,


-- ** lowerBound #method:lowerBound#

#if defined(ENABLE_OVERLOADING)
    TreeLowerBoundMethodInfo                ,
#endif
    treeLowerBound                          ,


-- ** newFull #method:newFull#

    treeNewFull                             ,


-- ** nnodes #method:nnodes#

#if defined(ENABLE_OVERLOADING)
    TreeNnodesMethodInfo                    ,
#endif
    treeNnodes                              ,


-- ** nodeFirst #method:nodeFirst#

#if defined(ENABLE_OVERLOADING)
    TreeNodeFirstMethodInfo                 ,
#endif
    treeNodeFirst                           ,


-- ** nodeLast #method:nodeLast#

#if defined(ENABLE_OVERLOADING)
    TreeNodeLastMethodInfo                  ,
#endif
    treeNodeLast                            ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    TreeRefMethodInfo                       ,
#endif
    treeRef                                 ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    TreeRemoveMethodInfo                    ,
#endif
    treeRemove                              ,


-- ** removeAll #method:removeAll#

#if defined(ENABLE_OVERLOADING)
    TreeRemoveAllMethodInfo                 ,
#endif
    treeRemoveAll                           ,


-- ** replace #method:replace#

#if defined(ENABLE_OVERLOADING)
    TreeReplaceMethodInfo                   ,
#endif
    treeReplace                             ,


-- ** replaceNode #method:replaceNode#

#if defined(ENABLE_OVERLOADING)
    TreeReplaceNodeMethodInfo               ,
#endif
    treeReplaceNode                         ,


-- ** search #method:search#

#if defined(ENABLE_OVERLOADING)
    TreeSearchMethodInfo                    ,
#endif
    treeSearch                              ,


-- ** searchNode #method:searchNode#

#if defined(ENABLE_OVERLOADING)
    TreeSearchNodeMethodInfo                ,
#endif
    treeSearchNode                          ,


-- ** steal #method:steal#

#if defined(ENABLE_OVERLOADING)
    TreeStealMethodInfo                     ,
#endif
    treeSteal                               ,


-- ** traverse #method:traverse#

#if defined(ENABLE_OVERLOADING)
    TreeTraverseMethodInfo                  ,
#endif
    treeTraverse                            ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    TreeUnrefMethodInfo                     ,
#endif
    treeUnref                               ,


-- ** upperBound #method:upperBound#

#if defined(ENABLE_OVERLOADING)
    TreeUpperBoundMethodInfo                ,
#endif
    treeUpperBound                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Structs.TreeNode as GLib.TreeNode

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Structs.TreeNode as GLib.TreeNode

#endif

-- | Memory-managed wrapper type.
newtype Tree = Tree (SP.ManagedPtr Tree)
    deriving (Eq)

instance SP.ManagedPtrNewtype Tree where
    toManagedPtr (Tree p) = p

foreign import ccall "g_tree_get_type" c_g_tree_get_type :: 
    IO GType

type instance O.ParentTypes Tree = '[]
instance O.HasParentTypes Tree

instance B.Types.TypedObject Tree where
    glibType = c_g_tree_get_type

instance B.Types.GBoxed Tree

-- | Convert t'Tree' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Tree) where
    gvalueGType_ = c_g_tree_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Tree)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Tree)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Tree ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Tree
type instance O.AttributeList Tree = TreeAttributeList
type TreeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Tree::new_full
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "key_compare_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "qsort()-style comparison function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key_compare_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to comparison function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key_destroy_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a function to free the memory allocated for the key\n  used when removing the entry from the #GTree or %NULL if you don't\n  want to supply such a function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value_destroy_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a function to free the memory allocated for the\n  value used when removing the entry from the #GTree or %NULL if you\n  don't want to supply such a function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Tree" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_new_full" g_tree_new_full :: 
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- key_compare_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- key_compare_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- key_destroy_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- value_destroy_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr Tree)

-- | Creates a new t'GI.GLib.Structs.Tree.Tree' like @/g_tree_new()/@ and allows to specify functions
-- to free the memory allocated for the key and value that get called when
-- removing the entry from the t'GI.GLib.Structs.Tree.Tree'.
treeNewFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Callbacks.CompareDataFunc
    -- ^ /@keyCompareFunc@/: @/qsort()/@-style comparison function
    -> GLib.Callbacks.DestroyNotify
    -- ^ /@keyDestroyFunc@/: a function to free the memory allocated for the key
    --   used when removing the entry from the t'GI.GLib.Structs.Tree.Tree' or 'P.Nothing' if you don\'t
    --   want to supply such a function
    -> m Tree
    -- ^ __Returns:__ a newly allocated t'GI.GLib.Structs.Tree.Tree'
treeNewFull keyCompareFunc keyDestroyFunc = liftIO $ do
    keyCompareFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc keyCompareFunc))
    ptrkeyDestroyFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
    keyDestroyFunc' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrkeyDestroyFunc) keyDestroyFunc)
    poke ptrkeyDestroyFunc keyDestroyFunc'
    let keyCompareData = castFunPtrToPtr keyCompareFunc'
    let valueDestroyFunc = SP.safeFreeFunPtrPtr
    result <- g_tree_new_full keyCompareFunc' keyCompareData keyDestroyFunc' valueDestroyFunc
    checkUnexpectedReturnNULL "treeNewFull" result
    result' <- (wrapBoxed Tree) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Tree::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_destroy" g_tree_destroy :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO ()

-- | Removes all keys and values from the t'GI.GLib.Structs.Tree.Tree' and decreases its
-- reference count by one. If keys and\/or values are dynamically
-- allocated, you should either free them first or create the t'GI.GLib.Structs.Tree.Tree'
-- using 'GI.GLib.Structs.Tree.treeNewFull'. In the latter case the destroy functions
-- you supplied will be called on all keys and values before destroying
-- the t'GI.GLib.Structs.Tree.Tree'.
treeDestroy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m ()
treeDestroy tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    g_tree_destroy tree'
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TreeDestroyMethodInfo Tree signature where
    overloadedMethod = treeDestroy

instance O.OverloadedMethodInfo TreeDestroyMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeDestroy"
        })


#endif

-- method Tree::foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the function to call for each node visited.\n    If this function returns %TRUE, the traversal is stopped."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_foreach" g_tree_foreach :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    FunPtr GLib.Callbacks.C_TraverseFunc -> -- func : TInterface (Name {namespace = "GLib", name = "TraverseFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Calls the given function for each of the key\/value pairs in the t'GI.GLib.Structs.Tree.Tree'.
-- The function is passed the key and value of each pair, and the given
-- /@data@/ parameter. The tree is traversed in sorted order.
-- 
-- The tree may not be modified while iterating over it (you can\'t
-- add\/remove items). To remove all items matching a predicate, you need
-- to add each item to a list in your t'GI.GLib.Callbacks.TraverseFunc' as you walk over
-- the tree, then walk the list and remove each item.
treeForeach ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> GLib.Callbacks.TraverseFunc
    -- ^ /@func@/: the function to call for each node visited.
    --     If this function returns 'P.True', the traversal is stopped.
    -> m ()
treeForeach tree func = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    func' <- GLib.Callbacks.mk_TraverseFunc (GLib.Callbacks.wrap_TraverseFunc Nothing func)
    let userData = nullPtr
    g_tree_foreach tree' func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeForeachMethodInfo
instance (signature ~ (GLib.Callbacks.TraverseFunc -> m ()), MonadIO m) => O.OverloadedMethod TreeForeachMethodInfo Tree signature where
    overloadedMethod = treeForeach

instance O.OverloadedMethodInfo TreeForeachMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeForeach"
        })


#endif

-- method Tree::foreach_node
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseNodeFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the function to call for each node visited.\n    If this function returns %TRUE, the traversal is stopped."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_foreach_node" g_tree_foreach_node :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    FunPtr GLib.Callbacks.C_TraverseNodeFunc -> -- func : TInterface (Name {namespace = "GLib", name = "TraverseNodeFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Calls the given function for each of the nodes in the t'GI.GLib.Structs.Tree.Tree'.
-- The function is passed the pointer to the particular node, and the given
-- /@data@/ parameter. The tree traversal happens in-order.
-- 
-- The tree may not be modified while iterating over it (you can\'t
-- add\/remove items). To remove all items matching a predicate, you need
-- to add each item to a list in your t'GI.GLib.Callbacks.TraverseFunc' as you walk over
-- the tree, then walk the list and remove each item.
-- 
-- /Since: 2.68/
treeForeachNode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> GLib.Callbacks.TraverseNodeFunc
    -- ^ /@func@/: the function to call for each node visited.
    --     If this function returns 'P.True', the traversal is stopped.
    -> m ()
treeForeachNode tree func = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    func' <- GLib.Callbacks.mk_TraverseNodeFunc (GLib.Callbacks.wrap_TraverseNodeFunc Nothing func)
    let userData = nullPtr
    g_tree_foreach_node tree' func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeForeachNodeMethodInfo
instance (signature ~ (GLib.Callbacks.TraverseNodeFunc -> m ()), MonadIO m) => O.OverloadedMethod TreeForeachNodeMethodInfo Tree signature where
    overloadedMethod = treeForeachNode

instance O.OverloadedMethodInfo TreeForeachNodeMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeForeachNode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeForeachNode"
        })


#endif

-- method Tree::height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_height" g_tree_height :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO Int32

-- | Gets the height of a t'GI.GLib.Structs.Tree.Tree'.
-- 
-- If the t'GI.GLib.Structs.Tree.Tree' contains no nodes, the height is 0.
-- If the t'GI.GLib.Structs.Tree.Tree' contains only one root node the height is 1.
-- If the root node has children the height is 2, etc.
treeHeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m Int32
    -- ^ __Returns:__ the height of /@tree@/
treeHeight tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_height tree'
    touchManagedPtr tree
    return result

#if defined(ENABLE_OVERLOADING)
data TreeHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod TreeHeightMethodInfo Tree signature where
    overloadedMethod = treeHeight

instance O.OverloadedMethodInfo TreeHeightMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeHeight"
        })


#endif

-- method Tree::insert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to insert" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value corresponding to the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_insert" g_tree_insert :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    Ptr () ->                               -- value : TBasicType TPtr
    IO ()

-- | Inserts a key\/value pair into a t'GI.GLib.Structs.Tree.Tree'.
-- 
-- Inserts a new key and value into a t'GI.GLib.Structs.Tree.Tree' as 'GI.GLib.Structs.Tree.treeInsertNode' does,
-- only this function does not return the inserted or set node.
treeInsert ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to insert
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> m ()
treeInsert tree key value = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    g_tree_insert tree' key value
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeInsertMethodInfo
instance (signature ~ (Ptr () -> Ptr () -> m ()), MonadIO m) => O.OverloadedMethod TreeInsertMethodInfo Tree signature where
    overloadedMethod = treeInsert

instance O.OverloadedMethodInfo TreeInsertMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeInsert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeInsert"
        })


#endif

-- method Tree::insert_node
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to insert" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value corresponding to the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_insert_node" g_tree_insert_node :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    Ptr () ->                               -- value : TBasicType TPtr
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Inserts a key\/value pair into a t'GI.GLib.Structs.Tree.Tree'.
-- 
-- If the given key already exists in the t'GI.GLib.Structs.Tree.Tree' its corresponding value
-- is set to the new value. If you supplied a /@valueDestroyFunc@/ when
-- creating the t'GI.GLib.Structs.Tree.Tree', the old value is freed using that function. If
-- you supplied a /@keyDestroyFunc@/ when creating the t'GI.GLib.Structs.Tree.Tree', the passed
-- key is freed using that function.
-- 
-- The tree is automatically \'balanced\' as new key\/value pairs are added,
-- so that the distance from the root to every leaf is as small as possible.
-- The cost of maintaining a balanced tree while inserting new key\/value
-- result in a O(n log(n)) operation where most of the other operations
-- are O(log(n)).
-- 
-- /Since: 2.68/
treeInsertNode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to insert
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the inserted (or set) node or 'P.Nothing'
    -- if insertion would overflow the tree node counter.
treeInsertNode tree key value = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_insert_node tree' key value
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeInsertNodeMethodInfo
instance (signature ~ (Ptr () -> Ptr () -> m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeInsertNodeMethodInfo Tree signature where
    overloadedMethod = treeInsertNode

instance O.OverloadedMethodInfo TreeInsertNodeMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeInsertNode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeInsertNode"
        })


#endif

-- method Tree::lookup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to look up" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_lookup" g_tree_lookup :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    IO (Ptr ())

-- | Gets the value corresponding to the given key. Since a t'GI.GLib.Structs.Tree.Tree' is
-- automatically balanced as key\/value pairs are added, key lookup
-- is O(log n) (where n is the number of key\/value pairs in the tree).
treeLookup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to look up
    -> m (Ptr ())
    -- ^ __Returns:__ the value corresponding to the key, or 'P.Nothing'
    --     if the key was not found
treeLookup tree key = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_lookup tree' key
    touchManagedPtr tree
    return result

#if defined(ENABLE_OVERLOADING)
data TreeLookupMethodInfo
instance (signature ~ (Ptr () -> m (Ptr ())), MonadIO m) => O.OverloadedMethod TreeLookupMethodInfo Tree signature where
    overloadedMethod = treeLookup

instance O.OverloadedMethodInfo TreeLookupMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeLookup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeLookup"
        })


#endif

-- method Tree::lookup_extended
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lookup_key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to look up" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "orig_key"
--           , argType = TBasicType TPtr
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "returns the original key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "returns the value associated with the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_lookup_extended" g_tree_lookup_extended :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- lookup_key : TBasicType TPtr
    Ptr (Ptr ()) ->                         -- orig_key : TBasicType TPtr
    Ptr (Ptr ()) ->                         -- value : TBasicType TPtr
    IO CInt

-- | Looks up a key in the t'GI.GLib.Structs.Tree.Tree', returning the original key and the
-- associated value. This is useful if you need to free the memory
-- allocated for the original key, for example before calling
-- 'GI.GLib.Structs.Tree.treeRemove'.
treeLookupExtended ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@lookupKey@/: the key to look up
    -> m ((Bool, Ptr (), Ptr ()))
    -- ^ __Returns:__ 'P.True' if the key was found in the t'GI.GLib.Structs.Tree.Tree'
treeLookupExtended tree lookupKey = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    origKey <- callocMem :: IO (Ptr (Ptr ()))
    value <- callocMem :: IO (Ptr (Ptr ()))
    result <- g_tree_lookup_extended tree' lookupKey origKey value
    let result' = (/= 0) result
    origKey' <- peek origKey
    value' <- peek value
    touchManagedPtr tree
    freeMem origKey
    freeMem value
    return (result', origKey', value')

#if defined(ENABLE_OVERLOADING)
data TreeLookupExtendedMethodInfo
instance (signature ~ (Ptr () -> m ((Bool, Ptr (), Ptr ()))), MonadIO m) => O.OverloadedMethod TreeLookupExtendedMethodInfo Tree signature where
    overloadedMethod = treeLookupExtended

instance O.OverloadedMethodInfo TreeLookupExtendedMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeLookupExtended",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeLookupExtended"
        })


#endif

-- method Tree::lookup_node
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to look up" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_lookup_node" g_tree_lookup_node :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Gets the tree node corresponding to the given key. Since a t'GI.GLib.Structs.Tree.Tree' is
-- automatically balanced as key\/value pairs are added, key lookup
-- is O(log n) (where n is the number of key\/value pairs in the tree).
-- 
-- /Since: 2.68/
treeLookupNode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to look up
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the tree node corresponding to
    --          the key, or 'P.Nothing' if the key was not found
treeLookupNode tree key = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_lookup_node tree' key
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeLookupNodeMethodInfo
instance (signature ~ (Ptr () -> m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeLookupNodeMethodInfo Tree signature where
    overloadedMethod = treeLookupNode

instance O.OverloadedMethodInfo TreeLookupNodeMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeLookupNode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeLookupNode"
        })


#endif

-- method Tree::lower_bound
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to calculate the lower bound for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_lower_bound" g_tree_lower_bound :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Gets the lower bound node corresponding to the given key,
-- or 'P.Nothing' if the tree is empty or all the nodes in the tree
-- have keys that are strictly lower than the searched key.
-- 
-- The lower bound is the first node that has its key greater
-- than or equal to the searched key.
-- 
-- /Since: 2.68/
treeLowerBound ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to calculate the lower bound for
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the tree node corresponding to
    --          the lower bound, or 'P.Nothing' if the tree is empty or has only
    --          keys strictly lower than the searched key.
treeLowerBound tree key = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_lower_bound tree' key
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeLowerBoundMethodInfo
instance (signature ~ (Ptr () -> m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeLowerBoundMethodInfo Tree signature where
    overloadedMethod = treeLowerBound

instance O.OverloadedMethodInfo TreeLowerBoundMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeLowerBound",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeLowerBound"
        })


#endif

-- method Tree::nnodes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_nnodes" g_tree_nnodes :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO Int32

-- | Gets the number of nodes in a t'GI.GLib.Structs.Tree.Tree'.
treeNnodes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m Int32
    -- ^ __Returns:__ the number of nodes in /@tree@/
    -- 
    -- The node counter value type is really a @/guint/@,
    -- but it is returned as a @/gint/@ due to backward
    -- compatibility issues (can be cast back to @/guint/@ to
    -- support its full range of values).
treeNnodes tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_nnodes tree'
    touchManagedPtr tree
    return result

#if defined(ENABLE_OVERLOADING)
data TreeNnodesMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod TreeNnodesMethodInfo Tree signature where
    overloadedMethod = treeNnodes

instance O.OverloadedMethodInfo TreeNnodesMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeNnodes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeNnodes"
        })


#endif

-- method Tree::node_first
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_node_first" g_tree_node_first :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Returns the first in-order node of the tree, or 'P.Nothing'
-- for an empty tree.
-- 
-- /Since: 2.68/
treeNodeFirst ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the first node in the tree
treeNodeFirst tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_node_first tree'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeNodeFirstMethodInfo
instance (signature ~ (m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeNodeFirstMethodInfo Tree signature where
    overloadedMethod = treeNodeFirst

instance O.OverloadedMethodInfo TreeNodeFirstMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeNodeFirst",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeNodeFirst"
        })


#endif

-- method Tree::node_last
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_node_last" g_tree_node_last :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Returns the last in-order node of the tree, or 'P.Nothing'
-- for an empty tree.
-- 
-- /Since: 2.68/
treeNodeLast ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the last node in the tree
treeNodeLast tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_node_last tree'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeNodeLastMethodInfo
instance (signature ~ (m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeNodeLastMethodInfo Tree signature where
    overloadedMethod = treeNodeLast

instance O.OverloadedMethodInfo TreeNodeLastMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeNodeLast",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeNodeLast"
        })


#endif

-- method Tree::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Tree" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_ref" g_tree_ref :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO (Ptr Tree)

-- | Increments the reference count of /@tree@/ by one.
-- 
-- It is safe to call this function from any thread.
-- 
-- /Since: 2.22/
treeRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m Tree
    -- ^ __Returns:__ the passed in t'GI.GLib.Structs.Tree.Tree'
treeRef tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_ref tree'
    checkUnexpectedReturnNULL "treeRef" result
    result' <- (wrapBoxed Tree) result
    touchManagedPtr tree
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeRefMethodInfo
instance (signature ~ (m Tree), MonadIO m) => O.OverloadedMethod TreeRefMethodInfo Tree signature where
    overloadedMethod = treeRef

instance O.OverloadedMethodInfo TreeRefMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeRef"
        })


#endif

-- method Tree::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to remove" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_remove" g_tree_remove :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    IO CInt

-- | Removes a key\/value pair from a t'GI.GLib.Structs.Tree.Tree'.
-- 
-- If the t'GI.GLib.Structs.Tree.Tree' was created using 'GI.GLib.Structs.Tree.treeNewFull', the key and value
-- are freed using the supplied destroy functions, otherwise you have to
-- make sure that any dynamically allocated values are freed yourself.
-- If the key does not exist in the t'GI.GLib.Structs.Tree.Tree', the function does nothing.
-- 
-- The cost of maintaining a balanced tree while removing a key\/value
-- result in a O(n log(n)) operation where most of the other operations
-- are O(log(n)).
treeRemove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to remove
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the key was found (prior to 2.8, this function
    --     returned nothing)
treeRemove tree key = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_remove tree' key
    let result' = (/= 0) result
    touchManagedPtr tree
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeRemoveMethodInfo
instance (signature ~ (Ptr () -> m Bool), MonadIO m) => O.OverloadedMethod TreeRemoveMethodInfo Tree signature where
    overloadedMethod = treeRemove

instance O.OverloadedMethodInfo TreeRemoveMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeRemove"
        })


#endif

-- method Tree::remove_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_remove_all" g_tree_remove_all :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO ()

-- | Removes all nodes from a t'GI.GLib.Structs.Tree.Tree' and destroys their keys and values,
-- then resets the t'GI.GLib.Structs.Tree.Tree'’s root to 'P.Nothing'.
-- 
-- /Since: 2.70/
treeRemoveAll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m ()
treeRemoveAll tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    g_tree_remove_all tree'
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeRemoveAllMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TreeRemoveAllMethodInfo Tree signature where
    overloadedMethod = treeRemoveAll

instance O.OverloadedMethodInfo TreeRemoveAllMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeRemoveAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeRemoveAll"
        })


#endif

-- method Tree::replace
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to insert" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value corresponding to the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_replace" g_tree_replace :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    Ptr () ->                               -- value : TBasicType TPtr
    IO ()

-- | Inserts a new key and value into a t'GI.GLib.Structs.Tree.Tree' as 'GI.GLib.Structs.Tree.treeReplaceNode' does,
-- only this function does not return the inserted or set node.
treeReplace ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to insert
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> m ()
treeReplace tree key value = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    g_tree_replace tree' key value
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeReplaceMethodInfo
instance (signature ~ (Ptr () -> Ptr () -> m ()), MonadIO m) => O.OverloadedMethod TreeReplaceMethodInfo Tree signature where
    overloadedMethod = treeReplace

instance O.OverloadedMethodInfo TreeReplaceMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeReplace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeReplace"
        })


#endif

-- method Tree::replace_node
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to insert" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value corresponding to the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_replace_node" g_tree_replace_node :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    Ptr () ->                               -- value : TBasicType TPtr
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Inserts a new key and value into a t'GI.GLib.Structs.Tree.Tree' similar to 'GI.GLib.Structs.Tree.treeInsertNode'.
-- The difference is that if the key already exists in the t'GI.GLib.Structs.Tree.Tree', it gets
-- replaced by the new key. If you supplied a /@valueDestroyFunc@/ when
-- creating the t'GI.GLib.Structs.Tree.Tree', the old value is freed using that function. If you
-- supplied a /@keyDestroyFunc@/ when creating the t'GI.GLib.Structs.Tree.Tree', the old key is
-- freed using that function.
-- 
-- The tree is automatically \'balanced\' as new key\/value pairs are added,
-- so that the distance from the root to every leaf is as small as possible.
-- 
-- /Since: 2.68/
treeReplaceNode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to insert
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the inserted (or set) node or 'P.Nothing'
    -- if insertion would overflow the tree node counter.
treeReplaceNode tree key value = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_replace_node tree' key value
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeReplaceNodeMethodInfo
instance (signature ~ (Ptr () -> Ptr () -> m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeReplaceNodeMethodInfo Tree signature where
    overloadedMethod = treeReplaceNode

instance O.OverloadedMethodInfo TreeReplaceNodeMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeReplaceNode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeReplaceNode"
        })


#endif

-- method Tree::search
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "search_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a function used to search the #GTree"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the data passed as the second argument to @search_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_search" g_tree_search :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    FunPtr GLib.Callbacks.C_CompareFunc ->  -- search_func : TInterface (Name {namespace = "GLib", name = "CompareFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO (Ptr ())

-- | Searches a t'GI.GLib.Structs.Tree.Tree' using /@searchFunc@/.
-- 
-- The /@searchFunc@/ is called with a pointer to the key of a key\/value
-- pair in the tree, and the passed in /@userData@/. If /@searchFunc@/ returns
-- 0 for a key\/value pair, then the corresponding value is returned as
-- the result of 'GI.GLib.Structs.Tree.treeSearch'. If /@searchFunc@/ returns -1, searching
-- will proceed among the key\/value pairs that have a smaller key; if
-- /@searchFunc@/ returns 1, searching will proceed among the key\/value
-- pairs that have a larger key.
treeSearch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> GLib.Callbacks.CompareFunc
    -- ^ /@searchFunc@/: a function used to search the t'GI.GLib.Structs.Tree.Tree'
    -> m (Ptr ())
    -- ^ __Returns:__ the value corresponding to the found key, or 'P.Nothing'
    --     if the key was not found
treeSearch tree searchFunc = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    searchFunc' <- GLib.Callbacks.mk_CompareFunc (GLib.Callbacks.wrap_CompareFunc Nothing searchFunc)
    let userData = nullPtr
    result <- g_tree_search tree' searchFunc' userData
    safeFreeFunPtr $ castFunPtrToPtr searchFunc'
    touchManagedPtr tree
    return result

#if defined(ENABLE_OVERLOADING)
data TreeSearchMethodInfo
instance (signature ~ (GLib.Callbacks.CompareFunc -> m (Ptr ())), MonadIO m) => O.OverloadedMethod TreeSearchMethodInfo Tree signature where
    overloadedMethod = treeSearch

instance O.OverloadedMethodInfo TreeSearchMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeSearch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeSearch"
        })


#endif

-- method Tree::search_node
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "search_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a function used to search the #GTree"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the data passed as the second argument to @search_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_search_node" g_tree_search_node :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    FunPtr GLib.Callbacks.C_CompareFunc ->  -- search_func : TInterface (Name {namespace = "GLib", name = "CompareFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Searches a t'GI.GLib.Structs.Tree.Tree' using /@searchFunc@/.
-- 
-- The /@searchFunc@/ is called with a pointer to the key of a key\/value
-- pair in the tree, and the passed in /@userData@/. If /@searchFunc@/ returns
-- 0 for a key\/value pair, then the corresponding node is returned as
-- the result of 'GI.GLib.Structs.Tree.treeSearch'. If /@searchFunc@/ returns -1, searching
-- will proceed among the key\/value pairs that have a smaller key; if
-- /@searchFunc@/ returns 1, searching will proceed among the key\/value
-- pairs that have a larger key.
-- 
-- /Since: 2.68/
treeSearchNode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> GLib.Callbacks.CompareFunc
    -- ^ /@searchFunc@/: a function used to search the t'GI.GLib.Structs.Tree.Tree'
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the node corresponding to the
    --          found key, or 'P.Nothing' if the key was not found
treeSearchNode tree searchFunc = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    searchFunc' <- GLib.Callbacks.mk_CompareFunc (GLib.Callbacks.wrap_CompareFunc Nothing searchFunc)
    let userData = nullPtr
    result <- g_tree_search_node tree' searchFunc' userData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    safeFreeFunPtr $ castFunPtrToPtr searchFunc'
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeSearchNodeMethodInfo
instance (signature ~ (GLib.Callbacks.CompareFunc -> m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeSearchNodeMethodInfo Tree signature where
    overloadedMethod = treeSearchNode

instance O.OverloadedMethodInfo TreeSearchNodeMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeSearchNode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeSearchNode"
        })


#endif

-- method Tree::steal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to remove" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_steal" g_tree_steal :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    IO CInt

-- | Removes a key and its associated value from a t'GI.GLib.Structs.Tree.Tree' without calling
-- the key and value destroy functions.
-- 
-- If the key does not exist in the t'GI.GLib.Structs.Tree.Tree', the function does nothing.
treeSteal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to remove
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the key was found (prior to 2.8, this function
    --     returned nothing)
treeSteal tree key = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_steal tree' key
    let result' = (/= 0) result
    touchManagedPtr tree
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeStealMethodInfo
instance (signature ~ (Ptr () -> m Bool), MonadIO m) => O.OverloadedMethod TreeStealMethodInfo Tree signature where
    overloadedMethod = treeSteal

instance O.OverloadedMethodInfo TreeStealMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeSteal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeSteal"
        })


#endif

-- method Tree::traverse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "traverse_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the function to call for each node visited. If this\n  function returns %TRUE, the traversal is stopped."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "traverse_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the order in which nodes are visited, one of %G_IN_ORDER,\n  %G_PRE_ORDER and %G_POST_ORDER"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_traverse" g_tree_traverse :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    FunPtr GLib.Callbacks.C_TraverseFunc -> -- traverse_func : TInterface (Name {namespace = "GLib", name = "TraverseFunc"})
    CUInt ->                                -- traverse_type : TInterface (Name {namespace = "GLib", name = "TraverseType"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

{-# DEPRECATED treeTraverse ["(Since version 2.2)","The order of a balanced tree is somewhat arbitrary.","    If you just want to visit all nodes in sorted order, use","    'GI.GLib.Structs.Tree.treeForeach' instead. If you really need to visit nodes in","    a different order, consider using an <http://developer.gnome.org/glib/stable/data-structures.html#n-ary-trees n-ary tree>."] #-}
-- | Calls the given function for each node in the t'GI.GLib.Structs.Tree.Tree'.
treeTraverse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> GLib.Callbacks.TraverseFunc
    -- ^ /@traverseFunc@/: the function to call for each node visited. If this
    --   function returns 'P.True', the traversal is stopped.
    -> GLib.Enums.TraverseType
    -- ^ /@traverseType@/: the order in which nodes are visited, one of 'GI.GLib.Enums.TraverseTypeInOrder',
    --   'GI.GLib.Enums.TraverseTypePreOrder' and 'GI.GLib.Enums.TraverseTypePostOrder'
    -> m ()
treeTraverse tree traverseFunc traverseType = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    traverseFunc' <- GLib.Callbacks.mk_TraverseFunc (GLib.Callbacks.wrap_TraverseFunc Nothing traverseFunc)
    let traverseType' = (fromIntegral . fromEnum) traverseType
    let userData = nullPtr
    g_tree_traverse tree' traverseFunc' traverseType' userData
    safeFreeFunPtr $ castFunPtrToPtr traverseFunc'
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeTraverseMethodInfo
instance (signature ~ (GLib.Callbacks.TraverseFunc -> GLib.Enums.TraverseType -> m ()), MonadIO m) => O.OverloadedMethod TreeTraverseMethodInfo Tree signature where
    overloadedMethod = treeTraverse

instance O.OverloadedMethodInfo TreeTraverseMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeTraverse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeTraverse"
        })


#endif

-- method Tree::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_unref" g_tree_unref :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    IO ()

-- | Decrements the reference count of /@tree@/ by one.
-- If the reference count drops to 0, all keys and values will
-- be destroyed (if destroy functions were specified) and all
-- memory allocated by /@tree@/ will be released.
-- 
-- It is safe to call this function from any thread.
-- 
-- /Since: 2.22/
treeUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> m ()
treeUnref tree = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    g_tree_unref tree'
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TreeUnrefMethodInfo Tree signature where
    overloadedMethod = treeUnref

instance O.OverloadedMethodInfo TreeUnrefMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeUnref"
        })


#endif

-- method Tree::upper_bound
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key to calculate the upper bound for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_upper_bound" g_tree_upper_bound :: 
    Ptr Tree ->                             -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- key : TBasicType TPtr
    IO (Ptr GLib.TreeNode.TreeNode)

-- | Gets the upper bound node corresponding to the given key,
-- or 'P.Nothing' if the tree is empty or all the nodes in the tree
-- have keys that are lower than or equal to the searched key.
-- 
-- The upper bound is the first node that has its key strictly greater
-- than the searched key.
-- 
-- /Since: 2.68/
treeUpperBound ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree'
    -> Ptr ()
    -- ^ /@key@/: the key to calculate the upper bound for
    -> m (Maybe GLib.TreeNode.TreeNode)
    -- ^ __Returns:__ the tree node corresponding to the
    --          upper bound, or 'P.Nothing' if the tree is empty or has only keys
    --          lower than or equal to the searched key.
treeUpperBound tree key = liftIO $ do
    tree' <- unsafeManagedPtrGetPtr tree
    result <- g_tree_upper_bound tree' key
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.TreeNode.TreeNode) result'
        return result''
    touchManagedPtr tree
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeUpperBoundMethodInfo
instance (signature ~ (Ptr () -> m (Maybe GLib.TreeNode.TreeNode)), MonadIO m) => O.OverloadedMethod TreeUpperBoundMethodInfo Tree signature where
    overloadedMethod = treeUpperBound

instance O.OverloadedMethodInfo TreeUpperBoundMethodInfo Tree where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tree.treeUpperBound",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Tree.html#v:treeUpperBound"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTreeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTreeMethod "destroy" o = TreeDestroyMethodInfo
    ResolveTreeMethod "foreach" o = TreeForeachMethodInfo
    ResolveTreeMethod "foreachNode" o = TreeForeachNodeMethodInfo
    ResolveTreeMethod "height" o = TreeHeightMethodInfo
    ResolveTreeMethod "insert" o = TreeInsertMethodInfo
    ResolveTreeMethod "insertNode" o = TreeInsertNodeMethodInfo
    ResolveTreeMethod "lookup" o = TreeLookupMethodInfo
    ResolveTreeMethod "lookupExtended" o = TreeLookupExtendedMethodInfo
    ResolveTreeMethod "lookupNode" o = TreeLookupNodeMethodInfo
    ResolveTreeMethod "lowerBound" o = TreeLowerBoundMethodInfo
    ResolveTreeMethod "nnodes" o = TreeNnodesMethodInfo
    ResolveTreeMethod "nodeFirst" o = TreeNodeFirstMethodInfo
    ResolveTreeMethod "nodeLast" o = TreeNodeLastMethodInfo
    ResolveTreeMethod "ref" o = TreeRefMethodInfo
    ResolveTreeMethod "remove" o = TreeRemoveMethodInfo
    ResolveTreeMethod "removeAll" o = TreeRemoveAllMethodInfo
    ResolveTreeMethod "replace" o = TreeReplaceMethodInfo
    ResolveTreeMethod "replaceNode" o = TreeReplaceNodeMethodInfo
    ResolveTreeMethod "search" o = TreeSearchMethodInfo
    ResolveTreeMethod "searchNode" o = TreeSearchNodeMethodInfo
    ResolveTreeMethod "steal" o = TreeStealMethodInfo
    ResolveTreeMethod "traverse" o = TreeTraverseMethodInfo
    ResolveTreeMethod "unref" o = TreeUnrefMethodInfo
    ResolveTreeMethod "upperBound" o = TreeUpperBoundMethodInfo
    ResolveTreeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTreeMethod t Tree, O.OverloadedMethod info Tree p) => OL.IsLabel t (Tree -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTreeMethod t Tree, O.OverloadedMethod info Tree p, R.HasField t Tree p) => R.HasField t Tree p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTreeMethod t Tree, O.OverloadedMethodInfo info Tree) => OL.IsLabel t (O.MethodProxy info Tree) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


