{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A ray emitted from an origin in a given direction.
-- 
-- The contents of the @graphene_ray_t@ structure are private, and should not
-- be modified directly.
-- 
-- /Since: 1.4/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Ray
    ( 

-- * Exported types
    Ray(..)                                 ,
    newZeroRay                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [equal]("GI.Graphene.Structs.Ray#g:method:equal"), [free]("GI.Graphene.Structs.Ray#g:method:free"), [init]("GI.Graphene.Structs.Ray#g:method:init"), [initFromRay]("GI.Graphene.Structs.Ray#g:method:initFromRay"), [initFromVec3]("GI.Graphene.Structs.Ray#g:method:initFromVec3"), [intersectBox]("GI.Graphene.Structs.Ray#g:method:intersectBox"), [intersectSphere]("GI.Graphene.Structs.Ray#g:method:intersectSphere"), [intersectTriangle]("GI.Graphene.Structs.Ray#g:method:intersectTriangle"), [intersectsBox]("GI.Graphene.Structs.Ray#g:method:intersectsBox"), [intersectsSphere]("GI.Graphene.Structs.Ray#g:method:intersectsSphere"), [intersectsTriangle]("GI.Graphene.Structs.Ray#g:method:intersectsTriangle").
-- 
-- ==== Getters
-- [getClosestPointToPoint]("GI.Graphene.Structs.Ray#g:method:getClosestPointToPoint"), [getDirection]("GI.Graphene.Structs.Ray#g:method:getDirection"), [getDistanceToPlane]("GI.Graphene.Structs.Ray#g:method:getDistanceToPlane"), [getDistanceToPoint]("GI.Graphene.Structs.Ray#g:method:getDistanceToPoint"), [getOrigin]("GI.Graphene.Structs.Ray#g:method:getOrigin"), [getPositionAt]("GI.Graphene.Structs.Ray#g:method:getPositionAt").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRayMethod                        ,
#endif

-- ** alloc #method:alloc#

    rayAlloc                                ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    RayEqualMethodInfo                      ,
#endif
    rayEqual                                ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    RayFreeMethodInfo                       ,
#endif
    rayFree                                 ,


-- ** getClosestPointToPoint #method:getClosestPointToPoint#

#if defined(ENABLE_OVERLOADING)
    RayGetClosestPointToPointMethodInfo     ,
#endif
    rayGetClosestPointToPoint               ,


-- ** getDirection #method:getDirection#

#if defined(ENABLE_OVERLOADING)
    RayGetDirectionMethodInfo               ,
#endif
    rayGetDirection                         ,


-- ** getDistanceToPlane #method:getDistanceToPlane#

#if defined(ENABLE_OVERLOADING)
    RayGetDistanceToPlaneMethodInfo         ,
#endif
    rayGetDistanceToPlane                   ,


-- ** getDistanceToPoint #method:getDistanceToPoint#

#if defined(ENABLE_OVERLOADING)
    RayGetDistanceToPointMethodInfo         ,
#endif
    rayGetDistanceToPoint                   ,


-- ** getOrigin #method:getOrigin#

#if defined(ENABLE_OVERLOADING)
    RayGetOriginMethodInfo                  ,
#endif
    rayGetOrigin                            ,


-- ** getPositionAt #method:getPositionAt#

#if defined(ENABLE_OVERLOADING)
    RayGetPositionAtMethodInfo              ,
#endif
    rayGetPositionAt                        ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    RayInitMethodInfo                       ,
#endif
    rayInit                                 ,


-- ** initFromRay #method:initFromRay#

#if defined(ENABLE_OVERLOADING)
    RayInitFromRayMethodInfo                ,
#endif
    rayInitFromRay                          ,


-- ** initFromVec3 #method:initFromVec3#

#if defined(ENABLE_OVERLOADING)
    RayInitFromVec3MethodInfo               ,
#endif
    rayInitFromVec3                         ,


-- ** intersectBox #method:intersectBox#

#if defined(ENABLE_OVERLOADING)
    RayIntersectBoxMethodInfo               ,
#endif
    rayIntersectBox                         ,


-- ** intersectSphere #method:intersectSphere#

#if defined(ENABLE_OVERLOADING)
    RayIntersectSphereMethodInfo            ,
#endif
    rayIntersectSphere                      ,


-- ** intersectTriangle #method:intersectTriangle#

#if defined(ENABLE_OVERLOADING)
    RayIntersectTriangleMethodInfo          ,
#endif
    rayIntersectTriangle                    ,


-- ** intersectsBox #method:intersectsBox#

#if defined(ENABLE_OVERLOADING)
    RayIntersectsBoxMethodInfo              ,
#endif
    rayIntersectsBox                        ,


-- ** intersectsSphere #method:intersectsSphere#

#if defined(ENABLE_OVERLOADING)
    RayIntersectsSphereMethodInfo           ,
#endif
    rayIntersectsSphere                     ,


-- ** intersectsTriangle #method:intersectsTriangle#

#if defined(ENABLE_OVERLOADING)
    RayIntersectsTriangleMethodInfo         ,
#endif
    rayIntersectsTriangle                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Enums as Graphene.Enums
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Euler as Graphene.Euler
import {-# SOURCE #-} qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import {-# SOURCE #-} qualified GI.Graphene.Structs.Plane as Graphene.Plane
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quad as Graphene.Quad
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quaternion as Graphene.Quaternion
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Sphere as Graphene.Sphere
import {-# SOURCE #-} qualified GI.Graphene.Structs.Triangle as Graphene.Triangle
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#else
import {-# SOURCE #-} qualified GI.Graphene.Enums as Graphene.Enums
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Plane as Graphene.Plane
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Sphere as Graphene.Sphere
import {-# SOURCE #-} qualified GI.Graphene.Structs.Triangle as Graphene.Triangle
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3

#endif

-- | Memory-managed wrapper type.
newtype Ray = Ray (SP.ManagedPtr Ray)
    deriving (Eq)

instance SP.ManagedPtrNewtype Ray where
    toManagedPtr (Ray p) = p

foreign import ccall "graphene_ray_get_type" c_graphene_ray_get_type :: 
    IO GType

type instance O.ParentTypes Ray = '[]
instance O.HasParentTypes Ray

instance B.Types.TypedObject Ray where
    glibType = c_graphene_ray_get_type

instance B.Types.GBoxed Ray

-- | Convert t'Ray' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Ray) where
    gvalueGType_ = c_graphene_ray_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Ray)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Ray)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Ray ptr
        else return P.Nothing
        
    

-- | Construct a t'Ray' struct initialized to zero.
newZeroRay :: MonadIO m => m Ray
newZeroRay = liftIO $ callocBoxedBytes 32 >>= wrapBoxed Ray

instance tag ~ 'AttrSet => Constructible Ray tag where
    new _ attrs = do
        o <- newZeroRay
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Ray
type instance O.AttributeList Ray = RayAttributeList
type RayAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Ray::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Ray" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_alloc" graphene_ray_alloc :: 
    IO (Ptr Ray)

-- | Allocates a new t'GI.Graphene.Structs.Ray.Ray' structure.
-- 
-- The contents of the returned structure are undefined.
-- 
-- /Since: 1.4/
rayAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Ray
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Ray.Ray'.
    --   Use 'GI.Graphene.Structs.Ray.rayFree' to free the resources allocated by
    --   this function
rayAlloc  = liftIO $ do
    result <- graphene_ray_alloc
    checkUnexpectedReturnNULL "rayAlloc" result
    result' <- (wrapBoxed Ray) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Ray::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_equal" graphene_ray_equal :: 
    Ptr Ray ->                              -- a : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Ray ->                              -- b : TInterface (Name {namespace = "Graphene", name = "Ray"})
    IO CInt

-- | Checks whether the two given t'GI.Graphene.Structs.Ray.Ray' are equal.
-- 
-- /Since: 1.4/
rayEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@a@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Ray
    -- ^ /@b@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> m Bool
    -- ^ __Returns:__ @true@ if the given rays are equal
rayEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_ray_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data RayEqualMethodInfo
instance (signature ~ (Ray -> m Bool), MonadIO m) => O.OverloadedMethod RayEqualMethodInfo Ray signature where
    overloadedMethod = rayEqual

instance O.OverloadedMethodInfo RayEqualMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayEqual"
        })


#endif

-- method Ray::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_free" graphene_ray_free :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Ray.rayAlloc'.
-- 
-- /Since: 1.4/
rayFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> m ()
rayFree r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    graphene_ray_free r'
    touchManagedPtr r
    return ()

#if defined(ENABLE_OVERLOADING)
data RayFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod RayFreeMethodInfo Ray signature where
    overloadedMethod = rayFree

instance O.OverloadedMethodInfo RayFreeMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayFree"
        })


#endif

-- method Ray::get_closest_point_to_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the closest point3d"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_get_closest_point_to_point" graphene_ray_get_closest_point_to_point :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Point3D.Point3D ->         -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- res : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Computes the point on the given t'GI.Graphene.Structs.Ray.Ray' that is closest to the
-- given point /@p@/.
-- 
-- /Since: 1.4/
rayGetClosestPointToPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Point3D.Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m (Graphene.Point3D.Point3D)
rayGetClosestPointToPoint r p = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p' <- unsafeManagedPtrGetPtr p
    res <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_ray_get_closest_point_to_point r' p' res
    res' <- (wrapBoxed Graphene.Point3D.Point3D) res
    touchManagedPtr r
    touchManagedPtr p
    return res'

#if defined(ENABLE_OVERLOADING)
data RayGetClosestPointToPointMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod RayGetClosestPointToPointMethodInfo Ray signature where
    overloadedMethod = rayGetClosestPointToPoint

instance O.OverloadedMethodInfo RayGetClosestPointToPointMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayGetClosestPointToPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayGetClosestPointToPoint"
        })


#endif

-- method Ray::get_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_get_direction" graphene_ray_get_direction :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Vec3.Vec3 ->               -- direction : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

-- | Retrieves the direction of the given t'GI.Graphene.Structs.Ray.Ray'.
-- 
-- /Since: 1.4/
rayGetDirection ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> m (Graphene.Vec3.Vec3)
rayGetDirection r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    direction <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    graphene_ray_get_direction r' direction
    direction' <- (wrapBoxed Graphene.Vec3.Vec3) direction
    touchManagedPtr r
    return direction'

#if defined(ENABLE_OVERLOADING)
data RayGetDirectionMethodInfo
instance (signature ~ (m (Graphene.Vec3.Vec3)), MonadIO m) => O.OverloadedMethod RayGetDirectionMethodInfo Ray signature where
    overloadedMethod = rayGetDirection

instance O.OverloadedMethodInfo RayGetDirectionMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayGetDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayGetDirection"
        })


#endif

-- method Ray::get_distance_to_plane
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_get_distance_to_plane" graphene_ray_get_distance_to_plane :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Plane.Plane ->             -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO CFloat

-- | Computes the distance of the origin of the given t'GI.Graphene.Structs.Ray.Ray' from the
-- given plane.
-- 
-- If the ray does not intersect the plane, this function returns @INFINITY@.
-- 
-- /Since: 1.4/
rayGetDistanceToPlane ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Plane.Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m Float
    -- ^ __Returns:__ the distance of the origin of the ray from the plane
rayGetDistanceToPlane r p = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p' <- unsafeManagedPtrGetPtr p
    result <- graphene_ray_get_distance_to_plane r' p'
    let result' = realToFrac result
    touchManagedPtr r
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data RayGetDistanceToPlaneMethodInfo
instance (signature ~ (Graphene.Plane.Plane -> m Float), MonadIO m) => O.OverloadedMethod RayGetDistanceToPlaneMethodInfo Ray signature where
    overloadedMethod = rayGetDistanceToPlane

instance O.OverloadedMethodInfo RayGetDistanceToPlaneMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayGetDistanceToPlane",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayGetDistanceToPlane"
        })


#endif

-- method Ray::get_distance_to_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_get_distance_to_point" graphene_ray_get_distance_to_point :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Point3D.Point3D ->         -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CFloat

-- | Computes the distance of the closest approach between the
-- given t'GI.Graphene.Structs.Ray.Ray' /@r@/ and the point /@p@/.
-- 
-- The closest approach to a ray from a point is the distance
-- between the point and the projection of the point on the
-- ray itself.
-- 
-- /Since: 1.4/
rayGetDistanceToPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Point3D.Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Float
    -- ^ __Returns:__ the distance of the point
rayGetDistanceToPoint r p = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p' <- unsafeManagedPtrGetPtr p
    result <- graphene_ray_get_distance_to_point r' p'
    let result' = realToFrac result
    touchManagedPtr r
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data RayGetDistanceToPointMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m Float), MonadIO m) => O.OverloadedMethod RayGetDistanceToPointMethodInfo Ray signature where
    overloadedMethod = rayGetDistanceToPoint

instance O.OverloadedMethodInfo RayGetDistanceToPointMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayGetDistanceToPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayGetDistanceToPoint"
        })


#endif

-- method Ray::get_origin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_get_origin" graphene_ray_get_origin :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Point3D.Point3D ->         -- origin : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Retrieves the origin of the given t'GI.Graphene.Structs.Ray.Ray'.
-- 
-- /Since: 1.4/
rayGetOrigin ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> m (Graphene.Point3D.Point3D)
rayGetOrigin r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    origin <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_ray_get_origin r' origin
    origin' <- (wrapBoxed Graphene.Point3D.Point3D) origin
    touchManagedPtr r
    return origin'

#if defined(ENABLE_OVERLOADING)
data RayGetOriginMethodInfo
instance (signature ~ (m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod RayGetOriginMethodInfo Ray signature where
    overloadedMethod = rayGetOrigin

instance O.OverloadedMethodInfo RayGetOriginMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayGetOrigin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayGetOrigin"
        })


#endif

-- method Ray::get_position_at
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "t"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the distance along the ray"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_get_position_at" graphene_ray_get_position_at :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    CFloat ->                               -- t : TBasicType TFloat
    Ptr Graphene.Point3D.Point3D ->         -- position : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Retrieves the coordinates of a point at the distance /@t@/ along the
-- given t'GI.Graphene.Structs.Ray.Ray'.
-- 
-- /Since: 1.4/
rayGetPositionAt ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Float
    -- ^ /@t@/: the distance along the ray
    -> m (Graphene.Point3D.Point3D)
rayGetPositionAt r t = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    let t' = realToFrac t
    position <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_ray_get_position_at r' t' position
    position' <- (wrapBoxed Graphene.Point3D.Point3D) position
    touchManagedPtr r
    return position'

#if defined(ENABLE_OVERLOADING)
data RayGetPositionAtMethodInfo
instance (signature ~ (Float -> m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod RayGetPositionAtMethodInfo Ray signature where
    overloadedMethod = rayGetPositionAt

instance O.OverloadedMethodInfo RayGetPositionAtMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayGetPositionAt",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayGetPositionAt"
        })


#endif

-- method Ray::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_ray_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the origin of the ray"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the direction vector"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Ray" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_init" graphene_ray_init :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Point3D.Point3D ->         -- origin : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Vec3.Vec3 ->               -- direction : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO (Ptr Ray)

-- | Initializes the given t'GI.Graphene.Structs.Ray.Ray' using the given /@origin@/
-- and /@direction@/ values.
-- 
-- /Since: 1.4/
rayInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: the t'GI.Graphene.Structs.Ray.Ray' to initialize
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@origin@/: the origin of the ray
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@direction@/: the direction vector
    -> m Ray
    -- ^ __Returns:__ the initialized ray
rayInit r origin direction = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    maybeOrigin <- case origin of
        Nothing -> return FP.nullPtr
        Just jOrigin -> do
            jOrigin' <- unsafeManagedPtrGetPtr jOrigin
            return jOrigin'
    maybeDirection <- case direction of
        Nothing -> return FP.nullPtr
        Just jDirection -> do
            jDirection' <- unsafeManagedPtrGetPtr jDirection
            return jDirection'
    result <- graphene_ray_init r' maybeOrigin maybeDirection
    checkUnexpectedReturnNULL "rayInit" result
    result' <- (newBoxed Ray) result
    touchManagedPtr r
    whenJust origin touchManagedPtr
    whenJust direction touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data RayInitMethodInfo
instance (signature ~ (Maybe (Graphene.Point3D.Point3D) -> Maybe (Graphene.Vec3.Vec3) -> m Ray), MonadIO m) => O.OverloadedMethod RayInitMethodInfo Ray signature where
    overloadedMethod = rayInit

instance O.OverloadedMethodInfo RayInitMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayInit"
        })


#endif

-- method Ray::init_from_ray
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_ray_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Ray" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_init_from_ray" graphene_ray_init_from_ray :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Ray ->                              -- src : TInterface (Name {namespace = "Graphene", name = "Ray"})
    IO (Ptr Ray)

-- | Initializes the given t'GI.Graphene.Structs.Ray.Ray' using the origin and direction
-- values of another t'GI.Graphene.Structs.Ray.Ray'.
-- 
-- /Since: 1.4/
rayInitFromRay ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: the t'GI.Graphene.Structs.Ray.Ray' to initialize
    -> Ray
    -- ^ /@src@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> m Ray
    -- ^ __Returns:__ the initialized ray
rayInitFromRay r src = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_ray_init_from_ray r' src'
    checkUnexpectedReturnNULL "rayInitFromRay" result
    result' <- (newBoxed Ray) result
    touchManagedPtr r
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data RayInitFromRayMethodInfo
instance (signature ~ (Ray -> m Ray), MonadIO m) => O.OverloadedMethod RayInitFromRayMethodInfo Ray signature where
    overloadedMethod = rayInitFromRay

instance O.OverloadedMethodInfo RayInitFromRayMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayInitFromRay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayInitFromRay"
        })


#endif

-- method Ray::init_from_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_ray_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_vec3_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_vec3_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Ray" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_init_from_vec3" graphene_ray_init_from_vec3 :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Vec3.Vec3 ->               -- origin : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Graphene.Vec3.Vec3 ->               -- direction : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO (Ptr Ray)

-- | Initializes the given t'GI.Graphene.Structs.Ray.Ray' using the given vectors.
-- 
-- /Since: 1.4/
rayInitFromVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: the t'GI.Graphene.Structs.Ray.Ray' to initialize
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@origin@/: a t'GI.Graphene.Structs.Vec3.Vec3'
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@direction@/: a t'GI.Graphene.Structs.Vec3.Vec3'
    -> m Ray
    -- ^ __Returns:__ the initialized ray
rayInitFromVec3 r origin direction = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    maybeOrigin <- case origin of
        Nothing -> return FP.nullPtr
        Just jOrigin -> do
            jOrigin' <- unsafeManagedPtrGetPtr jOrigin
            return jOrigin'
    maybeDirection <- case direction of
        Nothing -> return FP.nullPtr
        Just jDirection -> do
            jDirection' <- unsafeManagedPtrGetPtr jDirection
            return jDirection'
    result <- graphene_ray_init_from_vec3 r' maybeOrigin maybeDirection
    checkUnexpectedReturnNULL "rayInitFromVec3" result
    result' <- (newBoxed Ray) result
    touchManagedPtr r
    whenJust origin touchManagedPtr
    whenJust direction touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data RayInitFromVec3MethodInfo
instance (signature ~ (Maybe (Graphene.Vec3.Vec3) -> Maybe (Graphene.Vec3.Vec3) -> m Ray), MonadIO m) => O.OverloadedMethod RayInitFromVec3MethodInfo Ray signature where
    overloadedMethod = rayInitFromVec3

instance O.OverloadedMethodInfo RayInitFromVec3MethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayInitFromVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayInitFromVec3"
        })


#endif

-- method Ray::intersect_box
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "t_out"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the distance of the point on the ray that intersects the box"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Graphene" , name = "RayIntersectionKind" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_intersect_box" graphene_ray_intersect_box :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Box.Box ->                 -- b : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr CFloat ->                           -- t_out : TBasicType TFloat
    IO CUInt

-- | Intersects the given t'GI.Graphene.Structs.Ray.Ray' /@r@/ with the given
-- t'GI.Graphene.Structs.Box.Box' /@b@/.
-- 
-- /Since: 1.10/
rayIntersectBox ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Box.Box
    -- ^ /@b@/: a t'GI.Graphene.Structs.Box.Box'
    -> m ((Graphene.Enums.RayIntersectionKind, Float))
    -- ^ __Returns:__ the type of intersection
rayIntersectBox r b = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    b' <- unsafeManagedPtrGetPtr b
    tOut <- allocMem :: IO (Ptr CFloat)
    result <- graphene_ray_intersect_box r' b' tOut
    let result' = (toEnum . fromIntegral) result
    tOut' <- peek tOut
    let tOut'' = realToFrac tOut'
    touchManagedPtr r
    touchManagedPtr b
    freeMem tOut
    return (result', tOut'')

#if defined(ENABLE_OVERLOADING)
data RayIntersectBoxMethodInfo
instance (signature ~ (Graphene.Box.Box -> m ((Graphene.Enums.RayIntersectionKind, Float))), MonadIO m) => O.OverloadedMethod RayIntersectBoxMethodInfo Ray signature where
    overloadedMethod = rayIntersectBox

instance O.OverloadedMethodInfo RayIntersectBoxMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayIntersectBox",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayIntersectBox"
        })


#endif

-- method Ray::intersect_sphere
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "t_out"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the distance of the point on the ray that intersects the sphere"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Graphene" , name = "RayIntersectionKind" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_intersect_sphere" graphene_ray_intersect_sphere :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Sphere.Sphere ->           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr CFloat ->                           -- t_out : TBasicType TFloat
    IO CUInt

-- | Intersects the given t'GI.Graphene.Structs.Ray.Ray' /@r@/ with the given
-- t'GI.Graphene.Structs.Sphere.Sphere' /@s@/.
-- 
-- /Since: 1.10/
rayIntersectSphere ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Sphere.Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m ((Graphene.Enums.RayIntersectionKind, Float))
    -- ^ __Returns:__ the type of intersection
rayIntersectSphere r s = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    s' <- unsafeManagedPtrGetPtr s
    tOut <- allocMem :: IO (Ptr CFloat)
    result <- graphene_ray_intersect_sphere r' s' tOut
    let result' = (toEnum . fromIntegral) result
    tOut' <- peek tOut
    let tOut'' = realToFrac tOut'
    touchManagedPtr r
    touchManagedPtr s
    freeMem tOut
    return (result', tOut'')

#if defined(ENABLE_OVERLOADING)
data RayIntersectSphereMethodInfo
instance (signature ~ (Graphene.Sphere.Sphere -> m ((Graphene.Enums.RayIntersectionKind, Float))), MonadIO m) => O.OverloadedMethod RayIntersectSphereMethodInfo Ray signature where
    overloadedMethod = rayIntersectSphere

instance O.OverloadedMethodInfo RayIntersectSphereMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayIntersectSphere",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayIntersectSphere"
        })


#endif

-- method Ray::intersect_triangle
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "t_out"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the distance of the point on the ray that intersects the triangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Graphene" , name = "RayIntersectionKind" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_intersect_triangle" graphene_ray_intersect_triangle :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Triangle.Triangle ->       -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr CFloat ->                           -- t_out : TBasicType TFloat
    IO CUInt

-- | Intersects the given t'GI.Graphene.Structs.Ray.Ray' /@r@/ with the given
-- t'GI.Graphene.Structs.Triangle.Triangle' /@t@/.
-- 
-- /Since: 1.10/
rayIntersectTriangle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Triangle.Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m ((Graphene.Enums.RayIntersectionKind, Float))
    -- ^ __Returns:__ the type of intersection
rayIntersectTriangle r t = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    t' <- unsafeManagedPtrGetPtr t
    tOut <- allocMem :: IO (Ptr CFloat)
    result <- graphene_ray_intersect_triangle r' t' tOut
    let result' = (toEnum . fromIntegral) result
    tOut' <- peek tOut
    let tOut'' = realToFrac tOut'
    touchManagedPtr r
    touchManagedPtr t
    freeMem tOut
    return (result', tOut'')

#if defined(ENABLE_OVERLOADING)
data RayIntersectTriangleMethodInfo
instance (signature ~ (Graphene.Triangle.Triangle -> m ((Graphene.Enums.RayIntersectionKind, Float))), MonadIO m) => O.OverloadedMethod RayIntersectTriangleMethodInfo Ray signature where
    overloadedMethod = rayIntersectTriangle

instance O.OverloadedMethodInfo RayIntersectTriangleMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayIntersectTriangle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayIntersectTriangle"
        })


#endif

-- method Ray::intersects_box
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_intersects_box" graphene_ray_intersects_box :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Box.Box ->                 -- b : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO CInt

-- | Checks whether the given t'GI.Graphene.Structs.Ray.Ray' /@r@/ intersects the
-- given t'GI.Graphene.Structs.Box.Box' /@b@/.
-- 
-- See also: 'GI.Graphene.Structs.Ray.rayIntersectBox'
-- 
-- /Since: 1.10/
rayIntersectsBox ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Box.Box
    -- ^ /@b@/: a t'GI.Graphene.Structs.Box.Box'
    -> m Bool
    -- ^ __Returns:__ @true@ if the ray intersects the box
rayIntersectsBox r b = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_ray_intersects_box r' b'
    let result' = (/= 0) result
    touchManagedPtr r
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data RayIntersectsBoxMethodInfo
instance (signature ~ (Graphene.Box.Box -> m Bool), MonadIO m) => O.OverloadedMethod RayIntersectsBoxMethodInfo Ray signature where
    overloadedMethod = rayIntersectsBox

instance O.OverloadedMethodInfo RayIntersectsBoxMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayIntersectsBox",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayIntersectsBox"
        })


#endif

-- method Ray::intersects_sphere
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_intersects_sphere" graphene_ray_intersects_sphere :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Sphere.Sphere ->           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    IO CInt

-- | Checks if the given t'GI.Graphene.Structs.Ray.Ray' /@r@/ intersects the
-- given t'GI.Graphene.Structs.Sphere.Sphere' /@s@/.
-- 
-- See also: 'GI.Graphene.Structs.Ray.rayIntersectSphere'
-- 
-- /Since: 1.10/
rayIntersectsSphere ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Sphere.Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m Bool
    -- ^ __Returns:__ @true@ if the ray intersects the sphere
rayIntersectsSphere r s = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    s' <- unsafeManagedPtrGetPtr s
    result <- graphene_ray_intersects_sphere r' s'
    let result' = (/= 0) result
    touchManagedPtr r
    touchManagedPtr s
    return result'

#if defined(ENABLE_OVERLOADING)
data RayIntersectsSphereMethodInfo
instance (signature ~ (Graphene.Sphere.Sphere -> m Bool), MonadIO m) => O.OverloadedMethod RayIntersectsSphereMethodInfo Ray signature where
    overloadedMethod = rayIntersectsSphere

instance O.OverloadedMethodInfo RayIntersectsSphereMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayIntersectsSphere",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayIntersectsSphere"
        })


#endif

-- method Ray::intersects_triangle
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Ray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_ray_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_ray_intersects_triangle" graphene_ray_intersects_triangle :: 
    Ptr Ray ->                              -- r : TInterface (Name {namespace = "Graphene", name = "Ray"})
    Ptr Graphene.Triangle.Triangle ->       -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    IO CInt

-- | Checks whether the given t'GI.Graphene.Structs.Ray.Ray' /@r@/ intersects the
-- given t'GI.Graphene.Structs.Triangle.Triangle' /@b@/.
-- 
-- See also: 'GI.Graphene.Structs.Ray.rayIntersectTriangle'
-- 
-- /Since: 1.10/
rayIntersectsTriangle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ray
    -- ^ /@r@/: a t'GI.Graphene.Structs.Ray.Ray'
    -> Graphene.Triangle.Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m Bool
    -- ^ __Returns:__ @true@ if the ray intersects the triangle
rayIntersectsTriangle r t = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    t' <- unsafeManagedPtrGetPtr t
    result <- graphene_ray_intersects_triangle r' t'
    let result' = (/= 0) result
    touchManagedPtr r
    touchManagedPtr t
    return result'

#if defined(ENABLE_OVERLOADING)
data RayIntersectsTriangleMethodInfo
instance (signature ~ (Graphene.Triangle.Triangle -> m Bool), MonadIO m) => O.OverloadedMethod RayIntersectsTriangleMethodInfo Ray signature where
    overloadedMethod = rayIntersectsTriangle

instance O.OverloadedMethodInfo RayIntersectsTriangleMethodInfo Ray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Ray.rayIntersectsTriangle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Ray.html#v:rayIntersectsTriangle"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveRayMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRayMethod "equal" o = RayEqualMethodInfo
    ResolveRayMethod "free" o = RayFreeMethodInfo
    ResolveRayMethod "init" o = RayInitMethodInfo
    ResolveRayMethod "initFromRay" o = RayInitFromRayMethodInfo
    ResolveRayMethod "initFromVec3" o = RayInitFromVec3MethodInfo
    ResolveRayMethod "intersectBox" o = RayIntersectBoxMethodInfo
    ResolveRayMethod "intersectSphere" o = RayIntersectSphereMethodInfo
    ResolveRayMethod "intersectTriangle" o = RayIntersectTriangleMethodInfo
    ResolveRayMethod "intersectsBox" o = RayIntersectsBoxMethodInfo
    ResolveRayMethod "intersectsSphere" o = RayIntersectsSphereMethodInfo
    ResolveRayMethod "intersectsTriangle" o = RayIntersectsTriangleMethodInfo
    ResolveRayMethod "getClosestPointToPoint" o = RayGetClosestPointToPointMethodInfo
    ResolveRayMethod "getDirection" o = RayGetDirectionMethodInfo
    ResolveRayMethod "getDistanceToPlane" o = RayGetDistanceToPlaneMethodInfo
    ResolveRayMethod "getDistanceToPoint" o = RayGetDistanceToPointMethodInfo
    ResolveRayMethod "getOrigin" o = RayGetOriginMethodInfo
    ResolveRayMethod "getPositionAt" o = RayGetPositionAtMethodInfo
    ResolveRayMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRayMethod t Ray, O.OverloadedMethod info Ray p) => OL.IsLabel t (Ray -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRayMethod t Ray, O.OverloadedMethod info Ray p, R.HasField t Ray p) => R.HasField t Ray p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRayMethod t Ray, O.OverloadedMethodInfo info Ray) => OL.IsLabel t (O.MethodProxy info Ray) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


