{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A 3D box, described as the volume between a minimum and
-- a maximum vertices.
-- 
-- /Since: 1.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Box
    ( 

-- * Exported types
    Box(..)                                 ,
    newZeroBox                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [containsBox]("GI.Graphene.Structs.Box#g:method:containsBox"), [containsPoint]("GI.Graphene.Structs.Box#g:method:containsPoint"), [equal]("GI.Graphene.Structs.Box#g:method:equal"), [expand]("GI.Graphene.Structs.Box#g:method:expand"), [expandScalar]("GI.Graphene.Structs.Box#g:method:expandScalar"), [expandVec3]("GI.Graphene.Structs.Box#g:method:expandVec3"), [free]("GI.Graphene.Structs.Box#g:method:free"), [init]("GI.Graphene.Structs.Box#g:method:init"), [initFromBox]("GI.Graphene.Structs.Box#g:method:initFromBox"), [initFromPoints]("GI.Graphene.Structs.Box#g:method:initFromPoints"), [initFromVec3]("GI.Graphene.Structs.Box#g:method:initFromVec3"), [initFromVectors]("GI.Graphene.Structs.Box#g:method:initFromVectors"), [intersection]("GI.Graphene.Structs.Box#g:method:intersection"), [union]("GI.Graphene.Structs.Box#g:method:union").
-- 
-- ==== Getters
-- [getBoundingSphere]("GI.Graphene.Structs.Box#g:method:getBoundingSphere"), [getCenter]("GI.Graphene.Structs.Box#g:method:getCenter"), [getDepth]("GI.Graphene.Structs.Box#g:method:getDepth"), [getHeight]("GI.Graphene.Structs.Box#g:method:getHeight"), [getMax]("GI.Graphene.Structs.Box#g:method:getMax"), [getMin]("GI.Graphene.Structs.Box#g:method:getMin"), [getSize]("GI.Graphene.Structs.Box#g:method:getSize"), [getWidth]("GI.Graphene.Structs.Box#g:method:getWidth").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveBoxMethod                        ,
#endif

-- ** alloc #method:alloc#

    boxAlloc                                ,


-- ** containsBox #method:containsBox#

#if defined(ENABLE_OVERLOADING)
    BoxContainsBoxMethodInfo                ,
#endif
    boxContainsBox                          ,


-- ** containsPoint #method:containsPoint#

#if defined(ENABLE_OVERLOADING)
    BoxContainsPointMethodInfo              ,
#endif
    boxContainsPoint                        ,


-- ** empty #method:empty#

    boxEmpty                                ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    BoxEqualMethodInfo                      ,
#endif
    boxEqual                                ,


-- ** expand #method:expand#

#if defined(ENABLE_OVERLOADING)
    BoxExpandMethodInfo                     ,
#endif
    boxExpand                               ,


-- ** expandScalar #method:expandScalar#

#if defined(ENABLE_OVERLOADING)
    BoxExpandScalarMethodInfo               ,
#endif
    boxExpandScalar                         ,


-- ** expandVec3 #method:expandVec3#

#if defined(ENABLE_OVERLOADING)
    BoxExpandVec3MethodInfo                 ,
#endif
    boxExpandVec3                           ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    BoxFreeMethodInfo                       ,
#endif
    boxFree                                 ,


-- ** getBoundingSphere #method:getBoundingSphere#

#if defined(ENABLE_OVERLOADING)
    BoxGetBoundingSphereMethodInfo          ,
#endif
    boxGetBoundingSphere                    ,


-- ** getCenter #method:getCenter#

#if defined(ENABLE_OVERLOADING)
    BoxGetCenterMethodInfo                  ,
#endif
    boxGetCenter                            ,


-- ** getDepth #method:getDepth#

#if defined(ENABLE_OVERLOADING)
    BoxGetDepthMethodInfo                   ,
#endif
    boxGetDepth                             ,


-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    BoxGetHeightMethodInfo                  ,
#endif
    boxGetHeight                            ,


-- ** getMax #method:getMax#

#if defined(ENABLE_OVERLOADING)
    BoxGetMaxMethodInfo                     ,
#endif
    boxGetMax                               ,


-- ** getMin #method:getMin#

#if defined(ENABLE_OVERLOADING)
    BoxGetMinMethodInfo                     ,
#endif
    boxGetMin                               ,


-- ** getSize #method:getSize#

#if defined(ENABLE_OVERLOADING)
    BoxGetSizeMethodInfo                    ,
#endif
    boxGetSize                              ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    BoxGetWidthMethodInfo                   ,
#endif
    boxGetWidth                             ,


-- ** infinite #method:infinite#

    boxInfinite                             ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    BoxInitMethodInfo                       ,
#endif
    boxInit                                 ,


-- ** initFromBox #method:initFromBox#

#if defined(ENABLE_OVERLOADING)
    BoxInitFromBoxMethodInfo                ,
#endif
    boxInitFromBox                          ,


-- ** initFromPoints #method:initFromPoints#

#if defined(ENABLE_OVERLOADING)
    BoxInitFromPointsMethodInfo             ,
#endif
    boxInitFromPoints                       ,


-- ** initFromVec3 #method:initFromVec3#

#if defined(ENABLE_OVERLOADING)
    BoxInitFromVec3MethodInfo               ,
#endif
    boxInitFromVec3                         ,


-- ** initFromVectors #method:initFromVectors#

#if defined(ENABLE_OVERLOADING)
    BoxInitFromVectorsMethodInfo            ,
#endif
    boxInitFromVectors                      ,


-- ** intersection #method:intersection#

#if defined(ENABLE_OVERLOADING)
    BoxIntersectionMethodInfo               ,
#endif
    boxIntersection                         ,


-- ** minusOne #method:minusOne#

    boxMinusOne                             ,


-- ** one #method:one#

    boxOne                                  ,


-- ** oneMinusOne #method:oneMinusOne#

    boxOneMinusOne                          ,


-- ** union #method:union#

#if defined(ENABLE_OVERLOADING)
    BoxUnionMethodInfo                      ,
#endif
    boxUnion                                ,


-- ** zero #method:zero#

    boxZero                                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Sphere as Graphene.Sphere
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Sphere as Graphene.Sphere
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3

#endif

-- | Memory-managed wrapper type.
newtype Box = Box (SP.ManagedPtr Box)
    deriving (Eq)

instance SP.ManagedPtrNewtype Box where
    toManagedPtr (Box p) = p

foreign import ccall "graphene_box_get_type" c_graphene_box_get_type :: 
    IO GType

type instance O.ParentTypes Box = '[]
instance O.HasParentTypes Box

instance B.Types.TypedObject Box where
    glibType = c_graphene_box_get_type

instance B.Types.GBoxed Box

-- | Convert t'Box' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Box) where
    gvalueGType_ = c_graphene_box_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Box)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Box)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Box ptr
        else return P.Nothing
        
    

-- | Construct a t'Box' struct initialized to zero.
newZeroBox :: MonadIO m => m Box
newZeroBox = liftIO $ callocBoxedBytes 32 >>= wrapBoxed Box

instance tag ~ 'AttrSet => Constructible Box tag where
    new _ attrs = do
        o <- newZeroBox
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Box
type instance O.AttributeList Box = BoxAttributeList
type BoxAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Box::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_alloc" graphene_box_alloc :: 
    IO (Ptr Box)

-- | Allocates a new t'GI.Graphene.Structs.Box.Box'.
-- 
-- The contents of the returned structure are undefined.
-- 
-- /Since: 1.2/
boxAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Box
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Box.Box' structure.
    --   Use 'GI.Graphene.Structs.Box.boxFree' to free the resources allocated by this function
boxAlloc  = liftIO $ do
    result <- graphene_box_alloc
    checkUnexpectedReturnNULL "boxAlloc" result
    result' <- (wrapBoxed Box) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Box::contains_box
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_contains_box" graphene_box_contains_box :: 
    Ptr Box ->                              -- a : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Box ->                              -- b : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO CInt

-- | Checks whether the t'GI.Graphene.Structs.Box.Box' /@a@/ contains the given
-- t'GI.Graphene.Structs.Box.Box' /@b@/.
-- 
-- /Since: 1.2/
boxContainsBox ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@a@/: a t'GI.Graphene.Structs.Box.Box'
    -> Box
    -- ^ /@b@/: a t'GI.Graphene.Structs.Box.Box'
    -> m Bool
    -- ^ __Returns:__ @true@ if the box is contained in the given box
boxContainsBox a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_box_contains_box a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxContainsBoxMethodInfo
instance (signature ~ (Box -> m Bool), MonadIO m) => O.OverloadedMethod BoxContainsBoxMethodInfo Box signature where
    overloadedMethod = boxContainsBox

instance O.OverloadedMethodInfo BoxContainsBoxMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxContainsBox",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxContainsBox"
        })


#endif

-- method Box::contains_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the coordinates to check"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_contains_point" graphene_box_contains_point :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Point3D.Point3D ->         -- point : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CInt

-- | Checks whether /@box@/ contains the given /@point@/.
-- 
-- /Since: 1.2/
boxContainsPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> Graphene.Point3D.Point3D
    -- ^ /@point@/: the coordinates to check
    -> m Bool
    -- ^ __Returns:__ @true@ if the point is contained in the given box
boxContainsPoint box point = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    point' <- unsafeManagedPtrGetPtr point
    result <- graphene_box_contains_point box' point'
    let result' = (/= 0) result
    touchManagedPtr box
    touchManagedPtr point
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxContainsPointMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m Bool), MonadIO m) => O.OverloadedMethod BoxContainsPointMethodInfo Box signature where
    overloadedMethod = boxContainsPoint

instance O.OverloadedMethodInfo BoxContainsPointMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxContainsPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxContainsPoint"
        })


#endif

-- method Box::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_equal" graphene_box_equal :: 
    Ptr Box ->                              -- a : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Box ->                              -- b : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO CInt

-- | Checks whether the two given boxes are equal.
-- 
-- /Since: 1.2/
boxEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@a@/: a t'GI.Graphene.Structs.Box.Box'
    -> Box
    -- ^ /@b@/: a t'GI.Graphene.Structs.Box.Box'
    -> m Bool
    -- ^ __Returns:__ @true@ if the boxes are equal
boxEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_box_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxEqualMethodInfo
instance (signature ~ (Box -> m Bool), MonadIO m) => O.OverloadedMethod BoxEqualMethodInfo Box signature where
    overloadedMethod = boxEqual

instance O.OverloadedMethodInfo BoxEqualMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxEqual"
        })


#endif

-- method Box::expand
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the coordinates of the point to include"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the expanded box"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_expand" graphene_box_expand :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Point3D.Point3D ->         -- point : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Box ->                              -- res : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO ()

-- | Expands the dimensions of /@box@/ to include the coordinates at /@point@/.
-- 
-- /Since: 1.2/
boxExpand ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> Graphene.Point3D.Point3D
    -- ^ /@point@/: the coordinates of the point to include
    -> m (Box)
boxExpand box point = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    point' <- unsafeManagedPtrGetPtr point
    res <- SP.callocBoxedBytes 32 :: IO (Ptr Box)
    graphene_box_expand box' point' res
    res' <- (wrapBoxed Box) res
    touchManagedPtr box
    touchManagedPtr point
    return res'

#if defined(ENABLE_OVERLOADING)
data BoxExpandMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m (Box)), MonadIO m) => O.OverloadedMethod BoxExpandMethodInfo Box signature where
    overloadedMethod = boxExpand

instance O.OverloadedMethodInfo BoxExpandMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxExpand",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxExpand"
        })


#endif

-- method Box::expand_scalar
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scalar"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a scalar value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the expanded box"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_expand_scalar" graphene_box_expand_scalar :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    CFloat ->                               -- scalar : TBasicType TFloat
    Ptr Box ->                              -- res : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO ()

-- | Expands the dimensions of /@box@/ by the given /@scalar@/ value.
-- 
-- If /@scalar@/ is positive, the t'GI.Graphene.Structs.Box.Box' will grow; if /@scalar@/ is
-- negative, the t'GI.Graphene.Structs.Box.Box' will shrink.
-- 
-- /Since: 1.2/
boxExpandScalar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> Float
    -- ^ /@scalar@/: a scalar value
    -> m (Box)
boxExpandScalar box scalar = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    let scalar' = realToFrac scalar
    res <- SP.callocBoxedBytes 32 :: IO (Ptr Box)
    graphene_box_expand_scalar box' scalar' res
    res' <- (wrapBoxed Box) res
    touchManagedPtr box
    return res'

#if defined(ENABLE_OVERLOADING)
data BoxExpandScalarMethodInfo
instance (signature ~ (Float -> m (Box)), MonadIO m) => O.OverloadedMethod BoxExpandScalarMethodInfo Box signature where
    overloadedMethod = boxExpandScalar

instance O.OverloadedMethodInfo BoxExpandScalarMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxExpandScalar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxExpandScalar"
        })


#endif

-- method Box::expand_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vec"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the coordinates of the point to include, as a #graphene_vec3_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the expanded box"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_expand_vec3" graphene_box_expand_vec3 :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Vec3.Vec3 ->               -- vec : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Box ->                              -- res : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO ()

-- | Expands the dimensions of /@box@/ to include the coordinates of the
-- given vector.
-- 
-- /Since: 1.2/
boxExpandVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> Graphene.Vec3.Vec3
    -- ^ /@vec@/: the coordinates of the point to include, as a t'GI.Graphene.Structs.Vec3.Vec3'
    -> m (Box)
boxExpandVec3 box vec = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    vec' <- unsafeManagedPtrGetPtr vec
    res <- SP.callocBoxedBytes 32 :: IO (Ptr Box)
    graphene_box_expand_vec3 box' vec' res
    res' <- (wrapBoxed Box) res
    touchManagedPtr box
    touchManagedPtr vec
    return res'

#if defined(ENABLE_OVERLOADING)
data BoxExpandVec3MethodInfo
instance (signature ~ (Graphene.Vec3.Vec3 -> m (Box)), MonadIO m) => O.OverloadedMethod BoxExpandVec3MethodInfo Box signature where
    overloadedMethod = boxExpandVec3

instance O.OverloadedMethodInfo BoxExpandVec3MethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxExpandVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxExpandVec3"
        })


#endif

-- method Box::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_free" graphene_box_free :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Box.boxAlloc'.
-- 
-- /Since: 1.2/
boxFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m ()
boxFree box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    graphene_box_free box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data BoxFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod BoxFreeMethodInfo Box signature where
    overloadedMethod = boxFree

instance O.OverloadedMethodInfo BoxFreeMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxFree"
        })


#endif

-- method Box::get_bounding_sphere
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sphere"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the bounding sphere"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_bounding_sphere" graphene_box_get_bounding_sphere :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Sphere.Sphere ->           -- sphere : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    IO ()

-- | Computes the bounding t'GI.Graphene.Structs.Sphere.Sphere' capable of containing the given
-- t'GI.Graphene.Structs.Box.Box'.
-- 
-- /Since: 1.2/
boxGetBoundingSphere ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m (Graphene.Sphere.Sphere)
boxGetBoundingSphere box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    sphere <- SP.callocBoxedBytes 20 :: IO (Ptr Graphene.Sphere.Sphere)
    graphene_box_get_bounding_sphere box' sphere
    sphere' <- (wrapBoxed Graphene.Sphere.Sphere) sphere
    touchManagedPtr box
    return sphere'

#if defined(ENABLE_OVERLOADING)
data BoxGetBoundingSphereMethodInfo
instance (signature ~ (m (Graphene.Sphere.Sphere)), MonadIO m) => O.OverloadedMethod BoxGetBoundingSphereMethodInfo Box signature where
    overloadedMethod = boxGetBoundingSphere

instance O.OverloadedMethodInfo BoxGetBoundingSphereMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetBoundingSphere",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetBoundingSphere"
        })


#endif

-- method Box::get_center
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the coordinates of\n  the center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_center" graphene_box_get_center :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Point3D.Point3D ->         -- center : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Retrieves the coordinates of the center of a t'GI.Graphene.Structs.Box.Box'.
-- 
-- /Since: 1.2/
boxGetCenter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m (Graphene.Point3D.Point3D)
boxGetCenter box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    center <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_box_get_center box' center
    center' <- (wrapBoxed Graphene.Point3D.Point3D) center
    touchManagedPtr box
    return center'

#if defined(ENABLE_OVERLOADING)
data BoxGetCenterMethodInfo
instance (signature ~ (m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod BoxGetCenterMethodInfo Box signature where
    overloadedMethod = boxGetCenter

instance O.OverloadedMethodInfo BoxGetCenterMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetCenter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetCenter"
        })


#endif

-- method Box::get_depth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_depth" graphene_box_get_depth :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO CFloat

-- | Retrieves the size of the /@box@/ on the Z axis.
-- 
-- /Since: 1.2/
boxGetDepth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m Float
    -- ^ __Returns:__ the depth of the box
boxGetDepth box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    result <- graphene_box_get_depth box'
    let result' = realToFrac result
    touchManagedPtr box
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxGetDepthMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod BoxGetDepthMethodInfo Box signature where
    overloadedMethod = boxGetDepth

instance O.OverloadedMethodInfo BoxGetDepthMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetDepth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetDepth"
        })


#endif

-- method Box::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_height" graphene_box_get_height :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO CFloat

-- | Retrieves the size of the /@box@/ on the Y axis.
-- 
-- /Since: 1.2/
boxGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m Float
    -- ^ __Returns:__ the height of the box
boxGetHeight box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    result <- graphene_box_get_height box'
    let result' = realToFrac result
    touchManagedPtr box
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxGetHeightMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod BoxGetHeightMethodInfo Box signature where
    overloadedMethod = boxGetHeight

instance O.OverloadedMethodInfo BoxGetHeightMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetHeight"
        })


#endif

-- method Box::get_max
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the maximum point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_max" graphene_box_get_max :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Point3D.Point3D ->         -- max : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Retrieves the coordinates of the maximum point of the given
-- t'GI.Graphene.Structs.Box.Box'.
-- 
-- /Since: 1.2/
boxGetMax ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m (Graphene.Point3D.Point3D)
boxGetMax box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    max <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_box_get_max box' max
    max' <- (wrapBoxed Graphene.Point3D.Point3D) max
    touchManagedPtr box
    return max'

#if defined(ENABLE_OVERLOADING)
data BoxGetMaxMethodInfo
instance (signature ~ (m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod BoxGetMaxMethodInfo Box signature where
    overloadedMethod = boxGetMax

instance O.OverloadedMethodInfo BoxGetMaxMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetMax",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetMax"
        })


#endif

-- method Box::get_min
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the minimum point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_min" graphene_box_get_min :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Point3D.Point3D ->         -- min : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Retrieves the coordinates of the minimum point of the given
-- t'GI.Graphene.Structs.Box.Box'.
-- 
-- /Since: 1.2/
boxGetMin ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m (Graphene.Point3D.Point3D)
boxGetMin box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    min <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_box_get_min box' min
    min' <- (wrapBoxed Graphene.Point3D.Point3D) min
    touchManagedPtr box
    return min'

#if defined(ENABLE_OVERLOADING)
data BoxGetMinMethodInfo
instance (signature ~ (m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod BoxGetMinMethodInfo Box signature where
    overloadedMethod = boxGetMin

instance O.OverloadedMethodInfo BoxGetMinMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetMin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetMin"
        })


#endif

-- method Box::get_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_size" graphene_box_get_size :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Vec3.Vec3 ->               -- size : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

-- | Retrieves the size of the box on all three axes, and stores
-- it into the given /@size@/ vector.
-- 
-- /Since: 1.2/
boxGetSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m (Graphene.Vec3.Vec3)
boxGetSize box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    size <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    graphene_box_get_size box' size
    size' <- (wrapBoxed Graphene.Vec3.Vec3) size
    touchManagedPtr box
    return size'

#if defined(ENABLE_OVERLOADING)
data BoxGetSizeMethodInfo
instance (signature ~ (m (Graphene.Vec3.Vec3)), MonadIO m) => O.OverloadedMethod BoxGetSizeMethodInfo Box signature where
    overloadedMethod = boxGetSize

instance O.OverloadedMethodInfo BoxGetSizeMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetSize"
        })


#endif

-- XXX Could not generate method Box::get_vertices
-- Not implemented: Don't know how to allocate "vertices" of type TCArray False 8 (-1) (TInterface (Name {namespace = "Graphene", name = "Vec3"}))
-- method Box::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_get_width" graphene_box_get_width :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO CFloat

-- | Retrieves the size of the /@box@/ on the X axis.
-- 
-- /Since: 1.2/
boxGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: a t'GI.Graphene.Structs.Box.Box'
    -> m Float
    -- ^ __Returns:__ the width of the box
boxGetWidth box = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    result <- graphene_box_get_width box'
    let result' = realToFrac result
    touchManagedPtr box
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxGetWidthMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod BoxGetWidthMethodInfo Box signature where
    overloadedMethod = boxGetWidth

instance O.OverloadedMethodInfo BoxGetWidthMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxGetWidth"
        })


#endif

-- method Box::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_box_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the coordinates of the minimum vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the coordinates of the maximum vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_init" graphene_box_init :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Point3D.Point3D ->         -- min : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- max : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO (Ptr Box)

-- | Initializes the given t'GI.Graphene.Structs.Box.Box' with two vertices.
-- 
-- /Since: 1.2/
boxInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: the t'GI.Graphene.Structs.Box.Box' to initialize
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@min@/: the coordinates of the minimum vertex
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@max@/: the coordinates of the maximum vertex
    -> m Box
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Box.Box'
boxInit box min max = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    maybeMin <- case min of
        Nothing -> return FP.nullPtr
        Just jMin -> do
            jMin' <- unsafeManagedPtrGetPtr jMin
            return jMin'
    maybeMax <- case max of
        Nothing -> return FP.nullPtr
        Just jMax -> do
            jMax' <- unsafeManagedPtrGetPtr jMax
            return jMax'
    result <- graphene_box_init box' maybeMin maybeMax
    checkUnexpectedReturnNULL "boxInit" result
    result' <- (newBoxed Box) result
    touchManagedPtr box
    whenJust min touchManagedPtr
    whenJust max touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxInitMethodInfo
instance (signature ~ (Maybe (Graphene.Point3D.Point3D) -> Maybe (Graphene.Point3D.Point3D) -> m Box), MonadIO m) => O.OverloadedMethod BoxInitMethodInfo Box signature where
    overloadedMethod = boxInit

instance O.OverloadedMethodInfo BoxInitMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxInit"
        })


#endif

-- method Box::init_from_box
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_box_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_init_from_box" graphene_box_init_from_box :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Box ->                              -- src : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO (Ptr Box)

-- | Initializes the given t'GI.Graphene.Structs.Box.Box' with the vertices of
-- another t'GI.Graphene.Structs.Box.Box'.
-- 
-- /Since: 1.2/
boxInitFromBox ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: the t'GI.Graphene.Structs.Box.Box' to initialize
    -> Box
    -- ^ /@src@/: a t'GI.Graphene.Structs.Box.Box'
    -> m Box
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Box.Box'
boxInitFromBox box src = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_box_init_from_box box' src'
    checkUnexpectedReturnNULL "boxInitFromBox" result
    result' <- (newBoxed Box) result
    touchManagedPtr box
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxInitFromBoxMethodInfo
instance (signature ~ (Box -> m Box), MonadIO m) => O.OverloadedMethod BoxInitFromBoxMethodInfo Box signature where
    overloadedMethod = boxInitFromBox

instance O.OverloadedMethodInfo BoxInitFromBoxMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxInitFromBox",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxInitFromBox"
        })


#endif

-- method Box::init_from_points
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_box_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_points"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number #graphene_point3d_t in the @points array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "points"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Graphene" , name = "Point3D" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_points"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number #graphene_point3d_t in the @points array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_init_from_points" graphene_box_init_from_points :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Word32 ->                               -- n_points : TBasicType TUInt
    Ptr Graphene.Point3D.Point3D ->         -- points : TCArray False (-1) 1 (TInterface (Name {namespace = "Graphene", name = "Point3D"}))
    IO (Ptr Box)

-- | Initializes the given t'GI.Graphene.Structs.Box.Box' with the given array
-- of vertices.
-- 
-- If /@nPoints@/ is 0, the returned box is initialized with
-- 'GI.Graphene.Functions.boxEmpty'.
-- 
-- /Since: 1.2/
boxInitFromPoints ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: the t'GI.Graphene.Structs.Box.Box' to initialize
    -> [Graphene.Point3D.Point3D]
    -- ^ /@points@/: an array of t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Box
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Box.Box'
boxInitFromPoints box points = liftIO $ do
    let nPoints = fromIntegral $ P.length points
    box' <- unsafeManagedPtrGetPtr box
    points' <- mapM unsafeManagedPtrGetPtr points
    points'' <- packBlockArray 12 points'
    result <- graphene_box_init_from_points box' nPoints points''
    checkUnexpectedReturnNULL "boxInitFromPoints" result
    result' <- (newBoxed Box) result
    touchManagedPtr box
    mapM_ touchManagedPtr points
    freeMem points''
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxInitFromPointsMethodInfo
instance (signature ~ ([Graphene.Point3D.Point3D] -> m Box), MonadIO m) => O.OverloadedMethod BoxInitFromPointsMethodInfo Box signature where
    overloadedMethod = boxInitFromPoints

instance O.OverloadedMethodInfo BoxInitFromPointsMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxInitFromPoints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxInitFromPoints"
        })


#endif

-- method Box::init_from_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_box_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the coordinates of the minimum vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the coordinates of the maximum vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_init_from_vec3" graphene_box_init_from_vec3 :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Graphene.Vec3.Vec3 ->               -- min : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Graphene.Vec3.Vec3 ->               -- max : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO (Ptr Box)

-- | Initializes the given t'GI.Graphene.Structs.Box.Box' with two vertices
-- stored inside t'GI.Graphene.Structs.Vec3.Vec3'.
-- 
-- /Since: 1.2/
boxInitFromVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: the t'GI.Graphene.Structs.Box.Box' to initialize
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@min@/: the coordinates of the minimum vertex
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@max@/: the coordinates of the maximum vertex
    -> m Box
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Box.Box'
boxInitFromVec3 box min max = liftIO $ do
    box' <- unsafeManagedPtrGetPtr box
    maybeMin <- case min of
        Nothing -> return FP.nullPtr
        Just jMin -> do
            jMin' <- unsafeManagedPtrGetPtr jMin
            return jMin'
    maybeMax <- case max of
        Nothing -> return FP.nullPtr
        Just jMax -> do
            jMax' <- unsafeManagedPtrGetPtr jMax
            return jMax'
    result <- graphene_box_init_from_vec3 box' maybeMin maybeMax
    checkUnexpectedReturnNULL "boxInitFromVec3" result
    result' <- (newBoxed Box) result
    touchManagedPtr box
    whenJust min touchManagedPtr
    whenJust max touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxInitFromVec3MethodInfo
instance (signature ~ (Maybe (Graphene.Vec3.Vec3) -> Maybe (Graphene.Vec3.Vec3) -> m Box), MonadIO m) => O.OverloadedMethod BoxInitFromVec3MethodInfo Box signature where
    overloadedMethod = boxInitFromVec3

instance O.OverloadedMethodInfo BoxInitFromVec3MethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxInitFromVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxInitFromVec3"
        })


#endif

-- method Box::init_from_vectors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_box_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_vectors"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number #graphene_point3d_t in the @vectors array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vectors"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Graphene" , name = "Vec3" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of #graphene_vec3_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_vectors"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number #graphene_point3d_t in the @vectors array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_init_from_vectors" graphene_box_init_from_vectors :: 
    Ptr Box ->                              -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    Word32 ->                               -- n_vectors : TBasicType TUInt
    Ptr Graphene.Vec3.Vec3 ->               -- vectors : TCArray False (-1) 1 (TInterface (Name {namespace = "Graphene", name = "Vec3"}))
    IO (Ptr Box)

-- | Initializes the given t'GI.Graphene.Structs.Box.Box' with the given array
-- of vertices.
-- 
-- If /@nVectors@/ is 0, the returned box is initialized with
-- 'GI.Graphene.Functions.boxEmpty'.
-- 
-- /Since: 1.2/
boxInitFromVectors ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@box@/: the t'GI.Graphene.Structs.Box.Box' to initialize
    -> [Graphene.Vec3.Vec3]
    -- ^ /@vectors@/: an array of t'GI.Graphene.Structs.Vec3.Vec3'
    -> m Box
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Box.Box'
boxInitFromVectors box vectors = liftIO $ do
    let nVectors = fromIntegral $ P.length vectors
    box' <- unsafeManagedPtrGetPtr box
    vectors' <- mapM unsafeManagedPtrGetPtr vectors
    vectors'' <- packBlockArray 16 vectors'
    result <- graphene_box_init_from_vectors box' nVectors vectors''
    checkUnexpectedReturnNULL "boxInitFromVectors" result
    result' <- (newBoxed Box) result
    touchManagedPtr box
    mapM_ touchManagedPtr vectors
    freeMem vectors''
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxInitFromVectorsMethodInfo
instance (signature ~ ([Graphene.Vec3.Vec3] -> m Box), MonadIO m) => O.OverloadedMethod BoxInitFromVectorsMethodInfo Box signature where
    overloadedMethod = boxInitFromVectors

instance O.OverloadedMethodInfo BoxInitFromVectorsMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxInitFromVectors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxInitFromVectors"
        })


#endif

-- method Box::intersection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_intersection" graphene_box_intersection :: 
    Ptr Box ->                              -- a : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Box ->                              -- b : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Box ->                              -- res : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO CInt

-- | Intersects the two given t'GI.Graphene.Structs.Box.Box'.
-- 
-- If the two boxes do not intersect, /@res@/ will contain a degenerate box
-- initialized with 'GI.Graphene.Functions.boxEmpty'.
-- 
-- /Since: 1.2/
boxIntersection ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@a@/: a t'GI.Graphene.Structs.Box.Box'
    -> Box
    -- ^ /@b@/: a t'GI.Graphene.Structs.Box.Box'
    -> m ((Bool, Box))
    -- ^ __Returns:__ true if the two boxes intersect
boxIntersection a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    res <- SP.callocBoxedBytes 32 :: IO (Ptr Box)
    result <- graphene_box_intersection a' b' res
    let result' = (/= 0) result
    res' <- (wrapBoxed Box) res
    touchManagedPtr a
    touchManagedPtr b
    return (result', res')

#if defined(ENABLE_OVERLOADING)
data BoxIntersectionMethodInfo
instance (signature ~ (Box -> m ((Bool, Box))), MonadIO m) => O.OverloadedMethod BoxIntersectionMethodInfo Box signature where
    overloadedMethod = boxIntersection

instance O.OverloadedMethodInfo BoxIntersectionMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxIntersection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxIntersection"
        })


#endif

-- method Box::union
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_box_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the box to union to @a"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_union" graphene_box_union :: 
    Ptr Box ->                              -- a : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Box ->                              -- b : TInterface (Name {namespace = "Graphene", name = "Box"})
    Ptr Box ->                              -- res : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO ()

-- | Unions the two given t'GI.Graphene.Structs.Box.Box'.
-- 
-- /Since: 1.2/
boxUnion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Box
    -- ^ /@a@/: a t'GI.Graphene.Structs.Box.Box'
    -> Box
    -- ^ /@b@/: the box to union to /@a@/
    -> m (Box)
boxUnion a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    res <- SP.callocBoxedBytes 32 :: IO (Ptr Box)
    graphene_box_union a' b' res
    res' <- (wrapBoxed Box) res
    touchManagedPtr a
    touchManagedPtr b
    return res'

#if defined(ENABLE_OVERLOADING)
data BoxUnionMethodInfo
instance (signature ~ (Box -> m (Box)), MonadIO m) => O.OverloadedMethod BoxUnionMethodInfo Box signature where
    overloadedMethod = boxUnion

instance O.OverloadedMethodInfo BoxUnionMethodInfo Box where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Box.boxUnion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Box.html#v:boxUnion"
        })


#endif

-- method Box::empty
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_empty" graphene_box_empty :: 
    IO (Ptr Box)

-- | A degenerate t'GI.Graphene.Structs.Box.Box' that can only be expanded.
-- 
-- The returned value is owned by Graphene and should not be modified or freed.
-- 
-- /Since: 1.2/
boxEmpty ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Box
    -- ^ __Returns:__ a t'GI.Graphene.Structs.Box.Box'
boxEmpty  = liftIO $ do
    result <- graphene_box_empty
    checkUnexpectedReturnNULL "boxEmpty" result
    result' <- (newBoxed Box) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Box::infinite
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_infinite" graphene_box_infinite :: 
    IO (Ptr Box)

-- | A degenerate t'GI.Graphene.Structs.Box.Box' that cannot be expanded.
-- 
-- The returned value is owned by Graphene and should not be modified or freed.
-- 
-- /Since: 1.2/
boxInfinite ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Box
    -- ^ __Returns:__ a t'GI.Graphene.Structs.Box.Box'
boxInfinite  = liftIO $ do
    result <- graphene_box_infinite
    checkUnexpectedReturnNULL "boxInfinite" result
    result' <- (newBoxed Box) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Box::minus_one
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_minus_one" graphene_box_minus_one :: 
    IO (Ptr Box)

-- | A t'GI.Graphene.Structs.Box.Box' with the minimum vertex set at (-1, -1, -1) and the
-- maximum vertex set at (0, 0, 0).
-- 
-- The returned value is owned by Graphene and should not be modified or freed.
-- 
-- /Since: 1.2/
boxMinusOne ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Box
    -- ^ __Returns:__ a t'GI.Graphene.Structs.Box.Box'
boxMinusOne  = liftIO $ do
    result <- graphene_box_minus_one
    checkUnexpectedReturnNULL "boxMinusOne" result
    result' <- (newBoxed Box) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Box::one
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_one" graphene_box_one :: 
    IO (Ptr Box)

-- | A t'GI.Graphene.Structs.Box.Box' with the minimum vertex set at (0, 0, 0) and the
-- maximum vertex set at (1, 1, 1).
-- 
-- The returned value is owned by Graphene and should not be modified or freed.
-- 
-- /Since: 1.2/
boxOne ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Box
    -- ^ __Returns:__ a t'GI.Graphene.Structs.Box.Box'
boxOne  = liftIO $ do
    result <- graphene_box_one
    checkUnexpectedReturnNULL "boxOne" result
    result' <- (newBoxed Box) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Box::one_minus_one
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_one_minus_one" graphene_box_one_minus_one :: 
    IO (Ptr Box)

-- | A t'GI.Graphene.Structs.Box.Box' with the minimum vertex set at (-1, -1, -1) and the
-- maximum vertex set at (1, 1, 1).
-- 
-- The returned value is owned by Graphene and should not be modified or freed.
-- 
-- /Since: 1.2/
boxOneMinusOne ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Box
    -- ^ __Returns:__ a t'GI.Graphene.Structs.Box.Box'
boxOneMinusOne  = liftIO $ do
    result <- graphene_box_one_minus_one
    checkUnexpectedReturnNULL "boxOneMinusOne" result
    result' <- (newBoxed Box) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Box::zero
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Box" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_box_zero" graphene_box_zero :: 
    IO (Ptr Box)

-- | A t'GI.Graphene.Structs.Box.Box' with both the minimum and maximum vertices set at (0, 0, 0).
-- 
-- The returned value is owned by Graphene and should not be modified or freed.
-- 
-- /Since: 1.2/
boxZero ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Box
    -- ^ __Returns:__ a t'GI.Graphene.Structs.Box.Box'
boxZero  = liftIO $ do
    result <- graphene_box_zero
    checkUnexpectedReturnNULL "boxZero" result
    result' <- (newBoxed Box) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveBoxMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBoxMethod "containsBox" o = BoxContainsBoxMethodInfo
    ResolveBoxMethod "containsPoint" o = BoxContainsPointMethodInfo
    ResolveBoxMethod "equal" o = BoxEqualMethodInfo
    ResolveBoxMethod "expand" o = BoxExpandMethodInfo
    ResolveBoxMethod "expandScalar" o = BoxExpandScalarMethodInfo
    ResolveBoxMethod "expandVec3" o = BoxExpandVec3MethodInfo
    ResolveBoxMethod "free" o = BoxFreeMethodInfo
    ResolveBoxMethod "init" o = BoxInitMethodInfo
    ResolveBoxMethod "initFromBox" o = BoxInitFromBoxMethodInfo
    ResolveBoxMethod "initFromPoints" o = BoxInitFromPointsMethodInfo
    ResolveBoxMethod "initFromVec3" o = BoxInitFromVec3MethodInfo
    ResolveBoxMethod "initFromVectors" o = BoxInitFromVectorsMethodInfo
    ResolveBoxMethod "intersection" o = BoxIntersectionMethodInfo
    ResolveBoxMethod "union" o = BoxUnionMethodInfo
    ResolveBoxMethod "getBoundingSphere" o = BoxGetBoundingSphereMethodInfo
    ResolveBoxMethod "getCenter" o = BoxGetCenterMethodInfo
    ResolveBoxMethod "getDepth" o = BoxGetDepthMethodInfo
    ResolveBoxMethod "getHeight" o = BoxGetHeightMethodInfo
    ResolveBoxMethod "getMax" o = BoxGetMaxMethodInfo
    ResolveBoxMethod "getMin" o = BoxGetMinMethodInfo
    ResolveBoxMethod "getSize" o = BoxGetSizeMethodInfo
    ResolveBoxMethod "getWidth" o = BoxGetWidthMethodInfo
    ResolveBoxMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBoxMethod t Box, O.OverloadedMethod info Box p) => OL.IsLabel t (Box -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBoxMethod t Box, O.OverloadedMethod info Box p, R.HasField t Box p) => R.HasField t Box p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBoxMethod t Box, O.OverloadedMethodInfo info Box) => OL.IsLabel t (O.MethodProxy info Box) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


