{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GtkAppChooserButton@ lets the user select an application.
-- 
-- \<picture>
--   \<source srcset=\"appchooserbutton-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkAppChooserButton\" src=\"appchooserbutton.png\">
-- \<\/picture>
-- 
-- Initially, a @GtkAppChooserButton@ selects the first application
-- in its list, which will either be the most-recently used application
-- or, if [AppChooserButton:showDefaultItem]("GI.Gtk.Objects.AppChooserButton#g:attr:showDefaultItem") is 'P.True', the
-- default application.
-- 
-- The list of applications shown in a @GtkAppChooserButton@ includes
-- the recommended applications for the given content type. When
-- [AppChooserButton:showDefaultItem]("GI.Gtk.Objects.AppChooserButton#g:attr:showDefaultItem") is set, the default
-- application is also included. To let the user chooser other applications,
-- you can set the [AppChooserButton:showDialogItem]("GI.Gtk.Objects.AppChooserButton#g:attr:showDialogItem") property,
-- which allows to open a full t'GI.Gtk.Objects.AppChooserDialog.AppChooserDialog'.
-- 
-- It is possible to add custom items to the list, using
-- 'GI.Gtk.Objects.AppChooserButton.appChooserButtonAppendCustomItem'. These items cause
-- the [AppChooserButton::customItemActivated]("GI.Gtk.Objects.AppChooserButton#g:signal:customItemActivated") signal to be
-- emitted when they are selected.
-- 
-- To track changes in the selected application, use the
-- [AppChooserButton::changed]("GI.Gtk.Objects.AppChooserButton#g:signal:changed") signal.
-- 
-- == CSS nodes
-- 
-- @GtkAppChooserButton@ has a single CSS node with the name “appchooserbutton”.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AppChooserButton
    ( 

-- * Exported types
    AppChooserButton(..)                    ,
    IsAppChooserButton                      ,
    toAppChooserButton                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [appendCustomItem]("GI.Gtk.Objects.AppChooserButton#g:method:appendCustomItem"), [appendSeparator]("GI.Gtk.Objects.AppChooserButton#g:method:appendSeparator"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refresh]("GI.Gtk.Interfaces.AppChooser#g:method:refresh"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAppInfo]("GI.Gtk.Interfaces.AppChooser#g:method:getAppInfo"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getContentType]("GI.Gtk.Interfaces.AppChooser#g:method:getContentType"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeading]("GI.Gtk.Objects.AppChooserButton#g:method:getHeading"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getModal]("GI.Gtk.Objects.AppChooserButton#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowDefaultItem]("GI.Gtk.Objects.AppChooserButton#g:method:getShowDefaultItem"), [getShowDialogItem]("GI.Gtk.Objects.AppChooserButton#g:method:getShowDialogItem"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActiveCustomItem]("GI.Gtk.Objects.AppChooserButton#g:method:setActiveCustomItem"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHeading]("GI.Gtk.Objects.AppChooserButton#g:method:setHeading"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setModal]("GI.Gtk.Objects.AppChooserButton#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowDefaultItem]("GI.Gtk.Objects.AppChooserButton#g:method:setShowDefaultItem"), [setShowDialogItem]("GI.Gtk.Objects.AppChooserButton#g:method:setShowDialogItem"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveAppChooserButtonMethod           ,
#endif

-- ** appendCustomItem #method:appendCustomItem#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonAppendCustomItemMethodInfo,
#endif
    appChooserButtonAppendCustomItem        ,


-- ** appendSeparator #method:appendSeparator#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonAppendSeparatorMethodInfo,
#endif
    appChooserButtonAppendSeparator         ,


-- ** getHeading #method:getHeading#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonGetHeadingMethodInfo    ,
#endif
    appChooserButtonGetHeading              ,


-- ** getModal #method:getModal#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonGetModalMethodInfo      ,
#endif
    appChooserButtonGetModal                ,


-- ** getShowDefaultItem #method:getShowDefaultItem#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonGetShowDefaultItemMethodInfo,
#endif
    appChooserButtonGetShowDefaultItem      ,


-- ** getShowDialogItem #method:getShowDialogItem#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonGetShowDialogItemMethodInfo,
#endif
    appChooserButtonGetShowDialogItem       ,


-- ** new #method:new#

    appChooserButtonNew                     ,


-- ** setActiveCustomItem #method:setActiveCustomItem#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonSetActiveCustomItemMethodInfo,
#endif
    appChooserButtonSetActiveCustomItem     ,


-- ** setHeading #method:setHeading#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonSetHeadingMethodInfo    ,
#endif
    appChooserButtonSetHeading              ,


-- ** setModal #method:setModal#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonSetModalMethodInfo      ,
#endif
    appChooserButtonSetModal                ,


-- ** setShowDefaultItem #method:setShowDefaultItem#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonSetShowDefaultItemMethodInfo,
#endif
    appChooserButtonSetShowDefaultItem      ,


-- ** setShowDialogItem #method:setShowDialogItem#

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonSetShowDialogItemMethodInfo,
#endif
    appChooserButtonSetShowDialogItem       ,




 -- * Properties


-- ** heading #attr:heading#
-- | The text to show at the top of the dialog that can be
-- opened from the button.
-- 
-- The string may contain Pango markup.

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonHeadingPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserButtonHeading                 ,
#endif
    constructAppChooserButtonHeading        ,
    getAppChooserButtonHeading              ,
    setAppChooserButtonHeading              ,


-- ** modal #attr:modal#
-- | Whether the app chooser dialog should be modal.

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonModalPropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserButtonModal                   ,
#endif
    constructAppChooserButtonModal          ,
    getAppChooserButtonModal                ,
    setAppChooserButtonModal                ,


-- ** showDefaultItem #attr:showDefaultItem#
-- | Determines whether the dropdown menu shows the default application
-- on top for the provided content type.

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonShowDefaultItemPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserButtonShowDefaultItem         ,
#endif
    constructAppChooserButtonShowDefaultItem,
    getAppChooserButtonShowDefaultItem      ,
    setAppChooserButtonShowDefaultItem      ,


-- ** showDialogItem #attr:showDialogItem#
-- | Determines whether the dropdown menu shows an item to open
-- a @GtkAppChooserDialog@.

#if defined(ENABLE_OVERLOADING)
    AppChooserButtonShowDialogItemPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserButtonShowDialogItem          ,
#endif
    constructAppChooserButtonShowDialogItem ,
    getAppChooserButtonShowDialogItem       ,
    setAppChooserButtonShowDialogItem       ,




 -- * Signals


-- ** activate #signal:activate#

    AppChooserButtonActivateCallback        ,
#if defined(ENABLE_OVERLOADING)
    AppChooserButtonActivateSignalInfo      ,
#endif
    afterAppChooserButtonActivate           ,
    onAppChooserButtonActivate              ,


-- ** changed #signal:changed#

    AppChooserButtonChangedCallback         ,
#if defined(ENABLE_OVERLOADING)
    AppChooserButtonChangedSignalInfo       ,
#endif
    afterAppChooserButtonChanged            ,
    onAppChooserButtonChanged               ,


-- ** customItemActivated #signal:customItemActivated#

    AppChooserButtonCustomItemActivatedCallback,
#if defined(ENABLE_OVERLOADING)
    AppChooserButtonCustomItemActivatedSignalInfo,
#endif
    afterAppChooserButtonCustomItemActivated,
    onAppChooserButtonCustomItemActivated   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AppChooser as Gtk.AppChooser
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AppChooser as Gtk.AppChooser
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype AppChooserButton = AppChooserButton (SP.ManagedPtr AppChooserButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype AppChooserButton where
    toManagedPtr (AppChooserButton p) = p

foreign import ccall "gtk_app_chooser_button_get_type"
    c_gtk_app_chooser_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject AppChooserButton where
    glibType = c_gtk_app_chooser_button_get_type

instance B.Types.GObject AppChooserButton

-- | Type class for types which can be safely cast to t'AppChooserButton', for instance with `toAppChooserButton`.
class (SP.GObject o, O.IsDescendantOf AppChooserButton o) => IsAppChooserButton o
instance (SP.GObject o, O.IsDescendantOf AppChooserButton o) => IsAppChooserButton o

instance O.HasParentTypes AppChooserButton
type instance O.ParentTypes AppChooserButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AppChooser.AppChooser, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'AppChooserButton', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAppChooserButton :: (MIO.MonadIO m, IsAppChooserButton o) => o -> m AppChooserButton
toAppChooserButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo AppChooserButton

-- | Convert t'AppChooserButton' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AppChooserButton) where
    gvalueGType_ = c_gtk_app_chooser_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AppChooserButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AppChooserButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AppChooserButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAppChooserButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAppChooserButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveAppChooserButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveAppChooserButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveAppChooserButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveAppChooserButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveAppChooserButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveAppChooserButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveAppChooserButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveAppChooserButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveAppChooserButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveAppChooserButtonMethod "appendCustomItem" o = AppChooserButtonAppendCustomItemMethodInfo
    ResolveAppChooserButtonMethod "appendSeparator" o = AppChooserButtonAppendSeparatorMethodInfo
    ResolveAppChooserButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAppChooserButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAppChooserButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveAppChooserButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveAppChooserButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveAppChooserButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveAppChooserButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveAppChooserButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveAppChooserButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveAppChooserButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveAppChooserButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveAppChooserButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveAppChooserButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveAppChooserButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAppChooserButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAppChooserButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAppChooserButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveAppChooserButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveAppChooserButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveAppChooserButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveAppChooserButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveAppChooserButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveAppChooserButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveAppChooserButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveAppChooserButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveAppChooserButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveAppChooserButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveAppChooserButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveAppChooserButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveAppChooserButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAppChooserButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveAppChooserButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveAppChooserButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveAppChooserButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveAppChooserButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveAppChooserButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveAppChooserButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveAppChooserButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveAppChooserButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAppChooserButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAppChooserButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveAppChooserButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveAppChooserButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveAppChooserButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveAppChooserButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveAppChooserButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveAppChooserButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveAppChooserButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAppChooserButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAppChooserButtonMethod "refresh" o = Gtk.AppChooser.AppChooserRefreshMethodInfo
    ResolveAppChooserButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveAppChooserButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveAppChooserButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveAppChooserButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveAppChooserButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveAppChooserButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveAppChooserButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveAppChooserButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAppChooserButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveAppChooserButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveAppChooserButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveAppChooserButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveAppChooserButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAppChooserButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAppChooserButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAppChooserButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveAppChooserButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveAppChooserButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveAppChooserButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveAppChooserButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveAppChooserButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAppChooserButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveAppChooserButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveAppChooserButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveAppChooserButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveAppChooserButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveAppChooserButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveAppChooserButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAppChooserButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveAppChooserButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveAppChooserButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveAppChooserButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveAppChooserButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveAppChooserButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveAppChooserButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveAppChooserButtonMethod "getAppInfo" o = Gtk.AppChooser.AppChooserGetAppInfoMethodInfo
    ResolveAppChooserButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveAppChooserButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveAppChooserButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveAppChooserButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveAppChooserButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveAppChooserButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveAppChooserButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveAppChooserButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveAppChooserButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveAppChooserButtonMethod "getContentType" o = Gtk.AppChooser.AppChooserGetContentTypeMethodInfo
    ResolveAppChooserButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveAppChooserButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveAppChooserButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveAppChooserButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAppChooserButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveAppChooserButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveAppChooserButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveAppChooserButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveAppChooserButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveAppChooserButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveAppChooserButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveAppChooserButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveAppChooserButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveAppChooserButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveAppChooserButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveAppChooserButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveAppChooserButtonMethod "getHeading" o = AppChooserButtonGetHeadingMethodInfo
    ResolveAppChooserButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveAppChooserButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveAppChooserButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveAppChooserButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveAppChooserButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveAppChooserButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveAppChooserButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveAppChooserButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveAppChooserButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveAppChooserButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveAppChooserButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveAppChooserButtonMethod "getModal" o = AppChooserButtonGetModalMethodInfo
    ResolveAppChooserButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveAppChooserButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveAppChooserButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveAppChooserButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveAppChooserButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveAppChooserButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveAppChooserButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveAppChooserButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveAppChooserButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveAppChooserButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveAppChooserButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveAppChooserButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveAppChooserButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAppChooserButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAppChooserButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveAppChooserButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveAppChooserButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveAppChooserButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveAppChooserButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveAppChooserButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveAppChooserButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveAppChooserButtonMethod "getShowDefaultItem" o = AppChooserButtonGetShowDefaultItemMethodInfo
    ResolveAppChooserButtonMethod "getShowDialogItem" o = AppChooserButtonGetShowDialogItemMethodInfo
    ResolveAppChooserButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveAppChooserButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveAppChooserButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveAppChooserButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveAppChooserButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveAppChooserButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveAppChooserButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveAppChooserButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveAppChooserButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveAppChooserButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveAppChooserButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveAppChooserButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveAppChooserButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveAppChooserButtonMethod "setActiveCustomItem" o = AppChooserButtonSetActiveCustomItemMethodInfo
    ResolveAppChooserButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveAppChooserButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveAppChooserButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveAppChooserButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveAppChooserButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveAppChooserButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveAppChooserButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAppChooserButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAppChooserButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveAppChooserButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveAppChooserButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveAppChooserButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveAppChooserButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveAppChooserButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveAppChooserButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveAppChooserButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveAppChooserButtonMethod "setHeading" o = AppChooserButtonSetHeadingMethodInfo
    ResolveAppChooserButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveAppChooserButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveAppChooserButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveAppChooserButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveAppChooserButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveAppChooserButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveAppChooserButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveAppChooserButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveAppChooserButtonMethod "setModal" o = AppChooserButtonSetModalMethodInfo
    ResolveAppChooserButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveAppChooserButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveAppChooserButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveAppChooserButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveAppChooserButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAppChooserButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveAppChooserButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveAppChooserButtonMethod "setShowDefaultItem" o = AppChooserButtonSetShowDefaultItemMethodInfo
    ResolveAppChooserButtonMethod "setShowDialogItem" o = AppChooserButtonSetShowDialogItemMethodInfo
    ResolveAppChooserButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveAppChooserButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveAppChooserButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveAppChooserButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveAppChooserButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveAppChooserButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveAppChooserButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveAppChooserButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveAppChooserButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAppChooserButtonMethod t AppChooserButton, O.OverloadedMethod info AppChooserButton p) => OL.IsLabel t (AppChooserButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAppChooserButtonMethod t AppChooserButton, O.OverloadedMethod info AppChooserButton p, R.HasField t AppChooserButton p) => R.HasField t AppChooserButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAppChooserButtonMethod t AppChooserButton, O.OverloadedMethodInfo info AppChooserButton) => OL.IsLabel t (O.MethodProxy info AppChooserButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal AppChooserButton::activate
-- | Emitted to when the button is activated.
-- 
-- The @::activate@ signal on @GtkAppChooserButton@ is an action signal and
-- emitting it causes the button to pop up its dialog.
-- 
-- /Since: 4.4/
type AppChooserButtonActivateCallback =
    IO ()

type C_AppChooserButtonActivateCallback =
    Ptr AppChooserButton ->                 -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AppChooserButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_AppChooserButtonActivateCallback :: C_AppChooserButtonActivateCallback -> IO (FunPtr C_AppChooserButtonActivateCallback)

wrap_AppChooserButtonActivateCallback :: 
    GObject a => (a -> AppChooserButtonActivateCallback) ->
    C_AppChooserButtonActivateCallback
wrap_AppChooserButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' appChooserButton #activate callback
-- @
-- 
-- 
onAppChooserButtonActivate :: (IsAppChooserButton a, MonadIO m) => a -> ((?self :: a) => AppChooserButtonActivateCallback) -> m SignalHandlerId
onAppChooserButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserButtonActivateCallback wrapped
    wrapped'' <- mk_AppChooserButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' appChooserButton #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAppChooserButtonActivate :: (IsAppChooserButton a, MonadIO m) => a -> ((?self :: a) => AppChooserButtonActivateCallback) -> m SignalHandlerId
afterAppChooserButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserButtonActivateCallback wrapped
    wrapped'' <- mk_AppChooserButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AppChooserButtonActivateSignalInfo
instance SignalInfo AppChooserButtonActivateSignalInfo where
    type HaskellCallbackType AppChooserButtonActivateSignalInfo = AppChooserButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AppChooserButtonActivateCallback cb
        cb'' <- mk_AppChooserButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#g:signal:activate"})

#endif

-- signal AppChooserButton::changed
-- | Emitted when the active application changes.
type AppChooserButtonChangedCallback =
    IO ()

type C_AppChooserButtonChangedCallback =
    Ptr AppChooserButton ->                 -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AppChooserButtonChangedCallback`.
foreign import ccall "wrapper"
    mk_AppChooserButtonChangedCallback :: C_AppChooserButtonChangedCallback -> IO (FunPtr C_AppChooserButtonChangedCallback)

wrap_AppChooserButtonChangedCallback :: 
    GObject a => (a -> AppChooserButtonChangedCallback) ->
    C_AppChooserButtonChangedCallback
wrap_AppChooserButtonChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' appChooserButton #changed callback
-- @
-- 
-- 
onAppChooserButtonChanged :: (IsAppChooserButton a, MonadIO m) => a -> ((?self :: a) => AppChooserButtonChangedCallback) -> m SignalHandlerId
onAppChooserButtonChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserButtonChangedCallback wrapped
    wrapped'' <- mk_AppChooserButtonChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' appChooserButton #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAppChooserButtonChanged :: (IsAppChooserButton a, MonadIO m) => a -> ((?self :: a) => AppChooserButtonChangedCallback) -> m SignalHandlerId
afterAppChooserButtonChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserButtonChangedCallback wrapped
    wrapped'' <- mk_AppChooserButtonChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AppChooserButtonChangedSignalInfo
instance SignalInfo AppChooserButtonChangedSignalInfo where
    type HaskellCallbackType AppChooserButtonChangedSignalInfo = AppChooserButtonChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AppChooserButtonChangedCallback cb
        cb'' <- mk_AppChooserButtonChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#g:signal:changed"})

#endif

-- signal AppChooserButton::custom-item-activated
-- | Emitted when a custom item is activated.
-- 
-- Use 'GI.Gtk.Objects.AppChooserButton.appChooserButtonAppendCustomItem',
-- to add custom items.
type AppChooserButtonCustomItemActivatedCallback =
    T.Text
    -- ^ /@itemName@/: the name of the activated item
    -> IO ()

type C_AppChooserButtonCustomItemActivatedCallback =
    Ptr AppChooserButton ->                 -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AppChooserButtonCustomItemActivatedCallback`.
foreign import ccall "wrapper"
    mk_AppChooserButtonCustomItemActivatedCallback :: C_AppChooserButtonCustomItemActivatedCallback -> IO (FunPtr C_AppChooserButtonCustomItemActivatedCallback)

wrap_AppChooserButtonCustomItemActivatedCallback :: 
    GObject a => (a -> AppChooserButtonCustomItemActivatedCallback) ->
    C_AppChooserButtonCustomItemActivatedCallback
wrap_AppChooserButtonCustomItemActivatedCallback gi'cb gi'selfPtr itemName _ = do
    itemName' <- cstringToText itemName
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  itemName'


-- | Connect a signal handler for the [customItemActivated](#signal:customItemActivated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' appChooserButton #customItemActivated callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@custom-item-activated::detail@” instead.
-- 
onAppChooserButtonCustomItemActivated :: (IsAppChooserButton a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => AppChooserButtonCustomItemActivatedCallback) -> m SignalHandlerId
onAppChooserButtonCustomItemActivated obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserButtonCustomItemActivatedCallback wrapped
    wrapped'' <- mk_AppChooserButtonCustomItemActivatedCallback wrapped'
    connectSignalFunPtr obj "custom-item-activated" wrapped'' SignalConnectBefore detail

-- | Connect a signal handler for the [customItemActivated](#signal:customItemActivated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' appChooserButton #customItemActivated callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@custom-item-activated::detail@” instead.
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAppChooserButtonCustomItemActivated :: (IsAppChooserButton a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => AppChooserButtonCustomItemActivatedCallback) -> m SignalHandlerId
afterAppChooserButtonCustomItemActivated obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserButtonCustomItemActivatedCallback wrapped
    wrapped'' <- mk_AppChooserButtonCustomItemActivatedCallback wrapped'
    connectSignalFunPtr obj "custom-item-activated" wrapped'' SignalConnectAfter detail


#if defined(ENABLE_OVERLOADING)
data AppChooserButtonCustomItemActivatedSignalInfo
instance SignalInfo AppChooserButtonCustomItemActivatedSignalInfo where
    type HaskellCallbackType AppChooserButtonCustomItemActivatedSignalInfo = AppChooserButtonCustomItemActivatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AppChooserButtonCustomItemActivatedCallback cb
        cb'' <- mk_AppChooserButtonCustomItemActivatedCallback cb'
        connectSignalFunPtr obj "custom-item-activated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton::custom-item-activated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#g:signal:customItemActivated"})

#endif

-- VVV Prop "heading"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@heading@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserButton #heading
-- @
getAppChooserButtonHeading :: (MonadIO m, IsAppChooserButton o) => o -> m (Maybe T.Text)
getAppChooserButtonHeading obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "heading"

-- | Set the value of the “@heading@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserButton [ #heading 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserButtonHeading :: (MonadIO m, IsAppChooserButton o) => o -> T.Text -> m ()
setAppChooserButtonHeading obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "heading" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@heading@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserButtonHeading :: (IsAppChooserButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAppChooserButtonHeading val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "heading" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonHeadingPropertyInfo
instance AttrInfo AppChooserButtonHeadingPropertyInfo where
    type AttrAllowedOps AppChooserButtonHeadingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AppChooserButtonHeadingPropertyInfo = IsAppChooserButton
    type AttrSetTypeConstraint AppChooserButtonHeadingPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AppChooserButtonHeadingPropertyInfo = (~) T.Text
    type AttrTransferType AppChooserButtonHeadingPropertyInfo = T.Text
    type AttrGetType AppChooserButtonHeadingPropertyInfo = (Maybe T.Text)
    type AttrLabel AppChooserButtonHeadingPropertyInfo = "heading"
    type AttrOrigin AppChooserButtonHeadingPropertyInfo = AppChooserButton
    attrGet = getAppChooserButtonHeading
    attrSet = setAppChooserButtonHeading
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserButtonHeading
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.heading"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#g:attr:heading"
        })
#endif

-- VVV Prop "modal"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserButton #modal
-- @
getAppChooserButtonModal :: (MonadIO m, IsAppChooserButton o) => o -> m Bool
getAppChooserButtonModal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "modal"

-- | Set the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserButton [ #modal 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserButtonModal :: (MonadIO m, IsAppChooserButton o) => o -> Bool -> m ()
setAppChooserButtonModal obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "modal" val

-- | Construct a t'GValueConstruct' with valid value for the “@modal@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserButtonModal :: (IsAppChooserButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserButtonModal val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "modal" val

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonModalPropertyInfo
instance AttrInfo AppChooserButtonModalPropertyInfo where
    type AttrAllowedOps AppChooserButtonModalPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserButtonModalPropertyInfo = IsAppChooserButton
    type AttrSetTypeConstraint AppChooserButtonModalPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserButtonModalPropertyInfo = (~) Bool
    type AttrTransferType AppChooserButtonModalPropertyInfo = Bool
    type AttrGetType AppChooserButtonModalPropertyInfo = Bool
    type AttrLabel AppChooserButtonModalPropertyInfo = "modal"
    type AttrOrigin AppChooserButtonModalPropertyInfo = AppChooserButton
    attrGet = getAppChooserButtonModal
    attrSet = setAppChooserButtonModal
    attrPut = setAppChooserButtonModal
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserButtonModal
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.modal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#g:attr:modal"
        })
#endif

-- VVV Prop "show-default-item"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-default-item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserButton #showDefaultItem
-- @
getAppChooserButtonShowDefaultItem :: (MonadIO m, IsAppChooserButton o) => o -> m Bool
getAppChooserButtonShowDefaultItem obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-default-item"

-- | Set the value of the “@show-default-item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserButton [ #showDefaultItem 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserButtonShowDefaultItem :: (MonadIO m, IsAppChooserButton o) => o -> Bool -> m ()
setAppChooserButtonShowDefaultItem obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-default-item" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-default-item@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserButtonShowDefaultItem :: (IsAppChooserButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserButtonShowDefaultItem val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-default-item" val

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonShowDefaultItemPropertyInfo
instance AttrInfo AppChooserButtonShowDefaultItemPropertyInfo where
    type AttrAllowedOps AppChooserButtonShowDefaultItemPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserButtonShowDefaultItemPropertyInfo = IsAppChooserButton
    type AttrSetTypeConstraint AppChooserButtonShowDefaultItemPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserButtonShowDefaultItemPropertyInfo = (~) Bool
    type AttrTransferType AppChooserButtonShowDefaultItemPropertyInfo = Bool
    type AttrGetType AppChooserButtonShowDefaultItemPropertyInfo = Bool
    type AttrLabel AppChooserButtonShowDefaultItemPropertyInfo = "show-default-item"
    type AttrOrigin AppChooserButtonShowDefaultItemPropertyInfo = AppChooserButton
    attrGet = getAppChooserButtonShowDefaultItem
    attrSet = setAppChooserButtonShowDefaultItem
    attrPut = setAppChooserButtonShowDefaultItem
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserButtonShowDefaultItem
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.showDefaultItem"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#g:attr:showDefaultItem"
        })
#endif

-- VVV Prop "show-dialog-item"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-dialog-item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserButton #showDialogItem
-- @
getAppChooserButtonShowDialogItem :: (MonadIO m, IsAppChooserButton o) => o -> m Bool
getAppChooserButtonShowDialogItem obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-dialog-item"

-- | Set the value of the “@show-dialog-item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserButton [ #showDialogItem 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserButtonShowDialogItem :: (MonadIO m, IsAppChooserButton o) => o -> Bool -> m ()
setAppChooserButtonShowDialogItem obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-dialog-item" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-dialog-item@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserButtonShowDialogItem :: (IsAppChooserButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserButtonShowDialogItem val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-dialog-item" val

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonShowDialogItemPropertyInfo
instance AttrInfo AppChooserButtonShowDialogItemPropertyInfo where
    type AttrAllowedOps AppChooserButtonShowDialogItemPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserButtonShowDialogItemPropertyInfo = IsAppChooserButton
    type AttrSetTypeConstraint AppChooserButtonShowDialogItemPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserButtonShowDialogItemPropertyInfo = (~) Bool
    type AttrTransferType AppChooserButtonShowDialogItemPropertyInfo = Bool
    type AttrGetType AppChooserButtonShowDialogItemPropertyInfo = Bool
    type AttrLabel AppChooserButtonShowDialogItemPropertyInfo = "show-dialog-item"
    type AttrOrigin AppChooserButtonShowDialogItemPropertyInfo = AppChooserButton
    attrGet = getAppChooserButtonShowDialogItem
    attrSet = setAppChooserButtonShowDialogItem
    attrPut = setAppChooserButtonShowDialogItem
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserButtonShowDialogItem
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.showDialogItem"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#g:attr:showDialogItem"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AppChooserButton
type instance O.AttributeList AppChooserButton = AppChooserButtonAttributeList
type AppChooserButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("contentType", Gtk.AppChooser.AppChooserContentTypePropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heading", AppChooserButtonHeadingPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("modal", AppChooserButtonModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showDefaultItem", AppChooserButtonShowDefaultItemPropertyInfo), '("showDialogItem", AppChooserButtonShowDialogItemPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
appChooserButtonHeading :: AttrLabelProxy "heading"
appChooserButtonHeading = AttrLabelProxy

appChooserButtonModal :: AttrLabelProxy "modal"
appChooserButtonModal = AttrLabelProxy

appChooserButtonShowDefaultItem :: AttrLabelProxy "showDefaultItem"
appChooserButtonShowDefaultItem = AttrLabelProxy

appChooserButtonShowDialogItem :: AttrLabelProxy "showDialogItem"
appChooserButtonShowDialogItem = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AppChooserButton = AppChooserButtonSignalList
type AppChooserButtonSignalList = ('[ '("activate", AppChooserButtonActivateSignalInfo), '("changed", AppChooserButtonChangedSignalInfo), '("customItemActivated", AppChooserButtonCustomItemActivatedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AppChooserButton::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the content type to show applications for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "AppChooserButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_new" gtk_app_chooser_button_new :: 
    CString ->                              -- content_type : TBasicType TUTF8
    IO (Ptr AppChooserButton)

{-# DEPRECATED appChooserButtonNew ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Creates a new @GtkAppChooserButton@ for applications
-- that can handle content of the given type.
appChooserButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@contentType@/: the content type to show applications for
    -> m AppChooserButton
    -- ^ __Returns:__ a newly created @GtkAppChooserButton@
appChooserButtonNew contentType = liftIO $ do
    contentType' <- textToCString contentType
    result <- gtk_app_chooser_button_new contentType'
    checkUnexpectedReturnNULL "appChooserButtonNew" result
    result' <- (newObject AppChooserButton) result
    freeMem contentType'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppChooserButton::append_custom_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the custom item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the label for the custom item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the icon for the custom item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_append_custom_item" gtk_app_chooser_button_append_custom_item :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- label : TBasicType TUTF8
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO ()

{-# DEPRECATED appChooserButtonAppendCustomItem ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Appends a custom item to the list of applications that is shown
-- in the popup.
-- 
-- The item name must be unique per-widget. Clients can use the
-- provided name as a detail for the
-- [AppChooserButton::customItemActivated]("GI.Gtk.Objects.AppChooserButton#g:signal:customItemActivated") signal, to add a
-- callback for the activation of a particular custom item in the list.
-- 
-- See also 'GI.Gtk.Objects.AppChooserButton.appChooserButtonAppendSeparator'.
appChooserButtonAppendCustomItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a, Gio.Icon.IsIcon b) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> T.Text
    -- ^ /@name@/: the name of the custom item
    -> T.Text
    -- ^ /@label@/: the label for the custom item
    -> b
    -- ^ /@icon@/: the icon for the custom item
    -> m ()
appChooserButtonAppendCustomItem self name label icon = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    name' <- textToCString name
    label' <- textToCString label
    icon' <- unsafeManagedPtrCastPtr icon
    gtk_app_chooser_button_append_custom_item self' name' label' icon'
    touchManagedPtr self
    touchManagedPtr icon
    freeMem name'
    freeMem label'
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonAppendCustomItemMethodInfo
instance (signature ~ (T.Text -> T.Text -> b -> m ()), MonadIO m, IsAppChooserButton a, Gio.Icon.IsIcon b) => O.OverloadedMethod AppChooserButtonAppendCustomItemMethodInfo a signature where
    overloadedMethod = appChooserButtonAppendCustomItem

instance O.OverloadedMethodInfo AppChooserButtonAppendCustomItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonAppendCustomItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonAppendCustomItem"
        })


#endif

-- method AppChooserButton::append_separator
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_append_separator" gtk_app_chooser_button_append_separator :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    IO ()

{-# DEPRECATED appChooserButtonAppendSeparator ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Appends a separator to the list of applications that is shown
-- in the popup.
appChooserButtonAppendSeparator ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> m ()
appChooserButtonAppendSeparator self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_app_chooser_button_append_separator self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonAppendSeparatorMethodInfo
instance (signature ~ (m ()), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonAppendSeparatorMethodInfo a signature where
    overloadedMethod = appChooserButtonAppendSeparator

instance O.OverloadedMethodInfo AppChooserButtonAppendSeparatorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonAppendSeparator",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonAppendSeparator"
        })


#endif

-- method AppChooserButton::get_heading
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_get_heading" gtk_app_chooser_button_get_heading :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    IO CString

{-# DEPRECATED appChooserButtonGetHeading ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns the text to display at the top of the dialog.
appChooserButtonGetHeading ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the text to display at the top of the dialog,
    --   or 'P.Nothing', in which case a default text is displayed
appChooserButtonGetHeading self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_button_get_heading self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonGetHeadingMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonGetHeadingMethodInfo a signature where
    overloadedMethod = appChooserButtonGetHeading

instance O.OverloadedMethodInfo AppChooserButtonGetHeadingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonGetHeading",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonGetHeading"
        })


#endif

-- method AppChooserButton::get_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_get_modal" gtk_app_chooser_button_get_modal :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    IO CInt

{-# DEPRECATED appChooserButtonGetModal ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets whether the dialog is modal.
appChooserButtonGetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the dialog is modal
appChooserButtonGetModal self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_button_get_modal self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonGetModalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonGetModalMethodInfo a signature where
    overloadedMethod = appChooserButtonGetModal

instance O.OverloadedMethodInfo AppChooserButtonGetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonGetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonGetModal"
        })


#endif

-- method AppChooserButton::get_show_default_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_get_show_default_item" gtk_app_chooser_button_get_show_default_item :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    IO CInt

{-# DEPRECATED appChooserButtonGetShowDefaultItem ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns whether the dropdown menu should show the default
-- application at the top.
appChooserButtonGetShowDefaultItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> m Bool
    -- ^ __Returns:__ the value of [AppChooserButton:showDefaultItem]("GI.Gtk.Objects.AppChooserButton#g:attr:showDefaultItem")
appChooserButtonGetShowDefaultItem self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_button_get_show_default_item self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonGetShowDefaultItemMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonGetShowDefaultItemMethodInfo a signature where
    overloadedMethod = appChooserButtonGetShowDefaultItem

instance O.OverloadedMethodInfo AppChooserButtonGetShowDefaultItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonGetShowDefaultItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonGetShowDefaultItem"
        })


#endif

-- method AppChooserButton::get_show_dialog_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_get_show_dialog_item" gtk_app_chooser_button_get_show_dialog_item :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    IO CInt

{-# DEPRECATED appChooserButtonGetShowDialogItem ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns whether the dropdown menu shows an item
-- for a @GtkAppChooserDialog@.
appChooserButtonGetShowDialogItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> m Bool
    -- ^ __Returns:__ the value of [AppChooserButton:showDialogItem]("GI.Gtk.Objects.AppChooserButton#g:attr:showDialogItem")
appChooserButtonGetShowDialogItem self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_button_get_show_dialog_item self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonGetShowDialogItemMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonGetShowDialogItemMethodInfo a signature where
    overloadedMethod = appChooserButtonGetShowDialogItem

instance O.OverloadedMethodInfo AppChooserButtonGetShowDialogItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonGetShowDialogItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonGetShowDialogItem"
        })


#endif

-- method AppChooserButton::set_active_custom_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the custom item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_set_active_custom_item" gtk_app_chooser_button_set_active_custom_item :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

{-# DEPRECATED appChooserButtonSetActiveCustomItem ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Selects a custom item.
-- 
-- See 'GI.Gtk.Objects.AppChooserButton.appChooserButtonAppendCustomItem'.
-- 
-- Use 'GI.Gtk.Interfaces.AppChooser.appChooserRefresh' to bring the selection
-- to its initial state.
appChooserButtonSetActiveCustomItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> T.Text
    -- ^ /@name@/: the name of the custom item
    -> m ()
appChooserButtonSetActiveCustomItem self name = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    name' <- textToCString name
    gtk_app_chooser_button_set_active_custom_item self' name'
    touchManagedPtr self
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonSetActiveCustomItemMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonSetActiveCustomItemMethodInfo a signature where
    overloadedMethod = appChooserButtonSetActiveCustomItem

instance O.OverloadedMethodInfo AppChooserButtonSetActiveCustomItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonSetActiveCustomItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonSetActiveCustomItem"
        })


#endif

-- method AppChooserButton::set_heading
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "heading"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing Pango markup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_set_heading" gtk_app_chooser_button_set_heading :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    CString ->                              -- heading : TBasicType TUTF8
    IO ()

{-# DEPRECATED appChooserButtonSetHeading ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets the text to display at the top of the dialog.
-- 
-- If the heading is not set, the dialog displays a default text.
appChooserButtonSetHeading ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> T.Text
    -- ^ /@heading@/: a string containing Pango markup
    -> m ()
appChooserButtonSetHeading self heading = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    heading' <- textToCString heading
    gtk_app_chooser_button_set_heading self' heading'
    touchManagedPtr self
    freeMem heading'
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonSetHeadingMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonSetHeadingMethodInfo a signature where
    overloadedMethod = appChooserButtonSetHeading

instance O.OverloadedMethodInfo AppChooserButtonSetHeadingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonSetHeading",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonSetHeading"
        })


#endif

-- method AppChooserButton::set_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make the dialog modal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_set_modal" gtk_app_chooser_button_set_modal :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    CInt ->                                 -- modal : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserButtonSetModal ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the dialog should be modal.
appChooserButtonSetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> Bool
    -- ^ /@modal@/: 'P.True' to make the dialog modal
    -> m ()
appChooserButtonSetModal self modal = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let modal' = (P.fromIntegral . P.fromEnum) modal
    gtk_app_chooser_button_set_modal self' modal'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonSetModalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonSetModalMethodInfo a signature where
    overloadedMethod = appChooserButtonSetModal

instance O.OverloadedMethodInfo AppChooserButtonSetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonSetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonSetModal"
        })


#endif

-- method AppChooserButton::set_show_default_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new value for [property@Gtk.AppChooserButton:show-default-item]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_set_show_default_item" gtk_app_chooser_button_set_show_default_item :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserButtonSetShowDefaultItem ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the dropdown menu of this button should show the
-- default application for the given content type at top.
appChooserButtonSetShowDefaultItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> Bool
    -- ^ /@setting@/: the new value for [AppChooserButton:showDefaultItem]("GI.Gtk.Objects.AppChooserButton#g:attr:showDefaultItem")
    -> m ()
appChooserButtonSetShowDefaultItem self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_app_chooser_button_set_show_default_item self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonSetShowDefaultItemMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonSetShowDefaultItemMethodInfo a signature where
    overloadedMethod = appChooserButtonSetShowDefaultItem

instance O.OverloadedMethodInfo AppChooserButtonSetShowDefaultItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonSetShowDefaultItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonSetShowDefaultItem"
        })


#endif

-- method AppChooserButton::set_show_dialog_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new value for [property@Gtk.AppChooserButton:show-dialog-item]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_button_set_show_dialog_item" gtk_app_chooser_button_set_show_dialog_item :: 
    Ptr AppChooserButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserButton"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserButtonSetShowDialogItem ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the dropdown menu of this button should show an
-- entry to trigger a @GtkAppChooserDialog@.
appChooserButtonSetShowDialogItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserButton a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserButton@
    -> Bool
    -- ^ /@setting@/: the new value for [AppChooserButton:showDialogItem]("GI.Gtk.Objects.AppChooserButton#g:attr:showDialogItem")
    -> m ()
appChooserButtonSetShowDialogItem self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_app_chooser_button_set_show_dialog_item self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserButtonSetShowDialogItemMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserButton a) => O.OverloadedMethod AppChooserButtonSetShowDialogItemMethodInfo a signature where
    overloadedMethod = appChooserButtonSetShowDialogItem

instance O.OverloadedMethodInfo AppChooserButtonSetShowDialogItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserButton.appChooserButtonSetShowDialogItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserButton.html#v:appChooserButtonSetShowDialogItem"
        })


#endif


