{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Tracks the pointer position.
-- 
-- The event controller offers [EventControllerMotion::enter]("GI.Gtk.Objects.EventControllerMotion#g:signal:enter")
-- and [EventControllerMotion::leave]("GI.Gtk.Objects.EventControllerMotion#g:signal:leave") signals, as well as
-- [EventControllerMotion:isPointer]("GI.Gtk.Objects.EventControllerMotion#g:attr:isPointer") and
-- [EventControllerMotion:containsPointer]("GI.Gtk.Objects.EventControllerMotion#g:attr:containsPointer") properties
-- which are updated to reflect changes in the pointer position as it
-- moves over the widget.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.EventControllerMotion
    ( 

-- * Exported types
    EventControllerMotion(..)               ,
    IsEventControllerMotion                 ,
    toEventControllerMotion                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [containsPointer]("GI.Gtk.Objects.EventControllerMotion#g:method:containsPointer"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isPointer]("GI.Gtk.Objects.EventControllerMotion#g:method:isPointer"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveEventControllerMotionMethod      ,
#endif

-- ** containsPointer #method:containsPointer#

#if defined(ENABLE_OVERLOADING)
    EventControllerMotionContainsPointerMethodInfo,
#endif
    eventControllerMotionContainsPointer    ,


-- ** isPointer #method:isPointer#

#if defined(ENABLE_OVERLOADING)
    EventControllerMotionIsPointerMethodInfo,
#endif
    eventControllerMotionIsPointer          ,


-- ** new #method:new#

    eventControllerMotionNew                ,




 -- * Properties


-- ** containsPointer #attr:containsPointer#
-- | Whether the pointer is in the controllers widget or a descendant.
-- 
-- See also [EventControllerMotion:isPointer]("GI.Gtk.Objects.EventControllerMotion#g:attr:isPointer").
-- 
-- When handling crossing events, this property is updated
-- before [EventControllerMotion::enter]("GI.Gtk.Objects.EventControllerMotion#g:signal:enter"), but after
-- [EventControllerMotion::leave]("GI.Gtk.Objects.EventControllerMotion#g:signal:leave") is emitted.

#if defined(ENABLE_OVERLOADING)
    EventControllerMotionContainsPointerPropertyInfo,
#endif
    getEventControllerMotionContainsPointer ,


-- ** isPointer #attr:isPointer#
-- | Whether the pointer is in the controllers widget itself,
-- as opposed to in a descendent widget.
-- 
-- See also [EventControllerMotion:containsPointer]("GI.Gtk.Objects.EventControllerMotion#g:attr:containsPointer").
-- 
-- When handling crossing events, this property is updated
-- before [EventControllerMotion::enter]("GI.Gtk.Objects.EventControllerMotion#g:signal:enter"), but after
-- [EventControllerMotion::leave]("GI.Gtk.Objects.EventControllerMotion#g:signal:leave") is emitted.

#if defined(ENABLE_OVERLOADING)
    EventControllerMotionIsPointerPropertyInfo,
#endif
    getEventControllerMotionIsPointer       ,




 -- * Signals


-- ** enter #signal:enter#

    EventControllerMotionEnterCallback      ,
#if defined(ENABLE_OVERLOADING)
    EventControllerMotionEnterSignalInfo    ,
#endif
    afterEventControllerMotionEnter         ,
    onEventControllerMotionEnter            ,


-- ** leave #signal:leave#

    EventControllerMotionLeaveCallback      ,
#if defined(ENABLE_OVERLOADING)
    EventControllerMotionLeaveSignalInfo    ,
#endif
    afterEventControllerMotionLeave         ,
    onEventControllerMotionLeave            ,


-- ** motion #signal:motion#

    EventControllerMotionMotionCallback     ,
#if defined(ENABLE_OVERLOADING)
    EventControllerMotionMotionSignalInfo   ,
#endif
    afterEventControllerMotionMotion        ,
    onEventControllerMotionMotion           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController

#endif

-- | Memory-managed wrapper type.
newtype EventControllerMotion = EventControllerMotion (SP.ManagedPtr EventControllerMotion)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventControllerMotion where
    toManagedPtr (EventControllerMotion p) = p

foreign import ccall "gtk_event_controller_motion_get_type"
    c_gtk_event_controller_motion_get_type :: IO B.Types.GType

instance B.Types.TypedObject EventControllerMotion where
    glibType = c_gtk_event_controller_motion_get_type

instance B.Types.GObject EventControllerMotion

-- | Type class for types which can be safely cast to t'EventControllerMotion', for instance with `toEventControllerMotion`.
class (SP.GObject o, O.IsDescendantOf EventControllerMotion o) => IsEventControllerMotion o
instance (SP.GObject o, O.IsDescendantOf EventControllerMotion o) => IsEventControllerMotion o

instance O.HasParentTypes EventControllerMotion
type instance O.ParentTypes EventControllerMotion = '[Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to t'EventControllerMotion', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toEventControllerMotion :: (MIO.MonadIO m, IsEventControllerMotion o) => o -> m EventControllerMotion
toEventControllerMotion = MIO.liftIO . B.ManagedPtr.unsafeCastTo EventControllerMotion

-- | Convert t'EventControllerMotion' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EventControllerMotion) where
    gvalueGType_ = c_gtk_event_controller_motion_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EventControllerMotion)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EventControllerMotion)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EventControllerMotion ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEventControllerMotionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventControllerMotionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEventControllerMotionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEventControllerMotionMethod "containsPointer" o = EventControllerMotionContainsPointerMethodInfo
    ResolveEventControllerMotionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEventControllerMotionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEventControllerMotionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEventControllerMotionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEventControllerMotionMethod "isPointer" o = EventControllerMotionIsPointerMethodInfo
    ResolveEventControllerMotionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEventControllerMotionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEventControllerMotionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEventControllerMotionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEventControllerMotionMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveEventControllerMotionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEventControllerMotionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEventControllerMotionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEventControllerMotionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEventControllerMotionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEventControllerMotionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEventControllerMotionMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveEventControllerMotionMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveEventControllerMotionMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveEventControllerMotionMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveEventControllerMotionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEventControllerMotionMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveEventControllerMotionMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveEventControllerMotionMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveEventControllerMotionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEventControllerMotionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEventControllerMotionMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveEventControllerMotionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEventControllerMotionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEventControllerMotionMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveEventControllerMotionMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveEventControllerMotionMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveEventControllerMotionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEventControllerMotionMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveEventControllerMotionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventControllerMotionMethod t EventControllerMotion, O.OverloadedMethod info EventControllerMotion p) => OL.IsLabel t (EventControllerMotion -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventControllerMotionMethod t EventControllerMotion, O.OverloadedMethod info EventControllerMotion p, R.HasField t EventControllerMotion p) => R.HasField t EventControllerMotion p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventControllerMotionMethod t EventControllerMotion, O.OverloadedMethodInfo info EventControllerMotion) => OL.IsLabel t (O.MethodProxy info EventControllerMotion) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal EventControllerMotion::enter
-- | Signals that the pointer has entered the widget.
type EventControllerMotionEnterCallback =
    Double
    -- ^ /@x@/: coordinates of pointer location
    -> Double
    -- ^ /@y@/: coordinates of pointer location
    -> IO ()

type C_EventControllerMotionEnterCallback =
    Ptr EventControllerMotion ->            -- object
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EventControllerMotionEnterCallback`.
foreign import ccall "wrapper"
    mk_EventControllerMotionEnterCallback :: C_EventControllerMotionEnterCallback -> IO (FunPtr C_EventControllerMotionEnterCallback)

wrap_EventControllerMotionEnterCallback :: 
    GObject a => (a -> EventControllerMotionEnterCallback) ->
    C_EventControllerMotionEnterCallback
wrap_EventControllerMotionEnterCallback gi'cb gi'selfPtr x y _ = do
    let x' = realToFrac x
    let y' = realToFrac y
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  x' y'


-- | Connect a signal handler for the [enter](#signal:enter) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerMotion #enter callback
-- @
-- 
-- 
onEventControllerMotionEnter :: (IsEventControllerMotion a, MonadIO m) => a -> ((?self :: a) => EventControllerMotionEnterCallback) -> m SignalHandlerId
onEventControllerMotionEnter obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerMotionEnterCallback wrapped
    wrapped'' <- mk_EventControllerMotionEnterCallback wrapped'
    connectSignalFunPtr obj "enter" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [enter](#signal:enter) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerMotion #enter callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerMotionEnter :: (IsEventControllerMotion a, MonadIO m) => a -> ((?self :: a) => EventControllerMotionEnterCallback) -> m SignalHandlerId
afterEventControllerMotionEnter obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerMotionEnterCallback wrapped
    wrapped'' <- mk_EventControllerMotionEnterCallback wrapped'
    connectSignalFunPtr obj "enter" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerMotionEnterSignalInfo
instance SignalInfo EventControllerMotionEnterSignalInfo where
    type HaskellCallbackType EventControllerMotionEnterSignalInfo = EventControllerMotionEnterCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerMotionEnterCallback cb
        cb'' <- mk_EventControllerMotionEnterCallback cb'
        connectSignalFunPtr obj "enter" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerMotion::enter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerMotion.html#g:signal:enter"})

#endif

-- signal EventControllerMotion::leave
-- | Signals that the pointer has left the widget.
type EventControllerMotionLeaveCallback =
    IO ()

type C_EventControllerMotionLeaveCallback =
    Ptr EventControllerMotion ->            -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EventControllerMotionLeaveCallback`.
foreign import ccall "wrapper"
    mk_EventControllerMotionLeaveCallback :: C_EventControllerMotionLeaveCallback -> IO (FunPtr C_EventControllerMotionLeaveCallback)

wrap_EventControllerMotionLeaveCallback :: 
    GObject a => (a -> EventControllerMotionLeaveCallback) ->
    C_EventControllerMotionLeaveCallback
wrap_EventControllerMotionLeaveCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [leave](#signal:leave) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerMotion #leave callback
-- @
-- 
-- 
onEventControllerMotionLeave :: (IsEventControllerMotion a, MonadIO m) => a -> ((?self :: a) => EventControllerMotionLeaveCallback) -> m SignalHandlerId
onEventControllerMotionLeave obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerMotionLeaveCallback wrapped
    wrapped'' <- mk_EventControllerMotionLeaveCallback wrapped'
    connectSignalFunPtr obj "leave" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [leave](#signal:leave) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerMotion #leave callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerMotionLeave :: (IsEventControllerMotion a, MonadIO m) => a -> ((?self :: a) => EventControllerMotionLeaveCallback) -> m SignalHandlerId
afterEventControllerMotionLeave obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerMotionLeaveCallback wrapped
    wrapped'' <- mk_EventControllerMotionLeaveCallback wrapped'
    connectSignalFunPtr obj "leave" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerMotionLeaveSignalInfo
instance SignalInfo EventControllerMotionLeaveSignalInfo where
    type HaskellCallbackType EventControllerMotionLeaveSignalInfo = EventControllerMotionLeaveCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerMotionLeaveCallback cb
        cb'' <- mk_EventControllerMotionLeaveCallback cb'
        connectSignalFunPtr obj "leave" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerMotion::leave"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerMotion.html#g:signal:leave"})

#endif

-- signal EventControllerMotion::motion
-- | Emitted when the pointer moves inside the widget.
type EventControllerMotionMotionCallback =
    Double
    -- ^ /@x@/: the x coordinate
    -> Double
    -- ^ /@y@/: the y coordinate
    -> IO ()

type C_EventControllerMotionMotionCallback =
    Ptr EventControllerMotion ->            -- object
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EventControllerMotionMotionCallback`.
foreign import ccall "wrapper"
    mk_EventControllerMotionMotionCallback :: C_EventControllerMotionMotionCallback -> IO (FunPtr C_EventControllerMotionMotionCallback)

wrap_EventControllerMotionMotionCallback :: 
    GObject a => (a -> EventControllerMotionMotionCallback) ->
    C_EventControllerMotionMotionCallback
wrap_EventControllerMotionMotionCallback gi'cb gi'selfPtr x y _ = do
    let x' = realToFrac x
    let y' = realToFrac y
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  x' y'


-- | Connect a signal handler for the [motion](#signal:motion) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerMotion #motion callback
-- @
-- 
-- 
onEventControllerMotionMotion :: (IsEventControllerMotion a, MonadIO m) => a -> ((?self :: a) => EventControllerMotionMotionCallback) -> m SignalHandlerId
onEventControllerMotionMotion obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerMotionMotionCallback wrapped
    wrapped'' <- mk_EventControllerMotionMotionCallback wrapped'
    connectSignalFunPtr obj "motion" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [motion](#signal:motion) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerMotion #motion callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerMotionMotion :: (IsEventControllerMotion a, MonadIO m) => a -> ((?self :: a) => EventControllerMotionMotionCallback) -> m SignalHandlerId
afterEventControllerMotionMotion obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerMotionMotionCallback wrapped
    wrapped'' <- mk_EventControllerMotionMotionCallback wrapped'
    connectSignalFunPtr obj "motion" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerMotionMotionSignalInfo
instance SignalInfo EventControllerMotionMotionSignalInfo where
    type HaskellCallbackType EventControllerMotionMotionSignalInfo = EventControllerMotionMotionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerMotionMotionCallback cb
        cb'' <- mk_EventControllerMotionMotionCallback cb'
        connectSignalFunPtr obj "motion" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerMotion::motion"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerMotion.html#g:signal:motion"})

#endif

-- VVV Prop "contains-pointer"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@contains-pointer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventControllerMotion #containsPointer
-- @
getEventControllerMotionContainsPointer :: (MonadIO m, IsEventControllerMotion o) => o -> m Bool
getEventControllerMotionContainsPointer obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "contains-pointer"

#if defined(ENABLE_OVERLOADING)
data EventControllerMotionContainsPointerPropertyInfo
instance AttrInfo EventControllerMotionContainsPointerPropertyInfo where
    type AttrAllowedOps EventControllerMotionContainsPointerPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint EventControllerMotionContainsPointerPropertyInfo = IsEventControllerMotion
    type AttrSetTypeConstraint EventControllerMotionContainsPointerPropertyInfo = (~) ()
    type AttrTransferTypeConstraint EventControllerMotionContainsPointerPropertyInfo = (~) ()
    type AttrTransferType EventControllerMotionContainsPointerPropertyInfo = ()
    type AttrGetType EventControllerMotionContainsPointerPropertyInfo = Bool
    type AttrLabel EventControllerMotionContainsPointerPropertyInfo = "contains-pointer"
    type AttrOrigin EventControllerMotionContainsPointerPropertyInfo = EventControllerMotion
    attrGet = getEventControllerMotionContainsPointer
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerMotion.containsPointer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerMotion.html#g:attr:containsPointer"
        })
#endif

-- VVV Prop "is-pointer"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-pointer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventControllerMotion #isPointer
-- @
getEventControllerMotionIsPointer :: (MonadIO m, IsEventControllerMotion o) => o -> m Bool
getEventControllerMotionIsPointer obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-pointer"

#if defined(ENABLE_OVERLOADING)
data EventControllerMotionIsPointerPropertyInfo
instance AttrInfo EventControllerMotionIsPointerPropertyInfo where
    type AttrAllowedOps EventControllerMotionIsPointerPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint EventControllerMotionIsPointerPropertyInfo = IsEventControllerMotion
    type AttrSetTypeConstraint EventControllerMotionIsPointerPropertyInfo = (~) ()
    type AttrTransferTypeConstraint EventControllerMotionIsPointerPropertyInfo = (~) ()
    type AttrTransferType EventControllerMotionIsPointerPropertyInfo = ()
    type AttrGetType EventControllerMotionIsPointerPropertyInfo = Bool
    type AttrLabel EventControllerMotionIsPointerPropertyInfo = "is-pointer"
    type AttrOrigin EventControllerMotionIsPointerPropertyInfo = EventControllerMotion
    attrGet = getEventControllerMotionIsPointer
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerMotion.isPointer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerMotion.html#g:attr:isPointer"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventControllerMotion
type instance O.AttributeList EventControllerMotion = EventControllerMotionAttributeList
type EventControllerMotionAttributeList = ('[ '("containsPointer", EventControllerMotionContainsPointerPropertyInfo), '("isPointer", EventControllerMotionIsPointerPropertyInfo), '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EventControllerMotion = EventControllerMotionSignalList
type EventControllerMotionSignalList = ('[ '("enter", EventControllerMotionEnterSignalInfo), '("leave", EventControllerMotionLeaveSignalInfo), '("motion", EventControllerMotionMotionSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EventControllerMotion::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "EventControllerMotion" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_motion_new" gtk_event_controller_motion_new :: 
    IO (Ptr EventControllerMotion)

-- | Creates a new event controller that will handle motion events.
eventControllerMotionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m EventControllerMotion
    -- ^ __Returns:__ a new @GtkEventControllerMotion@
eventControllerMotionNew  = liftIO $ do
    result <- gtk_event_controller_motion_new
    checkUnexpectedReturnNULL "eventControllerMotionNew" result
    result' <- (wrapObject EventControllerMotion) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method EventControllerMotion::contains_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "EventControllerMotion" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerMotion`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_motion_contains_pointer" gtk_event_controller_motion_contains_pointer :: 
    Ptr EventControllerMotion ->            -- self : TInterface (Name {namespace = "Gtk", name = "EventControllerMotion"})
    IO CInt

-- | Returns if a pointer is within /@self@/ or one of its children.
eventControllerMotionContainsPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerMotion a) =>
    a
    -- ^ /@self@/: a @GtkEventControllerMotion@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if a pointer is within /@self@/ or one of its children
eventControllerMotionContainsPointer self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_event_controller_motion_contains_pointer self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerMotionContainsPointerMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsEventControllerMotion a) => O.OverloadedMethod EventControllerMotionContainsPointerMethodInfo a signature where
    overloadedMethod = eventControllerMotionContainsPointer

instance O.OverloadedMethodInfo EventControllerMotionContainsPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerMotion.eventControllerMotionContainsPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerMotion.html#v:eventControllerMotionContainsPointer"
        })


#endif

-- method EventControllerMotion::is_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "EventControllerMotion" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerMotion`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_motion_is_pointer" gtk_event_controller_motion_is_pointer :: 
    Ptr EventControllerMotion ->            -- self : TInterface (Name {namespace = "Gtk", name = "EventControllerMotion"})
    IO CInt

-- | Returns if a pointer is within /@self@/, but not one of its children.
eventControllerMotionIsPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerMotion a) =>
    a
    -- ^ /@self@/: a @GtkEventControllerMotion@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if a pointer is within /@self@/ but not one of its children
eventControllerMotionIsPointer self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_event_controller_motion_is_pointer self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerMotionIsPointerMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsEventControllerMotion a) => O.OverloadedMethod EventControllerMotionIsPointerMethodInfo a signature where
    overloadedMethod = eventControllerMotionIsPointer

instance O.OverloadedMethodInfo EventControllerMotionIsPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerMotion.eventControllerMotionIsPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerMotion.html#v:eventControllerMotionIsPointer"
        })


#endif


