{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Font-wide extent values, measured in scaled units.
-- 
-- Note that typically /@ascender@/ is positive and /@descender@/
-- negative, in coordinate systems that grow up.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.FontExtentsT
    ( 

-- * Exported types
    FontExtentsT(..)                        ,
    newZeroFontExtentsT                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveFontExtentsTMethod               ,
#endif



 -- * Properties


-- ** ascender #attr:ascender#
-- | The height of typographic ascenders.

#if defined(ENABLE_OVERLOADING)
    fontExtentsT_ascender                   ,
#endif
    getFontExtentsTAscender                 ,
    setFontExtentsTAscender                 ,


-- ** descender #attr:descender#
-- | The depth of typographic descenders.

#if defined(ENABLE_OVERLOADING)
    fontExtentsT_descender                  ,
#endif
    getFontExtentsTDescender                ,
    setFontExtentsTDescender                ,


-- ** lineGap #attr:lineGap#
-- | The suggested line-spacing gap.

#if defined(ENABLE_OVERLOADING)
    fontExtentsT_lineGap                    ,
#endif
    getFontExtentsTLineGap                  ,
    setFontExtentsTLineGap                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype FontExtentsT = FontExtentsT (SP.ManagedPtr FontExtentsT)
    deriving (Eq)

instance SP.ManagedPtrNewtype FontExtentsT where
    toManagedPtr (FontExtentsT p) = p

instance BoxedPtr FontExtentsT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 48 >=> B.ManagedPtr.wrapPtr FontExtentsT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr FontExtentsT where
    boxedPtrCalloc = callocBytes 48


-- | Construct a t'FontExtentsT' struct initialized to zero.
newZeroFontExtentsT :: MonadIO m => m FontExtentsT
newZeroFontExtentsT = liftIO $ boxedPtrCalloc >>= wrapPtr FontExtentsT

instance tag ~ 'AttrSet => Constructible FontExtentsT tag where
    new _ attrs = do
        o <- newZeroFontExtentsT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ascender@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontExtentsT #ascender
-- @
getFontExtentsTAscender :: MonadIO m => FontExtentsT -> m Int32
getFontExtentsTAscender s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@ascender@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontExtentsT [ #ascender 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontExtentsTAscender :: MonadIO m => FontExtentsT -> Int32 -> m ()
setFontExtentsTAscender s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data FontExtentsTAscenderFieldInfo
instance AttrInfo FontExtentsTAscenderFieldInfo where
    type AttrBaseTypeConstraint FontExtentsTAscenderFieldInfo = (~) FontExtentsT
    type AttrAllowedOps FontExtentsTAscenderFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FontExtentsTAscenderFieldInfo = (~) Int32
    type AttrTransferTypeConstraint FontExtentsTAscenderFieldInfo = (~)Int32
    type AttrTransferType FontExtentsTAscenderFieldInfo = Int32
    type AttrGetType FontExtentsTAscenderFieldInfo = Int32
    type AttrLabel FontExtentsTAscenderFieldInfo = "ascender"
    type AttrOrigin FontExtentsTAscenderFieldInfo = FontExtentsT
    attrGet = getFontExtentsTAscender
    attrSet = setFontExtentsTAscender
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.FontExtentsT.ascender"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-FontExtentsT.html#g:attr:ascender"
        })

fontExtentsT_ascender :: AttrLabelProxy "ascender"
fontExtentsT_ascender = AttrLabelProxy

#endif


-- | Get the value of the “@descender@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontExtentsT #descender
-- @
getFontExtentsTDescender :: MonadIO m => FontExtentsT -> m Int32
getFontExtentsTDescender s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@descender@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontExtentsT [ #descender 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontExtentsTDescender :: MonadIO m => FontExtentsT -> Int32 -> m ()
setFontExtentsTDescender s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data FontExtentsTDescenderFieldInfo
instance AttrInfo FontExtentsTDescenderFieldInfo where
    type AttrBaseTypeConstraint FontExtentsTDescenderFieldInfo = (~) FontExtentsT
    type AttrAllowedOps FontExtentsTDescenderFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FontExtentsTDescenderFieldInfo = (~) Int32
    type AttrTransferTypeConstraint FontExtentsTDescenderFieldInfo = (~)Int32
    type AttrTransferType FontExtentsTDescenderFieldInfo = Int32
    type AttrGetType FontExtentsTDescenderFieldInfo = Int32
    type AttrLabel FontExtentsTDescenderFieldInfo = "descender"
    type AttrOrigin FontExtentsTDescenderFieldInfo = FontExtentsT
    attrGet = getFontExtentsTDescender
    attrSet = setFontExtentsTDescender
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.FontExtentsT.descender"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-FontExtentsT.html#g:attr:descender"
        })

fontExtentsT_descender :: AttrLabelProxy "descender"
fontExtentsT_descender = AttrLabelProxy

#endif


-- | Get the value of the “@line_gap@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontExtentsT #lineGap
-- @
getFontExtentsTLineGap :: MonadIO m => FontExtentsT -> m Int32
getFontExtentsTLineGap s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@line_gap@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontExtentsT [ #lineGap 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontExtentsTLineGap :: MonadIO m => FontExtentsT -> Int32 -> m ()
setFontExtentsTLineGap s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data FontExtentsTLineGapFieldInfo
instance AttrInfo FontExtentsTLineGapFieldInfo where
    type AttrBaseTypeConstraint FontExtentsTLineGapFieldInfo = (~) FontExtentsT
    type AttrAllowedOps FontExtentsTLineGapFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FontExtentsTLineGapFieldInfo = (~) Int32
    type AttrTransferTypeConstraint FontExtentsTLineGapFieldInfo = (~)Int32
    type AttrTransferType FontExtentsTLineGapFieldInfo = Int32
    type AttrGetType FontExtentsTLineGapFieldInfo = Int32
    type AttrLabel FontExtentsTLineGapFieldInfo = "line_gap"
    type AttrOrigin FontExtentsTLineGapFieldInfo = FontExtentsT
    attrGet = getFontExtentsTLineGap
    attrSet = setFontExtentsTLineGap
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.FontExtentsT.lineGap"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-FontExtentsT.html#g:attr:lineGap"
        })

fontExtentsT_lineGap :: AttrLabelProxy "lineGap"
fontExtentsT_lineGap = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FontExtentsT
type instance O.AttributeList FontExtentsT = FontExtentsTAttributeList
type FontExtentsTAttributeList = ('[ '("ascender", FontExtentsTAscenderFieldInfo), '("descender", FontExtentsTDescenderFieldInfo), '("lineGap", FontExtentsTLineGapFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFontExtentsTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontExtentsTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontExtentsTMethod t FontExtentsT, O.OverloadedMethod info FontExtentsT p) => OL.IsLabel t (FontExtentsT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontExtentsTMethod t FontExtentsT, O.OverloadedMethod info FontExtentsT p, R.HasField t FontExtentsT p) => R.HasField t FontExtentsT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontExtentsTMethod t FontExtentsT, O.OverloadedMethodInfo info FontExtentsT) => OL.IsLabel t (O.MethodProxy info FontExtentsT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


