{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoFontDescription@ describes a font in an implementation-independent
-- manner.
-- 
-- @PangoFontDescription@ structures are used both to list what fonts are
-- available on the system and also for specifying the characteristics of
-- a font to load.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.FontDescription
    ( 

-- * Exported types
    FontDescription(..)                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [betterMatch]("GI.Pango.Structs.FontDescription#g:method:betterMatch"), [copy]("GI.Pango.Structs.FontDescription#g:method:copy"), [copyStatic]("GI.Pango.Structs.FontDescription#g:method:copyStatic"), [equal]("GI.Pango.Structs.FontDescription#g:method:equal"), [free]("GI.Pango.Structs.FontDescription#g:method:free"), [hash]("GI.Pango.Structs.FontDescription#g:method:hash"), [merge]("GI.Pango.Structs.FontDescription#g:method:merge"), [mergeStatic]("GI.Pango.Structs.FontDescription#g:method:mergeStatic"), [toFilename]("GI.Pango.Structs.FontDescription#g:method:toFilename"), [toString]("GI.Pango.Structs.FontDescription#g:method:toString"), [unsetFields]("GI.Pango.Structs.FontDescription#g:method:unsetFields").
-- 
-- ==== Getters
-- [getColor]("GI.Pango.Structs.FontDescription#g:method:getColor"), [getFamily]("GI.Pango.Structs.FontDescription#g:method:getFamily"), [getFeatures]("GI.Pango.Structs.FontDescription#g:method:getFeatures"), [getGravity]("GI.Pango.Structs.FontDescription#g:method:getGravity"), [getSetFields]("GI.Pango.Structs.FontDescription#g:method:getSetFields"), [getSize]("GI.Pango.Structs.FontDescription#g:method:getSize"), [getSizeIsAbsolute]("GI.Pango.Structs.FontDescription#g:method:getSizeIsAbsolute"), [getStretch]("GI.Pango.Structs.FontDescription#g:method:getStretch"), [getStyle]("GI.Pango.Structs.FontDescription#g:method:getStyle"), [getVariant]("GI.Pango.Structs.FontDescription#g:method:getVariant"), [getVariations]("GI.Pango.Structs.FontDescription#g:method:getVariations"), [getWeight]("GI.Pango.Structs.FontDescription#g:method:getWeight").
-- 
-- ==== Setters
-- [setAbsoluteSize]("GI.Pango.Structs.FontDescription#g:method:setAbsoluteSize"), [setColor]("GI.Pango.Structs.FontDescription#g:method:setColor"), [setFamily]("GI.Pango.Structs.FontDescription#g:method:setFamily"), [setFamilyStatic]("GI.Pango.Structs.FontDescription#g:method:setFamilyStatic"), [setFeatures]("GI.Pango.Structs.FontDescription#g:method:setFeatures"), [setFeaturesStatic]("GI.Pango.Structs.FontDescription#g:method:setFeaturesStatic"), [setGravity]("GI.Pango.Structs.FontDescription#g:method:setGravity"), [setSize]("GI.Pango.Structs.FontDescription#g:method:setSize"), [setStretch]("GI.Pango.Structs.FontDescription#g:method:setStretch"), [setStyle]("GI.Pango.Structs.FontDescription#g:method:setStyle"), [setVariant]("GI.Pango.Structs.FontDescription#g:method:setVariant"), [setVariations]("GI.Pango.Structs.FontDescription#g:method:setVariations"), [setVariationsStatic]("GI.Pango.Structs.FontDescription#g:method:setVariationsStatic"), [setWeight]("GI.Pango.Structs.FontDescription#g:method:setWeight").

#if defined(ENABLE_OVERLOADING)
    ResolveFontDescriptionMethod            ,
#endif

-- ** betterMatch #method:betterMatch#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionBetterMatchMethodInfo    ,
#endif
    fontDescriptionBetterMatch              ,


-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionCopyMethodInfo           ,
#endif
    fontDescriptionCopy                     ,


-- ** copyStatic #method:copyStatic#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionCopyStaticMethodInfo     ,
#endif
    fontDescriptionCopyStatic               ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionEqualMethodInfo          ,
#endif
    fontDescriptionEqual                    ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionFreeMethodInfo           ,
#endif
    fontDescriptionFree                     ,


-- ** fromString #method:fromString#

    fontDescriptionFromString               ,


-- ** getColor #method:getColor#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetColorMethodInfo       ,
#endif
    fontDescriptionGetColor                 ,


-- ** getFamily #method:getFamily#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetFamilyMethodInfo      ,
#endif
    fontDescriptionGetFamily                ,


-- ** getFeatures #method:getFeatures#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetFeaturesMethodInfo    ,
#endif
    fontDescriptionGetFeatures              ,


-- ** getGravity #method:getGravity#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetGravityMethodInfo     ,
#endif
    fontDescriptionGetGravity               ,


-- ** getSetFields #method:getSetFields#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetSetFieldsMethodInfo   ,
#endif
    fontDescriptionGetSetFields             ,


-- ** getSize #method:getSize#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetSizeMethodInfo        ,
#endif
    fontDescriptionGetSize                  ,


-- ** getSizeIsAbsolute #method:getSizeIsAbsolute#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetSizeIsAbsoluteMethodInfo,
#endif
    fontDescriptionGetSizeIsAbsolute        ,


-- ** getStretch #method:getStretch#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetStretchMethodInfo     ,
#endif
    fontDescriptionGetStretch               ,


-- ** getStyle #method:getStyle#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetStyleMethodInfo       ,
#endif
    fontDescriptionGetStyle                 ,


-- ** getVariant #method:getVariant#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetVariantMethodInfo     ,
#endif
    fontDescriptionGetVariant               ,


-- ** getVariations #method:getVariations#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetVariationsMethodInfo  ,
#endif
    fontDescriptionGetVariations            ,


-- ** getWeight #method:getWeight#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionGetWeightMethodInfo      ,
#endif
    fontDescriptionGetWeight                ,


-- ** hash #method:hash#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionHashMethodInfo           ,
#endif
    fontDescriptionHash                     ,


-- ** merge #method:merge#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionMergeMethodInfo          ,
#endif
    fontDescriptionMerge                    ,


-- ** mergeStatic #method:mergeStatic#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionMergeStaticMethodInfo    ,
#endif
    fontDescriptionMergeStatic              ,


-- ** new #method:new#

    fontDescriptionNew                      ,


-- ** setAbsoluteSize #method:setAbsoluteSize#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetAbsoluteSizeMethodInfo,
#endif
    fontDescriptionSetAbsoluteSize          ,


-- ** setColor #method:setColor#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetColorMethodInfo       ,
#endif
    fontDescriptionSetColor                 ,


-- ** setFamily #method:setFamily#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetFamilyMethodInfo      ,
#endif
    fontDescriptionSetFamily                ,


-- ** setFamilyStatic #method:setFamilyStatic#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetFamilyStaticMethodInfo,
#endif
    fontDescriptionSetFamilyStatic          ,


-- ** setFeatures #method:setFeatures#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetFeaturesMethodInfo    ,
#endif
    fontDescriptionSetFeatures              ,


-- ** setFeaturesStatic #method:setFeaturesStatic#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetFeaturesStaticMethodInfo,
#endif
    fontDescriptionSetFeaturesStatic        ,


-- ** setGravity #method:setGravity#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetGravityMethodInfo     ,
#endif
    fontDescriptionSetGravity               ,


-- ** setSize #method:setSize#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetSizeMethodInfo        ,
#endif
    fontDescriptionSetSize                  ,


-- ** setStretch #method:setStretch#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetStretchMethodInfo     ,
#endif
    fontDescriptionSetStretch               ,


-- ** setStyle #method:setStyle#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetStyleMethodInfo       ,
#endif
    fontDescriptionSetStyle                 ,


-- ** setVariant #method:setVariant#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetVariantMethodInfo     ,
#endif
    fontDescriptionSetVariant               ,


-- ** setVariations #method:setVariations#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetVariationsMethodInfo  ,
#endif
    fontDescriptionSetVariations            ,


-- ** setVariationsStatic #method:setVariationsStatic#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetVariationsStaticMethodInfo,
#endif
    fontDescriptionSetVariationsStatic      ,


-- ** setWeight #method:setWeight#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionSetWeightMethodInfo      ,
#endif
    fontDescriptionSetWeight                ,


-- ** toFilename #method:toFilename#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionToFilenameMethodInfo     ,
#endif
    fontDescriptionToFilename               ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionToStringMethodInfo       ,
#endif
    fontDescriptionToString                 ,


-- ** unsetFields #method:unsetFields#

#if defined(ENABLE_OVERLOADING)
    FontDescriptionUnsetFieldsMethodInfo    ,
#endif
    fontDescriptionUnsetFields              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags

#else
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags

#endif

-- | Memory-managed wrapper type.
newtype FontDescription = FontDescription (SP.ManagedPtr FontDescription)
    deriving (Eq)

instance SP.ManagedPtrNewtype FontDescription where
    toManagedPtr (FontDescription p) = p

foreign import ccall "pango_font_description_get_type" c_pango_font_description_get_type :: 
    IO GType

type instance O.ParentTypes FontDescription = '[]
instance O.HasParentTypes FontDescription

instance B.Types.TypedObject FontDescription where
    glibType = c_pango_font_description_get_type

instance B.Types.GBoxed FontDescription

-- | Convert t'FontDescription' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FontDescription) where
    gvalueGType_ = c_pango_font_description_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr FontDescription)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr FontDescription)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed FontDescription ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FontDescription
type instance O.AttributeList FontDescription = FontDescriptionAttributeList
type FontDescriptionAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method FontDescription::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Pango" , name = "FontDescription" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_new" pango_font_description_new :: 
    IO (Ptr FontDescription)

-- | Creates a new font description structure with all fields unset.
fontDescriptionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m FontDescription
    -- ^ __Returns:__ the newly allocated @PangoFontDescription@,
    --   which should be freed using 'GI.Pango.Structs.FontDescription.fontDescriptionFree'.
fontDescriptionNew  = liftIO $ do
    result <- pango_font_description_new
    checkUnexpectedReturnNULL "fontDescriptionNew" result
    result' <- (wrapBoxed FontDescription) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FontDescription::better_match
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "old_match"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_match"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_better_match" pango_font_description_better_match :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr FontDescription ->                  -- old_match : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr FontDescription ->                  -- new_match : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CInt

-- | Determines if the style attributes of /@newMatch@/ are a closer match
-- for /@desc@/ than those of /@oldMatch@/ are, or if /@oldMatch@/ is 'P.Nothing',
-- determines if /@newMatch@/ is a match at all.
-- 
-- Approximate matching is done for weight and style; other style attributes
-- must match exactly. Style attributes are all attributes other than family
-- and size-related attributes. Approximate matching for style considers
-- 'GI.Pango.Enums.StyleOblique' and 'GI.Pango.Enums.StyleItalic' as matches, but not as good
-- a match as when the styles are equal.
-- 
-- Note that /@oldMatch@/ must match /@desc@/.
fontDescriptionBetterMatch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Maybe (FontDescription)
    -- ^ /@oldMatch@/: a @PangoFontDescription@, or 'P.Nothing'
    -> FontDescription
    -- ^ /@newMatch@/: a @PangoFontDescription@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@newMatch@/ is a better match
fontDescriptionBetterMatch desc oldMatch newMatch = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    maybeOldMatch <- case oldMatch of
        Nothing -> return FP.nullPtr
        Just jOldMatch -> do
            jOldMatch' <- unsafeManagedPtrGetPtr jOldMatch
            return jOldMatch'
    newMatch' <- unsafeManagedPtrGetPtr newMatch
    result <- pango_font_description_better_match desc' maybeOldMatch newMatch'
    let result' = (/= 0) result
    touchManagedPtr desc
    whenJust oldMatch touchManagedPtr
    touchManagedPtr newMatch
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionBetterMatchMethodInfo
instance (signature ~ (Maybe (FontDescription) -> FontDescription -> m Bool), MonadIO m) => O.OverloadedMethod FontDescriptionBetterMatchMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionBetterMatch

instance O.OverloadedMethodInfo FontDescriptionBetterMatchMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionBetterMatch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionBetterMatch"
        })


#endif

-- method FontDescription::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Pango" , name = "FontDescription" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_copy" pango_font_description_copy :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO (Ptr FontDescription)

-- | Make a copy of a @PangoFontDescription@.
fontDescriptionCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (FontDescription)
    -- ^ /@desc@/: a @PangoFontDescription@, may be 'P.Nothing'
    -> m (Maybe FontDescription)
    -- ^ __Returns:__ the newly allocated @PangoFontDescription@,
    --   which should be freed with 'GI.Pango.Structs.FontDescription.fontDescriptionFree',
    --   or 'P.Nothing' if /@desc@/ was 'P.Nothing'.
fontDescriptionCopy desc = liftIO $ do
    maybeDesc <- case desc of
        Nothing -> return FP.nullPtr
        Just jDesc -> do
            jDesc' <- unsafeManagedPtrGetPtr jDesc
            return jDesc'
    result <- pango_font_description_copy maybeDesc
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed FontDescription) result'
        return result''
    whenJust desc touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDescriptionCopyMethodInfo
instance (signature ~ (m (Maybe FontDescription)), MonadIO m) => O.OverloadedMethod FontDescriptionCopyMethodInfo FontDescription signature where
    overloadedMethod i = fontDescriptionCopy (Just i)

instance O.OverloadedMethodInfo FontDescriptionCopyMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionCopy"
        })


#endif

-- method FontDescription::copy_static
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Pango" , name = "FontDescription" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_copy_static" pango_font_description_copy_static :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO (Ptr FontDescription)

-- | Make a copy of a @PangoFontDescription@, but don\'t duplicate
-- allocated fields.
-- 
-- This is like 'GI.Pango.Structs.FontDescription.fontDescriptionCopy', but only a shallow
-- copy is made of the family name and other allocated fields. The result
-- can only be used until /@desc@/ is modified or freed. This is meant
-- to be used when the copy is only needed temporarily.
fontDescriptionCopyStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (FontDescription)
    -- ^ /@desc@/: a @PangoFontDescription@, may be 'P.Nothing'
    -> m (Maybe FontDescription)
    -- ^ __Returns:__ the newly allocated @PangoFontDescription@,
    --   which should be freed with 'GI.Pango.Structs.FontDescription.fontDescriptionFree',
    --   or 'P.Nothing' if /@desc@/ was 'P.Nothing'.
fontDescriptionCopyStatic desc = liftIO $ do
    maybeDesc <- case desc of
        Nothing -> return FP.nullPtr
        Just jDesc -> do
            jDesc' <- unsafeManagedPtrGetPtr jDesc
            return jDesc'
    result <- pango_font_description_copy_static maybeDesc
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed FontDescription) result'
        return result''
    whenJust desc touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDescriptionCopyStaticMethodInfo
instance (signature ~ (m (Maybe FontDescription)), MonadIO m) => O.OverloadedMethod FontDescriptionCopyStaticMethodInfo FontDescription signature where
    overloadedMethod i = fontDescriptionCopyStatic (Just i)

instance O.OverloadedMethodInfo FontDescriptionCopyStaticMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionCopyStatic",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionCopyStatic"
        })


#endif

-- method FontDescription::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc1"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc2"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_equal" pango_font_description_equal :: 
    Ptr FontDescription ->                  -- desc1 : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr FontDescription ->                  -- desc2 : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CInt

-- | Compares two font descriptions for equality.
-- 
-- Two font descriptions are considered equal if the fonts they describe
-- are provably identical. This means that their masks do not have to match,
-- as long as other fields are all the same. (Two font descriptions may
-- result in identical fonts being loaded, but still compare 'P.False'.)
fontDescriptionEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc1@/: a @PangoFontDescription@
    -> FontDescription
    -- ^ /@desc2@/: another @PangoFontDescription@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two font descriptions are identical,
    --   'P.False' otherwise.
fontDescriptionEqual desc1 desc2 = liftIO $ do
    desc1' <- unsafeManagedPtrGetPtr desc1
    desc2' <- unsafeManagedPtrGetPtr desc2
    result <- pango_font_description_equal desc1' desc2'
    let result' = (/= 0) result
    touchManagedPtr desc1
    touchManagedPtr desc2
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionEqualMethodInfo
instance (signature ~ (FontDescription -> m Bool), MonadIO m) => O.OverloadedMethod FontDescriptionEqualMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionEqual

instance O.OverloadedMethodInfo FontDescriptionEqualMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionEqual"
        })


#endif

-- method FontDescription::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_free" pango_font_description_free :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO ()

-- | Frees a font description.
fontDescriptionFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (FontDescription)
    -- ^ /@desc@/: a @PangoFontDescription@, may be 'P.Nothing'
    -> m ()
fontDescriptionFree desc = liftIO $ do
    maybeDesc <- case desc of
        Nothing -> return FP.nullPtr
        Just jDesc -> do
            jDesc' <- unsafeManagedPtrGetPtr jDesc
            return jDesc'
    pango_font_description_free maybeDesc
    whenJust desc touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod FontDescriptionFreeMethodInfo FontDescription signature where
    overloadedMethod i = fontDescriptionFree (Just i)

instance O.OverloadedMethodInfo FontDescriptionFreeMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionFree"
        })


#endif

-- method FontDescription::get_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "FontColor" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_color" pango_font_description_get_color :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CUInt

-- | Returns the color field of the font description.
-- 
-- This field determines whether the font description should
-- match fonts that have color glyphs, or fonts that don\'t.
-- 
-- /Since: 1.57/
fontDescriptionGetColor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m Pango.Enums.FontColor
fontDescriptionGetColor desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_color desc'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetColorMethodInfo
instance (signature ~ (m Pango.Enums.FontColor), MonadIO m) => O.OverloadedMethod FontDescriptionGetColorMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetColor

instance O.OverloadedMethodInfo FontDescriptionGetColorMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetColor"
        })


#endif

-- method FontDescription::get_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_family" pango_font_description_get_family :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CString

-- | Gets the family name field of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetFamily'.
fontDescriptionGetFamily ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the family name field for the
    --   font description, or 'P.Nothing' if not previously set. This has the same
    --   life-time as the font description itself and should not be freed.
fontDescriptionGetFamily desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_family desc'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr desc
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetFamilyMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod FontDescriptionGetFamilyMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetFamily

instance O.OverloadedMethodInfo FontDescriptionGetFamilyMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetFamily"
        })


#endif

-- method FontDescription::get_features
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_features" pango_font_description_get_features :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CString

-- | Gets the features field of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetFeatures'.
-- 
-- /Since: 1.56/
fontDescriptionGetFeatures ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the features field for the font
    --   description, or 'P.Nothing' if not previously set. This has the same
    --   life-time as the font description itself and should not be freed.
fontDescriptionGetFeatures desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_features desc'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr desc
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetFeaturesMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod FontDescriptionGetFeaturesMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetFeatures

instance O.OverloadedMethodInfo FontDescriptionGetFeaturesMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetFeatures",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetFeatures"
        })


#endif

-- method FontDescription::get_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Gravity" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_gravity" pango_font_description_get_gravity :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CUInt

-- | Gets the gravity field of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetGravity'.
-- 
-- /Since: 1.16/
fontDescriptionGetGravity ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m Pango.Enums.Gravity
    -- ^ __Returns:__ the gravity field for the font description.
    --   Use 'GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields' to find out
    --   if the field was explicitly set or not.
fontDescriptionGetGravity desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_gravity desc'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetGravityMethodInfo
instance (signature ~ (m Pango.Enums.Gravity), MonadIO m) => O.OverloadedMethod FontDescriptionGetGravityMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetGravity

instance O.OverloadedMethodInfo FontDescriptionGetGravityMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetGravity"
        })


#endif

-- method FontDescription::get_set_fields
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "FontMask" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_set_fields" pango_font_description_get_set_fields :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CUInt

-- | Determines which fields in a font description have been set.
fontDescriptionGetSetFields ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m [Pango.Flags.FontMask]
    -- ^ __Returns:__ a bitmask with bits set corresponding to the
    --   fields in /@desc@/ that have been set.
fontDescriptionGetSetFields desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_set_fields desc'
    let result' = wordToGFlags result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetSetFieldsMethodInfo
instance (signature ~ (m [Pango.Flags.FontMask]), MonadIO m) => O.OverloadedMethod FontDescriptionGetSetFieldsMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetSetFields

instance O.OverloadedMethodInfo FontDescriptionGetSetFieldsMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetSetFields"
        })


#endif

-- method FontDescription::get_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_size" pango_font_description_get_size :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO Int32

-- | Gets the size field of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetSize'.
fontDescriptionGetSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m Int32
    -- ^ __Returns:__ the size field for the font description in points
    --   or device units. You must call
    --   'GI.Pango.Structs.FontDescription.fontDescriptionGetSizeIsAbsolute' to find out
    --   which is the case. Returns 0 if the size field has not previously
    --   been set or it has been set to 0 explicitly.
    --   Use 'GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields' to find out
    --   if the field was explicitly set or not.
fontDescriptionGetSize desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_size desc'
    touchManagedPtr desc
    return result

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetSizeMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod FontDescriptionGetSizeMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetSize

instance O.OverloadedMethodInfo FontDescriptionGetSizeMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetSize"
        })


#endif

-- method FontDescription::get_size_is_absolute
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_size_is_absolute" pango_font_description_get_size_is_absolute :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CInt

-- | Determines whether the size of the font is in points (not absolute)
-- or device units (absolute).
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetSize'
-- and 'GI.Pango.Structs.FontDescription.fontDescriptionSetAbsoluteSize'.
-- 
-- /Since: 1.8/
fontDescriptionGetSizeIsAbsolute ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m Bool
    -- ^ __Returns:__ whether the size for the font description is in
    --   points or device units. Use 'GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields'
    --   to find out if the size field of the font description was explicitly
    --   set or not.
fontDescriptionGetSizeIsAbsolute desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_size_is_absolute desc'
    let result' = (/= 0) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetSizeIsAbsoluteMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod FontDescriptionGetSizeIsAbsoluteMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetSizeIsAbsolute

instance O.OverloadedMethodInfo FontDescriptionGetSizeIsAbsoluteMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetSizeIsAbsolute",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetSizeIsAbsolute"
        })


#endif

-- method FontDescription::get_stretch
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Stretch" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_stretch" pango_font_description_get_stretch :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CUInt

-- | Gets the stretch field of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetStretch'.
fontDescriptionGetStretch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@.
    -> m Pango.Enums.Stretch
    -- ^ __Returns:__ the stretch field for the font description.
    --   Use 'GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields' to find
    --   out if the field was explicitly set or not.
fontDescriptionGetStretch desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_stretch desc'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetStretchMethodInfo
instance (signature ~ (m Pango.Enums.Stretch), MonadIO m) => O.OverloadedMethod FontDescriptionGetStretchMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetStretch

instance O.OverloadedMethodInfo FontDescriptionGetStretchMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetStretch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetStretch"
        })


#endif

-- method FontDescription::get_style
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Style" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_style" pango_font_description_get_style :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CUInt

-- | Gets the style field of a @PangoFontDescription@.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetStyle'.
fontDescriptionGetStyle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m Pango.Enums.Style
    -- ^ __Returns:__ the style field for the font description.
    --   Use 'GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields' to
    --   find out if the field was explicitly set or not.
fontDescriptionGetStyle desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_style desc'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetStyleMethodInfo
instance (signature ~ (m Pango.Enums.Style), MonadIO m) => O.OverloadedMethod FontDescriptionGetStyleMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetStyle

instance O.OverloadedMethodInfo FontDescriptionGetStyleMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetStyle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetStyle"
        })


#endif

-- method FontDescription::get_variant
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Variant" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_variant" pango_font_description_get_variant :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CUInt

-- | Gets the variant field of a @PangoFontDescription@.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetVariant'.
fontDescriptionGetVariant ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@.
    -> m Pango.Enums.Variant
    -- ^ __Returns:__ the variant field for the font description.
    --   Use 'GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields' to find
    --   out if the field was explicitly set or not.
fontDescriptionGetVariant desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_variant desc'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetVariantMethodInfo
instance (signature ~ (m Pango.Enums.Variant), MonadIO m) => O.OverloadedMethod FontDescriptionGetVariantMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetVariant

instance O.OverloadedMethodInfo FontDescriptionGetVariantMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetVariant",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetVariant"
        })


#endif

-- method FontDescription::get_variations
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_variations" pango_font_description_get_variations :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CString

-- | Gets the variations field of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetVariations'.
-- 
-- /Since: 1.42/
fontDescriptionGetVariations ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the variations field for the font
    --   description, or 'P.Nothing' if not previously set. This has the same
    --   life-time as the font description itself and should not be freed.
fontDescriptionGetVariations desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_variations desc'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr desc
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetVariationsMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod FontDescriptionGetVariationsMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetVariations

instance O.OverloadedMethodInfo FontDescriptionGetVariationsMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetVariations",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetVariations"
        })


#endif

-- method FontDescription::get_weight
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Weight" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_get_weight" pango_font_description_get_weight :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CUInt

-- | Gets the weight field of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionSetWeight'.
fontDescriptionGetWeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m Pango.Enums.Weight
    -- ^ __Returns:__ the weight field for the font description.
    --   Use 'GI.Pango.Structs.FontDescription.fontDescriptionGetSetFields' to find
    --   out if the field was explicitly set or not.
fontDescriptionGetWeight desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_get_weight desc'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionGetWeightMethodInfo
instance (signature ~ (m Pango.Enums.Weight), MonadIO m) => O.OverloadedMethod FontDescriptionGetWeightMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionGetWeight

instance O.OverloadedMethodInfo FontDescriptionGetWeightMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionGetWeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionGetWeight"
        })


#endif

-- method FontDescription::hash
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_hash" pango_font_description_hash :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO Word32

-- | Computes a hash of a @PangoFontDescription@ structure.
-- 
-- This is suitable to be used, for example, as an argument
-- to @/g_hash_table_new()/@. The hash value is independent of /@desc@/->mask.
fontDescriptionHash ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m Word32
    -- ^ __Returns:__ the hash value.
fontDescriptionHash desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_hash desc'
    touchManagedPtr desc
    return result

#if defined(ENABLE_OVERLOADING)
data FontDescriptionHashMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod FontDescriptionHashMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionHash

instance O.OverloadedMethodInfo FontDescriptionHashMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionHash",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionHash"
        })


#endif

-- method FontDescription::merge
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc_to_merge"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `PangoFontDescription` to merge from,\n  or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "replace_existing"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %TRUE, replace fields in @desc with the\n  corresponding values from @desc_to_merge, even if they\n  are already exist."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_merge" pango_font_description_merge :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr FontDescription ->                  -- desc_to_merge : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CInt ->                                 -- replace_existing : TBasicType TBoolean
    IO ()

-- | Merges the fields that are set in /@descToMerge@/ into the fields in
-- /@desc@/.
-- 
-- If /@replaceExisting@/ is 'P.False', only fields in /@desc@/ that
-- are not already set are affected. If 'P.True', then fields that are
-- already set will be replaced as well.
-- 
-- If /@descToMerge@/ is 'P.Nothing', this function performs nothing.
fontDescriptionMerge ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Maybe (FontDescription)
    -- ^ /@descToMerge@/: the @PangoFontDescription@ to merge from,
    --   or 'P.Nothing'
    -> Bool
    -- ^ /@replaceExisting@/: if 'P.True', replace fields in /@desc@/ with the
    --   corresponding values from /@descToMerge@/, even if they
    --   are already exist.
    -> m ()
fontDescriptionMerge desc descToMerge replaceExisting = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    maybeDescToMerge <- case descToMerge of
        Nothing -> return FP.nullPtr
        Just jDescToMerge -> do
            jDescToMerge' <- unsafeManagedPtrGetPtr jDescToMerge
            return jDescToMerge'
    let replaceExisting' = (P.fromIntegral . P.fromEnum) replaceExisting
    pango_font_description_merge desc' maybeDescToMerge replaceExisting'
    touchManagedPtr desc
    whenJust descToMerge touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionMergeMethodInfo
instance (signature ~ (Maybe (FontDescription) -> Bool -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionMergeMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionMerge

instance O.OverloadedMethodInfo FontDescriptionMergeMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionMerge",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionMerge"
        })


#endif

-- method FontDescription::merge_static
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc_to_merge"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `PangoFontDescription` to merge from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "replace_existing"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %TRUE, replace fields in @desc with the\n  corresponding values from @desc_to_merge, even if they\n  are already exist."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_merge_static" pango_font_description_merge_static :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr FontDescription ->                  -- desc_to_merge : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CInt ->                                 -- replace_existing : TBasicType TBoolean
    IO ()

-- | Merges the fields that are set in /@descToMerge@/ into the fields in
-- /@desc@/, without copying allocated fields.
-- 
-- This is like 'GI.Pango.Structs.FontDescription.fontDescriptionMerge', but only a shallow copy
-- is made of the family name and other allocated fields. /@desc@/ can only
-- be used until /@descToMerge@/ is modified or freed. This is meant to
-- be used when the merged font description is only needed temporarily.
fontDescriptionMergeStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> FontDescription
    -- ^ /@descToMerge@/: the @PangoFontDescription@ to merge from
    -> Bool
    -- ^ /@replaceExisting@/: if 'P.True', replace fields in /@desc@/ with the
    --   corresponding values from /@descToMerge@/, even if they
    --   are already exist.
    -> m ()
fontDescriptionMergeStatic desc descToMerge replaceExisting = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    descToMerge' <- unsafeManagedPtrGetPtr descToMerge
    let replaceExisting' = (P.fromIntegral . P.fromEnum) replaceExisting
    pango_font_description_merge_static desc' descToMerge' replaceExisting'
    touchManagedPtr desc
    touchManagedPtr descToMerge
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionMergeStaticMethodInfo
instance (signature ~ (FontDescription -> Bool -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionMergeStaticMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionMergeStatic

instance O.OverloadedMethodInfo FontDescriptionMergeStaticMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionMergeStatic",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionMergeStatic"
        })


#endif

-- method FontDescription::set_absolute_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new size, in Pango units. There are %PANGO_SCALE Pango units\n  in one device unit. For an output backend where a device unit is a pixel,\n  a @size value of 10 * PANGO_SCALE gives a 10 pixel font."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_absolute_size" pango_font_description_set_absolute_size :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CDouble ->                              -- size : TBasicType TDouble
    IO ()

-- | Sets the size field of a font description, in device units.
-- 
-- This is mutually exclusive with 'GI.Pango.Structs.FontDescription.fontDescriptionSetSize'
-- which sets the font size in points.
-- 
-- /Since: 1.8/
fontDescriptionSetAbsoluteSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Double
    -- ^ /@size@/: the new size, in Pango units. There are 'GI.Pango.Constants.SCALE' Pango units
    --   in one device unit. For an output backend where a device unit is a pixel,
    --   a /@size@/ value of 10 * PANGO_SCALE gives a 10 pixel font.
    -> m ()
fontDescriptionSetAbsoluteSize desc size = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let size' = realToFrac size
    pango_font_description_set_absolute_size desc' size'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetAbsoluteSizeMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetAbsoluteSizeMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetAbsoluteSize

instance O.OverloadedMethodInfo FontDescriptionSetAbsoluteSizeMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetAbsoluteSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetAbsoluteSize"
        })


#endif

-- method FontDescription::set_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `PangoFontColor` value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_color" pango_font_description_set_color :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CUInt ->                                -- color : TInterface (Name {namespace = "Pango", name = "FontColor"})
    IO ()

-- | Sets the color field of a font description.
-- 
-- This field determines whether the font description should
-- match fonts that have color glyphs, or fonts that don\'t.
-- 
-- /Since: 1.57/
fontDescriptionSetColor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@.
    -> Pango.Enums.FontColor
    -- ^ /@color@/: the @PangoFontColor@ value
    -> m ()
fontDescriptionSetColor desc color = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let color' = (fromIntegral . fromEnum) color
    pango_font_description_set_color desc' color'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetColorMethodInfo
instance (signature ~ (Pango.Enums.FontColor -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetColorMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetColor

instance O.OverloadedMethodInfo FontDescriptionSetColorMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetColor"
        })


#endif

-- method FontDescription::set_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "family"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representing the family name."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_family" pango_font_description_set_family :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CString ->                              -- family : TBasicType TUTF8
    IO ()

-- | Sets the family name field of a font description.
-- 
-- The family
-- name represents a family of related font styles, and will
-- resolve to a particular @PangoFontFamily@. In some uses of
-- @PangoFontDescription@, it is also possible to use a comma
-- separated list of family names for this field.
fontDescriptionSetFamily ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@.
    -> T.Text
    -- ^ /@family@/: a string representing the family name.
    -> m ()
fontDescriptionSetFamily desc family = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    family' <- textToCString family
    pango_font_description_set_family desc' family'
    touchManagedPtr desc
    freeMem family'
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetFamilyMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetFamily

instance O.OverloadedMethodInfo FontDescriptionSetFamilyMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetFamily"
        })


#endif

-- method FontDescription::set_family_static
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "family"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representing the family name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_family_static" pango_font_description_set_family_static :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CString ->                              -- family : TBasicType TUTF8
    IO ()

-- | Sets the family name field of a font description, without copying the string.
-- 
-- This is like 'GI.Pango.Structs.FontDescription.fontDescriptionSetFamily', except that no
-- copy of /@family@/ is made. The caller must make sure that the
-- string passed in stays around until /@desc@/ has been freed or the
-- name is set again. This function can be used if /@family@/ is a static
-- string such as a C string literal, or if /@desc@/ is only needed temporarily.
fontDescriptionSetFamilyStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> T.Text
    -- ^ /@family@/: a string representing the family name
    -> m ()
fontDescriptionSetFamilyStatic desc family = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    family' <- textToCString family
    pango_font_description_set_family_static desc' family'
    touchManagedPtr desc
    freeMem family'
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetFamilyStaticMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetFamilyStaticMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetFamilyStatic

instance O.OverloadedMethodInfo FontDescriptionSetFamilyStaticMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetFamilyStatic",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetFamilyStatic"
        })


#endif

-- method FontDescription::set_features
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "features"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representing the features"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_features" pango_font_description_set_features :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CString ->                              -- features : TBasicType TUTF8
    IO ()

-- | Sets the features field of a font description.
-- 
-- OpenType font features allow to enable or disable certain optional
-- features of a font, such as tabular numbers.
-- 
-- The format of the features string is comma-separated list of
-- feature assignments, with each assignment being one of these forms:
-- 
--     FEATURE=n
-- 
-- where FEATURE must be a 4 character tag that identifies and OpenType
-- feature, and n an integer (depending on the feature, the allowed
-- values may be 0, 1 or bigger numbers). Unknown features are ignored.
-- 
-- Note that font features set in this way are enabled for the entire text
-- that is using the font, which is not appropriate for all OpenType features.
-- The intended use case is to select character variations (features cv01 - c99),
-- style sets (ss01 - ss20) and the like.
-- 
-- Pango does not currently have a way to find supported OpenType features
-- of a font. Both harfbuzz and freetype have API for this. See for example
-- <https://harfbuzz.github.io/harfbuzz-hb-ot-layout.html#hb-ot-layout-table-get-feature-tags hb_ot_layout_table_get_feature_tags>.
-- 
-- Features that are not supported by the font are silently ignored.
-- 
-- /Since: 1.56/
fontDescriptionSetFeatures ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@.
    -> Maybe (T.Text)
    -- ^ /@features@/: a string representing the features
    -> m ()
fontDescriptionSetFeatures desc features = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    maybeFeatures <- case features of
        Nothing -> return FP.nullPtr
        Just jFeatures -> do
            jFeatures' <- textToCString jFeatures
            return jFeatures'
    pango_font_description_set_features desc' maybeFeatures
    touchManagedPtr desc
    freeMem maybeFeatures
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetFeaturesMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetFeaturesMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetFeatures

instance O.OverloadedMethodInfo FontDescriptionSetFeaturesMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetFeatures",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetFeatures"
        })


#endif

-- method FontDescription::set_features_static
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "features"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representing the features"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_features_static" pango_font_description_set_features_static :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CString ->                              -- features : TBasicType TUTF8
    IO ()

-- | Sets the features field of a font description.
-- 
-- This is like 'GI.Pango.Structs.FontDescription.fontDescriptionSetFeatures', except
-- that no copy of /@featuresis@/ made. The caller must make sure that
-- the string passed in stays around until /@desc@/ has been freed
-- or the name is set again. This function can be used if
-- /@features@/ is a static string such as a C string literal,
-- or if /@desc@/ is only needed temporarily.
-- 
-- /Since: 1.56/
fontDescriptionSetFeaturesStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> T.Text
    -- ^ /@features@/: a string representing the features
    -> m ()
fontDescriptionSetFeaturesStatic desc features = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    features' <- textToCString features
    pango_font_description_set_features_static desc' features'
    touchManagedPtr desc
    freeMem features'
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetFeaturesStaticMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetFeaturesStaticMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetFeaturesStatic

instance O.OverloadedMethodInfo FontDescriptionSetFeaturesStaticMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetFeaturesStatic",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetFeaturesStatic"
        })


#endif

-- method FontDescription::set_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gravity"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Gravity" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the gravity for the font description."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_gravity" pango_font_description_set_gravity :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CUInt ->                                -- gravity : TInterface (Name {namespace = "Pango", name = "Gravity"})
    IO ()

-- | Sets the gravity field of a font description.
-- 
-- The gravity field
-- specifies how the glyphs should be rotated. If /@gravity@/ is
-- 'GI.Pango.Enums.GravityAuto', this actually unsets the gravity mask on
-- the font description.
-- 
-- This function is seldom useful to the user. Gravity should normally
-- be set on a @PangoContext@.
-- 
-- /Since: 1.16/
fontDescriptionSetGravity ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Pango.Enums.Gravity
    -- ^ /@gravity@/: the gravity for the font description.
    -> m ()
fontDescriptionSetGravity desc gravity = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let gravity' = (fromIntegral . fromEnum) gravity
    pango_font_description_set_gravity desc' gravity'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetGravityMethodInfo
instance (signature ~ (Pango.Enums.Gravity -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetGravityMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetGravity

instance O.OverloadedMethodInfo FontDescriptionSetGravityMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetGravity"
        })


#endif

-- method FontDescription::set_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the size of the font in points, scaled by %PANGO_SCALE.\n  (That is, a @size value of 10 * PANGO_SCALE is a 10 point font.\n  The conversion factor between points and device units depends on\n  system configuration and the output device. For screen display, a\n  logical DPI of 96 is common, in which case a 10 point font corresponds\n  to a 10 * (96 / 72) = 13.3 pixel font.\n  Use [method@Pango.FontDescription.set_absolute_size] if you need\n  a particular size in device units."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_size" pango_font_description_set_size :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Int32 ->                                -- size : TBasicType TInt
    IO ()

-- | Sets the size field of a font description in fractional points.
-- 
-- This is mutually exclusive with
-- 'GI.Pango.Structs.FontDescription.fontDescriptionSetAbsoluteSize'.
fontDescriptionSetSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Int32
    -- ^ /@size@/: the size of the font in points, scaled by 'GI.Pango.Constants.SCALE'.
    --   (That is, a /@size@/ value of 10 * PANGO_SCALE is a 10 point font.
    --   The conversion factor between points and device units depends on
    --   system configuration and the output device. For screen display, a
    --   logical DPI of 96 is common, in which case a 10 point font corresponds
    --   to a 10 * (96 \/ 72) = 13.3 pixel font.
    --   Use 'GI.Pango.Structs.FontDescription.fontDescriptionSetAbsoluteSize' if you need
    --   a particular size in device units.
    -> m ()
fontDescriptionSetSize desc size = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    pango_font_description_set_size desc' size
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetSizeMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetSizeMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetSize

instance O.OverloadedMethodInfo FontDescriptionSetSizeMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetSize"
        })


#endif

-- method FontDescription::set_stretch
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stretch"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Stretch" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the stretch for the font description"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_stretch" pango_font_description_set_stretch :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CUInt ->                                -- stretch : TInterface (Name {namespace = "Pango", name = "Stretch"})
    IO ()

-- | Sets the stretch field of a font description.
-- 
-- The t'GI.Pango.Enums.Stretch' field specifies how narrow or
-- wide the font should be.
fontDescriptionSetStretch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Pango.Enums.Stretch
    -- ^ /@stretch@/: the stretch for the font description
    -> m ()
fontDescriptionSetStretch desc stretch = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let stretch' = (fromIntegral . fromEnum) stretch
    pango_font_description_set_stretch desc' stretch'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetStretchMethodInfo
instance (signature ~ (Pango.Enums.Stretch -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetStretchMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetStretch

instance O.OverloadedMethodInfo FontDescriptionSetStretchMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetStretch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetStretch"
        })


#endif

-- method FontDescription::set_style
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "style"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Style" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the style for the font description"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_style" pango_font_description_set_style :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CUInt ->                                -- style : TInterface (Name {namespace = "Pango", name = "Style"})
    IO ()

-- | Sets the style field of a @PangoFontDescription@.
-- 
-- The t'GI.Pango.Enums.Style' enumeration describes whether the font is
-- slanted and the manner in which it is slanted; it can be either
-- 'GI.Pango.Enums.StyleNormal', 'GI.Pango.Enums.StyleItalic', or 'GI.Pango.Enums.StyleOblique'.
-- 
-- Most fonts will either have a italic style or an oblique style,
-- but not both, and font matching in Pango will match italic
-- specifications with oblique fonts and vice-versa if an exact
-- match is not found.
fontDescriptionSetStyle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Pango.Enums.Style
    -- ^ /@style@/: the style for the font description
    -> m ()
fontDescriptionSetStyle desc style = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let style' = (fromIntegral . fromEnum) style
    pango_font_description_set_style desc' style'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetStyleMethodInfo
instance (signature ~ (Pango.Enums.Style -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetStyleMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetStyle

instance O.OverloadedMethodInfo FontDescriptionSetStyleMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetStyle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetStyle"
        })


#endif

-- method FontDescription::set_variant
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variant"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Variant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the variant type for the font description."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_variant" pango_font_description_set_variant :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CUInt ->                                -- variant : TInterface (Name {namespace = "Pango", name = "Variant"})
    IO ()

-- | Sets the variant field of a font description.
-- 
-- The t'GI.Pango.Enums.Variant' can either be 'GI.Pango.Enums.VariantNormal'
-- or 'GI.Pango.Enums.VariantSmallCaps'.
fontDescriptionSetVariant ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Pango.Enums.Variant
    -- ^ /@variant@/: the variant type for the font description.
    -> m ()
fontDescriptionSetVariant desc variant = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let variant' = (fromIntegral . fromEnum) variant
    pango_font_description_set_variant desc' variant'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetVariantMethodInfo
instance (signature ~ (Pango.Enums.Variant -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetVariantMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetVariant

instance O.OverloadedMethodInfo FontDescriptionSetVariantMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetVariant",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetVariant"
        })


#endif

-- method FontDescription::set_variations
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variations"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representing the variations"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_variations" pango_font_description_set_variations :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CString ->                              -- variations : TBasicType TUTF8
    IO ()

-- | Sets the variations field of a font description.
-- 
-- OpenType font variations allow to select a font instance by
-- specifying values for a number of axes, such as width or weight.
-- 
-- The format of the variations string is
-- 
--     AXIS1=VALUE,AXIS2=VALUE...
-- 
-- with each AXIS a 4 character tag that identifies a font axis,
-- and each VALUE a floating point number. Unknown axes are ignored,
-- and values are clamped to their allowed range.
-- 
-- Pango does not currently have a way to find supported axes of
-- a font. Both harfbuzz and freetype have API for this. See
-- for example <https://harfbuzz.github.io/harfbuzz-hb-ot-var.html#hb-ot-var-get-axis-infos hb_ot_var_get_axis_infos>.
-- 
-- /Since: 1.42/
fontDescriptionSetVariations ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@.
    -> Maybe (T.Text)
    -- ^ /@variations@/: a string representing the variations
    -> m ()
fontDescriptionSetVariations desc variations = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    maybeVariations <- case variations of
        Nothing -> return FP.nullPtr
        Just jVariations -> do
            jVariations' <- textToCString jVariations
            return jVariations'
    pango_font_description_set_variations desc' maybeVariations
    touchManagedPtr desc
    freeMem maybeVariations
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetVariationsMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetVariationsMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetVariations

instance O.OverloadedMethodInfo FontDescriptionSetVariationsMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetVariations",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetVariations"
        })


#endif

-- method FontDescription::set_variations_static
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variations"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representing the variations"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_variations_static" pango_font_description_set_variations_static :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CString ->                              -- variations : TBasicType TUTF8
    IO ()

-- | Sets the variations field of a font description.
-- 
-- This is like 'GI.Pango.Structs.FontDescription.fontDescriptionSetVariations', except
-- that no copy of /@variations@/ is made. The caller must make sure that
-- the string passed in stays around until /@desc@/ has been freed
-- or the name is set again. This function can be used if
-- /@variations@/ is a static string such as a C string literal,
-- or if /@desc@/ is only needed temporarily.
-- 
-- /Since: 1.42/
fontDescriptionSetVariationsStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> T.Text
    -- ^ /@variations@/: a string representing the variations
    -> m ()
fontDescriptionSetVariationsStatic desc variations = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    variations' <- textToCString variations
    pango_font_description_set_variations_static desc' variations'
    touchManagedPtr desc
    freeMem variations'
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetVariationsStaticMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetVariationsStaticMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetVariationsStatic

instance O.OverloadedMethodInfo FontDescriptionSetVariationsStaticMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetVariationsStatic",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetVariationsStatic"
        })


#endif

-- method FontDescription::set_weight
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "weight"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Weight" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the weight for the font description."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_set_weight" pango_font_description_set_weight :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CUInt ->                                -- weight : TInterface (Name {namespace = "Pango", name = "Weight"})
    IO ()

-- | Sets the weight field of a font description.
-- 
-- The weight field
-- specifies how bold or light the font should be. In addition
-- to the values of the t'GI.Pango.Enums.Weight' enumeration, other
-- intermediate numeric values are possible.
fontDescriptionSetWeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> Pango.Enums.Weight
    -- ^ /@weight@/: the weight for the font description.
    -> m ()
fontDescriptionSetWeight desc weight = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let weight' = (fromIntegral . fromEnum) weight
    pango_font_description_set_weight desc' weight'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionSetWeightMethodInfo
instance (signature ~ (Pango.Enums.Weight -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionSetWeightMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionSetWeight

instance O.OverloadedMethodInfo FontDescriptionSetWeightMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionSetWeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionSetWeight"
        })


#endif

-- method FontDescription::to_filename
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_to_filename" pango_font_description_to_filename :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CString

-- | Creates a filename representation of a font description.
-- 
-- The filename is identical to the result from calling
-- 'GI.Pango.Structs.FontDescription.fontDescriptionToString', but with underscores
-- instead of characters that are untypical in filenames, and in
-- lower case only.
fontDescriptionToFilename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a new string that must be freed with 'GI.GLib.Functions.free'.
fontDescriptionToFilename desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_to_filename desc'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr desc
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDescriptionToFilenameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod FontDescriptionToFilenameMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionToFilename

instance O.OverloadedMethodInfo FontDescriptionToFilenameMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionToFilename",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionToFilename"
        })


#endif

-- method FontDescription::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_to_string" pango_font_description_to_string :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO CString

-- | Creates a string representation of a font description.
-- 
-- See 'GI.Pango.Structs.FontDescription.fontDescriptionFromString' for a description
-- of the format of the string representation. The family list in
-- the string description will only have a terminating comma if
-- the last word of the list is a valid style option.
fontDescriptionToString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> m T.Text
    -- ^ __Returns:__ a new string that must be freed with 'GI.GLib.Functions.free'.
fontDescriptionToString desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_description_to_string desc'
    checkUnexpectedReturnNULL "fontDescriptionToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDescriptionToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod FontDescriptionToStringMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionToString

instance O.OverloadedMethodInfo FontDescriptionToStringMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionToString"
        })


#endif

-- method FontDescription::unset_fields
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontDescription`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_unset"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bitmask of fields in the @desc to unset."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_unset_fields" pango_font_description_unset_fields :: 
    Ptr FontDescription ->                  -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    CUInt ->                                -- to_unset : TInterface (Name {namespace = "Pango", name = "FontMask"})
    IO ()

-- | Unsets some of the fields in a @PangoFontDescription@.
-- 
-- The unset fields will get back to their default values.
fontDescriptionUnsetFields ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@
    -> [Pango.Flags.FontMask]
    -- ^ /@toUnset@/: bitmask of fields in the /@desc@/ to unset.
    -> m ()
fontDescriptionUnsetFields desc toUnset = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    let toUnset' = gflagsToWord toUnset
    pango_font_description_unset_fields desc' toUnset'
    touchManagedPtr desc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDescriptionUnsetFieldsMethodInfo
instance (signature ~ ([Pango.Flags.FontMask] -> m ()), MonadIO m) => O.OverloadedMethod FontDescriptionUnsetFieldsMethodInfo FontDescription signature where
    overloadedMethod = fontDescriptionUnsetFields

instance O.OverloadedMethodInfo FontDescriptionUnsetFieldsMethodInfo FontDescription where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.FontDescription.fontDescriptionUnsetFields",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-FontDescription.html#v:fontDescriptionUnsetFields"
        })


#endif

-- method FontDescription::from_string
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string representation of a font description."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Pango" , name = "FontDescription" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_description_from_string" pango_font_description_from_string :: 
    CString ->                              -- str : TBasicType TUTF8
    IO (Ptr FontDescription)

-- | Creates a new font description from a string representation.
-- 
-- The string must have the form
-- 
--     [FAMILY-LIST] [STYLE-OPTIONS] [SIZE] [VARIATIONS] [FEATURES]
-- 
-- where FAMILY-LIST is a comma-separated list of families optionally
-- terminated by a comma, STYLE_OPTIONS is a whitespace-separated list
-- of words where each word describes one of style, variant, weight,
-- stretch, or gravity, and SIZE is a decimal number (size in points)
-- or optionally followed by the unit modifier \"px\" for absolute size.
-- 
-- The following words are understood as styles:
-- \"Normal\", \"Roman\", \"Oblique\", \"Italic\".
-- 
-- The following words are understood as variants:
-- \"Small-Caps\", \"All-Small-Caps\", \"Petite-Caps\", \"All-Petite-Caps\",
-- \"Unicase\", \"Title-Caps\".
-- 
-- The following words are understood as weights:
-- \"Thin\", \"Ultra-Light\", \"Extra-Light\", \"Light\", \"Semi-Light\",
-- \"Demi-Light\", \"Book\", \"Regular\", \"Medium\", \"Semi-Bold\", \"Demi-Bold\",
-- \"Bold\", \"Ultra-Bold\", \"Extra-Bold\", \"Heavy\", \"Black\", \"Ultra-Black\",
-- \"Extra-Black\".
-- 
-- The following words are understood as stretch values:
-- \"Ultra-Condensed\", \"Extra-Condensed\", \"Condensed\", \"Semi-Condensed\",
-- \"Semi-Expanded\", \"Expanded\", \"Extra-Expanded\", \"Ultra-Expanded\".
-- 
-- The following words are understood as gravity values:
-- \"Not-Rotated\", \"South\", \"Upside-Down\", \"North\", \"Rotated-Left\",
-- \"East\", \"Rotated-Right\", \"West\".
-- 
-- The following words are understood as color values:
-- \"With-Color\", \"Without-Color\".
-- 
-- VARIATIONS is a comma-separated list of font variations
-- of the form \@‍axis1=value,axis2=value,...
-- 
-- FEATURES is a comma-separated list of font features of the form
-- #‍feature1=value,feature2=value,...
-- The =value part can be ommitted if the value is 1.
-- 
-- Any one of the options may be absent. If FAMILY-LIST is absent, then
-- the family_name field of the resulting font description will be
-- initialized to 'P.Nothing'. If STYLE-OPTIONS is missing, then all style
-- options will be set to the default values. If SIZE is missing, the
-- size in the resulting font description will be set to 0.
-- 
-- A typical example:
-- 
--     Cantarell Italic Light 15 \@‍wght=200 #‍tnum=1
fontDescriptionFromString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: string representation of a font description.
    -> m FontDescription
    -- ^ __Returns:__ a new @PangoFontDescription@.
fontDescriptionFromString str = liftIO $ do
    str' <- textToCString str
    result <- pango_font_description_from_string str'
    checkUnexpectedReturnNULL "fontDescriptionFromString" result
    result' <- (wrapBoxed FontDescription) result
    freeMem str'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFontDescriptionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontDescriptionMethod "betterMatch" o = FontDescriptionBetterMatchMethodInfo
    ResolveFontDescriptionMethod "copy" o = FontDescriptionCopyMethodInfo
    ResolveFontDescriptionMethod "copyStatic" o = FontDescriptionCopyStaticMethodInfo
    ResolveFontDescriptionMethod "equal" o = FontDescriptionEqualMethodInfo
    ResolveFontDescriptionMethod "free" o = FontDescriptionFreeMethodInfo
    ResolveFontDescriptionMethod "hash" o = FontDescriptionHashMethodInfo
    ResolveFontDescriptionMethod "merge" o = FontDescriptionMergeMethodInfo
    ResolveFontDescriptionMethod "mergeStatic" o = FontDescriptionMergeStaticMethodInfo
    ResolveFontDescriptionMethod "toFilename" o = FontDescriptionToFilenameMethodInfo
    ResolveFontDescriptionMethod "toString" o = FontDescriptionToStringMethodInfo
    ResolveFontDescriptionMethod "unsetFields" o = FontDescriptionUnsetFieldsMethodInfo
    ResolveFontDescriptionMethod "getColor" o = FontDescriptionGetColorMethodInfo
    ResolveFontDescriptionMethod "getFamily" o = FontDescriptionGetFamilyMethodInfo
    ResolveFontDescriptionMethod "getFeatures" o = FontDescriptionGetFeaturesMethodInfo
    ResolveFontDescriptionMethod "getGravity" o = FontDescriptionGetGravityMethodInfo
    ResolveFontDescriptionMethod "getSetFields" o = FontDescriptionGetSetFieldsMethodInfo
    ResolveFontDescriptionMethod "getSize" o = FontDescriptionGetSizeMethodInfo
    ResolveFontDescriptionMethod "getSizeIsAbsolute" o = FontDescriptionGetSizeIsAbsoluteMethodInfo
    ResolveFontDescriptionMethod "getStretch" o = FontDescriptionGetStretchMethodInfo
    ResolveFontDescriptionMethod "getStyle" o = FontDescriptionGetStyleMethodInfo
    ResolveFontDescriptionMethod "getVariant" o = FontDescriptionGetVariantMethodInfo
    ResolveFontDescriptionMethod "getVariations" o = FontDescriptionGetVariationsMethodInfo
    ResolveFontDescriptionMethod "getWeight" o = FontDescriptionGetWeightMethodInfo
    ResolveFontDescriptionMethod "setAbsoluteSize" o = FontDescriptionSetAbsoluteSizeMethodInfo
    ResolveFontDescriptionMethod "setColor" o = FontDescriptionSetColorMethodInfo
    ResolveFontDescriptionMethod "setFamily" o = FontDescriptionSetFamilyMethodInfo
    ResolveFontDescriptionMethod "setFamilyStatic" o = FontDescriptionSetFamilyStaticMethodInfo
    ResolveFontDescriptionMethod "setFeatures" o = FontDescriptionSetFeaturesMethodInfo
    ResolveFontDescriptionMethod "setFeaturesStatic" o = FontDescriptionSetFeaturesStaticMethodInfo
    ResolveFontDescriptionMethod "setGravity" o = FontDescriptionSetGravityMethodInfo
    ResolveFontDescriptionMethod "setSize" o = FontDescriptionSetSizeMethodInfo
    ResolveFontDescriptionMethod "setStretch" o = FontDescriptionSetStretchMethodInfo
    ResolveFontDescriptionMethod "setStyle" o = FontDescriptionSetStyleMethodInfo
    ResolveFontDescriptionMethod "setVariant" o = FontDescriptionSetVariantMethodInfo
    ResolveFontDescriptionMethod "setVariations" o = FontDescriptionSetVariationsMethodInfo
    ResolveFontDescriptionMethod "setVariationsStatic" o = FontDescriptionSetVariationsStaticMethodInfo
    ResolveFontDescriptionMethod "setWeight" o = FontDescriptionSetWeightMethodInfo
    ResolveFontDescriptionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontDescriptionMethod t FontDescription, O.OverloadedMethod info FontDescription p) => OL.IsLabel t (FontDescription -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontDescriptionMethod t FontDescription, O.OverloadedMethod info FontDescription p, R.HasField t FontDescription p) => R.HasField t FontDescription p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontDescriptionMethod t FontDescription, O.OverloadedMethodInfo info FontDescription) => OL.IsLabel t (O.MethodProxy info FontDescription) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


