#define _CFFI_USE_EMBEDDING
#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

#define _CFFI_MODULE_NAME  "_hexchat_embedded"
static const char _CFFI_PYTHON_STARTUP_CODE[] = {
// # NB. this is not a string because of a size limit in MSVC
// 'from __future__ import print_function\n
102,114,111,109,32,95,95,102,117,116,117,114,101,95,95,32,105,109,112,111,114,
116,32,112,114,105,110,116,95,102,117,110,99,116,105,111,110,10,
// '\n
10,
// 'import importlib\n
105,109,112,111,114,116,32,105,109,112,111,114,116,108,105,98,10,
// 'import os\n
105,109,112,111,114,116,32,111,115,10,
// 'import pydoc\n
105,109,112,111,114,116,32,112,121,100,111,99,10,
// 'import signal\n
105,109,112,111,114,116,32,115,105,103,110,97,108,10,
// 'import sys\n
105,109,112,111,114,116,32,115,121,115,10,
// 'import traceback\n
105,109,112,111,114,116,32,116,114,97,99,101,98,97,99,107,10,
// 'import weakref\n
105,109,112,111,114,116,32,119,101,97,107,114,101,102,10,
// 'from contextlib import contextmanager\n
102,114,111,109,32,99,111,110,116,101,120,116,108,105,98,32,105,109,112,111,
114,116,32,99,111,110,116,101,120,116,109,97,110,97,103,101,114,10,
// '\n
10,
// 'from _hexchat_embedded import ffi, lib\n
102,114,111,109,32,95,104,101,120,99,104,97,116,95,101,109,98,101,100,100,101,
100,32,105,109,112,111,114,116,32,102,102,105,44,32,108,105,98,10,
// '\n
10,
// 'if sys.version_info < (3, 0):\n
105,102,32,115,121,115,46,118,101,114,115,105,111,110,95,105,110,102,111,32,
60,32,40,51,44,32,48,41,58,10,
// '    from io import BytesIO as HelpEater\n
32,32,32,32,102,114,111,109,32,105,111,32,105,109,112,111,114,116,32,66,121,
116,101,115,73,79,32,97,115,32,72,101,108,112,69,97,116,101,114,10,
// 'else:\n
101,108,115,101,58,10,
// '    from io import StringIO as HelpEater\n
32,32,32,32,102,114,111,109,32,105,111,32,105,109,112,111,114,116,32,83,116,
114,105,110,103,73,79,32,97,115,32,72,101,108,112,69,97,116,101,114,10,
// '\n
10,
// "if not hasattr(sys, 'argv'):\n
105,102,32,110,111,116,32,104,97,115,97,116,116,114,40,115,121,115,44,32,39,
97,114,103,118,39,41,58,10,
// "    sys.argv = ['<hexchat>']\n
32,32,32,32,115,121,115,46,97,114,103,118,32,61,32,91,39,60,104,101,120,99,104,
97,116,62,39,93,10,
// '\n
10,
// "VERSION = b'2.0'  # Sync with hexchat.__version__\n
86,69,82,83,73,79,78,32,61,32,98,39,50,46,48,39,32,32,35,32,83,121,110,99,32,
119,105,116,104,32,104,101,120,99,104,97,116,46,95,95,118,101,114,115,105,111,
110,95,95,10,
// "PLUGIN_NAME = ffi.new('char[]', b'Python')\n
80,76,85,71,73,78,95,78,65,77,69,32,61,32,102,102,105,46,110,101,119,40,39,99,
104,97,114,91,93,39,44,32,98,39,80,121,116,104,111,110,39,41,10,
// "PLUGIN_DESC = ffi.new('char[]', b'Python %d.%d scripting interface' % (sys.version_info[0], sys.version_info[1]))\n
80,76,85,71,73,78,95,68,69,83,67,32,61,32,102,102,105,46,110,101,119,40,39,99,
104,97,114,91,93,39,44,32,98,39,80,121,116,104,111,110,32,37,100,46,37,100,32,
115,99,114,105,112,116,105,110,103,32,105,110,116,101,114,102,97,99,101,39,32,
37,32,40,115,121,115,46,118,101,114,115,105,111,110,95,105,110,102,111,91,48,
93,44,32,115,121,115,46,118,101,114,115,105,111,110,95,105,110,102,111,91,49,
93,41,41,10,
// "PLUGIN_VERSION = ffi.new('char[]', VERSION)\n
80,76,85,71,73,78,95,86,69,82,83,73,79,78,32,61,32,102,102,105,46,110,101,119,
40,39,99,104,97,114,91,93,39,44,32,86,69,82,83,73,79,78,41,10,
// '\n
10,
// '# TODO: Constants should be screaming snake case\n
35,32,84,79,68,79,58,32,67,111,110,115,116,97,110,116,115,32,115,104,111,117,
108,100,32,98,101,32,115,99,114,101,97,109,105,110,103,32,115,110,97,107,101,
32,99,97,115,101,10,
// 'hexchat = None\n
104,101,120,99,104,97,116,32,61,32,78,111,110,101,10,
// 'local_interp = None\n
108,111,99,97,108,95,105,110,116,101,114,112,32,61,32,78,111,110,101,10,
// 'hexchat_stdout = None\n
104,101,120,99,104,97,116,95,115,116,100,111,117,116,32,61,32,78,111,110,101,
10,
// 'plugins = set()\n
112,108,117,103,105,110,115,32,61,32,115,101,116,40,41,10,
// '\n
10,
// '\n
10,
// '@contextmanager\n
64,99,111,110,116,101,120,116,109,97,110,97,103,101,114,10,
// 'def redirected_stdout():\n
100,101,102,32,114,101,100,105,114,101,99,116,101,100,95,115,116,100,111,117,
116,40,41,58,10,
// '    sys.stdout = sys.__stdout__\n
32,32,32,32,115,121,115,46,115,116,100,111,117,116,32,61,32,115,121,115,46,95,
95,115,116,100,111,117,116,95,95,10,
// '    sys.stderr = sys.__stderr__\n
32,32,32,32,115,121,115,46,115,116,100,101,114,114,32,61,32,115,121,115,46,95,
95,115,116,100,101,114,114,95,95,10,
// '    yield\n
32,32,32,32,121,105,101,108,100,10,
// '    sys.stdout = hexchat_stdout\n
32,32,32,32,115,121,115,46,115,116,100,111,117,116,32,61,32,104,101,120,99,104,
97,116,95,115,116,100,111,117,116,10,
// '    sys.stderr = hexchat_stdout\n
32,32,32,32,115,121,115,46,115,116,100,101,114,114,32,61,32,104,101,120,99,104,
97,116,95,115,116,100,111,117,116,10,
// '\n
10,
// '\n
10,
// "if os.getenv('HEXCHAT_LOG_PYTHON'):\n
105,102,32,111,115,46,103,101,116,101,110,118,40,39,72,69,88,67,72,65,84,95,
76,79,71,95,80,89,84,72,79,78,39,41,58,10,
// '    def log(*args):\n
32,32,32,32,100,101,102,32,108,111,103,40,42,97,114,103,115,41,58,10,
// '        with redirected_stdout():\n
32,32,32,32,32,32,32,32,119,105,116,104,32,114,101,100,105,114,101,99,116,101,
100,95,115,116,100,111,117,116,40,41,58,10,
// '            print(*args)\n
32,32,32,32,32,32,32,32,32,32,32,32,112,114,105,110,116,40,42,97,114,103,115,
41,10,
// '\n
10,
// 'else:\n
101,108,115,101,58,10,
// '    def log(*args):\n
32,32,32,32,100,101,102,32,108,111,103,40,42,97,114,103,115,41,58,10,
// '        pass\n
32,32,32,32,32,32,32,32,112,97,115,115,10,
// '\n
10,
// '\n
10,
// 'class Stdout:\n
99,108,97,115,115,32,83,116,100,111,117,116,58,10,
// '    def __init__(self):\n
32,32,32,32,100,101,102,32,95,95,105,110,105,116,95,95,40,115,101,108,102,41,
58,10,
// '        self.buffer = bytearray()\n
32,32,32,32,32,32,32,32,115,101,108,102,46,98,117,102,102,101,114,32,61,32,98,
121,116,101,97,114,114,97,121,40,41,10,
// '\n
10,
// '    def write(self, string):\n
32,32,32,32,100,101,102,32,119,114,105,116,101,40,115,101,108,102,44,32,115,
116,114,105,110,103,41,58,10,
// '        string = string.encode()\n
32,32,32,32,32,32,32,32,115,116,114,105,110,103,32,61,32,115,116,114,105,110,
103,46,101,110,99,111,100,101,40,41,10,
// "        idx = string.rfind(b'\\n')\n
32,32,32,32,32,32,32,32,105,100,120,32,61,32,115,116,114,105,110,103,46,114,
102,105,110,100,40,98,39,92,110,39,41,10,
// '        if idx != -1:\n
32,32,32,32,32,32,32,32,105,102,32,105,100,120,32,33,61,32,45,49,58,10,
// '            self.buffer += string[:idx]\n
32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,98,117,102,102,101,114,
32,43,61,32,115,116,114,105,110,103,91,58,105,100,120,93,10,
// '            lib.hexchat_print(lib.ph, bytes(self.buffer))\n
32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,
95,112,114,105,110,116,40,108,105,98,46,112,104,44,32,98,121,116,101,115,40,
115,101,108,102,46,98,117,102,102,101,114,41,41,10,
// '            self.buffer = bytearray(string[idx + 1:])\n
32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,98,117,102,102,101,114,
32,61,32,98,121,116,101,97,114,114,97,121,40,115,116,114,105,110,103,91,105,
100,120,32,43,32,49,58,93,41,10,
// '        else:\n
32,32,32,32,32,32,32,32,101,108,115,101,58,10,
// '            self.buffer += string\n
32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,98,117,102,102,101,114,
32,43,61,32,115,116,114,105,110,103,10,
// '\n
10,
// '    def flush(self):\n
32,32,32,32,100,101,102,32,102,108,117,115,104,40,115,101,108,102,41,58,10,
// '        lib.hexchat_print(lib.ph, bytes(self.buffer))\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,
110,116,40,108,105,98,46,112,104,44,32,98,121,116,101,115,40,115,101,108,102,
46,98,117,102,102,101,114,41,41,10,
// '        self.buffer = bytearray()\n
32,32,32,32,32,32,32,32,115,101,108,102,46,98,117,102,102,101,114,32,61,32,98,
121,116,101,97,114,114,97,121,40,41,10,
// '\n
10,
// '    def isatty(self):\n
32,32,32,32,100,101,102,32,105,115,97,116,116,121,40,115,101,108,102,41,58,10,
// '        return False\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,70,97,108,115,101,10,
// '\n
10,
// '\n
10,
// 'class Attribute:\n
99,108,97,115,115,32,65,116,116,114,105,98,117,116,101,58,10,
// '    def __init__(self):\n
32,32,32,32,100,101,102,32,95,95,105,110,105,116,95,95,40,115,101,108,102,41,
58,10,
// '        self.time = 0\n
32,32,32,32,32,32,32,32,115,101,108,102,46,116,105,109,101,32,61,32,48,10,
// '\n
10,
// '    def __repr__(self):\n
32,32,32,32,100,101,102,32,95,95,114,101,112,114,95,95,40,115,101,108,102,41,
58,10,
// "        return '<Attribute object at {}>'.format(id(self))\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,39,60,65,116,116,114,105,
98,117,116,101,32,111,98,106,101,99,116,32,97,116,32,123,125,62,39,46,102,111,
114,109,97,116,40,105,100,40,115,101,108,102,41,41,10,
// '\n
10,
// '\n
10,
// 'class Hook:\n
99,108,97,115,115,32,72,111,111,107,58,10,
// '    def __init__(self, plugin, callback, userdata, is_unload):\n
32,32,32,32,100,101,102,32,95,95,105,110,105,116,95,95,40,115,101,108,102,44,
32,112,108,117,103,105,110,44,32,99,97,108,108,98,97,99,107,44,32,117,115,101,
114,100,97,116,97,44,32,105,115,95,117,110,108,111,97,100,41,58,10,
// '        self.is_unload = is_unload\n
32,32,32,32,32,32,32,32,115,101,108,102,46,105,115,95,117,110,108,111,97,100,
32,61,32,105,115,95,117,110,108,111,97,100,10,
// '        self.plugin = weakref.proxy(plugin)\n
32,32,32,32,32,32,32,32,115,101,108,102,46,112,108,117,103,105,110,32,61,32,
119,101,97,107,114,101,102,46,112,114,111,120,121,40,112,108,117,103,105,110,
41,10,
// '        self.callback = callback\n
32,32,32,32,32,32,32,32,115,101,108,102,46,99,97,108,108,98,97,99,107,32,61,
32,99,97,108,108,98,97,99,107,10,
// '        self.userdata = userdata\n
32,32,32,32,32,32,32,32,115,101,108,102,46,117,115,101,114,100,97,116,97,32,
61,32,117,115,101,114,100,97,116,97,10,
// '        self.hexchat_hook = None\n
32,32,32,32,32,32,32,32,115,101,108,102,46,104,101,120,99,104,97,116,95,104,
111,111,107,32,61,32,78,111,110,101,10,
// '        self.handle = ffi.new_handle(weakref.proxy(self))\n
32,32,32,32,32,32,32,32,115,101,108,102,46,104,97,110,100,108,101,32,61,32,102,
102,105,46,110,101,119,95,104,97,110,100,108,101,40,119,101,97,107,114,101,102,
46,112,114,111,120,121,40,115,101,108,102,41,41,10,
// '\n
10,
// '    def __del__(self):\n
32,32,32,32,100,101,102,32,95,95,100,101,108,95,95,40,115,101,108,102,41,58,
10,
// "        log('Removing hook', id(self))\n
32,32,32,32,32,32,32,32,108,111,103,40,39,82,101,109,111,118,105,110,103,32,
104,111,111,107,39,44,32,105,100,40,115,101,108,102,41,41,10,
// '        if self.is_unload is False:\n
32,32,32,32,32,32,32,32,105,102,32,115,101,108,102,46,105,115,95,117,110,108,
111,97,100,32,105,115,32,70,97,108,115,101,58,10,
// '            assert self.hexchat_hook is not None\n
32,32,32,32,32,32,32,32,32,32,32,32,97,115,115,101,114,116,32,115,101,108,102,
46,104,101,120,99,104,97,116,95,104,111,111,107,32,105,115,32,110,111,116,32,
78,111,110,101,10,
// '            lib.hexchat_unhook(lib.ph, self.hexchat_hook)\n
32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,
95,117,110,104,111,111,107,40,108,105,98,46,112,104,44,32,115,101,108,102,46,
104,101,120,99,104,97,116,95,104,111,111,107,41,10,
// '\n
10,
// '\n
10,
// 'if sys.version_info[0] == 2:\n
105,102,32,115,121,115,46,118,101,114,115,105,111,110,95,105,110,102,111,91,
48,93,32,61,61,32,50,58,10,
// '    def compile_file(data, filename):\n
32,32,32,32,100,101,102,32,99,111,109,112,105,108,101,95,102,105,108,101,40,
100,97,116,97,44,32,102,105,108,101,110,97,109,101,41,58,10,
// "        return compile(data, filename, 'exec', dont_inherit=True)\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,99,111,109,112,105,108,101,
40,100,97,116,97,44,32,102,105,108,101,110,97,109,101,44,32,39,101,120,101,99,
39,44,32,100,111,110,116,95,105,110,104,101,114,105,116,61,84,114,117,101,41,
10,
// '\n
10,
// '\n
10,
// '    def compile_line(string):\n
32,32,32,32,100,101,102,32,99,111,109,112,105,108,101,95,108,105,110,101,40,
115,116,114,105,110,103,41,58,10,
// '        try:\n
32,32,32,32,32,32,32,32,116,114,121,58,10,
// "            return compile(string, '<string>', 'eval', dont_inherit=True)\n
32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,99,111,109,112,
105,108,101,40,115,116,114,105,110,103,44,32,39,60,115,116,114,105,110,103,62,
39,44,32,39,101,118,97,108,39,44,32,100,111,110,116,95,105,110,104,101,114,105,
116,61,84,114,117,101,41,10,
// '\n
10,
// '        except SyntaxError:\n
32,32,32,32,32,32,32,32,101,120,99,101,112,116,32,83,121,110,116,97,120,69,114,
114,111,114,58,10,
// '            # For some reason `print` is invalid for eval\n
32,32,32,32,32,32,32,32,32,32,32,32,35,32,70,111,114,32,115,111,109,101,32,114,
101,97,115,111,110,32,96,112,114,105,110,116,96,32,105,115,32,105,110,118,97,
108,105,100,32,102,111,114,32,101,118,97,108,10,
// '            # This will hide any return value though\n
32,32,32,32,32,32,32,32,32,32,32,32,35,32,84,104,105,115,32,119,105,108,108,
32,104,105,100,101,32,97,110,121,32,114,101,116,117,114,110,32,118,97,108,117,
101,32,116,104,111,117,103,104,10,
// "            return compile(string, '<string>', 'exec', dont_inherit=True)\n
32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,99,111,109,112,
105,108,101,40,115,116,114,105,110,103,44,32,39,60,115,116,114,105,110,103,62,
39,44,32,39,101,120,101,99,39,44,32,100,111,110,116,95,105,110,104,101,114,105,
116,61,84,114,117,101,41,10,
// 'else:\n
101,108,115,101,58,10,
// '    def compile_file(data, filename):\n
32,32,32,32,100,101,102,32,99,111,109,112,105,108,101,95,102,105,108,101,40,
100,97,116,97,44,32,102,105,108,101,110,97,109,101,41,58,10,
// "        return compile(data, filename, 'exec', optimize=2, dont_inherit=True)\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,99,111,109,112,105,108,101,
40,100,97,116,97,44,32,102,105,108,101,110,97,109,101,44,32,39,101,120,101,99,
39,44,32,111,112,116,105,109,105,122,101,61,50,44,32,100,111,110,116,95,105,
110,104,101,114,105,116,61,84,114,117,101,41,10,
// '\n
10,
// '\n
10,
// '    def compile_line(string):\n
32,32,32,32,100,101,102,32,99,111,109,112,105,108,101,95,108,105,110,101,40,
115,116,114,105,110,103,41,58,10,
// '        # newline appended to solve unexpected EOF issues\n
32,32,32,32,32,32,32,32,35,32,110,101,119,108,105,110,101,32,97,112,112,101,
110,100,101,100,32,116,111,32,115,111,108,118,101,32,117,110,101,120,112,101,
99,116,101,100,32,69,79,70,32,105,115,115,117,101,115,10,
// "        return compile(string + '\\n', '<string>', 'single', optimize=2, dont_inherit=True)\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,99,111,109,112,105,108,101,
40,115,116,114,105,110,103,32,43,32,39,92,110,39,44,32,39,60,115,116,114,105,
110,103,62,39,44,32,39,115,105,110,103,108,101,39,44,32,111,112,116,105,109,
105,122,101,61,50,44,32,100,111,110,116,95,105,110,104,101,114,105,116,61,84,
114,117,101,41,10,
// '\n
10,
// '\n
10,
// 'class Plugin:\n
99,108,97,115,115,32,80,108,117,103,105,110,58,10,
// '    def __init__(self):\n
32,32,32,32,100,101,102,32,95,95,105,110,105,116,95,95,40,115,101,108,102,41,
58,10,
// '        self.ph = None\n
32,32,32,32,32,32,32,32,115,101,108,102,46,112,104,32,61,32,78,111,110,101,10,
// "        self.name = ''\n
32,32,32,32,32,32,32,32,115,101,108,102,46,110,97,109,101,32,61,32,39,39,10,
// "        self.filename = ''\n
32,32,32,32,32,32,32,32,115,101,108,102,46,102,105,108,101,110,97,109,101,32,
61,32,39,39,10,
// "        self.version = ''\n
32,32,32,32,32,32,32,32,115,101,108,102,46,118,101,114,115,105,111,110,32,61,
32,39,39,10,
// "        self.description = ''\n
32,32,32,32,32,32,32,32,115,101,108,102,46,100,101,115,99,114,105,112,116,105,
111,110,32,61,32,39,39,10,
// '        self.hooks = set()\n
32,32,32,32,32,32,32,32,115,101,108,102,46,104,111,111,107,115,32,61,32,115,
101,116,40,41,10,
// '        self.globals = {\n
32,32,32,32,32,32,32,32,115,101,108,102,46,103,108,111,98,97,108,115,32,61,32,
123,10,
// "            '__plugin': weakref.proxy(self),\n
32,32,32,32,32,32,32,32,32,32,32,32,39,95,95,112,108,117,103,105,110,39,58,32,
119,101,97,107,114,101,102,46,112,114,111,120,121,40,115,101,108,102,41,44,10,
// "            '__name__': '__main__',\n
32,32,32,32,32,32,32,32,32,32,32,32,39,95,95,110,97,109,101,95,95,39,58,32,39,
95,95,109,97,105,110,95,95,39,44,10,
// '        }\n
32,32,32,32,32,32,32,32,125,10,
// '\n
10,
// '    def add_hook(self, callback, userdata, is_unload=False):\n
32,32,32,32,100,101,102,32,97,100,100,95,104,111,111,107,40,115,101,108,102,
44,32,99,97,108,108,98,97,99,107,44,32,117,115,101,114,100,97,116,97,44,32,105,
115,95,117,110,108,111,97,100,61,70,97,108,115,101,41,58,10,
// '        hook = Hook(self, callback, userdata, is_unload=is_unload)\n
32,32,32,32,32,32,32,32,104,111,111,107,32,61,32,72,111,111,107,40,115,101,108,
102,44,32,99,97,108,108,98,97,99,107,44,32,117,115,101,114,100,97,116,97,44,
32,105,115,95,117,110,108,111,97,100,61,105,115,95,117,110,108,111,97,100,41,
10,
// '        self.hooks.add(hook)\n
32,32,32,32,32,32,32,32,115,101,108,102,46,104,111,111,107,115,46,97,100,100,
40,104,111,111,107,41,10,
// '        return hook\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,104,111,111,107,10,
// '\n
10,
// '    def remove_hook(self, hook):\n
32,32,32,32,100,101,102,32,114,101,109,111,118,101,95,104,111,111,107,40,115,
101,108,102,44,32,104,111,111,107,41,58,10,
// '        for h in self.hooks:\n
32,32,32,32,32,32,32,32,102,111,114,32,104,32,105,110,32,115,101,108,102,46,
104,111,111,107,115,58,10,
// '            if id(h) == hook:\n
32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,105,100,40,104,41,32,61,61,32,
104,111,111,107,58,10,
// '                ud = h.userdata\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,117,100,32,61,32,104,46,117,
115,101,114,100,97,116,97,10,
// '                self.hooks.remove(h)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,104,111,111,
107,115,46,114,101,109,111,118,101,40,104,41,10,
// '                return ud\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,117,
100,10,
// '\n
10,
// "        log('Hook not found')\n
32,32,32,32,32,32,32,32,108,111,103,40,39,72,111,111,107,32,110,111,116,32,102,
111,117,110,100,39,41,10,
// '        return None\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,78,111,110,101,10,
// '\n
10,
// '    def loadfile(self, filename):\n
32,32,32,32,100,101,102,32,108,111,97,100,102,105,108,101,40,115,101,108,102,
44,32,102,105,108,101,110,97,109,101,41,58,10,
// '        try:\n
32,32,32,32,32,32,32,32,116,114,121,58,10,
// '            self.filename = filename\n
32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,102,105,108,101,110,97,
109,101,32,61,32,102,105,108,101,110,97,109,101,10,
// "            with open(filename, 'rb') as f:\n
32,32,32,32,32,32,32,32,32,32,32,32,119,105,116,104,32,111,112,101,110,40,102,
105,108,101,110,97,109,101,44,32,39,114,98,39,41,32,97,115,32,102,58,10,
// "                data = f.read().decode('utf-8')\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,100,97,116,97,32,61,32,102,46,
114,101,97,100,40,41,46,100,101,99,111,100,101,40,39,117,116,102,45,56,39,41,
10,
// '            compiled = compile_file(data, filename)\n
32,32,32,32,32,32,32,32,32,32,32,32,99,111,109,112,105,108,101,100,32,61,32,
99,111,109,112,105,108,101,95,102,105,108,101,40,100,97,116,97,44,32,102,105,
108,101,110,97,109,101,41,10,
// '            exec(compiled, self.globals)\n
32,32,32,32,32,32,32,32,32,32,32,32,101,120,101,99,40,99,111,109,112,105,108,
101,100,44,32,115,101,108,102,46,103,108,111,98,97,108,115,41,10,
// '\n
10,
// '            try:\n
32,32,32,32,32,32,32,32,32,32,32,32,116,114,121,58,10,
// "                self.name = self.globals['__module_name__']\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,110,97,109,
101,32,61,32,115,101,108,102,46,103,108,111,98,97,108,115,91,39,95,95,109,111,
100,117,108,101,95,110,97,109,101,95,95,39,93,10,
// '\n
10,
// '            except KeyError:\n
32,32,32,32,32,32,32,32,32,32,32,32,101,120,99,101,112,116,32,75,101,121,69,
114,114,111,114,58,10,
// "                lib.hexchat_print(lib.ph, b'Failed to load module: __module_name__ must be set')\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,
104,97,116,95,112,114,105,110,116,40,108,105,98,46,112,104,44,32,98,39,70,97,
105,108,101,100,32,116,111,32,108,111,97,100,32,109,111,100,117,108,101,58,32,
95,95,109,111,100,117,108,101,95,110,97,109,101,95,95,32,109,117,115,116,32,
98,101,32,115,101,116,39,41,10,
// '\n
10,
// '                return False\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,70,
97,108,115,101,10,
// '\n
10,
// "            self.version = self.globals.get('__module_version__', '')\n
32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,118,101,114,115,105,111,
110,32,61,32,115,101,108,102,46,103,108,111,98,97,108,115,46,103,101,116,40,
39,95,95,109,111,100,117,108,101,95,118,101,114,115,105,111,110,95,95,39,44,
32,39,39,41,10,
// "            self.description = self.globals.get('__module_description__', '')\n
32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,100,101,115,99,114,105,
112,116,105,111,110,32,61,32,115,101,108,102,46,103,108,111,98,97,108,115,46,
103,101,116,40,39,95,95,109,111,100,117,108,101,95,100,101,115,99,114,105,112,
116,105,111,110,95,95,39,44,32,39,39,41,10,
// '            self.ph = lib.hexchat_plugingui_add(lib.ph, filename.encode(), self.name.encode(),\n
32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,102,46,112,104,32,61,32,108,
105,98,46,104,101,120,99,104,97,116,95,112,108,117,103,105,110,103,117,105,95,
97,100,100,40,108,105,98,46,112,104,44,32,102,105,108,101,110,97,109,101,46,
101,110,99,111,100,101,40,41,44,32,115,101,108,102,46,110,97,109,101,46,101,
110,99,111,100,101,40,41,44,10,
// '                                                self.description.encode(), self.version.encode(), ffi.NULL)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,101,108,
102,46,100,101,115,99,114,105,112,116,105,111,110,46,101,110,99,111,100,101,
40,41,44,32,115,101,108,102,46,118,101,114,115,105,111,110,46,101,110,99,111,
100,101,40,41,44,32,102,102,105,46,78,85,76,76,41,10,
// '\n
10,
// '        except Exception as e:\n
32,32,32,32,32,32,32,32,101,120,99,101,112,116,32,69,120,99,101,112,116,105,
111,110,32,97,115,32,101,58,10,
// "            lib.hexchat_print(lib.ph, 'Failed to load module: {}'.format(e).encode())\n
32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,
95,112,114,105,110,116,40,108,105,98,46,112,104,44,32,39,70,97,105,108,101,100,
32,116,111,32,108,111,97,100,32,109,111,100,117,108,101,58,32,123,125,39,46,
102,111,114,109,97,116,40,101,41,46,101,110,99,111,100,101,40,41,41,10,
// '            traceback.print_exc()\n
32,32,32,32,32,32,32,32,32,32,32,32,116,114,97,99,101,98,97,99,107,46,112,114,
105,110,116,95,101,120,99,40,41,10,
// '            return False\n
32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,70,97,108,115,
101,10,
// '\n
10,
// '        return True\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,84,114,117,101,10,
// '\n
10,
// '    def __del__(self):\n
32,32,32,32,100,101,102,32,95,95,100,101,108,95,95,40,115,101,108,102,41,58,
10,
// "        log('unloading', self.filename)\n
32,32,32,32,32,32,32,32,108,111,103,40,39,117,110,108,111,97,100,105,110,103,
39,44,32,115,101,108,102,46,102,105,108,101,110,97,109,101,41,10,
// '        for hook in self.hooks:\n
32,32,32,32,32,32,32,32,102,111,114,32,104,111,111,107,32,105,110,32,115,101,
108,102,46,104,111,111,107,115,58,10,
// '            if hook.is_unload is True:\n
32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,104,111,111,107,46,105,115,95,
117,110,108,111,97,100,32,105,115,32,84,114,117,101,58,10,
// '                try:\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,114,121,58,10,
// '                    hook.callback(hook.userdata)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,104,111,111,107,
46,99,97,108,108,98,97,99,107,40,104,111,111,107,46,117,115,101,114,100,97,116,
97,41,10,
// '\n
10,
// '                except Exception as e:\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,101,120,99,101,112,116,32,69,
120,99,101,112,116,105,111,110,32,97,115,32,101,58,10,
// "                    log('Failed to run hook:', e)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,111,103,40,39,
70,97,105,108,101,100,32,116,111,32,114,117,110,32,104,111,111,107,58,39,44,
32,101,41,10,
// '                    traceback.print_exc()\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,114,97,99,101,
98,97,99,107,46,112,114,105,110,116,95,101,120,99,40,41,10,
// '\n
10,
// '        del self.hooks\n
32,32,32,32,32,32,32,32,100,101,108,32,115,101,108,102,46,104,111,111,107,115,
10,
// '        if self.ph is not None:\n
32,32,32,32,32,32,32,32,105,102,32,115,101,108,102,46,112,104,32,105,115,32,
110,111,116,32,78,111,110,101,58,10,
// '            lib.hexchat_plugingui_remove(lib.ph, self.ph)\n
32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,
95,112,108,117,103,105,110,103,117,105,95,114,101,109,111,118,101,40,108,105,
98,46,112,104,44,32,115,101,108,102,46,112,104,41,10,
// '\n
10,
// '\n
10,
// 'if sys.version_info[0] == 2:\n
105,102,32,115,121,115,46,118,101,114,115,105,111,110,95,105,110,102,111,91,
48,93,32,61,61,32,50,58,10,
// '    def __decode(string):\n
32,32,32,32,100,101,102,32,95,95,100,101,99,111,100,101,40,115,116,114,105,110,
103,41,58,10,
// '        return string\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,115,116,114,105,110,103,10,
// '\n
10,
// 'else:\n
101,108,115,101,58,10,
// '    def __decode(string):\n
32,32,32,32,100,101,102,32,95,95,100,101,99,111,100,101,40,115,116,114,105,110,
103,41,58,10,
// '        return string.decode()\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,115,116,114,105,110,103,46,
100,101,99,111,100,101,40,41,10,
// '\n
10,
// '\n
10,
// '# There can be empty entries between non-empty ones so find the actual last value\n
35,32,84,104,101,114,101,32,99,97,110,32,98,101,32,101,109,112,116,121,32,101,
110,116,114,105,101,115,32,98,101,116,119,101,101,110,32,110,111,110,45,101,
109,112,116,121,32,111,110,101,115,32,115,111,32,102,105,110,100,32,116,104,
101,32,97,99,116,117,97,108,32,108,97,115,116,32,118,97,108,117,101,10,
// 'def wordlist_len(words):\n
100,101,102,32,119,111,114,100,108,105,115,116,95,108,101,110,40,119,111,114,
100,115,41,58,10,
// '    for i in range(31, 0, -1):\n
32,32,32,32,102,111,114,32,105,32,105,110,32,114,97,110,103,101,40,51,49,44,
32,48,44,32,45,49,41,58,10,
// '        if ffi.string(words[i]):\n
32,32,32,32,32,32,32,32,105,102,32,102,102,105,46,115,116,114,105,110,103,40,
119,111,114,100,115,91,105,93,41,58,10,
// '            return i\n
32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,105,10,
// '\n
10,
// '    return 0\n
32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '\n
10,
// 'def create_wordlist(words):\n
100,101,102,32,99,114,101,97,116,101,95,119,111,114,100,108,105,115,116,40,119,
111,114,100,115,41,58,10,
// '    size = wordlist_len(words)\n
32,32,32,32,115,105,122,101,32,61,32,119,111,114,100,108,105,115,116,95,108,
101,110,40,119,111,114,100,115,41,10,
// '    return [__decode(ffi.string(words[i])) for i in range(1, size + 1)]\n
32,32,32,32,114,101,116,117,114,110,32,91,95,95,100,101,99,111,100,101,40,102,
102,105,46,115,116,114,105,110,103,40,119,111,114,100,115,91,105,93,41,41,32,
102,111,114,32,105,32,105,110,32,114,97,110,103,101,40,49,44,32,115,105,122,
101,32,43,32,49,41,93,10,
// '\n
10,
// '\n
10,
// '# This function only exists for compat reasons with the C plugin\n
35,32,84,104,105,115,32,102,117,110,99,116,105,111,110,32,111,110,108,121,32,
101,120,105,115,116,115,32,102,111,114,32,99,111,109,112,97,116,32,114,101,97,
115,111,110,115,32,119,105,116,104,32,116,104,101,32,67,32,112,108,117,103,105,
110,10,
// '# It turns the word list from print hooks into a word_eol list\n
35,32,73,116,32,116,117,114,110,115,32,116,104,101,32,119,111,114,100,32,108,
105,115,116,32,102,114,111,109,32,112,114,105,110,116,32,104,111,111,107,115,
32,105,110,116,111,32,97,32,119,111,114,100,95,101,111,108,32,108,105,115,116,
10,
// '# This makes no sense to do...\n
35,32,84,104,105,115,32,109,97,107,101,115,32,110,111,32,115,101,110,115,101,
32,116,111,32,100,111,46,46,46,10,
// 'def create_wordeollist(words):\n
100,101,102,32,99,114,101,97,116,101,95,119,111,114,100,101,111,108,108,105,
115,116,40,119,111,114,100,115,41,58,10,
// '    words = reversed(words)\n
32,32,32,32,119,111,114,100,115,32,61,32,114,101,118,101,114,115,101,100,40,
119,111,114,100,115,41,10,
// '    accum = None\n
32,32,32,32,97,99,99,117,109,32,61,32,78,111,110,101,10,
// '    ret = []\n
32,32,32,32,114,101,116,32,61,32,91,93,10,
// '    for word in words:\n
32,32,32,32,102,111,114,32,119,111,114,100,32,105,110,32,119,111,114,100,115,
58,10,
// '        if accum is None:\n
32,32,32,32,32,32,32,32,105,102,32,97,99,99,117,109,32,105,115,32,78,111,110,
101,58,10,
// '            accum = word\n
32,32,32,32,32,32,32,32,32,32,32,32,97,99,99,117,109,32,61,32,119,111,114,100,
10,
// '\n
10,
// '        elif word:\n
32,32,32,32,32,32,32,32,101,108,105,102,32,119,111,114,100,58,10,
// '            last = accum\n
32,32,32,32,32,32,32,32,32,32,32,32,108,97,115,116,32,61,32,97,99,99,117,109,
10,
// "            accum = ' '.join((word, last))\n
32,32,32,32,32,32,32,32,32,32,32,32,97,99,99,117,109,32,61,32,39,32,39,46,106,
111,105,110,40,40,119,111,114,100,44,32,108,97,115,116,41,41,10,
// '\n
10,
// '        ret.insert(0, accum)\n
32,32,32,32,32,32,32,32,114,101,116,46,105,110,115,101,114,116,40,48,44,32,97,
99,99,117,109,41,10,
// '\n
10,
// '    return ret\n
32,32,32,32,114,101,116,117,114,110,32,114,101,116,10,
// '\n
10,
// '\n
10,
// 'def to_cb_ret(value):\n
100,101,102,32,116,111,95,99,98,95,114,101,116,40,118,97,108,117,101,41,58,10,
// '    if value is None:\n
32,32,32,32,105,102,32,118,97,108,117,101,32,105,115,32,78,111,110,101,58,10,
// '        return 0\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '    return int(value)\n
32,32,32,32,114,101,116,117,114,110,32,105,110,116,40,118,97,108,117,101,41,
10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_command_hook(word, word_eol, userdata):\n
100,101,102,32,95,111,110,95,99,111,109,109,97,110,100,95,104,111,111,107,40,
119,111,114,100,44,32,119,111,114,100,95,101,111,108,44,32,117,115,101,114,100,
97,116,97,41,58,10,
// '    hook = ffi.from_handle(userdata)\n
32,32,32,32,104,111,111,107,32,61,32,102,102,105,46,102,114,111,109,95,104,97,
110,100,108,101,40,117,115,101,114,100,97,116,97,41,10,
// '    word = create_wordlist(word)\n
32,32,32,32,119,111,114,100,32,61,32,99,114,101,97,116,101,95,119,111,114,100,
108,105,115,116,40,119,111,114,100,41,10,
// '    word_eol = create_wordlist(word_eol)\n
32,32,32,32,119,111,114,100,95,101,111,108,32,61,32,99,114,101,97,116,101,95,
119,111,114,100,108,105,115,116,40,119,111,114,100,95,101,111,108,41,10,
// '    return to_cb_ret(hook.callback(word, word_eol, hook.userdata))\n
32,32,32,32,114,101,116,117,114,110,32,116,111,95,99,98,95,114,101,116,40,104,
111,111,107,46,99,97,108,108,98,97,99,107,40,119,111,114,100,44,32,119,111,114,
100,95,101,111,108,44,32,104,111,111,107,46,117,115,101,114,100,97,116,97,41,
41,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_print_hook(word, userdata):\n
100,101,102,32,95,111,110,95,112,114,105,110,116,95,104,111,111,107,40,119,111,
114,100,44,32,117,115,101,114,100,97,116,97,41,58,10,
// '    hook = ffi.from_handle(userdata)\n
32,32,32,32,104,111,111,107,32,61,32,102,102,105,46,102,114,111,109,95,104,97,
110,100,108,101,40,117,115,101,114,100,97,116,97,41,10,
// '    word = create_wordlist(word)\n
32,32,32,32,119,111,114,100,32,61,32,99,114,101,97,116,101,95,119,111,114,100,
108,105,115,116,40,119,111,114,100,41,10,
// '    word_eol = create_wordeollist(word)\n
32,32,32,32,119,111,114,100,95,101,111,108,32,61,32,99,114,101,97,116,101,95,
119,111,114,100,101,111,108,108,105,115,116,40,119,111,114,100,41,10,
// '    return to_cb_ret(hook.callback(word, word_eol, hook.userdata))\n
32,32,32,32,114,101,116,117,114,110,32,116,111,95,99,98,95,114,101,116,40,104,
111,111,107,46,99,97,108,108,98,97,99,107,40,119,111,114,100,44,32,119,111,114,
100,95,101,111,108,44,32,104,111,111,107,46,117,115,101,114,100,97,116,97,41,
41,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_print_attrs_hook(word, attrs, userdata):\n
100,101,102,32,95,111,110,95,112,114,105,110,116,95,97,116,116,114,115,95,104,
111,111,107,40,119,111,114,100,44,32,97,116,116,114,115,44,32,117,115,101,114,
100,97,116,97,41,58,10,
// '    hook = ffi.from_handle(userdata)\n
32,32,32,32,104,111,111,107,32,61,32,102,102,105,46,102,114,111,109,95,104,97,
110,100,108,101,40,117,115,101,114,100,97,116,97,41,10,
// '    word = create_wordlist(word)\n
32,32,32,32,119,111,114,100,32,61,32,99,114,101,97,116,101,95,119,111,114,100,
108,105,115,116,40,119,111,114,100,41,10,
// '    word_eol = create_wordeollist(word)\n
32,32,32,32,119,111,114,100,95,101,111,108,32,61,32,99,114,101,97,116,101,95,
119,111,114,100,101,111,108,108,105,115,116,40,119,111,114,100,41,10,
// '    attr = Attribute()\n
32,32,32,32,97,116,116,114,32,61,32,65,116,116,114,105,98,117,116,101,40,41,
10,
// '    attr.time = attrs.server_time_utc\n
32,32,32,32,97,116,116,114,46,116,105,109,101,32,61,32,97,116,116,114,115,46,
115,101,114,118,101,114,95,116,105,109,101,95,117,116,99,10,
// '    return to_cb_ret(hook.callback(word, word_eol, hook.userdata, attr))\n
32,32,32,32,114,101,116,117,114,110,32,116,111,95,99,98,95,114,101,116,40,104,
111,111,107,46,99,97,108,108,98,97,99,107,40,119,111,114,100,44,32,119,111,114,
100,95,101,111,108,44,32,104,111,111,107,46,117,115,101,114,100,97,116,97,44,
32,97,116,116,114,41,41,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_server_hook(word, word_eol, userdata):\n
100,101,102,32,95,111,110,95,115,101,114,118,101,114,95,104,111,111,107,40,119,
111,114,100,44,32,119,111,114,100,95,101,111,108,44,32,117,115,101,114,100,97,
116,97,41,58,10,
// '    hook = ffi.from_handle(userdata)\n
32,32,32,32,104,111,111,107,32,61,32,102,102,105,46,102,114,111,109,95,104,97,
110,100,108,101,40,117,115,101,114,100,97,116,97,41,10,
// '    word = create_wordlist(word)\n
32,32,32,32,119,111,114,100,32,61,32,99,114,101,97,116,101,95,119,111,114,100,
108,105,115,116,40,119,111,114,100,41,10,
// '    word_eol = create_wordlist(word_eol)\n
32,32,32,32,119,111,114,100,95,101,111,108,32,61,32,99,114,101,97,116,101,95,
119,111,114,100,108,105,115,116,40,119,111,114,100,95,101,111,108,41,10,
// '    return to_cb_ret(hook.callback(word, word_eol, hook.userdata))\n
32,32,32,32,114,101,116,117,114,110,32,116,111,95,99,98,95,114,101,116,40,104,
111,111,107,46,99,97,108,108,98,97,99,107,40,119,111,114,100,44,32,119,111,114,
100,95,101,111,108,44,32,104,111,111,107,46,117,115,101,114,100,97,116,97,41,
41,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_server_attrs_hook(word, word_eol, attrs, userdata):\n
100,101,102,32,95,111,110,95,115,101,114,118,101,114,95,97,116,116,114,115,95,
104,111,111,107,40,119,111,114,100,44,32,119,111,114,100,95,101,111,108,44,32,
97,116,116,114,115,44,32,117,115,101,114,100,97,116,97,41,58,10,
// '    hook = ffi.from_handle(userdata)\n
32,32,32,32,104,111,111,107,32,61,32,102,102,105,46,102,114,111,109,95,104,97,
110,100,108,101,40,117,115,101,114,100,97,116,97,41,10,
// '    word = create_wordlist(word)\n
32,32,32,32,119,111,114,100,32,61,32,99,114,101,97,116,101,95,119,111,114,100,
108,105,115,116,40,119,111,114,100,41,10,
// '    word_eol = create_wordlist(word_eol)\n
32,32,32,32,119,111,114,100,95,101,111,108,32,61,32,99,114,101,97,116,101,95,
119,111,114,100,108,105,115,116,40,119,111,114,100,95,101,111,108,41,10,
// '    attr = Attribute()\n
32,32,32,32,97,116,116,114,32,61,32,65,116,116,114,105,98,117,116,101,40,41,
10,
// '    attr.time = attrs.server_time_utc\n
32,32,32,32,97,116,116,114,46,116,105,109,101,32,61,32,97,116,116,114,115,46,
115,101,114,118,101,114,95,116,105,109,101,95,117,116,99,10,
// '    return to_cb_ret(hook.callback(word, word_eol, hook.userdata, attr))\n
32,32,32,32,114,101,116,117,114,110,32,116,111,95,99,98,95,114,101,116,40,104,
111,111,107,46,99,97,108,108,98,97,99,107,40,119,111,114,100,44,32,119,111,114,
100,95,101,111,108,44,32,104,111,111,107,46,117,115,101,114,100,97,116,97,44,
32,97,116,116,114,41,41,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_timer_hook(userdata):\n
100,101,102,32,95,111,110,95,116,105,109,101,114,95,104,111,111,107,40,117,115,
101,114,100,97,116,97,41,58,10,
// '    hook = ffi.from_handle(userdata)\n
32,32,32,32,104,111,111,107,32,61,32,102,102,105,46,102,114,111,109,95,104,97,
110,100,108,101,40,117,115,101,114,100,97,116,97,41,10,
// '    if hook.callback(hook.userdata) == True:\n
32,32,32,32,105,102,32,104,111,111,107,46,99,97,108,108,98,97,99,107,40,104,
111,111,107,46,117,115,101,114,100,97,116,97,41,32,61,61,32,84,114,117,101,58,
10,
// '        return 1\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,49,10,
// '\n
10,
// '    try:\n
32,32,32,32,116,114,121,58,10,
// '        # Avoid calling hexchat_unhook twice if unnecessary\n
32,32,32,32,32,32,32,32,35,32,65,118,111,105,100,32,99,97,108,108,105,110,103,
32,104,101,120,99,104,97,116,95,117,110,104,111,111,107,32,116,119,105,99,101,
32,105,102,32,117,110,110,101,99,101,115,115,97,114,121,10,
// '        hook.is_unload = True\n
32,32,32,32,32,32,32,32,104,111,111,107,46,105,115,95,117,110,108,111,97,100,
32,61,32,84,114,117,101,10,
// '    except ReferenceError:\n
32,32,32,32,101,120,99,101,112,116,32,82,101,102,101,114,101,110,99,101,69,114,
114,111,114,58,10,
// '        # hook is a weak reference, it might have been destroyed by the callback\n
32,32,32,32,32,32,32,32,35,32,104,111,111,107,32,105,115,32,97,32,119,101,97,
107,32,114,101,102,101,114,101,110,99,101,44,32,105,116,32,109,105,103,104,116,
32,104,97,118,101,32,98,101,101,110,32,100,101,115,116,114,111,121,101,100,32,
98,121,32,116,104,101,32,99,97,108,108,98,97,99,107,10,
// '        # in which case it has already been removed from hook.plugin.hooks and\n
32,32,32,32,32,32,32,32,35,32,105,110,32,119,104,105,99,104,32,99,97,115,101,
32,105,116,32,104,97,115,32,97,108,114,101,97,100,121,32,98,101,101,110,32,114,
101,109,111,118,101,100,32,102,114,111,109,32,104,111,111,107,46,112,108,117,
103,105,110,46,104,111,111,107,115,32,97,110,100,10,
// "        # we wouldn't be able to test it with h == hook anyway.\n
32,32,32,32,32,32,32,32,35,32,119,101,32,119,111,117,108,100,110,39,116,32,98,
101,32,97,98,108,101,32,116,111,32,116,101,115,116,32,105,116,32,119,105,116,
104,32,104,32,61,61,32,104,111,111,107,32,97,110,121,119,97,121,46,10,
// '        return 0\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '    for h in hook.plugin.hooks:\n
32,32,32,32,102,111,114,32,104,32,105,110,32,104,111,111,107,46,112,108,117,
103,105,110,46,104,111,111,107,115,58,10,
// '        if h == hook:\n
32,32,32,32,32,32,32,32,105,102,32,104,32,61,61,32,104,111,111,107,58,10,
// '            hook.plugin.hooks.remove(h)\n
32,32,32,32,32,32,32,32,32,32,32,32,104,111,111,107,46,112,108,117,103,105,110,
46,104,111,111,107,115,46,114,101,109,111,118,101,40,104,41,10,
// '            break\n
32,32,32,32,32,32,32,32,32,32,32,32,98,114,101,97,107,10,
// '\n
10,
// '    return 0\n
32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern(error=3)\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,101,114,114,111,
114,61,51,41,10,
// 'def _on_say_command(word, word_eol, userdata):\n
100,101,102,32,95,111,110,95,115,97,121,95,99,111,109,109,97,110,100,40,119,
111,114,100,44,32,119,111,114,100,95,101,111,108,44,32,117,115,101,114,100,97,
116,97,41,58,10,
// "    channel = ffi.string(lib.hexchat_get_info(lib.ph, b'channel'))\n
32,32,32,32,99,104,97,110,110,101,108,32,61,32,102,102,105,46,115,116,114,105,
110,103,40,108,105,98,46,104,101,120,99,104,97,116,95,103,101,116,95,105,110,
102,111,40,108,105,98,46,112,104,44,32,98,39,99,104,97,110,110,101,108,39,41,
41,10,
// "    if channel == b'>>python<<':\n
32,32,32,32,105,102,32,99,104,97,110,110,101,108,32,61,61,32,98,39,62,62,112,
121,116,104,111,110,60,60,39,58,10,
// '        python = ffi.string(word_eol[1])\n
32,32,32,32,32,32,32,32,112,121,116,104,111,110,32,61,32,102,102,105,46,115,
116,114,105,110,103,40,119,111,114,100,95,101,111,108,91,49,93,41,10,
// "        lib.hexchat_print(lib.ph, b'>>> ' + python)\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,
110,116,40,108,105,98,46,112,104,44,32,98,39,62,62,62,32,39,32,43,32,112,121,
116,104,111,110,41,10,
// '        exec_in_interp(__decode(python))\n
32,32,32,32,32,32,32,32,101,120,101,99,95,105,110,95,105,110,116,101,114,112,
40,95,95,100,101,99,111,100,101,40,112,121,116,104,111,110,41,41,10,
// '        return 1\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,49,10,
// '\n
10,
// '    return 0\n
32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '\n
10,
// 'def load_filename(filename):\n
100,101,102,32,108,111,97,100,95,102,105,108,101,110,97,109,101,40,102,105,108,
101,110,97,109,101,41,58,10,
// '    filename = os.path.expanduser(filename)\n
32,32,32,32,102,105,108,101,110,97,109,101,32,61,32,111,115,46,112,97,116,104,
46,101,120,112,97,110,100,117,115,101,114,40,102,105,108,101,110,97,109,101,
41,10,
// '    if not os.path.isabs(filename):\n
32,32,32,32,105,102,32,110,111,116,32,111,115,46,112,97,116,104,46,105,115,97,
98,115,40,102,105,108,101,110,97,109,101,41,58,10,
// "        configdir = __decode(ffi.string(lib.hexchat_get_info(lib.ph, b'configdir')))\n
32,32,32,32,32,32,32,32,99,111,110,102,105,103,100,105,114,32,61,32,95,95,100,
101,99,111,100,101,40,102,102,105,46,115,116,114,105,110,103,40,108,105,98,46,
104,101,120,99,104,97,116,95,103,101,116,95,105,110,102,111,40,108,105,98,46,
112,104,44,32,98,39,99,111,110,102,105,103,100,105,114,39,41,41,41,10,
// '\n
10,
// "        filename = os.path.join(configdir, 'addons', filename)\n
32,32,32,32,32,32,32,32,102,105,108,101,110,97,109,101,32,61,32,111,115,46,112,
97,116,104,46,106,111,105,110,40,99,111,110,102,105,103,100,105,114,44,32,39,
97,100,100,111,110,115,39,44,32,102,105,108,101,110,97,109,101,41,10,
// '\n
10,
// '    if filename and not any(plugin.filename == filename for plugin in plugins):\n
32,32,32,32,105,102,32,102,105,108,101,110,97,109,101,32,97,110,100,32,110,111,
116,32,97,110,121,40,112,108,117,103,105,110,46,102,105,108,101,110,97,109,101,
32,61,61,32,102,105,108,101,110,97,109,101,32,102,111,114,32,112,108,117,103,
105,110,32,105,110,32,112,108,117,103,105,110,115,41,58,10,
// '        plugin = Plugin()\n
32,32,32,32,32,32,32,32,112,108,117,103,105,110,32,61,32,80,108,117,103,105,
110,40,41,10,
// '        if plugin.loadfile(filename):\n
32,32,32,32,32,32,32,32,105,102,32,112,108,117,103,105,110,46,108,111,97,100,
102,105,108,101,40,102,105,108,101,110,97,109,101,41,58,10,
// '            plugins.add(plugin)\n
32,32,32,32,32,32,32,32,32,32,32,32,112,108,117,103,105,110,115,46,97,100,100,
40,112,108,117,103,105,110,41,10,
// '            return True\n
32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,84,114,117,101,
10,
// '\n
10,
// '    return False\n
32,32,32,32,114,101,116,117,114,110,32,70,97,108,115,101,10,
// '\n
10,
// '\n
10,
// 'def unload_name(name):\n
100,101,102,32,117,110,108,111,97,100,95,110,97,109,101,40,110,97,109,101,41,
58,10,
// '    if name:\n
32,32,32,32,105,102,32,110,97,109,101,58,10,
// '        for plugin in plugins:\n
32,32,32,32,32,32,32,32,102,111,114,32,112,108,117,103,105,110,32,105,110,32,
112,108,117,103,105,110,115,58,10,
// '            if name in (plugin.name, plugin.filename, os.path.basename(plugin.filename)):\n
32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,110,97,109,101,32,105,110,32,
40,112,108,117,103,105,110,46,110,97,109,101,44,32,112,108,117,103,105,110,46,
102,105,108,101,110,97,109,101,44,32,111,115,46,112,97,116,104,46,98,97,115,
101,110,97,109,101,40,112,108,117,103,105,110,46,102,105,108,101,110,97,109,
101,41,41,58,10,
// '                plugins.remove(plugin)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,112,108,117,103,105,110,115,
46,114,101,109,111,118,101,40,112,108,117,103,105,110,41,10,
// '                return True\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,84,
114,117,101,10,
// '\n
10,
// '    return False\n
32,32,32,32,114,101,116,117,114,110,32,70,97,108,115,101,10,
// '\n
10,
// '\n
10,
// 'def reload_name(name):\n
100,101,102,32,114,101,108,111,97,100,95,110,97,109,101,40,110,97,109,101,41,
58,10,
// '    if name:\n
32,32,32,32,105,102,32,110,97,109,101,58,10,
// '        for plugin in plugins:\n
32,32,32,32,32,32,32,32,102,111,114,32,112,108,117,103,105,110,32,105,110,32,
112,108,117,103,105,110,115,58,10,
// '            if name in (plugin.name, plugin.filename, os.path.basename(plugin.filename)):\n
32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,110,97,109,101,32,105,110,32,
40,112,108,117,103,105,110,46,110,97,109,101,44,32,112,108,117,103,105,110,46,
102,105,108,101,110,97,109,101,44,32,111,115,46,112,97,116,104,46,98,97,115,
101,110,97,109,101,40,112,108,117,103,105,110,46,102,105,108,101,110,97,109,
101,41,41,58,10,
// '                filename = plugin.filename\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,102,105,108,101,110,97,109,101,
32,61,32,112,108,117,103,105,110,46,102,105,108,101,110,97,109,101,10,
// '                plugins.remove(plugin)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,112,108,117,103,105,110,115,
46,114,101,109,111,118,101,40,112,108,117,103,105,110,41,10,
// '                return load_filename(filename)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,108,
111,97,100,95,102,105,108,101,110,97,109,101,40,102,105,108,101,110,97,109,101,
41,10,
// '\n
10,
// '    return False\n
32,32,32,32,114,101,116,117,114,110,32,70,97,108,115,101,10,
// '\n
10,
// '\n
10,
// '@contextmanager\n
64,99,111,110,116,101,120,116,109,97,110,97,103,101,114,10,
// 'def change_cwd(path):\n
100,101,102,32,99,104,97,110,103,101,95,99,119,100,40,112,97,116,104,41,58,10,
// '    old_cwd = os.getcwd()\n
32,32,32,32,111,108,100,95,99,119,100,32,61,32,111,115,46,103,101,116,99,119,
100,40,41,10,
// '    os.chdir(path)\n
32,32,32,32,111,115,46,99,104,100,105,114,40,112,97,116,104,41,10,
// '    yield\n
32,32,32,32,121,105,101,108,100,10,
// '    os.chdir(old_cwd)\n
32,32,32,32,111,115,46,99,104,100,105,114,40,111,108,100,95,99,119,100,41,10,
// '\n
10,
// '\n
10,
// 'def autoload():\n
100,101,102,32,97,117,116,111,108,111,97,100,40,41,58,10,
// "    configdir = __decode(ffi.string(lib.hexchat_get_info(lib.ph, b'configdir')))\n
32,32,32,32,99,111,110,102,105,103,100,105,114,32,61,32,95,95,100,101,99,111,
100,101,40,102,102,105,46,115,116,114,105,110,103,40,108,105,98,46,104,101,120,
99,104,97,116,95,103,101,116,95,105,110,102,111,40,108,105,98,46,112,104,44,
32,98,39,99,111,110,102,105,103,100,105,114,39,41,41,41,10,
// "    addondir = os.path.join(configdir, 'addons')\n
32,32,32,32,97,100,100,111,110,100,105,114,32,61,32,111,115,46,112,97,116,104,
46,106,111,105,110,40,99,111,110,102,105,103,100,105,114,44,32,39,97,100,100,
111,110,115,39,41,10,
// '    try:\n
32,32,32,32,116,114,121,58,10,
// '        with change_cwd(addondir):  # Maintaining old behavior\n
32,32,32,32,32,32,32,32,119,105,116,104,32,99,104,97,110,103,101,95,99,119,100,
40,97,100,100,111,110,100,105,114,41,58,32,32,35,32,77,97,105,110,116,97,105,
110,105,110,103,32,111,108,100,32,98,101,104,97,118,105,111,114,10,
// '            for f in os.listdir(addondir):\n
32,32,32,32,32,32,32,32,32,32,32,32,102,111,114,32,102,32,105,110,32,111,115,
46,108,105,115,116,100,105,114,40,97,100,100,111,110,100,105,114,41,58,10,
// "                if f.endswith('.py'):\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,102,46,101,110,100,
115,119,105,116,104,40,39,46,112,121,39,41,58,10,
// "                    log('Autoloading', f)\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,111,103,40,39,
65,117,116,111,108,111,97,100,105,110,103,39,44,32,102,41,10,
// '                    # TODO: Set cwd\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,35,32,84,79,68,79,
58,32,83,101,116,32,99,119,100,10,
// '                    load_filename(os.path.join(addondir, f))\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,111,97,100,95,
102,105,108,101,110,97,109,101,40,111,115,46,112,97,116,104,46,106,111,105,110,
40,97,100,100,111,110,100,105,114,44,32,102,41,41,10,
// '\n
10,
// '    except FileNotFoundError as e:\n
32,32,32,32,101,120,99,101,112,116,32,70,105,108,101,78,111,116,70,111,117,110,
100,69,114,114,111,114,32,97,115,32,101,58,10,
// "        log('Autoload failed', e)\n
32,32,32,32,32,32,32,32,108,111,103,40,39,65,117,116,111,108,111,97,100,32,102,
97,105,108,101,100,39,44,32,101,41,10,
// '\n
10,
// '\n
10,
// 'def list_plugins():\n
100,101,102,32,108,105,115,116,95,112,108,117,103,105,110,115,40,41,58,10,
// '    if not plugins:\n
32,32,32,32,105,102,32,110,111,116,32,112,108,117,103,105,110,115,58,10,
// "        lib.hexchat_print(lib.ph, b'No python modules loaded')\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,
110,116,40,108,105,98,46,112,104,44,32,98,39,78,111,32,112,121,116,104,111,110,
32,109,111,100,117,108,101,115,32,108,111,97,100,101,100,39,41,10,
// '        return\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,10,
// '\n
10,
// "    tbl_headers = [b'Name', b'Version', b'Filename', b'Description']\n
32,32,32,32,116,98,108,95,104,101,97,100,101,114,115,32,61,32,91,98,39,78,97,
109,101,39,44,32,98,39,86,101,114,115,105,111,110,39,44,32,98,39,70,105,108,
101,110,97,109,101,39,44,32,98,39,68,101,115,99,114,105,112,116,105,111,110,
39,93,10,
// '    tbl = [\n
32,32,32,32,116,98,108,32,61,32,91,10,
// '        tbl_headers,\n
32,32,32,32,32,32,32,32,116,98,108,95,104,101,97,100,101,114,115,44,10,
// "        [(b'-' * len(s)) for s in tbl_headers]\n
32,32,32,32,32,32,32,32,91,40,98,39,45,39,32,42,32,108,101,110,40,115,41,41,
32,102,111,114,32,115,32,105,110,32,116,98,108,95,104,101,97,100,101,114,115,
93,10,
// '    ]\n
32,32,32,32,93,10,
// '\n
10,
// '    for plugin in plugins:\n
32,32,32,32,102,111,114,32,112,108,117,103,105,110,32,105,110,32,112,108,117,
103,105,110,115,58,10,
// '        basename = os.path.basename(plugin.filename).encode()\n
32,32,32,32,32,32,32,32,98,97,115,101,110,97,109,101,32,61,32,111,115,46,112,
97,116,104,46,98,97,115,101,110,97,109,101,40,112,108,117,103,105,110,46,102,
105,108,101,110,97,109,101,41,46,101,110,99,111,100,101,40,41,10,
// '        name = plugin.name.encode()\n
32,32,32,32,32,32,32,32,110,97,109,101,32,61,32,112,108,117,103,105,110,46,110,
97,109,101,46,101,110,99,111,100,101,40,41,10,
// "        version = plugin.version.encode() if plugin.version else b'<none>'\n
32,32,32,32,32,32,32,32,118,101,114,115,105,111,110,32,61,32,112,108,117,103,
105,110,46,118,101,114,115,105,111,110,46,101,110,99,111,100,101,40,41,32,105,
102,32,112,108,117,103,105,110,46,118,101,114,115,105,111,110,32,101,108,115,
101,32,98,39,60,110,111,110,101,62,39,10,
// "        description = plugin.description.encode() if plugin.description else b'<none>'\n
32,32,32,32,32,32,32,32,100,101,115,99,114,105,112,116,105,111,110,32,61,32,
112,108,117,103,105,110,46,100,101,115,99,114,105,112,116,105,111,110,46,101,
110,99,111,100,101,40,41,32,105,102,32,112,108,117,103,105,110,46,100,101,115,
99,114,105,112,116,105,111,110,32,101,108,115,101,32,98,39,60,110,111,110,101,
62,39,10,
// '        tbl.append((name, version, basename, description))\n
32,32,32,32,32,32,32,32,116,98,108,46,97,112,112,101,110,100,40,40,110,97,109,
101,44,32,118,101,114,115,105,111,110,44,32,98,97,115,101,110,97,109,101,44,
32,100,101,115,99,114,105,112,116,105,111,110,41,41,10,
// '\n
10,
// '    column_sizes = [\n
32,32,32,32,99,111,108,117,109,110,95,115,105,122,101,115,32,61,32,91,10,
// '        max(len(item) for item in column)\n
32,32,32,32,32,32,32,32,109,97,120,40,108,101,110,40,105,116,101,109,41,32,102,
111,114,32,105,116,101,109,32,105,110,32,99,111,108,117,109,110,41,10,
// '        for column in zip(*tbl)\n
32,32,32,32,32,32,32,32,102,111,114,32,99,111,108,117,109,110,32,105,110,32,
122,105,112,40,42,116,98,108,41,10,
// '    ]\n
32,32,32,32,93,10,
// '\n
10,
// '    for row in tbl:\n
32,32,32,32,102,111,114,32,114,111,119,32,105,110,32,116,98,108,58,10,
// "        lib.hexchat_print(lib.ph, b' '.join(item.ljust(column_sizes[i])\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,
110,116,40,108,105,98,46,112,104,44,32,98,39,32,39,46,106,111,105,110,40,105,
116,101,109,46,108,106,117,115,116,40,99,111,108,117,109,110,95,115,105,122,
101,115,91,105,93,41,10,
// '                                            for i, item in enumerate(row)))\n
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,102,111,114,32,105,44,
32,105,116,101,109,32,105,110,32,101,110,117,109,101,114,97,116,101,40,114,111,
119,41,41,41,10,
// "    lib.hexchat_print(lib.ph, b'')\n
32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,110,116,40,
108,105,98,46,112,104,44,32,98,39,39,41,10,
// '\n
10,
// '\n
10,
// 'def exec_in_interp(python):\n
100,101,102,32,101,120,101,99,95,105,110,95,105,110,116,101,114,112,40,112,121,
116,104,111,110,41,58,10,
// '    global local_interp\n
32,32,32,32,103,108,111,98,97,108,32,108,111,99,97,108,95,105,110,116,101,114,
112,10,
// '\n
10,
// '    if not python:\n
32,32,32,32,105,102,32,110,111,116,32,112,121,116,104,111,110,58,10,
// '        return\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,10,
// '\n
10,
// '    if local_interp is None:\n
32,32,32,32,105,102,32,108,111,99,97,108,95,105,110,116,101,114,112,32,105,115,
32,78,111,110,101,58,10,
// '        local_interp = Plugin()\n
32,32,32,32,32,32,32,32,108,111,99,97,108,95,105,110,116,101,114,112,32,61,32,
80,108,117,103,105,110,40,41,10,
// '        local_interp.locals = {}\n
32,32,32,32,32,32,32,32,108,111,99,97,108,95,105,110,116,101,114,112,46,108,
111,99,97,108,115,32,61,32,123,125,10,
// "        local_interp.globals['hexchat'] = hexchat\n
32,32,32,32,32,32,32,32,108,111,99,97,108,95,105,110,116,101,114,112,46,103,
108,111,98,97,108,115,91,39,104,101,120,99,104,97,116,39,93,32,61,32,104,101,
120,99,104,97,116,10,
// '\n
10,
// '    code = compile_line(python)\n
32,32,32,32,99,111,100,101,32,61,32,99,111,109,112,105,108,101,95,108,105,110,
101,40,112,121,116,104,111,110,41,10,
// '    try:\n
32,32,32,32,116,114,121,58,10,
// '        ret = eval(code, local_interp.globals, local_interp.locals)\n
32,32,32,32,32,32,32,32,114,101,116,32,61,32,101,118,97,108,40,99,111,100,101,
44,32,108,111,99,97,108,95,105,110,116,101,114,112,46,103,108,111,98,97,108,
115,44,32,108,111,99,97,108,95,105,110,116,101,114,112,46,108,111,99,97,108,
115,41,10,
// '        if ret is not None:\n
32,32,32,32,32,32,32,32,105,102,32,114,101,116,32,105,115,32,110,111,116,32,
78,111,110,101,58,10,
// "            lib.hexchat_print(lib.ph, '{}'.format(ret).encode())\n
32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,
95,112,114,105,110,116,40,108,105,98,46,112,104,44,32,39,123,125,39,46,102,111,
114,109,97,116,40,114,101,116,41,46,101,110,99,111,100,101,40,41,41,10,
// '\n
10,
// '    except Exception as e:\n
32,32,32,32,101,120,99,101,112,116,32,69,120,99,101,112,116,105,111,110,32,97,
115,32,101,58,10,
// '        traceback.print_exc(file=hexchat_stdout)\n
32,32,32,32,32,32,32,32,116,114,97,99,101,98,97,99,107,46,112,114,105,110,116,
95,101,120,99,40,102,105,108,101,61,104,101,120,99,104,97,116,95,115,116,100,
111,117,116,41,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_load_command(word, word_eol, userdata):\n
100,101,102,32,95,111,110,95,108,111,97,100,95,99,111,109,109,97,110,100,40,
119,111,114,100,44,32,119,111,114,100,95,101,111,108,44,32,117,115,101,114,100,
97,116,97,41,58,10,
// '    filename = ffi.string(word[2])\n
32,32,32,32,102,105,108,101,110,97,109,101,32,61,32,102,102,105,46,115,116,114,
105,110,103,40,119,111,114,100,91,50,93,41,10,
// "    if filename.endswith(b'.py'):\n
32,32,32,32,105,102,32,102,105,108,101,110,97,109,101,46,101,110,100,115,119,
105,116,104,40,98,39,46,112,121,39,41,58,10,
// '        load_filename(__decode(filename))\n
32,32,32,32,32,32,32,32,108,111,97,100,95,102,105,108,101,110,97,109,101,40,
95,95,100,101,99,111,100,101,40,102,105,108,101,110,97,109,101,41,41,10,
// '        return 3\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,51,10,
// '\n
10,
// '    return 0\n
32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_unload_command(word, word_eol, userdata):\n
100,101,102,32,95,111,110,95,117,110,108,111,97,100,95,99,111,109,109,97,110,
100,40,119,111,114,100,44,32,119,111,114,100,95,101,111,108,44,32,117,115,101,
114,100,97,116,97,41,58,10,
// '    filename = ffi.string(word[2])\n
32,32,32,32,102,105,108,101,110,97,109,101,32,61,32,102,102,105,46,115,116,114,
105,110,103,40,119,111,114,100,91,50,93,41,10,
// "    if filename.endswith(b'.py'):\n
32,32,32,32,105,102,32,102,105,108,101,110,97,109,101,46,101,110,100,115,119,
105,116,104,40,98,39,46,112,121,39,41,58,10,
// '        unload_name(__decode(filename))\n
32,32,32,32,32,32,32,32,117,110,108,111,97,100,95,110,97,109,101,40,95,95,100,
101,99,111,100,101,40,102,105,108,101,110,97,109,101,41,41,10,
// '        return 3\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,51,10,
// '\n
10,
// '    return 0\n
32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_reload_command(word, word_eol, userdata):\n
100,101,102,32,95,111,110,95,114,101,108,111,97,100,95,99,111,109,109,97,110,
100,40,119,111,114,100,44,32,119,111,114,100,95,101,111,108,44,32,117,115,101,
114,100,97,116,97,41,58,10,
// '    filename = ffi.string(word[2])\n
32,32,32,32,102,105,108,101,110,97,109,101,32,61,32,102,102,105,46,115,116,114,
105,110,103,40,119,111,114,100,91,50,93,41,10,
// "    if filename.endswith(b'.py'):\n
32,32,32,32,105,102,32,102,105,108,101,110,97,109,101,46,101,110,100,115,119,
105,116,104,40,98,39,46,112,121,39,41,58,10,
// '        reload_name(__decode(filename))\n
32,32,32,32,32,32,32,32,114,101,108,111,97,100,95,110,97,109,101,40,95,95,100,
101,99,111,100,101,40,102,105,108,101,110,97,109,101,41,41,10,
// '        return 3\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,51,10,
// '\n
10,
// '    return 0\n
32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern(error=3)\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,101,114,114,111,
114,61,51,41,10,
// 'def _on_py_command(word, word_eol, userdata):\n
100,101,102,32,95,111,110,95,112,121,95,99,111,109,109,97,110,100,40,119,111,
114,100,44,32,119,111,114,100,95,101,111,108,44,32,117,115,101,114,100,97,116,
97,41,58,10,
// '    subcmd = __decode(ffi.string(word[2])).lower()\n
32,32,32,32,115,117,98,99,109,100,32,61,32,95,95,100,101,99,111,100,101,40,102,
102,105,46,115,116,114,105,110,103,40,119,111,114,100,91,50,93,41,41,46,108,
111,119,101,114,40,41,10,
// '\n
10,
// "    if subcmd == 'exec':\n
32,32,32,32,105,102,32,115,117,98,99,109,100,32,61,61,32,39,101,120,101,99,39,
58,10,
// '        python = __decode(ffi.string(word_eol[3]))\n
32,32,32,32,32,32,32,32,112,121,116,104,111,110,32,61,32,95,95,100,101,99,111,
100,101,40,102,102,105,46,115,116,114,105,110,103,40,119,111,114,100,95,101,
111,108,91,51,93,41,41,10,
// '        exec_in_interp(python)\n
32,32,32,32,32,32,32,32,101,120,101,99,95,105,110,95,105,110,116,101,114,112,
40,112,121,116,104,111,110,41,10,
// '\n
10,
// "    elif subcmd == 'load':\n
32,32,32,32,101,108,105,102,32,115,117,98,99,109,100,32,61,61,32,39,108,111,
97,100,39,58,10,
// '        filename = __decode(ffi.string(word[3]))\n
32,32,32,32,32,32,32,32,102,105,108,101,110,97,109,101,32,61,32,95,95,100,101,
99,111,100,101,40,102,102,105,46,115,116,114,105,110,103,40,119,111,114,100,
91,51,93,41,41,10,
// '        load_filename(filename)\n
32,32,32,32,32,32,32,32,108,111,97,100,95,102,105,108,101,110,97,109,101,40,
102,105,108,101,110,97,109,101,41,10,
// '\n
10,
// "    elif subcmd == 'unload':\n
32,32,32,32,101,108,105,102,32,115,117,98,99,109,100,32,61,61,32,39,117,110,
108,111,97,100,39,58,10,
// '        name = __decode(ffi.string(word[3]))\n
32,32,32,32,32,32,32,32,110,97,109,101,32,61,32,95,95,100,101,99,111,100,101,
40,102,102,105,46,115,116,114,105,110,103,40,119,111,114,100,91,51,93,41,41,
10,
// '        if not unload_name(name):\n
32,32,32,32,32,32,32,32,105,102,32,110,111,116,32,117,110,108,111,97,100,95,
110,97,109,101,40,110,97,109,101,41,58,10,
// "            lib.hexchat_print(lib.ph, b'Can\\'t find a python plugin with that name')\n
32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,
95,112,114,105,110,116,40,108,105,98,46,112,104,44,32,98,39,67,97,110,92,39,
116,32,102,105,110,100,32,97,32,112,121,116,104,111,110,32,112,108,117,103,105,
110,32,119,105,116,104,32,116,104,97,116,32,110,97,109,101,39,41,10,
// '\n
10,
// "    elif subcmd == 'reload':\n
32,32,32,32,101,108,105,102,32,115,117,98,99,109,100,32,61,61,32,39,114,101,
108,111,97,100,39,58,10,
// '        name = __decode(ffi.string(word[3]))\n
32,32,32,32,32,32,32,32,110,97,109,101,32,61,32,95,95,100,101,99,111,100,101,
40,102,102,105,46,115,116,114,105,110,103,40,119,111,114,100,91,51,93,41,41,
10,
// '        if not reload_name(name):\n
32,32,32,32,32,32,32,32,105,102,32,110,111,116,32,114,101,108,111,97,100,95,
110,97,109,101,40,110,97,109,101,41,58,10,
// "            lib.hexchat_print(lib.ph, b'Can\\'t find a python plugin with that name')\n
32,32,32,32,32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,
95,112,114,105,110,116,40,108,105,98,46,112,104,44,32,98,39,67,97,110,92,39,
116,32,102,105,110,100,32,97,32,112,121,116,104,111,110,32,112,108,117,103,105,
110,32,119,105,116,104,32,116,104,97,116,32,110,97,109,101,39,41,10,
// '\n
10,
// "    elif subcmd == 'console':\n
32,32,32,32,101,108,105,102,32,115,117,98,99,109,100,32,61,61,32,39,99,111,110,
115,111,108,101,39,58,10,
// "        lib.hexchat_command(lib.ph, b'QUERY >>python<<')\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,99,111,109,
109,97,110,100,40,108,105,98,46,112,104,44,32,98,39,81,85,69,82,89,32,62,62,
112,121,116,104,111,110,60,60,39,41,10,
// '\n
10,
// "    elif subcmd == 'list':\n
32,32,32,32,101,108,105,102,32,115,117,98,99,109,100,32,61,61,32,39,108,105,
115,116,39,58,10,
// '        list_plugins()\n
32,32,32,32,32,32,32,32,108,105,115,116,95,112,108,117,103,105,110,115,40,41,
10,
// '\n
10,
// "    elif subcmd == 'about':\n
32,32,32,32,101,108,105,102,32,115,117,98,99,109,100,32,61,61,32,39,97,98,111,
117,116,39,58,10,
// "        lib.hexchat_print(lib.ph, b'HexChat Python interface version ' + VERSION)\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,
110,116,40,108,105,98,46,112,104,44,32,98,39,72,101,120,67,104,97,116,32,80,
121,116,104,111,110,32,105,110,116,101,114,102,97,99,101,32,118,101,114,115,
105,111,110,32,39,32,43,32,86,69,82,83,73,79,78,41,10,
// '\n
10,
// '    else:\n
32,32,32,32,101,108,115,101,58,10,
// "        lib.hexchat_command(lib.ph, b'HELP PY')\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,99,111,109,
109,97,110,100,40,108,105,98,46,112,104,44,32,98,39,72,69,76,80,32,80,89,39,
41,10,
// '\n
10,
// '    return 3\n
32,32,32,32,114,101,116,117,114,110,32,51,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_plugin_init(plugin_name, plugin_desc, plugin_version, arg, libdir):\n
100,101,102,32,95,111,110,95,112,108,117,103,105,110,95,105,110,105,116,40,112,
108,117,103,105,110,95,110,97,109,101,44,32,112,108,117,103,105,110,95,100,101,
115,99,44,32,112,108,117,103,105,110,95,118,101,114,115,105,111,110,44,32,97,
114,103,44,32,108,105,98,100,105,114,41,58,10,
// '    global hexchat\n
32,32,32,32,103,108,111,98,97,108,32,104,101,120,99,104,97,116,10,
// '    global hexchat_stdout\n
32,32,32,32,103,108,111,98,97,108,32,104,101,120,99,104,97,116,95,115,116,100,
111,117,116,10,
// '\n
10,
// '    signal.signal(signal.SIGINT, signal.SIG_DFL)\n
32,32,32,32,115,105,103,110,97,108,46,115,105,103,110,97,108,40,115,105,103,
110,97,108,46,83,73,71,73,78,84,44,32,115,105,103,110,97,108,46,83,73,71,95,
68,70,76,41,10,
// '\n
10,
// '    plugin_name[0] = PLUGIN_NAME\n
32,32,32,32,112,108,117,103,105,110,95,110,97,109,101,91,48,93,32,61,32,80,76,
85,71,73,78,95,78,65,77,69,10,
// '    plugin_desc[0] = PLUGIN_DESC\n
32,32,32,32,112,108,117,103,105,110,95,100,101,115,99,91,48,93,32,61,32,80,76,
85,71,73,78,95,68,69,83,67,10,
// '    plugin_version[0] = PLUGIN_VERSION\n
32,32,32,32,112,108,117,103,105,110,95,118,101,114,115,105,111,110,91,48,93,
32,61,32,80,76,85,71,73,78,95,86,69,82,83,73,79,78,10,
// '\n
10,
// '    try:\n
32,32,32,32,116,114,121,58,10,
// '        libdir = __decode(ffi.string(libdir))\n
32,32,32,32,32,32,32,32,108,105,98,100,105,114,32,61,32,95,95,100,101,99,111,
100,101,40,102,102,105,46,115,116,114,105,110,103,40,108,105,98,100,105,114,
41,41,10,
// "        modpath = os.path.join(libdir, '..', 'python')\n
32,32,32,32,32,32,32,32,109,111,100,112,97,116,104,32,61,32,111,115,46,112,97,
116,104,46,106,111,105,110,40,108,105,98,100,105,114,44,32,39,46,46,39,44,32,
39,112,121,116,104,111,110,39,41,10,
// '        sys.path.append(os.path.abspath(modpath))\n
32,32,32,32,32,32,32,32,115,121,115,46,112,97,116,104,46,97,112,112,101,110,
100,40,111,115,46,112,97,116,104,46,97,98,115,112,97,116,104,40,109,111,100,
112,97,116,104,41,41,10,
// "        hexchat = importlib.import_module('hexchat')\n
32,32,32,32,32,32,32,32,104,101,120,99,104,97,116,32,61,32,105,109,112,111,114,
116,108,105,98,46,105,109,112,111,114,116,95,109,111,100,117,108,101,40,39,104,
101,120,99,104,97,116,39,41,10,
// '\n
10,
// '    except (UnicodeDecodeError, ImportError) as e:\n
32,32,32,32,101,120,99,101,112,116,32,40,85,110,105,99,111,100,101,68,101,99,
111,100,101,69,114,114,111,114,44,32,73,109,112,111,114,116,69,114,114,111,114,
41,32,97,115,32,101,58,10,
// "        lib.hexchat_print(lib.ph, b'Failed to import module: ' + repr(e).encode())\n
32,32,32,32,32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,
110,116,40,108,105,98,46,112,104,44,32,98,39,70,97,105,108,101,100,32,116,111,
32,105,109,112,111,114,116,32,109,111,100,117,108,101,58,32,39,32,43,32,114,
101,112,114,40,101,41,46,101,110,99,111,100,101,40,41,41,10,
// '\n
10,
// '        return 0\n
32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,48,10,
// '\n
10,
// '    hexchat_stdout = Stdout()\n
32,32,32,32,104,101,120,99,104,97,116,95,115,116,100,111,117,116,32,61,32,83,
116,100,111,117,116,40,41,10,
// '    sys.stdout = hexchat_stdout\n
32,32,32,32,115,121,115,46,115,116,100,111,117,116,32,61,32,104,101,120,99,104,
97,116,95,115,116,100,111,117,116,10,
// '    sys.stderr = hexchat_stdout\n
32,32,32,32,115,121,115,46,115,116,100,101,114,114,32,61,32,104,101,120,99,104,
97,116,95,115,116,100,111,117,116,10,
// '    pydoc.help = pydoc.Helper(HelpEater(), HelpEater())\n
32,32,32,32,112,121,100,111,99,46,104,101,108,112,32,61,32,112,121,100,111,99,
46,72,101,108,112,101,114,40,72,101,108,112,69,97,116,101,114,40,41,44,32,72,
101,108,112,69,97,116,101,114,40,41,41,10,
// '\n
10,
// "    lib.hexchat_hook_command(lib.ph, b'', 0, lib._on_say_command, ffi.NULL, ffi.NULL)\n
32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,104,111,111,107,95,99,
111,109,109,97,110,100,40,108,105,98,46,112,104,44,32,98,39,39,44,32,48,44,32,
108,105,98,46,95,111,110,95,115,97,121,95,99,111,109,109,97,110,100,44,32,102,
102,105,46,78,85,76,76,44,32,102,102,105,46,78,85,76,76,41,10,
// "    lib.hexchat_hook_command(lib.ph, b'LOAD', 0, lib._on_load_command, ffi.NULL, ffi.NULL)\n
32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,104,111,111,107,95,99,
111,109,109,97,110,100,40,108,105,98,46,112,104,44,32,98,39,76,79,65,68,39,44,
32,48,44,32,108,105,98,46,95,111,110,95,108,111,97,100,95,99,111,109,109,97,
110,100,44,32,102,102,105,46,78,85,76,76,44,32,102,102,105,46,78,85,76,76,41,
10,
// "    lib.hexchat_hook_command(lib.ph, b'UNLOAD', 0, lib._on_unload_command, ffi.NULL, ffi.NULL)\n
32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,104,111,111,107,95,99,
111,109,109,97,110,100,40,108,105,98,46,112,104,44,32,98,39,85,78,76,79,65,68,
39,44,32,48,44,32,108,105,98,46,95,111,110,95,117,110,108,111,97,100,95,99,111,
109,109,97,110,100,44,32,102,102,105,46,78,85,76,76,44,32,102,102,105,46,78,
85,76,76,41,10,
// "    lib.hexchat_hook_command(lib.ph, b'RELOAD', 0, lib._on_reload_command, ffi.NULL, ffi.NULL)\n
32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,104,111,111,107,95,99,
111,109,109,97,110,100,40,108,105,98,46,112,104,44,32,98,39,82,69,76,79,65,68,
39,44,32,48,44,32,108,105,98,46,95,111,110,95,114,101,108,111,97,100,95,99,111,
109,109,97,110,100,44,32,102,102,105,46,78,85,76,76,44,32,102,102,105,46,78,
85,76,76,41,10,
// "    lib.hexchat_hook_command(lib.ph, b'PY', 0, lib._on_py_command, b'''Usage: /PY LOAD   <filename>\n
32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,104,111,111,107,95,99,
111,109,109,97,110,100,40,108,105,98,46,112,104,44,32,98,39,80,89,39,44,32,48,
44,32,108,105,98,46,95,111,110,95,112,121,95,99,111,109,109,97,110,100,44,32,
98,39,39,39,85,115,97,103,101,58,32,47,80,89,32,76,79,65,68,32,32,32,60,102,
105,108,101,110,97,109,101,62,10,
// '           UNLOAD <filename|name>\n
32,32,32,32,32,32,32,32,32,32,32,85,78,76,79,65,68,32,60,102,105,108,101,110,
97,109,101,124,110,97,109,101,62,10,
// '           RELOAD <filename|name>\n
32,32,32,32,32,32,32,32,32,32,32,82,69,76,79,65,68,32,60,102,105,108,101,110,
97,109,101,124,110,97,109,101,62,10,
// '           LIST\n
32,32,32,32,32,32,32,32,32,32,32,76,73,83,84,10,
// '           EXEC <command>\n
32,32,32,32,32,32,32,32,32,32,32,69,88,69,67,32,60,99,111,109,109,97,110,100,
62,10,
// '           CONSOLE\n
32,32,32,32,32,32,32,32,32,32,32,67,79,78,83,79,76,69,10,
// "           ABOUT''', ffi.NULL)\n
32,32,32,32,32,32,32,32,32,32,32,65,66,79,85,84,39,39,39,44,32,102,102,105,46,
78,85,76,76,41,10,
// '\n
10,
// "    lib.hexchat_print(lib.ph, b'Python interface loaded')\n
32,32,32,32,108,105,98,46,104,101,120,99,104,97,116,95,112,114,105,110,116,40,
108,105,98,46,112,104,44,32,98,39,80,121,116,104,111,110,32,105,110,116,101,
114,102,97,99,101,32,108,111,97,100,101,100,39,41,10,
// '    autoload()\n
32,32,32,32,97,117,116,111,108,111,97,100,40,41,10,
// '    return 1\n
32,32,32,32,114,101,116,117,114,110,32,49,10,
// '\n
10,
// '\n
10,
// '@ffi.def_extern()\n
64,102,102,105,46,100,101,102,95,101,120,116,101,114,110,40,41,10,
// 'def _on_plugin_deinit():\n
100,101,102,32,95,111,110,95,112,108,117,103,105,110,95,100,101,105,110,105,
116,40,41,58,10,
// '    global local_interp\n
32,32,32,32,103,108,111,98,97,108,32,108,111,99,97,108,95,105,110,116,101,114,
112,10,
// '    global hexchat\n
32,32,32,32,103,108,111,98,97,108,32,104,101,120,99,104,97,116,10,
// '    global hexchat_stdout\n
32,32,32,32,103,108,111,98,97,108,32,104,101,120,99,104,97,116,95,115,116,100,
111,117,116,10,
// '    global plugins\n
32,32,32,32,103,108,111,98,97,108,32,112,108,117,103,105,110,115,10,
// '\n
10,
// '    plugins = set()\n
32,32,32,32,112,108,117,103,105,110,115,32,61,32,115,101,116,40,41,10,
// '    local_interp = None\n
32,32,32,32,108,111,99,97,108,95,105,110,116,101,114,112,32,61,32,78,111,110,
101,10,
// '    hexchat = None\n
32,32,32,32,104,101,120,99,104,97,116,32,61,32,78,111,110,101,10,
// '    hexchat_stdout = None\n
32,32,32,32,104,101,120,99,104,97,116,95,115,116,100,111,117,116,32,61,32,78,
111,110,101,10,
// '    sys.stdout = sys.__stdout__\n
32,32,32,32,115,121,115,46,115,116,100,111,117,116,32,61,32,115,121,115,46,95,
95,115,116,100,111,117,116,95,95,10,
// '    sys.stderr = sys.__stderr__\n
32,32,32,32,115,121,115,46,115,116,100,101,114,114,32,61,32,115,121,115,46,95,
95,115,116,100,101,114,114,95,95,10,
// '    pydoc.help = pydoc.Helper()\n
32,32,32,32,112,121,100,111,99,46,104,101,108,112,32,61,32,112,121,100,111,99,
46,72,101,108,112,101,114,40,41,10,
// '\n
10,
// "    for mod in ('_hexchat', 'hexchat', 'xchat', '_hexchat_embedded'):\n
32,32,32,32,102,111,114,32,109,111,100,32,105,110,32,40,39,95,104,101,120,99,
104,97,116,39,44,32,39,104,101,120,99,104,97,116,39,44,32,39,120,99,104,97,116,
39,44,32,39,95,104,101,120,99,104,97,116,95,101,109,98,101,100,100,101,100,39,
41,58,10,
// '        try:\n
32,32,32,32,32,32,32,32,116,114,121,58,10,
// '            del sys.modules[mod]\n
32,32,32,32,32,32,32,32,32,32,32,32,100,101,108,32,115,121,115,46,109,111,100,
117,108,101,115,91,109,111,100,93,10,
// '\n
10,
// '        except KeyError:\n
32,32,32,32,32,32,32,32,101,120,99,101,112,116,32,75,101,121,69,114,114,111,
114,58,10,
// '            pass\n
32,32,32,32,32,32,32,32,32,32,32,32,112,97,115,115,10,
// '\n
10,
// '    return 1\n
32,32,32,32,114,101,116,117,114,110,32,49,10,
0 };
#ifdef PYPY_VERSION
# define _CFFI_PYTHON_STARTUP_FUNC  _cffi_pypyinit__hexchat_embedded
#elif PY_MAJOR_VERSION >= 3
# define _CFFI_PYTHON_STARTUP_FUNC  PyInit__hexchat_embedded
#else
# define _CFFI_PYTHON_STARTUP_FUNC  init_hexchat_embedded
#endif

/***** Support code for embedding *****/

#ifdef __cplusplus
extern "C" {
#endif


#if defined(_WIN32)
#  define CFFI_DLLEXPORT  __declspec(dllexport)
#elif defined(__GNUC__)
#  define CFFI_DLLEXPORT  __attribute__((visibility("default")))
#else
#  define CFFI_DLLEXPORT  /* nothing */
#endif


/* There are two global variables of type _cffi_call_python_fnptr:

   * _cffi_call_python, which we declare just below, is the one called
     by ``extern "Python"`` implementations.

   * _cffi_call_python_org, which on CPython is actually part of the
     _cffi_exports[] array, is the function pointer copied from
     _cffi_backend.  If _cffi_start_python() fails, then this is set
     to NULL; otherwise, it should never be NULL.

   After initialization is complete, both are equal.  However, the
   first one remains equal to &_cffi_start_and_call_python until the
   very end of initialization, when we are (or should be) sure that
   concurrent threads also see a completely initialized world, and
   only then is it changed.
*/
#undef _cffi_call_python
typedef void (*_cffi_call_python_fnptr)(struct _cffi_externpy_s *, char *);
static void _cffi_start_and_call_python(struct _cffi_externpy_s *, char *);
static _cffi_call_python_fnptr _cffi_call_python = &_cffi_start_and_call_python;


#ifndef _MSC_VER
   /* --- Assuming a GCC not infinitely old --- */
# define cffi_compare_and_swap(l,o,n)  __sync_bool_compare_and_swap(l,o,n)
# define cffi_write_barrier()          __sync_synchronize()
# if !defined(__amd64__) && !defined(__x86_64__) &&   \
     !defined(__i386__) && !defined(__i386)
#   define cffi_read_barrier()         __sync_synchronize()
# else
#   define cffi_read_barrier()         (void)0
# endif
#else
   /* --- Windows threads version --- */
# include <Windows.h>
# define cffi_compare_and_swap(l,o,n) \
                               (InterlockedCompareExchangePointer(l,n,o) == (o))
# define cffi_write_barrier()       InterlockedCompareExchange(&_cffi_dummy,0,0)
# define cffi_read_barrier()           (void)0
static volatile LONG _cffi_dummy;
#endif

#ifdef WITH_THREAD
# ifndef _MSC_VER
#  include <pthread.h>
   static pthread_mutex_t _cffi_embed_startup_lock;
# else
   static CRITICAL_SECTION _cffi_embed_startup_lock;
# endif
  static char _cffi_embed_startup_lock_ready = 0;
#endif

static void _cffi_acquire_reentrant_mutex(void)
{
    static void *volatile lock = NULL;

    while (!cffi_compare_and_swap(&lock, NULL, (void *)1)) {
        /* should ideally do a spin loop instruction here, but
           hard to do it portably and doesn't really matter I
           think: pthread_mutex_init() should be very fast, and
           this is only run at start-up anyway. */
    }

#ifdef WITH_THREAD
    if (!_cffi_embed_startup_lock_ready) {
# ifndef _MSC_VER
        pthread_mutexattr_t attr;
        pthread_mutexattr_init(&attr);
        pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
        pthread_mutex_init(&_cffi_embed_startup_lock, &attr);
# else
        InitializeCriticalSection(&_cffi_embed_startup_lock);
# endif
        _cffi_embed_startup_lock_ready = 1;
    }
#endif

    while (!cffi_compare_and_swap(&lock, (void *)1, NULL))
        ;

#ifndef _MSC_VER
    pthread_mutex_lock(&_cffi_embed_startup_lock);
#else
    EnterCriticalSection(&_cffi_embed_startup_lock);
#endif
}

static void _cffi_release_reentrant_mutex(void)
{
#ifndef _MSC_VER
    pthread_mutex_unlock(&_cffi_embed_startup_lock);
#else
    LeaveCriticalSection(&_cffi_embed_startup_lock);
#endif
}


/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION

#ifndef CFFI_MESSAGEBOX
# ifdef _MSC_VER
#  define CFFI_MESSAGEBOX  1
# else
#  define CFFI_MESSAGEBOX  0
# endif
#endif


#if CFFI_MESSAGEBOX
/* Windows only: logic to take the Python-CFFI embedding logic
   initialization errors and display them in a background thread
   with MessageBox.  The idea is that if the whole program closes
   as a result of this problem, then likely it is already a console
   program and you can read the stderr output in the console too.
   If it is not a console program, then it will likely show its own
   dialog to complain, or generally not abruptly close, and for this
   case the background thread should stay alive.
*/
static void *volatile _cffi_bootstrap_text;

static PyObject *_cffi_start_error_capture(void)
{
    PyObject *result = NULL;
    PyObject *x, *m, *bi;

    if (InterlockedCompareExchangePointer(&_cffi_bootstrap_text,
            (void *)1, NULL) != NULL)
        return (PyObject *)1;

    m = PyImport_AddModule("_cffi_error_capture");
    if (m == NULL)
        goto error;

    result = PyModule_GetDict(m);
    if (result == NULL)
        goto error;

#if PY_MAJOR_VERSION >= 3
    bi = PyImport_ImportModule("builtins");
#else
    bi = PyImport_ImportModule("__builtin__");
#endif
    if (bi == NULL)
        goto error;
    PyDict_SetItemString(result, "__builtins__", bi);
    Py_DECREF(bi);

    x = PyRun_String(
        "import sys\n"
        "class FileLike:\n"
        "  def write(self, x):\n"
        "    try:\n"
        "      of.write(x)\n"
        "    except: pass\n"
        "    self.buf += x\n"
        "  def flush(self):\n"
        "    pass\n"
        "fl = FileLike()\n"
        "fl.buf = ''\n"
        "of = sys.stderr\n"
        "sys.stderr = fl\n"
        "def done():\n"
        "  sys.stderr = of\n"
        "  return fl.buf\n",   /* make sure the returned value stays alive */
        Py_file_input,
        result, result);
    Py_XDECREF(x);

 error:
    if (PyErr_Occurred())
    {
        PyErr_WriteUnraisable(Py_None);
        PyErr_Clear();
    }
    return result;
}

#pragma comment(lib, "user32.lib")

static DWORD WINAPI _cffi_bootstrap_dialog(LPVOID ignored)
{
    Sleep(666);    /* may be interrupted if the whole process is closing */
#if PY_MAJOR_VERSION >= 3
    MessageBoxW(NULL, (wchar_t *)_cffi_bootstrap_text,
                L"Python-CFFI error",
                MB_OK | MB_ICONERROR);
#else
    MessageBoxA(NULL, (char *)_cffi_bootstrap_text,
                "Python-CFFI error",
                MB_OK | MB_ICONERROR);
#endif
    _cffi_bootstrap_text = NULL;
    return 0;
}

static void _cffi_stop_error_capture(PyObject *ecap)
{
    PyObject *s;
    void *text;

    if (ecap == (PyObject *)1)
        return;

    if (ecap == NULL)
        goto error;

    s = PyRun_String("done()", Py_eval_input, ecap, ecap);
    if (s == NULL)
        goto error;

    /* Show a dialog box, but in a background thread, and
       never show multiple dialog boxes at once. */
#if PY_MAJOR_VERSION >= 3
    text = PyUnicode_AsWideCharString(s, NULL);
#else
    text = PyString_AsString(s);
#endif

    _cffi_bootstrap_text = text;

    if (text != NULL)
    {
        HANDLE h;
        h = CreateThread(NULL, 0, _cffi_bootstrap_dialog,
                         NULL, 0, NULL);
        if (h != NULL)
            CloseHandle(h);
    }
    /* decref the string, but it should stay alive as 'fl.buf'
       in the small module above.  It will really be freed only if
       we later get another similar error.  So it's a leak of at
       most one copy of the small module.  That's fine for this
       situation which is usually a "fatal error" anyway. */
    Py_DECREF(s);
    PyErr_Clear();
    return;

  error:
    _cffi_bootstrap_text = NULL;
    PyErr_Clear();
}

#else

static PyObject *_cffi_start_error_capture(void) { return NULL; }
static void _cffi_stop_error_capture(PyObject *ecap) { }

#endif


#define _cffi_call_python_org  _cffi_exports[_CFFI_CPIDX]

PyMODINIT_FUNC _CFFI_PYTHON_STARTUP_FUNC(void);   /* forward */

static void _cffi_py_initialize(void)
{
    /* XXX use initsigs=0, which "skips initialization registration of
       signal handlers, which might be useful when Python is
       embedded" according to the Python docs.  But review and think
       if it should be a user-controllable setting.

       XXX we should also give a way to write errors to a buffer
       instead of to stderr.

       XXX if importing 'site' fails, CPython (any version) calls
       exit().  Should we try to work around this behavior here?
    */
    Py_InitializeEx(0);
}

static int _cffi_initialize_python(void)
{
    /* This initializes Python, imports _cffi_backend, and then the
       present .dll/.so is set up as a CPython C extension module.
    */
    int result;
    PyGILState_STATE state;
    PyObject *pycode=NULL, *global_dict=NULL, *x;
    PyObject *builtins;

    state = PyGILState_Ensure();

    /* Call the initxxx() function from the present module.  It will
       create and initialize us as a CPython extension module, instead
       of letting the startup Python code do it---it might reimport
       the same .dll/.so and get maybe confused on some platforms.
       It might also have troubles locating the .dll/.so again for all
       I know.
    */
    (void)_CFFI_PYTHON_STARTUP_FUNC();
    if (PyErr_Occurred())
        goto error;

    /* Now run the Python code provided to ffi.embedding_init_code().
     */
    pycode = Py_CompileString(_CFFI_PYTHON_STARTUP_CODE,
                              "<init code for '" _CFFI_MODULE_NAME "'>",
                              Py_file_input);
    if (pycode == NULL)
        goto error;
    global_dict = PyDict_New();
    if (global_dict == NULL)
        goto error;
    builtins = PyEval_GetBuiltins();
    if (builtins == NULL)
        goto error;
    if (PyDict_SetItemString(global_dict, "__builtins__", builtins) < 0)
        goto error;
    x = PyEval_EvalCode(
#if PY_MAJOR_VERSION < 3
                        (PyCodeObject *)
#endif
                        pycode, global_dict, global_dict);
    if (x == NULL)
        goto error;
    Py_DECREF(x);

    /* Done!  Now if we've been called from
       _cffi_start_and_call_python() in an ``extern "Python"``, we can
       only hope that the Python code did correctly set up the
       corresponding @ffi.def_extern() function.  Otherwise, the
       general logic of ``extern "Python"`` functions (inside the
       _cffi_backend module) will find that the reference is still
       missing and print an error.
     */
    result = 0;
 done:
    Py_XDECREF(pycode);
    Py_XDECREF(global_dict);
    PyGILState_Release(state);
    return result;

 error:;
    {
        /* Print as much information as potentially useful.
           Debugging load-time failures with embedding is not fun
        */
        PyObject *ecap;
        PyObject *exception, *v, *tb, *f, *modules, *mod;
        PyErr_Fetch(&exception, &v, &tb);
        ecap = _cffi_start_error_capture();
        f = PySys_GetObject((char *)"stderr");
        if (f != NULL && f != Py_None) {
            PyFile_WriteString(
                "Failed to initialize the Python-CFFI embedding logic:\n\n", f);
        }

        if (exception != NULL) {
            PyErr_NormalizeException(&exception, &v, &tb);
            PyErr_Display(exception, v, tb);
        }
        Py_XDECREF(exception);
        Py_XDECREF(v);
        Py_XDECREF(tb);

        if (f != NULL && f != Py_None) {
            PyFile_WriteString("\nFrom: " _CFFI_MODULE_NAME
                               "\ncompiled with cffi version: 1.17.1"
                               "\n_cffi_backend module: ", f);
            modules = PyImport_GetModuleDict();
            mod = PyDict_GetItemString(modules, "_cffi_backend");
            if (mod == NULL) {
                PyFile_WriteString("not loaded", f);
            }
            else {
                v = PyObject_GetAttrString(mod, "__file__");
                PyFile_WriteObject(v, f, 0);
                Py_XDECREF(v);
            }
            PyFile_WriteString("\nsys.path: ", f);
            PyFile_WriteObject(PySys_GetObject((char *)"path"), f, 0);
            PyFile_WriteString("\n\n", f);
        }
        _cffi_stop_error_capture(ecap);
    }
    result = -1;
    goto done;
}

#if PY_VERSION_HEX < 0x03080000
PyAPI_DATA(char *) _PyParser_TokenNames[];  /* from CPython */
#endif

static int _cffi_carefully_make_gil(void)
{
    /* This does the basic initialization of Python.  It can be called
       completely concurrently from unrelated threads.  It assumes
       that we don't hold the GIL before (if it exists), and we don't
       hold it afterwards.

       (What it really does used to be completely different in Python 2
       and Python 3, with the Python 2 solution avoiding the spin-lock
       around the Py_InitializeEx() call.  However, after recent changes
       to CPython 2.7 (issue #358) it no longer works.  So we use the
       Python 3 solution everywhere.)

       This initializes Python by calling Py_InitializeEx().
       Important: this must not be called concurrently at all.
       So we use a global variable as a simple spin lock.  This global
       variable must be from 'libpythonX.Y.so', not from this
       cffi-based extension module, because it must be shared from
       different cffi-based extension modules.

       In Python < 3.8, we choose
       _PyParser_TokenNames[0] as a completely arbitrary pointer value
       that is never written to.  The default is to point to the
       string "ENDMARKER".  We change it temporarily to point to the
       next character in that string.  (Yes, I know it's REALLY
       obscure.)

       In Python >= 3.8, this string array is no longer writable, so
       instead we pick PyCapsuleType.tp_version_tag.  We can't change
       Python < 3.8 because someone might use a mixture of cffi
       embedded modules, some of which were compiled before this file
       changed.

       In Python >= 3.12, this stopped working because that particular
       tp_version_tag gets modified during interpreter startup.  It's
       arguably a bad idea before 3.12 too, but again we can't change
       that because someone might use a mixture of cffi embedded
       modules, and no-one reported a bug so far.  In Python >= 3.12
       we go instead for PyCapsuleType.tp_as_buffer, which is supposed
       to always be NULL.  We write to it temporarily a pointer to
       a struct full of NULLs, which is semantically the same.
    */

#ifdef WITH_THREAD
# if PY_VERSION_HEX < 0x03080000
    char *volatile *lock = (char *volatile *)_PyParser_TokenNames;
    char *old_value, *locked_value;

    while (1) {    /* spin loop */
        old_value = *lock;
        locked_value = old_value + 1;
        if (old_value[0] == 'E') {
            assert(old_value[1] == 'N');
            if (cffi_compare_and_swap(lock, old_value, locked_value))
                break;
        }
        else {
            assert(old_value[0] == 'N');
            /* should ideally do a spin loop instruction here, but
               hard to do it portably and doesn't really matter I
               think: PyEval_InitThreads() should be very fast, and
               this is only run at start-up anyway. */
        }
    }
# else
#  if PY_VERSION_HEX < 0x030C0000
    int volatile *lock = (int volatile *)&PyCapsule_Type.tp_version_tag;
    int old_value, locked_value = -42;
    assert(!(PyCapsule_Type.tp_flags & Py_TPFLAGS_HAVE_VERSION_TAG));
#  else
    static struct ebp_s { PyBufferProcs buf; int mark; } empty_buffer_procs;
    empty_buffer_procs.mark = -42;
    PyBufferProcs *volatile *lock = (PyBufferProcs *volatile *)
        &PyCapsule_Type.tp_as_buffer;
    PyBufferProcs *old_value, *locked_value = &empty_buffer_procs.buf;
#  endif

    while (1) {    /* spin loop */
        old_value = *lock;
        if (old_value == 0) {
            if (cffi_compare_and_swap(lock, old_value, locked_value))
                break;
        }
        else {
#  if PY_VERSION_HEX < 0x030C0000
            assert(old_value == locked_value);
#  else
            /* The pointer should point to a possibly different
               empty_buffer_procs from another C extension module */
            assert(((struct ebp_s *)old_value)->mark == -42);
#  endif
            /* should ideally do a spin loop instruction here, but
               hard to do it portably and doesn't really matter I
               think: PyEval_InitThreads() should be very fast, and
               this is only run at start-up anyway. */
        }
    }
# endif
#endif

    /* call Py_InitializeEx() */
    if (!Py_IsInitialized()) {
        _cffi_py_initialize();
#if PY_VERSION_HEX < 0x03070000
        PyEval_InitThreads();
#endif
        PyEval_SaveThread();  /* release the GIL */
        /* the returned tstate must be the one that has been stored into the
           autoTLSkey by _PyGILState_Init() called from Py_Initialize(). */
    }
    else {
#if PY_VERSION_HEX < 0x03070000
        /* PyEval_InitThreads() is always a no-op from CPython 3.7 */
        PyGILState_STATE state = PyGILState_Ensure();
        PyEval_InitThreads();
        PyGILState_Release(state);
#endif
    }

#ifdef WITH_THREAD
    /* release the lock */
    while (!cffi_compare_and_swap(lock, locked_value, old_value))
        ;
#endif

    return 0;
}

/**********  end CPython-specific section  **********/


#else


/**********  PyPy-specific section  **********/

PyMODINIT_FUNC _CFFI_PYTHON_STARTUP_FUNC(const void *[]);   /* forward */

static struct _cffi_pypy_init_s {
    const char *name;
    void *func;    /* function pointer */
    const char *code;
} _cffi_pypy_init = {
    _CFFI_MODULE_NAME,
    _CFFI_PYTHON_STARTUP_FUNC,
    _CFFI_PYTHON_STARTUP_CODE,
};

extern int pypy_carefully_make_gil(const char *);
extern int pypy_init_embedded_cffi_module(int, struct _cffi_pypy_init_s *);

static int _cffi_carefully_make_gil(void)
{
    return pypy_carefully_make_gil(_CFFI_MODULE_NAME);
}

static int _cffi_initialize_python(void)
{
    return pypy_init_embedded_cffi_module(0xB011, &_cffi_pypy_init);
}

/**********  end PyPy-specific section  **********/


#endif


#ifdef __GNUC__
__attribute__((noinline))
#endif
static _cffi_call_python_fnptr _cffi_start_python(void)
{
    /* Delicate logic to initialize Python.  This function can be
       called multiple times concurrently, e.g. when the process calls
       its first ``extern "Python"`` functions in multiple threads at
       once.  It can also be called recursively, in which case we must
       ignore it.  We also have to consider what occurs if several
       different cffi-based extensions reach this code in parallel
       threads---it is a different copy of the code, then, and we
       can't have any shared global variable unless it comes from
       'libpythonX.Y.so'.

       Idea:

       * _cffi_carefully_make_gil(): "carefully" call
         PyEval_InitThreads() (possibly with Py_InitializeEx() first).

       * then we use a (local) custom lock to make sure that a call to this
         cffi-based extension will wait if another call to the *same*
         extension is running the initialization in another thread.
         It is reentrant, so that a recursive call will not block, but
         only one from a different thread.

       * then we grab the GIL and (Python 2) we call Py_InitializeEx().
         At this point, concurrent calls to Py_InitializeEx() are not
         possible: we have the GIL.

       * do the rest of the specific initialization, which may
         temporarily release the GIL but not the custom lock.
         Only release the custom lock when we are done.
    */
    static char called = 0;

    if (_cffi_carefully_make_gil() != 0)
        return NULL;

    _cffi_acquire_reentrant_mutex();

    /* Here the GIL exists, but we don't have it.  We're only protected
       from concurrency by the reentrant mutex. */

    /* This file only initializes the embedded module once, the first
       time this is called, even if there are subinterpreters. */
    if (!called) {
        called = 1;  /* invoke _cffi_initialize_python() only once,
                        but don't set '_cffi_call_python' right now,
                        otherwise concurrent threads won't call
                        this function at all (we need them to wait) */
        if (_cffi_initialize_python() == 0) {
            /* now initialization is finished.  Switch to the fast-path. */

            /* We would like nobody to see the new value of
               '_cffi_call_python' without also seeing the rest of the
               data initialized.  However, this is not possible.  But
               the new value of '_cffi_call_python' is the function
               'cffi_call_python()' from _cffi_backend.  So:  */
            cffi_write_barrier();
            /* ^^^ we put a write barrier here, and a corresponding
               read barrier at the start of cffi_call_python().  This
               ensures that after that read barrier, we see everything
               done here before the write barrier.
            */

            assert(_cffi_call_python_org != NULL);
            _cffi_call_python = (_cffi_call_python_fnptr)_cffi_call_python_org;
        }
        else {
            /* initialization failed.  Reset this to NULL, even if it was
               already set to some other value.  Future calls to
               _cffi_start_python() are still forced to occur, and will
               always return NULL from now on. */
            _cffi_call_python_org = NULL;
        }
    }

    _cffi_release_reentrant_mutex();

    return (_cffi_call_python_fnptr)_cffi_call_python_org;
}

static
void _cffi_start_and_call_python(struct _cffi_externpy_s *externpy, char *args)
{
    _cffi_call_python_fnptr fnptr;
    int current_err = errno;
#ifdef _MSC_VER
    int current_lasterr = GetLastError();
#endif
    fnptr = _cffi_start_python();
    if (fnptr == NULL) {
        fprintf(stderr, "function %s() called, but initialization code "
                        "failed.  Returning 0.\n", externpy->name);
        memset(args, 0, externpy->size_of_result);
    }
#ifdef _MSC_VER
    SetLastError(current_lasterr);
#endif
    errno = current_err;

    if (fnptr != NULL)
        fnptr(externpy, args);
}


/* The cffi_start_python() function makes sure Python is initialized
   and our cffi module is set up.  It can be called manually from the
   user C code.  The same effect is obtained automatically from any
   dll-exported ``extern "Python"`` function.  This function returns
   -1 if initialization failed, 0 if all is OK.  */
_CFFI_UNUSED_FN
static int cffi_start_python(void)
{
    if (_cffi_call_python == &_cffi_start_and_call_python) {
        if (_cffi_start_python() == NULL)
            return -1;
    }
    cffi_read_barrier();
    return 0;
}

#undef cffi_compare_and_swap
#undef cffi_write_barrier
#undef cffi_read_barrier

#ifdef __cplusplus
}
#endif

/************************************************************/


/* Python's header defines these.. */
#undef HAVE_MEMRCHR
#undef HAVE_STRINGS_H

#include "config.h"
#include "hexchat-plugin.h"

static hexchat_plugin *ph;
CFFI_DLLEXPORT int _on_plugin_init(char **, char **, char **, char *, char *);
CFFI_DLLEXPORT int _on_plugin_deinit(void);

int hexchat_plugin_init(hexchat_plugin *plugin_handle,
                        char **name_out, char **description_out,
                        char **version_out, char *arg)
{
    if (ph != NULL)
    {
        puts ("Python plugin already loaded\n");
        return 0; /* Prevent loading twice */
    }

    ph = plugin_handle;
    return _on_plugin_init(name_out, description_out, version_out, arg, HEXCHATLIBDIR);
}

int hexchat_plugin_deinit(void)
{
    int ret = _on_plugin_deinit();
    ph = NULL;
    return ret;
}


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 91), // char *()(hexchat_plugin *, char const *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 225), // hexchat_plugin *
/*  2 */ _CFFI_OP(_CFFI_OP_POINTER, 197), // char const *
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 91), // char *()(hexchat_plugin *, char const *, int, int)
/*  5 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  6 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/*  7 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  8 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION, 220), // char const * const *()(hexchat_plugin *, char const *)
/* 11 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 12 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // char const *()(hexchat_plugin *, char const *)
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // char const *()(hexchat_plugin *, hexchat_list *, char const *)
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 224), // hexchat_list *
/* 21 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION, 149), // hexchat_context *()(hexchat_plugin *)
/* 24 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 149), // hexchat_context *()(hexchat_plugin *, char const *, char const *)
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 29 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 97), // hexchat_event_attrs *()(hexchat_plugin *)
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // hexchat_hook *()(hexchat_plugin *, char const *, int, int(*)(char * *, char * *, hexchat_event_attrs *, void *), void *)
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 37 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 38 */ _CFFI_OP(_CFFI_OP_POINTER, 94), // int(*)(char * *, char * *, hexchat_event_attrs *, void *)
/* 39 */ _CFFI_OP(_CFFI_OP_POINTER, 232), // void *
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // hexchat_hook *()(hexchat_plugin *, char const *, int, int(*)(char * *, char * *, void *), char const *, void *)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 44 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 100), // int(*)(char * *, char * *, void *)
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // hexchat_hook *()(hexchat_plugin *, char const *, int, int(*)(char * *, char * *, void *), void *)
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // hexchat_hook *()(hexchat_plugin *, char const *, int, int(*)(char * *, hexchat_event_attrs *, void *), void *)
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 59 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 60 */ _CFFI_OP(_CFFI_OP_POINTER, 105), // int(*)(char * *, hexchat_event_attrs *, void *)
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // hexchat_hook *()(hexchat_plugin *, char const *, int, int(*)(char * *, void *), void *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 66 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 67 */ _CFFI_OP(_CFFI_OP_POINTER, 110), // int(*)(char * *, void *)
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // hexchat_hook *()(hexchat_plugin *, int, int(*)(void *), void *)
/* 71 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 72 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 73 */ _CFFI_OP(_CFFI_OP_POINTER, 170), // int(*)(void *)
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // hexchat_hook *()(hexchat_plugin *, int, int, int(*)(int, int, void *), void *)
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 79 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 80 */ _CFFI_OP(_CFFI_OP_POINTER, 165), // int(*)(int, int, void *)
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION, 20), // hexchat_list *()(hexchat_plugin *, char const *)
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(char * *, char * *, char * *, char *, char *)
/* 88 */ _CFFI_OP(_CFFI_OP_POINTER, 91), // char * *
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 91 */ _CFFI_OP(_CFFI_OP_POINTER, 197), // char *
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(char * *, char * *, hexchat_event_attrs *, void *)
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 97 */ _CFFI_OP(_CFFI_OP_POINTER, 222), // hexchat_event_attrs *
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(char * *, char * *, void *)
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(char * *, hexchat_event_attrs *, void *)
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(char * *, void *)
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, char *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, char const *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, char const *, ...)
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, char const *, char *)
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, char const *, char const * *, int *)
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 134 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // char const * *
/* 135 */ _CFFI_OP(_CFFI_OP_POINTER, 7), // int *
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, char const *, char const *)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 139 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, char const *, int)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 144 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 145 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, hexchat_context *)
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 149 */ _CFFI_OP(_CFFI_OP_POINTER, 221), // hexchat_context *
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, hexchat_event_attrs *, char const *, ...)
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, hexchat_list *)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(hexchat_plugin *, hexchat_list *, char const *)
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 163 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 165 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(int, int, void *)
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 167 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(void *)
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(void)
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 230), // time_t()(hexchat_plugin *, hexchat_list *, char const *)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION, 39), // void *()(hexchat_plugin *, char const *, char const *, char const *, char const *, char *)
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 39), // void *()(hexchat_plugin *, hexchat_hook *)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 190 */ _CFFI_OP(_CFFI_OP_POINTER, 223), // hexchat_hook *
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 232), // void()(hexchat_plugin *, char const * *, int, int, char, char)
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 194 */ _CFFI_OP(_CFFI_OP_NOOP, 134),
/* 195 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 196 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 197 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 198 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 232), // void()(hexchat_plugin *, char const *)
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION, 232), // void()(hexchat_plugin *, char const *, ...)
/* 205 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION, 232), // void()(hexchat_plugin *, hexchat_event_attrs *)
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 232), // void()(hexchat_plugin *, hexchat_list *)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 232), // void()(hexchat_plugin *, void *)
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 218 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // char const * const *
/* 221 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // hexchat_context
/* 222 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // hexchat_event_attrs
/* 223 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // hexchat_hook
/* 224 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // hexchat_list
/* 225 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // hexchat_plugin
/* 226 */ _CFFI_OP(_CFFI_OP_POINTER, 87), // int(*)(char * *, char * *, char * *, char *, char *)
/* 227 */ _CFFI_OP(_CFFI_OP_POINTER, 122), // int(*)(hexchat_plugin *, char const *, ...)
/* 228 */ _CFFI_OP(_CFFI_OP_POINTER, 151), // int(*)(hexchat_plugin *, hexchat_event_attrs *, char const *, ...)
/* 229 */ _CFFI_OP(_CFFI_OP_POINTER, 173), // int(*)(void)
/* 230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 231 */ _CFFI_OP(_CFFI_OP_POINTER, 204), // void(*)(hexchat_plugin *, char const *, ...)
/* 232 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_hexchat_event_attrs(hexchat_event_attrs *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->server_time_utc) | 0);  /* check that 'hexchat_event_attrs.server_time_utc' is an integer */
}
struct _cffi_align_typedef_hexchat_event_attrs { char x; hexchat_event_attrs y; };

static struct _cffi_externpy_s _cffi_externpy___on_command_hook =
  { "_hexchat_embedded._on_command_hook", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_command_hook(char * * a0, char * * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_command_hook, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_load_command =
  { "_hexchat_embedded._on_load_command", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_load_command(char * * a0, char * * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_load_command, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_plugin_deinit =
  { "_hexchat_embedded._on_plugin_deinit", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_plugin_deinit(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy___on_plugin_deinit, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_plugin_init =
  { "_hexchat_embedded._on_plugin_init", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_plugin_init(char * * a0, char * * a1, char * * a2, char * a3, char * a4)
{
  char a[40];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(char * * *)(p + 16) = a2;
  *(char * *)(p + 24) = a3;
  *(char * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___on_plugin_init, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_print_attrs_hook =
  { "_hexchat_embedded._on_print_attrs_hook", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_print_attrs_hook(char * * a0, hexchat_event_attrs * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(hexchat_event_attrs * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_print_attrs_hook, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_print_hook =
  { "_hexchat_embedded._on_print_hook", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_print_hook(char * * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___on_print_hook, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_py_command =
  { "_hexchat_embedded._on_py_command", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_py_command(char * * a0, char * * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_py_command, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_reload_command =
  { "_hexchat_embedded._on_reload_command", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_reload_command(char * * a0, char * * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_reload_command, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_say_command =
  { "_hexchat_embedded._on_say_command", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_say_command(char * * a0, char * * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_say_command, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_server_attrs_hook =
  { "_hexchat_embedded._on_server_attrs_hook", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_server_attrs_hook(char * * a0, char * * a1, hexchat_event_attrs * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(hexchat_event_attrs * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___on_server_attrs_hook, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_server_hook =
  { "_hexchat_embedded._on_server_hook", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_server_hook(char * * a0, char * * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_server_hook, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_timer_hook =
  { "_hexchat_embedded._on_timer_hook", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_timer_hook(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___on_timer_hook, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___on_unload_command =
  { "_hexchat_embedded._on_unload_command", (int)sizeof(int), 0, 0 };

CFFI_DLLEXPORT int _on_unload_command(char * * a0, char * * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char * * *)(p + 0) = a0;
  *(char * * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___on_unload_command, p);
  return *(int *)p;
}

static void _cffi_d_hexchat_command(hexchat_plugin * x0, char const * x1)
{
  hexchat_command(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_command(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_command", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hexchat_command(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_hexchat_command _cffi_d_hexchat_command
#endif

static void _cffi_const_hexchat_commandf(char *o)
{
  *(void(* *)(hexchat_plugin *, char const *, ...))o = hexchat_commandf;
}

static void _cffi_const_hexchat_emit_print(char *o)
{
  *(int(* *)(hexchat_plugin *, char const *, ...))o = hexchat_emit_print;
}

static void _cffi_const_hexchat_emit_print_attrs(char *o)
{
  *(int(* *)(hexchat_plugin *, hexchat_event_attrs *, char const *, ...))o = hexchat_emit_print_attrs;
}

static hexchat_event_attrs * _cffi_d_hexchat_event_attrs_create(hexchat_plugin * x0)
{
  return hexchat_event_attrs_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_event_attrs_create(PyObject *self, PyObject *arg0)
{
  hexchat_plugin * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_event_attrs * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_event_attrs_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(97));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_event_attrs_create _cffi_d_hexchat_event_attrs_create
#endif

static void _cffi_d_hexchat_event_attrs_free(hexchat_plugin * x0, hexchat_event_attrs * x1)
{
  hexchat_event_attrs_free(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_event_attrs_free(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_event_attrs * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_event_attrs_free", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(97), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_event_attrs *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(97), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hexchat_event_attrs_free(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_hexchat_event_attrs_free _cffi_d_hexchat_event_attrs_free
#endif

static hexchat_context * _cffi_d_hexchat_find_context(hexchat_plugin * x0, char const * x1, char const * x2)
{
  return hexchat_find_context(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_find_context(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_context * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_find_context", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_find_context(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(149));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_find_context _cffi_d_hexchat_find_context
#endif

static void _cffi_d_hexchat_free(hexchat_plugin * x0, void * x1)
{
  hexchat_free(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_free(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_free", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hexchat_free(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_hexchat_free _cffi_d_hexchat_free
#endif

static hexchat_context * _cffi_d_hexchat_get_context(hexchat_plugin * x0)
{
  return hexchat_get_context(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_get_context(PyObject *self, PyObject *arg0)
{
  hexchat_plugin * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_context * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_get_context(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(149));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_get_context _cffi_d_hexchat_get_context
#endif

static char const * _cffi_d_hexchat_get_info(hexchat_plugin * x0, char const * x1)
{
  return hexchat_get_info(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_get_info(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_get_info", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_get_info(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(2));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_get_info _cffi_d_hexchat_get_info
#endif

static int _cffi_d_hexchat_get_prefs(hexchat_plugin * x0, char const * x1, char const * * x2, int * x3)
{
  return hexchat_get_prefs(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_get_prefs(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  char const * * x2;
  int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "hexchat_get_prefs", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(135), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(135), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_get_prefs(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_get_prefs _cffi_d_hexchat_get_prefs
#endif

static char * _cffi_d_hexchat_gettext(hexchat_plugin * x0, char const * x1)
{
  return hexchat_gettext(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_gettext(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_gettext", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_gettext(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(91));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_gettext _cffi_d_hexchat_gettext
#endif

static hexchat_hook * _cffi_d_hexchat_hook_command(hexchat_plugin * x0, char const * x1, int x2, int(* x3)(char * *, char * *, void *), char const * x4, void * x5)
{
  return hexchat_hook_command(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_hook_command(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  int x2;
  int(* x3)(char * *, char * *, void *);
  char const * x4;
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_hook * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "hexchat_hook_command", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(char * *, char * *, void *))_cffi_to_c_pointer(arg3, _cffi_type(45));
  if (x3 == (int(*)(char * *, char * *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_hook_command(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_hook_command _cffi_d_hexchat_hook_command
#endif

static hexchat_hook * _cffi_d_hexchat_hook_fd(hexchat_plugin * x0, int x1, int x2, int(* x3)(int, int, void *), void * x4)
{
  return hexchat_hook_fd(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_hook_fd(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  int x1;
  int x2;
  int(* x3)(int, int, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_hook * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "hexchat_hook_fd", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(int, int, void *))_cffi_to_c_pointer(arg3, _cffi_type(80));
  if (x3 == (int(*)(int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_hook_fd(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_hook_fd _cffi_d_hexchat_hook_fd
#endif

static hexchat_hook * _cffi_d_hexchat_hook_print(hexchat_plugin * x0, char const * x1, int x2, int(* x3)(char * *, void *), void * x4)
{
  return hexchat_hook_print(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_hook_print(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  int x2;
  int(* x3)(char * *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_hook * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "hexchat_hook_print", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(char * *, void *))_cffi_to_c_pointer(arg3, _cffi_type(67));
  if (x3 == (int(*)(char * *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_hook_print(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_hook_print _cffi_d_hexchat_hook_print
#endif

static hexchat_hook * _cffi_d_hexchat_hook_print_attrs(hexchat_plugin * x0, char const * x1, int x2, int(* x3)(char * *, hexchat_event_attrs *, void *), void * x4)
{
  return hexchat_hook_print_attrs(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_hook_print_attrs(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  int x2;
  int(* x3)(char * *, hexchat_event_attrs *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_hook * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "hexchat_hook_print_attrs", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(char * *, hexchat_event_attrs *, void *))_cffi_to_c_pointer(arg3, _cffi_type(60));
  if (x3 == (int(*)(char * *, hexchat_event_attrs *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_hook_print_attrs(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_hook_print_attrs _cffi_d_hexchat_hook_print_attrs
#endif

static hexchat_hook * _cffi_d_hexchat_hook_server(hexchat_plugin * x0, char const * x1, int x2, int(* x3)(char * *, char * *, void *), void * x4)
{
  return hexchat_hook_server(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_hook_server(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  int x2;
  int(* x3)(char * *, char * *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_hook * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "hexchat_hook_server", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(char * *, char * *, void *))_cffi_to_c_pointer(arg3, _cffi_type(45));
  if (x3 == (int(*)(char * *, char * *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_hook_server(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_hook_server _cffi_d_hexchat_hook_server
#endif

static hexchat_hook * _cffi_d_hexchat_hook_server_attrs(hexchat_plugin * x0, char const * x1, int x2, int(* x3)(char * *, char * *, hexchat_event_attrs *, void *), void * x4)
{
  return hexchat_hook_server_attrs(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_hook_server_attrs(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  int x2;
  int(* x3)(char * *, char * *, hexchat_event_attrs *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_hook * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "hexchat_hook_server_attrs", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(char * *, char * *, hexchat_event_attrs *, void *))_cffi_to_c_pointer(arg3, _cffi_type(38));
  if (x3 == (int(*)(char * *, char * *, hexchat_event_attrs *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_hook_server_attrs(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_hook_server_attrs _cffi_d_hexchat_hook_server_attrs
#endif

static hexchat_hook * _cffi_d_hexchat_hook_timer(hexchat_plugin * x0, int x1, int(* x2)(void *), void * x3)
{
  return hexchat_hook_timer(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_hook_timer(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  int x1;
  int(* x2)(void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_hook * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "hexchat_hook_timer", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(void *))_cffi_to_c_pointer(arg2, _cffi_type(73));
  if (x2 == (int(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_hook_timer(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_hook_timer _cffi_d_hexchat_hook_timer
#endif

static char const * const * _cffi_d_hexchat_list_fields(hexchat_plugin * x0, char const * x1)
{
  return hexchat_list_fields(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_list_fields(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_list_fields", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_list_fields(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(220));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_list_fields _cffi_d_hexchat_list_fields
#endif

static void _cffi_d_hexchat_list_free(hexchat_plugin * x0, hexchat_list * x1)
{
  hexchat_list_free(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_list_free(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_list * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_list_free", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_list *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hexchat_list_free(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_hexchat_list_free _cffi_d_hexchat_list_free
#endif

static hexchat_list * _cffi_d_hexchat_list_get(hexchat_plugin * x0, char const * x1)
{
  return hexchat_list_get(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_list_get(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  hexchat_list * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_list_get", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_list_get(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(20));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_list_get _cffi_d_hexchat_list_get
#endif

static int _cffi_d_hexchat_list_int(hexchat_plugin * x0, hexchat_list * x1, char const * x2)
{
  return hexchat_list_int(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_list_int(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_list * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_list_int", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_list *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_list_int(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_list_int _cffi_d_hexchat_list_int
#endif

static int _cffi_d_hexchat_list_next(hexchat_plugin * x0, hexchat_list * x1)
{
  return hexchat_list_next(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_list_next(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_list * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_list_next", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_list *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_list_next(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_list_next _cffi_d_hexchat_list_next
#endif

static char const * _cffi_d_hexchat_list_str(hexchat_plugin * x0, hexchat_list * x1, char const * x2)
{
  return hexchat_list_str(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_list_str(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_list * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_list_str", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_list *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_list_str(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(2));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_list_str _cffi_d_hexchat_list_str
#endif

static time_t _cffi_d_hexchat_list_time(hexchat_plugin * x0, hexchat_list * x1, char const * x2)
{
  return hexchat_list_time(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_list_time(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_list * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  time_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_list_time", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_list *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_list_time(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, time_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_list_time _cffi_d_hexchat_list_time
#endif

static int _cffi_d_hexchat_nickcmp(hexchat_plugin * x0, char const * x1, char const * x2)
{
  return hexchat_nickcmp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_nickcmp(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_nickcmp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_nickcmp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_nickcmp _cffi_d_hexchat_nickcmp
#endif

static void * _cffi_d_hexchat_plugingui_add(hexchat_plugin * x0, char const * x1, char const * x2, char const * x3, char const * x4, char * x5)
{
  return hexchat_plugingui_add(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_plugingui_add(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  char const * x4;
  char * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "hexchat_plugingui_add", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(91), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(91), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_plugingui_add(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(39));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_plugingui_add _cffi_d_hexchat_plugingui_add
#endif

static void _cffi_d_hexchat_plugingui_remove(hexchat_plugin * x0, void * x1)
{
  hexchat_plugingui_remove(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_plugingui_remove(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_plugingui_remove", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hexchat_plugingui_remove(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_hexchat_plugingui_remove _cffi_d_hexchat_plugingui_remove
#endif

static int _cffi_d_hexchat_pluginpref_delete(hexchat_plugin * x0, char const * x1)
{
  return hexchat_pluginpref_delete(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_pluginpref_delete(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_pluginpref_delete", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_pluginpref_delete(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_pluginpref_delete _cffi_d_hexchat_pluginpref_delete
#endif

static int _cffi_d_hexchat_pluginpref_get_int(hexchat_plugin * x0, char const * x1)
{
  return hexchat_pluginpref_get_int(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_pluginpref_get_int(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_pluginpref_get_int", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_pluginpref_get_int(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_pluginpref_get_int _cffi_d_hexchat_pluginpref_get_int
#endif

static int _cffi_d_hexchat_pluginpref_get_str(hexchat_plugin * x0, char const * x1, char * x2)
{
  return hexchat_pluginpref_get_str(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_pluginpref_get_str(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  char * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_pluginpref_get_str", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(91), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(91), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_pluginpref_get_str(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_pluginpref_get_str _cffi_d_hexchat_pluginpref_get_str
#endif

static int _cffi_d_hexchat_pluginpref_list(hexchat_plugin * x0, char * x1)
{
  return hexchat_pluginpref_list(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_pluginpref_list(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_pluginpref_list", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(91), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(91), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_pluginpref_list(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_pluginpref_list _cffi_d_hexchat_pluginpref_list
#endif

static int _cffi_d_hexchat_pluginpref_set_int(hexchat_plugin * x0, char const * x1, int x2)
{
  return hexchat_pluginpref_set_int(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_pluginpref_set_int(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_pluginpref_set_int", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_pluginpref_set_int(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_pluginpref_set_int _cffi_d_hexchat_pluginpref_set_int
#endif

static int _cffi_d_hexchat_pluginpref_set_str(hexchat_plugin * x0, char const * x1, char const * x2)
{
  return hexchat_pluginpref_set_str(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_pluginpref_set_str(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "hexchat_pluginpref_set_str", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_pluginpref_set_str(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_pluginpref_set_str _cffi_d_hexchat_pluginpref_set_str
#endif

static void _cffi_d_hexchat_print(hexchat_plugin * x0, char const * x1)
{
  hexchat_print(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_print(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_print", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hexchat_print(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_hexchat_print _cffi_d_hexchat_print
#endif

static void _cffi_const_hexchat_printf(char *o)
{
  *(void(* *)(hexchat_plugin *, char const *, ...))o = hexchat_printf;
}

static void _cffi_d_hexchat_send_modes(hexchat_plugin * x0, char const * * x1, int x2, int x3, char x4, char x5)
{
  hexchat_send_modes(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_send_modes(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * * x1;
  int x2;
  int x3;
  char x4;
  char x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "hexchat_send_modes", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (char)_cffi_to_c_char(arg4);
  if (x4 == (char)-1 && PyErr_Occurred())
    return NULL;

  x5 = (char)_cffi_to_c_char(arg5);
  if (x5 == (char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hexchat_send_modes(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_hexchat_send_modes _cffi_d_hexchat_send_modes
#endif

static int _cffi_d_hexchat_set_context(hexchat_plugin * x0, hexchat_context * x1)
{
  return hexchat_set_context(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_set_context(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_context * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_set_context", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(149), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(149), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_set_context(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_set_context _cffi_d_hexchat_set_context
#endif

static char * _cffi_d_hexchat_strip(hexchat_plugin * x0, char const * x1, int x2, int x3)
{
  return hexchat_strip(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_strip(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  char const * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "hexchat_strip", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_strip(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(91));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_strip _cffi_d_hexchat_strip
#endif

static void * _cffi_d_hexchat_unhook(hexchat_plugin * x0, hexchat_hook * x1)
{
  return hexchat_unhook(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hexchat_unhook(PyObject *self, PyObject *args)
{
  hexchat_plugin * x0;
  hexchat_hook * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hexchat_unhook", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (hexchat_plugin *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (hexchat_hook *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hexchat_unhook(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(39));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hexchat_unhook _cffi_d_hexchat_unhook
#endif

static hexchat_plugin * *_cffi_var_ph(void)
{
  return &(ph);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "_on_command_hook", (void *)&_cffi_externpy___on_command_hook, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 45), (void *)_on_command_hook },
  { "_on_load_command", (void *)&_cffi_externpy___on_load_command, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 45), (void *)_on_load_command },
  { "_on_plugin_deinit", (void *)&_cffi_externpy___on_plugin_deinit, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 229), (void *)_on_plugin_deinit },
  { "_on_plugin_init", (void *)&_cffi_externpy___on_plugin_init, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 226), (void *)_on_plugin_init },
  { "_on_print_attrs_hook", (void *)&_cffi_externpy___on_print_attrs_hook, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 60), (void *)_on_print_attrs_hook },
  { "_on_print_hook", (void *)&_cffi_externpy___on_print_hook, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 67), (void *)_on_print_hook },
  { "_on_py_command", (void *)&_cffi_externpy___on_py_command, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 45), (void *)_on_py_command },
  { "_on_reload_command", (void *)&_cffi_externpy___on_reload_command, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 45), (void *)_on_reload_command },
  { "_on_say_command", (void *)&_cffi_externpy___on_say_command, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 45), (void *)_on_say_command },
  { "_on_server_attrs_hook", (void *)&_cffi_externpy___on_server_attrs_hook, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 38), (void *)_on_server_attrs_hook },
  { "_on_server_hook", (void *)&_cffi_externpy___on_server_hook, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 45), (void *)_on_server_hook },
  { "_on_timer_hook", (void *)&_cffi_externpy___on_timer_hook, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 73), (void *)_on_timer_hook },
  { "_on_unload_command", (void *)&_cffi_externpy___on_unload_command, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 45), (void *)_on_unload_command },
  { "hexchat_command", (void *)_cffi_f_hexchat_command, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_hexchat_command },
  { "hexchat_commandf", (void *)_cffi_const_hexchat_commandf, _CFFI_OP(_CFFI_OP_CONSTANT, 231), (void *)0 },
  { "hexchat_emit_print", (void *)_cffi_const_hexchat_emit_print, _CFFI_OP(_CFFI_OP_CONSTANT, 227), (void *)0 },
  { "hexchat_emit_print_attrs", (void *)_cffi_const_hexchat_emit_print_attrs, _CFFI_OP(_CFFI_OP_CONSTANT, 228), (void *)0 },
  { "hexchat_event_attrs_create", (void *)_cffi_f_hexchat_event_attrs_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 31), (void *)_cffi_d_hexchat_event_attrs_create },
  { "hexchat_event_attrs_free", (void *)_cffi_f_hexchat_event_attrs_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 208), (void *)_cffi_d_hexchat_event_attrs_free },
  { "hexchat_find_context", (void *)_cffi_f_hexchat_find_context, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 26), (void *)_cffi_d_hexchat_find_context },
  { "hexchat_free", (void *)_cffi_f_hexchat_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 216), (void *)_cffi_d_hexchat_free },
  { "hexchat_get_context", (void *)_cffi_f_hexchat_get_context, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 23), (void *)_cffi_d_hexchat_get_context },
  { "hexchat_get_info", (void *)_cffi_f_hexchat_get_info, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 14), (void *)_cffi_d_hexchat_get_info },
  { "hexchat_get_prefs", (void *)_cffi_f_hexchat_get_prefs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_hexchat_get_prefs },
  { "hexchat_gettext", (void *)_cffi_f_hexchat_gettext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_hexchat_gettext },
  { "hexchat_hook_command", (void *)_cffi_f_hexchat_hook_command, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 41), (void *)_cffi_d_hexchat_hook_command },
  { "hexchat_hook_fd", (void *)_cffi_f_hexchat_hook_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 76), (void *)_cffi_d_hexchat_hook_fd },
  { "hexchat_hook_print", (void *)_cffi_f_hexchat_hook_print, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 63), (void *)_cffi_d_hexchat_hook_print },
  { "hexchat_hook_print_attrs", (void *)_cffi_f_hexchat_hook_print_attrs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 56), (void *)_cffi_d_hexchat_hook_print_attrs },
  { "hexchat_hook_server", (void *)_cffi_f_hexchat_hook_server, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_hexchat_hook_server },
  { "hexchat_hook_server_attrs", (void *)_cffi_f_hexchat_hook_server_attrs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 34), (void *)_cffi_d_hexchat_hook_server_attrs },
  { "hexchat_hook_timer", (void *)_cffi_f_hexchat_hook_timer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 70), (void *)_cffi_d_hexchat_hook_timer },
  { "hexchat_list_fields", (void *)_cffi_f_hexchat_list_fields, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 10), (void *)_cffi_d_hexchat_list_fields },
  { "hexchat_list_free", (void *)_cffi_f_hexchat_list_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 212), (void *)_cffi_d_hexchat_list_free },
  { "hexchat_list_get", (void *)_cffi_f_hexchat_list_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_hexchat_list_get },
  { "hexchat_list_int", (void *)_cffi_f_hexchat_list_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 160), (void *)_cffi_d_hexchat_list_int },
  { "hexchat_list_next", (void *)_cffi_f_hexchat_list_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d_hexchat_list_next },
  { "hexchat_list_str", (void *)_cffi_f_hexchat_list_str, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 18), (void *)_cffi_d_hexchat_list_str },
  { "hexchat_list_time", (void *)_cffi_f_hexchat_list_time, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_hexchat_list_time },
  { "hexchat_nickcmp", (void *)_cffi_f_hexchat_nickcmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 137), (void *)_cffi_d_hexchat_nickcmp },
  { "hexchat_plugingui_add", (void *)_cffi_f_hexchat_plugingui_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 180), (void *)_cffi_d_hexchat_plugingui_add },
  { "hexchat_plugingui_remove", (void *)_cffi_f_hexchat_plugingui_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 216), (void *)_cffi_d_hexchat_plugingui_remove },
  { "hexchat_pluginpref_delete", (void *)_cffi_f_hexchat_pluginpref_delete, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_hexchat_pluginpref_delete },
  { "hexchat_pluginpref_get_int", (void *)_cffi_f_hexchat_pluginpref_get_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_hexchat_pluginpref_get_int },
  { "hexchat_pluginpref_get_str", (void *)_cffi_f_hexchat_pluginpref_get_str, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 126), (void *)_cffi_d_hexchat_pluginpref_get_str },
  { "hexchat_pluginpref_list", (void *)_cffi_f_hexchat_pluginpref_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_hexchat_pluginpref_list },
  { "hexchat_pluginpref_set_int", (void *)_cffi_f_hexchat_pluginpref_set_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 142), (void *)_cffi_d_hexchat_pluginpref_set_int },
  { "hexchat_pluginpref_set_str", (void *)_cffi_f_hexchat_pluginpref_set_str, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 137), (void *)_cffi_d_hexchat_pluginpref_set_str },
  { "hexchat_print", (void *)_cffi_f_hexchat_print, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_hexchat_print },
  { "hexchat_printf", (void *)_cffi_const_hexchat_printf, _CFFI_OP(_CFFI_OP_CONSTANT, 231), (void *)0 },
  { "hexchat_send_modes", (void *)_cffi_f_hexchat_send_modes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 192), (void *)_cffi_d_hexchat_send_modes },
  { "hexchat_set_context", (void *)_cffi_f_hexchat_set_context, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 147), (void *)_cffi_d_hexchat_set_context },
  { "hexchat_strip", (void *)_cffi_f_hexchat_strip, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 4), (void *)_cffi_d_hexchat_strip },
  { "hexchat_unhook", (void *)_cffi_f_hexchat_unhook, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 188), (void *)_cffi_d_hexchat_unhook },
  { "ph", (void *)_cffi_var_ph, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 1), (void *)0 },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "server_time_utc", offsetof(hexchat_event_attrs, server_time_utc),
                       sizeof(((hexchat_event_attrs *)0)->server_time_utc),
                       _CFFI_OP(_CFFI_OP_NOOP, 230) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$hexchat_event_attrs", 222, _CFFI_F_CHECK_FIELDS,
    sizeof(hexchat_event_attrs), offsetof(struct _cffi_align_typedef_hexchat_event_attrs, y), 0, 1 },
  { "_hexchat_context", 221, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_hexchat_hook", 223, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_hexchat_list", 224, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_hexchat_plugin", 225, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "hexchat_context", 221 },
  { "hexchat_event_attrs", 222 },
  { "hexchat_hook", 223 },
  { "hexchat_list", 224 },
  { "hexchat_plugin", 225 },
  { "time_t", 230 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  55,  /* num_globals */
  5,  /* num_struct_unions */
  0,  /* num_enums */
  6,  /* num_typenames */
  NULL,  /* no includes */
  233,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__hexchat_embedded(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2701;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__hexchat_embedded(void) { return NULL; }
#  else
     init_hexchat_embedded(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__hexchat_embedded(void)
{
  return _cffi_init("_hexchat_embedded", 0x2701, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_hexchat_embedded(void)
{
  _cffi_init("_hexchat_embedded", 0x2701, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
