/*
Copyright (c) 2024 - present Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "CUDA2HIP.h"

const std::map<llvm::StringRef, hipCounter> CUDA_TENSOR_FUNCTION_MAP {
  {"cutensorCreate",                                 {"hiptensorCreate",                                     "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorDestroy",                                {"hiptensorDestroy",                                    "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorHandleResizePlanCache",                  {"hiptensorHandleResizePlanCache",                      "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorHandleWritePlanCacheToFile",             {"hiptensorHandleWritePlanCacheToFile",                 "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorHandleReadPlanCacheFromFile",            {"hiptensorHandleReadPlanCacheFromFile",                "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorWriteKernelCacheToFile",                 {"hiptensorWriteKernelCacheToFile",                     "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorReadKernelCacheFromFile",                {"hiptensorReadKernelCacheFromFile",                    "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreateTensorDescriptor",                 {"hiptensorCreateTensorDescriptor",                     "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorInitTensorDescriptor",                   {"hiptensorInitTensorDescriptor",                       "", CONV_LIB_FUNC, API_TENSOR, 2, HIP_REMOVED}},
  {"cutensorDestroyTensorDescriptor",                {"hiptensorDestroyTensorDescriptor",                    "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreateElementwiseTrinary",               {"hiptensorCreateElementwiseTrinary",                   "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorElementwiseTrinaryExecute",              {"hiptensorElementwiseTrinaryExecute",                  "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreateElementwiseBinary",                {"hiptensorCreateElementwiseBinary",                    "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorElementwiseBinaryExecute",               {"hiptensorElementwiseBinaryExecute",                   "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreatePermutation",                      {"hiptensorCreatePermutation",                          "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorPermutation",                            {"hiptensorPermutation",                                "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorPermute",                                {"hiptensorPermute",                                    "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreateContraction",                      {"hiptensorCreateContraction",                          "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorContraction",                            {"hiptensorContraction",                                "", CONV_LIB_FUNC, API_TENSOR, 2, HIP_REMOVED}},
  {"cutensorDestroyOperationDescriptor",             {"hiptensorDestroyOperationDescriptor",                 "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorOperationDescriptorSetAttribute",        {"hiptensorOperationDescriptorSetAttribute",            "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorOperationDescriptorGetAttribute",        {"hiptensorOperationDescriptorGetAttribute",            "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreatePlanPreference",                   {"hiptensorCreatePlanPreference",                       "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorDestroyPlanPreference",                  {"hiptensorDestroyPlanPreference",                      "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorPlanPreferenceSetAttribute",             {"hiptensorPlanPreferenceSetAttribute",                 "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorPlanGetAttribute",                       {"hiptensorPlanGetAttribute",                           "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorEstimateWorkspaceSize",                  {"hiptensorEstimateWorkspaceSize",                      "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreatePlan",                             {"hiptensorCreatePlan",                                 "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorDestroyPlan",                            {"hiptensorDestroyPlan",                                "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorContract",                               {"hiptensorContract",                                   "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorReduction",                              {"hiptensorReduction",                                  "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorCreateReduction",                        {"hiptensorCreateReduction",                            "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorReduce",                                 {"hiptensorReduce",                                     "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorGetErrorString",                         {"hiptensorGetErrorString",                             "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorGetVersion",                             {"hiptensorGetVersion",                                 "", CONV_LIB_FUNC, API_TENSOR, 2, HIP_EXPERIMENTAL}},
  {"cutensorGetCudartVersion",                       {"hiptensorGetHiprtVersion",                            "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorLoggerSetCallback",                      {"hiptensorLoggerSetCallback",                          "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorLoggerSetFile",                          {"hiptensorLoggerSetFile",                              "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorLoggerOpenFile",                         {"hiptensorLoggerOpenFile",                             "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorLoggerSetLevel",                         {"hiptensorLoggerSetLevel",                             "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorLoggerSetMask",                          {"hiptensorLoggerSetMask",                              "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorLoggerForceDisable",                     {"hiptensorLoggerForceDisable",                         "", CONV_LIB_FUNC, API_TENSOR, 2}},
  {"cutensorMgCreate",                               {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgDestroy",                              {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCreateTensorDescriptor",               {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgDestroyTensorDescriptor",              {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCreateCopyDescriptor",                 {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgDestroyCopyDescriptor",                {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCopyGetWorkspace",                     {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCreateCopyPlan",                       {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgDestroyCopyPlan",                      {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCopy",                                 {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCreateContractionFind",                {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgDestroyContractionFind",               {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgContractionFindSetAttribute",          {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCreateContractionDescriptor",          {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgDestroyContractionDescriptor",         {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgContractionGetWorkspace",              {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgCreateContractionPlan",                {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgDestroyContractionPlan",               {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorMgContraction",                          {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorCreateContractionTrinary",               {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorContractTrinary",                        {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorCreateBlockSparseTensorDescriptor",      {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorDestroyBlockSparseTensorDescriptor",     {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorCreateBlockSparseContraction",           {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
  {"cutensorBlockSparseContract",                    {"",                                                    "", CONV_LIB_FUNC, API_TENSOR, 2, UNSUPPORTED}},
};

const std::map<llvm::StringRef, cudaAPIversions> CUDA_TENSOR_FUNCTION_VER_MAP {
  {"cutensorCreate",                                 {CUTENSOR_1700, CUDA_0,        CUDA_0        }},
  {"cutensorDestroy",                                {CUTENSOR_1700, CUDA_0,        CUDA_0        }},
  {"cutensorHandleResizePlanCache",                  {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorHandleWritePlanCacheToFile",             {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorHandleReadPlanCacheFromFile",            {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorWriteKernelCacheToFile",                 {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorReadKernelCacheFromFile",                {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreateTensorDescriptor",                 {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorInitTensorDescriptor",                   {CUTENSOR_1010, CUDA_0,        CUTENSOR_2000 }},
  {"cutensorDestroyTensorDescriptor",                {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreateElementwiseTrinary",               {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorElementwiseTrinaryExecute",              {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreateElementwiseBinary",                {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorElementwiseBinaryExecute",               {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreatePermutation",                      {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorPermutation",                            {CUTENSOR_1010, CUDA_0,        CUTENSOR_2000 }},
  {"cutensorPermute",                                {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreateContraction",                      {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorContraction",                            {CUTENSOR_1010, CUDA_0,        CUTENSOR_2000 }},
  {"cutensorDestroyOperationDescriptor",             {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorOperationDescriptorSetAttribute",        {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorOperationDescriptorGetAttribute",        {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreatePlanPreference",                   {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorDestroyPlanPreference",                  {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorPlanPreferenceSetAttribute",             {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorPlanGetAttribute",                       {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorEstimateWorkspaceSize",                  {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreatePlan",                             {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorDestroyPlan",                            {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorContract",                               {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorCreateReduction",                        {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorReduction",                              {CUTENSOR_1010, CUDA_0,        CUTENSOR_2000 }},
  {"cutensorReduce",                                 {CUTENSOR_2000, CUDA_0,        CUDA_0        }},
  {"cutensorGetErrorString",                         {CUTENSOR_1010, CUDA_0,        CUDA_0        }},
  {"cutensorGetVersion",                             {CUTENSOR_1010, CUDA_0,        CUDA_0        }},
  {"cutensorGetCudartVersion",                       {CUTENSOR_1010, CUDA_0,        CUDA_0        }},
  {"cutensorLoggerSetCallback",                      {CUTENSOR_1320, CUDA_0,        CUDA_0        }},
  {"cutensorLoggerSetFile",                          {CUTENSOR_1320, CUDA_0,        CUDA_0        }},
  {"cutensorLoggerOpenFile",                         {CUTENSOR_1320, CUDA_0,        CUDA_0        }},
  {"cutensorLoggerSetLevel",                         {CUTENSOR_1320, CUDA_0,        CUDA_0        }},
  {"cutensorLoggerSetMask",                          {CUTENSOR_1320, CUDA_0,        CUDA_0        }},
  {"cutensorLoggerForceDisable",                     {CUTENSOR_1320, CUDA_0,        CUDA_0        }},
  {"cutensorMgCreate",                               {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgDestroy",                              {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgCreateTensorDescriptor",               {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgDestroyTensorDescriptor",              {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgCreateCopyDescriptor",                 {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgDestroyCopyDescriptor",                {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgCopyGetWorkspace",                     {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgCreateCopyPlan",                       {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgDestroyCopyPlan",                      {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgCopy",                                 {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgCreateContractionFind",                {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgDestroyContractionFind",               {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgContractionFindSetAttribute",          {CUTENSOR_1500, CUDA_0,        CUDA_0        }},
  {"cutensorMgCreateContractionDescriptor",          {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgDestroyContractionDescriptor",         {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgContractionGetWorkspace",              {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgCreateContractionPlan",                {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgDestroyContractionPlan",               {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorMgContraction",                          {CUTENSOR_1400, CUDA_0,        CUDA_0        }},
  {"cutensorCreateContractionTrinary",               {CUTENSOR_2200, CUDA_0,        CUDA_0        }},
  {"cutensorContractTrinary",                        {CUTENSOR_2200, CUDA_0,        CUDA_0        }},
  {"cutensorCreateBlockSparseTensorDescriptor",      {CUTENSOR_2300, CUDA_0,        CUDA_0        }},
  {"cutensorDestroyBlockSparseTensorDescriptor",     {CUTENSOR_2300, CUDA_0,        CUDA_0        }},
  {"cutensorCreateBlockSparseContraction",           {CUTENSOR_2300, CUDA_0,        CUDA_0        }},
  {"cutensorBlockSparseContract",                    {CUTENSOR_2300, CUDA_0,        CUDA_0        }},
};

const std::map<llvm::StringRef, hipAPIversions> HIP_TENSOR_FUNCTION_VER_MAP {
  {"hiptensorCreate",                                {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorDestroy",                               {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorInitTensorDescriptor",                  {HIP_5070,      HIP_0,         HIP_7000      }},
  {"hiptensorPermutation",                           {HIP_6010,      HIP_0,         HIP_0         }},
  {"hiptensorContraction",                           {HIP_6010,      HIP_0,         HIP_7000      }},
  {"hiptensorReduction",                             {HIP_6030,      HIP_0,         HIP_0         }},
  {"hiptensorGetErrorString",                        {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorGetHiprtVersion",                       {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorLoggerSetCallback",                     {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorLoggerSetFile",                         {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorLoggerOpenFile",                        {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorLoggerSetLevel",                        {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorLoggerSetMask",                         {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorLoggerForceDisable",                    {HIP_5070,      HIP_0,         HIP_0         }},
  {"hiptensorHandleResizePlanCache",                 {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorHandleWritePlanCacheToFile",            {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorHandleReadPlanCacheFromFile",           {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorWriteKernelCacheToFile",                {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorReadKernelCacheFromFile",               {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreateTensorDescriptor",                {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorDestroyTensorDescriptor",               {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreateContraction",                     {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorDestroyOperationDescriptor",            {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorOperationDescriptorSetAttribute",       {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorOperationDescriptorGetAttribute",       {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreatePlanPreference",                  {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorDestroyPlanPreference",                 {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorPlanPreferenceSetAttribute",            {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorPlanGetAttribute",                      {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorEstimateWorkspaceSize",                 {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreatePermutation",                     {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreatePlan",                            {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorDestroyPlan",                           {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorContract",                              {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorPermute",                               {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreateElementwiseBinary",               {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorElementwiseBinaryExecute",              {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreateElementwiseTrinary",              {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorElementwiseTrinaryExecute",             {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorCreateReduction",                       {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorReduce",                                {HIP_7000,      HIP_0,         HIP_0         }},
  {"hiptensorGetVersion",                            {HIP_7020,      HIP_0,         HIP_0,        HIP_7020}},
};

const std::map<llvm::StringRef, cudaAPIChangedVersions> CUDA_TENSOR_FUNCTION_CHANGED_VER_MAP {
  {"cutensorCreate",                                 {CUTENSOR_2000}},
  {"cutensorDestroy",                                {CUTENSOR_2000}},
};

const std::map<llvm::StringRef, hipAPIChangedVersions> HIP_TENSOR_FUNCTION_CHANGED_VER_MAP {
  {"hiptensorCreate",                                {HIP_7000}},
  {"hiptensorDestroy",                               {HIP_7000}},
};

const std::map<unsigned int, llvm::StringRef> CUDA_TENSOR_API_SECTION_MAP {
  {1, "CUTENSOR Data types"},
  {2, "CUTENSOR Function Reference"},
};
