
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kstatusnotifieritem_python.h"

// main header
#include "kstatusnotifieritem_wrapper.h"

// Wrappers providing overrides
#include "kstatusnotifieritem_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kstatusnotifieritem.h>
#include <qaction.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmenu.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qwindow.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KStatusNotifierItem_Type = nullptr;
static PyTypeObject *Sbk_KStatusNotifierItem_TypeF(void)
{
    return _Sbk_KStatusNotifierItem_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KStatusNotifierItemWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KStatusNotifierItemWrapper::KStatusNotifierItemWrapper(::QObject * parent) : KStatusNotifierItem(parent)
{
}

KStatusNotifierItemWrapper::KStatusNotifierItemWrapper(const ::QString & id, ::QObject * parent) : KStatusNotifierItem(id, parent)
{
}

void KStatusNotifierItemWrapper::activate(const ::QPoint & pos)
{
    static const char *funcName = "activate";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusNotifierItem::activate(pos);
    }
    sbk_o_activate("KStatusNotifierItem", funcName, gil, pyOverride, pos);
}

void KStatusNotifierItemWrapper::sbk_o_activate(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QPoint & pos)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &pos)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &pos)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KStatusNotifierItemWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    sbk_o_childEvent("KStatusNotifierItem", funcName, gil, pyOverride, event);
}

void KStatusNotifierItemWrapper::sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KStatusNotifierItemWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    sbk_o_connectNotify("KStatusNotifierItem", funcName, gil, pyOverride, signal);
}

void KStatusNotifierItemWrapper::sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KStatusNotifierItemWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    sbk_o_customEvent("KStatusNotifierItem", funcName, gil, pyOverride, event);
}

void KStatusNotifierItemWrapper::sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KStatusNotifierItemWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KStatusNotifierItemWrapper::sbk_o_connectNotify("KStatusNotifierItem", funcName, gil, pyOverride, signal);
}

bool KStatusNotifierItemWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return sbk_o_event("KStatusNotifierItem", funcName, gil, pyOverride, event);
}

bool KStatusNotifierItemWrapper::sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KStatusNotifierItemWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusNotifierItem::eventFilter(watched, event);
    }
    return sbk_o_eventFilter("KStatusNotifierItem", funcName, gil, pyOverride, watched, event);
}

bool KStatusNotifierItemWrapper::sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg2 = Py_REFCNT(pyArgArray[1]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg2 = Py_REFCNT(PyTuple_GetItem(pyArgs, 1)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(pyArgArray[1]);
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 1));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KStatusNotifierItemWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusNotifierItem_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    sbk_o_timerEvent("KStatusNotifierItem", funcName, gil, pyOverride, event);
}

void KStatusNotifierItemWrapper::sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

const QMetaObject *KStatusNotifierItemWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KStatusNotifierItem::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KStatusNotifierItemWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KStatusNotifierItem::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KStatusNotifierItemWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KStatusNotifierItemWrapper *>(this));
    }
    return KStatusNotifierItem::qt_metacast(_clname);
}

KStatusNotifierItemWrapper::~KStatusNotifierItemWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KStatusNotifierItem_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KStatusNotifierItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KStatusNotifierItem >()))
        return -1;

    KStatusNotifierItemWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KStatusNotifierItem", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KStatusNotifierItem::KStatusNotifierItem(QObject*=)
    // 1: KStatusNotifierItem::KStatusNotifierItem(QString,QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KStatusNotifierItem(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KStatusNotifierItem(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KStatusNotifierItem(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KStatusNotifierItem(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KStatusNotifierItem(QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KStatusNotifierItem(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KStatusNotifierItemWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KStatusNotifierItemWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KStatusNotifierItem(const QString &id, QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KStatusNotifierItem(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KStatusNotifierItemWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KStatusNotifierItemWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KStatusNotifierItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KStatusNotifierItemFunc_abortQuit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // abortQuit()
        cppSelf->abortQuit();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_action(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::action(QString)const->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // action(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "action", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KStatusNotifierItem", "action(const QString &name) const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // action(QString)const
            QAction * cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->action(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_actionCollection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KStatusNotifierItem", "actionCollection() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // actionCollection()const
        QList<QAction*> cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->actionCollection();
        pyResult = Shiboken::Conversions::copyToPython(SbkKStatusNotifierItemTypeConverters[SBK_KStatusNotifierItem_QList_QActionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_activate(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "activate", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    if (PyArg_ParseTuple(args, "|O:activate", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KStatusNotifierItem::activate(const QPoint&=)
    if (numArgs == 0) {
        overloadId = 0; // activate(QPoint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArgs[0])))) {
        overloadId = 0; // activate(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "activate", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"pos", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "activate", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPoint cppArg0_local = QPoint();
        ::QPoint *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // activate(QPoint)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusNotifierItem::activate(*cppArg0)
                : cppSelf->activate(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_addAction(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addAction", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KStatusNotifierItem::addAction(QString,QAction*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addAction(QString,QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KStatusNotifierItem", "addAction(const QString &name, QAction *action)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAction *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addAction(QString,QAction*)
            cppSelf->addAction(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_associatedWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // associatedWindow()const
        QWindow * cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->associatedWindow();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_attentionIconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // attentionIconName()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->attentionIconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_attentionIconPixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // attentionIconPixmap()const
        QIcon cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->attentionIconPixmap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_attentionMovieName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // attentionMovieName()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->attentionMovieName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_category(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // category()const
        KStatusNotifierItem::ItemCategory cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->category();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemCategory_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_contextMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // contextMenu()const
        QMenu * cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->contextMenu();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusNotifierItem::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_hideAssociatedWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hideAssociatedWindow()
        cppSelf->hideAssociatedWindow();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_iconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconName()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->iconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_iconPixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconPixmap()const
        QIcon cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->iconPixmap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // id()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->id();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_isMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isMenu()const
        bool cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->isMenu();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_overlayIconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // overlayIconName()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->overlayIconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_overlayIconPixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // overlayIconPixmap()const
        QIcon cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->overlayIconPixmap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_providedToken(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // providedToken()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->providedToken();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_removeAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::removeAction(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // removeAction(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeAction", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KStatusNotifierItem", "removeAction(const QString &name)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeAction(QString)
            cppSelf->removeAction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setAssociatedWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setAssociatedWindow(QWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), (pyArg)))) {
        overloadId = 0; // setAssociatedWindow(QWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAssociatedWindow", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAssociatedWindow(QWindow*)
            cppSelf->setAssociatedWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setAttentionIconByName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setAttentionIconByName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setAttentionIconByName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAttentionIconByName", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAttentionIconByName(QString)
            cppSelf->setAttentionIconByName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setAttentionIconByPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setAttentionIconByPixmap(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setAttentionIconByPixmap(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAttentionIconByPixmap", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setAttentionIconByPixmap(QIcon)
            cppSelf->setAttentionIconByPixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setAttentionMovieByName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setAttentionMovieByName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setAttentionMovieByName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAttentionMovieByName", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAttentionMovieByName(QString)
            cppSelf->setAttentionMovieByName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setCategory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setCategory(KStatusNotifierItem::ItemCategory)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemCategory_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setCategory(KStatusNotifierItem::ItemCategory)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCategory", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::KStatusNotifierItem::ItemCategory cppArg0 = static_cast< ::KStatusNotifierItem::ItemCategory>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCategory(KStatusNotifierItem::ItemCategory)
            cppSelf->setCategory(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setContextMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setContextMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArg)))) {
        overloadId = 0; // setContextMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setContextMenu", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setContextMenu(QMenu*)
            cppSelf->setContextMenu(cppArg0);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArg);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setIconByName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setIconByName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setIconByName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIconByName", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setIconByName(QString)
            cppSelf->setIconByName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setIconByPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setIconByPixmap(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIconByPixmap(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIconByPixmap", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIconByPixmap(QIcon)
            cppSelf->setIconByPixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setIsMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setIsMenu(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setIsMenu(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIsMenu", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setIsMenu(bool)
            cppSelf->setIsMenu(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setOverlayIconByName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setOverlayIconByName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setOverlayIconByName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOverlayIconByName", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOverlayIconByName(QString)
            cppSelf->setOverlayIconByName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setOverlayIconByPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setOverlayIconByPixmap(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setOverlayIconByPixmap(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOverlayIconByPixmap", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setOverlayIconByPixmap(QIcon)
            cppSelf->setOverlayIconByPixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setStandardActionsEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setStandardActionsEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStandardActionsEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStandardActionsEnabled", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStandardActionsEnabled(bool)
            cppSelf->setStandardActionsEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setStatus(KStatusNotifierItem::ItemStatus)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemStatus_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setStatus(KStatusNotifierItem::ItemStatus)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStatus", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::KStatusNotifierItem::ItemStatus cppArg0 = static_cast< ::KStatusNotifierItem::ItemStatus>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStatus(KStatusNotifierItem::ItemStatus)
            cppSelf->setStatus(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTitle", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setToolTip(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setToolTip", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KStatusNotifierItem::setToolTip(QIcon,QString,QString)
    // 1: KStatusNotifierItem::setToolTip(QString,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 1; // setToolTip(QString,QString,QString)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // setToolTip(QIcon,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setToolTip", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setToolTip(const QIcon &icon, const QString &title, const QString &subTitle)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setToolTip(QIcon,QString,QString)
                cppSelf->setToolTip(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // setToolTip(const QString &iconName, const QString &title, const QString &subTitle)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setToolTip(QString,QString,QString)
                cppSelf->setToolTip(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setToolTipIconByName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setToolTipIconByName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setToolTipIconByName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolTipIconByName", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolTipIconByName(QString)
            cppSelf->setToolTipIconByName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setToolTipIconByPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setToolTipIconByPixmap(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setToolTipIconByPixmap(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolTipIconByPixmap", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolTipIconByPixmap(QIcon)
            cppSelf->setToolTipIconByPixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setToolTipSubTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setToolTipSubTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setToolTipSubTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolTipSubTitle", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolTipSubTitle(QString)
            cppSelf->setToolTipSubTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_setToolTipTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusNotifierItem::setToolTipTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setToolTipTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolTipTitle", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolTipTitle(QString)
            cppSelf->setToolTipTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_showMessage(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showMessage", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:showMessage", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KStatusNotifierItem::showMessage(QString,QString,QString,int=)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // showMessage(QString,QString,QString,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // showMessage(QString,QString,QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showMessage", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"timeout", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showMessage", errInfo, SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 10000;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showMessage(QString,QString,QString,int)
            cppSelf->showMessage(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusNotifierItemFunc_standardActionsEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // standardActionsEnabled()const
        bool cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->standardActionsEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // status()const
        KStatusNotifierItem::ItemStatus cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->status();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemStatus_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // title()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->title();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_toolTipIconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolTipIconName()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->toolTipIconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_toolTipIconPixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolTipIconPixmap()const
        QIcon cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->toolTipIconPixmap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_toolTipSubTitle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolTipSubTitle()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->toolTipSubTitle();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStatusNotifierItemFunc_toolTipTitle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolTipTitle()const
        QString cppResult = const_cast<const ::KStatusNotifierItem *>(cppSelf)->toolTipTitle();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KStatusNotifierItem_PropertyStrings[] = {
    "attentionIconName::setAttentionIconByName",
    "category::",
    "iconName::setIconByName",
    "overlayIconName::setOverlayIconByName",
    "status::",
    "title::",
    "toolTipIconName::setToolTipIconByName",
    "toolTipSubTitle::",
    "toolTipTitle::",
    nullptr // Sentinel
};

static const char *Sbk_KStatusNotifierItem_EnumFlagInfo[] = {
    "ItemCategory:IntEnum",
    "ItemStatus:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KStatusNotifierItem_methods[] = {
    {"abortQuit", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_abortQuit), METH_NOARGS, nullptr},
    {"action", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_action), METH_O, nullptr},
    {"actionCollection", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_actionCollection), METH_NOARGS, nullptr},
    {"activate", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_activate), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"addAction", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_addAction), METH_VARARGS, nullptr},
    {"associatedWindow", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_associatedWindow), METH_NOARGS, nullptr},
    {"attentionIconName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_attentionIconName), METH_NOARGS, nullptr},
    {"attentionIconPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_attentionIconPixmap), METH_NOARGS, nullptr},
    {"attentionMovieName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_attentionMovieName), METH_NOARGS, nullptr},
    {"category", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_category), METH_NOARGS, nullptr},
    {"contextMenu", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_contextMenu), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_eventFilter), METH_VARARGS, nullptr},
    {"hideAssociatedWindow", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_hideAssociatedWindow), METH_NOARGS, nullptr},
    {"iconName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_iconName), METH_NOARGS, nullptr},
    {"iconPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_iconPixmap), METH_NOARGS, nullptr},
    {"id", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_id), METH_NOARGS, nullptr},
    {"isMenu", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_isMenu), METH_NOARGS, nullptr},
    {"overlayIconName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_overlayIconName), METH_NOARGS, nullptr},
    {"overlayIconPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_overlayIconPixmap), METH_NOARGS, nullptr},
    {"providedToken", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_providedToken), METH_NOARGS, nullptr},
    {"removeAction", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_removeAction), METH_O, nullptr},
    {"setAssociatedWindow", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setAssociatedWindow), METH_O, nullptr},
    {"setAttentionIconByName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setAttentionIconByName), METH_O, nullptr},
    {"setAttentionIconByPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setAttentionIconByPixmap), METH_O, nullptr},
    {"setAttentionMovieByName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setAttentionMovieByName), METH_O, nullptr},
    {"setCategory", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setCategory), METH_O, nullptr},
    {"setContextMenu", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setContextMenu), METH_O, nullptr},
    {"setIconByName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setIconByName), METH_O, nullptr},
    {"setIconByPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setIconByPixmap), METH_O, nullptr},
    {"setIsMenu", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setIsMenu), METH_O, nullptr},
    {"setOverlayIconByName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setOverlayIconByName), METH_O, nullptr},
    {"setOverlayIconByPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setOverlayIconByPixmap), METH_O, nullptr},
    {"setStandardActionsEnabled", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setStandardActionsEnabled), METH_O, nullptr},
    {"setStatus", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setStatus), METH_O, nullptr},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setTitle), METH_O, nullptr},
    {"setToolTip", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setToolTip), METH_VARARGS, nullptr},
    {"setToolTipIconByName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setToolTipIconByName), METH_O, nullptr},
    {"setToolTipIconByPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setToolTipIconByPixmap), METH_O, nullptr},
    {"setToolTipSubTitle", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setToolTipSubTitle), METH_O, nullptr},
    {"setToolTipTitle", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_setToolTipTitle), METH_O, nullptr},
    {"showMessage", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_showMessage), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"standardActionsEnabled", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_standardActionsEnabled), METH_NOARGS, nullptr},
    {"status", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_status), METH_NOARGS, nullptr},
    {"title", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_title), METH_NOARGS, nullptr},
    {"toolTipIconName", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_toolTipIconName), METH_NOARGS, nullptr},
    {"toolTipIconPixmap", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_toolTipIconPixmap), METH_NOARGS, nullptr},
    {"toolTipSubTitle", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_toolTipSubTitle), METH_NOARGS, nullptr},
    {"toolTipTitle", reinterpret_cast<PyCFunction>(Sbk_KStatusNotifierItemFunc_toolTipTitle), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KStatusNotifierItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KStatusNotifierItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KStatusNotifierItemWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KStatusNotifierItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KStatusNotifierItem_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KStatusNotifierItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KStatusNotifierItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KStatusNotifierItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KStatusNotifierItem_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KStatusNotifierItem_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KStatusNotifierItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KStatusNotifierItem_spec = {
    "1:KStatusNotifierItem.KStatusNotifierItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KStatusNotifierItem_slots
};

} //extern "C"

static void *Sbk_KStatusNotifierItem_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KStatusNotifierItem *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KStatusNotifierItem_ItemStatus(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KStatusNotifierItem::ItemStatus>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KStatusNotifierItem::ItemStatus *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KStatusNotifierItem_ItemStatus_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemStatus_IDX])))
        return Enum_PythonToCpp_KStatusNotifierItem_ItemStatus;
    return {};
}

static PyObject *KStatusNotifierItem_ItemStatus_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KStatusNotifierItem::ItemStatus>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KStatusNotifierItem::ItemStatus *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KStatusNotifierItem_ItemCategory(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KStatusNotifierItem::ItemCategory>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KStatusNotifierItem::ItemCategory *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KStatusNotifierItem_ItemCategory_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemCategory_IDX])))
        return Enum_PythonToCpp_KStatusNotifierItem_ItemCategory;
    return {};
}

static PyObject *KStatusNotifierItem_ItemCategory_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KStatusNotifierItem::ItemCategory>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KStatusNotifierItem::ItemCategory *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KStatusNotifierItem_PythonToCpp_KStatusNotifierItem_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KStatusNotifierItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KStatusNotifierItem_PythonToCpp_KStatusNotifierItem_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KStatusNotifierItem_TypeF()))
        return KStatusNotifierItem_PythonToCpp_KStatusNotifierItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KStatusNotifierItem_PTR_CppToPython_KStatusNotifierItem(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KStatusNotifierItem *>(const_cast<void *>(cppIn)), Sbk_KStatusNotifierItem_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KStatusNotifierItem_SignatureStrings[] = {
    "1:KStatusNotifierItem.KStatusNotifierItem(self,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,category:KStatusNotifierItem.KStatusNotifierItem.ItemCategory=None,title:QString=None,status:KStatusNotifierItem.KStatusNotifierItem.ItemStatus=None,iconName:QString=None,overlayIconName:QString=None,attentionIconName:QString=None,toolTipIconName:QString=None,toolTipTitle:QString=None,toolTipSubTitle:QString=None)",
    "0:KStatusNotifierItem.KStatusNotifierItem(self,id:QString,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,category:KStatusNotifierItem.KStatusNotifierItem.ItemCategory=None,title:QString=None,status:KStatusNotifierItem.KStatusNotifierItem.ItemStatus=None,iconName:QString=None,overlayIconName:QString=None,attentionIconName:QString=None,toolTipIconName:QString=None,toolTipTitle:QString=None,toolTipSubTitle:QString=None)",
    "KStatusNotifierItem.KStatusNotifierItem.abortQuit(self)",
    "KStatusNotifierItem.KStatusNotifierItem.action(self,name:QString)->PySide6.QtGui.QAction",
    "KStatusNotifierItem.KStatusNotifierItem.actionCollection(self)->QList[PySide6.QtGui.QAction]",
    "KStatusNotifierItem.KStatusNotifierItem.activate(self,pos:PySide6.QtCore.QPoint=QPoint())",
    "KStatusNotifierItem.KStatusNotifierItem.addAction(self,name:QString,action:PySide6.QtGui.QAction)",
    "KStatusNotifierItem.KStatusNotifierItem.associatedWindow(self)->PySide6.QtGui.QWindow",
    "KStatusNotifierItem.KStatusNotifierItem.attentionIconName(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.attentionIconPixmap(self)->PySide6.QtGui.QIcon",
    "KStatusNotifierItem.KStatusNotifierItem.attentionMovieName(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.category(self)->KStatusNotifierItem.KStatusNotifierItem.ItemCategory",
    "KStatusNotifierItem.KStatusNotifierItem.contextMenu(self)->PySide6.QtWidgets.QMenu",
    "KStatusNotifierItem.KStatusNotifierItem.eventFilter(self,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KStatusNotifierItem.KStatusNotifierItem.hideAssociatedWindow(self)",
    "KStatusNotifierItem.KStatusNotifierItem.iconName(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.iconPixmap(self)->PySide6.QtGui.QIcon",
    "KStatusNotifierItem.KStatusNotifierItem.id(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.isMenu(self)->bool",
    "KStatusNotifierItem.KStatusNotifierItem.overlayIconName(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.overlayIconPixmap(self)->PySide6.QtGui.QIcon",
    "KStatusNotifierItem.KStatusNotifierItem.providedToken(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.removeAction(self,name:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setAssociatedWindow(self,window:PySide6.QtGui.QWindow)",
    "KStatusNotifierItem.KStatusNotifierItem.setAttentionIconByName(self,name:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setAttentionIconByPixmap(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KStatusNotifierItem.KStatusNotifierItem.setAttentionMovieByName(self,name:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setCategory(self,category:KStatusNotifierItem.KStatusNotifierItem.ItemCategory)",
    "KStatusNotifierItem.KStatusNotifierItem.setContextMenu(self,menu:PySide6.QtWidgets.QMenu)",
    "KStatusNotifierItem.KStatusNotifierItem.setIconByName(self,name:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setIconByPixmap(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KStatusNotifierItem.KStatusNotifierItem.setIsMenu(self,isMenu:bool)",
    "KStatusNotifierItem.KStatusNotifierItem.setOverlayIconByName(self,name:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setOverlayIconByPixmap(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KStatusNotifierItem.KStatusNotifierItem.setStandardActionsEnabled(self,enabled:bool)",
    "KStatusNotifierItem.KStatusNotifierItem.setStatus(self,status:KStatusNotifierItem.KStatusNotifierItem.ItemStatus)",
    "KStatusNotifierItem.KStatusNotifierItem.setTitle(self,title:QString)",
    "1:KStatusNotifierItem.KStatusNotifierItem.setToolTip(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],title:QString,subTitle:QString)",
    "0:KStatusNotifierItem.KStatusNotifierItem.setToolTip(self,iconName:QString,title:QString,subTitle:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setToolTipIconByName(self,name:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setToolTipIconByPixmap(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KStatusNotifierItem.KStatusNotifierItem.setToolTipSubTitle(self,subTitle:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.setToolTipTitle(self,title:QString)",
    "KStatusNotifierItem.KStatusNotifierItem.showMessage(self,title:QString,message:QString,icon:QString,timeout:int=10000)",
    "KStatusNotifierItem.KStatusNotifierItem.standardActionsEnabled(self)->bool",
    "KStatusNotifierItem.KStatusNotifierItem.status(self)->KStatusNotifierItem.KStatusNotifierItem.ItemStatus",
    "KStatusNotifierItem.KStatusNotifierItem.title(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.toolTipIconName(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.toolTipIconPixmap(self)->PySide6.QtGui.QIcon",
    "KStatusNotifierItem.KStatusNotifierItem.toolTipSubTitle(self)->QString",
    "KStatusNotifierItem.KStatusNotifierItem.toolTipTitle(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KStatusNotifierItem_SignatureByteSize = 706;
static constexpr uint8_t KStatusNotifierItem_SignatureBytes[706] = {
    0x78, 0xda, 0xed, 0x58, 0x4d, 0x8f, 0xda, 0x30, 0x10, 0xbd, 0xef, 0xaf, 0xe8, 0x71, 0xa9, 0xd2,
    0x68, 0xb9, 0xf4, 0x10, 0x89, 0x4a, 0x14, 0x6d, 0x2b, 0xb4, 0xe5, 0x23, 0x82, 0x6a, 0x0f, 0xab,
    0x3d, 0x04, 0x3c, 0x0b, 0x6e, 0x13, 0x3b, 0xb2, 0x27, 0xb0, 0xf9, 0xf7, 0x75, 0x62, 0x3e, 0x92,
    0xe0, 0xb4, 0x71, 0x88, 0xc4, 0xa5, 0x1c, 0x20, 0xcc, 0xc4, 0x6f, 0x9e, 0x67, 0x26, 0x0f, 0x0f,
    0x7d, 0xef, 0x69, 0x81, 0x01, 0x26, 0x72, 0xca, 0x91, 0xbe, 0x51, 0x10, 0x63, 0x84, 0xc8, 0x35,
    0xd8, 0xee, 0x25, 0x84, 0x6f, 0x4e, 0x1c, 0x08, 0x60, 0xe8, 0xcd, 0xd3, 0x05, 0x25, 0xf0, 0xd9,
    0xf5, 0x71, 0xc4, 0x05, 0xb8, 0xfe, 0x6c, 0xf5, 0x0b, 0xd6, 0x38, 0x60, 0x49, 0x18, 0xc6, 0x28,
    0x9c, 0x8f, 0xde, 0x13, 0xa4, 0x7b, 0x2e, 0xc8, 0x8c, 0x85, 0xe9, 0x60, 0xca, 0x19, 0x38, 0xeb,
    0x00, 0x61, 0xc3, 0x45, 0xda, 0x34, 0x9c, 0x9b, 0xbd, 0x8d, 0x0e, 0x8b, 0x34, 0x04, 0x52, 0x0c,
    0xc1, 0xf3, 0x17, 0x28, 0x28, 0xdb, 0x68, 0x93, 0xcc, 0xd7, 0x59, 0x61, 0x6a, 0xb3, 0x5e, 0x4e,
    0xd7, 0x9c, 0x4d, 0x83, 0xa8, 0x02, 0xca, 0x77, 0x20, 0xc2, 0x20, 0x1d, 0x1b, 0x9d, 0x01, 0xa2,
    0x4a, 0x00, 0xe5, 0xcc, 0xec, 0x46, 0xce, 0xc3, 0x25, 0x8d, 0xff, 0xea, 0x5c, 0x5e, 0xee, 0xe3,
    0xe0, 0x59, 0x24, 0xab, 0x4b, 0x67, 0xef, 0xee, 0xc1, 0xae, 0x46, 0x94, 0x1c, 0xd7, 0xff, 0x2f,
    0xd7, 0x2d, 0xca, 0xd5, 0x74, 0x7b, 0xc1, 0x8a, 0x0b, 0xf4, 0x13, 0x8a, 0x79, 0xd9, 0x2c, 0xd6,
    0xad, 0xb3, 0x0d, 0xe9, 0x5a, 0xb3, 0x02, 0xeb, 0xde, 0xa7, 0x2f, 0xe7, 0x42, 0x7f, 0x4f, 0xa8,
    0xeb, 0x0f, 0xf3, 0x3b, 0x2d, 0x81, 0x47, 0x3c, 0x0c, 0xe1, 0x1c, 0x42, 0xa1, 0xfa, 0x3f, 0xa8,
    0xc4, 0x17, 0x23, 0xf6, 0xab, 0x15, 0xf8, 0x4e, 0x35, 0xc8, 0x41, 0x47, 0xb8, 0xbc, 0xe8, 0xca,
    0x39, 0xa7, 0x0c, 0x07, 0xfa, 0xe3, 0xbe, 0x67, 0x91, 0x0f, 0x42, 0x86, 0x35, 0x29, 0x71, 0xf4,
    0x96, 0x3c, 0x23, 0x77, 0x8b, 0x08, 0x52, 0xf2, 0x35, 0x55, 0xe4, 0xc9, 0x33, 0x65, 0x84, 0xef,
    0x8f, 0x89, 0xa9, 0xc0, 0x6a, 0x67, 0x73, 0xd4, 0x6a, 0x6f, 0x9e, 0xf2, 0xad, 0xc9, 0xb7, 0x03,
    0x9a, 0xd3, 0xf7, 0x28, 0x88, 0x6b, 0x18, 0x66, 0x37, 0xd8, 0xc3, 0x4e, 0xf8, 0x8e, 0xc2, 0x35,
    0x04, 0x8f, 0x6a, 0x72, 0x5c, 0xdf, 0x46, 0x54, 0x9a, 0x07, 0xe3, 0x0c, 0xe1, 0x1d, 0x27, 0xc0,
    0x92, 0xcb, 0x2c, 0x3c, 0x53, 0xb2, 0x01, 0x94, 0xae, 0x9f, 0xb9, 0x1b, 0x43, 0xc2, 0x4e, 0x25,
    0xe2, 0x1b, 0x0d, 0x11, 0x84, 0xee, 0xb1, 0x7d, 0x80, 0xeb, 0x2d, 0x90, 0x1a, 0x61, 0x75, 0xf2,
    0xfb, 0x2f, 0x9c, 0x8f, 0x99, 0x55, 0xb1, 0x59, 0x29, 0xf5, 0x68, 0x1c, 0x7a, 0xab, 0x20, 0x86,
    0xc6, 0xf6, 0x6b, 0x0c, 0x41, 0xaf, 0x6c, 0x2f, 0xda, 0x69, 0x57, 0x51, 0xd2, 0x9a, 0x87, 0x2c,
    0xd6, 0xd4, 0x2a, 0x8b, 0x95, 0xdf, 0x88, 0xb6, 0x0c, 0x0a, 0x30, 0xdd, 0x25, 0x24, 0x16, 0xea,
    0xf1, 0x22, 0x40, 0x96, 0xfc, 0x37, 0xb0, 0xb6, 0xcc, 0x04, 0x44, 0x8a, 0x5c, 0x9d, 0x0c, 0x36,
    0xef, 0x15, 0x09, 0x68, 0xec, 0x36, 0x67, 0x9f, 0x5f, 0x7b, 0x46, 0xc5, 0xb3, 0x83, 0x2f, 0x8a,
    0xd5, 0xd7, 0xf4, 0x54, 0x8e, 0x2b, 0x08, 0x97, 0x11, 0x0b, 0x95, 0xc9, 0x4f, 0x0c, 0x1e, 0xa6,
    0xb1, 0x82, 0x74, 0x7f, 0x32, 0x75, 0xcb, 0x8b, 0xa1, 0x52, 0xce, 0x87, 0x8a, 0x51, 0x23, 0xbc,
    0xb6, 0x23, 0x91, 0x8b, 0x65, 0x27, 0xfb, 0x1a, 0x15, 0x55, 0xf3, 0xba, 0x13, 0x99, 0x5d, 0xdc,
    0x8a, 0x80, 0x3a, 0x91, 0xba, 0xf2, 0x6a, 0x34, 0xd4, 0x0a, 0xb9, 0xb3, 0x92, 0xdf, 0xb2, 0xd2,
    0xe3, 0xb3, 0x0c, 0x39, 0x5a, 0x92, 0xbc, 0x4c, 0x8b, 0xac, 0x30, 0x66, 0x67, 0x21, 0xe9, 0x24,
    0x1f, 0x25, 0xbc, 0xdb, 0xa4, 0x45, 0x59, 0x19, 0x09, 0xc4, 0xe1, 0x28, 0x26, 0x1f, 0x59, 0xb0,
    0x0a, 0x41, 0x6b, 0xbd, 0x03, 0xfa, 0x8b, 0x7d, 0x9e, 0xb4, 0x55, 0x83, 0xb4, 0x1e, 0x1e, 0xac,
    0x22, 0xe6, 0x07, 0x7a, 0x1d, 0xb0, 0x34, 0xc0, 0xf4, 0xee, 0xfa, 0x9e, 0x0d, 0x8c, 0x9e, 0x10,
    0x3a, 0x28, 0x42, 0x99, 0x86, 0x23, 0x2b, 0x33, 0x87, 0xc5, 0x74, 0x68, 0xe4, 0x55, 0x1c, 0x7b,
    0xfe, 0x19, 0xca, 0x3e, 0x50, 0x67, 0x1d, 0x5e, 0xc2, 0xbb, 0x4d, 0x87, 0x2f, 0xcb, 0x53, 0xdf,
    0xa1, 0x2b, 0x3b, 0x48, 0x52, 0x7d, 0xcf, 0x35, 0xc6, 0xda, 0xf2, 0xfd, 0x04, 0xa4, 0x0c, 0x36,
    0x26, 0x1c, 0x25, 0xe0, 0xb9, 0xeb, 0xf4, 0x3d, 0xcf, 0xd9, 0xb9, 0xe8, 0x11, 0xf0, 0x04, 0xbd,
    0x6c, 0xf8, 0xea, 0x3f, 0xa8, 0x97, 0x45, 0xd8, 0xfa, 0x67, 0xde, 0xf6, 0x84, 0x26, 0xcf, 0x4f,
    0xba, 0xe5, 0x80, 0xa0, 0xcd, 0x8d, 0x03, 0xe1, 0x29, 0xd9, 0x2d, 0x8e, 0x59, 0x95, 0xff, 0x0b,
    0x3a, 0x80, 0xe9, 0xee, 0x1c, 0x89, 0x86, 0xf6, 0x6c, 0xcf, 0xcd, 0x88, 0xf1, 0x07, 0x5c, 0xf5,
    0x99, 0xad
};
#endif

PyTypeObject *init_KStatusNotifierItem(PyObject *module)
{
    if (SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX].type != nullptr)
        return SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX].type;

    Shiboken::AutoDecRef Sbk_KStatusNotifierItem_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KStatusNotifierItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KStatusNotifierItem",
        "KStatusNotifierItem*",
        &Sbk_KStatusNotifierItem_spec,
        &Shiboken::callCppDestructor< KStatusNotifierItem >,
        Sbk_KStatusNotifierItem_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KStatusNotifierItem_Type; // references _Sbk_KStatusNotifierItem_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KStatusNotifierItem_SignatureStrings);
#else
    InitSignatureBytes(pyType, KStatusNotifierItem_SignatureBytes, KStatusNotifierItem_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KStatusNotifierItem_PropertyStrings);
    SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KStatusNotifierItem_PythonToCpp_KStatusNotifierItem_PTR,
        is_KStatusNotifierItem_PythonToCpp_KStatusNotifierItem_PTR_Convertible,
        KStatusNotifierItem_PTR_CppToPython_KStatusNotifierItem);

    Shiboken::Conversions::registerConverterName(converter, "KStatusNotifierItem");
    Shiboken::Conversions::registerConverterName(converter, "KStatusNotifierItem*");
    Shiboken::Conversions::registerConverterName(converter, "KStatusNotifierItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KStatusNotifierItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KStatusNotifierItemWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KStatusNotifierItem_TypeF(), &Sbk_KStatusNotifierItem_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KStatusNotifierItem_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ItemStatus'.
    const char *ItemStatus_Initializer[] = {
        "Passive",
        "Active",
        "NeedsAttention",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ItemStatus_InitializerValues[] = {
        uint8_t(KStatusNotifierItem::ItemStatus::Passive),       //  0x01  1
        uint8_t(KStatusNotifierItem::ItemStatus::Active),        //  0x02  2
        uint8_t(KStatusNotifierItem::ItemStatus::NeedsAttention) //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KStatusNotifierItem_TypeF(),
        "1:KStatusNotifierItem.KStatusNotifierItem.ItemStatus",
        ItemStatus_Initializer, ItemStatus_InitializerValues);
    SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemStatus_IDX].type = EType;
    // Register converter for enum 'KStatusNotifierItem::ItemStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KStatusNotifierItem_ItemStatus_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KStatusNotifierItem_ItemStatus,
            is_Enum_PythonToCpp_KStatusNotifierItem_ItemStatus_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KStatusNotifierItem::ItemStatus");
        Shiboken::Conversions::registerConverterAlias(converter, "ItemStatus");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ItemStatus' enum.

    // Initialization of enum 'ItemCategory'.
    const char *ItemCategory_Initializer[] = {
        "ApplicationStatus",
        "Communications",
        "SystemServices",
        "Hardware",
        "Reserved",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ItemCategory_InitializerValues[] = {
        uint8_t(KStatusNotifierItem::ItemCategory::ApplicationStatus), //  0x01  1
        uint8_t(KStatusNotifierItem::ItemCategory::Communications),    //  0x02  2
        uint8_t(KStatusNotifierItem::ItemCategory::SystemServices),    //  0x03  3
        uint8_t(KStatusNotifierItem::ItemCategory::Hardware),          //  0x04  4
        uint8_t(KStatusNotifierItem::ItemCategory::Reserved)           //  0x81  129
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KStatusNotifierItem_TypeF(),
        "1:KStatusNotifierItem.KStatusNotifierItem.ItemCategory",
        ItemCategory_Initializer, ItemCategory_InitializerValues);
    SbkKStatusNotifierItemTypeStructs[SBK_KStatusNotifierItem_ItemCategory_IDX].type = EType;
    // Register converter for enum 'KStatusNotifierItem::ItemCategory'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KStatusNotifierItem_ItemCategory_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KStatusNotifierItem_ItemCategory,
            is_Enum_PythonToCpp_KStatusNotifierItem_ItemCategory_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KStatusNotifierItem::ItemCategory");
        Shiboken::Conversions::registerConverterAlias(converter, "ItemCategory");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ItemCategory' enum.

    PySide::Signal::registerSignals(pyType, &::KStatusNotifierItem::staticMetaObject);
    qRegisterMetaType< ::KStatusNotifierItem::ItemStatus >("KStatusNotifierItem::ItemStatus");
    qRegisterMetaType< ::KStatusNotifierItem::ItemCategory >("KStatusNotifierItem::ItemCategory");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KStatusNotifierItem::staticMetaObject, sizeof(KStatusNotifierItemWrapper));

    return pyType;
}
