
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kviewstateserializer_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qabstractitemmodel.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KViewStateSerializer_Type = nullptr;
static PyTypeObject *Sbk_KViewStateSerializer_TypeF(void)
{
    return _Sbk_KViewStateSerializer_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KViewStateSerializerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KViewStateSerializerWrapper::KViewStateSerializerWrapper(::QObject * parent) : KViewStateSerializer(parent)
{
}

void KViewStateSerializerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KViewStateSerializer", funcName, gil, pyOverride, event);
}

void KViewStateSerializerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KViewStateSerializer", funcName, gil, pyOverride, signal);
}

void KViewStateSerializerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KViewStateSerializer", funcName, gil, pyOverride, event);
}

void KViewStateSerializerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KViewStateSerializer", funcName, gil, pyOverride, signal);
}

bool KViewStateSerializerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KViewStateSerializer", funcName, gil, pyOverride, event);
}

bool KViewStateSerializerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KViewStateSerializer", funcName, gil, pyOverride, watched, event);
}

::QModelIndex KViewStateSerializerWrapper::indexFromConfigString(const ::QAbstractItemModel * model, const ::QString & key) const
{
    static const char *funcName = "indexFromConfigString";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KViewStateSerializer.indexFromConfigString");
        return {};
    }
    return sbk_o_indexFromConfigString("KViewStateSerializer", funcName, gil, pyOverride, model, key);
}

::QModelIndex KViewStateSerializerWrapper::sbk_o_indexFromConfigString(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QAbstractItemModel * model, const ::QString & key)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]), model),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]), model),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QModelIndex >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString KViewStateSerializerWrapper::indexToConfigString(const ::QModelIndex & index) const
{
    static const char *funcName = "indexToConfigString";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KViewStateSerializer.indexToConfigString");
        return ::QString();
    }
    return sbk_o_indexToConfigString("KViewStateSerializer", funcName, gil, pyOverride, index);
}

::QString KViewStateSerializerWrapper::sbk_o_indexToConfigString(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KViewStateSerializerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KViewStateSerializer_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KViewStateSerializer", funcName, gil, pyOverride, event);
}

const QMetaObject *KViewStateSerializerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KViewStateSerializer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KViewStateSerializerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KViewStateSerializer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KViewStateSerializerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KViewStateSerializerWrapper *>(this));
    }
    return KViewStateSerializer::qt_metacast(_clname);
}

KViewStateSerializerWrapper::~KViewStateSerializerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KViewStateSerializer_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KViewStateSerializer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KViewStateSerializer");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KViewStateSerializer >()))
        return -1;

    KViewStateSerializerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KViewStateSerializer", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KViewStateSerializer::KViewStateSerializer(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KViewStateSerializer(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KViewStateSerializer(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KViewStateSerializer(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KViewStateSerializerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KViewStateSerializerWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KViewStateSerializer >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KViewStateSerializerFunc_currentIndexKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentIndexKey()const
        QString cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->currentIndexKey();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KViewStateSerializerFunc_expansionKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // expansionKeys()const
        QStringList cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->expansionKeys();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KViewStateSerializerFunc_indexFromConfigString(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "indexFromConfigString", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KViewStateSerializer::indexFromConfigString(const QAbstractItemModel*,QString)const->QModelIndex
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // indexFromConfigString(const QAbstractItemModel*,QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "indexFromConfigString", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QAbstractItemModel *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // indexFromConfigString(const QAbstractItemModel*,QString)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KViewStateSerializer.indexFromConfigString");
                return {};
            }
            QModelIndex cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->indexFromConfigString(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KViewStateSerializerFunc_indexToConfigString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KViewStateSerializer::indexToConfigString(QModelIndex)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // indexToConfigString(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "indexToConfigString", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // indexToConfigString(QModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KViewStateSerializer.indexToConfigString");
                return {};
            }
            QString cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->indexToConfigString(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KViewStateSerializerFunc_restoreCurrentItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KViewStateSerializer::restoreCurrentItem(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // restoreCurrentItem(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "restoreCurrentItem", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // restoreCurrentItem(QString)
            cppSelf->restoreCurrentItem(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KViewStateSerializerFunc_restoreExpanded(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KViewStateSerializer::restoreExpanded(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // restoreExpanded(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "restoreExpanded", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // restoreExpanded(QStringList)
            cppSelf->restoreExpanded(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KViewStateSerializerFunc_restoreScrollState(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "restoreScrollState", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KViewStateSerializer::restoreScrollState(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // restoreScrollState(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "restoreScrollState", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // restoreScrollState(int,int)
            cppSelf->restoreScrollState(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KViewStateSerializerFunc_restoreSelection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KViewStateSerializer::restoreSelection(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // restoreSelection(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "restoreSelection", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // restoreSelection(QStringList)
            cppSelf->restoreSelection(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KViewStateSerializerFunc_restoreState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // restoreState()
        cppSelf->restoreState();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KViewStateSerializerFunc_scrollState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // scrollState()const
        std::pair<int,int> cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->scrollState();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_int_int_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KViewStateSerializerFunc_selectionKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectionKeys()const
        QStringList cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->selectionKeys();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KViewStateSerializerFunc_selectionModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectionModel()const
        QItemSelectionModel * cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->selectionModel();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QItemSelectionModel_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KViewStateSerializerFunc_setSelectionModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KViewStateSerializer::setSelectionModel(QItemSelectionModel*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QItemSelectionModel_IDX]), (pyArg)))) {
        overloadId = 0; // setSelectionModel(QItemSelectionModel*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectionModel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectionModel(QItemSelectionModel*)
            cppSelf->setSelectionModel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KViewStateSerializerFunc_setView(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KViewStateSerializer::setView(QAbstractItemView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractItemView_IDX]), (pyArg)))) {
        overloadId = 0; // setView(QAbstractItemView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setView", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setView(QAbstractItemView*)
            cppSelf->setView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KViewStateSerializerFunc_view(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // view()const
        QAbstractItemView * cppResult = const_cast<const ::KViewStateSerializer *>(cppSelf)->view();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractItemView_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KViewStateSerializer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KViewStateSerializer_methods[] = {
    {"currentIndexKey", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_currentIndexKey), METH_NOARGS, nullptr},
    {"expansionKeys", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_expansionKeys), METH_NOARGS, nullptr},
    {"indexFromConfigString", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_indexFromConfigString), METH_VARARGS, nullptr},
    {"indexToConfigString", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_indexToConfigString), METH_O, nullptr},
    {"restoreCurrentItem", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_restoreCurrentItem), METH_O, nullptr},
    {"restoreExpanded", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_restoreExpanded), METH_O, nullptr},
    {"restoreScrollState", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_restoreScrollState), METH_VARARGS, nullptr},
    {"restoreSelection", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_restoreSelection), METH_O, nullptr},
    {"restoreState", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_restoreState), METH_NOARGS, nullptr},
    {"scrollState", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_scrollState), METH_NOARGS, nullptr},
    {"selectionKeys", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_selectionKeys), METH_NOARGS, nullptr},
    {"selectionModel", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_selectionModel), METH_NOARGS, nullptr},
    {"setSelectionModel", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_setSelectionModel), METH_O, nullptr},
    {"setView", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_setView), METH_O, nullptr},
    {"view", reinterpret_cast<PyCFunction>(Sbk_KViewStateSerializerFunc_view), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KViewStateSerializer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KViewStateSerializer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KViewStateSerializerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KViewStateSerializer_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KViewStateSerializer_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KViewStateSerializer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KViewStateSerializer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KViewStateSerializer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KViewStateSerializer_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KViewStateSerializer_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KViewStateSerializer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KViewStateSerializer_spec = {
    "1:KWidgetsAddons.KViewStateSerializer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KViewStateSerializer_slots
};

} //extern "C"

static void *Sbk_KViewStateSerializer_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KViewStateSerializer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KViewStateSerializer_PythonToCpp_KViewStateSerializer_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KViewStateSerializer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KViewStateSerializer_PythonToCpp_KViewStateSerializer_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KViewStateSerializer_TypeF()))
        return KViewStateSerializer_PythonToCpp_KViewStateSerializer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KViewStateSerializer_PTR_CppToPython_KViewStateSerializer(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KViewStateSerializer *>(const_cast<void *>(cppIn)), Sbk_KViewStateSerializer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KViewStateSerializer_SignatureStrings[] = {
    "KWidgetsAddons.KViewStateSerializer(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KWidgetsAddons.KViewStateSerializer.currentIndexKey(self)->QString",
    "KWidgetsAddons.KViewStateSerializer.expansionKeys(self)->QStringList",
    "KWidgetsAddons.KViewStateSerializer.indexFromConfigString(self,model:PySide6.QtCore.QAbstractItemModel,key:QString)->PySide6.QtCore.QModelIndex",
    "KWidgetsAddons.KViewStateSerializer.indexToConfigString(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->QString",
    "KWidgetsAddons.KViewStateSerializer.restoreCurrentItem(self,indexString:QString)",
    "KWidgetsAddons.KViewStateSerializer.restoreExpanded(self,indexStrings:QStringList)",
    "KWidgetsAddons.KViewStateSerializer.restoreScrollState(self,verticalScoll:int,horizontalScroll:int)",
    "KWidgetsAddons.KViewStateSerializer.restoreSelection(self,indexStrings:QStringList)",
    "KWidgetsAddons.KViewStateSerializer.restoreState(self)",
    "KWidgetsAddons.KViewStateSerializer.scrollState(self)->std.pair[int, int]",
    "KWidgetsAddons.KViewStateSerializer.selectionKeys(self)->QStringList",
    "KWidgetsAddons.KViewStateSerializer.selectionModel(self)->PySide6.QtCore.QItemSelectionModel",
    "KWidgetsAddons.KViewStateSerializer.setSelectionModel(self,selectionModel:PySide6.QtCore.QItemSelectionModel)",
    "KWidgetsAddons.KViewStateSerializer.setView(self,view:PySide6.QtWidgets.QAbstractItemView)",
    "KWidgetsAddons.KViewStateSerializer.view(self)->PySide6.QtWidgets.QAbstractItemView",
    nullptr}; // Sentinel
#else
static constexpr size_t KViewStateSerializer_SignatureByteSize = 375;
static constexpr uint8_t KViewStateSerializer_SignatureBytes[375] = {
    0x78, 0xda, 0xad, 0x94, 0x4b, 0x6b, 0xc2, 0x40, 0x10, 0xc7, 0xef, 0x7e, 0x0a, 0x8f, 0x15, 0xd2,
    0x1c, 0x7b, 0x08, 0xb4, 0x20, 0xd2, 0x82, 0xa4, 0xa5, 0xca, 0xf6, 0x71, 0x10, 0x0f, 0x31, 0x3b,
    0xda, 0x6d, 0xd7, 0xdd, 0x30, 0x3b, 0x5a, 0xe3, 0xa7, 0xef, 0x6e, 0x12, 0xad, 0x49, 0x10, 0x37,
    0xb4, 0x97, 0x10, 0xe6, 0xf1, 0x9b, 0xff, 0x3c, 0x92, 0xf8, 0x5d, 0xf0, 0x15, 0x90, 0x19, 0x72,
    0xae, 0x95, 0x09, 0xe3, 0x37, 0x01, 0xdf, 0x8c, 0x12, 0x02, 0x06, 0x28, 0x12, 0x29, 0xf6, 0x80,
    0x57, 0x06, 0xe4, 0x32, 0xc8, 0x12, 0x04, 0x45, 0xd1, 0x24, 0x67, 0x82, 0xc3, 0x4d, 0x38, 0xa5,
    0x91, 0x46, 0x08, 0xa7, 0xcf, 0x8b, 0x4f, 0x48, 0xe9, 0x56, 0x6d, 0xa4, 0xcc, 0x08, 0x07, 0xbd,
    0xf8, 0x32, 0x2f, 0x4c, 0x37, 0xe8, 0x58, 0x63, 0xc5, 0x61, 0x17, 0x43, 0x5e, 0xf0, 0x07, 0xd7,
    0x77, 0x53, 0x46, 0x28, 0xd4, 0xca, 0x0b, 0x01, 0xbb, 0x2c, 0x51, 0x46, 0x68, 0x65, 0xf3, 0x4d,
    0x03, 0xf0, 0x28, 0x0c, 0x79, 0x41, 0x84, 0x13, 0xf0, 0x80, 0x7a, 0x3d, 0xd2, 0x6a, 0x29, 0x56,
    0x65, 0x76, 0xd9, 0xed, 0x5a, 0x73, 0x90, 0xad, 0x66, 0x87, 0x0b, 0x43, 0x98, 0xa4, 0x34, 0x26,
    0x58, 0x3f, 0xb9, 0x88, 0xe0, 0x0b, 0xf2, 0xa8, 0x2a, 0x6b, 0x05, 0x34, 0xe3, 0x8b, 0x98, 0xa2,
    0x4d, 0x7f, 0x3d, 0x2f, 0xba, 0xad, 0xa6, 0x70, 0x44, 0x94, 0x67, 0xd6, 0x12, 0xbe, 0x2a, 0xdb,
    0xf6, 0xec, 0x7c, 0xa9, 0xa0, 0xdf, 0xf4, 0x4d, 0x00, 0x8d, 0x9d, 0x89, 0x1d, 0xf9, 0x6f, 0xd4,
    0xbc, 0xe3, 0xc0, 0x11, 0x0c, 0x59, 0xd8, 0xa8, 0x5a, 0x9d, 0x1d, 0xc0, 0x89, 0xb4, 0x92, 0x73,
    0x1c, 0x44, 0x17, 0xe0, 0xbd, 0x5b, 0x24, 0x07, 0xde, 0xa2, 0x99, 0xe8, 0x64, 0x9d, 0x9d, 0x90,
    0x2c, 0x45, 0x2d, 0x65, 0xe1, 0x2c, 0xa9, 0x5b, 0x40, 0x12, 0x69, 0x22, 0x59, 0x6a, 0xed, 0x91,
    0x50, 0x14, 0x7c, 0x68, 0x14, 0x7b, 0xad, 0xc8, 0xd9, 0xb0, 0x32, 0x76, 0xab, 0x01, 0xd2, 0x9e,
    0xbd, 0x5d, 0xc4, 0x7f, 0xea, 0x3e, 0x2a, 0xf6, 0x4b, 0x33, 0x8d, 0x3e, 0xed, 0x46, 0x0d, 0xf1,
    0x30, 0x4b, 0x04, 0xce, 0x5c, 0x93, 0x7d, 0xfb, 0x98, 0xfb, 0x91, 0x0e, 0xdd, 0xfc, 0xe5, 0x6b,
    0x3a, 0x42, 0x8a, 0x23, 0x3b, 0x50, 0x9a, 0xb7, 0xe8, 0x2e, 0x87, 0xd5, 0x22, 0x3d, 0xe1, 0xc4,
    0xda, 0xfc, 0xa0, 0x5e, 0x33, 0xba, 0x5c, 0x6c, 0xe0, 0x5b, 0xcd, 0x99, 0xab, 0xeb, 0xb1, 0x6f,
    0x27, 0xe4, 0x2a, 0xbd, 0xfe, 0x33, 0x70, 0xd1, 0x7e, 0xe8, 0xed, 0x81, 0x5b, 0x9b, 0xcd, 0x59,
    0x68, 0xef, 0x07, 0xb7, 0x35, 0x1e, 0x71
};
#endif

PyTypeObject *init_KViewStateSerializer(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX].type;

    Shiboken::AutoDecRef Sbk_KViewStateSerializer_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KViewStateSerializer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KViewStateSerializer",
        "KViewStateSerializer*",
        &Sbk_KViewStateSerializer_spec,
        &Shiboken::callCppDestructor< KViewStateSerializer >,
        Sbk_KViewStateSerializer_Type_bases.object(),
        0);
    auto *pyType = Sbk_KViewStateSerializer_TypeF(); // references _Sbk_KViewStateSerializer_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KViewStateSerializer_SignatureStrings);
#else
    InitSignatureBytes(pyType, KViewStateSerializer_SignatureBytes, KViewStateSerializer_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KViewStateSerializer_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KViewStateSerializer_PythonToCpp_KViewStateSerializer_PTR,
        is_KViewStateSerializer_PythonToCpp_KViewStateSerializer_PTR_Convertible,
        KViewStateSerializer_PTR_CppToPython_KViewStateSerializer);

    Shiboken::Conversions::registerConverterName(converter, "KViewStateSerializer");
    Shiboken::Conversions::registerConverterName(converter, "KViewStateSerializer*");
    Shiboken::Conversions::registerConverterName(converter, "KViewStateSerializer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KViewStateSerializer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KViewStateSerializerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KViewStateSerializer_TypeF(), &Sbk_KViewStateSerializer_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KViewStateSerializer::staticMetaObject, sizeof(KViewStateSerializerWrapper));

    return pyType;
}
