/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-property.h"
#include "libical-glib-private.h"
#include "i-cal-derived-parameter.h"
#include "i-cal-parameter.h"
#include "i-cal-value.h"
#include "i-cal-derived-property.h"
#include "i-cal-derived-value.h"

G_DEFINE_TYPE (ICalProperty, i_cal_property, I_CAL_TYPE_OBJECT)

static void i_cal_property_class_init (G_GNUC_UNUSED ICalPropertyClass *klass)
{
}

static void i_cal_property_init (G_GNUC_UNUSED ICalProperty *self)
{
}

/**
 * i_cal_property_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalProperty *
i_cal_property_new_full (icalproperty *native, 
                         GObject *owner)
{
    ICalProperty *object;
    if (native == NULL)
        return NULL;
    
    
    object = i_cal_object_construct (I_CAL_TYPE_PROPERTY,
                            (gpointer) native,
                            (GDestroyNotify) icalproperty_free,
                            FALSE,
                            owner);

    return object;
}


/**
 * i_cal_property_new:
 * @kind: The kind of #ICalProperty to be created
 *
 * Creates a #ICalProperty of the target type.
 *
 * Returns: (transfer full): The newly created #ICalProperty with the type @kind.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_property_new (ICalPropertyKind kind)
{
	return i_cal_property_new_full (icalproperty_new ((icalproperty_kind) (kind)), NULL);
}

/**
 * i_cal_property_clone:
 * @prop: The #ICalProperty to be cloned
 *
 * Deeply clone a #ICalProperty.
 *
 * Returns: (transfer full): The newly created #ICalProperty deeply cloned from @prop.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_property_clone (ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return i_cal_property_new_full (icalproperty_new_clone ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop))), NULL);
}

/**
 * i_cal_property_new_from_string:
 * @str: The string used to construct a #ICalProperty
 *
 * Creates a #ICalProperty from a string.
 *
 * Returns: (transfer full): The newly created #ICalProperty from @str.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_property_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_property_new_full (icalproperty_new_from_string (str), NULL);
}

/**
 * i_cal_property_as_ical_string:
 * @prop: The #ICalProperty to be converted
 *
 * Converts a #ICalProperty to a string representation.
 *
 * Returns: (transfer full): The string representation of @prop.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_as_ical_string (ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return icalproperty_as_ical_string_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_free: (skip)
 * @prop: (transfer full): The #ICalProperty to be freed
 *
 * Frees a #ICalProperty.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_free (ICalProperty *prop)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));

	icalproperty_free ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_isa:
 * @property: The #ICalProperty which type is to be determined
 *
 * Gets the kind of #ICalProperty.
 *
 * Returns: The type of #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalPropertyKind
i_cal_property_isa (ICalProperty *property)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (property), I_CAL_NO_PROPERTY);

	return (ICalPropertyKind) (icalproperty_isa ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property))));
}

/**
 * i_cal_property_isa_property:
 * @property: The object whose native part to be checked
 *
 * Checks whether the native part of #ICalProperty is of the type icalproperty.
 *
 * Returns: 1 if the native part of @property is of the type icalproperty, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_isa_property (ICalProperty *property)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (property), 0);

	return icalproperty_isa_property ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)));
}

/**
 * i_cal_property_add_parameter:
 * @prop: The #ICalProperty to be set
 * @parameter: (transfer none): The parameter to be added into @prop
 *
 * Adds a #ICalParameter into the #ICalProperty. It behaves like set the copy of the #ICalParameter. Upon
 * completion the native part of #ICalParameter will be set to NULL.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_add_parameter (ICalProperty *prop, 
                              ICalParameter *parameter)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (I_CAL_IS_PARAMETER (parameter));

	i_cal_object_set_owner ((ICalObject *)parameter, (GObject *)prop);
	icalproperty_add_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (parameter)));
}

/**
 * i_cal_property_take_parameter: (skip)
 * @prop: The #ICalProperty to be set
 * @parameter: (transfer full): The parameter to be added into @prop
 *
 * Adds the @parameter into the @prop and free the @parameter.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_take_parameter (ICalProperty *prop, 
                               ICalParameter *parameter)
{
    g_return_if_fail(I_CAL_IS_PROPERTY(prop));
    g_return_if_fail(I_CAL_IS_PARAMETER(parameter));

    i_cal_property_add_parameter(prop, parameter);
    g_object_unref(parameter);
}

/**
 * i_cal_property_set_parameter:
 * @prop: The #ICalProperty to be set
 * @parameter: (transfer none): The parameter to be set into @prop
 *
 * Sets a #ICalParameter into the #ICalProperty. It behaves like set the copy of the #ICalParameter. Upon
 * completion the native part of #ICalParameter will be set to NULL.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_parameter (ICalProperty *prop, 
                              ICalParameter *parameter)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (I_CAL_IS_PARAMETER (parameter));

	i_cal_object_set_owner ((ICalObject *)parameter, (GObject *)prop);
	icalproperty_set_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (parameter)));
}

/**
 * i_cal_property_set_parameter_from_string:
 * @prop: The #ICalProperty to be set
 * @name: The name of the parameter
 * @value: The value of the parameter
 *
 * Sets the #ICalProperty with the parameter defined by the name and value.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_parameter_from_string (ICalProperty *prop, 
                                          const gchar *name, 
                                          const gchar *value)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);

	icalproperty_set_parameter_from_string ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name, value);
}

/**
 * i_cal_property_get_parameter_as_string:
 * @prop: The #ICalProperty to be queried
 * @name: The name of the target parameter
 *
 * Gets the string representation of the target parameter in the #ICalProperty.
 *
 * Returns: (transfer full): The string representation of the parameter.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_get_parameter_as_string (ICalProperty *prop, 
                                        const gchar *name)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (name != NULL, NULL);

	return icalproperty_get_parameter_as_string_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name);
}

/**
 * i_cal_property_remove_parameter_by_kind:
 * @prop: The #ICalProperty to be manipulated
 * @kind: The #ICalParameterKind to be removed
 *
 * Removes the target kind of the parameters in the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_remove_parameter_by_kind (ICalProperty *prop, 
                                         ICalParameterKind kind)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));

	icalproperty_remove_parameter_by_kind ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter_kind) (kind));
}

/**
 * i_cal_property_remove_parameter_by_name:
 * @prop: The #ICalProperty to be manipulated
 * @name: The name of the parameter to be removed
 *
 * Removes parameter in the #ICalProperty by name.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_remove_parameter_by_name (ICalProperty *prop, 
                                         const gchar *name)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (name != NULL);

	icalproperty_remove_parameter_by_name ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name);
}

/**
 * i_cal_property_remove_parameter_by_ref:
 * @prop: The #ICalProperty to be manipulated
 * @param: The #ICalParameter to be removed
 *
 * Removes the parameter in the #ICalProperty by ref.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_remove_parameter_by_ref (ICalProperty *prop, 
                                        ICalParameter *param)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (I_CAL_IS_PARAMETER (param));

	icalproperty_remove_parameter_by_ref ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (param)));
}

/**
 * i_cal_property_count_parameters:
 * @prop: The #ICalProperty to be checked
 *
 * Counts the parameters in the #ICalProperty.
 *
 * Returns: The count of the parameters in the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_count_parameters (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), 0);

	return icalproperty_count_parameters ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_get_first_parameter:
 * @prop: The #ICalProperty to be queried
 * @kind: The target kind of #ICalParameter to be retrieved
 *
 * Gets the first #ICalParameter from the parent #ICalProperty.
 *
 * Returns: (transfer full): The first #ICalParameter of @prop.
 *
 * Since: 1.0
 *
 **/
ICalParameter *
i_cal_property_get_first_parameter (ICalProperty *prop, 
                                    ICalParameterKind kind)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return i_cal_parameter_new_full (icalproperty_get_first_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter_kind) (kind)), (GObject *)prop);
}

/**
 * i_cal_property_get_next_parameter:
 * @prop: The #ICalProperty to be queried
 * @kind: The target kind of #ICalParameter to be retrieved
 *
 * Gets the next #ICalParameter from the parent #ICalProperty.
 *
 * Returns: (transfer full): The next #ICalParameter of @prop.
 *
 * Since: 1.0
 *
 **/
ICalParameter *
i_cal_property_get_next_parameter (ICalProperty *prop, 
                                   ICalParameterKind kind)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return i_cal_parameter_new_full (icalproperty_get_next_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter_kind) (kind)), (GObject *)prop);
}

/**
 * i_cal_property_set_value:
 * @prop: The target #ICalProperty
 * @value: The #ICalValue will be set as the property of @prop
 *
 * Sets the #ICalProperty with the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_value (ICalProperty *prop, 
                          ICalValue *value)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (I_CAL_IS_VALUE (value));

	i_cal_object_set_owner ((ICalObject *)prop, (GObject *)value);
	i_cal_object_set_owner ((ICalObject *)value, (GObject *)prop);
	icalproperty_set_value ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_property_take_value: (skip)
 * @prop: The target #ICalProperty
 * @value: (transfer full): The #ICalValue will be set as the property of @prop
 *
 * Sets the @prop with the @value and unrefs the @value.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_take_value (ICalProperty *prop, 
                           ICalValue *value)
{
    g_return_if_fail(I_CAL_IS_PROPERTY(prop));
    g_return_if_fail(I_CAL_IS_VALUE(value));

    i_cal_property_set_value(prop, value);
    g_object_unref(value);
}

/**
 * i_cal_property_set_value_from_string:
 * @prop: The #ICalProperty to be set
 * @value: The value used to construct the #ICalValue
 * @kind: The kind used to construct the #ICalValue
 *
 * Sets the #ICalProperty with the #ICalValue constructed from string.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_value_from_string (ICalProperty *prop, 
                                      const gchar *value, 
                                      const gchar *kind)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (value != NULL);
	g_return_if_fail (kind != NULL);

	icalproperty_set_value_from_string ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), value, kind);
}

/**
 * i_cal_property_get_value:
 * @prop: The #ICalProperty to be queried
 *
 * Gets the #ICalValue of #ICalProperty.
 *
 * Returns: (transfer full): The #ICalValue of @prop.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_property_get_value (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return i_cal_value_new_full (icalproperty_get_value ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop))), (GObject *)prop);
}

/**
 * i_cal_property_get_value_as_string:
 * @prop: The #ICalProperty to be queried
 *
 * Gets the string representation of the value in #ICalProperty.
 *
 * Returns: (transfer full): The string representation of the value of the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_get_value_as_string (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return icalproperty_get_value_as_string_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_value_set_parent:
 * @value: The child #ICalValue
 * @property: (nullable): The parent #ICalProperty
 *
 * Sets the parent property of a value.
 *
 * Since: 2.0
 *
 **/
void
i_cal_value_set_parent (ICalValue *value, 
                        ICalProperty *property)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	if(property)
		g_return_if_fail (I_CAL_IS_PROPERTY (property));

	icalvalue_set_parent ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), ((property)?((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property))):NULL));
}

/**
 * i_cal_value_get_parent:
 * @value: The child #ICalValue
 *
 * Gets the parent #ICalProperty of the specified #ICalValue.
 *
 * Returns: (transfer full) (nullable): The parent #ICalProperty
 *
 * Since: 3.0
 *
 **/
ICalProperty *
i_cal_value_get_parent (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_property_new_full (icalvalue_get_parent ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))), NULL);
}

/**
 * i_cal_parameter_set_parent:
 * @param: The child #ICalParameter
 * @property: (nullable): The parent #ICalProperty
 *
 * Sets the parent #ICalProperty of an #ICalParameter.
 *
 * Since: 3.0
 *
 **/
void
i_cal_parameter_set_parent (ICalParameter *param, 
                            ICalProperty *property)
{
	g_return_if_fail (I_CAL_IS_PARAMETER (param));
	if(property)
		g_return_if_fail (I_CAL_IS_PROPERTY (property));

	icalparameter_set_parent ((icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (param)), ((property)?((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property))):NULL));
}

/**
 * i_cal_parameter_get_parent:
 * @param: The child #ICalParameter
 *
 * Gets the parent #ICalProperty of the specified #ICalParameter.
 *
 * Returns: (transfer full) (nullable): The parent #ICalProperty
 *
 * Since: 3.0
 *
 **/
ICalProperty *
i_cal_parameter_get_parent (ICalParameter *param)
{
	g_return_val_if_fail (I_CAL_IS_PARAMETER (param), NULL);

	return i_cal_property_new_full (icalparameter_get_parent ((icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (param))), NULL);
}

/**
 * i_cal_property_set_x_name:
 * @prop: A #ICalProperty
 * @name: The name string
 *
 * Sets the name of x property for the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_x_name (ICalProperty *prop, 
                           const gchar *name)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (name != NULL);

	icalproperty_set_x_name ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name);
}

/**
 * i_cal_property_get_x_name:
 * @prop: A #ICalProperty
 *
 * Gets the name of x property.
 *
 * Returns: (nullable): The name of x property.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_get_x_name (ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return icalproperty_get_x_name ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_get_property_name:
 * @prop: A #ICalProperty
 *
 * Gets the property name of #ICalProperty.
 *
 * Returns: (transfer full): Property name of #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_get_property_name (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);

	return icalproperty_get_property_name_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_parameter_value_to_value_kind:
 * @value: A #ICalParameterValue
 *
 * Converts the #ICalParameterValue to #ICalValueKind.
 *
 * Returns: #ICalValueKind
 *
 * Since: 1.0
 *
 **/
ICalValueKind
i_cal_parameter_value_to_value_kind (ICalParameterValue value)
{
	return (ICalValueKind) (icalparameter_value_to_value_kind ((icalparameter_value) (value)));
}

/**
 * i_cal_property_kind_to_value_kind:
 * @kind: A #ICalPropertyKind
 *
 * Converts the #ICalPropertyKind to #ICalValueKind.
 *
 * Returns: The #ICalValueKind
 *
 * Since: 1.0
 *
 **/
ICalValueKind
i_cal_property_kind_to_value_kind (ICalPropertyKind kind)
{
	return (ICalValueKind) (icalproperty_kind_to_value_kind ((icalproperty_kind) (kind)));
}

/**
 * i_cal_value_kind_to_property_kind:
 * @kind: A #ICalValueKind
 *
 * Converts a #ICalValueKind to a #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyKind.
 *
 * Since: 1.0
 *
 **/
ICalPropertyKind
i_cal_value_kind_to_property_kind (ICalValueKind kind)
{
	return (ICalPropertyKind) (icalproperty_value_kind_to_kind ((icalvalue_kind) (kind)));
}

/**
 * i_cal_property_kind_to_string:
 * @kind: A #ICalPropertyKind
 *
 * Converts the #ICalPropertyKind to a string.
 *
 * Returns: The string representation of @kind.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_kind_to_string (ICalPropertyKind kind)
{
	return icalproperty_kind_to_string ((icalproperty_kind) (kind));
}

/**
 * i_cal_property_kind_from_string:
 * @string: A string representing #ICalPropertyKind
 *
 * Converts the string to #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyKind.
 *
 * Since: 1.0
 *
 **/
ICalPropertyKind
i_cal_property_kind_from_string (const gchar *string)
{
	g_return_val_if_fail (string != NULL, I_CAL_NO_PROPERTY);

	return (ICalPropertyKind) (icalproperty_string_to_kind (string));
}

/**
 * i_cal_property_kind_is_valid:
 * @kind: The #ICalPropertyKind
 *
 * Checks whether #ICalPropertyKind is valid.
 *
 * Returns: 1 if valid, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_property_kind_is_valid (const ICalPropertyKind kind)
{
	return icalproperty_kind_is_valid ((icalproperty_kind) (kind));
}

/**
 * i_cal_property_method_from_string:
 * @str: A string
 *
 * Converts the string to #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyMethod.
 *
 * Since: 1.0
 *
 **/
ICalPropertyMethod
i_cal_property_method_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_METHOD_NONE);

	return (ICalPropertyMethod) (icalproperty_string_to_method (str));
}

/**
 * i_cal_property_method_to_string:
 * @method: The #ICalPropertyMethod
 *
 * Converts the #ICalPropertyMethod to string.
 *
 * Returns: The string representation of #ICalPropertyMethod.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_method_to_string (ICalPropertyMethod method)
{
	return icalproperty_method_to_string ((icalproperty_method) (method));
}

/**
 * i_cal_property_enum_to_string:
 * @e: The enum to be converted
 *
 * Converts the enum to string.
 *
 * Returns: (transfer full): The string representation of @e.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_enum_to_string (gint e)
{
	return icalproperty_enum_to_string_r (e);
}

/**
 * i_cal_property_kind_and_string_to_enum:
 * @kind: The kind
 * @str: A string
 *
 * Converts a integer and string into an enum.
 *
 * Returns: The enum.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_kind_and_string_to_enum (const gint kind, 
                                        const gchar *str)
{
	g_return_val_if_fail (str != NULL, 0);

	return icalproperty_kind_and_string_to_enum (kind, str);
}

/**
 * i_cal_property_status_from_string:
 * @str: A string
 *
 * Converts the string to #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyStatus.
 *
 * Since: 1.0
 *
 **/
ICalPropertyStatus
i_cal_property_status_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_STATUS_NONE);

	return (ICalPropertyStatus) (icalproperty_string_to_status (str));
}

/**
 * i_cal_property_status_to_string:
 * @method: The #ICalPropertyStatus
 *
 * Converts the #ICalPropertyStatus to string.
 *
 * Returns: The string representation of #ICalPropertyStatus.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_status_to_string (ICalPropertyStatus method)
{
	return icalproperty_status_to_string ((icalproperty_status) (method));
}

/**
 * i_cal_property_kind_has_property:
 * @kind: A #ICalPropertyKind
 * @e: The enum to be checked
 *
 * Checks whether the enum belongs to the #ICalPropertyKind.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_kind_has_property (ICalPropertyKind kind, 
                                  gint e)
{
	return icalproperty_enum_belongs_to_property ((icalproperty_kind) (kind), e);
}
