/* user-avatar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from user-avatar.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define USER_AVATAR_AVATAR_SIZE 32
#define USER_AVATAR_AVATAR_MARGIN 6
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CACHED_IMAGE (cached_image_get_type ())
#define CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CACHED_IMAGE, CachedImage))
#define CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CACHED_IMAGE, CachedImageClass))
#define IS_CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CACHED_IMAGE))
#define IS_CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CACHED_IMAGE))
#define CACHED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CACHED_IMAGE, CachedImageClass))

typedef struct _CachedImage CachedImage;
typedef struct _CachedImageClass CachedImageClass;
typedef struct _CachedImagePrivate CachedImagePrivate;

#define TYPE_USER_AVATAR (user_avatar_get_type ())
#define USER_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_AVATAR, UserAvatar))
#define USER_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_AVATAR, UserAvatarClass))
#define IS_USER_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_AVATAR))
#define IS_USER_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_AVATAR))
#define USER_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_AVATAR, UserAvatarClass))

typedef struct _UserAvatar UserAvatar;
typedef struct _UserAvatarClass UserAvatarClass;
typedef struct _UserAvatarPrivate UserAvatarPrivate;
enum  {
	USER_AVATAR_0_PROPERTY,
	USER_AVATAR_AVATAR_PATH_PROPERTY,
	USER_AVATAR_IS_SMALL_PROPERTY,
	USER_AVATAR_NUM_PROPERTIES
};
static GParamSpec* user_avatar_properties[USER_AVATAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CachedImage {
	GtkImage parent_instance;
	CachedImagePrivate * priv;
};

struct _CachedImageClass {
	GtkImageClass parent_class;
};

struct _UserAvatar {
	CachedImage parent_instance;
	UserAvatarPrivate * priv;
};

struct _UserAvatarClass {
	CachedImageClass parent_class;
};

struct _UserAvatarPrivate {
	gchar* _avatar_path;
	gboolean _is_small;
};

static gint UserAvatar_private_offset;
static gpointer user_avatar_parent_class = NULL;

VALA_EXTERN GType cached_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CachedImage, g_object_unref)
VALA_EXTERN GType user_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UserAvatar, g_object_unref)
VALA_EXTERN UserAvatar* user_avatar_new (void);
VALA_EXTERN UserAvatar* user_avatar_construct (GType object_type);
static void user_avatar_setup_avatar (UserAvatar* self);
static void user_avatar_update_avatar (UserAvatar* self);
VALA_EXTERN const gchar* user_avatar_get_avatar_path (UserAvatar* self);
VALA_EXTERN void cached_image_set_pixbuf (CachedImage* self,
                              GdkPixbuf* pixbuf);
VALA_EXTERN void user_avatar_set_avatar_path (UserAvatar* self,
                                  const gchar* value);
VALA_EXTERN gboolean user_avatar_get_is_small (UserAvatar* self);
VALA_EXTERN void user_avatar_set_is_small (UserAvatar* self,
                               gboolean value);
static void user_avatar_finalize (GObject * obj);
static GType user_avatar_get_type_once (void);
static void _vala_user_avatar_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_user_avatar_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
user_avatar_get_instance_private (UserAvatar* self)
{
	return G_STRUCT_MEMBER_P (self, UserAvatar_private_offset);
}

UserAvatar*
user_avatar_construct (GType object_type)
{
	UserAvatar * self = NULL;
#line 27 "../src/user-avatar.vala"
	self = (UserAvatar*) g_object_new (object_type, NULL);
#line 28 "../src/user-avatar.vala"
	user_avatar_setup_avatar (self);
#line 25 "../src/user-avatar.vala"
	return self;
#line 141 "user-avatar.c"
}

UserAvatar*
user_avatar_new (void)
{
#line 25 "../src/user-avatar.vala"
	return user_avatar_construct (TYPE_USER_AVATAR);
#line 149 "user-avatar.c"
}

static void
user_avatar_setup_avatar (UserAvatar* self)
{
#line 31 "../src/user-avatar.vala"
	g_return_if_fail (self != NULL);
#line 34 "../src/user-avatar.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, USER_AVATAR_AVATAR_SIZE, USER_AVATAR_AVATAR_SIZE);
#line 35 "../src/user-avatar.vala"
	gtk_widget_set_margin_right ((GtkWidget*) self, USER_AVATAR_AVATAR_MARGIN);
#line 36 "../src/user-avatar.vala"
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
#line 37 "../src/user-avatar.vala"
	gtk_widget_set_hexpand ((GtkWidget*) self, FALSE);
#line 38 "../src/user-avatar.vala"
	gtk_widget_set_vexpand ((GtkWidget*) self, FALSE);
#line 167 "user-avatar.c"
}

static void
user_avatar_update_avatar (UserAvatar* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 41 "../src/user-avatar.vala"
	g_return_if_fail (self != NULL);
#line 43 "../src/user-avatar.vala"
	_tmp0_ = user_avatar_get_avatar_path (self);
#line 43 "../src/user-avatar.vala"
	_tmp1_ = _tmp0_;
#line 43 "../src/user-avatar.vala"
	if (_tmp1_ != NULL) {
#line 184 "user-avatar.c"
		{
			gint scale_factor = 0;
			gint _tmp2_ = 0;
			gint pixel_size = 0;
			GdkPixbuf* pixbuf = NULL;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			GdkPixbuf* _tmp5_;
			cairo_surface_t* surface = NULL;
			cairo_surface_t* _tmp6_;
			cairo_t* cr = NULL;
			cairo_surface_t* _tmp7_;
			cairo_t* _tmp8_;
			cairo_t* _tmp9_;
			cairo_t* _tmp10_;
			cairo_t* _tmp11_;
			GdkPixbuf* _tmp12_;
			cairo_t* _tmp13_;
			GdkPixbuf* final_pixbuf = NULL;
			cairo_surface_t* _tmp14_;
			GdkPixbuf* _tmp15_;
			GdkPixbuf* _tmp16_;
#line 48 "../src/user-avatar.vala"
			scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) self);
#line 49 "../src/user-avatar.vala"
			if (scale_factor > 1) {
#line 49 "../src/user-avatar.vala"
				_tmp2_ = 2;
#line 213 "user-avatar.c"
			} else {
#line 49 "../src/user-avatar.vala"
				_tmp2_ = 1;
#line 217 "user-avatar.c"
			}
#line 49 "../src/user-avatar.vala"
			pixel_size = USER_AVATAR_AVATAR_SIZE * _tmp2_;
#line 51 "../src/user-avatar.vala"
			_tmp3_ = user_avatar_get_avatar_path (self);
#line 51 "../src/user-avatar.vala"
			_tmp4_ = _tmp3_;
#line 51 "../src/user-avatar.vala"
			_tmp5_ = gdk_pixbuf_new_from_file_at_scale (_tmp4_, pixel_size, pixel_size, TRUE, &_inner_error0_);
#line 51 "../src/user-avatar.vala"
			pixbuf = _tmp5_;
#line 51 "../src/user-avatar.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 231 "user-avatar.c"
				goto __catch0_g_error;
			}
#line 59 "../src/user-avatar.vala"
			_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, pixel_size, pixel_size);
#line 59 "../src/user-avatar.vala"
			surface = _tmp6_;
#line 64 "../src/user-avatar.vala"
			_tmp7_ = surface;
#line 64 "../src/user-avatar.vala"
			_tmp8_ = cairo_create (_tmp7_);
#line 64 "../src/user-avatar.vala"
			cr = _tmp8_;
#line 67 "../src/user-avatar.vala"
			_tmp9_ = cr;
#line 67 "../src/user-avatar.vala"
			cairo_arc (_tmp9_, pixel_size / 2.0, pixel_size / 2.0, pixel_size / 2.0, (gdouble) 0, 2 * G_PI);
#line 74 "../src/user-avatar.vala"
			_tmp10_ = cr;
#line 74 "../src/user-avatar.vala"
			cairo_clip (_tmp10_);
#line 77 "../src/user-avatar.vala"
			_tmp11_ = cr;
#line 77 "../src/user-avatar.vala"
			_tmp12_ = pixbuf;
#line 77 "../src/user-avatar.vala"
			gdk_cairo_set_source_pixbuf (_tmp11_, _tmp12_, (gdouble) 0, (gdouble) 0);
#line 78 "../src/user-avatar.vala"
			_tmp13_ = cr;
#line 78 "../src/user-avatar.vala"
			cairo_paint (_tmp13_);
#line 81 "../src/user-avatar.vala"
			_tmp14_ = surface;
#line 81 "../src/user-avatar.vala"
			_tmp15_ = gdk_pixbuf_get_from_surface (_tmp14_, 0, 0, pixel_size, pixel_size);
#line 81 "../src/user-avatar.vala"
			final_pixbuf = _tmp15_;
#line 89 "../src/user-avatar.vala"
			_tmp16_ = final_pixbuf;
#line 89 "../src/user-avatar.vala"
			cached_image_set_pixbuf ((CachedImage*) self, _tmp16_);
#line 90 "../src/user-avatar.vala"
			gtk_widget_show ((GtkWidget*) self);
#line 45 "../src/user-avatar.vala"
			_g_object_unref0 (final_pixbuf);
#line 45 "../src/user-avatar.vala"
			_cairo_destroy0 (cr);
#line 45 "../src/user-avatar.vala"
			_cairo_surface_destroy0 (surface);
#line 45 "../src/user-avatar.vala"
			_g_object_unref0 (pixbuf);
#line 282 "user-avatar.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
#line 45 "../src/user-avatar.vala"
			e = _inner_error0_;
#line 45 "../src/user-avatar.vala"
			_inner_error0_ = NULL;
#line 94 "../src/user-avatar.vala"
			_tmp17_ = e;
#line 94 "../src/user-avatar.vala"
			_tmp18_ = _tmp17_->message;
#line 94 "../src/user-avatar.vala"
			g_warning ("user-avatar.vala:94: Failed to load avatar: %s", _tmp18_);
#line 95 "../src/user-avatar.vala"
			gtk_widget_hide ((GtkWidget*) self);
#line 45 "../src/user-avatar.vala"
			_g_error_free0 (e);
#line 304 "user-avatar.c"
		}
		__finally0:
#line 45 "../src/user-avatar.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 45 "../src/user-avatar.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 45 "../src/user-avatar.vala"
			g_clear_error (&_inner_error0_);
#line 45 "../src/user-avatar.vala"
			return;
#line 315 "user-avatar.c"
		}
	} else {
#line 100 "../src/user-avatar.vala"
		gtk_widget_hide ((GtkWidget*) self);
#line 320 "user-avatar.c"
	}
}

const gchar*
user_avatar_get_avatar_path (UserAvatar* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 9 "../src/user-avatar.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 9 "../src/user-avatar.vala"
	_tmp0_ = self->priv->_avatar_path;
#line 9 "../src/user-avatar.vala"
	result = _tmp0_;
#line 9 "../src/user-avatar.vala"
	return result;
#line 337 "user-avatar.c"
}

void
user_avatar_set_avatar_path (UserAvatar* self,
                             const gchar* value)
{
	gchar* _tmp0_;
#line 10 "../src/user-avatar.vala"
	g_return_if_fail (self != NULL);
#line 11 "../src/user-avatar.vala"
	_tmp0_ = g_strdup (value);
#line 11 "../src/user-avatar.vala"
	_g_free0 (self->priv->_avatar_path);
#line 11 "../src/user-avatar.vala"
	self->priv->_avatar_path = _tmp0_;
#line 12 "../src/user-avatar.vala"
	user_avatar_update_avatar (self);
#line 10 "../src/user-avatar.vala"
	g_object_notify_by_pspec ((GObject *) self, user_avatar_properties[USER_AVATAR_AVATAR_PATH_PROPERTY]);
#line 357 "user-avatar.c"
}

gboolean
user_avatar_get_is_small (UserAvatar* self)
{
	gboolean result;
#line 18 "../src/user-avatar.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 18 "../src/user-avatar.vala"
	result = self->priv->_is_small;
#line 18 "../src/user-avatar.vala"
	return result;
#line 370 "user-avatar.c"
}

void
user_avatar_set_is_small (UserAvatar* self,
                          gboolean value)
{
#line 19 "../src/user-avatar.vala"
	g_return_if_fail (self != NULL);
#line 20 "../src/user-avatar.vala"
	self->priv->_is_small = value;
#line 21 "../src/user-avatar.vala"
	user_avatar_update_avatar (self);
#line 19 "../src/user-avatar.vala"
	g_object_notify_by_pspec ((GObject *) self, user_avatar_properties[USER_AVATAR_IS_SMALL_PROPERTY]);
#line 385 "user-avatar.c"
}

static void
user_avatar_class_init (UserAvatarClass * klass,
                        gpointer klass_data)
{
#line 1 "../src/user-avatar.vala"
	user_avatar_parent_class = g_type_class_peek_parent (klass);
#line 1 "../src/user-avatar.vala"
	g_type_class_adjust_private_offset (klass, &UserAvatar_private_offset);
#line 1 "../src/user-avatar.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_user_avatar_get_property;
#line 1 "../src/user-avatar.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_user_avatar_set_property;
#line 1 "../src/user-avatar.vala"
	G_OBJECT_CLASS (klass)->finalize = user_avatar_finalize;
#line 1 "../src/user-avatar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_AVATAR_AVATAR_PATH_PROPERTY, user_avatar_properties[USER_AVATAR_AVATAR_PATH_PROPERTY] = g_param_spec_string ("avatar-path", "avatar-path", "avatar-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1 "../src/user-avatar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_AVATAR_IS_SMALL_PROPERTY, user_avatar_properties[USER_AVATAR_IS_SMALL_PROPERTY] = g_param_spec_boolean ("is-small", "is-small", "is-small", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 406 "user-avatar.c"
}

static void
user_avatar_instance_init (UserAvatar * self,
                           gpointer klass)
{
#line 1 "../src/user-avatar.vala"
	self->priv = user_avatar_get_instance_private (self);
#line 16 "../src/user-avatar.vala"
	self->priv->_is_small = FALSE;
#line 417 "user-avatar.c"
}

static void
user_avatar_finalize (GObject * obj)
{
	UserAvatar * self;
#line 1 "../src/user-avatar.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_AVATAR, UserAvatar);
#line 6 "../src/user-avatar.vala"
	_g_free0 (self->priv->_avatar_path);
#line 1 "../src/user-avatar.vala"
	G_OBJECT_CLASS (user_avatar_parent_class)->finalize (obj);
#line 430 "user-avatar.c"
}

static GType
user_avatar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserAvatarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_avatar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserAvatar), 0, (GInstanceInitFunc) user_avatar_instance_init, NULL };
	GType user_avatar_type_id;
	user_avatar_type_id = g_type_register_static (TYPE_CACHED_IMAGE, "UserAvatar", &g_define_type_info, 0);
	UserAvatar_private_offset = g_type_add_instance_private (user_avatar_type_id, sizeof (UserAvatarPrivate));
	return user_avatar_type_id;
}

GType
user_avatar_get_type (void)
{
	static volatile gsize user_avatar_type_id__once = 0;
	if (g_once_init_enter (&user_avatar_type_id__once)) {
		GType user_avatar_type_id;
		user_avatar_type_id = user_avatar_get_type_once ();
		g_once_init_leave (&user_avatar_type_id__once, user_avatar_type_id);
	}
	return user_avatar_type_id__once;
}

static void
_vala_user_avatar_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	UserAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_AVATAR, UserAvatar);
#line 1 "../src/user-avatar.vala"
	switch (property_id) {
#line 1 "../src/user-avatar.vala"
		case USER_AVATAR_AVATAR_PATH_PROPERTY:
#line 1 "../src/user-avatar.vala"
		g_value_set_string (value, user_avatar_get_avatar_path (self));
#line 1 "../src/user-avatar.vala"
		break;
#line 1 "../src/user-avatar.vala"
		case USER_AVATAR_IS_SMALL_PROPERTY:
#line 1 "../src/user-avatar.vala"
		g_value_set_boolean (value, user_avatar_get_is_small (self));
#line 1 "../src/user-avatar.vala"
		break;
#line 477 "user-avatar.c"
		default:
#line 1 "../src/user-avatar.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 1 "../src/user-avatar.vala"
		break;
#line 483 "user-avatar.c"
	}
}

static void
_vala_user_avatar_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	UserAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_AVATAR, UserAvatar);
#line 1 "../src/user-avatar.vala"
	switch (property_id) {
#line 1 "../src/user-avatar.vala"
		case USER_AVATAR_AVATAR_PATH_PROPERTY:
#line 1 "../src/user-avatar.vala"
		user_avatar_set_avatar_path (self, g_value_get_string (value));
#line 1 "../src/user-avatar.vala"
		break;
#line 1 "../src/user-avatar.vala"
		case USER_AVATAR_IS_SMALL_PROPERTY:
#line 1 "../src/user-avatar.vala"
		user_avatar_set_is_small (self, g_value_get_boolean (value));
#line 1 "../src/user-avatar.vala"
		break;
#line 509 "user-avatar.c"
		default:
#line 1 "../src/user-avatar.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 1 "../src/user-avatar.vala"
		break;
#line 515 "user-avatar.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

