/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Register Bank Source Fragments                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_REGBANK_DECLARATIONS
#undef GET_REGBANK_DECLARATIONS
namespace llvm {
namespace RISCV {
enum : unsigned {
  InvalidRegBankID = ~0u,
  FPRBRegBankID = 0,
  GPRBRegBankID = 1,
  VRBRegBankID = 2,
  NumRegisterBanks,
};
} // end namespace RISCV
} // end namespace llvm
#endif // GET_REGBANK_DECLARATIONS

#ifdef GET_TARGET_REGBANK_CLASS
#undef GET_TARGET_REGBANK_CLASS
private:
  static const RegisterBank *RegBanks[];
  static const unsigned Sizes[];

public:
  const RegisterBank &getRegBankFromRegClass(const TargetRegisterClass &RC, LLT Ty) const override;
protected:
  RISCVGenRegisterBankInfo(unsigned HwMode = 0);

#endif // GET_TARGET_REGBANK_CLASS

#ifdef GET_TARGET_REGBANK_IMPL
#undef GET_TARGET_REGBANK_IMPL
namespace llvm {
namespace RISCV {
const uint32_t FPRBRegBankCoverageData[] = {
    // 0-31
    (1u << (RISCV::FPR16RegClassID - 0)) |
    (1u << (RISCV::FPR32RegClassID - 0)) |
    (1u << (RISCV::FPR16CRegClassID - 0)) |
    (1u << (RISCV::FPR32CRegClassID - 0)) |
    0,
    // 32-63
    (1u << (RISCV::FPR64RegClassID - 32)) |
    0,
    // 64-95
    (1u << (RISCV::FPR64CRegClassID - 64)) |
    0,
    // 96-127
    0,
};
const uint32_t GPRBRegBankCoverageData[] = {
    // 0-31
    (1u << (RISCV::GPRRegClassID - 0)) |
    (1u << (RISCV::GPRF16RegClassID - 0)) |
    (1u << (RISCV::GPRF32RegClassID - 0)) |
    (1u << (RISCV::GPRNoX0RegClassID - 0)) |
    (1u << (RISCV::GPRF16NoX0RegClassID - 0)) |
    (1u << (RISCV::GPRF32NoX0RegClassID - 0)) |
    (1u << (RISCV::GPRNoX0X2RegClassID - 0)) |
    (1u << (RISCV::GPRNoX0X2_and_GPRNoX31RegClassID - 0)) |
    (1u << (RISCV::GPRJALR_and_GPRNoX31RegClassID - 0)) |
    (1u << (RISCV::GPRJALRNonX7_and_GPRNoX31RegClassID - 0)) |
    (1u << (RISCV::GPRNoX31_and_GPRTCNonX7RegClassID - 0)) |
    (1u << (RISCV::GPRC_and_GPRTCRegClassID - 0)) |
    (1u << (RISCV::GPRF16CRegClassID - 0)) |
    (1u << (RISCV::GPRF32CRegClassID - 0)) |
    (1u << (RISCV::GPRCRegClassID - 0)) |
    (1u << (RISCV::SR07RegClassID - 0)) |
    (1u << (RISCV::GPRNoX31_and_GPRTCRegClassID - 0)) |
    (1u << (RISCV::GPRJALRRegClassID - 0)) |
    (1u << (RISCV::GPRJALRNonX7RegClassID - 0)) |
    (1u << (RISCV::GPRTCNonX7RegClassID - 0)) |
    (1u << (RISCV::GPRTCRegClassID - 0)) |
    (1u << (RISCV::GPRNoX0_and_GPRNoX31RegClassID - 0)) |
    (1u << (RISCV::GPRNoX31RegClassID - 0)) |
    0,
    // 32-63
    (1u << (RISCV::GPRC_and_SR07RegClassID - 32)) |
    (1u << (RISCV::GPRX7RegClassID - 32)) |
    (1u << (RISCV::GPRX1X5RegClassID - 32)) |
    (1u << (RISCV::GPRX1RegClassID - 32)) |
    (1u << (RISCV::GPRX5RegClassID - 32)) |
    (1u << (RISCV::SPRegClassID - 32)) |
    (1u << (RISCV::GPRX0RegClassID - 32)) |
    0,
    // 64-95
    0,
    // 96-127
    0,
};
const uint32_t VRBRegBankCoverageData[] = {
    // 0-31
    0,
    // 32-63
    (1u << (RISCV::VMRegClassID - 32)) |
    (1u << (RISCV::VRRegClassID - 32)) |
    0,
    // 64-95
    (1u << (RISCV::VRNoV0RegClassID - 64)) |
    (1u << (RISCV::VRM2RegClassID - 64)) |
    (1u << (RISCV::VRM2NoV0RegClassID - 64)) |
    (1u << (RISCV::VRM4RegClassID - 64)) |
    (1u << (RISCV::VRM4NoV0RegClassID - 64)) |
    (1u << (RISCV::VMV0RegClassID - 64)) |
    (1u << (RISCV::VRM2_with_sub_vrm1_0_in_VMV0RegClassID - 64)) |
    (1u << (RISCV::VRM4_with_sub_vrm1_0_in_VMV0RegClassID - 64)) |
    0,
    // 96-127
    (1u << (RISCV::VRM8RegClassID - 96)) |
    (1u << (RISCV::VRM8NoV0RegClassID - 96)) |
    (1u << (RISCV::VRM8_with_sub_vrm4_0_in_VRM4_with_sub_vrm1_0_in_VMV0RegClassID - 96)) |
    0,
};

constexpr RegisterBank FPRBRegBank(/* ID */ RISCV::FPRBRegBankID, /* Name */ "FPRB", /* CoveredRegClasses */ FPRBRegBankCoverageData, /* NumRegClasses */ 111);
constexpr RegisterBank GPRBRegBank(/* ID */ RISCV::GPRBRegBankID, /* Name */ "GPRB", /* CoveredRegClasses */ GPRBRegBankCoverageData, /* NumRegClasses */ 111);
constexpr RegisterBank VRBRegBank(/* ID */ RISCV::VRBRegBankID, /* Name */ "VRB", /* CoveredRegClasses */ VRBRegBankCoverageData, /* NumRegClasses */ 111);
} // end namespace RISCV

const RegisterBank *RISCVGenRegisterBankInfo::RegBanks[] = {
    &RISCV::FPRBRegBank,
    &RISCV::GPRBRegBank,
    &RISCV::VRBRegBank,
};

const unsigned RISCVGenRegisterBankInfo::Sizes[] = {
    // Mode = 0 (Default)
    64,
    32,
    512,
    // Mode = 1 (RV64)
    64,
    64,
    512,
};

RISCVGenRegisterBankInfo::RISCVGenRegisterBankInfo(unsigned HwMode)
    : RegisterBankInfo(RegBanks, RISCV::NumRegisterBanks, Sizes, HwMode) {
  // Assert that RegBank indices match their ID's
#ifndef NDEBUG
  for (auto RB : enumerate(RegBanks))
    assert(RB.index() == RB.value()->getID() && "Index != ID");
#endif // NDEBUG
}
const RegisterBank &
RISCVGenRegisterBankInfo::getRegBankFromRegClass(const TargetRegisterClass &RC, LLT) const {
  constexpr uint32_t InvalidRegBankID = uint32_t(RISCV::InvalidRegBankID) & 3;
  static const uint32_t RegClass2RegBank[7] = {
    (uint32_t(RISCV::FPRBRegBankID) << 0) | // FPR16RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 2) | // GPRF16RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 4) | // GPRF16NoX0RegClassID
    (uint32_t(RISCV::FPRBRegBankID) << 6) | // FPR16CRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 8) | // GPRF16CRegClassID
    (uint32_t(InvalidRegBankID) << 10) |
    (uint32_t(RISCV::FPRBRegBankID) << 12) | // FPR32RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 14) | // GPRRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 16) | // GPRF32RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 18) | // GPRF32NoX0RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 20) | // GPRNoX0RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 22) | // GPRNoX31RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 24) | // GPRNoX0X2RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 26) | // GPRNoX0_and_GPRNoX31RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 28) | // GPRNoX0X2_and_GPRNoX31RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 30), // GPRJALRRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 0) | // GPRJALRNonX7RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 2) | // GPRJALR_and_GPRNoX31RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 4) | // GPRJALRNonX7_and_GPRNoX31RegClassID
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(RISCV::GPRBRegBankID) << 8) | // GPRTCRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 10) | // GPRNoX31_and_GPRTCRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 12) | // GPRTCNonX7RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 14) | // GPRNoX31_and_GPRTCNonX7RegClassID
    (uint32_t(RISCV::FPRBRegBankID) << 16) | // FPR32CRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 18) | // GPRCRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 20) | // GPRF32CRegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 22) | // SR07RegClassID
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(RISCV::GPRBRegBankID) << 26) | // GPRC_and_GPRTCRegClassID
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(RISCV::GPRBRegBankID) << 0) | // GPRC_and_SR07RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 2) | // GPRX1X5RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 4) | // GPRX0RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 6) | // GPRX1RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 8) | // GPRX5RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 10) | // GPRX7RegClassID
    (uint32_t(RISCV::GPRBRegBankID) << 12) | // SPRegClassID
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(InvalidRegBankID) << 26) |
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(InvalidRegBankID) << 2) |
    (uint32_t(InvalidRegBankID) << 4) |
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(InvalidRegBankID) << 8) |
    (uint32_t(InvalidRegBankID) << 10) |
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(RISCV::FPRBRegBankID) << 26) | // FPR64RegClassID
    (uint32_t(RISCV::VRBRegBankID) << 28) | // VMRegClassID
    (uint32_t(RISCV::VRBRegBankID) << 30), // VRRegClassID
    (uint32_t(RISCV::VRBRegBankID) << 0) | // VRNoV0RegClassID
    (uint32_t(RISCV::FPRBRegBankID) << 2) | // FPR64CRegClassID
    (uint32_t(RISCV::VRBRegBankID) << 4) | // VMV0RegClassID
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(InvalidRegBankID) << 8) |
    (uint32_t(RISCV::VRBRegBankID) << 10) | // VRM2RegClassID
    (uint32_t(RISCV::VRBRegBankID) << 12) | // VRM2NoV0RegClassID
    (uint32_t(RISCV::VRBRegBankID) << 14) | // VRM2_with_sub_vrm1_0_in_VMV0RegClassID
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(InvalidRegBankID) << 26) |
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(InvalidRegBankID) << 2) |
    (uint32_t(RISCV::VRBRegBankID) << 4) | // VRM4RegClassID
    (uint32_t(RISCV::VRBRegBankID) << 6) | // VRM4NoV0RegClassID
    (uint32_t(RISCV::VRBRegBankID) << 8) | // VRM4_with_sub_vrm1_0_in_VMV0RegClassID
    (uint32_t(InvalidRegBankID) << 10) |
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(InvalidRegBankID) << 26) |
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(InvalidRegBankID) << 2) |
    (uint32_t(InvalidRegBankID) << 4) |
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(InvalidRegBankID) << 8) |
    (uint32_t(InvalidRegBankID) << 10) |
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(RISCV::VRBRegBankID) << 18) | // VRM8RegClassID
    (uint32_t(RISCV::VRBRegBankID) << 20) | // VRM8NoV0RegClassID
    (uint32_t(RISCV::VRBRegBankID) << 22) // VRM8_with_sub_vrm4_0_in_VRM4_with_sub_vrm1_0_in_VMV0RegClassID
  };
  const unsigned RegClassID = RC.getID();
  if (LLVM_LIKELY(RegClassID < 108)) {
    unsigned RegBankID = (RegClass2RegBank[RegClassID / 16] >> ((RegClassID % 16) * 2)) & 3;
    if (RegBankID != InvalidRegBankID)
      return getRegBank(RegBankID);
  }
  llvm_unreachable(llvm::Twine("Target needs to handle register class ID 0x").concat(llvm::Twine::utohexstr(RegClassID)).str().c_str());
}
} // end namespace llvm
#endif // GET_TARGET_REGBANK_IMPL
