/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 91;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s32,
  GILLT_p0s64,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 32),
  LLT::pointer(0, 64),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicbopBit = 67,
  Feature_HasStdExtZicondBit = 68,
  Feature_HasStdExtZimopBit = 66,
  Feature_HasStdExtZicfilpBit = 2,
  Feature_NoStdExtZicfilpBit = 1,
  Feature_HasStdExtZmmulBit = 19,
  Feature_HasStdExtMBit = 20,
  Feature_HasStdExtABit = 22,
  Feature_HasStdExtZtsoBit = 24,
  Feature_NotHasStdExtZtsoBit = 23,
  Feature_HasStdExtZabhaBit = 27,
  Feature_HasStdExtZacasBit = 26,
  Feature_NoStdExtZacasBit = 25,
  Feature_HasStdExtFBit = 5,
  Feature_HasStdExtDBit = 7,
  Feature_HasStdExtZfhminBit = 28,
  Feature_HasStdExtZfhBit = 9,
  Feature_NoStdExtZfhBit = 30,
  Feature_HasStdExtZfbfminBit = 32,
  Feature_HasStdExtZfaBit = 33,
  Feature_HasStdExtZfinxBit = 6,
  Feature_HasStdExtZdinxBit = 8,
  Feature_HasStdExtZhinxminBit = 29,
  Feature_HasStdExtZhinxBit = 10,
  Feature_NoStdExtZhinxBit = 31,
  Feature_HasStdExtCBit = 15,
  Feature_HasStdExtCOrZcaBit = 17,
  Feature_HasStdExtZbaBit = 39,
  Feature_NotHasStdExtZbaBit = 18,
  Feature_HasStdExtZbbBit = 36,
  Feature_NoStdExtZbbBit = 38,
  Feature_HasStdExtZbcBit = 41,
  Feature_HasStdExtZbsBit = 35,
  Feature_HasStdExtZbkbBit = 37,
  Feature_HasStdExtZbkxBit = 42,
  Feature_HasStdExtZbbOrZbkbBit = 34,
  Feature_HasStdExtZbcOrZbkcBit = 40,
  Feature_HasStdExtZkndBit = 43,
  Feature_HasStdExtZkneBit = 45,
  Feature_HasStdExtZkndOrZkneBit = 44,
  Feature_HasStdExtZknhBit = 46,
  Feature_HasStdExtZksedBit = 47,
  Feature_HasStdExtZkshBit = 48,
  Feature_HasStdExtZvfbfwmaBit = 55,
  Feature_HasStdExtZvkbBit = 58,
  Feature_HasStdExtZvbbBit = 57,
  Feature_HasStdExtZvbcBit = 62,
  Feature_HasStdExtZvkgBit = 59,
  Feature_HasStdExtZvknedBit = 60,
  Feature_HasStdExtZvknhaBit = 63,
  Feature_HasStdExtZvknhbBit = 64,
  Feature_HasStdExtZvksedBit = 65,
  Feature_HasStdExtZvkshBit = 61,
  Feature_HasVInstructionsBit = 11,
  Feature_HasVInstructionsI64Bit = 51,
  Feature_HasVInstructionsAnyFBit = 50,
  Feature_HasVInstructionsF16MinimalBit = 56,
  Feature_HasVInstructionsBF16Bit = 54,
  Feature_HasVInstructionsF16Bit = 49,
  Feature_HasVInstructionsF64Bit = 53,
  Feature_HasVInstructionsFullMultiplyBit = 52,
  Feature_HasVendorXVentanaCondOpsBit = 69,
  Feature_HasVendorXTHeadBaBit = 70,
  Feature_HasVendorXTHeadBbBit = 71,
  Feature_HasVendorXTHeadBsBit = 72,
  Feature_HasVendorXTHeadCondMovBit = 73,
  Feature_HasVendorXTHeadFMemIdxBit = 78,
  Feature_HasVendorXTHeadMacBit = 74,
  Feature_HasVendorXTHeadMemIdxBit = 77,
  Feature_HasVendorXTHeadMemPairBit = 76,
  Feature_HasVendorXTHeadVdotBit = 75,
  Feature_HasVendorXSfvcpBit = 79,
  Feature_HasVendorXSfvqmaccdodBit = 80,
  Feature_HasVendorXSfvqmaccqoqBit = 81,
  Feature_HasVendorXSfvfwmaccqqqBit = 82,
  Feature_HasVendorXSfvfnrclipxfqfBit = 83,
  Feature_HasVendorXCVbitmanipBit = 85,
  Feature_HasVendorXCVmacBit = 88,
  Feature_HasVendorXCVmemBit = 84,
  Feature_HasVendorXCValuBit = 86,
  Feature_HasVendorXCVbiBit = 87,
  Feature_IsRV64Bit = 4,
  Feature_IsRV32Bit = 3,
  Feature_HasShortForwardBranchOptBit = 12,
  Feature_NoShortForwardBranchOptBit = 14,
  Feature_HasConditionalMoveFusionBit = 13,
  Feature_NoConditionalMoveFusionBit = 0,
  Feature_HasAtomicLdStBit = 21,
  Feature_OptForMinSizeBit = 16,
  Feature_HwMode1Bit = 90,
  Feature_HwMode0Bit = 89,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasStdExtZicbop())
    Features.set(Feature_HasStdExtZicbopBit);
  if (Subtarget->hasStdExtZicond())
    Features.set(Feature_HasStdExtZicondBit);
  if (Subtarget->hasStdExtZimop())
    Features.set(Feature_HasStdExtZimopBit);
  if (Subtarget->hasStdExtZicfilp())
    Features.set(Feature_HasStdExtZicfilpBit);
  if (!Subtarget->hasStdExtZicfilp())
    Features.set(Feature_NoStdExtZicfilpBit);
  if (Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtZmmulBit);
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtZtso())
    Features.set(Feature_HasStdExtZtsoBit);
  if (!Subtarget->hasStdExtZtso())
    Features.set(Feature_NotHasStdExtZtsoBit);
  if (Subtarget->hasStdExtZabha())
    Features.set(Feature_HasStdExtZabhaBit);
  if (Subtarget->hasStdExtZacas())
    Features.set(Feature_HasStdExtZacasBit);
  if (!Subtarget->hasStdExtZacas())
    Features.set(Feature_NoStdExtZacasBit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhminBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (!Subtarget->hasStdExtZfh())
    Features.set(Feature_NoStdExtZfhBit);
  if (Subtarget->hasStdExtZfbfmin())
    Features.set(Feature_HasStdExtZfbfminBit);
  if (Subtarget->hasStdExtZfa())
    Features.set(Feature_HasStdExtZfaBit);
  if (Subtarget->hasStdExtZfinx())
    Features.set(Feature_HasStdExtZfinxBit);
  if (Subtarget->hasStdExtZdinx())
    Features.set(Feature_HasStdExtZdinxBit);
  if (Subtarget->hasStdExtZhinxmin())
    Features.set(Feature_HasStdExtZhinxminBit);
  if (Subtarget->hasStdExtZhinx())
    Features.set(Feature_HasStdExtZhinxBit);
  if (!Subtarget->hasStdExtZhinx())
    Features.set(Feature_NoStdExtZhinxBit);
  if (Subtarget->hasStdExtC())
    Features.set(Feature_HasStdExtCBit);
  if (Subtarget->hasStdExtCOrZca())
    Features.set(Feature_HasStdExtCOrZcaBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (!Subtarget->hasStdExtZbb())
    Features.set(Feature_NoStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbkbBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasStdExtZvfbfwma())
    Features.set(Feature_HasStdExtZvfbfwmaBit);
  if (Subtarget->hasStdExtZvkb())
    Features.set(Feature_HasStdExtZvkbBit);
  if (Subtarget->hasStdExtZvbb())
    Features.set(Feature_HasStdExtZvbbBit);
  if (Subtarget->hasStdExtZvbc())
    Features.set(Feature_HasStdExtZvbcBit);
  if (Subtarget->hasStdExtZvkg())
    Features.set(Feature_HasStdExtZvkgBit);
  if (Subtarget->hasStdExtZvkned())
    Features.set(Feature_HasStdExtZvknedBit);
  if (Subtarget->hasStdExtZvknha())
    Features.set(Feature_HasStdExtZvknhaBit);
  if (Subtarget->hasStdExtZvknhb())
    Features.set(Feature_HasStdExtZvknhbBit);
  if (Subtarget->hasStdExtZvksed())
    Features.set(Feature_HasStdExtZvksedBit);
  if (Subtarget->hasStdExtZvksh())
    Features.set(Feature_HasStdExtZvkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsI64())
    Features.set(Feature_HasVInstructionsI64Bit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->hasVInstructionsF16Minimal())
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (Subtarget->hasVInstructionsBF16())
    Features.set(Feature_HasVInstructionsBF16Bit);
  if (Subtarget->hasVInstructionsF16())
    Features.set(Feature_HasVInstructionsF16Bit);
  if (Subtarget->hasVInstructionsF64())
    Features.set(Feature_HasVInstructionsF64Bit);
  if (Subtarget->hasVInstructionsFullMultiply())
    Features.set(Feature_HasVInstructionsFullMultiplyBit);
  if (Subtarget->hasVendorXVentanaCondOps())
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (Subtarget->hasVendorXTHeadBa())
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (Subtarget->hasVendorXTHeadBb())
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (Subtarget->hasVendorXTHeadBs())
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (Subtarget->hasVendorXTHeadCondMov())
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (Subtarget->hasVendorXTHeadFMemIdx())
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (Subtarget->hasVendorXTHeadMac())
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (Subtarget->hasVendorXTHeadMemIdx())
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (Subtarget->hasVendorXTHeadMemPair())
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (Subtarget->hasVendorXTHeadVdot())
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (Subtarget->hasVendorXSfvcp())
    Features.set(Feature_HasVendorXSfvcpBit);
  if (Subtarget->hasVendorXSfvqmaccdod())
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (Subtarget->hasVendorXSfvqmaccqoq())
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (Subtarget->hasVendorXSfvfwmaccqqq())
    Features.set(Feature_HasVendorXSfvfwmaccqqqBit);
  if (Subtarget->hasVendorXSfvfnrclipxfqf())
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (Subtarget->hasVendorXCVbitmanip())
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (Subtarget->hasVendorXCVmac())
    Features.set(Feature_HasVendorXCVmacBit);
  if (Subtarget->hasVendorXCVmem())
    Features.set(Feature_HasVendorXCVmemBit);
  if (Subtarget->hasVendorXCValu())
    Features.set(Feature_HasVendorXCValuBit);
  if (Subtarget->hasVendorXCVbi())
    Features.set(Feature_HasVendorXCVbiBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  if (Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_HasShortForwardBranchOptBit);
  if (!Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_NoShortForwardBranchOptBit);
  if (Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_HasConditionalMoveFusionBit);
  if (!Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_NoConditionalMoveFusionBit);
  if (Subtarget->hasStdExtA() || Subtarget->hasForcedAtomics())
    Features.set(Feature_HasAtomicLdStBit);
  if (MF ? MF->getFunction().hasMinSize() : false)
    Features.set(Feature_OptForMinSizeBit);
  if (!((Subtarget->is64Bit())))
    Features.set(Feature_HwMode1Bit);
  if ((Subtarget->is64Bit()))
    Features.set(Feature_HwMode0Bit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HwMode0,
  GIFBS_HwMode1,
  GIFBS_HasAtomicLdSt_HwMode0,
  GIFBS_HasAtomicLdSt_HwMode1,
  GIFBS_HasShortForwardBranchOpt_HwMode0,
  GIFBS_HasShortForwardBranchOpt_HwMode1,
  GIFBS_HasStdExtA_HwMode1,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtD_HwMode0,
  GIFBS_HasStdExtD_HwMode1,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtF_HwMode0,
  GIFBS_HasStdExtF_HwMode1,
  GIFBS_HasStdExtM_HwMode0,
  GIFBS_HasStdExtM_HwMode1,
  GIFBS_HasStdExtZba_HwMode0,
  GIFBS_HasStdExtZba_HwMode1,
  GIFBS_HasStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_HwMode1,
  GIFBS_HasStdExtZbkx_HwMode0,
  GIFBS_HasStdExtZbkx_HwMode1,
  GIFBS_HasStdExtZbs_HwMode0,
  GIFBS_HasStdExtZbs_HwMode1,
  GIFBS_HasStdExtZfa,
  GIFBS_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtZfbfmin_HwMode0,
  GIFBS_HasStdExtZfbfmin_HwMode1,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtZfinx,
  GIFBS_HasStdExtZfinx_HwMode0,
  GIFBS_HasStdExtZfinx_HwMode1,
  GIFBS_HasStdExtZhinx,
  GIFBS_HasStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZhinxmin_HwMode0,
  GIFBS_HasStdExtZhinxmin_HwMode1,
  GIFBS_HasStdExtZmmul_HwMode0,
  GIFBS_HasStdExtZmmul_HwMode1,
  GIFBS_HasVInstructions_HwMode0,
  GIFBS_HasVInstructions_HwMode1,
  GIFBS_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructionsBF16_HwMode0,
  GIFBS_HasVInstructionsBF16_HwMode1,
  GIFBS_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructionsF16Minimal_HwMode0,
  GIFBS_HasVInstructionsF16Minimal_HwMode1,
  GIFBS_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsFullMultiply_HwMode0,
  GIFBS_HasVInstructionsFullMultiply_HwMode1,
  GIFBS_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXCVmac_HwMode0,
  GIFBS_HasVendorXCVmac_HwMode1,
  GIFBS_HasVendorXTHeadBa_HwMode0,
  GIFBS_HasVendorXTHeadBa_HwMode1,
  GIFBS_HasVendorXTHeadBb_HwMode0,
  GIFBS_HasVendorXTHeadBb_HwMode1,
  GIFBS_HasVendorXTHeadBs_HwMode0,
  GIFBS_HasVendorXTHeadBs_HwMode1,
  GIFBS_HasVendorXTHeadCondMov_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_HwMode1,
  GIFBS_HasVendorXTHeadMac_HwMode0,
  GIFBS_HasVendorXTHeadMac_HwMode1,
  GIFBS_IsRV32_HwMode0,
  GIFBS_IsRV32_HwMode1,
  GIFBS_IsRV64_HwMode0,
  GIFBS_IsRV64_HwMode1,
  GIFBS_HasAtomicLdSt_IsRV64_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_IsRV64_HwMode1,
  GIFBS_HasStdExtA_NoStdExtZacas_HwMode1,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfa,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtD_IsRV64_HwMode0,
  GIFBS_HasStdExtF_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode1,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZba_IsRV64_HwMode0,
  GIFBS_HasStdExtZba_IsRV64_HwMode1,
  GIFBS_HasStdExtZbb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbs_IsRV64_HwMode0,
  GIFBS_HasStdExtZbs_IsRV64_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV32,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfbfmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZfh_IsRV64_HwMode0,
  GIFBS_HasStdExtZfhmin_NoStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfhmin_NoStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinxmin_NoStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinxmin_NoStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZknd_IsRV32_HwMode1,
  GIFBS_HasStdExtZknd_IsRV64_HwMode0,
  GIFBS_HasStdExtZkndOrZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZkne_IsRV32_HwMode1,
  GIFBS_HasStdExtZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZknh_IsRV32_HwMode1,
  GIFBS_HasStdExtZknh_IsRV64_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_HwMode1,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXCValu_IsRV32_HwMode0,
  GIFBS_HasVendorXCValu_IsRV32_HwMode1,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode0,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode1,
  GIFBS_HasVendorXTHeadBb_IsRV64_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_IsRV64_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_IsRV64_HwMode1,
  GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0,
  GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1,
  GIFBS_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtA_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtZacas_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZfhmin_IsRV64_NoStdExtZfh_HwMode0,
  GIFBS_HasStdExtZhinxmin_IsRV64_NoStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_NotHasStdExtZba_HwMode0,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HwMode0Bit, },
  {Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode1Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode0Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtFBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode1Bit, },
  {Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NoStdExtZacasBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_NoStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_NoStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_NoStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_NoStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_IsRV64Bit, Feature_NoStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_NoStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_GIAddrRegImm,
  GICP_GIShiftMask32,
  GICP_GIShiftMaskXLen,
  GICP_gi_sh1add_op,
  GICP_gi_sh1add_uw_op,
  GICP_gi_sh2add_op,
  GICP_gi_sh2add_uw_op,
  GICP_gi_sh3add_op,
  GICP_gi_sh3add_uw_op,
};
// See constructor for table contents

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &RISCVInstructionSelector::selectAddrRegImm, // GIAddrRegImm
  &RISCVInstructionSelector::selectShiftMask, // GIShiftMask32
  &RISCVInstructionSelector::selectShiftMask, // GIShiftMaskXLen
  &RISCVInstructionSelector::selectSHXADDOp<1>, // gi_sh1add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<1>, // gi_sh1add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<2>, // gi_sh2add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<2>, // gi_sh2add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<3>, // gi_sh3add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<3>, // gi_sh3add_uw_op
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_like_non_imm12 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_add_non_imm12,
};
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_like_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
        const MachineFunction &MF = *MI.getParent()->getParent();
        const MachineRegisterInfo &MRI = MF.getRegInfo();
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_like_non_imm12 should have returned");
  }
  case GICXXPred_MI_Predicate_add_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
        const MachineFunction &MF = *MI.getParent()->getParent();
        const MachineRegisterInfo &MRI = MF.getRegInfo();
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_non_imm12 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_BCLRMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BCLRMaski32,
  GICXXPred_I64_Predicate_SingleBitSetMask,
  GICXXPred_I64_Predicate_SingleBitSetMaski32,
  GICXXPred_I64_Predicate_byteselect,
  GICXXPred_I64_Predicate_c_lui_imm,
  GICXXPred_I64_Predicate_csr_sysreg,
  GICXXPred_I64_Predicate_cv_tuimm2,
  GICXXPred_I64_Predicate_cv_tuimm5,
  GICXXPred_I64_Predicate_cv_uimm10,
  GICXXPred_I64_Predicate_immzero,
  GICXXPred_I64_Predicate_payload1,
  GICXXPred_I64_Predicate_payload2,
  GICXXPred_I64_Predicate_payload5,
  GICXXPred_I64_Predicate_powerOf2Minus1,
  GICXXPred_I64_Predicate_rnum,
  GICXXPred_I64_Predicate_shfl_uimm,
  GICXXPred_I64_Predicate_simm5,
  GICXXPred_I64_Predicate_simm5_plus1,
  GICXXPred_I64_Predicate_simm5_plus1_nonzero,
  GICXXPred_I64_Predicate_simm6,
  GICXXPred_I64_Predicate_simm6nonzero,
  GICXXPred_I64_Predicate_simm9_lsb0,
  GICXXPred_I64_Predicate_simm10_lsb0000nonzero,
  GICXXPred_I64_Predicate_simm12,
  GICXXPred_I64_Predicate_simm12Minus1Nonzero,
  GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1,
  GICXXPred_I64_Predicate_simm12Plus1,
  GICXXPred_I64_Predicate_simm12Plus1i32,
  GICXXPred_I64_Predicate_simm12_lsb0,
  GICXXPred_I64_Predicate_simm12_lsb00000,
  GICXXPred_I64_Predicate_simm12_no6,
  GICXXPred_I64_Predicate_simm12i32,
  GICXXPred_I64_Predicate_tsimm5,
  GICXXPred_I64_Predicate_tuimm5,
  GICXXPred_I64_Predicate_u32simm12,
  GICXXPred_I64_Predicate_uimm1,
  GICXXPred_I64_Predicate_uimm2,
  GICXXPred_I64_Predicate_uimm2_3,
  GICXXPred_I64_Predicate_uimm2_4,
  GICXXPred_I64_Predicate_uimm2_lsb0,
  GICXXPred_I64_Predicate_uimm4_with_predicate,
  GICXXPred_I64_Predicate_uimm5,
  GICXXPred_I64_Predicate_uimm5_lsb0,
  GICXXPred_I64_Predicate_uimm5_with_predicate,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6_lsb0,
  GICXXPred_I64_Predicate_uimm6gt32,
  GICXXPred_I64_Predicate_uimm7_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb000,
  GICXXPred_I64_Predicate_uimm9_lsb000,
  GICXXPred_I64_Predicate_uimm10_lsb00nonzero,
  GICXXPred_I64_Predicate_uimmlog2xlen,
  GICXXPred_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_BCLRMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
    llvm_unreachable("BCLRMask should have returned");
  }
  case GICXXPred_I64_Predicate_BCLRMaski32: {
    
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
  }
  case GICXXPred_I64_Predicate_SingleBitSetMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
    llvm_unreachable("SingleBitSetMask should have returned");
  }
  case GICXXPred_I64_Predicate_SingleBitSetMaski32: {
    
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                     (isUInt<5>(Imm) ||
                                      (Imm >= 0xfffe0 && Imm <= 0xfffff));
  }
  case GICXXPred_I64_Predicate_csr_sysreg: {
    return isUInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_uimm10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immzero: {
    return (Imm == 0);
  }
  case GICXXPred_I64_Predicate_payload1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_payload2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_payload5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_powerOf2Minus1: {
     return isPowerOf2_32(Imm+1); 
  }
  case GICXXPred_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
  }
  case GICXXPred_I64_Predicate_shfl_uimm: {
    
      if (Subtarget->is64Bit())
        return isUInt<5>(Imm);
      return isUInt<4>(Imm);
    
    llvm_unreachable("shfl_uimm should have returned");
  }
  case GICXXPred_I64_Predicate_simm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
  }
  case GICXXPred_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
  }
  case GICXXPred_I64_Predicate_simm6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12Minus1Nonzero: {
    
      return (Imm >= -2049 && Imm < 0) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1: {
    
      return (Imm >= -2049 && Imm < -1) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Plus1: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12Plus1i32: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_no6: {
    
      return isInt<12>(Imm) && !isInt<6>(Imm) && isInt<12>(-Imm);
  }
  case GICXXPred_I64_Predicate_simm12i32: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_tsimm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_u32simm12: {
    
      return isUInt<32>(Imm) && isInt<12>(SignExtend64<32>(Imm));
    
  }
  case GICXXPred_I64_Predicate_uimm1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2_3: {
    
      return isShiftedUInt<2, 3>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_4: {
    
      return isShiftedUInt<2, 4>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_lsb0: {
    return isShiftedUInt<1, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm4_with_predicate: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5_lsb0: {
    return isShiftedUInt<4, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5_with_predicate: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6: {
    return isUInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6_lsb0: {
    return isShiftedUInt<5, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6gt32: {
    
      return isUInt<6>(Imm) && Imm > 32;
    
  }
  case GICXXPred_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
  }
  case GICXXPred_I64_Predicate_uimmlog2xlen: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm);
      return isUInt<5>(Imm);
    
    llvm_unreachable("uimmlog2xlen should have returned");
  }
  case GICXXPred_I64_Predicate_uimmlog2xlennonzero: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm) && (Imm != 0);
      return isUInt<5>(Imm) && (Imm != 0);
    
    llvm_unreachable("uimmlog2xlennonzero should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_Shifted32OnesMask = GICXXPred_Invalid + 1,
};
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_Shifted32OnesMask: {
    
      if (!Imm.isShiftedMask())
        return false;
    
      unsigned TrailingZeros = Imm.countr_zero();
      return TrailingZeros > 0 && TrailingZeros < 32 &&
             Imm == UINT64_C(0xFFFFFFFF) << TrailingZeros;
    
    llvm_unreachable("Shifted32OnesMask should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("RISCVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderImm,
  GICR_renderImmPlus1,
  GICR_renderImmSubFrom32,
  GICR_renderImmSubFromXLen,
  GICR_renderNegImm,
  GICR_renderTrailingZeros,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &RISCVInstructionSelector::renderImm,
  &RISCVInstructionSelector::renderImmPlus1,
  &RISCVInstructionSelector::renderImmSubFrom32,
  &RISCVInstructionSelector::renderImmSubFromXLen,
  &RISCVInstructionSelector::renderNegImm,
  &RISCVInstructionSelector::renderTrailingZeros,
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool RISCVInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("RISCVInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(300), /*)*//*default:*//*Label 99*/ GIMT_Encode4(319999),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(1006),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(10348),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(13452),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(16357),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(19127),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(21897),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(24667), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(27437),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(36983),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(44914), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 10*/ GIMT_Encode4(60302), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 11*/ GIMT_Encode4(60615),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 12*/ GIMT_Encode4(60813),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 13*/ GIMT_Encode4(61011),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 14*/ GIMT_Encode4(61909),
    /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 15*/ GIMT_Encode4(62211),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 16*/ GIMT_Encode4(62351),
    /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 17*/ GIMT_Encode4(62390),
    /*TargetOpcode::G_LOAD*//*Label 18*/ GIMT_Encode4(62429),
    /*TargetOpcode::G_SEXTLOAD*//*Label 19*/ GIMT_Encode4(66859),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 20*/ GIMT_Encode4(67367), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STORE*//*Label 21*/ GIMT_Encode4(67875), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 22*/ GIMT_Encode4(71821),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 23*/ GIMT_Encode4(76377),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 24*/ GIMT_Encode4(80107), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 25*/ GIMT_Encode4(83837),
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 26*/ GIMT_Encode4(87567),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 27*/ GIMT_Encode4(87852),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 28*/ GIMT_Encode4(91582),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 29*/ GIMT_Encode4(95312),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 30*/ GIMT_Encode4(99042),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 31*/ GIMT_Encode4(102772),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 32*/ GIMT_Encode4(106502), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 33*/ GIMT_Encode4(110232), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 34*/ GIMT_Encode4(110450),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 35*/ GIMT_Encode4(114630), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 36*/ GIMT_Encode4(115356), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 37*/ GIMT_Encode4(118477), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 38*/ GIMT_Encode4(121642),
    /*TargetOpcode::G_SHL*//*Label 39*/ GIMT_Encode4(124858),
    /*TargetOpcode::G_LSHR*//*Label 40*/ GIMT_Encode4(128303),
    /*TargetOpcode::G_ASHR*//*Label 41*/ GIMT_Encode4(131410), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 42*/ GIMT_Encode4(134486),
    /*TargetOpcode::G_ROTL*//*Label 43*/ GIMT_Encode4(137589),
    /*TargetOpcode::G_ICMP*//*Label 44*/ GIMT_Encode4(140655),
    /*TargetOpcode::G_FCMP*//*Label 45*/ GIMT_Encode4(167318), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 46*/ GIMT_Encode4(174780), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 47*/ GIMT_Encode4(181510),
    /*TargetOpcode::G_SMULH*//*Label 48*/ GIMT_Encode4(184244),
    /*TargetOpcode::G_UADDSAT*//*Label 49*/ GIMT_Encode4(186978),
    /*TargetOpcode::G_SADDSAT*//*Label 50*/ GIMT_Encode4(189764),
    /*TargetOpcode::G_USUBSAT*//*Label 51*/ GIMT_Encode4(192550),
    /*TargetOpcode::G_SSUBSAT*//*Label 52*/ GIMT_Encode4(195336), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 53*/ GIMT_Encode4(198122),
    /*TargetOpcode::G_FSUB*//*Label 54*/ GIMT_Encode4(200550),
    /*TargetOpcode::G_FMUL*//*Label 55*/ GIMT_Encode4(202978),
    /*TargetOpcode::G_FMA*//*Label 56*/ GIMT_Encode4(205406), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 57*/ GIMT_Encode4(222051), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 58*/ GIMT_Encode4(224479),
    /*TargetOpcode::G_FPEXT*//*Label 59*/ GIMT_Encode4(226450),
    /*TargetOpcode::G_FPTRUNC*//*Label 60*/ GIMT_Encode4(226903),
    /*TargetOpcode::G_FPTOSI*//*Label 61*/ GIMT_Encode4(228899),
    /*TargetOpcode::G_FPTOUI*//*Label 62*/ GIMT_Encode4(234262),
    /*TargetOpcode::G_SITOFP*//*Label 63*/ GIMT_Encode4(239625),
    /*TargetOpcode::G_UITOFP*//*Label 64*/ GIMT_Encode4(245166),
    /*TargetOpcode::G_FABS*//*Label 65*/ GIMT_Encode4(250707),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 66*/ GIMT_Encode4(252678), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 67*/ GIMT_Encode4(258327),
    /*TargetOpcode::G_FMAXNUM*//*Label 68*/ GIMT_Encode4(260412), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 69*/ GIMT_Encode4(262497),
    /*TargetOpcode::G_FMAXIMUM*//*Label 70*/ GIMT_Encode4(262623), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 71*/ GIMT_Encode4(262749),
    /*TargetOpcode::G_SMAX*//*Label 72*/ GIMT_Encode4(265525),
    /*TargetOpcode::G_UMIN*//*Label 73*/ GIMT_Encode4(268301),
    /*TargetOpcode::G_UMAX*//*Label 74*/ GIMT_Encode4(271077),
    /*TargetOpcode::G_ABS*//*Label 75*/ GIMT_Encode4(273853),
    /*TargetOpcode::G_LROUND*//*Label 76*/ GIMT_Encode4(274011),
    /*TargetOpcode::G_LLROUND*//*Label 77*/ GIMT_Encode4(274909),
    /*TargetOpcode::G_BR*//*Label 78*/ GIMT_Encode4(275211), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 79*/ GIMT_Encode4(275227), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 80*/ GIMT_Encode4(277777), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 81*/ GIMT_Encode4(280473),
    /*TargetOpcode::G_BSWAP*//*Label 82*/ GIMT_Encode4(283023),
    /*TargetOpcode::G_BITREVERSE*//*Label 83*/ GIMT_Encode4(285558),
    /*TargetOpcode::G_FCEIL*//*Label 84*/ GIMT_Encode4(288052), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 85*/ GIMT_Encode4(288250),
    /*TargetOpcode::G_FFLOOR*//*Label 86*/ GIMT_Encode4(290426),
    /*TargetOpcode::G_FRINT*//*Label 87*/ GIMT_Encode4(290624),
    /*TargetOpcode::G_FNEARBYINT*//*Label 88*/ GIMT_Encode4(290822), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 89*/ GIMT_Encode4(291020),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 90*/ GIMT_Encode4(293448),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 91*/ GIMT_Encode4(295876),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 92*/ GIMT_Encode4(298304), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 93*/ GIMT_Encode4(300732),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 94*/ GIMT_Encode4(317377), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 95*/ GIMT_Encode4(319553),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 96*/ GIMT_Encode4(319566), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*RISCV::G_FCLASS*//*Label 97*/ GIMT_Encode4(319579),
    /*RISCV::G_READ_VLENB*//*Label 98*/ GIMT_Encode4(319939),
    // Label 0: @1006
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 124*/ GIMT_Encode4(10347),
    /*GILLT_s32*//*Label 100*/ GIMT_Encode4(1141),
    /*GILLT_s64*//*Label 101*/ GIMT_Encode4(3639), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 102*/ GIMT_Encode4(7817),
    /*GILLT_nxv1s16*//*Label 103*/ GIMT_Encode4(7932),
    /*GILLT_nxv1s32*//*Label 104*/ GIMT_Encode4(8047),
    /*GILLT_nxv1s64*//*Label 105*/ GIMT_Encode4(8162), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 106*/ GIMT_Encode4(8277),
    /*GILLT_nxv2s16*//*Label 107*/ GIMT_Encode4(8392),
    /*GILLT_nxv2s32*//*Label 108*/ GIMT_Encode4(8507),
    /*GILLT_nxv2s64*//*Label 109*/ GIMT_Encode4(8622), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 110*/ GIMT_Encode4(8737),
    /*GILLT_nxv4s16*//*Label 111*/ GIMT_Encode4(8852),
    /*GILLT_nxv4s32*//*Label 112*/ GIMT_Encode4(8967),
    /*GILLT_nxv4s64*//*Label 113*/ GIMT_Encode4(9082), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 114*/ GIMT_Encode4(9197),
    /*GILLT_nxv8s16*//*Label 115*/ GIMT_Encode4(9312),
    /*GILLT_nxv8s32*//*Label 116*/ GIMT_Encode4(9427),
    /*GILLT_nxv8s64*//*Label 117*/ GIMT_Encode4(9542), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 118*/ GIMT_Encode4(9657),
    /*GILLT_nxv16s16*//*Label 119*/ GIMT_Encode4(9772),
    /*GILLT_nxv16s32*//*Label 120*/ GIMT_Encode4(9887), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 121*/ GIMT_Encode4(10002),
    /*GILLT_nxv32s16*//*Label 122*/ GIMT_Encode4(10117), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 123*/ GIMT_Encode4(10232),
    // Label 100: @1141
    GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(3638),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1200), // Rule ID 2716 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:2:x, GPR:{ *:[i32] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2716,
        GIR_EraseRootFromParent_Done,
      // Label 126: @1200
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1248), // Rule ID 2726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:4:x, GPR:{ *:[i32] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2726,
        GIR_EraseRootFromParent_Done,
      // Label 127: @1248
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1296), // Rule ID 2736 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:6:x, GPR:{ *:[i32] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2736,
        GIR_EraseRootFromParent_Done,
      // Label 128: @1296
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1347), // Rule ID 63003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:27:x, GPR:{ *:[i32] }:$rs2:$pred:27:y)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh1add_op:{ *:[i32] }:$rs1, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63003,
        GIR_EraseRootFromParent_Done,
      // Label 129: @1347
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1398), // Rule ID 63005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:28:x, GPR:{ *:[i32] }:$rs2:$pred:28:y)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh2add_op:{ *:[i32] }:$rs1, 2:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63005,
        GIR_EraseRootFromParent_Done,
      // Label 130: @1398
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1449), // Rule ID 63007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:29:x, GPR:{ *:[i32] }:$rs2:$pred:29:y)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh3add_op:{ *:[i32] }:$rs1, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63007,
        GIR_EraseRootFromParent_Done,
      // Label 131: @1449
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1497), // Rule ID 65226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:2:y, sh1add_op:{ *:[i32] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65226,
        GIR_EraseRootFromParent_Done,
      // Label 132: @1497
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1545), // Rule ID 65234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:4:y, sh2add_op:{ *:[i32] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65234,
        GIR_EraseRootFromParent_Done,
      // Label 133: @1545
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1593), // Rule ID 65242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:6:y, sh3add_op:{ *:[i32] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65242,
        GIR_EraseRootFromParent_Done,
      // Label 134: @1593
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(1644), // Rule ID 73721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:27:y, sh1add_op:{ *:[i32] }:$rs1:$pred:27:x)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh1add_op:{ *:[i32] }:$rs1, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73721,
        GIR_EraseRootFromParent_Done,
      // Label 135: @1644
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(1695), // Rule ID 73723 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:28:y, sh2add_op:{ *:[i32] }:$rs1:$pred:28:x)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh2add_op:{ *:[i32] }:$rs1, 2:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73723,
        GIR_EraseRootFromParent_Done,
      // Label 136: @1695
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(1746), // Rule ID 73725 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:29:y, sh3add_op:{ *:[i32] }:$rs1:$pred:29:x)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh3add_op:{ *:[i32] }:$rs1, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73725,
        GIR_EraseRootFromParent_Done,
      // Label 137: @1746
      GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(1814), // Rule ID 2710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x, GPR:{ *:[i32] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2710,
        GIR_EraseRootFromParent_Done,
      // Label 138: @1814
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(1882), // Rule ID 2720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x, GPR:{ *:[i32] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2720,
        GIR_EraseRootFromParent_Done,
      // Label 139: @1882
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(1950), // Rule ID 2730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x, GPR:{ *:[i32] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2730,
        GIR_EraseRootFromParent_Done,
      // Label 140: @1950
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2018), // Rule ID 2832 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x, GPR:{ *:[i32] }:$rs2:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2832,
        GIR_EraseRootFromParent_Done,
      // Label 141: @2018
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2086), // Rule ID 2833 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x, GPR:{ *:[i32] }:$rs2:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2833,
        GIR_EraseRootFromParent_Done,
      // Label 142: @2086
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2154), // Rule ID 2838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x, GPR:{ *:[i32] }:$rs2:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2838,
        GIR_EraseRootFromParent_Done,
      // Label 143: @2154
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2222), // Rule ID 2839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x, GPR:{ *:[i32] }:$rs2:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2839,
        GIR_EraseRootFromParent_Done,
      // Label 144: @2222
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2290), // Rule ID 2844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x, GPR:{ *:[i32] }:$rs2:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2844,
        GIR_EraseRootFromParent_Done,
      // Label 145: @2290
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2358), // Rule ID 2845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x, GPR:{ *:[i32] }:$rs2:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2845,
        GIR_EraseRootFromParent_Done,
      // Label 146: @2358
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2426), // Rule ID 65222 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:1:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65222,
        GIR_EraseRootFromParent_Done,
      // Label 147: @2426
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2494), // Rule ID 65230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:3:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65230,
        GIR_EraseRootFromParent_Done,
      // Label 148: @2494
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2562), // Rule ID 65238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:5:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65238,
        GIR_EraseRootFromParent_Done,
      // Label 149: @2562
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2630), // Rule ID 65294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:24:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65294,
        GIR_EraseRootFromParent_Done,
      // Label 150: @2630
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2698), // Rule ID 65295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:24:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65295,
        GIR_EraseRootFromParent_Done,
      // Label 151: @2698
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2766), // Rule ID 65298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:25:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65298,
        GIR_EraseRootFromParent_Done,
      // Label 152: @2766
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2834), // Rule ID 65299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:25:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65299,
        GIR_EraseRootFromParent_Done,
      // Label 153: @2834
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2902), // Rule ID 65302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:26:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65302,
        GIR_EraseRootFromParent_Done,
      // Label 154: @2902
      GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(2970), // Rule ID 65303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:26:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65303,
        GIR_EraseRootFromParent_Done,
      // Label 155: @2970
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3037), // Rule ID 73719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i32] }:$rs1)  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73719,
        GIR_EraseRootFromParent_Done,
      // Label 156: @3037
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3104), // Rule ID 62999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 62999,
        GIR_EraseRootFromParent_Done,
      // Label 157: @3104
      GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3146), // Rule ID 69 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 69,
        GIR_EraseRootFromParent_Done,
      // Label 158: @3146
      GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3190), // Rule ID 310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12i32>>:$imm)  =>  (ADDIW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (as_i64imm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 310,
        GIR_EraseRootFromParent_Done,
      // Label 159: @3190
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(3251), // Rule ID 73727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73727,
        GIR_EraseRootFromParent_Done,
      // Label 160: @3251
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3312), // Rule ID 73731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73731,
        GIR_EraseRootFromParent_Done,
      // Label 161: @3312
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3373), // Rule ID 73732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73732,
        GIR_EraseRootFromParent_Done,
      // Label 162: @3373
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3434), // Rule ID 63059 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63059,
        GIR_EraseRootFromParent_Done,
      // Label 163: @3434
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(3495), // Rule ID 63316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63316,
        GIR_EraseRootFromParent_Done,
      // Label 164: @3495
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(3556), // Rule ID 63317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63317,
        GIR_EraseRootFromParent_Done,
      // Label 165: @3556
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(3583), // Rule ID 67 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 67,
        GIR_Done,
      // Label 166: @3583
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(3610), // Rule ID 297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADDW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 297,
        GIR_Done,
      // Label 167: @3610
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(3637), // Rule ID 298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADDW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 298,
        GIR_Done,
      // Label 168: @3637
      GIM_Reject,
    // Label 125: @3638
    GIM_Reject,
    // Label 101: @3639
    GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(7816),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(3745), // Rule ID 2760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:11:x, GPR:{ *:[i64] }:$rs2:$pred:11:y)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2760,
        GIR_EraseRootFromParent_Done,
      // Label 170: @3745
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(3840), // Rule ID 2762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:12:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x, GPR:{ *:[i64] }:$rs2:$pred:12:y)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2762,
        GIR_EraseRootFromParent_Done,
      // Label 171: @3840
      GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(3935), // Rule ID 2764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:13:x, GPR:{ *:[i64] }:$rs2:$pred:13:y)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2764,
        GIR_EraseRootFromParent_Done,
      // Label 172: @3935
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(4030), // Rule ID 2751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x, GPR:{ *:[i64] }:$rs2:$pred:8:y)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2751,
        GIR_EraseRootFromParent_Done,
      // Label 173: @4030
      GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(4125), // Rule ID 2754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:9:x, GPR:{ *:[i64] }:$rs2:$pred:9:y)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2754,
        GIR_EraseRootFromParent_Done,
      // Label 174: @4125
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(4220), // Rule ID 2757 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:10:x, GPR:{ *:[i64] }:$rs2:$pred:10:y)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2757,
        GIR_EraseRootFromParent_Done,
      // Label 175: @4220
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(4315), // Rule ID 65252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:11:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:11:x)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65252,
        GIR_EraseRootFromParent_Done,
      // Label 176: @4315
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(4410), // Rule ID 65254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:12:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:12:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65254,
        GIR_EraseRootFromParent_Done,
      // Label 177: @4410
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(4505), // Rule ID 65256 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:13:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:13:x)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65256,
        GIR_EraseRootFromParent_Done,
      // Label 178: @4505
      GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(4600), // Rule ID 65246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:8:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65246,
        GIR_EraseRootFromParent_Done,
      // Label 179: @4600
      GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(4695), // Rule ID 65248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:9:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:9:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:9:x)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65248,
        GIR_EraseRootFromParent_Done,
      // Label 180: @4695
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(4790), // Rule ID 65250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:10:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:10:x)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65250,
        GIR_EraseRootFromParent_Done,
      // Label 181: @4790
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(4838), // Rule ID 2715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:2:x, GPR:{ *:[i64] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2715,
        GIR_EraseRootFromParent_Done,
      // Label 182: @4838
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(4886), // Rule ID 2725 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:4:x, GPR:{ *:[i64] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2725,
        GIR_EraseRootFromParent_Done,
      // Label 183: @4886
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(4934), // Rule ID 2735 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:6:x, GPR:{ *:[i64] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2735,
        GIR_EraseRootFromParent_Done,
      // Label 184: @4934
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(4982), // Rule ID 2766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1:$pred:14:x, GPR:{ *:[i64] }:$rs2:$pred:14:y)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2766,
        GIR_EraseRootFromParent_Done,
      // Label 185: @4982
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(5030), // Rule ID 2768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:15:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:15:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1:$pred:15:x, GPR:{ *:[i64] }:$rs2:$pred:15:y)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2768,
        GIR_EraseRootFromParent_Done,
      // Label 186: @5030
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(5078), // Rule ID 2770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1:$pred:16:x, GPR:{ *:[i64] }:$rs2:$pred:16:y)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2770,
        GIR_EraseRootFromParent_Done,
      // Label 187: @5078
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(5129), // Rule ID 63002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:27:x, GPR:{ *:[i64] }:$rs2:$pred:27:y)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh1add_op:{ *:[i64] }:$rs1, 1:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63002,
        GIR_EraseRootFromParent_Done,
      // Label 188: @5129
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(5180), // Rule ID 63004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:28:x, GPR:{ *:[i64] }:$rs2:$pred:28:y)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh2add_op:{ *:[i64] }:$rs1, 2:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63004,
        GIR_EraseRootFromParent_Done,
      // Label 189: @5180
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(5231), // Rule ID 63006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:29:x, GPR:{ *:[i64] }:$rs2:$pred:29:y)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh3add_op:{ *:[i64] }:$rs1, 3:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63006,
        GIR_EraseRootFromParent_Done,
      // Label 190: @5231
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(5279), // Rule ID 65225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:2:y, sh1add_op:{ *:[i64] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65225,
        GIR_EraseRootFromParent_Done,
      // Label 191: @5279
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(5327), // Rule ID 65233 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:4:y, sh2add_op:{ *:[i64] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65233,
        GIR_EraseRootFromParent_Done,
      // Label 192: @5327
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(5375), // Rule ID 65241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:6:y, sh3add_op:{ *:[i64] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65241,
        GIR_EraseRootFromParent_Done,
      // Label 193: @5375
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(5423), // Rule ID 65258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:14:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:14:y, sh1add_uw_op:{ *:[i64] }:$rs1:$pred:14:x)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65258,
        GIR_EraseRootFromParent_Done,
      // Label 194: @5423
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(5471), // Rule ID 65260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:15:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:15:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:15:y, sh2add_uw_op:{ *:[i64] }:$rs1:$pred:15:x)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65260,
        GIR_EraseRootFromParent_Done,
      // Label 195: @5471
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(5519), // Rule ID 65262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:16:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:16:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:16:y, sh3add_uw_op:{ *:[i64] }:$rs1:$pred:16:x)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65262,
        GIR_EraseRootFromParent_Done,
      // Label 196: @5519
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(5570), // Rule ID 73720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:27:y, sh1add_op:{ *:[i64] }:$rs1:$pred:27:x)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh1add_op:{ *:[i64] }:$rs1, 1:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73720,
        GIR_EraseRootFromParent_Done,
      // Label 197: @5570
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(5621), // Rule ID 73722 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:28:y, sh2add_op:{ *:[i64] }:$rs1:$pred:28:x)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh2add_op:{ *:[i64] }:$rs1, 2:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73722,
        GIR_EraseRootFromParent_Done,
      // Label 198: @5621
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(5672), // Rule ID 73724 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:29:y, sh3add_op:{ *:[i64] }:$rs1:$pred:29:x)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh3add_op:{ *:[i64] }:$rs1, 3:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73724,
        GIR_EraseRootFromParent_Done,
      // Label 199: @5672
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(5747), // Rule ID 2748 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x, GPR:{ *:[i64] }:$rs2:$pred:7:y)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2748,
        GIR_EraseRootFromParent_Done,
      // Label 200: @5747
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(5842), // Rule ID 2772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:17:x, GPR:{ *:[i64] }:$rs2:$pred:17:y)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2772,
        GIR_EraseRootFromParent_Done,
      // Label 201: @5842
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(5937), // Rule ID 2774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:18:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:18:x, GPR:{ *:[i64] }:$rs2:$pred:18:y)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2774,
        GIR_EraseRootFromParent_Done,
      // Label 202: @5937
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(6032), // Rule ID 2776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:19:x, GPR:{ *:[i64] }:$rs2:$pred:19:y)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2776,
        GIR_EraseRootFromParent_Done,
      // Label 203: @6032
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(6127), // Rule ID 2778 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:20:x, GPR:{ *:[i64] }:$rs2:$pred:20:y)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2778,
        GIR_EraseRootFromParent_Done,
      // Label 204: @6127
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(6222), // Rule ID 2780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:21:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:21:x, GPR:{ *:[i64] }:$rs2:$pred:21:y)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2780,
        GIR_EraseRootFromParent_Done,
      // Label 205: @6222
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(6317), // Rule ID 2782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:22:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:22:x, GPR:{ *:[i64] }:$rs2:$pred:22:y)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2782,
        GIR_EraseRootFromParent_Done,
      // Label 206: @6317
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(6385), // Rule ID 2709 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x, GPR:{ *:[i64] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2709,
        GIR_EraseRootFromParent_Done,
      // Label 207: @6385
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(6453), // Rule ID 2719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x, GPR:{ *:[i64] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2719,
        GIR_EraseRootFromParent_Done,
      // Label 208: @6453
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(6521), // Rule ID 2729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x, GPR:{ *:[i64] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2729,
        GIR_EraseRootFromParent_Done,
      // Label 209: @6521
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(6596), // Rule ID 65244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:7:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65244,
        GIR_EraseRootFromParent_Done,
      // Label 210: @6596
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(6691), // Rule ID 65264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:17:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:17:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:17:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:17:x)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65264,
        GIR_EraseRootFromParent_Done,
      // Label 211: @6691
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(6786), // Rule ID 65266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:18:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:18:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:18:x)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65266,
        GIR_EraseRootFromParent_Done,
      // Label 212: @6786
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(6881), // Rule ID 65268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:19:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:19:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:19:x)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65268,
        GIR_EraseRootFromParent_Done,
      // Label 213: @6881
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(6976), // Rule ID 65270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:20:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:20:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:20:x)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65270,
        GIR_EraseRootFromParent_Done,
      // Label 214: @6976
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(7071), // Rule ID 65272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:21:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:21:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:21:x)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65272,
        GIR_EraseRootFromParent_Done,
      // Label 215: @7071
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(7166), // Rule ID 65274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:22:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:22:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:22:x)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65274,
        GIR_EraseRootFromParent_Done,
      // Label 216: @7166
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(7234), // Rule ID 65221 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:1:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65221,
        GIR_EraseRootFromParent_Done,
      // Label 217: @7234
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(7302), // Rule ID 65229 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:3:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65229,
        GIR_EraseRootFromParent_Done,
      // Label 218: @7302
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(7370), // Rule ID 65237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:5:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65237,
        GIR_EraseRootFromParent_Done,
      // Label 219: @7370
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(7437), // Rule ID 73718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i64] }:$rs1)  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73718,
        GIR_EraseRootFromParent_Done,
      // Label 220: @7437
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(7504), // Rule ID 62998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 62998,
        GIR_EraseRootFromParent_Done,
      // Label 221: @7504
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(7564), // Rule ID 2828 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (zext:{ *:[i64] } GPR:{ *:[i32] }:$rs1):$pred:23:x, GPR:{ *:[i64] }:$rs2:$pred:23:y)<<P:23:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2828,
        GIR_EraseRootFromParent_Done,
      // Label 222: @7564
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(7624), // Rule ID 65291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:23:y, (zext:{ *:[i64] } GPR:{ *:[i32] }:$rs1):$pred:23:x)<<P:23:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65291,
        GIR_EraseRootFromParent_Done,
      // Label 223: @7624
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(7666), // Rule ID 68 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 68,
        GIR_EraseRootFromParent_Done,
      // Label 224: @7666
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(7727), // Rule ID 73726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rd)  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73726,
        GIR_EraseRootFromParent_Done,
      // Label 225: @7727
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(7788), // Rule ID 63058 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63058,
        GIR_EraseRootFromParent_Done,
      // Label 226: @7788
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(7815), // Rule ID 66 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 66,
        GIR_Done,
      // Label 227: @7815
      GIM_Reject,
    // Label 169: @7816
    GIM_Reject,
    // Label 102: @7817
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(7931),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(7885), // Rule ID 46578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46578,
        GIR_EraseRootFromParent_Done,
      // Label 229: @7885
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(7930), // Rule ID 46579 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46579,
        GIR_EraseRootFromParent_Done,
      // Label 230: @7930
      GIM_Reject,
    // Label 228: @7931
    GIM_Reject,
    // Label 103: @7932
    GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(8046),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(8000), // Rule ID 46958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46958,
        GIR_EraseRootFromParent_Done,
      // Label 232: @8000
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(8045), // Rule ID 46959 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46959,
        GIR_EraseRootFromParent_Done,
      // Label 233: @8045
      GIM_Reject,
    // Label 231: @8046
    GIM_Reject,
    // Label 104: @8047
    GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(8161),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(8115), // Rule ID 46966 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46966,
        GIR_EraseRootFromParent_Done,
      // Label 235: @8115
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(8160), // Rule ID 46967 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46967,
        GIR_EraseRootFromParent_Done,
      // Label 236: @8160
      GIM_Reject,
    // Label 234: @8161
    GIM_Reject,
    // Label 105: @8162
    GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(8276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(8230), // Rule ID 46982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46982,
        GIR_EraseRootFromParent_Done,
      // Label 238: @8230
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(8275), // Rule ID 46983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46983,
        GIR_EraseRootFromParent_Done,
      // Label 239: @8275
      GIM_Reject,
    // Label 237: @8276
    GIM_Reject,
    // Label 106: @8277
    GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(8391),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(8345), // Rule ID 46950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46950,
        GIR_EraseRootFromParent_Done,
      // Label 241: @8345
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(8390), // Rule ID 46951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46951,
        GIR_EraseRootFromParent_Done,
      // Label 242: @8390
      GIM_Reject,
    // Label 240: @8391
    GIM_Reject,
    // Label 107: @8392
    GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(8506),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(8460), // Rule ID 46962 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46962,
        GIR_EraseRootFromParent_Done,
      // Label 244: @8460
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(8505), // Rule ID 46963 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46963,
        GIR_EraseRootFromParent_Done,
      // Label 245: @8505
      GIM_Reject,
    // Label 243: @8506
    GIM_Reject,
    // Label 108: @8507
    GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(8621),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(8575), // Rule ID 46978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46978,
        GIR_EraseRootFromParent_Done,
      // Label 247: @8575
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(8620), // Rule ID 46979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46979,
        GIR_EraseRootFromParent_Done,
      // Label 248: @8620
      GIM_Reject,
    // Label 246: @8621
    GIM_Reject,
    // Label 109: @8622
    GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(8736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(8690), // Rule ID 47022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47022,
        GIR_EraseRootFromParent_Done,
      // Label 250: @8690
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(8735), // Rule ID 47023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47023,
        GIR_EraseRootFromParent_Done,
      // Label 251: @8735
      GIM_Reject,
    // Label 249: @8736
    GIM_Reject,
    // Label 110: @8737
    GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(8851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(8805), // Rule ID 46954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46954,
        GIR_EraseRootFromParent_Done,
      // Label 253: @8805
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(8850), // Rule ID 46955 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46955,
        GIR_EraseRootFromParent_Done,
      // Label 254: @8850
      GIM_Reject,
    // Label 252: @8851
    GIM_Reject,
    // Label 111: @8852
    GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(8966),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(8920), // Rule ID 46974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46974,
        GIR_EraseRootFromParent_Done,
      // Label 256: @8920
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(8965), // Rule ID 46975 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46975,
        GIR_EraseRootFromParent_Done,
      // Label 257: @8965
      GIM_Reject,
    // Label 255: @8966
    GIM_Reject,
    // Label 112: @8967
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(9081),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(9035), // Rule ID 47010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47010,
        GIR_EraseRootFromParent_Done,
      // Label 259: @9035
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(9080), // Rule ID 47011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47011,
        GIR_EraseRootFromParent_Done,
      // Label 260: @9080
      GIM_Reject,
    // Label 258: @9081
    GIM_Reject,
    // Label 113: @9082
    GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(9196),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(9150), // Rule ID 47026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47026,
        GIR_EraseRootFromParent_Done,
      // Label 262: @9150
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(9195), // Rule ID 47027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47027,
        GIR_EraseRootFromParent_Done,
      // Label 263: @9195
      GIM_Reject,
    // Label 261: @9196
    GIM_Reject,
    // Label 114: @9197
    GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(9311),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(9265), // Rule ID 46970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46970,
        GIR_EraseRootFromParent_Done,
      // Label 265: @9265
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(9310), // Rule ID 46971 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46971,
        GIR_EraseRootFromParent_Done,
      // Label 266: @9310
      GIM_Reject,
    // Label 264: @9311
    GIM_Reject,
    // Label 115: @9312
    GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(9426),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(9380), // Rule ID 46998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46998,
        GIR_EraseRootFromParent_Done,
      // Label 268: @9380
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(9425), // Rule ID 46999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46999,
        GIR_EraseRootFromParent_Done,
      // Label 269: @9425
      GIM_Reject,
    // Label 267: @9426
    GIM_Reject,
    // Label 116: @9427
    GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(9541),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(9495), // Rule ID 47014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47014,
        GIR_EraseRootFromParent_Done,
      // Label 271: @9495
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(9540), // Rule ID 47015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47015,
        GIR_EraseRootFromParent_Done,
      // Label 272: @9540
      GIM_Reject,
    // Label 270: @9541
    GIM_Reject,
    // Label 117: @9542
    GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(9656),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(9610), // Rule ID 47030 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47030,
        GIR_EraseRootFromParent_Done,
      // Label 274: @9610
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(9655), // Rule ID 47031 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47031,
        GIR_EraseRootFromParent_Done,
      // Label 275: @9655
      GIM_Reject,
    // Label 273: @9656
    GIM_Reject,
    // Label 118: @9657
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(9771),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(9725), // Rule ID 46986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46986,
        GIR_EraseRootFromParent_Done,
      // Label 277: @9725
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(9770), // Rule ID 46987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46987,
        GIR_EraseRootFromParent_Done,
      // Label 278: @9770
      GIM_Reject,
    // Label 276: @9771
    GIM_Reject,
    // Label 119: @9772
    GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(9886),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(9840), // Rule ID 47002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47002,
        GIR_EraseRootFromParent_Done,
      // Label 280: @9840
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(9885), // Rule ID 47003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47003,
        GIR_EraseRootFromParent_Done,
      // Label 281: @9885
      GIM_Reject,
    // Label 279: @9886
    GIM_Reject,
    // Label 120: @9887
    GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(10001),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(9955), // Rule ID 47018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47018,
        GIR_EraseRootFromParent_Done,
      // Label 283: @9955
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(10000), // Rule ID 47019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47019,
        GIR_EraseRootFromParent_Done,
      // Label 284: @10000
      GIM_Reject,
    // Label 282: @10001
    GIM_Reject,
    // Label 121: @10002
    GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(10116),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(10070), // Rule ID 46990 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46990,
        GIR_EraseRootFromParent_Done,
      // Label 286: @10070
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(10115), // Rule ID 46991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46991,
        GIR_EraseRootFromParent_Done,
      // Label 287: @10115
      GIM_Reject,
    // Label 285: @10116
    GIM_Reject,
    // Label 122: @10117
    GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(10231),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(10185), // Rule ID 47006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47006,
        GIR_EraseRootFromParent_Done,
      // Label 289: @10185
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(10230), // Rule ID 47007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47007,
        GIR_EraseRootFromParent_Done,
      // Label 290: @10230
      GIM_Reject,
    // Label 288: @10231
    GIM_Reject,
    // Label 123: @10232
    GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(10346),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(10300), // Rule ID 46994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46994,
        GIR_EraseRootFromParent_Done,
      // Label 292: @10300
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(10345), // Rule ID 46995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46995,
        GIR_EraseRootFromParent_Done,
      // Label 293: @10345
      GIM_Reject,
    // Label 291: @10346
    GIM_Reject,
    // Label 124: @10347
    GIM_Reject,
    // Label 1: @10348
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 318*/ GIMT_Encode4(13451),
    /*GILLT_s32*//*Label 294*/ GIMT_Encode4(10483),
    /*GILLT_s64*//*Label 295*/ GIMT_Encode4(10792), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 296*/ GIMT_Encode4(10921),
    /*GILLT_nxv1s16*//*Label 297*/ GIMT_Encode4(11036),
    /*GILLT_nxv1s32*//*Label 298*/ GIMT_Encode4(11151),
    /*GILLT_nxv1s64*//*Label 299*/ GIMT_Encode4(11266), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 300*/ GIMT_Encode4(11381),
    /*GILLT_nxv2s16*//*Label 301*/ GIMT_Encode4(11496),
    /*GILLT_nxv2s32*//*Label 302*/ GIMT_Encode4(11611),
    /*GILLT_nxv2s64*//*Label 303*/ GIMT_Encode4(11726), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 304*/ GIMT_Encode4(11841),
    /*GILLT_nxv4s16*//*Label 305*/ GIMT_Encode4(11956),
    /*GILLT_nxv4s32*//*Label 306*/ GIMT_Encode4(12071),
    /*GILLT_nxv4s64*//*Label 307*/ GIMT_Encode4(12186), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 308*/ GIMT_Encode4(12301),
    /*GILLT_nxv8s16*//*Label 309*/ GIMT_Encode4(12416),
    /*GILLT_nxv8s32*//*Label 310*/ GIMT_Encode4(12531),
    /*GILLT_nxv8s64*//*Label 311*/ GIMT_Encode4(12646), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 312*/ GIMT_Encode4(12761),
    /*GILLT_nxv16s16*//*Label 313*/ GIMT_Encode4(12876),
    /*GILLT_nxv16s32*//*Label 314*/ GIMT_Encode4(12991), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 315*/ GIMT_Encode4(13106),
    /*GILLT_nxv32s16*//*Label 316*/ GIMT_Encode4(13221), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 317*/ GIMT_Encode4(13336),
    // Label 294: @10483
    GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(10791),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(10538), // Rule ID 65043 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12Plus1>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (NegImm:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_simm12Plus1>>:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65043,
        GIR_EraseRootFromParent_Done,
      // Label 320: @10538
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(10574), // Rule ID 65044 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12Plus1i32>>:$imm)  =>  (ADDIW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (NegImm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65044,
        GIR_EraseRootFromParent_Done,
      // Label 321: @10574
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(10627), // Rule ID 63061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULS:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63061,
        GIR_EraseRootFromParent_Done,
      // Label 322: @10627
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(10680), // Rule ID 63318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULSW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63318,
        GIR_EraseRootFromParent_Done,
      // Label 323: @10680
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(10733), // Rule ID 63319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULSW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63319,
        GIR_EraseRootFromParent_Done,
      // Label 324: @10733
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(10752), // Rule ID 71 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71,
        GIR_Done,
      // Label 325: @10752
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(10771), // Rule ID 299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUBW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUBW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 299,
        GIR_Done,
      // Label 326: @10771
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(10790), // Rule ID 300 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUBW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUBW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 300,
        GIR_Done,
      // Label 327: @10790
      GIM_Reject,
    // Label 319: @10791
    GIM_Reject,
    // Label 295: @10792
    GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(10920),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(10847), // Rule ID 65042 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12Plus1>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (NegImm:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_simm12Plus1>>:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65042,
        GIR_EraseRootFromParent_Done,
      // Label 329: @10847
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(10900), // Rule ID 63060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULS:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63060,
        GIR_EraseRootFromParent_Done,
      // Label 330: @10900
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(10919), // Rule ID 70 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70,
        GIR_Done,
      // Label 331: @10919
      GIM_Reject,
    // Label 328: @10920
    GIM_Reject,
    // Label 296: @10921
    GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(11035),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(10989), // Rule ID 47076 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47076,
        GIR_EraseRootFromParent_Done,
      // Label 333: @10989
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(11034), // Rule ID 47077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47077,
        GIR_EraseRootFromParent_Done,
      // Label 334: @11034
      GIM_Reject,
    // Label 332: @11035
    GIM_Reject,
    // Label 297: @11036
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(11150),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(11104), // Rule ID 47088 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47088,
        GIR_EraseRootFromParent_Done,
      // Label 336: @11104
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(11149), // Rule ID 47089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47089,
        GIR_EraseRootFromParent_Done,
      // Label 337: @11149
      GIM_Reject,
    // Label 335: @11150
    GIM_Reject,
    // Label 298: @11151
    GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(11265),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(11219), // Rule ID 47096 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47096,
        GIR_EraseRootFromParent_Done,
      // Label 339: @11219
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(11264), // Rule ID 47097 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47097,
        GIR_EraseRootFromParent_Done,
      // Label 340: @11264
      GIM_Reject,
    // Label 338: @11265
    GIM_Reject,
    // Label 299: @11266
    GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(11380),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(11334), // Rule ID 47112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47112,
        GIR_EraseRootFromParent_Done,
      // Label 342: @11334
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(11379), // Rule ID 47113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47113,
        GIR_EraseRootFromParent_Done,
      // Label 343: @11379
      GIM_Reject,
    // Label 341: @11380
    GIM_Reject,
    // Label 300: @11381
    GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(11495),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(11449), // Rule ID 47080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47080,
        GIR_EraseRootFromParent_Done,
      // Label 345: @11449
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(11494), // Rule ID 47081 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47081,
        GIR_EraseRootFromParent_Done,
      // Label 346: @11494
      GIM_Reject,
    // Label 344: @11495
    GIM_Reject,
    // Label 301: @11496
    GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(11610),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(11564), // Rule ID 47092 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47092,
        GIR_EraseRootFromParent_Done,
      // Label 348: @11564
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(11609), // Rule ID 47093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47093,
        GIR_EraseRootFromParent_Done,
      // Label 349: @11609
      GIM_Reject,
    // Label 347: @11610
    GIM_Reject,
    // Label 302: @11611
    GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(11725),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(11679), // Rule ID 47108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47108,
        GIR_EraseRootFromParent_Done,
      // Label 351: @11679
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(11724), // Rule ID 47109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47109,
        GIR_EraseRootFromParent_Done,
      // Label 352: @11724
      GIM_Reject,
    // Label 350: @11725
    GIM_Reject,
    // Label 303: @11726
    GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(11840),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(11794), // Rule ID 47152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47152,
        GIR_EraseRootFromParent_Done,
      // Label 354: @11794
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(11839), // Rule ID 47153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47153,
        GIR_EraseRootFromParent_Done,
      // Label 355: @11839
      GIM_Reject,
    // Label 353: @11840
    GIM_Reject,
    // Label 304: @11841
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(11955),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(11909), // Rule ID 47084 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47084,
        GIR_EraseRootFromParent_Done,
      // Label 357: @11909
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(11954), // Rule ID 47085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47085,
        GIR_EraseRootFromParent_Done,
      // Label 358: @11954
      GIM_Reject,
    // Label 356: @11955
    GIM_Reject,
    // Label 305: @11956
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(12070),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(12024), // Rule ID 47104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47104,
        GIR_EraseRootFromParent_Done,
      // Label 360: @12024
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(12069), // Rule ID 47105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47105,
        GIR_EraseRootFromParent_Done,
      // Label 361: @12069
      GIM_Reject,
    // Label 359: @12070
    GIM_Reject,
    // Label 306: @12071
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(12185),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(12139), // Rule ID 47140 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47140,
        GIR_EraseRootFromParent_Done,
      // Label 363: @12139
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(12184), // Rule ID 47141 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47141,
        GIR_EraseRootFromParent_Done,
      // Label 364: @12184
      GIM_Reject,
    // Label 362: @12185
    GIM_Reject,
    // Label 307: @12186
    GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(12300),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(12254), // Rule ID 47156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47156,
        GIR_EraseRootFromParent_Done,
      // Label 366: @12254
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(12299), // Rule ID 47157 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47157,
        GIR_EraseRootFromParent_Done,
      // Label 367: @12299
      GIM_Reject,
    // Label 365: @12300
    GIM_Reject,
    // Label 308: @12301
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(12415),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(12369), // Rule ID 47100 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47100,
        GIR_EraseRootFromParent_Done,
      // Label 369: @12369
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(12414), // Rule ID 47101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47101,
        GIR_EraseRootFromParent_Done,
      // Label 370: @12414
      GIM_Reject,
    // Label 368: @12415
    GIM_Reject,
    // Label 309: @12416
    GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(12530),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(12484), // Rule ID 47128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47128,
        GIR_EraseRootFromParent_Done,
      // Label 372: @12484
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(12529), // Rule ID 47129 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47129,
        GIR_EraseRootFromParent_Done,
      // Label 373: @12529
      GIM_Reject,
    // Label 371: @12530
    GIM_Reject,
    // Label 310: @12531
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(12645),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(12599), // Rule ID 47144 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47144,
        GIR_EraseRootFromParent_Done,
      // Label 375: @12599
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(12644), // Rule ID 47145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47145,
        GIR_EraseRootFromParent_Done,
      // Label 376: @12644
      GIM_Reject,
    // Label 374: @12645
    GIM_Reject,
    // Label 311: @12646
    GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(12760),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(12714), // Rule ID 47160 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47160,
        GIR_EraseRootFromParent_Done,
      // Label 378: @12714
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(12759), // Rule ID 47161 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47161,
        GIR_EraseRootFromParent_Done,
      // Label 379: @12759
      GIM_Reject,
    // Label 377: @12760
    GIM_Reject,
    // Label 312: @12761
    GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(12875),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(12829), // Rule ID 47116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47116,
        GIR_EraseRootFromParent_Done,
      // Label 381: @12829
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(12874), // Rule ID 47117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47117,
        GIR_EraseRootFromParent_Done,
      // Label 382: @12874
      GIM_Reject,
    // Label 380: @12875
    GIM_Reject,
    // Label 313: @12876
    GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(12990),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(12944), // Rule ID 47132 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47132,
        GIR_EraseRootFromParent_Done,
      // Label 384: @12944
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(12989), // Rule ID 47133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47133,
        GIR_EraseRootFromParent_Done,
      // Label 385: @12989
      GIM_Reject,
    // Label 383: @12990
    GIM_Reject,
    // Label 314: @12991
    GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(13105),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(13059), // Rule ID 47148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47148,
        GIR_EraseRootFromParent_Done,
      // Label 387: @13059
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(13104), // Rule ID 47149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47149,
        GIR_EraseRootFromParent_Done,
      // Label 388: @13104
      GIM_Reject,
    // Label 386: @13105
    GIM_Reject,
    // Label 315: @13106
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(13220),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(13174), // Rule ID 47120 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47120,
        GIR_EraseRootFromParent_Done,
      // Label 390: @13174
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(13219), // Rule ID 47121 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47121,
        GIR_EraseRootFromParent_Done,
      // Label 391: @13219
      GIM_Reject,
    // Label 389: @13220
    GIM_Reject,
    // Label 316: @13221
    GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(13335),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(13289), // Rule ID 47136 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47136,
        GIR_EraseRootFromParent_Done,
      // Label 393: @13289
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(13334), // Rule ID 47137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47137,
        GIR_EraseRootFromParent_Done,
      // Label 394: @13334
      GIM_Reject,
    // Label 392: @13335
    GIM_Reject,
    // Label 317: @13336
    GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(13450),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(13404), // Rule ID 47124 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47124,
        GIR_EraseRootFromParent_Done,
      // Label 396: @13404
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(13449), // Rule ID 47125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47125,
        GIR_EraseRootFromParent_Done,
      // Label 397: @13449
      GIM_Reject,
    // Label 395: @13450
    GIM_Reject,
    // Label 318: @13451
    GIM_Reject,
    // Label 2: @13452
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 422*/ GIMT_Encode4(16356),
    /*GILLT_s32*//*Label 398*/ GIMT_Encode4(13587),
    /*GILLT_s64*//*Label 399*/ GIMT_Encode4(13657), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 400*/ GIMT_Encode4(13826),
    /*GILLT_nxv1s16*//*Label 401*/ GIMT_Encode4(13941),
    /*GILLT_nxv1s32*//*Label 402*/ GIMT_Encode4(14056),
    /*GILLT_nxv1s64*//*Label 403*/ GIMT_Encode4(14171), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 404*/ GIMT_Encode4(14286),
    /*GILLT_nxv2s16*//*Label 405*/ GIMT_Encode4(14401),
    /*GILLT_nxv2s32*//*Label 406*/ GIMT_Encode4(14516),
    /*GILLT_nxv2s64*//*Label 407*/ GIMT_Encode4(14631), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 408*/ GIMT_Encode4(14746),
    /*GILLT_nxv4s16*//*Label 409*/ GIMT_Encode4(14861),
    /*GILLT_nxv4s32*//*Label 410*/ GIMT_Encode4(14976),
    /*GILLT_nxv4s64*//*Label 411*/ GIMT_Encode4(15091), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 412*/ GIMT_Encode4(15206),
    /*GILLT_nxv8s16*//*Label 413*/ GIMT_Encode4(15321),
    /*GILLT_nxv8s32*//*Label 414*/ GIMT_Encode4(15436),
    /*GILLT_nxv8s64*//*Label 415*/ GIMT_Encode4(15551), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 416*/ GIMT_Encode4(15666),
    /*GILLT_nxv16s16*//*Label 417*/ GIMT_Encode4(15781),
    /*GILLT_nxv16s32*//*Label 418*/ GIMT_Encode4(15896), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 419*/ GIMT_Encode4(16011),
    /*GILLT_nxv32s16*//*Label 420*/ GIMT_Encode4(16126), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 421*/ GIMT_Encode4(16241),
    // Label 398: @13587
    GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(13656),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(13625), // Rule ID 325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_HwMode1),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 325,
        GIR_Done,
      // Label 424: @13625
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(13640), // Rule ID 348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_IsRV64_HwMode0),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MULW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MULW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 348,
        GIR_Done,
      // Label 425: @13640
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(13655), // Rule ID 349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_IsRV64_HwMode1),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MULW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MULW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 349,
        GIR_Done,
      // Label 426: @13655
      GIM_Reject,
    // Label 423: @13656
    GIM_Reject,
    // Label 399: @13657
    GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(13825),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(13801), // Rule ID 347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::MULHU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 347,
        GIR_EraseRootFromParent_Done,
      // Label 428: @13801
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(13824), // Rule ID 324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 324,
        GIR_Done,
      // Label 429: @13824
      GIM_Reject,
    // Label 427: @13825
    GIM_Reject,
    // Label 400: @13826
    GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(13940),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(13894), // Rule ID 51480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51480,
        GIR_EraseRootFromParent_Done,
      // Label 431: @13894
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(13939), // Rule ID 51481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51481,
        GIR_EraseRootFromParent_Done,
      // Label 432: @13939
      GIM_Reject,
    // Label 430: @13940
    GIM_Reject,
    // Label 401: @13941
    GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(14055),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(14009), // Rule ID 51492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51492,
        GIR_EraseRootFromParent_Done,
      // Label 434: @14009
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(14054), // Rule ID 51493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51493,
        GIR_EraseRootFromParent_Done,
      // Label 435: @14054
      GIM_Reject,
    // Label 433: @14055
    GIM_Reject,
    // Label 402: @14056
    GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(14170),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(14124), // Rule ID 51500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51500,
        GIR_EraseRootFromParent_Done,
      // Label 437: @14124
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(14169), // Rule ID 51501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51501,
        GIR_EraseRootFromParent_Done,
      // Label 438: @14169
      GIM_Reject,
    // Label 436: @14170
    GIM_Reject,
    // Label 403: @14171
    GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(14285),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(14239), // Rule ID 51516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51516,
        GIR_EraseRootFromParent_Done,
      // Label 440: @14239
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(14284), // Rule ID 51517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51517,
        GIR_EraseRootFromParent_Done,
      // Label 441: @14284
      GIM_Reject,
    // Label 439: @14285
    GIM_Reject,
    // Label 404: @14286
    GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(14400),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(14354), // Rule ID 51484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51484,
        GIR_EraseRootFromParent_Done,
      // Label 443: @14354
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(14399), // Rule ID 51485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51485,
        GIR_EraseRootFromParent_Done,
      // Label 444: @14399
      GIM_Reject,
    // Label 442: @14400
    GIM_Reject,
    // Label 405: @14401
    GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(14515),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(14469), // Rule ID 51496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51496,
        GIR_EraseRootFromParent_Done,
      // Label 446: @14469
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(14514), // Rule ID 51497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51497,
        GIR_EraseRootFromParent_Done,
      // Label 447: @14514
      GIM_Reject,
    // Label 445: @14515
    GIM_Reject,
    // Label 406: @14516
    GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(14630),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(14584), // Rule ID 51512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51512,
        GIR_EraseRootFromParent_Done,
      // Label 449: @14584
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(14629), // Rule ID 51513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51513,
        GIR_EraseRootFromParent_Done,
      // Label 450: @14629
      GIM_Reject,
    // Label 448: @14630
    GIM_Reject,
    // Label 407: @14631
    GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(14745),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(14699), // Rule ID 51556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51556,
        GIR_EraseRootFromParent_Done,
      // Label 452: @14699
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(14744), // Rule ID 51557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51557,
        GIR_EraseRootFromParent_Done,
      // Label 453: @14744
      GIM_Reject,
    // Label 451: @14745
    GIM_Reject,
    // Label 408: @14746
    GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(14860),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(14814), // Rule ID 51488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51488,
        GIR_EraseRootFromParent_Done,
      // Label 455: @14814
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(14859), // Rule ID 51489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51489,
        GIR_EraseRootFromParent_Done,
      // Label 456: @14859
      GIM_Reject,
    // Label 454: @14860
    GIM_Reject,
    // Label 409: @14861
    GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(14975),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(14929), // Rule ID 51508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51508,
        GIR_EraseRootFromParent_Done,
      // Label 458: @14929
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(14974), // Rule ID 51509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51509,
        GIR_EraseRootFromParent_Done,
      // Label 459: @14974
      GIM_Reject,
    // Label 457: @14975
    GIM_Reject,
    // Label 410: @14976
    GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(15090),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(15044), // Rule ID 51544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51544,
        GIR_EraseRootFromParent_Done,
      // Label 461: @15044
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(15089), // Rule ID 51545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51545,
        GIR_EraseRootFromParent_Done,
      // Label 462: @15089
      GIM_Reject,
    // Label 460: @15090
    GIM_Reject,
    // Label 411: @15091
    GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(15205),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(15159), // Rule ID 51560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51560,
        GIR_EraseRootFromParent_Done,
      // Label 464: @15159
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(15204), // Rule ID 51561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51561,
        GIR_EraseRootFromParent_Done,
      // Label 465: @15204
      GIM_Reject,
    // Label 463: @15205
    GIM_Reject,
    // Label 412: @15206
    GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(15320),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(15274), // Rule ID 51504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51504,
        GIR_EraseRootFromParent_Done,
      // Label 467: @15274
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(15319), // Rule ID 51505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51505,
        GIR_EraseRootFromParent_Done,
      // Label 468: @15319
      GIM_Reject,
    // Label 466: @15320
    GIM_Reject,
    // Label 413: @15321
    GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(15435),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(15389), // Rule ID 51532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51532,
        GIR_EraseRootFromParent_Done,
      // Label 470: @15389
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(15434), // Rule ID 51533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51533,
        GIR_EraseRootFromParent_Done,
      // Label 471: @15434
      GIM_Reject,
    // Label 469: @15435
    GIM_Reject,
    // Label 414: @15436
    GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(15550),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(15504), // Rule ID 51548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51548,
        GIR_EraseRootFromParent_Done,
      // Label 473: @15504
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(15549), // Rule ID 51549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51549,
        GIR_EraseRootFromParent_Done,
      // Label 474: @15549
      GIM_Reject,
    // Label 472: @15550
    GIM_Reject,
    // Label 415: @15551
    GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(15665),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(15619), // Rule ID 51564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51564,
        GIR_EraseRootFromParent_Done,
      // Label 476: @15619
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(15664), // Rule ID 51565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51565,
        GIR_EraseRootFromParent_Done,
      // Label 477: @15664
      GIM_Reject,
    // Label 475: @15665
    GIM_Reject,
    // Label 416: @15666
    GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(15780),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(15734), // Rule ID 51520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51520,
        GIR_EraseRootFromParent_Done,
      // Label 479: @15734
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(15779), // Rule ID 51521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51521,
        GIR_EraseRootFromParent_Done,
      // Label 480: @15779
      GIM_Reject,
    // Label 478: @15780
    GIM_Reject,
    // Label 417: @15781
    GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(15895),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(15849), // Rule ID 51536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51536,
        GIR_EraseRootFromParent_Done,
      // Label 482: @15849
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(15894), // Rule ID 51537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51537,
        GIR_EraseRootFromParent_Done,
      // Label 483: @15894
      GIM_Reject,
    // Label 481: @15895
    GIM_Reject,
    // Label 418: @15896
    GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(16010),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(15964), // Rule ID 51552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51552,
        GIR_EraseRootFromParent_Done,
      // Label 485: @15964
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(16009), // Rule ID 51553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51553,
        GIR_EraseRootFromParent_Done,
      // Label 486: @16009
      GIM_Reject,
    // Label 484: @16010
    GIM_Reject,
    // Label 419: @16011
    GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(16125),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(16079), // Rule ID 51524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51524,
        GIR_EraseRootFromParent_Done,
      // Label 488: @16079
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(16124), // Rule ID 51525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51525,
        GIR_EraseRootFromParent_Done,
      // Label 489: @16124
      GIM_Reject,
    // Label 487: @16125
    GIM_Reject,
    // Label 420: @16126
    GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(16240),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(16194), // Rule ID 51540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51540,
        GIR_EraseRootFromParent_Done,
      // Label 491: @16194
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(16239), // Rule ID 51541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51541,
        GIR_EraseRootFromParent_Done,
      // Label 492: @16239
      GIM_Reject,
    // Label 490: @16240
    GIM_Reject,
    // Label 421: @16241
    GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(16355),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(16309), // Rule ID 51528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51528,
        GIR_EraseRootFromParent_Done,
      // Label 494: @16309
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(16354), // Rule ID 51529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51529,
        GIR_EraseRootFromParent_Done,
      // Label 495: @16354
      GIM_Reject,
    // Label 493: @16355
    GIM_Reject,
    // Label 422: @16356
    GIM_Reject,
    // Label 3: @16357
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 520*/ GIMT_Encode4(19126),
    /*GILLT_s32*//*Label 496*/ GIMT_Encode4(16492),
    /*GILLT_s64*//*Label 497*/ GIMT_Encode4(16562), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 498*/ GIMT_Encode4(16596),
    /*GILLT_nxv1s16*//*Label 499*/ GIMT_Encode4(16711),
    /*GILLT_nxv1s32*//*Label 500*/ GIMT_Encode4(16826),
    /*GILLT_nxv1s64*//*Label 501*/ GIMT_Encode4(16941), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 502*/ GIMT_Encode4(17056),
    /*GILLT_nxv2s16*//*Label 503*/ GIMT_Encode4(17171),
    /*GILLT_nxv2s32*//*Label 504*/ GIMT_Encode4(17286),
    /*GILLT_nxv2s64*//*Label 505*/ GIMT_Encode4(17401), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 506*/ GIMT_Encode4(17516),
    /*GILLT_nxv4s16*//*Label 507*/ GIMT_Encode4(17631),
    /*GILLT_nxv4s32*//*Label 508*/ GIMT_Encode4(17746),
    /*GILLT_nxv4s64*//*Label 509*/ GIMT_Encode4(17861), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 510*/ GIMT_Encode4(17976),
    /*GILLT_nxv8s16*//*Label 511*/ GIMT_Encode4(18091),
    /*GILLT_nxv8s32*//*Label 512*/ GIMT_Encode4(18206),
    /*GILLT_nxv8s64*//*Label 513*/ GIMT_Encode4(18321), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 514*/ GIMT_Encode4(18436),
    /*GILLT_nxv16s16*//*Label 515*/ GIMT_Encode4(18551),
    /*GILLT_nxv16s32*//*Label 516*/ GIMT_Encode4(18666), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 517*/ GIMT_Encode4(18781),
    /*GILLT_nxv32s16*//*Label 518*/ GIMT_Encode4(18896), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 519*/ GIMT_Encode4(19011),
    // Label 496: @16492
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(16561),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(16530), // Rule ID 333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 333,
        GIR_Done,
      // Label 522: @16530
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(16545), // Rule ID 350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 350,
        GIR_Done,
      // Label 523: @16545
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(16560), // Rule ID 351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 351,
        GIR_Done,
      // Label 524: @16560
      GIM_Reject,
    // Label 521: @16561
    GIM_Reject,
    // Label 497: @16562
    GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(16595), // Rule ID 332 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 332,
      GIR_Done,
    // Label 525: @16595
    GIM_Reject,
    // Label 498: @16596
    GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(16710),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(16664), // Rule ID 51832 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51832,
        GIR_EraseRootFromParent_Done,
      // Label 527: @16664
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(16709), // Rule ID 51833 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51833,
        GIR_EraseRootFromParent_Done,
      // Label 528: @16709
      GIM_Reject,
    // Label 526: @16710
    GIM_Reject,
    // Label 499: @16711
    GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(16825),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(16779), // Rule ID 51844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51844,
        GIR_EraseRootFromParent_Done,
      // Label 530: @16779
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(16824), // Rule ID 51845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51845,
        GIR_EraseRootFromParent_Done,
      // Label 531: @16824
      GIM_Reject,
    // Label 529: @16825
    GIM_Reject,
    // Label 500: @16826
    GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(16940),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(16894), // Rule ID 51852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51852,
        GIR_EraseRootFromParent_Done,
      // Label 533: @16894
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(16939), // Rule ID 51853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51853,
        GIR_EraseRootFromParent_Done,
      // Label 534: @16939
      GIM_Reject,
    // Label 532: @16940
    GIM_Reject,
    // Label 501: @16941
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(17055),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(17009), // Rule ID 51868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51868,
        GIR_EraseRootFromParent_Done,
      // Label 536: @17009
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(17054), // Rule ID 51869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51869,
        GIR_EraseRootFromParent_Done,
      // Label 537: @17054
      GIM_Reject,
    // Label 535: @17055
    GIM_Reject,
    // Label 502: @17056
    GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(17170),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(17124), // Rule ID 51836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51836,
        GIR_EraseRootFromParent_Done,
      // Label 539: @17124
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(17169), // Rule ID 51837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51837,
        GIR_EraseRootFromParent_Done,
      // Label 540: @17169
      GIM_Reject,
    // Label 538: @17170
    GIM_Reject,
    // Label 503: @17171
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(17285),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(17239), // Rule ID 51848 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51848,
        GIR_EraseRootFromParent_Done,
      // Label 542: @17239
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(17284), // Rule ID 51849 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51849,
        GIR_EraseRootFromParent_Done,
      // Label 543: @17284
      GIM_Reject,
    // Label 541: @17285
    GIM_Reject,
    // Label 504: @17286
    GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(17400),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(17354), // Rule ID 51864 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51864,
        GIR_EraseRootFromParent_Done,
      // Label 545: @17354
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(17399), // Rule ID 51865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51865,
        GIR_EraseRootFromParent_Done,
      // Label 546: @17399
      GIM_Reject,
    // Label 544: @17400
    GIM_Reject,
    // Label 505: @17401
    GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(17515),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(17469), // Rule ID 51908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51908,
        GIR_EraseRootFromParent_Done,
      // Label 548: @17469
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(17514), // Rule ID 51909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51909,
        GIR_EraseRootFromParent_Done,
      // Label 549: @17514
      GIM_Reject,
    // Label 547: @17515
    GIM_Reject,
    // Label 506: @17516
    GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(17630),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(17584), // Rule ID 51840 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51840,
        GIR_EraseRootFromParent_Done,
      // Label 551: @17584
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(17629), // Rule ID 51841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51841,
        GIR_EraseRootFromParent_Done,
      // Label 552: @17629
      GIM_Reject,
    // Label 550: @17630
    GIM_Reject,
    // Label 507: @17631
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(17745),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(17699), // Rule ID 51860 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51860,
        GIR_EraseRootFromParent_Done,
      // Label 554: @17699
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(17744), // Rule ID 51861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51861,
        GIR_EraseRootFromParent_Done,
      // Label 555: @17744
      GIM_Reject,
    // Label 553: @17745
    GIM_Reject,
    // Label 508: @17746
    GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(17860),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(17814), // Rule ID 51896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51896,
        GIR_EraseRootFromParent_Done,
      // Label 557: @17814
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(17859), // Rule ID 51897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51897,
        GIR_EraseRootFromParent_Done,
      // Label 558: @17859
      GIM_Reject,
    // Label 556: @17860
    GIM_Reject,
    // Label 509: @17861
    GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(17975),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(17929), // Rule ID 51912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51912,
        GIR_EraseRootFromParent_Done,
      // Label 560: @17929
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(17974), // Rule ID 51913 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51913,
        GIR_EraseRootFromParent_Done,
      // Label 561: @17974
      GIM_Reject,
    // Label 559: @17975
    GIM_Reject,
    // Label 510: @17976
    GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(18090),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(18044), // Rule ID 51856 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51856,
        GIR_EraseRootFromParent_Done,
      // Label 563: @18044
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(18089), // Rule ID 51857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51857,
        GIR_EraseRootFromParent_Done,
      // Label 564: @18089
      GIM_Reject,
    // Label 562: @18090
    GIM_Reject,
    // Label 511: @18091
    GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(18205),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(18159), // Rule ID 51884 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51884,
        GIR_EraseRootFromParent_Done,
      // Label 566: @18159
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(18204), // Rule ID 51885 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51885,
        GIR_EraseRootFromParent_Done,
      // Label 567: @18204
      GIM_Reject,
    // Label 565: @18205
    GIM_Reject,
    // Label 512: @18206
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(18320),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(18274), // Rule ID 51900 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51900,
        GIR_EraseRootFromParent_Done,
      // Label 569: @18274
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(18319), // Rule ID 51901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51901,
        GIR_EraseRootFromParent_Done,
      // Label 570: @18319
      GIM_Reject,
    // Label 568: @18320
    GIM_Reject,
    // Label 513: @18321
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(18435),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(18389), // Rule ID 51916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51916,
        GIR_EraseRootFromParent_Done,
      // Label 572: @18389
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(18434), // Rule ID 51917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51917,
        GIR_EraseRootFromParent_Done,
      // Label 573: @18434
      GIM_Reject,
    // Label 571: @18435
    GIM_Reject,
    // Label 514: @18436
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(18550),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(18504), // Rule ID 51872 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51872,
        GIR_EraseRootFromParent_Done,
      // Label 575: @18504
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(18549), // Rule ID 51873 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51873,
        GIR_EraseRootFromParent_Done,
      // Label 576: @18549
      GIM_Reject,
    // Label 574: @18550
    GIM_Reject,
    // Label 515: @18551
    GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(18665),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(18619), // Rule ID 51888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51888,
        GIR_EraseRootFromParent_Done,
      // Label 578: @18619
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(18664), // Rule ID 51889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51889,
        GIR_EraseRootFromParent_Done,
      // Label 579: @18664
      GIM_Reject,
    // Label 577: @18665
    GIM_Reject,
    // Label 516: @18666
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(18780),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(18734), // Rule ID 51904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51904,
        GIR_EraseRootFromParent_Done,
      // Label 581: @18734
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(18779), // Rule ID 51905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51905,
        GIR_EraseRootFromParent_Done,
      // Label 582: @18779
      GIM_Reject,
    // Label 580: @18780
    GIM_Reject,
    // Label 517: @18781
    GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(18895),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(18849), // Rule ID 51876 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51876,
        GIR_EraseRootFromParent_Done,
      // Label 584: @18849
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(18894), // Rule ID 51877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51877,
        GIR_EraseRootFromParent_Done,
      // Label 585: @18894
      GIM_Reject,
    // Label 583: @18895
    GIM_Reject,
    // Label 518: @18896
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(19010),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(18964), // Rule ID 51892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51892,
        GIR_EraseRootFromParent_Done,
      // Label 587: @18964
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(19009), // Rule ID 51893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51893,
        GIR_EraseRootFromParent_Done,
      // Label 588: @19009
      GIM_Reject,
    // Label 586: @19010
    GIM_Reject,
    // Label 519: @19011
    GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(19125),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(19079), // Rule ID 51880 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51880,
        GIR_EraseRootFromParent_Done,
      // Label 590: @19079
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(19124), // Rule ID 51881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51881,
        GIR_EraseRootFromParent_Done,
      // Label 591: @19124
      GIM_Reject,
    // Label 589: @19125
    GIM_Reject,
    // Label 520: @19126
    GIM_Reject,
    // Label 4: @19127
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 616*/ GIMT_Encode4(21896),
    /*GILLT_s32*//*Label 592*/ GIMT_Encode4(19262),
    /*GILLT_s64*//*Label 593*/ GIMT_Encode4(19332), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 594*/ GIMT_Encode4(19366),
    /*GILLT_nxv1s16*//*Label 595*/ GIMT_Encode4(19481),
    /*GILLT_nxv1s32*//*Label 596*/ GIMT_Encode4(19596),
    /*GILLT_nxv1s64*//*Label 597*/ GIMT_Encode4(19711), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 598*/ GIMT_Encode4(19826),
    /*GILLT_nxv2s16*//*Label 599*/ GIMT_Encode4(19941),
    /*GILLT_nxv2s32*//*Label 600*/ GIMT_Encode4(20056),
    /*GILLT_nxv2s64*//*Label 601*/ GIMT_Encode4(20171), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 602*/ GIMT_Encode4(20286),
    /*GILLT_nxv4s16*//*Label 603*/ GIMT_Encode4(20401),
    /*GILLT_nxv4s32*//*Label 604*/ GIMT_Encode4(20516),
    /*GILLT_nxv4s64*//*Label 605*/ GIMT_Encode4(20631), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 606*/ GIMT_Encode4(20746),
    /*GILLT_nxv8s16*//*Label 607*/ GIMT_Encode4(20861),
    /*GILLT_nxv8s32*//*Label 608*/ GIMT_Encode4(20976),
    /*GILLT_nxv8s64*//*Label 609*/ GIMT_Encode4(21091), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 610*/ GIMT_Encode4(21206),
    /*GILLT_nxv16s16*//*Label 611*/ GIMT_Encode4(21321),
    /*GILLT_nxv16s32*//*Label 612*/ GIMT_Encode4(21436), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 613*/ GIMT_Encode4(21551),
    /*GILLT_nxv32s16*//*Label 614*/ GIMT_Encode4(21666), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 615*/ GIMT_Encode4(21781),
    // Label 592: @19262
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(19331),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(19300), // Rule ID 335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 335,
        GIR_Done,
      // Label 618: @19300
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(19315), // Rule ID 352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 619: @19315
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(19330), // Rule ID 353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 620: @19330
      GIM_Reject,
    // Label 617: @19331
    GIM_Reject,
    // Label 593: @19332
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(19365), // Rule ID 334 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 334,
      GIR_Done,
    // Label 621: @19365
    GIM_Reject,
    // Label 594: @19366
    GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(19480),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(19434), // Rule ID 51744 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51744,
        GIR_EraseRootFromParent_Done,
      // Label 623: @19434
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(19479), // Rule ID 51745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51745,
        GIR_EraseRootFromParent_Done,
      // Label 624: @19479
      GIM_Reject,
    // Label 622: @19480
    GIM_Reject,
    // Label 595: @19481
    GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(19595),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(19549), // Rule ID 51756 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51756,
        GIR_EraseRootFromParent_Done,
      // Label 626: @19549
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(19594), // Rule ID 51757 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51757,
        GIR_EraseRootFromParent_Done,
      // Label 627: @19594
      GIM_Reject,
    // Label 625: @19595
    GIM_Reject,
    // Label 596: @19596
    GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(19710),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(19664), // Rule ID 51764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51764,
        GIR_EraseRootFromParent_Done,
      // Label 629: @19664
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(19709), // Rule ID 51765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51765,
        GIR_EraseRootFromParent_Done,
      // Label 630: @19709
      GIM_Reject,
    // Label 628: @19710
    GIM_Reject,
    // Label 597: @19711
    GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(19825),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(19779), // Rule ID 51780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51780,
        GIR_EraseRootFromParent_Done,
      // Label 632: @19779
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(19824), // Rule ID 51781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51781,
        GIR_EraseRootFromParent_Done,
      // Label 633: @19824
      GIM_Reject,
    // Label 631: @19825
    GIM_Reject,
    // Label 598: @19826
    GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(19940),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(19894), // Rule ID 51748 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51748,
        GIR_EraseRootFromParent_Done,
      // Label 635: @19894
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(19939), // Rule ID 51749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51749,
        GIR_EraseRootFromParent_Done,
      // Label 636: @19939
      GIM_Reject,
    // Label 634: @19940
    GIM_Reject,
    // Label 599: @19941
    GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(20055),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(20009), // Rule ID 51760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51760,
        GIR_EraseRootFromParent_Done,
      // Label 638: @20009
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(20054), // Rule ID 51761 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51761,
        GIR_EraseRootFromParent_Done,
      // Label 639: @20054
      GIM_Reject,
    // Label 637: @20055
    GIM_Reject,
    // Label 600: @20056
    GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(20170),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(20124), // Rule ID 51776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51776,
        GIR_EraseRootFromParent_Done,
      // Label 641: @20124
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(20169), // Rule ID 51777 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51777,
        GIR_EraseRootFromParent_Done,
      // Label 642: @20169
      GIM_Reject,
    // Label 640: @20170
    GIM_Reject,
    // Label 601: @20171
    GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(20285),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(20239), // Rule ID 51820 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51820,
        GIR_EraseRootFromParent_Done,
      // Label 644: @20239
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(20284), // Rule ID 51821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51821,
        GIR_EraseRootFromParent_Done,
      // Label 645: @20284
      GIM_Reject,
    // Label 643: @20285
    GIM_Reject,
    // Label 602: @20286
    GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(20400),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(20354), // Rule ID 51752 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51752,
        GIR_EraseRootFromParent_Done,
      // Label 647: @20354
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(20399), // Rule ID 51753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51753,
        GIR_EraseRootFromParent_Done,
      // Label 648: @20399
      GIM_Reject,
    // Label 646: @20400
    GIM_Reject,
    // Label 603: @20401
    GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(20515),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(20469), // Rule ID 51772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51772,
        GIR_EraseRootFromParent_Done,
      // Label 650: @20469
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(20514), // Rule ID 51773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51773,
        GIR_EraseRootFromParent_Done,
      // Label 651: @20514
      GIM_Reject,
    // Label 649: @20515
    GIM_Reject,
    // Label 604: @20516
    GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(20630),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(20584), // Rule ID 51808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51808,
        GIR_EraseRootFromParent_Done,
      // Label 653: @20584
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(20629), // Rule ID 51809 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51809,
        GIR_EraseRootFromParent_Done,
      // Label 654: @20629
      GIM_Reject,
    // Label 652: @20630
    GIM_Reject,
    // Label 605: @20631
    GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(20745),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(20699), // Rule ID 51824 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51824,
        GIR_EraseRootFromParent_Done,
      // Label 656: @20699
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(20744), // Rule ID 51825 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51825,
        GIR_EraseRootFromParent_Done,
      // Label 657: @20744
      GIM_Reject,
    // Label 655: @20745
    GIM_Reject,
    // Label 606: @20746
    GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(20860),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(20814), // Rule ID 51768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51768,
        GIR_EraseRootFromParent_Done,
      // Label 659: @20814
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(20859), // Rule ID 51769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51769,
        GIR_EraseRootFromParent_Done,
      // Label 660: @20859
      GIM_Reject,
    // Label 658: @20860
    GIM_Reject,
    // Label 607: @20861
    GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(20975),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(20929), // Rule ID 51796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51796,
        GIR_EraseRootFromParent_Done,
      // Label 662: @20929
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(20974), // Rule ID 51797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51797,
        GIR_EraseRootFromParent_Done,
      // Label 663: @20974
      GIM_Reject,
    // Label 661: @20975
    GIM_Reject,
    // Label 608: @20976
    GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(21090),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(21044), // Rule ID 51812 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51812,
        GIR_EraseRootFromParent_Done,
      // Label 665: @21044
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(21089), // Rule ID 51813 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51813,
        GIR_EraseRootFromParent_Done,
      // Label 666: @21089
      GIM_Reject,
    // Label 664: @21090
    GIM_Reject,
    // Label 609: @21091
    GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(21205),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(21159), // Rule ID 51828 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51828,
        GIR_EraseRootFromParent_Done,
      // Label 668: @21159
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(21204), // Rule ID 51829 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51829,
        GIR_EraseRootFromParent_Done,
      // Label 669: @21204
      GIM_Reject,
    // Label 667: @21205
    GIM_Reject,
    // Label 610: @21206
    GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(21320),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(21274), // Rule ID 51784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51784,
        GIR_EraseRootFromParent_Done,
      // Label 671: @21274
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(21319), // Rule ID 51785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51785,
        GIR_EraseRootFromParent_Done,
      // Label 672: @21319
      GIM_Reject,
    // Label 670: @21320
    GIM_Reject,
    // Label 611: @21321
    GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(21435),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(21389), // Rule ID 51800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51800,
        GIR_EraseRootFromParent_Done,
      // Label 674: @21389
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(21434), // Rule ID 51801 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51801,
        GIR_EraseRootFromParent_Done,
      // Label 675: @21434
      GIM_Reject,
    // Label 673: @21435
    GIM_Reject,
    // Label 612: @21436
    GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(21550),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(21504), // Rule ID 51816 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51816,
        GIR_EraseRootFromParent_Done,
      // Label 677: @21504
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(21549), // Rule ID 51817 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51817,
        GIR_EraseRootFromParent_Done,
      // Label 678: @21549
      GIM_Reject,
    // Label 676: @21550
    GIM_Reject,
    // Label 613: @21551
    GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(21665),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(21619), // Rule ID 51788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51788,
        GIR_EraseRootFromParent_Done,
      // Label 680: @21619
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(21664), // Rule ID 51789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51789,
        GIR_EraseRootFromParent_Done,
      // Label 681: @21664
      GIM_Reject,
    // Label 679: @21665
    GIM_Reject,
    // Label 614: @21666
    GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(21780),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(21734), // Rule ID 51804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51804,
        GIR_EraseRootFromParent_Done,
      // Label 683: @21734
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(21779), // Rule ID 51805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51805,
        GIR_EraseRootFromParent_Done,
      // Label 684: @21779
      GIM_Reject,
    // Label 682: @21780
    GIM_Reject,
    // Label 615: @21781
    GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(21895),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(21849), // Rule ID 51792 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51792,
        GIR_EraseRootFromParent_Done,
      // Label 686: @21849
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(21894), // Rule ID 51793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51793,
        GIR_EraseRootFromParent_Done,
      // Label 687: @21894
      GIM_Reject,
    // Label 685: @21895
    GIM_Reject,
    // Label 616: @21896
    GIM_Reject,
    // Label 5: @21897
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 712*/ GIMT_Encode4(24666),
    /*GILLT_s32*//*Label 688*/ GIMT_Encode4(22032),
    /*GILLT_s64*//*Label 689*/ GIMT_Encode4(22102), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 690*/ GIMT_Encode4(22136),
    /*GILLT_nxv1s16*//*Label 691*/ GIMT_Encode4(22251),
    /*GILLT_nxv1s32*//*Label 692*/ GIMT_Encode4(22366),
    /*GILLT_nxv1s64*//*Label 693*/ GIMT_Encode4(22481), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 694*/ GIMT_Encode4(22596),
    /*GILLT_nxv2s16*//*Label 695*/ GIMT_Encode4(22711),
    /*GILLT_nxv2s32*//*Label 696*/ GIMT_Encode4(22826),
    /*GILLT_nxv2s64*//*Label 697*/ GIMT_Encode4(22941), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 698*/ GIMT_Encode4(23056),
    /*GILLT_nxv4s16*//*Label 699*/ GIMT_Encode4(23171),
    /*GILLT_nxv4s32*//*Label 700*/ GIMT_Encode4(23286),
    /*GILLT_nxv4s64*//*Label 701*/ GIMT_Encode4(23401), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 702*/ GIMT_Encode4(23516),
    /*GILLT_nxv8s16*//*Label 703*/ GIMT_Encode4(23631),
    /*GILLT_nxv8s32*//*Label 704*/ GIMT_Encode4(23746),
    /*GILLT_nxv8s64*//*Label 705*/ GIMT_Encode4(23861), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 706*/ GIMT_Encode4(23976),
    /*GILLT_nxv16s16*//*Label 707*/ GIMT_Encode4(24091),
    /*GILLT_nxv16s32*//*Label 708*/ GIMT_Encode4(24206), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 709*/ GIMT_Encode4(24321),
    /*GILLT_nxv32s16*//*Label 710*/ GIMT_Encode4(24436), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 711*/ GIMT_Encode4(24551),
    // Label 688: @22032
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(22101),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(22070), // Rule ID 337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 337,
        GIR_Done,
      // Label 714: @22070
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(22085), // Rule ID 354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 354,
        GIR_Done,
      // Label 715: @22085
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(22100), // Rule ID 355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 355,
        GIR_Done,
      // Label 716: @22100
      GIM_Reject,
    // Label 713: @22101
    GIM_Reject,
    // Label 689: @22102
    GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(22135), // Rule ID 336 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 336,
      GIR_Done,
    // Label 717: @22135
    GIM_Reject,
    // Label 690: @22136
    GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(22250),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(22204), // Rule ID 52008 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52008,
        GIR_EraseRootFromParent_Done,
      // Label 719: @22204
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(22249), // Rule ID 52009 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52009,
        GIR_EraseRootFromParent_Done,
      // Label 720: @22249
      GIM_Reject,
    // Label 718: @22250
    GIM_Reject,
    // Label 691: @22251
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(22365),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(22319), // Rule ID 52020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52020,
        GIR_EraseRootFromParent_Done,
      // Label 722: @22319
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(22364), // Rule ID 52021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52021,
        GIR_EraseRootFromParent_Done,
      // Label 723: @22364
      GIM_Reject,
    // Label 721: @22365
    GIM_Reject,
    // Label 692: @22366
    GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(22480),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(22434), // Rule ID 52028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52028,
        GIR_EraseRootFromParent_Done,
      // Label 725: @22434
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(22479), // Rule ID 52029 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52029,
        GIR_EraseRootFromParent_Done,
      // Label 726: @22479
      GIM_Reject,
    // Label 724: @22480
    GIM_Reject,
    // Label 693: @22481
    GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(22595),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(22549), // Rule ID 52044 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52044,
        GIR_EraseRootFromParent_Done,
      // Label 728: @22549
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(22594), // Rule ID 52045 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52045,
        GIR_EraseRootFromParent_Done,
      // Label 729: @22594
      GIM_Reject,
    // Label 727: @22595
    GIM_Reject,
    // Label 694: @22596
    GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(22710),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(22664), // Rule ID 52012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52012,
        GIR_EraseRootFromParent_Done,
      // Label 731: @22664
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(22709), // Rule ID 52013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52013,
        GIR_EraseRootFromParent_Done,
      // Label 732: @22709
      GIM_Reject,
    // Label 730: @22710
    GIM_Reject,
    // Label 695: @22711
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(22825),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(22779), // Rule ID 52024 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52024,
        GIR_EraseRootFromParent_Done,
      // Label 734: @22779
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(22824), // Rule ID 52025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52025,
        GIR_EraseRootFromParent_Done,
      // Label 735: @22824
      GIM_Reject,
    // Label 733: @22825
    GIM_Reject,
    // Label 696: @22826
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(22940),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(22894), // Rule ID 52040 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52040,
        GIR_EraseRootFromParent_Done,
      // Label 737: @22894
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(22939), // Rule ID 52041 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52041,
        GIR_EraseRootFromParent_Done,
      // Label 738: @22939
      GIM_Reject,
    // Label 736: @22940
    GIM_Reject,
    // Label 697: @22941
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(23055),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(23009), // Rule ID 52084 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52084,
        GIR_EraseRootFromParent_Done,
      // Label 740: @23009
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(23054), // Rule ID 52085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52085,
        GIR_EraseRootFromParent_Done,
      // Label 741: @23054
      GIM_Reject,
    // Label 739: @23055
    GIM_Reject,
    // Label 698: @23056
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(23170),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(23124), // Rule ID 52016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52016,
        GIR_EraseRootFromParent_Done,
      // Label 743: @23124
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(23169), // Rule ID 52017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52017,
        GIR_EraseRootFromParent_Done,
      // Label 744: @23169
      GIM_Reject,
    // Label 742: @23170
    GIM_Reject,
    // Label 699: @23171
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(23285),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(23239), // Rule ID 52036 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52036,
        GIR_EraseRootFromParent_Done,
      // Label 746: @23239
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(23284), // Rule ID 52037 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52037,
        GIR_EraseRootFromParent_Done,
      // Label 747: @23284
      GIM_Reject,
    // Label 745: @23285
    GIM_Reject,
    // Label 700: @23286
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(23400),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(23354), // Rule ID 52072 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52072,
        GIR_EraseRootFromParent_Done,
      // Label 749: @23354
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(23399), // Rule ID 52073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52073,
        GIR_EraseRootFromParent_Done,
      // Label 750: @23399
      GIM_Reject,
    // Label 748: @23400
    GIM_Reject,
    // Label 701: @23401
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(23515),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(23469), // Rule ID 52088 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52088,
        GIR_EraseRootFromParent_Done,
      // Label 752: @23469
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(23514), // Rule ID 52089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52089,
        GIR_EraseRootFromParent_Done,
      // Label 753: @23514
      GIM_Reject,
    // Label 751: @23515
    GIM_Reject,
    // Label 702: @23516
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(23630),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(23584), // Rule ID 52032 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52032,
        GIR_EraseRootFromParent_Done,
      // Label 755: @23584
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(23629), // Rule ID 52033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52033,
        GIR_EraseRootFromParent_Done,
      // Label 756: @23629
      GIM_Reject,
    // Label 754: @23630
    GIM_Reject,
    // Label 703: @23631
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(23745),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(23699), // Rule ID 52060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52060,
        GIR_EraseRootFromParent_Done,
      // Label 758: @23699
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(23744), // Rule ID 52061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52061,
        GIR_EraseRootFromParent_Done,
      // Label 759: @23744
      GIM_Reject,
    // Label 757: @23745
    GIM_Reject,
    // Label 704: @23746
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(23860),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(23814), // Rule ID 52076 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52076,
        GIR_EraseRootFromParent_Done,
      // Label 761: @23814
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(23859), // Rule ID 52077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52077,
        GIR_EraseRootFromParent_Done,
      // Label 762: @23859
      GIM_Reject,
    // Label 760: @23860
    GIM_Reject,
    // Label 705: @23861
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(23975),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(23929), // Rule ID 52092 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52092,
        GIR_EraseRootFromParent_Done,
      // Label 764: @23929
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(23974), // Rule ID 52093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52093,
        GIR_EraseRootFromParent_Done,
      // Label 765: @23974
      GIM_Reject,
    // Label 763: @23975
    GIM_Reject,
    // Label 706: @23976
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(24090),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(24044), // Rule ID 52048 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52048,
        GIR_EraseRootFromParent_Done,
      // Label 767: @24044
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(24089), // Rule ID 52049 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52049,
        GIR_EraseRootFromParent_Done,
      // Label 768: @24089
      GIM_Reject,
    // Label 766: @24090
    GIM_Reject,
    // Label 707: @24091
    GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(24205),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(24159), // Rule ID 52064 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52064,
        GIR_EraseRootFromParent_Done,
      // Label 770: @24159
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(24204), // Rule ID 52065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52065,
        GIR_EraseRootFromParent_Done,
      // Label 771: @24204
      GIM_Reject,
    // Label 769: @24205
    GIM_Reject,
    // Label 708: @24206
    GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(24320),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(24274), // Rule ID 52080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52080,
        GIR_EraseRootFromParent_Done,
      // Label 773: @24274
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(24319), // Rule ID 52081 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52081,
        GIR_EraseRootFromParent_Done,
      // Label 774: @24319
      GIM_Reject,
    // Label 772: @24320
    GIM_Reject,
    // Label 709: @24321
    GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(24435),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(24389), // Rule ID 52052 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52052,
        GIR_EraseRootFromParent_Done,
      // Label 776: @24389
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(24434), // Rule ID 52053 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52053,
        GIR_EraseRootFromParent_Done,
      // Label 777: @24434
      GIM_Reject,
    // Label 775: @24435
    GIM_Reject,
    // Label 710: @24436
    GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(24550),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(24504), // Rule ID 52068 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52068,
        GIR_EraseRootFromParent_Done,
      // Label 779: @24504
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(24549), // Rule ID 52069 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52069,
        GIR_EraseRootFromParent_Done,
      // Label 780: @24549
      GIM_Reject,
    // Label 778: @24550
    GIM_Reject,
    // Label 711: @24551
    GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(24665),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(24619), // Rule ID 52056 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52056,
        GIR_EraseRootFromParent_Done,
      // Label 782: @24619
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(24664), // Rule ID 52057 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52057,
        GIR_EraseRootFromParent_Done,
      // Label 783: @24664
      GIM_Reject,
    // Label 781: @24665
    GIM_Reject,
    // Label 712: @24666
    GIM_Reject,
    // Label 6: @24667
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 808*/ GIMT_Encode4(27436),
    /*GILLT_s32*//*Label 784*/ GIMT_Encode4(24802),
    /*GILLT_s64*//*Label 785*/ GIMT_Encode4(24872), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 786*/ GIMT_Encode4(24906),
    /*GILLT_nxv1s16*//*Label 787*/ GIMT_Encode4(25021),
    /*GILLT_nxv1s32*//*Label 788*/ GIMT_Encode4(25136),
    /*GILLT_nxv1s64*//*Label 789*/ GIMT_Encode4(25251), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 790*/ GIMT_Encode4(25366),
    /*GILLT_nxv2s16*//*Label 791*/ GIMT_Encode4(25481),
    /*GILLT_nxv2s32*//*Label 792*/ GIMT_Encode4(25596),
    /*GILLT_nxv2s64*//*Label 793*/ GIMT_Encode4(25711), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 794*/ GIMT_Encode4(25826),
    /*GILLT_nxv4s16*//*Label 795*/ GIMT_Encode4(25941),
    /*GILLT_nxv4s32*//*Label 796*/ GIMT_Encode4(26056),
    /*GILLT_nxv4s64*//*Label 797*/ GIMT_Encode4(26171), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 798*/ GIMT_Encode4(26286),
    /*GILLT_nxv8s16*//*Label 799*/ GIMT_Encode4(26401),
    /*GILLT_nxv8s32*//*Label 800*/ GIMT_Encode4(26516),
    /*GILLT_nxv8s64*//*Label 801*/ GIMT_Encode4(26631), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 802*/ GIMT_Encode4(26746),
    /*GILLT_nxv16s16*//*Label 803*/ GIMT_Encode4(26861),
    /*GILLT_nxv16s32*//*Label 804*/ GIMT_Encode4(26976), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 805*/ GIMT_Encode4(27091),
    /*GILLT_nxv32s16*//*Label 806*/ GIMT_Encode4(27206), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 807*/ GIMT_Encode4(27321),
    // Label 784: @24802
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(24871),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(24840), // Rule ID 339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 339,
        GIR_Done,
      // Label 810: @24840
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(24855), // Rule ID 356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 356,
        GIR_Done,
      // Label 811: @24855
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(24870), // Rule ID 357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 357,
        GIR_Done,
      // Label 812: @24870
      GIM_Reject,
    // Label 809: @24871
    GIM_Reject,
    // Label 785: @24872
    GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(24905), // Rule ID 338 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 338,
      GIR_Done,
    // Label 813: @24905
    GIM_Reject,
    // Label 786: @24906
    GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(25020),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(24974), // Rule ID 51920 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51920,
        GIR_EraseRootFromParent_Done,
      // Label 815: @24974
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(25019), // Rule ID 51921 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51921,
        GIR_EraseRootFromParent_Done,
      // Label 816: @25019
      GIM_Reject,
    // Label 814: @25020
    GIM_Reject,
    // Label 787: @25021
    GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(25135),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(25089), // Rule ID 51932 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51932,
        GIR_EraseRootFromParent_Done,
      // Label 818: @25089
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(25134), // Rule ID 51933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51933,
        GIR_EraseRootFromParent_Done,
      // Label 819: @25134
      GIM_Reject,
    // Label 817: @25135
    GIM_Reject,
    // Label 788: @25136
    GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(25250),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(25204), // Rule ID 51940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51940,
        GIR_EraseRootFromParent_Done,
      // Label 821: @25204
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(25249), // Rule ID 51941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51941,
        GIR_EraseRootFromParent_Done,
      // Label 822: @25249
      GIM_Reject,
    // Label 820: @25250
    GIM_Reject,
    // Label 789: @25251
    GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(25365),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(25319), // Rule ID 51956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51956,
        GIR_EraseRootFromParent_Done,
      // Label 824: @25319
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(25364), // Rule ID 51957 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51957,
        GIR_EraseRootFromParent_Done,
      // Label 825: @25364
      GIM_Reject,
    // Label 823: @25365
    GIM_Reject,
    // Label 790: @25366
    GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(25480),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(25434), // Rule ID 51924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51924,
        GIR_EraseRootFromParent_Done,
      // Label 827: @25434
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(25479), // Rule ID 51925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51925,
        GIR_EraseRootFromParent_Done,
      // Label 828: @25479
      GIM_Reject,
    // Label 826: @25480
    GIM_Reject,
    // Label 791: @25481
    GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(25595),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(25549), // Rule ID 51936 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51936,
        GIR_EraseRootFromParent_Done,
      // Label 830: @25549
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(25594), // Rule ID 51937 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51937,
        GIR_EraseRootFromParent_Done,
      // Label 831: @25594
      GIM_Reject,
    // Label 829: @25595
    GIM_Reject,
    // Label 792: @25596
    GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(25710),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(25664), // Rule ID 51952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51952,
        GIR_EraseRootFromParent_Done,
      // Label 833: @25664
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(25709), // Rule ID 51953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51953,
        GIR_EraseRootFromParent_Done,
      // Label 834: @25709
      GIM_Reject,
    // Label 832: @25710
    GIM_Reject,
    // Label 793: @25711
    GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(25825),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(25779), // Rule ID 51996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51996,
        GIR_EraseRootFromParent_Done,
      // Label 836: @25779
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(25824), // Rule ID 51997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51997,
        GIR_EraseRootFromParent_Done,
      // Label 837: @25824
      GIM_Reject,
    // Label 835: @25825
    GIM_Reject,
    // Label 794: @25826
    GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(25940),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(25894), // Rule ID 51928 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51928,
        GIR_EraseRootFromParent_Done,
      // Label 839: @25894
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(25939), // Rule ID 51929 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51929,
        GIR_EraseRootFromParent_Done,
      // Label 840: @25939
      GIM_Reject,
    // Label 838: @25940
    GIM_Reject,
    // Label 795: @25941
    GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(26055),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(26009), // Rule ID 51948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51948,
        GIR_EraseRootFromParent_Done,
      // Label 842: @26009
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(26054), // Rule ID 51949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51949,
        GIR_EraseRootFromParent_Done,
      // Label 843: @26054
      GIM_Reject,
    // Label 841: @26055
    GIM_Reject,
    // Label 796: @26056
    GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(26170),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(26124), // Rule ID 51984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51984,
        GIR_EraseRootFromParent_Done,
      // Label 845: @26124
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(26169), // Rule ID 51985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51985,
        GIR_EraseRootFromParent_Done,
      // Label 846: @26169
      GIM_Reject,
    // Label 844: @26170
    GIM_Reject,
    // Label 797: @26171
    GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(26285),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(26239), // Rule ID 52000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52000,
        GIR_EraseRootFromParent_Done,
      // Label 848: @26239
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(26284), // Rule ID 52001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52001,
        GIR_EraseRootFromParent_Done,
      // Label 849: @26284
      GIM_Reject,
    // Label 847: @26285
    GIM_Reject,
    // Label 798: @26286
    GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(26400),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(26354), // Rule ID 51944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51944,
        GIR_EraseRootFromParent_Done,
      // Label 851: @26354
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(26399), // Rule ID 51945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51945,
        GIR_EraseRootFromParent_Done,
      // Label 852: @26399
      GIM_Reject,
    // Label 850: @26400
    GIM_Reject,
    // Label 799: @26401
    GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(26515),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(26469), // Rule ID 51972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51972,
        GIR_EraseRootFromParent_Done,
      // Label 854: @26469
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(26514), // Rule ID 51973 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51973,
        GIR_EraseRootFromParent_Done,
      // Label 855: @26514
      GIM_Reject,
    // Label 853: @26515
    GIM_Reject,
    // Label 800: @26516
    GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(26630),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(26584), // Rule ID 51988 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51988,
        GIR_EraseRootFromParent_Done,
      // Label 857: @26584
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(26629), // Rule ID 51989 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51989,
        GIR_EraseRootFromParent_Done,
      // Label 858: @26629
      GIM_Reject,
    // Label 856: @26630
    GIM_Reject,
    // Label 801: @26631
    GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(26745),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(26699), // Rule ID 52004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52004,
        GIR_EraseRootFromParent_Done,
      // Label 860: @26699
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(26744), // Rule ID 52005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52005,
        GIR_EraseRootFromParent_Done,
      // Label 861: @26744
      GIM_Reject,
    // Label 859: @26745
    GIM_Reject,
    // Label 802: @26746
    GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(26860),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(26814), // Rule ID 51960 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51960,
        GIR_EraseRootFromParent_Done,
      // Label 863: @26814
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(26859), // Rule ID 51961 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51961,
        GIR_EraseRootFromParent_Done,
      // Label 864: @26859
      GIM_Reject,
    // Label 862: @26860
    GIM_Reject,
    // Label 803: @26861
    GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(26975),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(26929), // Rule ID 51976 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51976,
        GIR_EraseRootFromParent_Done,
      // Label 866: @26929
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(26974), // Rule ID 51977 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51977,
        GIR_EraseRootFromParent_Done,
      // Label 867: @26974
      GIM_Reject,
    // Label 865: @26975
    GIM_Reject,
    // Label 804: @26976
    GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(27090),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(27044), // Rule ID 51992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51992,
        GIR_EraseRootFromParent_Done,
      // Label 869: @27044
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(27089), // Rule ID 51993 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51993,
        GIR_EraseRootFromParent_Done,
      // Label 870: @27089
      GIM_Reject,
    // Label 868: @27090
    GIM_Reject,
    // Label 805: @27091
    GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(27205),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(27159), // Rule ID 51964 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51964,
        GIR_EraseRootFromParent_Done,
      // Label 872: @27159
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(27204), // Rule ID 51965 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51965,
        GIR_EraseRootFromParent_Done,
      // Label 873: @27204
      GIM_Reject,
    // Label 871: @27205
    GIM_Reject,
    // Label 806: @27206
    GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(27320),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(27274), // Rule ID 51980 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51980,
        GIR_EraseRootFromParent_Done,
      // Label 875: @27274
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(27319), // Rule ID 51981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51981,
        GIR_EraseRootFromParent_Done,
      // Label 876: @27319
      GIM_Reject,
    // Label 874: @27320
    GIM_Reject,
    // Label 807: @27321
    GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(27435),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(27389), // Rule ID 51968 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51968,
        GIR_EraseRootFromParent_Done,
      // Label 878: @27389
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(27434), // Rule ID 51969 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51969,
        GIR_EraseRootFromParent_Done,
      // Label 879: @27434
      GIM_Reject,
    // Label 877: @27435
    GIM_Reject,
    // Label 808: @27436
    GIM_Reject,
    // Label 7: @27437
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 911*/ GIMT_Encode4(36982),
    /*GILLT_s32*//*Label 880*/ GIMT_Encode4(27572),
    /*GILLT_s64*//*Label 881*/ GIMT_Encode4(29228),
    /*GILLT_nxv1s1*//*Label 882*/ GIMT_Encode4(30175),
    /*GILLT_nxv1s8*//*Label 883*/ GIMT_Encode4(30786),
    /*GILLT_nxv1s16*//*Label 884*/ GIMT_Encode4(30901),
    /*GILLT_nxv1s32*//*Label 885*/ GIMT_Encode4(31016),
    /*GILLT_nxv1s64*//*Label 886*/ GIMT_Encode4(31131),
    /*GILLT_nxv2s1*//*Label 887*/ GIMT_Encode4(31246),
    /*GILLT_nxv2s8*//*Label 888*/ GIMT_Encode4(31857),
    /*GILLT_nxv2s16*//*Label 889*/ GIMT_Encode4(31972),
    /*GILLT_nxv2s32*//*Label 890*/ GIMT_Encode4(32087),
    /*GILLT_nxv2s64*//*Label 891*/ GIMT_Encode4(32202),
    /*GILLT_nxv4s1*//*Label 892*/ GIMT_Encode4(32317),
    /*GILLT_nxv4s8*//*Label 893*/ GIMT_Encode4(32928),
    /*GILLT_nxv4s16*//*Label 894*/ GIMT_Encode4(33043),
    /*GILLT_nxv4s32*//*Label 895*/ GIMT_Encode4(33158),
    /*GILLT_nxv4s64*//*Label 896*/ GIMT_Encode4(33273),
    /*GILLT_nxv8s1*//*Label 897*/ GIMT_Encode4(33388),
    /*GILLT_nxv8s8*//*Label 898*/ GIMT_Encode4(33999),
    /*GILLT_nxv8s16*//*Label 899*/ GIMT_Encode4(34114),
    /*GILLT_nxv8s32*//*Label 900*/ GIMT_Encode4(34229),
    /*GILLT_nxv8s64*//*Label 901*/ GIMT_Encode4(34344),
    /*GILLT_nxv16s1*//*Label 902*/ GIMT_Encode4(34459),
    /*GILLT_nxv16s8*//*Label 903*/ GIMT_Encode4(35070),
    /*GILLT_nxv16s16*//*Label 904*/ GIMT_Encode4(35185),
    /*GILLT_nxv16s32*//*Label 905*/ GIMT_Encode4(35300),
    /*GILLT_nxv32s1*//*Label 906*/ GIMT_Encode4(35415),
    /*GILLT_nxv32s8*//*Label 907*/ GIMT_Encode4(36026),
    /*GILLT_nxv32s16*//*Label 908*/ GIMT_Encode4(36141),
    /*GILLT_nxv64s1*//*Label 909*/ GIMT_Encode4(36256),
    /*GILLT_nxv64s8*//*Label 910*/ GIMT_Encode4(36867),
    // Label 880: @27572
    GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(29227),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(27662), // Rule ID 2621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2621,
        GIR_EraseRootFromParent_Done,
      // Label 913: @27662
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(27737), // Rule ID 2848 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2848,
        GIR_EraseRootFromParent_Done,
      // Label 914: @27737
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(27812), // Rule ID 65200 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65200,
        GIR_EraseRootFromParent_Done,
      // Label 915: @27812
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(27887), // Rule ID 65304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65304,
        GIR_EraseRootFromParent_Done,
      // Label 916: @27887
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(27948), // Rule ID 2641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2641,
        GIR_EraseRootFromParent_Done,
      // Label 917: @27948
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(28009), // Rule ID 2856 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2856,
        GIR_EraseRootFromParent_Done,
      // Label 918: @28009
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(28070), // Rule ID 2857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2857,
        GIR_EraseRootFromParent_Done,
      // Label 919: @28070
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(28131), // Rule ID 63037 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (TH_TST:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63037,
        GIR_EraseRootFromParent_Done,
      // Label 920: @28131
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(28189), // Rule ID 2629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2629,
        GIR_EraseRootFromParent_Done,
      // Label 921: @28189
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(28247), // Rule ID 2852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2852,
        GIR_EraseRootFromParent_Done,
      // Label 922: @28247
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(28299), // Rule ID 2623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2623,
        GIR_EraseRootFromParent_Done,
      // Label 923: @28299
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(28351), // Rule ID 2849 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2849,
        GIR_EraseRootFromParent_Done,
      // Label 924: @28351
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(28403), // Rule ID 65192 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65192,
        GIR_EraseRootFromParent_Done,
      // Label 925: @28403
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(28455), // Rule ID 65275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65275,
        GIR_EraseRootFromParent_Done,
      // Label 926: @28455
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(28507), // Rule ID 65276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65276,
        GIR_EraseRootFromParent_Done,
      // Label 927: @28507
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(28559), // Rule ID 65202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65202,
        GIR_EraseRootFromParent_Done,
      // Label 928: @28559
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(28611), // Rule ID 65305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65305,
        GIR_EraseRootFromParent_Done,
      // Label 929: @28611
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(28663), // Rule ID 2603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2603,
        GIR_EraseRootFromParent_Done,
      // Label 930: @28663
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(28715), // Rule ID 2807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2807,
        GIR_EraseRootFromParent_Done,
      // Label 931: @28715
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(28767), // Rule ID 2808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2808,
        GIR_EraseRootFromParent_Done,
      // Label 932: @28767
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(28799), // Rule ID 64992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 65535:{ *:[i32] })  =>  (CV_EXTHZ:{ *:[i32] } GPR:{ *:[i32] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTHZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64992,
        GIR_EraseRootFromParent_Done,
      // Label 933: @28799
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(28831), // Rule ID 2701 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2701,
        GIR_EraseRootFromParent_Done,
      // Label 934: @28831
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(28863), // Rule ID 2702 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2702,
        GIR_EraseRootFromParent_Done,
      // Label 935: @28863
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(28901), // Rule ID 2704 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2704,
        GIR_EraseRootFromParent_Done,
      // Label 936: @28901
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(28939), // Rule ID 2705 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2705,
        GIR_EraseRootFromParent_Done,
      // Label 937: @28939
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(28971), // Rule ID 2803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV64:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2803,
        GIR_EraseRootFromParent_Done,
      // Label 938: @28971
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(29003), // Rule ID 2804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV64:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2804,
        GIR_EraseRootFromParent_Done,
      // Label 939: @29003
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(29041), // Rule ID 2805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACKW:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2805,
        GIR_EraseRootFromParent_Done,
      // Label 940: @29041
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(29079), // Rule ID 2806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACKW:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2806,
        GIR_EraseRootFromParent_Done,
      // Label 941: @29079
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(29117), // Rule ID 79 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 79,
        GIR_EraseRootFromParent_Done,
      // Label 942: @29117
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(29157), // Rule ID 311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12i32>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (as_i64imm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 311,
        GIR_EraseRootFromParent_Done,
      // Label 943: @29157
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(29180), // Rule ID 77 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 77,
        GIR_Done,
      // Label 944: @29180
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(29203), // Rule ID 301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 301,
        GIR_Done,
      // Label 945: @29203
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(29226), // Rule ID 302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 302,
        GIR_Done,
      // Label 946: @29226
      GIM_Reject,
    // Label 912: @29227
    GIM_Reject,
    // Label 881: @29228
    GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(30174),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(29318), // Rule ID 2620 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2620,
        GIR_EraseRootFromParent_Done,
      // Label 948: @29318
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(29393), // Rule ID 65199 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65199,
        GIR_EraseRootFromParent_Done,
      // Label 949: @29393
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(29463), // Rule ID 2853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2))), 1:{ *:[i64] })  =>  (BEXT:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2853,
        GIR_EraseRootFromParent_Done,
      // Label 950: @29463
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(29524), // Rule ID 2640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2640,
        GIR_EraseRootFromParent_Done,
      // Label 951: @29524
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(29585), // Rule ID 63036 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (TH_TST:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63036,
        GIR_EraseRootFromParent_Done,
      // Label 952: @29585
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(29643), // Rule ID 2628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), 1:{ *:[i64] })  =>  (BEXT:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2628,
        GIR_EraseRootFromParent_Done,
      // Label 953: @29643
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(29695), // Rule ID 2622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2622,
        GIR_EraseRootFromParent_Done,
      // Label 954: @29695
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(29747), // Rule ID 65191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65191,
        GIR_EraseRootFromParent_Done,
      // Label 955: @29747
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(29799), // Rule ID 65201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65201,
        GIR_EraseRootFromParent_Done,
      // Label 956: @29799
      GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(29851), // Rule ID 2602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2602,
        GIR_EraseRootFromParent_Done,
      // Label 957: @29851
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(29883), // Rule ID 64991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 65535:{ *:[i64] })  =>  (CV_EXTHZ:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTHZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64991,
        GIR_EraseRootFromParent_Done,
      // Label 958: @29883
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(29940), // Rule ID 243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 243,
        GIR_EraseRootFromParent_Done,
      // Label 959: @29940
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(29972), // Rule ID 2703 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2703,
        GIR_EraseRootFromParent_Done,
      // Label 960: @29972
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(30010), // Rule ID 2706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (PACKW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2706,
        GIR_EraseRootFromParent_Done,
      // Label 961: @30010
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(30048), // Rule ID 2749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2749,
        GIR_EraseRootFromParent_Done,
      // Label 962: @30048
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(30086), // Rule ID 78 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 78,
        GIR_EraseRootFromParent_Done,
      // Label 963: @30086
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(30150), // Rule ID 2746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_Shifted32OnesMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>><<X:TrailingZeros>>:$mask)  =>  (SLLI_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask)), (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SLLI_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2746,
        GIR_EraseRootFromParent_Done,
      // Label 964: @30150
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(30173), // Rule ID 76 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 76,
        GIR_Done,
      // Label 965: @30173
      GIM_Reject,
    // Label 947: @30174
    GIM_Reject,
    // Label 882: @30175
    GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(30785),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(30256), // Rule ID 71268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv1i1] }:$rs2), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71268,
        GIR_EraseRootFromParent_Done,
      // Label 967: @30256
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(30322), // Rule ID 71269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv1i1] }:$rs2), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71269,
        GIR_EraseRootFromParent_Done,
      // Label 968: @30322
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(30388), // Rule ID 71266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71266,
        GIR_EraseRootFromParent_Done,
      // Label 969: @30388
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(30454), // Rule ID 71267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71267,
        GIR_EraseRootFromParent_Done,
      // Label 970: @30454
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(30520), // Rule ID 71264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv1i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71264,
        GIR_EraseRootFromParent_Done,
      // Label 971: @30520
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(30586), // Rule ID 71265 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv1i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71265,
        GIR_EraseRootFromParent_Done,
      // Label 972: @30586
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(30652), // Rule ID 53796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53796,
        GIR_EraseRootFromParent_Done,
      // Label 973: @30652
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(30718), // Rule ID 53797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53797,
        GIR_EraseRootFromParent_Done,
      // Label 974: @30718
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(30751), // Rule ID 53784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53784,
        GIR_EraseRootFromParent_Done,
      // Label 975: @30751
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(30784), // Rule ID 53785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53785,
        GIR_EraseRootFromParent_Done,
      // Label 976: @30784
      GIM_Reject,
    // Label 966: @30785
    GIM_Reject,
    // Label 883: @30786
    GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(30900),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(30854), // Rule ID 48280 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48280,
        GIR_EraseRootFromParent_Done,
      // Label 978: @30854
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(30899), // Rule ID 48281 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48281,
        GIR_EraseRootFromParent_Done,
      // Label 979: @30899
      GIM_Reject,
    // Label 977: @30900
    GIM_Reject,
    // Label 884: @30901
    GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(31015),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(30969), // Rule ID 48292 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48292,
        GIR_EraseRootFromParent_Done,
      // Label 981: @30969
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(31014), // Rule ID 48293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48293,
        GIR_EraseRootFromParent_Done,
      // Label 982: @31014
      GIM_Reject,
    // Label 980: @31015
    GIM_Reject,
    // Label 885: @31016
    GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(31130),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(31084), // Rule ID 48300 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48300,
        GIR_EraseRootFromParent_Done,
      // Label 984: @31084
      GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(31129), // Rule ID 48301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48301,
        GIR_EraseRootFromParent_Done,
      // Label 985: @31129
      GIM_Reject,
    // Label 983: @31130
    GIM_Reject,
    // Label 886: @31131
    GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(31245),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(31199), // Rule ID 48316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48316,
        GIR_EraseRootFromParent_Done,
      // Label 987: @31199
      GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(31244), // Rule ID 48317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48317,
        GIR_EraseRootFromParent_Done,
      // Label 988: @31244
      GIM_Reject,
    // Label 986: @31245
    GIM_Reject,
    // Label 887: @31246
    GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(31856),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(31327), // Rule ID 71296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv2i1] }:$rs2), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71296,
        GIR_EraseRootFromParent_Done,
      // Label 990: @31327
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(31393), // Rule ID 71297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv2i1] }:$rs2), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71297,
        GIR_EraseRootFromParent_Done,
      // Label 991: @31393
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(31459), // Rule ID 71294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71294,
        GIR_EraseRootFromParent_Done,
      // Label 992: @31459
      GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(31525), // Rule ID 71295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71295,
        GIR_EraseRootFromParent_Done,
      // Label 993: @31525
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(31591), // Rule ID 71292 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv2i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71292,
        GIR_EraseRootFromParent_Done,
      // Label 994: @31591
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(31657), // Rule ID 71293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv2i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71293,
        GIR_EraseRootFromParent_Done,
      // Label 995: @31657
      GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(31723), // Rule ID 53814 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53814,
        GIR_EraseRootFromParent_Done,
      // Label 996: @31723
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(31789), // Rule ID 53815 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53815,
        GIR_EraseRootFromParent_Done,
      // Label 997: @31789
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(31822), // Rule ID 53802 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53802,
        GIR_EraseRootFromParent_Done,
      // Label 998: @31822
      GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(31855), // Rule ID 53803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53803,
        GIR_EraseRootFromParent_Done,
      // Label 999: @31855
      GIM_Reject,
    // Label 989: @31856
    GIM_Reject,
    // Label 888: @31857
    GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(31971),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(31925), // Rule ID 48284 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48284,
        GIR_EraseRootFromParent_Done,
      // Label 1001: @31925
      GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(31970), // Rule ID 48285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48285,
        GIR_EraseRootFromParent_Done,
      // Label 1002: @31970
      GIM_Reject,
    // Label 1000: @31971
    GIM_Reject,
    // Label 889: @31972
    GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(32086),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(32040), // Rule ID 48296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48296,
        GIR_EraseRootFromParent_Done,
      // Label 1004: @32040
      GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(32085), // Rule ID 48297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48297,
        GIR_EraseRootFromParent_Done,
      // Label 1005: @32085
      GIM_Reject,
    // Label 1003: @32086
    GIM_Reject,
    // Label 890: @32087
    GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(32201),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(32155), // Rule ID 48312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48312,
        GIR_EraseRootFromParent_Done,
      // Label 1007: @32155
      GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(32200), // Rule ID 48313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48313,
        GIR_EraseRootFromParent_Done,
      // Label 1008: @32200
      GIM_Reject,
    // Label 1006: @32201
    GIM_Reject,
    // Label 891: @32202
    GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(32316),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(32270), // Rule ID 48356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48356,
        GIR_EraseRootFromParent_Done,
      // Label 1010: @32270
      GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(32315), // Rule ID 48357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48357,
        GIR_EraseRootFromParent_Done,
      // Label 1011: @32315
      GIM_Reject,
    // Label 1009: @32316
    GIM_Reject,
    // Label 892: @32317
    GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(32927),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(32398), // Rule ID 71324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv4i1] }:$rs2), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71324,
        GIR_EraseRootFromParent_Done,
      // Label 1013: @32398
      GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(32464), // Rule ID 71325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv4i1] }:$rs2), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71325,
        GIR_EraseRootFromParent_Done,
      // Label 1014: @32464
      GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(32530), // Rule ID 71322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71322,
        GIR_EraseRootFromParent_Done,
      // Label 1015: @32530
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(32596), // Rule ID 71323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71323,
        GIR_EraseRootFromParent_Done,
      // Label 1016: @32596
      GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(32662), // Rule ID 71320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv4i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71320,
        GIR_EraseRootFromParent_Done,
      // Label 1017: @32662
      GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(32728), // Rule ID 71321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv4i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71321,
        GIR_EraseRootFromParent_Done,
      // Label 1018: @32728
      GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(32794), // Rule ID 53832 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53832,
        GIR_EraseRootFromParent_Done,
      // Label 1019: @32794
      GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(32860), // Rule ID 53833 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53833,
        GIR_EraseRootFromParent_Done,
      // Label 1020: @32860
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(32893), // Rule ID 53820 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53820,
        GIR_EraseRootFromParent_Done,
      // Label 1021: @32893
      GIM_Try, /*On fail goto*//*Label 1022*/ GIMT_Encode4(32926), // Rule ID 53821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53821,
        GIR_EraseRootFromParent_Done,
      // Label 1022: @32926
      GIM_Reject,
    // Label 1012: @32927
    GIM_Reject,
    // Label 893: @32928
    GIM_Try, /*On fail goto*//*Label 1023*/ GIMT_Encode4(33042),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1024*/ GIMT_Encode4(32996), // Rule ID 48288 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48288,
        GIR_EraseRootFromParent_Done,
      // Label 1024: @32996
      GIM_Try, /*On fail goto*//*Label 1025*/ GIMT_Encode4(33041), // Rule ID 48289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48289,
        GIR_EraseRootFromParent_Done,
      // Label 1025: @33041
      GIM_Reject,
    // Label 1023: @33042
    GIM_Reject,
    // Label 894: @33043
    GIM_Try, /*On fail goto*//*Label 1026*/ GIMT_Encode4(33157),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1027*/ GIMT_Encode4(33111), // Rule ID 48308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48308,
        GIR_EraseRootFromParent_Done,
      // Label 1027: @33111
      GIM_Try, /*On fail goto*//*Label 1028*/ GIMT_Encode4(33156), // Rule ID 48309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48309,
        GIR_EraseRootFromParent_Done,
      // Label 1028: @33156
      GIM_Reject,
    // Label 1026: @33157
    GIM_Reject,
    // Label 895: @33158
    GIM_Try, /*On fail goto*//*Label 1029*/ GIMT_Encode4(33272),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1030*/ GIMT_Encode4(33226), // Rule ID 48344 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48344,
        GIR_EraseRootFromParent_Done,
      // Label 1030: @33226
      GIM_Try, /*On fail goto*//*Label 1031*/ GIMT_Encode4(33271), // Rule ID 48345 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48345,
        GIR_EraseRootFromParent_Done,
      // Label 1031: @33271
      GIM_Reject,
    // Label 1029: @33272
    GIM_Reject,
    // Label 896: @33273
    GIM_Try, /*On fail goto*//*Label 1032*/ GIMT_Encode4(33387),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1033*/ GIMT_Encode4(33341), // Rule ID 48360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48360,
        GIR_EraseRootFromParent_Done,
      // Label 1033: @33341
      GIM_Try, /*On fail goto*//*Label 1034*/ GIMT_Encode4(33386), // Rule ID 48361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48361,
        GIR_EraseRootFromParent_Done,
      // Label 1034: @33386
      GIM_Reject,
    // Label 1032: @33387
    GIM_Reject,
    // Label 897: @33388
    GIM_Try, /*On fail goto*//*Label 1035*/ GIMT_Encode4(33998),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1036*/ GIMT_Encode4(33469), // Rule ID 71352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv8i1] }:$rs2), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71352,
        GIR_EraseRootFromParent_Done,
      // Label 1036: @33469
      GIM_Try, /*On fail goto*//*Label 1037*/ GIMT_Encode4(33535), // Rule ID 71353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv8i1] }:$rs2), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71353,
        GIR_EraseRootFromParent_Done,
      // Label 1037: @33535
      GIM_Try, /*On fail goto*//*Label 1038*/ GIMT_Encode4(33601), // Rule ID 71350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71350,
        GIR_EraseRootFromParent_Done,
      // Label 1038: @33601
      GIM_Try, /*On fail goto*//*Label 1039*/ GIMT_Encode4(33667), // Rule ID 71351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71351,
        GIR_EraseRootFromParent_Done,
      // Label 1039: @33667
      GIM_Try, /*On fail goto*//*Label 1040*/ GIMT_Encode4(33733), // Rule ID 71348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv8i1] }:$rs2))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71348,
        GIR_EraseRootFromParent_Done,
      // Label 1040: @33733
      GIM_Try, /*On fail goto*//*Label 1041*/ GIMT_Encode4(33799), // Rule ID 71349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv8i1] }:$rs2))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71349,
        GIR_EraseRootFromParent_Done,
      // Label 1041: @33799
      GIM_Try, /*On fail goto*//*Label 1042*/ GIMT_Encode4(33865), // Rule ID 53850 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53850,
        GIR_EraseRootFromParent_Done,
      // Label 1042: @33865
      GIM_Try, /*On fail goto*//*Label 1043*/ GIMT_Encode4(33931), // Rule ID 53851 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53851,
        GIR_EraseRootFromParent_Done,
      // Label 1043: @33931
      GIM_Try, /*On fail goto*//*Label 1044*/ GIMT_Encode4(33964), // Rule ID 53838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53838,
        GIR_EraseRootFromParent_Done,
      // Label 1044: @33964
      GIM_Try, /*On fail goto*//*Label 1045*/ GIMT_Encode4(33997), // Rule ID 53839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53839,
        GIR_EraseRootFromParent_Done,
      // Label 1045: @33997
      GIM_Reject,
    // Label 1035: @33998
    GIM_Reject,
    // Label 898: @33999
    GIM_Try, /*On fail goto*//*Label 1046*/ GIMT_Encode4(34113),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1047*/ GIMT_Encode4(34067), // Rule ID 48304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48304,
        GIR_EraseRootFromParent_Done,
      // Label 1047: @34067
      GIM_Try, /*On fail goto*//*Label 1048*/ GIMT_Encode4(34112), // Rule ID 48305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48305,
        GIR_EraseRootFromParent_Done,
      // Label 1048: @34112
      GIM_Reject,
    // Label 1046: @34113
    GIM_Reject,
    // Label 899: @34114
    GIM_Try, /*On fail goto*//*Label 1049*/ GIMT_Encode4(34228),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1050*/ GIMT_Encode4(34182), // Rule ID 48332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48332,
        GIR_EraseRootFromParent_Done,
      // Label 1050: @34182
      GIM_Try, /*On fail goto*//*Label 1051*/ GIMT_Encode4(34227), // Rule ID 48333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48333,
        GIR_EraseRootFromParent_Done,
      // Label 1051: @34227
      GIM_Reject,
    // Label 1049: @34228
    GIM_Reject,
    // Label 900: @34229
    GIM_Try, /*On fail goto*//*Label 1052*/ GIMT_Encode4(34343),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1053*/ GIMT_Encode4(34297), // Rule ID 48348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48348,
        GIR_EraseRootFromParent_Done,
      // Label 1053: @34297
      GIM_Try, /*On fail goto*//*Label 1054*/ GIMT_Encode4(34342), // Rule ID 48349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48349,
        GIR_EraseRootFromParent_Done,
      // Label 1054: @34342
      GIM_Reject,
    // Label 1052: @34343
    GIM_Reject,
    // Label 901: @34344
    GIM_Try, /*On fail goto*//*Label 1055*/ GIMT_Encode4(34458),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1056*/ GIMT_Encode4(34412), // Rule ID 48364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48364,
        GIR_EraseRootFromParent_Done,
      // Label 1056: @34412
      GIM_Try, /*On fail goto*//*Label 1057*/ GIMT_Encode4(34457), // Rule ID 48365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48365,
        GIR_EraseRootFromParent_Done,
      // Label 1057: @34457
      GIM_Reject,
    // Label 1055: @34458
    GIM_Reject,
    // Label 902: @34459
    GIM_Try, /*On fail goto*//*Label 1058*/ GIMT_Encode4(35069),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1059*/ GIMT_Encode4(34540), // Rule ID 71380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv16i1] }:$rs2), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71380,
        GIR_EraseRootFromParent_Done,
      // Label 1059: @34540
      GIM_Try, /*On fail goto*//*Label 1060*/ GIMT_Encode4(34606), // Rule ID 71381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv16i1] }:$rs2), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71381,
        GIR_EraseRootFromParent_Done,
      // Label 1060: @34606
      GIM_Try, /*On fail goto*//*Label 1061*/ GIMT_Encode4(34672), // Rule ID 71378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71378,
        GIR_EraseRootFromParent_Done,
      // Label 1061: @34672
      GIM_Try, /*On fail goto*//*Label 1062*/ GIMT_Encode4(34738), // Rule ID 71379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71379,
        GIR_EraseRootFromParent_Done,
      // Label 1062: @34738
      GIM_Try, /*On fail goto*//*Label 1063*/ GIMT_Encode4(34804), // Rule ID 71376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv16i1] }:$rs2))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71376,
        GIR_EraseRootFromParent_Done,
      // Label 1063: @34804
      GIM_Try, /*On fail goto*//*Label 1064*/ GIMT_Encode4(34870), // Rule ID 71377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv16i1] }:$rs2))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71377,
        GIR_EraseRootFromParent_Done,
      // Label 1064: @34870
      GIM_Try, /*On fail goto*//*Label 1065*/ GIMT_Encode4(34936), // Rule ID 53868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53868,
        GIR_EraseRootFromParent_Done,
      // Label 1065: @34936
      GIM_Try, /*On fail goto*//*Label 1066*/ GIMT_Encode4(35002), // Rule ID 53869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53869,
        GIR_EraseRootFromParent_Done,
      // Label 1066: @35002
      GIM_Try, /*On fail goto*//*Label 1067*/ GIMT_Encode4(35035), // Rule ID 53856 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53856,
        GIR_EraseRootFromParent_Done,
      // Label 1067: @35035
      GIM_Try, /*On fail goto*//*Label 1068*/ GIMT_Encode4(35068), // Rule ID 53857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53857,
        GIR_EraseRootFromParent_Done,
      // Label 1068: @35068
      GIM_Reject,
    // Label 1058: @35069
    GIM_Reject,
    // Label 903: @35070
    GIM_Try, /*On fail goto*//*Label 1069*/ GIMT_Encode4(35184),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1070*/ GIMT_Encode4(35138), // Rule ID 48320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48320,
        GIR_EraseRootFromParent_Done,
      // Label 1070: @35138
      GIM_Try, /*On fail goto*//*Label 1071*/ GIMT_Encode4(35183), // Rule ID 48321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48321,
        GIR_EraseRootFromParent_Done,
      // Label 1071: @35183
      GIM_Reject,
    // Label 1069: @35184
    GIM_Reject,
    // Label 904: @35185
    GIM_Try, /*On fail goto*//*Label 1072*/ GIMT_Encode4(35299),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1073*/ GIMT_Encode4(35253), // Rule ID 48336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48336,
        GIR_EraseRootFromParent_Done,
      // Label 1073: @35253
      GIM_Try, /*On fail goto*//*Label 1074*/ GIMT_Encode4(35298), // Rule ID 48337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48337,
        GIR_EraseRootFromParent_Done,
      // Label 1074: @35298
      GIM_Reject,
    // Label 1072: @35299
    GIM_Reject,
    // Label 905: @35300
    GIM_Try, /*On fail goto*//*Label 1075*/ GIMT_Encode4(35414),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1076*/ GIMT_Encode4(35368), // Rule ID 48352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48352,
        GIR_EraseRootFromParent_Done,
      // Label 1076: @35368
      GIM_Try, /*On fail goto*//*Label 1077*/ GIMT_Encode4(35413), // Rule ID 48353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48353,
        GIR_EraseRootFromParent_Done,
      // Label 1077: @35413
      GIM_Reject,
    // Label 1075: @35414
    GIM_Reject,
    // Label 906: @35415
    GIM_Try, /*On fail goto*//*Label 1078*/ GIMT_Encode4(36025),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1079*/ GIMT_Encode4(35496), // Rule ID 71408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv32i1] }:$rs2), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71408,
        GIR_EraseRootFromParent_Done,
      // Label 1079: @35496
      GIM_Try, /*On fail goto*//*Label 1080*/ GIMT_Encode4(35562), // Rule ID 71409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv32i1] }:$rs2), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71409,
        GIR_EraseRootFromParent_Done,
      // Label 1080: @35562
      GIM_Try, /*On fail goto*//*Label 1081*/ GIMT_Encode4(35628), // Rule ID 71406 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71406,
        GIR_EraseRootFromParent_Done,
      // Label 1081: @35628
      GIM_Try, /*On fail goto*//*Label 1082*/ GIMT_Encode4(35694), // Rule ID 71407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71407,
        GIR_EraseRootFromParent_Done,
      // Label 1082: @35694
      GIM_Try, /*On fail goto*//*Label 1083*/ GIMT_Encode4(35760), // Rule ID 71404 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv32i1] }:$rs2))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71404,
        GIR_EraseRootFromParent_Done,
      // Label 1083: @35760
      GIM_Try, /*On fail goto*//*Label 1084*/ GIMT_Encode4(35826), // Rule ID 71405 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv32i1] }:$rs2))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71405,
        GIR_EraseRootFromParent_Done,
      // Label 1084: @35826
      GIM_Try, /*On fail goto*//*Label 1085*/ GIMT_Encode4(35892), // Rule ID 53886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53886,
        GIR_EraseRootFromParent_Done,
      // Label 1085: @35892
      GIM_Try, /*On fail goto*//*Label 1086*/ GIMT_Encode4(35958), // Rule ID 53887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53887,
        GIR_EraseRootFromParent_Done,
      // Label 1086: @35958
      GIM_Try, /*On fail goto*//*Label 1087*/ GIMT_Encode4(35991), // Rule ID 53874 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53874,
        GIR_EraseRootFromParent_Done,
      // Label 1087: @35991
      GIM_Try, /*On fail goto*//*Label 1088*/ GIMT_Encode4(36024), // Rule ID 53875 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53875,
        GIR_EraseRootFromParent_Done,
      // Label 1088: @36024
      GIM_Reject,
    // Label 1078: @36025
    GIM_Reject,
    // Label 907: @36026
    GIM_Try, /*On fail goto*//*Label 1089*/ GIMT_Encode4(36140),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1090*/ GIMT_Encode4(36094), // Rule ID 48324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48324,
        GIR_EraseRootFromParent_Done,
      // Label 1090: @36094
      GIM_Try, /*On fail goto*//*Label 1091*/ GIMT_Encode4(36139), // Rule ID 48325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48325,
        GIR_EraseRootFromParent_Done,
      // Label 1091: @36139
      GIM_Reject,
    // Label 1089: @36140
    GIM_Reject,
    // Label 908: @36141
    GIM_Try, /*On fail goto*//*Label 1092*/ GIMT_Encode4(36255),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1093*/ GIMT_Encode4(36209), // Rule ID 48340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48340,
        GIR_EraseRootFromParent_Done,
      // Label 1093: @36209
      GIM_Try, /*On fail goto*//*Label 1094*/ GIMT_Encode4(36254), // Rule ID 48341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48341,
        GIR_EraseRootFromParent_Done,
      // Label 1094: @36254
      GIM_Reject,
    // Label 1092: @36255
    GIM_Reject,
    // Label 909: @36256
    GIM_Try, /*On fail goto*//*Label 1095*/ GIMT_Encode4(36866),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1096*/ GIMT_Encode4(36337), // Rule ID 71436 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv64i1] }:$rs2), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71436,
        GIR_EraseRootFromParent_Done,
      // Label 1096: @36337
      GIM_Try, /*On fail goto*//*Label 1097*/ GIMT_Encode4(36403), // Rule ID 71437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv64i1] }:$rs2), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71437,
        GIR_EraseRootFromParent_Done,
      // Label 1097: @36403
      GIM_Try, /*On fail goto*//*Label 1098*/ GIMT_Encode4(36469), // Rule ID 71434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71434,
        GIR_EraseRootFromParent_Done,
      // Label 1098: @36469
      GIM_Try, /*On fail goto*//*Label 1099*/ GIMT_Encode4(36535), // Rule ID 71435 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71435,
        GIR_EraseRootFromParent_Done,
      // Label 1099: @36535
      GIM_Try, /*On fail goto*//*Label 1100*/ GIMT_Encode4(36601), // Rule ID 71432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv64i1] }:$rs2))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71432,
        GIR_EraseRootFromParent_Done,
      // Label 1100: @36601
      GIM_Try, /*On fail goto*//*Label 1101*/ GIMT_Encode4(36667), // Rule ID 71433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv64i1] }:$rs2))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71433,
        GIR_EraseRootFromParent_Done,
      // Label 1101: @36667
      GIM_Try, /*On fail goto*//*Label 1102*/ GIMT_Encode4(36733), // Rule ID 53904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53904,
        GIR_EraseRootFromParent_Done,
      // Label 1102: @36733
      GIM_Try, /*On fail goto*//*Label 1103*/ GIMT_Encode4(36799), // Rule ID 53905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53905,
        GIR_EraseRootFromParent_Done,
      // Label 1103: @36799
      GIM_Try, /*On fail goto*//*Label 1104*/ GIMT_Encode4(36832), // Rule ID 53892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53892,
        GIR_EraseRootFromParent_Done,
      // Label 1104: @36832
      GIM_Try, /*On fail goto*//*Label 1105*/ GIMT_Encode4(36865), // Rule ID 53893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53893,
        GIR_EraseRootFromParent_Done,
      // Label 1105: @36865
      GIM_Reject,
    // Label 1095: @36866
    GIM_Reject,
    // Label 910: @36867
    GIM_Try, /*On fail goto*//*Label 1106*/ GIMT_Encode4(36981),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1107*/ GIMT_Encode4(36935), // Rule ID 48328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48328,
        GIR_EraseRootFromParent_Done,
      // Label 1107: @36935
      GIM_Try, /*On fail goto*//*Label 1108*/ GIMT_Encode4(36980), // Rule ID 48329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48329,
        GIR_EraseRootFromParent_Done,
      // Label 1108: @36980
      GIM_Reject,
    // Label 1106: @36981
    GIM_Reject,
    // Label 911: @36982
    GIM_Reject,
    // Label 8: @36983
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 1140*/ GIMT_Encode4(44913),
    /*GILLT_s32*//*Label 1109*/ GIMT_Encode4(37118),
    /*GILLT_s64*//*Label 1110*/ GIMT_Encode4(37814),
    /*GILLT_nxv1s1*//*Label 1111*/ GIMT_Encode4(38106),
    /*GILLT_nxv1s8*//*Label 1112*/ GIMT_Encode4(38717),
    /*GILLT_nxv1s16*//*Label 1113*/ GIMT_Encode4(38832),
    /*GILLT_nxv1s32*//*Label 1114*/ GIMT_Encode4(38947),
    /*GILLT_nxv1s64*//*Label 1115*/ GIMT_Encode4(39062),
    /*GILLT_nxv2s1*//*Label 1116*/ GIMT_Encode4(39177),
    /*GILLT_nxv2s8*//*Label 1117*/ GIMT_Encode4(39788),
    /*GILLT_nxv2s16*//*Label 1118*/ GIMT_Encode4(39903),
    /*GILLT_nxv2s32*//*Label 1119*/ GIMT_Encode4(40018),
    /*GILLT_nxv2s64*//*Label 1120*/ GIMT_Encode4(40133),
    /*GILLT_nxv4s1*//*Label 1121*/ GIMT_Encode4(40248),
    /*GILLT_nxv4s8*//*Label 1122*/ GIMT_Encode4(40859),
    /*GILLT_nxv4s16*//*Label 1123*/ GIMT_Encode4(40974),
    /*GILLT_nxv4s32*//*Label 1124*/ GIMT_Encode4(41089),
    /*GILLT_nxv4s64*//*Label 1125*/ GIMT_Encode4(41204),
    /*GILLT_nxv8s1*//*Label 1126*/ GIMT_Encode4(41319),
    /*GILLT_nxv8s8*//*Label 1127*/ GIMT_Encode4(41930),
    /*GILLT_nxv8s16*//*Label 1128*/ GIMT_Encode4(42045),
    /*GILLT_nxv8s32*//*Label 1129*/ GIMT_Encode4(42160),
    /*GILLT_nxv8s64*//*Label 1130*/ GIMT_Encode4(42275),
    /*GILLT_nxv16s1*//*Label 1131*/ GIMT_Encode4(42390),
    /*GILLT_nxv16s8*//*Label 1132*/ GIMT_Encode4(43001),
    /*GILLT_nxv16s16*//*Label 1133*/ GIMT_Encode4(43116),
    /*GILLT_nxv16s32*//*Label 1134*/ GIMT_Encode4(43231),
    /*GILLT_nxv32s1*//*Label 1135*/ GIMT_Encode4(43346),
    /*GILLT_nxv32s8*//*Label 1136*/ GIMT_Encode4(43957),
    /*GILLT_nxv32s16*//*Label 1137*/ GIMT_Encode4(44072),
    /*GILLT_nxv64s1*//*Label 1138*/ GIMT_Encode4(44187),
    /*GILLT_nxv64s8*//*Label 1139*/ GIMT_Encode4(44798),
    // Label 1109: @37118
    GIM_Try, /*On fail goto*//*Label 1141*/ GIMT_Encode4(37813),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1142*/ GIMT_Encode4(37188), // Rule ID 2625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), GPR:{ *:[i32] }:$rs1)  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2625,
        GIR_EraseRootFromParent_Done,
      // Label 1142: @37188
      GIM_Try, /*On fail goto*//*Label 1143*/ GIMT_Encode4(37243), // Rule ID 2850 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), GPR:{ *:[i32] }:$rs1)  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2850,
        GIR_EraseRootFromParent_Done,
      // Label 1143: @37243
      GIM_Try, /*On fail goto*//*Label 1144*/ GIMT_Encode4(37298), // Rule ID 65204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)))  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65204,
        GIR_EraseRootFromParent_Done,
      // Label 1144: @37298
      GIM_Try, /*On fail goto*//*Label 1145*/ GIMT_Encode4(37353), // Rule ID 65306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)))  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65306,
        GIR_EraseRootFromParent_Done,
      // Label 1145: @37353
      GIM_Try, /*On fail goto*//*Label 1146*/ GIMT_Encode4(37405), // Rule ID 65194 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65194,
        GIR_EraseRootFromParent_Done,
      // Label 1146: @37405
      GIM_Try, /*On fail goto*//*Label 1147*/ GIMT_Encode4(37457), // Rule ID 65277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65277,
        GIR_EraseRootFromParent_Done,
      // Label 1147: @37457
      GIM_Try, /*On fail goto*//*Label 1148*/ GIMT_Encode4(37509), // Rule ID 65278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65278,
        GIR_EraseRootFromParent_Done,
      // Label 1148: @37509
      GIM_Try, /*On fail goto*//*Label 1149*/ GIMT_Encode4(37561), // Rule ID 2605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2605,
        GIR_EraseRootFromParent_Done,
      // Label 1149: @37561
      GIM_Try, /*On fail goto*//*Label 1150*/ GIMT_Encode4(37613), // Rule ID 2809 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs