#include "typenamespace.hpp"
#include "type.hpp"
#define True true
#define False false
void TypeNamespace::initFunctions() {
  this->functions["add_global_arguments"] = std::make_shared<Function>(
    "add_global_arguments",
    "Adds global arguments to the compiler command line.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "arg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        False
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["add_global_link_arguments"] = std::make_shared<Function>(
    "add_global_link_arguments",
    "Adds global arguments to the linker command line.\n\nLike `add_global_arguments()` but the arguments are passed to the linker.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "arg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        False
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["add_languages"] = std::make_shared<Function>(
    "add_languages",
    "Add programming languages used by the project.\n\nThis is equivalent to having them in the `project` declaration. This function is usually used to add languages that are only used under some conditions.\n\nReturns `true` if all languages specified were found and `false` otherwise.\n\nIf native is omitted, the languages may be used for either build or host machine, but are never required for the build machine. (i.e. it is equivalent to `add_languages(*langs*, native: false, required: *required*) and add_languages(*langs*, native: true, required: false)`).\nThis default behaviour may change to `native: false` in a future Meson version.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "required",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool"),
          this->types.at("feature")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
    }
  );
  this->functions["add_project_arguments"] = std::make_shared<Function>(
    "add_project_arguments",
    "Adds project specific arguments to the compiler command line.\n\nThis function behaves in the same way as `add_global_arguments()` except that the arguments are only used for the current project, they won't be used in any other subproject.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "arg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        False
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["add_project_dependencies"] = std::make_shared<Function>(
    "add_project_dependencies",
    "Adds arguments to the compiler and linker command line, so that the given set of dependencies is included in all build products for this project.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "dependency",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("dep")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        False
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
,DeprecationState()
,Version("0.63.0")
  );
  this->functions["add_project_link_arguments"] = std::make_shared<Function>(
    "add_project_link_arguments",
    "Adds project specific arguments to the linker command line.\n\nLike `add_project_arguments()` but the arguments are passed to the linker.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "arg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        False
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["add_test_setup"] = std::make_shared<Function>(
    "add_test_setup",
    "Add a custom test setup. This setup can be used to run the tests with a custom setup, for example under Valgrind.\n\nTo use the test setup, run `meson test --setup=*name*` inside the build dir.\n\nNote that all these options are also available while running the `meson test` script for running tests instead of `ninja test` or `msbuild RUN_TESTS.vcxproj`, etc depending on the backend.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "env",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("env"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "exclude_suites",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "exe_wrapper",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("external_program"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gdb",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "is_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "timeout_multiplier",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["alias_target"] = std::make_shared<Function>(
    "alias_target",
    "This function creates a new top-level target. Like all top-level targets, this integrates with the selected backend. For instance, with you can run it as `meson compile target_name`. This is a dummy target that does not execute any command, but ensures that all dependencies are built. Dependencies can be any build target (e.g. return value of `executable()`, `custom_target()`, etc)",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "dep",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("tgt")
        },
        False,
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("alias_tgt")
    }
,DeprecationState()
,Version("0.52.0")
  );
  this->functions["assert"] = std::make_shared<Function>(
    "assert",
    "Abort with an error message if `condition` evaluates to `false`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "condition",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "message",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["benchmark"] = std::make_shared<Function>(
    "benchmark",
    "Creates a benchmark item that will be run when the benchmark target is run. The behavior of this function is identical to `test()` except for:\n\n- `benchmark()` has no `is_parallel` keyword because benchmarks are not run in parallel\n- `benchmark()` does not automatically add the `MALLOC_PERTURB_` environment variable\n\nDefined tests can be run in a backend-agnostic way by calling `meson test` inside the build dir, or by using backend-specific commands, such as `ninja test` or `msbuild RUN_TESTS.vcxproj`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "executable",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("exe"),
          this->types.at("jar"),
          this->types.at("external_program"),
          this->types.at("file")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("file"),this->types.at("str"),this->types.at("tgt")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depends",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "env",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("env")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "priority",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "protocol",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "should_fail",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "suite",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "timeout",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "verbose",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "workdir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["both_libraries"] = std::make_shared<Function>(
    "both_libraries",
    "Builds both a static and shared library with the given sources.\nPositional and keyword arguments are otherwise the same as for `library()`. Source files will be compiled only once and object files will be reused to build both shared and static libraries, unless `b_staticpic` user option or `pic` argument are set to false in which case sources will be compiled twice.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "darwin_versions",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "pic",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "prelink",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_abi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "soversion",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_gir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_header",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_vapi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vs_module_defs",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("both_libs")
    }
,DeprecationState()
,Version("0.46.0")
  );
  this->functions["build_target"] = std::make_shared<Function>(
    "build_target",
    "Creates a build target whose type can be set dynamically with the `target_type` keyword argument.\n\n`target_type` may be set to one of:\n\n- `executable` (see `executable()`)\n- `shared_library` (see `shared_library()`)\n- `shared_module` (see `shared_module()`)\n- `static_library` (see `static_library()`)\n- `both_libraries` (see `both_libraries()`)\n- `library` (see `library()`)\n- `jar` (see `jar()`)",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("build_tgt")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "c_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "darwin_versions",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implib",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool"),
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "main_class",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "pic",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "pie",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "prelink",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_abi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "soversion",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "target_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_gir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_header",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_vapi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vs_module_defs",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("build_tgt")
    }
  );
  this->functions["configuration_data"] = std::make_shared<Function>(
    "configuration_data",
    "Creates an empty configuration object.\nYou should add your configuration with the `cfg_data` method calls and finally use it in a call to `configure_file()`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "data",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")})
        },
        True,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("cfg_data")
    }
  );
  this->functions["configure_file"] = std::make_shared<Function>(
    "configure_file",
    "This function can run in three modes depending on the keyword arguments passed to it.\n\n- When a `cfg_data` object is passed to the `configuration:` keyword argument, it takes a template file as the `input:` (optional) and produces the `output:` (required) by substituting values from the configuration data as detailed in the [configuration file documentation](https://mesonbuild.com/Configuration.html). A dictionary can be passed instead of a `cfg_data` object.\n- When a list of strings is passed to the `command:` keyword argument, it takes any source or configured file as the `input:` and assumes that the `output:` is produced when the specified command is run.\n- When the `copy:` keyword argument is set to true, this function will copy the file provided in `input:` to a file in the build directory with the name `output:` in the current directory.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<Kwarg>(
        "capture",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "command",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "configuration",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          this->types.at("cfg_data")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "copy",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depfile",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "encoding",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "format",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "input",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "macro_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "output",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False
      ),
      std::make_shared<Kwarg>(
        "output_format",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("file")
    }
  );
  this->functions["custom_target"] = std::make_shared<Function>(
    "custom_target",
    "Create a custom top level build target.\n\nThe list of strings passed to the `command` keyword argument accept the following special string substitutions:\n\n- `@INPUT@`: the full path to the input passed to `input`. If more than one input is specified, all of them will be substituted as separate arguments only if the command uses `'@INPUT@'` as a standalone-argument. For instance, this would not work: `command : ['cp', './@INPUT@']`, but this would: `command : ['cp', '@INPUT@']`.\n- `@OUTPUT@`: the full path to the output passed to `output`. If more than one outputs are specified, the behavior is the same as `@INPUT@`.\n- `@INPUT0@` `@INPUT1@` ...: the full path to the input with the specified array index in `input`\n- `@OUTPUT0@` `@OUTPUT1@` ...: the full path to the output with the specified array index in `output`\n- `@OUTDIR@`: the full path to the directory where the output(s) must be written\n- `@DEPFILE@`: the full path to the dependency file passed to `depfile`\n- `@PLAINNAME@`: the input filename, without a path\n- `@BASENAME@`: the input filename, with extension removed\n- `@PRIVATE_DIR@`: path to a directory where the custom target must store all its intermediate files.\n- `@SOURCE_ROOT@`: the path to the root of the source tree. Depending on the backend, this may be an absolute or a relative to current workdir path.\n- `@BUILD_ROOT@`: the path to the root of the build tree. Depending on the backend, this may be an absolute or a relative to current workdir path.\n- `@CURRENT_SOURCE_DIR@`: this is the directory where the currently processed meson.build is located in. Depending on the backend, this may be an absolute or a relative to current workdir path.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        False
      ),
      std::make_shared<Kwarg>(
        "build_always",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.47.0", std::vector<std::string>
{"@build_always_stale","@build_by_default"
})
      ),
      std::make_shared<Kwarg>(
        "build_always_stale",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "capture",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "command",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("exe"),this->types.at("external_program"),this->types.at("file"),this->types.at("str")})
        },
        False
      ),
      std::make_shared<Kwarg>(
        "console",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depend_files",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depends",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depfile",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "env",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("env"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "feed",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "input",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("exe"),this->types.at("extracted_obj"),this->types.at("file"),this->types.at("generated_list"),this->types.at("lib"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "output",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
    }
  );
  this->functions["debug"] = std::make_shared<Function>(
    "debug",
    "Write the argument string to the meson build log.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "message",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          this->types.at("bool"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")})
        },
        True,
        False
      ),
      std::make_shared<PositionalArgument>(
        "msg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          this->types.at("bool"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")})
        },
        True,
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["declare_dependency"] = std::make_shared<Function>(
    "declare_dependency",
    "This function returns a `dep` object that behaves like the return value of `dependency()` but is internal to the current build.\nThe main use case for this is in subprojects. This allows a subproject to easily specify how it should be used. This makes it interchangeable with the same dependency that is provided externally by the system.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<Kwarg>(
        "compile_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "variables",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
    }
  );
  this->functions["dependency"] = std::make_shared<Function>(
    "dependency",
    "Finds an external dependency (usually a library installed on your system) with the given name with `pkg-config` and with CMake if pkg-config fails.\nAdditionally, frameworks (OSX only) and library-specific fallback detection logic are also supported.\n\nMore than one name can be provided, they will be tried in order and the first name to be found will be used. The fallback subproject will be used only if none of the names are found on the system.\nOnce one of the name has been found, all other names are added into the cache so subsequent calls for any of those name will return the same value. This is useful in case a dependency could have different names, such as `png` and `libpng`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "names",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        True
      ),
      std::make_shared<Kwarg>(
        "allow_fallback",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cmake_module_path",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cmake_package_version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "components",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "default_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str"),std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})}),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "disabler",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fallback",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "main",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "method",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "modules",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "not_found_message",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "optional_modules",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "private_headers",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "required",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool"),
          this->types.at("feature")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "static",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
    }
  );
  this->functions["disabler"] = std::make_shared<Function>(
    "disabler",
    "Returns a `disabler` object.",
    std::vector<std::shared_ptr<Argument>>{
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("disabler")
    }
,DeprecationState()
,Version("0.44.0")
  );
  this->functions["environment"] = std::make_shared<Function>(
    "environment",
    "Returns an empty `env` object.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "env",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})}),
          this->types.at("env")
        },
        True,
        False
      ),
      std::make_shared<Kwarg>(
        "method",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "separator",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("env")
    }
,DeprecationState()
,Version("0.35.0")
  );
  this->functions["error"] = std::make_shared<Function>(
    "error",
    "Print the argument string and halts the build process.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "message",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        False
      ),
      std::make_shared<PositionalArgument>(
        "msg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["executable"] = std::make_shared<Function>(
    "executable",
    "Creates a new executable. The first argument specifies its name and the remaining positional arguments define the input files to use.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("build_tgt"),
          this->types.at("structured_src")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("external_program"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "export_dynamic",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implib",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool"),
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib"),this->types.at("tgt")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("extracted_obj"),this->types.at("extracted_obj"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "pie",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_gir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_header",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_vapi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vs_module_defs",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("exe")
    }
  );
  this->functions["files"] = std::make_shared<Function>(
    "files",
    "This command takes the strings given to it in arguments and returns corresponding File objects that you can use as sources for build targets. The difference is that file objects remember the subdirectory they were defined in and can be used anywhere in the source tree.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "file",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file")})
    }
  );
  this->functions["find_program"] = std::make_shared<Function>(
    "find_program",
    "`program_name` here is a string that can be an executable or script to be searched for in PATH or other places inside the project. The search order is:\n\n\n1. Program overrides set via `meson.override_find_program()`\n2. `[provide]` sections in subproject wrap files, if `wrap_mode` is set to `forcefallback`\n3. `[binaries]` section in your machine files\n4. Directories provided using the `dirs:` kwarg\n5. Project's source tree relative to the current subdir\n1. If you use the return value of `configure_file()`, the current subdir inside the build tree is used instead\n7. `PATH` environment variable\n8. `[provide]` sections in subproject wrap files, if wrap_mode is set to anything other than `nofallback`\n\nMeson will also autodetect scripts with a shebang line and run them with the executable/interpreter specified in it both on Windows (because the command invocator will reject the command otherwise) and Unixes (if the script file does not have the executable bit set).\nHence, you must not manually add the interpreter while using this script as part of a list of commands. If the \"python3\" program is requested and it is not found in the system, Meson will return its current interpreter.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "program_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "fallback",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "default_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str"),this->types.at("bool"),this->types.at("int"),std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})}),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "disabler",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "required",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool"),
          this->types.at("feature")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version_argument",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("external_program")
    }
  );
  this->functions["generator"] = std::make_shared<Function>(
    "generator",
    "This function creates a `generator` object that can be used to run custom compilation commands. The only positional argument is the executable to use. It can either be a self-built executable or one returned by find_program.\nThe template strings passed to all the keyword arguments accept the following special substitutions:\n\n- `@PLAINNAME@`: the complete input file name, e.g., `foo.c` becomes `foo.c` (unchanged).\n- `@BASENAME@`: the base of the input filename, e.g., `foo.c.y` becomes `foo.c` (extension is removed).\n\nEach string passed to the `output` keyword argument must be constructed using one or both of these two substitutions.\n\nIn addition to the above substitutions, the `arguments` keyword argument also accepts the following:\n\n- `@OUTPUT@`: the full path to the output file.\n- `@INPUT@`: the full path to the input file.\n- `@DEPFILE@`: the full path to the depfile.\n- `@SOURCE_DIR@`: the full path to the root of the source tree.\n- `@CURRENT_SOURCE_DIR@`: this is the directory where the currently processed `meson.build` is located.\n- `@BUILD_DIR@`: the full path to the root of the build directory where the output will be placed.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "exe",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("exe"),
          this->types.at("external_program")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "arguments",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "capture",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depends",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depfile",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "output",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("generator")
    }
  );
  this->functions["get_option"] = std::make_shared<Function>(
    "get_option",
    "Obtains the value of the `project build option` specified in the positional argument.\n\nNote that the value returned for built-in options that end in `dir` such as `bindir` and `libdir` is usually a path relative to (and inside) the `prefix` but you should not rely on that, as it can also be an absolute path in some cases. `install_dir` arguments handle that as expected but if you need an absolute path, e.g. to use in a `define` etc., you should use the path concatenation operator like this: `get_option('prefix') / get_option('localstatedir')`.\nNever manually join paths as if they were strings.\n\nFor options of type `feature` a feature option object is returned instead of a string.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "option_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("str"),
        this->types.at("int"),
        this->types.at("bool"),
        this->types.at("feature"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")})
    }
  );
  this->functions["get_variable"] = std::make_shared<Function>(
    "get_variable",
    "\nThis function can be used to dynamically obtain a variable. `res = get_variable(varname, fallback)` takes the value of `varname` (which must be a string) and stores the variable of that name into `res`. If the variable does not exist, the variable `fallback` is stored into `res` instead. If a fallback is not specified, then attempting to read a non-existing variable will cause a fatal error.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "variable_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("any")
        },
        True,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
    }
  );
  this->functions["import"] = std::make_shared<Function>(
    "import",
    "Imports the given extension module. Returns an object that can be used to call the methods of the module.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "module_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "disabler",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "module_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "required",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool"),
          this->types.at("feature")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("module")
    }
  );
  this->functions["include_directories"] = std::make_shared<Function>(
    "include_directories",
    "Returns an opaque object which contains the directories (relative to the current directory) given in the positional arguments. The result can then be passed to the `include_directories:` keyword argument when building executables or libraries. You can use the returned object in any subdirectory you want, Meson will make the paths work automatically.\n\nNote that this function call itself does not add the directories into the search path, since there is no global search path. For something like that, see `add_project_arguments()`.\n\nSee also `implicit_include_directories` parameter of `executable()`, which adds current source and build directories to include path.\n\nEach directory given is converted to two include paths: one that is relative to the source root and one relative to the build root.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "includes",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "is_system",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("inc")
    }
  );
  this->functions["install_data"] = std::make_shared<Function>(
    "install_data",
    "Installs files from the source tree that are listed as positional arguments.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "file",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "follow_symlinks",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "preserve_path",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rename",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["install_emptydir"] = std::make_shared<Function>(
    "install_emptydir",
    "Installs a new directory entry to the location specified by the positional argument. If the directory exists and is not empty, the contents are left in place.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "dirpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "follow_symlinks",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
,DeprecationState()
,Version("0.60.0")
  );
  this->functions["install_headers"] = std::make_shared<Function>(
    "install_headers",
    "Installs the specified header files from the source tree into the system header directory (usually `/{prefix}/include`) during the install step. This directory can be overridden by specifying it with the `install_dir` keyword argument. If you just want to install into a subdirectory of the system header directory, then use the `subdir` argument. As an example if this has the value `myproj` then the headers would be installed to `/{prefix}/include/myproj`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "file",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "follow_symlinks",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "preserve_path",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "subdir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["install_man"] = std::make_shared<Function>(
    "install_man",
    "Installs the specified man files from the source tree into system's man directory during the install step. This directory can be overridden by specifying it with the `install_dir` keyword argument.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "file",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "follow_symlinks",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "locale",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["install_subdir"] = std::make_shared<Function>(
    "install_subdir",
    "Installs the entire given subdirectory and its contents from the source tree to the location specified by the keyword argument `install_dir`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "subdir_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "exclude_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "exclude_files",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "follow_symlinks",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "strip_directory",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["install_symlink"] = std::make_shared<Function>(
    "install_symlink",
    "Installs a symbolic link to `pointing_to` target under `install_dir`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "link_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "pointing_to",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
,DeprecationState()
,Version("0.61.0")
  );
  this->functions["is_disabler"] = std::make_shared<Function>(
    "is_disabler",
    "Returns `true` if a variable is a `disabler` and `false` otherwise.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "var",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("any")
        },
        False,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
    }
,DeprecationState()
,Version("0.52.0")
  );
  this->functions["is_variable"] = std::make_shared<Function>(
    "is_variable",
    "Returns `true` if a variable of the given name exists and `false` otherwise.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "var",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
    }
,DeprecationState()
,Version("0.52.0")
  );
  this->functions["jar"] = std::make_shared<Function>(
    "jar",
    "Build a jar from the specified Java source files. Keyword arguments are the same as `executable()`'s, with the addition of `main_class` which specifies the main class to execute when running the jar with `java -jar file.jar`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("jar"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "main_class",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("jar")
    }
  );
  this->functions["join_paths"] = std::make_shared<Function>(
    "join_paths",
    "Joins the given strings into a file system path segment.\nFor example `join_paths('foo', 'bar')` results in `foo/bar`.\nIf any one of the individual segments is an absolute path, all segments before it are dropped. That means `join_paths('foo', '/bar')` returns `/bar`.\n\nUsing the `/` operator on strings is equivalent to calling `join_paths()`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "part",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
    }
,DeprecationState()
,Version("0.36.0")
  );
  this->functions["library"] = std::make_shared<Function>(
    "library",
    "Builds a library that is either static, shared, or both depending on the value of the `default_library` user option.\nYou should use this instead of `shared_library()`, `static_library()`, or `both_libraries()` most of the time.\nThis allows you to toggle your entire project (including subprojects) from shared to static with only one option.\nThis option applies to libraries being built internally within the entire project.\nFor external dependencies, the default library type preferred is shared. This can be adapted on a per-library basis using the `dependency()` static keyword.\n\nThe keyword arguments for this are the same as for `build_target()`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("build_tgt"),
          this->types.at("external_program")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "c_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_shared_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_static_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "darwin_versions",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "pic",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "prelink",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_abi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "soversion",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_gir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_header",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_vapi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vs_module_defs",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("lib"),
        this->types.at("both_libs")
    }
  );
  this->functions["message"] = std::make_shared<Function>(
    "message",
    "This function prints its argument to stdout.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "message",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          this->types.at("bool"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          this->types.at("env")
        },
        True,
        False
      ),
      std::make_shared<PositionalArgument>(
        "msg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          this->types.at("bool"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          this->types.at("env")
        },
        True,
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["project"] = std::make_shared<Function>(
    "project",
    "The first function called in each project, to initialize Meson.\n\nThe first argument to this function must be a string defining the name of this project.\n\nThe project name can be any string you want; it's not used for anything except descriptive purposes. However, since it is written to, for example, the dependency manifest, it usually makes sense to have it be the same as the project tarball or pkg-config name. So, for example, you would probably want to use the name `libfoobar` instead of `The Foobar Library`.\n\nIt may be followed by the list of programming languages that the project uses.\n\nThe list of languages is optional.\n\nThese languages may be used both for `native: false` (the default) (host machine) targets and for `native: true` (build machine) targets. (since 0.56.0) The build machine compilers for the specified languages are not required.\n\nSupported values for languages are `c`, `cpp` (for C++), `cuda`, `cython`, `d`, `objc`, `objcpp`, `fortran`, `java`, `cs` (for C#), `vala`, and `rust`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "project_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "default_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str"),this->types.at("bool"),this->types.at("int"),std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "license",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "license_files",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "meson_version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "subproject_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["range"] = std::make_shared<Function>(
    "range",
    "Return an opaque object that can be only be used in `foreach` statements.\n\n- `start` must be an integer greater than or equal to 0. Defaults to 0.\n- `stop` must be an integer greater than or equal to `start`.\n- `step` must be an integer greater than or equal to 1. Defaults to 1.\n\nIt causes the `foreach` loop to be called with the value from `start` (included) to `stop` (excluded) with an increment of `step` after each loop.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "start",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True,
        False
      ),
      std::make_shared<PositionalArgument>(
        "stop",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True,
        False
      ),
      std::make_shared<PositionalArgument>(
        "step",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("range")
    }
,DeprecationState()
,Version("0.58.0")
  );
  this->functions["run_command"] = std::make_shared<Function>(
    "run_command",
    "Runs the command specified in positional arguments. `command` can be a string, or the output of `find_program()`, `files()`, or `configure_file()`, or a compiler object.\n\nReturns a `runresult` object containing the result of the invocation.\nThe command is run from an unspecified directory, and Meson will set three environment variables `MESON_SOURCE_ROOT`, `MESON_BUILD_ROOT`, and `MESON_SUBDIR` that specify the source directory, build directory, and subdirectory the target was defined in, respectively.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "command",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("external_program"),
          this->types.at("compiler")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "capture",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "check",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "env",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("env"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("runresult")
    }
  );
  this->functions["run_target"] = std::make_shared<Function>(
    "run_target",
    "This function creates a new top-level target that runs a specified command with the specified arguments. Like all top-level targets, this integrates with the selected backend. For instance, you can run it as `meson compile target_name`. Note that a run target produces no output as far as Meson is concerned. It is only meant for tasks such as running a code formatter or flashing an external device's firmware with a built file.\n\nThe command is run from an unspecified directory, and Meson will set three environment variables `MESON_SOURCE_ROOT`, `MESON_BUILD_ROOT`, and `MESON_SUBDIR` that specify the source directory, build directory, and subdirectory the target was defined in, respectively.\n\nThe template strings passed to `command` keyword arguments accept the following special substitutions:\n\n- `@SOURCE_ROOT@`: the path to the root of the source tree. Depending on the backend, this may be an absolute or a relative to current workdir path.\n- `@BUILD_ROOT@`: the path to the root of the build tree. Depending on the backend, this may be an absolute or a relative to current workdir path.\n- `@CURRENT_SOURCE_DIR@` (Since 0.57.1): this is the directory where the currently processed `meson.build` is located in. Depending on the backend, this may be an absolute or a relative to current workdir path.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "command",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("exe"),this->types.at("external_program"),this->types.at("file"),this->types.at("str")})
        },
        False
      ),
      std::make_shared<Kwarg>(
        "depends",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "env",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("env"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("run_tgt")
    }
  );
  this->functions["set_variable"] = std::make_shared<Function>(
    "set_variable",
    "Assigns a value to the given variable name. Calling `set_variable('foo', bar)` is equivalent to `foo = bar`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "variable_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "value",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("any")
        },
        False,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["shared_library"] = std::make_shared<Function>(
    "shared_library",
    "Builds a shared library with the given sources.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("build_tgt")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "darwin_versions",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool")}),
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool")}),
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_abi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "soversion",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_gir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_header",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_vapi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vs_module_defs",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("lib")
    }
  );
  this->functions["shared_module"] = std::make_shared<Function>(
    "shared_module",
    "Builds a shared module with the given sources.\n\nThis is useful for building modules that will be `dlopen()`ed and hence may contain undefined symbols that will be provided by the library that is loading it.\n\nIf you want the shared module to be able to refer to functions and variables defined in the `executable()` it is loaded by, you will need to set the `export_dynamic` argument of the `executable` to `true`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("build_tgt")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("exe"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_abi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_gir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_header",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_vapi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vs_module_defs",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("build_tgt")
    }
  );
  this->functions["static_library"] = std::make_shared<Function>(
    "static_library",
    "Builds a static library with the given sources.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "target_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "source",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("build_tgt")
        },
        True,
        True
      ),
      std::make_shared<Kwarg>(
        "build_by_default",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "build_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "c_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cpp_pch",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cs_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cuda_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "cython_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "swift_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_debug",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_import_dirs",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_module_versions",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "d_unittest",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "dependencies",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "extra_files",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fortran_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gnu_symbol_visibility",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "gui_app",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
      ),
      std::make_shared<Kwarg>(
        "implicit_include_directories",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "include_directories",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_dir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_mode",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_rpath",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "install_tag",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "java_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_depends",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_language",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_whole",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "link_with",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "masm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_prefix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "name_suffix",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>()
        },
        True
      ),
      std::make_shared<Kwarg>(
        "nasm_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "native",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objc_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objcpp_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "objects",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "override_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "pic",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "prelink",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "resources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_abi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "rust_crate_type",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
      ),
      std::make_shared<Kwarg>(
        "rust_dependency_map",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "sources",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx"),
          this->types.at("generated_list"),
          this->types.at("structured_src")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "soversion",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_gir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_header",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vala_vapi",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "vs_module_defs",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt"),
          this->types.at("custom_idx")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "win_subsystem",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("lib")
    }
  );
  this->functions["structured_sources"] = std::make_shared<Function>(
    "structured_sources",
    "Create a StructuredSource object, which is opaque and may be passed as a source to any build_target (including static_library, shared_library, executable, etc.). This is useful for languages like Rust, which use the filesystem layout to determine import names. This is only allowed in Rust targets, and cannot be mixed with non structured inputs.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "root",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "additional",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
        },
        True,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("structured_src")
    }
,DeprecationState()
,Version("0.62.0")
  );
  this->functions["subdir"] = std::make_shared<Function>(
    "subdir",
    "Enters the specified subdirectory and executes the `meson.build` file in it. Once that is done, it returns and execution continues on the line following this `subdir()` command. Variables defined in that `meson.build` file are then available for use in later parts of the current build file and in all subsequent build files executed with `subdir()`.\n\nNote that this means that each `meson.build` file in a source tree can and must only be executed once.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "dir_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "if_found",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["subdir_done"] = std::make_shared<Function>(
    "subdir_done",
    "Stops further interpretation of the Meson script file from the point of the invocation. All steps executed up to this point are valid and will be executed by Meson. This means that all targets defined before the call of `subdir_done()` will be build.\n\nIf the current script was called by subdir the execution returns to the calling directory and continues as if the script had reached the end. If the current script is the top level script Meson configures the project as defined up to this point.",
    std::vector<std::shared_ptr<Argument>>{
    },
    std::vector<std::shared_ptr<Type>>{
    }
,DeprecationState()
,Version("0.46.0")
  );
  this->functions["subproject"] = std::make_shared<Function>(
    "subproject",
    "Takes the project specified in the positional argument and brings that into the current build specification by returning a subproject object. Subprojects must always be placed inside the `subprojects` directory at the top source directory. So for example, a subproject called `foo` must be located in `${MESON_SOURCE_ROOT}/subprojects/foo`.\n\n- `default_options` (since 0.37.0): an array of default option values that override those set in the subproject's `meson.options` (like `default_options` in `project`, they only have effect when Meson is run for the first time, and command line arguments override any default options in build files). (since 0.54.0): `default_library` built-in option can also be overridden. (since 1.2.0): A dictionary may be passed instead of an array.\n- `version`: works just like the same as in `dependency`. It specifies what version the subproject should be, as an example `>=1.0.1`.\n- `required` (since 0.48.0): By default, `required` is true and Meson will abort if the subproject could not be set up. You can set this to `false` and then use the `.found()` method on the subproject object. You may also pass the value of a feature option, same as `dependency()`.\n\nNote that you can use the returned subproject object to access any variable in the subproject. However, if you want to use a `dependency` object from inside a subproject, an easier way is to use the `fallback:` keyword argument to `dependency()`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "subproject_name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "default_options",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str"),this->types.at("bool"),this->types.at("int"),std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})}),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "required",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool"),
          this->types.at("feature")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "version",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("subproject")
    }
  );
  this->functions["summary"] = std::make_shared<Function>(
    "summary",
    "This function is used to summarize build configuration at the end of the build process. It provides a way for projects (and subprojects) to report this information in a clear way.\n\nThe content is a series of key/value pairs grouped into sections. If the `section` keyword argument is omitted, those key/value pairs are implicitly grouped into a section with no title. Key/value pairs can optionally be grouped into a dictionary, but keep in mind that dictionaries do not guarantee ordering. `key` must be a string, and `value` can be:\n\n- an integer, boolean, or string\n- (since 0.57.0) an external program or a dependency\n- (since 0.58.0) a feature option\n- a list of those.\n\nInstead of calling `summary` as `summary(key, value)`, it is also possible to directly pass a dictionary to the `summary()` function, as seen in the example below.\n\n`summary()` can be called multiple times as long as the same section/key pair doesn't appear twice. All sections will be collected and printed at the end of the configuration in the same order as they have been called.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "key_or_dict",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("dep"),this->types.at("external_program"),this->types.at("int"),std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("dep"),this->types.at("external_program"),this->types.at("int"),this->types.at("str")}),this->types.at("str")})
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "value",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("bool"),
          this->types.at("int"),
          this->types.at("dep"),
          this->types.at("external_program"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("dep"),this->types.at("external_program"),this->types.at("int"),this->types.at("str")})
        },
        True,
        False
      ),
      std::make_shared<Kwarg>(
        "bool_yn",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "list_sep",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "section",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
,DeprecationState()
,Version(" 0.53.0")
  );
  this->functions["test"] = std::make_shared<Function>(
    "test",
    "Defines a test to run with the test harness. Takes two positional arguments: the first is the name of the test, and the second is the executable to run. The executable can be an `exe` object returned by `executable()` or an `external_program` object returned by `find_program()`.\n\n(since 0.55.0) When cross-compiling, if an `exe_wrapper` is needed and defined, the environment variable `MESON_EXE_WRAPPER` will be set to the string value of that wrapper (implementation detail: using `mesonlib.join_args`). Test scripts may use this to run cross-built binaries. If your test needs `MESON_EXE_WRAPPER` in cross-build situations, it is your responsibility to return code 77 to tell the harness to report \"skip\".\n\nBy default, the environment variable `MALLOC_PERTURB_` is automatically set by `meson test` to a random value between 1 and 255. This can help find memory leaks on configurations using glibc, including with non-GCC compilers. However, this can have a performance impact and may fail a test due to external libraries whose internals are out of the user's control. To check if this feature is causing an expected runtime crash, disable the feature by temporarily setting the environment variable `MALLOC_PERTURB_=0`. While it's preferable to only temporarily disable this check, if a project requires permanent disabling of this check in `meson.build`, do like:\n\n```meson\nnomalloc = environment({'MALLOC_PERTURB_': '0'})\ntest(..., env: nomalloc, ...)\n```\nBy default, the environment variables `ASAN_OPTIONS` and `UBSAN_OPTIONS` are set to enable aborting on detected violations and to provide a backtrace. To suppress this behavior, you can set `ASAN_OPTIONS` and `UBSAN_OPTIONS` in the environment variables.\n\nIn addition to running individual executables as test cases, `test()` can also be used to invoke an external test harness. For this scenario, it is recommended to use `verbose: true` (since 0.62.0) and, if supported by the external harness, `protocol: 'tap'` (since 0.50.0). This setup ensures that Meson logs each subtest as it runs, rather than including the entire log at the end of the run.\n\nDefined tests can be run in a backend-agnostic way by executing `meson test` within the build directory, or by using backend-specific commands such as `ninja test` or `msbuild RUN_TESTS.vcxproj`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "name",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      ),
      std::make_shared<PositionalArgument>(
        "executable",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("exe"),
          this->types.at("jar"),
          this->types.at("external_program"),
          this->types.at("file"),
          this->types.at("tgt"),
          this->types.at("custom_idx"),
          this->types.at("custom_tgt")
        },
        False,
        False
      ),
      std::make_shared<Kwarg>(
        "args",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("file"),this->types.at("str"),this->types.at("tgt")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "depends",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "env",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
          this->types.at("env")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "is_parallel",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "priority",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "protocol",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "should_fail",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "suite",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "timeout",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("int")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "verbose",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("bool")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "workdir",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
  );
  this->functions["unset_variable"] = std::make_shared<Function>(
    "unset_variable",
    "Unsets a variable. Referencing a variable which has been unset is an error until it has been set again.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "varname",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False,
        False
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
,DeprecationState()
,Version("0.60.0")
  );
  this->functions["vcs_tag"] = std::make_shared<Function>(
    "vcs_tag",
    "This command detects revision control commit information at build time and places it in the specified output file. The generated file is ensured to be up to date with every build. Keywords are similar to `custom_target()`.\n\nMeson will read the contents of `input`, substitute the `replace_string` with the detected revision number, and write the result to `output`. This method returns a `custom_tgt` object that, as usual, should be used to signal dependencies if other targets use the file outputted by this.\n\nFor instance, if you generate a header with this command and intend to use it in a build target, you must add the return value to the sources of that build target. This is crucial for Meson to determine the order in which to build the targets.\n\nIf you require more specific behavior than what this command provides, it is recommended to use `custom_target()`.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<Kwarg>(
        "command",
        std::vector<std::shared_ptr<Type>>{
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("exe"),this->types.at("external_program"),this->types.at("file"),this->types.at("str")})
        },
        True
      ),
      std::make_shared<Kwarg>(
        "fallback",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      ),
      std::make_shared<Kwarg>(
        "input",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("file"),
          this->types.at("custom_tgt")
        },
        False
      ),
      std::make_shared<Kwarg>(
        "output",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        False
      ),
      std::make_shared<Kwarg>(
        "replace_string",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str")
        },
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
    }
  );
  this->functions["warning"] = std::make_shared<Function>(
    "warning",
    "This function prints its argument to stdout prefixed with WARNING:.",
    std::vector<std::shared_ptr<Argument>>{
      std::make_shared<PositionalArgument>(
        "message",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          this->types.at("bool"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")})
        },
        True,
        False
      ),
      std::make_shared<PositionalArgument>(
        "msg",
        std::vector<std::shared_ptr<Type>>{
          this->types.at("str"),
          this->types.at("int"),
          this->types.at("bool"),
          std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")}),
          std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("int"),this->types.at("str")})
        },
        True,
        True
      )
    },
    std::vector<std::shared_ptr<Type>>{
    }
,DeprecationState()
,Version("0.44.0")
  );
}
