#include "typenamespace.hpp"
void TypeNamespace::initObjectDocs() {
    this->objectDocs["build_machine"] = "Provides information about the build machine -- the machine that is doing the actual compilation.\n\nCurrently, these values are populated using `platform.system()` and `platform.machine()`.";
    this->objectDocs["host_machine"] = "Provides information about the host machine -- the machine on which the compiled binary will run.\n\nIt has the same methods as build_machine.\n\nWhen not cross-compiling, all the methods return the same values as `build_machine` (because the build machine is the host machine)\n\nNote that while cross-compiling, it simply returns the values defined in the cross-info file.";
    this->objectDocs["meson"] = "The meson object allows you to introspect various properties of the system. This object is always mapped in the meson variable.";
    this->objectDocs["target_machine"] = "Provides information about the target machine -- the machine on which the compiled binary's output will run. Hence, this object should only be used while cross-compiling a compiler.\n\nIt has the same methods as `build_machine`.\n\nWhen all compilation is 'native', all the methods return the same values as `build_machine` (because the build machine is the host machine and the target machine).\n\nNote that while cross-compiling, it simply returns the values defined in the cross-info file. If `target_machine` values are not defined in the cross-info file, `host_machine` values are returned instead.";
    this->objectDocs["any"] = "A placeholder representing all types. This includes builtin, as well as returned objects.";
    this->objectDocs["bool"] = "A boolean object which is either `true` or `false`.";
    this->objectDocs["dict"] = "Stores a mapping of strings to other objects.";
    this->objectDocs["int"] = "All integer numbers.\n\nHexadecimal, binary and octal numbers are supported:\n```\nint_255 = 0xFF\nint_493 = 0o755\nint_1365 = 0b10101010101\n```";
    this->objectDocs["list"] = "An array of elements.";
    this->objectDocs["str"] = "All strings are immutable, all operations return their results as a new string.";
    this->objectDocs["alias_tgt"] = "Opaque object returned by `alias_target()`.";
    this->objectDocs["both_libs"] = "Container for both a static and shared library returned by `both_libraries()`.";
    this->objectDocs["build_tgt"] = "A build target is either an executable, shared library, static library, both shared and static library or shared module.";
    this->objectDocs["cfg_data"] = "This object encapsulates configuration values to be used for generating configuration files.";
    this->objectDocs["compiler"] = "This object is returned by `meson.get_compiler()`. It represents a compiler for a given language and allows you to query its properties.";
    this->objectDocs["custom_idx"] = "References a specific output file of a `custom_tgt` object.";
    this->objectDocs["custom_tgt"] = "This object is returned by `custom_target()`.";
    this->objectDocs["dep"] = "Abstract representation of a dependency.";
    this->objectDocs["disabler"] = "A disabler object is an object that behaves in much the same way as NaN numbers do in floating point math.\nThat is when used in any statement (function call, logical op, etc) they will cause the statement evaluation to immediately short circuit to return a disabler object.\nA disabler object has one method:";
    this->objectDocs["env"] = "This object is returned by `environment()` and stores detailed information about how environment variables should be set.\nIt should be passed as the `env` keyword argument to tests and other functions.";
    this->objectDocs["exe"] = "An executable";
    this->objectDocs["external_program"] = "Opaque object representing an external program.";
    this->objectDocs["extracted_obj"] = "Opaque object representing extracted object files from build targets";
    this->objectDocs["feature"] = "Meson object representing a feature options";
    this->objectDocs["file"] = "Object that stores the path to an existing file";
    this->objectDocs["generated_list"] = "Opaque object representing the result of a `generator.process()` call.";
    this->objectDocs["generator"] = "This object is returned by `generator()` and contains a generator that is used to transform files from one type to another by an executable (e.g. idl files into source code and headers).";
    this->objectDocs["inc"] = "Opaque wrapper for storing include directories.";
    this->objectDocs["jar"] = "A Java JAR build target";
    this->objectDocs["lib"] = "Represents either a shared or static library.";
    this->objectDocs["module"] = "Base type for all modules.\n\nModules provide their own specific implementation methods.";
    this->objectDocs["range"] = "Opaque object that can be used in a loop and accessed via `[num]`.";
    this->objectDocs["run_tgt"] = "Opaque object returned by `run_target()`.";
    this->objectDocs["runresult"] = "This object encapsulates the result of trying to compile and run a sample piece of code with `compiler.run()` or `run_command()`.";
    this->objectDocs["structured_src"] = "Opaque object returned by `structured_sources()`.";
    this->objectDocs["subproject"] = "This object is returned by `subproject()` and is an opaque object representing it.";
    this->objectDocs["tgt"] = "Opaque base object for all Meson targets.";
    this->objectDocs["cmake_module"] = "This module provides helper tools for generating cmake package files.\nIt also supports the usage of CMake based subprojects, similar to the normal Meson subprojects.";
    this->objectDocs["fs_module"] = "This module provides functions to inspect the file system.\n\nNon-absolute paths are looked up relative to the directory where the current `meson.build` file is.\n\nIf specified, a leading `~` is expanded to the user home directory. Environment variables are not available as is the rule throughout Meson. That is, `$HOME`, `%USERPROFILE%`, `$MKLROOT`, etc. have no meaning to the Meson filesystem module.\nIf needed, pass such variables into Meson via command line options in `meson.options`, native-file or cross-file.\n\nWhere possible, symlinks and parent directory notation are resolved to an absolute path.";
    this->objectDocs["i18n_module"] = "This module provides internationalisation and localisation functionality.";
    this->objectDocs["gnome_module"] = "This module provides helper tools for build operations needed when building Gnome/GLib programs.\n\n**Note:** the compilation commands here might not work properly when you change the source files.\nThis is a bug in the respective compilers which do not expose the required dependency information. This has been reported upstream in [this bug](https://bugzilla.gnome.org/show_bug.cgi?id=745754). Until this is fixed you need to be careful when changing your source files.";
    this->objectDocs["rust_module"] = "The rust module provides helper to integrate rust code into Meson.\nThe goal is to make using rust in Meson more pleasant, while still remaining mesonic, this means that it attempts to make Rust work more like Meson, rather than Meson work more like rust.";
    this->objectDocs["python_module"] = "This module provides support for finding and building extensions against python installations, be they python 2 or 3.";
    this->objectDocs["python_installation"] = "The `python_installation` object is an `external_program`, with several added methods.";
    this->objectDocs["python3_module"] = "This module provides support for dealing with Python 3. It has the following methods.\n\nThis module is deprecated and replaced by the python module.";
    this->objectDocs["pkgconfig_module"] = "This module is a simple generator for [pkg-config](https://www.freedesktop.org/wiki/Software/pkg-config/) files.";
    this->objectDocs["keyval_module"] = "This module parses files consisting of a series of `key=value` lines. One use of this module is to load kconfig configurations in Meson projects.\n\n**Note:** this does not provide kconfig frontend tooling to generate a configuration. You still need something such as kconfig frontends (see link below) to parse your Kconfig files, and then (after you've chosen the configuration options), output a \".config\" file.";
    this->objectDocs["dlang_module"] = "This module provides tools related to the D programming language.";
    this->objectDocs["external_project_module"] = "*This is an experimental module, API could change.*\n\nThis module allows building code that uses build systems other than Meson. This module is intended to be used to build Autotools subprojects as fallback if the dependency couldn't be found on the system (e.g. too old distro version).\n\nThe project will be compiled out-of-tree inside Meson's build directory. The project will also be installed inside Meson's build directory using make's `DESTDIR` feature. During project installation step, that `DESTDIR` will be copied verbatim into the desired location.\n\nExternal subprojects can use libraries built by Meson (main project, or other subprojects) using pkg-config, thanks to `*-uninstalled.pc` files generated by `pkg.generate()`.\n\nExternal build system requirements:\n\n- Must support out-of-tree build. The configure script will be invoked with the current workdir inside Meson's build directory and not subproject's top source directory.\n- Configure script must generate a `Makefile` in the current workdir.\n- Configure script must take common directories like prefix, libdir, etc, as command line arguments.\n- Configure script must support common environment variable like CFLAGS, CC, etc.\n- Compilation step must detect when a reconfigure is needed, and do it transparently.\n\nKnown limitations:\n\n- Executables from external projects cannot be used uninstalled, because they would need its libraries to be installed in the final location. This is why there is no `find_program()` method.\n- The configure script must generate a `Makefile`, other build systems are not yet supported.\n- When cross compiling, if `PKG_CONFIG_SYSROOT_DIR` is set in environment or `sys_root` in the cross file properties, the external subproject will not be able to find dependencies built by Meson using pkg-config. The reason is pkg-config and pkgconf both prepend the sysroot path to `-I` and `-L` arguments from `-uninstalled.pc` files. This is arguably a bug that could be fixed in future version of pkg-config/pkgconf.";
    this->objectDocs["hotdoc_module"] = "This module provides helper functions for generating documentation using hotdoc.";
    this->objectDocs["windows_module"] = "This module provides functionality used to build applications for Windows.";
    this->objectDocs["cuda_module"] = "This module provides helper functionality related to the CUDA Toolkit and building code using it.\n\n**Note:** This module is unstable. It is only provided as a technology preview. Its API may change in arbitrary ways between releases or it might be removed from Meson altogether.";
    this->objectDocs["icestorm_module"] = "This module provides an experimental method to create FPGA bitstreams using the IceStorm suite of tools.\n\n**Note:** This module is unstable. It is only provided as a technology preview. Its API may change in arbitrary ways between releases or it might be removed from Meson altogether.";
    this->objectDocs["qt4_module"] = "This module provides support for Qt4's `moc`, `uic` and `rcc` tools. It is used identically to the Qt 5 module.";
    this->objectDocs["qt5_module"] = "The Qt5 module provides tools to automatically deal with the various tools and steps required for Qt.";
    this->objectDocs["qt6_module"] = "The Qt6 module provides tools to automatically deal with the various tools and steps required for Qt.";
    this->objectDocs["wayland_module"] = "This module provides helper functions to find wayland protocol xmls and to generate .c and .h files using wayland-scanner\n\n**Note:** this module is unstable. It is only provided as a technology preview. Its API may change in arbitrary ways between releases or it might be removed from Meson altogether.";
    this->objectDocs["simd_module"] = "This module provides helper functionality to build code with SIMD instructions.";
    this->objectDocs["sourceset_module"] = "This module provides support for building many targets against a single set of files;\nthe choice of which files to include in each target depends on the contents of a dictionary or a `configuration_data` object.";
    this->objectDocs["sourceset"] = "The `source_set` object provides methods to add files to a source set and to query it. The source set becomes immutable after any method but `add` is called.";
    this->objectDocs["source_configuration"] = "The `source_configuration` object provides methods to query the result of an `apply` operation on a source set.";
    this->objectDocs["cmake_subproject"] = "A CMake Subproject";
    this->objectDocs["cmake_subprojectoptions"] = "Options for configuring CMake subprojects";
    this->objectDocs["cmake_tgt"] = "A CMake target";
    this->objectDocs["external_project"] = "An external project.";
    this->objectDocs["hotdoc_target"] = "A `custom_target()` with the following extra method:\n- `config_path()`: Path to the generated hotdoc configuration file.";
    this->objectDocs["java_module"] = "Provides functionality for generating JNI headers.";
}
