#pragma once
#include "lsptypes.hpp"
#include "node.hpp"
#include "type.hpp"

#include <memory>
#include <string>
#include <vector>

class InlayHintVisitor : public CodeVisitor {
public:
  InlayHintVisitor(bool removeDefaultTypesInInlayHints,
                   bool disablePosargInlayHints)
      : removeDefaultTypesInInlayHints(removeDefaultTypesInInlayHints),
        disablePosargInlayHints(disablePosargInlayHints) {}

  std::vector<InlayHint> hints;
  void visitArgumentList(ArgumentList *node) override;
  void visitArrayLiteral(ArrayLiteral *node) override;
  void visitAssignmentStatement(AssignmentStatement *node) override;
  void visitBinaryExpression(BinaryExpression *node) override;
  void visitBooleanLiteral(BooleanLiteral *node) override;
  void visitBuildDefinition(BuildDefinition *node) override;
  void visitConditionalExpression(ConditionalExpression *node) override;
  void visitDictionaryLiteral(DictionaryLiteral *node) override;
  void visitFunctionExpression(FunctionExpression *node) override;
  void visitIdExpression(IdExpression *node) override;
  void visitIntegerLiteral(IntegerLiteral *node) override;
  void visitIterationStatement(IterationStatement *node) override;
  void visitKeyValueItem(KeyValueItem *node) override;
  void visitKeywordItem(KeywordItem *node) override;
  void visitMethodExpression(MethodExpression *node) override;
  void visitSelectionStatement(SelectionStatement *node) override;
  void visitStringLiteral(StringLiteral *node) override;
  void visitSubscriptExpression(SubscriptExpression *node) override;
  void visitUnaryExpression(UnaryExpression *node) override;
  void visitErrorNode(ErrorNode *node) override;
  void visitBreakNode(BreakNode *node) override;
  void visitContinueNode(ContinueNode *node) override;

private:
  bool removeDefaultTypesInInlayHints;
  bool disablePosargInlayHints;
  void makeHint(const Node *node);
  std::string prettify(const std::vector<std::shared_ptr<Type>> &types,
                       int depth);
};
