#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 380
#define LARGE_STATE_COUNT 9
#define SYMBOL_COUNT 119
#define ALIAS_COUNT 0
#define TOKEN_COUNT 65
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 2
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 2

enum {
  anon_sym_if = 1,
  anon_sym_elif = 2,
  anon_sym_else = 3,
  anon_sym_endif = 4,
  anon_sym_foreach = 5,
  anon_sym_COLON = 6,
  anon_sym_endforeach = 7,
  anon_sym_EQ = 8,
  anon_sym_STAR_EQ = 9,
  anon_sym_SLASH_EQ = 10,
  anon_sym_PERCENT_EQ = 11,
  anon_sym_PLUS_EQ = 12,
  anon_sym_DASH_EQ = 13,
  anon_sym_break = 14,
  anon_sym_continue = 15,
  anon_sym_LPAREN = 16,
  anon_sym_RPAREN = 17,
  anon_sym_COMMA = 18,
  anon_sym_DOT = 19,
  anon_sym_LBRACK = 20,
  anon_sym_RBRACK = 21,
  anon_sym_not = 22,
  anon_sym_BANG = 23,
  anon_sym_DASH = 24,
  anon_sym_and = 25,
  anon_sym_or = 26,
  anon_sym_PLUS = 27,
  anon_sym_STAR = 28,
  anon_sym_SLASH = 29,
  anon_sym_PERCENT = 30,
  anon_sym_EQ_EQ = 31,
  anon_sym_BANG_EQ = 32,
  anon_sym_GT = 33,
  anon_sym_LT = 34,
  anon_sym_GT_EQ = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_in = 37,
  anon_sym_QMARK = 38,
  sym__DECIMAL_NUMBER = 39,
  anon_sym_0o = 40,
  anon_sym_0O = 41,
  sym__OCTAL_NUMBER = 42,
  anon_sym_0x = 43,
  anon_sym_0X = 44,
  sym__HEX_NUMBER = 45,
  anon_sym_0b = 46,
  anon_sym_0B = 47,
  sym__BINARY_NUMBER = 48,
  sym_escape_sequence = 49,
  anon_sym_SQUOTE = 50,
  aux_sym_string_simple_token1 = 51,
  anon_sym_f_SQUOTE = 52,
  anon_sym_f_SQUOTE_SQUOTE_SQUOTE = 53,
  aux_sym_string_format_multiline_token1 = 54,
  anon_sym_SQUOTE_SQUOTE = 55,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 56,
  anon_sym_true = 57,
  anon_sym_false = 58,
  anon_sym_LF = 59,
  anon_sym_CR_LF = 60,
  anon_sym_LBRACE = 61,
  anon_sym_RBRACE = 62,
  sym__IDENTIFIER = 63,
  sym__comment = 64,
  sym_source_file = 65,
  sym_build_definition = 66,
  sym_statement = 67,
  sym__statement_without = 68,
  sym_selection_statement = 69,
  sym_iteration_statement = 70,
  sym_assignment_statement = 71,
  sym_assignment_operator = 72,
  sym_jump_statement = 73,
  sym_condition = 74,
  sym_expression = 75,
  sym_function_expression = 76,
  sym_argument_list = 77,
  sym_keyword_item = 78,
  sym_key_value_item = 79,
  sym_method_expression = 80,
  sym_subscript_expression = 81,
  sym_unary_expression = 82,
  sym_binary_expression = 83,
  sym_add_operator = 84,
  sym_mult_operator = 85,
  sym_equ_operator = 86,
  sym_rel_operator = 87,
  sym_conditional_expression = 88,
  sym__literal = 89,
  sym_integer_literal = 90,
  sym__decimal_literal = 91,
  sym__octal_literal = 92,
  sym__hex_literal = 93,
  sym__binary_literal = 94,
  sym_string_literal = 95,
  sym_string_simple = 96,
  sym_string_format = 97,
  sym_string_format_simple = 98,
  sym_string_format_multiline = 99,
  sym_string_multiline = 100,
  sym_boolean_literal = 101,
  sym_array_literal = 102,
  sym__NEWLINE = 103,
  sym_dictionary_literal = 104,
  sym_identifier_list = 105,
  sym_primary_expression = 106,
  sym_function_id = 107,
  sym_keyword_arg_key = 108,
  sym_id_expression = 109,
  aux_sym_build_definition_repeat1 = 110,
  aux_sym_selection_statement_repeat1 = 111,
  aux_sym_selection_statement_repeat2 = 112,
  aux_sym_argument_list_repeat1 = 113,
  aux_sym_key_value_list_repeat1 = 114,
  aux_sym_string_simple_repeat1 = 115,
  aux_sym_string_format_multiline_repeat1 = 116,
  aux_sym_array_literal_repeat1 = 117,
  aux_sym_identifier_list_repeat1 = 118,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_if] = "if",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_endif] = "endif",
  [anon_sym_foreach] = "foreach",
  [anon_sym_COLON] = ":",
  [anon_sym_endforeach] = "endforeach",
  [anon_sym_EQ] = "=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_not] = "not",
  [anon_sym_BANG] = "!",
  [anon_sym_DASH] = "-",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_in] = "in",
  [anon_sym_QMARK] = "\?",
  [sym__DECIMAL_NUMBER] = "_DECIMAL_NUMBER",
  [anon_sym_0o] = "0o",
  [anon_sym_0O] = "0O",
  [sym__OCTAL_NUMBER] = "_OCTAL_NUMBER",
  [anon_sym_0x] = "0x",
  [anon_sym_0X] = "0X",
  [sym__HEX_NUMBER] = "_HEX_NUMBER",
  [anon_sym_0b] = "0b",
  [anon_sym_0B] = "0B",
  [sym__BINARY_NUMBER] = "_BINARY_NUMBER",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_simple_token1] = "string_simple_token1",
  [anon_sym_f_SQUOTE] = "f'",
  [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = "f'''",
  [aux_sym_string_format_multiline_token1] = "string_format_multiline_token1",
  [anon_sym_SQUOTE_SQUOTE] = "''",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LF] = "\n",
  [anon_sym_CR_LF] = "\r\n",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym__IDENTIFIER] = "_IDENTIFIER",
  [sym__comment] = "_comment",
  [sym_source_file] = "source_file",
  [sym_build_definition] = "build_definition",
  [sym_statement] = "statement",
  [sym__statement_without] = "_statement_without",
  [sym_selection_statement] = "selection_statement",
  [sym_iteration_statement] = "iteration_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_assignment_operator] = "assignment_operator",
  [sym_jump_statement] = "jump_statement",
  [sym_condition] = "condition",
  [sym_expression] = "expression",
  [sym_function_expression] = "function_expression",
  [sym_argument_list] = "argument_list",
  [sym_keyword_item] = "keyword_item",
  [sym_key_value_item] = "key_value_item",
  [sym_method_expression] = "method_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_add_operator] = "add_operator",
  [sym_mult_operator] = "mult_operator",
  [sym_equ_operator] = "equ_operator",
  [sym_rel_operator] = "rel_operator",
  [sym_conditional_expression] = "conditional_expression",
  [sym__literal] = "_literal",
  [sym_integer_literal] = "integer_literal",
  [sym__decimal_literal] = "_decimal_literal",
  [sym__octal_literal] = "_octal_literal",
  [sym__hex_literal] = "_hex_literal",
  [sym__binary_literal] = "_binary_literal",
  [sym_string_literal] = "string_literal",
  [sym_string_simple] = "string_simple",
  [sym_string_format] = "string_format",
  [sym_string_format_simple] = "string_format_simple",
  [sym_string_format_multiline] = "string_format_multiline",
  [sym_string_multiline] = "string_multiline",
  [sym_boolean_literal] = "boolean_literal",
  [sym_array_literal] = "array_literal",
  [sym__NEWLINE] = "_NEWLINE",
  [sym_dictionary_literal] = "dictionary_literal",
  [sym_identifier_list] = "identifier_list",
  [sym_primary_expression] = "primary_expression",
  [sym_function_id] = "function_id",
  [sym_keyword_arg_key] = "keyword_arg_key",
  [sym_id_expression] = "id_expression",
  [aux_sym_build_definition_repeat1] = "build_definition_repeat1",
  [aux_sym_selection_statement_repeat1] = "selection_statement_repeat1",
  [aux_sym_selection_statement_repeat2] = "selection_statement_repeat2",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_key_value_list_repeat1] = "key_value_list_repeat1",
  [aux_sym_string_simple_repeat1] = "string_simple_repeat1",
  [aux_sym_string_format_multiline_repeat1] = "string_format_multiline_repeat1",
  [aux_sym_array_literal_repeat1] = "array_literal_repeat1",
  [aux_sym_identifier_list_repeat1] = "identifier_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_endif] = anon_sym_endif,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_endforeach] = anon_sym_endforeach,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym__DECIMAL_NUMBER] = sym__DECIMAL_NUMBER,
  [anon_sym_0o] = anon_sym_0o,
  [anon_sym_0O] = anon_sym_0O,
  [sym__OCTAL_NUMBER] = sym__OCTAL_NUMBER,
  [anon_sym_0x] = anon_sym_0x,
  [anon_sym_0X] = anon_sym_0X,
  [sym__HEX_NUMBER] = sym__HEX_NUMBER,
  [anon_sym_0b] = anon_sym_0b,
  [anon_sym_0B] = anon_sym_0B,
  [sym__BINARY_NUMBER] = sym__BINARY_NUMBER,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_simple_token1] = aux_sym_string_simple_token1,
  [anon_sym_f_SQUOTE] = anon_sym_f_SQUOTE,
  [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym_string_format_multiline_token1] = aux_sym_string_format_multiline_token1,
  [anon_sym_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym__IDENTIFIER] = sym__IDENTIFIER,
  [sym__comment] = sym__comment,
  [sym_source_file] = sym_source_file,
  [sym_build_definition] = sym_build_definition,
  [sym_statement] = sym_statement,
  [sym__statement_without] = sym__statement_without,
  [sym_selection_statement] = sym_selection_statement,
  [sym_iteration_statement] = sym_iteration_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_assignment_operator] = sym_assignment_operator,
  [sym_jump_statement] = sym_jump_statement,
  [sym_condition] = sym_condition,
  [sym_expression] = sym_expression,
  [sym_function_expression] = sym_function_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_keyword_item] = sym_keyword_item,
  [sym_key_value_item] = sym_key_value_item,
  [sym_method_expression] = sym_method_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_add_operator] = sym_add_operator,
  [sym_mult_operator] = sym_mult_operator,
  [sym_equ_operator] = sym_equ_operator,
  [sym_rel_operator] = sym_rel_operator,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym__literal] = sym__literal,
  [sym_integer_literal] = sym_integer_literal,
  [sym__decimal_literal] = sym__decimal_literal,
  [sym__octal_literal] = sym__octal_literal,
  [sym__hex_literal] = sym__hex_literal,
  [sym__binary_literal] = sym__binary_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_string_simple] = sym_string_simple,
  [sym_string_format] = sym_string_format,
  [sym_string_format_simple] = sym_string_format_simple,
  [sym_string_format_multiline] = sym_string_format_multiline,
  [sym_string_multiline] = sym_string_multiline,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_array_literal] = sym_array_literal,
  [sym__NEWLINE] = sym__NEWLINE,
  [sym_dictionary_literal] = sym_dictionary_literal,
  [sym_identifier_list] = sym_identifier_list,
  [sym_primary_expression] = sym_primary_expression,
  [sym_function_id] = sym_function_id,
  [sym_keyword_arg_key] = sym_keyword_arg_key,
  [sym_id_expression] = sym_id_expression,
  [aux_sym_build_definition_repeat1] = aux_sym_build_definition_repeat1,
  [aux_sym_selection_statement_repeat1] = aux_sym_selection_statement_repeat1,
  [aux_sym_selection_statement_repeat2] = aux_sym_selection_statement_repeat2,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_key_value_list_repeat1] = aux_sym_key_value_list_repeat1,
  [aux_sym_string_simple_repeat1] = aux_sym_string_simple_repeat1,
  [aux_sym_string_format_multiline_repeat1] = aux_sym_string_format_multiline_repeat1,
  [aux_sym_array_literal_repeat1] = aux_sym_array_literal_repeat1,
  [aux_sym_identifier_list_repeat1] = aux_sym_identifier_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endforeach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym__DECIMAL_NUMBER] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_0o] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_0O] = {
    .visible = true,
    .named = false,
  },
  [sym__OCTAL_NUMBER] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_0x] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_0X] = {
    .visible = true,
    .named = false,
  },
  [sym__HEX_NUMBER] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_0b] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_0B] = {
    .visible = true,
    .named = false,
  },
  [sym__BINARY_NUMBER] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_simple_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_f_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_format_multiline_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__IDENTIFIER] = {
    .visible = false,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_build_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__statement_without] = {
    .visible = false,
    .named = true,
  },
  [sym_selection_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_iteration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_jump_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_item] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_item] = {
    .visible = true,
    .named = true,
  },
  [sym_method_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_add_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_mult_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_equ_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_rel_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__decimal_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_simple] = {
    .visible = true,
    .named = true,
  },
  [sym_string_format] = {
    .visible = true,
    .named = true,
  },
  [sym_string_format_simple] = {
    .visible = true,
    .named = true,
  },
  [sym_string_format_multiline] = {
    .visible = true,
    .named = true,
  },
  [sym_string_multiline] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__NEWLINE] = {
    .visible = false,
    .named = true,
  },
  [sym_dictionary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_id] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_arg_key] = {
    .visible = true,
    .named = true,
  },
  [sym_id_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_build_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selection_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selection_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_key_value_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_simple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_format_multiline_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_key = 1,
  field_value = 2,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_key] = "key",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_key, 0},
    {field_value, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 13,
  [15] = 12,
  [16] = 8,
  [17] = 8,
  [18] = 18,
  [19] = 11,
  [20] = 18,
  [21] = 21,
  [22] = 22,
  [23] = 10,
  [24] = 21,
  [25] = 9,
  [26] = 22,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 38,
  [41] = 38,
  [42] = 39,
  [43] = 39,
  [44] = 44,
  [45] = 45,
  [46] = 44,
  [47] = 47,
  [48] = 44,
  [49] = 49,
  [50] = 50,
  [51] = 49,
  [52] = 52,
  [53] = 50,
  [54] = 50,
  [55] = 49,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 63,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 74,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 57,
  [97] = 63,
  [98] = 74,
  [99] = 57,
  [100] = 58,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 107,
  [111] = 106,
  [112] = 106,
  [113] = 107,
  [114] = 108,
  [115] = 108,
  [116] = 116,
  [117] = 101,
  [118] = 102,
  [119] = 109,
  [120] = 101,
  [121] = 121,
  [122] = 122,
  [123] = 109,
  [124] = 124,
  [125] = 125,
  [126] = 121,
  [127] = 125,
  [128] = 102,
  [129] = 105,
  [130] = 105,
  [131] = 116,
  [132] = 132,
  [133] = 122,
  [134] = 124,
  [135] = 121,
  [136] = 104,
  [137] = 122,
  [138] = 138,
  [139] = 125,
  [140] = 124,
  [141] = 141,
  [142] = 29,
  [143] = 31,
  [144] = 35,
  [145] = 34,
  [146] = 37,
  [147] = 33,
  [148] = 32,
  [149] = 36,
  [150] = 30,
  [151] = 37,
  [152] = 30,
  [153] = 35,
  [154] = 34,
  [155] = 36,
  [156] = 156,
  [157] = 157,
  [158] = 33,
  [159] = 93,
  [160] = 32,
  [161] = 31,
  [162] = 61,
  [163] = 62,
  [164] = 66,
  [165] = 60,
  [166] = 85,
  [167] = 84,
  [168] = 82,
  [169] = 72,
  [170] = 81,
  [171] = 70,
  [172] = 94,
  [173] = 79,
  [174] = 77,
  [175] = 89,
  [176] = 88,
  [177] = 87,
  [178] = 86,
  [179] = 78,
  [180] = 73,
  [181] = 75,
  [182] = 71,
  [183] = 69,
  [184] = 68,
  [185] = 65,
  [186] = 64,
  [187] = 95,
  [188] = 80,
  [189] = 56,
  [190] = 59,
  [191] = 91,
  [192] = 90,
  [193] = 156,
  [194] = 157,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 157,
  [204] = 196,
  [205] = 199,
  [206] = 196,
  [207] = 207,
  [208] = 208,
  [209] = 156,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 141,
  [216] = 93,
  [217] = 217,
  [218] = 218,
  [219] = 78,
  [220] = 220,
  [221] = 80,
  [222] = 59,
  [223] = 223,
  [224] = 85,
  [225] = 225,
  [226] = 84,
  [227] = 225,
  [228] = 223,
  [229] = 220,
  [230] = 220,
  [231] = 225,
  [232] = 223,
  [233] = 82,
  [234] = 94,
  [235] = 72,
  [236] = 89,
  [237] = 88,
  [238] = 87,
  [239] = 86,
  [240] = 70,
  [241] = 73,
  [242] = 81,
  [243] = 71,
  [244] = 69,
  [245] = 68,
  [246] = 65,
  [247] = 64,
  [248] = 62,
  [249] = 61,
  [250] = 56,
  [251] = 60,
  [252] = 66,
  [253] = 253,
  [254] = 95,
  [255] = 90,
  [256] = 91,
  [257] = 75,
  [258] = 77,
  [259] = 79,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 268,
  [271] = 271,
  [272] = 268,
  [273] = 271,
  [274] = 274,
  [275] = 267,
  [276] = 274,
  [277] = 267,
  [278] = 274,
  [279] = 271,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 280,
  [288] = 281,
  [289] = 285,
  [290] = 284,
  [291] = 281,
  [292] = 292,
  [293] = 286,
  [294] = 282,
  [295] = 284,
  [296] = 282,
  [297] = 280,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 300,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 304,
  [307] = 304,
  [308] = 308,
  [309] = 300,
  [310] = 303,
  [311] = 311,
  [312] = 305,
  [313] = 313,
  [314] = 303,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 298,
  [321] = 313,
  [322] = 322,
  [323] = 308,
  [324] = 301,
  [325] = 313,
  [326] = 318,
  [327] = 327,
  [328] = 328,
  [329] = 198,
  [330] = 330,
  [331] = 331,
  [332] = 331,
  [333] = 208,
  [334] = 334,
  [335] = 335,
  [336] = 207,
  [337] = 330,
  [338] = 210,
  [339] = 339,
  [340] = 340,
  [341] = 331,
  [342] = 202,
  [343] = 195,
  [344] = 344,
  [345] = 201,
  [346] = 200,
  [347] = 330,
  [348] = 197,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 352,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 351,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 351,
  [363] = 354,
  [364] = 361,
  [365] = 355,
  [366] = 352,
  [367] = 354,
  [368] = 355,
  [369] = 358,
  [370] = 360,
  [371] = 360,
  [372] = 372,
  [373] = 350,
  [374] = 350,
  [375] = 375,
  [376] = 376,
  [377] = 361,
  [378] = 349,
  [379] = 358,
};

static inline bool anon_sym_BANG_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\f'
        ? (c >= '\t' && c <= '\n')
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool aux_sym_string_simple_token1_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\f'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool anon_sym_LF_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\f'
        ? c == '\t'
        : c <= '\f')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(62);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(0)
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '%') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(132);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(100);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(55)
      if (lookahead == ']') ADVANCE(86);
      if (lookahead == 'a') ADVANCE(181);
      if (lookahead == 'b') ADVANCE(189);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'e') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(166);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 'o') ADVANCE(190);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '{') ADVANCE(146);
      if (lookahead == '}') ADVANCE(147);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(115);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(117);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(116);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(45)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(45)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(46)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(46)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(7)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(7)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(145);
      if (anon_sym_LF_character_set_1(lookahead)) SKIP(7)
      if (lookahead == '\r') ADVANCE(7);
      if (lookahead == '!') ADVANCE(22);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '%') ADVANCE(104);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == '*') ADVANCE(100);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == 'a') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(47)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(47)
      if (lookahead == '\r') SKIP(8)
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(128);
      if (lookahead == '\r') ADVANCE(127);
      if (lookahead == 'U') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(40);
      if (lookahead == 'x') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (lookahead != 0) ADVANCE(127);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(49)
      if (aux_sym_string_simple_token1_character_set_1(lookahead)) ADVANCE(134);
      if (lookahead == '#') ADVANCE(135);
      if (lookahead == '\'') ADVANCE(131);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(50)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(50)
      if (lookahead == '\r') SKIP(12)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(51)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(51)
      if (lookahead == '\r') SKIP(14)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(52)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(52)
      if (lookahead == '\r') SKIP(16)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(53)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(53)
      if (lookahead == '\r') SKIP(18)
      END_STATE();
    case 20:
      if (lookahead == '\'') ADVANCE(142);
      END_STATE();
    case 21:
      if (lookahead == '\'') ADVANCE(137);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 24:
      if (lookahead == 'd') ADVANCE(93);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(30);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(64);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(68);
      END_STATE();
    case 29:
      if (lookahead == 'i') ADVANCE(27);
      if (lookahead == 's') ADVANCE(26);
      END_STATE();
    case 30:
      if (lookahead == 'i') ADVANCE(28);
      END_STATE();
    case 31:
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(127);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(45)
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\'') ADVANCE(133);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '0') ADVANCE(114);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == 'b') ADVANCE(189);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '{') ADVANCE(146);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(117);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 46:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(46)
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\'') ADVANCE(133);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '0') ADVANCE(114);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(86);
      if (lookahead == 'f') ADVANCE(149);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '{') ADVANCE(146);
      if (lookahead == '}') ADVANCE(147);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(117);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 47:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(47)
      if (lookahead == '!') ADVANCE(22);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '%') ADVANCE(103);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(99);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(101);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(9)
      if (lookahead == ']') ADVANCE(86);
      if (lookahead == 'a') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      if (lookahead == '}') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(120);
      END_STATE();
    case 48:
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(139);
      if (lookahead == '#') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead != 0) ADVANCE(140);
      END_STATE();
    case 49:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(49)
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\'') ADVANCE(131);
      if (lookahead == '\\') ADVANCE(10);
      END_STATE();
    case 50:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(50)
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(126);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 51:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(51)
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\\') SKIP(15)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 52:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(52)
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\'') ADVANCE(133);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '0') ADVANCE(114);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(17)
      if (lookahead == 'b') ADVANCE(189);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'e') ADVANCE(184);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '{') ADVANCE(146);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(117);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 53:
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(53)
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\'') ADVANCE(133);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '0') ADVANCE(114);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(19)
      if (lookahead == 'b') ADVANCE(189);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'e') ADVANCE(183);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '{') ADVANCE(146);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(117);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 54:
      if (eof) ADVANCE(62);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 55:
      if (eof) ADVANCE(62);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(54)
      END_STATE();
    case 56:
      if (eof) ADVANCE(62);
      if (lookahead == '\n') SKIP(60)
      END_STATE();
    case 57:
      if (eof) ADVANCE(62);
      if (lookahead == '\n') SKIP(60)
      if (lookahead == '\r') SKIP(56)
      END_STATE();
    case 58:
      if (eof) ADVANCE(62);
      if (lookahead == '\n') SKIP(61)
      END_STATE();
    case 59:
      if (eof) ADVANCE(62);
      if (lookahead == '\n') SKIP(61)
      if (lookahead == '\r') SKIP(58)
      END_STATE();
    case 60:
      if (eof) ADVANCE(62);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(60)
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\'') ADVANCE(133);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '0') ADVANCE(114);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(57)
      if (lookahead == 'b') ADVANCE(189);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '{') ADVANCE(146);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(117);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 61:
      if (eof) ADVANCE(62);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(61)
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '%') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(133);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == '*') ADVANCE(100);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == '0') ADVANCE(114);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(59)
      if (lookahead == 'a') ADVANCE(181);
      if (lookahead == 'b') ADVANCE(189);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(166);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 'o') ADVANCE(190);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '{') ADVANCE(146);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(117);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_elif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_endif);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_endif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_foreach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_endforeach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_break);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_continue);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(74);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(75);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym__DECIMAL_NUMBER);
      if (lookahead == 'B') ADVANCE(125);
      if (lookahead == 'O') ADVANCE(119);
      if (lookahead == 'X') ADVANCE(122);
      if (lookahead == 'b') ADVANCE(124);
      if (lookahead == 'o') ADVANCE(118);
      if (lookahead == 'x') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(117);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym__DECIMAL_NUMBER);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(115);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(117);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(116);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym__DECIMAL_NUMBER);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym__DECIMAL_NUMBER);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(117);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_0o);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_0O);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym__OCTAL_NUMBER);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(120);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_0x);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_0X);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym__HEX_NUMBER);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_0b);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_0B);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym__BINARY_NUMBER);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(10);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(141);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(20);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_string_simple_token1);
      if (aux_sym_string_simple_token1_character_set_1(lookahead)) ADVANCE(134);
      if (lookahead == '#') ADVANCE(135);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(135);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_string_simple_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_f_SQUOTE);
      if (lookahead == '\'') ADVANCE(21);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_f_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_string_format_multiline_token1);
      if (lookahead == '\n') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_string_format_multiline_token1);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(139);
      if (lookahead == '#') ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(140);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_string_format_multiline_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      if (lookahead == '\'') ADVANCE(142);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(145);
      if (lookahead == '\r') ADVANCE(7);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == '\'') ADVANCE(136);
      if (lookahead == 'a') ADVANCE(180);
      if (lookahead == 'o') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == '\'') ADVANCE(136);
      if (lookahead == 'a') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'a') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'a') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'a') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'c') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'c') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'd') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'd') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'd') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'd') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'e') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'e') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'e') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'e') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'e') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'e') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'e') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'f') ADVANCE(63);
      if (lookahead == 'n') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'f') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'f') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'f') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'f') ADVANCE(188);
      if (lookahead == 'i') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'f') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'h') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'h') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == 's') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'i') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'i') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'k') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'l') ADVANCE(174);
      if (lookahead == 'n') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'l') ADVANCE(174);
      if (lookahead == 'n') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'l') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'n') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'n') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'n') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'n') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'o') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'o') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'o') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'r') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'r') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'r') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'r') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'r') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 's') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 't') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 't') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'u') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (lookahead == 'u') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym__IDENTIFIER);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(200);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 60},
  [2] = {.lex_state = 45},
  [3] = {.lex_state = 45},
  [4] = {.lex_state = 45},
  [5] = {.lex_state = 45},
  [6] = {.lex_state = 45},
  [7] = {.lex_state = 45},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 52},
  [10] = {.lex_state = 53},
  [11] = {.lex_state = 53},
  [12] = {.lex_state = 53},
  [13] = {.lex_state = 53},
  [14] = {.lex_state = 53},
  [15] = {.lex_state = 53},
  [16] = {.lex_state = 53},
  [17] = {.lex_state = 52},
  [18] = {.lex_state = 52},
  [19] = {.lex_state = 53},
  [20] = {.lex_state = 52},
  [21] = {.lex_state = 53},
  [22] = {.lex_state = 53},
  [23] = {.lex_state = 53},
  [24] = {.lex_state = 53},
  [25] = {.lex_state = 52},
  [26] = {.lex_state = 53},
  [27] = {.lex_state = 60},
  [28] = {.lex_state = 60},
  [29] = {.lex_state = 61},
  [30] = {.lex_state = 61},
  [31] = {.lex_state = 61},
  [32] = {.lex_state = 61},
  [33] = {.lex_state = 61},
  [34] = {.lex_state = 61},
  [35] = {.lex_state = 61},
  [36] = {.lex_state = 61},
  [37] = {.lex_state = 61},
  [38] = {.lex_state = 46},
  [39] = {.lex_state = 46},
  [40] = {.lex_state = 46},
  [41] = {.lex_state = 46},
  [42] = {.lex_state = 46},
  [43] = {.lex_state = 46},
  [44] = {.lex_state = 46},
  [45] = {.lex_state = 46},
  [46] = {.lex_state = 46},
  [47] = {.lex_state = 46},
  [48] = {.lex_state = 46},
  [49] = {.lex_state = 46},
  [50] = {.lex_state = 46},
  [51] = {.lex_state = 46},
  [52] = {.lex_state = 46},
  [53] = {.lex_state = 46},
  [54] = {.lex_state = 46},
  [55] = {.lex_state = 46},
  [56] = {.lex_state = 61},
  [57] = {.lex_state = 46},
  [58] = {.lex_state = 46},
  [59] = {.lex_state = 61},
  [60] = {.lex_state = 61},
  [61] = {.lex_state = 61},
  [62] = {.lex_state = 61},
  [63] = {.lex_state = 46},
  [64] = {.lex_state = 61},
  [65] = {.lex_state = 61},
  [66] = {.lex_state = 61},
  [67] = {.lex_state = 46},
  [68] = {.lex_state = 61},
  [69] = {.lex_state = 61},
  [70] = {.lex_state = 61},
  [71] = {.lex_state = 61},
  [72] = {.lex_state = 61},
  [73] = {.lex_state = 61},
  [74] = {.lex_state = 46},
  [75] = {.lex_state = 61},
  [76] = {.lex_state = 46},
  [77] = {.lex_state = 61},
  [78] = {.lex_state = 61},
  [79] = {.lex_state = 61},
  [80] = {.lex_state = 61},
  [81] = {.lex_state = 61},
  [82] = {.lex_state = 61},
  [83] = {.lex_state = 46},
  [84] = {.lex_state = 61},
  [85] = {.lex_state = 61},
  [86] = {.lex_state = 61},
  [87] = {.lex_state = 61},
  [88] = {.lex_state = 61},
  [89] = {.lex_state = 61},
  [90] = {.lex_state = 61},
  [91] = {.lex_state = 61},
  [92] = {.lex_state = 46},
  [93] = {.lex_state = 61},
  [94] = {.lex_state = 61},
  [95] = {.lex_state = 61},
  [96] = {.lex_state = 46},
  [97] = {.lex_state = 46},
  [98] = {.lex_state = 46},
  [99] = {.lex_state = 46},
  [100] = {.lex_state = 46},
  [101] = {.lex_state = 46},
  [102] = {.lex_state = 46},
  [103] = {.lex_state = 46},
  [104] = {.lex_state = 46},
  [105] = {.lex_state = 46},
  [106] = {.lex_state = 46},
  [107] = {.lex_state = 46},
  [108] = {.lex_state = 46},
  [109] = {.lex_state = 46},
  [110] = {.lex_state = 46},
  [111] = {.lex_state = 46},
  [112] = {.lex_state = 46},
  [113] = {.lex_state = 46},
  [114] = {.lex_state = 46},
  [115] = {.lex_state = 46},
  [116] = {.lex_state = 46},
  [117] = {.lex_state = 46},
  [118] = {.lex_state = 46},
  [119] = {.lex_state = 46},
  [120] = {.lex_state = 46},
  [121] = {.lex_state = 46},
  [122] = {.lex_state = 46},
  [123] = {.lex_state = 46},
  [124] = {.lex_state = 46},
  [125] = {.lex_state = 46},
  [126] = {.lex_state = 46},
  [127] = {.lex_state = 46},
  [128] = {.lex_state = 46},
  [129] = {.lex_state = 46},
  [130] = {.lex_state = 46},
  [131] = {.lex_state = 46},
  [132] = {.lex_state = 46},
  [133] = {.lex_state = 46},
  [134] = {.lex_state = 46},
  [135] = {.lex_state = 46},
  [136] = {.lex_state = 46},
  [137] = {.lex_state = 46},
  [138] = {.lex_state = 46},
  [139] = {.lex_state = 46},
  [140] = {.lex_state = 46},
  [141] = {.lex_state = 61},
  [142] = {.lex_state = 7},
  [143] = {.lex_state = 7},
  [144] = {.lex_state = 7},
  [145] = {.lex_state = 7},
  [146] = {.lex_state = 7},
  [147] = {.lex_state = 7},
  [148] = {.lex_state = 7},
  [149] = {.lex_state = 7},
  [150] = {.lex_state = 7},
  [151] = {.lex_state = 47},
  [152] = {.lex_state = 47},
  [153] = {.lex_state = 47},
  [154] = {.lex_state = 47},
  [155] = {.lex_state = 47},
  [156] = {.lex_state = 45},
  [157] = {.lex_state = 45},
  [158] = {.lex_state = 47},
  [159] = {.lex_state = 7},
  [160] = {.lex_state = 47},
  [161] = {.lex_state = 47},
  [162] = {.lex_state = 7},
  [163] = {.lex_state = 7},
  [164] = {.lex_state = 7},
  [165] = {.lex_state = 7},
  [166] = {.lex_state = 7},
  [167] = {.lex_state = 7},
  [168] = {.lex_state = 7},
  [169] = {.lex_state = 7},
  [170] = {.lex_state = 7},
  [171] = {.lex_state = 7},
  [172] = {.lex_state = 7},
  [173] = {.lex_state = 7},
  [174] = {.lex_state = 7},
  [175] = {.lex_state = 7},
  [176] = {.lex_state = 7},
  [177] = {.lex_state = 7},
  [178] = {.lex_state = 7},
  [179] = {.lex_state = 7},
  [180] = {.lex_state = 7},
  [181] = {.lex_state = 7},
  [182] = {.lex_state = 7},
  [183] = {.lex_state = 7},
  [184] = {.lex_state = 7},
  [185] = {.lex_state = 7},
  [186] = {.lex_state = 7},
  [187] = {.lex_state = 7},
  [188] = {.lex_state = 7},
  [189] = {.lex_state = 7},
  [190] = {.lex_state = 7},
  [191] = {.lex_state = 7},
  [192] = {.lex_state = 7},
  [193] = {.lex_state = 52},
  [194] = {.lex_state = 52},
  [195] = {.lex_state = 60},
  [196] = {.lex_state = 47},
  [197] = {.lex_state = 60},
  [198] = {.lex_state = 60},
  [199] = {.lex_state = 7},
  [200] = {.lex_state = 60},
  [201] = {.lex_state = 60},
  [202] = {.lex_state = 60},
  [203] = {.lex_state = 53},
  [204] = {.lex_state = 47},
  [205] = {.lex_state = 7},
  [206] = {.lex_state = 47},
  [207] = {.lex_state = 60},
  [208] = {.lex_state = 60},
  [209] = {.lex_state = 53},
  [210] = {.lex_state = 60},
  [211] = {.lex_state = 47},
  [212] = {.lex_state = 47},
  [213] = {.lex_state = 7},
  [214] = {.lex_state = 47},
  [215] = {.lex_state = 7},
  [216] = {.lex_state = 47},
  [217] = {.lex_state = 47},
  [218] = {.lex_state = 47},
  [219] = {.lex_state = 47},
  [220] = {.lex_state = 47},
  [221] = {.lex_state = 47},
  [222] = {.lex_state = 47},
  [223] = {.lex_state = 47},
  [224] = {.lex_state = 47},
  [225] = {.lex_state = 47},
  [226] = {.lex_state = 47},
  [227] = {.lex_state = 47},
  [228] = {.lex_state = 47},
  [229] = {.lex_state = 47},
  [230] = {.lex_state = 47},
  [231] = {.lex_state = 47},
  [232] = {.lex_state = 47},
  [233] = {.lex_state = 47},
  [234] = {.lex_state = 47},
  [235] = {.lex_state = 47},
  [236] = {.lex_state = 47},
  [237] = {.lex_state = 47},
  [238] = {.lex_state = 47},
  [239] = {.lex_state = 47},
  [240] = {.lex_state = 47},
  [241] = {.lex_state = 47},
  [242] = {.lex_state = 47},
  [243] = {.lex_state = 47},
  [244] = {.lex_state = 47},
  [245] = {.lex_state = 47},
  [246] = {.lex_state = 47},
  [247] = {.lex_state = 47},
  [248] = {.lex_state = 47},
  [249] = {.lex_state = 47},
  [250] = {.lex_state = 47},
  [251] = {.lex_state = 47},
  [252] = {.lex_state = 47},
  [253] = {.lex_state = 47},
  [254] = {.lex_state = 47},
  [255] = {.lex_state = 47},
  [256] = {.lex_state = 47},
  [257] = {.lex_state = 47},
  [258] = {.lex_state = 47},
  [259] = {.lex_state = 47},
  [260] = {.lex_state = 47},
  [261] = {.lex_state = 46},
  [262] = {.lex_state = 46},
  [263] = {.lex_state = 46},
  [264] = {.lex_state = 46},
  [265] = {.lex_state = 46},
  [266] = {.lex_state = 46},
  [267] = {.lex_state = 48},
  [268] = {.lex_state = 48},
  [269] = {.lex_state = 48},
  [270] = {.lex_state = 48},
  [271] = {.lex_state = 48},
  [272] = {.lex_state = 48},
  [273] = {.lex_state = 48},
  [274] = {.lex_state = 48},
  [275] = {.lex_state = 48},
  [276] = {.lex_state = 48},
  [277] = {.lex_state = 48},
  [278] = {.lex_state = 48},
  [279] = {.lex_state = 48},
  [280] = {.lex_state = 11},
  [281] = {.lex_state = 11},
  [282] = {.lex_state = 11},
  [283] = {.lex_state = 11},
  [284] = {.lex_state = 11},
  [285] = {.lex_state = 47},
  [286] = {.lex_state = 47},
  [287] = {.lex_state = 11},
  [288] = {.lex_state = 11},
  [289] = {.lex_state = 47},
  [290] = {.lex_state = 11},
  [291] = {.lex_state = 11},
  [292] = {.lex_state = 47},
  [293] = {.lex_state = 47},
  [294] = {.lex_state = 11},
  [295] = {.lex_state = 11},
  [296] = {.lex_state = 11},
  [297] = {.lex_state = 11},
  [298] = {.lex_state = 7},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 7},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 7},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 7},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 7},
  [313] = {.lex_state = 7},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 50},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 7},
  [321] = {.lex_state = 7},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 7},
  [324] = {.lex_state = 7},
  [325] = {.lex_state = 7},
  [326] = {.lex_state = 50},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 7},
  [329] = {.lex_state = 7},
  [330] = {.lex_state = 7},
  [331] = {.lex_state = 50},
  [332] = {.lex_state = 50},
  [333] = {.lex_state = 7},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 7},
  [337] = {.lex_state = 7},
  [338] = {.lex_state = 7},
  [339] = {.lex_state = 50},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 50},
  [342] = {.lex_state = 7},
  [343] = {.lex_state = 7},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 7},
  [346] = {.lex_state = 7},
  [347] = {.lex_state = 7},
  [348] = {.lex_state = 7},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 51},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 47},
  [356] = {.lex_state = 47},
  [357] = {.lex_state = 51},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 50},
  [362] = {.lex_state = 51},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 50},
  [365] = {.lex_state = 47},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 47},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 50},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_endif] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_endforeach] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym__DECIMAL_NUMBER] = ACTIONS(1),
    [sym__OCTAL_NUMBER] = ACTIONS(1),
    [sym__BINARY_NUMBER] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_f_SQUOTE] = ACTIONS(1),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym__IDENTIFIER] = ACTIONS(1),
    [sym__comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(375),
    [sym_build_definition] = STATE(372),
    [sym__statement_without] = STATE(28),
    [sym_selection_statement] = STATE(28),
    [sym_iteration_statement] = STATE(28),
    [sym_assignment_statement] = STATE(28),
    [sym_jump_statement] = STATE(28),
    [sym_expression] = STATE(29),
    [sym_function_expression] = STATE(89),
    [sym_method_expression] = STATE(89),
    [sym_subscript_expression] = STATE(89),
    [sym_unary_expression] = STATE(89),
    [sym_binary_expression] = STATE(89),
    [sym_conditional_expression] = STATE(89),
    [sym__literal] = STATE(89),
    [sym_integer_literal] = STATE(89),
    [sym__decimal_literal] = STATE(88),
    [sym__octal_literal] = STATE(88),
    [sym__hex_literal] = STATE(88),
    [sym__binary_literal] = STATE(88),
    [sym_string_literal] = STATE(89),
    [sym_string_simple] = STATE(87),
    [sym_string_format] = STATE(87),
    [sym_string_format_simple] = STATE(86),
    [sym_string_format_multiline] = STATE(86),
    [sym_string_multiline] = STATE(87),
    [sym_boolean_literal] = STATE(89),
    [sym_array_literal] = STATE(89),
    [sym_dictionary_literal] = STATE(89),
    [sym_primary_expression] = STATE(89),
    [sym_function_id] = STATE(371),
    [sym_id_expression] = STATE(78),
    [aux_sym_build_definition_repeat1] = STATE(28),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(7),
    [anon_sym_foreach] = ACTIONS(9),
    [anon_sym_break] = ACTIONS(11),
    [anon_sym_continue] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LBRACK] = ACTIONS(15),
    [anon_sym_not] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [sym__DECIMAL_NUMBER] = ACTIONS(21),
    [anon_sym_0o] = ACTIONS(23),
    [anon_sym_0O] = ACTIONS(23),
    [anon_sym_0x] = ACTIONS(25),
    [anon_sym_0X] = ACTIONS(25),
    [anon_sym_0b] = ACTIONS(27),
    [anon_sym_0B] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_f_SQUOTE] = ACTIONS(31),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(37),
    [anon_sym_false] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [sym__IDENTIFIER] = ACTIONS(41),
    [sym__comment] = ACTIONS(43),
  },
  [2] = {
    [sym_statement] = STATE(8),
    [sym__statement_without] = STATE(313),
    [sym_selection_statement] = STATE(313),
    [sym_iteration_statement] = STATE(313),
    [sym_assignment_statement] = STATE(313),
    [sym_jump_statement] = STATE(313),
    [sym_expression] = STATE(142),
    [sym_function_expression] = STATE(175),
    [sym_method_expression] = STATE(175),
    [sym_subscript_expression] = STATE(175),
    [sym_unary_expression] = STATE(175),
    [sym_binary_expression] = STATE(175),
    [sym_conditional_expression] = STATE(175),
    [sym__literal] = STATE(175),
    [sym_integer_literal] = STATE(175),
    [sym__decimal_literal] = STATE(176),
    [sym__octal_literal] = STATE(176),
    [sym__hex_literal] = STATE(176),
    [sym__binary_literal] = STATE(176),
    [sym_string_literal] = STATE(175),
    [sym_string_simple] = STATE(177),
    [sym_string_format] = STATE(177),
    [sym_string_format_simple] = STATE(178),
    [sym_string_format_multiline] = STATE(178),
    [sym_string_multiline] = STATE(177),
    [sym_boolean_literal] = STATE(175),
    [sym_array_literal] = STATE(175),
    [sym_dictionary_literal] = STATE(175),
    [sym_primary_expression] = STATE(175),
    [sym_function_id] = STATE(360),
    [sym_id_expression] = STATE(179),
    [aux_sym_selection_statement_repeat1] = STATE(8),
    [aux_sym_selection_statement_repeat2] = STATE(293),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_elif] = ACTIONS(47),
    [anon_sym_else] = ACTIONS(49),
    [anon_sym_endif] = ACTIONS(51),
    [anon_sym_foreach] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [sym__DECIMAL_NUMBER] = ACTIONS(65),
    [anon_sym_0o] = ACTIONS(67),
    [anon_sym_0O] = ACTIONS(67),
    [anon_sym_0x] = ACTIONS(69),
    [anon_sym_0X] = ACTIONS(69),
    [anon_sym_0b] = ACTIONS(71),
    [anon_sym_0B] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_f_SQUOTE] = ACTIONS(75),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [sym__IDENTIFIER] = ACTIONS(85),
    [sym__comment] = ACTIONS(87),
  },
  [3] = {
    [sym_statement] = STATE(4),
    [sym__statement_without] = STATE(313),
    [sym_selection_statement] = STATE(313),
    [sym_iteration_statement] = STATE(313),
    [sym_assignment_statement] = STATE(313),
    [sym_jump_statement] = STATE(313),
    [sym_expression] = STATE(142),
    [sym_function_expression] = STATE(175),
    [sym_method_expression] = STATE(175),
    [sym_subscript_expression] = STATE(175),
    [sym_unary_expression] = STATE(175),
    [sym_binary_expression] = STATE(175),
    [sym_conditional_expression] = STATE(175),
    [sym__literal] = STATE(175),
    [sym_integer_literal] = STATE(175),
    [sym__decimal_literal] = STATE(176),
    [sym__octal_literal] = STATE(176),
    [sym__hex_literal] = STATE(176),
    [sym__binary_literal] = STATE(176),
    [sym_string_literal] = STATE(175),
    [sym_string_simple] = STATE(177),
    [sym_string_format] = STATE(177),
    [sym_string_format_simple] = STATE(178),
    [sym_string_format_multiline] = STATE(178),
    [sym_string_multiline] = STATE(177),
    [sym_boolean_literal] = STATE(175),
    [sym_array_literal] = STATE(175),
    [sym_dictionary_literal] = STATE(175),
    [sym_primary_expression] = STATE(175),
    [sym_function_id] = STATE(360),
    [sym_id_expression] = STATE(179),
    [aux_sym_selection_statement_repeat1] = STATE(4),
    [aux_sym_selection_statement_repeat2] = STATE(289),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_elif] = ACTIONS(47),
    [anon_sym_else] = ACTIONS(89),
    [anon_sym_endif] = ACTIONS(91),
    [anon_sym_foreach] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [sym__DECIMAL_NUMBER] = ACTIONS(65),
    [anon_sym_0o] = ACTIONS(67),
    [anon_sym_0O] = ACTIONS(67),
    [anon_sym_0x] = ACTIONS(69),
    [anon_sym_0X] = ACTIONS(69),
    [anon_sym_0b] = ACTIONS(71),
    [anon_sym_0B] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_f_SQUOTE] = ACTIONS(75),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [sym__IDENTIFIER] = ACTIONS(85),
    [sym__comment] = ACTIONS(87),
  },
  [4] = {
    [sym_statement] = STATE(8),
    [sym__statement_without] = STATE(313),
    [sym_selection_statement] = STATE(313),
    [sym_iteration_statement] = STATE(313),
    [sym_assignment_statement] = STATE(313),
    [sym_jump_statement] = STATE(313),
    [sym_expression] = STATE(142),
    [sym_function_expression] = STATE(175),
    [sym_method_expression] = STATE(175),
    [sym_subscript_expression] = STATE(175),
    [sym_unary_expression] = STATE(175),
    [sym_binary_expression] = STATE(175),
    [sym_conditional_expression] = STATE(175),
    [sym__literal] = STATE(175),
    [sym_integer_literal] = STATE(175),
    [sym__decimal_literal] = STATE(176),
    [sym__octal_literal] = STATE(176),
    [sym__hex_literal] = STATE(176),
    [sym__binary_literal] = STATE(176),
    [sym_string_literal] = STATE(175),
    [sym_string_simple] = STATE(177),
    [sym_string_format] = STATE(177),
    [sym_string_format_simple] = STATE(178),
    [sym_string_format_multiline] = STATE(178),
    [sym_string_multiline] = STATE(177),
    [sym_boolean_literal] = STATE(175),
    [sym_array_literal] = STATE(175),
    [sym_dictionary_literal] = STATE(175),
    [sym_primary_expression] = STATE(175),
    [sym_function_id] = STATE(360),
    [sym_id_expression] = STATE(179),
    [aux_sym_selection_statement_repeat1] = STATE(8),
    [aux_sym_selection_statement_repeat2] = STATE(286),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_elif] = ACTIONS(47),
    [anon_sym_else] = ACTIONS(93),
    [anon_sym_endif] = ACTIONS(95),
    [anon_sym_foreach] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [sym__DECIMAL_NUMBER] = ACTIONS(65),
    [anon_sym_0o] = ACTIONS(67),
    [anon_sym_0O] = ACTIONS(67),
    [anon_sym_0x] = ACTIONS(69),
    [anon_sym_0X] = ACTIONS(69),
    [anon_sym_0b] = ACTIONS(71),
    [anon_sym_0B] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_f_SQUOTE] = ACTIONS(75),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [sym__IDENTIFIER] = ACTIONS(85),
    [sym__comment] = ACTIONS(87),
  },
  [5] = {
    [sym_statement] = STATE(2),
    [sym__statement_without] = STATE(313),
    [sym_selection_statement] = STATE(313),
    [sym_iteration_statement] = STATE(313),
    [sym_assignment_statement] = STATE(313),
    [sym_jump_statement] = STATE(313),
    [sym_expression] = STATE(142),
    [sym_function_expression] = STATE(175),
    [sym_method_expression] = STATE(175),
    [sym_subscript_expression] = STATE(175),
    [sym_unary_expression] = STATE(175),
    [sym_binary_expression] = STATE(175),
    [sym_conditional_expression] = STATE(175),
    [sym__literal] = STATE(175),
    [sym_integer_literal] = STATE(175),
    [sym__decimal_literal] = STATE(176),
    [sym__octal_literal] = STATE(176),
    [sym__hex_literal] = STATE(176),
    [sym__binary_literal] = STATE(176),
    [sym_string_literal] = STATE(175),
    [sym_string_simple] = STATE(177),
    [sym_string_format] = STATE(177),
    [sym_string_format_simple] = STATE(178),
    [sym_string_format_multiline] = STATE(178),
    [sym_string_multiline] = STATE(177),
    [sym_boolean_literal] = STATE(175),
    [sym_array_literal] = STATE(175),
    [sym_dictionary_literal] = STATE(175),
    [sym_primary_expression] = STATE(175),
    [sym_function_id] = STATE(360),
    [sym_id_expression] = STATE(179),
    [aux_sym_selection_statement_repeat1] = STATE(2),
    [aux_sym_selection_statement_repeat2] = STATE(285),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_elif] = ACTIONS(47),
    [anon_sym_else] = ACTIONS(97),
    [anon_sym_endif] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [sym__DECIMAL_NUMBER] = ACTIONS(65),
    [anon_sym_0o] = ACTIONS(67),
    [anon_sym_0O] = ACTIONS(67),
    [anon_sym_0x] = ACTIONS(69),
    [anon_sym_0X] = ACTIONS(69),
    [anon_sym_0b] = ACTIONS(71),
    [anon_sym_0B] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_f_SQUOTE] = ACTIONS(75),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [sym__IDENTIFIER] = ACTIONS(85),
    [sym__comment] = ACTIONS(87),
  },
  [6] = {
    [sym_statement] = STATE(7),
    [sym__statement_without] = STATE(313),
    [sym_selection_statement] = STATE(313),
    [sym_iteration_statement] = STATE(313),
    [sym_assignment_statement] = STATE(313),
    [sym_jump_statement] = STATE(313),
    [sym_expression] = STATE(142),
    [sym_function_expression] = STATE(175),
    [sym_method_expression] = STATE(175),
    [sym_subscript_expression] = STATE(175),
    [sym_unary_expression] = STATE(175),
    [sym_binary_expression] = STATE(175),
    [sym_conditional_expression] = STATE(175),
    [sym__literal] = STATE(175),
    [sym_integer_literal] = STATE(175),
    [sym__decimal_literal] = STATE(176),
    [sym__octal_literal] = STATE(176),
    [sym__hex_literal] = STATE(176),
    [sym__binary_literal] = STATE(176),
    [sym_string_literal] = STATE(175),
    [sym_string_simple] = STATE(177),
    [sym_string_format] = STATE(177),
    [sym_string_format_simple] = STATE(178),
    [sym_string_format_multiline] = STATE(178),
    [sym_string_multiline] = STATE(177),
    [sym_boolean_literal] = STATE(175),
    [sym_array_literal] = STATE(175),
    [sym_dictionary_literal] = STATE(175),
    [sym_primary_expression] = STATE(175),
    [sym_function_id] = STATE(360),
    [sym_id_expression] = STATE(179),
    [aux_sym_selection_statement_repeat1] = STATE(7),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_elif] = ACTIONS(101),
    [anon_sym_else] = ACTIONS(101),
    [anon_sym_endif] = ACTIONS(101),
    [anon_sym_foreach] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [sym__DECIMAL_NUMBER] = ACTIONS(65),
    [anon_sym_0o] = ACTIONS(67),
    [anon_sym_0O] = ACTIONS(67),
    [anon_sym_0x] = ACTIONS(69),
    [anon_sym_0X] = ACTIONS(69),
    [anon_sym_0b] = ACTIONS(71),
    [anon_sym_0B] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_f_SQUOTE] = ACTIONS(75),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [sym__IDENTIFIER] = ACTIONS(85),
    [sym__comment] = ACTIONS(87),
  },
  [7] = {
    [sym_statement] = STATE(8),
    [sym__statement_without] = STATE(313),
    [sym_selection_statement] = STATE(313),
    [sym_iteration_statement] = STATE(313),
    [sym_assignment_statement] = STATE(313),
    [sym_jump_statement] = STATE(313),
    [sym_expression] = STATE(142),
    [sym_function_expression] = STATE(175),
    [sym_method_expression] = STATE(175),
    [sym_subscript_expression] = STATE(175),
    [sym_unary_expression] = STATE(175),
    [sym_binary_expression] = STATE(175),
    [sym_conditional_expression] = STATE(175),
    [sym__literal] = STATE(175),
    [sym_integer_literal] = STATE(175),
    [sym__decimal_literal] = STATE(176),
    [sym__octal_literal] = STATE(176),
    [sym__hex_literal] = STATE(176),
    [sym__binary_literal] = STATE(176),
    [sym_string_literal] = STATE(175),
    [sym_string_simple] = STATE(177),
    [sym_string_format] = STATE(177),
    [sym_string_format_simple] = STATE(178),
    [sym_string_format_multiline] = STATE(178),
    [sym_string_multiline] = STATE(177),
    [sym_boolean_literal] = STATE(175),
    [sym_array_literal] = STATE(175),
    [sym_dictionary_literal] = STATE(175),
    [sym_primary_expression] = STATE(175),
    [sym_function_id] = STATE(360),
    [sym_id_expression] = STATE(179),
    [aux_sym_selection_statement_repeat1] = STATE(8),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_elif] = ACTIONS(103),
    [anon_sym_else] = ACTIONS(103),
    [anon_sym_endif] = ACTIONS(103),
    [anon_sym_foreach] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [sym__DECIMAL_NUMBER] = ACTIONS(65),
    [anon_sym_0o] = ACTIONS(67),
    [anon_sym_0O] = ACTIONS(67),
    [anon_sym_0x] = ACTIONS(69),
    [anon_sym_0X] = ACTIONS(69),
    [anon_sym_0b] = ACTIONS(71),
    [anon_sym_0B] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_f_SQUOTE] = ACTIONS(75),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [sym__IDENTIFIER] = ACTIONS(85),
    [sym__comment] = ACTIONS(87),
  },
  [8] = {
    [sym_statement] = STATE(8),
    [sym__statement_without] = STATE(313),
    [sym_selection_statement] = STATE(313),
    [sym_iteration_statement] = STATE(313),
    [sym_assignment_statement] = STATE(313),
    [sym_jump_statement] = STATE(313),
    [sym_expression] = STATE(142),
    [sym_function_expression] = STATE(175),
    [sym_method_expression] = STATE(175),
    [sym_subscript_expression] = STATE(175),
    [sym_unary_expression] = STATE(175),
    [sym_binary_expression] = STATE(175),
    [sym_conditional_expression] = STATE(175),
    [sym__literal] = STATE(175),
    [sym_integer_literal] = STATE(175),
    [sym__decimal_literal] = STATE(176),
    [sym__octal_literal] = STATE(176),
    [sym__hex_literal] = STATE(176),
    [sym__binary_literal] = STATE(176),
    [sym_string_literal] = STATE(175),
    [sym_string_simple] = STATE(177),
    [sym_string_format] = STATE(177),
    [sym_string_format_simple] = STATE(178),
    [sym_string_format_multiline] = STATE(178),
    [sym_string_multiline] = STATE(177),
    [sym_boolean_literal] = STATE(175),
    [sym_array_literal] = STATE(175),
    [sym_dictionary_literal] = STATE(175),
    [sym_primary_expression] = STATE(175),
    [sym_function_id] = STATE(360),
    [sym_id_expression] = STATE(179),
    [aux_sym_selection_statement_repeat1] = STATE(8),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_elif] = ACTIONS(108),
    [anon_sym_else] = ACTIONS(108),
    [anon_sym_endif] = ACTIONS(108),
    [anon_sym_foreach] = ACTIONS(110),
    [anon_sym_break] = ACTIONS(113),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(116),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_not] = ACTIONS(122),
    [anon_sym_BANG] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(125),
    [sym__DECIMAL_NUMBER] = ACTIONS(128),
    [anon_sym_0o] = ACTIONS(131),
    [anon_sym_0O] = ACTIONS(131),
    [anon_sym_0x] = ACTIONS(134),
    [anon_sym_0X] = ACTIONS(134),
    [anon_sym_0b] = ACTIONS(137),
    [anon_sym_0B] = ACTIONS(137),
    [anon_sym_SQUOTE] = ACTIONS(140),
    [anon_sym_f_SQUOTE] = ACTIONS(143),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(146),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(149),
    [anon_sym_true] = ACTIONS(152),
    [anon_sym_false] = ACTIONS(152),
    [anon_sym_LBRACE] = ACTIONS(155),
    [sym__IDENTIFIER] = ACTIONS(158),
    [sym__comment] = ACTIONS(161),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(164), 1,
      anon_sym_endforeach,
    ACTIONS(166), 1,
      sym__comment,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(20), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(321), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [117] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(168), 1,
      anon_sym_endif,
    ACTIONS(170), 1,
      sym__comment,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(26), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [234] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(172), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [351] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(172), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(13), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [468] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(174), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [585] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(176), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [702] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(178), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(14), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [819] = 29,
    ACTIONS(105), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_endif,
    ACTIONS(110), 1,
      anon_sym_foreach,
    ACTIONS(116), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(122), 1,
      anon_sym_not,
    ACTIONS(128), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(140), 1,
      anon_sym_SQUOTE,
    ACTIONS(143), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(146), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(158), 1,
      sym__IDENTIFIER,
    ACTIONS(180), 1,
      sym__comment,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(113), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(125), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(131), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(134), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(137), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(152), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [936] = 29,
    ACTIONS(105), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_endforeach,
    ACTIONS(110), 1,
      anon_sym_foreach,
    ACTIONS(116), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(122), 1,
      anon_sym_not,
    ACTIONS(128), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(140), 1,
      anon_sym_SQUOTE,
    ACTIONS(143), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(146), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(158), 1,
      sym__IDENTIFIER,
    ACTIONS(183), 1,
      sym__comment,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(113), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(125), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(131), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(134), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(137), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(152), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(321), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1053] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(166), 1,
      sym__comment,
    ACTIONS(186), 1,
      anon_sym_endforeach,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(321), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1170] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(178), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1287] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(166), 1,
      sym__comment,
    ACTIONS(188), 1,
      anon_sym_endforeach,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(321), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1404] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(190), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1521] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(190), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1638] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(192), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(22), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1755] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(194), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(19), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1872] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(166), 1,
      sym__comment,
    ACTIONS(196), 1,
      anon_sym_endforeach,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(18), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(321), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [1989] = 29,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_foreach,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    ACTIONS(170), 1,
      sym__comment,
    ACTIONS(194), 1,
      anon_sym_endif,
    STATE(142), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(55), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_statement,
      aux_sym_selection_statement_repeat1,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(325), 5,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [2106] = 28,
    ACTIONS(198), 1,
      ts_builtin_sym_end,
    ACTIONS(200), 1,
      anon_sym_if,
    ACTIONS(203), 1,
      anon_sym_foreach,
    ACTIONS(209), 1,
      anon_sym_LPAREN,
    ACTIONS(212), 1,
      anon_sym_LBRACK,
    ACTIONS(215), 1,
      anon_sym_not,
    ACTIONS(221), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(233), 1,
      anon_sym_SQUOTE,
    ACTIONS(236), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(239), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(242), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(248), 1,
      anon_sym_LBRACE,
    ACTIONS(251), 1,
      sym__IDENTIFIER,
    ACTIONS(254), 1,
      sym__comment,
    STATE(29), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(206), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(218), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(224), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(227), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(230), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(245), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(27), 6,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
      aux_sym_build_definition_repeat1,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [2220] = 28,
    ACTIONS(7), 1,
      anon_sym_if,
    ACTIONS(9), 1,
      anon_sym_foreach,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    ACTIONS(257), 1,
      ts_builtin_sym_end,
    ACTIONS(259), 1,
      sym__comment,
    STATE(29), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(11), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(27), 6,
      sym__statement_without,
      sym_selection_statement,
      sym_iteration_statement,
      sym_assignment_statement,
      sym_jump_statement,
      aux_sym_build_definition_repeat1,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [2334] = 20,
    ACTIONS(265), 1,
      anon_sym_EQ,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(277), 1,
      anon_sym_and,
    ACTIONS(279), 1,
      anon_sym_or,
    ACTIONS(289), 1,
      anon_sym_QMARK,
    STATE(116), 1,
      sym_assignment_operator,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(287), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
    ACTIONS(267), 5,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
    ACTIONS(263), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_BANG,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(261), 12,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [2427] = 15,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(277), 1,
      anon_sym_and,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(287), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
    ACTIONS(293), 13,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_BANG,
      anon_sym_or,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(291), 18,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [2509] = 9,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(293), 20,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(291), 22,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [2579] = 8,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(291), 22,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
    ACTIONS(293), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
  [2647] = 17,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(277), 1,
      anon_sym_and,
    ACTIONS(279), 1,
      anon_sym_or,
    ACTIONS(289), 1,
      anon_sym_QMARK,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(287), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
    ACTIONS(297), 12,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_BANG,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(295), 17,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [2733] = 11,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(293), 18,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_and,
      anon_sym_or,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(291), 20,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [2807] = 15,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(277), 1,
      anon_sym_and,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(287), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
    ACTIONS(301), 13,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_BANG,
      anon_sym_or,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(299), 18,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [2889] = 14,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_not,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(287), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
    ACTIONS(293), 14,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_BANG,
      anon_sym_and,
      anon_sym_or,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(291), 18,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [2969] = 10,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(293), 18,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_and,
      anon_sym_or,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(291), 22,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [3041] = 27,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(305), 1,
      anon_sym_RPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    STATE(211), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(299), 1,
      sym_keyword_item,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(367), 1,
      sym_argument_list,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3146] = 27,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    ACTIONS(335), 1,
      anon_sym_RPAREN,
    STATE(211), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(299), 1,
      sym_keyword_item,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(369), 1,
      sym_argument_list,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3251] = 27,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    ACTIONS(337), 1,
      anon_sym_RPAREN,
    STATE(211), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(299), 1,
      sym_keyword_item,
    STATE(354), 1,
      sym_argument_list,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3356] = 27,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    ACTIONS(339), 1,
      anon_sym_RPAREN,
    STATE(211), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(299), 1,
      sym_keyword_item,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(363), 1,
      sym_argument_list,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3461] = 27,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    ACTIONS(341), 1,
      anon_sym_RPAREN,
    STATE(211), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(299), 1,
      sym_keyword_item,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(370), 1,
      sym_function_id,
    STATE(379), 1,
      sym_argument_list,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3566] = 27,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    ACTIONS(343), 1,
      anon_sym_RPAREN,
    STATE(211), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(299), 1,
      sym_keyword_item,
    STATE(358), 1,
      sym_argument_list,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3671] = 26,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(345), 1,
      anon_sym_COMMA,
    ACTIONS(347), 1,
      anon_sym_RBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(303), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3773] = 26,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    ACTIONS(351), 1,
      anon_sym_RPAREN,
    STATE(218), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(335), 1,
      sym_keyword_item,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3875] = 26,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(353), 1,
      anon_sym_COMMA,
    ACTIONS(355), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(314), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [3977] = 26,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    ACTIONS(357), 1,
      anon_sym_RPAREN,
    STATE(218), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(335), 1,
      sym_keyword_item,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4079] = 26,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(359), 1,
      anon_sym_COMMA,
    ACTIONS(361), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(310), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4181] = 25,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(363), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(344), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4280] = 25,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(365), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(344), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4379] = 25,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(367), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(344), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4478] = 25,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      sym__IDENTIFIER,
    STATE(218), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(335), 1,
      sym_keyword_item,
    STATE(359), 1,
      sym_keyword_arg_key,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4577] = 25,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(369), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(344), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4676] = 25,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(371), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(344), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4775] = 25,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(373), 1,
      anon_sym_RBRACE,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(344), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [4874] = 2,
    ACTIONS(377), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(375), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [4926] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(379), 1,
      anon_sym_RBRACK,
    STATE(196), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [5022] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(179), 1,
      sym_id_expression,
    STATE(213), 1,
      sym_expression,
    STATE(323), 1,
      sym_condition,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [5118] = 2,
    ACTIONS(383), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(381), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5170] = 2,
    ACTIONS(387), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(385), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5222] = 2,
    ACTIONS(391), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(389), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5274] = 2,
    ACTIONS(395), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(393), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5326] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(397), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [5422] = 2,
    ACTIONS(401), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(399), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5474] = 2,
    ACTIONS(405), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(403), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5526] = 2,
    ACTIONS(409), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(407), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5578] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(253), 1,
      sym_expression,
    STATE(344), 1,
      sym_key_value_item,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [5674] = 2,
    ACTIONS(413), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(411), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5726] = 2,
    ACTIONS(417), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(415), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5778] = 2,
    ACTIONS(421), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(419), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5830] = 2,
    ACTIONS(425), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(423), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5882] = 2,
    ACTIONS(429), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(427), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5934] = 2,
    ACTIONS(433), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(431), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [5986] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(435), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [6082] = 2,
    ACTIONS(439), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(437), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6134] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(441), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [6230] = 2,
    ACTIONS(445), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(443), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6282] = 2,
    ACTIONS(449), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(447), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6334] = 2,
    ACTIONS(453), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(451), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6386] = 2,
    ACTIONS(457), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(455), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6438] = 2,
    ACTIONS(461), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(459), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6490] = 2,
    ACTIONS(465), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(463), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6542] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(467), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [6638] = 2,
    ACTIONS(471), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(469), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6690] = 2,
    ACTIONS(475), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(473), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6742] = 2,
    ACTIONS(479), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(477), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6794] = 2,
    ACTIONS(483), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(481), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6846] = 2,
    ACTIONS(487), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(485), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6898] = 2,
    ACTIONS(491), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(489), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [6950] = 2,
    ACTIONS(495), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(493), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [7002] = 2,
    ACTIONS(499), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(497), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [7054] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(179), 1,
      sym_id_expression,
    STATE(213), 1,
      sym_expression,
    STATE(328), 1,
      sym_condition,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7150] = 3,
    ACTIONS(505), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 23,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
    ACTIONS(503), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
  [7204] = 2,
    ACTIONS(509), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(507), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [7256] = 2,
    ACTIONS(513), 23,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_EQ,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(511), 24,
      ts_builtin_sym_end,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [7308] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(515), 1,
      anon_sym_RBRACK,
    STATE(206), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7404] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(517), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7500] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(519), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7596] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    ACTIONS(521), 1,
      anon_sym_RBRACK,
    STATE(204), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7692] = 24,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(179), 1,
      sym_id_expression,
    STATE(213), 1,
      sym_expression,
    STATE(308), 1,
      sym_condition,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7788] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(147), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7881] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(161), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [7974] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(217), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8067] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(179), 1,
      sym_id_expression,
    STATE(199), 1,
      sym_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8160] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(144), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8253] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(227), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8346] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(228), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8439] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(229), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8532] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(36), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8625] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(223), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8718] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(231), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8811] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(225), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8904] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(232), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [8997] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(220), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9090] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(219), 1,
      sym_id_expression,
    STATE(230), 1,
      sym_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9183] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(78), 1,
      sym_id_expression,
    STATE(141), 1,
      sym_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9276] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(33), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9369] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(31), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9462] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(155), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9555] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(158), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9648] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(32), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9741] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(152), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9834] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(149), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [9927] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(145), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10020] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(146), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10113] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(148), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10206] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(37), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10299] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(143), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10392] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(35), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10485] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(153), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10578] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(179), 1,
      sym_id_expression,
    STATE(215), 1,
      sym_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10671] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(212), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10764] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(30), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10857] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_not,
    ACTIONS(21), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(33), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__IDENTIFIER,
    STATE(34), 1,
      sym_expression,
    STATE(78), 1,
      sym_id_expression,
    STATE(371), 1,
      sym_function_id,
    ACTIONS(19), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(23), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(25), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(27), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(87), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(88), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(89), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [10950] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(160), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [11043] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(179), 1,
      sym_id_expression,
    STATE(205), 1,
      sym_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [11136] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(77), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      sym__IDENTIFIER,
    STATE(150), 1,
      sym_expression,
    STATE(179), 1,
      sym_id_expression,
    STATE(360), 1,
      sym_function_id,
    ACTIONS(63), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(67), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(69), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(71), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(81), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(178), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(177), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(176), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(175), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [11229] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(214), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [11322] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(151), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [11415] = 23,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_not,
    ACTIONS(313), 1,
      sym__DECIMAL_NUMBER,
    ACTIONS(321), 1,
      anon_sym_SQUOTE,
    ACTIONS(323), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(325), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      sym__IDENTIFIER,
    STATE(154), 1,
      sym_expression,
    STATE(219), 1,
      sym_id_expression,
    STATE(370), 1,
      sym_function_id,
    ACTIONS(311), 2,
      anon_sym_BANG,
      anon_sym_DASH,
    ACTIONS(315), 2,
      anon_sym_0o,
      anon_sym_0O,
    ACTIONS(317), 2,
      anon_sym_0x,
      anon_sym_0X,
    ACTIONS(319), 2,
      anon_sym_0b,
      anon_sym_0B,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 2,
      sym_string_format_simple,
      sym_string_format_multiline,
    STATE(238), 3,
      sym_string_simple,
      sym_string_format,
      sym_string_multiline,
    STATE(237), 4,
      sym__decimal_literal,
      sym__octal_literal,
      sym__hex_literal,
      sym__binary_literal,
    STATE(236), 13,
      sym_function_expression,
      sym_method_expression,
      sym_subscript_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_conditional_expression,
      sym__literal,
      sym_integer_literal,
      sym_string_literal,
      sym_boolean_literal,
      sym_array_literal,
      sym_dictionary_literal,
      sym_primary_expression,
  [11508] = 17,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LBRACK,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(277), 1,
      anon_sym_and,
    ACTIONS(279), 1,
      anon_sym_or,
    ACTIONS(289), 1,
      anon_sym_QMARK,
    STATE(118), 1,
      sym_add_operator,
    STATE(121), 1,
      sym_mult_operator,
    STATE(127), 1,
      sym_equ_operator,
    STATE(134), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(287), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(285), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(525), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_BANG,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(523), 12,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [11588] = 17,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    ACTIONS(537), 1,
      anon_sym_or,
    ACTIONS(541), 1,
      anon_sym_QMARK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    STATE(131), 1,
      sym_assignment_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(263), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(265), 6,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
  [11655] = 8,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(293), 22,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [11703] = 13,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(301), 11,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_or,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [11761] = 10,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(293), 18,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [11813] = 9,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(293), 20,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [11863] = 15,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    ACTIONS(537), 1,
      anon_sym_or,
    ACTIONS(541), 1,
      anon_sym_QMARK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(297), 9,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [11925] = 7,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(293), 25,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [11971] = 12,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(293), 12,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12027] = 13,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(293), 11,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_or,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12085] = 11,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(293), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(291), 14,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [12136] = 15,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(291), 7,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_or,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [12195] = 15,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(299), 7,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_or,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [12254] = 12,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(293), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(291), 12,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [12307] = 14,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(291), 8,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_and,
      anon_sym_or,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [12364] = 2,
    ACTIONS(551), 14,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_endif,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(553), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [12397] = 2,
    ACTIONS(555), 14,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_endif,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(557), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [12430] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(295), 5,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [12493] = 2,
    ACTIONS(563), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12526] = 9,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(293), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(291), 19,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [12573] = 10,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(293), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(291), 16,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [12622] = 1,
    ACTIONS(391), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12652] = 1,
    ACTIONS(395), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12682] = 1,
    ACTIONS(409), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12712] = 1,
    ACTIONS(387), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12742] = 1,
    ACTIONS(475), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12772] = 1,
    ACTIONS(471), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12802] = 1,
    ACTIONS(465), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12832] = 1,
    ACTIONS(429), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12862] = 1,
    ACTIONS(461), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12892] = 1,
    ACTIONS(421), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12922] = 1,
    ACTIONS(509), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12952] = 1,
    ACTIONS(453), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [12982] = 1,
    ACTIONS(445), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13012] = 1,
    ACTIONS(491), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13042] = 1,
    ACTIONS(487), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13072] = 1,
    ACTIONS(483), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13102] = 1,
    ACTIONS(479), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13132] = 1,
    ACTIONS(449), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13162] = 1,
    ACTIONS(433), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13192] = 1,
    ACTIONS(439), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13222] = 1,
    ACTIONS(425), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13252] = 1,
    ACTIONS(417), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13282] = 1,
    ACTIONS(413), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13312] = 1,
    ACTIONS(405), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13342] = 1,
    ACTIONS(401), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13372] = 1,
    ACTIONS(513), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13402] = 1,
    ACTIONS(457), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13432] = 1,
    ACTIONS(377), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13462] = 1,
    ACTIONS(383), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13492] = 1,
    ACTIONS(499), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13522] = 1,
    ACTIONS(495), 27,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [13552] = 2,
    ACTIONS(551), 12,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_endforeach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(553), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13583] = 2,
    ACTIONS(555), 12,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_endforeach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(557), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13614] = 2,
    ACTIONS(567), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(565), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13645] = 19,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(569), 1,
      anon_sym_COMMA,
    ACTIONS(571), 1,
      anon_sym_RBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    STATE(307), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [13710] = 2,
    ACTIONS(575), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(573), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13741] = 2,
    ACTIONS(579), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(577), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13772] = 17,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    ACTIONS(537), 1,
      anon_sym_or,
    ACTIONS(541), 1,
      anon_sym_QMARK,
    ACTIONS(583), 1,
      sym__comment,
    STATE(9), 1,
      sym__NEWLINE,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(581), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
  [13833] = 2,
    ACTIONS(587), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(585), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13864] = 2,
    ACTIONS(591), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(589), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13895] = 2,
    ACTIONS(595), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(593), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13926] = 2,
    ACTIONS(555), 12,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(557), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [13957] = 19,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(597), 1,
      anon_sym_COMMA,
    ACTIONS(599), 1,
      anon_sym_RBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    STATE(306), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14022] = 17,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    ACTIONS(537), 1,
      anon_sym_or,
    ACTIONS(541), 1,
      anon_sym_QMARK,
    ACTIONS(583), 1,
      sym__comment,
    STATE(25), 1,
      sym__NEWLINE,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(601), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
  [14083] = 19,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(603), 1,
      anon_sym_COMMA,
    ACTIONS(605), 1,
      anon_sym_RBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    STATE(304), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14148] = 2,
    ACTIONS(609), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(607), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [14179] = 2,
    ACTIONS(613), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(611), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [14210] = 2,
    ACTIONS(551), 12,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(553), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [14241] = 2,
    ACTIONS(617), 11,
      anon_sym_if,
      anon_sym_foreach,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(615), 15,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
      sym__comment,
  [14272] = 19,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(619), 1,
      anon_sym_RPAREN,
    ACTIONS(621), 1,
      anon_sym_COMMA,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    STATE(319), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14337] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(623), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14397] = 15,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    ACTIONS(537), 1,
      anon_sym_or,
    ACTIONS(541), 1,
      anon_sym_QMARK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(625), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
  [14453] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(627), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14513] = 15,
    ACTIONS(273), 1,
      anon_sym_not,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(533), 1,
      anon_sym_LBRACK,
    ACTIONS(535), 1,
      anon_sym_and,
    ACTIONS(537), 1,
      anon_sym_or,
    ACTIONS(541), 1,
      anon_sym_QMARK,
    STATE(124), 1,
      sym_rel_operator,
    STATE(125), 1,
      sym_equ_operator,
    STATE(126), 1,
      sym_mult_operator,
    STATE(128), 1,
      sym_add_operator,
    ACTIONS(275), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(539), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(525), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
    ACTIONS(285), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
  [14569] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(505), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(501), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [14603] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(629), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14663] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(631), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14723] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(449), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(447), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [14754] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(633), 1,
      anon_sym_RPAREN,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14813] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(457), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(455), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [14844] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(383), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(381), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [14875] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(635), 1,
      anon_sym_RBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [14934] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(475), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(473), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [14965] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(637), 1,
      anon_sym_COLON,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [15024] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(471), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(469), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15055] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(639), 1,
      anon_sym_COLON,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [15114] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(641), 1,
      anon_sym_RBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [15173] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(643), 1,
      anon_sym_RPAREN,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [15232] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(645), 1,
      anon_sym_RPAREN,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [15291] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(647), 1,
      anon_sym_COLON,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [15350] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_RBRACK,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [15409] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(465), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(463), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15440] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(509), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(507), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15471] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(429), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(427), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15502] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(491), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(489), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15533] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(487), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(485), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15564] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(483), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(481), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15595] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(479), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(477), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15626] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(421), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(419), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15657] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(433), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(431), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15688] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(461), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(459), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15719] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(425), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(423), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15750] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(417), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15781] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(413), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(411), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15812] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(405), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(403), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15843] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(401), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(399), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15874] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(395), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(393), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15905] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(391), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(389), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15936] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(377), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(375), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15967] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(387), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [15998] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(409), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(407), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [16029] = 17,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_not,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(559), 1,
      anon_sym_or,
    ACTIONS(561), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_COLON,
    STATE(102), 1,
      sym_add_operator,
    STATE(135), 1,
      sym_mult_operator,
    STATE(139), 1,
      sym_equ_operator,
    STATE(140), 1,
      sym_rel_operator,
    ACTIONS(283), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(287), 3,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
    ACTIONS(529), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [16088] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(513), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(511), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [16119] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(495), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(493), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [16150] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(499), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(497), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [16181] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(439), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(437), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [16212] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(445), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [16243] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(453), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(451), 21,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_RBRACE,
  [16274] = 5,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(505), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      anon_sym_COLON,
    ACTIONS(503), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(501), 18,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_DASH,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_in,
      anon_sym_QMARK,
  [16308] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(657), 7,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(655), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
  [16336] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(661), 7,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(659), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
  [16364] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(665), 7,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(663), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
  [16392] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(669), 7,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(667), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
  [16420] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(673), 7,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(671), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
  [16448] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(677), 7,
      anon_sym_not,
      sym__DECIMAL_NUMBER,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_true,
      anon_sym_false,
      sym__IDENTIFIER,
    ACTIONS(675), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_0o,
      anon_sym_0O,
      anon_sym_0x,
      anon_sym_0X,
      anon_sym_0b,
      anon_sym_0B,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACE,
  [16476] = 5,
    ACTIONS(681), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(683), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(685), 1,
      sym__comment,
    STATE(269), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(679), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16494] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(689), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(691), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(278), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(687), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16512] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(696), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(699), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(269), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(693), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16530] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(703), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(705), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(276), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(701), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16548] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(709), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(711), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(277), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(707), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16566] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(715), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(717), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(274), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(713), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16584] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(721), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(723), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(275), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(719), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16602] = 5,
    ACTIONS(681), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(725), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(269), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(679), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16620] = 5,
    ACTIONS(681), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(727), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(269), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(679), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16638] = 5,
    ACTIONS(681), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(729), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(269), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(679), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16656] = 5,
    ACTIONS(681), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(731), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(269), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(679), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16674] = 5,
    ACTIONS(681), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(733), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(269), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(679), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16692] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(737), 1,
      aux_sym_string_format_multiline_token1,
    ACTIONS(739), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(267), 1,
      aux_sym_string_format_multiline_repeat1,
    ACTIONS(735), 3,
      sym_escape_sequence,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE,
  [16710] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(741), 1,
      sym_escape_sequence,
    ACTIONS(743), 1,
      anon_sym_SQUOTE,
    ACTIONS(745), 1,
      aux_sym_string_simple_token1,
    STATE(283), 1,
      aux_sym_string_simple_repeat1,
  [16726] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(741), 1,
      sym_escape_sequence,
    ACTIONS(745), 1,
      aux_sym_string_simple_token1,
    ACTIONS(747), 1,
      anon_sym_SQUOTE,
    STATE(283), 1,
      aux_sym_string_simple_repeat1,
  [16742] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(749), 1,
      sym_escape_sequence,
    ACTIONS(751), 1,
      anon_sym_SQUOTE,
    ACTIONS(753), 1,
      aux_sym_string_simple_token1,
    STATE(287), 1,
      aux_sym_string_simple_repeat1,
  [16758] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(755), 1,
      sym_escape_sequence,
    ACTIONS(758), 1,
      anon_sym_SQUOTE,
    ACTIONS(760), 1,
      aux_sym_string_simple_token1,
    STATE(283), 1,
      aux_sym_string_simple_repeat1,
  [16774] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(763), 1,
      sym_escape_sequence,
    ACTIONS(765), 1,
      anon_sym_SQUOTE,
    ACTIONS(767), 1,
      aux_sym_string_simple_token1,
    STATE(291), 1,
      aux_sym_string_simple_repeat1,
  [16790] = 5,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(769), 1,
      anon_sym_elif,
    ACTIONS(771), 1,
      anon_sym_else,
    ACTIONS(773), 1,
      anon_sym_endif,
    STATE(292), 1,
      aux_sym_selection_statement_repeat2,
  [16806] = 5,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(769), 1,
      anon_sym_elif,
    ACTIONS(775), 1,
      anon_sym_else,
    ACTIONS(777), 1,
      anon_sym_endif,
    STATE(292), 1,
      aux_sym_selection_statement_repeat2,
  [16822] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(741), 1,
      sym_escape_sequence,
    ACTIONS(745), 1,
      aux_sym_string_simple_token1,
    ACTIONS(779), 1,
      anon_sym_SQUOTE,
    STATE(283), 1,
      aux_sym_string_simple_repeat1,
  [16838] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(741), 1,
      sym_escape_sequence,
    ACTIONS(745), 1,
      aux_sym_string_simple_token1,
    ACTIONS(781), 1,
      anon_sym_SQUOTE,
    STATE(283), 1,
      aux_sym_string_simple_repeat1,
  [16854] = 5,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(769), 1,
      anon_sym_elif,
    ACTIONS(783), 1,
      anon_sym_else,
    ACTIONS(785), 1,
      anon_sym_endif,
    STATE(292), 1,
      aux_sym_selection_statement_repeat2,
  [16870] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(787), 1,
      sym_escape_sequence,
    ACTIONS(789), 1,
      anon_sym_SQUOTE,
    ACTIONS(791), 1,
      aux_sym_string_simple_token1,
    STATE(288), 1,
      aux_sym_string_simple_repeat1,
  [16886] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(741), 1,
      sym_escape_sequence,
    ACTIONS(745), 1,
      aux_sym_string_simple_token1,
    ACTIONS(793), 1,
      anon_sym_SQUOTE,
    STATE(283), 1,
      aux_sym_string_simple_repeat1,
  [16902] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(795), 1,
      anon_sym_elif,
    STATE(292), 1,
      aux_sym_selection_statement_repeat2,
    ACTIONS(798), 2,
      anon_sym_else,
      anon_sym_endif,
  [16916] = 5,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(769), 1,
      anon_sym_elif,
    ACTIONS(800), 1,
      anon_sym_else,
    ACTIONS(802), 1,
      anon_sym_endif,
    STATE(292), 1,
      aux_sym_selection_statement_repeat2,
  [16932] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(804), 1,
      sym_escape_sequence,
    ACTIONS(806), 1,
      anon_sym_SQUOTE,
    ACTIONS(808), 1,
      aux_sym_string_simple_token1,
    STATE(297), 1,
      aux_sym_string_simple_repeat1,
  [16948] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(810), 1,
      sym_escape_sequence,
    ACTIONS(812), 1,
      anon_sym_SQUOTE,
    ACTIONS(814), 1,
      aux_sym_string_simple_token1,
    STATE(281), 1,
      aux_sym_string_simple_repeat1,
  [16964] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(816), 1,
      sym_escape_sequence,
    ACTIONS(818), 1,
      anon_sym_SQUOTE,
    ACTIONS(820), 1,
      aux_sym_string_simple_token1,
    STATE(280), 1,
      aux_sym_string_simple_repeat1,
  [16980] = 5,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(741), 1,
      sym_escape_sequence,
    ACTIONS(745), 1,
      aux_sym_string_simple_token1,
    ACTIONS(822), 1,
      anon_sym_SQUOTE,
    STATE(283), 1,
      aux_sym_string_simple_repeat1,
  [16996] = 3,
    ACTIONS(826), 1,
      sym__comment,
    STATE(23), 1,
      sym__NEWLINE,
    ACTIONS(824), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17007] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(619), 1,
      anon_sym_RPAREN,
    ACTIONS(621), 1,
      anon_sym_COMMA,
    STATE(319), 1,
      aux_sym_argument_list_repeat1,
  [17020] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(363), 1,
      anon_sym_RBRACE,
    ACTIONS(828), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym_key_value_list_repeat1,
  [17033] = 3,
    ACTIONS(826), 1,
      sym__comment,
    STATE(12), 1,
      sym__NEWLINE,
    ACTIONS(830), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17044] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(367), 1,
      anon_sym_RBRACE,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym_key_value_list_repeat1,
  [17057] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(834), 1,
      anon_sym_COMMA,
    ACTIONS(836), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      aux_sym_key_value_list_repeat1,
  [17070] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(517), 1,
      anon_sym_RBRACK,
    ACTIONS(838), 1,
      anon_sym_COMMA,
    STATE(315), 1,
      aux_sym_array_literal_repeat1,
  [17083] = 3,
    ACTIONS(826), 1,
      sym__comment,
    STATE(21), 1,
      sym__NEWLINE,
    ACTIONS(840), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17094] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(441), 1,
      anon_sym_RBRACK,
    ACTIONS(842), 1,
      anon_sym_COMMA,
    STATE(315), 1,
      aux_sym_array_literal_repeat1,
  [17107] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(397), 1,
      anon_sym_RBRACK,
    ACTIONS(844), 1,
      anon_sym_COMMA,
    STATE(315), 1,
      aux_sym_array_literal_repeat1,
  [17120] = 3,
    ACTIONS(848), 1,
      sym__comment,
    STATE(3), 1,
      sym__NEWLINE,
    ACTIONS(846), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17131] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(373), 1,
      anon_sym_RBRACE,
    ACTIONS(850), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym_key_value_list_repeat1,
  [17144] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(852), 1,
      anon_sym_COMMA,
    ACTIONS(854), 1,
      anon_sym_RBRACE,
    STATE(302), 1,
      aux_sym_key_value_list_repeat1,
  [17157] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(856), 1,
      anon_sym_COLON,
    ACTIONS(858), 1,
      anon_sym_COMMA,
    STATE(322), 1,
      aux_sym_identifier_list_repeat1,
  [17170] = 3,
    ACTIONS(826), 1,
      sym__comment,
    STATE(24), 1,
      sym__NEWLINE,
    ACTIONS(860), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17181] = 3,
    ACTIONS(848), 1,
      sym__comment,
    STATE(157), 1,
      sym__NEWLINE,
    ACTIONS(862), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17192] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(864), 1,
      anon_sym_COMMA,
    ACTIONS(866), 1,
      anon_sym_RBRACE,
    STATE(300), 1,
      aux_sym_key_value_list_repeat1,
  [17205] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(627), 1,
      anon_sym_RBRACK,
    ACTIONS(868), 1,
      anon_sym_COMMA,
    STATE(315), 1,
      aux_sym_array_literal_repeat1,
  [17218] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(871), 1,
      anon_sym_COMMA,
    ACTIONS(874), 1,
      anon_sym_RBRACE,
    STATE(316), 1,
      aux_sym_key_value_list_repeat1,
  [17231] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(858), 1,
      anon_sym_COMMA,
    ACTIONS(876), 1,
      anon_sym_COLON,
    STATE(311), 1,
      aux_sym_identifier_list_repeat1,
  [17244] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(878), 1,
      sym__IDENTIFIER,
    STATE(317), 1,
      sym_id_expression,
    STATE(349), 1,
      sym_identifier_list,
  [17257] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(351), 1,
      anon_sym_RPAREN,
    ACTIONS(880), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_argument_list_repeat1,
  [17270] = 3,
    ACTIONS(826), 1,
      sym__comment,
    STATE(10), 1,
      sym__NEWLINE,
    ACTIONS(882), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17281] = 3,
    ACTIONS(583), 1,
      sym__comment,
    STATE(194), 1,
      sym__NEWLINE,
    ACTIONS(884), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17292] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(886), 1,
      anon_sym_COLON,
    ACTIONS(888), 1,
      anon_sym_COMMA,
    STATE(322), 1,
      aux_sym_identifier_list_repeat1,
  [17305] = 3,
    ACTIONS(848), 1,
      sym__comment,
    STATE(5), 1,
      sym__NEWLINE,
    ACTIONS(891), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17316] = 3,
    ACTIONS(826), 1,
      sym__comment,
    STATE(15), 1,
      sym__NEWLINE,
    ACTIONS(893), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17327] = 3,
    ACTIONS(826), 1,
      sym__comment,
    STATE(203), 1,
      sym__NEWLINE,
    ACTIONS(895), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17338] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(878), 1,
      sym__IDENTIFIER,
    STATE(317), 1,
      sym_id_expression,
    STATE(378), 1,
      sym_identifier_list,
  [17351] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(631), 1,
      anon_sym_RPAREN,
    ACTIONS(897), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_argument_list_repeat1,
  [17364] = 3,
    ACTIONS(848), 1,
      sym__comment,
    STATE(6), 1,
      sym__NEWLINE,
    ACTIONS(900), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17375] = 1,
    ACTIONS(579), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17381] = 2,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(902), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17389] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(904), 1,
      sym__IDENTIFIER,
    STATE(373), 1,
      sym_function_id,
  [17399] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(904), 1,
      sym__IDENTIFIER,
    STATE(350), 1,
      sym_function_id,
  [17409] = 1,
    ACTIONS(613), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17415] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(886), 2,
      anon_sym_COLON,
      anon_sym_COMMA,
  [17423] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(631), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [17431] = 1,
    ACTIONS(609), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17437] = 2,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(906), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17445] = 1,
    ACTIONS(617), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17451] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(878), 1,
      sym__IDENTIFIER,
    STATE(334), 1,
      sym_id_expression,
  [17461] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(501), 2,
      anon_sym_COLON,
      anon_sym_COMMA,
  [17469] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(904), 1,
      sym__IDENTIFIER,
    STATE(374), 1,
      sym_function_id,
  [17479] = 1,
    ACTIONS(595), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17485] = 1,
    ACTIONS(567), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17491] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(874), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [17499] = 1,
    ACTIONS(591), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17505] = 1,
    ACTIONS(587), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17511] = 2,
    ACTIONS(685), 1,
      sym__comment,
    ACTIONS(908), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [17519] = 1,
    ACTIONS(575), 3,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym__comment,
  [17525] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(910), 1,
      anon_sym_COLON,
  [17532] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(912), 1,
      anon_sym_LPAREN,
  [17539] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(914), 1,
      sym__HEX_NUMBER,
  [17546] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(866), 1,
      anon_sym_RBRACE,
  [17553] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(836), 1,
      anon_sym_RBRACE,
  [17560] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(916), 1,
      anon_sym_RPAREN,
  [17567] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(918), 1,
      sym__OCTAL_NUMBER,
  [17574] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(920), 1,
      anon_sym_in,
  [17581] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(922), 1,
      sym__HEX_NUMBER,
  [17588] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(924), 1,
      anon_sym_RPAREN,
  [17595] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(926), 1,
      anon_sym_COLON,
  [17602] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(928), 1,
      anon_sym_LPAREN,
  [17609] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(930), 1,
      sym__BINARY_NUMBER,
  [17616] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(932), 1,
      sym__HEX_NUMBER,
  [17623] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(934), 1,
      anon_sym_RPAREN,
  [17630] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(936), 1,
      sym__BINARY_NUMBER,
  [17637] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(938), 1,
      sym__OCTAL_NUMBER,
  [17644] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(854), 1,
      anon_sym_RBRACE,
  [17651] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(940), 1,
      anon_sym_RPAREN,
  [17658] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(942), 1,
      sym__OCTAL_NUMBER,
  [17665] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(944), 1,
      anon_sym_RPAREN,
  [17672] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(946), 1,
      anon_sym_LPAREN,
  [17679] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(948), 1,
      anon_sym_LPAREN,
  [17686] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(950), 1,
      ts_builtin_sym_end,
  [17693] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(952), 1,
      anon_sym_LPAREN,
  [17700] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
  [17707] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(956), 1,
      ts_builtin_sym_end,
  [17714] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(505), 1,
      anon_sym_LPAREN,
  [17721] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(958), 1,
      sym__BINARY_NUMBER,
  [17728] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(960), 1,
      anon_sym_COLON,
  [17735] = 2,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(962), 1,
      anon_sym_RPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(9)] = 0,
  [SMALL_STATE(10)] = 117,
  [SMALL_STATE(11)] = 234,
  [SMALL_STATE(12)] = 351,
  [SMALL_STATE(13)] = 468,
  [SMALL_STATE(14)] = 585,
  [SMALL_STATE(15)] = 702,
  [SMALL_STATE(16)] = 819,
  [SMALL_STATE(17)] = 936,
  [SMALL_STATE(18)] = 1053,
  [SMALL_STATE(19)] = 1170,
  [SMALL_STATE(20)] = 1287,
  [SMALL_STATE(21)] = 1404,
  [SMALL_STATE(22)] = 1521,
  [SMALL_STATE(23)] = 1638,
  [SMALL_STATE(24)] = 1755,
  [SMALL_STATE(25)] = 1872,
  [SMALL_STATE(26)] = 1989,
  [SMALL_STATE(27)] = 2106,
  [SMALL_STATE(28)] = 2220,
  [SMALL_STATE(29)] = 2334,
  [SMALL_STATE(30)] = 2427,
  [SMALL_STATE(31)] = 2509,
  [SMALL_STATE(32)] = 2579,
  [SMALL_STATE(33)] = 2647,
  [SMALL_STATE(34)] = 2733,
  [SMALL_STATE(35)] = 2807,
  [SMALL_STATE(36)] = 2889,
  [SMALL_STATE(37)] = 2969,
  [SMALL_STATE(38)] = 3041,
  [SMALL_STATE(39)] = 3146,
  [SMALL_STATE(40)] = 3251,
  [SMALL_STATE(41)] = 3356,
  [SMALL_STATE(42)] = 3461,
  [SMALL_STATE(43)] = 3566,
  [SMALL_STATE(44)] = 3671,
  [SMALL_STATE(45)] = 3773,
  [SMALL_STATE(46)] = 3875,
  [SMALL_STATE(47)] = 3977,
  [SMALL_STATE(48)] = 4079,
  [SMALL_STATE(49)] = 4181,
  [SMALL_STATE(50)] = 4280,
  [SMALL_STATE(51)] = 4379,
  [SMALL_STATE(52)] = 4478,
  [SMALL_STATE(53)] = 4577,
  [SMALL_STATE(54)] = 4676,
  [SMALL_STATE(55)] = 4775,
  [SMALL_STATE(56)] = 4874,
  [SMALL_STATE(57)] = 4926,
  [SMALL_STATE(58)] = 5022,
  [SMALL_STATE(59)] = 5118,
  [SMALL_STATE(60)] = 5170,
  [SMALL_STATE(61)] = 5222,
  [SMALL_STATE(62)] = 5274,
  [SMALL_STATE(63)] = 5326,
  [SMALL_STATE(64)] = 5422,
  [SMALL_STATE(65)] = 5474,
  [SMALL_STATE(66)] = 5526,
  [SMALL_STATE(67)] = 5578,
  [SMALL_STATE(68)] = 5674,
  [SMALL_STATE(69)] = 5726,
  [SMALL_STATE(70)] = 5778,
  [SMALL_STATE(71)] = 5830,
  [SMALL_STATE(72)] = 5882,
  [SMALL_STATE(73)] = 5934,
  [SMALL_STATE(74)] = 5986,
  [SMALL_STATE(75)] = 6082,
  [SMALL_STATE(76)] = 6134,
  [SMALL_STATE(77)] = 6230,
  [SMALL_STATE(78)] = 6282,
  [SMALL_STATE(79)] = 6334,
  [SMALL_STATE(80)] = 6386,
  [SMALL_STATE(81)] = 6438,
  [SMALL_STATE(82)] = 6490,
  [SMALL_STATE(83)] = 6542,
  [SMALL_STATE(84)] = 6638,
  [SMALL_STATE(85)] = 6690,
  [SMALL_STATE(86)] = 6742,
  [SMALL_STATE(87)] = 6794,
  [SMALL_STATE(88)] = 6846,
  [SMALL_STATE(89)] = 6898,
  [SMALL_STATE(90)] = 6950,
  [SMALL_STATE(91)] = 7002,
  [SMALL_STATE(92)] = 7054,
  [SMALL_STATE(93)] = 7150,
  [SMALL_STATE(94)] = 7204,
  [SMALL_STATE(95)] = 7256,
  [SMALL_STATE(96)] = 7308,
  [SMALL_STATE(97)] = 7404,
  [SMALL_STATE(98)] = 7500,
  [SMALL_STATE(99)] = 7596,
  [SMALL_STATE(100)] = 7692,
  [SMALL_STATE(101)] = 7788,
  [SMALL_STATE(102)] = 7881,
  [SMALL_STATE(103)] = 7974,
  [SMALL_STATE(104)] = 8067,
  [SMALL_STATE(105)] = 8160,
  [SMALL_STATE(106)] = 8253,
  [SMALL_STATE(107)] = 8346,
  [SMALL_STATE(108)] = 8439,
  [SMALL_STATE(109)] = 8532,
  [SMALL_STATE(110)] = 8625,
  [SMALL_STATE(111)] = 8718,
  [SMALL_STATE(112)] = 8811,
  [SMALL_STATE(113)] = 8904,
  [SMALL_STATE(114)] = 8997,
  [SMALL_STATE(115)] = 9090,
  [SMALL_STATE(116)] = 9183,
  [SMALL_STATE(117)] = 9276,
  [SMALL_STATE(118)] = 9369,
  [SMALL_STATE(119)] = 9462,
  [SMALL_STATE(120)] = 9555,
  [SMALL_STATE(121)] = 9648,
  [SMALL_STATE(122)] = 9741,
  [SMALL_STATE(123)] = 9834,
  [SMALL_STATE(124)] = 9927,
  [SMALL_STATE(125)] = 10020,
  [SMALL_STATE(126)] = 10113,
  [SMALL_STATE(127)] = 10206,
  [SMALL_STATE(128)] = 10299,
  [SMALL_STATE(129)] = 10392,
  [SMALL_STATE(130)] = 10485,
  [SMALL_STATE(131)] = 10578,
  [SMALL_STATE(132)] = 10671,
  [SMALL_STATE(133)] = 10764,
  [SMALL_STATE(134)] = 10857,
  [SMALL_STATE(135)] = 10950,
  [SMALL_STATE(136)] = 11043,
  [SMALL_STATE(137)] = 11136,
  [SMALL_STATE(138)] = 11229,
  [SMALL_STATE(139)] = 11322,
  [SMALL_STATE(140)] = 11415,
  [SMALL_STATE(141)] = 11508,
  [SMALL_STATE(142)] = 11588,
  [SMALL_STATE(143)] = 11655,
  [SMALL_STATE(144)] = 11703,
  [SMALL_STATE(145)] = 11761,
  [SMALL_STATE(146)] = 11813,
  [SMALL_STATE(147)] = 11863,
  [SMALL_STATE(148)] = 11925,
  [SMALL_STATE(149)] = 11971,
  [SMALL_STATE(150)] = 12027,
  [SMALL_STATE(151)] = 12085,
  [SMALL_STATE(152)] = 12136,
  [SMALL_STATE(153)] = 12195,
  [SMALL_STATE(154)] = 12254,
  [SMALL_STATE(155)] = 12307,
  [SMALL_STATE(156)] = 12364,
  [SMALL_STATE(157)] = 12397,
  [SMALL_STATE(158)] = 12430,
  [SMALL_STATE(159)] = 12493,
  [SMALL_STATE(160)] = 12526,
  [SMALL_STATE(161)] = 12573,
  [SMALL_STATE(162)] = 12622,
  [SMALL_STATE(163)] = 12652,
  [SMALL_STATE(164)] = 12682,
  [SMALL_STATE(165)] = 12712,
  [SMALL_STATE(166)] = 12742,
  [SMALL_STATE(167)] = 12772,
  [SMALL_STATE(168)] = 12802,
  [SMALL_STATE(169)] = 12832,
  [SMALL_STATE(170)] = 12862,
  [SMALL_STATE(171)] = 12892,
  [SMALL_STATE(172)] = 12922,
  [SMALL_STATE(173)] = 12952,
  [SMALL_STATE(174)] = 12982,
  [SMALL_STATE(175)] = 13012,
  [SMALL_STATE(176)] = 13042,
  [SMALL_STATE(177)] = 13072,
  [SMALL_STATE(178)] = 13102,
  [SMALL_STATE(179)] = 13132,
  [SMALL_STATE(180)] = 13162,
  [SMALL_STATE(181)] = 13192,
  [SMALL_STATE(182)] = 13222,
  [SMALL_STATE(183)] = 13252,
  [SMALL_STATE(184)] = 13282,
  [SMALL_STATE(185)] = 13312,
  [SMALL_STATE(186)] = 13342,
  [SMALL_STATE(187)] = 13372,
  [SMALL_STATE(188)] = 13402,
  [SMALL_STATE(189)] = 13432,
  [SMALL_STATE(190)] = 13462,
  [SMALL_STATE(191)] = 13492,
  [SMALL_STATE(192)] = 13522,
  [SMALL_STATE(193)] = 13552,
  [SMALL_STATE(194)] = 13583,
  [SMALL_STATE(195)] = 13614,
  [SMALL_STATE(196)] = 13645,
  [SMALL_STATE(197)] = 13710,
  [SMALL_STATE(198)] = 13741,
  [SMALL_STATE(199)] = 13772,
  [SMALL_STATE(200)] = 13833,
  [SMALL_STATE(201)] = 13864,
  [SMALL_STATE(202)] = 13895,
  [SMALL_STATE(203)] = 13926,
  [SMALL_STATE(204)] = 13957,
  [SMALL_STATE(205)] = 14022,
  [SMALL_STATE(206)] = 14083,
  [SMALL_STATE(207)] = 14148,
  [SMALL_STATE(208)] = 14179,
  [SMALL_STATE(209)] = 14210,
  [SMALL_STATE(210)] = 14241,
  [SMALL_STATE(211)] = 14272,
  [SMALL_STATE(212)] = 14337,
  [SMALL_STATE(213)] = 14397,
  [SMALL_STATE(214)] = 14453,
  [SMALL_STATE(215)] = 14513,
  [SMALL_STATE(216)] = 14569,
  [SMALL_STATE(217)] = 14603,
  [SMALL_STATE(218)] = 14663,
  [SMALL_STATE(219)] = 14723,
  [SMALL_STATE(220)] = 14754,
  [SMALL_STATE(221)] = 14813,
  [SMALL_STATE(222)] = 14844,
  [SMALL_STATE(223)] = 14875,
  [SMALL_STATE(224)] = 14934,
  [SMALL_STATE(225)] = 14965,
  [SMALL_STATE(226)] = 15024,
  [SMALL_STATE(227)] = 15055,
  [SMALL_STATE(228)] = 15114,
  [SMALL_STATE(229)] = 15173,
  [SMALL_STATE(230)] = 15232,
  [SMALL_STATE(231)] = 15291,
  [SMALL_STATE(232)] = 15350,
  [SMALL_STATE(233)] = 15409,
  [SMALL_STATE(234)] = 15440,
  [SMALL_STATE(235)] = 15471,
  [SMALL_STATE(236)] = 15502,
  [SMALL_STATE(237)] = 15533,
  [SMALL_STATE(238)] = 15564,
  [SMALL_STATE(239)] = 15595,
  [SMALL_STATE(240)] = 15626,
  [SMALL_STATE(241)] = 15657,
  [SMALL_STATE(242)] = 15688,
  [SMALL_STATE(243)] = 15719,
  [SMALL_STATE(244)] = 15750,
  [SMALL_STATE(245)] = 15781,
  [SMALL_STATE(246)] = 15812,
  [SMALL_STATE(247)] = 15843,
  [SMALL_STATE(248)] = 15874,
  [SMALL_STATE(249)] = 15905,
  [SMALL_STATE(250)] = 15936,
  [SMALL_STATE(251)] = 15967,
  [SMALL_STATE(252)] = 15998,
  [SMALL_STATE(253)] = 16029,
  [SMALL_STATE(254)] = 16088,
  [SMALL_STATE(255)] = 16119,
  [SMALL_STATE(256)] = 16150,
  [SMALL_STATE(257)] = 16181,
  [SMALL_STATE(258)] = 16212,
  [SMALL_STATE(259)] = 16243,
  [SMALL_STATE(260)] = 16274,
  [SMALL_STATE(261)] = 16308,
  [SMALL_STATE(262)] = 16336,
  [SMALL_STATE(263)] = 16364,
  [SMALL_STATE(264)] = 16392,
  [SMALL_STATE(265)] = 16420,
  [SMALL_STATE(266)] = 16448,
  [SMALL_STATE(267)] = 16476,
  [SMALL_STATE(268)] = 16494,
  [SMALL_STATE(269)] = 16512,
  [SMALL_STATE(270)] = 16530,
  [SMALL_STATE(271)] = 16548,
  [SMALL_STATE(272)] = 16566,
  [SMALL_STATE(273)] = 16584,
  [SMALL_STATE(274)] = 16602,
  [SMALL_STATE(275)] = 16620,
  [SMALL_STATE(276)] = 16638,
  [SMALL_STATE(277)] = 16656,
  [SMALL_STATE(278)] = 16674,
  [SMALL_STATE(279)] = 16692,
  [SMALL_STATE(280)] = 16710,
  [SMALL_STATE(281)] = 16726,
  [SMALL_STATE(282)] = 16742,
  [SMALL_STATE(283)] = 16758,
  [SMALL_STATE(284)] = 16774,
  [SMALL_STATE(285)] = 16790,
  [SMALL_STATE(286)] = 16806,
  [SMALL_STATE(287)] = 16822,
  [SMALL_STATE(288)] = 16838,
  [SMALL_STATE(289)] = 16854,
  [SMALL_STATE(290)] = 16870,
  [SMALL_STATE(291)] = 16886,
  [SMALL_STATE(292)] = 16902,
  [SMALL_STATE(293)] = 16916,
  [SMALL_STATE(294)] = 16932,
  [SMALL_STATE(295)] = 16948,
  [SMALL_STATE(296)] = 16964,
  [SMALL_STATE(297)] = 16980,
  [SMALL_STATE(298)] = 16996,
  [SMALL_STATE(299)] = 17007,
  [SMALL_STATE(300)] = 17020,
  [SMALL_STATE(301)] = 17033,
  [SMALL_STATE(302)] = 17044,
  [SMALL_STATE(303)] = 17057,
  [SMALL_STATE(304)] = 17070,
  [SMALL_STATE(305)] = 17083,
  [SMALL_STATE(306)] = 17094,
  [SMALL_STATE(307)] = 17107,
  [SMALL_STATE(308)] = 17120,
  [SMALL_STATE(309)] = 17131,
  [SMALL_STATE(310)] = 17144,
  [SMALL_STATE(311)] = 17157,
  [SMALL_STATE(312)] = 17170,
  [SMALL_STATE(313)] = 17181,
  [SMALL_STATE(314)] = 17192,
  [SMALL_STATE(315)] = 17205,
  [SMALL_STATE(316)] = 17218,
  [SMALL_STATE(317)] = 17231,
  [SMALL_STATE(318)] = 17244,
  [SMALL_STATE(319)] = 17257,
  [SMALL_STATE(320)] = 17270,
  [SMALL_STATE(321)] = 17281,
  [SMALL_STATE(322)] = 17292,
  [SMALL_STATE(323)] = 17305,
  [SMALL_STATE(324)] = 17316,
  [SMALL_STATE(325)] = 17327,
  [SMALL_STATE(326)] = 17338,
  [SMALL_STATE(327)] = 17351,
  [SMALL_STATE(328)] = 17364,
  [SMALL_STATE(329)] = 17375,
  [SMALL_STATE(330)] = 17381,
  [SMALL_STATE(331)] = 17389,
  [SMALL_STATE(332)] = 17399,
  [SMALL_STATE(333)] = 17409,
  [SMALL_STATE(334)] = 17415,
  [SMALL_STATE(335)] = 17423,
  [SMALL_STATE(336)] = 17431,
  [SMALL_STATE(337)] = 17437,
  [SMALL_STATE(338)] = 17445,
  [SMALL_STATE(339)] = 17451,
  [SMALL_STATE(340)] = 17461,
  [SMALL_STATE(341)] = 17469,
  [SMALL_STATE(342)] = 17479,
  [SMALL_STATE(343)] = 17485,
  [SMALL_STATE(344)] = 17491,
  [SMALL_STATE(345)] = 17499,
  [SMALL_STATE(346)] = 17505,
  [SMALL_STATE(347)] = 17511,
  [SMALL_STATE(348)] = 17519,
  [SMALL_STATE(349)] = 17525,
  [SMALL_STATE(350)] = 17532,
  [SMALL_STATE(351)] = 17539,
  [SMALL_STATE(352)] = 17546,
  [SMALL_STATE(353)] = 17553,
  [SMALL_STATE(354)] = 17560,
  [SMALL_STATE(355)] = 17567,
  [SMALL_STATE(356)] = 17574,
  [SMALL_STATE(357)] = 17581,
  [SMALL_STATE(358)] = 17588,
  [SMALL_STATE(359)] = 17595,
  [SMALL_STATE(360)] = 17602,
  [SMALL_STATE(361)] = 17609,
  [SMALL_STATE(362)] = 17616,
  [SMALL_STATE(363)] = 17623,
  [SMALL_STATE(364)] = 17630,
  [SMALL_STATE(365)] = 17637,
  [SMALL_STATE(366)] = 17644,
  [SMALL_STATE(367)] = 17651,
  [SMALL_STATE(368)] = 17658,
  [SMALL_STATE(369)] = 17665,
  [SMALL_STATE(370)] = 17672,
  [SMALL_STATE(371)] = 17679,
  [SMALL_STATE(372)] = 17686,
  [SMALL_STATE(373)] = 17693,
  [SMALL_STATE(374)] = 17700,
  [SMALL_STATE(375)] = 17707,
  [SMALL_STATE(376)] = 17714,
  [SMALL_STATE(377)] = 17721,
  [SMALL_STATE(378)] = 17728,
  [SMALL_STATE(379)] = 17735,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat2, 3),
  [103] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat2, 4),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(100),
  [108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(326),
  [113] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(333),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(114),
  [119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(57),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(101),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(101),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(176),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(365),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(362),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(361),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(294),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(295),
  [146] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(268),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(279),
  [152] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(172),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(44),
  [158] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(159),
  [161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(313),
  [164] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [168] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [172] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(325),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(321),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [190] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2),
  [200] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(58),
  [203] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(318),
  [206] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(208),
  [209] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(115),
  [212] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(99),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(117),
  [218] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(117),
  [221] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(88),
  [224] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(355),
  [227] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(351),
  [230] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(364),
  [233] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(296),
  [236] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(284),
  [239] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(270),
  [242] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(271),
  [245] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(94),
  [248] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(46),
  [251] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(93),
  [254] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(27),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_build_definition, 1),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement_without, 1),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement_without, 1),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional_expression, 5),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_expression, 5),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [323] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dictionary_literal, 2),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dictionary_literal, 2),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_expression, 6),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_expression, 6),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3),
  [387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_expression, 3),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_multiline, 2),
  [391] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_multiline, 2),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_format_multiline, 2),
  [395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_format_multiline, 2),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_format_simple, 2),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_format_simple, 2),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_simple, 2),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_simple, 2),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_expression, 5),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_expression, 5),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__binary_literal, 2),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__binary_literal, 2),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__hex_literal, 2),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__hex_literal, 2),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dictionary_literal, 5),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dictionary_literal, 5),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__octal_literal, 2),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__octal_literal, 2),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 5),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 5),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 2),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 2),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 3),
  [439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 3),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 3),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 3),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 1),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 1),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_simple, 3),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_simple, 3),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 4),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_expression, 4),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_format_simple, 3),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_format_simple, 3),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_format_multiline, 3),
  [465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_format_multiline, 3),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_multiline, 3),
  [471] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_multiline, 3),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dictionary_literal, 3),
  [475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dictionary_literal, 3),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_format, 1),
  [479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_format, 1),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 1),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 1),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_literal, 1),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_integer_literal, 1),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dictionary_literal, 4),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dictionary_literal, 4),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript_expression, 4),
  [499] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript_expression, 4),
  [501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id_expression, 1),
  [503] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id_expression, 1),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_id, 1),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_literal, 1),
  [509] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_literal, 1),
  [511] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 4),
  [513] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 4),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3),
  [525] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_statement, 3),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [551] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__NEWLINE, 2),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__NEWLINE, 2),
  [555] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [563] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_id, 1),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 5),
  [567] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_selection_statement, 5),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 6),
  [575] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_selection_statement, 6),
  [577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_iteration_statement, 6),
  [579] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_iteration_statement, 6),
  [581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [583] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 9),
  [587] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_selection_statement, 9),
  [589] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 8),
  [591] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_selection_statement, 8),
  [593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_iteration_statement, 7),
  [595] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_iteration_statement, 7),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 4),
  [609] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_selection_statement, 4),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_jump_statement, 1),
  [613] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_jump_statement, 1),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 7),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_selection_statement, 7),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyword_item, 3),
  [625] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition, 1),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_literal_repeat1, 2),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value_item, 3, .production_id = 1),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyword_arg_key, 1),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rel_operator, 1),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rel_operator, 1),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equ_operator, 1),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equ_operator, 1),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rel_operator, 2),
  [665] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rel_operator, 2),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_add_operator, 1),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_add_operator, 1),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mult_operator, 1),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mult_operator, 1),
  [675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_operator, 1),
  [677] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_operator, 1),
  [679] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [683] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [685] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [687] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [693] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_format_multiline_repeat1, 2), SHIFT_REPEAT(269),
  [696] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_format_multiline_repeat1, 2), SHIFT_REPEAT(269),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_format_multiline_repeat1, 2),
  [701] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [705] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [707] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [713] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [717] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [723] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [733] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [735] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [739] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [743] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [751] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [755] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_simple_repeat1, 2), SHIFT_REPEAT(283),
  [758] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_simple_repeat1, 2),
  [760] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_simple_repeat1, 2), SHIFT_REPEAT(283),
  [763] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [765] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [779] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [781] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [787] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [789] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [793] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [795] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat2, 2), SHIFT_REPEAT(92),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat2, 2),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [804] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [806] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [810] = {.entry = {.count = 1, .reusable = false}}, SHIFT(281),
  [812] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [816] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [822] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [824] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [830] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [840] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [846] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [848] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_list, 2),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [860] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [862] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [868] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_literal_repeat1, 2), SHIFT_REPEAT(138),
  [871] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_list_repeat1, 2), SHIFT_REPEAT(67),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_key_value_list_repeat1, 2),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_list, 1),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [882] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [884] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [886] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_identifier_list_repeat1, 2),
  [888] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_identifier_list_repeat1, 2), SHIFT_REPEAT(339),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [893] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [897] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2), SHIFT_REPEAT(52),
  [900] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [902] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [906] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [908] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [956] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_meson(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
