/* DynamicNotebook.c generated by valac 0.56.18, the Vala compiler
 * generated from DynamicNotebook.vala, do not modify */

/*
 *  Copyright (C) 2011-2013 Tom Beckmann <tom@elementaryos.org>
 *
 *  This program or library is free software; you can redistribute it
 *  and/or modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General
 *  Public License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301 USA.
 */
/* a mask to ignore modifiers like num lock or caps lock that are irrelevant to keyboard shortcuts*/

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#define MODIFIER_MASK (((GDK_SHIFT_MASK | GDK_SUPER_MASK) | GDK_CONTROL_MASK) | GDK_MOD1_MASK)
#define DYNAMIC_NOTEBOOK_MAX_TAB_WIDTH 174
#define DYNAMIC_NOTEBOOK_TAB_WIDTH_PINNED 18
#define DYNAMIC_NOTEBOOK_ADD_BUTTON_PADDING 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TAB_PAGE_CONTAINER (tab_page_container_get_type ())
#define TAB_PAGE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_PAGE_CONTAINER, TabPageContainer))
#define TAB_PAGE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_PAGE_CONTAINER, TabPageContainerClass))
#define IS_TAB_PAGE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_PAGE_CONTAINER))
#define IS_TAB_PAGE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_PAGE_CONTAINER))
#define TAB_PAGE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_PAGE_CONTAINER, TabPageContainerClass))

typedef struct _TabPageContainer TabPageContainer;
typedef struct _TabPageContainerClass TabPageContainerClass;
typedef struct _TabPageContainerPrivate TabPageContainerPrivate;

#define TYPE_TAB (tab_get_type ())
#define TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB, Tab))
#define TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB, TabClass))
#define IS_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB))
#define IS_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB))
#define TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB, TabClass))

typedef struct _Tab Tab;
typedef struct _TabClass TabClass;
enum  {
	TAB_PAGE_CONTAINER_0_PROPERTY,
	TAB_PAGE_CONTAINER_TAB_PROPERTY,
	TAB_PAGE_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* tab_page_container_properties[TAB_PAGE_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TabPrivate TabPrivate;
enum  {
	TAB_0_PROPERTY,
	TAB_LABEL_PROPERTY,
	TAB_TOOLTIP_PROPERTY,
	TAB_PINNED_PROPERTY,
	TAB_PINNABLE_PROPERTY,
	TAB_RESTORE_DATA_PROPERTY,
	TAB_PAGE_PROPERTY,
	TAB_ICON_PROPERTY,
	TAB_WORKING_PROPERTY,
	TAB_ELLIPSIZE_MODE_PROPERTY,
	TAB_FIXED_PROPERTY,
	TAB_MENU_PROPERTY,
	TAB_CLOSABLE_PROPERTY,
	TAB_IS_CURRENT_TAB_PROPERTY,
	TAB_NUM_PROPERTIES
};
static GParamSpec* tab_properties[TAB_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block14Data Block14Data;
enum  {
	TAB_CLOSED_SIGNAL,
	TAB_CLOSE_OTHERS_SIGNAL,
	TAB_NEW_WINDOW_SIGNAL,
	TAB_DUPLICATE_SIGNAL,
	TAB_PIN_SWITCH_SIGNAL,
	TAB_NUM_SIGNALS
};
static guint tab_signals[TAB_NUM_SIGNALS] = {0};

#define TYPE_CLOSED_TABS (closed_tabs_get_type ())
#define CLOSED_TABS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOSED_TABS, ClosedTabs))
#define CLOSED_TABS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOSED_TABS, ClosedTabsClass))
#define IS_CLOSED_TABS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOSED_TABS))
#define IS_CLOSED_TABS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOSED_TABS))
#define CLOSED_TABS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOSED_TABS, ClosedTabsClass))

typedef struct _ClosedTabs ClosedTabs;
typedef struct _ClosedTabsClass ClosedTabsClass;
typedef struct _ClosedTabsPrivate ClosedTabsPrivate;

#define CLOSED_TABS_TYPE_ENTRY (closed_tabs_entry_get_type ())
typedef struct _ClosedTabsEntry ClosedTabsEntry;
enum  {
	CLOSED_TABS_0_PROPERTY,
	CLOSED_TABS_MAX_RESTORABLE_TABS_PROPERTY,
	CLOSED_TABS_EMPTY_PROPERTY,
	CLOSED_TABS_MENU_PROPERTY,
	CLOSED_TABS_NUM_PROPERTIES
};
static GParamSpec* closed_tabs_properties[CLOSED_TABS_NUM_PROPERTIES];
#define _closed_tabs_entry_free0(var) ((var == NULL) ? NULL : (var = (closed_tabs_entry_free (var), NULL)))
typedef struct _Block15Data Block15Data;
enum  {
	CLOSED_TABS_RESTORED_SIGNAL,
	CLOSED_TABS_CLEARED_SIGNAL,
	CLOSED_TABS_NUM_SIGNALS
};
static guint closed_tabs_signals[CLOSED_TABS_NUM_SIGNALS] = {0};

#define TYPE_DYNAMIC_NOTEBOOK (dynamic_notebook_get_type ())
#define DYNAMIC_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DYNAMIC_NOTEBOOK, DynamicNotebook))
#define DYNAMIC_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DYNAMIC_NOTEBOOK, DynamicNotebookClass))
#define IS_DYNAMIC_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DYNAMIC_NOTEBOOK))
#define IS_DYNAMIC_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DYNAMIC_NOTEBOOK))
#define DYNAMIC_NOTEBOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DYNAMIC_NOTEBOOK, DynamicNotebookClass))

typedef struct _DynamicNotebook DynamicNotebook;
typedef struct _DynamicNotebookClass DynamicNotebookClass;
typedef struct _DynamicNotebookPrivate DynamicNotebookPrivate;
typedef enum  {
	DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_ALWAYS = 0,
	DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_SINGLE = 1,
	DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_NEVER = 2
} DynamicNotebookTabBarBehavior;

#define DYNAMIC_NOTEBOOK_TYPE_TAB_BAR_BEHAVIOR (dynamic_notebook_tab_bar_behavior_get_type ())
enum  {
	DYNAMIC_NOTEBOOK_0_PROPERTY,
	DYNAMIC_NOTEBOOK_N_TABS_PROPERTY,
	DYNAMIC_NOTEBOOK_SHOW_TABS_PROPERTY,
	DYNAMIC_NOTEBOOK_SHOW_ICONS_PROPERTY,
	DYNAMIC_NOTEBOOK_TABS_CLOSABLE_PROPERTY,
	DYNAMIC_NOTEBOOK_ALLOW_DRAG_PROPERTY,
	DYNAMIC_NOTEBOOK_ALLOW_NEW_WINDOW_PROPERTY,
	DYNAMIC_NOTEBOOK_ALLOW_DUPLICATION_PROPERTY,
	DYNAMIC_NOTEBOOK_ALLOW_RESTORING_PROPERTY,
	DYNAMIC_NOTEBOOK_MAX_RESTORABLE_TABS_PROPERTY,
	DYNAMIC_NOTEBOOK_ADD_BUTTON_VISIBLE_PROPERTY,
	DYNAMIC_NOTEBOOK_ALLOW_PINNING_PROPERTY,
	DYNAMIC_NOTEBOOK_FORCE_LEFT_PROPERTY,
	DYNAMIC_NOTEBOOK_ADD_BUTTON_TOOLTIP_PROPERTY,
	DYNAMIC_NOTEBOOK_CURRENT_PROPERTY,
	DYNAMIC_NOTEBOOK_TABS_PROPERTY,
	DYNAMIC_NOTEBOOK_GROUP_NAME_PROPERTY,
	DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_PROPERTY,
	DYNAMIC_NOTEBOOK_MENU_PROPERTY,
	DYNAMIC_NOTEBOOK_NUM_PROPERTIES
};
static GParamSpec* dynamic_notebook_properties[DYNAMIC_NOTEBOOK_NUM_PROPERTIES];
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;
enum  {
	DYNAMIC_NOTEBOOK_TAB_ADDED_SIGNAL,
	DYNAMIC_NOTEBOOK_TAB_REMOVED_SIGNAL,
	DYNAMIC_NOTEBOOK_TAB_SWITCHED_SIGNAL,
	DYNAMIC_NOTEBOOK_TAB_REORDERED_SIGNAL,
	DYNAMIC_NOTEBOOK_TAB_MOVED_SIGNAL,
	DYNAMIC_NOTEBOOK_TAB_DUPLICATED_SIGNAL,
	DYNAMIC_NOTEBOOK_TAB_RESTORED_SIGNAL,
	DYNAMIC_NOTEBOOK_NEW_TAB_REQUESTED_SIGNAL,
	DYNAMIC_NOTEBOOK_CLOSE_TAB_REQUESTED_SIGNAL,
	DYNAMIC_NOTEBOOK_NUM_SIGNALS
};
static guint dynamic_notebook_signals[DYNAMIC_NOTEBOOK_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TabPageContainer {
	GtkEventBox parent_instance;
	TabPageContainerPrivate * priv;
};

struct _TabPageContainerClass {
	GtkEventBoxClass parent_class;
};

struct _TabPageContainerPrivate {
	Tab* _tab;
};

struct _Tab {
	GtkEventBox parent_instance;
	TabPrivate * priv;
	GraniteWidgetsDroppedDelegate dropped_callback;
	gpointer dropped_callback_target;
	GDestroyNotify dropped_callback_target_destroy_notify;
	TabPageContainer* page_container;
	GtkImage* _icon;
	GtkMenuItem* new_window_m;
	GtkMenuItem* duplicate_m;
	GtkMenuItem* pin_m;
};

struct _TabClass {
	GtkEventBoxClass parent_class;
};

struct _TabPrivate {
	GtkLabel* _label;
	gboolean _pinned;
	gboolean _pinnable;
	gchar* _restore_data;
	GtkSpinner* _working;
	gboolean __working;
	gboolean _fixed;
	GtkMenu* _menu;
	gboolean _closable;
	gboolean _is_current_tab;
	gboolean cursor_over_tab;
	gboolean cursor_over_close_button;
	GtkRevealer* close_button_revealer;
};

struct _Block14Data {
	int _ref_count_;
	Tab* self;
	GtkMenuItem* close_other_m;
};

struct _ClosedTabs {
	GObject parent_instance;
	ClosedTabsPrivate * priv;
};

struct _ClosedTabsClass {
	GObjectClass parent_class;
};

struct _ClosedTabsEntry {
	gchar* label;
	gchar* restore_data;
	GIcon* icon;
	GraniteWidgetsDroppedDelegate dropped_callback;
	gpointer dropped_callback_target;
};

struct _ClosedTabsPrivate {
	gint _max_restorable_tabs;
	GeeLinkedList* closed_tabs;
};

struct _Block15Data {
	int _ref_count_;
	ClosedTabs* self;
	ClosedTabsEntry* entry;
};

struct _DynamicNotebook {
	GtkEventBox parent_instance;
	DynamicNotebookPrivate * priv;
};

struct _DynamicNotebookClass {
	GtkEventBoxClass parent_class;
};

struct _DynamicNotebookPrivate {
	gboolean _show_icons;
	gboolean _tabs_closable;
	gboolean _allow_drag;
	gboolean _allow_new_window;
	gboolean _allow_duplication;
	gboolean _allow_restoring;
	gboolean _add_button_visible;
	gboolean _allow_pinning;
	gboolean _force_left;
	gchar* _add_button_tooltip;
	GList* _tabs;
	DynamicNotebookTabBarBehavior _tab_bar_behavior;
	GtkMenu* _menu;
	ClosedTabs* closed_tabs;
	GtkNotebook* notebook;
	gint tab_width;
	Tab* old_tab;
	GtkMenuItem* new_tab_m;
	GtkMenuItem* restore_tab_m;
	GtkButton* add_button;
	GtkButton* restore_button;
};

struct _Block16Data {
	int _ref_count_;
	DynamicNotebook* self;
	gboolean value;
};

struct _Block17Data {
	int _ref_count_;
	DynamicNotebook* self;
	gboolean value;
};

struct _Block18Data {
	int _ref_count_;
	DynamicNotebook* self;
	gboolean value;
};

static gint TabPageContainer_private_offset;
static gpointer tab_page_container_parent_class = NULL;
static gint Tab_private_offset;
static gpointer tab_parent_class = NULL;
static gint ClosedTabs_private_offset;
static gpointer closed_tabs_parent_class = NULL;
static gint DynamicNotebook_private_offset;
static gpointer dynamic_notebook_parent_class = NULL;

VALA_EXTERN GType tab_page_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TabPageContainer, g_object_unref)
VALA_EXTERN GType tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tab, g_object_unref)
VALA_EXTERN TabPageContainer* tab_page_container_new (Tab* tab);
VALA_EXTERN TabPageContainer* tab_page_container_construct (GType object_type,
                                                Tab* tab);
VALA_EXTERN Tab* tab_page_container_get_tab (TabPageContainer* self);
VALA_EXTERN void tab_page_container_set_tab (TabPageContainer* self,
                                 Tab* value);
static GObject * tab_page_container_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void tab_page_container_finalize (GObject * obj);
static GType tab_page_container_get_type_once (void);
static void _vala_tab_page_container_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_tab_page_container_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN Tab* tab_new (const gchar* label,
              GIcon* icon,
              GtkWidget* page);
VALA_EXTERN Tab* tab_construct (GType object_type,
                    const gchar* label,
                    GIcon* icon,
                    GtkWidget* page);
VALA_EXTERN void tab_set_page (Tab* self,
                   GtkWidget* value);
VALA_EXTERN void tab_close (Tab* self);
static void tab_update_close_button_visibility (Tab* self);
static gboolean tab_close_button_is_visible (Tab* self);
VALA_EXTERN const gchar* tab_get_label (Tab* self);
VALA_EXTERN void tab_set_label (Tab* self,
                    const gchar* value);
VALA_EXTERN gchar* tab_get_tooltip (Tab* self);
VALA_EXTERN void tab_set_tooltip (Tab* self,
                      const gchar* value);
VALA_EXTERN gboolean tab_get_pinned (Tab* self);
VALA_EXTERN void tab_set_pinned (Tab* self,
                     gboolean value);
VALA_EXTERN gboolean tab_get_pinnable (Tab* self);
VALA_EXTERN void tab_set_pinnable (Tab* self,
                       gboolean value);
VALA_EXTERN const gchar* tab_get_restore_data (Tab* self);
VALA_EXTERN void tab_set_restore_data (Tab* self,
                           const gchar* value);
VALA_EXTERN GtkWidget* tab_get_page (Tab* self);
VALA_EXTERN GIcon* tab_get_icon (Tab* self);
VALA_EXTERN void tab_set_icon (Tab* self,
                   GIcon* value);
VALA_EXTERN gboolean tab_get_working (Tab* self);
VALA_EXTERN void tab_set_working (Tab* self,
                      gboolean value);
VALA_EXTERN PangoEllipsizeMode tab_get_ellipsize_mode (Tab* self);
VALA_EXTERN void tab_set_ellipsize_mode (Tab* self,
                             PangoEllipsizeMode value);
VALA_EXTERN gboolean tab_get_fixed (Tab* self) G_GNUC_DEPRECATED ;
VALA_EXTERN void tab_set_fixed (Tab* self,
                    gboolean value) G_GNUC_DEPRECATED ;
VALA_EXTERN GtkMenu* tab_get_menu (Tab* self);
VALA_EXTERN void tab_set_menu (Tab* self,
                   GtkMenu* value);
VALA_EXTERN void tab_set_closable (Tab* self,
                       gboolean value);
VALA_EXTERN void tab_set_is_current_tab (Tab* self,
                             gboolean value);
static GObject * tab_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void _tab___lambda4_ (Tab* self);
static void __tab___lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static void _tab___lambda5_ (Tab* self);
static void __tab___lambda5__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static void _tab___lambda6_ (Tab* self);
static void __tab___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static void _tab___lambda7_ (Tab* self);
static void __tab___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static void _tab___lambda8_ (Tab* self);
static void __tab___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static gboolean _tab___lambda9_ (Tab* self,
                          GdkEventScroll* e);
static gboolean __tab___lambda9__gtk_widget_scroll_event (GtkWidget* _sender,
                                                   GdkEventScroll* event,
                                                   gpointer self);
static gboolean _tab___lambda10_ (Block14Data* _data14_,
                           GdkEventButton* e);
static gboolean __tab___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                                          GdkEventButton* event,
                                                          gpointer self);
static gboolean _tab___lambda11_ (Tab* self,
                           GdkEventCrossing* e);
static gboolean __tab___lambda11__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                          GdkEventCrossing* event,
                                                          gpointer self);
static gboolean _tab___lambda12_ (Tab* self,
                           GdkEventCrossing* e);
static gboolean __tab___lambda12__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                          GdkEventCrossing* event,
                                                          gpointer self);
static gboolean _tab___lambda13_ (Tab* self,
                           GdkEventCrossing* e);
static gboolean __tab___lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                          GdkEventCrossing* event,
                                                          gpointer self);
static gboolean _tab___lambda14_ (Tab* self,
                           GdkEventCrossing* e);
static gboolean __tab___lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                          GdkEventCrossing* event,
                                                          gpointer self);
static gboolean _tab___lambda15_ (Tab* self);
static gboolean __tab___lambda15__gtk_widget_button_press_event (GtkWidget* _sender,
                                                          GdkEventButton* event,
                                                          gpointer self);
static void _tab___lambda16_ (Tab* self);
static void __tab___lambda16__gtk_button_clicked (GtkButton* _sender,
                                           gpointer self);
static void tab_finalize (GObject * obj);
static GType tab_get_type_once (void);
static void _vala_tab_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec);
static void _vala_tab_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec);
VALA_EXTERN GType closed_tabs_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClosedTabs, g_object_unref)
VALA_EXTERN GType closed_tabs_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClosedTabsEntry* closed_tabs_entry_dup (const ClosedTabsEntry* self);
VALA_EXTERN void closed_tabs_entry_free (ClosedTabsEntry* self);
VALA_EXTERN void closed_tabs_entry_copy (const ClosedTabsEntry* self,
                             ClosedTabsEntry* dest);
VALA_EXTERN void closed_tabs_entry_destroy (ClosedTabsEntry* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (ClosedTabsEntry, closed_tabs_entry_destroy)
VALA_EXTERN ClosedTabs* closed_tabs_new (void);
VALA_EXTERN ClosedTabs* closed_tabs_construct (GType object_type);
VALA_EXTERN void closed_tabs_push (ClosedTabs* self,
                       Tab* tab);
VALA_EXTERN gint closed_tabs_get_max_restorable_tabs (ClosedTabs* self);
VALA_EXTERN void closed_tabs_pop (ClosedTabs* self,
                      ClosedTabsEntry* result);
VALA_EXTERN void closed_tabs_pick (ClosedTabs* self,
                       const gchar* search,
                       ClosedTabsEntry* result);
VALA_EXTERN void closed_tabs_set_max_restorable_tabs (ClosedTabs* self,
                                          gint value);
VALA_EXTERN gboolean closed_tabs_get_empty (ClosedTabs* self);
VALA_EXTERN GtkMenu* closed_tabs_get_menu (ClosedTabs* self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void _closed_tabs_menu_____lambda17_ (Block15Data* _data15_);
static void __closed_tabs_menu_____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void _closed_tabs_menu____lambda18_ (ClosedTabs* self);
static void __closed_tabs_menu____lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                             gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_STRING_OBJECT (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static GObject * closed_tabs_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void closed_tabs_finalize (GObject * obj);
static GType closed_tabs_get_type_once (void);
static void _vala_closed_tabs_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_closed_tabs_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
VALA_EXTERN GType dynamic_notebook_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DynamicNotebook, g_object_unref)
VALA_EXTERN GType dynamic_notebook_tab_bar_behavior_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN DynamicNotebook* dynamic_notebook_new (void);
VALA_EXTERN DynamicNotebook* dynamic_notebook_construct (GType object_type);
static void dynamic_notebook_on_switch_page (DynamicNotebook* self,
                                      GtkWidget* page,
                                      guint pagenum);
static void dynamic_notebook_on_page_added (DynamicNotebook* self,
                                     GtkWidget* page,
                                     guint pagenum);
static void dynamic_notebook_insert_callbacks (DynamicNotebook* self,
                                        Tab* tab);
static void dynamic_notebook_update_tabs_visibility (DynamicNotebook* self);
static void dynamic_notebook_on_page_removed (DynamicNotebook* self,
                                       GtkWidget* page,
                                       guint pagenum);
static void dynamic_notebook_remove_callbacks (DynamicNotebook* self,
                                        Tab* tab);
static void dynamic_notebook_on_page_reordered (DynamicNotebook* self,
                                         GtkWidget* page,
                                         guint pagenum);
static void dynamic_notebook_recalc_order (DynamicNotebook* self);
static GtkNotebook* dynamic_notebook_on_create_window (DynamicNotebook* self,
                                                GtkWidget* page,
                                                gint x,
                                                gint y);
VALA_EXTERN gint dynamic_notebook_get_n_tabs (DynamicNotebook* self);
VALA_EXTERN gboolean dynamic_notebook_get_force_left (DynamicNotebook* self);
static void dynamic_notebook_recalc_size (DynamicNotebook* self);
static void dynamic_notebook_restore_last_tab (DynamicNotebook* self);
VALA_EXTERN gboolean dynamic_notebook_get_allow_restoring (DynamicNotebook* self);
static void dynamic_notebook_switch_pin_tab (DynamicNotebook* self,
                                      Tab* tab);
VALA_EXTERN gboolean dynamic_notebook_get_allow_pinning (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_remove_tab (DynamicNotebook* self,
                                  Tab* tab);
VALA_EXTERN gint dynamic_notebook_get_tab_position (DynamicNotebook* self,
                                        Tab* tab);
VALA_EXTERN void dynamic_notebook_next_page (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_previous_page (DynamicNotebook* self);
static void dynamic_notebook_real_show (GtkWidget* base);
VALA_EXTERN GList* dynamic_notebook_get_children (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_tab_position (DynamicNotebook* self,
                                        Tab* tab,
                                        gint position);
VALA_EXTERN Tab* dynamic_notebook_get_tab_by_index (DynamicNotebook* self,
                                        gint index);
VALA_EXTERN Tab* dynamic_notebook_get_tab_by_widget (DynamicNotebook* self,
                                         GtkWidget* widget);
VALA_EXTERN GtkWidget* dynamic_notebook_get_nth_page (DynamicNotebook* self,
                                          gint index);
VALA_EXTERN guint dynamic_notebook_insert_tab (DynamicNotebook* self,
                                   Tab* tab,
                                   gint index);
VALA_EXTERN GList* dynamic_notebook_get_tabs (DynamicNotebook* self);
VALA_EXTERN gboolean dynamic_notebook_get_allow_drag (DynamicNotebook* self);
VALA_EXTERN gboolean dynamic_notebook_get_allow_new_window (DynamicNotebook* self);
VALA_EXTERN gboolean dynamic_notebook_get_allow_duplication (DynamicNotebook* self);
VALA_EXTERN gboolean dynamic_notebook_get_tabs_closable (DynamicNotebook* self);
static void dynamic_notebook_on_tab_closed (DynamicNotebook* self,
                                     Tab* tab);
static void _dynamic_notebook_on_tab_closed_tab_closed (Tab* _sender,
                                                 gpointer self);
static void dynamic_notebook_on_close_others (DynamicNotebook* self,
                                       Tab* tab);
static void _dynamic_notebook_on_close_others_tab_close_others (Tab* _sender,
                                                         gpointer self);
static void dynamic_notebook_on_new_window (DynamicNotebook* self,
                                     Tab* tab);
static void _dynamic_notebook_on_new_window_tab_new_window (Tab* _sender,
                                                     gpointer self);
static void dynamic_notebook_on_duplicate (DynamicNotebook* self,
                                    Tab* tab);
static void _dynamic_notebook_on_duplicate_tab_duplicate (Tab* _sender,
                                                   gpointer self);
static void dynamic_notebook_on_pin_switch (DynamicNotebook* self,
                                     Tab* tab);
static void _dynamic_notebook_on_pin_switch_tab_pin_switch (Tab* _sender,
                                                     gpointer self);
VALA_EXTERN gboolean dynamic_notebook_get_show_tabs (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_show_tabs (DynamicNotebook* self,
                                     gboolean value);
VALA_EXTERN gboolean dynamic_notebook_get_show_icons (DynamicNotebook* self) G_GNUC_DEPRECATED ;
VALA_EXTERN void dynamic_notebook_set_show_icons (DynamicNotebook* self,
                                      gboolean value) G_GNUC_DEPRECATED ;
VALA_EXTERN void dynamic_notebook_set_tabs_closable (DynamicNotebook* self,
                                         gboolean value);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void _dynamic_notebook_tabs_closable____lambda21_ (Block16Data* _data16_,
                                                   Tab* t);
static void __dynamic_notebook_tabs_closable____lambda21__gfunc (gconstpointer data,
                                                          gpointer self);
VALA_EXTERN void dynamic_notebook_set_allow_drag (DynamicNotebook* self,
                                      gboolean value);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void _dynamic_notebook_allow_drag___lambda19_ (Block17Data* _data17_,
                                               Tab* t);
static void __dynamic_notebook_allow_drag___lambda19__gfunc (gconstpointer data,
                                                      gpointer self);
VALA_EXTERN void dynamic_notebook_set_allow_new_window (DynamicNotebook* self,
                                            gboolean value);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void _dynamic_notebook_allow_new_window___lambda20_ (Block18Data* _data18_,
                                                     Tab* t);
static void __dynamic_notebook_allow_new_window___lambda20__gfunc (gconstpointer data,
                                                            gpointer self);
VALA_EXTERN void dynamic_notebook_set_allow_duplication (DynamicNotebook* self,
                                             gboolean value);
VALA_EXTERN void dynamic_notebook_set_allow_restoring (DynamicNotebook* self,
                                           gboolean value);
VALA_EXTERN gint dynamic_notebook_get_max_restorable_tabs (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_max_restorable_tabs (DynamicNotebook* self,
                                               gint value);
VALA_EXTERN gboolean dynamic_notebook_get_add_button_visible (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_add_button_visible (DynamicNotebook* self,
                                              gboolean value);
VALA_EXTERN void dynamic_notebook_set_allow_pinning (DynamicNotebook* self,
                                         gboolean value);
VALA_EXTERN void dynamic_notebook_set_force_left (DynamicNotebook* self,
                                      gboolean value);
VALA_EXTERN const gchar* dynamic_notebook_get_add_button_tooltip (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_add_button_tooltip (DynamicNotebook* self,
                                              const gchar* value);
VALA_EXTERN Tab* dynamic_notebook_get_current (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_current (DynamicNotebook* self,
                                   Tab* value);
VALA_EXTERN const gchar* dynamic_notebook_get_group_name (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_group_name (DynamicNotebook* self,
                                      const gchar* value);
VALA_EXTERN DynamicNotebookTabBarBehavior dynamic_notebook_get_tab_bar_behavior (DynamicNotebook* self);
VALA_EXTERN void dynamic_notebook_set_tab_bar_behavior (DynamicNotebook* self,
                                            DynamicNotebookTabBarBehavior value);
VALA_EXTERN GtkMenu* dynamic_notebook_get_menu (DynamicNotebook* self);
static void dynamic_notebook_set_menu (DynamicNotebook* self,
                                GtkMenu* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_INT_INT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static GObject * dynamic_notebook_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static gboolean _dynamic_notebook___lambda22_ (DynamicNotebook* self,
                                        cairo_t* ctx);
static gboolean __dynamic_notebook___lambda22__gtk_widget_draw (GtkWidget* _sender,
                                                         cairo_t* cr,
                                                         gpointer self);
static void _dynamic_notebook___lambda23_ (DynamicNotebook* self);
static void __dynamic_notebook___lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self);
static void _dynamic_notebook___lambda24_ (DynamicNotebook* self);
static void __dynamic_notebook___lambda24__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self);
static void _dynamic_notebook___lambda25_ (DynamicNotebook* self,
                                    const gchar* label,
                                    const gchar* restore_data,
                                    GIcon* icon);
static void __dynamic_notebook___lambda25__closed_tabs_restored (ClosedTabs* _sender,
                                                          const gchar* label,
                                                          const gchar* restore_data,
                                                          GIcon* icon,
                                                          gpointer self);
static void _dynamic_notebook___lambda26_ (DynamicNotebook* self);
static void __dynamic_notebook___lambda26__closed_tabs_cleared (ClosedTabs* _sender,
                                                         gpointer self);
static void _dynamic_notebook___lambda27_ (DynamicNotebook* self);
static void __dynamic_notebook___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static gboolean _dynamic_notebook___lambda28_ (DynamicNotebook* self,
                                        GdkEventButton* e);
static gboolean __dynamic_notebook___lambda28__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self);
static void _dynamic_notebook___lambda29_ (DynamicNotebook* self);
static void __dynamic_notebook___lambda29__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void _dynamic_notebook___lambda30_ (DynamicNotebook* self);
static void __dynamic_notebook___lambda30__gtk_widget_size_allocate (GtkWidget* _sender,
                                                              GtkAllocation* allocation,
                                                              gpointer self);
static gboolean _dynamic_notebook___lambda31_ (DynamicNotebook* self,
                                        GdkEventButton* e);
static gboolean __dynamic_notebook___lambda31__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self);
static gboolean _dynamic_notebook___lambda32_ (DynamicNotebook* self,
                                        GdkEventKey* e);
static gboolean __dynamic_notebook___lambda32__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                    GdkEventKey* event,
                                                                    gpointer self);
static void _dynamic_notebook___lambda33_ (DynamicNotebook* self);
static void _dynamic_notebook_on_switch_page_gtk_notebook_switch_page (GtkNotebook* _sender,
                                                                GtkWidget* page,
                                                                guint page_num,
                                                                gpointer self);
static void _dynamic_notebook_on_page_added_gtk_notebook_page_added (GtkNotebook* _sender,
                                                              GtkWidget* child,
                                                              guint page_num,
                                                              gpointer self);
static void _dynamic_notebook_on_page_removed_gtk_notebook_page_removed (GtkNotebook* _sender,
                                                                  GtkWidget* child,
                                                                  guint page_num,
                                                                  gpointer self);
static void _dynamic_notebook_on_page_reordered_gtk_notebook_page_reordered (GtkNotebook* _sender,
                                                                      GtkWidget* child,
                                                                      guint page_num,
                                                                      gpointer self);
static GtkNotebook* _dynamic_notebook_on_create_window_gtk_notebook_create_window (GtkNotebook* _sender,
                                                                            GtkWidget* page,
                                                                            gint x,
                                                                            gint y,
                                                                            gpointer self);
static void __dynamic_notebook___lambda33__gtk_widget_destroy (GtkWidget* _sender,
                                                        gpointer self);
static void dynamic_notebook_finalize (GObject * obj);
static GType dynamic_notebook_get_type_once (void);
static void _vala_dynamic_notebook_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_dynamic_notebook_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
tab_page_container_get_instance_private (TabPageContainer* self)
{
	return G_STRUCT_MEMBER_P (self, TabPageContainer_private_offset);
}

TabPageContainer*
tab_page_container_construct (GType object_type,
                              Tab* tab)
{
	TabPageContainer * self = NULL;
	g_return_val_if_fail (tab != NULL, NULL);
	self = (TabPageContainer*) g_object_new (object_type, "tab", tab, NULL);
	return self;
}

TabPageContainer*
tab_page_container_new (Tab* tab)
{
	return tab_page_container_construct (TYPE_TAB_PAGE_CONTAINER, tab);
}

Tab*
tab_page_container_get_tab (TabPageContainer* self)
{
	Tab* result;
	Tab* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tab;
	result = _tmp0_;
	return result;
}

void
tab_page_container_set_tab (TabPageContainer* self,
                            Tab* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tab = value;
	g_object_notify_by_pspec ((GObject *) self, tab_page_container_properties[TAB_PAGE_CONTAINER_TAB_PROPERTY]);
}

static GObject *
tab_page_container_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TabPageContainer * self;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	parent_class = G_OBJECT_CLASS (tab_page_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAB_PAGE_CONTAINER, TabPageContainer);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
tab_page_container_class_init (TabPageContainerClass * klass,
                               gpointer klass_data)
{
	tab_page_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TabPageContainer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tab_page_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tab_page_container_set_property;
	G_OBJECT_CLASS (klass)->constructor = tab_page_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = tab_page_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_PAGE_CONTAINER_TAB_PROPERTY, tab_page_container_properties[TAB_PAGE_CONTAINER_TAB_PROPERTY] = g_param_spec_object ("tab", "tab", "tab", TYPE_TAB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tab_page_container_instance_init (TabPageContainer * self,
                                  gpointer klass)
{
	self->priv = tab_page_container_get_instance_private (self);
	self->priv->_tab = NULL;
}

static void
tab_page_container_finalize (GObject * obj)
{
	TabPageContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAB_PAGE_CONTAINER, TabPageContainer);
	G_OBJECT_CLASS (tab_page_container_parent_class)->finalize (obj);
}

static GType
tab_page_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TabPageContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_page_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TabPageContainer), 0, (GInstanceInitFunc) tab_page_container_instance_init, NULL };
	GType tab_page_container_type_id;
	tab_page_container_type_id = g_type_register_static (gtk_event_box_get_type (), "TabPageContainer", &g_define_type_info, 0);
	TabPageContainer_private_offset = g_type_add_instance_private (tab_page_container_type_id, sizeof (TabPageContainerPrivate));
	return tab_page_container_type_id;
}

GType
tab_page_container_get_type (void)
{
	static volatile gsize tab_page_container_type_id__once = 0;
	if (g_once_init_enter (&tab_page_container_type_id__once)) {
		GType tab_page_container_type_id;
		tab_page_container_type_id = tab_page_container_get_type_once ();
		g_once_init_leave (&tab_page_container_type_id__once, tab_page_container_type_id);
	}
	return tab_page_container_type_id__once;
}

static void
_vala_tab_page_container_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	TabPageContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAB_PAGE_CONTAINER, TabPageContainer);
	switch (property_id) {
		case TAB_PAGE_CONTAINER_TAB_PROPERTY:
		g_value_set_object (value, tab_page_container_get_tab (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tab_page_container_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	TabPageContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAB_PAGE_CONTAINER, TabPageContainer);
	switch (property_id) {
		case TAB_PAGE_CONTAINER_TAB_PROPERTY:
		tab_page_container_set_tab (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
tab_get_instance_private (Tab* self)
{
	return G_STRUCT_MEMBER_P (self, Tab_private_offset);
}

/**
         * With this you can construct a Tab. It is linked to the page that is shown on focus.
         * A Tab can have a icon on the right side. You can pass null on the constructor to
         * create a tab without a icon.
         **/
Tab*
tab_construct (GType object_type,
               const gchar* label,
               GIcon* icon,
               GtkWidget* page)
{
	Tab * self = NULL;
	self = (Tab*) g_object_new (object_type, "label", label, "icon", icon, NULL);
	if (page != NULL) {
		tab_set_page (self, page);
	}
	return self;
}

Tab*
tab_new (const gchar* label,
         GIcon* icon,
         GtkWidget* page)
{
	return tab_construct (TYPE_TAB, label, icon, page);
}

void
tab_close (Tab* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, tab_signals[TAB_CLOSED_SIGNAL], 0);
}

static void
tab_update_close_button_visibility (Tab* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkRevealer* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->close_button_revealer;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp0_, self->priv->_pinned);
	_tmp1_ = self->priv->close_button_revealer;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, !self->priv->_pinned);
	if (self->priv->_closable) {
		_tmp3_ = !self->priv->_pinned;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		if (self->priv->cursor_over_tab) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = self->priv->cursor_over_close_button;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = self->priv->_is_current_tab;
		}
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = self->priv->close_button_revealer;
	gtk_revealer_set_reveal_child (_tmp6_, _tmp2_);
}

static gboolean
tab_close_button_is_visible (Tab* self)
{
	gboolean _tmp0_ = FALSE;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->close_button_revealer;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkRevealer* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->close_button_revealer;
		_tmp5_ = gtk_revealer_get_child_revealed (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

const gchar*
tab_get_label (Tab* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tab_set_label (Tab* self,
               const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_LABEL_PROPERTY]);
}

gchar*
tab_get_tooltip (Tab* self)
{
	gchar* result;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	_tmp1_ = gtk_widget_get_tooltip_text ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
tab_set_tooltip (Tab* self,
                 const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_label;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_TOOLTIP_PROPERTY]);
}

gboolean
tab_get_pinned (Tab* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pinned;
	return result;
}

void
tab_set_pinned (Tab* self,
                gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tab_get_pinnable (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (value != self->priv->_pinned) {
			if (value) {
				GtkLabel* _tmp2_;
				GtkImage* _tmp3_;
				GtkSpinner* _tmp4_;
				_tmp2_ = self->priv->_label;
				gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
				_tmp3_ = self->_icon;
				gtk_widget_set_margin_start ((GtkWidget*) _tmp3_, 1);
				_tmp4_ = self->priv->_working;
				gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 1);
			} else {
				GtkLabel* _tmp5_;
				GtkImage* _tmp6_;
				GtkSpinner* _tmp7_;
				_tmp5_ = self->priv->_label;
				gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
				_tmp6_ = self->_icon;
				gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 0);
				_tmp7_ = self->priv->_working;
				gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 0);
			}
			self->priv->_pinned = value;
			tab_update_close_button_visibility (self);
			g_signal_emit (self, tab_signals[TAB_PIN_SWITCH_SIGNAL], 0);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_PINNED_PROPERTY]);
}

gboolean
tab_get_pinnable (Tab* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pinnable;
	return result;
}

void
tab_set_pinnable (Tab* self,
                  gboolean value)
{
	g_return_if_fail (self != NULL);
	if (!value) {
		tab_set_pinned (self, FALSE);
	}
	self->priv->_pinnable = value;
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_PINNABLE_PROPERTY]);
}

const gchar*
tab_get_restore_data (Tab* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_restore_data;
	result = _tmp0_;
	return result;
}

void
tab_set_restore_data (Tab* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tab_get_restore_data (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_restore_data);
		self->priv->_restore_data = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_RESTORE_DATA_PROPERTY]);
	}
}

GtkWidget*
tab_get_page (Tab* self)
{
	GtkWidget* result;
	TabPageContainer* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->page_container;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
tab_set_page (Tab* self,
              GtkWidget* value)
{
	GtkWidget* container_child = NULL;
	TabPageContainer* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkContainer* value_parent = NULL;
	GtkContainer* _tmp5_;
	GtkContainer* _tmp6_;
	TabPageContainer* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->page_container;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	container_child = _tmp1_;
	_tmp2_ = container_child;
	if (_tmp2_ != NULL) {
		TabPageContainer* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp3_ = self->page_container;
		_tmp4_ = container_child;
		gtk_container_remove ((GtkContainer*) _tmp3_, _tmp4_);
	}
	_tmp5_ = gtk_widget_get_parent (value);
	value_parent = _tmp5_;
	_tmp6_ = value_parent;
	if (_tmp6_ != NULL) {
		GtkContainer* _tmp7_;
		TabPageContainer* _tmp8_;
		_tmp7_ = value_parent;
		gtk_container_remove (_tmp7_, value);
		_tmp8_ = self->page_container;
		gtk_container_add ((GtkContainer*) _tmp8_, value);
	} else {
		TabPageContainer* _tmp9_;
		_tmp9_ = self->page_container;
		gtk_container_add ((GtkContainer*) _tmp9_, value);
	}
	_tmp10_ = self->page_container;
	gtk_widget_show_all ((GtkWidget*) _tmp10_);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_PAGE_PROPERTY]);
}

GIcon*
tab_get_icon (Tab* self)
{
	GIcon* result;
	GtkImage* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_icon;
	g_object_get (_tmp0_, "gicon", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tab_set_icon (Tab* self,
              GIcon* value)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->_icon;
	g_object_set (_tmp0_, "gicon", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_ICON_PROPERTY]);
}

gboolean
tab_get_working (Tab* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->__working;
	return result;
}

void
tab_set_working (Tab* self,
                 gboolean value)
{
	GtkSpinner* _tmp0_;
	GtkImage* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_working;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	self->priv->__working = value;
	_tmp1_ = self->_icon;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, !value);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_WORKING_PROPERTY]);
}

PangoEllipsizeMode
tab_get_ellipsize_mode (Tab* self)
{
	PangoEllipsizeMode result;
	GtkLabel* _tmp0_;
	PangoEllipsizeMode _tmp1_;
	PangoEllipsizeMode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_label;
	_tmp1_ = gtk_label_get_ellipsize (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tab_set_ellipsize_mode (Tab* self,
                        PangoEllipsizeMode value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_label;
	gtk_label_set_ellipsize (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_ELLIPSIZE_MODE_PROPERTY]);
}

gboolean
tab_get_fixed (Tab* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fixed;
	return result;
}

void
tab_set_fixed (Tab* self,
               gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_fixed) {
		GtkLabel* _tmp0_;
		self->priv->_fixed = value;
		_tmp0_ = self->priv->_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_FIXED_PROPERTY]);
}

GtkMenu*
tab_get_menu (Tab* self)
{
	GtkMenu* result;
	GtkMenu* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_menu;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tab_set_menu (Tab* self,
              GtkMenu* value)
{
	GtkMenu* old_value;
	g_return_if_fail (self != NULL);
	old_value = tab_get_menu (self);
	if (old_value != value) {
		GtkMenu* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_menu);
		self->priv->_menu = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_MENU_PROPERTY]);
	}
}

void
tab_set_closable (Tab* self,
                  gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value == self->priv->_closable) {
		return;
	}
	self->priv->_closable = value;
	tab_update_close_button_visibility (self);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_CLOSABLE_PROPERTY]);
}

void
tab_set_is_current_tab (Tab* self,
                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_current_tab = value;
	tab_update_close_button_visibility (self);
	g_object_notify_by_pspec ((GObject *) self, tab_properties[TAB_IS_CURRENT_TAB_PROPERTY]);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		Tab* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->close_other_m);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
_tab___lambda4_ (Tab* self)
{
	g_signal_emit (self, tab_signals[TAB_CLOSED_SIGNAL], 0);
}

static void
__tab___lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	_tab___lambda4_ ((Tab*) self);
}

static void
_tab___lambda5_ (Tab* self)
{
	g_signal_emit (self, tab_signals[TAB_CLOSE_OTHERS_SIGNAL], 0);
}

static void
__tab___lambda5__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	_tab___lambda5_ ((Tab*) self);
}

static void
_tab___lambda6_ (Tab* self)
{
	g_signal_emit (self, tab_signals[TAB_NEW_WINDOW_SIGNAL], 0);
}

static void
__tab___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	_tab___lambda6_ ((Tab*) self);
}

static void
_tab___lambda7_ (Tab* self)
{
	g_signal_emit (self, tab_signals[TAB_DUPLICATE_SIGNAL], 0);
}

static void
__tab___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	_tab___lambda7_ ((Tab*) self);
}

static void
_tab___lambda8_ (Tab* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = tab_get_pinned (self);
	_tmp1_ = _tmp0_;
	tab_set_pinned (self, !_tmp1_);
}

static void
__tab___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	_tab___lambda8_ ((Tab*) self);
}

static gboolean
_tab___lambda9_ (Tab* self,
                 GdkEventScroll* e)
{
	GtkNotebook* notebook = NULL;
	GtkContainer* _tmp0_;
	GtkNotebook* _tmp1_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_notebook_get_type ()) ? ((GtkNotebook*) _tmp0_) : NULL);
	notebook = _tmp1_;
	switch (e->direction) {
		case GDK_SCROLL_UP:
		case GDK_SCROLL_LEFT:
		{
			GtkNotebook* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			_tmp2_ = notebook;
			g_object_get (_tmp2_, "page", &_tmp3_, NULL);
			_tmp4_ = _tmp3_;
			if (_tmp4_ > 0) {
				GtkNotebook* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				_tmp5_ = notebook;
				g_object_get (_tmp5_, "page", &_tmp6_, NULL);
				_tmp7_ = _tmp6_;
				g_object_set (_tmp5_, "page", _tmp7_ - 1, NULL);
				result = TRUE;
				_g_object_unref0 (notebook);
				return result;
			}
			break;
		}
		case GDK_SCROLL_DOWN:
		case GDK_SCROLL_RIGHT:
		{
			GtkNotebook* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GtkNotebook* _tmp11_;
			_tmp8_ = notebook;
			g_object_get (_tmp8_, "page", &_tmp9_, NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = notebook;
			if (_tmp10_ < gtk_notebook_get_n_pages (_tmp11_)) {
				GtkNotebook* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = notebook;
				g_object_get (_tmp12_, "page", &_tmp13_, NULL);
				_tmp14_ = _tmp13_;
				g_object_set (_tmp12_, "page", _tmp14_ + 1, NULL);
				result = TRUE;
				_g_object_unref0 (notebook);
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = FALSE;
	_g_object_unref0 (notebook);
	return result;
}

static gboolean
__tab___lambda9__gtk_widget_scroll_event (GtkWidget* _sender,
                                          GdkEventScroll* event,
                                          gpointer self)
{
	gboolean result;
	result = _tab___lambda9_ ((Tab*) self, event);
	return result;
}

static gboolean
_tab___lambda10_ (Block14Data* _data14_,
                  GdkEventButton* e)
{
	Tab* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data14_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) 2)) {
		_tmp0_ = tab_close_button_is_visible (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		e->state = e->state & MODIFIER_MASK;
		if (e->state == 0) {
			g_signal_emit (self, tab_signals[TAB_CLOSED_SIGNAL], 0);
		} else {
			if (e->state == GDK_SHIFT_MASK) {
				g_signal_emit (self, tab_signals[TAB_CLOSE_OTHERS_SIGNAL], 0);
			}
		}
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (e->button == ((guint) 1)) {
			_tmp2_ = e->type == GDK_2BUTTON_PRESS;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GtkMenuItem* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = self->duplicate_m;
			_tmp4_ = gtk_widget_get_visible ((GtkWidget*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp1_ = _tmp5_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			g_signal_emit (self, tab_signals[TAB_DUPLICATE_SIGNAL], 0);
		} else {
			if (e->button == ((guint) 3)) {
				GtkMenu* _tmp6_;
				GtkContainer* cont = NULL;
				GtkContainer* _tmp7_;
				GtkContainer* _tmp8_;
				guint _tmp9_ = 0U;
				GtkContainer* _tmp10_;
				guint num_tabs = 0U;
				GtkMenuItem* _tmp14_;
				GtkMenuItem* _tmp15_;
				GtkMenuItem* _tmp16_;
				GtkMenuItem* _tmp17_;
				gboolean _tmp18_;
				gboolean _tmp19_;
				_tmp6_ = self->priv->_menu;
				gtk_menu_popup_at_pointer (_tmp6_, (GdkEvent*) e);
				_tmp7_ = gtk_widget_get_parent ((GtkWidget*) self);
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp7_) : NULL);
				cont = _tmp8_;
				_tmp10_ = cont;
				if (_tmp10_ == NULL) {
					_tmp9_ = (guint) 0;
				} else {
					GtkContainer* _tmp11_;
					GList* _tmp12_;
					GList* _tmp13_;
					_tmp11_ = cont;
					_tmp12_ = gtk_container_get_children (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp9_ = g_list_length (_tmp13_);
					(_tmp13_ == NULL) ? NULL : (_tmp13_ = (g_list_free (_tmp13_), NULL));
				}
				num_tabs = _tmp9_;
				_tmp14_ = _data14_->close_other_m;
				gtk_menu_item_set_label (_tmp14_, ngettext (_ ("Close Other Tab"), _ ("Close Other Tabs"), (gulong) (num_tabs - 1)));
				_tmp15_ = _data14_->close_other_m;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, num_tabs != ((guint) 1));
				_tmp16_ = self->new_window_m;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, num_tabs != ((guint) 1));
				_tmp17_ = self->pin_m;
				gtk_menu_item_set_label (_tmp17_, "Pin");
				_tmp18_ = tab_get_pinned (self);
				_tmp19_ = _tmp18_;
				if (_tmp19_) {
					GtkMenuItem* _tmp20_;
					_tmp20_ = self->pin_m;
					gtk_menu_item_set_label (_tmp20_, "Unpin");
				}
				_g_object_unref0 (cont);
			} else {
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
__tab___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                                 GdkEventButton* event,
                                                 gpointer self)
{
	gboolean result;
	result = _tab___lambda10_ (self, event);
	return result;
}

static gboolean
_tab___lambda11_ (Tab* self,
                  GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	self->priv->cursor_over_tab = TRUE;
	tab_update_close_button_visibility (self);
	result = FALSE;
	return result;
}

static gboolean
__tab___lambda11__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                 GdkEventCrossing* event,
                                                 gpointer self)
{
	gboolean result;
	result = _tab___lambda11_ ((Tab*) self, event);
	return result;
}

static gboolean
_tab___lambda12_ (Tab* self,
                  GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (!self->priv->cursor_over_tab) {
		result = FALSE;
		return result;
	}
	self->priv->cursor_over_tab = FALSE;
	tab_update_close_button_visibility (self);
	result = FALSE;
	return result;
}

static gboolean
__tab___lambda12__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                 GdkEventCrossing* event,
                                                 gpointer self)
{
	gboolean result;
	result = _tab___lambda12_ ((Tab*) self, event);
	return result;
}

static gboolean
_tab___lambda13_ (Tab* self,
                  GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	self->priv->cursor_over_close_button = TRUE;
	tab_update_close_button_visibility (self);
	result = FALSE;
	return result;
}

static gboolean
__tab___lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                 GdkEventCrossing* event,
                                                 gpointer self)
{
	gboolean result;
	result = _tab___lambda13_ ((Tab*) self, event);
	return result;
}

static gboolean
_tab___lambda14_ (Tab* self,
                  GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (!self->priv->cursor_over_close_button) {
		result = FALSE;
		return result;
	}
	self->priv->cursor_over_close_button = FALSE;
	tab_update_close_button_visibility (self);
	result = FALSE;
	return result;
}

static gboolean
__tab___lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                 GdkEventCrossing* event,
                                                 gpointer self)
{
	gboolean result;
	result = _tab___lambda14_ ((Tab*) self, event);
	return result;
}

static gboolean
_tab___lambda15_ (Tab* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
__tab___lambda15__gtk_widget_button_press_event (GtkWidget* _sender,
                                                 GdkEventButton* event,
                                                 gpointer self)
{
	gboolean result;
	result = _tab___lambda15_ ((Tab*) self);
	return result;
}

static void
_tab___lambda16_ (Tab* self)
{
	g_signal_emit (self, tab_signals[TAB_CLOSED_SIGNAL], 0);
}

static void
__tab___lambda16__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self)
{
	_tab___lambda16_ ((Tab*) self);
}

static GObject *
tab_constructor (GType type,
                 guint n_construct_properties,
                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Tab * self;
	Block14Data* _data14_;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkSpinner* _tmp10_;
	GtkSpinner* _tmp11_;
	GtkSpinner* _tmp12_;
	GtkButton* close_button = NULL;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkRevealer* _tmp17_;
	GtkRevealer* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkButton* _tmp20_;
	GtkGrid* tab_layout = NULL;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkGrid* _tmp23_;
	GtkGrid* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkGrid* _tmp26_;
	GtkLabel* _tmp27_;
	GtkGrid* _tmp28_;
	GtkImage* _tmp29_;
	GtkGrid* _tmp30_;
	GtkSpinner* _tmp31_;
	GtkGrid* _tmp32_;
	TabPageContainer* _tmp33_;
	GtkMenu* _tmp34_;
	GtkMenu* _tmp35_;
	GtkMenuItem* close_m = NULL;
	GtkMenuItem* _tmp36_;
	GtkMenuItem* _tmp37_;
	GtkMenuItem* _tmp38_;
	GtkMenuItem* _tmp39_;
	GtkMenuItem* _tmp40_;
	GtkMenu* _tmp41_;
	GtkMenuItem* _tmp42_;
	GtkMenu* _tmp43_;
	GtkMenuItem* _tmp44_;
	GtkMenu* _tmp45_;
	GtkMenuItem* _tmp46_;
	GtkMenu* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkMenu* _tmp49_;
	GtkMenuItem* _tmp50_;
	GtkMenu* _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenuItem* _tmp53_;
	GtkMenuItem* _tmp54_;
	GtkMenuItem* _tmp55_;
	GtkMenuItem* _tmp56_;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	TabPageContainer* _tmp59_;
	GtkButton* _tmp60_;
	parent_class = G_OBJECT_CLASS (tab_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAB, Tab);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_label);
	self->priv->_label = _tmp0_;
	_tmp1_ = self->priv->_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->_label;
	_tmp3_ = tab_get_label (self);
	_tmp4_ = _tmp3_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp4_);
	_tmp5_ = self->priv->_label;
	gtk_label_set_ellipsize (_tmp5_, PANGO_ELLIPSIZE_END);
	_tmp6_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->_icon);
	self->_icon = _tmp6_;
	_tmp7_ = self->_icon;
	g_object_set (_tmp7_, "icon-size", (gint) GTK_ICON_SIZE_MENU, NULL);
	_tmp8_ = self->_icon;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = self->_icon;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 16, 16);
	_tmp10_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->_working);
	self->priv->_working = _tmp10_;
	_tmp11_ = self->priv->_working;
	gtk_widget_set_size_request ((GtkWidget*) _tmp11_, 16, 16);
	_tmp12_ = self->priv->_working;
	gtk_spinner_start (_tmp12_);
	_tmp13_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp13_);
	close_button = _tmp13_;
	_tmp14_ = close_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _ ("Close Tab"));
	_tmp15_ = close_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	_tmp16_ = close_button;
	gtk_button_set_relief (_tmp16_, GTK_RELIEF_NONE);
	_tmp17_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->close_button_revealer);
	self->priv->close_button_revealer = _tmp17_;
	_tmp18_ = self->priv->close_button_revealer;
	gtk_revealer_set_transition_type (_tmp18_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	_tmp19_ = self->priv->close_button_revealer;
	_tmp20_ = close_button;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp21_);
	tab_layout = _tmp21_;
	_tmp22_ = tab_layout;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, FALSE);
	_tmp23_ = tab_layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp23_, GTK_ORIENTATION_HORIZONTAL);
	_tmp24_ = tab_layout;
	_tmp25_ = self->priv->close_button_revealer;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = tab_layout;
	_tmp27_ = self->priv->_label;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = tab_layout;
	_tmp29_ = self->_icon;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = tab_layout;
	_tmp31_ = self->priv->_working;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, TRUE);
	_tmp32_ = tab_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp32_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp33_ = tab_page_container_new (self);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->page_container);
	self->page_container = _tmp33_;
	_tmp34_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	tab_set_menu (self, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Close Tab"));
	g_object_ref_sink (_tmp36_);
	close_m = _tmp36_;
	_tmp37_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("");
	g_object_ref_sink (_tmp37_);
	_data14_->close_other_m = _tmp37_;
	_tmp38_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("");
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->pin_m);
	self->pin_m = _tmp38_;
	_tmp39_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in a New Window"));
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->new_window_m);
	self->new_window_m = _tmp39_;
	_tmp40_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Duplicate"));
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->duplicate_m);
	self->duplicate_m = _tmp40_;
	_tmp41_ = self->priv->_menu;
	_tmp42_ = _data14_->close_other_m;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp41_, _tmp42_);
	_tmp43_ = self->priv->_menu;
	_tmp44_ = close_m;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp43_, _tmp44_);
	_tmp45_ = self->priv->_menu;
	_tmp46_ = self->new_window_m;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp45_, _tmp46_);
	_tmp47_ = self->priv->_menu;
	_tmp48_ = self->duplicate_m;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp47_, _tmp48_);
	_tmp49_ = self->priv->_menu;
	_tmp50_ = self->pin_m;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp49_, _tmp50_);
	_tmp51_ = self->priv->_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp51_);
	_tmp52_ = close_m;
	g_signal_connect_object (_tmp52_, "activate", (GCallback) __tab___lambda4__gtk_menu_item_activate, self, 0);
	_tmp53_ = _data14_->close_other_m;
	g_signal_connect_object (_tmp53_, "activate", (GCallback) __tab___lambda5__gtk_menu_item_activate, self, 0);
	_tmp54_ = self->new_window_m;
	g_signal_connect_object (_tmp54_, "activate", (GCallback) __tab___lambda6__gtk_menu_item_activate, self, 0);
	_tmp55_ = self->duplicate_m;
	g_signal_connect_object (_tmp55_, "activate", (GCallback) __tab___lambda7__gtk_menu_item_activate, self, 0);
	_tmp56_ = self->pin_m;
	g_signal_connect_object (_tmp56_, "activate", (GCallback) __tab___lambda8__gtk_menu_item_activate, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "scroll-event", (GCallback) __tab___lambda9__gtk_widget_scroll_event, self, 0);
	g_signal_connect_data ((GtkWidget*) self, "button-press-event", (GCallback) __tab___lambda10__gtk_widget_button_press_event, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) __tab___lambda11__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) __tab___lambda12__gtk_widget_leave_notify_event, self, 0);
	_tmp57_ = close_button;
	g_signal_connect_object ((GtkWidget*) _tmp57_, "enter-notify-event", (GCallback) __tab___lambda13__gtk_widget_enter_notify_event, self, 0);
	_tmp58_ = close_button;
	g_signal_connect_object ((GtkWidget*) _tmp58_, "leave-notify-event", (GCallback) __tab___lambda14__gtk_widget_leave_notify_event, self, 0);
	_tmp59_ = self->page_container;
	g_signal_connect_object ((GtkWidget*) _tmp59_, "button-press-event", (GCallback) __tab___lambda15__gtk_widget_button_press_event, self, 0);
	_tmp60_ = close_button;
	g_signal_connect_object (_tmp60_, "clicked", (GCallback) __tab___lambda16__gtk_button_clicked, self, 0);
	tab_set_working (self, FALSE);
	tab_update_close_button_visibility (self);
	_g_object_unref0 (close_m);
	_g_object_unref0 (tab_layout);
	_g_object_unref0 (close_button);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return obj;
}

static void
tab_class_init (TabClass * klass,
                gpointer klass_data)
{
	tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Tab_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tab_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tab_set_property;
	G_OBJECT_CLASS (klass)->constructor = tab_constructor;
	G_OBJECT_CLASS (klass)->finalize = tab_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_LABEL_PROPERTY, tab_properties[TAB_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_TOOLTIP_PROPERTY, tab_properties[TAB_TOOLTIP_PROPERTY] = g_param_spec_string ("tooltip", "tooltip", "tooltip", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_PINNED_PROPERTY, tab_properties[TAB_PINNED_PROPERTY] = g_param_spec_boolean ("pinned", "pinned", "pinned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_PINNABLE_PROPERTY, tab_properties[TAB_PINNABLE_PROPERTY] = g_param_spec_boolean ("pinnable", "pinnable", "pinnable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Data which will be kept once the tab is deleted, and which will be used by
	         * the application to restore the data into the restored tab. Let it empty if
	         * the tab should not be restored.
	         **/
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_RESTORE_DATA_PROPERTY, tab_properties[TAB_RESTORE_DATA_PROPERTY] = g_param_spec_string ("restore-data", "restore-data", "restore-data", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_PAGE_PROPERTY, tab_properties[TAB_PAGE_PROPERTY] = g_param_spec_object ("page", "page", "page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_ICON_PROPERTY, tab_properties[TAB_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_WORKING_PROPERTY, tab_properties[TAB_WORKING_PROPERTY] = g_param_spec_boolean ("working", "working", "working", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_ELLIPSIZE_MODE_PROPERTY, tab_properties[TAB_ELLIPSIZE_MODE_PROPERTY] = g_param_spec_enum ("ellipsize-mode", "ellipsize-mode", "ellipsize-mode", pango_ellipsize_mode_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_FIXED_PROPERTY, tab_properties[TAB_FIXED_PROPERTY] = g_param_spec_boolean ("fixed", "fixed", "fixed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_DEPRECATED));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_MENU_PROPERTY, tab_properties[TAB_MENU_PROPERTY] = g_param_spec_object ("menu", "menu", "menu", gtk_menu_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_CLOSABLE_PROPERTY, tab_properties[TAB_CLOSABLE_PROPERTY] = g_param_spec_boolean ("closable", "closable", "closable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAB_IS_CURRENT_TAB_PROPERTY, tab_properties[TAB_IS_CURRENT_TAB_PROPERTY] = g_param_spec_boolean ("is-current-tab", "is-current-tab", "is-current-tab", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	tab_signals[TAB_CLOSED_SIGNAL] = g_signal_new ("closed", TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tab_signals[TAB_CLOSE_OTHERS_SIGNAL] = g_signal_new ("close-others", TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tab_signals[TAB_NEW_WINDOW_SIGNAL] = g_signal_new ("new-window", TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tab_signals[TAB_DUPLICATE_SIGNAL] = g_signal_new ("duplicate", TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tab_signals[TAB_PIN_SWITCH_SIGNAL] = g_signal_new ("pin-switch", TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
tab_instance_init (Tab * self,
                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = tab_get_instance_private (self);
	self->priv->_pinned = FALSE;
	self->priv->_pinnable = TRUE;
	_tmp0_ = g_strdup ("");
	self->priv->_restore_data = _tmp0_;
	self->dropped_callback = NULL;
	self->dropped_callback_target = NULL;
	self->dropped_callback_target_destroy_notify = NULL;
	self->priv->_closable = TRUE;
	self->priv->_is_current_tab = FALSE;
	self->priv->cursor_over_tab = FALSE;
	self->priv->cursor_over_close_button = FALSE;
}

static void
tab_finalize (GObject * obj)
{
	Tab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAB, Tab);
	_g_object_unref0 (self->priv->_label);
	_g_free0 (self->priv->_restore_data);
	(self->dropped_callback_target_destroy_notify == NULL) ? NULL : (self->dropped_callback_target_destroy_notify (self->dropped_callback_target), NULL);
	self->dropped_callback = NULL;
	self->dropped_callback_target = NULL;
	self->dropped_callback_target_destroy_notify = NULL;
	_g_object_unref0 (self->page_container);
	_g_object_unref0 (self->_icon);
	_g_object_unref0 (self->priv->_working);
	_g_object_unref0 (self->priv->_menu);
	_g_object_unref0 (self->new_window_m);
	_g_object_unref0 (self->duplicate_m);
	_g_object_unref0 (self->pin_m);
	_g_object_unref0 (self->priv->close_button_revealer);
	G_OBJECT_CLASS (tab_parent_class)->finalize (obj);
}

/**
     * This is a standard tab which can be used in a notebook to form a tabbed UI.
     */
static GType
tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tab), 0, (GInstanceInitFunc) tab_instance_init, NULL };
	GType tab_type_id;
	tab_type_id = g_type_register_static (gtk_event_box_get_type (), "Tab", &g_define_type_info, 0);
	Tab_private_offset = g_type_add_instance_private (tab_type_id, sizeof (TabPrivate));
	return tab_type_id;
}

GType
tab_get_type (void)
{
	static volatile gsize tab_type_id__once = 0;
	if (g_once_init_enter (&tab_type_id__once)) {
		GType tab_type_id;
		tab_type_id = tab_get_type_once ();
		g_once_init_leave (&tab_type_id__once, tab_type_id);
	}
	return tab_type_id__once;
}

static void
_vala_tab_get_property (GObject * object,
                        guint property_id,
                        GValue * value,
                        GParamSpec * pspec)
{
	Tab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAB, Tab);
	switch (property_id) {
		case TAB_LABEL_PROPERTY:
		g_value_set_string (value, tab_get_label (self));
		break;
		case TAB_TOOLTIP_PROPERTY:
		g_value_take_string (value, tab_get_tooltip (self));
		break;
		case TAB_PINNED_PROPERTY:
		g_value_set_boolean (value, tab_get_pinned (self));
		break;
		case TAB_PINNABLE_PROPERTY:
		g_value_set_boolean (value, tab_get_pinnable (self));
		break;
		case TAB_RESTORE_DATA_PROPERTY:
		g_value_set_string (value, tab_get_restore_data (self));
		break;
		case TAB_PAGE_PROPERTY:
		g_value_set_object (value, tab_get_page (self));
		break;
		case TAB_ICON_PROPERTY:
		g_value_take_object (value, tab_get_icon (self));
		break;
		case TAB_WORKING_PROPERTY:
		g_value_set_boolean (value, tab_get_working (self));
		break;
		case TAB_ELLIPSIZE_MODE_PROPERTY:
		g_value_set_enum (value, tab_get_ellipsize_mode (self));
		break;
		case TAB_FIXED_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_boolean (value, tab_get_fixed (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case TAB_MENU_PROPERTY:
		g_value_set_object (value, tab_get_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tab_set_property (GObject * object,
                        guint property_id,
                        const GValue * value,
                        GParamSpec * pspec)
{
	Tab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAB, Tab);
	switch (property_id) {
		case TAB_LABEL_PROPERTY:
		tab_set_label (self, g_value_get_string (value));
		break;
		case TAB_TOOLTIP_PROPERTY:
		tab_set_tooltip (self, g_value_get_string (value));
		break;
		case TAB_PINNED_PROPERTY:
		tab_set_pinned (self, g_value_get_boolean (value));
		break;
		case TAB_PINNABLE_PROPERTY:
		tab_set_pinnable (self, g_value_get_boolean (value));
		break;
		case TAB_RESTORE_DATA_PROPERTY:
		tab_set_restore_data (self, g_value_get_string (value));
		break;
		case TAB_PAGE_PROPERTY:
		tab_set_page (self, g_value_get_object (value));
		break;
		case TAB_ICON_PROPERTY:
		tab_set_icon (self, g_value_get_object (value));
		break;
		case TAB_WORKING_PROPERTY:
		tab_set_working (self, g_value_get_boolean (value));
		break;
		case TAB_ELLIPSIZE_MODE_PROPERTY:
		tab_set_ellipsize_mode (self, g_value_get_enum (value));
		break;
		case TAB_FIXED_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		tab_set_fixed (self, g_value_get_boolean (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case TAB_MENU_PROPERTY:
		tab_set_menu (self, g_value_get_object (value));
		break;
		case TAB_CLOSABLE_PROPERTY:
		tab_set_closable (self, g_value_get_boolean (value));
		break;
		case TAB_IS_CURRENT_TAB_PROPERTY:
		tab_set_is_current_tab (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
closed_tabs_get_instance_private (ClosedTabs* self)
{
	return G_STRUCT_MEMBER_P (self, ClosedTabs_private_offset);
}

ClosedTabs*
closed_tabs_construct (GType object_type)
{
	ClosedTabs * self = NULL;
	self = (ClosedTabs*) g_object_new (object_type, NULL);
	return self;
}

ClosedTabs*
closed_tabs_new (void)
{
	return closed_tabs_construct (TYPE_CLOSED_TABS);
}

void
closed_tabs_push (ClosedTabs* self,
                  Tab* tab)
{
	ClosedTabsEntry e = {0};
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GIcon* _tmp18_;
	GIcon* _tmp19_;
	GraniteWidgetsDroppedDelegate _tmp20_;
	gpointer _tmp20__target;
	ClosedTabsEntry _tmp21_ = {0};
	GeeLinkedList* _tmp22_;
	ClosedTabsEntry _tmp23_;
	GeeLinkedList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	{
		GeeLinkedList* _entry_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _entry_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _entry_index = 0;
		_tmp0_ = self->priv->closed_tabs;
		_entry_list = _tmp0_;
		_tmp1_ = _entry_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_entry_size = _tmp3_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ClosedTabsEntry* entry = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			ClosedTabsEntry* _tmp10_;
			const gchar* _tmp11_;
			_entry_index = _entry_index + 1;
			_tmp4_ = _entry_index;
			_tmp5_ = _entry_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _entry_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _entry_index);
			entry = (ClosedTabsEntry*) _tmp7_;
			_tmp8_ = tab_get_restore_data (tab);
			_tmp9_ = _tmp8_;
			_tmp10_ = entry;
			_tmp11_ = (*_tmp10_).restore_data;
			if (g_strcmp0 (_tmp9_, _tmp11_) == 0) {
				_closed_tabs_entry_free0 (entry);
				return;
			}
			_closed_tabs_entry_free0 (entry);
		}
	}
	_tmp12_ = tab_get_label (tab);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = tab_get_restore_data (tab);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup (_tmp16_);
	_tmp18_ = tab_get_icon (tab);
	_tmp19_ = _tmp18_;
	_tmp20_ = tab->dropped_callback;
	_tmp20__target = tab->dropped_callback_target;
	_g_free0 (_tmp21_.label);
	_tmp21_.label = _tmp14_;
	_g_free0 (_tmp21_.restore_data);
	_tmp21_.restore_data = _tmp17_;
	_g_object_unref0 (_tmp21_.icon);
	_tmp21_.icon = _tmp19_;
	_tmp21_.dropped_callback = _tmp20_;
	_tmp21_.dropped_callback_target = _tmp20__target;
	e = _tmp21_;
	_tmp22_ = self->priv->closed_tabs;
	_tmp23_ = e;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, &_tmp23_);
	_tmp24_ = self->priv->closed_tabs;
	_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = closed_tabs_get_max_restorable_tabs (self);
	_tmp28_ = _tmp27_;
	if (_tmp26_ > _tmp28_) {
		ClosedTabsEntry* elem = NULL;
		GeeLinkedList* _tmp29_;
		gpointer _tmp30_;
		GraniteWidgetsDroppedDelegate dropped_callback = NULL;
		ClosedTabsEntry* _tmp31_;
		GraniteWidgetsDroppedDelegate _tmp32_;
		gpointer _tmp32__target;
		gpointer dropped_callback_target;
		GraniteWidgetsDroppedDelegate _tmp33_;
		gpointer _tmp33__target;
		_tmp29_ = self->priv->closed_tabs;
		_tmp30_ = gee_deque_poll_head ((GeeDeque*) _tmp29_);
		elem = (ClosedTabsEntry*) _tmp30_;
		_tmp31_ = elem;
		_tmp32_ = (*_tmp31_).dropped_callback;
		_tmp32__target = (*_tmp31_).dropped_callback_target;
		dropped_callback = _tmp32_;
		dropped_callback_target = _tmp32__target;
		_tmp33_ = dropped_callback;
		_tmp33__target = dropped_callback_target;
		if (_tmp33_ != NULL) {
			GraniteWidgetsDroppedDelegate _tmp34_;
			gpointer _tmp34__target;
			_tmp34_ = dropped_callback;
			_tmp34__target = dropped_callback_target;
			_tmp34_ (_tmp34__target);
		}
		_closed_tabs_entry_free0 (elem);
	}
	closed_tabs_entry_destroy (&e);
}

void
closed_tabs_pop (ClosedTabs* self,
                 ClosedTabsEntry* result)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeLinkedList* _tmp3_;
	gpointer _tmp4_;
	ClosedTabsEntry* _tmp5_;
	ClosedTabsEntry _tmp6_;
	ClosedTabsEntry _tmp7_ = {0};
	ClosedTabsEntry _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->closed_tabs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ > 0, "closed_tabs.size > 0");
	_tmp3_ = self->priv->closed_tabs;
	_tmp4_ = gee_deque_poll_tail ((GeeDeque*) _tmp3_);
	_tmp5_ = (ClosedTabsEntry*) _tmp4_;
	_tmp6_ = *_tmp5_;
	closed_tabs_entry_copy (&_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_closed_tabs_entry_free0 (_tmp5_);
	*result = _tmp8_;
	return;
}

void
closed_tabs_pick (ClosedTabs* self,
                  const gchar* search,
                  ClosedTabsEntry* result)
{
	ClosedTabsEntry picked = {0};
	ClosedTabsEntry _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_g_free0 (_tmp0_.label);
	_tmp0_.label = NULL;
	_g_free0 (_tmp0_.restore_data);
	_tmp0_.restore_data = NULL;
	_g_object_unref0 (_tmp0_.icon);
	_tmp0_.icon = NULL;
	picked = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeLinkedList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ClosedTabsEntry* entry = NULL;
				GeeLinkedList* _tmp6_;
				gpointer _tmp7_;
				ClosedTabsEntry* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->closed_tabs;
				_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->closed_tabs;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, i);
				entry = (ClosedTabsEntry*) _tmp7_;
				_tmp8_ = entry;
				_tmp9_ = (*_tmp8_).restore_data;
				if (g_strcmp0 (_tmp9_, search) == 0) {
					GeeLinkedList* _tmp10_;
					gpointer _tmp11_;
					ClosedTabsEntry* _tmp12_;
					ClosedTabsEntry _tmp13_;
					ClosedTabsEntry _tmp14_ = {0};
					_tmp10_ = self->priv->closed_tabs;
					_tmp11_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp10_, i);
					_tmp12_ = (ClosedTabsEntry*) _tmp11_;
					_tmp13_ = *_tmp12_;
					closed_tabs_entry_copy (&_tmp13_, &_tmp14_);
					closed_tabs_entry_destroy (&picked);
					picked = _tmp14_;
					_closed_tabs_entry_free0 (_tmp12_);
					_closed_tabs_entry_free0 (entry);
					break;
				}
				_closed_tabs_entry_free0 (entry);
			}
		}
	}
	*result = picked;
	return;
}

gint
closed_tabs_get_max_restorable_tabs (ClosedTabs* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_restorable_tabs;
	return result;
}

void
closed_tabs_set_max_restorable_tabs (ClosedTabs* self,
                                     gint value)
{
	g_return_if_fail (self != NULL);
	_vala_assert (value > 0, "value > 0");
	self->priv->_max_restorable_tabs = value;
	g_object_notify_by_pspec ((GObject *) self, closed_tabs_properties[CLOSED_TABS_MAX_RESTORABLE_TABS_PROPERTY]);
}

gboolean
closed_tabs_get_empty (ClosedTabs* self)
{
	gboolean result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->closed_tabs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ClosedTabs* self;
		self = _data15_->self;
		_closed_tabs_entry_free0 (_data15_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
_closed_tabs_menu_____lambda17_ (Block15Data* _data15_)
{
	ClosedTabs* self;
	ClosedTabsEntry e = {0};
	ClosedTabsEntry* _tmp0_;
	const gchar* _tmp1_;
	ClosedTabsEntry _tmp2_ = {0};
	ClosedTabsEntry _tmp3_;
	const gchar* _tmp4_;
	ClosedTabsEntry _tmp5_;
	const gchar* _tmp6_;
	ClosedTabsEntry _tmp7_;
	GIcon* _tmp8_;
	self = _data15_->self;
	_tmp0_ = _data15_->entry;
	_tmp1_ = (*_tmp0_).restore_data;
	closed_tabs_pick (self, _tmp1_, &_tmp2_);
	e = _tmp2_;
	_tmp3_ = e;
	_tmp4_ = _tmp3_.label;
	_tmp5_ = e;
	_tmp6_ = _tmp5_.restore_data;
	_tmp7_ = e;
	_tmp8_ = _tmp7_.icon;
	g_signal_emit (self, closed_tabs_signals[CLOSED_TABS_RESTORED_SIGNAL], 0, _tmp4_, _tmp6_, _tmp8_);
	closed_tabs_entry_destroy (&e);
}

static void
__closed_tabs_menu_____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	_closed_tabs_menu_____lambda17_ (self);
}

static void
_closed_tabs_menu____lambda18_ (ClosedTabs* self)
{
	GeeLinkedList* _tmp12_;
	{
		GeeLinkedList* _entry_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _entry_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _entry_index = 0;
		_tmp0_ = self->priv->closed_tabs;
		_entry_list = _tmp0_;
		_tmp1_ = _entry_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_entry_size = _tmp3_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ClosedTabsEntry* entry = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			ClosedTabsEntry* _tmp8_;
			GraniteWidgetsDroppedDelegate _tmp9_;
			gpointer _tmp9__target;
			_entry_index = _entry_index + 1;
			_tmp4_ = _entry_index;
			_tmp5_ = _entry_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _entry_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _entry_index);
			entry = (ClosedTabsEntry*) _tmp7_;
			_tmp8_ = entry;
			_tmp9_ = (*_tmp8_).dropped_callback;
			_tmp9__target = (*_tmp8_).dropped_callback_target;
			if (_tmp9_ != NULL) {
				ClosedTabsEntry* _tmp10_;
				GraniteWidgetsDroppedDelegate _tmp11_;
				gpointer _tmp11__target;
				_tmp10_ = entry;
				_tmp11_ = (*_tmp10_).dropped_callback;
				_tmp11__target = (*_tmp10_).dropped_callback_target;
				_tmp11_ (_tmp11__target);
			}
			_closed_tabs_entry_free0 (entry);
		}
	}
	_tmp12_ = self->priv->closed_tabs;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
	g_signal_emit (self, closed_tabs_signals[CLOSED_TABS_CLEARED_SIGNAL], 0);
}

static void
__closed_tabs_menu____lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                        gpointer self)
{
	_closed_tabs_menu____lambda18_ ((ClosedTabs*) self);
}

GtkMenu*
closed_tabs_get_menu (ClosedTabs* self)
{
	GtkMenu* result;
	GtkMenu* _menu = NULL;
	GtkMenu* _tmp0_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_menu = _tmp0_;
	{
		GeeLinkedList* _entry_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _entry_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _entry_index = 0;
		_tmp1_ = self->priv->closed_tabs;
		_entry_list = _tmp1_;
		_tmp2_ = _entry_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_entry_size = _tmp4_;
		_entry_index = -1;
		while (TRUE) {
			Block15Data* _data15_;
			gint _tmp5_;
			gint _tmp6_;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			GtkMenuItem* item = NULL;
			ClosedTabsEntry* _tmp9_;
			const gchar* _tmp10_;
			GtkMenuItem* _tmp11_;
			GtkMenu* _tmp12_;
			GtkMenuItem* _tmp13_;
			GtkMenuItem* _tmp14_;
			_data15_ = g_slice_new0 (Block15Data);
			_data15_->_ref_count_ = 1;
			_data15_->self = g_object_ref (self);
			_entry_index = _entry_index + 1;
			_tmp5_ = _entry_index;
			_tmp6_ = _entry_size;
			if (!(_tmp5_ < _tmp6_)) {
				block15_data_unref (_data15_);
				_data15_ = NULL;
				break;
			}
			_tmp7_ = _entry_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _entry_index);
			_data15_->entry = (ClosedTabsEntry*) _tmp8_;
			_tmp9_ = _data15_->entry;
			_tmp10_ = (*_tmp9_).label;
			_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp10_);
			g_object_ref_sink (_tmp11_);
			item = _tmp11_;
			_tmp12_ = _menu;
			_tmp13_ = item;
			gtk_menu_shell_prepend ((GtkMenuShell*) _tmp12_, (GtkWidget*) _tmp13_);
			_tmp14_ = item;
			g_signal_connect_data (_tmp14_, "activate", (GCallback) __closed_tabs_menu_____lambda17__gtk_menu_item_activate, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
			_g_object_unref0 (item);
			block15_data_unref (_data15_);
			_data15_ = NULL;
		}
	}
	_tmp15_ = closed_tabs_get_empty (self);
	_tmp16_ = _tmp15_;
	if (!_tmp16_) {
		GtkSeparatorMenuItem* separator = NULL;
		GtkSeparatorMenuItem* _tmp17_;
		GtkMenuItem* item = NULL;
		GtkMenuItem* _tmp18_;
		GtkMenu* _tmp19_;
		GtkSeparatorMenuItem* _tmp20_;
		GtkMenu* _tmp21_;
		GtkMenuItem* _tmp22_;
		GtkMenuItem* _tmp23_;
		_tmp17_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp17_);
		separator = _tmp17_;
		_tmp18_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Clear All"));
		g_object_ref_sink (_tmp18_);
		item = _tmp18_;
		_tmp19_ = _menu;
		_tmp20_ = separator;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp19_, (GtkMenuItem*) _tmp20_);
		_tmp21_ = _menu;
		_tmp22_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp21_, _tmp22_);
		_tmp23_ = item;
		g_signal_connect_object (_tmp23_, "activate", (GCallback) __closed_tabs_menu____lambda18__gtk_menu_item_activate, self, 0);
		_g_object_unref0 (item);
		_g_object_unref0 (separator);
	}
	result = _menu;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_OBJECT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_OBJECT) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_object (param_values + 3), data2);
}

void
closed_tabs_entry_copy (const ClosedTabsEntry* self,
                        ClosedTabsEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GraniteWidgetsDroppedDelegate _tmp6_;
	gpointer _tmp6__target;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).restore_data;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).restore_data);
	(*dest).restore_data = _tmp3_;
	_tmp4_ = (*self).icon;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).icon);
	(*dest).icon = _tmp5_;
	_tmp6_ = (*self).dropped_callback;
	_tmp6__target = (*self).dropped_callback_target;
	(*dest).dropped_callback = _tmp6_;
	(*dest).dropped_callback_target = _tmp6__target;
}

void
closed_tabs_entry_destroy (ClosedTabsEntry* self)
{
	_g_free0 ((*self).label);
	_g_free0 ((*self).restore_data);
	_g_object_unref0 ((*self).icon);
}

ClosedTabsEntry*
closed_tabs_entry_dup (const ClosedTabsEntry* self)
{
	ClosedTabsEntry* dup;
	dup = g_new0 (ClosedTabsEntry, 1);
	closed_tabs_entry_copy (self, dup);
	return dup;
}

void
closed_tabs_entry_free (ClosedTabsEntry* self)
{
	closed_tabs_entry_destroy (self);
	g_free (self);
}

static GType
closed_tabs_entry_get_type_once (void)
{
	GType closed_tabs_entry_type_id;
	closed_tabs_entry_type_id = g_boxed_type_register_static ("ClosedTabsEntry", (GBoxedCopyFunc) closed_tabs_entry_dup, (GBoxedFreeFunc) closed_tabs_entry_free);
	return closed_tabs_entry_type_id;
}

GType
closed_tabs_entry_get_type (void)
{
	static volatile gsize closed_tabs_entry_type_id__once = 0;
	if (g_once_init_enter (&closed_tabs_entry_type_id__once)) {
		GType closed_tabs_entry_type_id;
		closed_tabs_entry_type_id = closed_tabs_entry_get_type_once ();
		g_once_init_leave (&closed_tabs_entry_type_id__once, closed_tabs_entry_type_id);
	}
	return closed_tabs_entry_type_id__once;
}

static GObject *
closed_tabs_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClosedTabs * self;
	GeeLinkedList* _tmp0_;
	parent_class = G_OBJECT_CLASS (closed_tabs_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLOSED_TABS, ClosedTabs);
	_tmp0_ = gee_linked_list_new (CLOSED_TABS_TYPE_ENTRY, (GBoxedCopyFunc) closed_tabs_entry_dup, (GDestroyNotify) closed_tabs_entry_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->closed_tabs);
	self->priv->closed_tabs = _tmp0_;
	return obj;
}

static void
closed_tabs_class_init (ClosedTabsClass * klass,
                        gpointer klass_data)
{
	closed_tabs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClosedTabs_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_closed_tabs_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_closed_tabs_set_property;
	G_OBJECT_CLASS (klass)->constructor = closed_tabs_constructor;
	G_OBJECT_CLASS (klass)->finalize = closed_tabs_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOSED_TABS_MAX_RESTORABLE_TABS_PROPERTY, closed_tabs_properties[CLOSED_TABS_MAX_RESTORABLE_TABS_PROPERTY] = g_param_spec_int ("max-restorable-tabs", "max-restorable-tabs", "max-restorable-tabs", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOSED_TABS_EMPTY_PROPERTY, closed_tabs_properties[CLOSED_TABS_EMPTY_PROPERTY] = g_param_spec_boolean ("empty", "empty", "empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOSED_TABS_MENU_PROPERTY, closed_tabs_properties[CLOSED_TABS_MENU_PROPERTY] = g_param_spec_object ("menu", "menu", "menu", gtk_menu_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	closed_tabs_signals[CLOSED_TABS_RESTORED_SIGNAL] = g_signal_new ("restored", TYPE_CLOSED_TABS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_OBJECT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, g_icon_get_type ());
	closed_tabs_signals[CLOSED_TABS_CLEARED_SIGNAL] = g_signal_new ("cleared", TYPE_CLOSED_TABS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
closed_tabs_instance_init (ClosedTabs * self,
                           gpointer klass)
{
	self->priv = closed_tabs_get_instance_private (self);
	self->priv->_max_restorable_tabs = 10;
}

static void
closed_tabs_finalize (GObject * obj)
{
	ClosedTabs * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLOSED_TABS, ClosedTabs);
	_g_object_unref0 (self->priv->closed_tabs);
	G_OBJECT_CLASS (closed_tabs_parent_class)->finalize (obj);
}

static GType
closed_tabs_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClosedTabsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) closed_tabs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClosedTabs), 0, (GInstanceInitFunc) closed_tabs_instance_init, NULL };
	GType closed_tabs_type_id;
	closed_tabs_type_id = g_type_register_static (G_TYPE_OBJECT, "ClosedTabs", &g_define_type_info, 0);
	ClosedTabs_private_offset = g_type_add_instance_private (closed_tabs_type_id, sizeof (ClosedTabsPrivate));
	return closed_tabs_type_id;
}

GType
closed_tabs_get_type (void)
{
	static volatile gsize closed_tabs_type_id__once = 0;
	if (g_once_init_enter (&closed_tabs_type_id__once)) {
		GType closed_tabs_type_id;
		closed_tabs_type_id = closed_tabs_get_type_once ();
		g_once_init_leave (&closed_tabs_type_id__once, closed_tabs_type_id);
	}
	return closed_tabs_type_id__once;
}

static void
_vala_closed_tabs_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	ClosedTabs * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CLOSED_TABS, ClosedTabs);
	switch (property_id) {
		case CLOSED_TABS_MAX_RESTORABLE_TABS_PROPERTY:
		g_value_set_int (value, closed_tabs_get_max_restorable_tabs (self));
		break;
		case CLOSED_TABS_EMPTY_PROPERTY:
		g_value_set_boolean (value, closed_tabs_get_empty (self));
		break;
		case CLOSED_TABS_MENU_PROPERTY:
		g_value_take_object (value, closed_tabs_get_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_closed_tabs_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	ClosedTabs * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CLOSED_TABS, ClosedTabs);
	switch (property_id) {
		case CLOSED_TABS_MAX_RESTORABLE_TABS_PROPERTY:
		closed_tabs_set_max_restorable_tabs (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
dynamic_notebook_get_instance_private (DynamicNotebook* self)
{
	return G_STRUCT_MEMBER_P (self, DynamicNotebook_private_offset);
}

static GType
dynamic_notebook_tab_bar_behavior_get_type_once (void)
{
	static const GEnumValue values[] = {{DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_ALWAYS, "DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_ALWAYS", "always"}, {DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_SINGLE, "DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_SINGLE", "single"}, {DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_NEVER, "DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_NEVER", "never"}, {0, NULL, NULL}};
	GType dynamic_notebook_tab_bar_behavior_type_id;
	dynamic_notebook_tab_bar_behavior_type_id = g_enum_register_static ("DynamicNotebookTabBarBehavior", values);
	return dynamic_notebook_tab_bar_behavior_type_id;
}

GType
dynamic_notebook_tab_bar_behavior_get_type (void)
{
	static volatile gsize dynamic_notebook_tab_bar_behavior_type_id__once = 0;
	if (g_once_init_enter (&dynamic_notebook_tab_bar_behavior_type_id__once)) {
		GType dynamic_notebook_tab_bar_behavior_type_id;
		dynamic_notebook_tab_bar_behavior_type_id = dynamic_notebook_tab_bar_behavior_get_type_once ();
		g_once_init_leave (&dynamic_notebook_tab_bar_behavior_type_id__once, dynamic_notebook_tab_bar_behavior_type_id);
	}
	return dynamic_notebook_tab_bar_behavior_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

/**
         * Create a new dynamic notebook
         */
DynamicNotebook*
dynamic_notebook_construct (GType object_type)
{
	DynamicNotebook * self = NULL;
	self = (DynamicNotebook*) g_object_new (object_type, NULL);
	return self;
}

DynamicNotebook*
dynamic_notebook_new (void)
{
	return dynamic_notebook_construct (TYPE_DYNAMIC_NOTEBOOK);
}

static void
dynamic_notebook_on_switch_page (DynamicNotebook* self,
                                 GtkWidget* page,
                                 guint pagenum)
{
	TabPageContainer* cont = NULL;
	TabPageContainer* _tmp0_;
	TabPageContainer* _tmp1_;
	Tab* new_tab = NULL;
	TabPageContainer* _tmp2_;
	Tab* _tmp3_;
	Tab* _tmp4_;
	Tab* _tmp5_;
	Tab* _tmp6_;
	Tab* _tmp8_;
	Tab* _tmp9_;
	Tab* _tmp10_;
	Tab* _tmp11_;
	Tab* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = _g_object_ref0 (IS_TAB_PAGE_CONTAINER (page) ? ((TabPageContainer*) page) : NULL);
	cont = _tmp0_;
	_tmp1_ = cont;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (cont);
		return;
	}
	_tmp2_ = cont;
	_tmp3_ = tab_page_container_get_tab (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	new_tab = _tmp5_;
	_tmp6_ = self->priv->old_tab;
	if (_tmp6_ != NULL) {
		Tab* _tmp7_;
		_tmp7_ = self->priv->old_tab;
		tab_set_is_current_tab (_tmp7_, FALSE);
	}
	_tmp8_ = new_tab;
	tab_set_is_current_tab (_tmp8_, TRUE);
	_tmp9_ = self->priv->old_tab;
	_tmp10_ = new_tab;
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_SWITCHED_SIGNAL], 0, _tmp9_, _tmp10_);
	_tmp11_ = new_tab;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->old_tab);
	self->priv->old_tab = _tmp12_;
	_g_object_unref0 (new_tab);
	_g_object_unref0 (cont);
}

static void
dynamic_notebook_on_page_added (DynamicNotebook* self,
                                GtkWidget* page,
                                guint pagenum)
{
	TabPageContainer* cont = NULL;
	TabPageContainer* _tmp0_;
	TabPageContainer* _tmp1_;
	Tab* t = NULL;
	TabPageContainer* _tmp2_;
	Tab* _tmp3_;
	Tab* _tmp4_;
	Tab* _tmp5_;
	Tab* _tmp6_;
	Tab* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = _g_object_ref0 (IS_TAB_PAGE_CONTAINER (page) ? ((TabPageContainer*) page) : NULL);
	cont = _tmp0_;
	_tmp1_ = cont;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (cont);
		return;
	}
	_tmp2_ = cont;
	_tmp3_ = tab_page_container_get_tab (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	t = _tmp5_;
	_tmp6_ = t;
	dynamic_notebook_insert_callbacks (self, _tmp6_);
	_tmp7_ = t;
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_ADDED_SIGNAL], 0, _tmp7_);
	dynamic_notebook_update_tabs_visibility (self);
	_g_object_unref0 (t);
	_g_object_unref0 (cont);
}

static void
dynamic_notebook_on_page_removed (DynamicNotebook* self,
                                  GtkWidget* page,
                                  guint pagenum)
{
	TabPageContainer* cont = NULL;
	TabPageContainer* _tmp0_;
	TabPageContainer* _tmp1_;
	Tab* t = NULL;
	TabPageContainer* _tmp2_;
	Tab* _tmp3_;
	Tab* _tmp4_;
	Tab* _tmp5_;
	Tab* _tmp6_;
	Tab* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = _g_object_ref0 (IS_TAB_PAGE_CONTAINER (page) ? ((TabPageContainer*) page) : NULL);
	cont = _tmp0_;
	_tmp1_ = cont;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (cont);
		return;
	}
	_tmp2_ = cont;
	_tmp3_ = tab_page_container_get_tab (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	t = _tmp5_;
	_tmp6_ = t;
	dynamic_notebook_remove_callbacks (self, _tmp6_);
	_tmp7_ = t;
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_REMOVED_SIGNAL], 0, _tmp7_);
	dynamic_notebook_update_tabs_visibility (self);
	_g_object_unref0 (t);
	_g_object_unref0 (cont);
}

static void
dynamic_notebook_on_page_reordered (DynamicNotebook* self,
                                    GtkWidget* page,
                                    guint pagenum)
{
	Tab* _tmp0_;
	Tab* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = tab_page_container_get_tab (IS_TAB_PAGE_CONTAINER (page) ? ((TabPageContainer*) page) : NULL);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_REORDERED_SIGNAL], 0, _tmp1_, (gint) pagenum);
	dynamic_notebook_recalc_order (self);
}

static GtkNotebook*
dynamic_notebook_on_create_window (DynamicNotebook* self,
                                   GtkWidget* page,
                                   gint x,
                                   gint y)
{
	Tab* tab = NULL;
	GtkNotebook* _tmp0_;
	GtkWidget* _tmp1_;
	Tab* _tmp2_;
	GtkNotebook* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_tab_label (_tmp0_, page);
	_tmp2_ = _g_object_ref0 (IS_TAB (_tmp1_) ? ((Tab*) _tmp1_) : NULL);
	tab = _tmp2_;
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_MOVED_SIGNAL], 0, tab, x, y);
	dynamic_notebook_recalc_order (self);
	result = G_TYPE_CHECK_INSTANCE_CAST (NULL, gtk_notebook_get_type (), GtkNotebook);
	_g_object_unref0 (tab);
	return result;
}

static void
dynamic_notebook_recalc_order (DynamicNotebook* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint pinned_tabs = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = dynamic_notebook_get_n_tabs (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = dynamic_notebook_get_force_left (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	pinned_tabs = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GtkNotebook* _tmp7_;
				Tab* tab = NULL;
				GtkNotebook* _tmp8_;
				GtkNotebook* _tmp9_;
				GtkWidget* _tmp10_;
				GtkWidget* _tmp11_;
				Tab* _tmp12_;
				gboolean _tmp13_ = FALSE;
				Tab* _tmp14_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->priv->notebook;
				if (!(i < gtk_notebook_get_n_pages (_tmp7_))) {
					break;
				}
				_tmp8_ = self->priv->notebook;
				_tmp9_ = self->priv->notebook;
				_tmp10_ = gtk_notebook_get_nth_page (_tmp9_, i);
				_tmp11_ = gtk_notebook_get_tab_label (_tmp8_, _tmp10_);
				_tmp12_ = _g_object_ref0 (IS_TAB (_tmp11_) ? ((Tab*) _tmp11_) : NULL);
				tab = _tmp12_;
				_tmp14_ = tab;
				if (_tmp14_ != NULL) {
					Tab* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp15_ = tab;
					_tmp16_ = tab_get_pinned (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp13_ = _tmp17_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gint _tmp18_;
					_tmp18_ = pinned_tabs;
					pinned_tabs = _tmp18_ + 1;
				}
				_g_object_unref0 (tab);
			}
		}
	}
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gint sel = 0;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = p;
					p = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				if (!(p < pinned_tabs)) {
					break;
				}
				sel = p;
				{
					gint i = 0;
					i = p;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							GtkNotebook* _tmp23_;
							Tab* tab = NULL;
							GtkNotebook* _tmp24_;
							GtkNotebook* _tmp25_;
							GtkWidget* _tmp26_;
							GtkWidget* _tmp27_;
							Tab* _tmp28_;
							gboolean _tmp29_ = FALSE;
							Tab* _tmp30_;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = i;
								i = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp23_ = self->priv->notebook;
							if (!(i < gtk_notebook_get_n_pages (_tmp23_))) {
								break;
							}
							_tmp24_ = self->priv->notebook;
							_tmp25_ = self->priv->notebook;
							_tmp26_ = gtk_notebook_get_nth_page (_tmp25_, i);
							_tmp27_ = gtk_notebook_get_tab_label (_tmp24_, _tmp26_);
							_tmp28_ = _g_object_ref0 (IS_TAB (_tmp27_) ? ((Tab*) _tmp27_) : NULL);
							tab = _tmp28_;
							_tmp30_ = tab;
							if (_tmp30_ != NULL) {
								Tab* _tmp31_;
								gboolean _tmp32_;
								gboolean _tmp33_;
								_tmp31_ = tab;
								_tmp32_ = tab_get_pinned (_tmp31_);
								_tmp33_ = _tmp32_;
								_tmp29_ = _tmp33_;
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								sel = i;
								_g_object_unref0 (tab);
								break;
							}
							_g_object_unref0 (tab);
						}
					}
				}
				if (sel != p) {
					GtkNotebook* _tmp34_;
					GtkNotebook* _tmp35_;
					GtkWidget* _tmp36_;
					_tmp34_ = self->priv->notebook;
					_tmp35_ = self->priv->notebook;
					_tmp36_ = gtk_notebook_get_nth_page (_tmp35_, sel);
					gtk_notebook_reorder_child (_tmp34_, _tmp36_, p);
				}
			}
		}
	}
}

static void
dynamic_notebook_recalc_size (DynamicNotebook* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint pinned_tabs = 0;
	gint unpinned_tabs = 0;
	gint offset = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = dynamic_notebook_get_n_tabs (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	pinned_tabs = 0;
	unpinned_tabs = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GtkNotebook* _tmp4_;
				GtkNotebook* _tmp5_;
				GtkNotebook* _tmp6_;
				GtkWidget* _tmp7_;
				GtkWidget* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->notebook;
				if (!(i < gtk_notebook_get_n_pages (_tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->notebook;
				_tmp6_ = self->priv->notebook;
				_tmp7_ = gtk_notebook_get_nth_page (_tmp6_, i);
				_tmp8_ = gtk_notebook_get_tab_label (_tmp5_, _tmp7_);
				_tmp9_ = tab_get_pinned (IS_TAB (_tmp8_) ? ((Tab*) _tmp8_) : NULL);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					gint _tmp11_;
					_tmp11_ = pinned_tabs;
					pinned_tabs = _tmp11_ + 1;
				} else {
					gint _tmp12_;
					_tmp12_ = unpinned_tabs;
					unpinned_tabs = _tmp12_ + 1;
				}
			}
		}
	}
	if (unpinned_tabs == 0) {
		unpinned_tabs = 1;
	}
	offset = 130;
	self->priv->tab_width = ((gtk_widget_get_allocated_width ((GtkWidget*) self) - offset) - (pinned_tabs * DYNAMIC_NOTEBOOK_TAB_WIDTH_PINNED)) / unpinned_tabs;
	if (self->priv->tab_width > DYNAMIC_NOTEBOOK_MAX_TAB_WIDTH) {
		self->priv->tab_width = DYNAMIC_NOTEBOOK_MAX_TAB_WIDTH;
	}
	if (self->priv->tab_width < 0) {
		self->priv->tab_width = 0;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				GtkNotebook* _tmp15_;
				GtkNotebook* _tmp16_;
				GtkNotebook* _tmp17_;
				GtkWidget* _tmp18_;
				GtkWidget* _tmp19_;
				GtkNotebook* _tmp20_;
				GtkNotebook* _tmp21_;
				GtkWidget* _tmp22_;
				GtkWidget* _tmp23_;
				gboolean _tmp24_;
				gboolean _tmp25_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = self->priv->notebook;
				if (!(i < gtk_notebook_get_n_pages (_tmp15_))) {
					break;
				}
				_tmp16_ = self->priv->notebook;
				_tmp17_ = self->priv->notebook;
				_tmp18_ = gtk_notebook_get_nth_page (_tmp17_, i);
				_tmp19_ = gtk_notebook_get_tab_label (_tmp16_, _tmp18_);
				g_object_set (_tmp19_, "width-request", self->priv->tab_width, NULL);
				_tmp20_ = self->priv->notebook;
				_tmp21_ = self->priv->notebook;
				_tmp22_ = gtk_notebook_get_nth_page (_tmp21_, i);
				_tmp23_ = gtk_notebook_get_tab_label (_tmp20_, _tmp22_);
				_tmp24_ = tab_get_pinned (IS_TAB (_tmp23_) ? ((Tab*) _tmp23_) : NULL);
				_tmp25_ = _tmp24_;
				if (_tmp25_) {
					GtkNotebook* _tmp26_;
					GtkNotebook* _tmp27_;
					GtkWidget* _tmp28_;
					GtkWidget* _tmp29_;
					_tmp26_ = self->priv->notebook;
					_tmp27_ = self->priv->notebook;
					_tmp28_ = gtk_notebook_get_nth_page (_tmp27_, i);
					_tmp29_ = gtk_notebook_get_tab_label (_tmp26_, _tmp28_);
					g_object_set (_tmp29_, "width-request", DYNAMIC_NOTEBOOK_TAB_WIDTH_PINNED, NULL);
				}
			}
		}
	}
}

static void
dynamic_notebook_restore_last_tab (DynamicNotebook* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ClosedTabsEntry restored = {0};
	ClosedTabs* _tmp6_;
	ClosedTabsEntry _tmp7_ = {0};
	GtkButton* _tmp8_;
	ClosedTabs* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GtkMenuItem* _tmp12_;
	ClosedTabs* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ClosedTabsEntry _tmp16_;
	const gchar* _tmp17_;
	ClosedTabsEntry _tmp18_;
	const gchar* _tmp19_;
	ClosedTabsEntry _tmp20_;
	GIcon* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp1_ = dynamic_notebook_get_allow_restoring (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		ClosedTabs* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->closed_tabs;
		_tmp4_ = closed_tabs_get_empty (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = self->priv->closed_tabs;
	closed_tabs_pop (_tmp6_, &_tmp7_);
	restored = _tmp7_;
	_tmp8_ = self->priv->restore_button;
	_tmp9_ = self->priv->closed_tabs;
	_tmp10_ = closed_tabs_get_empty (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, !_tmp11_);
	_tmp12_ = self->priv->restore_tab_m;
	_tmp13_ = self->priv->closed_tabs;
	_tmp14_ = closed_tabs_get_empty (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, !_tmp15_);
	_tmp16_ = restored;
	_tmp17_ = _tmp16_.label;
	_tmp18_ = restored;
	_tmp19_ = _tmp18_.restore_data;
	_tmp20_ = restored;
	_tmp21_ = _tmp20_.icon;
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_RESTORED_SIGNAL], 0, _tmp17_, _tmp19_, _tmp21_);
	closed_tabs_entry_destroy (&restored);
}

static void
dynamic_notebook_switch_pin_tab (DynamicNotebook* self,
                                 Tab* tab)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = dynamic_notebook_get_allow_pinning (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	dynamic_notebook_recalc_order (self);
	dynamic_notebook_recalc_size (self);
}

void
dynamic_notebook_remove_tab (DynamicNotebook* self,
                             Tab* tab)
{
	gint pos = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	pos = dynamic_notebook_get_tab_position (self, tab);
	if (pos != -1) {
		GtkNotebook* _tmp0_;
		_tmp0_ = self->priv->notebook;
		gtk_notebook_remove_page (_tmp0_, pos);
	}
}

void
dynamic_notebook_next_page (DynamicNotebook* self)
{
	gint _tmp0_ = 0;
	GtkNotebook* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkNotebook* _tmp4_;
	GtkNotebook* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->notebook;
	g_object_get (_tmp1_, "page", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->notebook;
	if ((_tmp3_ + 1) >= gtk_notebook_get_n_pages (_tmp4_)) {
		GtkNotebook* _tmp5_;
		_tmp5_ = self->priv->notebook;
		g_object_set (_tmp5_, "page", 0, NULL);
		_tmp0_ = 0;
	} else {
		GtkNotebook* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->notebook;
		g_object_get (_tmp6_, "page", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ + 1;
	}
	_tmp9_ = self->priv->notebook;
	g_object_set (_tmp9_, "page", _tmp0_, NULL);
}

void
dynamic_notebook_previous_page (DynamicNotebook* self)
{
	gint _tmp0_ = 0;
	GtkNotebook* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkNotebook* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->notebook;
	g_object_get (_tmp1_, "page", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if ((_tmp3_ - 1) < 0) {
		GtkNotebook* _tmp4_;
		GtkNotebook* _tmp5_;
		_tmp4_ = self->priv->notebook;
		_tmp5_ = self->priv->notebook;
		g_object_set (_tmp4_, "page", gtk_notebook_get_n_pages (_tmp5_) - 1, NULL);
		_tmp0_ = gtk_notebook_get_n_pages (_tmp5_) - 1;
	} else {
		GtkNotebook* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->notebook;
		g_object_get (_tmp6_, "page", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ - 1;
	}
	_tmp9_ = self->priv->notebook;
	g_object_set (_tmp9_, "page", _tmp0_, NULL);
}

static void
dynamic_notebook_real_show (GtkWidget* base)
{
	DynamicNotebook * self;
	GtkNotebook* _tmp0_;
	self = (DynamicNotebook*) base;
	GTK_WIDGET_CLASS (dynamic_notebook_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox));
	_tmp0_ = self->priv->notebook;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

GList*
dynamic_notebook_get_children (DynamicNotebook* self)
{
	GList* list = NULL;
	GtkNotebook* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkContainer* cont = NULL;
				GtkWidget* _tmp2_;
				GtkContainer* _tmp3_;
				GtkContainer* _tmp4_;
				_tmp2_ = child;
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp2_) : NULL);
				cont = _tmp3_;
				_tmp4_ = cont;
				if (_tmp4_ != NULL) {
					GtkContainer* _tmp5_;
					GList* _tmp6_;
					GList* _tmp7_;
					gconstpointer _tmp8_;
					GtkWidget* _tmp9_;
					_tmp5_ = cont;
					_tmp6_ = gtk_container_get_children (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
					_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
					list = g_list_append (list, _tmp9_);
					(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_list_free (_tmp7_), NULL));
				}
				_g_object_unref0 (cont);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = list;
	return result;
}

gint
dynamic_notebook_get_tab_position (DynamicNotebook* self,
                                   Tab* tab)
{
	GtkNotebook* _tmp0_;
	TabPageContainer* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (tab != NULL, 0);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = tab->page_container;
	result = gtk_notebook_page_num (_tmp0_, (GtkWidget*) _tmp1_);
	return result;
}

void
dynamic_notebook_set_tab_position (DynamicNotebook* self,
                                   Tab* tab,
                                   gint position)
{
	GtkNotebook* _tmp0_;
	TabPageContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = tab->page_container;
	gtk_notebook_reorder_child (_tmp0_, (GtkWidget*) _tmp1_, position);
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_REORDERED_SIGNAL], 0, tab, position);
	dynamic_notebook_recalc_order (self);
}

Tab*
dynamic_notebook_get_tab_by_index (DynamicNotebook* self,
                                   gint index)
{
	GtkNotebook* _tmp0_;
	GtkNotebook* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	Tab* _tmp4_;
	Tab* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = self->priv->notebook;
	_tmp2_ = gtk_notebook_get_nth_page (_tmp1_, index);
	_tmp3_ = gtk_notebook_get_tab_label (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 (IS_TAB (_tmp3_) ? ((Tab*) _tmp3_) : NULL);
	result = _tmp4_;
	return result;
}

Tab*
dynamic_notebook_get_tab_by_widget (DynamicNotebook* self,
                                    GtkWidget* widget)
{
	GtkNotebook* _tmp0_;
	GtkContainer* _tmp1_;
	GtkWidget* _tmp2_;
	Tab* _tmp3_;
	Tab* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_widget_get_parent (widget);
	_tmp2_ = gtk_notebook_get_tab_label (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (IS_TAB (_tmp2_) ? ((Tab*) _tmp2_) : NULL);
	result = _tmp3_;
	return result;
}

GtkWidget*
dynamic_notebook_get_nth_page (DynamicNotebook* self,
                               gint index)
{
	GtkNotebook* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_nth_page (_tmp0_, index);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

guint
dynamic_notebook_insert_tab (DynamicNotebook* self,
                             Tab* tab,
                             gint index)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gint i = 0;
	GtkNotebook* _tmp7_;
	TabPageContainer* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkNotebook* _tmp11_;
	TabPageContainer* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GtkMenuItem* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GtkMenuItem* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GtkMenuItem* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (tab != NULL, 0U);
	_tmp0_ = dynamic_notebook_get_tabs (self);
	_tmp1_ = _tmp0_;
	g_return_val_if_fail (g_list_index (_tmp1_, tab) < 0, 0);
	i = 0;
	if (index <= -1) {
		GtkNotebook* _tmp2_;
		TabPageContainer* _tmp3_;
		GtkNotebook* _tmp4_;
		_tmp2_ = self->priv->notebook;
		_tmp3_ = tab->page_container;
		_tmp4_ = self->priv->notebook;
		i = gtk_notebook_insert_page (_tmp2_, (GtkWidget*) _tmp3_, (GtkWidget*) tab, gtk_notebook_get_n_pages (_tmp4_));
	} else {
		GtkNotebook* _tmp5_;
		TabPageContainer* _tmp6_;
		_tmp5_ = self->priv->notebook;
		_tmp6_ = tab->page_container;
		i = gtk_notebook_insert_page (_tmp5_, (GtkWidget*) _tmp6_, (GtkWidget*) tab, index);
	}
	_tmp7_ = self->priv->notebook;
	_tmp8_ = tab->page_container;
	_tmp9_ = dynamic_notebook_get_allow_drag (self);
	_tmp10_ = _tmp9_;
	gtk_notebook_set_tab_reorderable (_tmp7_, (GtkWidget*) _tmp8_, _tmp10_);
	_tmp11_ = self->priv->notebook;
	_tmp12_ = tab->page_container;
	_tmp13_ = dynamic_notebook_get_allow_new_window (self);
	_tmp14_ = _tmp13_;
	gtk_notebook_set_tab_detachable (_tmp11_, (GtkWidget*) _tmp12_, _tmp14_);
	_tmp15_ = tab->duplicate_m;
	_tmp16_ = dynamic_notebook_get_allow_duplication (self);
	_tmp17_ = _tmp16_;
	gtk_widget_set_visible ((GtkWidget*) _tmp15_, _tmp17_);
	_tmp18_ = tab->new_window_m;
	_tmp19_ = dynamic_notebook_get_allow_new_window (self);
	_tmp20_ = _tmp19_;
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, _tmp20_);
	_tmp21_ = tab->pin_m;
	_tmp22_ = dynamic_notebook_get_allow_pinning (self);
	_tmp23_ = _tmp22_;
	gtk_widget_set_visible ((GtkWidget*) _tmp21_, _tmp23_);
	_tmp24_ = dynamic_notebook_get_allow_pinning (self);
	_tmp25_ = _tmp24_;
	tab_set_pinnable (tab, _tmp25_);
	tab_set_pinned (tab, FALSE);
	g_object_set ((GtkWidget*) tab, "width-request", self->priv->tab_width, NULL);
	dynamic_notebook_recalc_size (self);
	dynamic_notebook_recalc_order (self);
	_tmp26_ = dynamic_notebook_get_tabs_closable (self);
	_tmp27_ = _tmp26_;
	if (!_tmp27_) {
		tab_set_closable (tab, FALSE);
	}
	result = (guint) i;
	return result;
}

static void
_dynamic_notebook_on_tab_closed_tab_closed (Tab* _sender,
                                            gpointer self)
{
	dynamic_notebook_on_tab_closed ((DynamicNotebook*) self, _sender);
}

static void
_dynamic_notebook_on_close_others_tab_close_others (Tab* _sender,
                                                    gpointer self)
{
	dynamic_notebook_on_close_others ((DynamicNotebook*) self, _sender);
}

static void
_dynamic_notebook_on_new_window_tab_new_window (Tab* _sender,
                                                gpointer self)
{
	dynamic_notebook_on_new_window ((DynamicNotebook*) self, _sender);
}

static void
_dynamic_notebook_on_duplicate_tab_duplicate (Tab* _sender,
                                              gpointer self)
{
	dynamic_notebook_on_duplicate ((DynamicNotebook*) self, _sender);
}

static void
_dynamic_notebook_on_pin_switch_tab_pin_switch (Tab* _sender,
                                                gpointer self)
{
	dynamic_notebook_on_pin_switch ((DynamicNotebook*) self, _sender);
}

static void
dynamic_notebook_insert_callbacks (DynamicNotebook* self,
                                   Tab* tab)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	g_signal_connect_object (tab, "closed", (GCallback) _dynamic_notebook_on_tab_closed_tab_closed, self, 0);
	g_signal_connect_object (tab, "close-others", (GCallback) _dynamic_notebook_on_close_others_tab_close_others, self, 0);
	g_signal_connect_object (tab, "new-window", (GCallback) _dynamic_notebook_on_new_window_tab_new_window, self, 0);
	g_signal_connect_object (tab, "duplicate", (GCallback) _dynamic_notebook_on_duplicate_tab_duplicate, self, 0);
	g_signal_connect_object (tab, "pin-switch", (GCallback) _dynamic_notebook_on_pin_switch_tab_pin_switch, self, 0);
}

static void
dynamic_notebook_remove_callbacks (DynamicNotebook* self,
                                   Tab* tab)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	g_signal_parse_name ("closed", TYPE_TAB, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tab, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _dynamic_notebook_on_tab_closed_tab_closed, self);
	g_signal_parse_name ("close-others", TYPE_TAB, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tab, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _dynamic_notebook_on_close_others_tab_close_others, self);
	g_signal_parse_name ("new-window", TYPE_TAB, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tab, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _dynamic_notebook_on_new_window_tab_new_window, self);
	g_signal_parse_name ("duplicate", TYPE_TAB, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tab, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _dynamic_notebook_on_duplicate_tab_duplicate, self);
	g_signal_parse_name ("pin-switch", TYPE_TAB, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tab, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _dynamic_notebook_on_pin_switch_tab_pin_switch, self);
}

static void
dynamic_notebook_on_tab_closed (DynamicNotebook* self,
                                Tab* tab)
{
	gint pos = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	if (g_signal_has_handler_pending (self, g_signal_lookup ("close-tab-requested", TYPE_DYNAMIC_NOTEBOOK), (GQuark) 0, TRUE)) {
		gboolean sure = FALSE;
		gboolean _tmp0_ = FALSE;
		g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_CLOSE_TAB_REQUESTED_SIGNAL], 0, tab, &_tmp0_);
		sure = _tmp0_;
		if (!sure) {
			return;
		}
	}
	pos = dynamic_notebook_get_tab_position (self, tab);
	dynamic_notebook_remove_tab (self, tab);
	if (pos != -1) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkContainer* _tmp4_;
		_tmp2_ = tab_get_page (tab);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_widget_get_parent (_tmp3_);
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp5_ = tab_get_page (tab);
		_tmp6_ = _tmp5_;
		gtk_widget_unparent (_tmp6_);
	}
	_tmp8_ = tab_get_label (tab);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = tab_get_restore_data (tab);
		_tmp11_ = _tmp10_;
		_tmp7_ = g_strcmp0 (_tmp11_, "") != 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ClosedTabs* _tmp12_;
		GtkButton* _tmp13_;
		ClosedTabs* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		GtkMenuItem* _tmp17_;
		ClosedTabs* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp12_ = self->priv->closed_tabs;
		closed_tabs_push (_tmp12_, tab);
		_tmp13_ = self->priv->restore_button;
		_tmp14_ = self->priv->closed_tabs;
		_tmp15_ = closed_tabs_get_empty (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp16_);
		_tmp17_ = self->priv->restore_tab_m;
		_tmp18_ = self->priv->closed_tabs;
		_tmp19_ = closed_tabs_get_empty (_tmp18_);
		_tmp20_ = _tmp19_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, !_tmp20_);
	}
}

static void
dynamic_notebook_on_close_others (DynamicNotebook* self,
                                  Tab* tab)
{
	gint num = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	num = 0;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GList* _tmp2_;
				GList* _tmp3_;
				GList* _tmp4_;
				GList* _tmp5_;
				gconstpointer _tmp6_;
				gint _tmp13_;
				gint _tmp14_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = j;
					j = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = dynamic_notebook_get_tabs (self);
				_tmp3_ = _tmp2_;
				if (!(((guint) j) < g_list_length (_tmp3_))) {
					break;
				}
				_tmp4_ = dynamic_notebook_get_tabs (self);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_list_nth_data (_tmp5_, (guint) j);
				if (tab != ((Tab*) _tmp6_)) {
					GList* _tmp7_;
					GList* _tmp8_;
					gconstpointer _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp7_ = dynamic_notebook_get_tabs (self);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_list_nth_data (_tmp8_, (guint) j);
					g_signal_emit ((Tab*) _tmp9_, tab_signals[TAB_CLOSED_SIGNAL], 0);
					_tmp10_ = dynamic_notebook_get_n_tabs (self);
					_tmp11_ = _tmp10_;
					if (num == _tmp11_) {
						break;
					}
					_tmp12_ = j;
					j = _tmp12_ - 1;
				}
				_tmp13_ = dynamic_notebook_get_n_tabs (self);
				_tmp14_ = _tmp13_;
				num = _tmp14_;
			}
		}
	}
}

static void
dynamic_notebook_on_new_window (DynamicNotebook* self,
                                Tab* tab)
{
	GtkNotebook* _tmp0_;
	TabPageContainer* _tmp1_;
	GtkNotebook* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = tab->page_container;
	g_signal_emit_by_name (_tmp0_, "create-window", (GtkWidget*) _tmp1_, 0, 0, &_tmp2_);
}

static void
dynamic_notebook_on_duplicate (DynamicNotebook* self,
                               Tab* tab)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_DUPLICATED_SIGNAL], 0, tab);
}

static void
dynamic_notebook_on_pin_switch (DynamicNotebook* self,
                                Tab* tab)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	dynamic_notebook_switch_pin_tab (self, tab);
}

static void
dynamic_notebook_update_tabs_visibility (DynamicNotebook* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_tab_bar_behavior == DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_SINGLE) {
		GtkNotebook* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->notebook;
		_tmp1_ = dynamic_notebook_get_n_tabs (self);
		_tmp2_ = _tmp1_;
		gtk_notebook_set_show_tabs (_tmp0_, _tmp2_ > 1);
	} else {
		if (self->priv->_tab_bar_behavior == DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_NEVER) {
			GtkNotebook* _tmp3_;
			_tmp3_ = self->priv->notebook;
			gtk_notebook_set_show_tabs (_tmp3_, FALSE);
		} else {
			if (self->priv->_tab_bar_behavior == DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_ALWAYS) {
				GtkNotebook* _tmp4_;
				_tmp4_ = self->priv->notebook;
				gtk_notebook_set_show_tabs (_tmp4_, TRUE);
			}
		}
	}
}

gint
dynamic_notebook_get_n_tabs (DynamicNotebook* self)
{
	gint result;
	GtkNotebook* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->notebook;
	result = gtk_notebook_get_n_pages (_tmp0_);
	return result;
}

gboolean
dynamic_notebook_get_show_tabs (DynamicNotebook* self)
{
	gboolean result;
	GtkNotebook* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_show_tabs (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
dynamic_notebook_set_show_tabs (DynamicNotebook* self,
                                gboolean value)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_SHOW_TABS_PROPERTY]);
}

gboolean
dynamic_notebook_get_show_icons (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_icons;
	return result;
}

void
dynamic_notebook_set_show_icons (DynamicNotebook* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_icons = value;
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_SHOW_ICONS_PROPERTY]);
}

gboolean
dynamic_notebook_get_tabs_closable (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tabs_closable;
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		DynamicNotebook* self;
		self = _data16_->self;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
_dynamic_notebook_tabs_closable____lambda21_ (Block16Data* _data16_,
                                              Tab* t)
{
	DynamicNotebook* self;
	self = _data16_->self;
	g_return_if_fail (t != NULL);
	tab_set_closable (t, _data16_->value);
}

static void
__dynamic_notebook_tabs_closable____lambda21__gfunc (gconstpointer data,
                                                     gpointer self)
{
	_dynamic_notebook_tabs_closable____lambda21_ (self, (Tab*) data);
}

void
dynamic_notebook_set_tabs_closable (DynamicNotebook* self,
                                    gboolean value)
{
	Block16Data* _data16_;
	g_return_if_fail (self != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->value = value;
	if (_data16_->value != self->priv->_tabs_closable) {
		GList* _tmp0_;
		GList* _tmp1_;
		_tmp0_ = dynamic_notebook_get_tabs (self);
		_tmp1_ = _tmp0_;
		g_list_foreach (_tmp1_, __dynamic_notebook_tabs_closable____lambda21__gfunc, _data16_);
	}
	self->priv->_tabs_closable = _data16_->value;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_TABS_CLOSABLE_PROPERTY]);
}

gboolean
dynamic_notebook_get_allow_drag (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_drag;
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		DynamicNotebook* self;
		self = _data17_->self;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
_dynamic_notebook_allow_drag___lambda19_ (Block17Data* _data17_,
                                          Tab* t)
{
	DynamicNotebook* self;
	GtkNotebook* _tmp0_;
	TabPageContainer* _tmp1_;
	self = _data17_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = t->page_container;
	gtk_notebook_set_tab_reorderable (_tmp0_, (GtkWidget*) _tmp1_, _data17_->value);
}

static void
__dynamic_notebook_allow_drag___lambda19__gfunc (gconstpointer data,
                                                 gpointer self)
{
	_dynamic_notebook_allow_drag___lambda19_ (self, (Tab*) data);
}

void
dynamic_notebook_set_allow_drag (DynamicNotebook* self,
                                 gboolean value)
{
	Block17Data* _data17_;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_data17_->value = value;
	self->priv->_allow_drag = _data17_->value;
	_tmp0_ = dynamic_notebook_get_tabs (self);
	_tmp1_ = _tmp0_;
	g_list_foreach (_tmp1_, __dynamic_notebook_allow_drag___lambda19__gfunc, _data17_);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_DRAG_PROPERTY]);
}

gboolean
dynamic_notebook_get_allow_new_window (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_new_window;
	return result;
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		DynamicNotebook* self;
		self = _data18_->self;
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
_dynamic_notebook_allow_new_window___lambda20_ (Block18Data* _data18_,
                                                Tab* t)
{
	DynamicNotebook* self;
	GtkNotebook* _tmp0_;
	TabPageContainer* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = t->page_container;
	gtk_notebook_set_tab_detachable (_tmp0_, (GtkWidget*) _tmp1_, _data18_->value);
}

static void
__dynamic_notebook_allow_new_window___lambda20__gfunc (gconstpointer data,
                                                       gpointer self)
{
	_dynamic_notebook_allow_new_window___lambda20_ (self, (Tab*) data);
}

void
dynamic_notebook_set_allow_new_window (DynamicNotebook* self,
                                       gboolean value)
{
	Block18Data* _data18_;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_data18_->value = value;
	self->priv->_allow_new_window = _data18_->value;
	_tmp0_ = dynamic_notebook_get_tabs (self);
	_tmp1_ = _tmp0_;
	g_list_foreach (_tmp1_, __dynamic_notebook_allow_new_window___lambda20__gfunc, _data18_);
	block18_data_unref (_data18_);
	_data18_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_NEW_WINDOW_PROPERTY]);
}

gboolean
dynamic_notebook_get_allow_duplication (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_duplication;
	return result;
}

void
dynamic_notebook_set_allow_duplication (DynamicNotebook* self,
                                        gboolean value)
{
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_allow_duplication = value;
	_tmp0_ = dynamic_notebook_get_tabs (self);
	_tmp1_ = _tmp0_;
	{
		GList* tab_collection = NULL;
		GList* tab_it = NULL;
		tab_collection = _tmp1_;
		for (tab_it = tab_collection; tab_it != NULL; tab_it = tab_it->next) {
			Tab* _tmp2_;
			Tab* tab = NULL;
			_tmp2_ = _g_object_ref0 ((Tab*) tab_it->data);
			tab = _tmp2_;
			{
				Tab* _tmp3_;
				GtkMenuItem* _tmp4_;
				_tmp3_ = tab;
				_tmp4_ = _tmp3_->duplicate_m;
				gtk_widget_set_visible ((GtkWidget*) _tmp4_, value);
				_g_object_unref0 (tab);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_DUPLICATION_PROPERTY]);
}

gboolean
dynamic_notebook_get_allow_restoring (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_restoring;
	return result;
}

void
dynamic_notebook_set_allow_restoring (DynamicNotebook* self,
                                      gboolean value)
{
	GtkMenuItem* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_allow_restoring = value;
	_tmp0_ = self->priv->restore_tab_m;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	_tmp1_ = self->priv->restore_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_RESTORING_PROPERTY]);
}

gint
dynamic_notebook_get_max_restorable_tabs (DynamicNotebook* self)
{
	gint result;
	ClosedTabs* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->closed_tabs;
	_tmp1_ = closed_tabs_get_max_restorable_tabs (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
dynamic_notebook_set_max_restorable_tabs (DynamicNotebook* self,
                                          gint value)
{
	ClosedTabs* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->closed_tabs;
	closed_tabs_set_max_restorable_tabs (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_MAX_RESTORABLE_TABS_PROPERTY]);
}

gboolean
dynamic_notebook_get_add_button_visible (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_add_button_visible;
	return result;
}

void
dynamic_notebook_set_add_button_visible (DynamicNotebook* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_add_button_visible) {
		GtkMenuItem* _tmp4_;
		if (self->priv->_add_button_visible) {
			GtkNotebook* _tmp0_;
			GtkButton* _tmp1_;
			_tmp0_ = self->priv->notebook;
			_tmp1_ = self->priv->add_button;
			gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
		} else {
			GtkNotebook* _tmp2_;
			GtkButton* _tmp3_;
			_tmp2_ = self->priv->notebook;
			_tmp3_ = self->priv->add_button;
			gtk_notebook_set_action_widget (_tmp2_, (GtkWidget*) _tmp3_, GTK_PACK_START);
		}
		self->priv->_add_button_visible = value;
		_tmp4_ = self->priv->new_tab_m;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ADD_BUTTON_VISIBLE_PROPERTY]);
}

gboolean
dynamic_notebook_get_allow_pinning (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_pinning;
	return result;
}

void
dynamic_notebook_set_allow_pinning (DynamicNotebook* self,
                                    gboolean value)
{
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_allow_pinning = value;
	_tmp0_ = dynamic_notebook_get_tabs (self);
	_tmp1_ = _tmp0_;
	{
		GList* tab_collection = NULL;
		GList* tab_it = NULL;
		tab_collection = _tmp1_;
		for (tab_it = tab_collection; tab_it != NULL; tab_it = tab_it->next) {
			Tab* _tmp2_;
			Tab* tab = NULL;
			_tmp2_ = _g_object_ref0 ((Tab*) tab_it->data);
			tab = _tmp2_;
			{
				Tab* _tmp3_;
				_tmp3_ = tab;
				tab_set_pinnable (_tmp3_, value);
				_g_object_unref0 (tab);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_PINNING_PROPERTY]);
}

gboolean
dynamic_notebook_get_force_left (DynamicNotebook* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_force_left;
	return result;
}

void
dynamic_notebook_set_force_left (DynamicNotebook* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_force_left = value;
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_FORCE_LEFT_PROPERTY]);
}

const gchar*
dynamic_notebook_get_add_button_tooltip (DynamicNotebook* self)
{
	const gchar* result;
	GtkButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->add_button;
	_tmp1_ = gtk_widget_get_tooltip_text ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_free0 (self->priv->_add_button_tooltip);
	self->priv->_add_button_tooltip = _tmp2_;
	_tmp3_ = self->priv->_add_button_tooltip;
	result = _tmp3_;
	return result;
}

void
dynamic_notebook_set_add_button_tooltip (DynamicNotebook* self,
                                         const gchar* value)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->add_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ADD_BUTTON_TOOLTIP_PROPERTY]);
}

Tab*
dynamic_notebook_get_current (DynamicNotebook* self)
{
	Tab* result;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkNotebook* _tmp2_;
	gconstpointer _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dynamic_notebook_get_tabs (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->notebook;
	_tmp3_ = g_list_nth_data (_tmp1_, (guint) gtk_notebook_get_current_page (_tmp2_));
	result = (Tab*) _tmp3_;
	return result;
}

void
dynamic_notebook_set_current (DynamicNotebook* self,
                              Tab* value)
{
	GtkNotebook* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = dynamic_notebook_get_tabs (self);
	_tmp2_ = _tmp1_;
	gtk_notebook_set_current_page (_tmp0_, g_list_index (_tmp2_, value));
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_CURRENT_PROPERTY]);
}

GList*
dynamic_notebook_get_tabs (DynamicNotebook* self)
{
	GList* result;
	GList* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	(self->priv->_tabs == NULL) ? NULL : (self->priv->_tabs = (_g_list_free__g_object_unref0_ (self->priv->_tabs), NULL));
	self->priv->_tabs = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				GtkNotebook* _tmp4_;
				GtkNotebook* _tmp5_;
				GtkWidget* _tmp6_;
				GtkWidget* _tmp7_;
				Tab* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = dynamic_notebook_get_n_tabs (self);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = self->priv->notebook;
				_tmp5_ = self->priv->notebook;
				_tmp6_ = gtk_notebook_get_nth_page (_tmp5_, i);
				_tmp7_ = gtk_notebook_get_tab_label (_tmp4_, _tmp6_);
				_tmp8_ = _g_object_ref0 (IS_TAB (_tmp7_) ? ((Tab*) _tmp7_) : NULL);
				self->priv->_tabs = g_list_append (self->priv->_tabs, _tmp8_);
			}
		}
	}
	_tmp9_ = self->priv->_tabs;
	result = _tmp9_;
	return result;
}

const gchar*
dynamic_notebook_get_group_name (DynamicNotebook* self)
{
	const gchar* result;
	GtkNotebook* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_group_name (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
dynamic_notebook_set_group_name (DynamicNotebook* self,
                                 const gchar* value)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_group_name (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_GROUP_NAME_PROPERTY]);
}

DynamicNotebookTabBarBehavior
dynamic_notebook_get_tab_bar_behavior (DynamicNotebook* self)
{
	DynamicNotebookTabBarBehavior result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_tab_bar_behavior;
	return result;
}

void
dynamic_notebook_set_tab_bar_behavior (DynamicNotebook* self,
                                       DynamicNotebookTabBarBehavior value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tab_bar_behavior = value;
	dynamic_notebook_update_tabs_visibility (self);
	g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_PROPERTY]);
}

GtkMenu*
dynamic_notebook_get_menu (DynamicNotebook* self)
{
	GtkMenu* result;
	GtkMenu* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_menu;
	result = _tmp0_;
	return result;
}

static void
dynamic_notebook_set_menu (DynamicNotebook* self,
                           GtkMenu* value)
{
	GtkMenu* old_value;
	g_return_if_fail (self != NULL);
	old_value = dynamic_notebook_get_menu (self);
	if (old_value != value) {
		GtkMenu* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_menu);
		self->priv->_menu = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_MENU_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_INT_INT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static gboolean
_dynamic_notebook___lambda22_ (DynamicNotebook* self,
                               cairo_t* ctx)
{
	GtkStyleContext* _tmp0_;
	gboolean result;
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_render_activity (_tmp0_, ctx, (gdouble) 0, (gdouble) 0, (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self), (gdouble) 27);
	result = FALSE;
	return result;
}

static gboolean
__dynamic_notebook___lambda22__gtk_widget_draw (GtkWidget* _sender,
                                                cairo_t* cr,
                                                gpointer self)
{
	gboolean result;
	result = _dynamic_notebook___lambda22_ ((DynamicNotebook*) self, cr);
	return result;
}

static void
_dynamic_notebook___lambda23_ (DynamicNotebook* self)
{
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_NEW_TAB_REQUESTED_SIGNAL], 0);
}

static void
__dynamic_notebook___lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self)
{
	_dynamic_notebook___lambda23_ ((DynamicNotebook*) self);
}

static void
_dynamic_notebook___lambda24_ (DynamicNotebook* self)
{
	dynamic_notebook_restore_last_tab (self);
}

static void
__dynamic_notebook___lambda24__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self)
{
	_dynamic_notebook___lambda24_ ((DynamicNotebook*) self);
}

static void
_dynamic_notebook___lambda25_ (DynamicNotebook* self,
                               const gchar* label,
                               const gchar* restore_data,
                               GIcon* icon)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkButton* _tmp2_;
	ClosedTabs* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkMenuItem* _tmp6_;
	ClosedTabs* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (label != NULL);
	g_return_if_fail (restore_data != NULL);
	_tmp0_ = dynamic_notebook_get_allow_restoring (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->restore_button;
	_tmp3_ = self->priv->closed_tabs;
	_tmp4_ = closed_tabs_get_empty (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, !_tmp5_);
	_tmp6_ = self->priv->restore_tab_m;
	_tmp7_ = self->priv->closed_tabs;
	_tmp8_ = closed_tabs_get_empty (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, !_tmp9_);
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_RESTORED_SIGNAL], 0, label, restore_data, icon);
}

static void
__dynamic_notebook___lambda25__closed_tabs_restored (ClosedTabs* _sender,
                                                     const gchar* label,
                                                     const gchar* restore_data,
                                                     GIcon* icon,
                                                     gpointer self)
{
	_dynamic_notebook___lambda25_ ((DynamicNotebook*) self, label, restore_data, icon);
}

static void
_dynamic_notebook___lambda26_ (DynamicNotebook* self)
{
	GtkButton* _tmp0_;
	GtkMenuItem* _tmp1_;
	_tmp0_ = self->priv->restore_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->restore_tab_m;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
}

static void
__dynamic_notebook___lambda26__closed_tabs_cleared (ClosedTabs* _sender,
                                                    gpointer self)
{
	_dynamic_notebook___lambda26_ ((DynamicNotebook*) self);
}

static void
_dynamic_notebook___lambda27_ (DynamicNotebook* self)
{
	g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_NEW_TAB_REQUESTED_SIGNAL], 0);
}

static void
__dynamic_notebook___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	_dynamic_notebook___lambda27_ ((DynamicNotebook*) self);
}

static gboolean
_dynamic_notebook___lambda28_ (DynamicNotebook* self,
                               GdkEventButton* e)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->type == GDK_2BUTTON_PRESS) {
		_tmp0_ = e->button == ((guint) 1);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
__dynamic_notebook___lambda28__gtk_widget_button_press_event (GtkWidget* _sender,
                                                              GdkEventButton* event,
                                                              gpointer self)
{
	gboolean result;
	result = _dynamic_notebook___lambda28_ ((DynamicNotebook*) self, event);
	return result;
}

static void
_dynamic_notebook___lambda29_ (DynamicNotebook* self)
{
	GtkMenu* menu = NULL;
	ClosedTabs* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* _tmp3_;
	GtkButton* _tmp4_;
	GtkMenu* _tmp5_;
	GtkMenu* _tmp6_;
	GtkButton* _tmp7_;
	_tmp0_ = self->priv->closed_tabs;
	_tmp1_ = closed_tabs_get_menu (_tmp0_);
	_tmp2_ = _tmp1_;
	menu = _tmp2_;
	_tmp3_ = menu;
	_tmp4_ = self->priv->restore_button;
	g_object_set (_tmp3_, "attach-widget", (GtkWidget*) _tmp4_, NULL);
	_tmp5_ = menu;
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
	_tmp6_ = menu;
	_tmp7_ = self->priv->restore_button;
	gtk_menu_popup_at_widget (_tmp6_, (GtkWidget*) _tmp7_, GDK_GRAVITY_SOUTH_EAST, GDK_GRAVITY_NORTH_EAST, NULL);
	_g_object_unref0 (menu);
}

static void
__dynamic_notebook___lambda29__gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	_dynamic_notebook___lambda29_ ((DynamicNotebook*) self);
}

static void
_dynamic_notebook___lambda30_ (DynamicNotebook* self)
{
	dynamic_notebook_recalc_size (self);
}

static void
__dynamic_notebook___lambda30__gtk_widget_size_allocate (GtkWidget* _sender,
                                                         GtkAllocation* allocation,
                                                         gpointer self)
{
	_dynamic_notebook___lambda30_ ((DynamicNotebook*) self);
}

static gboolean
_dynamic_notebook___lambda31_ (DynamicNotebook* self,
                               GdkEventButton* e)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->type == GDK_2BUTTON_PRESS) {
		_tmp0_ = e->button == ((guint) 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_NEW_TAB_REQUESTED_SIGNAL], 0);
	} else {
		gboolean _tmp1_ = FALSE;
		if (e->button == ((guint) 2)) {
			gboolean _tmp2_;
			gboolean _tmp3_;
			_tmp2_ = dynamic_notebook_get_allow_restoring (self);
			_tmp3_ = _tmp2_;
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			dynamic_notebook_restore_last_tab (self);
			result = TRUE;
			return result;
		} else {
			gboolean _tmp4_ = FALSE;
			if (e->button == ((guint) 3)) {
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp6_ = dynamic_notebook_get_allow_restoring (self);
				_tmp7_ = _tmp6_;
				if (_tmp7_) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp8_;
					gboolean _tmp9_;
					_tmp8_ = dynamic_notebook_get_add_button_visible (self);
					_tmp9_ = _tmp8_;
					_tmp5_ = _tmp9_;
				}
				_tmp4_ = _tmp5_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				GtkMenu* _tmp10_;
				_tmp10_ = self->priv->_menu;
				gtk_menu_popup_at_pointer (_tmp10_, (GdkEvent*) e);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
__dynamic_notebook___lambda31__gtk_widget_button_press_event (GtkWidget* _sender,
                                                              GdkEventButton* event,
                                                              gpointer self)
{
	gboolean result;
	result = _dynamic_notebook___lambda31_ ((DynamicNotebook*) self, event);
	return result;
}

static gboolean
_dynamic_notebook___lambda32_ (DynamicNotebook* self,
                               GdkEventKey* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	e->state = e->state & MODIFIER_MASK;
	switch (e->keyval) {
		case GDK_KEY_w:
		case GDK_KEY_W:
		{
			if (e->state == GDK_CONTROL_MASK) {
				gboolean _tmp0_;
				gboolean _tmp1_;
				Tab* _tmp2_;
				Tab* _tmp3_;
				_tmp0_ = dynamic_notebook_get_tabs_closable (self);
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = dynamic_notebook_get_current (self);
				_tmp3_ = _tmp2_;
				tab_close (_tmp3_);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_t:
		case GDK_KEY_T:
		{
			if (e->state == GDK_CONTROL_MASK) {
				g_signal_emit (self, dynamic_notebook_signals[DYNAMIC_NOTEBOOK_NEW_TAB_REQUESTED_SIGNAL], 0);
				result = TRUE;
				return result;
			} else {
				gboolean _tmp4_ = FALSE;
				if (e->state == (GDK_CONTROL_MASK | GDK_SHIFT_MASK)) {
					gboolean _tmp5_;
					gboolean _tmp6_;
					_tmp5_ = dynamic_notebook_get_allow_restoring (self);
					_tmp6_ = _tmp5_;
					_tmp4_ = _tmp6_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					dynamic_notebook_restore_last_tab (self);
					result = TRUE;
					return result;
				}
			}
			break;
		}
		case GDK_KEY_Page_Up:
		{
			if (e->state == GDK_CONTROL_MASK) {
				dynamic_notebook_next_page (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Page_Down:
		{
			if (e->state == GDK_CONTROL_MASK) {
				dynamic_notebook_previous_page (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_1:
		case GDK_KEY_2:
		case GDK_KEY_3:
		case GDK_KEY_4:
		case GDK_KEY_5:
		case GDK_KEY_6:
		case GDK_KEY_7:
		case GDK_KEY_8:
		{
			if ((e->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
				guint i = 0U;
				gint n_pages = 0;
				GtkNotebook* _tmp7_;
				guint _tmp8_ = 0U;
				GtkNotebook* _tmp9_;
				i = e->keyval - 49;
				_tmp7_ = self->priv->notebook;
				n_pages = gtk_notebook_get_n_pages (_tmp7_);
				if (i >= ((guint) n_pages)) {
					_tmp8_ = (guint) (n_pages - 1);
				} else {
					_tmp8_ = i;
				}
				_tmp9_ = self->priv->notebook;
				g_object_set (_tmp9_, "page", (gint) _tmp8_, NULL);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_9:
		{
			if ((e->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
				GtkNotebook* _tmp10_;
				GtkNotebook* _tmp11_;
				_tmp10_ = self->priv->notebook;
				_tmp11_ = self->priv->notebook;
				g_object_set (_tmp10_, "page", gtk_notebook_get_n_pages (_tmp11_) - 1, NULL);
				result = TRUE;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static gboolean
__dynamic_notebook___lambda32__gtk_widget_key_press_event (GtkWidget* _sender,
                                                           GdkEventKey* event,
                                                           gpointer self)
{
	gboolean result;
	result = _dynamic_notebook___lambda32_ ((DynamicNotebook*) self, event);
	return result;
}

static void
_dynamic_notebook_on_switch_page_gtk_notebook_switch_page (GtkNotebook* _sender,
                                                           GtkWidget* page,
                                                           guint page_num,
                                                           gpointer self)
{
	dynamic_notebook_on_switch_page ((DynamicNotebook*) self, page, page_num);
}

static void
_dynamic_notebook_on_page_added_gtk_notebook_page_added (GtkNotebook* _sender,
                                                         GtkWidget* child,
                                                         guint page_num,
                                                         gpointer self)
{
	dynamic_notebook_on_page_added ((DynamicNotebook*) self, child, page_num);
}

static void
_dynamic_notebook_on_page_removed_gtk_notebook_page_removed (GtkNotebook* _sender,
                                                             GtkWidget* child,
                                                             guint page_num,
                                                             gpointer self)
{
	dynamic_notebook_on_page_removed ((DynamicNotebook*) self, child, page_num);
}

static void
_dynamic_notebook_on_page_reordered_gtk_notebook_page_reordered (GtkNotebook* _sender,
                                                                 GtkWidget* child,
                                                                 guint page_num,
                                                                 gpointer self)
{
	dynamic_notebook_on_page_reordered ((DynamicNotebook*) self, child, page_num);
}

static GtkNotebook*
_dynamic_notebook_on_create_window_gtk_notebook_create_window (GtkNotebook* _sender,
                                                               GtkWidget* page,
                                                               gint x,
                                                               gint y,
                                                               gpointer self)
{
	GtkNotebook* result;
	result = dynamic_notebook_on_create_window ((DynamicNotebook*) self, page, x, y);
	return result;
}

static void
_dynamic_notebook___lambda33_ (DynamicNotebook* self)
{
	GtkNotebook* _tmp0_;
	guint _tmp1_;
	GtkNotebook* _tmp2_;
	guint _tmp3_;
	GtkNotebook* _tmp4_;
	guint _tmp5_;
	GtkNotebook* _tmp6_;
	guint _tmp7_;
	GtkNotebook* _tmp8_;
	guint _tmp9_;
	_tmp0_ = self->priv->notebook;
	g_signal_parse_name ("switch-page", gtk_notebook_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _dynamic_notebook_on_switch_page_gtk_notebook_switch_page, self);
	_tmp2_ = self->priv->notebook;
	g_signal_parse_name ("page-added", gtk_notebook_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _dynamic_notebook_on_page_added_gtk_notebook_page_added, self);
	_tmp4_ = self->priv->notebook;
	g_signal_parse_name ("page-removed", gtk_notebook_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _dynamic_notebook_on_page_removed_gtk_notebook_page_removed, self);
	_tmp6_ = self->priv->notebook;
	g_signal_parse_name ("page-reordered", gtk_notebook_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _dynamic_notebook_on_page_reordered_gtk_notebook_page_reordered, self);
	_tmp8_ = self->priv->notebook;
	g_signal_parse_name ("create-window", gtk_notebook_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _dynamic_notebook_on_create_window_gtk_notebook_create_window, self);
}

static void
__dynamic_notebook___lambda33__gtk_widget_destroy (GtkWidget* _sender,
                                                   gpointer self)
{
	_dynamic_notebook___lambda33_ ((DynamicNotebook*) self);
}

static GObject *
dynamic_notebook_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DynamicNotebook * self;
	GtkNotebook* _tmp0_;
	GtkNotebook* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkNotebook* _tmp3_;
	GtkNotebook* _tmp4_;
	GtkNotebook* _tmp5_;
	GtkMenu* _tmp6_;
	GtkMenu* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenu* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenu* _tmp13_;
	GtkMenuItem* _tmp14_;
	GtkMenu* _tmp15_;
	GtkMenuItem* _tmp16_;
	GtkMenuItem* _tmp17_;
	ClosedTabs* _tmp18_;
	ClosedTabs* _tmp19_;
	ClosedTabs* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkNotebook* _tmp30_;
	GtkButton* _tmp31_;
	GtkNotebook* _tmp32_;
	GtkButton* _tmp33_;
	GtkButton* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkMenuItem* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	GtkButton* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	GtkNotebook* _tmp43_;
	GtkNotebook* _tmp44_;
	GtkNotebook* _tmp45_;
	GtkNotebook* _tmp46_;
	GtkNotebook* _tmp47_;
	parent_class = G_OBJECT_CLASS (dynamic_notebook_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DYNAMIC_NOTEBOOK, DynamicNotebook);
	_tmp0_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp0_;
	_tmp1_ = self->priv->notebook;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp1_, FALSE);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "dynamic-notebook");
	_tmp3_ = self->priv->notebook;
	gtk_notebook_set_scrollable (_tmp3_, TRUE);
	_tmp4_ = self->priv->notebook;
	gtk_notebook_set_show_border (_tmp4_, FALSE);
	self->priv->_tab_bar_behavior = DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_ALWAYS;
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) __dynamic_notebook___lambda22__gtk_widget_draw, self, 0);
	_tmp5_ = self->priv->notebook;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	dynamic_notebook_set_menu (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("New Tab"));
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->new_tab_m);
	self->priv->new_tab_m = _tmp8_;
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Undo Close Tab"));
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->restore_tab_m);
	self->priv->restore_tab_m = _tmp9_;
	_tmp10_ = self->priv->restore_tab_m;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
	_tmp11_ = self->priv->_menu;
	_tmp12_ = self->priv->new_tab_m;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp11_, _tmp12_);
	_tmp13_ = self->priv->_menu;
	_tmp14_ = self->priv->restore_tab_m;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->new_tab_m;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) __dynamic_notebook___lambda23__gtk_menu_item_activate, self, 0);
	_tmp17_ = self->priv->restore_tab_m;
	g_signal_connect_object (_tmp17_, "activate", (GCallback) __dynamic_notebook___lambda24__gtk_menu_item_activate, self, 0);
	_tmp18_ = closed_tabs_new ();
	_g_object_unref0 (self->priv->closed_tabs);
	self->priv->closed_tabs = _tmp18_;
	_tmp19_ = self->priv->closed_tabs;
	g_signal_connect_object (_tmp19_, "restored", (GCallback) __dynamic_notebook___lambda25__closed_tabs_restored, self, 0);
	_tmp20_ = self->priv->closed_tabs;
	g_signal_connect_object (_tmp20_, "cleared", (GCallback) __dynamic_notebook___lambda26__closed_tabs_cleared, self, 0);
	_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->add_button);
	self->priv->add_button = _tmp21_;
	_tmp22_ = self->priv->add_button;
	gtk_button_set_relief (_tmp22_, GTK_RELIEF_NONE);
	_tmp23_ = self->priv->add_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp23_, _ ("New Tab"));
	_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("document-open-recent-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->restore_button);
	self->priv->restore_button = _tmp24_;
	_tmp25_ = self->priv->restore_button;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp25_, 3);
	_tmp26_ = self->priv->restore_button;
	gtk_button_set_relief (_tmp26_, GTK_RELIEF_NONE);
	_tmp27_ = self->priv->restore_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _ ("Closed Tabs"));
	_tmp28_ = self->priv->restore_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp28_, FALSE);
	_tmp29_ = self->priv->restore_button;
	gtk_widget_show ((GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->notebook;
	_tmp31_ = self->priv->add_button;
	gtk_notebook_set_action_widget (_tmp30_, (GtkWidget*) _tmp31_, GTK_PACK_START);
	_tmp32_ = self->priv->notebook;
	_tmp33_ = self->priv->restore_button;
	gtk_notebook_set_action_widget (_tmp32_, (GtkWidget*) _tmp33_, GTK_PACK_END);
	_tmp34_ = self->priv->add_button;
	g_signal_connect_object (_tmp34_, "clicked", (GCallback) __dynamic_notebook___lambda27__gtk_button_clicked, self, 0);
	_tmp35_ = self->priv->add_button;
	g_signal_connect_object ((GtkWidget*) _tmp35_, "button-press-event", (GCallback) __dynamic_notebook___lambda28__gtk_widget_button_press_event, self, 0);
	_tmp36_ = self->priv->restore_button;
	g_signal_connect_object (_tmp36_, "clicked", (GCallback) __dynamic_notebook___lambda29__gtk_button_clicked, self, 0);
	_tmp37_ = self->priv->restore_tab_m;
	_tmp38_ = dynamic_notebook_get_allow_restoring (self);
	_tmp39_ = _tmp38_;
	gtk_widget_set_visible ((GtkWidget*) _tmp37_, _tmp39_);
	_tmp40_ = self->priv->restore_button;
	_tmp41_ = dynamic_notebook_get_allow_restoring (self);
	_tmp42_ = _tmp41_;
	gtk_widget_set_visible ((GtkWidget*) _tmp40_, _tmp42_);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) __dynamic_notebook___lambda30__gtk_widget_size_allocate, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) __dynamic_notebook___lambda31__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) __dynamic_notebook___lambda32__gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) __dynamic_notebook___lambda33__gtk_widget_destroy, self, 0);
	_tmp43_ = self->priv->notebook;
	g_signal_connect_object (_tmp43_, "switch-page", (GCallback) _dynamic_notebook_on_switch_page_gtk_notebook_switch_page, self, 0);
	_tmp44_ = self->priv->notebook;
	g_signal_connect_object (_tmp44_, "page-added", (GCallback) _dynamic_notebook_on_page_added_gtk_notebook_page_added, self, 0);
	_tmp45_ = self->priv->notebook;
	g_signal_connect_object (_tmp45_, "page-removed", (GCallback) _dynamic_notebook_on_page_removed_gtk_notebook_page_removed, self, 0);
	_tmp46_ = self->priv->notebook;
	g_signal_connect_object (_tmp46_, "page-reordered", (GCallback) _dynamic_notebook_on_page_reordered_gtk_notebook_page_reordered, self, 0);
	_tmp47_ = self->priv->notebook;
	g_signal_connect_object (_tmp47_, "create-window", (GCallback) _dynamic_notebook_on_create_window_gtk_notebook_create_window, self, 0);
	return obj;
}

static void
dynamic_notebook_class_init (DynamicNotebookClass * klass,
                             gpointer klass_data)
{
	dynamic_notebook_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DynamicNotebook_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) dynamic_notebook_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_dynamic_notebook_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dynamic_notebook_set_property;
	G_OBJECT_CLASS (klass)->constructor = dynamic_notebook_constructor;
	G_OBJECT_CLASS (klass)->finalize = dynamic_notebook_finalize;
	/**
	         * number of pages
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_N_TABS_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_N_TABS_PROPERTY] = g_param_spec_int ("n-tabs", "n-tabs", "n-tabs", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Hide the tab bar and only show the pages
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_SHOW_TABS_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_SHOW_TABS_PROPERTY] = g_param_spec_boolean ("show-tabs", "show-tabs", "show-tabs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_SHOW_ICONS_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_SHOW_ICONS_PROPERTY] = g_param_spec_boolean ("show-icons", "show-icons", "show-icons", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_DEPRECATED));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_TABS_CLOSABLE_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_TABS_CLOSABLE_PROPERTY] = g_param_spec_boolean ("tabs-closable", "tabs-closable", "tabs-closable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_ALLOW_DRAG_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_DRAG_PROPERTY] = g_param_spec_boolean ("allow-drag", "allow-drag", "allow-drag", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_ALLOW_NEW_WINDOW_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_NEW_WINDOW_PROPERTY] = g_param_spec_boolean ("allow-new-window", "allow-new-window", "allow-new-window", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_ALLOW_DUPLICATION_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_DUPLICATION_PROPERTY] = g_param_spec_boolean ("allow-duplication", "allow-duplication", "allow-duplication", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_ALLOW_RESTORING_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_RESTORING_PROPERTY] = g_param_spec_boolean ("allow-restoring", "allow-restoring", "allow-restoring", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Set or get the upper limit of the size of the set
	         * of restorable tabs.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_MAX_RESTORABLE_TABS_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_MAX_RESTORABLE_TABS_PROPERTY] = g_param_spec_int ("max-restorable-tabs", "max-restorable-tabs", "max-restorable-tabs", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_ADD_BUTTON_VISIBLE_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ADD_BUTTON_VISIBLE_PROPERTY] = g_param_spec_boolean ("add-button-visible", "add-button-visible", "add-button-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_ALLOW_PINNING_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ALLOW_PINNING_PROPERTY] = g_param_spec_boolean ("allow-pinning", "allow-pinning", "allow-pinning", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_FORCE_LEFT_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_FORCE_LEFT_PROPERTY] = g_param_spec_boolean ("force-left", "force-left", "force-left", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	        * The text shown in the add button tooltip
	        */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_ADD_BUTTON_TOOLTIP_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_ADD_BUTTON_TOOLTIP_PROPERTY] = g_param_spec_string ("add-button-tooltip", "add-button-tooltip", "add-button-tooltip", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_CURRENT_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_CURRENT_PROPERTY] = g_param_spec_object ("current", "current", "current", TYPE_TAB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_TABS_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_TABS_PROPERTY] = g_param_spec_pointer ("tabs", "tabs", "tabs", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_GROUP_NAME_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_GROUP_NAME_PROPERTY] = g_param_spec_string ("group-name", "group-name", "group-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The behavior of the tab bar and its visibility
	        */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_PROPERTY] = g_param_spec_enum ("tab-bar-behavior", "tab-bar-behavior", "tab-bar-behavior", DYNAMIC_NOTEBOOK_TYPE_TAB_BAR_BEHAVIOR, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The menu appearing when the notebook is clicked on a blank space
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DYNAMIC_NOTEBOOK_MENU_PROPERTY, dynamic_notebook_properties[DYNAMIC_NOTEBOOK_MENU_PROPERTY] = g_param_spec_object ("menu", "menu", "menu", gtk_menu_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_ADDED_SIGNAL] = g_signal_new ("tab-added", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TAB);
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_REMOVED_SIGNAL] = g_signal_new ("tab-removed", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TAB);
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_SWITCHED_SIGNAL] = g_signal_new ("tab-switched", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_TAB, TYPE_TAB);
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_REORDERED_SIGNAL] = g_signal_new ("tab-reordered", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT, G_TYPE_NONE, 2, TYPE_TAB, G_TYPE_INT);
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_MOVED_SIGNAL] = g_signal_new ("tab-moved", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT_INT, G_TYPE_NONE, 3, TYPE_TAB, G_TYPE_INT, G_TYPE_INT);
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_DUPLICATED_SIGNAL] = g_signal_new ("tab-duplicated", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TAB);
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_TAB_RESTORED_SIGNAL] = g_signal_new ("tab-restored", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_OBJECT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, g_icon_get_type ());
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_NEW_TAB_REQUESTED_SIGNAL] = g_signal_new ("new-tab-requested", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	dynamic_notebook_signals[DYNAMIC_NOTEBOOK_CLOSE_TAB_REQUESTED_SIGNAL] = g_signal_new ("close-tab-requested", TYPE_DYNAMIC_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, TYPE_TAB);
}

static void
dynamic_notebook_instance_init (DynamicNotebook * self,
                                gpointer klass)
{
	self->priv = dynamic_notebook_get_instance_private (self);
	self->priv->_tabs_closable = TRUE;
	self->priv->_allow_drag = TRUE;
	self->priv->_allow_new_window = FALSE;
	self->priv->_allow_duplication = FALSE;
	self->priv->_allow_restoring = FALSE;
	self->priv->_add_button_visible = TRUE;
	self->priv->_allow_pinning = FALSE;
	self->priv->_force_left = TRUE;
	self->priv->tab_width = 150;
}

static void
dynamic_notebook_finalize (GObject * obj)
{
	DynamicNotebook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DYNAMIC_NOTEBOOK, DynamicNotebook);
	_g_free0 (self->priv->_add_button_tooltip);
	(self->priv->_tabs == NULL) ? NULL : (self->priv->_tabs = (_g_list_free__g_object_unref0_ (self->priv->_tabs), NULL));
	_g_object_unref0 (self->priv->_menu);
	_g_object_unref0 (self->priv->closed_tabs);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->old_tab);
	_g_object_unref0 (self->priv->new_tab_m);
	_g_object_unref0 (self->priv->restore_tab_m);
	_g_object_unref0 (self->priv->add_button);
	_g_object_unref0 (self->priv->restore_button);
	G_OBJECT_CLASS (dynamic_notebook_parent_class)->finalize (obj);
}

/**
    * Tab bar widget designed for a variable number of tabs.
    * Supports showing a "New tab" button, restoring closed tabs, "pinning" tabs, and more.
    *
    * {{../doc/images/DynamicNotebook.png}}
    */
static GType
dynamic_notebook_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DynamicNotebookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dynamic_notebook_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DynamicNotebook), 0, (GInstanceInitFunc) dynamic_notebook_instance_init, NULL };
	GType dynamic_notebook_type_id;
	dynamic_notebook_type_id = g_type_register_static (gtk_event_box_get_type (), "DynamicNotebook", &g_define_type_info, 0);
	DynamicNotebook_private_offset = g_type_add_instance_private (dynamic_notebook_type_id, sizeof (DynamicNotebookPrivate));
	return dynamic_notebook_type_id;
}

GType
dynamic_notebook_get_type (void)
{
	static volatile gsize dynamic_notebook_type_id__once = 0;
	if (g_once_init_enter (&dynamic_notebook_type_id__once)) {
		GType dynamic_notebook_type_id;
		dynamic_notebook_type_id = dynamic_notebook_get_type_once ();
		g_once_init_leave (&dynamic_notebook_type_id__once, dynamic_notebook_type_id);
	}
	return dynamic_notebook_type_id__once;
}

static void
_vala_dynamic_notebook_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	DynamicNotebook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DYNAMIC_NOTEBOOK, DynamicNotebook);
	switch (property_id) {
		case DYNAMIC_NOTEBOOK_N_TABS_PROPERTY:
		g_value_set_int (value, dynamic_notebook_get_n_tabs (self));
		break;
		case DYNAMIC_NOTEBOOK_SHOW_TABS_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_show_tabs (self));
		break;
		case DYNAMIC_NOTEBOOK_SHOW_ICONS_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_boolean (value, dynamic_notebook_get_show_icons (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case DYNAMIC_NOTEBOOK_TABS_CLOSABLE_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_tabs_closable (self));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_DRAG_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_allow_drag (self));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_NEW_WINDOW_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_allow_new_window (self));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_DUPLICATION_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_allow_duplication (self));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_RESTORING_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_allow_restoring (self));
		break;
		case DYNAMIC_NOTEBOOK_MAX_RESTORABLE_TABS_PROPERTY:
		g_value_set_int (value, dynamic_notebook_get_max_restorable_tabs (self));
		break;
		case DYNAMIC_NOTEBOOK_ADD_BUTTON_VISIBLE_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_add_button_visible (self));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_PINNING_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_allow_pinning (self));
		break;
		case DYNAMIC_NOTEBOOK_FORCE_LEFT_PROPERTY:
		g_value_set_boolean (value, dynamic_notebook_get_force_left (self));
		break;
		case DYNAMIC_NOTEBOOK_ADD_BUTTON_TOOLTIP_PROPERTY:
		g_value_set_string (value, dynamic_notebook_get_add_button_tooltip (self));
		break;
		case DYNAMIC_NOTEBOOK_CURRENT_PROPERTY:
		g_value_set_object (value, dynamic_notebook_get_current (self));
		break;
		case DYNAMIC_NOTEBOOK_TABS_PROPERTY:
		g_value_set_pointer (value, dynamic_notebook_get_tabs (self));
		break;
		case DYNAMIC_NOTEBOOK_GROUP_NAME_PROPERTY:
		g_value_set_string (value, dynamic_notebook_get_group_name (self));
		break;
		case DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_PROPERTY:
		g_value_set_enum (value, dynamic_notebook_get_tab_bar_behavior (self));
		break;
		case DYNAMIC_NOTEBOOK_MENU_PROPERTY:
		g_value_set_object (value, dynamic_notebook_get_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_dynamic_notebook_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	DynamicNotebook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DYNAMIC_NOTEBOOK, DynamicNotebook);
	switch (property_id) {
		case DYNAMIC_NOTEBOOK_SHOW_TABS_PROPERTY:
		dynamic_notebook_set_show_tabs (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_SHOW_ICONS_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		dynamic_notebook_set_show_icons (self, g_value_get_boolean (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case DYNAMIC_NOTEBOOK_TABS_CLOSABLE_PROPERTY:
		dynamic_notebook_set_tabs_closable (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_DRAG_PROPERTY:
		dynamic_notebook_set_allow_drag (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_NEW_WINDOW_PROPERTY:
		dynamic_notebook_set_allow_new_window (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_DUPLICATION_PROPERTY:
		dynamic_notebook_set_allow_duplication (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_RESTORING_PROPERTY:
		dynamic_notebook_set_allow_restoring (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_MAX_RESTORABLE_TABS_PROPERTY:
		dynamic_notebook_set_max_restorable_tabs (self, g_value_get_int (value));
		break;
		case DYNAMIC_NOTEBOOK_ADD_BUTTON_VISIBLE_PROPERTY:
		dynamic_notebook_set_add_button_visible (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_ALLOW_PINNING_PROPERTY:
		dynamic_notebook_set_allow_pinning (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_FORCE_LEFT_PROPERTY:
		dynamic_notebook_set_force_left (self, g_value_get_boolean (value));
		break;
		case DYNAMIC_NOTEBOOK_ADD_BUTTON_TOOLTIP_PROPERTY:
		dynamic_notebook_set_add_button_tooltip (self, g_value_get_string (value));
		break;
		case DYNAMIC_NOTEBOOK_CURRENT_PROPERTY:
		dynamic_notebook_set_current (self, g_value_get_object (value));
		break;
		case DYNAMIC_NOTEBOOK_GROUP_NAME_PROPERTY:
		dynamic_notebook_set_group_name (self, g_value_get_string (value));
		break;
		case DYNAMIC_NOTEBOOK_TAB_BAR_BEHAVIOR_PROPERTY:
		dynamic_notebook_set_tab_bar_behavior (self, g_value_get_enum (value));
		break;
		case DYNAMIC_NOTEBOOK_MENU_PROPERTY:
		dynamic_notebook_set_menu (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

