/* Sticker.c generated by valac 0.56.18, the Vala compiler
 * generated from Sticker.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <libxml/tree.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	STICKER_MODE_NONE = 0,
	STICKER_MODE_SELECTED,
	STICKER_MODE_DROPPABLE
} StickerMode;

#define TYPE_STICKER_MODE (sticker_mode_get_type ())

#define TYPE_STICKER (sticker_get_type ())
#define STICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STICKER, Sticker))
#define STICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STICKER, StickerClass))
#define IS_STICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STICKER))
#define IS_STICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STICKER))
#define STICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STICKER, StickerClass))

typedef struct _Sticker Sticker;
typedef struct _StickerClass StickerClass;
typedef struct _StickerPrivate StickerPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
typedef struct _ParamSpecSticker ParamSpecSticker;

struct _Sticker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StickerPrivate * priv;
};

struct _StickerClass {
	GTypeClass parent_class;
	void (*finalize) (Sticker *self);
};

struct _StickerPrivate {
	DrawArea* _da;
	gchar* _name;
	GdkPixbuf* _buf;
	gdouble _posx;
	gdouble _posy;
	StickerMode _mode;
};

struct _ParamSpecSticker {
	GParamSpec parent_instance;
};

static gint Sticker_private_offset;
static gpointer sticker_parent_class = NULL;

VALA_EXTERN GType sticker_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer sticker_ref (gpointer instance);
VALA_EXTERN void sticker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_sticker (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_sticker (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_sticker (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_sticker (const GValue* value);
VALA_EXTERN GType sticker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sticker, sticker_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN Sticker* sticker_new (DrawArea* da,
                      const gchar* n,
                      gdouble x,
                      gdouble y,
                      gint width);
VALA_EXTERN Sticker* sticker_construct (GType object_type,
                            DrawArea* da,
                            const gchar* n,
                            gdouble x,
                            gdouble y,
                            gint width);
VALA_EXTERN void sticker_set_posx (Sticker* self,
                       gdouble value);
VALA_EXTERN void sticker_set_posy (Sticker* self,
                       gdouble value);
VALA_EXTERN void sticker_set_pixbuf (Sticker* self,
                         gint width);
VALA_EXTERN Sticker* sticker_new_from_xml (DrawArea* da,
                               xmlNode* n);
VALA_EXTERN Sticker* sticker_construct_from_xml (GType object_type,
                                     DrawArea* da,
                                     xmlNode* n);
VALA_EXTERN void sticker_load (Sticker* self,
                   xmlNode* n);
VALA_EXTERN void sticker_resizer_bbox (Sticker* self,
                           gdouble* x,
                           gdouble* y,
                           gdouble* w,
                           gdouble* h);
VALA_EXTERN gdouble sticker_get_posx (Sticker* self);
VALA_EXTERN gdouble sticker_get_posy (Sticker* self);
VALA_EXTERN gboolean sticker_is_within_resizer (Sticker* self,
                                    gdouble x,
                                    gdouble y);
VALA_EXTERN gboolean utils_is_within_bounds (gdouble x,
                                 gdouble y,
                                 gdouble bx,
                                 gdouble by,
                                 gdouble bw,
                                 gdouble bh);
VALA_EXTERN void sticker_resize (Sticker* self,
                     gdouble diff);
VALA_EXTERN xmlNode* sticker_save (Sticker* self);
VALA_EXTERN GdkPixbuf* sticker_set_make_pixbuf (const gchar* resource,
                                    gint width);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void sticker_draw (Sticker* self,
                   cairo_t* ctx,
                   Theme* theme,
                   gdouble opacity,
                   gboolean exporting);
VALA_EXTERN StickerMode sticker_get_mode (Sticker* self);
VALA_EXTERN void utils_set_context_color_with_alpha (cairo_t* ctx,
                                         GdkRGBA* color,
                                         gdouble alpha);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN void utils_set_context_color (cairo_t* ctx,
                              GdkRGBA* color);
VALA_EXTERN void sticker_set_mode (Sticker* self,
                       StickerMode value);
VALA_EXTERN gdouble draw_area_get_origin_x (DrawArea* self);
VALA_EXTERN gdouble draw_area_get_origin_y (DrawArea* self);
VALA_EXTERN gdouble sticker_get_width (Sticker* self);
VALA_EXTERN gdouble sticker_get_height (Sticker* self);
static void sticker_finalize (Sticker * obj);
static GType sticker_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
sticker_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{STICKER_MODE_NONE, "STICKER_MODE_NONE", "none"}, {STICKER_MODE_SELECTED, "STICKER_MODE_SELECTED", "selected"}, {STICKER_MODE_DROPPABLE, "STICKER_MODE_DROPPABLE", "droppable"}, {0, NULL, NULL}};
	GType sticker_mode_type_id;
	sticker_mode_type_id = g_enum_register_static ("StickerMode", values);
	return sticker_mode_type_id;
}

GType
sticker_mode_get_type (void)
{
	static volatile gsize sticker_mode_type_id__once = 0;
	if (g_once_init_enter (&sticker_mode_type_id__once)) {
		GType sticker_mode_type_id;
		sticker_mode_type_id = sticker_mode_get_type_once ();
		g_once_init_leave (&sticker_mode_type_id__once, sticker_mode_type_id);
	}
	return sticker_mode_type_id__once;
}

static inline gpointer
sticker_get_instance_private (Sticker* self)
{
	return G_STRUCT_MEMBER_P (self, Sticker_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Sticker*
sticker_construct (GType object_type,
                   DrawArea* da,
                   const gchar* n,
                   gdouble x,
                   gdouble y,
                   gint width)
{
	Sticker* self = NULL;
	DrawArea* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	self = (Sticker*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = g_strdup (n);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	sticker_set_posx (self, x);
	sticker_set_posy (self, y);
	sticker_set_pixbuf (self, width);
	return self;
}

Sticker*
sticker_new (DrawArea* da,
             const gchar* n,
             gdouble x,
             gdouble y,
             gint width)
{
	return sticker_construct (TYPE_STICKER, da, n, x, y, width);
}

Sticker*
sticker_construct_from_xml (GType object_type,
                            DrawArea* da,
                            xmlNode* n)
{
	Sticker* self = NULL;
	DrawArea* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (Sticker*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	sticker_load (self, n);
	return self;
}

Sticker*
sticker_new_from_xml (DrawArea* da,
                      xmlNode* n)
{
	return sticker_construct_from_xml (TYPE_STICKER, da, n);
}

void
sticker_resizer_bbox (Sticker* self,
                      gdouble* x,
                      gdouble* y,
                      gdouble* w,
                      gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	GdkPixbuf* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sticker_get_posx (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_buf;
	_tmp3_ = gdk_pixbuf_get_width (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_x = (_tmp1_ + _tmp4_) - 8;
	_tmp5_ = sticker_get_posy (self);
	_tmp6_ = _tmp5_;
	_vala_y = _tmp6_;
	_vala_w = (gdouble) 8;
	_vala_h = (gdouble) 8;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

gboolean
sticker_is_within_resizer (Sticker* self,
                           gdouble x,
                           gdouble y)
{
	gdouble rx = 0.0;
	gdouble ry = 0.0;
	gdouble rw = 0.0;
	gdouble rh = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	sticker_resizer_bbox (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	rx = _tmp0_;
	ry = _tmp1_;
	rw = _tmp2_;
	rh = _tmp3_;
	result = utils_is_within_bounds (x, y, rx, ry, rw, rh);
	return result;
}

void
sticker_resize (Sticker* self,
                gdouble diff)
{
	gint width = 0;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint int_new_width = 0;
	GdkPixbuf* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_buf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	width = (gint) (_tmp2_ + diff);
	if (width < 24) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = width > 256;
	}
	if (_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->_buf;
	_tmp5_ = gdk_pixbuf_get_width (_tmp4_);
	_tmp6_ = _tmp5_;
	int_new_width = (gint) (_tmp6_ + diff);
	sticker_set_pixbuf (self, int_new_width);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

xmlNode*
sticker_save (Sticker* self)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GdkPixbuf* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "sticker");
	n = _tmp0_;
	_tmp1_ = self->priv->_name;
	xmlSetProp (n, (xmlChar*) "name", (xmlChar*) _tmp1_);
	_tmp2_ = double_to_string (self->priv->_posx);
	_tmp3_ = _tmp2_;
	xmlSetProp (n, (xmlChar*) "posx", (xmlChar*) _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = double_to_string (self->priv->_posy);
	_tmp5_ = _tmp4_;
	xmlSetProp (n, (xmlChar*) "posy", (xmlChar*) _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_buf;
	_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_tmp10_ = _tmp9_;
	xmlSetProp (n, (xmlChar*) "width", (xmlChar*) _tmp10_);
	_g_free0 (_tmp10_);
	result = n;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

void
sticker_load (Sticker* self,
              xmlNode* n)
{
	gint width = 0;
	gchar* nm = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* x = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* y = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* w = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	width = -1;
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "name");
	nm = _tmp0_;
	_tmp1_ = nm;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = nm;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp3_;
	}
	_tmp4_ = (gchar*) xmlGetProp (n, (xmlChar*) "posx");
	x = _tmp4_;
	_tmp5_ = x;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = x;
		self->priv->_posx = double_parse (_tmp6_);
	}
	_tmp7_ = (gchar*) xmlGetProp (n, (xmlChar*) "posy");
	y = _tmp7_;
	_tmp8_ = y;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		_tmp9_ = y;
		self->priv->_posy = double_parse (_tmp9_);
	}
	_tmp10_ = (gchar*) xmlGetProp (n, (xmlChar*) "width");
	w = _tmp10_;
	_tmp11_ = w;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_;
		_tmp12_ = w;
		width = atoi (_tmp12_);
	}
	sticker_set_pixbuf (self, width);
	_g_free0 (w);
	_g_free0 (y);
	_g_free0 (x);
	_g_free0 (nm);
}

void
sticker_set_pixbuf (Sticker* self,
                    gint width)
{
	const gchar* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = sticker_set_make_pixbuf (_tmp0_, width);
	_g_object_unref0 (self->priv->_buf);
	self->priv->_buf = _tmp1_;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

void
sticker_draw (Sticker* self,
              cairo_t* ctx,
              Theme* theme,
              gdouble opacity,
              gboolean exporting)
{
	gboolean _tmp0_ = FALSE;
	StickerMode _tmp1_;
	GdkPixbuf* _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	StickerMode _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	_tmp1_ = self->priv->_mode;
	if (_tmp1_ == STICKER_MODE_SELECTED) {
		_tmp0_ = !exporting;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gdouble _tmp2_ = 0.0;
		GdkRGBA* _tmp3_;
		GdkRGBA* _tmp4_;
		GdkRGBA _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		GdkPixbuf* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		GdkPixbuf* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gdouble x = 0.0;
		gdouble y = 0.0;
		gdouble w = 0.0;
		gdouble h = 0.0;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		GdkRGBA* _tmp20_;
		GdkRGBA* _tmp21_;
		GdkRGBA _tmp22_;
		GdkRGBA* _tmp23_;
		GdkRGBA* _tmp24_;
		GdkRGBA _tmp25_;
		if (opacity == 1.0) {
			_tmp2_ = 0.5;
		} else {
			_tmp2_ = opacity;
		}
		_tmp3_ = theme_get_color (theme, "nodesel_background");
		_tmp4_ = _tmp3_;
		_tmp5_ = *_tmp4_;
		utils_set_context_color_with_alpha (ctx, &_tmp5_, _tmp2_);
		__vala_GdkRGBA_free0 (_tmp4_);
		_tmp6_ = sticker_get_posx (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = sticker_get_posy (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_buf;
		_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->_buf;
		_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
		_tmp15_ = _tmp14_;
		cairo_rectangle (ctx, _tmp7_, _tmp9_, (gdouble) _tmp12_, (gdouble) _tmp15_);
		cairo_fill (ctx);
		sticker_resizer_bbox (self, &_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
		x = _tmp16_;
		y = _tmp17_;
		w = _tmp18_;
		h = _tmp19_;
		_tmp20_ = theme_get_color (theme, "background");
		_tmp21_ = _tmp20_;
		_tmp22_ = *_tmp21_;
		utils_set_context_color (ctx, &_tmp22_);
		__vala_GdkRGBA_free0 (_tmp21_);
		cairo_set_line_width (ctx, (gdouble) 1);
		cairo_rectangle (ctx, x, y, w, h);
		cairo_fill_preserve (ctx);
		_tmp23_ = theme_get_color (theme, "foreground");
		_tmp24_ = _tmp23_;
		_tmp25_ = *_tmp24_;
		utils_set_context_color_with_alpha (ctx, &_tmp25_, opacity);
		__vala_GdkRGBA_free0 (_tmp24_);
		cairo_stroke (ctx);
	}
	_tmp26_ = self->priv->_buf;
	_tmp27_ = sticker_get_posx (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = sticker_get_posy (self);
	_tmp30_ = _tmp29_;
	gdk_cairo_set_source_pixbuf (ctx, _tmp26_, _tmp28_, _tmp30_);
	cairo_paint_with_alpha (ctx, opacity);
	_tmp31_ = self->priv->_mode;
	if (_tmp31_ == STICKER_MODE_DROPPABLE) {
		GdkRGBA* _tmp32_;
		GdkRGBA* _tmp33_;
		GdkRGBA _tmp34_;
		gdouble _tmp35_;
		gdouble _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_;
		GdkPixbuf* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		GdkPixbuf* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		_tmp32_ = theme_get_color (theme, "attachable");
		_tmp33_ = _tmp32_;
		_tmp34_ = *_tmp33_;
		utils_set_context_color_with_alpha (ctx, &_tmp34_, opacity);
		__vala_GdkRGBA_free0 (_tmp33_);
		cairo_set_line_width (ctx, (gdouble) 4);
		_tmp35_ = sticker_get_posx (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = sticker_get_posy (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = self->priv->_buf;
		_tmp40_ = gdk_pixbuf_get_width (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = self->priv->_buf;
		_tmp43_ = gdk_pixbuf_get_height (_tmp42_);
		_tmp44_ = _tmp43_;
		cairo_rectangle (ctx, _tmp36_, _tmp38_, (gdouble) _tmp41_, (gdouble) _tmp44_);
		cairo_stroke (ctx);
	}
}

StickerMode
sticker_get_mode (Sticker* self)
{
	StickerMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
sticker_set_mode (Sticker* self,
                  StickerMode value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
}

gdouble
sticker_get_posx (Sticker* self)
{
	gdouble result;
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_x (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->_posx + _tmp2_;
	return result;
}

void
sticker_set_posx (Sticker* self,
                  gdouble value)
{
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_x (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_posx = value - _tmp2_;
}

gdouble
sticker_get_posy (Sticker* self)
{
	gdouble result;
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_y (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->_posy + _tmp2_;
	return result;
}

void
sticker_set_posy (Sticker* self,
                  gdouble value)
{
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_y (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_posy = value - _tmp2_;
}

gdouble
sticker_get_width (Sticker* self)
{
	gdouble result;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_buf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gdouble) _tmp2_;
	return result;
}

gdouble
sticker_get_height (Sticker* self)
{
	gdouble result;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_buf;
	_tmp1_ = gdk_pixbuf_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gdouble) _tmp2_;
	return result;
}

static void
value_sticker_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_sticker_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		sticker_unref (value->data[0].v_pointer);
	}
}

static void
value_sticker_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sticker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_sticker_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_sticker_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Sticker * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sticker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_sticker_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Sticker ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sticker_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_sticker (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecSticker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STICKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_sticker (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STICKER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_sticker (GValue* value,
                   gpointer v_object)
{
	Sticker * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STICKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STICKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sticker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sticker_unref (old);
	}
}

void
value_take_sticker (GValue* value,
                    gpointer v_object)
{
	Sticker * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STICKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STICKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sticker_unref (old);
	}
}

static void
sticker_class_init (StickerClass * klass,
                    gpointer klass_data)
{
	sticker_parent_class = g_type_class_peek_parent (klass);
	((StickerClass *) klass)->finalize = sticker_finalize;
	g_type_class_adjust_private_offset (klass, &Sticker_private_offset);
}

static void
sticker_instance_init (Sticker * self,
                       gpointer klass)
{
	self->priv = sticker_get_instance_private (self);
	self->priv->_posx = 0.0;
	self->priv->_posy = 0.0;
	self->priv->_mode = STICKER_MODE_NONE;
	self->ref_count = 1;
}

static void
sticker_finalize (Sticker * obj)
{
	Sticker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STICKER, Sticker);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_da);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_buf);
}

static GType
sticker_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_sticker_init, value_sticker_free_value, value_sticker_copy_value, value_sticker_peek_pointer, "p", value_sticker_collect_value, "p", value_sticker_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (StickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sticker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sticker), 0, (GInstanceInitFunc) sticker_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType sticker_type_id;
	sticker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Sticker", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Sticker_private_offset = g_type_add_instance_private (sticker_type_id, sizeof (StickerPrivate));
	return sticker_type_id;
}

GType
sticker_get_type (void)
{
	static volatile gsize sticker_type_id__once = 0;
	if (g_once_init_enter (&sticker_type_id__once)) {
		GType sticker_type_id;
		sticker_type_id = sticker_get_type_once ();
		g_once_init_leave (&sticker_type_id__once, sticker_type_id);
	}
	return sticker_type_id__once;
}

gpointer
sticker_ref (gpointer instance)
{
	Sticker * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
sticker_unref (gpointer instance)
{
	Sticker * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STICKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

