/* LinkTypeSquared.c generated by valac 0.56.18, the Vala compiler
 * generated from LinkTypeSquared.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_LINK_TYPE (link_type_get_type ())
#define LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE, LinkType))
#define IS_LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE))
#define LINK_TYPE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LINK_TYPE, LinkTypeIface))

typedef struct _LinkType LinkType;
typedef struct _LinkTypeIface LinkTypeIface;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_LINK_TYPE_SQUARED (link_type_squared_get_type ())
#define LINK_TYPE_SQUARED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE_SQUARED, LinkTypeSquared))
#define LINK_TYPE_SQUARED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_TYPE_SQUARED, LinkTypeSquaredClass))
#define IS_LINK_TYPE_SQUARED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE_SQUARED))
#define IS_LINK_TYPE_SQUARED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_TYPE_SQUARED))
#define LINK_TYPE_SQUARED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_TYPE_SQUARED, LinkTypeSquaredClass))

typedef struct _LinkTypeSquared LinkTypeSquared;
typedef struct _LinkTypeSquaredClass LinkTypeSquaredClass;
typedef struct _LinkTypeSquaredPrivate LinkTypeSquaredPrivate;
enum  {
	LINK_TYPE_SQUARED_0_PROPERTY,
	LINK_TYPE_SQUARED_NUM_PROPERTIES
};
static GParamSpec* link_type_squared_properties[LINK_TYPE_SQUARED_NUM_PROPERTIES];
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))

struct _LinkTypeIface {
	GTypeInterface parent_iface;
	gchar* (*name) (LinkType* self);
	gchar* (*display_name) (LinkType* self);
	gchar* (*icon_name) (LinkType* self);
	void (*draw) (LinkType* self, cairo_t* ctx, Node* from_node, Node* to_node, gdouble from_x, gdouble from_y, gdouble to_x, gdouble to_y, gdouble* fx, gdouble* fy, gdouble* tx, gdouble* ty);
};

struct _LinkTypeSquared {
	GObject parent_instance;
	LinkTypeSquaredPrivate * priv;
};

struct _LinkTypeSquaredClass {
	GObjectClass parent_class;
};

static gpointer link_type_squared_parent_class = NULL;
static LinkTypeIface * link_type_squared_link_type_parent_iface = NULL;

VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType link_type_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkType, g_object_unref)
VALA_EXTERN GType link_type_squared_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkTypeSquared, g_object_unref)
VALA_EXTERN LinkTypeSquared* link_type_squared_new (void);
VALA_EXTERN LinkTypeSquared* link_type_squared_construct (GType object_type);
static gchar* link_type_squared_real_name (LinkType* base);
static gchar* link_type_squared_real_display_name (LinkType* base);
static gchar* link_type_squared_real_icon_name (LinkType* base);
static void link_type_squared_real_draw (LinkType* base,
                                  cairo_t* ctx,
                                  Node* from_node,
                                  Node* to_node,
                                  gdouble from_x,
                                  gdouble from_y,
                                  gdouble to_x,
                                  gdouble to_y,
                                  gdouble* tailx,
                                  gdouble* taily,
                                  gdouble* tipx,
                                  gdouble* tipy);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN gdouble link_type_adjust_a (LinkType* self,
                            Style* style);
VALA_EXTERN gdouble link_type_adjust_tip (LinkType* self,
                              Style* style);
VALA_EXTERN gboolean node_side_horizontal (NodeSide self);
VALA_EXTERN gdouble link_type_adjust_mid_by (LinkType* self,
                                 Node* parent,
                                 NodeSide child_side);
VALA_EXTERN gchar* link_type_name (LinkType* self);
VALA_EXTERN gchar* link_type_display_name (LinkType* self);
VALA_EXTERN gchar* link_type_icon_name (LinkType* self);
VALA_EXTERN void link_type_draw (LinkType* self,
                     cairo_t* ctx,
                     Node* from_node,
                     Node* to_node,
                     gdouble from_x,
                     gdouble from_y,
                     gdouble to_x,
                     gdouble to_y,
                     gdouble* fx,
                     gdouble* fy,
                     gdouble* tx,
                     gdouble* ty);
static GType link_type_squared_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

LinkTypeSquared*
link_type_squared_construct (GType object_type)
{
	LinkTypeSquared * self = NULL;
	self = (LinkTypeSquared*) g_object_new (object_type, NULL);
	return self;
}

LinkTypeSquared*
link_type_squared_new (void)
{
	return link_type_squared_construct (TYPE_LINK_TYPE_SQUARED);
}

static gchar*
link_type_squared_real_name (LinkType* base)
{
	LinkTypeSquared * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LinkTypeSquared*) base;
	_tmp0_ = g_strdup ("squared");
	result = _tmp0_;
	return result;
}

static gchar*
link_type_squared_real_display_name (LinkType* base)
{
	LinkTypeSquared * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LinkTypeSquared*) base;
	_tmp0_ = g_strdup (_ ("Squared"));
	result = _tmp0_;
	return result;
}

static gchar*
link_type_squared_real_icon_name (LinkType* base)
{
	LinkTypeSquared * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LinkTypeSquared*) base;
	_tmp0_ = g_strdup ("minder-link-squared-symbolic");
	result = _tmp0_;
	return result;
}

static gpointer
_style_ref0 (gpointer self)
{
	return self ? style_ref (self) : NULL;
}

static void
link_type_squared_real_draw (LinkType* base,
                             cairo_t* ctx,
                             Node* from_node,
                             Node* to_node,
                             gdouble from_x,
                             gdouble from_y,
                             gdouble to_x,
                             gdouble to_y,
                             gdouble* tailx,
                             gdouble* taily,
                             gdouble* tipx,
                             gdouble* tipy)
{
	LinkTypeSquared * self;
	gdouble _vala_tailx = 0.0;
	gdouble _vala_taily = 0.0;
	gdouble _vala_tipx = 0.0;
	gdouble _vala_tipy = 0.0;
	NodeSide side = 0;
	NodeSide _tmp0_;
	NodeSide _tmp1_;
	Style* style = NULL;
	Style* _tmp2_;
	Style* _tmp3_;
	Style* _tmp4_;
	gdouble adj_a = 0.0;
	Style* _tmp5_;
	gdouble adj_t = 0.0;
	Style* _tmp6_;
	self = (LinkTypeSquared*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (from_node != NULL);
	g_return_if_fail (to_node != NULL);
	_tmp0_ = node_get_side (to_node);
	_tmp1_ = _tmp0_;
	side = _tmp1_;
	_tmp2_ = node_get_style (to_node);
	_tmp3_ = _tmp2_;
	_tmp4_ = _style_ref0 (_tmp3_);
	style = _tmp4_;
	_tmp5_ = style;
	adj_a = link_type_adjust_a ((LinkType*) self, _tmp5_);
	_tmp6_ = style;
	adj_t = link_type_adjust_tip ((LinkType*) self, _tmp6_);
	_vala_tipy = (gdouble) 0;
	_vala_tipx = _vala_tipy;
	switch (side) {
		case NODE_SIDE_LEFT:
		{
			to_x = to_x + adj_a;
			_vala_tipx = to_x - adj_t;
			_vala_tipy = to_y;
			break;
		}
		case NODE_SIDE_RIGHT:
		{
			to_x = to_x - adj_a;
			_vala_tipx = to_x + adj_t;
			_vala_tipy = to_y;
			break;
		}
		case NODE_SIDE_TOP:
		{
			to_y = to_y + adj_a;
			_vala_tipy = to_y - adj_t;
			_vala_tipx = to_x;
			break;
		}
		case NODE_SIDE_BOTTOM:
		{
			to_y = to_y - adj_a;
			_vala_tipy = to_y + adj_t;
			_vala_tipx = to_x;
			break;
		}
		default:
		break;
	}
	cairo_move_to (ctx, from_x, from_y);
	if (node_side_horizontal (side)) {
		gdouble mid_x = 0.0;
		mid_x = ((from_x + to_x) / 2) + link_type_adjust_mid_by ((LinkType*) self, from_node, side);
		_vala_tailx = mid_x;
		_vala_taily = to_y;
		cairo_line_to (ctx, mid_x, from_y);
		cairo_line_to (ctx, mid_x, to_y);
		cairo_line_to (ctx, to_x, to_y);
	} else {
		gdouble mid_y = 0.0;
		mid_y = ((from_y + to_y) / 2) + link_type_adjust_mid_by ((LinkType*) self, from_node, side);
		_vala_tailx = to_x;
		_vala_taily = mid_y;
		cairo_line_to (ctx, from_x, mid_y);
		cairo_line_to (ctx, to_x, mid_y);
		cairo_line_to (ctx, to_x, to_y);
	}
	cairo_stroke (ctx);
	_style_unref0 (style);
	if (tailx) {
		*tailx = _vala_tailx;
	}
	if (taily) {
		*taily = _vala_taily;
	}
	if (tipx) {
		*tipx = _vala_tipx;
	}
	if (tipy) {
		*tipy = _vala_tipy;
	}
}

static void
link_type_squared_class_init (LinkTypeSquaredClass * klass,
                              gpointer klass_data)
{
	link_type_squared_parent_class = g_type_class_peek_parent (klass);
}

static void
link_type_squared_link_type_interface_init (LinkTypeIface * iface,
                                            gpointer iface_data)
{
	link_type_squared_link_type_parent_iface = g_type_interface_peek_parent (iface);
	iface->name = (gchar* (*) (LinkType*)) link_type_squared_real_name;
	iface->display_name = (gchar* (*) (LinkType*)) link_type_squared_real_display_name;
	iface->icon_name = (gchar* (*) (LinkType*)) link_type_squared_real_icon_name;
	iface->draw = (void (*) (LinkType*, cairo_t*, Node*, Node*, gdouble, gdouble, gdouble, gdouble, gdouble*, gdouble*, gdouble*, gdouble*)) link_type_squared_real_draw;
}

static void
link_type_squared_instance_init (LinkTypeSquared * self,
                                 gpointer klass)
{
}

static GType
link_type_squared_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LinkTypeSquaredClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) link_type_squared_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LinkTypeSquared), 0, (GInstanceInitFunc) link_type_squared_instance_init, NULL };
	static const GInterfaceInfo link_type_info = { (GInterfaceInitFunc) link_type_squared_link_type_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType link_type_squared_type_id;
	link_type_squared_type_id = g_type_register_static (G_TYPE_OBJECT, "LinkTypeSquared", &g_define_type_info, 0);
	g_type_add_interface_static (link_type_squared_type_id, TYPE_LINK_TYPE, &link_type_info);
	return link_type_squared_type_id;
}

GType
link_type_squared_get_type (void)
{
	static volatile gsize link_type_squared_type_id__once = 0;
	if (g_once_init_enter (&link_type_squared_type_id__once)) {
		GType link_type_squared_type_id;
		link_type_squared_type_id = link_type_squared_get_type_once ();
		g_once_init_leave (&link_type_squared_type_id__once, link_type_squared_type_id);
	}
	return link_type_squared_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

