// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011-2012 Xamarin Inc.
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			ReadOnly = 1 << 7,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue | ReadOnly,
			PrimaryConstructor = Ref | Out | Params | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
		static readonly object RefStructToken = new object ();
		static readonly object RefPartialStructToken = new object ();

		NamespaceContainer current_namespace;
		TypeContainer current_container;
		TypeDefinition current_type;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariable current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;
		
		bool async_block;

		///
		/// An out-of-band stack.
		///
		Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;

		bool? interactive_async;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		List<Parameter> parameters_bucket;
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Stack<Location> location_stack;
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }
#pragma warning disable 649
  /* An EOF token */
  public int eof_token;
#pragma warning restore 649
  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_namespace",
//t    "using_namespace : USING opt_static namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING opt_static IDENTIFIER ASSIGN namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING error",
//t    "opt_static :",
//t    "opt_static : STATIC",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon_error",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name",
//t    "opt_semicolon_error :",
//t    "opt_semicolon_error : SEMICOLON",
//t    "opt_semicolon_error : error",
//t    "namespace_name : IDENTIFIER",
//t    "namespace_name : namespace_name DOT IDENTIFIER",
//t    "namespace_name : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "namespace_or_type_declaration : attribute_sections CLOSE_BRACE",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : IDENTIFIER error",
//t    "attribute_section_cont : error",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_expr",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "positional_or_named_argument : error",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : identifier_inside_body COLON opt_named_modifier named_argument_expr",
//t    "named_argument : identifier_inside_body COLON OUT named_argument_expr_or_out_variable_declaration",
//t    "named_argument_expr : expression_or_error",
//t    "named_argument_expr_or_out_variable_declaration : expression_or_error",
//t    "named_argument_expr_or_out_variable_declaration : out_variable_declaration",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : primary_constructor_body",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : attributes_without_members",
//t    "class_member_declaration : incomplete_member",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "primary_constructor_body : OPEN_BRACE $$8 opt_statement_list block_end",
//t    "struct_keyword : STRUCT",
//t    "struct_keyword : REF_STRUCT",
//t    "struct_keyword : REF_PARTIAL STRUCT",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial struct_keyword type_declaration_name $$9 opt_primary_parameters opt_class_base opt_type_parameter_constraints_clauses $$10 OPEN_BRACE $$11 opt_class_member_declarations CLOSE_BRACE $$12 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial struct_keyword error",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type error",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers ref_member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "ref_member_type : member_type",
//t    "$$21 :",
//t    "ref_member_type : REF $$21 type",
//t    "$$22 :",
//t    "ref_member_type : REF READONLY $$22 type",
//t    "$$23 :",
//t    "$$24 :",
//t    "method_header : opt_attributes opt_modifiers ref_member_type method_declaration_name OPEN_PARENS $$23 opt_formal_parameter_list CLOSE_PARENS $$24 opt_type_parameter_constraints_clauses",
//t    "$$25 :",
//t    "$$26 :",
//t    "$$27 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$25 method_declaration_name OPEN_PARENS $$26 opt_formal_parameter_list CLOSE_PARENS $$27 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers ref_member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_header : opt_attributes opt_modifiers ref_member_type method_declaration_name error",
//t    "method_body : block",
//t    "method_body : expression_block",
//t    "method_body : SEMICOLON",
//t    "destructor_body : method_body",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "$$28 :",
//t    "constructor_body : ARROW $$28 expression SEMICOLON",
//t    "$$29 :",
//t    "expression_block : ARROW $$29 lambda_arrow_expression SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : attribute_sections error",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$30 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body ASSIGN $$30 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_modifier : IN",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$31 :",
//t    "$$32 :",
//t    "$$33 :",
//t    "$$34 :",
//t    "property_declaration : opt_attributes opt_modifiers ref_member_type member_declaration_name $$31 OPEN_BRACE $$32 accessor_declarations $$33 CLOSE_BRACE $$34 opt_property_initializer",
//t    "$$35 :",
//t    "property_declaration : opt_attributes opt_modifiers ref_member_type member_declaration_name $$35 expression_block",
//t    "opt_property_initializer :",
//t    "$$36 :",
//t    "opt_property_initializer : ASSIGN $$36 property_initializer SEMICOLON",
//t    "property_initializer : expression",
//t    "property_initializer : array_initializer",
//t    "$$37 :",
//t    "$$38 :",
//t    "indexer_declaration : opt_attributes opt_modifiers ref_member_type indexer_declaration_name OPEN_BRACKET $$37 opt_formal_parameter_list CLOSE_BRACKET $$38 indexer_body",
//t    "indexer_body : OPEN_BRACE accessor_declarations CLOSE_BRACE",
//t    "indexer_body : expression_block",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$39 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$39 accessor_body",
//t    "$$40 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$40 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : expression_block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$41 :",
//t    "$$42 :",
//t    "$$43 :",
//t    "$$44 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$41 type_declaration_name $$42 opt_class_base opt_type_parameter_constraints_clauses $$43 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$44 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$45 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$45 method_body",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$46 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$46 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "overloadable_operator : IS",
//t    "$$47 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$47 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$48 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$48 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$49 :",
//t    "$$50 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$49 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$50 opt_constructor_initializer",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$51 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$51 opt_argument_list CLOSE_PARENS",
//t    "$$52 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$52 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : COLON error",
//t    "constructor_initializer : error",
//t    "$$53 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$53 IDENTIFIER OPEN_PARENS CLOSE_PARENS destructor_body",
//t    "$$54 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$54 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$55 :",
//t    "$$56 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$55 event_accessor_declarations $$56 CLOSE_BRACE",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type error",
//t    "opt_event_initializer :",
//t    "$$57 :",
//t    "opt_event_initializer : ASSIGN $$57 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN event_variable_initializer",
//t    "$$58 :",
//t    "event_variable_initializer : $$58 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$59 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$59 event_accessor_block",
//t    "$$60 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$60 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "event_accessor_block : expression_block",
//t    "attributes_without_members : attribute_sections CLOSE_BRACE",
//t    "incomplete_member : opt_attributes opt_modifiers member_type CLOSE_BRACE",
//t    "$$61 :",
//t    "$$62 :",
//t    "$$63 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$61 OPEN_BRACE $$62 opt_enum_member_declarations $$63 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$64 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$64 ASSIGN constant_expression",
//t    "enum_member_declaration : opt_attributes IDENTIFIER error",
//t    "enum_member_declaration : attributes_without_members",
//t    "$$65 :",
//t    "$$66 :",
//t    "$$67 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE ref_member_type type_declaration_name OPEN_PARENS $$65 opt_formal_parameter_list CLOSE_PARENS $$66 opt_type_parameter_constraints_clauses $$67 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_expr : member_name",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER generic_dimension",
//t    "member_name : simple_name_expr",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER opt_type_argument_list",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER generic_dimension",
//t    "simple_name_expr : IDENTIFIER opt_type_argument_list",
//t    "simple_name_expr : IDENTIFIER generic_dimension",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$68 :",
//t    "type_declaration_name : IDENTIFIER $$68 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : void_invalid",
//t    "simple_type : type_expression",
//t    "simple_type : void_invalid",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_expr opt_nullable",
//t    "type_expression : namespace_or_type_expr pointer_stars",
//t    "type_expression : builtin_type_expression",
//t    "type_expression : OPEN_PARENS tuple_elements CLOSE_PARENS opt_nullable",
//t    "tuple_elements : tuple_element tuple_element_name",
//t    "tuple_elements : tuple_elements COMMA tuple_element tuple_element_name",
//t    "tuple_element_name :",
//t    "tuple_element_name : IDENTIFIER",
//t    "tuple_element : parameter_type",
//t    "void_invalid : VOID",
//t    "builtin_type_expression : builtin_types opt_nullable",
//t    "builtin_type_expression : builtin_types pointer_stars",
//t    "builtin_type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : type_name_expression",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression : interpolated_string",
//t    "primary_expression : default_literal",
//t    "type_name_expression : simple_name_expr",
//t    "type_name_expression : IDENTIFIER GENERATE_COMPLETION",
//t    "type_name_expression : member_access",
//t    "literal : boolean_literal",
//t    "literal : tuple_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "tuple_literal : OPEN_PARENS tuple_literal_elements CLOSE_PARENS",
//t    "tuple_literal_elements : tuple_literal_element COMMA tuple_literal_element",
//t    "tuple_literal_elements : tuple_literal_elements COMMA tuple_literal_element",
//t    "tuple_literal_element : expression",
//t    "tuple_literal_element : IDENTIFIER COLON expression",
//t    "interpolated_string : INTERPOLATED_STRING interpolations INTERPOLATED_STRING_END",
//t    "interpolated_string : INTERPOLATED_STRING_END",
//t    "interpolations : interpolation",
//t    "interpolations : interpolations INTERPOLATED_STRING interpolation",
//t    "interpolation : expression",
//t    "interpolation : expression COMMA expression",
//t    "$$69 :",
//t    "interpolation : expression COLON $$69 LITERAL",
//t    "$$70 :",
//t    "interpolation : expression COMMA expression COLON $$70 LITERAL",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : primary_expression DOT identifier_inside_body generic_dimension",
//t    "member_access : primary_expression INTERR_OPERATOR DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : builtin_types DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : BASE DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : AWAIT DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : qualified_alias_member identifier_inside_body opt_type_argument_list",
//t    "member_access : qualified_alias_member identifier_inside_body generic_dimension",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "invocation_expression : primary_expression open_parens_any argument_list error",
//t    "invocation_expression : primary_expression open_parens_any error",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : AWAIT ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACKET_EXPR argument_list CLOSE_BRACKET ASSIGN initializer_value",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA error",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : OUT out_variable_declaration",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "non_simple_argument : IN variable_reference",
//t    "out_variable_declaration : variable_type identifier_inside_body",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression INTERR_OPERATOR OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments error",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR error",
//t    "expression_list : expression_or_error",
//t    "expression_list : expression_list COMMA expression_or_error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$71 :",
//t    "new_expr_type : $$71 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_expression : NEW OPEN_BRACE GENERATE_COMPLETION",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameters : COMPLETE_COMPLETION",
//t    "anonymous_type_parameters : anonymous_type_parameter COMPLETE_COMPLETION",
//t    "anonymous_type_parameter : identifier_inside_body ASSIGN variable_initializer",
//t    "anonymous_type_parameter : identifier_inside_body",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "typeof_expression : TYPEOF open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : error",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "sizeof_expression : SIZEOF open_parens_any type error",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "checked_expression : CHECKED error",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED error",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$72 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$72 block",
//t    "$$73 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$73 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$74 :",
//t    "anonymous_method_signature : OPEN_PARENS $$74 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT_VALUE open_parens_any type CLOSE_PARENS",
//t    "default_literal : DEFAULT",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "unary_expression : AWAIT prefixed_unary_expression",
//t    "unary_expression : THROW_EXPR prefixed_unary_expression",
//t    "unary_expression : BANG error",
//t    "unary_expression : TILDE error",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS error",
//t    "unary_expression : AWAIT error",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "prefixed_unary_expression : PLUS error",
//t    "prefixed_unary_expression : MINUS error",
//t    "prefixed_unary_expression : OP_INC error",
//t    "prefixed_unary_expression : OP_DEC error",
//t    "prefixed_unary_expression : STAR error",
//t    "prefixed_unary_expression : BITWISE_AND error",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR error",
//t    "multiplicative_expression : multiplicative_expression DIV error",
//t    "multiplicative_expression : multiplicative_expression PERCENT error",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression PLUS error",
//t    "additive_expression : additive_expression MINUS error",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS pattern_type_expr opt_identifier",
//t    "additive_expression : additive_expression IS pattern_expr",
//t    "additive_expression : additive_expression AS error",
//t    "additive_expression : additive_expression IS error",
//t    "additive_expression : AWAIT IS type",
//t    "additive_expression : AWAIT AS type",
//t    "pattern_type_expr : variable_type",
//t    "pattern_expr : literal",
//t    "pattern_expr : PLUS prefixed_unary_expression",
//t    "pattern_expr : MINUS prefixed_unary_expression",
//t    "pattern_expr : sizeof_expression",
//t    "pattern_expr : default_value_expression",
//t    "pattern_expr : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "pattern_expr : STAR",
//t    "pattern_expr : pattern_property",
//t    "pattern_property : type_name_expression OPEN_BRACE pattern_property_list CLOSE_BRACE",
//t    "pattern_property_list : pattern_property_entry",
//t    "pattern_property_list : pattern_property_list COMMA pattern_property_entry",
//t    "pattern_property_entry : identifier_inside_body IS pattern",
//t    "pattern : pattern_expr",
//t    "pattern : pattern_type_expr opt_identifier",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT error",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT error",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "relational_expression : relational_expression OP_LT error",
//t    "relational_expression : relational_expression OP_GT error",
//t    "relational_expression : relational_expression OP_LE error",
//t    "relational_expression : relational_expression OP_GE error",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "equality_expression : equality_expression OP_EQ error",
//t    "equality_expression : equality_expression OP_NE error",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "and_expression : and_expression BITWISE_AND error",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET error",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR error",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND error",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR error",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_oper_expr : expression",
//t    "conditional_oper_expr : stackalloc_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR conditional_oper_expr COLON conditional_oper_expr",
//t    "conditional_expression : null_coalescing_expression INTERR conditional_oper_expr COLON THROW prefixed_unary_expression",
//t    "conditional_expression : null_coalescing_expression INTERR reference_expression COLON reference_expression",
//t    "conditional_expression : null_coalescing_expression INTERR conditional_oper_expr error",
//t    "conditional_expression : null_coalescing_expression INTERR conditional_oper_expr COLON error",
//t    "conditional_expression : null_coalescing_expression INTERR conditional_oper_expr COLON CLOSE_BRACE",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "assignment_expression : OPEN_PARENS_DECONSTRUCT deconstruct_assignment CLOSE_PARENS ASSIGN expression",
//t    "assignment_expression : OPEN_PARENS_DECONSTRUCT deconstruct_declaration CLOSE_PARENS ASSIGN expression",
//t    "deconstruct_assignment : expression COMMA expression",
//t    "deconstruct_assignment : deconstruct_assignment COMMA expression",
//t    "deconstruct_declaration : variable_type identifier_inside_body",
//t    "deconstruct_declaration : deconstruct_declaration COMMA variable_type identifier_inside_body",
//t    "deconstruct_declaration : deconstruct_declaration COMMA identifier_inside_body",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type identifier_inside_body",
//t    "lambda_parameter : parameter_type identifier_inside_body",
//t    "lambda_parameter : IDENTIFIER",
//t    "lambda_parameter : AWAIT",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "$$75 :",
//t    "lambda_expression_body : $$75 lambda_arrow_expression",
//t    "lambda_expression_body : block",
//t    "lambda_expression_body : error",
//t    "lambda_arrow_expression : expression",
//t    "lambda_arrow_expression : reference_expression",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$76 :",
//t    "lambda_expression : IDENTIFIER ARROW $$76 lambda_expression_body",
//t    "$$77 :",
//t    "lambda_expression : AWAIT ARROW $$77 lambda_expression_body",
//t    "$$78 :",
//t    "lambda_expression : ASYNC identifier_inside_body ARROW $$78 lambda_expression_body",
//t    "$$79 :",
//t    "$$80 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$79 opt_lambda_parameter_list CLOSE_PARENS ARROW $$80 lambda_expression_body",
//t    "$$81 :",
//t    "$$82 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$81 opt_lambda_parameter_list CLOSE_PARENS ARROW $$82 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "opt_primary_parameters :",
//t    "opt_primary_parameters : primary_parameters",
//t    "primary_parameters : OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "opt_primary_parameters_with_class_base :",
//t    "opt_primary_parameters_with_class_base : class_base",
//t    "opt_primary_parameters_with_class_base : primary_parameters",
//t    "opt_primary_parameters_with_class_base : primary_parameters class_base",
//t    "$$83 :",
//t    "opt_primary_parameters_with_class_base : primary_parameters class_base OPEN_PARENS $$83 opt_argument_list CLOSE_PARENS",
//t    "$$84 :",
//t    "$$85 :",
//t    "$$86 :",
//t    "$$87 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$84 type_declaration_name $$85 opt_primary_parameters_with_class_base opt_type_parameter_constraints_clauses $$86 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$87 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : class_base",
//t    "class_base : COLON type_list",
//t    "class_base : COLON type_list error",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER error",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$88 :",
//t    "block : OPEN_BRACE $$88 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$89 :",
//t    "block_prepared : OPEN_BRACE $$89 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$90 :",
//t    "labeled_statement : identifier_inside_body COLON $$90 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : type_name_expression opt_nullable",
//t    "variable_type_simple : type_name_expression pointer_stars",
//t    "variable_type_simple : builtin_type_expression",
//t    "variable_type_simple : tuple_type opt_nullable",
//t    "variable_type_simple : void_invalid",
//t    "tuple_type : OPEN_PARENS tuple_type_elements CLOSE_PARENS",
//t    "tuple_type_elements : variable_type IDENTIFIER COMMA variable_type IDENTIFIER",
//t    "tuple_type_elements : tuple_type_elements COMMA variable_type IDENTIFIER",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "identifier_inside_body : IDENTIFIER",
//t    "identifier_inside_body : AWAIT",
//t    "$$91 :",
//t    "block_variable_declaration : variable_type identifier_inside_body $$91 opt_local_variable_initializer opt_variable_declarators SEMICOLON",
//t    "$$92 :",
//t    "block_variable_declaration : CONST variable_type identifier_inside_body $$92 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "$$93 :",
//t    "block_variable_declaration : REF variable_type identifier_inside_body $$93 opt_local_variable_initializer opt_variable_declarators SEMICOLON",
//t    "$$94 :",
//t    "block_variable_declaration : REF READONLY variable_type identifier_inside_body $$94 opt_local_variable_initializer opt_variable_declarators SEMICOLON",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA identifier_inside_body",
//t    "variable_declarator : COMMA identifier_inside_body ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA identifier_inside_body ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "block_variable_initializer : reference_expression",
//t    "stackalloc_expression : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "stackalloc_expression : STACKALLOC simple_type",
//t    "reference_expression : REF expression",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "expression_statement : statement_expression CLOSE_BRACE",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression error",
//t    "$$95 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$95 opt_switch_sections CLOSE_BRACE",
//t    "switch_statement : SWITCH open_parens_any expression error",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "switch_section : switch_labels statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : CASE constant_expression error",
//t    "switch_label : CASE pattern_type_expr IDENTIFIER COLON",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "do_statement : DO embedded_statement error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression error",
//t    "$$96 :",
//t    "for_statement : FOR open_parens_any $$96 for_statement_cont",
//t    "$$97 :",
//t    "for_statement_cont : opt_for_initializer SEMICOLON $$97 for_condition_and_iterator_part embedded_statement",
//t    "for_statement_cont : error",
//t    "$$98 :",
//t    "for_condition_and_iterator_part : opt_for_condition SEMICOLON $$98 for_iterator_part",
//t    "for_condition_and_iterator_part : opt_for_condition close_parens_close_brace",
//t    "for_iterator_part : opt_for_iterator CLOSE_PARENS",
//t    "for_iterator_part : opt_for_iterator CLOSE_BRACE",
//t    "close_parens_close_brace : CLOSE_PARENS",
//t    "close_parens_close_brace : CLOSE_BRACE",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$99 :",
//t    "for_initializer : variable_type identifier_inside_body $$99 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "$$100 :",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body IN expression CLOSE_PARENS $$100 embedded_statement",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "continue_statement : CONTINUE error",
//t    "goto_statement : GOTO identifier_inside_body SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "return_statement : RETURN reference_expression SEMICOLON",
//t    "return_statement : RETURN expression error",
//t    "return_statement : RETURN error",
//t    "throw_statement : THROW expression SEMICOLON",
//t    "throw_statement : THROW SEMICOLON",
//t    "throw_statement : THROW expression error",
//t    "throw_statement : THROW error",
//t    "yield_statement : identifier_inside_body RETURN opt_expression SEMICOLON",
//t    "yield_statement : identifier_inside_body RETURN expression error",
//t    "yield_statement : identifier_inside_body BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : identifier_inside_body",
//t    "catch_clause : CATCH opt_catch_filter block",
//t    "$$101 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$101 opt_catch_filter_or_error",
//t    "catch_clause : CATCH open_parens_any error",
//t    "opt_catch_filter_or_error : opt_catch_filter block_prepared",
//t    "opt_catch_filter_or_error : error",
//t    "opt_catch_filter :",
//t    "$$102 :",
//t    "opt_catch_filter : WHEN $$102 open_parens_any expression CLOSE_PARENS",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$103 :",
//t    "unsafe_statement : UNSAFE $$103 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "lock_statement : LOCK open_parens_any expression error",
//t    "$$104 :",
//t    "$$105 :",
//t    "fixed_statement : FIXED open_parens_any variable_type identifier_inside_body $$104 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$105 embedded_statement",
//t    "$$106 :",
//t    "$$107 :",
//t    "using_statement : USING open_parens_any variable_type identifier_inside_body $$106 using_initialization CLOSE_PARENS $$107 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_statement : USING open_parens_any expression error",
//t    "using_initialization : using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators",
//t    "using_initialization : error",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST identifier_inside_body IN expression",
//t    "first_from_clause : FROM_FIRST type identifier_inside_body IN expression",
//t    "nested_from_clause : FROM identifier_inside_body IN expression",
//t    "nested_from_clause : FROM type identifier_inside_body IN expression",
//t    "$$108 :",
//t    "from_clause : FROM identifier_inside_body IN $$108 expression_or_error",
//t    "$$109 :",
//t    "from_clause : FROM type identifier_inside_body IN $$109 expression_or_error",
//t    "query_body : query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : select_or_group_clause opt_query_continuation",
//t    "query_body : query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : query_body_clauses error",
//t    "query_body : error",
//t    "$$110 :",
//t    "select_or_group_clause : SELECT $$110 expression_or_error",
//t    "$$111 :",
//t    "$$112 :",
//t    "select_or_group_clause : GROUP $$111 expression_or_error $$112 by_expression",
//t    "by_expression : BY expression_or_error",
//t    "by_expression : error",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$113 :",
//t    "let_clause : LET identifier_inside_body ASSIGN $$113 expression_or_error",
//t    "$$114 :",
//t    "where_clause : WHERE $$114 expression_or_error",
//t    "$$115 :",
//t    "$$116 :",
//t    "$$117 :",
//t    "join_clause : JOIN identifier_inside_body IN $$115 expression_or_error ON $$116 expression_or_error EQUALS $$117 expression_or_error opt_join_into",
//t    "$$118 :",
//t    "$$119 :",
//t    "$$120 :",
//t    "join_clause : JOIN type identifier_inside_body IN $$118 expression_or_error ON $$119 expression_or_error EQUALS $$120 expression_or_error opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO identifier_inside_body",
//t    "$$121 :",
//t    "orderby_clause : ORDERBY $$121 orderings",
//t    "orderings : order_by",
//t    "$$122 :",
//t    "orderings : order_by COMMA $$122 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$123 :",
//t    "orderings_then_by : orderings_then_by COMMA $$123 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$124 :",
//t    "opt_query_continuation : INTO identifier_inside_body $$124 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$125 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$125 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : VOID opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$126 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$126 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$127 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$127 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DEFAULT_VALUE","DELEGATE","DO","DOUBLE","ELSE","ENUM",
    "EVENT","EXPLICIT","EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR",
    "FOREACH","GOTO","IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL",
    "IS","LOCK","LONG","NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT",
    "OVERRIDE","PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF",
    "RETURN","REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC",
    "STATIC","STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY",
    "TYPEOF","UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING",
    "VIRTUAL","VOID","VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL",
    "ARROW","FROM","FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP",
    "BY","LET","ORDERBY","ASCENDING","DESCENDING","INTO",
    "INTERR_NULLABLE","EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF",
    "ASYNC","AWAIT","INTERR_OPERATOR","WHEN","INTERPOLATED_STRING",
    "INTERPOLATED_STRING_END","THROW_EXPR","GET","SET","LAST_KEYWORD",
    "OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET","CLOSE_BRACKET",
    "OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON","SEMICOLON",
    "TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT","BITWISE_AND",
    "BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR","DOUBLE_COLON",
    "OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT","OP_LE","OP_GE",
    "OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN","OP_DIV_ASSIGN",
    "OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "OPEN_PARENS_DECONSTRUCT","REF_STRUCT","REF_PARTIAL",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

#pragma warning disable 414
  int yyExpectingState;
#pragma warning restore 414
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
#pragma warning disable 649
	protected bool use_global_stacks;
#pragma warning restore 649
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 392 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 393 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
  case_7();
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 468 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 29:
  case_29();
  break;
case 30:
  case_30();
  break;
case 31:
  case_31();
  break;
case 32:
  case_32();
  break;
case 45:
  case_45();
  break;
case 46:
#line 671 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 47:
  case_47();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
  case_58();
  break;
case 59:
  case_59();
  break;
case 60:
  case_60();
  break;
case 61:
  case_61();
  break;
case 62:
  case_62();
  break;
case 63:
  case_63();
  break;
case 64:
  case_64();
  break;
case 65:
#line 797 "cs-parser.jay"
  { yyVal = "event"; }
  break;
case 66:
#line 798 "cs-parser.jay"
  { yyVal = "return"; }
  break;
case 67:
#line 805 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 68:
  case_68();
  break;
case 69:
#line 822 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 70:
  case_70();
  break;
case 72:
#line 841 "cs-parser.jay"
  { yyVal = null; }
  break;
case 73:
#line 845 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 74:
#line 850 "cs-parser.jay"
  { yyVal = null; }
  break;
case 75:
  case_75();
  break;
case 76:
  case_76();
  break;
case 77:
  case_77();
  break;
case 78:
  case_78();
  break;
case 79:
#line 892 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 81:
  case_81();
  break;
case 82:
#line 905 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 83:
  case_83();
  break;
case 84:
  case_84();
  break;
case 85:
  case_85();
  break;
case 89:
#line 949 "cs-parser.jay"
  { yyVal = null; }
  break;
case 90:
#line 953 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 93:
  case_93();
  break;
case 94:
  case_94();
  break;
case 108:
  case_108();
  break;
case 109:
  case_109();
  break;
case 110:
  case_110();
  break;
case 111:
#line 1028 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 112:
  case_112();
  break;
case 113:
  case_113();
  break;
case 114:
  case_114();
  break;
case 115:
  case_115();
  break;
case 116:
  case_116();
  break;
case 117:
  case_117();
  break;
case 118:
  case_118();
  break;
case 119:
#line 1113 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 120:
  case_120();
  break;
case 121:
  case_121();
  break;
case 122:
  case_122();
  break;
case 125:
#line 1162 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 126:
#line 1166 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 127:
  case_127();
  break;
case 128:
#line 1182 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 129:
  case_129();
  break;
case 130:
  case_130();
  break;
case 133:
  case_133();
  break;
case 134:
  case_134();
  break;
case 135:
  case_135();
  break;
case 136:
  case_136();
  break;
case 137:
#line 1260 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 139:
  case_139();
  break;
case 140:
  case_140();
  break;
case 143:
#line 1290 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 144:
#line 1294 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 145:
  case_145();
  break;
case 146:
#line 1307 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 147:
  case_147();
  break;
case 150:
#line 1326 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 151:
#line 1330 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 152:
  case_152();
  break;
case 153:
#line 1346 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 154:
  case_154();
  break;
case 155:
  case_155();
  break;
case 158:
  case_158();
  break;
case 159:
  case_159();
  break;
case 160:
  case_160();
  break;
case 161:
#line 1410 "cs-parser.jay"
  {
	  	yyVal = yyVals[0+yyTop];
	  }
  break;
case 162:
#line 1414 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 163:
  case_163();
  break;
case 164:
#line 1426 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 165:
  case_165();
  break;
case 166:
#line 1444 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 167:
  case_167();
  break;
case 168:
  case_168();
  break;
case 169:
#line 1484 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 170:
  case_170();
  break;
case 171:
#line 1494 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 172:
  case_172();
  break;
case 173:
  case_173();
  break;
case 174:
  case_174();
  break;
case 177:
#line 1568 "cs-parser.jay"
  { yyVal = null; }
  break;
case 180:
#line 1577 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
  case_184();
  break;
case 185:
#line 1618 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 187:
  case_187();
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
  case_192();
  break;
case 193:
  case_193();
  break;
case 194:
#line 1676 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 195:
#line 1680 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 196:
  case_196();
  break;
case 197:
  case_197();
  break;
case 198:
  case_198();
  break;
case 199:
  case_199();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 203:
#line 1758 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 204:
  case_204();
  break;
case 205:
#line 1799 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 207:
#line 1807 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 208:
  case_208();
  break;
case 209:
  case_209();
  break;
case 210:
  case_210();
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 213:
  case_213();
  break;
case 214:
  case_214();
  break;
case 215:
  case_215();
  break;
case 216:
  case_216();
  break;
case 217:
  case_217();
  break;
case 218:
#line 1906 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 219:
  case_219();
  break;
case 220:
  case_220();
  break;
case 221:
  case_221();
  break;
case 222:
  case_222();
  break;
case 223:
  case_223();
  break;
case 224:
#line 1966 "cs-parser.jay"
  {
		current_property = null;
	  }
  break;
case 225:
  case_225();
  break;
case 226:
  case_226();
  break;
case 228:
  case_228();
  break;
case 229:
  case_229();
  break;
case 232:
#line 2034 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue | ParameterModifierType.ReadOnly;
	  }
  break;
case 233:
  case_233();
  break;
case 234:
  case_234();
  break;
case 235:
#line 2090 "cs-parser.jay"
  {
		lbag.AppendToMember (current_property, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 236:
  case_236();
  break;
case 241:
  case_241();
  break;
case 242:
  case_242();
  break;
case 243:
  case_243();
  break;
case 244:
  case_244();
  break;
case 245:
  case_245();
  break;
case 247:
  case_247();
  break;
case 248:
  case_248();
  break;
case 249:
  case_249();
  break;
case 250:
#line 2234 "cs-parser.jay"
  {
	  }
  break;
case 251:
  case_251();
  break;
case 252:
  case_252();
  break;
case 253:
  case_253();
  break;
case 254:
  case_254();
  break;
case 255:
#line 2274 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 258:
  case_258();
  break;
case 259:
  case_259();
  break;
case 260:
#line 2299 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 261:
#line 2303 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 266:
#line 2311 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 267:
#line 2315 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 268:
#line 2319 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 269:
#line 2325 "cs-parser.jay"
  {
	  }
  break;
case 270:
  case_270();
  break;
case 272:
  case_272();
  break;
case 273:
  case_273();
  break;
case 274:
  case_274();
  break;
case 276:
#line 2416 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; }
  break;
case 277:
#line 2417 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; }
  break;
case 278:
#line 2418 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; }
  break;
case 279:
#line 2419 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; }
  break;
case 280:
#line 2420 "cs-parser.jay"
  { yyVal = Operator.OpType.True; }
  break;
case 281:
#line 2421 "cs-parser.jay"
  { yyVal = Operator.OpType.False; }
  break;
case 282:
#line 2423 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; }
  break;
case 283:
#line 2424 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; }
  break;
case 284:
#line 2426 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; }
  break;
case 285:
#line 2427 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; }
  break;
case 286:
#line 2428 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; }
  break;
case 287:
#line 2429 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; }
  break;
case 288:
#line 2430 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; }
  break;
case 289:
#line 2431 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; }
  break;
case 290:
#line 2432 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; }
  break;
case 291:
#line 2433 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; }
  break;
case 292:
#line 2434 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; }
  break;
case 293:
#line 2435 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; }
  break;
case 294:
#line 2436 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; }
  break;
case 295:
#line 2437 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; }
  break;
case 296:
#line 2438 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; }
  break;
case 297:
#line 2439 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; }
  break;
case 298:
  case_298();
  break;
case 299:
#line 2453 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue | ParameterModifierType.ReadOnly;
	  }
  break;
case 300:
  case_300();
  break;
case 301:
#line 2476 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue | ParameterModifierType.ReadOnly;
	  }
  break;
case 302:
  case_302();
  break;
case 303:
  case_303();
  break;
case 304:
  case_304();
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 307:
  case_307();
  break;
case 308:
  case_308();
  break;
case 311:
#line 2602 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 312:
  case_312();
  break;
case 313:
#line 2612 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 316:
  case_316();
  break;
case 317:
  case_317();
  break;
case 318:
  case_318();
  break;
case 319:
  case_319();
  break;
case 320:
  case_320();
  break;
case 321:
  case_321();
  break;
case 322:
  case_322();
  break;
case 323:
  case_323();
  break;
case 324:
  case_324();
  break;
case 326:
#line 2735 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 327:
  case_327();
  break;
case 330:
#line 2752 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 331:
#line 2756 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 332:
  case_332();
  break;
case 333:
  case_333();
  break;
case 334:
  case_334();
  break;
case 335:
  case_335();
  break;
case 338:
  case_338();
  break;
case 339:
  case_339();
  break;
case 340:
  case_340();
  break;
case 341:
  case_341();
  break;
case 342:
  case_342();
  break;
case 343:
  case_343();
  break;
case 344:
  case_344();
  break;
case 345:
  case_345();
  break;
case 347:
  case_347();
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 350:
  case_350();
  break;
case 351:
  case_351();
  break;
case 352:
  case_352();
  break;
case 353:
  case_353();
  break;
case 355:
#line 2966 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	 }
  break;
case 356:
  case_356();
  break;
case 359:
#line 2980 "cs-parser.jay"
  {
	  	lbag.AddLocation (yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 361:
  case_361();
  break;
case 362:
  case_362();
  break;
case 363:
  case_363();
  break;
case 364:
  case_364();
  break;
case 365:
  case_365();
  break;
case 367:
#line 3054 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue | ParameterModifierType.ReadOnly;
	  }
  break;
case 368:
  case_368();
  break;
case 369:
#line 3073 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 370:
  case_370();
  break;
case 372:
  case_372();
  break;
case 374:
  case_374();
  break;
case 375:
  case_375();
  break;
case 377:
  case_377();
  break;
case 378:
  case_378();
  break;
case 379:
  case_379();
  break;
case 380:
  case_380();
  break;
case 382:
  case_382();
  break;
case 383:
  case_383();
  break;
case 384:
  case_384();
  break;
case 385:
  case_385();
  break;
case 386:
#line 3192 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 387:
  case_387();
  break;
case 388:
  case_388();
  break;
case 390:
  case_390();
  break;
case 391:
  case_391();
  break;
case 392:
  case_392();
  break;
case 393:
  case_393();
  break;
case 394:
  case_394();
  break;
case 395:
  case_395();
  break;
case 397:
  case_397();
  break;
case 398:
  case_398();
  break;
case 399:
  case_399();
  break;
case 400:
  case_400();
  break;
case 401:
  case_401();
  break;
case 403:
#line 3310 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 404:
#line 3317 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 410:
  case_410();
  break;
case 412:
#line 3347 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 413:
  case_413();
  break;
case 414:
#line 3366 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 416:
  case_416();
  break;
case 417:
  case_417();
  break;
case 418:
  case_418();
  break;
case 422:
  case_422();
  break;
case 423:
  case_423();
  break;
case 424:
#line 3433 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 425:
#line 3437 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 426:
  case_426();
  break;
case 427:
  case_427();
  break;
case 428:
  case_428();
  break;
case 429:
#line 3470 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 430:
#line 3471 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 431:
#line 3472 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 432:
#line 3473 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 433:
#line 3474 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 434:
#line 3475 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 436:
#line 3480 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 437:
#line 3481 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 438:
#line 3482 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 439:
#line 3483 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 440:
#line 3484 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 441:
#line 3485 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 442:
#line 3486 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 443:
#line 3487 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 444:
#line 3488 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 468:
  case_468();
  break;
case 473:
#line 3534 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 474:
#line 3538 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 475:
#line 3539 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 476:
  case_476();
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
#line 3570 "cs-parser.jay"
  {
		yyVal = new TupleLiteralElement ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 480:
  case_480();
  break;
case 481:
  case_481();
  break;
case 482:
  case_482();
  break;
case 483:
  case_483();
  break;
case 484:
  case_484();
  break;
case 485:
#line 3615 "cs-parser.jay"
  {
		yyVal = new InterpolatedStringInsert ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 486:
  case_486();
  break;
case 487:
#line 3625 "cs-parser.jay"
  {
		lexer.parsing_interpolation_format = true;
	  }
  break;
case 488:
  case_488();
  break;
case 489:
#line 3637 "cs-parser.jay"
  {
		lexer.parsing_interpolation_format = true;
	  }
  break;
case 490:
  case_490();
  break;
case 495:
  case_495();
  break;
case 496:
#line 3679 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 497:
  case_497();
  break;
case 498:
  case_498();
  break;
case 499:
  case_499();
  break;
case 500:
  case_500();
  break;
case 501:
  case_501();
  break;
case 502:
  case_502();
  break;
case 503:
  case_503();
  break;
case 504:
  case_504();
  break;
case 505:
#line 3740 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 506:
  case_506();
  break;
case 507:
#line 3748 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 508:
  case_508();
  break;
case 509:
  case_509();
  break;
case 510:
  case_510();
  break;
case 511:
  case_511();
  break;
case 512:
#line 3778 "cs-parser.jay"
  { yyVal = null; }
  break;
case 514:
  case_514();
  break;
case 515:
  case_515();
  break;
case 516:
#line 3800 "cs-parser.jay"
  { yyVal = null; }
  break;
case 517:
#line 3804 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 518:
  case_518();
  break;
case 519:
  case_519();
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
#line 3842 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 524:
  case_524();
  break;
case 525:
  case_525();
  break;
case 526:
  case_526();
  break;
case 527:
  case_527();
  break;
case 530:
#line 3881 "cs-parser.jay"
  { yyVal = null; }
  break;
case 532:
  case_532();
  break;
case 533:
  case_533();
  break;
case 534:
  case_534();
  break;
case 535:
  case_535();
  break;
case 536:
  case_536();
  break;
case 537:
#line 3933 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 541:
  case_541();
  break;
case 542:
  case_542();
  break;
case 543:
#line 3956 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
	  }
  break;
case 544:
  case_544();
  break;
case 545:
  case_545();
  break;
case 546:
  case_546();
  break;
case 547:
  case_547();
  break;
case 549:
  case_549();
  break;
case 550:
  case_550();
  break;
case 551:
  case_551();
  break;
case 552:
  case_552();
  break;
case 553:
  case_553();
  break;
case 554:
  case_554();
  break;
case 555:
  case_555();
  break;
case 556:
  case_556();
  break;
case 557:
#line 4060 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 559:
#line 4068 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 560:
  case_560();
  break;
case 561:
  case_561();
  break;
case 562:
#line 4088 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 563:
#line 4095 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 564:
  case_564();
  break;
case 565:
  case_565();
  break;
case 566:
  case_566();
  break;
case 567:
  case_567();
  break;
case 568:
  case_568();
  break;
case 569:
  case_569();
  break;
case 570:
  case_570();
  break;
case 571:
#line 4167 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 572:
  case_572();
  break;
case 573:
  case_573();
  break;
case 574:
#line 4189 "cs-parser.jay"
  {
		yyVal = new EmptyCompletion ();
	  }
  break;
case 577:
#line 4198 "cs-parser.jay"
  { yyVal = null; }
  break;
case 579:
  case_579();
  break;
case 580:
  case_580();
  break;
case 581:
#line 4218 "cs-parser.jay"
  {
		yyVal = new EmptyCompletion ();
	  }
  break;
case 582:
#line 4222 "cs-parser.jay"
  {
	  	yyVal = yyVals[-1+yyTop];
	  }
  break;
case 583:
  case_583();
  break;
case 584:
  case_584();
  break;
case 585:
  case_585();
  break;
case 586:
  case_586();
  break;
case 590:
  case_590();
  break;
case 591:
  case_591();
  break;
case 592:
  case_592();
  break;
case 593:
#line 4282 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 594:
#line 4286 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 595:
#line 4293 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 596:
#line 4297 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
  case_601();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 607:
  case_607();
  break;
case 608:
  case_608();
  break;
case 609:
  case_609();
  break;
case 610:
  case_610();
  break;
case 611:
  case_611();
  break;
case 612:
  case_612();
  break;
case 613:
#line 4429 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 614:
#line 4433 "cs-parser.jay"
  {
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
	  }
  break;
case 615:
#line 4437 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 616:
#line 4441 "cs-parser.jay"
  {
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
	  }
  break;
case 617:
#line 4448 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 619:
#line 4456 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.ReadOnly;
	  }
  break;
case 620:
  case_620();
  break;
case 621:
  case_621();
  break;
case 622:
  case_622();
  break;
case 624:
#line 4490 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 625:
#line 4494 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 626:
  case_626();
  break;
case 627:
  case_627();
  break;
case 628:
  case_628();
  break;
case 629:
  case_629();
  break;
case 630:
  case_630();
  break;
case 631:
  case_631();
  break;
case 632:
  case_632();
  break;
case 634:
#line 4565 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 635:
#line 4569 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 636:
#line 4573 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 637:
#line 4577 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 638:
#line 4581 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 639:
#line 4585 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 640:
  case_640();
  break;
case 641:
  case_641();
  break;
case 642:
  case_642();
  break;
case 643:
  case_643();
  break;
case 644:
  case_644();
  break;
case 645:
  case_645();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 656:
  case_656();
  break;
case 657:
  case_657();
  break;
case 658:
#line 4692 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 659:
  case_659();
  break;
case 660:
  case_660();
  break;
case 661:
  case_661();
  break;
case 662:
  case_662();
  break;
case 663:
  case_663();
  break;
case 664:
  case_664();
  break;
case 667:
#line 4749 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 668:
#line 4753 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 671:
  case_671();
  break;
case 672:
#line 4764 "cs-parser.jay"
  {
		yyVal = new WildcardPattern (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 674:
#line 4782 "cs-parser.jay"
  {
		yyVal = new PropertyPattern ((ATypeNameExpression) yyVals[-3+yyTop], (List<PropertyPatternMember>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 675:
  case_675();
  break;
case 676:
  case_676();
  break;
case 677:
  case_677();
  break;
case 679:
  case_679();
  break;
case 681:
  case_681();
  break;
case 682:
  case_682();
  break;
case 683:
  case_683();
  break;
case 684:
  case_684();
  break;
case 686:
  case_686();
  break;
case 687:
  case_687();
  break;
case 688:
  case_688();
  break;
case 689:
  case_689();
  break;
case 690:
  case_690();
  break;
case 691:
  case_691();
  break;
case 692:
  case_692();
  break;
case 693:
  case_693();
  break;
case 695:
  case_695();
  break;
case 696:
  case_696();
  break;
case 697:
  case_697();
  break;
case 698:
  case_698();
  break;
case 700:
  case_700();
  break;
case 701:
  case_701();
  break;
case 703:
  case_703();
  break;
case 704:
  case_704();
  break;
case 706:
  case_706();
  break;
case 707:
  case_707();
  break;
case 709:
  case_709();
  break;
case 710:
  case_710();
  break;
case 712:
  case_712();
  break;
case 713:
  case_713();
  break;
case 715:
  case_715();
  break;
case 719:
  case_719();
  break;
case 720:
  case_720();
  break;
case 721:
  case_721();
  break;
case 722:
  case_722();
  break;
case 723:
  case_723();
  break;
case 724:
  case_724();
  break;
case 725:
  case_725();
  break;
case 726:
  case_726();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
  case_730();
  break;
case 731:
  case_731();
  break;
case 732:
  case_732();
  break;
case 733:
  case_733();
  break;
case 734:
  case_734();
  break;
case 735:
  case_735();
  break;
case 736:
  case_736();
  break;
case 737:
  case_737();
  break;
case 738:
  case_738();
  break;
case 739:
  case_739();
  break;
case 740:
  case_740();
  break;
case 741:
  case_741();
  break;
case 742:
  case_742();
  break;
case 743:
  case_743();
  break;
case 744:
  case_744();
  break;
case 745:
  case_745();
  break;
case 746:
  case_746();
  break;
case 747:
  case_747();
  break;
case 748:
  case_748();
  break;
case 749:
#line 5285 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 750:
  case_750();
  break;
case 751:
#line 5295 "cs-parser.jay"
  {
		start_block (Location.Null);
	  }
  break;
case 752:
  case_752();
  break;
case 754:
  case_754();
  break;
case 758:
  case_758();
  break;
case 759:
  case_759();
  break;
case 760:
  case_760();
  break;
case 761:
  case_761();
  break;
case 762:
  case_762();
  break;
case 763:
  case_763();
  break;
case 764:
  case_764();
  break;
case 765:
#line 5367 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.ReadOnly;
	  }
  break;
case 766:
  case_766();
  break;
case 767:
  case_767();
  break;
case 768:
#line 5381 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.ReadOnly;
	  }
  break;
case 769:
  case_769();
  break;
case 770:
  case_770();
  break;
case 776:
#line 5406 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 777:
  case_777();
  break;
case 778:
  case_778();
  break;
case 779:
  case_779();
  break;
case 781:
#line 5435 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 782:
#line 5442 "cs-parser.jay"
  {
	  	yyVal = null;
	  }
  break;
case 784:
  case_784();
  break;
case 785:
#line 5463 "cs-parser.jay"
  {
	  	yyVal = null;
	  }
  break;
case 786:
#line 5467 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 787:
#line 5471 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 788:
#line 5475 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 789:
  case_789();
  break;
case 790:
  case_790();
  break;
case 791:
#line 5500 "cs-parser.jay"
  {
	  }
  break;
case 792:
  case_792();
  break;
case 793:
  case_793();
  break;
case 794:
  case_794();
  break;
case 795:
  case_795();
  break;
case 796:
#line 5552 "cs-parser.jay"
  { yyVal = null; }
  break;
case 797:
#line 5554 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; }
  break;
case 798:
  case_798();
  break;
case 799:
#line 5567 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 801:
  case_801();
  break;
case 802:
  case_802();
  break;
case 803:
  case_803();
  break;
case 804:
  case_804();
  break;
case 805:
  case_805();
  break;
case 806:
  case_806();
  break;
case 807:
  case_807();
  break;
case 808:
  case_808();
  break;
case 809:
  case_809();
  break;
case 810:
  case_810();
  break;
case 811:
  case_811();
  break;
case 812:
  case_812();
  break;
case 813:
  case_813();
  break;
case 814:
  case_814();
  break;
case 815:
  case_815();
  break;
case 816:
  case_816();
  break;
case 819:
#line 5689 "cs-parser.jay"
  {
		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[0+yyTop]);
	 }
  break;
case 820:
  case_820();
  break;
case 822:
#line 5703 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 823:
  case_823();
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 826:
  case_826();
  break;
case 827:
  case_827();
  break;
case 828:
  case_828();
  break;
case 829:
  case_829();
  break;
case 830:
  case_830();
  break;
case 831:
#line 5795 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 832:
#line 5799 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 833:
#line 5806 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 834:
  case_834();
  break;
case 835:
#line 5820 "cs-parser.jay"
  {
		yyVal = new VarianceDecl (Variance.Covariant, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 836:
#line 5824 "cs-parser.jay"
  {
		yyVal = new VarianceDecl (Variance.Contravariant, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 837:
  case_837();
  break;
case 838:
#line 5849 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 839:
  case_839();
  break;
case 840:
  case_840();
  break;
case 841:
  case_841();
  break;
case 842:
  case_842();
  break;
case 847:
#line 5893 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 848:
#line 5897 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 850:
  case_850();
  break;
case 853:
#line 5921 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 854:
#line 5925 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 883:
  case_883();
  break;
case 884:
  case_884();
  break;
case 885:
  case_885();
  break;
case 886:
  case_886();
  break;
case 887:
  case_887();
  break;
case 890:
  case_890();
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 894:
  case_894();
  break;
case 896:
  case_896();
  break;
case 897:
  case_897();
  break;
case 898:
  case_898();
  break;
case 900:
  case_900();
  break;
case 901:
#line 6097 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 903:
#line 6105 "cs-parser.jay"
  {
	  	yyVal = Error_AwaitAsIdentifier (yyVals[0+yyTop]);
	  }
  break;
case 904:
  case_904();
  break;
case 905:
  case_905();
  break;
case 906:
  case_906();
  break;
case 907:
  case_907();
  break;
case 908:
  case_908();
  break;
case 909:
  case_909();
  break;
case 910:
  case_910();
  break;
case 911:
  case_911();
  break;
case 913:
  case_913();
  break;
case 914:
  case_914();
  break;
case 918:
  case_918();
  break;
case 921:
  case_921();
  break;
case 922:
  case_922();
  break;
case 923:
#line 6249 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 924:
#line 6253 "cs-parser.jay"
  {
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }
  break;
case 929:
  case_929();
  break;
case 931:
  case_931();
  break;
case 932:
  case_932();
  break;
case 934:
  case_934();
  break;
case 935:
  case_935();
  break;
case 936:
  case_936();
  break;
case 937:
  case_937();
  break;
case 938:
#line 6327 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 939:
  case_939();
  break;
case 940:
#line 6337 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 941:
#line 6338 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 942:
  case_942();
  break;
case 943:
  case_943();
  break;
case 944:
  case_944();
  break;
case 947:
  case_947();
  break;
case 948:
  case_948();
  break;
case 949:
  case_949();
  break;
case 950:
#line 6410 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 951:
  case_951();
  break;
case 952:
  case_952();
  break;
case 953:
#line 6430 "cs-parser.jay"
  {
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
	  }
  break;
case 957:
#line 6440 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 959:
  case_959();
  break;
case 960:
#line 6457 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 961:
  case_961();
  break;
case 962:
  case_962();
  break;
case 963:
  case_963();
  break;
case 964:
#line 6498 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 969:
  case_969();
  break;
case 970:
  case_970();
  break;
case 971:
  case_971();
  break;
case 972:
  case_972();
  break;
case 973:
  case_973();
  break;
case 974:
  case_974();
  break;
case 975:
#line 6558 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 976:
  case_976();
  break;
case 977:
  case_977();
  break;
case 978:
  case_978();
  break;
case 979:
  case_979();
  break;
case 980:
#line 6599 "cs-parser.jay"
  {
		yyVal = new Tuple<Location,Location> (GetLocation (yyVals[-2+yyTop]), (Location) yyVals[0+yyTop]);
	  }
  break;
case 981:
  case_981();
  break;
case 982:
  case_982();
  break;
case 983:
  case_983();
  break;
case 985:
#line 6627 "cs-parser.jay"
  { lexer.putback ('}'); }
  break;
case 986:
#line 6631 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 988:
  case_988();
  break;
case 989:
  case_989();
  break;
case 991:
#line 6655 "cs-parser.jay"
  { yyVal = null; }
  break;
case 993:
#line 6660 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 997:
  case_997();
  break;
case 998:
  case_998();
  break;
case 999:
  case_999();
  break;
case 1000:
  case_1000();
  break;
case 1001:
  case_1001();
  break;
case 1008:
  case_1008();
  break;
case 1009:
  case_1009();
  break;
case 1010:
  case_1010();
  break;
case 1011:
  case_1011();
  break;
case 1012:
  case_1012();
  break;
case 1013:
  case_1013();
  break;
case 1014:
  case_1014();
  break;
case 1015:
  case_1015();
  break;
case 1016:
  case_1016();
  break;
case 1017:
  case_1017();
  break;
case 1018:
  case_1018();
  break;
case 1019:
  case_1019();
  break;
case 1020:
  case_1020();
  break;
case 1021:
  case_1021();
  break;
case 1022:
  case_1022();
  break;
case 1023:
  case_1023();
  break;
case 1024:
  case_1024();
  break;
case 1027:
#line 6894 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 1028:
  case_1028();
  break;
case 1029:
  case_1029();
  break;
case 1030:
  case_1030();
  break;
case 1031:
  case_1031();
  break;
case 1032:
  case_1032();
  break;
case 1035:
  case_1035();
  break;
case 1036:
  case_1036();
  break;
case 1037:
  case_1037();
  break;
case 1038:
  case_1038();
  break;
case 1039:
#line 6985 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 1040:
  case_1040();
  break;
case 1041:
#line 6997 "cs-parser.jay"
  {
		lexer.parsing_catch_when = false;
	  }
  break;
case 1042:
#line 7001 "cs-parser.jay"
  {
		lexer.parsing_catch_when = false;
	  }
  break;
case 1043:
  case_1043();
  break;
case 1044:
#line 7016 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 1045:
#line 7023 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 1046:
  case_1046();
  break;
case 1047:
#line 7033 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 1048:
  case_1048();
  break;
case 1049:
  case_1049();
  break;
case 1050:
  case_1050();
  break;
case 1051:
  case_1051();
  break;
case 1052:
  case_1052();
  break;
case 1053:
  case_1053();
  break;
case 1054:
  case_1054();
  break;
case 1055:
  case_1055();
  break;
case 1056:
  case_1056();
  break;
case 1057:
  case_1057();
  break;
case 1059:
  case_1059();
  break;
case 1060:
#line 7137 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 1061:
  case_1061();
  break;
case 1062:
  case_1062();
  break;
case 1063:
  case_1063();
  break;
case 1064:
  case_1064();
  break;
case 1065:
  case_1065();
  break;
case 1066:
  case_1066();
  break;
case 1067:
  case_1067();
  break;
case 1068:
  case_1068();
  break;
case 1069:
  case_1069();
  break;
case 1070:
#line 7241 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1071:
  case_1071();
  break;
case 1072:
#line 7257 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1073:
  case_1073();
  break;
case 1074:
  case_1074();
  break;
case 1075:
  case_1075();
  break;
case 1077:
  case_1077();
  break;
case 1078:
  case_1078();
  break;
case 1079:
#line 7321 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1080:
  case_1080();
  break;
case 1081:
  case_1081();
  break;
case 1082:
  case_1082();
  break;
case 1083:
  case_1083();
  break;
case 1084:
#line 7360 "cs-parser.jay"
  {
	  	yyVal = new object[] { yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]) };
	  }
  break;
case 1085:
  case_1085();
  break;
case 1087:
  case_1087();
  break;
case 1093:
#line 7389 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1094:
  case_1094();
  break;
case 1095:
#line 7408 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1096:
  case_1096();
  break;
case 1097:
  case_1097();
  break;
case 1098:
  case_1098();
  break;
case 1099:
  case_1099();
  break;
case 1100:
  case_1100();
  break;
case 1101:
  case_1101();
  break;
case 1102:
  case_1102();
  break;
case 1103:
  case_1103();
  break;
case 1104:
  case_1104();
  break;
case 1106:
#line 7553 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 1107:
#line 7560 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1108:
  case_1108();
  break;
case 1110:
  case_1110();
  break;
case 1111:
  case_1111();
  break;
case 1113:
  case_1113();
  break;
case 1114:
  case_1114();
  break;
case 1115:
#line 7606 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 1116:
  case_1116();
  break;
case 1117:
  case_1117();
  break;
case 1118:
#line 7623 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 1119:
  case_1119();
  break;
case 1120:
  case_1120();
  break;
case 1122:
  case_1122();
  break;
case 1123:
  case_1123();
  break;
case 1126:
  case_1126();
  break;
case 1127:
  case_1127();
  break;
case 1135:
#line 7748 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 1136:
#line 7755 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 1137:
  case_1137();
  break;
case 1138:
  case_1138();
  break;
case 1139:
  case_1139();
  break;
case 1140:
#line 7778 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }
  break;
case 1141:
#line 7782 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.ReadOnly;
	  }
  break;
case 1142:
  case_1142();
  break;
case 1143:
  case_1143();
  break;
case 1144:
  case_1144();
  break;
case 1145:
  case_1145();
  break;
case 1147:
#line 7818 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 1149:
#line 7826 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.ReadOnly;
	  }
  break;
case 1150:
#line 7830 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 1151:
#line 7837 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 1153:
  case_1153();
  break;
case 1154:
  case_1154();
  break;
case 1155:
  case_1155();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 400 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");

			current_namespace.UnattachedAttributes = attrs;
		}
	  }

void case_7()
#line 410 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[0+yyTop];
		if (attrs != null) {
			foreach (var a in attrs.Attrs) {
				if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
					continue;

				if (a.ExplicitTarget == null)
					report.Error (-1671, a.Location, "Global attributes must have attribute target specified");
			}
		}

		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }

void case_8()
#line 425 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 445 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias") {
			syntax_error (lt.Location, "`alias' expected");
		} else {
			if (lang_version == LanguageVersion.ISO_1)
				FeatureIsNotAvailable (lt.Location, "external alias");

			lt = (LocatedToken) yyVals[-1+yyTop];
			if (lt.Value == QualifiedAliasMember.GlobalAlias) {
				RootNamespace.Error_GlobalNamespaceRedefined (report, lt.Location);
			}
			
			var na = new UsingExternAlias (new SimpleMemberName (lt.Value, lt.Location), GetLocation (yyVals[-3+yyTop]));
			current_namespace.AddUsing (na);
			
			lbag.AddLocation (na, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 478 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 486 "cs-parser.jay"
{
		UsingClause uc;
		if (yyVals[-2+yyTop] != null) {
			if (lang_version <= LanguageVersion.V_5)
				FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "using static");

			uc = new UsingType ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
			lbag.AddLocation (uc, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			uc = new UsingNamespace ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
			lbag.AddLocation (uc, GetLocation (yyVals[0+yyTop]));
		}

		current_namespace.AddUsing (uc);
	  }

void case_19()
#line 502 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		if (yyVals[-4+yyTop] != null) {
			report.Error (8085, GetLocation (yyVals[-4+yyTop]), "A `using static' directive cannot be used to declare an alias");
		}

		var un = new UsingAliasNamespace (new SimpleMemberName (lt.Value, lt.Location), (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		current_namespace.AddUsing (un);
		
		lbag.AddLocation (un, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_20()
#line 519 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_23()
#line 537 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		var name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		var ns = new NamespaceContainer (name, current_namespace);
		current_namespace.AddTypeContainer (ns);
		current_container = current_namespace = ns;
	  }

void case_24()
#line 565 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_25()
#line 570 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  
		current_container = current_namespace = current_namespace.Parent;
	  }

void case_26()
#line 579 "cs-parser.jay"
{
		report.Error (1514, lexer.Location, "Unexpected symbol `{0}', expecting `.' or `{{'", GetSymbolName (yyToken));

		var name = (MemberName) yyVals[0+yyTop];		
		var ns = new NamespaceContainer (name, current_namespace);
		lbag.AddLocation (ns, GetLocation (yyVals[-1+yyTop]));
		current_namespace.AddTypeContainer (ns);
	  }

void case_29()
#line 593 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_30()
#line 601 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_31()
#line 606 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location);		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_32()
#line 612 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_45()
#line 650 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location,
				"Namespace elements cannot be explicitly declared as private, protected, protected internal, or private protected");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_47()
#line 672 "cs-parser.jay"
{
		current_namespace.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1518, lexer.Location, "Attributes must be attached to class, delegate, enum, interface or struct");
		lexer.putback ('}');
	  }

void case_55()
#line 705 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
	  }

void case_56()
#line 710 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		if (attrs == null)
			attrs = new Attributes (sect);
		else if (sect != null)
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_57()
#line 723 "cs-parser.jay"
{
	  	PushLocation (GetLocation (yyVals[0+yyTop]));
		lexer.parsing_attribute_section = true;
	  }

void case_58()
#line 728 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_59()
#line 736 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_60()
#line 743 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];

		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}

		current_attr_target = null;
		lexer.parsing_attribute_section = false;
 	  }

void case_61()
#line 761 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];

		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation(yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation(yyVals[0+yyTop]));
		}
	  }

void case_62()
#line 772 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-1+yyTop];
		var tne = new SimpleName (lt.Value, null, lt.Location);

		yyVal = new List<Attribute> () {
			new Attribute (null, tne, null, GetLocation (yyVals[-1+yyTop]), false)
		};
	  }

void case_63()
#line 783 "cs-parser.jay"
{
		if (CheckAttributeTarget (yyToken, GetTokenName (yyToken), GetLocation (yyVals[0+yyTop])).Length > 0)
			Error_SyntaxError (yyToken);

 		yyVal = null;
	  }

void case_64()
#line 793 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (yyToken, lt.Value, lt.Location);
	  }

void case_68()
#line 807 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		if (attrs != null) {
			attrs.Add ((Attribute) yyVals[0+yyTop]);
	  		lbag.AppendTo (attrs, GetLocation (yyVals[-1+yyTop]));
	  	}

		yyVal = attrs;
	  }

void case_70()
#line 824 "cs-parser.jay"
{
		--lexer.parsing_block;
		
		var tne = (ATypeNameExpression) yyVals[-2+yyTop];
		if (tne.HasTypeArguments) {
			report.Error (404, tne.Location, "Attributes cannot be generic");
		}

		yyVal = new Attribute (current_attr_target, tne, (Arguments[]) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), lexer.IsEscapedIdentifier (tne));
	  }

void case_75()
#line 852 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_76()
#line 858 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_77()
#line 864 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (lang_version < LanguageVersion.V_7_2 && args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
	  }

void case_78()
#line 878 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
	  }

void case_81()
#line 895 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_83()
#line 907 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_84()
#line 917 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_85()
#line 929 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");

		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_93()
#line 963 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_94()
#line 968 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_108()
#line 989 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_109()
#line 999 "cs-parser.jay"
{
		current_local_parameters = current_type.PrimaryConstructorParameters;
		if (current_local_parameters == null) {
			report.Error (9010, GetLocation (yyVals[0+yyTop]), "Primary constructor body is not allowed");
			current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		}

		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_110()
#line 1010 "cs-parser.jay"
{
		current_local_parameters = null;
		var t = current_type as ClassOrStruct;
		if (t != null) {
			var b = (ToplevelBlock) yyVals[0+yyTop];
			if (t.PrimaryConstructorBlock != null) {
				report.Error (8041, b.StartLocation, "Primary constructor already has a body");
			} else {
				t.PrimaryConstructorBlock = b;
			}
		}
	  }

void case_112()
#line 1030 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_2) {
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "ref structs");
		}

		yyVal = RefStructToken;
	  }

void case_113()
#line 1038 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_2) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "ref structs");
		}

		yyVal = RefPartialStructToken;
	  }

void case_114()
#line 1053 "cs-parser.jay"
{
		var mods = (Modifiers) yyVals[-3+yyTop];
		if ((mods & Modifiers.READONLY) != 0 && lang_version < LanguageVersion.V_7_2) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "readonly structs");
		}
		if (yyVals[-1+yyTop] != null) {
			mods |= Modifiers.REF;
			if (yyVals[-1+yyTop] == RefPartialStructToken) {
				mods |= Modifiers.PARTIAL;
				yyVals[-2+yyTop] = yyVals[-1+yyTop];
			}
		}

		lexer.ConstraintsParsing = true;
		valid_param_mod = ParameterModifierType.PrimaryConstructor;
		push_current_container (new Struct (current_container, (MemberName) yyVals[0+yyTop], mods, (Attributes) yyVals[-4+yyTop]), yyVals[-2+yyTop]);
	  }

void case_115()
#line 1073 "cs-parser.jay"
{
		valid_param_mod = 0;
		lexer.ConstraintsParsing = false;

		if (yyVals[-2+yyTop] != null)
			current_type.PrimaryConstructorParameters = (ParametersCompiled) yyVals[-2+yyTop];

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (current_container, mod_locations, GetLocation (yyVals[-5+yyTop]));
		
		lexer.parsing_modifiers = true;
	  }

void case_116()
#line 1091 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_117()
#line 1096 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_118()
#line 1102 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_120()
#line 1120 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_121()
#line 1133 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, mod_locations, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_122()
#line 1146 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_127()
#line 1171 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_129()
#line 1184 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_130()
#line 1189 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_133()
#line 1204 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_134()
#line 1219 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, mod_locations, GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_135()
#line 1232 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_type.AddField (current_field);
	  }

void case_136()
#line 1243 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, mod_locations, GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_139()
#line 1266 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_140()
#line 1272 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_145()
#line 1299 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_147()
#line 1309 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_152()
#line 1335 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_154()
#line 1348 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_155()
#line 1354 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_158()
#line 1364 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_159()
#line 1373 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Was added earlier in the case of body being eof for full ast*/
	  }

void case_160()
#line 1380 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		async_block = false;
		
		if (method.Block == null) {
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_163()
#line 1416 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "byref locals and returns");
		}

		yyVal = new ReferenceTypeExpr ((FullNamedExpression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_165()
#line 1428 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_2) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "readonly references");
		}

		yyVal = new ReferenceTypeExpr ((FullNamedExpression) yyVals[0+yyTop], true, GetLocation (yyVals[-3+yyTop]));
	  }

void case_167()
#line 1446 "cs-parser.jay"
{
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-6+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, mod_locations, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = method;

		lexer.ConstraintsParsing = true;
	  }

void case_168()
#line 1468 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null) {
			var method = (Method) yyVals[-1+yyTop];
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_170()
#line 1487 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		valid_param_mod = ParameterModifierType.All;
	  }

void case_172()
#line 1496 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_type, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (yyVals[0+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, mod_locations, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_173()
#line 1527 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_174()
#line 1548 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.Undefined;

		MemberName name = (MemberName) yyVals[-1+yyTop];
		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-3+yyTop],
									name, current_local_parameters, (Attributes) yyVals[-4+yyTop]);

		current_type.AddMember (method);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_181()
#line 1579 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7) {
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "expression body constructor");
		}

		++lexer.parsing_block;
	 }

void case_182()
#line 1587 "cs-parser.jay"
{
		lexer.parsing_block = 0;
		current_block.AddStatement (CreateExpressionBodiedStatement ((Expression) yyVals[-1+yyTop]));
		var b = end_block (GetLocation (yyVals[0+yyTop]));
		b.IsCompilerGenerated = true;
		yyVal = b;
		current_block = null;
	 }

void case_183()
#line 1599 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6) {
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "expression bodied members");
		}

		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	 }

void case_184()
#line 1608 "cs-parser.jay"
{
		lexer.parsing_block = 0;
		current_block.AddStatement (CreateExpressionBodiedStatement ((Expression) yyVals[-1+yyTop]));
		var b = end_block (GetLocation (yyVals[0+yyTop]));
		b.IsCompilerGenerated = true;
		yyVal = b;
	 }

void case_187()
#line 1624 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  }

void case_188()
#line 1629 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  }

void case_189()
#line 1636 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_190()
#line 1642 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  }

void case_191()
#line 1649 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_192()
#line 1659 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  }

void case_193()
#line 1665 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_196()
#line 1682 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_197()
#line 1690 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_198()
#line 1699 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			lbag.AddLocation (p, GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_199()
#line 1723 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
	  }

void case_200()
#line 1731 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
	  }

void case_201()
#line 1737 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter (null, null, Parameter.Modifier.NONE, (Attributes) yyVals[-1+yyTop], l);
	  }

void case_202()
#line 1746 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
	  }

void case_204()
#line 1760 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_208()
#line 1809 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
		} else if ((mod & ~(Parameter.Modifier.This | Parameter.Modifier.ReadOnly)) == 0) {
			/* ok*/
		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_209()
#line 1835 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
	  		
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_210()
#line 1842 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
	  
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_211()
#line 1849 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
	  			
		yyVal = Parameter.Modifier.This;
	  }

void case_212()
#line 1859 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "readonly references");

		yyVal = Parameter.Modifier.ReadOnly;
	  }

void case_213()
#line 1869 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
	  }

void case_214()
#line 1874 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
	  }

void case_215()
#line 1881 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Attributes) yyVals[-3+yyTop], Location.Null);
	  }

void case_216()
#line 1890 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
	  }

void case_217()
#line 1895 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref, out or in");
		}	  
	  }

void case_219()
#line 1911 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_220()
#line 1922 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_221()
#line 1928 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_type.AddMember (current_property);
		lbag.AddMember (current_property, mod_locations, GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_222()
#line 1942 "cs-parser.jay"
{
		lexer.PropertyParsing = false;

		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();

		if (yyVals[-5+yyTop] is ReferenceTypeExpr) {
			if (current_property.Get == null) {
				report.Error (8146, GetLocation (yyVals[-4+yyTop]), "`{0}': property and indexer which return by reference must have a get accessor", current_property.GetSignatureForError ());
			}

			if (current_property.Set != null) {
				report.Error (8147, GetLocation (yyVals[-4+yyTop]), "`{0}': property and indexer which return by reference cannot have set accessors", current_property.GetSignatureForError ());
			}
		}
	  }

void case_223()
#line 1959 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		lexer.parsing_modifiers = true;
	  }

void case_225()
#line 1971 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_226()
#line 1978 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		var property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);

		property.Get = new Property.GetMethod (property, Modifiers.COMPILER_GENERATED, null, property.Location);
		property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];

		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, property.Get.Block.StartLocation,
				"`{0}': interface members cannot have a definition", property.GetSignatureForError ());
		}

		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", property.GetSignatureForError ());

		if (doc_support)
			property.DocComment = ConsumeStoredComment ();

		current_type.AddMember (property);

		current_local_parameters = null;
	  }

void case_228()
#line 2006 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_229()
#line 2012 "cs-parser.jay"
{
		--lexer.parsing_block;
		((Property)current_property).Initializer = (Expression) yyVals[-1+yyTop];
		lbag.AppendToMember (current_property, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		end_block (GetLocation (yyVals[0+yyTop]));
		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_233()
#line 2036 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-5+yyTop];
		Indexer indexer = new Indexer (current_type, type, (MemberName) yyVals[-4+yyTop], (Modifiers) yyVals[-6+yyTop], (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);
			
		current_property = indexer;

  		current_type.AddIndexer (indexer);
		lbag.AddMember (current_property, mod_locations, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-5+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-3+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
	  }

void case_234()
#line 2062 "cs-parser.jay"
{
 		lexer.PropertyParsing = false;
		current_local_parameters = null;

		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();

		if (yyVals[-7+yyTop] is ReferenceTypeExpr) {
			if (current_property.Get == null) {
				report.Error (8146, GetLocation (yyVals[-6+yyTop]), "`{0}': property and indexer which return by reference must have a get accessor", current_property.GetSignatureForError ());
			}

			if (current_property.Set != null) {
				report.Error (8147, GetLocation (yyVals[-6+yyTop]), "`{0}': property and indexer which return by reference cannot have set accessors", current_property.GetSignatureForError ());
			}
		}
			
		current_property = null;		
	  }

void case_236()
#line 2092 "cs-parser.jay"
{
		current_property.Get = new Indexer.GetIndexerMethod (current_property, Modifiers.COMPILER_GENERATED, current_local_parameters, null, current_property.Location);
		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];
	  }

void case_241()
#line 2104 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_242()
#line 2118 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lbag.AddMember (current_property.Get, mod_locations);
		lexer.PropertyParsing = false;
	  }

void case_243()
#line 2140 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}		
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_244()
#line 2161 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lbag.AddMember (current_property.Set, mod_locations);
		lexer.PropertyParsing = false;
	  }

void case_245()
#line 2188 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_247()
#line 2210 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7) {
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "expression body property accessor");
		}
	  }

void case_248()
#line 2216 "cs-parser.jay"
{
		/* TODO: lbag*/
	  	yyVal = null;
	  }

void case_249()
#line 2221 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_251()
#line 2236 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;
		push_current_container (new Interface (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, mod_locations, GetLocation (yyVals[-2+yyTop]));		
	  }

void case_252()
#line 2243 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_253()
#line 2257 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_254()
#line 2263 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_258()
#line 2284 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_259()
#line 2289 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_270()
#line 2327 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_type, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_type.AddOperator (op);

			lbag.AddMember (op, mod_locations, lbag.GetLocations (decl));
		}
		
		current_local_parameters = null;
	  }

void case_272()
#line 2356 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_273()
#line 2364 "cs-parser.jay"
{
		valid_param_mod = ParameterModifierType.DefaultValue | ParameterModifierType.ReadOnly;
		if ((Operator.OpType) yyVals[-1+yyTop] == Operator.OpType.Is)
			valid_param_mod |= ParameterModifierType.Out;
	  }

void case_274()
#line 2370 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else if (op == Operator.OpType.Is) {
			/* TODO: Special checks for is operator*/
		} else {
			if (p_count == 1) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			} else if (p_count != 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_298()
#line 2441 "cs-parser.jay"
{
		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "is user operator");

		yyVal = Operator.OpType.Is;
	  }

void case_300()
#line 2455 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `implicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_302()
#line 2478 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `explicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_303()
#line 2497 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_304()
#line 2503 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_305()
#line 2513 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_306()
#line 2530 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_307()
#line 2539 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
		
		var lt = (LocatedToken) yyVals[-4+yyTop];
		var mods = (Modifiers) yyVals[-5+yyTop];
		var c = new Constructor (current_type, lt.Value, mods, (Attributes) yyVals[-6+yyTop], current_local_parameters, lt.Location);

		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if (!current_local_parameters.IsEmpty) {
				report.Error (132, c.Location, "`{0}': The static constructor must be parameterless",
					c.GetSignatureForError ());
			}

			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
		} else {
			if (current_type.Kind == MemberKind.Struct && current_local_parameters.IsEmpty) {
				report.Error (568, c.Location, "Structs cannot contain explicit parameterless constructors");
			}
		}

		current_type.AddConstructor (c);
		lbag.AddMember (c, mod_locations, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;

		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_308()
#line 2577 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			var c = (Constructor) yyVals[-1+yyTop];
			c.Initializer = (ConstructorInitializer) yyVals[0+yyTop];
			
			if (c.IsStatic) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			}
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_312()
#line 2604 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_314()
#line 2614 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_315()
#line 2620 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new ConstructorThisInitializer (null, GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_316()
#line 2626 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_317()
#line 2634 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_318()
#line 2643 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_type, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_type.AddMember (d);
		lbag.AddMember (d, mod_locations, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_319()
#line 2668 "cs-parser.jay"
{
		current_event_field = new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_event_field);
		
		if (current_event_field.MemberName.ExplicitInterface != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_320()
#line 2682 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, mod_locations, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_321()
#line 2695 "cs-parser.jay"
{
		current_event = new EventProperty (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_type.AddMember (current_event);
		lbag.AddMember (current_event, mod_locations, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_322()
#line 2703 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_323()
#line 2710 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_324()
#line 2723 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_327()
#line 2737 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_332()
#line 2761 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_333()
#line 2767 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_334()
#line 2775 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}

		++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		start_block (lexer.Location);
	  }

void case_335()
#line 2791 "cs-parser.jay"
{
		yyVal = yyVals[0+yyTop];

		--lexer.parsing_block;
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_338()
#line 2804 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_339()
#line 2809 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_340()
#line 2814 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_341()
#line 2822 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, mod_locations);
		lexer.EventParsing = false;		
	  }

void case_342()
#line 2834 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_343()
#line 2850 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, mod_locations);
		lexer.EventParsing = false;		
	  }

void case_344()
#line 2862 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_345()
#line 2878 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_347()
#line 2884 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7) {
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "expression body event accessor");
		}
	  }

void case_348()
#line 2893 "cs-parser.jay"
{
		current_type.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1519, GetLocation (yyVals[-1+yyTop]), "An attribute is missing member declaration");
		lexer.putback ('}');
	  }

void case_349()
#line 2904 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `}' in class, struct, or interface member declaration");
 
		lexer.putback ('}');

	  	lexer.parsing_generic_declaration = false;
		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], MemberName.Null, (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_350()
#line 2922 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_351()
#line 2927 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_container (new Enum (current_container, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], name, (Attributes) yyVals[-6+yyTop]), null);
	  }

void case_352()
#line 2939 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
	  
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_353()
#line 2947 "cs-parser.jay"
{
		if (doc_support)
			current_container.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		lbag.AddMember (current_container, mod_locations, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_356()
#line 2968 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_361()
#line 2986 "cs-parser.jay"
{
	  	lbag.AddLocation (yyVals[-2+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_362()
#line 2994 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_363()
#line 3007 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_364()
#line 3015 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_type).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_365()
#line 3029 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-2+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_368()
#line 3056 "cs-parser.jay"
{
		valid_param_mod = 0;

		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_container, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (MemberName) yyVals[-4+yyTop], p, (Attributes) yyVals[-8+yyTop]);

		p.CheckParameters (del);

		current_container.AddTypeContainer (del);

		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_370()
#line 3075 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		if (yyVals[-2+yyTop] != null)
			current_delegate.SetConstraints ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, mod_locations, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_372()
#line 3094 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_374()
#line 3105 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_375()
#line 3113 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_377()
#line 3125 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_378()
#line 3131 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_379()
#line 3140 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_380()
#line 3145 "cs-parser.jay"
{  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_382()
#line 3157 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");	  
	  
		yyVal = yyVals[-1+yyTop];
	  }

void case_383()
#line 3164 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_384()
#line 3172 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_385()
#line 3178 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_387()
#line 3194 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters)yyVals[0+yyTop], lt.Location);
	  }

void case_388()
#line 3203 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeParameters != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_390()
#line 3214 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters) yyVals[0+yyTop], (ATypeNameExpression) yyVals[-2+yyTop], lt.Location);
	  }

void case_391()
#line 3223 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_392()
#line 3228 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, null, (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_393()
#line 3236 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_394()
#line 3242 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-3+yyTop];
		var lt2 = (LocatedToken) yyVals[-2+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_395()
#line 3250 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberAccess ((ATypeNameExpression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_397()
#line 3260 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_398()
#line 3271 "cs-parser.jay"
{
		var tparams = new TypeParameters ();
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
	  }

void case_399()
#line 3277 "cs-parser.jay"
{
		var tparams = (TypeParameters) yyVals[-2+yyTop];
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		lbag.AddLocation (yyVals[0+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_400()
#line 3287 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
		yyVal = new TypeParameter (new MemberName (lt.Value, lt.Location), (Attributes)yyVals[-2+yyTop], (VarianceDecl) yyVals[-1+yyTop]);
  	  }

void case_401()
#line 3292 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameter (MemberName.Null, null, null);
  	  }

void case_410()
#line 3336 "cs-parser.jay"
{
		report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_413()
#line 3352 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			var sn = yyVals[-1+yyTop] as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		}
	  }

void case_416()
#line 3369 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "tuples");

		var a = (Tuple<TypeArguments, List<string>>) yyVals[-2+yyTop];
		if (a.Item1.Count < 2) {
			report.Error (8124, GetLocation (yyVals[-3+yyTop]), "Tuple must contain at least two elements");
		}

		yyVal = new TupleTypeExpr (a.Item1, a.Item2, GetLocation (yyVals[-3+yyTop]));

		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVal, (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_417()
#line 3387 "cs-parser.jay"
{
		var type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[-1+yyTop]);

		var names = new List<string> (2);
		var lt = (LocatedToken) yyVals[0+yyTop];
		names.Add (lt?.Value);

		yyVal = Tuple.Create (type_args, names);
	  }

void case_418()
#line 3398 "cs-parser.jay"
{
		var a = (Tuple<TypeArguments, List<string>>) yyVals[-3+yyTop];
		a.Item1.Add ((FullNamedExpression) yyVals[-1+yyTop]);
		var lt = (LocatedToken) yyVals[0+yyTop];
		a.Item2.Add (lt?.Value);
		yyVal = a;
	  }

void case_422()
#line 3418 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_423()
#line 3426 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_426()
#line 3442 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_427()
#line 3448 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_428()
#line 3457 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_468()
#line 3523 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_476()
#line 3544 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "tuples");

		yyVal = new TupleLiteral ((List<TupleLiteralElement>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_477()
#line 3554 "cs-parser.jay"
{
		yyVal = new List<TupleLiteralElement> () {
			(TupleLiteralElement) yyVals[-2+yyTop], (TupleLiteralElement) yyVals[0+yyTop]
		};
	  }

void case_478()
#line 3560 "cs-parser.jay"
{
		var list = (List<TupleLiteralElement>)yyVals[-2+yyTop];
		list.Add ((TupleLiteralElement) yyVals[0+yyTop]);
	  }

void case_480()
#line 3572 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new TupleLiteralElement (lt.Value, (Expression) yyVals[0+yyTop], lt.Location);
	  }

void case_481()
#line 3580 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "interpolated strings");

		yyVal = new InterpolatedString ((StringLiteral) yyVals[-2+yyTop], (List<Expression>) yyVals[-1+yyTop], (StringLiteral) yyVals[0+yyTop]);
	  }

void case_482()
#line 3587 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "interpolated strings");

		yyVal = new InterpolatedString ((StringLiteral) yyVals[0+yyTop], null, null);
	  }

void case_483()
#line 3597 "cs-parser.jay"
{
		var list = new List<Expression> ();
		list.Add ((InterpolatedStringInsert) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_484()
#line 3603 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((StringLiteral) yyVals[-1+yyTop]);
		list.Add ((InterpolatedStringInsert) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_486()
#line 3617 "cs-parser.jay"
{
		yyVal = new InterpolatedStringInsert ((Expression) yyVals[-2+yyTop]) {
			Alignment = (Expression)yyVals[0+yyTop]
		};
	  }

void case_488()
#line 3627 "cs-parser.jay"
{
		lexer.parsing_interpolation_format = false;

		yyVal = new InterpolatedStringInsert ((Expression) yyVals[-3+yyTop]) {
			Format = (string)yyVals[0+yyTop]
		};
	  }

void case_490()
#line 3639 "cs-parser.jay"
{
		lexer.parsing_interpolation_format = false;

		yyVal = new InterpolatedStringInsert ((Expression) yyVals[-5+yyTop]) {
			Alignment = (Expression)yyVals[-3+yyTop],
			Format = (string) yyVals[0+yyTop]
		};
	  }

void case_495()
#line 3672 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_497()
#line 3684 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_498()
#line 3690 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_499()
#line 3696 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "null propagating operator");

		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new ConditionalMemberAccess ((Expression) yyVals[-4+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_500()
#line 3705 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_501()
#line 3711 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_502()
#line 3717 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new SimpleName ("await", ((LocatedToken) yyVals[-3+yyTop]).Location), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_503()
#line 3723 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_504()
#line 3731 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_506()
#line 3741 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_508()
#line 3749 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_509()
#line 3757 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_510()
#line 3762 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_511()
#line 3769 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_514()
#line 3784 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = new CollectionOrObjectInitializers (GetLocation (yyVals[-2+yyTop]));
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	}
 		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_515()
#line 3793 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_518()
#line 3809 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_519()
#line 3815 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_520()
#line 3820 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_521()
#line 3828 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_522()
#line 3834 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-2+yyTop]);
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_524()
#line 3843 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_525()
#line 3851 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = new CollectionElementInitializer (GetLocation (yyVals[-2+yyTop]));
		else
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));

		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_526()
#line 3860 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "dictionary initializer");

		yyVal = new DictionaryElementInitializer ((Arguments)yyVals[-3+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_527()
#line 3868 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = new CollectionElementInitializer (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_532()
#line 3887 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_533()
#line 3893 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (lang_version < LanguageVersion.V_7_2 && list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_534()
#line 3902 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		yyVal = list;
	  }

void case_535()
#line 3916 "cs-parser.jay"
{
	  	if (lexer.putback_char == -1)
	  		lexer.putback (')'); /* TODO: Wrong but what can I do*/
		Error_SyntaxError (yyToken);
		yyVal = yyVals[-2+yyTop];
	  }

void case_536()
#line 3923 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_541()
#line 3944 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_542()
#line 3949 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_544()
#line 3958 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_545()
#line 3963 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_546()
#line 3968 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "readonly references");

		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Readonly);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_547()
#line 3979 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "out variable declaration");

		var lt = (LocatedToken) yyVals[0+yyTop];
		var lv = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (lv);
		yyVal = new DeclarationExpression ((FullNamedExpression) yyVals[-1+yyTop], lv);
	  }

void case_549()
#line 3996 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_550()
#line 4001 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "null propagating operator");

		yyVal = new ElementAccess ((Expression) yyVals[-4+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop])) {
			ConditionalAccess = true
		};

		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_551()
#line 4012 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_552()
#line 4017 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_553()
#line 4025 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_554()
#line 4031 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_555()
#line 4040 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_556()
#line 4046 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (lang_version < LanguageVersion.V_7_2 && args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;	  
	  }

void case_560()
#line 4073 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_561()
#line 4078 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_564()
#line 4100 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_565()
#line 4113 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_566()
#line 4125 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
				}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop])) {
			NoEmptyInterpolation = true
		};

		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_567()
#line 4136 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop])) {
			NoEmptyInterpolation = true
		};
	  }

void case_568()
#line 4145 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_569()
#line 4152 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_570()
#line 4157 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		/* It can be any of new expression, create the most common one*/
		yyVal = new New ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_572()
#line 4169 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_573()
#line 4177 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_579()
#line 4204 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_580()
#line 4210 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_583()
#line 4227 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 4233 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_585()
#line 4239 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_586()
#line 4244 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_590()
#line 4259 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_591()
#line 4267 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_592()
#line 4272 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_597()
#line 4302 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_598()
#line 4309 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_599()
#line 4323 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_600()
#line 4329 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_601()
#line 4338 "cs-parser.jay"
{
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_603()
#line 4347 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_604()
#line 4355 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_605()
#line 4365 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_606()
#line 4376 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_607()
#line 4381 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_608()
#line 4391 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_609()
#line 4396 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new CheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_610()
#line 4405 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_611()
#line 4410 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnCheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_612()
#line 4419 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_620()
#line 4458 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_621()
#line 4466 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_622()
#line 4477 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_1)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "default literal");

		yyVal = new DefaultLiteralExpression (GetLocation (yyVals[0+yyTop]));
	  }

void case_626()
#line 4496 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_627()
#line 4501 "cs-parser.jay"
{
		if (!async_block) {
			 if (current_anonymous_method is LambdaExpression) {
				report.Error (4034, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing lambda expression is marked with the `async' modifier");
			} else if (current_anonymous_method != null) {
				report.Error (4035, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing anonymous method is marked with the `async' modifier");
			} else if (interactive_async != null) {
				current_block.Explicit.RegisterAsyncAwait ();
				interactive_async = true;
			} else {
				report.Error (4033, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing method is marked with the `async' modifier");
			}
		} else {
			current_block.Explicit.RegisterAsyncAwait ();
		}
		
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_628()
#line 4523 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (lexer.Location, "throw expression");

		yyVal = new ThrowExpression ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_629()
#line 4530 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.LogicalNot, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_630()
#line 4536 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.OnesComplement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_631()
#line 4542 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_632()
#line 4549 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Await (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_640()
#line 4587 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

	  	yyVal = new Unary (Unary.Operator.UnaryPlus, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_641()
#line 4593 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.UnaryNegation, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_642()
#line 4599 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_643()
#line 4605 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_644()
#line 4611 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Indirection (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_645()
#line 4617 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.AddressOf, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_647()
#line 4626 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_648()
#line 4631 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_649()
#line 4636 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_650()
#line 4641 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_651()
#line 4648 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_652()
#line 4655 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_654()
#line 4666 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_655()
#line 4671 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_656()
#line 4676 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_657()
#line 4683 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_659()
#line 4694 "cs-parser.jay"
{
		var is_expr = new Is ((Expression) yyVals[-3+yyTop], ((FullNamedExpression) yyVals[-1+yyTop]), GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] != null) {
			if (lang_version < LanguageVersion.V_7)
				FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "pattern matching");

			var lt = (LocatedToken) yyVals[0+yyTop];
			var lv = new LocalVariable (current_block, lt.Value, lt.Location);
			is_expr.Variable = lv;
			current_block.AddLocalName (lv.Name, lv, true);
		}

		yyVal = is_expr;
	  }

void case_660()
#line 4709 "cs-parser.jay"
{
		var is_expr = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "pattern matching");

		yyVal = is_expr;
	  }

void case_661()
#line 4717 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new As ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_662()
#line 4723 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Is ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_663()
#line 4729 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new Is (new SimpleName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_664()
#line 4734 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new As (new SimpleName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_671()
#line 4757 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_675()
#line 4787 "cs-parser.jay"
{
		var list = new List<PropertyPatternMember> ();
		list.Add ((PropertyPatternMember) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_676()
#line 4793 "cs-parser.jay"
{
		var list = (List<PropertyPatternMember>) yyVals[-2+yyTop];
		list.Add ((PropertyPatternMember) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_677()
#line 4802 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new PropertyPatternMember (lt.Value, (Expression) yyVals[0+yyTop], lt.Location);
	  }

void case_679()
#line 4811 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
			var lt = (LocatedToken) yyVals[0+yyTop];
			var variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (variable);
		}
	  }

void case_681()
#line 4864 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_682()
#line 4869 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_683()
#line 4874 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_684()
#line 4881 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_686()
#line 4892 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_687()
#line 4897 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_688()
#line 4902 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_689()
#line 4907 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_690()
#line 4912 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_691()
#line 4919 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_692()
#line 4926 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_693()
#line 4933 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_695()
#line 4944 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_696()
#line 4949 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_697()
#line 4954 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_698()
#line 4961 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_700()
#line 4972 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_701()
#line 4977 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_703()
#line 4988 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_704()
#line 4993 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_706()
#line 5004 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_707()
#line 5009 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_709()
#line 5020 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_710()
#line 5025 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_712()
#line 5036 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_713()
#line 5041 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_715()
#line 5052 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_719()
#line 5070 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_720()
#line 5075 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "throw expression");

		var expr = new ThrowExpression ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-5+yyTop]), (Expression) yyVals[-3+yyTop], expr, GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_721()
#line 5084 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_722()
#line 5089 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-3+yyTop]), (Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_723()
#line 5095 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_724()
#line 5102 "cs-parser.jay"
{
		Error_SyntaxError (Token.CLOSE_BRACE);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		lexer.putback ('}');
	  }

void case_725()
#line 5113 "cs-parser.jay"
{
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_726()
#line 5118 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_727()
#line 5123 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_728()
#line 5128 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_729()
#line 5133 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_730()
#line 5138 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_731()
#line 5143 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_732()
#line 5148 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_733()
#line 5153 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_734()
#line 5158 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_735()
#line 5163 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_736()
#line 5168 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "tuples");

		var exprs = (List<Expression>) yyVals[-3+yyTop];
		yyVal = new TupleDeconstruct (exprs, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_737()
#line 5176 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "tuples");

		var exprs = (List<BlockVariable>) yyVals[-3+yyTop];
		yyVal = new TupleDeconstruct (exprs, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_738()
#line 5187 "cs-parser.jay"
{
		yyVal = new List<Expression> () {
			(Expression) yyVals[-2+yyTop],
			(Expression) yyVals[0+yyTop]
	  	};
	  }

void case_739()
#line 5194 "cs-parser.jay"
{
		var src = (List<Expression>) yyVals[-2+yyTop];
		src.Add ((Expression) yyVals[0+yyTop]);
		yyVal = src;
	  }

void case_740()
#line 5203 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		yyVal = new List<BlockVariable> (2) {
			new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li)
		};
	  }

void case_741()
#line 5212 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);

		var src = (List<BlockVariable>) yyVals[-3+yyTop];
		src.Add (new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li));
		yyVal = src;
	  }

void case_742()
#line 5222 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);

		if (lt.Value != "_") {
			report.Error (8184, lt.Location, "A deconstruction cannot mix declarations and expressions on the left-hand-side");
		} else {
			li.Type = InternalType.Discard;
		}

		var src = (List<BlockVariable>) yyVals[-2+yyTop];
		src.Add (new BlockVariable (new TypeExpression (li.Type, lt.Location), li));
		yyVal = src;
	  }

void case_743()
#line 5240 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = pars;
	  }

void case_744()
#line 5247 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		yyVal = pars;
	  }

void case_745()
#line 5261 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_746()
#line 5267 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_747()
#line 5273 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_748()
#line 5278 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[0+yyTop]);
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_750()
#line 5286 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
	  }

void case_752()
#line 5297 "cs-parser.jay"
{
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_754()
#line 5305 "cs-parser.jay"
{
	  	/* Handles only cases like foo = x.FirstOrDefault (l => );*/
	  	/* where we must restore current_variable*/
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;

		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_758()
#line 5324 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_759()
#line 5332 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_760()
#line 5338 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_761()
#line 5343 "cs-parser.jay"
{
		var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-1+yyTop]);
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_762()
#line 5349 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_763()
#line 5354 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_764()
#line 5360 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_766()
#line 5369 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_767()
#line 5374 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_769()
#line 5383 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_770()
#line 5388 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_777()
#line 5411 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_778()
#line 5416 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_779()
#line 5421 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_784()
#line 5448 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];

		/* Cannot use opt_formal_parameter_list because it can be shared instance for empty parameters*/
	  	lbag.AppendToMember (current_container, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));

		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "primary constructor");
	  }

void case_789()
#line 5477 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_type.PrimaryConstructorBaseArgumentsStart = GetLocation (yyVals[0+yyTop]);
	  }

void case_790()
#line 5482 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		current_type.PrimaryConstructorBaseArguments = (Arguments) yyVals[-1+yyTop];
		--lexer.parsing_block;

		yyVal = yyVals[-5+yyTop];
	  }

void case_792()
#line 5502 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;

		Class c = new Class (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_container (c, yyVals[-3+yyTop]);
		valid_param_mod = ParameterModifierType.PrimaryConstructor;
	  }

void case_793()
#line 5515 "cs-parser.jay"
{
		valid_param_mod = 0;
		lexer.ConstraintsParsing = false;

		if (yyVals[-1+yyTop] != null)
			current_type.PrimaryConstructorParameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
		lbag.AddMember (current_container, mod_locations, GetLocation (yyVals[-5+yyTop]));

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_794()
#line 5534 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_795()
#line 5540 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_798()
#line 5559 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_801()
#line 5573 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0) {
			var accessibility = (m2 | m1 & Modifiers.AccessibilityMask);

			if (accessibility == (Modifiers.PRIVATE | Modifiers.PROTECTED)) {
				if (lang_version < LanguageVersion.V_7_2) {
					FeatureIsNotAvailable (lexer.Location, "private protected");
				}
			} else if (accessibility != (Modifiers.PROTECTED | Modifiers.INTERNAL)) {
				report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
					"More than one protection modifier specified");
			}
		}
		
		yyVal = m1 | m2;
	  }

void case_802()
#line 5599 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container.Kind == MemberKind.Namespace)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_803()
#line 5607 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_804()
#line 5612 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_805()
#line 5617 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_806()
#line 5622 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_807()
#line 5627 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_808()
#line 5632 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_809()
#line 5637 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_810()
#line 5642 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_811()
#line 5647 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_812()
#line 5652 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_813()
#line 5657 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_814()
#line 5662 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_815()
#line 5667 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_816()
#line 5674 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_820()
#line 5691 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[-1+yyTop]);
	  }

void case_823()
#line 5708 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_824()
#line 5714 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_825()
#line 5733 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_826()
#line 5739 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_827()
#line 5749 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_828()
#line 5755 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_829()
#line 5781 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_830()
#line 5788 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_834()
#line 5808 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");
		
		yyVal = yyVals[0+yyTop];
	  }

void case_837()
#line 5842 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_839()
#line 5854 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_840()
#line 5859 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_841()
#line 5868 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_842()
#line 5873 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_850()
#line 5900 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_883()
#line 5964 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_884()
#line 5969 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_885()
#line 5974 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_886()
#line 5982 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_887()
#line 5990 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_890()
#line 6003 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_891()
#line 6019 "cs-parser.jay"
{ 
		var expr = (ATypeNameExpression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			if (expr.Name == "var" && expr is SimpleName)
				yyVal = new VarExpr (expr.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		}
	  }

void case_892()
#line 6031 "cs-parser.jay"
{
		var expr = (ATypeNameExpression) yyVals[-1+yyTop];
		yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_894()
#line 6037 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_896()
#line 6048 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "tuples");

		var a = (Tuple<TypeArguments, List<string>>) yyVals[-1+yyTop];

		yyVal = new TupleTypeExpr (a.Item1, a.Item2, GetLocation (yyVals[-2+yyTop]));
	  }

void case_897()
#line 6060 "cs-parser.jay"
{
		var type_args = new TypeArguments ();

		type_args.Add ((FullNamedExpression) yyVals[-4+yyTop]);
		type_args.Add ((FullNamedExpression) yyVals[-1+yyTop]);

		var names = new List<string> (2);
		var lt = (LocatedToken) yyVals[-3+yyTop];
		names.Add (lt?.Value);
		lt = (LocatedToken) yyVals[0+yyTop];
		names.Add (lt?.Value);

		yyVal = Tuple.Create (type_args, names);
	  }

void case_898()
#line 6075 "cs-parser.jay"
{
		var a = (Tuple<TypeArguments, List<string>>) yyVals[-3+yyTop];
		a.Item1.Add ((FullNamedExpression) yyVals[-1+yyTop]);
		var lt = (LocatedToken) yyVals[0+yyTop];
		a.Item2.Add (lt?.Value);
		yyVal = a;
	  }

void case_900()
#line 6087 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_904()
#line 6110 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_905()
#line 6117 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		if (yyVals[-2+yyTop] != null)
			lbag.AddLocation (yyVal, PopLocation (), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_906()
#line 6126 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstant ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_907()
#line 6133 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_908()
#line 6139 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "byref locals and returns");
		}

		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ByRef, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_909()
#line 6150 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		if (yyVals[-2+yyTop] != null) {
			lbag.AddLocation (yyVal, PopLocation (), GetLocation (yyVals[0+yyTop]));
		} else {
			report.Error (8174, GetLocation (yyVals[-4+yyTop]), "A declaration of a by-reference variable must have an initializer");
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_910()
#line 6161 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_2) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "readonly references");
		}

		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ByRef | LocalVariable.Flags.ReadonlyMask, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_911()
#line 6172 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		if (yyVals[-2+yyTop] != null) {
			lbag.AddLocation (yyVal, PopLocation (), GetLocation (yyVals[0+yyTop]));
		} else {
			report.Error (8174, GetLocation (yyVals[-5+yyTop]), "A declaration of a by-reference variable must have an initializer");
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_913()
#line 6187 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		PushLocation (GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_914()
#line 6193 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_918()
#line 6211 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_921()
#line 6226 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_922()
#line 6235 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_929()
#line 6268 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_931()
#line 6281 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_932()
#line 6286 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_934()
#line 6295 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7_2) {
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "ref structs");
		}

		yyVal = new SpanStackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_935()
#line 6304 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_936()
#line 6312 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "byref locals and returns");
		}

		yyVal = new ReferenceExpression ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_937()
#line 6323 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_939()
#line 6329 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		report.Error (1002, GetLocation (yyVals[0+yyTop]), "; expected");
		lexer.putback ('}');
	  }

void case_942()
#line 6347 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			var expr = yyVals[0+yyTop] as Expression;
			yyVal = new StatementErrorExpression (expr);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_943()
#line 6360 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		yyVal = new StatementExpression (new OptionalAssign (expr, lexer.Location));
	  }

void case_944()
#line 6365 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_947()
#line 6379 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_948()
#line 6388 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_949()
#line 6398 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new If ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_951()
#line 6412 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]));
	  }

void case_952()
#line 6418 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Switch ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));	
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_959()
#line 6449 "cs-parser.jay"
{
	  	var label = (SwitchLabel) yyVals[0+yyTop];
	  	label.SectionStart = true;
		current_block.AddStatement (label);
	  }

void case_961()
#line 6462 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_962()
#line 6467 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_963()
#line 6485 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_7)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "pattern matching");

/*		$$ = new SwitchLabel ((FullNamedExpression) $2), GetLocation ($1)) {*/
/*			PatternMatching = true*/
/*		};*/

		throw new NotImplementedException ("type pattern matching");
	  }

void case_969()
#line 6510 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_970()
#line 6518 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new While ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_971()
#line 6528 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_972()
#line 6533 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Do ((Statement) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), Location.Null);
	  }

void case_973()
#line 6538 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Do ((Statement) yyVals[-4+yyTop], (BooleanExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_974()
#line 6548 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
		For f = new For (GetLocation (yyVals[-1+yyTop]));
		current_block.AddStatement (f);
		yyVal = f;
	  }

void case_976()
#line 6564 "cs-parser.jay"
{
		((For) yyVals[-2+yyTop]).Initializer = (Statement) yyVals[-1+yyTop];

		/* Pass the "For" object to the iterator_part4*/
		oob_stack.Push (yyVals[-2+yyTop]);
	  }

void case_977()
#line 6572 "cs-parser.jay"
{
		var locations = (Tuple<Location,Location>) yyVals[-1+yyTop];
		oob_stack.Pop ();
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		For f = ((For) yyVals[-5+yyTop]);
		f.Statement = (Statement) yyVals[0+yyTop];
		lbag.AddStatement (f, current_block.StartLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (locations.Item1), GetLocation (locations.Item2));

		yyVal = end_block (GetLocation (yyVals[-3+yyTop]));
	  }

void case_978()
#line 6585 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_979()
#line 6593 "cs-parser.jay"
{
		For f = (For) oob_stack.Peek ();
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
	  }

void case_981()
#line 6603 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `}'");
		For f = (For) oob_stack.Peek ();
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		yyVal = new Tuple<Location,Location> (GetLocation (yyVals[0+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_982()
#line 6612 "cs-parser.jay"
{
	  	For f = (For) oob_stack.Peek ();
		f.Iterator = (Statement) yyVals[-1+yyTop];
		yyVal = GetLocation (yyVals[0+yyTop]);
	  }

void case_983()
#line 6617 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol expected ')'");
		For f = (For) oob_stack.Peek ();
		f.Iterator = (Statement) yyVals[-1+yyTop];
		yyVal = GetLocation (yyVals[0+yyTop]);
	  }

void case_988()
#line 6637 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_989()
#line 6644 "cs-parser.jay"
{
		yyVal = current_variable;
		if (yyVals[-1+yyTop] != null)
			lbag.AddLocation (current_variable, PopLocation ());

		current_variable = null;
	  }

void case_997()
#line 6671 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  	}
	  		
		yyVal = sl;
	  }

void case_998()
#line 6687 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-3+yyTop]), "Type and identifier are both required in a foreach statement");

		start_block (GetLocation (yyVals[-2+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_999()
#line 6700 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-1+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_1000()
#line 6717 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_1001()
#line 6727 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], current_block, GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		end_block (GetLocation (yyVals[-2+yyTop]));
		
		yyVal = f;
	  }

void case_1008()
#line 6750 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1009()
#line 6758 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1010()
#line 6763 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
	  }

void case_1011()
#line 6771 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_1012()
#line 6777 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_1013()
#line 6782 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_1014()
#line 6790 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1015()
#line 6795 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1016()
#line 6800 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_1017()
#line 6805 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_1018()
#line 6813 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1019()
#line 6818 "cs-parser.jay"
{
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1020()
#line 6823 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_1021()
#line 6828 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_1022()
#line 6836 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_1023()
#line 6852 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1024()
#line 6870 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_1028()
#line 6896 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_1029()
#line 6901 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], Location.Null, true), (ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_1030()
#line 6906 "cs-parser.jay"
{
		Error_SyntaxError (1524, yyToken);
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), false);
	  }

void case_1031()
#line 6914 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_1032()
#line 6921 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		var prev_catch = l [l.Count - 1];
		if (prev_catch.IsGeneral && prev_catch.Filter == null) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		}
		
		l.Add (c);
		yyVal = l;
	  }

void case_1035()
#line 6942 "cs-parser.jay"
{
	  	var c = new Catch ((ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	c.Filter = (CatchFilterExpression) yyVals[-1+yyTop];
	  	yyVal = c;
	  }

void case_1036()
#line 6948 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch ((ExplicitBlock) current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}
		
		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
		lexer.parsing_catch_when = true;
	  }

void case_1037()
#line 6964 "cs-parser.jay"
{
	  	((Catch) yyVals[-1+yyTop]).Filter = (CatchFilterExpression) yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_1038()
#line 6969 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1040()
#line 6987 "cs-parser.jay"
{
		end_block (Location.Null);
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_1043()
#line 7003 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_5)
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "exception filter");

		yyVal = new CatchFilterExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_1046()
#line 7028 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_1048()
#line 7038 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_1049()
#line 7046 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Lock ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1050()
#line 7056 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_1051()
#line 7066 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_1052()
#line 7071 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_1053()
#line 7084 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_1054()
#line 7094 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_1055()
#line 7099 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_1056()
#line 7108 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_1057()
#line 7116 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new Using ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1059()
#line 7127 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  }

void case_1061()
#line 7139 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		yyVal = current_variable;
	  }

void case_1062()
#line 7150 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1063()
#line 7162 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1064()
#line 7173 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1065()
#line 7180 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1066()
#line 7189 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1067()
#line 7199 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1068()
#line 7214 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1069()
#line 7224 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1071()
#line 7243 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1073()
#line 7259 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1074()
#line 7278 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_1075()
#line 7293 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[0+yyTop];

		if (yyVals[-1+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-1+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_1077()
#line 7306 "cs-parser.jay"
{
		report.Error (742, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `{0}'. A query body must end with select or group clause", GetSymbolName (yyToken));
		yyVal = yyVals[-1+yyTop];
	  }

void case_1078()
#line 7311 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_1080()
#line 7323 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1081()
#line 7330 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_1082()
#line 7338 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1083()
#line 7345 "cs-parser.jay"
{
		var obj = (object[]) yyVals[0+yyTop];

		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-2+yyTop], linq_clause_blocks.Pop (), (Expression)obj[0], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, (Location) obj[1]);
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1085()
#line 7362 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new object[2] { null, Location.Null };
	  }

void case_1087()
#line 7371 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_1094()
#line 7391 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_1096()
#line 7410 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1097()
#line 7420 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1098()
#line 7428 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1099()
#line 7436 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1100()
#line 7444 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_1101()
#line 7482 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1102()
#line 7490 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1103()
#line 7498 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1104()
#line 7506 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_1108()
#line 7562 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_1110()
#line 7573 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1111()
#line 7580 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_1113()
#line 7589 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_1114()
#line 7596 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_1116()
#line 7608 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1117()
#line 7613 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1119()
#line 7625 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1120()
#line 7630 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1122()
#line 7640 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_1123()
#line 7656 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_1126()
#line 7683 "cs-parser.jay"
{ 
		current_container = current_type = new Class (current_container, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		var method = new InteractiveMethod (
			current_type,
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			pars);
			
		current_type.AddMember (method);			
		oob_stack.Push (method);

		interactive_async = false;

		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_1127()
#line 7711 "cs-parser.jay"
{
		--lexer.parsing_block;
		var method = (InteractiveMethod) oob_stack.Pop ();
		method.Block = (ToplevelBlock) end_block(lexer.Location);

		if (interactive_async == true) {
			method.ChangeToAsync ();
		}

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_1137()
#line 7757 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1138()
#line 7763 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1139()
#line 7769 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_1142()
#line 7784 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }

void case_1143()
#line 7789 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_1144()
#line 7797 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_1145()
#line 7805 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop];
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_1153()
#line 7843 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1154()
#line 7849 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1155()
#line 7858 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   15,   15,   15,
   16,   16,   20,   21,   18,   18,   23,   23,   23,   19,
   19,   19,   24,   24,   25,   25,    7,    7,    6,    6,
   22,   22,    8,    8,   26,   26,   26,   27,   27,   27,
   27,   27,    9,    9,   10,   10,   35,   33,   38,   34,
   34,   34,   34,   36,   36,   36,   37,   37,   42,   39,
   40,   41,   41,   43,   43,   43,   43,   43,   44,   44,
   44,   48,   45,   47,   47,   51,   52,   52,   50,   50,
   55,   55,   56,   56,   57,   57,   57,   57,   57,   57,
   57,   57,   57,   57,   57,   57,   57,   57,   71,   66,
   73,   73,   73,   78,   81,   82,   83,   29,   29,   86,
   58,   58,   87,   87,   88,   88,   89,   91,   85,   85,
   90,   90,   96,   59,  100,   59,   59,   95,  103,   95,
   97,   97,  104,  104,  105,  106,  105,  101,  101,  107,
  107,  108,  109,   99,   99,  102,  102,  102,  112,   60,
   94,  114,   94,  115,   94,  118,  119,  110,  120,  121,
  122,  110,  110,  110,  111,  111,  111,  126,  127,  127,
  129,  127,  131,  125,  117,  117,  132,  132,  132,  132,
  132,  132,  132,  132,  132,  132,  133,  133,  136,  136,
  136,  136,  139,  136,  137,  137,  140,  140,  141,  141,
  141,  141,  134,  134,  134,  142,  142,  142,  135,  144,
  146,  147,  149,   61,  150,   61,  148,  152,  148,  151,
  151,  154,  156,   63,  155,  155,  145,  145,  145,  145,
  145,  160,  157,  161,  158,  159,  159,  159,  159,  162,
  163,  164,  166,   30,   30,  165,  165,  167,  167,  168,
  168,  168,  168,  168,  168,  168,  168,  168,  170,   64,
  171,  171,  174,  169,  169,  173,  173,  173,  173,  173,
  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,
  173,  173,  173,  173,  173,  173,  173,  173,  176,  175,
  177,  175,  175,  175,   65,  179,  181,  178,  180,  180,
  184,  182,  185,  182,  182,  182,  186,   67,  188,   62,
  191,  192,   62,   62,  187,  194,  187,  189,  189,  195,
  195,  196,  196,  197,  193,  190,  190,  190,  190,  190,
  201,  198,  202,  199,  200,  200,  200,   68,   69,  204,
  206,  207,   31,  203,  203,  203,  205,  205,  205,  208,
  208,  209,  210,  209,  209,  209,  211,  212,  213,   32,
  214,  214,   17,   17,   17,  215,  215,  215,  219,  219,
  217,  217,  217,  220,  220,  222,   76,  143,  116,  116,
  153,  153,  223,  223,  223,  221,  221,  224,  224,  225,
  225,  227,  227,  113,   84,   84,   98,   98,  138,  138,
  172,  172,  229,  229,  229,  229,  233,  233,  235,  235,
  234,  228,  232,  232,  232,  237,  237,  238,  236,  236,
  236,  236,  236,  236,  236,  239,  239,  239,  239,  239,
  239,  239,  239,  239,  240,  240,  240,  240,  240,  240,
  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,
  240,  240,  240,  240,  240,  240,  241,  241,  241,  242,
  242,  242,  242,  264,  264,  265,  266,  266,  267,  267,
  261,  261,  268,  268,  269,  269,  270,  269,  271,  269,
  272,  272,  273,  273,  244,  244,  263,  263,  263,  263,
  263,  263,  263,  263,  263,  263,  263,  263,  246,  246,
  246,  275,  275,  276,  276,  277,  277,  279,  279,  279,
  280,  280,  280,  280,  280,  280,  280,  281,  281,  183,
  183,  274,  274,  274,  274,  274,  286,  286,  285,  285,
  287,  287,  287,  287,  287,  287,   54,  288,  247,  247,
  247,  247,  284,  284,  290,  290,  291,  291,  248,  249,
  249,  250,  251,  252,  252,  243,  243,  243,  243,  243,
  296,  292,  253,  253,  297,  297,  298,  298,  299,  299,
  299,  299,  300,  300,  300,  300,  293,  293,  230,  230,
  295,  295,  301,  301,  294,  294,   93,   93,  302,  302,
  254,  303,  303,  218,  216,  255,  255,  256,  256,  257,
  257,  258,  305,  259,  306,  259,  304,  304,  308,  307,
  245,  262,  309,  309,  309,  309,  309,  309,  309,  309,
  309,  309,  310,  310,  310,  310,  310,  310,  310,  310,
  310,  310,  310,  310,  310,  311,  311,  311,  311,  311,
  311,  311,  312,  312,  312,  312,  312,  312,  312,  312,
  312,  312,  312,  312,  313,  315,  315,  315,  315,  315,
  315,  315,  315,  316,  317,  317,  318,  319,  319,  320,
  320,  320,  320,  320,  321,  321,  321,  321,  321,  321,
  321,  321,  321,  322,  322,  322,  322,  322,  323,  323,
  323,  324,  324,  324,  325,  325,  325,  326,  326,  326,
  327,  327,  327,  328,  328,  329,  329,  331,  331,  331,
  331,  331,  331,  331,  333,  333,  333,  333,  333,  333,
  333,  333,  333,  333,  333,  333,  333,  334,  334,  335,
  335,  335,  336,  336,  337,  337,  337,  337,  338,  338,
  340,  339,  339,  339,  130,  130,   53,   53,  342,  341,
  343,  341,  344,  341,  345,  346,  341,  347,  348,  341,
   46,   46,  282,  282,  282,  282,  260,  260,  260,   92,
  350,   77,   77,  351,  352,  352,  352,  352,  354,  352,
  355,  356,  357,  358,   28,   75,   75,   74,   74,  123,
  123,  359,  359,  359,  359,  359,  359,  359,  359,  359,
  359,  359,  359,  359,  359,  359,   79,   79,  353,  353,
   80,   80,  360,  360,  361,  361,  362,  362,  363,  363,
  363,  363,  226,  226,  364,  364,  365,  124,   72,   72,
  366,  128,   70,   70,  367,  367,  368,  368,  368,  368,
  372,  372,  373,  373,  373,  370,  370,  370,  370,  370,
  370,  370,  370,  370,  370,  370,  370,  370,  374,  374,
  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,
  374,  388,  388,  388,  388,  375,  389,  371,  289,  289,
  390,  390,  390,  390,  390,  391,  392,  392,  231,  231,
  393,   49,   49,  395,  369,  398,  369,  400,  369,  401,
  369,  394,  394,  394,  396,  396,  404,  404,  403,  403,
  405,  405,  397,  397,  399,  399,  406,  406,  407,  402,
  402,  402,  402,  330,  330,  332,  376,  376,  376,  387,
  387,  408,  409,  409,  377,  377,  410,  410,  410,  413,
  411,  411,  412,  412,  414,  414,  414,  415,  416,  416,
  417,  417,  417,  417,  378,  378,  378,  378,  418,  418,
  419,  419,  419,  423,  420,  426,  422,  422,  429,  425,
  425,  428,  428,  430,  430,  424,  424,  433,  432,  432,
  427,  427,  431,  431,  435,  434,  434,  421,  421,  436,
  421,  379,  379,  379,  379,  379,  379,  437,  438,  438,
  439,  439,  439,  440,  440,  440,  440,  441,  441,  441,
  441,  442,  442,  442,  443,  443,  380,  380,  380,  380,
  444,  444,  314,  314,  445,  448,  445,  445,  447,  447,
  446,  449,  446,  381,  382,  450,  385,  383,  383,  452,
  453,  386,  455,  456,  384,  384,  384,  454,  454,  451,
  451,  349,  349,  349,  349,  457,  457,  459,  459,  461,
  460,  462,  460,  458,  458,  458,  458,  458,  466,  464,
  467,  469,  464,  468,  468,  463,  463,  470,  470,  470,
  470,  470,  475,  471,  476,  472,  477,  478,  479,  473,
  481,  482,  483,  473,  480,  480,  485,  474,  484,  488,
  484,  487,  490,  487,  486,  486,  486,  489,  489,  489,
  465,  491,  465,    3,    3,  492,    3,    3,  493,  493,
  283,  283,  278,  278,    5,  494,  494,  494,  494,  494,
  498,  494,  494,  494,  494,  495,  495,  496,  499,  496,
  497,  497,  500,  500,  501,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    4,    6,    2,
    0,    1,    0,    0,   11,    3,    0,    1,    1,    1,
    3,    1,    0,    1,    0,    1,    0,    1,    0,    1,
    0,    1,    1,    2,    1,    1,    2,    1,    1,    1,
    1,    1,    0,    1,    1,    2,    0,    3,    0,    6,
    3,    2,    1,    1,    1,    1,    1,    3,    0,    3,
    1,    0,    3,    0,    1,    1,    3,    3,    1,    1,
    1,    0,    4,    4,    4,    1,    1,    1,    0,    1,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    4,
    1,    1,    2,    0,    0,    0,    0,   16,    5,    0,
    9,    5,    0,    1,    1,    2,    3,    0,    3,    1,
    1,    1,    0,    8,    0,    9,    6,    0,    0,    3,
    0,    1,    1,    2,    2,    0,    5,    0,    1,    1,
    2,    3,    0,    4,    2,    1,    1,    1,    0,    3,
    1,    0,    3,    0,    4,    0,    0,   10,    0,    0,
    0,   12,    8,    5,    1,    1,    1,    1,    1,    1,
    0,    4,    0,    4,    0,    1,    1,    3,    3,    3,
    5,    3,    5,    1,    1,    1,    1,    3,    4,    6,
    2,    4,    0,    7,    0,    1,    1,    2,    1,    1,
    1,    1,    4,    6,    4,    1,    2,    2,    1,    0,
    0,    0,    0,   12,    0,    6,    0,    0,    4,    1,
    1,    0,    0,   10,    3,    1,    1,    2,    1,    2,
    1,    0,    5,    0,    5,    1,    1,    1,    1,    0,
    0,    0,    0,   15,    5,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    5,
    1,    1,    0,    7,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    7,
    0,    7,    2,    2,    2,    0,    0,    9,    0,    1,
    0,    6,    0,    6,    2,    1,    0,    8,    0,    9,
    0,    0,   10,    5,    0,    0,    3,    0,    1,    1,
    2,    2,    4,    0,    2,    2,    2,    1,    1,    1,
    0,    5,    0,    5,    1,    1,    1,    2,    4,    0,
    0,    0,   12,    0,    2,    2,    0,    1,    2,    1,
    3,    2,    0,    5,    3,    1,    0,    0,    0,   13,
    0,    1,    1,    3,    3,    1,    4,    4,    2,    2,
    0,    3,    2,    1,    3,    0,    3,    1,    1,    3,
    1,    2,    3,    4,    4,    0,    3,    1,    3,    3,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    2,    2,    1,    4,    2,    4,    0,    1,
    1,    1,    2,    2,    2,    1,    3,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    3,    3,    3,    1,    3,
    3,    1,    1,    3,    1,    3,    0,    4,    0,    6,
    1,    1,    1,    1,    3,    3,    4,    4,    5,    4,
    4,    4,    3,    3,    3,    4,    3,    4,    4,    4,
    3,    0,    1,    3,    4,    0,    1,    1,    3,    2,
    3,    3,    1,    2,    3,    5,    2,    1,    1,    0,
    1,    1,    3,    3,    3,    2,    1,    1,    1,    1,
    2,    2,    2,    4,    3,    2,    2,    1,    4,    5,
    4,    3,    1,    3,    1,    3,    1,    1,    1,    4,
    3,    2,    2,    6,    3,    7,    4,    3,    7,    3,
    0,    2,    4,    3,    1,    2,    0,    1,    1,    3,
    1,    2,    3,    1,    1,    1,    0,    1,    1,    2,
    2,    3,    1,    2,    0,    1,    2,    4,    1,    3,
    4,    1,    1,    1,    2,    4,    4,    4,    2,    4,
    2,    4,    0,    4,    0,    5,    0,    1,    0,    4,
    4,    1,    1,    2,    2,    4,    2,    2,    2,    2,
    4,    2,    1,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    1,    3,    3,    3,    3,
    3,    3,    1,    3,    3,    3,    3,    3,    4,    3,
    3,    3,    3,    3,    1,    1,    2,    2,    1,    1,
    4,    1,    1,    4,    1,    3,    3,    1,    2,    1,
    3,    3,    3,    3,    1,    3,    3,    3,    3,    3,
    3,    3,    3,    1,    3,    3,    3,    3,    1,    3,
    3,    1,    3,    3,    1,    3,    3,    1,    3,    3,
    1,    3,    3,    1,    3,    1,    1,    1,    5,    6,
    5,    4,    5,    5,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    5,    5,    3,    3,    2,
    4,    3,    1,    3,    3,    2,    1,    1,    0,    1,
    0,    2,    1,    1,    1,    1,    1,    1,    0,    4,
    0,    4,    0,    5,    0,    0,    7,    0,    0,    8,
    1,    1,    1,    1,    1,    1,    6,    4,    4,    1,
    1,    0,    1,    3,    0,    1,    1,    2,    0,    6,
    0,    0,    0,    0,   15,    0,    1,    0,    1,    1,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    1,    2,    3,
    0,    1,    1,    2,    4,    3,    1,    3,    1,    3,
    1,    1,    0,    1,    1,    1,    0,    4,    1,    1,
    0,    4,    0,    1,    1,    2,    1,    1,    1,    1,
    1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    4,    1,    2,
    2,    2,    1,    2,    1,    3,    5,    4,    1,    2,
    1,    1,    1,    0,    6,    0,    7,    0,    7,    0,
    8,    0,    2,    1,    0,    1,    0,    1,    1,    2,
    2,    4,    0,    2,    0,    1,    1,    2,    4,    1,
    5,    2,    1,    5,    2,    2,    2,    2,    2,    2,
    2,    1,    1,    1,    1,    1,    5,    7,    4,    0,
    8,    4,    0,    1,    1,    2,    1,    2,    1,    2,
    3,    3,    4,    1,    1,    1,    1,    1,    5,    4,
    7,    3,    6,    0,    4,    0,    5,    1,    0,    4,
    2,    2,    2,    1,    1,    0,    1,    0,    5,    1,
    0,    1,    0,    1,    1,    1,    3,    4,    5,    0,
    9,    1,    1,    1,    1,    1,    1,    2,    2,    2,
    3,    4,    3,    3,    3,    3,    2,    3,    2,    3,
    2,    4,    4,    3,    0,    1,    3,    4,    5,    3,
    1,    2,    0,    1,    3,    0,    7,    3,    2,    1,
    0,    0,    5,    2,    2,    0,    3,    5,    4,    0,
    0,   10,    0,    0,    9,    5,    4,    2,    1,    0,
    2,    2,    2,    2,    2,    4,    5,    4,    5,    0,
    5,    0,    6,    3,    2,    2,    2,    1,    0,    3,
    0,    0,    5,    2,    1,    1,    2,    1,    1,    1,
    1,    1,    0,    5,    0,    3,    0,    0,    0,   12,
    0,    0,    0,   13,    0,    2,    0,    3,    1,    0,
    4,    1,    0,    4,    1,    2,    2,    1,    2,    2,
    0,    0,    4,    2,    3,    0,    4,    2,    2,    3,
    0,    1,    1,    1,    2,    2,    2,    2,    4,    3,
    0,    7,    4,    4,    3,    1,    3,    0,    0,    4,
    0,    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0, 1124,    0,    0, 1128,    0,
    0,   15,   17,  431,  437,  444,  432,  434,    0,  433,
    0,  440,  442,  429,    0,  436,  438,  430,  441,  443,
  439,    0,  386, 1146,    0,  435, 1135,    0,   10,    1,
    0,    0,    0,   12,    0,  944,    0,    0,    0,    0,
    0,  622,    0,    0,    0,  475,    0,    0,    0,    0,
    0,    0,    0,  473,    0,    0,    0,    0,  559,    0,
  474,    0,    0,    0, 1046,    0,    0,    0,  776,    0,
    0,    0,    0,    0,    0,    0,    0,  482,    0,  837,
    0,  886,    0,    0,    0,    0,    0,    0,    0,    0,
  472,    0,  765,    0,    0,  943,    0,  869,    0,  467,
  895,  893,    0,    0,    0,  446,  447,  448,  449,  450,
  451,  452,  453,  454,  455,  456,  457,  458,  459,  460,
  461,  462,  463,  464,  465,  466,  469,  470,  471,  772,
    0,  633,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  773,  771,  774,  775,  853,  855,
    0,  851,  854,  870,  872,  873,  874,  875,  876,  877,
  878,  879,  880,  881,  871,    0,    0,    0,  945,  946,
  965,  966,  967,  968, 1002, 1003, 1004, 1005, 1006, 1007,
    0,    0,    0,   20,   22,    0, 1132,   16, 1125,    0,
    0,  281,  298,  280,  277,  282,  283,  276,  295,  294,
  287,  288,  284,  286,  285,  289,  278,  279,  290,  291,
  297,  296,  292,  293,    0, 1149, 1138,    0,    0, 1137,
    0, 1136,    3,   57,    0,    0,    0,   46,   43,   45,
   48,   49,   50,   51,   52,   55,   13,    0,    0,    0,
 1008,  609,  491,  492, 1044,    0,    0,    0,    0,    0,
    0,    0,    0, 1010, 1009,    0,  619,  613,  618,  885,
  942,  856,  883,  882,  884,  857,  858,  859,  860,  861,
  862,  863,  864,  865,  866,  867,  868,    0,    0,    0,
  974,    0,    0,    0,  903,  902,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1017,    0,    0,    0,
    0,    0,    0,  445,    0,    0,    0,    0, 1021, 1019,
    0,    0,    0,  611, 1045,    0,    0,    0,  901,  425,
    0,    0,    0,    0,    0,    0,    0,  405,  373,    0,
  376,  406,    0,  415,    0,    0,    0,    0,    0,    0,
    0,  768,    0,  632,    0,    0,  761,    0,    0,  627,
    0,    0,  483,  628,    0,    0,    0,    0,    0,    0,
    0,  630,  625,  640,  634,  641,  635,  629,  624,  645,
  639,  644,  638,  642,  636,  643,  637,  759,  605,    0,
  604,  468,  379,  380,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  887,    0,  372,    0,  423,  424,    0,
    0,  562,  563,    0,    0,    0,  891,  892,  904,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1127,  852,  890,    0,  894,  940,  941, 1078,
 1095,    0,    0, 1079, 1081,    0, 1107, 1064, 1062, 1088,
    0,    0, 1086, 1089, 1090, 1091, 1092, 1065, 1063,    0,
    0,    0,    0,    0,    0, 1145,    0,    0,  387,    0,
    0, 1147,    0,    0,   44,  807,  813,  805,    0,  802,
  812,  806,  804,  803,  810,  808,  809,  815,  811,  814,
  816,    0,    0,  800,   47,   56,  561,    0,  557,  558,
    0,    0,  555,    0,  906,    0,    0,    0,  972,    0,
  939,  937,  938,    0,    0,    0,  780,    0, 1013, 1011,
  781,    0,    0,  586,    0,    0,  574,  581,    0,    0,
    0,  575,    0,    0,  591,  593,    0,  570,    0,    0,
    0,    0,    0,  565,    0,  568,  572,  408,  407,    0,
  908,  936, 1016, 1015, 1014,    0,    0, 1020, 1018, 1030,
    0,    0,    0, 1031,  603,    0,  402,  602,    0,    0,
 1047,    0,    0,  900,    0,    0,  421,  409,    0,    0,
    0,  413,  414,    0,    0,    0,  412,    0,    0,    0,
  646,    0,    0,  615,    0,  763,  664,  663,    0,    0,
    0,  487,    0,  481,  850,    0,    0,  845,  847,  848,
  849,    0,  495,  496,  476,    0,    0,    0,  896,    0,
    0,  383,  384,    0,  212,  210,  209,  211,  748,    0,
    0,    0,    0,  743,    0,    0,    0,  740,    0,    0,
    0,    0, 1024,    0,    0,    0,  503,  504,    0,  507,
    0,    0,    0,    0,  505,    0,    0,  552,    0,  511,
    0,    0,    0,    0,    0,  537,  540,    0,    0,  532,
  539,  538,    0,  725,  726,  727,  728,  729,  730,  731,
  732,  733,  735,  734,  650,  647,  652,  649,  651,  648,
  661,  658,  662,    0,    0,  672,    0,    0,    0,    0,
    0,  665,    0,  660,  673,  656,    0,  657,    0,  683,
    0,    0,  684,    0,  690,    0,  691,    0,  692,    0,
  693,    0,  697,    0,  698,    0,  701,    0,  704,    0,
  707,    0,  710,    0,  713,    0,  715,    0,  716,    0,
  717,    0,  590,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1077, 1076,    0, 1087,    0, 1075,    0,   18,
 1143, 1144,    0,    0,  207,    0,    0, 1153,  401,    0,
    0,    0,  398, 1139, 1141,   63,   65,   66,    0,    0,
   58,    0,    0,   67,   69,   32,   30,    0,    0,    0,
  797,    0,  801,  501,    0,  560,    0,  608,    0,  621,
  196,  219,    0,    0,    0,  186,    0,    0,    0,  197,
  614,    0, 1050,  978,    0,  996,  975,    0,  987,    0,
  998,    0, 1012,  949,    0, 1049,    0,    0,  573,    0,
  582,  592,  594,    0,    0,    0,    0,  523,    0,    0,
  518,    0,    0,  758,  757,  553,    0,  596,  567,    0,
    0,  158,  597,  156,  157,  599,    0,  910,    0,  607,
  606,  952,    0, 1042,    0,    0, 1028,    0, 1032,  601,
  610, 1057,    0, 1053,  970,    0,    0,    0,  420,  417,
    0, 1068,    0,  374,  375, 1066,    0,    0,  778,  779,
    0,    0,    0,  754,  753,  762,    0,  502,    0,    0,
  484,  839,  840,  838,  846,  480,  479,  478,  477,    0,
    0,  760,    0,  382,  746,    0,    0,    0,  631,  626,
  738,    0,  739,    0,  742,    0, 1023, 1022,  888,  508,
  500,    0,    0,  506,  497,  498,  612,  551,  549,  548,
  546,  543,  542,    0,  541,    0,  536,  493,  494,  509,
  510,    0,  914,    0,    0,  667,  668,    0,    0, 1034,
  659,    0,  722,    0,    0, 1096, 1070,    0, 1097,    0,
 1080, 1082, 1093,    0, 1108,    0, 1074, 1122,    0, 1155,
  208, 1150,    0,  836,  835,    0,  834,    0,  397,    0,
   62,   59,    0,    0,    0,    0,    0,    0,    0,  161,
  404,    0,  791,    0,  111,  112,    0,    0,    0,   90,
    0,  556,    0,    0,    0,    0,    0,  201,  620,    0,
    0,    0,    0,    0,  988,  976,    0,  999,    0,    0,
 1048,  583,  580,    0,  527,    0,    0,    0, 1133, 1134,
  514,  520,    0,  524,    0,    0,    0,    0,    0,    0,
    0,    0,  950,    0, 1038,    0, 1035, 1029, 1056,    0,
  969,  416,    0,  377,  378, 1069, 1067,    0,  616,    0,
  764,  755,  752,  756,  489,  488,    0,  898,  385,  745,
  744,  766,  736,  737,  741,  499,  550,  547,  545,    0,
  535,  534,  533,    0,  930,  933,  913,    0,    0,    0,
  919,    0,    0,    0,  675,    0,  723,    0,  724,  719,
  721,    0, 1072,    0, 1101,    0,    0, 1116, 1117, 1110,
    0,   19, 1154,  400,  399,    0,    0,   68,   61,    0,
   70,   31,   24,  164,    0,    0,    0,  350,    0,  255,
    0,  113,  119,  114,   85,   87,   88,   84,   86,  924,
  131,  132,    0,    0,    0,  927,  217,  218,    0,    0,
    0,    0,  189,  198,  190,  192,  973,    0,    0,    0,
    0,    0,  997,    0,    0,  528,  529,  522,  525,  521,
    0,  515,  519,    0,  588,    0,  554,  564,  513,  600,
  598,    0,    0,    0,    0,    0, 1059,    0,    0,  418,
  777,  769,    0,  897,    0,  544,    0,    0,  905,  920,
  671,    0,  674,    0,    0,  720, 1071,    0,    0,    0,
 1085,    0, 1083, 1094,    0, 1123, 1142,    0,   81,    0,
    0,   75,   76,   79,   80,    0,    0,  163,  367,  356,
  355,    0,  792,  251,    0,    0,  907,  928,  202,    0,
  215,    0,    0,    0,  971, 1061,    0,    0,    0,  992,
    0,    0, 1000,  948,    0,  569,  566,    0,  909,  957,
    0,  964,    0,    0,  955,    0,  959,    0, 1036, 1058,
 1054,    0,  490,  767,    0,    0,    0,  678,  677,  676,
  934, 1073, 1098,    0, 1084,    0,    0, 1112,    0,   82,
   73,    0,    0,  165,    0,  351,    0,    0,    0,    0,
  783,    0,    0,  203,    0,  193,  191, 1051,  989,  977,
  985,  984,  979,  981,    0,  526,  911,    0,    0,  951,
  956,    0,  960, 1043,    0,    0,  770,    0,  922,  679,
    0, 1102, 1119, 1120, 1113,   60,    0,   77,   78,    0,
    0,    0,    0,    0,    0,  786,    0,  818,    0,    0,
  929,  200,    0,  214,    0,    0, 1001,  962,  961,    0,
 1040,    0, 1037, 1055,  931,    0,    0,    0,   83,    0,
    0,  368,    0,    0,  366,  352,    0,  360,  428,    0,
  426,    0,    0,  793,    0,  823,  252,  784,  115,  204,
 1052,  980,    0,    0,  994,  963,  841, 1039, 1099,    0,
 1114,    0,    0,    0,  348,    0,    0,  820,    0,  789,
    0,    0,  824,    0,    0,  983,  982,    0,    0, 1103,
   29,   28,   25,  369,  365,    0,    0,  361,  427,    0,
  826,    0,    0,    0,  116,    0,    0,    0,    0,    0,
   34,  353,    0,  831,    0,  832,  829,    0,  827,  108,
  109,    0,  105,    0,    0,   93,   95,   96,   97,   98,
   99,  100,  101,  102,  103,  104,  106,  107,  159,    0,
    0,  268,  260,  261,  262,  263,  264,  265,  266,  267,
    0,    0,  258,    0,  842,    0, 1100,    0,  370,  364,
  790,    0,    0,    0,    0,  794,   94,    0,  181,  180,
  305,  179,    0,  253,  259,    0, 1106, 1104,  830,  828,
    0,    0,    0,    0,    0,    0,    0,    0,  317,    0,
    0,    0,  269,    0,    0,  275,    0,  183,  177,  160,
  175,  176,    0,    0,  117,  110,    0,    0,  304,    0,
    0,  303,    0,  169,    0,    0,  391,    0,  389,    0,
    0,    0,    0,    0,    0,  349,    0,    0,  795,    0,
    0,  254,    0,  122,  120,  324,    0,  388,    0,    0,
    0,    0,  135,    0,    0,    0,    0,    0,    0,  174,
  166,    0,    0,    0,  232,    0,  392,    0,  270,    0,
    0,  182,  118,    0,  321,    0,  301,  137,    0,  299,
    0,    0,    0,  139,    0,  393,    0,    0,  221,  226,
    0,    0,    0,  390,  273,  184,  130,  128,    0,    0,
  326,    0,    0,    0,    0,    0,  170,    0,  307,    0,
    0,    0,    0,  143,    0,    0,    0,    0,  394,  395,
    0,    0,    0,    0,    0,  125,  340,    0,  322,    0,
    0,  334,    0,    0,    0,  330,    0,  155,    0,    0,
    0,    0,  150,    0,    0,  178,  318,    0,  140,    0,
  134,  144,  167,  173,  241,    0,  222,    0,    0,  233,
    0,  129,    0,  121,  126,    0,    0,    0,  336,    0,
  337,  327,    0,    0,  320,  331,  302,    0,    0,  136,
  151,  300,    0,  316,    0,  308,  310,  146,    0,    0,
    0,  238,  240,    0,  274,  127,  341,  343,  323,    0,
    0,  335,  334,  154,  152,  171,  315,    0,    0,    0,
  168,  242,  244,  223,    0,  236,  234,    0,    0,  333,
    0,  311,  313,  147,    0,    0,    0,    0,  345,  346,
  347,  342,  344,  172,    0,    0,  249,  248,  246,  247,
  243,  245,  228,  224,  235,    0,    0,    0,  312,  314,
  230,  231,    0,  229,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   50,    9,   51,   10,   11,   52,  245,  833,  834,
   12,   13,   53,   22,   23,  206,  345,  248,  818, 1027,
 1266, 1411, 1463, 1789, 1024,  249,  250,  251,  252,  253,
  254,  255,  256,  811,  503,  812,  813, 1157,  814,  815,
 1161, 1025, 1261, 1262, 1263,  281,  697, 1377,  117, 1041,
 1178, 1175,  876,  972, 1494, 1495, 1496, 1497, 1498, 1499,
 1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507, 1508,  636,
 1534,  934, 1038,  522,  822, 1589, 1340, 1275, 1387, 1424,
 1455, 1524, 1603, 1419, 1659, 1634, 1684, 1685, 1686, 1180,
 1682, 1181,  885, 1561, 1645, 1618, 1672,  577, 1665, 1639,
 1701, 1125, 1670, 1673, 1674, 1770, 1702, 1703, 1699, 1509,
 1570, 1538, 1030, 1165, 1267, 1590,  835, 1647, 1749, 1615,
 1705, 1781,  523,  282, 1572, 1707, 1541, 1438, 1573, 1103,
 1600,  836,  837,  838,  839,  840,  793,  661, 1393,  794,
  795, 1047, 1592, 1623, 1717, 1677, 1751, 1804, 1787, 1624,
 1813, 1808, 1593, 1651, 1777, 1754, 1718, 1719, 1801, 1785,
 1786, 1171, 1338, 1454, 1521, 1574, 1522, 1523, 1563, 1597,
 1564,  348,  235, 1681, 1566, 1666, 1663, 1510, 1586, 1746,
 1708, 1747,  698, 1795, 1796, 1585, 1662, 1636, 1694, 1689,
 1660, 1727, 1732, 1692, 1695, 1696, 1733, 1690, 1691, 1792,
 1778, 1779, 1168, 1272, 1416, 1382, 1446, 1417, 1418, 1466,
 1335, 1443, 1479,  418,  349,  119,  403,  404,  120,  654,
  499,  238, 1610,  802,  803, 1016, 1031,  121,  353,  465,
  340,  354,  609,  610,  910,  323, 1420, 1421,   46,  124,
  324,  126,  127,  128,  129,  130,  131,  132,  133,  134,
  135,  136,  137,  138,  139,  140,  141,  142,  143,  144,
  145,  146,  147,  148,  149,  378,  379,  372,  373,  930,
 1233,  266,  980,  881, 1218, 1207,  869, 1071,  870,  871,
 1208,  150,  209,  877,  700,  701,  702,  971,  151,  532,
  533,  312, 1216,  879,  466,  314,  561,  562,  563,  564,
  567,  887,  599,  278,  538,  921,  279,  537,  152,  153,
  154,  155,  733,  991,  734,  735, 1134, 1135, 1319,  156,
  157,  158,  159,  160,  161,  162,  163,  164,  770,  771,
  165, 1104,  166,  410,  411,  663,  664,  665,  926,  927,
  167,  651,  629,  923,  405, 1235,  625, 1312,  168,  552,
 1341, 1385, 1388, 1470, 1169, 1337, 1452, 1567,  524, 1425,
 1426, 1488, 1489, 1017,  375, 1458,  637,  638,  283,  284,
  285,  171,  172,  173,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  185,  298,  676,  186,
  187,  381,  341,  985,  703, 1129, 1044,  829, 1184,  889,
 1081, 1127, 1130, 1288, 1131, 1185, 1186,  299,  188,  189,
  190, 1303, 1224, 1304, 1305, 1306, 1307,  191,  192,  193,
  194,  847,  545,  848, 1291, 1202, 1292, 1432, 1396, 1354,
 1433,  849, 1201,  850, 1435, 1355,  195,  196,  197,  198,
  199,  200,  326,  593,  594,  896, 1403, 1365, 1084,  337,
 1200, 1054, 1395, 1229, 1090, 1366,  201,  479,  202,  480,
 1142, 1248,  481,  482,  788,  779,  780, 1253, 1146,  483,
  484,  485,  486,  487, 1147,  774, 1144, 1371, 1459, 1527,
 1250, 1407, 1478, 1005,  782, 1006, 1327, 1255, 1328, 1408,
 1151,   17,   19,   47,   48,  237,  796, 1020,  497,  797,
  798,
  };
  protected static readonly short [] yySindex = {         -159,
    0, -153,  107,  -21,   55, 5406,    0,  309,    0,    0,
   55,  -21,    0,    0,  203,    0, 9690,   55,    0, -129,
   64,    0,    0,    0,    0,    0,    0,    0,  379,    0,
  421,    0,    0,    0, 9300,    0,    0,    0,    0,    0,
    0,  375,    0,    0,  841,    0,    0,  860,    0,    0,
  309,  439,   55,    0,  440,    0,  374,  449, -186,21275,
 -148,    0,  353,  462, 9861,    0,  353,  353,  353,   95,
  353,  353,  907,    0,21167,11187,  353,  353,    0,11351,
    0,  483,  353, -174,    0,  353,  469,  353,    0,20647,
20647,  498,  353,  353,   97,13886,20030,    0,20771,    0,
19178,    0,14303,14442,14581,14720,14859,14998,15137,15276,
    0,  314,    0,19340,19320,    0, -189,    0,  -31,    0,
    0,    0,  438,  982,  366,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -31,    0, 1286,  912,  318, -281,  767,  650,  505,  541,
  524,  562, -274,  613,    0,    0,    0,    0,    0,    0,
 4649,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  669,  672, -280,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -121,  185,  439,    0,    0,  641,    0,    0,    0,19340,
19340,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  375,    0,    0,  649,  654,    0,
  137,    0,    0,    0,  439,22085,  779,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  836,  -31,20172,
    0,    0,    0,    0,    0,20030, -163, -142,  828,  798,
  594,  982,  -31,    0,    0,19340,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  267,  205,21275,
    0,19340,20030,  736,    0,    0,  765,20030,20030, 7637,
  699, -162,  811,19340,21275,  -31,    0,20030,13886,20314,
  314,  937,  844,    0,  893,  909,19340,20030,    0,    0,
  -86,   80,12680,    0,    0,20030,  483,19320,    0,    0,
  469,20030,19482,  677,  667,  947,  -31,    0,    0,  783,
    0,    0,  669,    0,  366,  956,  -31,20630,20030,20030,
  462,    0,  915,    0,19340,19340,    0,14164,  -31,    0,
  849,  990,    0,    0,10032,  363,  216,  894,  887,  876,
  910,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,18318,
    0,    0,    0,    0,21745,  677,  930,  932,  -31,  923,
  929,  934,20030,    0,  607,    0,  167,    0,    0,  290,
  176,    0,    0,  906,12171,10367,    0,    0,    0,20030,
20030,20030,20030,20030,20030,20030,20030,20030,20030,20030,
15415,15554,15693,18387,18056,15832,15971,16110,16249,16388,
16527,16666,16805,16944,17083,17222,17361,17500,17639,17778,
20907,19036,    0,    0,    0,  669,    0,    0,    0,    0,
    0,20647,20647,    0,    0,  -31,    0,    0,    0,    0,
  517,  966,    0,    0,    0,    0,    0,    0,    0,  439,
  779,  552,  744,  375,  375,    0,  722,  193,    0,  375,
  962,    0, -166,22085,    0,    0,    0,    0, -151,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  275,22117,    0,    0,    0,    0,  958,    0,    0,
  968,  791,    0, 1024,    0, 1036,  231,  483,    0,  353,
    0,    0,    0,  -31,11515, -144,    0, 1041,    0,    0,
    0,   -9,   75,    0,  798,  594,    0,    0, 1050,    0,
 1072,    0, 1070, 1016,    0,    0,  824,    0,12947,  856,
12335,  811,18894,    0,11023,    0,    0,    0,    0,  -31,
    0,    0,    0,    0,    0,  112,  133,    0,    0,    0,
  295,  483,  316,    0,    0,  469,    0,    0, 1074, 1078,
    0,  148,  -31,    0,  149,  469,    0,    0,  941, 1040,
 1043,    0,    0,20030, 1170,  607,    0,20030, 1176, 1093,
    0, 1097, 1101,    0,21745,    0,    0,    0,  130,  958,
20030,    0,20030,    0,    0, -267,10032,    0,    0,    0,
    0,20030,    0,    0,    0,20314,20314, 1103,    0,21275,
  130,    0,    0, -262,    0,    0,    0,    0,    0,  677,
  -31,19482, 1104,    0, 1108,17917,20030,    0, 1100,20030,
 1105,21383,    0, 1234, 1109,10032,    0,    0, 1056,    0,
  958,  -31,20172, 1057,    0,  607,  958,    0,  105,    0,
20030,19320,20030, 1118, 1243,    0,    0,  254,  -90,    0,
    0,    0, -171,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,20771,20771,    0,19340,  525,    0,    0,
    0,    0,  -31,    0,    0,    0,  912,    0,  912,    0,
14025,  318,    0,  318,    0, -281,    0, -281,    0, -281,
    0, -281,    0,  767,    0,  767,    0,  650,    0,  505,
    0,  541,    0,  524,    0,  562,    0,19340,    0, -185,
    0, 1121,    0,12335, 1208,  -31, 1209,  -31,12335,12335,
 1119,20030,    0,    0,  966,    0,  -31,    0, 1083,    0,
    0,    0,19482,  722,    0, 1135, 1134,    0,    0,  750,
  439,  189,    0,    0,    0,    0,    0,    0, -170, 1137,
    0, 1138, 1140,    0,    0,    0,    0, 1143,12825, 1102,
    0,   35,    0,    0,  788,    0,20172,    0, 1144,    0,
    0,    0,  757,  195, 1146,    0, 1147, 1150, 1153,    0,
    0,20030,    0,    0,  -31,    0,    0, 1156,    0, 1163,
    0,   81,    0,    0, 9861,    0, 9861,11679,    0,18249,
    0,    0,    0,13747,11843,  479,18894,    0,  188,   98,
    0, 1107, 1123,    0,    0,    0,  869,    0,    0, 1169,
 1168,    0,    0,    0,    0,    0, 1173,    0, -171,    0,
    0,    0, 1177,    0,18456,  483,    0,  483,    0,    0,
    0,    0, 9861,    0,    0, 9861,  672,19482,    0,    0,
  607,    0,20030,    0,    0,    0,20030,19340,    0,    0,
  483, 1180,  130,    0,    0,    0,19462,    0, 1174, 1142,
    0,    0,    0,    0,    0,    0,    0,    0,    0,21275,
 1148,    0,19340,    0,    0,  -31,21745, 1226,    0,    0,
    0,20030,    0,20030,    0,  -31,    0,    0,    0,    0,
    0,  958,  877,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -31,    0,18752,    0,    0,    0,    0,
    0,10531,    0,10695, 1193,    0,    0, 1197,  -31,    0,
    0, 1151,    0,10859, 1265,    0,    0, 1290,    0, 1291,
    0,    0,    0, 1009,    0, 1211,    0,    0,  793,    0,
    0,    0,  722,    0,    0, 1164,    0,  193,    0,  722,
    0,    0, 1083, 1213, 1217, 1175, 1224, 1285, 1102,    0,
    0, 1219,    0, 1346,    0,    0, 1279, -143,12007,    0,
12335,    0,19604, 1225,  757,19482,19340,    0,    0, -212,
 1348, 1350,  174, 1220,    0,    0,20030,    0,20030, 1327,
    0,    0,    0,19746,    0, -230,19746,  878,    0,    0,
    0,    0,12805,    0, 1353,  669,12335, 1237,11679, 1247,
 -171, 1193,    0,  353,    0,  -31,    0,    0,    0, -164,
    0,    0, 1040,    0,    0,    0,    0, 1233,    0, 1273,
    0,    0,    0,    0,    0,    0, 1198,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  942,
    0,    0,    0,19340,    0,    0,    0,  -31, 1241, 1193,
    0,20771, 1325,  566,    0,20030,    0,20771,    0,    0,
    0,12335,    0,12335,    0, -167,12335,    0,    0,    0,
  737,    0,    0,    0,    0, 1250, 1083,    0,    0,12499,
    0,    0,    0,    0,19340, 1248,18525,    0, 1102,    0,
 1102,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -31, 1245, 1225,    0,    0,    0, -120, -135,
 1251, 1252,    0,    0,    0,    0,    0, 1246,11679, 1193,
 -171,20030,    0, 1257, 9861,    0,    0,    0,    0,    0,
 1258,    0,    0, 1254,    0,  811,    0,    0,    0,    0,
    0, 1193, 1255, -177,20030, 1260,    0, 1193, 1261,    0,
    0,    0, 1221,    0,  130,    0, 1207, 1263,    0,    0,
    0,21043,    0,  -31, 1272,    0,    0,12335, 1303,12335,
    0,12335,    0,    0,20030,    0,    0, 1140,    0,  507,
  946,    0,    0,    0,    0,  -21,19340,    0,    0,    0,
    0, 1282,    0,    0, 1275, 1269,    0,    0,    0,  711,
    0, 1270, 1403, 1404,    0,    0, 1193, 1283, 1193,    0,
 9861,  738,    0,    0,19746,    0,    0, 1280,    0,    0,
19320,    0, 1289, -203,    0, 9519,    0, 1288,    0,    0,
    0,  130,    0,    0,20030,10695,  -31,    0,    0,    0,
    0,    0,    0, 1316,    0, 1017, 1287,    0, 1296,    0,
    0,12499,   55,    0,  231,    0,  885, 1295,  231, 1295,
    0,19604, 1301,    0,20030,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 9861,    0,    0, -169, 1259,    0,
    0,10032,    0,    0,  286, 9861,    0, 1302,    0,    0,
12335,    0,    0,    0,    0,    0,20030,    0,    0,  439,
 1306,  439,19340, 1295, 1339,    0, 1339,    0, 1307, 1339,
    0,    0,20030,    0, 9861,20030,    0,    0,    0, 1300,
    0, 1313,    0,    0,    0, 1340,12335,20030,    0,  439,
 1314,    0, 1266,  994,    0,    0, 1311,    0,    0,  125,
    0, 1315, 1281,    0, 1339,    0,    0,    0,    0,    0,
    0,    0,  890, 1163,    0,    0,    0,    0,    0, 1355,
    0,   -8, 1339, 1452,    0, 1335,  439,    0,19340,    0,
 -145, 1337,    0, 1341, 1342,    0,    0,10032,12335,    0,
    0,    0,    0,    0,    0, 1326, 1330,    0,    0,18894,
    0,21957,  173,  439,    0, 1343, 1361,12335, 1344,20030,
    0,    0, 1354,    0, 1351,    0,    0, 1360,    0,    0,
    0,22117,    0, 1345,  173,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  508,
22117,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1359,  439,    0,  173,    0,  -31,    0, 1361,    0,    0,
    0, 1357,21957,10032,21491,    0,    0,  568,    0,    0,
    0,    0,21565,    0,    0, 1369,    0,    0,    0,    0,
 -267,19340,19340,   79,19340,  299,  469, 1407,    0,  677,
 1527, 1372,    0, 1441,    0,    0, 1330,    0,    0,    0,
    0,    0,20030, 1330,    0,    0, -119, -115,    0,19340,
 -109,    0,19340,    0, 1331, 1373,    0,  472,    0,  156,
 1256,    0, 1374, 1332,  215,    0,  568, 9300,    0,19462,
 1375,    0, 1330,    0,    0,    0,  472,    0, 1378, 1334,
 1377, 1379,    0, 1382, 1338, 1387,  231, 1380, 1391,    0,
    0, 1389, 1399, 1429,    0,  958,    0,  989,    0, 1400,
 1398,    0,    0, -133,    0, 1394,    0,    0, 1408,    0,
 1405, 1406, 1409,    0, 1410,    0,  231,  231,    0,    0,
  231, 1413, 1414,    0,    0,    0,    0,    0, 1415,  253,
    0, 1416,  231, 1529, 1417,  231,    0,  568,    0,11679,
 1362, 1412, 1410,    0, 1420, 1421,  260, 1427,    0,    0,
  231,19604, 1381, 1422, 1415,    0,    0,22117,    0,  439,
  439,    0, 1383, 1424, 1416,    0, 1431,    0,20030, 1386,
 1432, 1417,    0, 1433,  231,    0,    0,  -58,    0, 1428,
    0,    0,    0,    0,    0,22117,    0,  260,  260,    0,
 1435,    0, -133,    0,    0,  308, 1442,22117,    0,22117,
    0,    0,11679, 1430,    0,    0,    0, 1443, 1408,    0,
    0,    0, 1440,    0,  320,    0,    0,    0, 1339, 1027,
 1446,    0,    0, -235,    0,    0,    0,    0,    0, 1486,
 1560,    0,    0,    0,    0,    0,    0, 1447, 1451,11679,
    0,    0,    0,    0,  260,    0,    0,  579,  579,    0,
 1339,    0,    0,    0,   66,   66, 1444, 1455,    0,    0,
    0,    0,    0,    0,18894,18894,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1454, 1456,19604,    0,    0,
    0,    0, 1459,    0,
  };
  protected static readonly short [] yyRindex = {         1634,
    0,    0,10203, 1634,    0,    0,    0, 1842,    0,    0,
 1873, 3988,    0,    0,    0,    0,    0, 1873,    0, 1419,
   57,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1844,    0,    0, 1844,    0,    0, 1844,    0,    0,
 1842, 2404, 4149,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1474,    0,    0,    0,    0,    0,    0,
    0,    0,19624,    0,    0, 1466,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3682,    0,    0,    0,
    0,    0,    0,    0,    0,  281,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 6298,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 7025, 6227, 6530,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 7105, 7258, 7639, 7898, 8354, 8573, 8719, 8865,
 9011, 6166, 1727,  784,    0,    0,    0,    0,    0,    0,
   57,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 7178, 7025,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 4275,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1844,    0,    0,  728,    0,    0,
    0,    0,    0,    0, 4358,  423, 4401,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 5072,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1476,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 5237, 1469,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 3394,    0,    0,  100, 3530,    0,    0,    0,    0,    0,
    0,    0, 3834,    0, 3530,    0,    0,    0,    0,    0,
 1474,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1054,    0,    0,    0,  204, 9353, 1472,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1477, 3242,    0,    0,    0,    0,
    0,    0, 1466,    0, 5072,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  256,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2560,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2275,    0,    0,    0,    0,    0,    0,    0, 4475,
 4539,  830,    0, 1844, 1844,    0,21400, -207,    0, 1844,
 1854,    0,    0,  411,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   83,18172,    0,    0,    0,    0, 5072,    0,    0,
    0,    0,    0,    0,    0,    0,21597,    0,    0,    0,
    0,    0,    0,    0, 1475,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  338,22094,    0,    0,  285, 1059,
    0,    0, 1482,  748,    0,    0,    0,    0,  209,    0,
    0, 5732, 1481,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1487,    0, 2793,    0,    0, -272,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   14,    0,    0,    0,  949,
    0,    0,    0,    0,    0, 3090,    0,    0,    0,    0,
    0,    0,    0,    0, 1477,    0,    0,    0,19888, 5072,
    0,    0,    0,    0,    0,    0,  219,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
19888,    0,    0,    0,    0,    0,    0,    0,    0, 1157,
    0,    0, 1484,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1469,    0,    0,    0,    0, 4907,    0,
 5072,    0,    0, 4741,    0, 5072, 5897,    0,    0,    0,
    0,    0,    0, -192,    0,    0,    0,    0,  266,    0,
    0,    0,  953,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 6463, 6695, 6805,
 6915,    0, 7331,    0,    0,    0, 7411,    0, 7484,    0,
    0, 7746,    0, 7822,    0, 7974,    0, 8050,    0, 8126,
    0, 8202,    0, 8427,    0, 8500,    0, 8646,    0, 8792,
    0, 8938,    0, 9084,    0, 9157,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 2275,    0,    0,    0,    0,    0,
    0,    0,    0,19766,    0,    0,  967,    0,    0, 1439,
13116,    0,    0,    0,    0,    0,    0,    0,  818,  769,
    0,    0, 1489,    0,    0,    0,    0, 4075,    0,    0,
    0,    0,    0,    0,12663,    0,    0,    0,  964,    0,
    0,    0,19908,21819,    0,    0,  974,  977, 1001,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1485,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1495,
    0,    0,    0,    0,    0, 8262,    0,    0,    0,  233,
    0,  171, 5402,    0,    0,    0,    0,    0,    0,    0,
 1492,    0,    0,    0,    0,    0, 1497,    0,  953,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3530,    0,    0,    0,
 3090,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,19888,    0,    0,    0,    0,    0, 1060,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 5072,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1493,    0,    0,    0,    0,    0,
    0, 5504,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -178,    0,  635,    0,    0,    0,    0,
    0,    0,19908,    0,    0,    0,    0, -207,    0,19198,
    0,    0, 1500,    0,  889,    0,    0,20050,    0,    0,
    0, 1504,    0, 1457,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1496,20192,    0,    0,    0,    0,21888,
    0,    0,    0, 1004,    0,    0,    0,    0,    0, 2981,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 5567,    0, 6062, 1505,    0,
  953, 1493,    0,    0,    0, 1502,    0,    0,    0, 1004,
    0,    0,  949,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1503,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1005,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1507,    0,    0,    0,    0,    0,
 1010, 1011,    0,    0,    0,    0,    0,    0,    0, 1506,
  953,  739,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 5732,    0,    0,    0,    0,
    0, 1493,    0, 1512,    0,    0,    0, 1506,    0,    0,
    0,    0,    0,    0,19888,    0,  781,  810,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1489,    0, 4974,
    0,    0,    0,    0,    0,13584,    0,    0,    0,    0,
    0,    0,    0,    0,  520,    0,    0,    0,    0,  825,
    0,  870,    0,    0,    0,    0, 1509,    0, 1493,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1519,    0,    0,    0,    0,    0,    0,
    0,19888,    0,    0,    0,    0,  768,    0,    0,    0,
    0,    0,    0,    0,    0,  441,  647,    0,    0,    0,
    0,    0,13667,    0,21597,    0,  584,  590,21597,  590,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -206,    0,    0, 1487,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 5236,
    0,  307,    0,  680, 1521,    0, 1521,    0,    0, 1521,
    0,    0,    0,    0,    0,  899,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 5731,
    0,    0,    0,13368,    0,    0, 1522,    0,    0,  589,
    0,  683,    0,    0,  629,    0,    0,    0,    0,    0,
    0,    0,    0,  911,    0,    0,    0,    0,    0,    0,
    0, 4232, 1515,  770,    0,    0,  332,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1524,    0,    0,
    0,    0,    0,    0,    0,    0, 2057,    0,    0, 1481,
    0,    0,13200,13452,    0,    0,  665,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  578,    0,    0,
    0,18594,    0,    0,13284,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
18668,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,13536,    0,13200,    0,    0,    0,  665,    0,    0,
    0,    0,    0,  204,   83,    0,    0,    0,    0,    0,
    0,    0,   83,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 4905,  278,    0,20565,
    0, 2164,    0,    0, 5895,    0, 2057,    0,    0,    0,
    0,    0,    0, 2057,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  395,    0,  465,
    0,  694,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2057,    0,    0,    0,  425,    0,  626,    0,
    0,    0,    0,    0,    0,    0,21597, 1012,    0,    0,
    0,    0,    0,    0,    0, 1520,    0,  837,    0,    0,
    0,    0,    0,    0,    0, 1013,    0,    0,    0,    0,
    0,    0,    0,    0, 1518,    0,21597,21597,    0,    0,
21671,    0,    0,    0,    0,    0,    0,    0, 1523,22055,
    0, 1526,21597,20456, 1528,21597,    0,    0,    0,    0,
    0,    0, 1531,    0,    0,    0, 4032,    0,    0,    0,
21597,    0,    0,    0, 1532,    0,    0,  416,    0, 6692,
21988,    0,    0,    0, 1533,    0,    0,    0,    0,    0,
    0, 1535,    0,    0,21597,    0,    0,  655,    0, 1035,
    0,    0,    0,    0,    0, 1061,    0, 6061, 6462,    0,
    0,    0,    0,    0,    0,    0,    0, 1585,    0, 1640,
    0,    0,    0, 1038,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  659,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 4032,    0,    0, 1426, 2210,    0,
  659,    0,    0,    0,    0,    0, 9295,    0,    0,    0,
    0,    0,    0,    0, 1481, 1481,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1853,    0,    0,    0,   -3,  -16, -193,  -48,  -44,
    0, 1897, 1915,  866,    0,    0, -179,    0,    0,    0,
    0,    0,    0,-1141, -834, -231, -689,    0,    0,    0,
    0,    0, -236,    0,    0,    0,  764,    0,  901,    0,
    0,    0,    0,  595,  596,  -17, -218,    0,   87,    0,
    0,    0, -570,  883,  402,    0,  434, -776, -729, -696,
 -677, -663, -642, -640, -638,    0,    0,-1283,    0,-1354,
    0,  382,    0,-1358,    0,   20,    0,    0,  598,-1321,
    0,    0,    0,  -71,  212,    0,    0,    0,  249,-1298,
    0, -294, -307, 1120,    0,    0,    0, -747,  201,    0,
    0, -559,    0,    0,  268,    0,    0,  246,    0,    0,
-1048,    0,  415,    0,    0, -620,-1211,    0,    0,    0,
    0,    0,  392,  -10,-1434,    0,    0,  444,    0,  355,
    0,    0,    0,  913,  916,  917, 1124, -296,    0,    0,
 -359,  920,  383,    0,-1004,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  183,    0,
    0,    0,    0,    0,    0,    0,    0,  450,    0,    0,
    0, -309,  362,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -568,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  199,    0,    0,  279,    0,  284,  288,  200,
    0,    0,    0,    0,    0,    0,    0,    0,  533,    0,
    0,    0,    0,  -92,    0, 1249, -347, -374, 1616,    0,
  356,    0,  424,    0,  969,    0, 1655,  453, -311, -277,
  -73,   50,    0, 1082,  898, 1196,    0,  543,    0,   -2,
  868, -415,    0,    0, -414,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -413,    0,    0,    0,    0,    0,
    0,    0, -270,    0,    0,    0,  794,    0, 1363,    0,
    0,  405,    0, -387,    0, -289,    0,    0,    0,  921,
-1007, -330, -134, 1128,    0, 1018,    0,  742,   41, -377,
 1171,    0,    0,  785, 1922,    0,    0,    0,    0, 1139,
    0,    0,    0, 1641,    0,    0,    0,    0,    0, 2151,
  997, 1000, -605,-1030,  761,    0,    0,  760,    0,  843,
 1014, 1551, 1553, 1554, 1552, 1558,    0, 1559, 1019,    0,
    0,  -64,    0,    0,    0,    0, 1067, 1397, -613,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -324,
  682,    0, -597,    0,    0,    0,    0,    0, -510,    0,
  599,    0,  490,    0,    0,    0,  719, -601,    8, -358,
   12,    0, 1855,    0,  114,    0,  126,  129,  131,  157,
  177,  191,  211,  228,  261,  276,    0, -774,    0,    0,
    0,    0,    0, -844,    0,-1027,    0,    0,    0,    0,
    0,  712, -351,  799,-1069,    0,  845, -523,    0,    0,
    0,    0,    0,    0,  725,    0,  726,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  638,    0,    0,    0,    0,    0,    0,
    0,    0, 1618,    0, 1448,  670,    0,    0,    0,    0,
  950,    0,    0,    0,    0,    0,    0, -187,    0,    0,
    0,    0,    0, 1556, 1262,    0,    0,    0,    0, 1562,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  511,
    0,    0,    0,    0,    0,    0,    0,    0,  636,    0,
    0,    0,    0,    0,    0,    6, 1025,    0,    0,    0,
 1033,
  };
  protected static readonly short [] yyTable = {           116,
   18,  203,  579,  246,  880,  576,  118,  247,  548,  490,
  526,  325,  823,  505,  489,  886,  640,  605,  347,  357,
  992,  846,  574,  597,  169,   44,  493,  620,  170,  729,
  730,  731,  427,  608,  572,  935,  463,  942,  699,  560,
  678,  530,  407, 1391, 1082,  662,  607,  689,  265,  419,
  240,  428, 1080,  242, 1223, 1226, 1131,  272,  322, 1210,
 1240,  958,  331,  776, 1301, 1427,  122,  677, 1429,  262,
  993,  332,  272,  335,  959,  617,  412, 1115, 1300,  371,
 1060,  334, 1061,  377,  983, 1021, 1398,   53, 1251,  806,
 1301, 1227,  262,  568,  467,  608,    1,  408, 1415,   53,
  273,  468,   14, 1476,  816,  403,  932,  274, 1568,  122,
 1471,  851, 1173,  334,  122,  316,  807,  943,  448,  449,
 1281, 1464, 1657, 1381,  122,  413,  204, 1389, 1089, 1191,
  174, 1091,  460, 1535,  470, 1279, 1604, 1775,  494,  495,
 1606,  380,  175, 1209,  461,  176, 1612,  177,  808, 1077,
  122,  403, 1543,  116,  246,  409,  307,  469,  491,  944,
  118, 1115,  244, 1415,  122,  981, 1115,  958, 1115,  588,
  933, 1115, 1115,  178, 1115, 1115,  346,  356,  169, 1551,
  824,  363,  170,  776, 1252,  776,  100,  776,  773, 1650,
  263,  414,  205,  179, 1298,  994,  504, 1744,  100,    2,
  491, 1115,  263,  996,  536,  415,  530,  180, 1001, 1002,
  569, 1399,  570,  263,  263,  984,   53, 1240,  471,  305,
  122,  958, 1199,  472, 1302,  473,  399,  181,  474,  475,
  546,  476,  477,  275,  263, 1472, 1222,  429,  872,  264,
  496,  915,  529,  305,  182,  776,  854, 1461,  534,  400,
 1302,  264,  612, 1658,  526,  586,  401,  809,  505, 1115,
  502, 1349,  264,  264,  878,  662,  571,  604,  914,  410,
   15,  613,  817,    3,    4,    5,    6,  183,  640,  306,
   43,  419,  928,  264,  174,  547, 1370, 1356, 1282,  982,
  551,  553,  184,  627,  628,  589,  175,  272, 1062,  176,
  582,  177,  377,  306, 1605,  963, 1033,  272, 1607, 1101,
  587,  966,  272, 1131, 1613,  608,  478,  640,  600, 1776,
  602, 1797, 1745,  810,  551, 1482,  601,  178,  653, 1726,
  856, 1034,  305,  961, 1579,  590, 1058,    2,  965,  967,
  544,  622,  623, 1791, 1791,  528,  531,  179,  591,  122,
 1800, 1800,  608, 1072,  796,  580, 1289, 1750, 1035,  535,
  968,  180,  303,   16,  122,  946,  592,  890,  855, 1760,
  304, 1761,  722, 1462,  361, 1059, 1237,  410,  603,  796,
 1448,  181,  639, 1722, 1580,  924,  641,  122,  892,  410,
   20,  410,  306,  410,  902,  674,  559,  772,  182,   20,
  776,  778,  581,  902,  905, 1643,  796,  529,  696, 1568,
    6, 1620,  704,  705,  706,  707,  708,  709,  710,  711,
  712,  713,  714, 1329,  122, 1599, 1131, 1771, 1490, 1197,
 1294,  183, 1602,  615, 1011, 1675, 1676,  410,  100, 1678,
  470,  246,  272,  619,  769,  491,  184, 1798,  799,  800,
 1048, 1697,  857,  801, 1704,  630,  579,  381,  305, 1794,
  305, 1633,  501,  381,  530, 1036, 1037,  276, 1176, 1721,
 1179,  300,  301,  302,  381,  308,  309, 1073,  381, 1068,
  969,  327,  328,  608,  827,  732,  831,  333,  336,  891,
  338,  381,  342, 1743,  122,  668, 1010,  359,  360,  791,
  792,  207,  100,  681, 1449,  804, 1217,  686, 1687,  597,
  893,  531,  531,  796,  796, 1715, 1350, 1053,  306, 1220,
  306,  362,  539,  381,  471,  903,  906,  841,  426,  472,
  305,  473, 1621, 1203,  474,  475, 1095,  476,  477,  305,
 1627, 1401,  352,  352, 1131, 1491,  903,  244, 1629,  797,
 1131, 1198,  819,  875, 1582,  696,  820,  884,  775,  777,
   43, 1069,  781, 1094,  526,   49,  352,  244, 1018,  244,
 1757, 1247,  832, 1249,  797, 1767, 1254,  843,  541,  444,
 1397,  897,  516, 1768,  591,  845,  542,  662, 1120,  560,
  679, 1404,  844,  643,  122,  903,  912,  526,  608,  684,
  916,  797,  898,  680, 1583,  244,  517,  540,  530, 1009,
 1019,  607,  685,  929, 1116,  371,  445,  821,  925, 1706,
 1431, 1314,  488, 1758,  936, 1070,   55,  244,  937,  937,
  843,  978,  852,  530,  244,  427, 1317,  608, 1628, 1286,
  925,  843,  543,  531,  639, 1769,  516,  272,  641,  951,
  386,  894,  953,  644,  428,  988,  844,  398,  584,  531,
  894,  903,  352,  352,  584,  529,  888,    6,  682,  272,
  517,  263,  336,  970,  970,  970,  426, 1322,  798, 1324,
  357, 1325,  798,  639,  210, 1187,  122,  641,  798,  904,
  941,  979,  798,  530,  798, 1359, 1118, 1513, 1367,  122,
  798,  446,  447,  531,  798,  359,  398,  798,  797,  797,
  399,  903,  956, 1752, 1753,  903,  573,  903,  683,  798,
  264,  122,  584,  416,  903,  122,  211,  396,  352,  263,
   53,  798,  974,  400,  798, 1182,  608, 1074,  386, 1386,
  401,  122,  872,  642, 1514, 1513,  798,  945,  258, 1189,
  402,  236,  259,  798,  352,   53,  875,  339,  955,  399,
  935,  875,  875, 1122, 1004,  798,  578,  386,  962,  531,
 1788,  386,  783,  381,  133,  903,  133, 1515,  264,  352,
 1118,  133,  400, 1493, 1512, 1118, 1422, 1118, 1219,  401,
 1118, 1118, 1514, 1118, 1118,  416, 1516,  386, 1215,  402,
 1406,  386,  260,  381,  386, 1493,  386, 1581,  388,  529,
 1517,  386,  579,  244, 1092,  386,  417,  352,  352,  990,
 1118,  257,  398, 1086,  551, 1515,  729,  730,  731,  339,
  261, 1518, 1512, 1519, 1493, 1520, 1440,  388,  277, 1032,
  884,  798,  798,  810, 1516,  386, 1098,  875, 1287,  696,
  398, 1539,  352,  798,  798,  100,  471,  272, 1517,  782,
  339,  472,  998,  473, 1000, 1067,  474,  475,  399,  476,
  477, 1109,  846, 1008,  358,  399, 1287, 1290, 1118, 1518,
 1437, 1519,  416, 1520,  125, 1087,  208, 1088, 1477, 1540,
 1109,  400,  782, 1330,  456, 1096,  352,  989,  400, 1097,
  782, 1483, 1111,  399,  122,  401,  122, 1528,  878, 1102,
 1099, 1568,  925,  531,  458,  402,  339,  825,  208, 1126,
 1105,  825, 1568,  785,  352,  352,  400,  125,  819,  817,
 1141, 1055,  125,  401, 1113,  457, 1114,  272,  789, 1243,
  100, 1265,  125,  402,  842, 1244,  559,  640,  399, 1569,
  825,  100,  122,  531,  784,  122,  785, 1608,  696,  825,
 1481,  819,  817, 1256,  696,  819,  884,  459,  125,  800,
 1622,  400,  822,  801, 1109, 1190,  769,  810,  401, 1109,
 1107, 1109,  125,  396, 1109, 1109, 1111, 1109, 1109,  122,
  399, 1111,  470, 1111, 1641,  895, 1111, 1111,  309, 1111,
 1111,  822,  821,  640, 1105,  319, 1358,  319,  462, 1105,
  822, 1105,  319,  400, 1105, 1105,  655, 1105, 1105,  787,
  401,  875,  788,  875,  416,  547,  400,  309,  656,  416,
  402,  821, 1110,  401, 1182,  657,  309,  225,  125,  718,
  821, 1204, 1115,  311, 1014,  611, 1206,  658, 1166, 1206,
 1394,  655,  787,  454,  455,  788, 1015, 1174,  339,  875,
 1118,  884,  531,  656,  492, 1045,  220,  396,  531,  498,
  657,  396, 1109,  399,  565, 1133,  471,  500,  566,  974,
  823,  472,  658,  473, 1111, 1343,  474,  475,  122,  476,
  477,  527,  396, 1268, 1039, 1271,  400, 1344, 1430,  640,
  396, 1040, 1105,  401,  396,  361,  396,  396,  396,  396,
 1709, 1351,  991, 1265,  396, 1352,  991,  549, 1245, 1353,
  991,  579,  611,  718,  875,  790,  875,  579,  718,  875,
  718,  718,  718,  718,  718,  718,  718,  718,  718,  718,
  718, 1033, 1264,  362,   71,   71,  550, 1033,   71,  362,
  718,  718,  525,  244,  450,  451,  363,  718,  932,  718,
  932,  718,  932,  718,  718,  718,  826,  125,  452,  453,
  827,  611,  990, 1762, 1152,  640,  369,  526,  505,  352,
  396,  884,  125,  575,  551, 1530, 1410,  921, 1273,  921,
 1274,  921,  583,  381,  381, 1334,  381,  381,   64,  862,
  199,   45,  199,  863,  199,  125,  616, 1308,  381,  396,
 1784,  381,  123,  396, 1238,  381,  396,  236,  396,  239,
  578,  718,  417,  396,  925, 1565, 1806, 1807,  631,  632,
  875,  873,  875, 1565,  875,  566,  236, 1326,  241,  272,
 1619,  614,  125,  579, 1076,  213,  531,  213, 1077,  213,
  618, 1126, 1117, 1211,  122,  123,  827,  982,  626, 1619,
  123, 1339, 1333, 1456,   72, 1383,  647, 1457,   72, 1276,
  123,  645,  993,  646,  584, 1280,  993, 1206, 1652,  310,
 1653,  311,  732,  547,  995,  355,  355,  649,  995,  650,
  585,  122,  746,  748,  750,  752,  123, 1368,  884,  648,
  669,  925,  670,  441,  442,  443,  671,  666,  672,  355,
  123,  667,  728,  639, 1264,  673, 1380,  641,  907, 1236,
  908,  982,  787, 1331,  547, 1332,  419,  547,  419,  687,
 1133,  246,  912, 1413,  912,  491,  805, 1414,  350,  350,
  122,  732, 1152,  923, 1152,  923,  420,  352,  825,  187,
  122,  187,  194,  875,  194,  122,  633,  634,  263, 1409,
  421,  246,  350, 1148, 1149,  491,  123, 1445,  244,  639,
  352, 1373, 1374,  641, 1182,  547,  195,  400,  195,  422,
  423, 1060,   74, 1060,   74,  219,  188,  219,  188,  875,
 1326,  138,  325,  138,  325,  352, 1772, 1773, 1413,  424,
 1487,  828, 1414,  990,  122,  355,  355,  264,  400,  498,
  425,  122,  125,  830,  145,  122,  145,  332,  531,  332,
  485,  485,  853,  469, 1492, 1511,  486,  486, 1414,  801,
  798,  798,  585,  973,  975,  469,  858,  469,  585,  938,
  939,  875,  737,  739,  122,  859, 1492,  742,  744,  860,
 1414,  900,  696,  861,  350,  901,  469,  469,  350,  350,
  875, 1487,  547,  909,  913,  639,  911,  754,  756,  641,
  917,  355,  918, 1511,  919, 1492,  469,  801,  920, 1414,
 1577, 1578,  940,  947,  469,  948,  952,  469, 1225,  957,
  958,  954,  960,  964,  976,  123,  585,  355,  977,  352,
 1812,  995,  997,  999,  125, 1003,  406,  122, 1611,  355,
  123, 1614, 1012, 1013,  381,  611,  506,  125, 1022, 1023,
  381, 1026,  355, 1049,  350,   43, 1050, 1571,  355, 1051,
 1043,  381, 1052,  123,  747,  381,  747, 1056,  355,  125,
  507,  639, 1057,  125,  207,  641, 1078,  982,  381, 1083,
  350, 1075, 1079,  508, 1105, 1601,  531, 1100,  510,  125,
  355,  355,  350,  511, 1106,  512,  513,  514,  515, 1112,
  123, 1108, 1128,  516, 1132,  350,  578,  517,  318, 1136,
  381,  350, 1102,  122, 1143, 1145, 1571, 1154, 1159,  518,
 1150,  350,  519, 1160,  520,  355, 1163, 1164, 1162, 1167,
  355, 1170, 1172, 1195, 1183, 1196, 1199, 1205, 1214,  569,
 1231, 1688, 1547,  350,  350,  801, 1232,  352,  521,  352,
 1221, 1234, 1239, 1242, 1269, 1257, 1277, 1285, 1716, 1296,
 1283, 1284,  801,   39, 1293, 1315, 1299, 1309, 1311,  355,
  123, 1728, 1730, 1313, 1295,  801,  801, 1321,  350, 1316,
 1323, 1339,  884,  350, 1336, 1342, 1345, 1571, 1346, 1347,
 1348, 1357, 1360, 1372,  547, 1364, 1375,  355,  355, 1716,
 1716, 1376,  430,  801,  801, 1383, 1392, 1405, 1423, 1607,
 1436, 1738, 1400, 1412, 1428, 1437,   33, 1442, 1439, 1444,
 1447, 1450,  350,  431,  432,  433,  434,  435,  436,  437,
  438,  439,  440, 1460, 1451,  351,  351, 1465, 1467, 1473,
   33, 1481, 1480, 1474, 1475,  884, 1525, 1526, 1536,  352,
  350,  350,  125,   33,  125, 1529, 1716, 1532,   33,  351,
  801, 1531, 1544,   33, 1549,   33,   33,   33,   33, 1533,
  123,   33, 1575,   33, 1584, 1596, 1598,   33, 1625, 1617,
 1635,  350,  884, 1637, 1616, 1626, 1632, 1628, 1640,   33,
 1638, 1607,   33, 1642,   33, 1648, 1644, 1790, 1790, 1646,
  125, 1649, 1568,  125, 1799, 1799, 1655,  696,  696, 1656,
 1661, 1667, 1664, 1668, 1698, 1710, 1669,  506,   33, 1671,
 1811, 1679, 1680, 1711, 1683, 1693, 1700, 1713, 1714,   33,
   33, 1758, 1720, 1724, 1723, 1735, 1734,  125, 1737, 1739,
 1742,  507, 1755, 1740, 1748, 1759, 1763, 1766, 1764, 1774,
  355,  351, 1757, 1782,  508,  351,  351, 1783, 1805,  510,
 1803, 1809,  123, 1810,  511,  352,  512,  513,  514,  515,
 1814,    9,   21, 1148,  516,  123,  617, 1025,  517,  577,
 1026,  479, 1587, 1140,  749,  578,  986,  355,  530, 1041,
  518,  750,  833,  519,   35,  520,  990,  123,  576,  531,
   35,  123,   37,  350,  915,   36,  354,  925,   36, 1033,
  250,  531,  531,  917,  916,  953,  918,  123,  926,  521,
   39,  351,  954,  821,   39,  358,  821,  843,  381,  141,
  798,  352,  798,  243,  123,   39,  125,  328,   54,  148,
  350,   39,  142,  124,  329,   39,  149,  351,   39,   21,
 1258, 1177,  355, 1158,  352, 1546, 1378, 1379, 1537,  351,
   39,   39, 1576, 1725, 1756,   39,   39, 1390, 1029, 1765,
 1712,   39,  351,   39,   39,   39,   39, 1741,  351, 1562,
 1588,   39, 1591, 1542, 1631,   39, 1046,   39,  351, 1630,
 1609, 1780, 1192,  355, 1188, 1193, 1194,   39, 1802,   39,
   39, 1545,   39, 1736, 1731,  350,   39, 1729, 1793, 1468,
  351,  351,  714, 1654, 1595,  352, 1155,  598,  355, 1093,
 1230, 1469, 1066, 1213,  313,  931,   39, 1042, 1063, 1123,
 1297,  624, 1318, 1320,  352,  352,  758,  578,   39,  760,
  764,  762, 1140, 1111,  355,  351,  350,  766, 1384,  767,
  351,  922, 1550, 1453, 1362,  464, 1310, 1369, 1361, 1278,
  675, 1363,  352, 1434, 1402,  352,  785,  350, 1548, 1228,
  899,  350,  786, 1441, 1156, 1153, 1007,    0,    0,    0,
  123,    0,  123,    0,    0,    0,   33,    0,    0,  351,
    0,    0,    0,    0,   39,   39,  714,  350,    0,    0,
    0,  714,  125,  714,  714,  714,  714,  714,  714,  714,
  714,  714,  714,  714,    0,    0,    0,  351,  351,    0,
  355,    0,    0,  714,  714,    0,    0,    0,  123,    0,
  714,  123,  714,  355,  714,    0,  714,  714,  714,  728,
    0,    0,    0,  355,    0,    0,    0,    0,  351,    0,
    0,    0,  714,    0,    0,    0,    0,    0,    0,   37,
    0,    0,    0,   37,    0,  123,    0,    0,  355,    0,
    0,    0,  355,  350,   37,    0,    0,    0,    0,    0,
   37,    0,    0,    0,   37,    0,  350,   37,  125,    0,
    0,    0,    0,    0,  714,    0,  350,    0,  125,   37,
   37,    0,    0,  125,   37,   37,    0,    0,    0,    0,
   37,    0,   37,   37,   37,   37,    0,    0,    0,    0,
   37,  350,    0,    0,   37,  350,   37,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,    0,   37,
    0,   37,    0,    0,    0,   37,    0,    0,    0,    0,
    0,    0,  125,    0,    0,    0,    0,    0,    0,  125,
    0,    0,    0,  125,  123,   37,    0,    0,    0,    0,
  351,  355,  355,    0,    0,    0,  370,   37,    0,  374,
    0,    0,    0,  383,  385,  387,  389,  391,  393,  395,
  397,    0,  125,    0,    0,    0,    0,    0,    0,    0,
    0,  350,    0,    0,    0,    0,    0,  351,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  350,  350,    0,    0,    0,    0,
    0,    0,    0,   37,   37,    0,    0,    0,    0,    0,
    0,    0,   33,   33,    0,    0,    0,   33,    0,  355,
    0,   33,    0,   33,    0,  125,   33,    0,   33,   33,
    0,   33,    0,    0,   33,    0,   33,    0,   33,   33,
   33,   33,  351,    0,   33,   33,    0,    0,    0,    0,
   33,    0,   33,   33,   33,    0,    0,   33,   33,   33,
  355,   33,  355,    0,   33,    0,   33,   33,   33,   33,
   33,    0,  350,   33,   33,   33,    0,    0,   33,   33,
   33,    0,    0,  351,    0,    0,    0,   33,   33,    0,
   33,   33,    0,   33,   33,   33,    0,    0,    0,   33,
  123,  125,    0,    5,  351,  350,    0,    0,  351,    0,
    0,    0,    0,  350,    0,  350,    0,    0,    0,   33,
    0,    0,    0,    0,  161,    0,    0,    0,    0,   33,
   33,   33,    0,   33,  351,    0,    0,  123,    0,   33,
    0,    0,    0,    0,    0,    0,    0,    0,  161,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  161,  355,    0,    0,    0,  161,    0,    0,  370,
   33,  161,   33,  161,  161,  161,  161,    0,    0,    0,
   33,  161,    0,    0,    0,  161,  123,   33,   33,  161,
    0,    0,    0,    0,   33,    0,  123,  161,    0,    0,
  161,  123,  161,    0,    0,    0,    0,   33,  621,    0,
  351,    0,   33,    0,    0,  350,    0,   33,  370,   33,
   33,   33,   33,  351,    0,    0,  161,   33,    0,    0,
 1121,   33,    0,  351,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   33,    0,    0,   33,    0,   33,    0,
  123,    0,    0,    0,    0,    0,    0,  123,  351,  589,
    0,  123,  351,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   33,    0,    0,    0,    0,    0,  355,    0,
    0,    0,    0,   33,   33,    0,    0,  161,    0,    0,
  123,  716,  718,  720,    0,    0,  621,  621,  621,  621,
  621,  621,  621,  621,  621,  621,  621,  621,  621,  621,
  621,  621,    0,    0, 1121,    0,    0,    0,    0, 1121,
    0, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121,
 1121,  350,    0,    0,    0,    0,    0,    0,  351,    0,
    0, 1121, 1121,    0,  355,    0,    0,    0, 1121,    0,
 1121,    0, 1121,  123, 1121, 1121, 1121,    0,    0,    0,
    5,  351,  351,    0,   53,    0,    0,  355,    0,    0,
    0,    0,    0,    0,    0,   53,    0,    0,    0,    0,
    0,   53,    0,    0,    0,   53,    0,    0,   53,    0,
    0,    0,    0,    0,    0,    0,    0,  350,    0,    0,
   53,   53,    0,    0,    0,   53,   53,    0,    0,    0,
    0,   53, 1121,   53,   53,   53,   53,    0,    0,  621,
  350,   53,    0,    0,    0,   53,    0,   53,  355,  123,
  355,    0,    0,    0,    0,    0,    0,   53,  355,  351,
   53,    0,   53,    0,    0,    0,   53,  355,  355,    0,
  355,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   53,    0,    0,    0,
    0,    0,  351,    0,    0,  355,    0,    0,  355,    0,
  351,  350,  351,  350,    0,    0,    0,    0,    0,    0,
    0,  350, 1027,    0,    0,    0,    0,    0,    0,    0,
  350,  350,    0,  350,    0,    0,    0,    0,    0, 1594,
    0,    0,    0,    0,    0,  589,  950,    0,    0,    0,
  589,  589,    0,    0,    0,    0, 1594,    0,  350,    0,
    0,  350,    0,    0,   53,   53,    0,    0,    0, 1594,
    0,    0,    0,    0,  589,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  589,  589,    0,
    0,    0,  589, 1594,    0,  589,    0,  589,    0,  589,
  589,  589,  589,    0,  986,  987,    0,  589,    0,    0,
    0,  589,  351,    0,    0,  589,    0,    0,    0,    0,
    0,  370,    0,  589,    0,    0,  589,    0,  589,  589,
    0,    0,    0,  589,  589,    0,  589,  589,  589,  589,
  589,  589,  589,  589,  589,  589,  589,    0,    0,    0,
    0,    0,  589,  589,  589,    0,  589,  589,    0,    0,
    0,    0,  589,  589,    0,  589,  589,  589,  589,  589,
  589,  589,    0,  589,  589,    0,  589,  589,  589,  589,
  589,  589,  589,  589,  589,  589,    0,  589,  589,  589,
  589,  589,  589,  589,  589,  589,  589,  589,  589,  589,
  589,  589,  589,  589,  589,  589,  589,  589,  589,    0,
  947,  589,    0,  589,    0,  589,    0,    0,  589,    0,
    0,    0,    0,    0,    0,    0,    0,  589,  351,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  370,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1027, 1027,
    0,    0,    0,    0,    0,    0, 1027, 1027, 1027, 1027,
 1027,    0, 1027, 1027,  351, 1027, 1027, 1027, 1027, 1027,
 1027, 1027, 1027, 1027,    0,    0,    0,    0, 1027,    0,
 1027, 1027, 1027, 1027, 1027, 1027,    0,  351, 1027,  381,
    0,    0, 1027, 1027,    0, 1027, 1027, 1027,    0,    0,
    0,    0,    0,    0,    0,    0, 1027, 1027,    0, 1027,
    0, 1027, 1027,    0,    0, 1027,    0, 1027, 1027, 1027,
 1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027,    0,
 1027,    0,    0, 1027, 1027,    0,    0, 1027, 1027,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  351,    0,
  351,    0, 1027, 1027, 1027, 1027, 1027,    0,  351, 1027,
 1027, 1027,    0,    0,    0, 1027, 1027,  351,  351, 1027,
  351,    0,    0,    0, 1027, 1027, 1027, 1027, 1027,    0,
    0,    0, 1027,    0, 1027,    0,    0,    0,    0,    0,
 1027, 1027,    0,    0,    0,  351,    0,    0,  351,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1027, 1027, 1027, 1027,    0,
 1027,    0, 1027,  621,    0,    0,    0,    0,    0,    0,
 1027,    0,    0,    0,    0,    0,  947,  947,    0,    0,
    0,  381,    0,    0,  947,  947,  947,  947,  947,    0,
  947,  947,    0,  947,  947,  947,  947,  947,  947,  947,
  947,    0,    0,    0,    0,    0,  947,    0,  947,  947,
  947,  947,  947,  947,    0,    0,  947,    0,    0,    0,
  947,  947, 1241,  947,  947,  947,    0,    0, 1246,    0,
    0,    0,    0,    0,  947,  947,    0,  947,    0,  947,
  947,    0,    0,  947,    0,  947,  947,  947,  947,  947,
  947,  947,  947,  947,  947,  947,  947,    0,  947,    0,
    0,  947,  947,    0,    0,  947,  947,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  947,  947,  947,  947,  947,  381,    0,  947,  947,  947,
  381,  381,    0,  947,  947,    0,    0,  947,    0,    0,
    0,    0,  947,  947,  947,  947,  947,    0,    0,    0,
  947,    0,  947,    0,  381,    0,    0,    0,  947,  947,
    0,    0,    0,    0,    0,    0,    0,  381,  381,    0,
    0,    0,  381,  899,    0,  381,    0,  381,    0,  381,
  381,  381,  381,  947,  947,  947,  947,  381,  947,    0,
  947,  381,    0,    0,    0,  381,    0,    0,  947,    0,
    0,    0,    0,  381,    0,    0,  381,    0,  381,  381,
    0,    0,    0,  381,  381,    0,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,    0,    0,
    0,    0,  381,  381,    0,    0,  381,  381,    0,    0,
    0,    0,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,    0,  381,  381,    0,    0,  381,  381,  381,
  381,  381,    0,    0,  381,  381,    0,    0,    0,  381,
  381,  381,  381,  381,  381,  381,  381,  381,    0,    0,
    0,    0,  381,  381,    0,    0,    0,    0,  381,    0,
    0,  381,    0,  381,    0,  381,    0,    0,  381,    0,
    0,    0,    0,    0,    0,    0,  381,  381,    0,  371,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  381,
  381,    0,    0,    0,  381,    0,    0,    0,    0,  381,
    0,  381,  381,  381,  381,    0,    0,    0,    0,  381,
    0,    0,    0,  381,    0,    0,    0,  381,    0,    0,
    0,    0,    0,    0,    0,  381,    0,    0,  381,    0,
  381,  381,    0,    0,    0,  381,  381,    0,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
    0,    0,    0,    0,  381,  381,    0,    0,  381,  381,
    0,    0,    0,    0,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,    0,  381,  381,    0,    0,  381,
  381,  381,  381,  381,    0,    0,  381,  381,    0,    0,
    0,  381,  381,  381,  381,  381,  381,  381,  381,  899,
    0,    0,    0,    0,  899,  899,    0,    0,    0,    0,
  381,    0,    0,  381,    0,  381,    0,  381,    0,    0,
  381,    0,    0,    0,    0,    0,    0,    0,  899,  381,
    0,  422,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  899,  899,    0,    0,    0,  899,    0,    0,  899,
    0,  899,    0,  899,  899,  899,  899,    0,    0,    0,
    0,  899,    0,    0,    0,  899,    0,    0,    0,  899,
    0,    0,    0,    0,    0,    0,    0,  899,    0,    0,
  899,    0,  899,  899,    0,    0,    0,  899,  899,    0,
  899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
  899,    0,    0,    0,    0,    0,  899,  899,    0,    0,
  899,  899,    0,    0,    0,    0,  899,  899,  899,  899,
  899,  899,    0,  899,  899,  899,    0,  899,  899,    0,
    0,  899,  899,  899,  899,  371,    0,    0,  899,  899,
  371,  371,    0,  899,  899,  899,  899,  899,  899,  899,
  899,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  899,    0,  371,  899,    0,  899,    0,  899,
    0,    0,  899,    0,    0,    0,    0,  371,  371,    0,
    0,  899,  371,  411,    0,  371,    0,  371,    0,  371,
  371,  371,  371,    0,    0,    0,    0,  371,    0,    0,
    0,  371,    0,    0,    0,  371,    0,    0,    0,    0,
    0,    0,    0,  371,    0,    0,  371,    0,  371,  371,
    0,    0,    0,  371,  371,    0,  371,  371,  371,  371,
  371,  371,  371,  371,  371,  371,  371,    0,    0,    0,
    0,    0,  371,  371,    0,    0,  371,  371,    0,    0,
    0,    0,  371,  371,  371,  371,  371,  371,    0,  371,
  371,  371,    0,  371,  371,    0,    0,  371,  371,  371,
  371,    0,    0,    0,  371,  371,    0,    0,    0,  371,
  371,  371,  371,  371,  371,  371,  371,  422,    0,    0,
    0,    0,  422,  422,    0,    0,    0,    0,  371,    0,
    0,  371,    0,  371,    0,  371,    0,    0,  371,    0,
    0,    0,    0,    0,    0,    0,  422,  371,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  422,
  422,    0,    0,    0,  422,    0,    0,   40,    0,  422,
    0,  422,  422,  422,  422,    0,    0,    0,    0,  422,
    0,    0,    0,  422,    0,    0,    0,  422,    0,    0,
    0,    0,    0,    0,    0,  422,    0,    0,  422,    0,
  422,  422,    0,    0,    0,  422,  422,    0,  422,  422,
  422,  422,  422,  422,  422,  422,  422,  422,  422,    0,
    0,    0,    0,    0,  422,  422,    0,    0,  422,  422,
    0,    0,    0,    0,  422,  422,  422,  422,  422,  422,
    0,  422,  422,  422,    0,  422,  422,    0,    0,  422,
  422,  422,  422,    0,   26,    0,  422,  422,    0,    0,
    0,  422,  422,  422,  422,  422,  422,  422,  422,  411,
    0,    0,    0,    0,  411,  411,    0,    0,    0,    0,
  422,    0,    0,  422,    0,  422,    0,  422,    0,    0,
  422,    0,    0,    0,    0,    0,    0,    0,  411,  422,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  411,  411,    0,    0,    0,  411,    0,    0,  411,
    0,  411,    0,  411,  411,  411,  411,    0,   38,    0,
    0,  411,    0,    0,    0,  411,    0,    0,    0,  411,
    0,    0,    0,    0,    0,    0,    0,  411,    0,    0,
  411,    0,  411,  411,    0,    0,    0,  411,  411,    0,
  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,
  411,    0,    0,    0,    0,    0,  411,  411,    0,    0,
  411,  411,    0,    0,    0,    0,  411,  411,    0,  411,
  411,  411,    0,  411,  411,  411,    0,  411,  411,    0,
    0,  411,  411,  411,  411,    0,    0,    0,  411,  411,
    0,   27,    0,  411,  411,  411,  411,  411,  411,  411,
  411,    0,    0,    0,   40,    0,    0,    0,   40,    0,
    0,    0,  411,    0,    0,  411,    0,  411,    0,   40,
    0,    0,    0,    0,    0,   40,    0,    0,    0,   40,
    0,  411,   40,    0, 1129,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   40,   40,    0,    0,    0,   40,
   40,    0,   53,    0,    0,   40,    0,   40,   40,   40,
   40,    0,    0,    0,    0,   40,    0,    0,    0,   40,
    0,   40,    0,    0,    0,    0,   53,    0,    0,    0,
    0,   40,    0,   40,   40,    0,   40,    0,    0,   53,
   40,   26,    0,    0,   53,   26,    0,    0,    0,   53,
    0,   53,   53,   53,   53,    0,   26,    0,    0,   53,
   40,    0,   26,   53,    0,    0,   26,   53,    0,   26,
    0,   40,   40,    0,    0,   53,    0,    0,   53,    0,
   53,   26,   26,    0,    0,    0,   26,   26,    0,    0,
    0,    0,   26,    0,   26,   26,   26,   26,    0,    0,
    0,    0,   26,    0,   53,    0,   26,    0,   26,    0,
    7,   53,   53,    0,    0,   38,    0,    0,   26,   38,
    0,   26,    0,   26,    0,    0,    0,   26,   40,   40,
   38,    0,    0,    0,    0,    0,   38,    0,    0,    0,
   38,    0,    0,   38,    0,    0,    0,   26,    0,    0,
    0,    0,    0,    0,    0,   38,   38,   23,   26,   26,
   38,   38,    0,    0,    0,    0,   38,    0,   38,   38,
   38,   38,    0,    0,    0,    0,   38,    0,    0,    0,
   38,    0,   38,    0, 1130,    0,    0,    0,    0,    0,
    0,    0,   38,    0,    0,   38,    0,   38,   27,    0,
    0,   38,   27,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   27,    0,   26,   26,    0,    0,   27,
    0,   38,    0,   27,    0,    0,   27,    0,    0,    0,
    0,    0,   38,   38,    0,    0,    0,    0,   27,   27,
    0, 1129,    0,   27,   27,   53,    0,    0,   54,   27,
    0,   27,   27,   27,   27,    0,   53,    0,    0,   27,
    0,    0,   53,   27,    0,   27,   53,    0,    0,   53,
    0,    0,    0,    0,    0,   27,    0,    0,   27,    0,
   27,   53,   53,    0,   27,    0,   53,   53,    0,   38,
   38,    0,   53,    0,   53,   53,   53,   53,    0,    0,
    0,    0,   53,    0,   27,    0,   53,    0,   53,    0,
    0,    0,    0,    0,    0,   27,   27,    0,   53,    0,
    0,   53,    0,   53,   53,    0,    0,   53,   53,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   53,
    0,    0,    0,    0,    0,   53,    0,   53,    0,   53,
    0,    0,   53,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   53,   53,    0,    7,    0,   53,
   53,   54,   27,   27,    0,   53,    0,   53,   53,   53,
   53,    0,   54,    0,    0,   53,    0,    0,   54,   53,
    0,   53,   54,    0,    0,   54,    0,    0,    0,    0,
    0,   53,    0,    0,   53,    0,   53,   54,   54,    0,
   53,    0,   54,   54,    0,   53,   53,    0,   54,    0,
   54,   54,   54,   54,    0,    0,    0,    0,   54,    0,
   53,    0,   54,    0,   54,    0,    0,    0,    0,    0,
    0, 1130,    0,    0,   54,   53,    0,   54,    0,   54,
    0,    0,    0,   54,    0,    0,   53,    0,    0,    0,
    0,    0,   53,    0,    0,    0,   53,    0,    0,   53,
    0,    0,    0,   54,    0,    0,    0,    0,    0,    0,
    0,   53,   53,    0,    0,    0,   53,   53,    0,    0,
    0,    0,   53,    0,   53,   53,   53,   53,   53,   53,
    0,    0,   53,    0,    0,   54,   53,    0,   53,   54,
    0,    0,    0,    0,    0,    0,    0,    0,   53,    0,
   54,   53,    0,   53,    0,    0,   54,   53,    0,    0,
   54,    0,    0,   54,    0,    0,    0,    0,    0,    0,
    0,   54,   54,    0,    0,   54,   54,   53,    0,    0,
   54,   54,    0,    0,    0,    0,   54,    0,   54,   54,
   54,   54,    0,    0,    0,    0,   54,    0,    0,    0,
   54,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   54,    0,    0,   54,    0,   54,    0,    0,
    0,   54,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   54,    0,    0,   56,   53,   53,    0,    0,    0,
    0,    0,   57,   24,   58,   25,    0,    0,   26,   59,
    0,   60,   61,   27,   62,   63,   64,   65,   28,    0,
    0,    0,    0,    0,   66,    0,   67,   30,   68,   69,
   70,   71,    0,    0,   32,    0,    0,    0,   72,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,   75,   76,    0,   36,    0,   37,   77,   54,
   54,   38,    0,   78,   79,   80,   81,   82,   83,   39,
   40,   84,   85,   41,   86,    0,   87,    0,    0,   88,
   89,    0,    0,   90,   91,    0,  902,    0,    0,    0,
    0,    0,  902,    0,    0,    0,    0,    0,   92,   93,
   94,   95,   96,    0,    0,   97,   98,   99,    0,    0,
    0,  100,    0,    0,    0,  101,    0,    0,    0,    0,
  102,  103,  104,  105,  106,    0,    0,    0,  107,  902,
  108,    0,    0,    0,    0,    0,  109,  110,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  111,  112,  113,  114,    0,    0,    0,  115,    0,
  902,    0,    0,    0,    0,  902,  207,  902,  902,  902,
  902,  902,  902,  902,  902,  902,  902,  902,  902,    0,
    0,    0,    0,    0,  902,  902,    0,  902,  902,    0,
    0,    0,    0,  902,  902,  902,  902,  902,  902,  902,
  902,  902,  902,    0,  902,  902,    0,  902,  902,  902,
  902,  902,  902,  902,  902,  902,  902,    0,  902,  902,
  902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
  902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
  902,    0,  902,    0,  902,  403,  902,  902,  902,  902,
    0,    0,    0,    0,    0,    0,    0,    0,  902,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  403,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  403,    0,    0,  902,    0,  403,    0,    0,
  272,    0,  403,    0,  403,  403,  403,  403,    0,    0,
    0,    0,  403,    0,    0,    0,  403,    0,    0,    0,
  403,    0,    0,    0,    0,  381,    0,    0,  403,    0,
    0,  403,    0,  403,    0,    0,  902,    0,    0,    0,
    0,  902,    0,  902,  902,  902,  902,  902,  902,  902,
  902,  902,  902,  902,  902,    0,    0,  403,    0,    0,
  902,  902,  381,  902,  902,    0,    0,    0,  403,  902,
  902,  902,  902,  902,  902,  902,  902,  902,  902,    0,
  902,  902,    0,  902,  902,  902,  902,  902,  902,  902,
  902,  902,  902,    0,  902,  902,  902,  902,  902,  902,
  902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
  902,  902,  902,  902,  902,  902,  902,  381,  403,    0,
  902,    0,  902,  381,    0,  902,    0,    0,  381,    0,
    0,    0,    0,    0,  902,    0,    0,    0,    0,    0,
  381,  381,  381,  381,  902,    0,    0,  381,  381,    0,
    0,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,    0,    0,    0,    0,    0,    0,  381,
    0,    0,  381,    0,    0,    0,    0,    0,    0,    0,
    0,  381,    0,    0,    0,    0,  381,    0,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
    0,    0,    0,    0,    0,  381,  381,    0,  381,  381,
    0,    0,    0,    0,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,    0,  381,  381,    0,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,    0,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,    0,  381,    0,    0,  381,   53,  381,  381,    0,
  381,    0,    0,    0,    0,    0,    0,   53,    0,  381,
    0,    0,    0,   53,    0,    0,    0,   53,    0,    0,
   53,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   53,   53,    0,  381,    0,   53,   53,    0,
    0,    0,    0,   53,    0,   53,   53,   53,   53,    0,
    0,    0,    0,   53,    0,    0,    0,   53,    0,   53,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   53,
    0,    0,   53,    0,   53,    0,  381,    0,   53,    0,
    0,  381,    0,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,    0,    0,    0,   53,    0,
  381,  381,    0,  381,  381,    0,    0,    0,    0,   41,
  381,  381,  381,  381,  381,  381,  381,  381,  381,    0,
  381,  381,    0,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,    0,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,    0,  591,    0,    0,
  381,    0,  381,  591,    0,  381,   53,   53,    0,    0,
   24,    0,   25,    0,  381,   26,    0,    0,    0,    0,
   27,    0,    0,    0,    0,   28,    0,    0,    0,   29,
    0,    0,    0,    0,   30,    0,    0,    0,    0,   31,
  591,   32,    0,    0,    0,    0,   33,    0,    0,    0,
   34,   35,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,    0,    0,    0,   38,    0,
    0,    0,    0,    0,    0,    0,   39,   40,    0,    0,
   41,  591,    0,   42,    0,    0,  591,    0,  591,  591,
  591,  591,  591,  591,  591,  591,  591,  591,  591,  935,
    0,    0,    0,    0,    0,    0,  591,    0,  591,  591,
    0,    0,    0,    0,  591,  591,  591,  591,  591,  591,
  591,  591,  591,  591,    0,  591,  591,    0,  591,  591,
  591,  591,  591,  591,  591,  591,  591,  591,    0,  591,
  591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
  591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
  591,    0,  587,    0,    0,    0,    0,  591,  587,   43,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  591,
    0,    0,    0,  935,    0,    0,    0,    0,  935,    0,
  935,  935,  935,  935,  935,  935,  935,  935,  935,  935,
  935,    0,    0,    0,    0,  587,    0,    0,    0,    0,
  935,  935,    0,    0,    0,    0,    0,  935,    0,  935,
    0,  935,    0,  935,  935,  935,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  587,    0,    0,    0,
    0,  587,    0,  587,  587,  587,  587,  587,  587,  587,
  587,  587,  587,  587,    0,    0,    0,    0,    0,    0,
    0,  587,    0,  587,  587,    0,    0,    0,    0,  587,
  587,  935,  587,  587,  587,  587,  587,  587,  587,    0,
  587,  587,    0,  587,  587,  587,  587,  587,  587,  587,
  587,  587,  587,    0,  587,  587,  587,  587,  587,  587,
  587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
  587,  587,  587,  587,  587,  587,    0,  595,    0,    0,
    0,   53,  587,  595,    0,  587,    0,    0,    0,    0,
    0,    0,   53,    0,  587,    0,    0,    0,   53,    0,
    0,    0,   53,    0,    0,   53,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   53,   53,    0,
  595,    0,   53,   53,    0,    0,    0,    0,   53,    0,
   53,   53,   53,   53,    0,    0,    0,    0,   53,    0,
    0,    0,   53,    0,   53,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   53,    0,    0,   53,    0,   53,
    0,  595,    0,   53,    0,    0,  595,    0,  595,  595,
  595,  595,  595,  595,  595,  595,  595,  595,  595,    0,
    0,    0,    0,   53,    0,    0,  595,    0,  595,  595,
    0,    0,    0,    0,   42,  595,    0,  595,  595,  595,
  595,  595,  595,  595,    0,  595,  595,    0,  595,  595,
  595,  595,  595,  595,  595,  595,  595,  595,    0,  595,
  595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
  595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
  595,    0,  381,    0,    0,  402,    0,  595,  381,    0,
  595,   53,   53,    0,    0,    0,    0,    0,    0,  595,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  402,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  402,    0,    0,  381,    0,  402,    0,    0,
  271,    0,  402,    0,  402,  402,  402,  402,    0,    0,
    0,    0,  402,    0,    0,    0,  402,    0,    0,    0,
  402,    0,    0,    0,    0,    0,    0,    0,  402,    0,
    0,  402,    0,  402,    0,    0,  381,    0,    0,    0,
    0,  381,    0,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,    0,    0,    0,  402,    0,    0,
    0,  381,    0,  381,  381,    0,    0,    0,  402,    0,
  381,    0,  381,  381,  381,  381,  381,  381,  381,    0,
  381,  381,    0,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,    0,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,    0,  512,  402,    0,
    0,   53,  381,  512,    0,  381,    0,    0,    0,    0,
    0,    0,    0,    0,  381,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   53,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   53,    0,
  512,    0,    0,   53,    0,    0,    0,    0,   53,    0,
   53,   53,   53,   53,    0,    0,    0,    0,   53,    0,
    0,    0,   53,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   53,    0,    0,   53,    0,   53,
    0,  512,    0,    0,    0,    0,  512,    0,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,    0,
    0,  711,    0,   53,    0,    0,  512,    0,  512,  512,
   53,   53,    0,    0,  237,  512,    0,  512,  512,  512,
  512,  512,  512,  512,    0,  512,  512,    0,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,    0,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,    0,  623,    0,    0,    0,    0,  512,  623,    0,
  512,    0,    0,    0,    0,    0,    0,    0,    0,  512,
    0,    0,    0,    0,    0,  711,    0,    0,    0,    0,
  711,    0,  711,  711,  711,  711,  711,  711,  711,  711,
  711,  711,  711,    0,    0,  623,    0,    0,    0,    0,
    0,    0,  711,  711,    0,    0,    0,    0,    0,  711,
    0,  711,    0,  711,    0,  711,  711,  711,    0,    0,
    0,    0,    0,  381,    0,    0,    0,    0,    0,  381,
    0,  711,    0,  902,    0,    0,  623,    0,    0,    0,
    0,  623,  711,  623,  623,  623,  623,  623,  623,  623,
  623,  623,  623,  623,  711,    0,    0,    0,    0,    0,
    0,    0,    0,  623,  623,    0,  381,    0,    0,    0,
  623,    0,  623,  711,  623,    0,  623,  623,  623,    0,
  623,  623,  902,  623,  623,  623,  623,  623,  623,  623,
  623,  623,  623,    0,    0,    0,  623,  623,  623,  623,
  623,  623,  623,  623,  623,  623,  623,  623,  623,  623,
  623,  623,  623,  623,    0,  623,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  381,    0,    0,    0,    0,
    0,  381,  381,    0,  623,    0,    0,    0,    0,    0,
    0,  381,  381,  381,  381,  381,  381,  381,  902,  381,
    0,  381,  381,    0,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,    0,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,    0,  371,    0,
    0,  381,   53,  381,  371,    0,  381,    0,    0,    0,
    0,    0,    0,    0,    0,  381,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   53,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   53,
    0,  371,    0,    0,   53,    0,    0,    0,    0,   53,
    0,   53,   53,   53,   53,    0,    0,    0,    0,   53,
    0,    0,    0,   53,    0,  445,    0,    0,    0,    0,
    0,  445,    0,    0,    0,   53,    0,    0,   53,    0,
   53,    0,  371,    0,    0,    0,    0,  371,    0,  371,
  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
    0,    0,    0,    0,   53,    0,  371,  445,  445,  371,
  371,   53,   53,    0,    0,  239,  371,  371,  371,  445,
  371,  445,  371,  371,  371,    0,  371,  371,    0,    0,
  371,  371,  371,  371,    0,    0,    0,  371,  371,    0,
  445,  445,  371,  371,  371,  371,  371,  371,  371,  371,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  445,  371,    0,    0,    0,    0,  371,    0,  445,    0,
    0,  445,    0,  371,  445,    0,    0,    0,    0,    0,
  371,    0,    0,  445,  371,  445,  445,  445,  445,  445,
  445,  445,    0,  445,  445,    0,  445,  445,  445,  445,
  445,    0,  445,  445,  445,  445,    0,  445,  445,  445,
  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,
  445,  445,  445,  445,  445,  445,  445,  445,  445,    0,
  666,    0,   53,  371,    0,  445,  666,    0,  445,    0,
    0,    0,    0,    0,    0,    0,    0,  445,    0,    0,
    0,    0,    0,    0,    0,    0,   53,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   53,
    0,    0,    0,  666,   53,    0,    0,    0,    0,   53,
    0,   53,   53,   53,   53,    0,    0,   53,    0,   53,
    0,    0,    0,   53,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   53,    0,    0,   53,    0,
   53,    0,    0,    0,  666,    0,    0,    0,    0,  666,
    0,  666,  666,  666,  666,  666,  666,  666,  666,  666,
  666,  666,    0,    0,   53,    0,    0,    0,    0,  446,
  670,  666,  666,    0,    0,  338,  670,    0,  666,    0,
  666,  446,  666,  446,  666,  666,  666,    0,  666,  666,
    0,    0,  666,  666,  666,  666,    0,    0,    0,  666,
  666,    0,  446,  446,  666,  666,  666,  666,  666,  666,
  666,  666,    0,  670,    0,    0,    0,    0,    0,    0,
    0,    0,  446,  666,    0,    0,    0,    0,    0,    0,
  446,    0,    0,  446,    0,    0,    0,    0,    0,    0,
    0,    0,  666,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  670,    0,    0,    0,    0,  670,
    0,  670,  670,  670,  670,  670,  670,  670,  670,  670,
  670,  670,    0,    0,    0,    0,    0,    0,    0,  449,
  669,  670,  670,    0,    0,    0,  669,    0,  670,    0,
  670,  449,  670,  449,  670,  670,  670,    0,  670,  670,
    0,    0,  670,  670,  670,  670,    0,    0,    0,  670,
  670,    0,  449,  449,  670,  670,  670,  670,  670,  670,
  670,  670,    0,  669,    0,    0,    0,    0,    0,    0,
    0,    0,  449,  670,    0,    0,    0,    0,    0,    0,
  449,    0,    0,  449,    0,    0,    0,    0,    0,    0,
    0,    0,  670,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  669,    0,    0,    0,    0,  669,
    0,  669,  669,  669,  669,  669,  669,  669,  669,  669,
  669,  669,    0,    0,    0,    0,    0,    0,    0,  459,
  371,  669,  669,    0,    0,    0,  371,    0,  669,    0,
  669,  459,  669,  459,  669,  669,  669,    0,  669,  669,
    0,    0,  669,  669,  669,  669,    0,    0,    0,  669,
  669,    0,  459,  459,  669,  669,  669,  669,  669,  669,
  669,  669,    0,  371,    0,    0,    0,    0,    0,    0,
    0,    0,  459,  669,    0,    0,    0,    0,    0,    0,
  459,    0,    0,  459,    0,    0,    0,    0,    0,    0,
    0,    0,  669,    0,    0,    0,    0,    0,    0,    0,
  646,    0,    0,    0,  371,    0,  646,    0,    0,  371,
    0,  371,  371,  371,  371,  371,  371,  371,  371,  371,
  371,  371,    0,    0,    0,    0,    0,    0,  371,    0,
    0,  371,  371,    0,    0,    0,    0,    0,  371,  371,
  371,    0,  371,  646,  371,  371,  371,    0,  371,  371,
    0,    0,  371,  371,  371,  371,    0,    0,    0,  371,
  371,    0,    0,    0,  371,  371,  371,  371,  371,  371,
  371,  371,    0,  889,    0,    0,    0,    0,    0,  889,
    0,    0,    0,  371,  646,    0,    0,    0,  371,  646,
    0,  646,  646,  646,  646,  646,  646,  646,  646,  646,
  646,  646,  371,    0,    0,    0,    0,    0,    0,    0,
    0,  646,  646,    0,    0,    0,  889,    0,  646,    0,
  646,    0,  646,    0,  646,  646,  646,    0,  646,  646,
    0,    0,  646,  646,  646,  646,  646,  646,  646,  646,
  646,    0,    0,    0,  646,  646,  646,  646,  646,  646,
  646,  646,    0,  653,    0,    0,    0,  889,    0,  653,
    0,    0,  889,  646,  889,  889,  889,  889,  889,  889,
  889,  889,  889,  889,  889,    0,    0,    0,    0,    0,
    0,  889,  646,    0,  889,  889,    0,    0,    0,    0,
    0,  889,    0,  889,    0,  889,  653,  889,  889,  889,
    0,  889,  889,    0,    0,  889,  889,  889,  889,    0,
    0,    0,  889,  889,    0,    0,    0,  889,  889,  889,
  889,  889,  889,  889,  889,    0, 1033,    0,    0,    0,
    0,    0, 1033,    0,    0,    0,  889,  653,    0,    0,
    0,  889,  653,    0,  653,  653,  653,  653,  653,  653,
  653,  653,  653,  653,  653,  889,    0,    0,    0,    0,
    0,    0,    0,    0,  653,  653,    0,    0,    0, 1033,
    0,  653,    0,  653,    0,  653,    0,  653,  653,  653,
    0,  653,  653,    0,    0,  653,  653,  653,  653,    0,
    0,    0,  653,  653,    0,    0,    0,  653,  653,  653,
  653,  653,  653,  653,  653,    0,  654,    0,    0,    0,
 1033,    0,  654,    0,    0, 1033,  653, 1033, 1033, 1033,
 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033,    0,    0,
    0,    0,    0,    0,    0,  653,    0, 1033, 1033,    0,
    0,    0,    0,    0, 1033,    0, 1033,    0, 1033,  654,
 1033, 1033, 1033,    0, 1033, 1033,    0,    0, 1033, 1033,
 1033, 1033,    0,    0,    0, 1033, 1033,    0,    0,    0,
 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033,    0,  655,
    0,    0,    0,    0,    0,  655,    0,    0,    0, 1033,
  654,    0,    0,    0,    0,  654,    0,  654,  654,  654,
  654,  654,  654,  654,  654,  654,  654,  654, 1033,    0,
    0,    0,    0,    0,    0,    0,    0,  654,  654,    0,
    0,    0,  655,    0,  654,    0,  654,    0,  654,    0,
  654,  654,  654,    0,  654,  654,    0,    0,  654,  654,
  654,  654,    0,    0,    0,  654,  654,    0,    0,    0,
  654,  654,  654,  654,  654,  654,  654,  654,    0,    0,
    0,    0,    0,  655,    0,    0,    0,    0,  655,  654,
  655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
  655,    0,    0,    0,    0,    0,    0,    0,  654,    0,
  655,  655,    0,    0,    0,    0,    0,  655,    0,  655,
    0,  655,    0,  655,  655,  655,    0,  655,  655,    0,
    0,  655,  655,  655,  655,    0,    0,    0,  655,  655,
    0,    0,    0,  655,  655,  655,  655,  655,  655,  655,
  655,    0,  554,    0,  680,    0,    0,    0,    0,    0,
   57,   24,  655,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
    0,  655,   66,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,  680,    0,
    0,    0,    0,  680,    0,  680,  680,  680,  680,  680,
  680,  680,  680,  680,  680,  680,   92,   93,   94,  269,
  555,  681,    0,   97,   98,  680,  680,    0,    0,    0,
    0,    0,  680,  320,  680,    0,  680,    0,  680,  680,
  680,    0,    0,    0,    0,    0,  680,  680,  680,  680,
    0,    0,    0,  680,  680,    0,    0,    0,  680,  680,
  680,  680,  680,  680,  680,  680,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  680,    0,  111,
  556,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  557,  558,    0,  680,  682,    0,    0,
    0,    0,    0,    0,    0,  681,    0,    0,    0,    0,
  681,    0,  681,  681,  681,  681,  681,  681,  681,  681,
  681,  681,  681,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  681,  681,    0,    0,    0,    0,    0,  681,
    0,  681,    0,  681,    0,  681,  681,  681,    0,    0,
    0,    0,    0,  681,  681,  681,  681,    0,    0,    0,
  681,  681,    0,    0,    0,  681,  681,  681,  681,  681,
  681,  681,  681,  685,    0,    0,    0,    0,    0,    0,
    0,  682,    0,    0,  681,    0,  682,    0,  682,  682,
  682,  682,  682,  682,  682,  682,  682,  682,  682,    0,
    0,    0,    0,  681,    0,    0,    0,    0,  682,  682,
    0,    0,    0,    0,    0,  682,    0,  682,    0,  682,
    0,  682,  682,  682,    0,    0,    0,    0,    0,  682,
  682,  682,  682,    0,    0,    0,  682,  682,    0,    0,
    0,  682,  682,  682,  682,  682,  682,  682,  682,  686,
    0,    0,    0,    0,    0,    0,    0,  685,    0,    0,
  682,    0,  685,    0,  685,  685,  685,  685,  685,  685,
  685,  685,  685,  685,  685,    0,    0,    0,    0,  682,
    0,    0,    0,    0,  685,  685,    0,    0,    0,    0,
    0,  685,    0,  685,    0,  685,    0,  685,  685,  685,
    0,    0,    0,    0,    0,  685,  685,  685,  685,    0,
    0,    0,  685,  685,    0,    0,    0,    0,    0,  685,
  685,  685,  685,  685,  685,  687,    0,    0,    0,    0,
    0,    0,    0,  686,    0,    0,  685,    0,  686,    0,
  686,  686,  686,  686,  686,  686,  686,  686,  686,  686,
  686,    0,    0,    0,    0,  685,    0,    0,    0,    0,
  686,  686,    0,    0,    0,    0,    0,  686,    0,  686,
    0,  686,    0,  686,  686,  686,    0,    0,    0,    0,
    0,  686,  686,  686,  686,    0,    0,    0,  686,  686,
    0,    0,    0,    0,    0,  686,  686,  686,  686,  686,
  686,  688,    0,    0,    0,    0,    0,    0,    0,  687,
    0,    0,  686,    0,  687,    0,  687,  687,  687,  687,
  687,  687,  687,  687,  687,  687,  687,    0,    0,    0,
    0,  686,    0,    0,    0,    0,  687,  687,    0,    0,
    0,    0,    0,  687,    0,  687,    0,  687,    0,  687,
  687,  687,    0,    0,    0,    0,    0,  687,  687,  687,
  687,    0,    0,    0,  687,  687,    0,    0,    0,    0,
    0,  687,  687,  687,  687,  687,  687,  689,    0,    0,
    0,    0,    0,    0,    0,  688,    0,    0,  687,    0,
  688,    0,  688,  688,  688,  688,  688,  688,  688,  688,
  688,  688,  688,    0,    0,    0,    0,  687,    0,    0,
    0,    0,  688,  688,    0,    0,    0,    0,    0,  688,
    0,  688,    0,  688,    0,  688,  688,  688,    0,    0,
    0,    0,    0,  688,  688,  688,  688,  381,    0,    0,
  688,  688,    0,  381,    0,    0,    0,  688,  688,  688,
  688,  688,  688,    0,    0,    0,    0,    0,    0,    0,
    0,  689,    0,    0,  688,    0,  689,    0,  689,  689,
  689,  689,  689,  689,  689,  689,  689,  689,  689,    0,
  381,    0,    0,  688,    0,    0,    0,    0,  689,  689,
    0,    0,    0,    0,    0,  689,    0,  689,    0,  689,
    0,  689,  689,  689,    0,    0,    0,    0,    0,  689,
  689,  689,  689,    0,    0,    0,  689,  689,    0,    0,
    0,    0,    0,  689,  689,  689,  689,  689,  689,  694,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  689,    0,    0,    0,    0,    0,  381,    0,    0,    0,
    0,    0,    0,    0,    0,  381,    0,    0,  381,  689,
  381,  381,    0,    0,    0,  381,  381,    0,    0,  381,
  381,  381,  381,  381,  381,  381,  381,  381,    0,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  381,
  381,    0,  695,    0,    0,    0,    0,  381,    0,    0,
  381,    0,    0,  694,    0,    0,    0,    0,  694,  381,
  694,  694,  694,  694,  694,  694,  694,  694,  694,  694,
  694,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  694,  694,    0,    0,    0,    0,    0,  694,    0,  694,
    0,  694,    0,  694,  694,  694,    0,    0,    0,    0,
    0,    0,    0,  694,  694,    0,    0,    0,  694,  694,
    0,    0,    0,    0,    0,  696,    0,  694,  694,  694,
  694,    0,    0,    0,    0,    0,  695,    0,    0,    0,
    0,  695,  694,  695,  695,  695,  695,  695,  695,  695,
  695,  695,  695,  695,    0,    0,    0,    0,    0,    0,
    0,  694,    0,  695,  695,    0,    0,    0,    0,    0,
  695,    0,  695,    0,  695,    0,  695,  695,  695,    0,
    0,    0,    0,    0,    0,    0,  695,  695,    0,    0,
    0,  695,  695,    0,    0,    0,    0,    0,  699,    0,
  695,  695,  695,  695,    0,    0,    0,    0,    0,  696,
    0,    0,    0,    0,  696,  695,  696,  696,  696,  696,
  696,  696,  696,  696,  696,  696,  696,    0,    0,    0,
    0,    0,    0,    0,  695,    0,  696,  696,    0,    0,
    0,    0,    0,  696,    0,  696,    0,  696,    0,  696,
  696,  696,    0,    0,    0,    0,    0,    0,    0,  696,
  696,    0,    0,    0,  696,  696,    0,    0,    0,    0,
    0,  700,    0,  696,  696,  696,  696,    0,    0,    0,
    0,    0,  699,    0,    0,    0,    0,  699,  696,  699,
  699,  699,  699,  699,  699,  699,  699,  699,  699,  699,
    0,    0,    0,    0,    0,    0,    0,  696,    0,  699,
  699,    0,    0,    0,    0,    0,  699,    0,  699,    0,
  699,    0,  699,  699,  699,    0,    0,    0,    0,    0,
    0,    0,  699,  699,    0,    0,    0,  699,  699,    0,
    0,    0,    0,    0,  702,    0,    0,    0,  699,  699,
    0,    0,    0,    0,    0,  700,    0,    0,    0,    0,
  700,  699,  700,  700,  700,  700,  700,  700,  700,  700,
  700,  700,  700,    0,    0,    0,    0,    0,    0,    0,
  699,    0,  700,  700,    0,    0,    0,    0,    0,  700,
    0,  700,    0,  700,    0,  700,  700,  700,    0,    0,
    0,    0,    0,    0,    0,  700,  700,    0,    0,    0,
  700,  700,    0,    0,    0,    0,    0,  703,    0,    0,
    0,  700,  700,    0,    0,    0,    0,    0,  702,    0,
    0,    0,    0,  702,  700,  702,  702,  702,  702,  702,
  702,  702,  702,  702,  702,  702,    0,    0,    0,    0,
    0,    0,    0,  700,    0,  702,  702,    0,    0,    0,
    0,    0,  702,    0,  702,    0,  702,    0,  702,  702,
  702,    0,    0,    0,    0,    0,    0,    0,    0,  702,
    0,    0,    0,  702,  702,    0,    0,    0,    0,    0,
  705,    0,    0,    0,  702,  702,    0,    0,    0,    0,
    0,  703,    0,    0,    0,    0,  703,  702,  703,  703,
  703,  703,  703,  703,  703,  703,  703,  703,  703,    0,
    0,    0,    0,    0,    0,    0,  702,    0,  703,  703,
    0,    0,    0,    0,    0,  703,    0,  703,    0,  703,
    0,  703,  703,  703,    0,    0,    0,    0,    0,    0,
    0,    0,  703,    0,    0,    0,  703,  703,    0,    0,
    0,    0,    0,  706,    0,    0,    0,  703,  703,    0,
    0,    0,    0,    0,  705,    0,    0,    0,    0,  705,
  703,  705,  705,  705,  705,  705,  705,  705,  705,  705,
  705,  705,    0,    0,    0,    0,    0,    0,    0,  703,
    0,  705,  705,    0,    0,    0,    0,    0,  705,    0,
  705,    0,  705,    0,  705,  705,  705,    0,    0,    0,
    0,    0,    0,    0,    0,  705,    0,    0,    0,    0,
  705,    0,    0,    0,    0,    0,  708,    0,    0,    0,
  705,  705,    0,    0,    0,    0,    0,  706,    0,    0,
    0,    0,  706,  705,  706,  706,  706,  706,  706,  706,
  706,  706,  706,  706,  706,    0,    0,    0,    0,    0,
    0,    0,  705,    0,  706,  706,    0,    0,    0,    0,
    0,  706,    0,  706,    0,  706,    0,  706,  706,  706,
    0,    0,    0,    0,    0,    0,    0,    0,  706,    0,
    0,    0,    0,  706,    0,    0,    0,    0,    0,  709,
    0,    0,    0,  706,  706,    0,    0,    0,    0,    0,
  708,    0,    0,    0,    0,  708,  706,  708,  708,  708,
  708,  708,  708,  708,  708,  708,  708,  708,    0,    0,
    0,    0,    0,    0,    0,  706,    0,  708,  708,    0,
    0,    0,    0,    0,  708,    0,  708,    0,  708,    0,
  708,  708,  708,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  708,    0,    0,    0,
    0,    0,  712,    0,    0,    0,  708,  708,    0,    0,
    0,    0,    0,  709,    0,    0,    0,    0,  709,  708,
  709,  709,  709,  709,  709,  709,  709,  709,  709,  709,
  709,    0,    0,    0,    0,    0,    0,    0,  708,    0,
  709,  709,    0,    0,    0,    0,    0,  709,    0,  709,
    0,  709,    0,  709,  709,  709,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  709,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  709,
  709,    0,    0,    0,    0,    0,  712,    0,    0,    0,
    0,  712,  709,  712,  712,  712,  712,  712,  712,  712,
  712,  712,  712,  712,    0,    0,    0,    0,    0,    0,
    0,  709,    0,  712,  712,    0,    0,    0,    0,    0,
  712,    0,  712,    0,  712,    0,  712,  712,  712,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  227,    0,  712,    0,    0,  227,    0,    0,    0,  227,
    0,  227,    0,  712,  227,    0,  227,  227,    0,  227,
    0,    0,  227,    0,  227,  712,  227,  227,  227,  227,
    0,    0,  227,  227,    0,  212,    0,    0,  227,    0,
  227,  227,  227,    0,  712,  227,    0,  227,  213,  227,
    0,    0,  227,    0,  227,  227,  227,  227,  227,    0,
    0,  227,  227,  227,  381,    0,  227,  227,  227,    0,
    0,    0,    0,    0,    0,  227,  227,  214,  227,  227,
    0,  227,  227,  227,    0,    0,    0,  227,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  381,    0,    0,    0,    0,    0,  227,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  227,  227,  227,
    0,  227,    0,    0,    0,    0,    0,  227,    0,    0,
    0,    0,  215,  216,  217,  218,    0,  219,  220,  221,
  222,  223,  224,  225,  226,    0,    0,  227,  228,  229,
  230,  231,  232,  233,  234,    0,    0,    0,    0,    0,
  381,    0,    0,    0,    0,    0,    0,  381,  227,    0,
    0,    0,    0,    0,    0,  227,  227,  381,    0,  381,
  381,  381,  381,    0,    0,    0,  381,  381,    0,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,    0,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
  381,  381,    0,    0,  635,    0,  381,    0,  381,    0,
    0,  381,   57,   24,   58,   25, 1301,    0,   26,   59,
  381,   60,   61,   27,   62,   63,   64,   65,   28,    0,
    0,    0,    0,    0,   66,    0,   67,   30,   68,   69,
   70,   71,    0,    0,   32,    0,    0,    0,   72,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,   75,   76,    0,   36,    0,   37,   77,    0,
    0,   38,    0,   78,   79,   80,   81,   82,   83,   39,
   40,   84,   85,   41,   86,    0,   87,    0,    0,   88,
   89,    0,    0,   90,   91,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,   95,   96,    0,    0,   97,   98,   99,    0,    0,
    0,  100,    0,    0,    0,  101,    0,    0,    0,    0,
  102,  103,  104,  105,  106,    0,    0,    0,  107,    0,
  108,    0,    0,    0,    0,    0,  109,  110,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  111,  112,  113,  114,   56, 1302,    0,  115,    0,
    0,    0,    0,   57,   24,   58,   25,    0,    0,   26,
   59,    0,   60,   61,   27,   62,   63,   64,   65,   28,
    0,    0,    0,    0,    0,   66,    0,   67,   30,   68,
   69,   70,   71,    0,    0,   32,    0,    0,    0,   72,
   33,    0,   73,   74,   34,    0,    0,    0,    0,    0,
    0,    0,    0,   75,   76,    0,   36,    0,   37,   77,
    0,    0,   38,    0,   78,   79,   80,   81,   82,   83,
   39,   40,   84,   85,   41,   86,    0,   87,    0,    0,
   88,   89,    0,    0,   90,   91,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   92,
   93,   94,   95,   96,    0,    0,   97,   98,   99,    0,
    0,    0,  100,    0,    0,    0,  101,    0,    0,    0,
    0,  102,  103,  104,  105,  106,    0,    0,    0,  107,
    0,  108,    0,    0,    0,    0,    0,  109,  110,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  111,  112,  113,  114,  280,    0,    0,  115,
    0,    0,    0,    0,   57,   24,   58,   25,    0,    0,
   26,   59,    0,   60,   61,   27,   62,   63,   64,   65,
   28,    0,    0,    0,    0,    0,   66,    0,   67,   30,
   68,   69,   70,   71,    0,    0,   32,    0,    0,    0,
   72,   33,    0,   73,   74,   34,    0,    0,    0,    0,
    0,    0,    0,    0,   75,   76,    0,   36,    0,   37,
   77,    0,    0,   38,    0,   78,   79,   80,   81,   82,
   83,   39,   40,   84,   85,   41,   86,    0,   87,    0,
    0,   88,   89,    0,    0,   90,   91,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,   95,   96,    0,    0,   97,   98,   99,
    0,    0,    0,  100,    0,    0,    0,  101,    0,    0,
    0,    0,  102,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,    0,    0,    0,  109,  110,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  111,  112,  113,  114,  635,    0,    0,
  115,    0,    0,    0,    0,   57,   24,   58,   25,    0,
    0,   26,   59,    0,   60,   61,   27,   62,   63,   64,
   65,   28,    0,    0,    0,    0,    0,   66,    0,   67,
   30,   68,   69,   70,   71,    0,    0,   32,    0,    0,
    0,   72,   33,    0,   73,   74,   34,    0,    0,    0,
    0,    0,    0,    0,    0,   75,   76,    0,   36,    0,
   37,   77,    0,    0,   38,    0,   78,   79,   80,   81,
   82,   83,   39,   40,   84,   85,   41,   86,    0,   87,
    0,    0,   88,   89,    0,    0,   90,   91,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   92,   93,   94,   95,   96,    0,    0,   97,   98,
   99,    0,    0,    0,  100,    0,    0,    0,  101,    0,
    0,    0,    0,  102,  103,  104,  105,  106,    0,    0,
    0,  107,    0,  108,    0,    0,    0,    0,    0,  109,
  110,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  111,  112,  113,  114, 1126,    0,
    0,  115,    0,    0,    0,    0, 1126, 1126, 1126, 1126,
    0,    0, 1126, 1126,    0, 1126, 1126, 1126, 1126, 1126,
 1126, 1126, 1126,    0,    0,    0,    0,    0, 1126,    0,
 1126, 1126, 1126, 1126, 1126, 1126,    0,    0, 1126,    0,
    0,    0, 1126, 1126,    0, 1126, 1126, 1126,    0,    0,
    0,    0,    0,    0,    0,    0, 1126, 1126,    0, 1126,
    0, 1126, 1126,    0,    0, 1126,    0, 1126, 1126, 1126,
 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126,    0,
 1126,    0,    0, 1126, 1126,    0,    0, 1126, 1126,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1126, 1126, 1126, 1126, 1126,    0,    0, 1126,
 1126, 1126,    0,    0,    0, 1126,    0,    0,    0, 1126,
    0,    0,    0,    0, 1126, 1126, 1126, 1126, 1126,    0,
    0,    0, 1126,    0, 1126,    0,    0,    0,    0,    0,
 1126, 1126,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  690,    0,    0, 1126, 1126, 1126, 1126,    0,
   57,   24, 1126,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
    0,    0,   66,    0,    0,   30,    0,    0,    0,    0,
    0,  691,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,  692,    0,    0,    0,    0,    0,    0,
  693,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,  694,    0,
    0,   90,   91,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,   95,
   96,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  320,    0,    0,  695,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,    0,    0,    0,  109,  110,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1121,    0,    0,  111,
  112,  113,  114,    0,   57,   24,  115,   25,    0,    0,
   26,  267,    0,    0,    0,   27,   62,   63,   64,    0,
   28,    0,    0,    0,    0,    0,   66,    0,    0,   30,
    0,    0,    0,    0,    0,  691,   32,    0,    0,    0,
    0,   33,    0,   73,   74,   34,    0,  692,    0,    0,
    0,    0,    0,    0,  693,    0,    0,   36,    0,   37,
   77,    0,    0,   38,    0,    0,   79,    0,   81,    0,
   83,   39,   40,  268,    0,   41,    0,    0,    0,    0,
    0,    0,  694,    0,    0,   90,   91,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,   95,   96,    0,    0,   97,   98,   99,
    0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
    0,    0,    0,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,    0,    0,    0,  109,  110,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  882,    0,    0,  111,  112,  113,  114,    0,   57,   24,
  115,   25,    0,    0,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,    0,    0,    0,    0,    0,
   66,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   73,   74,   34,
    0,    0,    0,    0,    0,    0,    0,    0,  318,    0,
    0,   36,    0,   37,   77, 1124,    0,   38,    0,    0,
   79,    0,   81,    0,   83,   39,   40,  268,    0,   41,
    0,    0,    0,    0,    0,    0,   89,    0,    0,   90,
   91,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,   95,  319,    0,
    0,   97,   98,   99,    0,    0,    0,  575,    0,    0,
    0,  320,    0,    0,    0,    0,    0,  103,  104,  105,
  106,    0,    0,    0,  107,    0,  108,    0,    0,    0,
    0,    0,  109,  110,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1137,    0,    0,  111,  321,  113,
  114,    0,   57,   24,  115,   25,    0,    0,   26,  267,
    0,    0,    0,   27,   62,   63,   64,    0,   28,    0,
    0,    0,    0,    0,   66,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   77,  768,
    0,   38,    0,    0,   79, 1138,   81,    0,   83,   39,
   40,  268,    0,   41,    0,    0,    0,    0,    0,    0,
   89,    0,    0,   90,   91,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,   95,  319,    0,    0,   97,   98,   99,    0,    0,
    0,    0, 1139,    0,    0,  320,    0,    0,    0,    0,
    0,  103,  104,  105,  106,    0,    0,    0,  107,    0,
  108,    0,    0,    0,    0,    0,  109,  110,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  882,    0,
    0,  111,  321,  113,  114,    0,   57,   24,  115,   25,
    0,    0,   26,  267,    0,    0,    0,   27,   62,   63,
   64,    0,   28,    0,    0,    0,    0,    0,   66,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   73,   74,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   77,    0,    0,   38,    0,    0,   79,    0,
   81,    0,   83,   39,   40,  268,    0,   41,    0,    0,
    0,    0,    0,    0,   89,    0,    0,   90,   91,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   92,   93,   94,   95,  319,    0,    0,   97,
   98,   99,    0,    0,    0,  575,  883,    0,    0,  320,
    0,    0,    0,    0,    0,  103,  104,  105,  106,    0,
    0,    0,  107,    0,  108,    0,    0,    0,    0,    0,
  109,  110,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  317,    0,    0,  111,  321,  113,  114,    0,
   57,   24,  115,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
    0,    0,   66,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
  318,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,   89,    0,
    0,   90,   91,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,   95,
  319,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  320,    0,    0,    0,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,    0,    0,    0,  109,  110,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  329,    0,    0,  111,
  321,  113,  114,    0,   57,   24,  115,   25,    0,    0,
   26,  267,    0,    0,    0,   27,   62,   63,   64,    0,
   28,    0,    0,    0,    0,    0,   66,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   73,   74,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   77,    0,    0,   38,    0,    0,   79,    0,   81,    0,
   83,   39,   40,  268,    0,   41,    0,    0,    0,    0,
    0,    0,   89,    0,    0,   90,   91,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,   95,  319,    0,    0,   97,   98,   99,
    0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
    0,    0,  330,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,    0,    0,    0,  109,  110,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  844,    0,    0,  111,  321,  113,  114,    0,   57,   24,
  115,   25,    0,    0,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,    0,    0,    0,    0,    0,
   66,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   73,   74,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   77,    0,    0,   38,    0,    0,
   79,    0,   81,    0,   83,   39,   40,  268,    0,   41,
    0,    0,   87,    0,    0,    0,   89,    0,    0,   90,
   91,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,   95,  319,    0,
    0,   97,   98,   99,    0,    0,    0,    0,    0,    0,
    0,  101,    0,    0,    0,    0,    0,  103,  104,  105,
  106,    0,    0,    0,  107,    0,  108,    0,    0,    0,
    0,    0,  109,  110,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  882,    0,    0,  111,  321,  113,
  114,    0,   57,   24,  115,   25,    0,    0,   26,  267,
    0,    0,    0,   27,   62,   63,   64,    0,   28,    0,
    0,    0,    0,    0,   66,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   77,    0,
    0,   38,    0,    0,   79,    0,   81,    0,   83,   39,
   40,  268,    0,   41,    0,    0,    0,    0,    0,    0,
   89,    0,    0,   90,   91,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,   95,  319,    0,    0,   97,   98,   99,    0,    0,
    0,  575,    0,    0,    0,  320,    0,    0,    0,    0,
    0,  103,  104,  105,  106,    0,    0,    0,  107,    0,
  108,    0,    0,    0,    0,    0,  109,  110,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  874,    0,
    0,  111,  321,  113,  114,    0,   57,   24,  115,   25,
    0,    0,   26,  267,    0,    0,    0,   27,   62,   63,
   64,    0,   28,    0,    0,    0,    0,    0,   66,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   73,   74,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   77,    0,    0,   38,    0,    0,   79,    0,
   81,    0,   83,   39,   40,  268,    0,   41,    0,    0,
    0,    0,    0,    0,   89,    0,    0,   90,   91,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   92,   93,   94,   95,  319,    0,    0,   97,
   98,   99,    0,    0,    0,    0, 1065,    0,    0,  320,
    0,    0,    0,    0,    0,  103,  104,  105,  106,    0,
    0,    0,  107,    0,  108,    0,    0,    0,    0,    0,
  109,  110,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  874,    0,    0,  111,  321,  113,  114,    0,
   57,   24,  115,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
    0,    0,   66,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,   87,    0,    0,    0,   89,    0,
    0,   90,   91,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,   95,
  319,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  101,    0,    0,    0,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,    0,    0,    0,  109,  110,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  688,    0,    0,  111,
  321,  113,  114,    0,   57,   24,  115,   25,    0,    0,
   26,  267,    0,    0,    0,   27,   62,   63,   64,    0,
   28,    0,    0,    0,    0,    0,   66,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   73,   74,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   77,    0,    0,   38,    0,    0,   79,    0,   81,    0,
   83,   39,   40,  268,    0,   41,    0,    0,    0,    0,
    0,    0,   89,    0,    0,   90,   91,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,   95,   96,    0,    0,   97,   98,   99,
    0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
    0,    0,    0,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,    0,    0,    0,  109,  110,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  874,    0,    0,  111,  112,  113,  114,    0,   57,   24,
  115,   25,    0,    0,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,    0,    0,    0,    0,    0,
   66,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   73,   74,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   77,    0,    0,   38,    0,    0,
   79,    0,   81,    0,   83,   39,   40,  268,    0,   41,
    0,    0,    0,    0,    0,    0,   89,    0,    0,   90,
   91,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,   95,  319,    0,
    0,   97,   98,   99,    0,    0,    0,    0,    0,    0,
    0,  320,    0,    0,    0,    0,    0,  103,  104,  105,
  106,    0,    0,    0,  107,    0,  108,    0,    0,    0,
    0,    0,  109,  110,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1259,    0,    0,  111,  321,  113,
  114,    0,   57,   24,  115,   25,    0,    0,   26,  267,
    0,    0,    0,   27,   62,   63,   64,    0,   28,    0,
    0,    0,    0,    0,   66,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   77,    0,
    0,   38,    0,    0,   79,    0,   81,    0,   83,   39,
   40,  268,    0,   41,    0,    0,    0,    0,    0,    0,
   89,    0,    0,   90,   91,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,   95,   96,    0,    0,   97,   98,   99,    0,    0,
    0,    0,    0,    0,    0,  320,    0,    0,    0,    0,
    0,  103,  104,  105,  106,    0,    0,    0,  107,    0,
  108,    0,    0,    0,    0,    0,  109,  110,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,    0,
    0,  111, 1260,  113,  114,    0,   89,   89,  115,   89,
    0,    0,   89,   89,    0,  595,    0,   89,   89,   89,
   89,    0,   89,    0,   24,    0,   25,    0,   89,   26,
    0,   89,    0,    0,   27,    0,    0,    0,   89,   28,
    0,    0,    0,   89,    0,   89,   89,   89,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,   89,
   33,   89,   89,    0,   34,   89,    0,    0,   89,    0,
   89,    0,   89,   89,   89,   89,   36,   89,   37,    0,
    0,    0,   38,    0,   89,    0,    0,   89,   89,    0,
   39,   40,    0,    0,   41,    0,    0,  596,    0,    0,
    0,    0,   89,   89,   89,   89,   89,    0,    0,   89,
   89,   89,    0,    0,    0,    0,    0,    0,    0,   89,
    0,    0,    0,    0,    0,   89,   89,   89,   89,    0,
    0,    0,   89,    0,   89,    0,  343,    0,    0,    0,
   89,   89,    0,    0,    0,    0,    0,    0,   57,   24,
    0,   25,    0,    0,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,   89,   89,   89,   89,   24,
   66,   25,   89,   30,   26,    0,    0,    0,    0,   27,
   32,    0,    0,  406,   28,   33,    0,   73,   74,   34,
    0,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,   36,    0,   37,   77,   33,    0,   38,    0,   34,
   79,    0,   81,    0,   83,   39,   40,  268, 1028,   41,
    0,   36,    0,   37,    0,    0,   89,   38,    0,   90,
   91,    0,    0,    0,    0,   39,   40,    0,    0,   41,
    0,    0,  596,    0,   92,   93,   94,   95,  864,    0,
    0,   97,   98,   99,    0,    0,    0,  865, 1212,    0,
    0,  320,    0,    0,    0,    0,    0,  103,  104,  105,
  106,    0,    0,    0,  107,    0,  108,    0,    0,    0,
    0,  343,  109,  110,    0,    0,    0,    0,    0,    0,
   57,   24,    0,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,  111,  866,  113,
  114,    0,   66,  867,    0,   30,    0,    0,    0,    0,
    0,  868,   32,    0,    0,    0,    0,   33,  406,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,   89,    0,
    0,   90,   91,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,   95,
  864,    0,    0,   97,   98,   99,    0,    0,    0,  865,
    0,    0,    0,  320,    0,    0,    0,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,    0,    0,    0,  109,  110,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  111,
  866,  113,  114,    0,    0,  867,   54,    0,   54,    0,
   54,    0,   54,  868,    0,   54,    0,   54,   54,    0,
   54,    0,    0,   54,    0,   54,    0,   54,   54,   54,
   54,    0,    0,   54,   54,    0,    0,    0,    0,   54,
   54,   54,   54,   54,    0,    0,   54,    0,   54,    0,
   54,    0,   54,   54,    0,   54,   54,   54,   54,   54,
    0,   54,   54,   54,   54,    0,    0,   54,   54,   54,
    0,    0,    0,    0,    0,    0,   54,   54,    0,   54,
   54,    0,   54,   54,   54,    0,    0,    0,   54,    0,
   53,    0,    0,    0,   53,    0,   53,    0,    0,   53,
    0,   53,   53,    0,   53,    0,    0,   53,   54,   53,
    0,   53,   53,   53,   53,   54,   54,   53,   53,    0,
    0,    0,   54,   53,    0,   53,   53,   53,    0,    0,
   53,    0,   53,    0,   53,    0,    0,   53,    0,   53,
   53,   53,   53,   53,    0,    0,   53,   53,   53,    0,
    0,   53,   53,   53,    0,    0,    0,    0,    0,    0,
   53,   53,    0,   53,   53,    0,   53,   53,   53,   54,
    0,    0,   53,    0,   53,    0,   54,   54,   53,    0,
   53,    0,    0,   53,    0,   53,   53,    0,   53,    0,
    0,   53,   53,   53,    0,   53,   53,   53,   53,    0,
    0,   53,   53,   91,    0,    0,   53,   53,    0,   53,
   53,   53,   53,    0,   53,    0,   53,    0,   53,    0,
    0,   53,    0,   53,   53,   53,   53,   53,    0,    0,
   53,   53,   53,    0,    0,   53,   53,   53,    0,    0,
    0,    0,    0,    0,   53,   53,    0,   53,   53,    0,
   53,   53,   53,   53,    0,    0,   53,    0,   54,    0,
   53,   53,   54,    0,   54,    0,    0,   54,    0,   54,
   54,    0,   54,    0,    0,   54,   53,   54,    0,   54,
   54,   54,   54,    0,    0,   54,   54,   92,    0,    0,
   53,   54,    0,   54,   54,   54,   53,    0,   54,    0,
   54,    0,   54,    0,    0,   54,    0,   54,   54,   54,
   54,   54,    0,    0,   54,   54,   54,    0,    0,   54,
   54,   54,    0,    0,    0,    0,    0,    0,   54,   54,
    0,   54,   54,    0,   54,   54,   54,   53,    0,    0,
   54,    0,   53,    0,   53,   53,   53,    0,   53,    0,
    0,   53,    0,   53,   53,    0,   53,    0,    0,   53,
   54,   53,    0,   53,   53,   53,   53,    0,    0,   53,
   53,    0,    0,    0,   54,   53,    0,   53,   53,   53,
   54,    0,   53,    0,   53,    0,   53,    0,    0,   53,
    0,   53,   53,   53,   53,   53,    0,    0,   53,   53,
   53,    0,    0,   53,   53,   53,    0,    0,    0,    0,
    0,    0,   53,   53,    0,   53,   53,    0,   53,   53,
   53,   54,    0,    0,   53,    0,   53,    0,   54,   54,
   53,    0,   53,    0,    0,   53,    0,   53,   53,    0,
   53,    0,    0,   53,   53,   53,    0,   53,   53,   53,
   53,    0,    0,   53,   53,  256,    0,    0,   53,   53,
    0,   53,   53,   53,    0,    0,   53,    0,   53,    0,
   53,    0,    0,   53,   39,   53,   53,   53,   53,   53,
    0,    0,   53,   53,   53,   39,    0,   53,   53,   53,
    0,   39,    0,    0,    0,   39,   53,   53,   39,   53,
   53,    0,   53,   53,   53,   53,    0,    0,   53,    0,
   39,   39,   53,   53,    0,   39,   39,    0,    0,    0,
    0,   39,    0,   39,   39,   39,   39,    0,   53,    0,
    0,   39,    0,    0,    0,   39,    0,   39,    0,  257,
    0,    0,   53,    0,    0,    0,    0,   39,    0,   39,
   39,    0,   39,    0,    0,    0,   39,   37,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   37,    0,
    0,    0,    0,    0,   37,    0,   39,    0,   37,    0,
    0,   37,    0,    0,    0,    0,    0,   39,   39,   53,
    0,    0,    0,   37,   37,    0,   53,   53,   37,   37,
    0,    0,    0,    0,   37,    0,   37,   37,   37,   37,
    0,    0,    0,    0,   37,    0,    0,    0,   37,    0,
   37,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   37,    0,  364,   37,    0,   37,    0,    0,  365,   37,
   57,   24,    0,   25,   39,   39,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,   37,
    0,    0,   66,    0,    0,   30,    0,    0,    0,    0,
   37,   37,   32,    0,    0,  366,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
  367,    0,    0,    0,    0,    0,    0,   37,   37,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,  269,
  368,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  320,    0,  369,    0,    0,    0,  103,
  104,  105,  106, 1064,    0,    0,  107,    0,  108,    0,
    0,  364,    0,    0,  109,  110,    0,  365,    0,   57,
   24,    0,   25,    0,    0,   26,  267,    0,    0,    0,
   27,   62,   63,   64,    0,   28,    0,    0,    0,  111,
  271,   66,  114,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,  366,    0,   33,    0,   73,   74,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   77,    0,    0,   38,    0,
    0,   79,    0,   81,    0,   83,   39,   40,  268,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,  367,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   92,   93,   94,  269,  368,
    0,    0,   97,   98,   99,    0,    0,    0,    0,    0,
    0,    0,  320,    0,  369,    0,    0,    0,  103,  104,
  105,  106,    0,    0,    0,  107,    0,  108,    0,    0,
  364,    0,    0,  109,  110,    0,  365,    0,   57,   24,
    0,   25,    0,    0,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,    0,    0,    0,  111,  271,
   66,  114,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,  366,    0,   33,    0,   73,   74,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   77,    0,    0,   38,    0,    0,
   79,    0,   81,    0,   83,   39,   40,  268,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,  269,  368,    0,
    0,   97,   98,   99,    0,    0,    0,    0,    0,    0,
    0,  320,    0,  369,    0,    0,    0,  103,  104,  105,
  106,    0,    0,    0,  107,    0,  108,    0,    0,  364,
    0,    0,  109,  110,    0,    0,    0,   57,   24,    0,
   25,    0,    0,   26,  267,    0,    0,    0,   27,   62,
   63,   64,    0,   28,    0,    0,    0,  111,  271,   66,
  114,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   73,   74,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   77,    0,    0,   38,    0,    0,   79,
    0,   81,    0,   83,   39,   40,  268,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   92,   93,   94,  269,  368,    0,    0,
   97,   98,   99,    0,    0,    0,    0,    0,    0,    0,
  320,    0,  369,    0,    0,    0,  103,  104,  105,  106,
    0,    0,    0,  107,    0,  108,    0,    0,  382,    0,
    0,  109,  110,    0,    0,    0,   57,   24,    0,   25,
    0,    0,   26,  267,    0,    0,    0,   27,   62,   63,
   64,    0,   28,    0,    0,    0,  111,  271,   66,  114,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   73,   74,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   77,    0,    0,   38,    0,    0,   79,    0,
   81,    0,   83,   39,   40,  268,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   92,   93,   94,  269,  368,    0,    0,   97,
   98,   99,    0,    0,    0,    0,    0,    0,    0,  320,
    0,    0,    0,    0,    0,  103,  104,  105,  106,    0,
    0,    0,  107,    0,  108,    0,    0,  384,    0,    0,
  109,  110,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  267,    0,    0,    0,   27,   62,   63,   64,
    0,   28,    0,    0,    0,  111,  271,   66,  114,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   73,   74,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   77,    0,    0,   38,    0,    0,   79,    0,   81,
    0,   83,   39,   40,  268,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   92,   93,   94,  269,  368,    0,    0,   97,   98,
   99,    0,    0,    0,    0,    0,    0,    0,  320,    0,
    0,    0,    0,    0,  103,  104,  105,  106,    0,    0,
    0,  107,    0,  108,    0,    0,  386,    0,    0,  109,
  110,    0,    0,    0,   57,   24,    0,   25,    0,    0,
   26,  267,    0,    0,    0,   27,   62,   63,   64,    0,
   28,    0,    0,    0,  111,  271,   66,  114,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   73,   74,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   77,    0,    0,   38,    0,    0,   79,    0,   81,    0,
   83,   39,   40,  268,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,  269,  368,    0,    0,   97,   98,   99,
    0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
    0,    0,    0,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,  388,    0,    0,  109,  110,
    0,    0,    0,   57,   24,    0,   25,    0,    0,   26,
  267,    0,    0,    0,   27,   62,   63,   64,    0,   28,
    0,    0,    0,  111,  271,   66,  114,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   73,   74,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   77,
    0,    0,   38,    0,    0,   79,    0,   81,    0,   83,
   39,   40,  268,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   92,
   93,   94,  269,  368,    0,    0,   97,   98,   99,    0,
    0,    0,    0,    0,    0,    0,  320,    0,    0,    0,
    0,    0,  103,  104,  105,  106,    0,    0,    0,  107,
    0,  108,    0,    0,  390,    0,    0,  109,  110,    0,
    0,    0,   57,   24,    0,   25,    0,    0,   26,  267,
    0,    0,    0,   27,   62,   63,   64,    0,   28,    0,
    0,    0,  111,  271,   66,  114,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   77,    0,
    0,   38,    0,    0,   79,    0,   81,    0,   83,   39,
   40,  268,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,  269,  368,    0,    0,   97,   98,   99,    0,    0,
    0,    0,    0,    0,    0,  320,    0,    0,    0,    0,
    0,  103,  104,  105,  106,    0,    0,    0,  107,    0,
  108,    0,    0,  392,    0,    0,  109,  110,    0,    0,
    0,   57,   24,    0,   25,    0,    0,   26,  267,    0,
    0,    0,   27,   62,   63,   64,    0,   28,    0,    0,
    0,  111,  271,   66,  114,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   73,   74,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   77,    0,    0,
   38,    0,    0,   79,    0,   81,    0,   83,   39,   40,
  268,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   92,   93,   94,
  269,  368,    0,    0,   97,   98,   99,    0,    0,    0,
    0,    0,    0,    0,  320,    0,    0,    0,    0,    0,
  103,  104,  105,  106,    0,    0,    0,  107,    0,  108,
    0,    0,  394,    0,    0,  109,  110,    0,    0,    0,
   57,   24,    0,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
  111,  271,   66,  114,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,  269,
  368,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  320,    0,    0,    0,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,  396,    0,    0,  109,  110,    0,    0,    0,   57,
   24,    0,   25,    0,    0,   26,  267,    0,    0,    0,
   27,   62,   63,   64,    0,   28,    0,    0,    0,  111,
  271,   66,  114,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   73,   74,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   77,    0,    0,   38,    0,
    0,   79,    0,   81,    0,   83,   39,   40,  268,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   92,   93,   94,  269,  368,
    0,    0,   97,   98,   99,    0,    0,    0,    0,    0,
    0,    0,  320,    0,    0,    0,    0,    0,  103,  104,
  105,  106,    0,    0,    0,  107,    0,  108,    0,    0,
  715,    0,    0,  109,  110,    0,    0,    0,   57,   24,
    0,   25,    0,    0,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,    0,    0,    0,  111,  271,
   66,  114,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   73,   74,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   77,    0,    0,   38,    0,    0,
   79,    0,   81,    0,   83,   39,   40,  268,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,  269,  368,    0,
    0,   97,   98,   99,    0,    0,    0,    0,    0,    0,
    0,  320,    0,    0,    0,    0,    0,  103,  104,  105,
  106,    0,    0,    0,  107,    0,  108,    0,    0,  717,
    0,    0,  109,  110,    0,    0,    0,   57,   24,    0,
   25,    0,    0,   26,  267,    0,    0,    0,   27,   62,
   63,   64,    0,   28,    0,    0,    0,  111,  271,   66,
  114,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   73,   74,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   77,    0,    0,   38,    0,    0,   79,
    0,   81,    0,   83,   39,   40,  268,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   92,   93,   94,  269,  368,    0,    0,
   97,   98,   99,    0,    0,    0,    0,    0,    0,    0,
  320,    0,    0,    0,    0,    0,  103,  104,  105,  106,
    0,    0,    0,  107,    0,  108,    0,    0,  719,    0,
    0,  109,  110,    0,    0,    0,   57,   24,    0,   25,
    0,    0,   26,  267,    0,    0,    0,   27,   62,   63,
   64,    0,   28,    0,    0,    0,  111,  271,   66,  114,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   73,   74,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   77,    0,    0,   38,    0,    0,   79,    0,
   81,    0,   83,   39,   40,  268,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   92,   93,   94,  269,  368,    0,    0,   97,
   98,   99,    0,    0,    0,    0,    0,    0,    0,  320,
    0,    0,    0,    0,    0,  103,  104,  105,  106,    0,
    0,    0,  107,    0,  108,    0,    0,  736,    0,    0,
  109,  110,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  267,    0,    0,    0,   27,   62,   63,   64,
    0,   28,    0,    0,    0,  111,  271,   66,  114,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   73,   74,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   77,    0,    0,   38,    0,    0,   79,    0,   81,
    0,   83,   39,   40,  268,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   92,   93,   94,  269,  368,    0,    0,   97,   98,
   99,    0,    0,    0,    0,    0,    0,    0,  320,    0,
    0,    0,    0,    0,  103,  104,  105,  106,    0,    0,
    0,  107,    0,  108,    0,    0,  738,    0,    0,  109,
  110,    0,    0,    0,   57,   24,    0,   25,    0,    0,
   26,  267,    0,    0,    0,   27,   62,   63,   64,    0,
   28,    0,    0,    0,  111,  271,   66,  114,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   73,   74,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   77,    0,    0,   38,    0,    0,   79,    0,   81,    0,
   83,   39,   40,  268,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,  269,  368,    0,    0,   97,   98,   99,
    0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
    0,    0,    0,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,  740,    0,    0,  109,  110,
    0,    0,    0,   57,   24,    0,   25,    0,    0,   26,
  267,    0,    0,    0,   27,   62,   63,   64,    0,   28,
    0,    0,    0,  111,  271,   66,  114,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   73,   74,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   77,
    0,    0,   38,    0,    0,   79,    0,   81,    0,   83,
   39,   40,  268,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   92,
   93,   94,  269,  741,    0,    0,   97,   98,   99,    0,
    0,    0,    0,    0,    0,    0,  320,    0,    0,    0,
    0,    0,  103,  104,  105,  106,    0,    0,    0,  107,
    0,  108,    0,    0,  743,    0,    0,  109,  110,    0,
    0,    0,   57,   24,    0,   25,    0,    0,   26,  267,
    0,    0,    0,   27,   62,   63,   64,    0,   28,    0,
    0,    0,  111,  271,   66,  114,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   77,    0,
    0,   38,    0,    0,   79,    0,   81,    0,   83,   39,
   40,  268,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,  269,  741,    0,    0,   97,   98,   99,    0,    0,
    0,    0,    0,    0,    0,  320,    0,    0,    0,    0,
    0,  103,  104,  105,  106,    0,    0,    0,  107,    0,
  108,    0,    0,  745,    0,    0,  109,  110,    0,    0,
    0,   57,   24,    0,   25,    0,    0,   26,  267,    0,
    0,    0,   27,   62,   63,   64,    0,   28,    0,    0,
    0,  111,  271,   66,  114,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   73,   74,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   77,    0,    0,
   38,    0,    0,   79,    0,   81,    0,   83,   39,   40,
  268,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   92,   93,   94,
  269,  741,    0,    0,   97,   98,   99,    0,    0,    0,
    0,    0,    0,    0,  320,    0,    0,    0,    0,    0,
  103,  104,  105,  106,    0,    0,    0,  107,    0,  108,
    0,    0,  747,    0,    0,  109,  110,    0,    0,    0,
   57,   24,    0,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
  111,  271,   66,  114,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,  269,
  741,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  320,    0,    0,    0,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,  749,    0,    0,  109,  110,    0,    0,    0,   57,
   24,    0,   25,    0,    0,   26,  267,    0,    0,    0,
   27,   62,   63,   64,    0,   28,    0,    0,    0,  111,
  271,   66,  114,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   73,   74,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   77,    0,    0,   38,    0,
    0,   79,    0,   81,    0,   83,   39,   40,  268,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   92,   93,   94,  269,  741,
    0,    0,   97,   98,   99,    0,    0,    0,    0,    0,
    0,    0,  320,    0,    0,    0,    0,    0,  103,  104,
  105,  106,    0,    0,    0,  107,    0,  108,    0,    0,
  751,    0,    0,  109,  110,    0,    0,    0,   57,   24,
    0,   25,    0,    0,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,    0,    0,    0,  111,  271,
   66,  114,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   73,   74,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   77,    0,    0,   38,    0,    0,
   79,    0,   81,    0,   83,   39,   40,  268,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,  269,  741,    0,
    0,   97,   98,   99,    0,    0,    0,    0,    0,    0,
    0,  320,    0,    0,    0,    0,    0,  103,  104,  105,
  106,    0,    0,    0,  107,    0,  108,    0,    0,  753,
    0,    0,  109,  110,    0,    0,    0,   57,   24,    0,
   25,    0,    0,   26,  267,    0,    0,    0,   27,   62,
   63,   64,    0,   28,    0,    0,    0,  111,  271,   66,
  114,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   73,   74,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   77,    0,    0,   38,    0,    0,   79,
    0,   81,    0,   83,   39,   40,  268,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   92,   93,   94,  269,  741,    0,    0,
   97,   98,   99,    0,    0,    0,    0,    0,    0,    0,
  320,    0,    0,    0,    0,    0,  103,  104,  105,  106,
    0,    0,    0,  107,    0,  108,    0,    0,  755,    0,
    0,  109,  110,    0,    0,    0,   57,   24,    0,   25,
    0,    0,   26,  267,    0,    0,    0,   27,   62,   63,
   64,    0,   28,    0,    0,    0,  111,  271,   66,  114,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   73,   74,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   77,    0,    0,   38,    0,    0,   79,    0,
   81,    0,   83,   39,   40,  268,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   92,   93,   94,  269,  741,    0,    0,   97,
   98,   99,    0,    0,    0,    0,    0,    0,    0,  320,
    0,    0,    0,    0,    0,  103,  104,  105,  106,    0,
    0,    0,  107,    0,  108,    0,    0,  757,    0,    0,
  109,  110,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  267,    0,    0,    0,   27,   62,   63,   64,
    0,   28,    0,    0,    0,  111,  271,   66,  114,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   73,   74,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   77,    0,    0,   38,    0,    0,   79,    0,   81,
    0,   83,   39,   40,  268,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   92,   93,   94,  269,  741,    0,    0,   97,   98,
   99,    0,    0,    0,    0,    0,    0,    0,  320,    0,
    0,    0,    0,    0,  103,  104,  105,  106,    0,    0,
    0,  107,    0,  108,    0,    0,  759,    0,    0,  109,
  110,    0,    0,    0,   57,   24,    0,   25,    0,    0,
   26,  267,    0,    0,    0,   27,   62,   63,   64,    0,
   28,    0,    0,    0,  111,  271,   66,  114,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   73,   74,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   77,    0,    0,   38,    0,    0,   79,    0,   81,    0,
   83,   39,   40,  268,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,  269,  741,    0,    0,   97,   98,   99,
    0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
    0,    0,    0,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,  761,    0,    0,  109,  110,
    0,    0,    0,   57,   24,    0,   25,    0,    0,   26,
  267,    0,    0,    0,   27,   62,   63,   64,    0,   28,
    0,    0,    0,  111,  271,   66,  114,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   73,   74,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   77,
    0,    0,   38,    0,    0,   79,    0,   81,    0,   83,
   39,   40,  268,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   92,
   93,   94,  269,  741,    0,    0,   97,   98,   99,    0,
    0,    0,    0,    0,    0,    0,  320,    0,    0,    0,
    0,    0,  103,  104,  105,  106,    0,    0,    0,  107,
    0,  108,    0,    0,  763,    0,    0,  109,  110,    0,
    0,    0,   57,   24,    0,   25,    0,    0,   26,  267,
    0,    0,    0,   27,   62,   63,   64,    0,   28,    0,
    0,    0,  111,  271,   66,  114,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   73,   74,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   77,    0,
    0,   38,    0,    0,   79,    0,   81,    0,   83,   39,
   40,  268,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,  269,  741,    0,    0,   97,   98,   99,    0,    0,
    0,    0,    0,    0,    0,  320,    0,    0,    0,    0,
    0,  103,  104,  105,  106,    0,    0,    0,  107,    0,
  108,    0,    0,  765,    0,    0,  109,  110,    0,    0,
    0,   57,   24,    0,   25,    0,    0,   26,  267,    0,
    0,    0,   27,   62,   63,   64,    0,   28,    0,    0,
    0,  111,  271,   66,  114,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   73,   74,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   77,    0,    0,
   38,    0,    0,   79,    0,   81,    0,   83,   39,   40,
  268,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   92,   93,   94,
  269,  741,    0,    0,   97,   98,   99,    0,    0,    0,
    0,    0,    0,    0,  320,    0,    0,    0,    0,    0,
  103,  104,  105,  106,    0,    0,    0,  107,    0,  108,
    0,    0,  949,    0,    0,  109,  110,    0,    0,    0,
   57,   24,    0,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
  111,  271,   66,  114,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,  269,
  368,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  320,    0,    0,    0,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,  723,    0,    0,  109,  110,    0,    0,    0,   57,
   24,    0,   25,    0,    0,   26,  267,    0,    0,    0,
   27,   62,   63,   64,    0,   28,    0,    0,    0,  111,
  271,   66,  114,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   73,   74,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   77,    0,    0,   38,    0,
    0,   79,    0,   81,    0,   83,   39,   40,  268,    0,
   41,    0,    0,   87,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   92,   93,   94,  269,  270,
    0,    0,   97,   98,    0,    0,    0,    0,    0,    0,
    0,    0,  101,    0,  799,    0,  799,    0,  799,  724,
  725,  799,    0,  799,  799,    0,  799,  726,    0,  799,
    0,  799,    0,  799,  799,  799,    0,    0,    0,  799,
  799,    0,    0,    0,    0,  799,    0,  799,  799,    0,
    0,    0,  799,    0,    0,    0,  799,    0,  111,  271,
    0,  727,    0,    0,    0,  799,    0,  799,  799,    0,
  799,    0,    0,    0,  799,  799,    0,    0,    0,    0,
    0,    0,  799,  799,  554,    0,  799,    0,    0,  799,
    0,    0,   57,   24,  799,   25,    0,    0,   26,  267,
    0,    0,    0,   27,   62,   63,   64,    0,   28,    0,
    0,    0,    0,    0,   66,    0,    0,   30,    0,    0,
    0,  799,  799,    0,   32,    0,    0,    0,  799,   33,
    0,   73,   74,   34,  799,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   77,    0,
    0,   38,    0,  652,   79,    0,   81,    0,   83,   39,
   40,  268,   24,   41,   25,    0,    0,   26,    0,    0,
    0,    0,   27,    0,    0,  799,    0,   28,    0,    0,
    0,    0,  799,  799,    0,    0,   30,    0,   92,   93,
   94,  269,  555,   32,    0,   97,   98,    0,   33,    0,
    0,    0,   34,    0,    0,  320,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,    0,    0,    0,
   38,    0,  721,    0,    0,    0,    0,    0,   39,   40,
    0,   24,   41,   25,    0,   87,   26,    0,    0,    0,
    0,   27,    0,    0,    0,    0,   28,    0,    0,    0,
    0,  111,  556,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,    0,
    0,   34,    0,    0,  343,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,    0,    0,    0,   38,
    0, 1085,    0,    0,    0,    0,    0,   39,   40,    0,
   24,   41,   25,    0,   87,   26,    0,    0,    0,    0,
   27,    0,    0,    0,    0,   28,    0,    0,    0,    0,
    0,  406,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,    0,    0,
   34,    0,    0,  343,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,    0,    0,    0,   38,    0,
 1270,    0,    0,    0,    0,    0,   39,   40,    0,   24,
   41,   25,    0,   87,   26,    0,    0,    0,    0,   27,
    0,    0,    0,    0,   28,    0,    0,    0,    0,    0,
  406,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,    0,    0,   34,
    0,    0,  343,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,    0,    0,    0,   38,    0,    0,
    0,    0,    0,    0,    0,   39,   40,    0,  798,   41,
  798,    0,   87,  798,    0,  798,  798,    0,  798,    0,
    0,  798,    0,  798,    0,  798,  798,  798,    0,  406,
    0,  798,  798,    0,    0,    0,    0,  798,    0,  798,
  798,    0,    0,    0,  798,    0,    0,    0,  798,    0,
    0,  343,    0,    0,    0,    0,    0,  798,    0,    0,
  798,    0,  798,    0,    0,    0,  798,  798,    0,    0,
    0,    0,    0,    0,  798,  798,    0,    0,  798,    0,
    0,  798,  798,    0,  798,    0,  798,  798,    0,  798,
  798,    0,  798,    0,    0,  798,    0,  798,  406,  798,
  798,  798,    0,    0,    0,  798,  798,    0,    0,    0,
    0,  798,    0,  798,  798,    0,    0,    0,  798,    0,
  798,    0,  798,    0,    0,    0,  798,    0,    0,    0,
    0,  798,    0,    0,  798,    0,  798,    0,    0,    0,
  798,  798,    0,    0,    0,    0,    0,    0,  798,  798,
    0,    0,  798,    0,    0,  798,    0,    0,    0,    0,
  798,    0,    0,    0,    0,   57,   24,  798,   25,    0,
    0,   26,  267,    0,  798,  798,   27,   62,   63,   64,
    0,   28,    0,    0,    0,    0,    0,   66,    0,    0,
   30,    0,    0,    0,  798,    0,  691,   32,    0,    0,
    0,    0,   33,    0,   73,   74,   34,    0,  692,    0,
    0,    0,    0,    0,    0,  693,    0,    0,   36,    0,
   37,   77,    0,    0,   38,    0,    0,   79,    0,   81,
    0,   83,   39,   40,  268,    0,   41,    0,    0,    0,
    0,  798,    0,  694,    0,    0,   90,   91,  798,  798,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   92,   93,   94,   95,   96,    0,    0,   97,   98,
   99,    0,    0,    0,    0,    0,    0,    0,  320, 1119,
    0,  695,    0,    0,  103,  104,  105,  106,    0,    0,
    0,  107,    0,  108,    0,    0,    0,    0,    0,  109,
  110,    0,    0,    0,    0,    0,    0,   57,   24,    0,
   25,    0,    0,   26,  267,    0,    0,    0,   27,   62,
   63,   64,    0,   28,  111,  112,  113,  114,    0,   66,
    0,  115,   30,    0,    0,    0,    0,    0,  691,   32,
    0,    0,    0,    0,   33,    0,   73,   74,   34,    0,
  692,    0,    0,    0,    0,    0,    0,  693,    0,    0,
   36,    0,   37,   77,    0,    0,   38,    0,    0,   79,
    0,   81,    0,   83,   39,   40,  268,    0,   41,    0,
    0,    0,    0,    0,    0,  694,    0,    0,   90,   91,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   92,   93,   94,   95,   96,    0,    0,
   97,   98,   99,    0,    0,    0,    0,    0,    0,    0,
  320,    0,    0,  695,    0,    0,  103,  104,  105,  106,
    0,    0,    0,  107,    0,  108,    0,    0,    0,    0,
    0,  109,  110,    0,    0,    0,    0,    0,    0,   57,
   24,    0,   25,    0,    0,   26,  267,    0,    0,    0,
   27,   62,   63,   64,    0,   28,  111,  112,  113,  114,
    0,   66,    0,  115,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   73,   74,
   34,    0,    0,    0,    0,    0,    0,    0,    0,  318,
    0,    0,   36,    0,   37,   77,  768,    0,   38,    0,
    0,   79,    0,   81,    0,   83,   39,   40,  268,    0,
   41,    0,    0,    0,    0,    0,    0,   89,    0,    0,
   90,   91,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   92,   93,   94,   95,  319,
    0,    0,   97,   98,   99,    0,    0,    0,    0,    0,
    0,    0,  320,    0,    0,    0,    0,    0,  103,  104,
  105,  106,    0,    0,    0,  107,    0,  108,    0,    0,
    0,    0,    0,  109,  110,    0,    0,    0,    0,    0,
    0,   57,   24,    0,   25,    0,    0,   26,  267,    0,
    0,    0,   27,   62,   63,   64,    0,   28,  111,  321,
  113,  114,  205,   66,  205,  115,   30,  205,    0,    0,
    0,    0,  205,   32,    0,    0,    0,  205,   33,    0,
   73,   74,   34,    0,    0,    0,  205,    0,    0,    0,
    0,    0,    0,  205,   36,    0,   37,   77,  205,    0,
   38,    0,  205,   79,    0,   81,    0,   83,   39,   40,
  268,    0,   41,    0,  205,   87,  205,    0,    0,   89,
  205,    0,   90,   91,    0,    0,    0,    0,  205,  205,
    0,    0,  205,    0,    0,  205,    0,   92,   93,   94,
   95,  319,    0,    0,   97,   98,   99,    0,    0,    0,
    0,    0,    0,    0,  101,    0,    0,    0,    0,    0,
  103,  104,  105,  106,    0,    0,    0,  107,    0,  108,
    0,    0,    0, 1151,  205,  109,  110,    0,    0,    0,
    0,    0,    0,   57,   24,    0,   25,    0,    0,   26,
  267,    0,    0,    0,   27,   62,   63,   64,    0,   28,
  111,  376,  113,  114,   24,   66,   25,  115,   30,   26,
    0,    0,    0,    0,   27,   32,    0,    0,    0,   28,
   33,  205,   73,   74,   34,    0,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,   36,    0,   37,   77,
   33,    0,   38,    0,   34,   79,    0,   81,    0,   83,
   39,   40,  268,    0,   41,    0,   36,   87,   37,    0,
    0,   89,   38,    0,   90,   91,    0,    0,    0,    0,
   39,   40,    0,    0,   41,    0,    0,   87,    0,   92,
   93,   94,   95,  319,    0,    0,   97,   98,   99,    0,
    0,    0,    0,    0,    0,    0,  101,    0,    0,    0,
    0,    0,  103,  104,  105,  106,    0,    0,    0,  107,
    0,  108,    0,    0,    0,    0,  343,  109,  110,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  267,    0,    0,    0,   27,   62,   63,   64,
    0,   28,  111,  321,  113,  114,   24,   66,   25,  115,
   30,   26,    0,    0,    0,    0,   27,   32,    0,    0,
    0,   28,   33,  406,   73,   74,   34,    0,    0,    0,
   30,    0,    0,    0,    0,  318,    0,   32,   36,    0,
   37,   77,   33,    0,   38,    0,   34,   79,    0,   81,
    0,   83,   39,   40,  268,    0,   41,    0,   36,    0,
   37,    0,    0,   89,   38,    0,   90,   91,    0,    0,
    0,    0,   39,   40,    0,    0,   41,    0,    0,  606,
    0,   92,   93,   94,   95,  319,    0,    0,   97,   98,
   99,    0,    0,    0,    0,    0,    0,    0,  320,    0,
    0,    0,    0,    0,  103,  104,  105,  106,    0,    0,
    0,  107,    0,  108,    0,    0,    0,    0,  343,  109,
  110,    0,    0,    0,    0,    0,    0,   57,   24,    0,
   25,    0,    0,   26,  267,    0,    0,    0,   27,   62,
   63,   64,    0,   28,  111,  321,  113,  114,  571,   66,
  571,  115,   30,  571,    0,    0,    0,    0,  571,   32,
    0,    0,    0,  571,   33,  406,   73,   74,   34,    0,
    0,    0,  571,    0,    0,    0,    0,    0,    0,  571,
   36,    0,   37,   77,  571,    0,   38,    0,  571,   79,
    0,   81,    0,   83,   39,   40,  268,    0,   41,    0,
  571,    0,  571,    0,    0,   89,  571,    0,   90,   91,
    0,    0,    0,    0,  571,  571,    0,    0,  571,    0,
    0,  571,    0,   92,   93,   94,   95,  319,    0,    0,
   97,   98,   99,    0,    0,    0,  575,    0,    0,    0,
  320,    0,    0,    0,    0,    0,  103,  104,  105,  106,
    0,    0,    0,  107,    0,  108,    0,    0,    0,    0,
  571,  109,  110,    0,    0,    0,    0,    0,    0,   57,
   24,    0,   25,    0,    0,   26,  267,    0,    0,    0,
   27,   62,   63,   64,    0,   28,  111,  321,  113,  114,
  206,   66,  206,  115,   30,  206,    0,    0,    0,    0,
  206,   32,    0,    0,    0,  206,   33,  571,   73,   74,
   34,    0,    0,    0,  206,    0,    0,    0,    0,    0,
    0,  206,   36,    0,   37,   77,  206,    0,   38,    0,
  206,   79,    0,   81,    0,   83,   39,   40,  268,    0,
   41,    0,  206,    0,  206,    0,    0,   89,  206,    0,
   90,   91,    0,    0,    0,    0,  206,  206,    0,    0,
  206,    0,    0,  206,    0,   92,   93,   94,   95,  319,
    0,    0,   97,   98,   99,    0,    0,    0,  569,    0,
    0,    0,  320,    0,    0,    0,    0,    0,  103,  104,
  105,  106,    0,    0,    0,  107,    0,  108,    0,    0,
    0,    0,  206,  109,  110,    0,    0,    0,    0,    0,
    0,  751,  751,    0,  751,    0,    0,  751,  751,    0,
    0,    0,  751,  751,  751,  751,    0,  751,  111,  321,
  113,  114,  205,  751,  205,  115,  751,  205,    0,    0,
    0,    0,  205,  751,    0,    0,    0,  205,  751,  206,
  751,  751,  751,    0,    0,    0,  205,    0,    0,    0,
    0,  751,    0,  205,  751,    0,  751,  751,  205,    0,
  751,    0,  205,  751,    0,  751,    0,  751,  751,  751,
  751,    0,  751,    0,  205,    0,  205,    0,    0,  751,
  205,    0,  751,  751,    0,    0,    0,    0,  205,  205,
    0,    0,  205,    0,    0,  205,    0,  751,  751,  751,
  751,  751,    0,    0,  751,  751,  751,    0,    0,    0,
    0,    0,    0,    0,  751,    0,    0,    0,    0,    0,
  751,  751,  751,  751,    0,    0,    0,  751,    0,  751,
    0,    0,    0,    0,  205,  751,  751,    0,    0,    0,
    0,    0,    0,   57,   24,    0,   25,    0,    0,   26,
  267,    0,    0,    0,   27,   62,   63,   64,    0,   28,
  751,  751,  751,  751,  162,   66,  162,  751,   30,  162,
    0,    0,    0,    0,  162,   32,    0,    0,    0,  162,
   33,  205,   73,   74,   34,    0,    0,    0,  162,    0,
    0,    0,    0,    0,    0,  162,   36,    0,   37,   77,
  162,    0,   38,    0,  162,   79,    0,   81,    0,   83,
   39,   40,  268,    0,   41,    0,  162,    0,  162,    0,
    0,   89,  162,    0,   90,   91,    0,    0,    0,    0,
  162,  162,    0,    0,  162,    0,    0,  162,    0,   92,
   93,   94,   95,  319,    0,    0,   97,   98,   99,    0,
    0,    0,    0,    0,    0,    0,  320,    0,    0,    0,
    0,    0,  103,  104,  105,  106,    0,    0,    0,  107,
    0,  108,    0,    0,    0,    0,  162,  109,  110,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  267,    0,    0,    0,   27,   62,   63,   64,
    0,   28,  111,  321,  113,  114,  216,   66,  216,  115,
   30,  216,    0,    0,    0,    0,  216,   32,    0,    0,
    0,  216,   33,  162,   73,   74,   34,    0,    0,    0,
  216,    0,    0,    0,    0,    0,    0,  216,   36,    0,
   37,   77,  216,    0,   38,    0,  216,   79,    0,   81,
    0,   83,   39,   40,  268,    0,   41,    0,  216,    0,
  216,    0,    0,   89,  216,    0,   90,   91,    0,    0,
    0,    0,  216,  216,    0,    0,  216,    0,    0,  216,
    0,   92,   93,   94,   95,   96,    0,    0,   97,   98,
   99,    0,    0,    0,    0,    0,    0,    0,  320,    0,
    0,    0,    0,    0,  103,  104,  105,  106,    0,    0,
    0,  107,    0,  108,    0,    0,    0,    0,  216,  109,
  110,    0,    0,    0,    0,    0,    0,   57,   24,    0,
   25,    0,    0,   26,  267,    0,    0,    0,   27,   62,
   63,   64,    0,   28,  111,  112,  113,  114,    0,   66,
    0,  115,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,  216,   73,   74,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   77,    0,    0,   38,    0,    0,   79,
    0,   81,    0,   83,   39,   40,  268,    0,   41,    0,
    0,    0,    0,    0,    0,   89,    0,    0,   90,   91,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   92,   93,   94,   95,  319,    0,    0,
   97,   98,   99,    0,    0,    0,    0,    0,    0,    0,
  320,    0,    0,    0,    0,    0,  103,  104,  105,  106,
    0,    0,    0,  107,    0,  108,    0,    0,    0,    0,
    0,  109,  110,    0,    0,    0,    0,    0,    0,  153,
  153,    0,  153,    0,    0,  153,  153,    0,    0,    0,
  153,  153,  153,  153,    0,  153,  111,  376,  113,  114,
    0,  153,    0,  115,  153,    0,    0,    0,    0,    0,
    0,  153,    0,    0,    0,    0,  153,    0,  153,  153,
  153,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  153,    0,  153,  153,    0,    0,  153,    0,
    0,  153,    0,  153,    0,  153,  153,  153,  153,    0,
  153,    0,    0,    0,    0,    0,    0,  153,    0,    0,
  153,  153,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  153,  153,  153,  153,  153,
    0,    0,  153,  153,  153,  381,    0,    0,    0,    0,
    0,    0,  153,    0,    0,    0,    0,    0,  153,  153,
  153,  153,    0,    0,    0,  153,    0,  153,    0,  381,
    0,    0,    0,  153,  153,    0,    0,    0,    0,    0,
    0,    0,  381,    0,    0,    0,    0,  381,    0,    0,
  381,    0,  381,    0,  381,  381,  381,  381,  153,  153,
  153,  153,  381,    0,    0,  153,  381,    0,    0,    0,
  381,    0,    0,   57,   24,    0,   25,    0,  381,   26,
  267,  381,    0,  381,   27,   62,   63,   64,    0,   28,
    0,   24,    0,   25,    0,   66,   26,    0,   30,    0,
    0,   27,  381,    0,    0,   32,   28,  381,    0,    0,
   33,    0,   73,   74,   34,   30,    0,    0,  381,  381,
    0,  306,   32,  381,    0,    0,   36,   33,   37,   77,
    0,   34,   38,    0,    0,   79,  381,   81,    0,   83,
   39,   40,  268,   36,   41,   37,    0,    0,    0,   38,
    0,   89,    0,    0,   90,   91,    0,   39,   40,    0,
    0,   41,    0,    0,   87,    0,    0,    0,  381,   92,
   93,   94,   95,  319,    0,    0,   97,   98,   99,    0,
    0,    0,    0,    0,    0,    0,  320,    0,    0,    0,
  305,    0,  103,  104,  105,  106,    0,    0,    0,  107,
    0,  108,    0,  343,    0,    0,    0,  109,  110,    0,
    0,    0,    0,    0,   57,   24,    0,   25,    0,    0,
   26,  267,    0,    0,    0,   27,   62,   63,   64,    0,
   28,    0,  111,  321,  113,  114,   66,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
  344,   33,    0,   73,   74,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   77,    0,    0,   38,    0,    0,   79,    0,   81,    0,
   83,   39,   40,  268,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,  269,  368,    0,    0,   97,   98,   99,
    0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
    0,    0,    0,  103,  104,  105,  106,    0,    0,    0,
  107,    0,  108,    0,    0,    0,    0,    0,  109,  110,
   57,   24,    0,   25,    0,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
    0,    0,   66,  111,  271,   30,  114,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,  269,
  741,    0,    0,   97,   98,   99,    0,    0,    0,    0,
    0,    0,    0,  320,    0,    0,    0,    0,    0,  103,
  104,  105,  106,    0,    0,    0,  107,    0,  108,    0,
    0,    0,    0,    0,  109,  110,   57,   24,    0,   25,
    0,    0,   26,  267,    0,    0,    0,   27,   62,   63,
   64,    0,   28,    0,    0,    0,    0,    0,   66,  111,
  271,   30,  114,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   73,   74,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   77,    0,    0,   38,    0,    0,   79,    0,
   81,    0,   83,   39,   40,  268,    0,   41,    0,    0,
   87,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   92,   93,   94,  269,  270,    0,    0,   97,
   98,    0,    0,    0,    0,    0,    0,    0,    0,  101,
    0,    0,    0,    0,    0,    0,  724,  725,    0,    0,
   57,   24,    0,   25,  726,    0,   26,  267,    0,    0,
    0,   27,   62,   63,   64,    0,   28,    0,    0,    0,
    0,    0,   66,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,  111,  271,   33,  727,   73,
   74,   34,    0,    0,    0,    0,    0,    0,    0,  315,
    0,    0,    0,   36,    0,   37,   77,    0,    0,   38,
    0,    0,   79,    0,   81,    0,   83,   39,   40,  268,
    0,   41,    0,    0,   87,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,  269,
  270,    0,    0,   97,   98,    0,    0,    0,   57,   24,
    0,   25,    0,  101,   26,  267,    0,    0,    0,   27,
   62,   63,   64,    0,   28,    0,    0,    0,    0,    0,
   66,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   73,   74,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  111,
  271,   36,    0,   37,   77,    0,    0,   38,    0,    0,
   79,    0,   81,    0,   83,   39,   40,  268,    0,   41,
    0,    0,   87,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,  269,  270,    0,
    0,   97,   98,    0,    0,    0,   57,   24,    0,   25,
    0,  101,   26,  267,    0,    0,    0,   27,   62,   63,
   64,    0,   28,    0,  205,    0,  205,    0,   66,  205,
    0,   30,    0,    0,  205,    0,    0,    0,   32,  205,
    0,    0,    0,   33,    0,   73,   74,   34,  205,    0,
    0,    0,    0,    0,    0,  205,    0,  111,  271,   36,
  205,   37,   77,    0,  205,   38,    0,    0,   79,    0,
   81,    0,   83,   39,   40,  268,  205,   41,  205,    0,
   87,    0,  205,    0,    0,    0,    0,    0,    0,    0,
  205,  205,    0,    0,  205,    0,    0,  205,    0,    0,
    0,    0,   92,   93,   94,  269,  555,    0,    0,   97,
   98,    0,    0,    0,    0,   24,    0,   25,    0,  101,
   26,    0,    0, 1552,    0,   27,    0,    0,  819,    0,
   28,    0,  820, 1553, 1554,    0,  205, 1151, 1555,   30,
    0,    0,    0,    0, 1556,    0,   32,    0,    0,    0,
    0,   33,    0,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0, 1028,  111,  556,   36,    0,   37,
    0,    0,    0,   38,    0,    0,    0,    0,    0,    0,
    0,   39,   40,  205,    0,   41,    0,    0, 1557,   24,
    0,   25,    0, 1558,   26,    0,    0, 1552,    0,   27,
    0,    0,  819,    0,   28,    0,  820, 1553, 1554,    0,
    0,    0, 1555,   30,    0,    0,    0,    0, 1556,    0,
   32,   53,    0,   53,    0,   33,   53,  343,    0,   34,
    0,   53,    0, 1559,    0,    0,   53,    0, 1028,    0,
    0,   36,    0,   37,    0,   53,    0,   38,    0,    0,
    0,   53,   53,    0,    0,   39,   40,   53,    0,   41,
    0,   53, 1557,   53,    0,   53,    0, 1558,    0,    0,
   53,    0,    0,   53, 1560,   53,    0,    0,    0,   53,
    0,    0,   53,    0,    0,    0,    0,   53,   53,    0,
    0,   53,    0,    0,   53,   53,    0,   53,    0,    0,
   53,  343,    0,    0,    0,   53,    0,    0,    0,    0,
   53,    0,    0,    0,    0,    0,    0,    0,    0,   53,
    0,    0,    0,    0,    0,   53,   53,    0,    0,    0,
    0,   53,    0,   53,  185,   53,    0,   53,    0,   53,
    0,    0,    0,    0,   53,    0,    0,   53, 1560,   53,
    0,    0,    0,   53,    0,    0,   53,    0,    0,    0,
    0,   53,   53,    0,    0,   53,    0,    0,   53,   24,
    0,   25,    0,    0,   26,    0,    0,    0,    0,   27,
   53,    0,    0,    0,   28,    0,    0,    0,    0,    0,
    0,    0,    0,   30,    0,    0,    0,    0,    0,  655,
   32,    0,    0,    0,    0,   33,  185,   53,    0,   34,
    0,  656,    0,    0,    0,    0,    0,    0,  657,    0,
    0,   36,    0,   37,    0,    0,    0,   38,    0,    0,
  658,    0,    0,    0,    0,   39,   40,    0,    0,   41,
    0,    0,  606,   54,    0,   54,    0,    0,   54,    0,
    0,    0,    0,   54,   53,    0,    0,    0,   54,    0,
    0,    0,    0,    0,    0,    0,    0,   54,  659,    0,
    0,    0,    0,   54,   54,    0,    0,    0,    0,   54,
    0,  343,    0,   54,    0,   54,    0,   54,    0,    0,
    0,    0,   54,    0,    0,   54,    0,   54,    0,    0,
    0,   54,    0,    0,   54,    0,    0,    0,    0,   54,
   54,    0,   53,   54,   53,    0,   54,   53,    0,    0,
    0,    0,   53,    0,    0,    0,    0,   53,  660,    0,
    0,    0,    0,    0,    0,    0,   53,    0,    0,    0,
    0,    0,   53,   53,    0,    0,    0,    0,   53,    0,
    0,    0,   53,    0,   53,   54,   53,    0,    0,    0,
    0,   53,    0,    0,   53,    0,   53,    0,    0,    0,
   53,    0,    0,   53,    0,    0,    0,    0,   53,   53,
    0,   24,   53,   25,    0,   53,   26,    0, 1484,    0,
    0,   27,    0,    0,    0,    0,   28,    0,    0,    0,
    0,    0,   54,    0,    0,   30,    0,    0,   53,    0,
   53,    0,   32,    0,    0,    0,    0,   33,    0, 1485,
    0,   34,    0,    0,   53,    0,    0,    0,    0,    0,
    0,    0,   53,   36,    0,   37,    0,    0,    0,   38,
 1486,    0,    0,    0,    0,   53,    0,   39,   40,    0,
   53,   41,    0,    0,   87,   53,    0,   53,   53,   53,
   53,    0,    0,    0,    0,   53,    0,    0,    0,   53,
    0,   53,    0,    0,    0,   53,    0,   53,    0,    0,
    0,   53,    0,    0,   53,    0,   53,    0,    0,    0,
    0,    0,    0,  343,    0,    0,    0,    0,    0,   53,
    0,    0,    0,    0,    0,  506,    0,    0,    0,    0,
   53,    0,   53,    0,    0,    0,    0,   53,    0,    0,
    0,  339,   53,    0,   53,   53,   53,   53,    0,  507,
   53,    0,   53,    0,    0,    0,   53,  506,    0,    0,
  406,    0,  508,    0,    0,    0,  509,  510,   53,    0,
    0,   53,  511,   53,  512,  513,  514,  515,    0,    0,
    0,  507,  516,    0,    0,    0,  517,    0,    0,    0,
    0,    0,    0,    0,  508,    0,    0,   53,  518,  510,
    0,  519,    0,  520,  511,    0,  512,  513,  514,  515,
    0,    0,    0,    0,  516,    0,    0,    0,  517,    0,
    0,    0,    0,    0,    0,    0,    0,  521,    0,    0,
  518,  381,    0,  519,    0,  520,    0,  381,  381,    0,
    0,    0,    0,    0,    0,    0,    0,  902,  381,    0,
  381,  902,  381,  902,    0,    0,    0,    0,    0,  521,
  902,    0,    0,    0,    0,  381,    0,    0,    0,    0,
    0,  381,  381,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  381,    0,    0,    0,    0,    0,  381,    0,  381,
    0,    0,  381,    0,    0,    0,    0,    0,    0,    0,
    0,  902,
  };
  protected static readonly short [] yyCheck = {            17,
    4,   18,  314,   52,  573,  313,   17,   52,  303,  203,
  247,   76,  523,  245,  202,  575,  375,  342,   90,   91,
  768,  545,  312,  333,   17,    6,  206,  358,   17,  445,
  445,  445,  125,  343,  312,  637,  171,  651,  426,  310,
  415,  260,  114, 1342,  889,  405,  343,  425,   59,  123,
   45,  125,  887,   48, 1082, 1086,    0,   60,   76, 1067,
 1130,  268,   80,  256,  268, 1387,   17,  415, 1390,  256,
  256,   82,   75,   84,  676,  353,  266,  256,  256,   97,
  855,  256,  857,  101,  256,  256,  256,  295,  256,  256,
  268,  256,  256,  256,  187,  405,  256,  115, 1382,  307,
   60,  382,  256, 1458,  256,  378,  374,  256,  344,   60,
  256,  256,  256,  256,   65,   75,  283,  380,  400,  401,
  256, 1443,  256, 1335,   75,  315,  256, 1339,  903,  342,
   17,  906,  407, 1492,  256,  256,  256,  373,  210,  211,
  256,  101,   17,  374,  419,   17,  256,   17,  315,  380,
  101,  424, 1511,  171,  203,  115,   70,  438,  203,  422,
  171,  340,  375, 1447,  115,  256,  345,  374,  347,  256,
  438,  350,  351,   17,  353,  354,   90,   91,  171, 1534,
  528,   95,  171,  376,  352,  378,  373,  380,  466, 1624,
  377,  381,  322,   17, 1222,  381,  245,  256,  373,  359,
  245,  380,  377,  774,  276,  119,  425,   17,  779,  780,
  373,  381,  375,  377,  377,  387,  424, 1287,  340,  364,
  171,  428,  387,  345,  428,  347,  397,   17,  350,  351,
  302,  353,  354,  382,  377,  381, 1081,  151,  569,  426,
  235,  616,  260,  364,   17,  438,  256,  256,  266,  420,
  428,  426,  345,  387,  491,  327,  427,  424,  490,  438,
  241, 1289,  426,  426,  572,  625,  429,  341,  616,  256,
  424,  345,  424,  433,  434,  435,  436,   17,  637,  424,
  424,  355,  630,  426,  171,  303, 1317, 1295,  424,  380,
  308,  309,   17,  365,  366,  382,  171,  300,  858,  171,
  318,  171,  320,  424,  424,  683,  272,  310,  424,  923,
  328,  686,  315,  257,  424,  625,  438,  676,  336, 1754,
  338,  256,  381,  503,  342, 1467,  337,  171,  400, 1688,
  256,  297,  364,  681,  256,  256,  256,  359,  686,  687,
  300,  359,  360, 1778, 1779,  259,  260,  171,  269,  300,
 1785, 1786,  662,  256,  272,  315, 1201, 1716,  324,  273,
  256,  171,  268,  257,  315,  662,  287,  256,  378, 1728,
  276, 1730,  444,  382,  278,  295, 1124,  364,  338,  297,
  256,  171,  375, 1682,  306,  256,  375,  338,  256,  376,
  336,  378,  424,  380,  295,  413,  310,  462,  171,  336,
  472,  473,  316,  256,  256, 1617,  324,  425,  426,  344,
    0,  256,  430,  431,  432,  433,  434,  435,  436,  437,
  438,  439,  440, 1258,  375, 1567,  256, 1749,  256,  256,
 1205,  171, 1574,  347,  794, 1647, 1648,  424,  373, 1651,
  256,  490,  445,  357,  462,  490,  171,  382,  256,  498,
  256, 1663,  378,  498, 1666,  369,  768,  358,  364, 1781,
  364, 1603,  326,  364,  683,  431,  432,   63, 1039, 1681,
 1041,   67,   68,   69,  375,   71,   72,  380,  379,  867,
  376,   77,   78,  793,  380,  445,  256,   83,   84,  378,
   86,  392,   88, 1705,  445,  409,  793,   93,   94,  494,
  495,  438,  373,  417,  380,  500, 1077,  421,  256,  819,
  378,  425,  426,  431,  432,  256, 1291,  842,  424, 1079,
  424,  425,  256,  424,  340,  378,  378,  538,  124,  345,
  364,  347,  377, 1057,  350,  351,  911,  353,  354,  364,
  326,  256,   90,   91,  374,  373,  266,  375, 1597,  272,
  380,  378,  278,  571,  256,  573,  282,  575,  472,  473,
  424,  374,  476,  911,  801,  257,  114,  375,  380,  375,
  263, 1142,  342, 1144,  297,  256, 1147,  374,  374,  262,
 1355,  592,  374,  264,  269,  545,  382,  947,  976,  860,
  424, 1366,  374,  378,  545,  315,  614,  834,  908,  424,
  618,  324,  287,  437,  306,  375,  374,  341,  827,  789,
  422,  908,  437,  631,  962,  633,  299,  343,  629, 1668,
 1395, 1235,  438,  316,  642,  438,  424,  375,  646,  647,
  544,  378,  546,  378,  375,  728, 1242,  947,  424, 1199,
  651,  438,  438,  378,  637,  326,  438,  650,  637,  667,
  256,  366,  670,  438,  728,  727,  438,  344,  374,  573,
  366,  381,  210,  211,  380,  683,  580,  257,  379,  672,
  438,  377,  268,  691,  692,  693,  272, 1248,  263, 1250,
  374, 1252,  272,  676,  306, 1045,  637,  676,  278,  603,
  650,  438,  282,  438,  272, 1301,  256, 1474, 1312,  650,
  278,  384,  385,  438,  282,  374,  344,  297,  431,  432,
  397,  374,  672, 1718, 1719,  378,  312,  380,  429,  297,
  426,  672,  438,  358,  387,  676,  306,    0,  276,  377,
  424,  316,  692,  420,  324, 1043, 1046,  872,  344, 1337,
  427,  692, 1073,  381, 1474, 1522,  324,  661,  375, 1046,
  437,  377,  379,  343,  302,  424,  774,  392,  672,  397,
 1362,  779,  780,  982,  782,  343,  314,  373,  682,  683,
 1775,  377,  256,  379,  380,  438,  382, 1474,  426,  327,
  340,  387,  420, 1473, 1474,  345, 1384,  347, 1078,  427,
  350,  351, 1522,  353,  354,  358, 1474,  373, 1076,  437,
 1371,  377,  429,  379,  380, 1495,  382, 1555,  344,  827,
 1474,  387, 1124,  375,  907,  421,  379,  365,  366,  733,
  380,  382,  344,  895,  842, 1522, 1242, 1242, 1242,  392,
  382, 1474, 1522, 1474, 1524, 1474, 1407,  373,  377,  820,
  858,  431,  432, 1023, 1522,  421,  918,  865, 1200,  867,
  344,  344,  400,  431,  432,  373,  340,  860, 1522,  340,
  392,  345,  776,  347,  778,  387,  350,  351,  397,  353,
  354,  943, 1396,  787,  377,  397, 1228, 1202,  438, 1522,
  373, 1522,  358, 1522,   17,  896,   21,  898, 1459,  382,
  256,  420,  373,  387,  390,  913,  444,  373,  420,  917,
  381, 1470,  256,  397,  855,  427,  857, 1478, 1216,  927,
  921,  344,  923,  827,  391,  437,  392,  340,   53,  984,
  256,  344,  344,  340,  472,  473,  420,   60,  340,  340,
  995,  845,   65,  427,  952,  395,  954,  940,  387,  374,
  373, 1160,   75,  437,  540,  380,  860, 1306,  397,  382,
  373,  373,  903,  867,  438,  906,  373, 1578,  976,  382,
  382,  373,  373, 1151,  982,  377,  984,  406,  101, 1018,
 1591,  420,  344, 1018,  340, 1047,  994, 1157,  427,  345,
  940,  347,  115,  256,  350,  351,  340,  353,  354,  940,
  397,  345,  256,  347, 1615,  591,  350,  351,  344,  353,
  354,  373,  344, 1362,  340,  380, 1301,  382,  396,  345,
  382,  347,  387,  420,  350,  351,  295,  353,  354,  340,
  427, 1039,  340, 1041,  358, 1043,  420,  373,  307,  358,
  437,  373,  946,  427, 1342,  314,  382,  344,  171,  256,
  382, 1059,  956,  375,  295,  379, 1064,  326, 1029, 1067,
 1345,  295,  373,  404,  405,  373,  307, 1038,  392, 1077,
  974, 1079,  976,  307,  424,  309,  373,  340,  982,  421,
  314,  344,  438,  397,  376,  989,  340,  424,  380, 1039,
 1591,  345,  326,  347,  438,  375,  350,  351, 1039,  353,
  354,  256,  256, 1165,  307, 1167,  420,  387, 1393, 1458,
  373,  314,  438,  427,  377,  278,  379,  380,  381,  382,
 1670,  374,  374, 1332,  387,  378,  378,  382, 1136,  382,
  382,  374,  379,  340, 1142,  382, 1144,  380,  345, 1147,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  374, 1160,  374,  376,  377,  382,  380,  380,  380,
  367,  368,  374,  375,  388,  389,  387,  374,  378,  376,
  380,  378,  382,  380,  381,  382,  376,  300,  402,  403,
  380,  379, 1086, 1733,  382, 1534,  379, 1414, 1410,  727,
  344, 1199,  315,  373, 1202, 1480, 1380,  378, 1169,  380,
 1171,  382,  256,  376,  377, 1267,  379,  380,  381,  376,
  376,    6,  378,  380,  380,  338,  424, 1225,  379,  373,
 1770,  382,   17,  377, 1128,  379,  380,  377,  382,  379,
  768,  438,  379,  387, 1235, 1535, 1795, 1796,  380,  381,
 1248,  376, 1250, 1543, 1252,  380,  377, 1255,  379, 1242,
 1588,  295,  375, 1555,  376,  376, 1160,  378,  380,  380,
  295, 1316,  376,  376, 1205,   60,  380,  380,  344, 1607,
   65,  377, 1266,  374,  376,  381,  380,  378,  380, 1183,
   75,  378,  374,  380,  382, 1189,  378, 1295, 1626,  373,
 1628,  375, 1242, 1301,  374,   90,   91,  378,  378,  380,
  382, 1242,  450,  451,  452,  453,  101, 1315, 1316,  424,
  378, 1312,  380,  392,  393,  394,  378,  378,  380,  114,
  115,  380,  445, 1306, 1332,  382, 1333, 1306,  378,  378,
  380,  380,  357,  378, 1342,  380,  378, 1345,  380,  424,
 1244, 1380,  380, 1382,  382, 1380,  375, 1382,   90,   91,
 1291, 1301,  376,  380,  378,  382,  365,  895,  381,  376,
 1301,  378,  376, 1371,  378, 1306,  367,  368,  377, 1377,
  379, 1410,  114,  355,  356, 1410,  171,  374,  375, 1362,
  918,  355,  356, 1362, 1682, 1393,  376,  420,  378,  398,
  399,  378,  378,  380,  380,  376,  376,  378,  378, 1407,
 1408,  380,  380,  382,  382,  943,  370,  371, 1447,  418,
 1472,  378, 1447, 1317, 1355,  210,  211,  426,  420,  421,
  429, 1362,  545,  378,  380, 1366,  382,  380, 1332,  382,
  367,  368,  382,  365, 1473, 1474,  367,  368, 1473, 1474,
  370,  371,  374,  692,  693,  377,  387,  379,  380,  646,
  647, 1459,  446,  447, 1395,  374, 1495,  448,  449,  380,
 1495,  378, 1470,  438,  206,  378,  398,  399,  210,  211,
 1478, 1533, 1480,  424,  295, 1458,  424,  454,  455, 1458,
  295,  276,  380, 1522,  378, 1524,  418, 1522,  378, 1524,
 1552, 1553,  380,  380,  426,  378,  387,  429, 1084,  256,
  382,  387,  437,  437,  377,  300,  438,  302,  256, 1047,
 1808,  381,  295,  295,  637,  387,  424, 1458, 1580,  314,
  315, 1583,  378,  380,  358,  379,  261,  650,  381,  380,
  364,  379,  327,  378,  276,  424,  380, 1538,  333,  380,
  387,  375,  380,  338,  378,  379,  380,  382,  343,  672,
  285, 1534,  380,  676,  438, 1534,  378,  380,  392,  373,
  302,  429,  380,  298,  381, 1573, 1470,  378,  303,  692,
  365,  366,  314,  308,  423,  310,  311,  312,  313,  344,
  375,  424,  380,  318,  378,  327, 1124,  322,  314,  429,
  424,  333, 1600, 1534,  295,  295, 1597,  424,  376,  334,
  380,  343,  337,  377,  339,  400,  373,  313,  424,  381,
  405,  256,  324,  256,  380,  256,  387,  281,  256,  373,
  378, 1660, 1526,  365,  366, 1660,  344, 1165,  363, 1167,
  374,  424,  382,  299,  377,  376,  382,  382, 1677,  376,
  380,  380, 1677,    0,  378,  429,  382,  378,  378,  444,
  445, 1690, 1691,  423,  387, 1690, 1691,  376,  400,  387,
  348,  377, 1670,  405,  373,  387,  387, 1668,  256,  256,
  378,  382,  374,  348, 1682,  378,  380,  472,  473, 1718,
 1719,  376,  387, 1718, 1719,  381,  376,  376,  340,  424,
  381, 1699,  424,  378,  378,  373,  261,  374,  349,  424,
  380,  377,  444,  408,  409,  410,  411,  412,  413,  414,
  415,  416,  417,  349,  424,   90,   91,  256,  374,  373,
  285,  382,  387,  373,  373, 1733,  374,  357,  374, 1267,
  472,  473,  855,  298,  857,  382, 1775,  377,  303,  114,
 1775,  378,  374,  308,  378,  310,  311,  312,  313,  380,
  545,  316,  374,  318,  338,  374,  306,  322,  375,  377,
  373,  503, 1770,  377,  424,  424,  382,  424,  377,  334,
  382,  424,  337,  377,  339,  377,  387, 1778, 1779,  379,
  903,  373,  344,  906, 1785, 1786,  377, 1795, 1796,  382,
  387,  377,  375,  378,  256,  424,  378,  261,  363,  380,
 1808,  379,  379,  382,  380,  380,  380,  378,  378,  374,
  375,  316,  376,  382,  424,  382,  424,  940,  378,  424,
  378,  285,  378,  382,  387,  374,  387,  378,  376,  374,
  625,  206,  263,  377,  298,  210,  211,  377,  374,  303,
  387,  378,  637,  378,  308, 1383,  310,  311,  312,  313,
  382,    0,  424,    0,  318,  650,  373,  382,  322,  374,
  382,  380,  326,    0,  378,  374,  382,  662,  378,  373,
  334,  378,  424,  337,  376,  339,  382,  672,  374,  378,
  374,  676,    0,  625,  382,  376,  373,  382,  374,  378,
  424, 1795, 1796,  378,  382,  374,  378,  692,  382,  363,
  257,  276,  374,  373,  261,  374,  382,  374,  379,  382,
  316, 1449,  263,   51,  382,  272, 1039,  382,   12,  382,
  662,  278,  382,  382,  382,  282,  382,  302,  285,    5,
 1157, 1039,  727, 1023, 1472, 1524, 1332, 1332, 1495,  314,
  297,  298, 1551, 1685, 1723,  302,  303, 1340,  819, 1739,
 1673,  308,  327,  310,  311,  312,  313, 1702,  333, 1535,
  424,  318, 1561, 1510, 1600,  322,  833,  324,  343, 1598,
 1578, 1763, 1050,  768, 1045, 1050, 1050,  334, 1786,  336,
  337, 1522,  339, 1695, 1691,  727,  343, 1690, 1779, 1447,
  365,  366,  256, 1628, 1561, 1533, 1018,  333,  793,  908,
 1093, 1449,  865, 1073,   73,  633,  363,  827,  860,  982,
 1216,  361, 1242, 1244, 1552, 1553,  456, 1555,  375,  457,
  459,  458,  994,  947,  819,  400,  768,  460, 1337,  461,
  405,  625, 1533, 1425, 1306,  171, 1228, 1316, 1304, 1185,
  413, 1306, 1580, 1396, 1365, 1583,  481,  789, 1528, 1090,
  593,  793,  481, 1408, 1020, 1013,  785,   -1,   -1,   -1,
  855,   -1,  857,   -1,   -1,   -1,    0,   -1,   -1,  444,
   -1,   -1,   -1,   -1,  431,  432,  340,  819,   -1,   -1,
   -1,  345, 1205,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,   -1,   -1,   -1,  472,  473,   -1,
  895,   -1,   -1,  367,  368,   -1,   -1,   -1,  903,   -1,
  374,  906,  376,  908,  378,   -1,  380,  381,  382, 1242,
   -1,   -1,   -1,  918,   -1,   -1,   -1,   -1,  503,   -1,
   -1,   -1,  396,   -1,   -1,   -1,   -1,   -1,   -1,  257,
   -1,   -1,   -1,  261,   -1,  940,   -1,   -1,  943,   -1,
   -1,   -1,  947,  895,  272,   -1,   -1,   -1,   -1,   -1,
  278,   -1,   -1,   -1,  282,   -1,  908,  285, 1291,   -1,
   -1,   -1,   -1,   -1,  438,   -1,  918,   -1, 1301,  297,
  298,   -1,   -1, 1306,  302,  303,   -1,   -1,   -1,   -1,
  308,   -1,  310,  311,  312,  313,   -1,   -1,   -1,   -1,
  318,  943,   -1,   -1,  322,  947,  324,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,  337,
   -1,  339,   -1,   -1,   -1,  343,   -1,   -1,   -1,   -1,
   -1,   -1, 1355,   -1,   -1,   -1,   -1,   -1,   -1, 1362,
   -1,   -1,   -1, 1366, 1039,  363,   -1,   -1,   -1,   -1,
  625, 1046, 1047,   -1,   -1,   -1,   96,  375,   -1,   99,
   -1,   -1,   -1,  103,  104,  105,  106,  107,  108,  109,
  110,   -1, 1395,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1, 1023,   -1,   -1,   -1,   -1,   -1,  662,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1, 1046, 1047,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  431,  432,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,  257,   -1,   -1,   -1,  261,   -1, 1124,
   -1,  265,   -1,  267,   -1, 1458,  270,   -1,  272,  273,
   -1,  275,   -1,   -1,  278,   -1,  280,   -1,  282,  283,
  284,  285,  727,   -1,  288,  289,   -1,   -1,   -1,   -1,
  294,   -1,  296,  297,  298,   -1,   -1,  301,  302,  303,
 1165,  305, 1167,   -1,  308,   -1,  310,  311,  312,  313,
  314,   -1, 1124,  317,  318,  319,   -1,   -1,  322,  323,
  324,   -1,   -1,  768,   -1,   -1,   -1,  331,  332,   -1,
  334,  335,   -1,  337,  338,  339,   -1,   -1,   -1,  343,
 1205, 1534,   -1,    0,  789, 1157,   -1,   -1,  793,   -1,
   -1,   -1,   -1, 1165,   -1, 1167,   -1,   -1,   -1,  363,
   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,   -1,  373,
  374,  375,   -1,  377,  819,   -1,   -1, 1242,   -1,  383,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  285,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  298, 1267,   -1,   -1,   -1,  303,   -1,   -1,  319,
  261,  308,  263,  310,  311,  312,  313,   -1,   -1,   -1,
  424,  318,   -1,   -1,   -1,  322, 1291,  431,  432,  326,
   -1,   -1,   -1,   -1,  285,   -1, 1301,  334,   -1,   -1,
  337, 1306,  339,   -1,   -1,   -1,   -1,  298,  358,   -1,
  895,   -1,  303,   -1,   -1, 1267,   -1,  308,  368,  310,
  311,  312,  313,  908,   -1,   -1,  363,  318,   -1,   -1,
  256,  322,   -1,  918,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,  339,   -1,
 1355,   -1,   -1,   -1,   -1,   -1,   -1, 1362,  943,    0,
   -1, 1366,  947,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 1383,   -1,
   -1,   -1,   -1,  374,  375,   -1,   -1,  424,   -1,   -1,
 1395,  441,  442,  443,   -1,   -1,  446,  447,  448,  449,
  450,  451,  452,  453,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,
   -1,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356, 1383,   -1,   -1,   -1,   -1,   -1,   -1, 1023,   -1,
   -1,  367,  368,   -1, 1449,   -1,   -1,   -1,  374,   -1,
  376,   -1,  378, 1458,  380,  381,  382,   -1,   -1,   -1,
  257, 1046, 1047,   -1,  261,   -1,   -1, 1472,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  272,   -1,   -1,   -1,   -1,
   -1,  278,   -1,   -1,   -1,  282,   -1,   -1,  285,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1449,   -1,   -1,
  297,  298,   -1,   -1,   -1,  302,  303,   -1,   -1,   -1,
   -1,  308,  438,  310,  311,  312,  313,   -1,   -1,  569,
 1472,  318,   -1,   -1,   -1,  322,   -1,  324, 1533, 1534,
 1535,   -1,   -1,   -1,   -1,   -1,   -1,  334, 1543, 1124,
  337,   -1,  339,   -1,   -1,   -1,  343, 1552, 1553,   -1,
 1555,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,
   -1,   -1, 1157,   -1,   -1, 1580,   -1,   -1, 1583,   -1,
 1165, 1533, 1167, 1535,   -1,   -1,   -1,   -1,   -1,   -1,
   -1, 1543,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 1552, 1553,   -1, 1555,   -1,   -1,   -1,   -1,   -1, 1561,
   -1,   -1,   -1,   -1,   -1,  256,  666,   -1,   -1,   -1,
  261,  262,   -1,   -1,   -1,   -1, 1578,   -1, 1580,   -1,
   -1, 1583,   -1,   -1,  431,  432,   -1,   -1,   -1, 1591,
   -1,   -1,   -1,   -1,  285,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,
   -1,   -1,  303, 1615,   -1,  306,   -1,  308,   -1,  310,
  311,  312,  313,   -1,  724,  725,   -1,  318,   -1,   -1,
   -1,  322, 1267,   -1,   -1,  326,   -1,   -1,   -1,   -1,
   -1,  741,   -1,  334,   -1,   -1,  337,   -1,  339,  340,
   -1,   -1,   -1,  344,  345,   -1,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,
   -1,   -1,  363,  364,  365,   -1,  367,  368,   -1,   -1,
   -1,   -1,  373,  374,   -1,  376,  377,  378,  379,  380,
  381,  382,   -1,  384,  385,   -1,  387,  388,  389,  390,
  391,  392,  393,  394,  395,  396,   -1,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,  414,  415,  416,  417,  418,  419,   -1,
    0,  422,   -1,  424,   -1,  426,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438, 1383,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  864,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,  266,  267,
  268,   -1,  270,  271, 1449,  273,  274,  275,  276,  277,
  278,  279,  280,  281,   -1,   -1,   -1,   -1,  286,   -1,
  288,  289,  290,  291,  292,  293,   -1, 1472,  296,    0,
   -1,   -1,  300,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,  315,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,  336,   -1,
  338,   -1,   -1,  341,  342,   -1,   -1,  345,  346,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1533,   -1,
 1535,   -1,  360,  361,  362,  363,  364,   -1, 1543,  367,
  368,  369,   -1,   -1,   -1,  373,  374, 1552, 1553,  377,
 1555,   -1,   -1,   -1,  382,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,
  398,  399,   -1,   -1,   -1, 1580,   -1,   -1, 1583,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  423,  424,  425,  426,   -1,
  428,   -1,  430, 1073,   -1,   -1,   -1,   -1,   -1,   -1,
  438,   -1,   -1,   -1,   -1,   -1,  256,  257,   -1,   -1,
   -1,    0,   -1,   -1,  264,  265,  266,  267,  268,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,  289,
  290,  291,  292,  293,   -1,   -1,  296,   -1,   -1,   -1,
  300,  301, 1132,  303,  304,  305,   -1,   -1, 1138,   -1,
   -1,   -1,   -1,   -1,  314,  315,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,  336,   -1,  338,   -1,
   -1,  341,  342,   -1,   -1,  345,  346,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,  256,   -1,  367,  368,  369,
  261,  262,   -1,  373,  374,   -1,   -1,  377,   -1,   -1,
   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,  285,   -1,   -1,   -1,  398,  399,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,
   -1,   -1,  303,    0,   -1,  306,   -1,  308,   -1,  310,
  311,  312,  313,  423,  424,  425,  426,  318,  428,   -1,
  430,  322,   -1,   -1,   -1,  326,   -1,   -1,  438,   -1,
   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,  339,  340,
   -1,   -1,   -1,  344,  345,   -1,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,   -1,   -1,
   -1,   -1,  363,  364,   -1,   -1,  367,  368,   -1,   -1,
   -1,   -1,  373,  374,  375,  376,  377,  378,  379,  380,
  381,  382,   -1,  384,  385,   -1,   -1,  388,  389,  390,
  391,  392,   -1,   -1,  395,  396,   -1,   -1,   -1,  400,
  401,  402,  403,  404,  405,  406,  407,  256,   -1,   -1,
   -1,   -1,  261,  262,   -1,   -1,   -1,   -1,  419,   -1,
   -1,  422,   -1,  424,   -1,  426,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  285,  438,   -1,    0,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,
  299,   -1,   -1,   -1,  303,   -1,   -1,   -1,   -1,  308,
   -1,  310,  311,  312,  313,   -1,   -1,   -1,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,  326,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,
  339,  340,   -1,   -1,   -1,  344,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
   -1,   -1,   -1,   -1,  363,  364,   -1,   -1,  367,  368,
   -1,   -1,   -1,   -1,  373,  374,  375,  376,  377,  378,
  379,  380,  381,  382,   -1,  384,  385,   -1,   -1,  388,
  389,  390,  391,  392,   -1,   -1,  395,  396,   -1,   -1,
   -1,  400,  401,  402,  403,  404,  405,  406,  407,  256,
   -1,   -1,   -1,   -1,  261,  262,   -1,   -1,   -1,   -1,
  419,   -1,   -1,  422,   -1,  424,   -1,  426,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  285,  438,
   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  298,  299,   -1,   -1,   -1,  303,   -1,   -1,  306,
   -1,  308,   -1,  310,  311,  312,  313,   -1,   -1,   -1,
   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,  326,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,
  337,   -1,  339,  340,   -1,   -1,   -1,  344,  345,   -1,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,  363,  364,   -1,   -1,
  367,  368,   -1,   -1,   -1,   -1,  373,  374,  375,  376,
  377,  378,   -1,  380,  381,  382,   -1,  384,  385,   -1,
   -1,  388,  389,  390,  391,  256,   -1,   -1,  395,  396,
  261,  262,   -1,  400,  401,  402,  403,  404,  405,  406,
  407,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  419,   -1,  285,  422,   -1,  424,   -1,  426,
   -1,   -1,  429,   -1,   -1,   -1,   -1,  298,  299,   -1,
   -1,  438,  303,    0,   -1,  306,   -1,  308,   -1,  310,
  311,  312,  313,   -1,   -1,   -1,   -1,  318,   -1,   -1,
   -1,  322,   -1,   -1,   -1,  326,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,  339,  340,
   -1,   -1,   -1,  344,  345,   -1,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,
   -1,   -1,  363,  364,   -1,   -1,  367,  368,   -1,   -1,
   -1,   -1,  373,  374,  375,  376,  377,  378,   -1,  380,
  381,  382,   -1,  384,  385,   -1,   -1,  388,  389,  390,
  391,   -1,   -1,   -1,  395,  396,   -1,   -1,   -1,  400,
  401,  402,  403,  404,  405,  406,  407,  256,   -1,   -1,
   -1,   -1,  261,  262,   -1,   -1,   -1,   -1,  419,   -1,
   -1,  422,   -1,  424,   -1,  426,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  285,  438,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,
  299,   -1,   -1,   -1,  303,   -1,   -1,    0,   -1,  308,
   -1,  310,  311,  312,  313,   -1,   -1,   -1,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,  326,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,
  339,  340,   -1,   -1,   -1,  344,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,   -1,
   -1,   -1,   -1,   -1,  363,  364,   -1,   -1,  367,  368,
   -1,   -1,   -1,   -1,  373,  374,  375,  376,  377,  378,
   -1,  380,  381,  382,   -1,  384,  385,   -1,   -1,  388,
  389,  390,  391,   -1,    0,   -1,  395,  396,   -1,   -1,
   -1,  400,  401,  402,  403,  404,  405,  406,  407,  256,
   -1,   -1,   -1,   -1,  261,  262,   -1,   -1,   -1,   -1,
  419,   -1,   -1,  422,   -1,  424,   -1,  426,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  285,  438,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  298,  299,   -1,   -1,   -1,  303,   -1,   -1,  306,
   -1,  308,   -1,  310,  311,  312,  313,   -1,    0,   -1,
   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,  326,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,
  337,   -1,  339,  340,   -1,   -1,   -1,  344,  345,   -1,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,  363,  364,   -1,   -1,
  367,  368,   -1,   -1,   -1,   -1,  373,  374,   -1,  376,
  377,  378,   -1,  380,  381,  382,   -1,  384,  385,   -1,
   -1,  388,  389,  390,  391,   -1,   -1,   -1,  395,  396,
   -1,    0,   -1,  400,  401,  402,  403,  404,  405,  406,
  407,   -1,   -1,   -1,  257,   -1,   -1,   -1,  261,   -1,
   -1,   -1,  419,   -1,   -1,  422,   -1,  424,   -1,  272,
   -1,   -1,   -1,   -1,   -1,  278,   -1,   -1,   -1,  282,
   -1,  438,  285,   -1,    0,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  297,  298,   -1,   -1,   -1,  302,
  303,   -1,  261,   -1,   -1,  308,   -1,  310,  311,  312,
  313,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,  322,
   -1,  324,   -1,   -1,   -1,   -1,  285,   -1,   -1,   -1,
   -1,  334,   -1,  336,  337,   -1,  339,   -1,   -1,  298,
  343,  257,   -1,   -1,  303,  261,   -1,   -1,   -1,  308,
   -1,  310,  311,  312,  313,   -1,  272,   -1,   -1,  318,
  363,   -1,  278,  322,   -1,   -1,  282,    0,   -1,  285,
   -1,  374,  375,   -1,   -1,  334,   -1,   -1,  337,   -1,
  339,  297,  298,   -1,   -1,   -1,  302,  303,   -1,   -1,
   -1,   -1,  308,   -1,  310,  311,  312,  313,   -1,   -1,
   -1,   -1,  318,   -1,  363,   -1,  322,   -1,  324,   -1,
    0,  370,  371,   -1,   -1,  257,   -1,   -1,  334,  261,
   -1,  337,   -1,  339,   -1,   -1,   -1,  343,  431,  432,
  272,   -1,   -1,   -1,   -1,   -1,  278,   -1,   -1,   -1,
  282,   -1,   -1,  285,   -1,   -1,   -1,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  297,  298,  373,  374,  375,
  302,  303,   -1,   -1,   -1,   -1,  308,   -1,  310,  311,
  312,  313,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
  322,   -1,  324,   -1,    0,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  334,   -1,   -1,  337,   -1,  339,  257,   -1,
   -1,  343,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  272,   -1,  431,  432,   -1,   -1,  278,
   -1,  363,   -1,  282,   -1,   -1,  285,   -1,   -1,   -1,
   -1,   -1,  374,  375,   -1,   -1,   -1,   -1,  297,  298,
   -1,  257,   -1,  302,  303,  261,   -1,   -1,    0,  308,
   -1,  310,  311,  312,  313,   -1,  272,   -1,   -1,  318,
   -1,   -1,  278,  322,   -1,  324,  282,   -1,   -1,  285,
   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,
  339,  297,  298,   -1,  343,   -1,  302,  303,   -1,  431,
  432,   -1,  308,   -1,  310,  311,  312,  313,   -1,   -1,
   -1,   -1,  318,   -1,  363,   -1,  322,   -1,  324,   -1,
   -1,   -1,   -1,   -1,   -1,  374,  375,   -1,  334,   -1,
   -1,  337,   -1,  339,  257,   -1,   -1,  343,  261,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,
   -1,   -1,   -1,   -1,   -1,  278,   -1,  363,   -1,  282,
   -1,   -1,  285,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  297,  298,   -1,  257,   -1,  302,
  303,  261,  431,  432,   -1,  308,   -1,  310,  311,  312,
  313,   -1,  272,   -1,   -1,  318,   -1,   -1,  278,  322,
   -1,  324,  282,   -1,   -1,  285,   -1,   -1,   -1,   -1,
   -1,  334,   -1,   -1,  337,   -1,  339,  297,  298,   -1,
  343,   -1,  302,  303,   -1,  431,  432,   -1,  308,   -1,
  310,  311,  312,  313,   -1,   -1,   -1,   -1,  318,   -1,
  363,   -1,  322,   -1,  324,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,   -1,  334,  261,   -1,  337,   -1,  339,
   -1,   -1,   -1,  343,   -1,   -1,  272,   -1,   -1,   -1,
   -1,   -1,  278,   -1,   -1,   -1,  282,   -1,   -1,  285,
   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  297,  298,   -1,   -1,   -1,  302,  303,   -1,   -1,
   -1,   -1,  308,   -1,  310,  311,  312,  313,  431,  432,
   -1,   -1,  318,   -1,   -1,  257,  322,   -1,  324,  261,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  334,   -1,
  272,  337,   -1,  339,   -1,   -1,  278,  343,   -1,   -1,
  282,   -1,   -1,  285,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  431,  432,   -1,   -1,  297,  298,  363,   -1,   -1,
  302,  303,   -1,   -1,   -1,   -1,  308,   -1,  310,  311,
  312,  313,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
  322,   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  334,   -1,   -1,  337,   -1,  339,   -1,   -1,
   -1,  343,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  363,   -1,   -1,  256,  431,  432,   -1,   -1,   -1,
   -1,   -1,  264,  265,  266,  267,   -1,   -1,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,   -1,
   -1,   -1,   -1,   -1,  286,   -1,  288,  289,  290,  291,
  292,  293,   -1,   -1,  296,   -1,   -1,   -1,  300,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,  315,   -1,  317,   -1,  319,  320,  431,
  432,  323,   -1,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,  336,   -1,  338,   -1,   -1,  341,
  342,   -1,   -1,  345,  346,   -1,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,  373,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
  382,  383,  384,  385,  386,   -1,   -1,   -1,  390,  299,
  392,   -1,   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  423,  424,  425,  426,   -1,   -1,   -1,  430,   -1,
  340,   -1,   -1,   -1,   -1,  345,  438,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,  358,   -1,
   -1,   -1,   -1,   -1,  364,  365,   -1,  367,  368,   -1,
   -1,   -1,   -1,  373,  374,  375,  376,  377,  378,  379,
  380,  381,  382,   -1,  384,  385,   -1,  387,  388,  389,
  390,  391,  392,  393,  394,  395,  396,   -1,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,  415,  416,  417,  418,  419,
  420,   -1,  256,   -1,  424,  261,  426,  427,  262,  429,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  298,   -1,   -1,  299,   -1,  303,   -1,   -1,
  306,   -1,  308,   -1,  310,  311,  312,  313,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
  326,   -1,   -1,   -1,   -1,  262,   -1,   -1,  334,   -1,
   -1,  337,   -1,  339,   -1,   -1,  340,   -1,   -1,   -1,
   -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,   -1,   -1,  363,   -1,   -1,
  364,  365,  299,  367,  368,   -1,   -1,   -1,  374,  373,
  374,  375,  376,  377,  378,  379,  380,  381,  382,   -1,
  384,  385,   -1,  387,  388,  389,  390,  391,  392,  393,
  394,  395,  396,   -1,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
  414,  415,  416,  417,  418,  419,  420,  256,  424,   -1,
  424,   -1,  426,  262,   -1,  429,   -1,   -1,  365,   -1,
   -1,   -1,   -1,   -1,  438,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,  381,   -1,   -1,  384,  385,   -1,
   -1,  388,  389,  390,  391,  392,  393,  394,  395,  396,
  299,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,  414,  415,  416,
  417,  418,  419,   -1,   -1,   -1,   -1,   -1,   -1,  426,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,   -1,   -1,   -1,   -1,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
   -1,   -1,   -1,   -1,   -1,  364,  365,   -1,  367,  368,
   -1,   -1,   -1,   -1,  373,  374,  375,  376,  377,  378,
  379,  380,  381,  382,   -1,  384,  385,   -1,  387,  388,
  389,  390,  391,  392,  393,  394,  395,  396,   -1,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,  418,
  419,   -1,  256,   -1,   -1,  424,  261,  426,  262,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,  438,
   -1,   -1,   -1,  278,   -1,   -1,   -1,  282,   -1,   -1,
  285,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  297,  298,   -1,  299,   -1,  302,  303,   -1,
   -1,   -1,   -1,  308,   -1,  310,  311,  312,  313,   -1,
   -1,   -1,   -1,  318,   -1,   -1,   -1,  322,   -1,  324,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  334,
   -1,   -1,  337,   -1,  339,   -1,  340,   -1,  343,   -1,
   -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,   -1,   -1,   -1,  363,   -1,
  364,  365,   -1,  367,  368,   -1,   -1,   -1,   -1,  374,
  374,  375,  376,  377,  378,  379,  380,  381,  382,   -1,
  384,  385,   -1,  387,  388,  389,  390,  391,  392,  393,
  394,  395,  396,   -1,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
  414,  415,  416,  417,  418,  419,   -1,  256,   -1,   -1,
  424,   -1,  426,  262,   -1,  429,  431,  432,   -1,   -1,
  265,   -1,  267,   -1,  438,  270,   -1,   -1,   -1,   -1,
  275,   -1,   -1,   -1,   -1,  280,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,  289,   -1,   -1,   -1,   -1,  294,
  299,  296,   -1,   -1,   -1,   -1,  301,   -1,   -1,   -1,
  305,  306,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  317,   -1,  319,   -1,   -1,   -1,  323,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,   -1,
  335,  340,   -1,  338,   -1,   -1,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  256,
   -1,   -1,   -1,   -1,   -1,   -1,  365,   -1,  367,  368,
   -1,   -1,   -1,   -1,  373,  374,  375,  376,  377,  378,
  379,  380,  381,  382,   -1,  384,  385,   -1,  387,  388,
  389,  390,  391,  392,  393,  394,  395,  396,   -1,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,  418,
  419,   -1,  256,   -1,   -1,   -1,   -1,  426,  262,  424,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,
   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,   -1,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,  299,   -1,   -1,   -1,   -1,
  367,  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,
   -1,  378,   -1,  380,  381,  382,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  365,   -1,  367,  368,   -1,   -1,   -1,   -1,  373,
  374,  438,  376,  377,  378,  379,  380,  381,  382,   -1,
  384,  385,   -1,  387,  388,  389,  390,  391,  392,  393,
  394,  395,  396,   -1,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
  414,  415,  416,  417,  418,  419,   -1,  256,   -1,   -1,
   -1,  261,  426,  262,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  272,   -1,  438,   -1,   -1,   -1,  278,   -1,
   -1,   -1,  282,   -1,   -1,  285,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297,  298,   -1,
  299,   -1,  302,  303,   -1,   -1,   -1,   -1,  308,   -1,
  310,  311,  312,  313,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,  322,   -1,  324,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,  339,
   -1,  340,   -1,  343,   -1,   -1,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,   -1,
   -1,   -1,   -1,  363,   -1,   -1,  365,   -1,  367,  368,
   -1,   -1,   -1,   -1,  374,  374,   -1,  376,  377,  378,
  379,  380,  381,  382,   -1,  384,  385,   -1,  387,  388,
  389,  390,  391,  392,  393,  394,  395,  396,   -1,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,  418,
  419,   -1,  256,   -1,   -1,  261,   -1,  426,  262,   -1,
  429,  431,  432,   -1,   -1,   -1,   -1,   -1,   -1,  438,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  298,   -1,   -1,  299,   -1,  303,   -1,   -1,
  306,   -1,  308,   -1,  310,  311,  312,  313,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
  326,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  334,   -1,
   -1,  337,   -1,  339,   -1,   -1,  340,   -1,   -1,   -1,
   -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,   -1,   -1,   -1,  363,   -1,   -1,
   -1,  365,   -1,  367,  368,   -1,   -1,   -1,  374,   -1,
  374,   -1,  376,  377,  378,  379,  380,  381,  382,   -1,
  384,  385,   -1,  387,  388,  389,  390,  391,  392,  393,
  394,  395,  396,   -1,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
  414,  415,  416,  417,  418,  419,   -1,  256,  424,   -1,
   -1,  261,  426,  262,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  438,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,
  299,   -1,   -1,  303,   -1,   -1,   -1,   -1,  308,   -1,
  310,  311,  312,  313,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,  339,
   -1,  340,   -1,   -1,   -1,   -1,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,   -1,
   -1,  256,   -1,  363,   -1,   -1,  365,   -1,  367,  368,
  370,  371,   -1,   -1,  374,  374,   -1,  376,  377,  378,
  379,  380,  381,  382,   -1,  384,  385,   -1,  387,  388,
  389,  390,  391,  392,  393,  394,  395,  396,   -1,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,  418,
  419,   -1,  256,   -1,   -1,   -1,   -1,  426,  262,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,
   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,
  345,   -1,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,   -1,   -1,  299,   -1,   -1,   -1,   -1,
   -1,   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,  374,
   -1,  376,   -1,  378,   -1,  380,  381,  382,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,
   -1,  396,   -1,  266,   -1,   -1,  340,   -1,   -1,   -1,
   -1,  345,  407,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  419,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  367,  368,   -1,  299,   -1,   -1,   -1,
  374,   -1,  376,  438,  378,   -1,  380,  381,  382,   -1,
  384,  385,  315,  387,  388,  389,  390,  391,  392,  393,
  394,  395,  396,   -1,   -1,   -1,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
  414,  415,  416,  417,   -1,  419,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  358,   -1,   -1,   -1,   -1,
   -1,  364,  365,   -1,  438,   -1,   -1,   -1,   -1,   -1,
   -1,  374,  375,  376,  377,  378,  379,  380,  381,  382,
   -1,  384,  385,   -1,  387,  388,  389,  390,  391,  392,
  393,  394,  395,  396,   -1,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,  414,  415,  416,  417,  418,  419,   -1,  256,   -1,
   -1,  424,  261,  426,  262,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  438,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,
   -1,  299,   -1,   -1,  303,   -1,   -1,   -1,   -1,  308,
   -1,  310,  311,  312,  313,   -1,   -1,   -1,   -1,  318,
   -1,   -1,   -1,  322,   -1,  256,   -1,   -1,   -1,   -1,
   -1,  262,   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,
  339,   -1,  340,   -1,   -1,   -1,   -1,  345,   -1,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
   -1,   -1,   -1,   -1,  363,   -1,  364,  365,  299,  367,
  368,  370,  371,   -1,   -1,  374,  374,  375,  376,  377,
  378,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1,
  388,  389,  390,  391,   -1,   -1,   -1,  395,  396,   -1,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  418,  419,   -1,   -1,   -1,   -1,  424,   -1,  426,   -1,
   -1,  429,   -1,  364,  365,   -1,   -1,   -1,   -1,   -1,
  438,   -1,   -1,  374,  375,  376,  377,  378,  379,  380,
  381,  382,   -1,  384,  385,   -1,  387,  388,  389,  390,
  391,   -1,  393,  394,  395,  396,   -1,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,  414,  415,  416,  417,  418,  419,   -1,
  256,   -1,  261,  424,   -1,  426,  262,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,
   -1,   -1,   -1,  299,  303,   -1,   -1,   -1,   -1,  308,
   -1,  310,  311,  312,  313,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,  337,   -1,
  339,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,
   -1,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,  363,   -1,   -1,   -1,   -1,  365,
  256,  367,  368,   -1,   -1,  374,  262,   -1,  374,   -1,
  376,  377,  378,  379,  380,  381,  382,   -1,  384,  385,
   -1,   -1,  388,  389,  390,  391,   -1,   -1,   -1,  395,
  396,   -1,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,   -1,  299,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  418,  419,   -1,   -1,   -1,   -1,   -1,   -1,
  426,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  438,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,
   -1,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,
  256,  367,  368,   -1,   -1,   -1,  262,   -1,  374,   -1,
  376,  377,  378,  379,  380,  381,  382,   -1,  384,  385,
   -1,   -1,  388,  389,  390,  391,   -1,   -1,   -1,  395,
  396,   -1,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,   -1,  299,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  418,  419,   -1,   -1,   -1,   -1,   -1,   -1,
  426,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  438,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,
   -1,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,
  256,  367,  368,   -1,   -1,   -1,  262,   -1,  374,   -1,
  376,  377,  378,  379,  380,  381,  382,   -1,  384,  385,
   -1,   -1,  388,  389,  390,  391,   -1,   -1,   -1,  395,
  396,   -1,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,   -1,  299,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  418,  419,   -1,   -1,   -1,   -1,   -1,   -1,
  426,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  438,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  340,   -1,  262,   -1,   -1,  345,
   -1,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,  364,   -1,
   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,  374,  375,
  376,   -1,  378,  299,  380,  381,  382,   -1,  384,  385,
   -1,   -1,  388,  389,  390,  391,   -1,   -1,   -1,  395,
  396,   -1,   -1,   -1,  400,  401,  402,  403,  404,  405,
  406,  407,   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,   -1,  419,  340,   -1,   -1,   -1,  424,  345,
   -1,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  438,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  367,  368,   -1,   -1,   -1,  299,   -1,  374,   -1,
  376,   -1,  378,   -1,  380,  381,  382,   -1,  384,  385,
   -1,   -1,  388,  389,  390,  391,  392,  393,  394,  395,
  396,   -1,   -1,   -1,  400,  401,  402,  403,  404,  405,
  406,  407,   -1,  256,   -1,   -1,   -1,  340,   -1,  262,
   -1,   -1,  345,  419,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,
   -1,  364,  438,   -1,  367,  368,   -1,   -1,   -1,   -1,
   -1,  374,   -1,  376,   -1,  378,  299,  380,  381,  382,
   -1,  384,  385,   -1,   -1,  388,  389,  390,  391,   -1,
   -1,   -1,  395,  396,   -1,   -1,   -1,  400,  401,  402,
  403,  404,  405,  406,  407,   -1,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,  419,  340,   -1,   -1,
   -1,  424,  345,   -1,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,  438,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  367,  368,   -1,   -1,   -1,  299,
   -1,  374,   -1,  376,   -1,  378,   -1,  380,  381,  382,
   -1,  384,  385,   -1,   -1,  388,  389,  390,  391,   -1,
   -1,   -1,  395,  396,   -1,   -1,   -1,  400,  401,  402,
  403,  404,  405,  406,  407,   -1,  256,   -1,   -1,   -1,
  340,   -1,  262,   -1,   -1,  345,  419,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  438,   -1,  367,  368,   -1,
   -1,   -1,   -1,   -1,  374,   -1,  376,   -1,  378,  299,
  380,  381,  382,   -1,  384,  385,   -1,   -1,  388,  389,
  390,  391,   -1,   -1,   -1,  395,  396,   -1,   -1,   -1,
  400,  401,  402,  403,  404,  405,  406,  407,   -1,  256,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,  419,
  340,   -1,   -1,   -1,   -1,  345,   -1,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,  438,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  368,   -1,
   -1,   -1,  299,   -1,  374,   -1,  376,   -1,  378,   -1,
  380,  381,  382,   -1,  384,  385,   -1,   -1,  388,  389,
  390,  391,   -1,   -1,   -1,  395,  396,   -1,   -1,   -1,
  400,  401,  402,  403,  404,  405,  406,  407,   -1,   -1,
   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,  419,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,   -1,
  367,  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,
   -1,  378,   -1,  380,  381,  382,   -1,  384,  385,   -1,
   -1,  388,  389,  390,  391,   -1,   -1,   -1,  395,  396,
   -1,   -1,   -1,  400,  401,  402,  403,  404,  405,  406,
  407,   -1,  256,   -1,  256,   -1,   -1,   -1,   -1,   -1,
  264,  265,  419,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
   -1,  438,  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,  345,   -1,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,  360,  361,  362,  363,
  364,  256,   -1,  367,  368,  367,  368,   -1,   -1,   -1,
   -1,   -1,  374,  377,  376,   -1,  378,   -1,  380,  381,
  382,   -1,   -1,   -1,   -1,   -1,  388,  389,  390,  391,
   -1,   -1,   -1,  395,  396,   -1,   -1,   -1,  400,  401,
  402,  403,  404,  405,  406,  407,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  419,   -1,  423,
  424,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  437,  438,   -1,  438,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,
  345,   -1,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,  374,
   -1,  376,   -1,  378,   -1,  380,  381,  382,   -1,   -1,
   -1,   -1,   -1,  388,  389,  390,  391,   -1,   -1,   -1,
  395,  396,   -1,   -1,   -1,  400,  401,  402,  403,  404,
  405,  406,  407,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,   -1,   -1,  419,   -1,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,   -1,
   -1,   -1,   -1,  438,   -1,   -1,   -1,   -1,  367,  368,
   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,   -1,  378,
   -1,  380,  381,  382,   -1,   -1,   -1,   -1,   -1,  388,
  389,  390,  391,   -1,   -1,   -1,  395,  396,   -1,   -1,
   -1,  400,  401,  402,  403,  404,  405,  406,  407,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,
  419,   -1,  345,   -1,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,  438,
   -1,   -1,   -1,   -1,  367,  368,   -1,   -1,   -1,   -1,
   -1,  374,   -1,  376,   -1,  378,   -1,  380,  381,  382,
   -1,   -1,   -1,   -1,   -1,  388,  389,  390,  391,   -1,
   -1,   -1,  395,  396,   -1,   -1,   -1,   -1,   -1,  402,
  403,  404,  405,  406,  407,  256,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,   -1,   -1,  419,   -1,  345,   -1,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,  438,   -1,   -1,   -1,   -1,
  367,  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,
   -1,  378,   -1,  380,  381,  382,   -1,   -1,   -1,   -1,
   -1,  388,  389,  390,  391,   -1,   -1,   -1,  395,  396,
   -1,   -1,   -1,   -1,   -1,  402,  403,  404,  405,  406,
  407,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
   -1,   -1,  419,   -1,  345,   -1,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,
   -1,  438,   -1,   -1,   -1,   -1,  367,  368,   -1,   -1,
   -1,   -1,   -1,  374,   -1,  376,   -1,  378,   -1,  380,
  381,  382,   -1,   -1,   -1,   -1,   -1,  388,  389,  390,
  391,   -1,   -1,   -1,  395,  396,   -1,   -1,   -1,   -1,
   -1,  402,  403,  404,  405,  406,  407,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  419,   -1,
  345,   -1,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,   -1,   -1,   -1,   -1,  438,   -1,   -1,
   -1,   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,  374,
   -1,  376,   -1,  378,   -1,  380,  381,  382,   -1,   -1,
   -1,   -1,   -1,  388,  389,  390,  391,  256,   -1,   -1,
  395,  396,   -1,  262,   -1,   -1,   -1,  402,  403,  404,
  405,  406,  407,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,   -1,   -1,  419,   -1,  345,   -1,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,   -1,
  299,   -1,   -1,  438,   -1,   -1,   -1,   -1,  367,  368,
   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,   -1,  378,
   -1,  380,  381,  382,   -1,   -1,   -1,   -1,   -1,  388,
  389,  390,  391,   -1,   -1,   -1,  395,  396,   -1,   -1,
   -1,   -1,   -1,  402,  403,  404,  405,  406,  407,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  419,   -1,   -1,   -1,   -1,   -1,  365,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,  377,  438,
  379,  380,   -1,   -1,   -1,  384,  385,   -1,   -1,  388,
  389,  390,  391,  392,  393,  394,  395,  396,   -1,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  418,
  419,   -1,  256,   -1,   -1,   -1,   -1,  426,   -1,   -1,
  429,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,  438,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  367,  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,
   -1,  378,   -1,  380,  381,  382,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  390,  391,   -1,   -1,   -1,  395,  396,
   -1,   -1,   -1,   -1,   -1,  256,   -1,  404,  405,  406,
  407,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,  345,  419,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  438,   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,
  374,   -1,  376,   -1,  378,   -1,  380,  381,  382,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  390,  391,   -1,   -1,
   -1,  395,  396,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  404,  405,  406,  407,   -1,   -1,   -1,   -1,   -1,  340,
   -1,   -1,   -1,   -1,  345,  419,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  438,   -1,  367,  368,   -1,   -1,
   -1,   -1,   -1,  374,   -1,  376,   -1,  378,   -1,  380,
  381,  382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  390,
  391,   -1,   -1,   -1,  395,  396,   -1,   -1,   -1,   -1,
   -1,  256,   -1,  404,  405,  406,  407,   -1,   -1,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,  419,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,   -1,  367,
  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,   -1,
  378,   -1,  380,  381,  382,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  390,  391,   -1,   -1,   -1,  395,  396,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  406,  407,
   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,
  345,  419,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  438,   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,  374,
   -1,  376,   -1,  378,   -1,  380,  381,  382,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  390,  391,   -1,   -1,   -1,
  395,  396,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  406,  407,   -1,   -1,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,  345,  419,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  438,   -1,  367,  368,   -1,   -1,   -1,
   -1,   -1,  374,   -1,  376,   -1,  378,   -1,  380,  381,
  382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,
   -1,   -1,   -1,  395,  396,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  406,  407,   -1,   -1,   -1,   -1,
   -1,  340,   -1,   -1,   -1,   -1,  345,  419,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  438,   -1,  367,  368,
   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,   -1,  378,
   -1,  380,  381,  382,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  391,   -1,   -1,   -1,  395,  396,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  406,  407,   -1,
   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,
  419,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,
   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,
  376,   -1,  378,   -1,  380,  381,  382,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  391,   -1,   -1,   -1,   -1,
  396,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  406,  407,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,
   -1,   -1,  345,  419,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  438,   -1,  367,  368,   -1,   -1,   -1,   -1,
   -1,  374,   -1,  376,   -1,  378,   -1,  380,  381,  382,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,   -1,
   -1,   -1,   -1,  396,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  406,  407,   -1,   -1,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,  345,  419,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  438,   -1,  367,  368,   -1,
   -1,   -1,   -1,   -1,  374,   -1,  376,   -1,  378,   -1,
  380,  381,  382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  396,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  406,  407,   -1,   -1,
   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,  345,  419,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  438,   -1,
  367,  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,  376,
   -1,  378,   -1,  380,  381,  382,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  396,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,  345,  419,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  438,   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,
  374,   -1,  376,   -1,  378,   -1,  380,  381,  382,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,  396,   -1,   -1,  261,   -1,   -1,   -1,  265,
   -1,  267,   -1,  407,  270,   -1,  272,  273,   -1,  275,
   -1,   -1,  278,   -1,  280,  419,  282,  283,  284,  285,
   -1,   -1,  288,  289,   -1,  286,   -1,   -1,  294,   -1,
  296,  297,  298,   -1,  438,  301,   -1,  303,  299,  305,
   -1,   -1,  308,   -1,  310,  311,  312,  313,  314,   -1,
   -1,  317,  318,  319,  262,   -1,  322,  323,  324,   -1,
   -1,   -1,   -1,   -1,   -1,  331,  332,  328,  334,  335,
   -1,  337,  338,  339,   -1,   -1,   -1,  343,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  299,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  373,  374,  375,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,   -1,   -1,
   -1,   -1,  383,  384,  385,  386,   -1,  388,  389,  390,
  391,  392,  393,  394,  395,   -1,   -1,  398,  399,  400,
  401,  402,  403,  404,  405,   -1,   -1,   -1,   -1,   -1,
  358,   -1,   -1,   -1,   -1,   -1,   -1,  365,  424,   -1,
   -1,   -1,   -1,   -1,   -1,  431,  432,  375,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,  385,   -1,  387,
  388,  389,  390,  391,  392,  393,  394,  395,  396,   -1,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,  414,  415,  416,  417,
  418,  419,   -1,   -1,  256,   -1,  424,   -1,  426,   -1,
   -1,  429,  264,  265,  266,  267,  268,   -1,  270,  271,
  438,  273,  274,  275,  276,  277,  278,  279,  280,   -1,
   -1,   -1,   -1,   -1,  286,   -1,  288,  289,  290,  291,
  292,  293,   -1,   -1,  296,   -1,   -1,   -1,  300,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,  315,   -1,  317,   -1,  319,  320,   -1,
   -1,  323,   -1,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,  336,   -1,  338,   -1,   -1,  341,
  342,   -1,   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,  373,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
  382,  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,
  392,   -1,   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  423,  424,  425,  426,  256,  428,   -1,  430,   -1,
   -1,   -1,   -1,  264,  265,  266,  267,   -1,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,  289,  290,
  291,  292,  293,   -1,   -1,  296,   -1,   -1,   -1,  300,
  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,  315,   -1,  317,   -1,  319,  320,
   -1,   -1,  323,   -1,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,  336,   -1,  338,   -1,   -1,
  341,  342,   -1,   -1,  345,  346,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,
   -1,   -1,  373,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,  382,  383,  384,  385,  386,   -1,   -1,   -1,  390,
   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,  399,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  423,  424,  425,  426,  256,   -1,   -1,  430,
   -1,   -1,   -1,   -1,  264,  265,  266,  267,   -1,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,  289,
  290,  291,  292,  293,   -1,   -1,  296,   -1,   -1,   -1,
  300,  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,  315,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,  336,   -1,  338,   -1,
   -1,  341,  342,   -1,   -1,  345,  346,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,  373,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,  399,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  423,  424,  425,  426,  256,   -1,   -1,
  430,   -1,   -1,   -1,   -1,  264,  265,  266,  267,   -1,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,
  289,  290,  291,  292,  293,   -1,   -1,  296,   -1,   -1,
   -1,  300,  301,   -1,  303,  304,  305,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,  315,   -1,  317,   -1,
  319,  320,   -1,   -1,  323,   -1,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  336,   -1,  338,
   -1,   -1,  341,  342,   -1,   -1,  345,  346,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,  368,
  369,   -1,   -1,   -1,  373,   -1,   -1,   -1,  377,   -1,
   -1,   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,
   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,
  399,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  423,  424,  425,  426,  256,   -1,
   -1,  430,   -1,   -1,   -1,   -1,  264,  265,  266,  267,
   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,
  288,  289,  290,  291,  292,  293,   -1,   -1,  296,   -1,
   -1,   -1,  300,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,  315,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,  336,   -1,
  338,   -1,   -1,  341,  342,   -1,   -1,  345,  346,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,  369,   -1,   -1,   -1,  373,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,  382,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,
  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,  423,  424,  425,  426,   -1,
  264,  265,  430,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,
   -1,  295,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,  307,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,
   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,  380,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,  423,
  424,  425,  426,   -1,  264,  265,  430,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,
  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,   -1,  289,
   -1,   -1,   -1,   -1,   -1,  295,  296,   -1,   -1,   -1,
   -1,  301,   -1,  303,  304,  305,   -1,  307,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,
  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,
   -1,   -1,  342,   -1,   -1,  345,  346,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,  399,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,  423,  424,  425,  426,   -1,  264,  265,
  430,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,   -1,   -1,   -1,   -1,   -1,
  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
   -1,  317,   -1,  319,  320,  321,   -1,  323,   -1,   -1,
  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,
   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,
  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,  369,   -1,   -1,   -1,  373,   -1,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,
   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,  423,  424,  425,
  426,   -1,  264,  265,  430,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,
   -1,   -1,   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,
   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,  321,
   -1,  323,   -1,   -1,  326,  327,  328,   -1,  330,  331,
  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,
  342,   -1,   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,   -1,  374,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,
  392,   -1,   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,  423,  424,  425,  426,   -1,  264,  265,  430,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  278,   -1,  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,
   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,
   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,  346,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,  369,   -1,   -1,   -1,  373,  374,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,
  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,  423,  424,  425,  426,   -1,
  264,  265,  430,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,
   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,  423,
  424,  425,  426,   -1,  264,  265,  430,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,
  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,   -1,  289,
   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,
   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,
  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,
   -1,   -1,  342,   -1,   -1,  345,  346,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,  399,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,  423,  424,  425,  426,   -1,  264,  265,
  430,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,   -1,   -1,   -1,   -1,   -1,
  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,
  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,
   -1,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,  345,
  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,
   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,  423,  424,  425,
  426,   -1,  264,  265,  430,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,
   -1,   -1,   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,
   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,
   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,
  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,
  342,   -1,   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,  373,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,
  392,   -1,   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,  423,  424,  425,  426,   -1,  264,  265,  430,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  278,   -1,  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,
   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,
   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,  346,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,  369,   -1,   -1,   -1,   -1,  374,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,
  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,  423,  424,  425,  426,   -1,
  264,  265,  430,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,  338,   -1,   -1,   -1,  342,   -1,
   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,  423,
  424,  425,  426,   -1,  264,  265,  430,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,
  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,   -1,  289,
   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,
   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,
  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,
   -1,   -1,  342,   -1,   -1,  345,  346,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,  399,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,  423,  424,  425,  426,   -1,  264,  265,
  430,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,   -1,   -1,   -1,   -1,   -1,
  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,
  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,
   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,
  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,
   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,  423,  424,  425,
  426,   -1,  264,  265,  430,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,
   -1,   -1,   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,
   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,
   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,
  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,
  342,   -1,   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,
  392,   -1,   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,  423,  424,  425,  426,   -1,  264,  265,  430,  267,
   -1,   -1,  270,  271,   -1,  256,   -1,  275,  276,  277,
  278,   -1,  280,   -1,  265,   -1,  267,   -1,  286,  270,
   -1,  289,   -1,   -1,  275,   -1,   -1,   -1,  296,  280,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,  289,   -1,
   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,  317,
  301,  319,  320,   -1,  305,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,  317,  335,  319,   -1,
   -1,   -1,  323,   -1,  342,   -1,   -1,  345,  346,   -1,
  331,  332,   -1,   -1,  335,   -1,   -1,  338,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,  377,   -1,   -1,   -1,
  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,  423,  424,  425,  426,  265,
  286,  267,  430,  289,  270,   -1,   -1,   -1,   -1,  275,
  296,   -1,   -1,  424,  280,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,  317,   -1,  319,  320,  301,   -1,  323,   -1,  305,
  326,   -1,  328,   -1,  330,  331,  332,  333,  314,  335,
   -1,  317,   -1,  319,   -1,   -1,  342,  323,   -1,  345,
  346,   -1,   -1,   -1,   -1,  331,  332,   -1,   -1,  335,
   -1,   -1,  338,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,  369,   -1,   -1,   -1,  373,  374,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,
   -1,  377,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,  423,  424,  425,
  426,   -1,  286,  429,   -1,  289,   -1,   -1,   -1,   -1,
   -1,  437,  296,   -1,   -1,   -1,   -1,  301,  424,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,
   -1,  345,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,  373,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  423,
  424,  425,  426,   -1,   -1,  429,  261,   -1,  263,   -1,
  265,   -1,  267,  437,   -1,  270,   -1,  272,  273,   -1,
  275,   -1,   -1,  278,   -1,  280,   -1,  282,  283,  284,
  285,   -1,   -1,  288,  289,   -1,   -1,   -1,   -1,  294,
  295,  296,  297,  298,   -1,   -1,  301,   -1,  303,   -1,
  305,   -1,  307,  308,   -1,  310,  311,  312,  313,  314,
   -1,  316,  317,  318,  319,   -1,   -1,  322,  323,  324,
   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,
  335,   -1,  337,  338,  339,   -1,   -1,   -1,  343,   -1,
  261,   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,  270,
   -1,  272,  273,   -1,  275,   -1,   -1,  278,  363,  280,
   -1,  282,  283,  284,  285,  370,  371,  288,  289,   -1,
   -1,   -1,  377,  294,   -1,  296,  297,  298,   -1,   -1,
  301,   -1,  303,   -1,  305,   -1,   -1,  308,   -1,  310,
  311,  312,  313,  314,   -1,   -1,  317,  318,  319,   -1,
   -1,  322,  323,  324,   -1,   -1,   -1,   -1,   -1,   -1,
  331,  332,   -1,  334,  335,   -1,  337,  338,  339,  424,
   -1,   -1,  343,   -1,  261,   -1,  431,  432,  265,   -1,
  267,   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,
   -1,  278,  363,  280,   -1,  282,  283,  284,  285,   -1,
   -1,  288,  289,  374,   -1,   -1,  377,  294,   -1,  296,
  297,  298,  383,   -1,  301,   -1,  303,   -1,  305,   -1,
   -1,  308,   -1,  310,  311,  312,  313,  314,   -1,   -1,
  317,  318,  319,   -1,   -1,  322,  323,  324,   -1,   -1,
   -1,   -1,   -1,   -1,  331,  332,   -1,  334,  335,   -1,
  337,  338,  339,  424,   -1,   -1,  343,   -1,  261,   -1,
  431,  432,  265,   -1,  267,   -1,   -1,  270,   -1,  272,
  273,   -1,  275,   -1,   -1,  278,  363,  280,   -1,  282,
  283,  284,  285,   -1,   -1,  288,  289,  374,   -1,   -1,
  377,  294,   -1,  296,  297,  298,  383,   -1,  301,   -1,
  303,   -1,  305,   -1,   -1,  308,   -1,  310,  311,  312,
  313,  314,   -1,   -1,  317,  318,  319,   -1,   -1,  322,
  323,  324,   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,
   -1,  334,  335,   -1,  337,  338,  339,  424,   -1,   -1,
  343,   -1,  261,   -1,  431,  432,  265,   -1,  267,   -1,
   -1,  270,   -1,  272,  273,   -1,  275,   -1,   -1,  278,
  363,  280,   -1,  282,  283,  284,  285,   -1,   -1,  288,
  289,   -1,   -1,   -1,  377,  294,   -1,  296,  297,  298,
  383,   -1,  301,   -1,  303,   -1,  305,   -1,   -1,  308,
   -1,  310,  311,  312,  313,  314,   -1,   -1,  317,  318,
  319,   -1,   -1,  322,  323,  324,   -1,   -1,   -1,   -1,
   -1,   -1,  331,  332,   -1,  334,  335,   -1,  337,  338,
  339,  424,   -1,   -1,  343,   -1,  261,   -1,  431,  432,
  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,   -1,
  275,   -1,   -1,  278,  363,  280,   -1,  282,  283,  284,
  285,   -1,   -1,  288,  289,  374,   -1,   -1,  377,  294,
   -1,  296,  297,  298,   -1,   -1,  301,   -1,  303,   -1,
  305,   -1,   -1,  308,  261,  310,  311,  312,  313,  314,
   -1,   -1,  317,  318,  319,  272,   -1,  322,  323,  324,
   -1,  278,   -1,   -1,   -1,  282,  331,  332,  285,  334,
  335,   -1,  337,  338,  339,  424,   -1,   -1,  343,   -1,
  297,  298,  431,  432,   -1,  302,  303,   -1,   -1,   -1,
   -1,  308,   -1,  310,  311,  312,  313,   -1,  363,   -1,
   -1,  318,   -1,   -1,   -1,  322,   -1,  324,   -1,  374,
   -1,   -1,  377,   -1,   -1,   -1,   -1,  334,   -1,  336,
  337,   -1,  339,   -1,   -1,   -1,  343,  261,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,
   -1,   -1,   -1,   -1,  278,   -1,  363,   -1,  282,   -1,
   -1,  285,   -1,   -1,   -1,   -1,   -1,  374,  375,  424,
   -1,   -1,   -1,  297,  298,   -1,  431,  432,  302,  303,
   -1,   -1,   -1,   -1,  308,   -1,  310,  311,  312,  313,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,  322,   -1,
  324,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  334,   -1,  256,  337,   -1,  339,   -1,   -1,  262,  343,
  264,  265,   -1,  267,  431,  432,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,  363,
   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,
  374,  375,  296,   -1,   -1,  299,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  344,   -1,   -1,   -1,   -1,   -1,   -1,  431,  432,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,  379,   -1,   -1,   -1,  383,
  384,  385,  386,  387,   -1,   -1,  390,   -1,  392,   -1,
   -1,  256,   -1,   -1,  398,  399,   -1,  262,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,  423,
  424,  286,  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,   -1,   -1,  299,   -1,  301,   -1,  303,  304,
  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,
   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,
  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  344,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,
   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  377,   -1,  379,   -1,   -1,   -1,  383,  384,
  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,
  256,   -1,   -1,  398,  399,   -1,  262,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,   -1,   -1,   -1,  423,  424,
  286,  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,  299,   -1,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,
  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  377,   -1,  379,   -1,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,  256,
   -1,   -1,  398,  399,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  278,   -1,  280,   -1,   -1,   -1,  423,  424,  286,
  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,
   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,
   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,
  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  377,   -1,  379,   -1,   -1,   -1,  383,  384,  385,  386,
   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,  256,   -1,
   -1,  398,  399,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  278,   -1,  280,   -1,   -1,   -1,  423,  424,  286,  426,
   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,   -1,  256,   -1,   -1,
  398,  399,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,
   -1,  280,   -1,   -1,   -1,  423,  424,  286,  426,   -1,
  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,
   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,
  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,
   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,  368,
  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,
   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,   -1,  392,   -1,   -1,  256,   -1,   -1,  398,
  399,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,
  280,   -1,   -1,   -1,  423,  424,  286,  426,   -1,  289,
   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,
   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,
  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,  256,   -1,   -1,  398,  399,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,
   -1,   -1,   -1,  423,  424,  286,  426,   -1,  289,   -1,
   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,
  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,
   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,
  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
   -1,  392,   -1,   -1,  256,   -1,   -1,  398,  399,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,
   -1,   -1,  423,  424,  286,  426,   -1,  289,   -1,   -1,
   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,
   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,
  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,
  392,   -1,   -1,  256,   -1,   -1,  398,  399,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,
   -1,  423,  424,  286,  426,   -1,  289,   -1,   -1,   -1,
   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,
  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,
  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,
  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,
  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,
   -1,   -1,  256,   -1,   -1,  398,  399,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
  423,  424,  286,  426,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,  256,   -1,   -1,  398,  399,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,  423,
  424,  286,  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,
  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,
   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,
  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,
   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,
  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,
  256,   -1,   -1,  398,  399,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,   -1,   -1,   -1,  423,  424,
  286,  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,
  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,  256,
   -1,   -1,  398,  399,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  278,   -1,  280,   -1,   -1,   -1,  423,  424,  286,
  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,
   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,
   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,
  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,
   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,  256,   -1,
   -1,  398,  399,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  278,   -1,  280,   -1,   -1,   -1,  423,  424,  286,  426,
   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,   -1,  256,   -1,   -1,
  398,  399,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,
   -1,  280,   -1,   -1,   -1,  423,  424,  286,  426,   -1,
  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,
   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,
  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,
   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,  368,
  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,
   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,   -1,  392,   -1,   -1,  256,   -1,   -1,  398,
  399,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,
  280,   -1,   -1,   -1,  423,  424,  286,  426,   -1,  289,
   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,
   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,
  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,  256,   -1,   -1,  398,  399,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,
   -1,   -1,   -1,  423,  424,  286,  426,   -1,  289,   -1,
   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,
  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,
   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,
  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
   -1,  392,   -1,   -1,  256,   -1,   -1,  398,  399,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,
   -1,   -1,  423,  424,  286,  426,   -1,  289,   -1,   -1,
   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,
   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,
  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,
  392,   -1,   -1,  256,   -1,   -1,  398,  399,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,
   -1,  423,  424,  286,  426,   -1,  289,   -1,   -1,   -1,
   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,
  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,
  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,
  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,
  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,
   -1,   -1,  256,   -1,   -1,  398,  399,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
  423,  424,  286,  426,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,  256,   -1,   -1,  398,  399,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,  423,
  424,  286,  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,
  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,
   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,
  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,
   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,
  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,
  256,   -1,   -1,  398,  399,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,   -1,   -1,   -1,  423,  424,
  286,  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,
  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,  256,
   -1,   -1,  398,  399,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  278,   -1,  280,   -1,   -1,   -1,  423,  424,  286,
  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,
   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,
   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,
  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,
   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,  256,   -1,
   -1,  398,  399,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  278,   -1,  280,   -1,   -1,   -1,  423,  424,  286,  426,
   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,
   -1,   -1,  390,   -1,  392,   -1,   -1,  256,   -1,   -1,
  398,  399,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,
   -1,  280,   -1,   -1,   -1,  423,  424,  286,  426,   -1,
  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,
   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,
  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,
   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,  368,
  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,
   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,   -1,  392,   -1,   -1,  256,   -1,   -1,  398,
  399,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,
  280,   -1,   -1,   -1,  423,  424,  286,  426,   -1,  289,
   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,
   -1,  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,
  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,  256,   -1,   -1,  398,  399,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,
   -1,   -1,   -1,  423,  424,  286,  426,   -1,  289,   -1,
   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,
  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,
   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,
  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
   -1,  392,   -1,   -1,  256,   -1,   -1,  398,  399,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,
   -1,   -1,  423,  424,  286,  426,   -1,  289,   -1,   -1,
   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,
   -1,  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,
   -1,  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,
  332,  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,
  392,   -1,   -1,  256,   -1,   -1,  398,  399,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,
   -1,  423,  424,  286,  426,   -1,  289,   -1,   -1,   -1,
   -1,   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,
  303,  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,
  323,   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,
  333,   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,
  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,
   -1,   -1,  256,   -1,   -1,  398,  399,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
  423,  424,  286,  426,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,  256,   -1,   -1,  398,  399,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,  423,
  424,  286,  426,   -1,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,
  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,
   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,
  335,   -1,   -1,  338,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,
   -1,   -1,  367,  368,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  377,   -1,  263,   -1,  265,   -1,  267,  384,
  385,  270,   -1,  272,  273,   -1,  275,  392,   -1,  278,
   -1,  280,   -1,  282,  283,  284,   -1,   -1,   -1,  288,
  289,   -1,   -1,   -1,   -1,  294,   -1,  296,  297,   -1,
   -1,   -1,  301,   -1,   -1,   -1,  305,   -1,  423,  424,
   -1,  426,   -1,   -1,   -1,  314,   -1,  316,  317,   -1,
  319,   -1,   -1,   -1,  323,  324,   -1,   -1,   -1,   -1,
   -1,   -1,  331,  332,  256,   -1,  335,   -1,   -1,  338,
   -1,   -1,  264,  265,  343,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,   -1,
   -1,   -1,   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,
   -1,  370,  371,   -1,  296,   -1,   -1,   -1,  377,  301,
   -1,  303,  304,  305,  383,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,  320,   -1,
   -1,  323,   -1,  256,  326,   -1,  328,   -1,  330,  331,
  332,  333,  265,  335,  267,   -1,   -1,  270,   -1,   -1,
   -1,   -1,  275,   -1,   -1,  424,   -1,  280,   -1,   -1,
   -1,   -1,  431,  432,   -1,   -1,  289,   -1,  360,  361,
  362,  363,  364,  296,   -1,  367,  368,   -1,  301,   -1,
   -1,   -1,  305,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  317,   -1,  319,   -1,   -1,   -1,
  323,   -1,  256,   -1,   -1,   -1,   -1,   -1,  331,  332,
   -1,  265,  335,  267,   -1,  338,  270,   -1,   -1,   -1,
   -1,  275,   -1,   -1,   -1,   -1,  280,   -1,   -1,   -1,
   -1,  423,  424,   -1,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,   -1,
   -1,  305,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,   -1,   -1,   -1,  323,
   -1,  256,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,
  265,  335,  267,   -1,  338,  270,   -1,   -1,   -1,   -1,
  275,   -1,   -1,   -1,   -1,  280,   -1,   -1,   -1,   -1,
   -1,  424,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,   -1,   -1,
  305,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  317,   -1,  319,   -1,   -1,   -1,  323,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  265,
  335,  267,   -1,  338,  270,   -1,   -1,   -1,   -1,  275,
   -1,   -1,   -1,   -1,  280,   -1,   -1,   -1,   -1,   -1,
  424,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,   -1,   -1,  301,   -1,   -1,   -1,  305,
   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  317,   -1,  319,   -1,   -1,   -1,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  265,  335,
  267,   -1,  338,  270,   -1,  272,  273,   -1,  275,   -1,
   -1,  278,   -1,  280,   -1,  282,  283,  284,   -1,  424,
   -1,  288,  289,   -1,   -1,   -1,   -1,  294,   -1,  296,
  297,   -1,   -1,   -1,  301,   -1,   -1,   -1,  305,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,  314,   -1,   -1,
  317,   -1,  319,   -1,   -1,   -1,  323,  324,   -1,   -1,
   -1,   -1,   -1,   -1,  331,  332,   -1,   -1,  335,   -1,
   -1,  338,  265,   -1,  267,   -1,  343,  270,   -1,  272,
  273,   -1,  275,   -1,   -1,  278,   -1,  280,  424,  282,
  283,  284,   -1,   -1,   -1,  288,  289,   -1,   -1,   -1,
   -1,  294,   -1,  296,  297,   -1,   -1,   -1,  301,   -1,
  377,   -1,  305,   -1,   -1,   -1,  383,   -1,   -1,   -1,
   -1,  314,   -1,   -1,  317,   -1,  319,   -1,   -1,   -1,
  323,  324,   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,
   -1,   -1,  335,   -1,   -1,  338,   -1,   -1,   -1,   -1,
  343,   -1,   -1,   -1,   -1,  264,  265,  424,  267,   -1,
   -1,  270,  271,   -1,  431,  432,  275,  276,  277,  278,
   -1,  280,   -1,   -1,   -1,   -1,   -1,  286,   -1,   -1,
  289,   -1,   -1,   -1,  377,   -1,  295,  296,   -1,   -1,
   -1,   -1,  301,   -1,  303,  304,  305,   -1,  307,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,   -1,  317,   -1,
  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,
   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,
   -1,  424,   -1,  342,   -1,   -1,  345,  346,  431,  432,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,  368,
  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,  378,
   -1,  380,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,
  399,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  278,   -1,  280,  423,  424,  425,  426,   -1,  286,
   -1,  430,  289,   -1,   -1,   -1,   -1,   -1,  295,  296,
   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,
  307,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,   -1,
  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,
   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,
   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,  346,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,
  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  377,   -1,   -1,  380,   -1,   -1,  383,  384,  385,  386,
   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,
   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  278,   -1,  280,  423,  424,  425,  426,
   -1,  286,   -1,  430,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,
  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,
   -1,   -1,  317,   -1,  319,  320,  321,   -1,  323,   -1,
   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,
  335,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,
  345,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,
   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,
  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,
   -1,   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  278,   -1,  280,  423,  424,
  425,  426,  265,  286,  267,  430,  289,  270,   -1,   -1,
   -1,   -1,  275,  296,   -1,   -1,   -1,  280,  301,   -1,
  303,  304,  305,   -1,   -1,   -1,  289,   -1,   -1,   -1,
   -1,   -1,   -1,  296,  317,   -1,  319,  320,  301,   -1,
  323,   -1,  305,  326,   -1,  328,   -1,  330,  331,  332,
  333,   -1,  335,   -1,  317,  338,  319,   -1,   -1,  342,
  323,   -1,  345,  346,   -1,   -1,   -1,   -1,  331,  332,
   -1,   -1,  335,   -1,   -1,  338,   -1,  360,  361,  362,
  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,
   -1,   -1,   -1,  376,  377,  398,  399,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,
  423,  424,  425,  426,  265,  286,  267,  430,  289,  270,
   -1,   -1,   -1,   -1,  275,  296,   -1,   -1,   -1,  280,
  301,  424,  303,  304,  305,   -1,   -1,   -1,  289,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  317,   -1,  319,  320,
  301,   -1,  323,   -1,  305,  326,   -1,  328,   -1,  330,
  331,  332,  333,   -1,  335,   -1,  317,  338,  319,   -1,
   -1,  342,  323,   -1,  345,  346,   -1,   -1,   -1,   -1,
  331,  332,   -1,   -1,  335,   -1,   -1,  338,   -1,  360,
  361,  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
   -1,  392,   -1,   -1,   -1,   -1,  377,  398,  399,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,
   -1,  280,  423,  424,  425,  426,  265,  286,  267,  430,
  289,  270,   -1,   -1,   -1,   -1,  275,  296,   -1,   -1,
   -1,  280,  301,  424,  303,  304,  305,   -1,   -1,   -1,
  289,   -1,   -1,   -1,   -1,  314,   -1,  296,  317,   -1,
  319,  320,  301,   -1,  323,   -1,  305,  326,   -1,  328,
   -1,  330,  331,  332,  333,   -1,  335,   -1,  317,   -1,
  319,   -1,   -1,  342,  323,   -1,  345,  346,   -1,   -1,
   -1,   -1,  331,  332,   -1,   -1,  335,   -1,   -1,  338,
   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,  368,
  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,
   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,  377,  398,
  399,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  278,   -1,  280,  423,  424,  425,  426,  265,  286,
  267,  430,  289,  270,   -1,   -1,   -1,   -1,  275,  296,
   -1,   -1,   -1,  280,  301,  424,  303,  304,  305,   -1,
   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,
  317,   -1,  319,  320,  301,   -1,  323,   -1,  305,  326,
   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,
  317,   -1,  319,   -1,   -1,  342,  323,   -1,  345,  346,
   -1,   -1,   -1,   -1,  331,  332,   -1,   -1,  335,   -1,
   -1,  338,   -1,  360,  361,  362,  363,  364,   -1,   -1,
  367,  368,  369,   -1,   -1,   -1,  373,   -1,   -1,   -1,
  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,
   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,
  377,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  278,   -1,  280,  423,  424,  425,  426,
  265,  286,  267,  430,  289,  270,   -1,   -1,   -1,   -1,
  275,  296,   -1,   -1,   -1,  280,  301,  424,  303,  304,
  305,   -1,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,  317,   -1,  319,  320,  301,   -1,  323,   -1,
  305,  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,
  335,   -1,  317,   -1,  319,   -1,   -1,  342,  323,   -1,
  345,  346,   -1,   -1,   -1,   -1,  331,  332,   -1,   -1,
  335,   -1,   -1,  338,   -1,  360,  361,  362,  363,  364,
   -1,   -1,  367,  368,  369,   -1,   -1,   -1,  373,   -1,
   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,
  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,
   -1,   -1,  377,  398,  399,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  278,   -1,  280,  423,  424,
  425,  426,  265,  286,  267,  430,  289,  270,   -1,   -1,
   -1,   -1,  275,  296,   -1,   -1,   -1,  280,  301,  424,
  303,  304,  305,   -1,   -1,   -1,  289,   -1,   -1,   -1,
   -1,  314,   -1,  296,  317,   -1,  319,  320,  301,   -1,
  323,   -1,  305,  326,   -1,  328,   -1,  330,  331,  332,
  333,   -1,  335,   -1,  317,   -1,  319,   -1,   -1,  342,
  323,   -1,  345,  346,   -1,   -1,   -1,   -1,  331,  332,
   -1,   -1,  335,   -1,   -1,  338,   -1,  360,  361,  362,
  363,  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
  383,  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,
   -1,   -1,   -1,   -1,  377,  398,  399,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,  280,
  423,  424,  425,  426,  265,  286,  267,  430,  289,  270,
   -1,   -1,   -1,   -1,  275,  296,   -1,   -1,   -1,  280,
  301,  424,  303,  304,  305,   -1,   -1,   -1,  289,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  317,   -1,  319,  320,
  301,   -1,  323,   -1,  305,  326,   -1,  328,   -1,  330,
  331,  332,  333,   -1,  335,   -1,  317,   -1,  319,   -1,
   -1,  342,  323,   -1,  345,  346,   -1,   -1,   -1,   -1,
  331,  332,   -1,   -1,  335,   -1,   -1,  338,   -1,  360,
  361,  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
   -1,  392,   -1,   -1,   -1,   -1,  377,  398,  399,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,
   -1,  280,  423,  424,  425,  426,  265,  286,  267,  430,
  289,  270,   -1,   -1,   -1,   -1,  275,  296,   -1,   -1,
   -1,  280,  301,  424,  303,  304,  305,   -1,   -1,   -1,
  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,  317,   -1,
  319,  320,  301,   -1,  323,   -1,  305,  326,   -1,  328,
   -1,  330,  331,  332,  333,   -1,  335,   -1,  317,   -1,
  319,   -1,   -1,  342,  323,   -1,  345,  346,   -1,   -1,
   -1,   -1,  331,  332,   -1,   -1,  335,   -1,   -1,  338,
   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,  368,
  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,
   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,  377,  398,
  399,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  278,   -1,  280,  423,  424,  425,  426,   -1,  286,
   -1,  430,  289,   -1,   -1,   -1,   -1,   -1,   -1,  296,
   -1,   -1,   -1,   -1,  301,  424,  303,  304,  305,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,
   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,
   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,  346,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,
  367,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,
   -1,   -1,   -1,  390,   -1,  392,   -1,   -1,   -1,   -1,
   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  278,   -1,  280,  423,  424,  425,  426,
   -1,  286,   -1,  430,  289,   -1,   -1,   -1,   -1,   -1,
   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,
  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,   -1,
   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,
  335,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,
  345,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,
   -1,   -1,  367,  368,  369,  261,   -1,   -1,   -1,   -1,
   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,  384,
  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,  285,
   -1,   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  298,   -1,   -1,   -1,   -1,  303,   -1,   -1,
  306,   -1,  308,   -1,  310,  311,  312,  313,  423,  424,
  425,  426,  318,   -1,   -1,  430,  322,   -1,   -1,   -1,
  326,   -1,   -1,  264,  265,   -1,  267,   -1,  334,  270,
  271,  337,   -1,  339,  275,  276,  277,  278,   -1,  280,
   -1,  265,   -1,  267,   -1,  286,  270,   -1,  289,   -1,
   -1,  275,  358,   -1,   -1,  296,  280,  363,   -1,   -1,
  301,   -1,  303,  304,  305,  289,   -1,   -1,  374,  375,
   -1,  377,  296,  379,   -1,   -1,  317,  301,  319,  320,
   -1,  305,  323,   -1,   -1,  326,  392,  328,   -1,  330,
  331,  332,  333,  317,  335,  319,   -1,   -1,   -1,  323,
   -1,  342,   -1,   -1,  345,  346,   -1,  331,  332,   -1,
   -1,  335,   -1,   -1,  338,   -1,   -1,   -1,  424,  360,
  361,  362,  363,  364,   -1,   -1,  367,  368,  369,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
  364,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
   -1,  392,   -1,  377,   -1,   -1,   -1,  398,  399,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  278,   -1,
  280,   -1,  423,  424,  425,  426,  286,   -1,   -1,  289,
   -1,   -1,   -1,   -1,   -1,   -1,  296,   -1,   -1,   -1,
  424,  301,   -1,  303,  304,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,   -1,  319,
  320,   -1,   -1,  323,   -1,   -1,  326,   -1,  328,   -1,
  330,  331,  332,  333,   -1,  335,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,  363,  364,   -1,   -1,  367,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,
  390,   -1,  392,   -1,   -1,   -1,   -1,   -1,  398,  399,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
   -1,   -1,  286,  423,  424,  289,  426,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,   -1,  392,   -1,
   -1,   -1,   -1,   -1,  398,  399,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  278,   -1,  280,   -1,   -1,   -1,   -1,   -1,  286,  423,
  424,  289,  426,   -1,   -1,   -1,   -1,   -1,  296,   -1,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,
   -1,  319,  320,   -1,   -1,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,   -1,  335,   -1,   -1,
  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,
  264,  265,   -1,  267,  392,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1,
   -1,   -1,  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,
   -1,   -1,  296,   -1,   -1,  423,  424,  301,  426,  303,
  304,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  313,
   -1,   -1,   -1,  317,   -1,  319,  320,   -1,   -1,  323,
   -1,   -1,  326,   -1,  328,   -1,  330,  331,  332,  333,
   -1,  335,   -1,   -1,  338,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,  363,
  364,   -1,   -1,  367,  368,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,  377,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  278,   -1,  280,   -1,   -1,   -1,   -1,   -1,
  286,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,   -1,
  296,   -1,   -1,   -1,   -1,  301,   -1,  303,  304,  305,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  423,
  424,  317,   -1,  319,  320,   -1,   -1,  323,   -1,   -1,
  326,   -1,  328,   -1,  330,  331,  332,  333,   -1,  335,
   -1,   -1,  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,   -1,
   -1,  367,  368,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,  377,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  278,   -1,  280,   -1,  265,   -1,  267,   -1,  286,  270,
   -1,  289,   -1,   -1,  275,   -1,   -1,   -1,  296,  280,
   -1,   -1,   -1,  301,   -1,  303,  304,  305,  289,   -1,
   -1,   -1,   -1,   -1,   -1,  296,   -1,  423,  424,  317,
  301,  319,  320,   -1,  305,  323,   -1,   -1,  326,   -1,
  328,   -1,  330,  331,  332,  333,  317,  335,  319,   -1,
  338,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  331,  332,   -1,   -1,  335,   -1,   -1,  338,   -1,   -1,
   -1,   -1,  360,  361,  362,  363,  364,   -1,   -1,  367,
  368,   -1,   -1,   -1,   -1,  265,   -1,  267,   -1,  377,
  270,   -1,   -1,  273,   -1,  275,   -1,   -1,  278,   -1,
  280,   -1,  282,  283,  284,   -1,  377,  378,  288,  289,
   -1,   -1,   -1,   -1,  294,   -1,  296,   -1,   -1,   -1,
   -1,  301,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,  423,  424,  317,   -1,  319,
   -1,   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  331,  332,  424,   -1,  335,   -1,   -1,  338,  265,
   -1,  267,   -1,  343,  270,   -1,   -1,  273,   -1,  275,
   -1,   -1,  278,   -1,  280,   -1,  282,  283,  284,   -1,
   -1,   -1,  288,  289,   -1,   -1,   -1,   -1,  294,   -1,
  296,  265,   -1,  267,   -1,  301,  270,  377,   -1,  305,
   -1,  275,   -1,  383,   -1,   -1,  280,   -1,  314,   -1,
   -1,  317,   -1,  319,   -1,  289,   -1,  323,   -1,   -1,
   -1,  295,  296,   -1,   -1,  331,  332,  301,   -1,  335,
   -1,  305,  338,  307,   -1,  309,   -1,  343,   -1,   -1,
  314,   -1,   -1,  317,  424,  319,   -1,   -1,   -1,  323,
   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332,   -1,
   -1,  335,   -1,   -1,  338,  265,   -1,  267,   -1,   -1,
  270,  377,   -1,   -1,   -1,  275,   -1,   -1,   -1,   -1,
  280,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  289,
   -1,   -1,   -1,   -1,   -1,  295,  296,   -1,   -1,   -1,
   -1,  301,   -1,  377,  378,  305,   -1,  307,   -1,  309,
   -1,   -1,   -1,   -1,  314,   -1,   -1,  317,  424,  319,
   -1,   -1,   -1,  323,   -1,   -1,  326,   -1,   -1,   -1,
   -1,  331,  332,   -1,   -1,  335,   -1,   -1,  338,  265,
   -1,  267,   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,
  424,   -1,   -1,   -1,  280,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  289,   -1,   -1,   -1,   -1,   -1,  295,
  296,   -1,   -1,   -1,   -1,  301,  376,  377,   -1,  305,
   -1,  307,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
   -1,  317,   -1,  319,   -1,   -1,   -1,  323,   -1,   -1,
  326,   -1,   -1,   -1,   -1,  331,  332,   -1,   -1,  335,
   -1,   -1,  338,  265,   -1,  267,   -1,   -1,  270,   -1,
   -1,   -1,   -1,  275,  424,   -1,   -1,   -1,  280,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  289,  364,   -1,
   -1,   -1,   -1,  295,  296,   -1,   -1,   -1,   -1,  301,
   -1,  377,   -1,  305,   -1,  307,   -1,  309,   -1,   -1,
   -1,   -1,  314,   -1,   -1,  317,   -1,  319,   -1,   -1,
   -1,  323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,
  332,   -1,  265,  335,  267,   -1,  338,  270,   -1,   -1,
   -1,   -1,  275,   -1,   -1,   -1,   -1,  280,  424,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  289,   -1,   -1,   -1,
   -1,   -1,  295,  296,   -1,   -1,   -1,   -1,  301,   -1,
   -1,   -1,  305,   -1,  307,  377,  309,   -1,   -1,   -1,
   -1,  314,   -1,   -1,  317,   -1,  319,   -1,   -1,   -1,
  323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332,
   -1,  265,  335,  267,   -1,  338,  270,   -1,  272,   -1,
   -1,  275,   -1,   -1,   -1,   -1,  280,   -1,   -1,   -1,
   -1,   -1,  424,   -1,   -1,  289,   -1,   -1,  261,   -1,
  263,   -1,  296,   -1,   -1,   -1,   -1,  301,   -1,  303,
   -1,  305,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  285,  317,   -1,  319,   -1,   -1,   -1,  323,
  324,   -1,   -1,   -1,   -1,  298,   -1,  331,  332,   -1,
  303,  335,   -1,   -1,  338,  308,   -1,  310,  311,  312,
  313,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,  322,
   -1,  424,   -1,   -1,   -1,  261,   -1,  263,   -1,   -1,
   -1,  334,   -1,   -1,  337,   -1,  339,   -1,   -1,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,   -1,
  363,   -1,  298,   -1,   -1,   -1,   -1,  303,   -1,   -1,
   -1,  374,  308,   -1,  310,  311,  312,  313,   -1,  285,
  316,   -1,  318,   -1,   -1,   -1,  322,  261,   -1,   -1,
  424,   -1,  298,   -1,   -1,   -1,  302,  303,  334,   -1,
   -1,  337,  308,  339,  310,  311,  312,  313,   -1,   -1,
   -1,  285,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  298,   -1,   -1,  363,  334,  303,
   -1,  337,   -1,  339,  308,   -1,  310,  311,  312,  313,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,  322,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,
  334,  358,   -1,  337,   -1,  339,   -1,  364,  365,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,  375,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,   -1,   -1,  363,
  387,   -1,   -1,   -1,   -1,  392,   -1,   -1,   -1,   -1,
   -1,  398,  399,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  418,   -1,   -1,   -1,   -1,   -1,  424,   -1,  426,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  438,
  };

#line 7867 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		expr.Error_InvalidExpressionStatement (report);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments when using language version older than 7.2");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

object Error_AwaitAsIdentifier (object token)
{
	if (async_block) {
		report.Error (4003, GetLocation (token), "`await' cannot be used as an identifier within an async method or lambda expression");
		return new LocatedToken ("await", GetLocation (token));
	}

	return token;
}

void push_current_container (TypeDefinition tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();

		undo.AddTypeContainer (current_container, tc);
	}
	
	if (partial_token != null)
		current_container.AddPartial (tc);
	else
		current_container.AddTypeContainer (tc);
		
	++lexer.parsing_declaration;
	current_container = tc;
	current_type = tc;
}

TypeContainer pop_current_class ()
{
	var retval = current_container;

	current_container = current_container.Parent;
	current_type = current_type.Parent as TypeDefinition;

	return retval;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

[System.Diagnostics.Conditional ("FULL_AST")]
void PushLocation (Location loc)
{
	if (location_stack == null)
		location_stack = new Stack<Location> ();

	location_stack.Push (loc);
}

Location PopLocation ()
{
	if (location_stack == null)
		return Location.Null;

	return location_stack.Pop ();
}

string CheckAttributeTarget (int token, string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	if (!Tokenizer.IsValidIdentifier (a)) {
		Error_SyntaxError (token);
	} else {
		report.Warning (658, 1, l,
			 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	}

	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

static Statement CreateExpressionBodiedStatement (Expression expr)
{
	if (expr is ThrowExpression te)
		return new StatementExpression (te);

	return new ContextualReturn (expr);
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, ParserSession session)
	: this (reader, file, file.Compiler.Report, session)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report, ParserSession session)
{
	this.file = file;
	current_container = current_namespace = file;
	
	this.module = file.Module;
	this.compiler = file.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	yacc_verbose_flag = settings.VerboseParserFlag;
	doc_support = settings.DocumentationFile != null;
	lexer = new Tokenizer (reader, file, session, report);
	oob_stack = new Stack<object> ();
	lbag = session.LocationsBag;
	use_global_stacks = session.UseJayGlobalArrays;
	parameters_bucket = session.ParametersStack;
}

public void parse ()
{
	eof_token = Token.EOF;
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			if (report.Errors == 0)
				report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0 || e is FatalException)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing" + e);
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (loc);
	}

	async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	if (async_block)
		anon_block.IsAsync = true;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariable) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token);
}

void Error_SyntaxError (int error_code, int token)
{
	Error_SyntaxError (error_code, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;
	
	// Avoid duplicit error message after unterminated string literals
	if (token == Token.LITERAL && lexer.Location.Column == 0)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
	case Token.DEFAULT_VALUE:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
	case Token.REF_STRUCT:
	case Token.REF_PARTIAL:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
	case Token.THROW_EXPR:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS_DECONSTRUCT:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
	case Token.WHEN:
		return "when";
	case Token.INTERPOLATED_STRING_END:
		return "}";
	case Token.INTERPOLATED_STRING:
		return "${";

	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
	case Token.INTERR_OPERATOR:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
	case Token.AWAIT:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DEFAULT_VALUE = 277;
  public const int DELEGATE = 278;
  public const int DO = 279;
  public const int DOUBLE = 280;
  public const int ELSE = 281;
  public const int ENUM = 282;
  public const int EVENT = 283;
  public const int EXPLICIT = 284;
  public const int EXTERN = 285;
  public const int FALSE = 286;
  public const int FINALLY = 287;
  public const int FIXED = 288;
  public const int FLOAT = 289;
  public const int FOR = 290;
  public const int FOREACH = 291;
  public const int GOTO = 292;
  public const int IF = 293;
  public const int IMPLICIT = 294;
  public const int IN = 295;
  public const int INT = 296;
  public const int INTERFACE = 297;
  public const int INTERNAL = 298;
  public const int IS = 299;
  public const int LOCK = 300;
  public const int LONG = 301;
  public const int NAMESPACE = 302;
  public const int NEW = 303;
  public const int NULL = 304;
  public const int OBJECT = 305;
  public const int OPERATOR = 306;
  public const int OUT = 307;
  public const int OVERRIDE = 308;
  public const int PARAMS = 309;
  public const int PRIVATE = 310;
  public const int PROTECTED = 311;
  public const int PUBLIC = 312;
  public const int READONLY = 313;
  public const int REF = 314;
  public const int RETURN = 315;
  public const int REMOVE = 316;
  public const int SBYTE = 317;
  public const int SEALED = 318;
  public const int SHORT = 319;
  public const int SIZEOF = 320;
  public const int STACKALLOC = 321;
  public const int STATIC = 322;
  public const int STRING = 323;
  public const int STRUCT = 324;
  public const int SWITCH = 325;
  public const int THIS = 326;
  public const int THROW = 327;
  public const int TRUE = 328;
  public const int TRY = 329;
  public const int TYPEOF = 330;
  public const int UINT = 331;
  public const int ULONG = 332;
  public const int UNCHECKED = 333;
  public const int UNSAFE = 334;
  public const int USHORT = 335;
  public const int USING = 336;
  public const int VIRTUAL = 337;
  public const int VOID = 338;
  public const int VOLATILE = 339;
  public const int WHERE = 340;
  public const int WHILE = 341;
  public const int ARGLIST = 342;
  public const int PARTIAL = 343;
  public const int ARROW = 344;
  public const int FROM = 345;
  public const int FROM_FIRST = 346;
  public const int JOIN = 347;
  public const int ON = 348;
  public const int EQUALS = 349;
  public const int SELECT = 350;
  public const int GROUP = 351;
  public const int BY = 352;
  public const int LET = 353;
  public const int ORDERBY = 354;
  public const int ASCENDING = 355;
  public const int DESCENDING = 356;
  public const int INTO = 357;
  public const int INTERR_NULLABLE = 358;
  public const int EXTERN_ALIAS = 359;
  public const int REFVALUE = 360;
  public const int REFTYPE = 361;
  public const int MAKEREF = 362;
  public const int ASYNC = 363;
  public const int AWAIT = 364;
  public const int INTERR_OPERATOR = 365;
  public const int WHEN = 366;
  public const int INTERPOLATED_STRING = 367;
  public const int INTERPOLATED_STRING_END = 368;
  public const int THROW_EXPR = 369;
  public const int GET = 370;
  public const int SET = 371;
  public const int LAST_KEYWORD = 372;
  public const int OPEN_BRACE = 373;
  public const int CLOSE_BRACE = 374;
  public const int OPEN_BRACKET = 375;
  public const int CLOSE_BRACKET = 376;
  public const int OPEN_PARENS = 377;
  public const int CLOSE_PARENS = 378;
  public const int DOT = 379;
  public const int COMMA = 380;
  public const int COLON = 381;
  public const int SEMICOLON = 382;
  public const int TILDE = 383;
  public const int PLUS = 384;
  public const int MINUS = 385;
  public const int BANG = 386;
  public const int ASSIGN = 387;
  public const int OP_LT = 388;
  public const int OP_GT = 389;
  public const int BITWISE_AND = 390;
  public const int BITWISE_OR = 391;
  public const int STAR = 392;
  public const int PERCENT = 393;
  public const int DIV = 394;
  public const int CARRET = 395;
  public const int INTERR = 396;
  public const int DOUBLE_COLON = 397;
  public const int OP_INC = 398;
  public const int OP_DEC = 399;
  public const int OP_SHIFT_LEFT = 400;
  public const int OP_SHIFT_RIGHT = 401;
  public const int OP_LE = 402;
  public const int OP_GE = 403;
  public const int OP_EQ = 404;
  public const int OP_NE = 405;
  public const int OP_AND = 406;
  public const int OP_OR = 407;
  public const int OP_MULT_ASSIGN = 408;
  public const int OP_DIV_ASSIGN = 409;
  public const int OP_MOD_ASSIGN = 410;
  public const int OP_ADD_ASSIGN = 411;
  public const int OP_SUB_ASSIGN = 412;
  public const int OP_SHIFT_LEFT_ASSIGN = 413;
  public const int OP_SHIFT_RIGHT_ASSIGN = 414;
  public const int OP_AND_ASSIGN = 415;
  public const int OP_XOR_ASSIGN = 416;
  public const int OP_OR_ASSIGN = 417;
  public const int OP_PTR = 418;
  public const int OP_COALESCING = 419;
  public const int OP_GENERICS_LT = 420;
  public const int OP_GENERICS_LT_DECL = 421;
  public const int OP_GENERICS_GT = 422;
  public const int LITERAL = 423;
  public const int IDENTIFIER = 424;
  public const int OPEN_PARENS_LAMBDA = 425;
  public const int OPEN_PARENS_CAST = 426;
  public const int GENERIC_DIMENSION = 427;
  public const int DEFAULT_COLON = 428;
  public const int OPEN_BRACKET_EXPR = 429;
  public const int OPEN_PARENS_DECONSTRUCT = 430;
  public const int REF_STRUCT = 431;
  public const int REF_PARTIAL = 432;
  public const int EVAL_STATEMENT_PARSER = 433;
  public const int EVAL_COMPILATION_UNIT_PARSER = 434;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 435;
  public const int DOC_SEE = 436;
  public const int GENERATE_COMPLETION = 437;
  public const int COMPLETE_COMPLETION = 438;
  public const int UMINUS = 439;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
