/* Generated by wayland-scanner 1.24.0 */

#ifndef FIFO_V1_SERVER_PROTOCOL_H
#define FIFO_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_fifo_v1 The fifo_v1 protocol
 * @section page_ifaces_fifo_v1 Interfaces
 * - @subpage page_iface_wp_fifo_manager_v1 - protocol for fifo constraints
 * - @subpage page_iface_wp_fifo_v1 - fifo interface
 * @section page_copyright_fifo_v1 Copyright
 * <pre>
 *
 * Copyright © 2023 Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wp_fifo_manager_v1;
struct wp_fifo_v1;

#ifndef WP_FIFO_MANAGER_V1_INTERFACE
#define WP_FIFO_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_fifo_manager_v1 wp_fifo_manager_v1
 * @section page_iface_wp_fifo_manager_v1_desc Description
 *
 * When a Wayland compositor considers applying a content update,
 * it must ensure all the update's readiness constraints (fences, etc)
 * are met.
 *
 * This protocol provides a way to use the completion of a display refresh
 * cycle as an additional readiness constraint.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_fifo_manager_v1_api API
 * See @ref iface_wp_fifo_manager_v1.
 */
/**
 * @defgroup iface_wp_fifo_manager_v1 The wp_fifo_manager_v1 interface
 *
 * When a Wayland compositor considers applying a content update,
 * it must ensure all the update's readiness constraints (fences, etc)
 * are met.
 *
 * This protocol provides a way to use the completion of a display refresh
 * cycle as an additional readiness constraint.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_fifo_manager_v1_interface;
#endif
#ifndef WP_FIFO_V1_INTERFACE
#define WP_FIFO_V1_INTERFACE
/**
 * @page page_iface_wp_fifo_v1 wp_fifo_v1
 * @section page_iface_wp_fifo_v1_desc Description
 *
 * A fifo object for a surface that may be used to add
 * display refresh constraints to content updates.
 * @section page_iface_wp_fifo_v1_api API
 * See @ref iface_wp_fifo_v1.
 */
/**
 * @defgroup iface_wp_fifo_v1 The wp_fifo_v1 interface
 *
 * A fifo object for a surface that may be used to add
 * display refresh constraints to content updates.
 */
extern const struct wl_interface wp_fifo_v1_interface;
#endif

#ifndef WP_FIFO_MANAGER_V1_ERROR_ENUM
#define WP_FIFO_MANAGER_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_fifo_manager_v1
 * fatal presentation error
 *
 * These fatal protocol errors may be emitted in response to
 * illegal requests.
 */
enum wp_fifo_manager_v1_error {
	/**
	 * fifo manager already exists for surface
	 */
	WP_FIFO_MANAGER_V1_ERROR_ALREADY_EXISTS = 0,
};
#endif /* WP_FIFO_MANAGER_V1_ERROR_ENUM */

#ifndef WP_FIFO_MANAGER_V1_ERROR_ENUM_IS_VALID
#define WP_FIFO_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_wp_fifo_manager_v1
 * Validate a wp_fifo_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_fifo_manager_v1_error
 */
static inline bool
wp_fifo_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_FIFO_MANAGER_V1_ERROR_ALREADY_EXISTS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_FIFO_MANAGER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_wp_fifo_manager_v1
 * @struct wp_fifo_manager_v1_interface
 */
struct wp_fifo_manager_v1_interface {
	/**
	 * unbind from the manager interface
	 *
	 * Informs the server that the client will no longer be using
	 * this protocol object. Existing objects created by this object
	 * are not affected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * request fifo interface for surface
	 *
	 * Establish a fifo object for a surface that may be used to add
	 * display refresh constraints to content updates.
	 *
	 * Only one such object may exist for a surface and attempting to
	 * create more than one will result in an already_exists protocol
	 * error. If a surface is acted on by multiple software components,
	 * general best practice is that only the component performing
	 * wl_surface.attach operations should use this protocol.
	 */
	void (*get_fifo)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t id,
			 struct wl_resource *surface);
};


/**
 * @ingroup iface_wp_fifo_manager_v1
 */
#define WP_FIFO_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_fifo_manager_v1
 */
#define WP_FIFO_MANAGER_V1_GET_FIFO_SINCE_VERSION 1

#ifndef WP_FIFO_V1_ERROR_ENUM
#define WP_FIFO_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_fifo_v1
 * fatal error
 *
 * These fatal protocol errors may be emitted in response to
 * illegal requests.
 */
enum wp_fifo_v1_error {
	/**
	 * the associated surface no longer exists
	 */
	WP_FIFO_V1_ERROR_SURFACE_DESTROYED = 0,
};
#endif /* WP_FIFO_V1_ERROR_ENUM */

#ifndef WP_FIFO_V1_ERROR_ENUM_IS_VALID
#define WP_FIFO_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_wp_fifo_v1
 * Validate a wp_fifo_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_fifo_v1_error
 */
static inline bool
wp_fifo_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_FIFO_V1_ERROR_SURFACE_DESTROYED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_FIFO_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_wp_fifo_v1
 * @struct wp_fifo_v1_interface
 */
struct wp_fifo_v1_interface {
	/**
	 * sets the start point for a fifo constraint
	 *
	 * When the content update containing the "set_barrier" is
	 * applied, it sets a "fifo_barrier" condition on the surface
	 * associated with the fifo object. The condition is cleared
	 * immediately after the following latching deadline for
	 * non-tearing presentation.
	 *
	 * The compositor may clear the condition early if it must do so to
	 * ensure client forward progress assumptions.
	 *
	 * To wait for this condition to clear, use the "wait_barrier"
	 * request.
	 *
	 * "set_barrier" is double-buffered state, see wl_surface.commit.
	 *
	 * Requesting set_barrier after the fifo object's surface is
	 * destroyed will generate a "surface_destroyed" error.
	 */
	void (*set_barrier)(struct wl_client *client,
			    struct wl_resource *resource);
	/**
	 * adds a fifo constraint to a content update
	 *
	 * Indicate that this content update is not ready while a
	 * "fifo_barrier" condition is present on the surface.
	 *
	 * This means that when the content update containing "set_barrier"
	 * was made active at a latching deadline, it will be active for at
	 * least one refresh cycle. A content update which is allowed to
	 * tear might become active after a latching deadline if no content
	 * update became active at the deadline.
	 *
	 * The constraint must be ignored if the surface is a subsurface in
	 * synchronized mode. If the surface is not being updated by the
	 * compositor (off-screen, occluded) the compositor may ignore the
	 * constraint. Clients must use an additional mechanism such as
	 * frame callbacks or timestamps to ensure throttling occurs under
	 * all conditions.
	 *
	 * "wait_barrier" is double-buffered state, see wl_surface.commit.
	 *
	 * Requesting "wait_barrier" after the fifo object's surface is
	 * destroyed will generate a "surface_destroyed" error.
	 */
	void (*wait_barrier)(struct wl_client *client,
			     struct wl_resource *resource);
	/**
	 * destroy the fifo interface
	 *
	 * Informs the server that the client will no longer be using
	 * this protocol object.
	 *
	 * Surface state changes previously made by this protocol are
	 * unaffected by this object's destruction.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_wp_fifo_v1
 */
#define WP_FIFO_V1_SET_BARRIER_SINCE_VERSION 1
/**
 * @ingroup iface_wp_fifo_v1
 */
#define WP_FIFO_V1_WAIT_BARRIER_SINCE_VERSION 1
/**
 * @ingroup iface_wp_fifo_v1
 */
#define WP_FIFO_V1_DESTROY_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
